/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import enums.MotionRestriction;
import enums.SchoolType;
import helpers.TimeConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import roadnetwork.Edge;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class School
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Edge closestEdge = null;
    private Point2DExt location;
    private SchoolType schoolType;
    private Rectangle2DExt shape;
    private int timeClosing;
    private int timeOpening;
    private int capacity;
    private int availableCapacity;

    public School(Point2D.Double location) {
        this.name = "School " + String.valueOf(increment++);
        this.shape = new Rectangle2DExt();
        this.shape.setFrameFromCenter(location.x, location.y, location.x + 15.0, location.y + 15.0);
        this.location = new Point2DExt(location);
        ArrayList<Handle> handles = new ArrayList<Handle>();
        handles.add(new Handle(location, "location", MotionRestriction.None));
        this.addHandles(handles);
        this.timeOpening = TimeConverter.toSeconds(7, 30);
        this.timeClosing = TimeConverter.toSeconds(13, 30);
        this.schoolType = SchoolType.Kindergarden;
        this.capacity = 800;
        this.exportPolygon = true;
    }

    public School(School source) {
        super(source);
        this.closestEdge = source.closestEdge;
        this.location = new Point2DExt(source.location);
        this.shape = new Rectangle2DExt(source.shape);
        this.schoolType = source.schoolType;
        this.capacity = source.capacity;
        this.timeClosing = source.timeClosing;
        this.timeOpening = source.timeOpening;
    }

    @Override
    public void Draw(Graphics2D g, double zoomFactor, boolean isDeleted, boolean isSelected) {
        Color prev = g.getColor();
        if (!isSelected) {
            g.setColor(Color.ORANGE);
        }
        if (isSelected) {
            g.setColor(Color.GREEN);
        }
        if (this.shape != null) {
            g.fill(this.shape);
        }
        super.Draw(g, zoomFactor, isDeleted, isSelected);
        g.setColor(prev);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return this.shape;
    }

    public Edge getClosestEdge() {
        return this.closestEdge;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public int amountOfTimeChildCanWaitAfterSchool() {
        int result = 0;
        switch (this.schoolType) {
            case Kindergarden: {
                result = 0;
                break;
            }
            case Elementary: {
                result = 600;
                break;
            }
            case Middle: {
                result = 1200;
                break;
            }
            case High: {
                result = 1800;
            }
        }
        return result;
    }

    public int getPriority() {
        int result = 0;
        switch (this.schoolType) {
            case Kindergarden: {
                result = 4;
                break;
            }
            case Elementary: {
                result = 3;
                break;
            }
            case Middle: {
                result = 2;
                break;
            }
            case High: {
                result = 1;
            }
        }
        return result;
    }

    public SchoolType getSchoolType() {
        return this.schoolType;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getAvailableCapacity() {
        return this.availableCapacity;
    }

    public void setAvailableCapacity(int availableCapacity) {
        this.availableCapacity = availableCapacity;
    }

    public int getTimeClosing() {
        return this.timeClosing;
    }

    public int getTimeOpening() {
        return this.timeOpening;
    }

    @Override
    public String getToolTip() {
        return "<html><b>School</b> " + this.name + "<br>" + "<b>Type:</b> " + this.schoolType.name() + "<br>" + "<b>Time opening:</b> " + TimeConverter.toString(this.timeOpening) + "<br>" + "<b>Time closing:</b> " + TimeConverter.toString(this.timeClosing) + "<br>" + "<b>Capacity:</b> " + String.valueOf(this.capacity) + "</html>";
    }

    @Override
    public void handleLocationChanged(Handle h) {
        if (h.getName().equals("location")) {
            this.location = new Point2DExt(h.getLocation());
            this.shape.setFrameFromCenter(this.location.x, this.location.y, this.location.x + 15.0, this.location.y + 15.0);
        }
    }

    @Override
    public boolean Hit(Point p) {
        return this.shape.getBounds2D().contains(p.x, p.y) && this.shape.contains(p.x, p.y);
    }

    @Override
    public boolean Hit(Rectangle transformedRectangle) {
        return this.shape.intersects(transformedRectangle);
    }

    public void setClosestEdge(Edge closestEdge) {
        this.closestEdge = closestEdge;
    }

    public void setSchoolType(SchoolType schoolType) {
        this.schoolType = schoolType;
    }

    public void setTimeClosing(int timeClosing) {
        this.timeClosing = timeClosing;
    }

    public void setTimeOpening(int timeOpening) {
        this.timeOpening = timeOpening;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new School(this);
    }

    @Override
    public String getGeometryXML() {
        StringBuilder polyBuilder = new StringBuilder();
        polyBuilder.append("<poly id=\"" + this.schoolType.name() + " School " + this.name + "\" type=\"School\" color=\"1,0,0\" fill=\"true\" layer=\"-1\">");
        polyBuilder.append(String.valueOf(String.valueOf(this.shape.getMinX())) + "," + String.valueOf(this.shape.getMinY()));
        polyBuilder.append(" " + String.valueOf(this.shape.getMinX()) + "," + String.valueOf(this.shape.getMaxY()));
        polyBuilder.append(" " + String.valueOf(this.shape.getMaxX()) + "," + String.valueOf(this.shape.getMaxY()));
        polyBuilder.append(" " + String.valueOf(this.shape.getMaxX()) + "," + String.valueOf(this.shape.getMinY()));
        polyBuilder.append("</poly>\n");
        return polyBuilder.toString();
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<school name=\"" + this.name + "\" openingTime=\"" + String.valueOf(this.timeOpening) + "\" closingTime=\"" + String.valueOf(this.timeClosing) + "\" level=\"" + this.schoolType.name() + "\" capacity=\"" + String.valueOf(this.capacity) + "\" location=\"" + String.valueOf(this.location.x) + "," + String.valueOf(this.location.y) + "\" />\n");
        return sb.toString();
    }

    public static class SchoolPriorityComparator
    implements Comparator<School> {
        @Override
        public int compare(School school1, School school2) {
            return school1.getPriority() - school2.getPriority();
        }
    }
}

