/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import classes.Project;
import classes.TypeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simulation.VehicleType;
import trafficdefinition.AreaFlow;
import ui.controls.SimTimeEdit;
import ui.dialogs.DlgSelectTypes;

public class PnlAreaFlowProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnChangeColor = null;
    private JButton btnSelectVehicleTypes = null;
    private AreaFlow currentAreaFlow = null;
    private JLabel lblBeginTimeTitle = null;
    private JLabel lblColor = null;
    private JLabel lblEndTimeTitle = null;
    private JLabel lblNameTitle = null;
    private JLabel lblNumberOfVehiclesTitle = null;
    private JSpinner spnNumberOfVehicles = null;
    private SimTimeEdit steBeginTime = null;
    private SimTimeEdit steEndTime = null;
    private JTextField txtName = null;
    private JCheckBox chkExportPolygon = null;
    private JCheckBox chkEnabled = null;

    public PnlAreaFlowProperties() {
        this.initialize();
    }

    public void setAreaFlow(AreaFlow flow) {
        this.currentAreaFlow = flow;
        this.txtName.setText(this.currentAreaFlow.getName());
        this.steBeginTime.setValue(this.currentAreaFlow.getBeginTime());
        this.steEndTime.setValue(this.currentAreaFlow.getEndTime());
        this.spnNumberOfVehicles.setValue(this.currentAreaFlow.getNumberOfVehicles());
        this.btnChangeColor.setBackground(this.currentAreaFlow.getColor());
        this.chkExportPolygon.setSelected(this.currentAreaFlow.getExportPolygon());
        this.chkEnabled.setSelected(this.currentAreaFlow.isEnabled());
    }

    private JButton getBtnChangeColor() {
        if (this.btnChangeColor == null) {
            this.btnChangeColor = new JButton();
            this.btnChangeColor.setPreferredSize(new Dimension(86, 20));
            this.btnChangeColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAreaFlowProperties.this.ChangeColor();
                }
            });
        }
        return this.btnChangeColor;
    }

    private JButton getBtnSelectVehicleTypes() {
        if (this.btnSelectVehicleTypes == null) {
            this.btnSelectVehicleTypes = new JButton();
            this.btnSelectVehicleTypes.setText("Vehicle types...");
            this.btnSelectVehicleTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/vehicletypes.png")));
            this.btnSelectVehicleTypes.setPreferredSize(new Dimension(150, 20));
            this.btnSelectVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlAreaFlowProperties.this.SelectVehicleTypes();
                }
            });
        }
        return this.btnSelectVehicleTypes;
    }

    private JSpinner getSpnNumberOfVehicles() {
        if (this.spnNumberOfVehicles == null) {
            this.spnNumberOfVehicles = new JSpinner();
            this.spnNumberOfVehicles.setModel(new SpinnerNumberModel(1, 1, 1000000, 1));
            this.spnNumberOfVehicles.setPreferredSize(new Dimension(70, 20));
            this.spnNumberOfVehicles.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setNumberOfVehicles((Integer)PnlAreaFlowProperties.this.spnNumberOfVehicles.getValue());
                }
            });
        }
        return this.spnNumberOfVehicles;
    }

    private SimTimeEdit getSteBeginTime() {
        if (this.steBeginTime == null) {
            this.steBeginTime = new SimTimeEdit();
            this.steBeginTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setBeginTime(PnlAreaFlowProperties.this.steBeginTime.getValue());
                }
            });
        }
        return this.steBeginTime;
    }

    private SimTimeEdit getSteEndTime() {
        if (this.steEndTime == null) {
            this.steEndTime = new SimTimeEdit();
            this.steEndTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setEndTime(PnlAreaFlowProperties.this.steEndTime.getValue());
                }
            });
        }
        return this.steEndTime;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setName(PnlAreaFlowProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridy = 6;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.gridy = 5;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints4.gridy = 2;
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.gridx = 1;
        gridBagConstraints32.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints32.gridy = 1;
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.anchor = 17;
        gridBagConstraints14.gridy = 3;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.insets = new Insets(15, 2, 2, 2);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.anchor = 11;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridy = 7;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints2.gridy = 4;
        this.lblColor = new JLabel();
        this.lblColor.setText("Color:");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 1;
        gridBagConstraints13.fill = 1;
        gridBagConstraints13.insets = new Insets(2, 0, 2, 10);
        gridBagConstraints13.gridy = 4;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints12.gridy = 3;
        this.lblNumberOfVehiclesTitle = new JLabel();
        this.lblNumberOfVehiclesTitle.setText("Number of vehicles:");
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.anchor = 18;
        gridBagConstraints31.insets = new Insets(3, 10, 0, 0);
        gridBagConstraints31.gridy = 2;
        this.lblEndTimeTitle = new JLabel();
        this.lblEndTimeTitle.setText("End time:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.insets = new Insets(3, 10, 0, 0);
        gridBagConstraints11.gridy = 1;
        this.lblBeginTimeTitle = new JLabel();
        this.lblBeginTimeTitle.setText("Begin time:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(300, 254);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints);
        this.add((Component)this.getTxtName(), gridBagConstraints1);
        this.add((Component)this.lblBeginTimeTitle, gridBagConstraints11);
        this.add((Component)this.lblEndTimeTitle, gridBagConstraints31);
        this.add((Component)this.lblNumberOfVehiclesTitle, gridBagConstraints12);
        this.add((Component)this.getBtnChangeColor(), gridBagConstraints13);
        this.add((Component)this.lblColor, gridBagConstraints2);
        this.add((Component)this.getBtnSelectVehicleTypes(), gridBagConstraints3);
        this.add((Component)this.getSpnNumberOfVehicles(), gridBagConstraints14);
        this.add((Component)this.getSteBeginTime(), gridBagConstraints32);
        this.add((Component)this.getSteEndTime(), gridBagConstraints4);
        this.add((Component)this.getChkExportPolygon(), gridBagConstraints21);
        this.add((Component)this.getChkEnabled(), gridBagConstraints5);
    }

    protected void ChangeColor() {
        Color newColor = JColorChooser.showDialog(this, "Select flow color", this.currentAreaFlow.getColor());
        if (newColor != null) {
            this.currentAreaFlow.setColor(newColor);
            this.btnChangeColor.setBackground(newColor);
        }
    }

    protected void SelectVehicleTypes() {
        TypeSelection<VehicleType> projectVehicleTypes = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getVehicleTypes());
        TypeSelection<VehicleType> areaFlowVehicleTypes = new TypeSelection<VehicleType>(this.currentAreaFlow.getVehicleSelection());
        areaFlowVehicleTypes.addTypesNotInSelection(projectVehicleTypes);
        DlgSelectTypes<VehicleType> dlg = new DlgSelectTypes<VehicleType>(areaFlowVehicleTypes);
        dlg.setVisible(true);
        if (dlg.getAnswer() == 0) {
            areaFlowVehicleTypes.removeTypesWithZeroPercentage();
            this.currentAreaFlow.setVehicleSelection(areaFlowVehicleTypes);
        }
    }

    private JCheckBox getChkExportPolygon() {
        if (this.chkExportPolygon == null) {
            this.chkExportPolygon = new JCheckBox();
            this.chkExportPolygon.setText("Export polygon");
            this.chkExportPolygon.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setExportPolygon(PnlAreaFlowProperties.this.chkExportPolygon.isSelected());
                }
            });
        }
        return this.chkExportPolygon;
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setEnabled(PnlAreaFlowProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }
}

