/*
 * Decompiled with CFR 0.152.
 */
package bioroute.analysis;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.io.tabularFileParser.TabularFileHandler;
import cadyts.utilities.io.tabularFileParser.TabularFileParser;
import cadyts.utilities.math.BasicStatistics;
import cadyts.utilities.math.Histogram;
import cadyts.utilities.math.networks.LinkCost;
import cadyts.utilities.math.networks.Router;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

public class CostHistogramAnalyzer
implements TabularFileHandler {
    private final Network network;
    private final int burnIn;
    private final int sampleInterval;
    private final LinkCost linkCost;
    private final int bins;
    private BasicStatistics stats;
    private Histogram hist;
    private long cnt = 0L;

    public CostHistogramAnalyzer(Network network, int burnIn, int sampleInterval, LinkCost linkCost, int bins) {
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        if (burnIn < 0) {
            throw new IllegalArgumentException("burn in < 0");
        }
        if (sampleInterval < 1) {
            throw new IllegalArgumentException("sample interval < 1");
        }
        if (linkCost == null) {
            throw new IllegalArgumentException("link cost is null");
        }
        if (bins < 1) {
            throw new IllegalArgumentException("bins < 1");
        }
        this.network = network;
        this.burnIn = burnIn;
        this.sampleInterval = sampleInterval;
        this.linkCost = linkCost;
        this.bins = bins;
    }

    public void run(String fromFile, String toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException("from file is null");
        }
        if (toFile == null) {
            throw new IllegalArgumentException("to file is null");
        }
        this.stats = new BasicStatistics();
        this.hist = null;
        TabularFileParser parser = new TabularFileParser();
        parser.setDelimiterRegex("\\s");
        parser.parse(fromFile, this);
        double delta = (this.stats.getMax() - this.stats.getMin()) / (double)this.bins;
        double[] boundaries = new double[this.bins + 1];
        int bin = 0;
        while (bin <= this.bins) {
            boundaries[bin] = (double)bin * delta;
            ++bin;
        }
        this.hist = new Histogram(boundaries);
        parser.parse(fromFile, this);
        PrintWriter writer = new PrintWriter(toFile);
        int bin2 = 1;
        while (bin2 < this.hist.binCnt()) {
            writer.print(this.hist.lowerBound(bin2));
            writer.print(" ");
            writer.println(this.hist.freq(bin2));
            ++bin2;
        }
        writer.flush();
        writer.close();
    }

    @Override
    public void startDocument() {
        this.cnt = 0L;
    }

    @Override
    public String preprocess(String line) {
        int semicolonIndex = line.indexOf(";");
        return line.substring(0, semicolonIndex);
    }

    @Override
    public void startRow(String[] row) {
        ++this.cnt;
        if (this.cnt <= (long)this.burnIn || this.cnt % (long)this.sampleInterval != 0L) {
            return;
        }
        LinkedList<Node> route = new LinkedList<Node>();
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            route.add(this.network.getNode(element));
            ++n2;
        }
        double cost = 0.0;
        for (Link link : Router.toLinkRoute(route)) {
            cost += this.linkCost.getCost(link);
        }
        if (this.hist == null) {
            this.stats.add(cost);
        } else {
            this.hist.add(cost - this.stats.getMin());
        }
    }

    @Override
    public void endDocument() {
    }
}

