/*
 * Decompiled with CFR 0.152.
 */
package bioroute.pathgenerator.metropolishastings;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.math.networks.Router;
import cadyts.utilities.math.networks.UpdateRouter;
import cadyts.utilities.misc.Triple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MHPath {
    private final Network network;
    private final UpdateRouter router;
    private final double scale;
    private final LinkedList<Node> nodes;
    private Triple<Integer, Integer, Integer> points;
    private List<Link> links = null;
    private Double cost = null;
    private Boolean spliceable = null;
    private Map<Node, Double> modifiedFwdCost = null;
    private Map<Node, Double> modifiedBwdCost = null;

    public List<Link> getLinks() {
        if (this.links == null) {
            this.links = Router.toLinkRoute(this.nodes);
        }
        return this.links;
    }

    double getCost() {
        if (this.cost == null) {
            this.cost = this.router.cost(this.getLinks());
        }
        return this.cost;
    }

    boolean isSpliceable() {
        if (this.spliceable == null) {
            LinkedList<Node> pathAB = this.fwdRoute(this.getNodeA(), this.getNodeB());
            if (!this.router.equals(this.nodes, this.points.getA(), this.points.getB(), pathAB, 0, pathAB.size() - 1)) {
                this.spliceable = false;
            } else {
                LinkedList<Node> pathBC = this.bwdRoute(this.getNodeB(), this.getNodeC());
                this.spliceable = this.router.equals(this.nodes, this.points.getB(), this.points.getC(), pathBC, 0, pathBC.size() - 1);
            }
        }
        return this.spliceable;
    }

    private Map<Node, Double> modifiedFwdCost() {
        if (this.modifiedFwdCost == null) {
            HashSet<Node> excludedNodes = new HashSet<Node>(this.nodes.subList(0, this.getPoints().getA()));
            excludedNodes.addAll(this.nodes.subList(this.getPoints().getC(), this.size()));
            this.modifiedFwdCost = this.router.fwdCostWithoutExcludedNodes(this.getNodeA(), this.network.getNodes(), excludedNodes, null);
        }
        return this.modifiedFwdCost;
    }

    private Map<Node, Double> modifiedBwdCost() {
        if (this.modifiedBwdCost == null) {
            HashSet<Node> excludedNodes = new HashSet<Node>(this.nodes.subList(0, this.getPoints().getA() + 1));
            excludedNodes.addAll(this.nodes.subList(this.getPoints().getC() + 1, this.size()));
            this.modifiedBwdCost = this.router.bwdCostWithoutExcludedNodes(this.getNodeC(), this.network.getNodes(), excludedNodes, null);
        }
        return this.modifiedBwdCost;
    }

    MHPath(LinkedList<Node> nodes, Triple<Integer, Integer, Integer> points, Network network, UpdateRouter router, double scale) {
        this.nodes = new LinkedList<Node>(nodes);
        this.points = points;
        this.network = network;
        this.router = router;
        this.scale = scale;
        this.links = null;
        this.cost = null;
        this.spliceable = null;
        this.modifiedFwdCost = null;
        this.modifiedBwdCost = null;
    }

    MHPath(MHPath parent) {
        this(parent.nodes, parent.points, parent.network, parent.router, parent.scale);
        this.links = parent.links == null ? null : new LinkedList<Link>(parent.links);
        this.cost = parent.cost;
        this.spliceable = parent.spliceable;
        this.modifiedFwdCost = parent.modifiedFwdCost == null ? null : new HashMap<Node, Double>(parent.modifiedFwdCost);
        this.modifiedBwdCost = parent.modifiedBwdCost == null ? null : new HashMap<Node, Double>(parent.modifiedBwdCost);
    }

    private LinkedList<Node> fwdRoute(Node origin, Node destination) {
        return this.router.bestRouteFwd(origin, destination, this.modifiedFwdCost());
    }

    private LinkedList<Node> bwdRoute(Node origin, Node destination) {
        return this.router.bestRouteBwd(origin, destination, this.modifiedBwdCost());
    }

    double getScale() {
        return this.scale;
    }

    int size() {
        return this.nodes.size();
    }

    long pointCombinationSize() {
        return 1L * (long)this.size() * (long)(this.size() - 1) * (long)(this.size() - 2) / 6L;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    Node getNode(int index) {
        return this.nodes.get(index);
    }

    Node getNodeA() {
        return this.getNode(this.getPoints().getA());
    }

    Node getNodeB() {
        return this.getNode(this.getPoints().getB());
    }

    Node getNodeC() {
        return this.getNode(this.getPoints().getC());
    }

    public Triple<Integer, Integer, Integer> getPoints() {
        return this.points;
    }

    boolean hasCycle() {
        return new HashSet<Node>(this.nodes).size() < this.nodes.size();
    }

    Map<Node, Double> getInsertProbs() {
        double detourScale = this.getScale();
        Map<Node, Double> fwdCost = this.modifiedFwdCost();
        Map<Node, Double> bwdCost = this.modifiedBwdCost();
        LinkedHashSet<Node> candidateNodes = new LinkedHashSet<Node>();
        for (Node node : fwdCost.keySet()) {
            if (!bwdCost.keySet().contains(node) || fwdCost.get(node).isInfinite() || bwdCost.get(node).isInfinite()) continue;
            candidateNodes.add(node);
        }
        int i = 0;
        while (i <= this.getPoints().getA()) {
            candidateNodes.remove(this.getNode(i));
            ++i;
        }
        i = this.getPoints().getC();
        while (i < this.size()) {
            candidateNodes.remove(this.getNode(i));
            ++i;
        }
        HashMap<Node, Double> insertProbs = new HashMap<Node, Double>();
        if (candidateNodes.isEmpty()) {
            return insertProbs;
        }
        double minCost = Double.POSITIVE_INFINITY;
        for (Node node : candidateNodes) {
            double cost = fwdCost.get(node) + bwdCost.get(node);
            insertProbs.put(node, cost);
            minCost = Math.min(cost, minCost);
        }
        double expSum = 0.0;
        for (Node node : candidateNodes) {
            double val = Math.exp(-detourScale * ((Double)insertProbs.get(node) - minCost));
            insertProbs.put(node, val);
            expSum += val;
        }
        for (Node node : candidateNodes) {
            insertProbs.put(node, (Double)insertProbs.get(node) / expSum);
        }
        return insertProbs;
    }

    void setPoints(Triple<Integer, Integer, Integer> points) {
        if (!this.points.equals(points)) {
            if (!this.points.getA().equals(points.getA()) || !this.points.getC().equals(points.getC())) {
                this.modifiedFwdCost = null;
                this.modifiedBwdCost = null;
            }
            this.points = points;
            this.spliceable = null;
        }
    }

    void insertDetour(Node nodeB) {
        LinkedList<Node> pathAB = this.fwdRoute(this.getNodeA(), nodeB);
        LinkedList<Node> pathBC = this.bwdRoute(nodeB, this.getNodeC());
        LinkedList newNodes = new LinkedList();
        newNodes.addAll(this.nodes.subList(0, this.points.getA()));
        newNodes.addAll(pathAB);
        newNodes.addAll(pathBC.subList(1, pathBC.size() - 1));
        newNodes.addAll(this.nodes.subList(this.points.getC(), this.nodes.size()));
        int newB = this.points.getA() + (pathAB.size() - 1);
        int newC = newB + (pathBC.size() - 1);
        Triple<Integer, Integer, Integer> newPoints = new Triple<Integer, Integer, Integer>(this.points.getA(), newB, newC);
        this.links = null;
        this.cost = null;
        this.spliceable = true;
        this.nodes.clear();
        this.nodes.addAll(newNodes);
        this.points = newPoints;
    }
}

