/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.calibrators.filebased.xml.PopulationHandler;
import cadyts.demand.PlanBuilder;
import cadyts.interfaces.sumo.SumoAgent;
import cadyts.interfaces.sumo.SumoPlan;
import cadyts.utilities.misc.DynamicData;
import cadyts.utilities.misc.Tuple;
import cadyts.utilities.misc.XMLHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

class SumoPopulationHandler
extends PopulationHandler<SumoAgent> {
    static final String VEHICLE_ELEM = "vehicle";
    static final String VEHICLEID_ATTR = "id";
    static final String DEPART_ATTR = "depart";
    static final String FROMTAZ_ATTR = "fromtaz";
    static final String TOTAZ_ATTR = "totaz";
    static final String ROUTE_ELEM = "route";
    static final String EDGES_ATTR = "edges";
    static final String EXITTIMES_ATTR = "exitTimes";
    static final String CHOICEPROB_ATTR = "probability";
    private final DynamicData<String> travelTimes;
    private final PlanBuilder<String> planBuilder;
    private final double demandScale;
    private final double stayAtHomeProb;
    private Set<Object> clonedAgentIDs = null;
    private String clonePostfix = null;
    private SumoAgent tempAgent = null;

    SumoPopulationHandler(PlanBuilder<String> planBuilder, DynamicData<String> travelTimes, double demandScale) {
        if (planBuilder == null) {
            throw new IllegalArgumentException("planBuilder is null");
        }
        this.planBuilder = planBuilder;
        this.travelTimes = travelTimes;
        Logger.getLogger(this.getClass().getName()).fine("travelTimes is " + (this.travelTimes == null ? "" : "not ") + "null");
        if (demandScale < 1.0 || demandScale > 2.0) {
            throw new IllegalArgumentException("demandScale of " + demandScale + " is not in [1,2]");
        }
        this.demandScale = demandScale;
        this.stayAtHomeProb = (demandScale - 1.0) / demandScale;
    }

    void setClonedAgentIDs(Set<Object> clonedAgentIDs, String clonePostfix) {
        if (clonePostfix == null && clonedAgentIDs != null) {
            throw new IllegalArgumentException("clonePostfix is null");
        }
        this.clonePostfix = clonePostfix;
        this.clonedAgentIDs = clonedAgentIDs;
    }

    private List<Tuple<String, String>> extractMiscAttrs(Attributes allAttrs) {
        ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>();
        int i = 0;
        while (i < allAttrs.getLength()) {
            String name = allAttrs.getQName(i);
            if (!(VEHICLEID_ATTR.equals(name) || DEPART_ATTR.equals(name) || FROMTAZ_ATTR.equals(name) || TOTAZ_ATTR.equals(name))) {
                String value = allAttrs.getValue(i);
                result.add(new Tuple<String, String>(name, value));
            }
            ++i;
        }
        return result;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (VEHICLE_ELEM.equals(qName)) {
            String agentId = attrs.getValue(VEHICLEID_ATTR);
            int dpt_s = XMLHelpers.DOUBLE2INT_EXTRACTOR.extract(attrs.getValue(DEPART_ATTR));
            String fromTAZ = attrs.getValue(FROMTAZ_ATTR);
            String toTAZ = attrs.getValue(TOTAZ_ATTR);
            List<Tuple<String, String>> miscAttrs = this.extractMiscAttrs(attrs);
            this.tempAgent = new SumoAgent(agentId, dpt_s, fromTAZ, toTAZ, miscAttrs);
            if (this.stayAtHomeProb > 0.0) {
                SumoPlan stayAtHomePlan = new SumoPlan(this.tempAgent.getPlans().size(), dpt_s, new ArrayList<String>(0), new ArrayList<Integer>(0), this.travelTimes, this.planBuilder);
                this.tempAgent.addPlan(stayAtHomePlan, this.stayAtHomeProb);
            }
        } else if (ROUTE_ELEM.equals(qName)) {
            List<String> edges = XMLHelpers.extractItems(attrs.getValue(EDGES_ATTR));
            List<Integer> exits = XMLHelpers.extractItems(attrs.getValue(EXITTIMES_ATTR), XMLHelpers.DOUBLE2INT_EXTRACTOR);
            if (edges.size() != exits.size()) {
                throw new RuntimeException("vehicle " + this.tempAgent.getId() + ": there are " + edges.size() + " edges but " + exits.size() + " exit times in its route.");
            }
            int routeId = this.tempAgent.getPlans().size();
            double prob = Double.parseDouble(attrs.getValue(CHOICEPROB_ATTR)) / this.demandScale;
            SumoPlan newPlan = new SumoPlan(routeId, this.tempAgent.getDptTime_s(), edges, exits, this.travelTimes, this.planBuilder);
            this.tempAgent.addPlan(newPlan, prob);
        }
    }

    @Override
    public void endElement(String uri, String lName, String qName) {
        if (VEHICLE_ELEM.equals(qName)) {
            this.putNextAgent(this.tempAgent);
            if (this.clonedAgentIDs != null && this.clonedAgentIDs.contains(this.tempAgent.getId())) {
                this.putNextAgent(new SumoAgent(this.tempAgent, "-CLONE" + this.clonePostfix));
            }
        }
    }
}

