/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math.networks;

import cadyts.supply.network.Link;
import cadyts.supply.network.Node;
import cadyts.utilities.math.networks.LinkCost;
import cadyts.utilities.math.networks.LinkCostExcludingNodes;
import cadyts.utilities.math.networks.Router;
import cadyts.utilities.math.networks.UnsettledNodes;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UpdateRouter
extends Router {
    public UpdateRouter(LinkCost linkCost) {
        super(linkCost);
    }

    Set<Node> affectedNextNodes(Map<Node, Double> treeCost, Collection<Node> rootNodes, Router.Direction direction) {
        HashSet<Node> result = new HashSet<Node>();
        HashSet<Node> frontier = new HashSet<Node>();
        frontier.addAll(rootNodes);
        while (!frontier.isEmpty()) {
            HashSet<Node> newFrontier = new HashSet<Node>();
            for (Node frontierNode : frontier) {
                double candCost;
                Node candNode;
                double frontierCost = Router.treeCost(frontierNode, treeCost);
                if (direction == Router.Direction.FWD) {
                    for (Link outLink : frontierNode.getOutLinks()) {
                        candNode = outLink.getToNode();
                        candCost = frontierCost + this.linkCost.getCost(outLink);
                        if (!(candCost <= Router.treeCost(candNode, treeCost))) continue;
                        newFrontier.add(candNode);
                    }
                    continue;
                }
                for (Link inLink : frontierNode.getInLinks()) {
                    candNode = inLink.getFromNode();
                    candCost = frontierCost + this.linkCost.getCost(inLink);
                    if (!(candCost <= Router.treeCost(candNode, treeCost))) continue;
                    newFrontier.add(candNode);
                }
            }
            result.addAll(frontier);
            frontier = newFrontier;
            frontier.removeAll(result);
        }
        return result;
    }

    public Set<Node> affectedNextNodesFwd(Map<Node, Double> fwdCost, Set<Node> rootNodes) {
        return this.affectedNextNodes(fwdCost, rootNodes, Router.Direction.FWD);
    }

    public Set<Node> affectedNextNodesBwd(Map<Node, Double> bwdCost, Set<Node> rootNodes) {
        return this.affectedNextNodes(bwdCost, rootNodes, Router.Direction.BWD);
    }

    Set<Node> boundaryNodes(Set<Node> affectedNodes, Router.Direction direction) {
        HashSet<Node> result = new HashSet<Node>();
        for (Node affected : affectedNodes) {
            Node candNode;
            if (direction == Router.Direction.FWD) {
                for (Link candLink : affected.getInLinks()) {
                    candNode = candLink.getFromNode();
                    if (affectedNodes.contains(candNode)) continue;
                    result.add(candNode);
                }
                continue;
            }
            for (Link candLink : affected.getOutLinks()) {
                candNode = candLink.getToNode();
                if (affectedNodes.contains(candNode)) continue;
                result.add(candNode);
            }
        }
        return result;
    }

    public Map<Node, Double> costWithoutExcludedNodes(Node root, Collection<Node> allNodes, Collection<Node> excludedNodes, Map<Node, Double> treeCost, Router.Direction direction) {
        return this.costWithoutExcludedNodes2(root, allNodes, excludedNodes, treeCost, direction);
    }

    public Map<Node, Double> costWithoutExcludedNodes1(Node root, Collection<Node> allNodes, Collection<Node> excludedNodes, Map<Node, Double> treeCost, Router.Direction direction) {
        if (excludedNodes.isEmpty()) {
            return new HashMap<Node, Double>(treeCost);
        }
        if (excludedNodes.contains(root)) {
            HashMap<Node, Double> result = new HashMap<Node, Double>();
            result.put(root, 0.0);
            return result;
        }
        Set<Node> affectedNodes = this.affectedNextNodes(treeCost, excludedNodes, direction);
        Set<Node> boundaryNodes = this.boundaryNodes(affectedNodes, direction);
        UnsettledNodes unsettled = new UnsettledNodes();
        for (Node boundaryNode : boundaryNodes) {
            unsettled.update(boundaryNode, treeCost.get(boundaryNode));
        }
        HashSet<Node> settled = new HashSet<Node>(allNodes);
        settled.removeAll(affectedNodes);
        settled.removeAll(boundaryNodes);
        LinkCostExcludingNodes myLinkCost = new LinkCostExcludingNodes(this.linkCost, excludedNodes);
        Router myRouter = new Router(myLinkCost);
        Map<Node, Double> myTreeCost = myRouter.treeCost(root, affectedNodes, direction, unsettled, settled);
        HashMap<Node, Double> result = new HashMap<Node, Double>(treeCost);
        for (Node affectedNode : affectedNodes) {
            Double newCost = Router.treeCost(affectedNode, myTreeCost);
            if (newCost.isInfinite()) {
                result.remove(affectedNode);
                continue;
            }
            result.put(affectedNode, newCost);
        }
        return result;
    }

    public Map<Node, Double> costWithoutExcludedNodes2(Node root, Collection<Node> allNodes, Collection<Node> excludedNodes, Map<Node, Double> treeCost, Router.Direction direction) {
        if (excludedNodes.contains(root)) {
            HashMap<Node, Double> result = new HashMap<Node, Double>();
            result.put(root, 0.0);
            return result;
        }
        LinkCostExcludingNodes myLinkCost = new LinkCostExcludingNodes(this.linkCost, excludedNodes);
        Router myRouter = new Router(myLinkCost);
        Map<Node, Double> myTreeCost = myRouter.treeCost(root, null, direction, null, null);
        return myTreeCost;
    }

    public Map<Node, Double> fwdCostWithoutExcludedNodes(Node origin, Collection<Node> allNodes, Collection<Node> excludedNodes, Map<Node, Double> fwdCost) {
        return this.costWithoutExcludedNodes(origin, allNodes, excludedNodes, fwdCost, Router.Direction.FWD);
    }

    public Map<Node, Double> bwdCostWithoutExcludedNodes(Node destination, Collection<Node> allNodes, Collection<Node> excludedNodes, Map<Node, Double> bwdCost) {
        return this.costWithoutExcludedNodes(destination, allNodes, excludedNodes, bwdCost, Router.Direction.BWD);
    }
}

