/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class MBTFPQProjection
extends Projection {
    private static final int NITER = 20;
    private static final double EPS = 1.0E-7;
    private static final double ONETOL = 1.000001;
    private static final double C = 1.7071067811865475;
    private static final double RC = 0.585786437626905;
    private static final double FYC = 1.874758284622695;
    private static final double RYC = 0.533402096794177;
    private static final double FXC = 0.3124597141037825;
    private static final double RXC = 3.2004125807650623;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double c = 1.7071067811865475 * Math.sin(lpphi);
        for (int i = 20; i > 0; --i) {
            double th1 = (Math.sin(0.5 * lpphi) + Math.sin(lpphi) - c) / (0.5 * Math.cos(0.5 * lpphi) + Math.cos(lpphi));
            out.y -= th1;
            if (Math.abs(th1) < 1.0E-7) break;
        }
        out.x = 0.3124597141037825 * lplam * (1.0 + 2.0 * Math.cos(lpphi) / Math.cos(0.5 * lpphi));
        out.y = 1.874758284622695 * Math.sin(0.5 * lpphi);
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        double t = 0.0;
        double lpphi = 0.533402096794177 * xyy;
        if (Math.abs(lpphi) > 1.0) {
            if (Math.abs(lpphi) > 1.000001) {
                throw new ProjectionException("I");
            }
            if (lpphi < 0.0) {
                t = -1.0;
                lpphi = -Math.PI;
            } else {
                t = 1.0;
                lpphi = Math.PI;
            }
        } else {
            t = lpphi;
            lpphi = 2.0 * Math.asin(t);
        }
        out.x = 3.2004125807650623 * xyx / (1.0 + 2.0 * Math.cos(lpphi) / Math.cos(0.5 * lpphi));
        lpphi = 0.585786437626905 * (t + Math.sin(lpphi));
        if (Math.abs(lpphi) > 1.0) {
            if (Math.abs(lpphi) > 1.000001) {
                throw new ProjectionException("I");
            }
            lpphi = lpphi < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            lpphi = Math.asin(lpphi);
        }
        out.y = lpphi;
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "McBryde-Thomas Flat-Polar Quartic";
    }
}

