/* === S Y N F I G ========================================================= */
/*!	\file synfig/rendering/opengl/task/taskgl.h
**	\brief TaskGL Header
**
**	$Id$
**
**	\legal
**	......... ... 2015 Ivan Mahonin
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === S T A R T =========================================================== */

#ifndef __SYNFIG_RENDERING_TASKGL_H
#define __SYNFIG_RENDERING_TASKGL_H

/* === H E A D E R S ======================================================= */

#include "../../task.h"

#include "../surfacegl.h"
#include "../internal/predeclarations.h"

/* === M A C R O S ========================================================= */

/* === T Y P E D E F S ===================================================== */

/* === C L A S S E S & S T R U C T S ======================================= */

namespace synfig
{
namespace rendering
{

class TaskGL: public TackCapabilityInterface
{
public:
	virtual ~TaskGL() { }
	virtual bool is_supported_target(const Surface::Handle &surface)
		{ return surface.type_is<SurfaceGL>(); }
	virtual bool is_supported_source(const Surface::Handle &surface)
		{ return surface.type_is<SurfaceGL>(); }
	virtual Surface::Handle create_supported_target() { return new SurfaceGL(); }
	virtual Surface::Handle create_supported_source() { return new SurfaceGL(); }
protected:
	gl::Environment& env() const;
};

} /* end namespace rendering */
} /* end namespace synfig */

/* -- E N D ----------------------------------------------------------------- */

#endif
