'\"
'\" Generated from file 'rest\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "rest" n 1\&.0\&.2 tcllib "A framework for RESTful web services"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
rest \- define REST web APIs and call them inline or asychronously
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBrest  ?1\&.0\&.2?\fR
.sp
\fB::rest::simple\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.sp
\fB::rest::get\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.sp
\fB::rest::post\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.sp
\fB::rest::head\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.sp
\fB::rest::put\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.sp
\fB::rest::delete\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.sp
\fB::rest::save\fR \fIname\fR \fIfile\fR
.sp
\fB::rest::describe\fR \fIname\fR
.sp
\fB::rest::parameters\fR \fIurl\fR ?\fIkey\fR?
.sp
\fB::rest::parse_opts\fR \fIstatic\fR \fIrequired\fR \fIoptional\fR \fIwords\fR
.sp
\fB::rest::substitute\fR \fIstring\fR \fIvar\fR
.sp
\fB::rest::create_interface\fR \fIname\fR
.sp
.BE
.SH DESCRIPTION
There are two types of usage this package supports: \fIsimple calls\fR,
and complete \fIinterfaces\fR\&.
In an \fIinterface\fR you specify a set of rules and then the package
builds the commands which correspond to the REST methods\&. These
commands can have many options such as input and output
transformations and data type specific formatting\&. This results in a
cleaner and simpler script\&.
On the other hand, while a \fIsimple call\fR is easier and quicker
to implement it is also less featureful\&. It takes the url and a few
options about the command and returns the result directly\&. Any
formatting or checking is up to rest of the script\&.
.SH "SIMPLE USAGE"
In simple usage you make calls using the http method procedures and
then check or process the returned data yourself
.TP
\fB::rest::simple\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.TP
\fB::rest::get\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.TP
\fB::rest::post\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.TP
\fB::rest::head\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.TP
\fB::rest::put\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.TP
\fB::rest::delete\fR \fIurl\fR \fIquery\fR ?\fIconfig\fR? ?\fIbody\fR?
.sp
These commands are all equivalent except for the http method
used\&.
If you use \fBsimple\fR then the method should be specified as an
option in the \fIconfig\fR dictionary\&. If that is not done it defaults
to \fBget\fR\&. If a \fIbody\fR is needed then the \fIconfig\fR
dictionary must be present, however it is allowed to be empty\&.
.sp
The \fIconfig\fR dictionary supports the following keys
.RS
.TP
\fBauth\fR
.TP
\fBcontent-type\fR
.TP
\fBcookie\fR
.TP
\fBformat\fR
.TP
\fBheaders\fR
.TP
\fBmethod\fR
.RE
.sp
Two quick examples:
.sp
Example 1, Yahoo Boss:
.CS


    set appid APPID
    set search tcl
    set res [rest::get http://boss\&.yahooapis\&.com/ysearch/web/v1/$search [list appid $appid]]
    set res [rest::format_json $res]

.CE
.sp
Example 2, Twitter:
.CS


    set url   http://twitter\&.com/statuses/update\&.json
    set query [list status $text]
    set res [rest::simple $url $query {
        method post
        auth   {basic user password}
        format json
    }]

.CE
.PP
.SH "INTERFACE USAGE"
An interface to a REST API consists of a series of definitions of REST
calls contained in an array\&.
The name of that array becomes a namespace containing the defined
commands\&. Each key of the array specifies the name of the call, with
the associated configuration a dictionary, i\&.e\&. key/value pairs\&.
The acceptable keys, i\&.e\&. legal configuration options are described
below\&.
After creating the definitions in the array simply calling
\fBrest::create_interface\fR with the array as argument will then
create the desired commands\&.
.PP
Example, Yahoo Weather:
.CS


    package require rest

    set yweather(forecast) {
       url      http://weather\&.yahooapis\&.com/forecastrss
       req_args { p: }
       opt_args { u: }
    }
    rest::create_interface yweather
    puts [yweather::forecast -p 94089]

.CE
.TP
\fB::rest::save\fR \fIname\fR \fIfile\fR
This command saves a copy of the dynamically created procedures for
all the API calls specified in the array variable \fIname\fR to the
\fIfile\fR, for later loading\&.
.sp
The result of the command is the empty string
.TP
\fB::rest::describe\fR \fIname\fR
This command prints a description of all API calls specified in the array
variable \fIname\fR to the channel \fBstdout\fR\&.
.sp
The result of the command is the empty string\&.
.TP
\fB::rest::parameters\fR \fIurl\fR ?\fIkey\fR?
This command parses an \fIurl\fR query string into a dictionary and
returns said dictionary as its result\&.
.sp
If \fIkey\fR is specified the command will not return the
entire dictionary, but only the value of that \fIkey\fR\&.
.TP
\fB::rest::parse_opts\fR \fIstatic\fR \fIrequired\fR \fIoptional\fR \fIwords\fR
This command implements a custom parserfor command options\&.
.RS
.TP
dict \fIstatic\fR
A dictionary of options and their values that are always present in
the output\&.
.TP
list \fIrequired\fR
A list of options that must be supplied by \fIwords\fR
.TP
list \fIoptional\fR
A list of options that may appear in the \fIwords\fR, but are not required\&.
The elements must be in one of three forms:
.RS
.TP
name
The option may be present or not, no default\&.
.TP
name:
When present the option requires an argument\&.
.TP
name:value
When not present use \fBvalue\fR as default\&.
.RE
.TP
list \fIwords\fR
The words to parse into options and values\&.
.RE
.sp
The result of the command is a list containing two elements\&.
The first element is a dictionary containing the parsed options and
their values\&.  The second element is a list of the remaining words\&.
.TP
\fB::rest::substitute\fR \fIstring\fR \fIvar\fR
This command takes a \fIstring\fR, substitutes values for any option
identifiers found inside and returns the modified string as its
results\&.
.sp
The values to substitute are found in the variable \fIvar\fR,
which is expected to contain a dictionary mapping from the option
identifiers to replace to their values\&.
\fINote\fR that option identifiers which have no key in \fIvar\fR are
replaced with the empty string\&.
.sp
The option identifiers in \fIstring\fR have to follow the
syntax \fB%\&.\&.\&.%\fR where \fB\&.\&.\&.\fR may contain any combination of
lower-case alphanumeric characters, plus underscore, colon and dash\&.
.TP
\fB::rest::create_interface\fR \fIname\fR
This command creates procedures for all the API calls specified in the
array variable \fIname\fR\&.
.sp
The name of that array becomes a namespace containing the defined
commands\&. Each key of the array specifies the name of the call, with
the associated configuration a dictionary, i\&.e\&. key/value pairs\&.
The legal keys and their meanings are:
.RS
.TP
\fBurl\fR
The value of this \fIrequired\fR option must be the target of the
http request\&.
.TP
\fBdescription\fR
The value of this option must be a short string describing the call\&.
Default to the empty string, if not specified\&.
Used only by \fB::rest::describe\fR\&.
.TP
\fBbody\fR
The value of this option indicates if arguments are required for the
call's request body or not\&. The acceptable values are listed below\&.
Defaults to \fBoptional\fR if not specified\&.
.RS
.TP
\fBnone\fR
The call has no request body, none must be supplied\&.
.TP
\fBoptional\fR
A request body can be supplied, but is not required\&.
.TP
\fBrequired\fR
A request body must be supplied\&.
.TP
\fBargument\fR
This value must be followed by the name of an option, treating the
entire string as a list\&. The request body will be used as the value of
that option\&.
.TP
\fBmime_multipart\fR
A request body must be supplied and will be interpreted as each
argument representing one part of a mime/multipart document\&.
Arguments must be lists containing 2 elements, a list of header keys
and values, and the mime part body, in this order\&.
.RE
.TP
\fBmethod\fR
The value of this option must be the name of the HTTP method to call
on the url\&.
Defaults to GET, if not specified\&.
The acceptable values are \fBGET\fR, \fBPOST\fR, and \fBPUT\fR,
regardless of letter-case\&.
.TP
\fBcopy\fR
When present the value of this option specifies the name of a
previously defined call\&. The definition of that call is copied to the
current call, except for the options specified by the current call
itself\&.
.TP
\fBunset\fR
When present the value of this option names an option in the current
call\&. This option is removed from the definition\&. Use this after
\fBcopy\fRing an existing definition to remove options, instead of
overriding their value\&.
.TP
\fBheaders\fR
Specification of additional header fields\&. The value of this option
must be a dictionary, interpreted to contain the new header fields and
their values\&. The default is to not add any additional headers\&.
.TP
\fBcontent-type\fR
The value of this option specifies the content type for the request data\&.
.TP
\fBreq_args\fR
The value of this option is a list naming the required arguments of
the call\&.  Names ending in a colon will require a value\&.
.TP
\fBopt_args\fR
The value of this option a list naming the arguments that may be
present for a call but are not required\&.
.TP
\fBstatic_args\fR
The value of this option a list naming the arguments that are always
the same\&.  No sense in troubling the user with these\&.  A leading dash
(\fB-\fR) is allowed but not required to maintain consistency with
the command line\&.
.TP
\fBauth\fR
The value of this option specifies how to authenticate the calls\&.
No authentication is done if the option is not specified\&.
.RS
.TP
\fBbasic\fR
The user may configure the \fIbasic authentication\fR by overriding
the procedure \fBbasic_auth\fR in the namespace of interface\&. This
procedure takes two arguments, the username and password, in this
order\&.
.TP
\fBsign\fR
The value must actually be a list with the second element the name of
a procedure which will be called to perform request signing\&.
.RE
.TP
\fBcallback\fR
If this option is present then the method will be created as an
\fIasync\fR call\&. Such calls will return immediately with the value
of the associated http token instead of the call's result\&. The event
loop must be active to use this option\&.
.sp
The value of this option is the name of a procedure which is
invoked when the HTTP call is complete\&. The procedure will receive
three arguments, the name of the calling procedure, the status of the
result (one of \fBOK\fR or \fBERROR\fR), and the data associated
with the result, in this order\&.
The http request header will be available in that procedure via
\fBupvar token token\fR\&.
.TP
\fBcookie\fR
The value of this option is a list of cookies to be passed in the http
header\&. This is a shortcut to the \fBheaders\fR option\&.
.TP
\fBinput_transform\fR
The value of this option is a command prefix or script to perform a
transformation on the query before invoking the call\&. A script
transform is wrapped into an automatically generated internal
procedure\&.
.sp
If not specified no transformation is done\&.
.sp
The command (prefix) must accept a single argument, the query
(a dictionary) to transform, and must return the modified query (again
as dictionary) as its result\&.
The request body is accessible in the transform command via
\fBupvar body body\fR\&.
.TP
\fBformat\fR
.TP
\fBresult\fR
The value of this option specifies the format of the returned
data\&.
Defaults to \fBauto\fR if not specified\&.
The acceptable values are:
.RS
.TP
\fBauto\fR
Auto detect between \fBxml\fR and \fBjson\fR\&.
.TP
\fBdiscard\fR
.TP
\fBjson\fR
.TP
\fBraw\fR
.TP
\fBrss\fR
This is formatted as a special case of \fBxml\fR\&.
.TP
\fBtdom\fR
.TP
\fBxml\fR
.RE
.TP
\fBpre_transform\fR
The value of this option is a command prefix or script to perform a
transformation on the result of a call (\fIbefore\fR the application
of the output transform as per \fBformat\fR)\&. A script transform is
wrapped into an automatically generated internal procedure\&.
.sp
If not specified no transformation is done\&.
.sp
The command (prefix) must accept a single argument, the result
to transform, and must return the modified result as its result\&.
.sp
The http request header is accessible in the transform command
via \fBupvar token token\fR
.TP
\fBpost_transform\fR
The value of this option is a command prefix or script to perform a
transformation on the result of a call (\fIafter\fR the application
of the output transform as per \fBformat\fR)\&. A script transform is
wrapped into an automatically generated internal procedure\&.
.sp
If not specified no transformation is done\&.
.sp
The command (prefix) must accept a single argument, the result
to transform, and must return the modified result as its result\&.
.sp
The http request header is accessible in the transform command
via \fBupvar token token\fR
.TP
\fBcheck_result\fR
The value of this option must be list of two expressions, either of
which may be empty\&.
.sp
The first expression is checks the OK condition, it must return
\fBtrue\fR when the result is satisfactory, and \fBfalse\fR
otherwise\&.
.sp
The second expression is the ERROR condition, it must return
\fBfalse\fR unless there is an error, then it has to return
\fBtrue\fR\&.
.RE
.PP
.SH EXAMPLES
.PP
Yahoo Geo:
.CS


set ygeo(parse) {
    url http://wherein\&.yahooapis\&.com/v1/document
    method post
    body { arg documentContent }
}
ygeo::parse "san jose ca"
# "san jose ca" will be interpreted as if it were specified as the -documentContent option

.CE
.PP
Google Docs:
.CS


set gdocs(upload) {
    url http://docs\&.google\&.com/feeds/default/private/full
    body mime_multipart
}
gdocs::upload [list {Content-Type application/atom+xml} $xml] [list {Content-Type image/jpeg} $filedata]

.CE
.PP
Delicious:
.CS


set delicious(updated) {
    url https://api\&.del\&.icio\&.us/v1/posts/update
    auth basic
}

rest::create_interface flickr

flickr::basic_auth username password

.CE
.PP
Flickr:
.CS


set flickr(auth\&.getToken) {
   url http://api\&.flickr\&.com/services/rest/
   req_args { api_key: secret: }
   auth { sign do_signature }
}

rest::create_interface flickr

proc ::flickr::do_signature {query} {
    # perform some operations on the query here
    return $query
}

.CE
.SH INCLUDED
The package provides functional but incomplete implementations for the following services:
.TP
\fBdel\&.icio\&.us\fR
.TP
\fBfacebook\fR
.TP
\fBflickr\fR
.TP
\fBtwitter\fR
.TP
\fBgoogle calendar\fR
.TP
\fByahoo boss\fR
.TP
\fByahoo weather\fR
.PP
Please either read the package's implementation, or use
\fBrest::describe\fR after loading it for their details\&.
.PP
Do not forget developers' documentation on the respective sites either\&.
.SH TLS
The \fBrest\fR package can be used with \fIhttps\fR-secured
services, by requiring the \fBTLS\fR package and then registering
it with the \fBhttp\fR package it is sitting on top of\&.
Example
.CS


    package require tls
    http::register https 443 ::tls::socket

.CE
.SH "TLS SECURITY CONSIDERATIONS"
This package uses the \fBTLS\fR package to handle the security
for \fBhttps\fR urls and other socket connections\&.
.PP
Policy decisions like the set of protocols to support and what
ciphers to use are not the responsibility of \fBTLS\fR, nor of
this package itself however\&.
Such decisions are the responsibility of whichever application is
using the package, and are likely influenced by the set of servers
the application will talk to as well\&.
.PP
For example, in light of the recent
\fIPOODLE attack\fR [http://googleonlinesecurity\&.blogspot\&.co\&.uk/2014/10/this-poodle-bites-exploiting-ssl-30\&.html] discovered by Google many servers will disable support
for the SSLv3 protocol\&.
To handle this change the applications using \fBTLS\fR must be
patched, and not this package, nor \fBTLS\fR itself\&.
Such a patch may be as simple as generally activating \fBtls1\fR
support, as shown in the example below\&.
.CS


    package require tls
    tls::init -tls1 1 ;# forcibly activate support for the TLS1 protocol

    \&.\&.\&. your own application code \&.\&.\&.

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIrest\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.