/*
 *
 * This file is part of Tulip (www.tulip-software.org)
 *
 * Authors: David Auber and the Tulip development Team
 * from LaBRI, University of Bordeaux
 *
 * Tulip is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 *
 * Tulip is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 */

#include <cstring>
#include <tulip/TulipFontAwesome.h>
#include <tulip/TlpTools.h>

#include <utf8.h>

#include <algorithm>
#include <map>

using namespace std;

namespace tlp {

const char* TulipFontAwesome::Adjust = "adjust";
const char* TulipFontAwesome::Adn = "adn";
const char* TulipFontAwesome::AlignCenter = "align-center";
const char* TulipFontAwesome::AlignJustify = "align-justify";
const char* TulipFontAwesome::AlignLeft = "align-left";
const char* TulipFontAwesome::AlignRight = "align-right";
const char* TulipFontAwesome::Ambulance = "ambulance";
const char* TulipFontAwesome::Anchor = "anchor";
const char* TulipFontAwesome::Android = "android";
const char* TulipFontAwesome::Angellist = "angellist";
const char* TulipFontAwesome::AngleDoubleDown = "angle-double-down";
const char* TulipFontAwesome::AngleDoubleLeft = "angle-double-left";
const char* TulipFontAwesome::AngleDoubleRight = "angle-double-right";
const char* TulipFontAwesome::AngleDoubleUp = "angle-double-up";
const char* TulipFontAwesome::AngleDown = "angle-down";
const char* TulipFontAwesome::AngleLeft = "angle-left";
const char* TulipFontAwesome::AngleRight = "angle-right";
const char* TulipFontAwesome::AngleUp = "angle-up";
const char* TulipFontAwesome::Apple = "apple";
const char* TulipFontAwesome::Archive = "archive";
const char* TulipFontAwesome::AreaChart = "area-chart";
const char* TulipFontAwesome::ArrowCircleDown = "arrow-circle-down";
const char* TulipFontAwesome::ArrowCircleLeft = "arrow-circle-left";
const char* TulipFontAwesome::ArrowCircleODown = "arrow-circle-o-down";
const char* TulipFontAwesome::ArrowCircleOLeft = "arrow-circle-o-left";
const char* TulipFontAwesome::ArrowCircleORight = "arrow-circle-o-right";
const char* TulipFontAwesome::ArrowCircleOUp = "arrow-circle-o-up";
const char* TulipFontAwesome::ArrowCircleRight = "arrow-circle-right";
const char* TulipFontAwesome::ArrowCircleUp = "arrow-circle-up";
const char* TulipFontAwesome::ArrowDown = "arrow-down";
const char* TulipFontAwesome::ArrowLeft = "arrow-left";
const char* TulipFontAwesome::ArrowRight = "arrow-right";
const char* TulipFontAwesome::ArrowUp = "arrow-up";
const char* TulipFontAwesome::Arrows = "arrows";
const char* TulipFontAwesome::ArrowsAlt = "arrows-alt";
const char* TulipFontAwesome::ArrowsH = "arrows-h";
const char* TulipFontAwesome::ArrowsV = "arrows-v";
const char* TulipFontAwesome::Asterisk = "asterisk";
const char* TulipFontAwesome::At = "at";
const char* TulipFontAwesome::Automobile = "automobile";
const char* TulipFontAwesome::Backward = "backward";
const char* TulipFontAwesome::Ban = "ban";
const char* TulipFontAwesome::Bank = "bank";
const char* TulipFontAwesome::BarChart = "bar-chart";
const char* TulipFontAwesome::BarChartO = "bar-chart-o";
const char* TulipFontAwesome::Barcode = "barcode";
const char* TulipFontAwesome::Bars = "bars";
const char* TulipFontAwesome::Bed = "bed";
const char* TulipFontAwesome::Beer = "beer";
const char* TulipFontAwesome::Behance = "behance";
const char* TulipFontAwesome::BehanceSquare = "behance-square";
const char* TulipFontAwesome::Bell = "bell";
const char* TulipFontAwesome::BellO = "bell-o";
const char* TulipFontAwesome::BellSlash = "bell-slash";
const char* TulipFontAwesome::BellSlashO = "bell-slash-o";
const char* TulipFontAwesome::Bicycle = "bicycle";
const char* TulipFontAwesome::Binoculars = "binoculars";
const char* TulipFontAwesome::BirthdayCake = "birthday-cake";
const char* TulipFontAwesome::Bitbucket = "bitbucket";
const char* TulipFontAwesome::BitbucketSquare = "bitbucket-square";
const char* TulipFontAwesome::Bitcoin = "bitcoin";
const char* TulipFontAwesome::Bold = "bold";
const char* TulipFontAwesome::Bolt = "bolt";
const char* TulipFontAwesome::Bomb = "bomb";
const char* TulipFontAwesome::Book = "book";
const char* TulipFontAwesome::Bookmark = "bookmark";
const char* TulipFontAwesome::BookmarkO = "bookmark-o";
const char* TulipFontAwesome::Briefcase = "briefcase";
const char* TulipFontAwesome::Btc = "btc";
const char* TulipFontAwesome::Bug = "bug";
const char* TulipFontAwesome::Building = "building";
const char* TulipFontAwesome::BuildingO = "building-o";
const char* TulipFontAwesome::Bullhorn = "bullhorn";
const char* TulipFontAwesome::Bullseye = "bullseye";
const char* TulipFontAwesome::Bus = "bus";
const char* TulipFontAwesome::Buysellads = "buysellads";
const char* TulipFontAwesome::Cab = "cab";
const char* TulipFontAwesome::Calculator = "calculator";
const char* TulipFontAwesome::Calendar = "calendar";
const char* TulipFontAwesome::CalendarO = "calendar-o";
const char* TulipFontAwesome::Camera = "camera";
const char* TulipFontAwesome::CameraRetro = "camera-retro";
const char* TulipFontAwesome::Car = "car";
const char* TulipFontAwesome::CaretDown = "caret-down";
const char* TulipFontAwesome::CaretLeft = "caret-left";
const char* TulipFontAwesome::CaretRight = "caret-right";
const char* TulipFontAwesome::CaretSquareODown = "caret-square-o-down";
const char* TulipFontAwesome::CaretSquareOLeft = "caret-square-o-left";
const char* TulipFontAwesome::CaretSquareORight = "caret-square-o-right";
const char* TulipFontAwesome::CaretSquareOUp = "caret-square-o-up";
const char* TulipFontAwesome::CaretUp = "caret-up";
const char* TulipFontAwesome::CartArrowDown = "cart-arrow-down";
const char* TulipFontAwesome::CartPlus = "cart-plus";
const char* TulipFontAwesome::Cc = "cc";
const char* TulipFontAwesome::CcAmex = "cc-amex";
const char* TulipFontAwesome::CcDiscover = "cc-discover";
const char* TulipFontAwesome::CcMastercard = "cc-mastercard";
const char* TulipFontAwesome::CcPaypal = "cc-paypal";
const char* TulipFontAwesome::CcStripe = "cc-stripe";
const char* TulipFontAwesome::CcVisa = "cc-visa";
const char* TulipFontAwesome::Certificate = "certificate";
const char* TulipFontAwesome::Chain = "chain";
const char* TulipFontAwesome::ChainBroken = "chain-broken";
const char* TulipFontAwesome::Check = "check";
const char* TulipFontAwesome::CheckCircle = "check-circle";
const char* TulipFontAwesome::CheckCircleO = "check-circle-o";
const char* TulipFontAwesome::CheckSquare = "check-square";
const char* TulipFontAwesome::CheckSquareO = "check-square-o";
const char* TulipFontAwesome::ChevronCircleDown = "chevron-circle-down";
const char* TulipFontAwesome::ChevronCircleLeft = "chevron-circle-left";
const char* TulipFontAwesome::ChevronCircleRight = "chevron-circle-right";
const char* TulipFontAwesome::ChevronCircleUp = "chevron-circle-up";
const char* TulipFontAwesome::ChevronDown = "chevron-down";
const char* TulipFontAwesome::ChevronLeft = "chevron-left";
const char* TulipFontAwesome::ChevronRight = "chevron-right";
const char* TulipFontAwesome::ChevronUp = "chevron-up";
const char* TulipFontAwesome::Child = "child";
const char* TulipFontAwesome::Circle = "circle";
const char* TulipFontAwesome::CircleO = "circle-o";
const char* TulipFontAwesome::CircleONotch = "circle-o-notch";
const char* TulipFontAwesome::CircleThin = "circle-thin";
const char* TulipFontAwesome::Clipboard = "clipboard";
const char* TulipFontAwesome::ClockO = "clock-o";
const char* TulipFontAwesome::Close = "close";
const char* TulipFontAwesome::Cloud = "cloud";
const char* TulipFontAwesome::CloudDownload = "cloud-download";
const char* TulipFontAwesome::CloudUpload = "cloud-upload";
const char* TulipFontAwesome::Cny = "cny";
const char* TulipFontAwesome::Code = "code";
const char* TulipFontAwesome::CodeFork = "code-fork";
const char* TulipFontAwesome::Codepen = "codepen";
const char* TulipFontAwesome::Coffee = "coffee";
const char* TulipFontAwesome::Cog = "cog";
const char* TulipFontAwesome::Cogs = "cogs";
const char* TulipFontAwesome::Columns = "columns";
const char* TulipFontAwesome::Comment = "comment";
const char* TulipFontAwesome::CommentO = "comment-o";
const char* TulipFontAwesome::Comments = "comments";
const char* TulipFontAwesome::CommentsO = "comments-o";
const char* TulipFontAwesome::Compass = "compass";
const char* TulipFontAwesome::Compress = "compress";
const char* TulipFontAwesome::Connectdevelop = "connectdevelop";
const char* TulipFontAwesome::Copy = "copy";
const char* TulipFontAwesome::Copyright = "copyright";
const char* TulipFontAwesome::CreditCard = "credit-card";
const char* TulipFontAwesome::Crop = "crop";
const char* TulipFontAwesome::Crosshairs = "crosshairs";
const char* TulipFontAwesome::Css3 = "css3";
const char* TulipFontAwesome::Cube = "cube";
const char* TulipFontAwesome::Cubes = "cubes";
const char* TulipFontAwesome::Cut = "cut";
const char* TulipFontAwesome::Cutlery = "cutlery";
const char* TulipFontAwesome::Dashboard = "dashboard";
const char* TulipFontAwesome::Dashcube = "dashcube";
const char* TulipFontAwesome::Database = "database";
const char* TulipFontAwesome::Dedent = "dedent";
const char* TulipFontAwesome::Delicious = "delicious";
const char* TulipFontAwesome::Desktop = "desktop";
const char* TulipFontAwesome::Deviantart = "deviantart";
const char* TulipFontAwesome::Diamond = "diamond";
const char* TulipFontAwesome::Digg = "digg";
const char* TulipFontAwesome::Dollar = "dollar";
const char* TulipFontAwesome::DotCircleO = "dot-circle-o";
const char* TulipFontAwesome::Download = "download";
const char* TulipFontAwesome::Dribbble = "dribbble";
const char* TulipFontAwesome::Dropbox = "dropbox";
const char* TulipFontAwesome::Drupal = "drupal";
const char* TulipFontAwesome::Edit = "edit";
const char* TulipFontAwesome::Eject = "eject";
const char* TulipFontAwesome::EllipsisH = "ellipsis-h";
const char* TulipFontAwesome::EllipsisV = "ellipsis-v";
const char* TulipFontAwesome::Empire = "empire";
const char* TulipFontAwesome::Envelope = "envelope";
const char* TulipFontAwesome::EnvelopeO = "envelope-o";
const char* TulipFontAwesome::EnvelopeSquare = "envelope-square";
const char* TulipFontAwesome::Eraser = "eraser";
const char* TulipFontAwesome::Eur = "eur";
const char* TulipFontAwesome::Euro = "euro";
const char* TulipFontAwesome::Exchange = "exchange";
const char* TulipFontAwesome::Exclamation = "exclamation";
const char* TulipFontAwesome::ExclamationCircle = "exclamation-circle";
const char* TulipFontAwesome::ExclamationTriangle = "exclamation-triangle";
const char* TulipFontAwesome::Expand = "expand";
const char* TulipFontAwesome::ExternalLink = "external-link";
const char* TulipFontAwesome::ExternalLinkSquare = "external-link-square";
const char* TulipFontAwesome::Eye = "eye";
const char* TulipFontAwesome::EyeSlash = "eye-slash";
const char* TulipFontAwesome::Eyedropper = "eyedropper";
const char* TulipFontAwesome::Facebook = "facebook";
const char* TulipFontAwesome::FacebookF = "facebook-f";
const char* TulipFontAwesome::FacebookOfficial = "facebook-official";
const char* TulipFontAwesome::FacebookSquare = "facebook-square";
const char* TulipFontAwesome::FastBackward = "fast-backward";
const char* TulipFontAwesome::FastForward = "fast-forward";
const char* TulipFontAwesome::Fax = "fax";
const char* TulipFontAwesome::Female = "female";
const char* TulipFontAwesome::FighterJet = "fighter-jet";
const char* TulipFontAwesome::File = "file";
const char* TulipFontAwesome::FileArchiveO = "file-archive-o";
const char* TulipFontAwesome::FileAudioO = "file-audio-o";
const char* TulipFontAwesome::FileCodeO = "file-code-o";
const char* TulipFontAwesome::FileExcelO = "file-excel-o";
const char* TulipFontAwesome::FileImageO = "file-image-o";
const char* TulipFontAwesome::FileMovieO = "file-movie-o";
const char* TulipFontAwesome::FileO = "file-o";
const char* TulipFontAwesome::FilePdfO = "file-pdf-o";
const char* TulipFontAwesome::FilePhotoO = "file-photo-o";
const char* TulipFontAwesome::FilePictureO = "file-picture-o";
const char* TulipFontAwesome::FilePowerpointO = "file-powerpoint-o";
const char* TulipFontAwesome::FileSoundO = "file-sound-o";
const char* TulipFontAwesome::FileText = "file-text";
const char* TulipFontAwesome::FileTextO = "file-text-o";
const char* TulipFontAwesome::FileVideoO = "file-video-o";
const char* TulipFontAwesome::FileWordO = "file-word-o";
const char* TulipFontAwesome::FileZipO = "file-zip-o";
const char* TulipFontAwesome::FilesO = "files-o";
const char* TulipFontAwesome::Film = "film";
const char* TulipFontAwesome::Filter = "filter";
const char* TulipFontAwesome::Fire = "fire";
const char* TulipFontAwesome::FireExtinguisher = "fire-extinguisher";
const char* TulipFontAwesome::Flag = "flag";
const char* TulipFontAwesome::FlagCheckered = "flag-checkered";
const char* TulipFontAwesome::FlagO = "flag-o";
const char* TulipFontAwesome::Flash = "flash";
const char* TulipFontAwesome::Flask = "flask";
const char* TulipFontAwesome::Flickr = "flickr";
const char* TulipFontAwesome::FloppyO = "floppy-o";
const char* TulipFontAwesome::Folder = "folder";
const char* TulipFontAwesome::FolderO = "folder-o";
const char* TulipFontAwesome::FolderOpen = "folder-open";
const char* TulipFontAwesome::FolderOpenO = "folder-open-o";
const char* TulipFontAwesome::Font = "font";
const char* TulipFontAwesome::Forumbee = "forumbee";
const char* TulipFontAwesome::Forward = "forward";
const char* TulipFontAwesome::Foursquare = "foursquare";
const char* TulipFontAwesome::FrownO = "frown-o";
const char* TulipFontAwesome::FutbolO = "futbol-o";
const char* TulipFontAwesome::Gamepad = "gamepad";
const char* TulipFontAwesome::Gavel = "gavel";
const char* TulipFontAwesome::Gbp = "gbp";
const char* TulipFontAwesome::Ge = "ge";
const char* TulipFontAwesome::Gear = "gear";
const char* TulipFontAwesome::Gears = "gears";
const char* TulipFontAwesome::Genderless = "genderless";
const char* TulipFontAwesome::Gift = "gift";
const char* TulipFontAwesome::Git = "git";
const char* TulipFontAwesome::GitSquare = "git-square";
const char* TulipFontAwesome::Github = "github";
const char* TulipFontAwesome::GithubAlt = "github-alt";
const char* TulipFontAwesome::GithubSquare = "github-square";
const char* TulipFontAwesome::Gittip = "gittip";
const char* TulipFontAwesome::Glass = "glass";
const char* TulipFontAwesome::Globe = "globe";
const char* TulipFontAwesome::Google = "google";
const char* TulipFontAwesome::GooglePlus = "google-plus";
const char* TulipFontAwesome::GooglePlusSquare = "google-plus-square";
const char* TulipFontAwesome::GoogleWallet = "google-wallet";
const char* TulipFontAwesome::GraduationCap = "graduation-cap";
const char* TulipFontAwesome::Gratipay = "gratipay";
const char* TulipFontAwesome::Group = "group";
const char* TulipFontAwesome::HSquare = "h-square";
const char* TulipFontAwesome::HackerNews = "hacker-news";
const char* TulipFontAwesome::HandODown = "hand-o-down";
const char* TulipFontAwesome::HandOLeft = "hand-o-left";
const char* TulipFontAwesome::HandORight = "hand-o-right";
const char* TulipFontAwesome::HandOUp = "hand-o-up";
const char* TulipFontAwesome::HddO = "hdd-o";
const char* TulipFontAwesome::Header = "header";
const char* TulipFontAwesome::Headphones = "headphones";
const char* TulipFontAwesome::Heart = "heart";
const char* TulipFontAwesome::HeartO = "heart-o";
const char* TulipFontAwesome::Heartbeat = "heartbeat";
const char* TulipFontAwesome::History = "history";
const char* TulipFontAwesome::Home = "home";
const char* TulipFontAwesome::HospitalO = "hospital-o";
const char* TulipFontAwesome::Hotel = "hotel";
const char* TulipFontAwesome::Html5 = "html5";
const char* TulipFontAwesome::Ils = "ils";
const char* TulipFontAwesome::Image = "image";
const char* TulipFontAwesome::Inbox = "inbox";
const char* TulipFontAwesome::Indent = "indent";
const char* TulipFontAwesome::Info = "info";
const char* TulipFontAwesome::InfoCircle = "info-circle";
const char* TulipFontAwesome::Inr = "inr";
const char* TulipFontAwesome::Instagram = "instagram";
const char* TulipFontAwesome::Institution = "institution";
const char* TulipFontAwesome::Ioxhost = "ioxhost";
const char* TulipFontAwesome::Italic = "italic";
const char* TulipFontAwesome::Joomla = "joomla";
const char* TulipFontAwesome::Jpy = "jpy";
const char* TulipFontAwesome::Jsfiddle = "jsfiddle";
const char* TulipFontAwesome::Key = "key";
const char* TulipFontAwesome::KeyboardO = "keyboard-o";
const char* TulipFontAwesome::Krw = "krw";
const char* TulipFontAwesome::Language = "language";
const char* TulipFontAwesome::Laptop = "laptop";
const char* TulipFontAwesome::Lastfm = "lastfm";
const char* TulipFontAwesome::LastfmSquare = "lastfm-square";
const char* TulipFontAwesome::Leaf = "leaf";
const char* TulipFontAwesome::Leanpub = "leanpub";
const char* TulipFontAwesome::Legal = "legal";
const char* TulipFontAwesome::LemonO = "lemon-o";
const char* TulipFontAwesome::LevelDown = "level-down";
const char* TulipFontAwesome::LevelUp = "level-up";
const char* TulipFontAwesome::LifeBouy = "life-bouy";
const char* TulipFontAwesome::LifeBuoy = "life-buoy";
const char* TulipFontAwesome::LifeRing = "life-ring";
const char* TulipFontAwesome::LifeSaver = "life-saver";
const char* TulipFontAwesome::LightbulbO = "lightbulb-o";
const char* TulipFontAwesome::LineChart = "line-chart";
const char* TulipFontAwesome::Link = "link";
const char* TulipFontAwesome::Linkedin = "linkedin";
const char* TulipFontAwesome::LinkedinSquare = "linkedin-square";
const char* TulipFontAwesome::Linux = "linux";
const char* TulipFontAwesome::List = "list";
const char* TulipFontAwesome::ListAlt = "list-alt";
const char* TulipFontAwesome::ListOl = "list-ol";
const char* TulipFontAwesome::ListUl = "list-ul";
const char* TulipFontAwesome::LocationArrow = "location-arrow";
const char* TulipFontAwesome::Lock = "lock";
const char* TulipFontAwesome::LongArrowDown = "long-arrow-down";
const char* TulipFontAwesome::LongArrowLeft = "long-arrow-left";
const char* TulipFontAwesome::LongArrowRight = "long-arrow-right";
const char* TulipFontAwesome::LongArrowUp = "long-arrow-up";
const char* TulipFontAwesome::Magic = "magic";
const char* TulipFontAwesome::Magnet = "magnet";
const char* TulipFontAwesome::MailForward = "mail-forward";
const char* TulipFontAwesome::MailReply = "mail-reply";
const char* TulipFontAwesome::MailReplyAll = "mail-reply-all";
const char* TulipFontAwesome::Male = "male";
const char* TulipFontAwesome::MapMarker = "map-marker";
const char* TulipFontAwesome::Mars = "mars";
const char* TulipFontAwesome::MarsDouble = "mars-double";
const char* TulipFontAwesome::MarsStroke = "mars-stroke";
const char* TulipFontAwesome::MarsStrokeH = "mars-stroke-h";
const char* TulipFontAwesome::MarsStrokeV = "mars-stroke-v";
const char* TulipFontAwesome::Maxcdn = "maxcdn";
const char* TulipFontAwesome::Meanpath = "meanpath";
const char* TulipFontAwesome::Medium = "medium";
const char* TulipFontAwesome::Medkit = "medkit";
const char* TulipFontAwesome::MehO = "meh-o";
const char* TulipFontAwesome::Mercury = "mercury";
const char* TulipFontAwesome::Microphone = "microphone";
const char* TulipFontAwesome::MicrophoneSlash = "microphone-slash";
const char* TulipFontAwesome::Minus = "minus";
const char* TulipFontAwesome::MinusCircle = "minus-circle";
const char* TulipFontAwesome::MinusSquare = "minus-square";
const char* TulipFontAwesome::MinusSquareO = "minus-square-o";
const char* TulipFontAwesome::Mobile = "mobile";
const char* TulipFontAwesome::MobilePhone = "mobile-phone";
const char* TulipFontAwesome::Money = "money";
const char* TulipFontAwesome::MoonO = "moon-o";
const char* TulipFontAwesome::MortarBoard = "mortar-board";
const char* TulipFontAwesome::Motorcycle = "motorcycle";
const char* TulipFontAwesome::Music = "music";
const char* TulipFontAwesome::Navicon = "navicon";
const char* TulipFontAwesome::Neuter = "neuter";
const char* TulipFontAwesome::NewspaperO = "newspaper-o";
const char* TulipFontAwesome::Openid = "openid";
const char* TulipFontAwesome::Outdent = "outdent";
const char* TulipFontAwesome::Pagelines = "pagelines";
const char* TulipFontAwesome::PaintBrush = "paint-brush";
const char* TulipFontAwesome::PaperPlane = "paper-plane";
const char* TulipFontAwesome::PaperPlaneO = "paper-plane-o";
const char* TulipFontAwesome::Paperclip = "paperclip";
const char* TulipFontAwesome::Paragraph = "paragraph";
const char* TulipFontAwesome::Paste = "paste";
const char* TulipFontAwesome::Pause = "pause";
const char* TulipFontAwesome::Paw = "paw";
const char* TulipFontAwesome::Paypal = "paypal";
const char* TulipFontAwesome::Pencil = "pencil";
const char* TulipFontAwesome::PencilSquare = "pencil-square";
const char* TulipFontAwesome::PencilSquareO = "pencil-square-o";
const char* TulipFontAwesome::Phone = "phone";
const char* TulipFontAwesome::PhoneSquare = "phone-square";
const char* TulipFontAwesome::Photo = "photo";
const char* TulipFontAwesome::PictureO = "picture-o";
const char* TulipFontAwesome::PieChart = "pie-chart";
const char* TulipFontAwesome::PiedPiper = "pied-piper";
const char* TulipFontAwesome::PiedPiperAlt = "pied-piper-alt";
const char* TulipFontAwesome::Pinterest = "pinterest";
const char* TulipFontAwesome::PinterestP = "pinterest-p";
const char* TulipFontAwesome::PinterestSquare = "pinterest-square";
const char* TulipFontAwesome::Plane = "plane";
const char* TulipFontAwesome::Play = "play";
const char* TulipFontAwesome::PlayCircle = "play-circle";
const char* TulipFontAwesome::PlayCircleO = "play-circle-o";
const char* TulipFontAwesome::Plug = "plug";
const char* TulipFontAwesome::Plus = "plus";
const char* TulipFontAwesome::PlusCircle = "plus-circle";
const char* TulipFontAwesome::PlusSquare = "plus-square";
const char* TulipFontAwesome::PlusSquareO = "plus-square-o";
const char* TulipFontAwesome::PowerOff = "power-off";
const char* TulipFontAwesome::Print = "print";
const char* TulipFontAwesome::PuzzlePiece = "puzzle-piece";
const char* TulipFontAwesome::Qq = "qq";
const char* TulipFontAwesome::Qrcode = "qrcode";
const char* TulipFontAwesome::Question = "question";
const char* TulipFontAwesome::QuestionCircle = "question-circle";
const char* TulipFontAwesome::QuoteLeft = "quote-left";
const char* TulipFontAwesome::QuoteRight = "quote-right";
const char* TulipFontAwesome::Ra = "ra";
const char* TulipFontAwesome::Random = "random";
const char* TulipFontAwesome::Rebel = "rebel";
const char* TulipFontAwesome::Recycle = "recycle";
const char* TulipFontAwesome::Reddit = "reddit";
const char* TulipFontAwesome::RedditSquare = "reddit-square";
const char* TulipFontAwesome::Refresh = "refresh";
const char* TulipFontAwesome::Remove = "remove";
const char* TulipFontAwesome::Renren = "renren";
const char* TulipFontAwesome::Reorder = "reorder";
const char* TulipFontAwesome::Repeat = "repeat";
const char* TulipFontAwesome::Reply = "reply";
const char* TulipFontAwesome::ReplyAll = "reply-all";
const char* TulipFontAwesome::Retweet = "retweet";
const char* TulipFontAwesome::Rmb = "rmb";
const char* TulipFontAwesome::Road = "road";
const char* TulipFontAwesome::Rocket = "rocket";
const char* TulipFontAwesome::RotateLeft = "rotate-left";
const char* TulipFontAwesome::RotateRight = "rotate-right";
const char* TulipFontAwesome::Rouble = "rouble";
const char* TulipFontAwesome::Rss = "rss";
const char* TulipFontAwesome::RssSquare = "rss-square";
const char* TulipFontAwesome::Rub = "rub";
const char* TulipFontAwesome::Ruble = "ruble";
const char* TulipFontAwesome::Rupee = "rupee";
const char* TulipFontAwesome::Save = "save";
const char* TulipFontAwesome::Scissors = "scissors";
const char* TulipFontAwesome::Search = "search";
const char* TulipFontAwesome::SearchMinus = "search-minus";
const char* TulipFontAwesome::SearchPlus = "search-plus";
const char* TulipFontAwesome::Sellsy = "sellsy";
const char* TulipFontAwesome::Send = "send";
const char* TulipFontAwesome::SendO = "send-o";
const char* TulipFontAwesome::Server = "server";
const char* TulipFontAwesome::Share = "share";
const char* TulipFontAwesome::ShareAlt = "share-alt";
const char* TulipFontAwesome::ShareAltSquare = "share-alt-square";
const char* TulipFontAwesome::ShareSquare = "share-square";
const char* TulipFontAwesome::ShareSquareO = "share-square-o";
const char* TulipFontAwesome::Shekel = "shekel";
const char* TulipFontAwesome::Sheqel = "sheqel";
const char* TulipFontAwesome::Shield = "shield";
const char* TulipFontAwesome::Ship = "ship";
const char* TulipFontAwesome::Shirtsinbulk = "shirtsinbulk";
const char* TulipFontAwesome::ShoppingCart = "shopping-cart";
const char* TulipFontAwesome::SignIn = "sign-in";
const char* TulipFontAwesome::SignOut = "sign-out";
const char* TulipFontAwesome::Signal = "signal";
const char* TulipFontAwesome::Simplybuilt = "simplybuilt";
const char* TulipFontAwesome::Sitemap = "sitemap";
const char* TulipFontAwesome::Skyatlas = "skyatlas";
const char* TulipFontAwesome::Skype = "skype";
const char* TulipFontAwesome::Slack = "slack";
const char* TulipFontAwesome::Sliders = "sliders";
const char* TulipFontAwesome::Slideshare = "slideshare";
const char* TulipFontAwesome::SmileO = "smile-o";
const char* TulipFontAwesome::SoccerBallO = "soccer-ball-o";
const char* TulipFontAwesome::Sort = "sort";
const char* TulipFontAwesome::SortAlphaAsc = "sort-alpha-asc";
const char* TulipFontAwesome::SortAlphaDesc = "sort-alpha-desc";
const char* TulipFontAwesome::SortAmountAsc = "sort-amount-asc";
const char* TulipFontAwesome::SortAmountDesc = "sort-amount-desc";
const char* TulipFontAwesome::SortAsc = "sort-asc";
const char* TulipFontAwesome::SortDesc = "sort-desc";
const char* TulipFontAwesome::SortDown = "sort-down";
const char* TulipFontAwesome::SortNumericAsc = "sort-numeric-asc";
const char* TulipFontAwesome::SortNumericDesc = "sort-numeric-desc";
const char* TulipFontAwesome::SortUp = "sort-up";
const char* TulipFontAwesome::Soundcloud = "soundcloud";
const char* TulipFontAwesome::SpaceShuttle = "space-shuttle";
const char* TulipFontAwesome::Spinner = "spinner";
const char* TulipFontAwesome::Spoon = "spoon";
const char* TulipFontAwesome::Spotify = "spotify";
const char* TulipFontAwesome::Square = "square";
const char* TulipFontAwesome::SquareO = "square-o";
const char* TulipFontAwesome::StackExchange = "stack-exchange";
const char* TulipFontAwesome::StackOverflow = "stack-overflow";
const char* TulipFontAwesome::Star = "star";
const char* TulipFontAwesome::StarHalf = "star-half";
const char* TulipFontAwesome::StarHalfEmpty = "star-half-empty";
const char* TulipFontAwesome::StarHalfFull = "star-half-full";
const char* TulipFontAwesome::StarHalfO = "star-half-o";
const char* TulipFontAwesome::StarO = "star-o";
const char* TulipFontAwesome::Steam = "steam";
const char* TulipFontAwesome::SteamSquare = "steam-square";
const char* TulipFontAwesome::StepBackward = "step-backward";
const char* TulipFontAwesome::StepForward = "step-forward";
const char* TulipFontAwesome::Stethoscope = "stethoscope";
const char* TulipFontAwesome::Stop = "stop";
const char* TulipFontAwesome::StreetView = "street-view";
const char* TulipFontAwesome::Strikethrough = "strikethrough";
const char* TulipFontAwesome::Stumbleupon = "stumbleupon";
const char* TulipFontAwesome::StumbleuponCircle = "stumbleupon-circle";
const char* TulipFontAwesome::Subscript = "subscript";
const char* TulipFontAwesome::Subway = "subway";
const char* TulipFontAwesome::Suitcase = "suitcase";
const char* TulipFontAwesome::SunO = "sun-o";
const char* TulipFontAwesome::Superscript = "superscript";
const char* TulipFontAwesome::Support = "support";
const char* TulipFontAwesome::Table = "table";
const char* TulipFontAwesome::Tablet = "tablet";
const char* TulipFontAwesome::Tachometer = "tachometer";
const char* TulipFontAwesome::Tag = "tag";
const char* TulipFontAwesome::Tags = "tags";
const char* TulipFontAwesome::Tasks = "tasks";
const char* TulipFontAwesome::Taxi = "taxi";
const char* TulipFontAwesome::TencentWeibo = "tencent-weibo";
const char* TulipFontAwesome::Terminal = "terminal";
const char* TulipFontAwesome::TextHeight = "text-height";
const char* TulipFontAwesome::TextWidth = "text-width";
const char* TulipFontAwesome::Th = "th";
const char* TulipFontAwesome::ThLarge = "th-large";
const char* TulipFontAwesome::ThList = "th-list";
const char* TulipFontAwesome::ThumbTack = "thumb-tack";
const char* TulipFontAwesome::ThumbsDown = "thumbs-down";
const char* TulipFontAwesome::ThumbsODown = "thumbs-o-down";
const char* TulipFontAwesome::ThumbsOUp = "thumbs-o-up";
const char* TulipFontAwesome::ThumbsUp = "thumbs-up";
const char* TulipFontAwesome::Ticket = "ticket";
const char* TulipFontAwesome::Times = "times";
const char* TulipFontAwesome::TimesCircle = "times-circle";
const char* TulipFontAwesome::TimesCircleO = "times-circle-o";
const char* TulipFontAwesome::Tint = "tint";
const char* TulipFontAwesome::ToggleDown = "toggle-down";
const char* TulipFontAwesome::ToggleLeft = "toggle-left";
const char* TulipFontAwesome::ToggleOff = "toggle-off";
const char* TulipFontAwesome::ToggleOn = "toggle-on";
const char* TulipFontAwesome::ToggleRight = "toggle-right";
const char* TulipFontAwesome::ToggleUp = "toggle-up";
const char* TulipFontAwesome::Train = "train";
const char* TulipFontAwesome::Transgender = "transgender";
const char* TulipFontAwesome::TransgenderAlt = "transgender-alt";
const char* TulipFontAwesome::Trash = "trash";
const char* TulipFontAwesome::TrashO = "trash-o";
const char* TulipFontAwesome::Tree = "tree";
const char* TulipFontAwesome::Trello = "trello";
const char* TulipFontAwesome::Trophy = "trophy";
const char* TulipFontAwesome::Truck = "truck";
const char* TulipFontAwesome::Try = "try";
const char* TulipFontAwesome::Tty = "tty";
const char* TulipFontAwesome::Tumblr = "tumblr";
const char* TulipFontAwesome::TumblrSquare = "tumblr-square";
const char* TulipFontAwesome::TurkishLira = "turkish-lira";
const char* TulipFontAwesome::Twitch = "twitch";
const char* TulipFontAwesome::Twitter = "twitter";
const char* TulipFontAwesome::TwitterSquare = "twitter-square";
const char* TulipFontAwesome::Umbrella = "umbrella";
const char* TulipFontAwesome::Underline = "underline";
const char* TulipFontAwesome::Undo = "undo";
const char* TulipFontAwesome::University = "university";
const char* TulipFontAwesome::Unlink = "unlink";
const char* TulipFontAwesome::Unlock = "unlock";
const char* TulipFontAwesome::UnlockAlt = "unlock-alt";
const char* TulipFontAwesome::Unsorted = "unsorted";
const char* TulipFontAwesome::Upload = "upload";
const char* TulipFontAwesome::Usd = "usd";
const char* TulipFontAwesome::User = "user";
const char* TulipFontAwesome::UserMd = "user-md";
const char* TulipFontAwesome::UserPlus = "user-plus";
const char* TulipFontAwesome::UserSecret = "user-secret";
const char* TulipFontAwesome::UserTimes = "user-times";
const char* TulipFontAwesome::Users = "users";
const char* TulipFontAwesome::Venus = "venus";
const char* TulipFontAwesome::VenusDouble = "venus-double";
const char* TulipFontAwesome::VenusMars = "venus-mars";
const char* TulipFontAwesome::Viacoin = "viacoin";
const char* TulipFontAwesome::VideoCamera = "video-camera";
const char* TulipFontAwesome::VimeoSquare = "vimeo-square";
const char* TulipFontAwesome::Vine = "vine";
const char* TulipFontAwesome::Vk = "vk";
const char* TulipFontAwesome::VolumeDown = "volume-down";
const char* TulipFontAwesome::VolumeOff = "volume-off";
const char* TulipFontAwesome::VolumeUp = "volume-up";
const char* TulipFontAwesome::Warning = "warning";
const char* TulipFontAwesome::Wechat = "wechat";
const char* TulipFontAwesome::Weibo = "weibo";
const char* TulipFontAwesome::Weixin = "weixin";
const char* TulipFontAwesome::Whatsapp = "whatsapp";
const char* TulipFontAwesome::Wheelchair = "wheelchair";
const char* TulipFontAwesome::Wifi = "wifi";
const char* TulipFontAwesome::Windows = "windows";
const char* TulipFontAwesome::Won = "won";
const char* TulipFontAwesome::Wordpress = "wordpress";
const char* TulipFontAwesome::Wrench = "wrench";
const char* TulipFontAwesome::Xing = "xing";
const char* TulipFontAwesome::XingSquare = "xing-square";
const char* TulipFontAwesome::Yahoo = "yahoo";
const char* TulipFontAwesome::Yelp = "yelp";
const char* TulipFontAwesome::Yen = "yen";
const char* TulipFontAwesome::Youtube = "youtube";
const char* TulipFontAwesome::YoutubePlay = "youtube-play";
const char* TulipFontAwesome::YoutubeSquare = "youtube-square";

const char* TulipFontAwesome::Yc = "yc";
const char* TulipFontAwesome::YCombinator = "y-combinator";
const char* TulipFontAwesome::OptinMonster = "optin-monster";
const char* TulipFontAwesome::Opencart = "opencart";
const char* TulipFontAwesome::Expeditedssl = "expeditedssl";
const char* TulipFontAwesome::Battery4 = "battery-4";
const char* TulipFontAwesome::BatteryFull = "battery-full";
const char* TulipFontAwesome::Battery3 = "battery-3";
const char* TulipFontAwesome::BatteryThreeQuarters = "battery-three-quarters";
const char* TulipFontAwesome::Battery2 = "battery-2";
const char* TulipFontAwesome::BatteryHalf = "battery-half";
const char* TulipFontAwesome::Battery1 = "battery-1";
const char* TulipFontAwesome::BatteryQuarter = "battery-quarter";
const char* TulipFontAwesome::Battery0 = "battery-0";
const char* TulipFontAwesome::BatteryEmpty = "battery-empty";
const char* TulipFontAwesome::MousePointer = "mouse-pointer";
const char* TulipFontAwesome::ICursor = "i-cursor";
const char* TulipFontAwesome::ObjectGroup = "object-group";
const char* TulipFontAwesome::ObjectUngroup = "object-ungroup";
const char* TulipFontAwesome::StickyNote = "sticky-note";
const char* TulipFontAwesome::StickyNoteO = "sticky-note-o";
const char* TulipFontAwesome::CcJcb = "cc-jcb";
const char* TulipFontAwesome::CcDinersClub = "cc-diners-club";
const char* TulipFontAwesome::Clone = "clone";
const char* TulipFontAwesome::BalanceScale = "balance-scale";
const char* TulipFontAwesome::HourglassO = "hourglass-o";
const char* TulipFontAwesome::Hourglass1 = "hourglass-1";
const char* TulipFontAwesome::HourglassStart = "hourglass-start";
const char* TulipFontAwesome::Hourglass2 = "hourglass-2";
const char* TulipFontAwesome::HourglassHalf = "hourglass-half";
const char* TulipFontAwesome::Hourglass3 = "hourglass-3";
const char* TulipFontAwesome::HourglassEnd = "hourglass-end";
const char* TulipFontAwesome::Hourglass = "hourglass";
const char* TulipFontAwesome::HandGrabO = "hand-grab-o";
const char* TulipFontAwesome::HandRockO = "hand-rock-o";
const char* TulipFontAwesome::HandStopO = "hand-stop-o";
const char* TulipFontAwesome::HandPaperO = "hand-paper-o";
const char* TulipFontAwesome::HandScissorsO = "hand-scissors-o";
const char* TulipFontAwesome::HandLizardO = "hand-lizard-o";
const char* TulipFontAwesome::HandSpockO = "hand-spock-o";
const char* TulipFontAwesome::HandPointerO = "hand-pointer-o";
const char* TulipFontAwesome::HandPeaceO = "hand-peace-o";
const char* TulipFontAwesome::Trademark = "trademark";
const char* TulipFontAwesome::Registered = "registered";
const char* TulipFontAwesome::CreativeCommons = "creative-commons";
const char* TulipFontAwesome::Gg = "gg";
const char* TulipFontAwesome::GgCircle = "gg-circle";
const char* TulipFontAwesome::Tripadvisor = "tripadvisor";
const char* TulipFontAwesome::Odnoklassniki = "odnoklassniki";
const char* TulipFontAwesome::OdnoklassnikiSquare = "odnoklassniki-square";
const char* TulipFontAwesome::GetPocket = "get-pocket";
const char* TulipFontAwesome::WikipediaW = "wikipedia-w";
const char* TulipFontAwesome::Safari = "safari";
const char* TulipFontAwesome::Chrome = "chrome";
const char* TulipFontAwesome::Firefox = "firefox";
const char* TulipFontAwesome::Opera = "opera";
const char* TulipFontAwesome::InternetExplorer = "internet-explorer";
const char* TulipFontAwesome::Tv = "tv";
const char* TulipFontAwesome::Television = "television";
const char* TulipFontAwesome::Contao = "contao";
const char* TulipFontAwesome::Px500 = "500px";
const char* TulipFontAwesome::Amazon = "amazon";
const char* TulipFontAwesome::CalendarPlusO = "calendar-plus-o";
const char* TulipFontAwesome::CalendarMinusO = "calendar-minus-o";
const char* TulipFontAwesome::CalendarTimesO = "calendar-times-o";
const char* TulipFontAwesome::CalendarCheckO = "calendar-check-o";
const char* TulipFontAwesome::Industry = "industry";
const char* TulipFontAwesome::MapPin = "map-pin";
const char* TulipFontAwesome::MapSigns = "map-signs";
const char* TulipFontAwesome::MapO = "map-o";
const char* TulipFontAwesome::Map = "map";
const char* TulipFontAwesome::Commenting = "commenting";
const char* TulipFontAwesome::CommentingO = "commenting-o";
const char* TulipFontAwesome::Houzz = "houzz";
const char* TulipFontAwesome::Vimeo = "vimeo";
const char* TulipFontAwesome::BlackTie = "black-tie";
const char* TulipFontAwesome::Fonticons = "fonticons";



struct cmpCharPtr {
  bool operator()(const char *s1, const char *s2) const {
    return strcmp(s1, s2) < 0;
  }
};
static map<const char*, vector<unsigned int>, cmpCharPtr> fontAwesomeIconCodePoint;
static vector<std::string> fontAwesomeIconsNames;

static void addIconCodePoint(const char *iconName, unsigned int codePoint) {
  fontAwesomeIconCodePoint[iconName].push_back(codePoint);
}

static void initFontAwesomeIconCodePoints() {
  addIconCodePoint(TulipFontAwesome::Adjust, 0xf042);
  addIconCodePoint(TulipFontAwesome::Adn, 0xf170);
  addIconCodePoint(TulipFontAwesome::AlignCenter, 0xf037);
  addIconCodePoint(TulipFontAwesome::AlignJustify, 0xf039);
  addIconCodePoint(TulipFontAwesome::AlignLeft, 0xf036);
  addIconCodePoint(TulipFontAwesome::AlignRight, 0xf038);
  addIconCodePoint(TulipFontAwesome::Ambulance, 0xf0f9);
  addIconCodePoint(TulipFontAwesome::Anchor, 0xf13d);
  addIconCodePoint(TulipFontAwesome::Android, 0xf17b);
  addIconCodePoint(TulipFontAwesome::Angellist, 0xf209);
  addIconCodePoint(TulipFontAwesome::AngleDoubleDown, 0xf103);
  addIconCodePoint(TulipFontAwesome::AngleDoubleLeft, 0xf100);
  addIconCodePoint(TulipFontAwesome::AngleDoubleRight, 0xf101);
  addIconCodePoint(TulipFontAwesome::AngleDoubleUp, 0xf102);
  addIconCodePoint(TulipFontAwesome::AngleDown, 0xf107);
  addIconCodePoint(TulipFontAwesome::AngleLeft, 0xf104);
  addIconCodePoint(TulipFontAwesome::AngleRight, 0xf105);
  addIconCodePoint(TulipFontAwesome::AngleUp, 0xf106);
  addIconCodePoint(TulipFontAwesome::Apple, 0xf179);
  addIconCodePoint(TulipFontAwesome::Archive, 0xf187);
  addIconCodePoint(TulipFontAwesome::AreaChart, 0xf1fe);
  addIconCodePoint(TulipFontAwesome::ArrowCircleDown, 0xf0ab);
  addIconCodePoint(TulipFontAwesome::ArrowCircleLeft, 0xf0a8);
  addIconCodePoint(TulipFontAwesome::ArrowCircleODown, 0xf01a);
  addIconCodePoint(TulipFontAwesome::ArrowCircleOLeft, 0xf190);
  addIconCodePoint(TulipFontAwesome::ArrowCircleORight, 0xf18e);
  addIconCodePoint(TulipFontAwesome::ArrowCircleOUp, 0xf01b);
  addIconCodePoint(TulipFontAwesome::ArrowCircleRight, 0xf0a9);
  addIconCodePoint(TulipFontAwesome::ArrowCircleUp, 0xf0aa);
  addIconCodePoint(TulipFontAwesome::ArrowDown, 0xf063);
  addIconCodePoint(TulipFontAwesome::ArrowLeft, 0xf060);
  addIconCodePoint(TulipFontAwesome::ArrowRight, 0xf061);
  addIconCodePoint(TulipFontAwesome::ArrowUp, 0xf062);
  addIconCodePoint(TulipFontAwesome::Arrows, 0xf047);
  addIconCodePoint(TulipFontAwesome::ArrowsAlt, 0xf0b2);
  addIconCodePoint(TulipFontAwesome::ArrowsH, 0xf07e);
  addIconCodePoint(TulipFontAwesome::ArrowsV, 0xf07d);
  addIconCodePoint(TulipFontAwesome::Asterisk, 0xf069);
  addIconCodePoint(TulipFontAwesome::At, 0xf1fa);
  addIconCodePoint(TulipFontAwesome::Automobile, 0xf1b9);
  addIconCodePoint(TulipFontAwesome::Backward, 0xf04a);
  addIconCodePoint(TulipFontAwesome::Ban, 0xf05e);
  addIconCodePoint(TulipFontAwesome::Bank, 0xf19c);
  addIconCodePoint(TulipFontAwesome::BarChart, 0xf080);
  addIconCodePoint(TulipFontAwesome::BarChartO, 0xf080);
  addIconCodePoint(TulipFontAwesome::Barcode, 0xf02a);
  addIconCodePoint(TulipFontAwesome::Bars, 0xf0c9);
  addIconCodePoint(TulipFontAwesome::Bed, 0xf236);
  addIconCodePoint(TulipFontAwesome::Beer, 0xf0fc);
  addIconCodePoint(TulipFontAwesome::Behance, 0xf1b4);
  addIconCodePoint(TulipFontAwesome::BehanceSquare, 0xf1b5);
  addIconCodePoint(TulipFontAwesome::Bell, 0xf0f3);
  addIconCodePoint(TulipFontAwesome::BellO, 0xf0a2);
  addIconCodePoint(TulipFontAwesome::BellSlash, 0xf1f6);
  addIconCodePoint(TulipFontAwesome::BellSlashO, 0xf1f7);
  addIconCodePoint(TulipFontAwesome::Bicycle, 0xf206);
  addIconCodePoint(TulipFontAwesome::Binoculars, 0xf1e5);
  addIconCodePoint(TulipFontAwesome::BirthdayCake, 0xf1fd);
  addIconCodePoint(TulipFontAwesome::Bitbucket, 0xf171);
  addIconCodePoint(TulipFontAwesome::BitbucketSquare, 0xf172);
  addIconCodePoint(TulipFontAwesome::Bitcoin, 0xf15a);
  addIconCodePoint(TulipFontAwesome::Bold, 0xf032);
  addIconCodePoint(TulipFontAwesome::Bolt, 0xf0e7);
  addIconCodePoint(TulipFontAwesome::Bomb, 0xf1e2);
  addIconCodePoint(TulipFontAwesome::Book, 0xf02d);
  addIconCodePoint(TulipFontAwesome::Bookmark, 0xf02e);
  addIconCodePoint(TulipFontAwesome::BookmarkO, 0xf097);
  addIconCodePoint(TulipFontAwesome::Briefcase, 0xf0b1);
  addIconCodePoint(TulipFontAwesome::Btc, 0xf15a);
  addIconCodePoint(TulipFontAwesome::Bug, 0xf188);
  addIconCodePoint(TulipFontAwesome::Building, 0xf1ad);
  addIconCodePoint(TulipFontAwesome::BuildingO, 0xf0f7);
  addIconCodePoint(TulipFontAwesome::Bullhorn, 0xf0a1);
  addIconCodePoint(TulipFontAwesome::Bullseye, 0xf140);
  addIconCodePoint(TulipFontAwesome::Bus, 0xf207);
  addIconCodePoint(TulipFontAwesome::Buysellads, 0xf20d);
  addIconCodePoint(TulipFontAwesome::Cab, 0xf1ba);
  addIconCodePoint(TulipFontAwesome::Calculator, 0xf1ec);
  addIconCodePoint(TulipFontAwesome::Calendar, 0xf073);
  addIconCodePoint(TulipFontAwesome::CalendarO, 0xf133);
  addIconCodePoint(TulipFontAwesome::Camera, 0xf030);
  addIconCodePoint(TulipFontAwesome::CameraRetro, 0xf083);
  addIconCodePoint(TulipFontAwesome::Car, 0xf1b9);
  addIconCodePoint(TulipFontAwesome::CaretDown, 0xf0d7);
  addIconCodePoint(TulipFontAwesome::CaretLeft, 0xf0d9);
  addIconCodePoint(TulipFontAwesome::CaretRight, 0xf0da);
  addIconCodePoint(TulipFontAwesome::CaretSquareODown, 0xf150);
  addIconCodePoint(TulipFontAwesome::CaretSquareOLeft, 0xf191);
  addIconCodePoint(TulipFontAwesome::CaretSquareORight, 0xf152);
  addIconCodePoint(TulipFontAwesome::CaretSquareOUp, 0xf151);
  addIconCodePoint(TulipFontAwesome::CaretUp, 0xf0d8);
  addIconCodePoint(TulipFontAwesome::CartArrowDown, 0xf218);
  addIconCodePoint(TulipFontAwesome::CartPlus, 0xf217);
  addIconCodePoint(TulipFontAwesome::Cc, 0xf20a);
  addIconCodePoint(TulipFontAwesome::CcAmex, 0xf1f3);
  addIconCodePoint(TulipFontAwesome::CcDiscover, 0xf1f2);
  addIconCodePoint(TulipFontAwesome::CcMastercard, 0xf1f1);
  addIconCodePoint(TulipFontAwesome::CcPaypal, 0xf1f4);
  addIconCodePoint(TulipFontAwesome::CcStripe, 0xf1f5);
  addIconCodePoint(TulipFontAwesome::CcVisa, 0xf1f0);
  addIconCodePoint(TulipFontAwesome::Certificate, 0xf0a3);
  addIconCodePoint(TulipFontAwesome::Chain, 0xf0c1);
  addIconCodePoint(TulipFontAwesome::ChainBroken, 0xf127);
  addIconCodePoint(TulipFontAwesome::Check, 0xf00c);
  addIconCodePoint(TulipFontAwesome::CheckCircle, 0xf058);
  addIconCodePoint(TulipFontAwesome::CheckCircleO, 0xf05d);
  addIconCodePoint(TulipFontAwesome::CheckSquare, 0xf14a);
  addIconCodePoint(TulipFontAwesome::CheckSquareO, 0xf046);
  addIconCodePoint(TulipFontAwesome::ChevronCircleDown, 0xf13a);
  addIconCodePoint(TulipFontAwesome::ChevronCircleLeft, 0xf137);
  addIconCodePoint(TulipFontAwesome::ChevronCircleRight, 0xf138);
  addIconCodePoint(TulipFontAwesome::ChevronCircleUp, 0xf139);
  addIconCodePoint(TulipFontAwesome::ChevronDown, 0xf078);
  addIconCodePoint(TulipFontAwesome::ChevronLeft, 0xf053);
  addIconCodePoint(TulipFontAwesome::ChevronRight, 0xf054);
  addIconCodePoint(TulipFontAwesome::ChevronUp, 0xf077);
  addIconCodePoint(TulipFontAwesome::Child, 0xf1ae);
  addIconCodePoint(TulipFontAwesome::Circle, 0xf111);
  addIconCodePoint(TulipFontAwesome::CircleO, 0xf10c);
  addIconCodePoint(TulipFontAwesome::CircleONotch, 0xf1ce);
  addIconCodePoint(TulipFontAwesome::CircleThin, 0xf1db);
  addIconCodePoint(TulipFontAwesome::Clipboard, 0xf0ea);
  addIconCodePoint(TulipFontAwesome::ClockO, 0xf017);
  addIconCodePoint(TulipFontAwesome::Close, 0xf00d);
  addIconCodePoint(TulipFontAwesome::Cloud, 0xf0c2);
  addIconCodePoint(TulipFontAwesome::CloudDownload, 0xf0ed);
  addIconCodePoint(TulipFontAwesome::CloudUpload, 0xf0ee);
  addIconCodePoint(TulipFontAwesome::Cny, 0xf157);
  addIconCodePoint(TulipFontAwesome::Code, 0xf121);
  addIconCodePoint(TulipFontAwesome::CodeFork, 0xf126);
  addIconCodePoint(TulipFontAwesome::Codepen, 0xf1cb);
  addIconCodePoint(TulipFontAwesome::Coffee, 0xf0f4);
  addIconCodePoint(TulipFontAwesome::Cog, 0xf013);
  addIconCodePoint(TulipFontAwesome::Cogs, 0xf085);
  addIconCodePoint(TulipFontAwesome::Columns, 0xf0db);
  addIconCodePoint(TulipFontAwesome::Comment, 0xf075);
  addIconCodePoint(TulipFontAwesome::CommentO, 0xf0e5);
  addIconCodePoint(TulipFontAwesome::Comments, 0xf086);
  addIconCodePoint(TulipFontAwesome::CommentsO, 0xf0e6);
  addIconCodePoint(TulipFontAwesome::Compass, 0xf14e);
  addIconCodePoint(TulipFontAwesome::Compress, 0xf066);
  addIconCodePoint(TulipFontAwesome::Connectdevelop, 0xf20e);
  addIconCodePoint(TulipFontAwesome::Copy, 0xf0c5);
  addIconCodePoint(TulipFontAwesome::Copyright, 0xf1f9);
  addIconCodePoint(TulipFontAwesome::CreditCard, 0xf09d);
  addIconCodePoint(TulipFontAwesome::Crop, 0xf125);
  addIconCodePoint(TulipFontAwesome::Crosshairs, 0xf05b);
  addIconCodePoint(TulipFontAwesome::Css3, 0xf13c);
  addIconCodePoint(TulipFontAwesome::Cube, 0xf1b2);
  addIconCodePoint(TulipFontAwesome::Cubes, 0xf1b3);
  addIconCodePoint(TulipFontAwesome::Cut, 0xf0c4);
  addIconCodePoint(TulipFontAwesome::Cutlery, 0xf0f5);
  addIconCodePoint(TulipFontAwesome::Dashboard, 0xf0e4);
  addIconCodePoint(TulipFontAwesome::Dashcube, 0xf210);
  addIconCodePoint(TulipFontAwesome::Database, 0xf1c0);
  addIconCodePoint(TulipFontAwesome::Dedent, 0xf03b);
  addIconCodePoint(TulipFontAwesome::Delicious, 0xf1a5);
  addIconCodePoint(TulipFontAwesome::Desktop, 0xf108);
  addIconCodePoint(TulipFontAwesome::Deviantart, 0xf1bd);
  addIconCodePoint(TulipFontAwesome::Diamond, 0xf219);
  addIconCodePoint(TulipFontAwesome::Digg, 0xf1a6);
  addIconCodePoint(TulipFontAwesome::Dollar, 0xf155);
  addIconCodePoint(TulipFontAwesome::DotCircleO, 0xf192);
  addIconCodePoint(TulipFontAwesome::Download, 0xf019);
  addIconCodePoint(TulipFontAwesome::Dribbble, 0xf17d);
  addIconCodePoint(TulipFontAwesome::Dropbox, 0xf16b);
  addIconCodePoint(TulipFontAwesome::Drupal, 0xf1a9);
  addIconCodePoint(TulipFontAwesome::Edit, 0xf044);
  addIconCodePoint(TulipFontAwesome::Eject, 0xf052);
  addIconCodePoint(TulipFontAwesome::EllipsisH, 0xf141);
  addIconCodePoint(TulipFontAwesome::EllipsisV, 0xf142);
  addIconCodePoint(TulipFontAwesome::Empire, 0xf1d1);
  addIconCodePoint(TulipFontAwesome::Envelope, 0xf0e0);
  addIconCodePoint(TulipFontAwesome::EnvelopeO, 0xf003);
  addIconCodePoint(TulipFontAwesome::EnvelopeSquare, 0xf199);
  addIconCodePoint(TulipFontAwesome::Eraser, 0xf12d);
  addIconCodePoint(TulipFontAwesome::Eur, 0xf153);
  addIconCodePoint(TulipFontAwesome::Euro, 0xf153);
  addIconCodePoint(TulipFontAwesome::Exchange, 0xf0ec);
  addIconCodePoint(TulipFontAwesome::Exclamation, 0xf12a);
  addIconCodePoint(TulipFontAwesome::ExclamationCircle, 0xf06a);
  addIconCodePoint(TulipFontAwesome::ExclamationTriangle, 0xf071);
  addIconCodePoint(TulipFontAwesome::Expand, 0xf065);
  addIconCodePoint(TulipFontAwesome::ExternalLink, 0xf08e);
  addIconCodePoint(TulipFontAwesome::ExternalLinkSquare, 0xf14c);
  addIconCodePoint(TulipFontAwesome::Eye, 0xf06e);
  addIconCodePoint(TulipFontAwesome::EyeSlash, 0xf070);
  addIconCodePoint(TulipFontAwesome::Eyedropper, 0xf1fb);
  addIconCodePoint(TulipFontAwesome::Facebook, 0xf09a);
  addIconCodePoint(TulipFontAwesome::FacebookF, 0xf09a);
  addIconCodePoint(TulipFontAwesome::FacebookOfficial, 0xf230);
  addIconCodePoint(TulipFontAwesome::FacebookSquare, 0xf082);
  addIconCodePoint(TulipFontAwesome::FastBackward, 0xf049);
  addIconCodePoint(TulipFontAwesome::FastForward, 0xf050);
  addIconCodePoint(TulipFontAwesome::Fax, 0xf1ac);
  addIconCodePoint(TulipFontAwesome::Female, 0xf182);
  addIconCodePoint(TulipFontAwesome::FighterJet, 0xf0fb);
  addIconCodePoint(TulipFontAwesome::File, 0xf15b);
  addIconCodePoint(TulipFontAwesome::FileArchiveO, 0xf1c6);
  addIconCodePoint(TulipFontAwesome::FileAudioO, 0xf1c7);
  addIconCodePoint(TulipFontAwesome::FileCodeO, 0xf1c9);
  addIconCodePoint(TulipFontAwesome::FileExcelO, 0xf1c3);
  addIconCodePoint(TulipFontAwesome::FileImageO, 0xf1c5);
  addIconCodePoint(TulipFontAwesome::FileMovieO, 0xf1c8);
  addIconCodePoint(TulipFontAwesome::FileO, 0xf016);
  addIconCodePoint(TulipFontAwesome::FilePdfO, 0xf1c1);
  addIconCodePoint(TulipFontAwesome::FilePhotoO, 0xf1c5);
  addIconCodePoint(TulipFontAwesome::FilePictureO, 0xf1c5);
  addIconCodePoint(TulipFontAwesome::FilePowerpointO, 0xf1c4);
  addIconCodePoint(TulipFontAwesome::FileSoundO, 0xf1c7);
  addIconCodePoint(TulipFontAwesome::FileText, 0xf15c);
  addIconCodePoint(TulipFontAwesome::FileTextO, 0xf0f6);
  addIconCodePoint(TulipFontAwesome::FileVideoO, 0xf1c8);
  addIconCodePoint(TulipFontAwesome::FileWordO, 0xf1c2);
  addIconCodePoint(TulipFontAwesome::FileZipO, 0xf1c6);
  addIconCodePoint(TulipFontAwesome::FilesO, 0xf0c5);
  addIconCodePoint(TulipFontAwesome::Film, 0xf008);
  addIconCodePoint(TulipFontAwesome::Filter, 0xf0b0);
  addIconCodePoint(TulipFontAwesome::Fire, 0xf06d);
  addIconCodePoint(TulipFontAwesome::FireExtinguisher, 0xf134);
  addIconCodePoint(TulipFontAwesome::Flag, 0xf024);
  addIconCodePoint(TulipFontAwesome::FlagCheckered, 0xf11e);
  addIconCodePoint(TulipFontAwesome::FlagO, 0xf11d);
  addIconCodePoint(TulipFontAwesome::Flash, 0xf0e7);
  addIconCodePoint(TulipFontAwesome::Flask, 0xf0c3);
  addIconCodePoint(TulipFontAwesome::Flickr, 0xf16e);
  addIconCodePoint(TulipFontAwesome::FloppyO, 0xf0c7);
  addIconCodePoint(TulipFontAwesome::Folder, 0xf07b);
  addIconCodePoint(TulipFontAwesome::FolderO, 0xf114);
  addIconCodePoint(TulipFontAwesome::FolderOpen, 0xf07c);
  addIconCodePoint(TulipFontAwesome::FolderOpenO, 0xf115);
  addIconCodePoint(TulipFontAwesome::Font, 0xf031);
  addIconCodePoint(TulipFontAwesome::Forumbee, 0xf211);
  addIconCodePoint(TulipFontAwesome::Forward, 0xf04e);
  addIconCodePoint(TulipFontAwesome::Foursquare, 0xf180);
  addIconCodePoint(TulipFontAwesome::FrownO, 0xf119);
  addIconCodePoint(TulipFontAwesome::FutbolO, 0xf1e3);
  addIconCodePoint(TulipFontAwesome::Gamepad, 0xf11b);
  addIconCodePoint(TulipFontAwesome::Gavel, 0xf0e3);
  addIconCodePoint(TulipFontAwesome::Gbp, 0xf154);
  addIconCodePoint(TulipFontAwesome::Ge, 0xf1d1);
  addIconCodePoint(TulipFontAwesome::Gear, 0xf013);
  addIconCodePoint(TulipFontAwesome::Gears, 0xf085);
  addIconCodePoint(TulipFontAwesome::Genderless, 0xf1db);
  addIconCodePoint(TulipFontAwesome::Gift, 0xf06b);
  addIconCodePoint(TulipFontAwesome::Git, 0xf1d3);
  addIconCodePoint(TulipFontAwesome::GitSquare, 0xf1d2);
  addIconCodePoint(TulipFontAwesome::Github, 0xf09b);
  addIconCodePoint(TulipFontAwesome::GithubAlt, 0xf113);
  addIconCodePoint(TulipFontAwesome::GithubSquare, 0xf092);
  addIconCodePoint(TulipFontAwesome::Gittip, 0xf184);
  addIconCodePoint(TulipFontAwesome::Glass, 0xf000);
  addIconCodePoint(TulipFontAwesome::Globe, 0xf0ac);
  addIconCodePoint(TulipFontAwesome::Google, 0xf1a0);
  addIconCodePoint(TulipFontAwesome::GooglePlus, 0xf0d5);
  addIconCodePoint(TulipFontAwesome::GooglePlusSquare, 0xf0d4);
  addIconCodePoint(TulipFontAwesome::GoogleWallet, 0xf1ee);
  addIconCodePoint(TulipFontAwesome::GraduationCap, 0xf19d);
  addIconCodePoint(TulipFontAwesome::Gratipay, 0xf184);
  addIconCodePoint(TulipFontAwesome::Group, 0xf0c0);
  addIconCodePoint(TulipFontAwesome::HSquare, 0xf0fd);
  addIconCodePoint(TulipFontAwesome::HackerNews, 0xf1d4);
  addIconCodePoint(TulipFontAwesome::HandODown, 0xf0a7);
  addIconCodePoint(TulipFontAwesome::HandOLeft, 0xf0a5);
  addIconCodePoint(TulipFontAwesome::HandORight, 0xf0a4);
  addIconCodePoint(TulipFontAwesome::HandOUp, 0xf0a6);
  addIconCodePoint(TulipFontAwesome::HddO, 0xf0a0);
  addIconCodePoint(TulipFontAwesome::Header, 0xf1dc);
  addIconCodePoint(TulipFontAwesome::Headphones, 0xf025);
  addIconCodePoint(TulipFontAwesome::Heart, 0xf004);
  addIconCodePoint(TulipFontAwesome::HeartO, 0xf08a);
  addIconCodePoint(TulipFontAwesome::Heartbeat, 0xf21e);
  addIconCodePoint(TulipFontAwesome::History, 0xf1da);
  addIconCodePoint(TulipFontAwesome::Home, 0xf015);
  addIconCodePoint(TulipFontAwesome::HospitalO, 0xf0f8);
  addIconCodePoint(TulipFontAwesome::Hotel, 0xf236);
  addIconCodePoint(TulipFontAwesome::Html5, 0xf13b);
  addIconCodePoint(TulipFontAwesome::Ils, 0xf20b);
  addIconCodePoint(TulipFontAwesome::Image, 0xf03e);
  addIconCodePoint(TulipFontAwesome::Inbox, 0xf01c);
  addIconCodePoint(TulipFontAwesome::Indent, 0xf03c);
  addIconCodePoint(TulipFontAwesome::Info, 0xf129);
  addIconCodePoint(TulipFontAwesome::InfoCircle, 0xf05a);
  addIconCodePoint(TulipFontAwesome::Inr, 0xf156);
  addIconCodePoint(TulipFontAwesome::Instagram, 0xf16d);
  addIconCodePoint(TulipFontAwesome::Institution, 0xf19c);
  addIconCodePoint(TulipFontAwesome::Ioxhost, 0xf208);
  addIconCodePoint(TulipFontAwesome::Italic, 0xf033);
  addIconCodePoint(TulipFontAwesome::Joomla, 0xf1aa);
  addIconCodePoint(TulipFontAwesome::Jpy, 0xf157);
  addIconCodePoint(TulipFontAwesome::Jsfiddle, 0xf1cc);
  addIconCodePoint(TulipFontAwesome::Key, 0xf084);
  addIconCodePoint(TulipFontAwesome::KeyboardO, 0xf11c);
  addIconCodePoint(TulipFontAwesome::Krw, 0xf159);
  addIconCodePoint(TulipFontAwesome::Language, 0xf1ab);
  addIconCodePoint(TulipFontAwesome::Laptop, 0xf109);
  addIconCodePoint(TulipFontAwesome::Lastfm, 0xf202);
  addIconCodePoint(TulipFontAwesome::LastfmSquare, 0xf203);
  addIconCodePoint(TulipFontAwesome::Leaf, 0xf06c);
  addIconCodePoint(TulipFontAwesome::Leanpub, 0xf212);
  addIconCodePoint(TulipFontAwesome::Legal, 0xf0e3);
  addIconCodePoint(TulipFontAwesome::LemonO, 0xf094);
  addIconCodePoint(TulipFontAwesome::LevelDown, 0xf149);
  addIconCodePoint(TulipFontAwesome::LevelUp, 0xf148);
  addIconCodePoint(TulipFontAwesome::LifeBouy, 0xf1cd);
  addIconCodePoint(TulipFontAwesome::LifeBuoy, 0xf1cd);
  addIconCodePoint(TulipFontAwesome::LifeRing, 0xf1cd);
  addIconCodePoint(TulipFontAwesome::LifeSaver, 0xf1cd);
  addIconCodePoint(TulipFontAwesome::LightbulbO, 0xf0eb);
  addIconCodePoint(TulipFontAwesome::LineChart, 0xf201);
  addIconCodePoint(TulipFontAwesome::Link, 0xf0c1);
  addIconCodePoint(TulipFontAwesome::Linkedin, 0xf0e1);
  addIconCodePoint(TulipFontAwesome::LinkedinSquare, 0xf08c);
  addIconCodePoint(TulipFontAwesome::Linux, 0xf17c);
  addIconCodePoint(TulipFontAwesome::List, 0xf03a);
  addIconCodePoint(TulipFontAwesome::ListAlt, 0xf022);
  addIconCodePoint(TulipFontAwesome::ListOl, 0xf0cb);
  addIconCodePoint(TulipFontAwesome::ListUl, 0xf0ca);
  addIconCodePoint(TulipFontAwesome::LocationArrow, 0xf124);
  addIconCodePoint(TulipFontAwesome::Lock, 0xf023);
  addIconCodePoint(TulipFontAwesome::LongArrowDown, 0xf175);
  addIconCodePoint(TulipFontAwesome::LongArrowLeft, 0xf177);
  addIconCodePoint(TulipFontAwesome::LongArrowRight, 0xf178);
  addIconCodePoint(TulipFontAwesome::LongArrowUp, 0xf176);
  addIconCodePoint(TulipFontAwesome::Magic, 0xf0d0);
  addIconCodePoint(TulipFontAwesome::Magnet, 0xf076);
  addIconCodePoint(TulipFontAwesome::MailForward, 0xf064);
  addIconCodePoint(TulipFontAwesome::MailReply, 0xf112);
  addIconCodePoint(TulipFontAwesome::MailReplyAll, 0xf122);
  addIconCodePoint(TulipFontAwesome::Male, 0xf183);
  addIconCodePoint(TulipFontAwesome::MapMarker, 0xf041);
  addIconCodePoint(TulipFontAwesome::Mars, 0xf222);
  addIconCodePoint(TulipFontAwesome::MarsDouble, 0xf227);
  addIconCodePoint(TulipFontAwesome::MarsStroke, 0xf229);
  addIconCodePoint(TulipFontAwesome::MarsStrokeH, 0xf22b);
  addIconCodePoint(TulipFontAwesome::MarsStrokeV, 0xf22a);
  addIconCodePoint(TulipFontAwesome::Maxcdn, 0xf136);
  addIconCodePoint(TulipFontAwesome::Meanpath, 0xf20c);
  addIconCodePoint(TulipFontAwesome::Medium, 0xf23a);
  addIconCodePoint(TulipFontAwesome::Medkit, 0xf0fa);
  addIconCodePoint(TulipFontAwesome::MehO, 0xf11a);
  addIconCodePoint(TulipFontAwesome::Mercury, 0xf223);
  addIconCodePoint(TulipFontAwesome::Microphone, 0xf130);
  addIconCodePoint(TulipFontAwesome::MicrophoneSlash, 0xf131);
  addIconCodePoint(TulipFontAwesome::Minus, 0xf068);
  addIconCodePoint(TulipFontAwesome::MinusCircle, 0xf056);
  addIconCodePoint(TulipFontAwesome::MinusSquare, 0xf146);
  addIconCodePoint(TulipFontAwesome::MinusSquareO, 0xf147);
  addIconCodePoint(TulipFontAwesome::Mobile, 0xf10b);
  addIconCodePoint(TulipFontAwesome::MobilePhone, 0xf10b);
  addIconCodePoint(TulipFontAwesome::Money, 0xf0d6);
  addIconCodePoint(TulipFontAwesome::MoonO, 0xf186);
  addIconCodePoint(TulipFontAwesome::MortarBoard, 0xf19d);
  addIconCodePoint(TulipFontAwesome::Motorcycle, 0xf21c);
  addIconCodePoint(TulipFontAwesome::Music, 0xf001);
  addIconCodePoint(TulipFontAwesome::Navicon, 0xf0c9);
  addIconCodePoint(TulipFontAwesome::Neuter, 0xf22c);
  addIconCodePoint(TulipFontAwesome::NewspaperO, 0xf1ea);
  addIconCodePoint(TulipFontAwesome::Openid, 0xf19b);
  addIconCodePoint(TulipFontAwesome::Outdent, 0xf03b);
  addIconCodePoint(TulipFontAwesome::Pagelines, 0xf18c);
  addIconCodePoint(TulipFontAwesome::PaintBrush, 0xf1fc);
  addIconCodePoint(TulipFontAwesome::PaperPlane, 0xf1d8);
  addIconCodePoint(TulipFontAwesome::PaperPlaneO, 0xf1d9);
  addIconCodePoint(TulipFontAwesome::Paperclip, 0xf0c6);
  addIconCodePoint(TulipFontAwesome::Paragraph, 0xf1dd);
  addIconCodePoint(TulipFontAwesome::Paste, 0xf0ea);
  addIconCodePoint(TulipFontAwesome::Pause, 0xf04c);
  addIconCodePoint(TulipFontAwesome::Paw, 0xf1b0);
  addIconCodePoint(TulipFontAwesome::Paypal, 0xf1ed);
  addIconCodePoint(TulipFontAwesome::Pencil, 0xf040);
  addIconCodePoint(TulipFontAwesome::PencilSquare, 0xf14b);
  addIconCodePoint(TulipFontAwesome::PencilSquareO, 0xf044);
  addIconCodePoint(TulipFontAwesome::Phone, 0xf095);
  addIconCodePoint(TulipFontAwesome::PhoneSquare, 0xf098);
  addIconCodePoint(TulipFontAwesome::Photo, 0xf03e);
  addIconCodePoint(TulipFontAwesome::PictureO, 0xf03e);
  addIconCodePoint(TulipFontAwesome::PieChart, 0xf200);
  addIconCodePoint(TulipFontAwesome::PiedPiper, 0xf1a7);
  addIconCodePoint(TulipFontAwesome::PiedPiperAlt, 0xf1a8);
  addIconCodePoint(TulipFontAwesome::Pinterest, 0xf0d2);
  addIconCodePoint(TulipFontAwesome::PinterestP, 0xf231);
  addIconCodePoint(TulipFontAwesome::PinterestSquare, 0xf0d3);
  addIconCodePoint(TulipFontAwesome::Plane, 0xf072);
  addIconCodePoint(TulipFontAwesome::Play, 0xf04b);
  addIconCodePoint(TulipFontAwesome::PlayCircle, 0xf144);
  addIconCodePoint(TulipFontAwesome::PlayCircleO, 0xf01d);
  addIconCodePoint(TulipFontAwesome::Plug, 0xf1e6);
  addIconCodePoint(TulipFontAwesome::Plus, 0xf067);
  addIconCodePoint(TulipFontAwesome::PlusCircle, 0xf055);
  addIconCodePoint(TulipFontAwesome::PlusSquare, 0xf0fe);
  addIconCodePoint(TulipFontAwesome::PlusSquareO, 0xf196);
  addIconCodePoint(TulipFontAwesome::PowerOff, 0xf011);
  addIconCodePoint(TulipFontAwesome::Print, 0xf02f);
  addIconCodePoint(TulipFontAwesome::PuzzlePiece, 0xf12e);
  addIconCodePoint(TulipFontAwesome::Qq, 0xf1d6);
  addIconCodePoint(TulipFontAwesome::Qrcode, 0xf029);
  addIconCodePoint(TulipFontAwesome::Question, 0xf128);
  addIconCodePoint(TulipFontAwesome::QuestionCircle, 0xf059);
  addIconCodePoint(TulipFontAwesome::QuoteLeft, 0xf10d);
  addIconCodePoint(TulipFontAwesome::QuoteRight, 0xf10e);
  addIconCodePoint(TulipFontAwesome::Ra, 0xf1d0);
  addIconCodePoint(TulipFontAwesome::Random, 0xf074);
  addIconCodePoint(TulipFontAwesome::Rebel, 0xf1d0);
  addIconCodePoint(TulipFontAwesome::Recycle, 0xf1b8);
  addIconCodePoint(TulipFontAwesome::Reddit, 0xf1a1);
  addIconCodePoint(TulipFontAwesome::RedditSquare, 0xf1a2);
  addIconCodePoint(TulipFontAwesome::Refresh, 0xf021);
  addIconCodePoint(TulipFontAwesome::Remove, 0xf00d);
  addIconCodePoint(TulipFontAwesome::Renren, 0xf18b);
  addIconCodePoint(TulipFontAwesome::Reorder, 0xf0c9);
  addIconCodePoint(TulipFontAwesome::Repeat, 0xf01e);
  addIconCodePoint(TulipFontAwesome::Reply, 0xf112);
  addIconCodePoint(TulipFontAwesome::ReplyAll, 0xf122);
  addIconCodePoint(TulipFontAwesome::Retweet, 0xf079);
  addIconCodePoint(TulipFontAwesome::Rmb, 0xf157);
  addIconCodePoint(TulipFontAwesome::Road, 0xf018);
  addIconCodePoint(TulipFontAwesome::Rocket, 0xf135);
  addIconCodePoint(TulipFontAwesome::RotateLeft, 0xf0e2);
  addIconCodePoint(TulipFontAwesome::RotateRight, 0xf01e);
  addIconCodePoint(TulipFontAwesome::Rouble, 0xf158);
  addIconCodePoint(TulipFontAwesome::Rss, 0xf09e);
  addIconCodePoint(TulipFontAwesome::RssSquare, 0xf143);
  addIconCodePoint(TulipFontAwesome::Rub, 0xf158);
  addIconCodePoint(TulipFontAwesome::Ruble, 0xf158);
  addIconCodePoint(TulipFontAwesome::Rupee, 0xf156);
  addIconCodePoint(TulipFontAwesome::Save, 0xf0c7);
  addIconCodePoint(TulipFontAwesome::Scissors, 0xf0c4);
  addIconCodePoint(TulipFontAwesome::Search, 0xf002);
  addIconCodePoint(TulipFontAwesome::SearchMinus, 0xf010);
  addIconCodePoint(TulipFontAwesome::SearchPlus, 0xf00e);
  addIconCodePoint(TulipFontAwesome::Sellsy, 0xf213);
  addIconCodePoint(TulipFontAwesome::Send, 0xf1d8);
  addIconCodePoint(TulipFontAwesome::SendO, 0xf1d9);
  addIconCodePoint(TulipFontAwesome::Server, 0xf233);
  addIconCodePoint(TulipFontAwesome::Share, 0xf064);
  addIconCodePoint(TulipFontAwesome::ShareAlt, 0xf1e0);
  addIconCodePoint(TulipFontAwesome::ShareAltSquare, 0xf1e1);
  addIconCodePoint(TulipFontAwesome::ShareSquare, 0xf14d);
  addIconCodePoint(TulipFontAwesome::ShareSquareO, 0xf045);
  addIconCodePoint(TulipFontAwesome::Shekel, 0xf20b);
  addIconCodePoint(TulipFontAwesome::Sheqel, 0xf20b);
  addIconCodePoint(TulipFontAwesome::Shield, 0xf132);
  addIconCodePoint(TulipFontAwesome::Ship, 0xf21a);
  addIconCodePoint(TulipFontAwesome::Shirtsinbulk, 0xf214);
  addIconCodePoint(TulipFontAwesome::ShoppingCart, 0xf07a);
  addIconCodePoint(TulipFontAwesome::SignIn, 0xf090);
  addIconCodePoint(TulipFontAwesome::SignOut, 0xf08b);
  addIconCodePoint(TulipFontAwesome::Signal, 0xf012);
  addIconCodePoint(TulipFontAwesome::Simplybuilt, 0xf215);
  addIconCodePoint(TulipFontAwesome::Sitemap, 0xf0e8);
  addIconCodePoint(TulipFontAwesome::Skyatlas, 0xf216);
  addIconCodePoint(TulipFontAwesome::Skype, 0xf17e);
  addIconCodePoint(TulipFontAwesome::Slack, 0xf198);
  addIconCodePoint(TulipFontAwesome::Sliders, 0xf1de);
  addIconCodePoint(TulipFontAwesome::Slideshare, 0xf1e7);
  addIconCodePoint(TulipFontAwesome::SmileO, 0xf118);
  addIconCodePoint(TulipFontAwesome::SoccerBallO, 0xf1e3);
  addIconCodePoint(TulipFontAwesome::Sort, 0xf0dc);
  addIconCodePoint(TulipFontAwesome::SortAlphaAsc, 0xf15d);
  addIconCodePoint(TulipFontAwesome::SortAlphaDesc, 0xf15e);
  addIconCodePoint(TulipFontAwesome::SortAmountAsc, 0xf160);
  addIconCodePoint(TulipFontAwesome::SortAmountDesc, 0xf161);
  addIconCodePoint(TulipFontAwesome::SortAsc, 0xf0de);
  addIconCodePoint(TulipFontAwesome::SortDesc, 0xf0dd);
  addIconCodePoint(TulipFontAwesome::SortDown, 0xf0dd);
  addIconCodePoint(TulipFontAwesome::SortNumericAsc, 0xf162);
  addIconCodePoint(TulipFontAwesome::SortNumericDesc, 0xf163);
  addIconCodePoint(TulipFontAwesome::SortUp, 0xf0de);
  addIconCodePoint(TulipFontAwesome::Soundcloud, 0xf1be);
  addIconCodePoint(TulipFontAwesome::SpaceShuttle, 0xf197);
  addIconCodePoint(TulipFontAwesome::Spinner, 0xf110);
  addIconCodePoint(TulipFontAwesome::Spoon, 0xf1b1);
  addIconCodePoint(TulipFontAwesome::Spotify, 0xf1bc);
  addIconCodePoint(TulipFontAwesome::Square, 0xf0c8);
  addIconCodePoint(TulipFontAwesome::SquareO, 0xf096);
  addIconCodePoint(TulipFontAwesome::StackExchange, 0xf18d);
  addIconCodePoint(TulipFontAwesome::StackOverflow, 0xf16c);
  addIconCodePoint(TulipFontAwesome::Star, 0xf005);
  addIconCodePoint(TulipFontAwesome::StarHalf, 0xf089);
  addIconCodePoint(TulipFontAwesome::StarHalfEmpty, 0xf123);
  addIconCodePoint(TulipFontAwesome::StarHalfFull, 0xf123);
  addIconCodePoint(TulipFontAwesome::StarHalfO, 0xf123);
  addIconCodePoint(TulipFontAwesome::StarO, 0xf006);
  addIconCodePoint(TulipFontAwesome::Steam, 0xf1b6);
  addIconCodePoint(TulipFontAwesome::SteamSquare, 0xf1b7);
  addIconCodePoint(TulipFontAwesome::StepBackward, 0xf048);
  addIconCodePoint(TulipFontAwesome::StepForward, 0xf051);
  addIconCodePoint(TulipFontAwesome::Stethoscope, 0xf0f1);
  addIconCodePoint(TulipFontAwesome::Stop, 0xf04d);
  addIconCodePoint(TulipFontAwesome::StreetView, 0xf21d);
  addIconCodePoint(TulipFontAwesome::Strikethrough, 0xf0cc);
  addIconCodePoint(TulipFontAwesome::Stumbleupon, 0xf1a4);
  addIconCodePoint(TulipFontAwesome::StumbleuponCircle, 0xf1a3);
  addIconCodePoint(TulipFontAwesome::Subscript, 0xf12c);
  addIconCodePoint(TulipFontAwesome::Subway, 0xf239);
  addIconCodePoint(TulipFontAwesome::Suitcase, 0xf0f2);
  addIconCodePoint(TulipFontAwesome::SunO, 0xf185);
  addIconCodePoint(TulipFontAwesome::Superscript, 0xf12b);
  addIconCodePoint(TulipFontAwesome::Support, 0xf1cd);
  addIconCodePoint(TulipFontAwesome::Table, 0xf0ce);
  addIconCodePoint(TulipFontAwesome::Tablet, 0xf10a);
  addIconCodePoint(TulipFontAwesome::Tachometer, 0xf0e4);
  addIconCodePoint(TulipFontAwesome::Tag, 0xf02b);
  addIconCodePoint(TulipFontAwesome::Tags, 0xf02c);
  addIconCodePoint(TulipFontAwesome::Tasks, 0xf0ae);
  addIconCodePoint(TulipFontAwesome::Taxi, 0xf1ba);
  addIconCodePoint(TulipFontAwesome::TencentWeibo, 0xf1d5);
  addIconCodePoint(TulipFontAwesome::Terminal, 0xf120);
  addIconCodePoint(TulipFontAwesome::TextHeight, 0xf034);
  addIconCodePoint(TulipFontAwesome::TextWidth, 0xf035);
  addIconCodePoint(TulipFontAwesome::Th, 0xf00a);
  addIconCodePoint(TulipFontAwesome::ThLarge, 0xf009);
  addIconCodePoint(TulipFontAwesome::ThList, 0xf00b);
  addIconCodePoint(TulipFontAwesome::ThumbTack, 0xf08d);
  addIconCodePoint(TulipFontAwesome::ThumbsDown, 0xf165);
  addIconCodePoint(TulipFontAwesome::ThumbsODown, 0xf088);
  addIconCodePoint(TulipFontAwesome::ThumbsOUp, 0xf087);
  addIconCodePoint(TulipFontAwesome::ThumbsUp, 0xf164);
  addIconCodePoint(TulipFontAwesome::Ticket, 0xf145);
  addIconCodePoint(TulipFontAwesome::Times, 0xf00d);
  addIconCodePoint(TulipFontAwesome::TimesCircle, 0xf057);
  addIconCodePoint(TulipFontAwesome::TimesCircleO, 0xf05c);
  addIconCodePoint(TulipFontAwesome::Tint, 0xf043);
  addIconCodePoint(TulipFontAwesome::ToggleDown, 0xf150);
  addIconCodePoint(TulipFontAwesome::ToggleLeft, 0xf191);
  addIconCodePoint(TulipFontAwesome::ToggleOff, 0xf204);
  addIconCodePoint(TulipFontAwesome::ToggleOn, 0xf205);
  addIconCodePoint(TulipFontAwesome::ToggleRight, 0xf152);
  addIconCodePoint(TulipFontAwesome::ToggleUp, 0xf151);
  addIconCodePoint(TulipFontAwesome::Train, 0xf238);
  addIconCodePoint(TulipFontAwesome::Transgender, 0xf224);
  addIconCodePoint(TulipFontAwesome::TransgenderAlt, 0xf225);
  addIconCodePoint(TulipFontAwesome::Trash, 0xf1f8);
  addIconCodePoint(TulipFontAwesome::TrashO, 0xf014);
  addIconCodePoint(TulipFontAwesome::Tree, 0xf1bb);
  addIconCodePoint(TulipFontAwesome::Trello, 0xf181);
  addIconCodePoint(TulipFontAwesome::Trophy, 0xf091);
  addIconCodePoint(TulipFontAwesome::Truck, 0xf0d1);
  addIconCodePoint(TulipFontAwesome::Try, 0xf195);
  addIconCodePoint(TulipFontAwesome::Tty, 0xf1e4);
  addIconCodePoint(TulipFontAwesome::Tumblr, 0xf173);
  addIconCodePoint(TulipFontAwesome::TumblrSquare, 0xf174);
  addIconCodePoint(TulipFontAwesome::TurkishLira, 0xf195);
  addIconCodePoint(TulipFontAwesome::Twitch, 0xf1e8);
  addIconCodePoint(TulipFontAwesome::Twitter, 0xf099);
  addIconCodePoint(TulipFontAwesome::TwitterSquare, 0xf081);
  addIconCodePoint(TulipFontAwesome::Umbrella, 0xf0e9);
  addIconCodePoint(TulipFontAwesome::Underline, 0xf0cd);
  addIconCodePoint(TulipFontAwesome::Undo, 0xf0e2);
  addIconCodePoint(TulipFontAwesome::University, 0xf19c);
  addIconCodePoint(TulipFontAwesome::Unlink, 0xf127);
  addIconCodePoint(TulipFontAwesome::Unlock, 0xf09c);
  addIconCodePoint(TulipFontAwesome::UnlockAlt, 0xf13e);
  addIconCodePoint(TulipFontAwesome::Unsorted, 0xf0dc);
  addIconCodePoint(TulipFontAwesome::Upload, 0xf093);
  addIconCodePoint(TulipFontAwesome::Usd, 0xf155);
  addIconCodePoint(TulipFontAwesome::User, 0xf007);
  addIconCodePoint(TulipFontAwesome::UserMd, 0xf0f0);
  addIconCodePoint(TulipFontAwesome::UserPlus, 0xf234);
  addIconCodePoint(TulipFontAwesome::UserSecret, 0xf21b);
  addIconCodePoint(TulipFontAwesome::UserTimes, 0xf235);
  addIconCodePoint(TulipFontAwesome::Users, 0xf0c0);
  addIconCodePoint(TulipFontAwesome::Venus, 0xf221);
  addIconCodePoint(TulipFontAwesome::VenusDouble, 0xf226);
  addIconCodePoint(TulipFontAwesome::VenusMars, 0xf228);
  addIconCodePoint(TulipFontAwesome::Viacoin, 0xf237);
  addIconCodePoint(TulipFontAwesome::VideoCamera, 0xf03d);
  addIconCodePoint(TulipFontAwesome::VimeoSquare, 0xf194);
  addIconCodePoint(TulipFontAwesome::Vine, 0xf1ca);
  addIconCodePoint(TulipFontAwesome::Vk, 0xf189);
  addIconCodePoint(TulipFontAwesome::VolumeDown, 0xf027);
  addIconCodePoint(TulipFontAwesome::VolumeOff, 0xf026);
  addIconCodePoint(TulipFontAwesome::VolumeUp, 0xf028);
  addIconCodePoint(TulipFontAwesome::Warning, 0xf071);
  addIconCodePoint(TulipFontAwesome::Wechat, 0xf1d7);
  addIconCodePoint(TulipFontAwesome::Weibo, 0xf18a);
  addIconCodePoint(TulipFontAwesome::Weixin, 0xf1d7);
  addIconCodePoint(TulipFontAwesome::Whatsapp, 0xf232);
  addIconCodePoint(TulipFontAwesome::Wheelchair, 0xf193);
  addIconCodePoint(TulipFontAwesome::Wifi, 0xf1eb);
  addIconCodePoint(TulipFontAwesome::Windows, 0xf17a);
  addIconCodePoint(TulipFontAwesome::Won, 0xf159);
  addIconCodePoint(TulipFontAwesome::Wordpress, 0xf19a);
  addIconCodePoint(TulipFontAwesome::Wrench, 0xf0ad);
  addIconCodePoint(TulipFontAwesome::Xing, 0xf168);
  addIconCodePoint(TulipFontAwesome::XingSquare, 0xf169);
  addIconCodePoint(TulipFontAwesome::Yahoo, 0xf19e);
  addIconCodePoint(TulipFontAwesome::Yelp, 0xf1e9);
  addIconCodePoint(TulipFontAwesome::Yen, 0xf157);
  addIconCodePoint(TulipFontAwesome::Youtube, 0xf167);
  addIconCodePoint(TulipFontAwesome::YoutubePlay, 0xf16a);
  addIconCodePoint(TulipFontAwesome::YoutubeSquare, 0xf166);

  addIconCodePoint(TulipFontAwesome::Yc, 0xf23b);
  addIconCodePoint(TulipFontAwesome::YCombinator, 0xf23b);
  addIconCodePoint(TulipFontAwesome::OptinMonster, 0xf23c);
  addIconCodePoint(TulipFontAwesome::Opencart, 0xf23d);
  addIconCodePoint(TulipFontAwesome::Expeditedssl, 0xf23e);
  addIconCodePoint(TulipFontAwesome::Battery4, 0xf240);
  addIconCodePoint(TulipFontAwesome::BatteryFull, 0xf240);
  addIconCodePoint(TulipFontAwesome::Battery3, 0xf241);
  addIconCodePoint(TulipFontAwesome::BatteryThreeQuarters, 0xf241);
  addIconCodePoint(TulipFontAwesome::Battery2, 0xf242);
  addIconCodePoint(TulipFontAwesome::BatteryHalf, 0xf242);
  addIconCodePoint(TulipFontAwesome::Battery1, 0xf243);
  addIconCodePoint(TulipFontAwesome::BatteryQuarter, 0xf243);
  addIconCodePoint(TulipFontAwesome::Battery0, 0xf244);
  addIconCodePoint(TulipFontAwesome::BatteryEmpty, 0xf244);
  addIconCodePoint(TulipFontAwesome::MousePointer, 0xf245);
  addIconCodePoint(TulipFontAwesome::ICursor, 0xf246);
  addIconCodePoint(TulipFontAwesome::ObjectGroup, 0xf247);
  addIconCodePoint(TulipFontAwesome::ObjectUngroup, 0xf248);
  addIconCodePoint(TulipFontAwesome::StickyNote, 0xf249);
  addIconCodePoint(TulipFontAwesome::StickyNoteO, 0xf24a);
  addIconCodePoint(TulipFontAwesome::CcJcb, 0xf24b);
  addIconCodePoint(TulipFontAwesome::CcDinersClub, 0xf24c);
  addIconCodePoint(TulipFontAwesome::Clone, 0xf24d);
  addIconCodePoint(TulipFontAwesome::BalanceScale, 0xf24e);
  addIconCodePoint(TulipFontAwesome::HourglassO, 0xf250);
  addIconCodePoint(TulipFontAwesome::Hourglass1, 0xf251);
  addIconCodePoint(TulipFontAwesome::HourglassStart, 0xf251);
  addIconCodePoint(TulipFontAwesome::Hourglass2, 0xf252);
  addIconCodePoint(TulipFontAwesome::HourglassHalf, 0xf252);
  addIconCodePoint(TulipFontAwesome::Hourglass3, 0xf253);
  addIconCodePoint(TulipFontAwesome::HourglassEnd, 0xf253);
  addIconCodePoint(TulipFontAwesome::Hourglass, 0xf254);
  addIconCodePoint(TulipFontAwesome::HandGrabO, 0xf255);
  addIconCodePoint(TulipFontAwesome::HandRockO, 0xf255);
  addIconCodePoint(TulipFontAwesome::HandStopO, 0xf256);
  addIconCodePoint(TulipFontAwesome::HandPaperO, 0xf256);
  addIconCodePoint(TulipFontAwesome::HandScissorsO, 0xf257);
  addIconCodePoint(TulipFontAwesome::HandLizardO, 0xf258);
  addIconCodePoint(TulipFontAwesome::HandSpockO, 0xf259);
  addIconCodePoint(TulipFontAwesome::HandPointerO, 0xf25a);
  addIconCodePoint(TulipFontAwesome::HandPeaceO, 0xf25b);
  addIconCodePoint(TulipFontAwesome::Trademark, 0xf25c);
  addIconCodePoint(TulipFontAwesome::Registered, 0xf25d);
  addIconCodePoint(TulipFontAwesome::CreativeCommons, 0xf25e);
  addIconCodePoint(TulipFontAwesome::Gg, 0xf260);
  addIconCodePoint(TulipFontAwesome::GgCircle, 0xf261);
  addIconCodePoint(TulipFontAwesome::Tripadvisor, 0xf262);
  addIconCodePoint(TulipFontAwesome::Odnoklassniki, 0xf263);
  addIconCodePoint(TulipFontAwesome::OdnoklassnikiSquare, 0xf264);
  addIconCodePoint(TulipFontAwesome::GetPocket, 0xf265);
  addIconCodePoint(TulipFontAwesome::WikipediaW, 0xf266);
  addIconCodePoint(TulipFontAwesome::Safari, 0xf267);
  addIconCodePoint(TulipFontAwesome::Chrome, 0xf268);
  addIconCodePoint(TulipFontAwesome::Firefox, 0xf269);
  addIconCodePoint(TulipFontAwesome::Opera, 0xf26a);
  addIconCodePoint(TulipFontAwesome::InternetExplorer, 0xf26b);
  addIconCodePoint(TulipFontAwesome::Tv, 0xf26c);
  addIconCodePoint(TulipFontAwesome::Television, 0xf26c);
  addIconCodePoint(TulipFontAwesome::Contao, 0xf26d);
  addIconCodePoint(TulipFontAwesome::Px500, 0xf26e);
  addIconCodePoint(TulipFontAwesome::Amazon, 0xf270);
  addIconCodePoint(TulipFontAwesome::CalendarPlusO, 0xf271);
  addIconCodePoint(TulipFontAwesome::CalendarMinusO, 0xf272);
  addIconCodePoint(TulipFontAwesome::CalendarTimesO, 0xf273);
  addIconCodePoint(TulipFontAwesome::CalendarCheckO, 0xf274);
  addIconCodePoint(TulipFontAwesome::Industry, 0xf275);
  addIconCodePoint(TulipFontAwesome::MapPin, 0xf276);
  addIconCodePoint(TulipFontAwesome::MapSigns, 0xf277);
  addIconCodePoint(TulipFontAwesome::MapO, 0xf278);
  addIconCodePoint(TulipFontAwesome::Map, 0xf279);
  addIconCodePoint(TulipFontAwesome::Commenting, 0xf27a);
  addIconCodePoint(TulipFontAwesome::CommentingO, 0xf27b);
  addIconCodePoint(TulipFontAwesome::Houzz, 0xf27c);
  addIconCodePoint(TulipFontAwesome::Vimeo, 0xf27d);
  addIconCodePoint(TulipFontAwesome::BlackTie, 0xf27e);
  addIconCodePoint(TulipFontAwesome::Fonticons, 0xf280);


  map<const char*, vector<unsigned int>, cmpCharPtr>::iterator it = fontAwesomeIconCodePoint.begin();

  for ( ; it != fontAwesomeIconCodePoint.end() ; ++it) {
    fontAwesomeIconsNames.push_back(std::string(it->first));
  }
}

std::string TulipFontAwesome::getFontAwesomeTrueTypeFileLocation() {
  return string(tlp::TulipBitmapDir).append("fontawesome-webfont.ttf");
}

bool TulipFontAwesome::isFontAwesomeIconSupported(const std::string &iconName) {
  if (fontAwesomeIconCodePoint.empty()) {
    initFontAwesomeIconCodePoints();
  }

  return fontAwesomeIconCodePoint.find(iconName.c_str()) != fontAwesomeIconCodePoint.end();
}

const vector<std::string> &TulipFontAwesome::getSupportedFontAwesomeIcons() {
  if (fontAwesomeIconCodePoint.empty()) {
    initFontAwesomeIconCodePoints();
  }

  return fontAwesomeIconsNames;
}

std::string TulipFontAwesome::getFontAwesomeIconUtf8String(const std::string& iconName) {
  if (fontAwesomeIconCodePoint.empty()) {
    initFontAwesomeIconCodePoints();
  }

  std::string iconString;
  utf8::utf32to8(fontAwesomeIconCodePoint[iconName.c_str()].begin(), fontAwesomeIconCodePoint[iconName.c_str()].end(), back_inserter(iconString));
  return iconString;
}

unsigned int TulipFontAwesome::getFontAwesomeIconCodePoint(const std::string &iconName) {
  if (fontAwesomeIconCodePoint.empty()) {
    initFontAwesomeIconCodePoints();
  }

  map<const char*, vector<unsigned int>, cmpCharPtr>::iterator it =
    fontAwesomeIconCodePoint.find(iconName.c_str());

  if (it != fontAwesomeIconCodePoint.end())
    return (it->second[0]);

  return 0;
}

}

