/* valasymbol.c generated by valac, the Vala compiler
 * generated from valasymbol.vala, do not modify */

/* valasymbol.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_version_attribute_unref0(var) ((var == NULL) ? NULL : (var = (vala_version_attribute_unref (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaSymbolPrivate {
	gchar* _name;
	gboolean _active;
	gboolean _used;
	gboolean _anonymous;
	ValaSymbolAccessibility _access;
	ValaComment* _comment;
	ValaVersionAttribute* _version;
	gboolean _hides;
	gboolean _external;
	ValaScope* _owner;
	ValaScope* _scope;
};


static gint ValaSymbol_private_offset;
static gpointer vala_symbol_parent_class = NULL;

static gboolean vala_symbol_real_is_instance_member (ValaSymbol* self);
static gboolean vala_symbol_real_is_class_member (ValaSymbol* self);
static void vala_symbol_real_add_namespace (ValaSymbol* self,
                                     ValaNamespace* ns);
static void vala_symbol_real_add_class (ValaSymbol* self,
                                 ValaClass* cl);
static void vala_symbol_real_add_interface (ValaSymbol* self,
                                     ValaInterface* iface);
static void vala_symbol_real_add_struct (ValaSymbol* self,
                                  ValaStruct* st);
static void vala_symbol_real_add_enum (ValaSymbol* self,
                                ValaEnum* en);
static void vala_symbol_real_add_error_domain (ValaSymbol* self,
                                        ValaErrorDomain* edomain);
static void vala_symbol_real_add_delegate (ValaSymbol* self,
                                    ValaDelegate* d);
static void vala_symbol_real_add_constant (ValaSymbol* self,
                                    ValaConstant* constant);
static void vala_symbol_real_add_field (ValaSymbol* self,
                                 ValaField* f);
static void vala_symbol_real_add_method (ValaSymbol* self,
                                  ValaMethod* m);
static void vala_symbol_real_add_property (ValaSymbol* self,
                                    ValaProperty* prop);
static void vala_symbol_real_add_signal (ValaSymbol* self,
                                  ValaSignal* sig);
static void vala_symbol_real_add_constructor (ValaSymbol* self,
                                       ValaConstructor* c);
static void vala_symbol_real_add_destructor (ValaSymbol* self,
                                      ValaDestructor* d);
static gchar* vala_symbol_real_to_string (ValaCodeNode* base);
static void vala_symbol_finalize (ValaCodeNode * obj);


static inline gpointer
vala_symbol_get_instance_private (ValaSymbol* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSymbol_private_offset);
}


/**
 * Check if this symbol is just internal API (and therefore doesn't need
 * to be listed in header files for instance) by traversing parent symbols
 * and checking their accessibility.
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


gboolean
vala_symbol_is_internal_symbol (ValaSymbol* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_external;
	if (!_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_symbol_get_external_package (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp4_;
		_tmp4_ = _vala_code_node_ref0 (self);
		sym = _tmp4_;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp10_;
				gboolean _tmp11_ = FALSE;
				ValaSymbol* _tmp12_;
				ValaSymbolAccessibility _tmp13_;
				if (!_tmp5_) {
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					_tmp6_ = sym;
					_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = _vala_code_node_ref0 (_tmp8_);
					_vala_code_node_unref0 (sym);
					sym = _tmp9_;
				}
				_tmp5_ = FALSE;
				_tmp10_ = sym;
				if (!(NULL != _tmp10_)) {
					break;
				}
				_tmp12_ = sym;
				_tmp13_ = _tmp12_->priv->_access;
				if (_tmp13_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					_tmp11_ = TRUE;
				} else {
					ValaSymbol* _tmp14_;
					ValaSymbolAccessibility _tmp15_;
					_tmp14_ = sym;
					_tmp15_ = _tmp14_->priv->_access;
					_tmp11_ = _tmp15_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL;
				}
				if (_tmp11_) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}


gboolean
vala_symbol_is_private_symbol (ValaSymbol* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_external;
	if (!_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_symbol_get_external_package (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp4_;
		_tmp4_ = _vala_code_node_ref0 (self);
		sym = _tmp4_;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				ValaSymbolAccessibility _tmp12_;
				if (!_tmp5_) {
					ValaSymbol* _tmp6_;
					ValaSymbol* _tmp7_;
					ValaSymbol* _tmp8_;
					ValaSymbol* _tmp9_;
					_tmp6_ = sym;
					_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = _vala_code_node_ref0 (_tmp8_);
					_vala_code_node_unref0 (sym);
					sym = _tmp9_;
				}
				_tmp5_ = FALSE;
				_tmp10_ = sym;
				if (!(NULL != _tmp10_)) {
					break;
				}
				_tmp11_ = sym;
				_tmp12_ = _tmp11_->priv->_access;
				if (_tmp12_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					result = TRUE;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = FALSE;
	return result;
}


ValaSymbol*
vala_symbol_construct (GType object_type,
                       const gchar* name,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaSymbol* self = NULL;
	ValaScope* _tmp0_;
	self = (ValaSymbol*) vala_code_node_construct (object_type);
	vala_symbol_set_name (self, name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_symbol_set_comment (self, comment);
	_tmp0_ = vala_scope_new (self);
	_vala_scope_unref0 (self->priv->_scope);
	self->priv->_scope = _tmp0_;
	return self;
}


/**
 * Returns the fully expanded name of this symbol for use in
 * human-readable messages.
 *
 * @return full name
 */
gchar*
vala_symbol_get_full_name (ValaSymbol* self)
{
	gchar* result = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	const gchar* _tmp4_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->_name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_name;
	if (_tmp4_ == NULL) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_symbol_get_full_name (_tmp6_);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = vala_symbol_get_parent_symbol (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_symbol_get_full_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ == NULL;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = self->priv->_name;
		_tmp14_ = g_strdup (_tmp13_);
		result = _tmp14_;
		return result;
	}
	_tmp15_ = self->priv->_name;
	if (g_str_has_prefix (_tmp15_, ".")) {
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp16_ = vala_symbol_get_parent_symbol (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_full_name (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->_name;
		_tmp21_ = g_strdup_printf ("%s%s", _tmp19_, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp19_);
		result = _tmp22_;
		return result;
	} else {
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp23_ = vala_symbol_get_parent_symbol (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_symbol_get_full_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_name;
		_tmp28_ = g_strdup_printf ("%s.%s", _tmp26_, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp26_);
		result = _tmp29_;
		return result;
	}
}


/**
 * Converts a string from CamelCase to lower_case.
 *
 * @param camel_case a string in camel case
 * @return           the specified string converted to lower case
 */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


gchar*
vala_symbol_camel_case_to_lower_case (const gchar* camel_case)
{
	gchar* result = NULL;
	GString* result_builder = NULL;
	GString* _tmp1_;
	const gchar* i = NULL;
	gboolean first = FALSE;
	GString* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	g_return_val_if_fail (camel_case != NULL, NULL);
	if (string_contains (camel_case, "_")) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_strdown (camel_case, (gssize) -1);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_string_new ("");
	result_builder = _tmp1_;
	i = camel_case;
	first = TRUE;
	while (TRUE) {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gunichar c = 0U;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gunichar _tmp7_;
		GString* _tmp32_;
		gunichar _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp2_ = i;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (!(_tmp4_ > 0)) {
			break;
		}
		_tmp5_ = i;
		c = string_get_char (_tmp5_, (glong) 0);
		_tmp7_ = c;
		if (g_unichar_isupper (_tmp7_)) {
			gboolean _tmp8_;
			_tmp8_ = first;
			_tmp6_ = !_tmp8_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			const gchar* t = NULL;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gboolean prev_upper = FALSE;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gboolean next_upper = FALSE;
			const gchar* _tmp14_;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_;
			_tmp9_ = i;
			_tmp10_ = g_utf8_prev_char (_tmp9_);
			t = _tmp10_;
			_tmp11_ = t;
			prev_upper = g_unichar_isupper (string_get_char (_tmp11_, (glong) 0));
			_tmp12_ = i;
			_tmp13_ = g_utf8_next_char (_tmp12_);
			t = _tmp13_;
			_tmp14_ = t;
			next_upper = g_unichar_isupper (string_get_char (_tmp14_, (glong) 0));
			_tmp16_ = prev_upper;
			if (!_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				_tmp18_ = i;
				_tmp19_ = strlen (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ >= 2) {
					gboolean _tmp21_;
					_tmp21_ = next_upper;
					_tmp17_ = !_tmp21_;
				} else {
					_tmp17_ = FALSE;
				}
				_tmp15_ = _tmp17_;
			}
			if (_tmp15_) {
				glong len = 0L;
				GString* _tmp22_;
				const gchar* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gboolean _tmp26_ = FALSE;
				glong _tmp27_;
				_tmp22_ = result_builder;
				_tmp23_ = _tmp22_->str;
				_tmp24_ = strlen (_tmp23_);
				_tmp25_ = _tmp24_;
				len = (glong) _tmp25_;
				_tmp27_ = len;
				if (_tmp27_ != ((glong) 1)) {
					GString* _tmp28_;
					const gchar* _tmp29_;
					glong _tmp30_;
					_tmp28_ = result_builder;
					_tmp29_ = _tmp28_->str;
					_tmp30_ = len;
					_tmp26_ = string_get_char (_tmp29_, _tmp30_ - 2) != ((gunichar) '_');
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					GString* _tmp31_;
					_tmp31_ = result_builder;
					g_string_append_c (_tmp31_, '_');
				}
			}
		}
		_tmp32_ = result_builder;
		_tmp33_ = c;
		g_string_append_unichar (_tmp32_, g_unichar_tolower (_tmp33_));
		first = FALSE;
		_tmp34_ = i;
		_tmp35_ = g_utf8_next_char (_tmp34_);
		i = _tmp35_;
	}
	_tmp36_ = result_builder;
	_tmp37_ = _tmp36_->str;
	_tmp38_ = g_strdup (_tmp37_);
	result = _tmp38_;
	_g_string_free0 (result_builder);
	return result;
}


/**
 * Converts a string from lower_case to CamelCase.
 *
 * @param lower_case a string in lower case
 * @return           the specified string converted to camel case
 */
gchar*
vala_symbol_lower_case_to_camel_case (const gchar* lower_case)
{
	gchar* result = NULL;
	GString* result_builder = NULL;
	GString* _tmp0_;
	const gchar* i = NULL;
	gboolean last_underscore = FALSE;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (lower_case != NULL, NULL);
	_tmp0_ = g_string_new ("");
	result_builder = _tmp0_;
	i = lower_case;
	last_underscore = TRUE;
	while (TRUE) {
		const gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gunichar c = 0U;
		const gchar* _tmp4_;
		gunichar _tmp5_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp1_ = i;
		_tmp2_ = strlen (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!(_tmp3_ > 0)) {
			break;
		}
		_tmp4_ = i;
		c = string_get_char (_tmp4_, (glong) 0);
		_tmp5_ = c;
		if (_tmp5_ == ((gunichar) '_')) {
			last_underscore = TRUE;
		} else {
			gunichar _tmp6_;
			_tmp6_ = c;
			if (g_unichar_isupper (_tmp6_)) {
				gchar* _tmp7_;
				_tmp7_ = g_strdup (lower_case);
				result = _tmp7_;
				_g_string_free0 (result_builder);
				return result;
			} else {
				gboolean _tmp8_;
				_tmp8_ = last_underscore;
				if (_tmp8_) {
					GString* _tmp9_;
					gunichar _tmp10_;
					_tmp9_ = result_builder;
					_tmp10_ = c;
					g_string_append_unichar (_tmp9_, g_unichar_toupper (_tmp10_));
					last_underscore = FALSE;
				} else {
					GString* _tmp11_;
					gunichar _tmp12_;
					_tmp11_ = result_builder;
					_tmp12_ = c;
					g_string_append_unichar (_tmp11_, _tmp12_);
				}
			}
		}
		_tmp13_ = i;
		_tmp14_ = g_utf8_next_char (_tmp13_);
		i = _tmp14_;
	}
	_tmp15_ = result_builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (result_builder);
	return result;
}


static gpointer
_vala_scope_ref0 (gpointer self)
{
	return self ? vala_scope_ref (self) : NULL;
}


ValaScope*
vala_symbol_get_top_accessible_scope (ValaSymbol* self,
                                      gboolean is_internal)
{
	ValaScope* result = NULL;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_access;
	if (_tmp0_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		ValaScope* _tmp3_;
		_tmp1_ = vala_symbol_get_owner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_scope_ref0 (_tmp2_);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->priv->_access;
	if (_tmp4_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL) {
		is_internal = TRUE;
	}
	_tmp5_ = vala_symbol_get_parent_symbol (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		if (is_internal) {
			ValaScope* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			_tmp7_ = vala_symbol_get_scope (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_scope_ref0 (_tmp8_);
			result = _tmp9_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
	_tmp10_ = vala_symbol_get_parent_symbol (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_top_accessible_scope (_tmp11_, is_internal);
	result = _tmp12_;
	return result;
}


static gboolean
vala_symbol_real_is_instance_member (ValaSymbol* self)
{
	gboolean result = FALSE;
	gboolean instance = FALSE;
	instance = TRUE;
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_FIELD)) {
		ValaField* f = NULL;
		ValaField* _tmp0_;
		ValaField* _tmp1_;
		ValaMemberBinding _tmp2_;
		ValaMemberBinding _tmp3_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_FIELD, ValaField));
		f = _tmp0_;
		_tmp1_ = f;
		_tmp2_ = vala_field_get_binding (_tmp1_);
		_tmp3_ = _tmp2_;
		instance = _tmp3_ == VALA_MEMBER_BINDING_INSTANCE;
		_vala_code_node_unref0 (f);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_METHOD)) {
			ValaMethod* m = NULL;
			ValaMethod* _tmp4_;
			ValaMethod* _tmp5_;
			_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp4_;
			_tmp5_ = m;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp6_;
				ValaMemberBinding _tmp7_;
				ValaMemberBinding _tmp8_;
				_tmp6_ = m;
				_tmp7_ = vala_method_get_binding (_tmp6_);
				_tmp8_ = _tmp7_;
				instance = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaProperty* _tmp9_;
				ValaProperty* _tmp10_;
				ValaMemberBinding _tmp11_;
				ValaMemberBinding _tmp12_;
				_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp9_;
				_tmp10_ = prop;
				_tmp11_ = vala_property_get_binding (_tmp10_);
				_tmp12_ = _tmp11_;
				instance = _tmp12_ == VALA_MEMBER_BINDING_INSTANCE;
				_vala_code_node_unref0 (prop);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_ENUM_VALUE)) {
					instance = FALSE;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_ERROR_CODE)) {
						instance = FALSE;
					}
				}
			}
		}
	}
	result = instance;
	return result;
}


gboolean
vala_symbol_is_instance_member (ValaSymbol* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_SYMBOL_GET_CLASS (self)->is_instance_member (self);
}


static gboolean
vala_symbol_real_is_class_member (ValaSymbol* self)
{
	gboolean result = FALSE;
	gboolean isclass = FALSE;
	isclass = TRUE;
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_FIELD)) {
		ValaField* f = NULL;
		ValaField* _tmp0_;
		ValaField* _tmp1_;
		ValaMemberBinding _tmp2_;
		ValaMemberBinding _tmp3_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_FIELD, ValaField));
		f = _tmp0_;
		_tmp1_ = f;
		_tmp2_ = vala_field_get_binding (_tmp1_);
		_tmp3_ = _tmp2_;
		isclass = _tmp3_ == VALA_MEMBER_BINDING_CLASS;
		_vala_code_node_unref0 (f);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_METHOD)) {
			ValaMethod* m = NULL;
			ValaMethod* _tmp4_;
			ValaMethod* _tmp5_;
			_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp4_;
			_tmp5_ = m;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp6_;
				ValaMemberBinding _tmp7_;
				ValaMemberBinding _tmp8_;
				_tmp6_ = m;
				_tmp7_ = vala_method_get_binding (_tmp6_);
				_tmp8_ = _tmp7_;
				isclass = _tmp8_ == VALA_MEMBER_BINDING_CLASS;
			}
			_vala_code_node_unref0 (m);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaProperty* _tmp9_;
				ValaProperty* _tmp10_;
				ValaMemberBinding _tmp11_;
				ValaMemberBinding _tmp12_;
				_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp9_;
				_tmp10_ = prop;
				_tmp11_ = vala_property_get_binding (_tmp10_);
				_tmp12_ = _tmp11_;
				isclass = _tmp12_ == VALA_MEMBER_BINDING_CLASS;
				_vala_code_node_unref0 (prop);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_ENUM_VALUE)) {
					isclass = FALSE;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_ERROR_CODE)) {
						isclass = FALSE;
					}
				}
			}
		}
	}
	result = isclass;
	return result;
}


gboolean
vala_symbol_is_class_member (ValaSymbol* self)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_SYMBOL_GET_CLASS (self)->is_class_member (self);
}


ValaSymbol*
vala_symbol_get_hidden_member (ValaSymbol* self)
{
	ValaSymbol* result = NULL;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	sym = NULL;
	_tmp0_ = vala_symbol_get_parent_symbol (self);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaClass* _tmp4_;
		ValaClass* _tmp5_;
		ValaClass* _tmp6_;
		_tmp2_ = vala_symbol_get_parent_symbol (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_class_get_base_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		cl = _tmp6_;
		while (TRUE) {
			ValaClass* _tmp7_;
			ValaClass* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			const gchar* _tmp11_;
			ValaSymbol* _tmp12_;
			gboolean _tmp13_ = FALSE;
			ValaSymbol* _tmp14_;
			ValaClass* _tmp17_;
			ValaClass* _tmp18_;
			ValaClass* _tmp19_;
			ValaClass* _tmp20_;
			_tmp7_ = cl;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = cl;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_name;
			_tmp12_ = vala_scope_lookup (_tmp10_, _tmp11_);
			_vala_code_node_unref0 (sym);
			sym = _tmp12_;
			_tmp14_ = sym;
			if (_tmp14_ != NULL) {
				ValaSymbol* _tmp15_;
				ValaSymbolAccessibility _tmp16_;
				_tmp15_ = sym;
				_tmp16_ = _tmp15_->priv->_access;
				_tmp13_ = _tmp16_ != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				result = sym;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_tmp17_ = cl;
			_tmp18_ = vala_class_get_base_class (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _vala_code_node_ref0 (_tmp19_);
			_vala_code_node_unref0 (cl);
			cl = _tmp20_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp21_ = vala_symbol_get_parent_symbol (self);
		_tmp22_ = _tmp21_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_STRUCT)) {
			ValaStruct* st = NULL;
			ValaSymbol* _tmp23_;
			ValaSymbol* _tmp24_;
			ValaStruct* _tmp25_;
			ValaStruct* _tmp26_;
			ValaStruct* _tmp27_;
			_tmp23_ = vala_symbol_get_parent_symbol (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_struct_get_base_struct (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_STRUCT, ValaStruct));
			_tmp26_ = _tmp25_;
			_tmp27_ = _vala_code_node_ref0 (_tmp26_);
			st = _tmp27_;
			while (TRUE) {
				ValaStruct* _tmp28_;
				ValaStruct* _tmp29_;
				ValaScope* _tmp30_;
				ValaScope* _tmp31_;
				const gchar* _tmp32_;
				ValaSymbol* _tmp33_;
				gboolean _tmp34_ = FALSE;
				ValaSymbol* _tmp35_;
				ValaStruct* _tmp38_;
				ValaStruct* _tmp39_;
				ValaStruct* _tmp40_;
				ValaStruct* _tmp41_;
				_tmp28_ = st;
				if (!(_tmp28_ != NULL)) {
					break;
				}
				_tmp29_ = st;
				_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = self->priv->_name;
				_tmp33_ = vala_scope_lookup (_tmp31_, _tmp32_);
				_vala_code_node_unref0 (sym);
				sym = _tmp33_;
				_tmp35_ = sym;
				if (_tmp35_ != NULL) {
					ValaSymbol* _tmp36_;
					ValaSymbolAccessibility _tmp37_;
					_tmp36_ = sym;
					_tmp37_ = _tmp36_->priv->_access;
					_tmp34_ = _tmp37_ != VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					result = sym;
					_vala_code_node_unref0 (st);
					return result;
				}
				_tmp38_ = st;
				_tmp39_ = vala_struct_get_base_struct (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _vala_code_node_ref0 (_tmp40_);
				_vala_code_node_unref0 (st);
				st = _tmp41_;
			}
			_vala_code_node_unref0 (st);
		}
	}
	result = NULL;
	_vala_code_node_unref0 (sym);
	return result;
}


gboolean
vala_symbol_is_accessible (ValaSymbol* self,
                           ValaSymbol* sym)
{
	gboolean result = FALSE;
	ValaScope* sym_scope = NULL;
	ValaScope* _tmp0_;
	ValaScope* this_scope = NULL;
	ValaScope* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaScope* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_symbol_get_top_accessible_scope (sym, FALSE);
	sym_scope = _tmp0_;
	_tmp1_ = vala_symbol_get_top_accessible_scope (self, FALSE);
	this_scope = _tmp1_;
	_tmp4_ = sym_scope;
	if (_tmp4_ == NULL) {
		ValaScope* _tmp5_;
		_tmp5_ = this_scope;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		ValaScope* _tmp7_;
		_tmp7_ = sym_scope;
		if (_tmp7_ != NULL) {
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			_tmp8_ = sym_scope;
			_tmp9_ = this_scope;
			_tmp6_ = !vala_scope_is_subscope_of (_tmp8_, _tmp9_);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		result = FALSE;
		_vala_scope_unref0 (this_scope);
		_vala_scope_unref0 (sym_scope);
		return result;
	}
	result = TRUE;
	_vala_scope_unref0 (this_scope);
	_vala_scope_unref0 (sym_scope);
	return result;
}


static void
vala_symbol_real_add_namespace (ValaSymbol* self,
                                ValaNamespace* ns)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_namespace (ValaSymbol* self,
                           ValaNamespace* ns)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_namespace (self, ns);
}


static void
vala_symbol_real_add_class (ValaSymbol* self,
                            ValaClass* cl)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_class (ValaSymbol* self,
                       ValaClass* cl)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_class (self, cl);
}


static void
vala_symbol_real_add_interface (ValaSymbol* self,
                                ValaInterface* iface)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) iface);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_interface (ValaSymbol* self,
                           ValaInterface* iface)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_interface (self, iface);
}


static void
vala_symbol_real_add_struct (ValaSymbol* self,
                             ValaStruct* st)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_struct (ValaSymbol* self,
                        ValaStruct* st)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_struct (self, st);
}


static void
vala_symbol_real_add_enum (ValaSymbol* self,
                           ValaEnum* en)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) en);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_enum (ValaSymbol* self,
                      ValaEnum* en)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_enum (self, en);
}


static void
vala_symbol_real_add_error_domain (ValaSymbol* self,
                                   ValaErrorDomain* edomain)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) edomain);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_error_domain (ValaSymbol* self,
                              ValaErrorDomain* edomain)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_error_domain (self, edomain);
}


static void
vala_symbol_real_add_delegate (ValaSymbol* self,
                               ValaDelegate* d)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_delegate (ValaSymbol* self,
                          ValaDelegate* d)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_delegate (self, d);
}


static void
vala_symbol_real_add_constant (ValaSymbol* self,
                               ValaConstant* constant)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) constant);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_constant (ValaSymbol* self,
                          ValaConstant* constant)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_constant (self, constant);
}


static void
vala_symbol_real_add_field (ValaSymbol* self,
                            ValaField* f)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_field (ValaSymbol* self,
                       ValaField* f)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_field (self, f);
}


static void
vala_symbol_real_add_method (ValaSymbol* self,
                             ValaMethod* m)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_method (ValaSymbol* self,
                        ValaMethod* m)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_method (self, m);
}


static void
vala_symbol_real_add_property (ValaSymbol* self,
                               ValaProperty* prop)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_property (ValaSymbol* self,
                          ValaProperty* prop)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_property (self, prop);
}


static void
vala_symbol_real_add_signal (ValaSymbol* self,
                             ValaSignal* sig)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_signal (ValaSymbol* self,
                        ValaSignal* sig)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_signal (self, sig);
}


static void
vala_symbol_real_add_constructor (ValaSymbol* self,
                                  ValaConstructor* c)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_constructor (ValaSymbol* self,
                             ValaConstructor* c)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_constructor (self, c);
}


static void
vala_symbol_real_add_destructor (ValaSymbol* self,
                                 ValaDestructor* d)
{
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
	_tmp1_ = _tmp0_;
	vala_report_error (_tmp1_, "unexpected declaration");
}


void
vala_symbol_add_destructor (ValaSymbol* self,
                            ValaDestructor* d)
{
	g_return_if_fail (self != NULL);
	VALA_SYMBOL_GET_CLASS (self)->add_destructor (self, d);
}


static gchar*
vala_symbol_real_to_string (ValaCodeNode* base)
{
	ValaSymbol * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaSymbol*) base;
	_tmp0_ = vala_symbol_get_full_name (self);
	result = _tmp0_;
	return result;
}


ValaSymbol*
vala_symbol_get_parent_symbol (ValaSymbol* self)
{
	ValaSymbol* result;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_symbol_get_owner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = NULL;
		return result;
	} else {
		ValaScope* _tmp2_;
		ValaScope* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp2_ = vala_symbol_get_owner (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_scope_get_owner (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		return result;
	}
}


ValaScope*
vala_symbol_get_owner (ValaSymbol* self)
{
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_owner (ValaSymbol* self,
                       ValaScope* value)
{
	ValaScope* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_owner = value;
	_tmp0_ = self->priv->_scope;
	vala_scope_set_parent_scope (_tmp0_, value);
}


const gchar*
vala_symbol_get_name (ValaSymbol* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_name (ValaSymbol* self,
                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp0_;
}


gboolean
vala_symbol_get_active (ValaSymbol* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_active (ValaSymbol* self,
                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
}


gboolean
vala_symbol_get_used (ValaSymbol* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_used;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_used (ValaSymbol* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_used = value;
}


gboolean
vala_symbol_get_anonymous (ValaSymbol* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_anonymous;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_anonymous (ValaSymbol* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_anonymous = value;
}


ValaSymbolAccessibility
vala_symbol_get_access (ValaSymbol* self)
{
	ValaSymbolAccessibility result;
	ValaSymbolAccessibility _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_access;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_access (ValaSymbol* self,
                        ValaSymbolAccessibility value)
{
	g_return_if_fail (self != NULL);
	self->priv->_access = value;
}


ValaComment*
vala_symbol_get_comment (ValaSymbol* self)
{
	ValaComment* result;
	ValaComment* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}


void
vala_symbol_set_comment (ValaSymbol* self,
                         ValaComment* value)
{
	ValaComment* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_comment_ref0 (value);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = _tmp0_;
}


ValaVersionAttribute*
vala_symbol_get_version (ValaSymbol* self)
{
	ValaVersionAttribute* result;
	ValaVersionAttribute* _tmp0_;
	ValaVersionAttribute* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_version;
	if (_tmp0_ == NULL) {
		ValaVersionAttribute* _tmp1_;
		_tmp1_ = vala_version_attribute_new (self);
		_vala_version_attribute_unref0 (self->priv->_version);
		self->priv->_version = _tmp1_;
	}
	_tmp2_ = self->priv->_version;
	result = _tmp2_;
	return result;
}


gboolean
vala_symbol_get_hides (ValaSymbol* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_hides;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_hides (ValaSymbol* self,
                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_hides = value;
}


ValaScope*
vala_symbol_get_scope (ValaSymbol* self)
{
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scope;
	result = _tmp0_;
	return result;
}


gboolean
vala_symbol_get_external (ValaSymbol* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_external;
	result = _tmp0_;
	return result;
}


void
vala_symbol_set_external (ValaSymbol* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_external = value;
}


gboolean
vala_symbol_get_external_package (ValaSymbol* self)
{
	gboolean result;
	ValaSourceFileType _tmp0_;
	ValaSourceFileType _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_symbol_get_source_type (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == VALA_SOURCE_FILE_TYPE_PACKAGE;
	return result;
}


gboolean
vala_symbol_get_from_commandline (ValaSymbol* self)
{
	gboolean result;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_file_get_from_commandline (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


ValaSourceFileType
vala_symbol_get_source_type (ValaSymbol* self)
{
	ValaSourceFileType result;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		ValaSourceFileType _tmp6_;
		ValaSourceFileType _tmp7_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_file_get_file_type (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	} else {
		result = VALA_SOURCE_FILE_TYPE_NONE;
		return result;
	}
}


static void
vala_symbol_class_init (ValaSymbolClass * klass)
{
	vala_symbol_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_symbol_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSymbol_private_offset);
	((ValaSymbolClass *) klass)->is_instance_member = (gboolean (*) (ValaSymbol*)) vala_symbol_real_is_instance_member;
	((ValaSymbolClass *) klass)->is_class_member = (gboolean (*) (ValaSymbol*)) vala_symbol_real_is_class_member;
	((ValaSymbolClass *) klass)->add_namespace = (void (*) (ValaSymbol*, ValaNamespace*)) vala_symbol_real_add_namespace;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol*, ValaClass*)) vala_symbol_real_add_class;
	((ValaSymbolClass *) klass)->add_interface = (void (*) (ValaSymbol*, ValaInterface*)) vala_symbol_real_add_interface;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol*, ValaStruct*)) vala_symbol_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol*, ValaEnum*)) vala_symbol_real_add_enum;
	((ValaSymbolClass *) klass)->add_error_domain = (void (*) (ValaSymbol*, ValaErrorDomain*)) vala_symbol_real_add_error_domain;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol*, ValaDelegate*)) vala_symbol_real_add_delegate;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_symbol_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_symbol_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_symbol_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_symbol_real_add_property;
	((ValaSymbolClass *) klass)->add_signal = (void (*) (ValaSymbol*, ValaSignal*)) vala_symbol_real_add_signal;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_symbol_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_symbol_real_add_destructor;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_symbol_real_to_string;
}


static void
vala_symbol_instance_init (ValaSymbol * self)
{
	self->priv = vala_symbol_get_instance_private (self);
	self->priv->_active = TRUE;
}


static void
vala_symbol_finalize (ValaCodeNode * obj)
{
	ValaSymbol * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SYMBOL, ValaSymbol);
	_g_free0 (self->priv->_name);
	_vala_comment_unref0 (self->priv->_comment);
	_vala_version_attribute_unref0 (self->priv->_version);
	_vala_scope_unref0 (self->priv->_scope);
	VALA_CODE_NODE_CLASS (vala_symbol_parent_class)->finalize (obj);
}


/**
 * Represents a node in the symbol tree.
 */
GType
vala_symbol_get_type (void)
{
	static volatile gsize vala_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSymbol), 0, (GInstanceInitFunc) vala_symbol_instance_init, NULL };
		GType vala_symbol_type_id;
		vala_symbol_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		ValaSymbol_private_offset = g_type_add_instance_private (vala_symbol_type_id, sizeof (ValaSymbolPrivate));
		g_once_init_leave (&vala_symbol_type_id__volatile, vala_symbol_type_id);
	}
	return vala_symbol_type_id__volatile;
}


GType
vala_symbol_accessibility_get_type (void)
{
	static volatile gsize vala_symbol_accessibility_type_id__volatile = 0;
	if (g_once_init_enter (&vala_symbol_accessibility_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_SYMBOL_ACCESSIBILITY_PRIVATE, "VALA_SYMBOL_ACCESSIBILITY_PRIVATE", "private"}, {VALA_SYMBOL_ACCESSIBILITY_INTERNAL, "VALA_SYMBOL_ACCESSIBILITY_INTERNAL", "internal"}, {VALA_SYMBOL_ACCESSIBILITY_PROTECTED, "VALA_SYMBOL_ACCESSIBILITY_PROTECTED", "protected"}, {VALA_SYMBOL_ACCESSIBILITY_PUBLIC, "VALA_SYMBOL_ACCESSIBILITY_PUBLIC", "public"}, {0, NULL, NULL}};
		GType vala_symbol_accessibility_type_id;
		vala_symbol_accessibility_type_id = g_enum_register_static ("ValaSymbolAccessibility", values);
		g_once_init_leave (&vala_symbol_accessibility_type_id__volatile, vala_symbol_accessibility_type_id);
	}
	return vala_symbol_accessibility_type_id__volatile;
}


GType
vala_member_binding_get_type (void)
{
	static volatile gsize vala_member_binding_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_binding_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_MEMBER_BINDING_INSTANCE, "VALA_MEMBER_BINDING_INSTANCE", "instance"}, {VALA_MEMBER_BINDING_CLASS, "VALA_MEMBER_BINDING_CLASS", "class"}, {VALA_MEMBER_BINDING_STATIC, "VALA_MEMBER_BINDING_STATIC", "static"}, {0, NULL, NULL}};
		GType vala_member_binding_type_id;
		vala_member_binding_type_id = g_enum_register_static ("ValaMemberBinding", values);
		g_once_init_leave (&vala_member_binding_type_id__volatile, vala_member_binding_type_id);
	}
	return vala_member_binding_type_id__volatile;
}



