/* tagcloud.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from tagcloud.vala, do not modify */

/* tagcloud.vala
 *
 * Copyright (C) 2010  Andrea Del Signore
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Andrea Del Signore <sejerpz@tin.it>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>


#define VALA_TYPE_TAG_CLOUD (vala_tag_cloud_get_type ())
#define VALA_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloud))
#define VALA_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))
#define VALA_IS_TAG_CLOUD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD))
#define VALA_IS_TAG_CLOUD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD))
#define VALA_TAG_CLOUD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD, ValaTagCloudClass))

typedef struct _ValaTagCloud ValaTagCloud;
typedef struct _ValaTagCloudClass ValaTagCloudClass;
typedef struct _ValaTagCloudPrivate ValaTagCloudPrivate;

#define VALA_TYPE_TAG_CLOUD_ITEM (vala_tag_cloud_item_get_type ())
#define VALA_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItem))
#define VALA_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))
#define VALA_IS_TAG_CLOUD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_IS_TAG_CLOUD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TAG_CLOUD_ITEM))
#define VALA_TAG_CLOUD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TAG_CLOUD_ITEM, ValaTagCloudItemClass))

typedef struct _ValaTagCloudItem ValaTagCloudItem;
typedef struct _ValaTagCloudItemClass ValaTagCloudItemClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ValaTagCloudItemPrivate ValaTagCloudItemPrivate;

#define VALA_TYPE_SELECT_STATUS (vala_select_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_font_description_free0(var) ((var == NULL) ? NULL : (var = (pango_font_description_free (var), NULL)))

struct _ValaTagCloud {
	GtkDrawingArea parent_instance;
	ValaTagCloudPrivate * priv;
};

struct _ValaTagCloudClass {
	GtkDrawingAreaClass parent_class;
};

struct _ValaTagCloudPrivate {
	GList* _items;
};

struct _ValaTagCloudItem {
	GObject parent_instance;
	ValaTagCloudItemPrivate * priv;
	gint x;
	gint y;
	gint width;
	gint height;
};

struct _ValaTagCloudItemClass {
	GObjectClass parent_class;
};

typedef enum  {
	VALA_SELECT_STATUS_SELECTED,
	VALA_SELECT_STATUS_EXCLUDED,
	VALA_SELECT_STATUS_NOT_SELECTED
} ValaSelectStatus;


static gpointer vala_tag_cloud_parent_class = NULL;

GType vala_tag_cloud_get_type (void) G_GNUC_CONST;
GType vala_tag_cloud_item_get_type (void) G_GNUC_CONST;
#define VALA_TAG_CLOUD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TAG_CLOUD, ValaTagCloudPrivate))
enum  {
	VALA_TAG_CLOUD_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
ValaTagCloud* vala_tag_cloud_new (void);
ValaTagCloud* vala_tag_cloud_construct (GType object_type);
void vala_tag_cloud_add_item (ValaTagCloud* self, ValaTagCloudItem* item);
static void vala_tag_cloud_on_tag_item_selected_changed (ValaTagCloud* self, GObject* sender);
static void _vala_tag_cloud_on_tag_item_selected_changed_vala_tag_cloud_item_select_status_changed (ValaTagCloudItem* _sender, gpointer self);
ValaTagCloudItem* vala_tag_cloud_get_item_with_text (ValaTagCloud* self, const gchar* text);
const gchar* vala_tag_cloud_item_get_text (ValaTagCloudItem* self);
ValaTagCloudItem* vala_tag_cloud_hit_test (ValaTagCloud* self, gdouble x, gdouble y);
static gboolean vala_tag_cloud_real_button_release_event (GtkWidget* base, GdkEventButton* e);
GType vala_select_status_get_type (void) G_GNUC_CONST;
ValaSelectStatus vala_tag_cloud_item_get_select_status (ValaTagCloudItem* self);
void vala_tag_cloud_item_set_select_status (ValaTagCloudItem* self, ValaSelectStatus value);
static gboolean vala_tag_cloud_real_motion_notify_event (GtkWidget* base, GdkEventMotion* e);
gboolean vala_tag_cloud_item_get_hilighted (ValaTagCloudItem* self);
void vala_tag_cloud_item_set_hilighted (ValaTagCloudItem* self, gboolean value);
static gboolean vala_tag_cloud_real_draw (GtkWidget* base, cairo_t* c);
gint vala_tag_cloud_item_get_occourrences (ValaTagCloudItem* self);
static void vala_tag_cloud_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


ValaTagCloud* vala_tag_cloud_construct (GType object_type) {
	ValaTagCloud * self = NULL;
	self = (ValaTagCloud*) g_object_new (object_type, NULL);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (((GDK_BUTTON_MOTION_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK));
	return self;
}


ValaTagCloud* vala_tag_cloud_new (void) {
	return vala_tag_cloud_construct (VALA_TYPE_TAG_CLOUD);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_tag_cloud_on_tag_item_selected_changed_vala_tag_cloud_item_select_status_changed (ValaTagCloudItem* _sender, gpointer self) {
	vala_tag_cloud_on_tag_item_selected_changed (self, _sender);
}


void vala_tag_cloud_add_item (ValaTagCloud* self, ValaTagCloudItem* item) {
	ValaTagCloudItem* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (item);
	self->priv->_items = g_list_append (self->priv->_items, _tmp0_);
	g_signal_connect_object (item, "select-status-changed", (GCallback) _vala_tag_cloud_on_tag_item_selected_changed_vala_tag_cloud_item_select_status_changed, self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


ValaTagCloudItem* vala_tag_cloud_get_item_with_text (ValaTagCloud* self, const gchar* text) {
	ValaTagCloudItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* _tmp0_;
			ValaTagCloudItem* item;
			_tmp0_ = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			item = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = vala_tag_cloud_item_get_text (item);
				if (g_strcmp0 (_tmp1_, text) == 0) {
					result = item;
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	return result;
}


static void vala_tag_cloud_on_tag_item_selected_changed (ValaTagCloud* self, GObject* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_signal_emit_by_name (self, "selected-items-changed");
}


ValaTagCloudItem* vala_tag_cloud_hit_test (ValaTagCloud* self, gdouble x, gdouble y) {
	ValaTagCloudItem* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* _tmp0_;
			ValaTagCloudItem* item;
			_tmp0_ = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			item = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				if (item->x <= x) {
					_tmp1_ = x <= (item->x + item->width);
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					gboolean _tmp2_ = FALSE;
					if (item->y <= y) {
						_tmp2_ = y <= (item->y + item->height);
					} else {
						_tmp2_ = FALSE;
					}
					if (_tmp2_) {
						result = item;
						return result;
					}
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = NULL;
	return result;
}


static gboolean vala_tag_cloud_real_button_release_event (GtkWidget* base, GdkEventButton* e) {
	ValaTagCloud * self;
	gboolean result = FALSE;
	ValaTagCloudItem* _tmp0_ = NULL;
	ValaTagCloudItem* i;
	self = (ValaTagCloud*) base;
	_tmp0_ = vala_tag_cloud_hit_test (self, (*e).x, (*e).y);
	i = _tmp0_;
	if (i != NULL) {
		ValaSelectStatus _tmp1_;
		_tmp1_ = vala_tag_cloud_item_get_select_status (i);
		if (_tmp1_ == VALA_SELECT_STATUS_EXCLUDED) {
			vala_tag_cloud_item_set_select_status (i, VALA_SELECT_STATUS_SELECTED);
		} else {
			ValaSelectStatus _tmp2_;
			_tmp2_ = vala_tag_cloud_item_get_select_status (i);
			if (_tmp2_ == VALA_SELECT_STATUS_SELECTED) {
				vala_tag_cloud_item_set_select_status (i, VALA_SELECT_STATUS_EXCLUDED);
			}
		}
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	result = FALSE;
	_g_object_unref0 (i);
	return result;
}


static gboolean vala_tag_cloud_real_motion_notify_event (GtkWidget* base, GdkEventMotion* e) {
	ValaTagCloud * self;
	gboolean result = FALSE;
	self = (ValaTagCloud*) base;
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* _tmp0_;
			ValaTagCloudItem* item;
			_tmp0_ = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			item = _tmp0_;
			{
				ValaTagCloudItem* _tmp1_ = NULL;
				ValaTagCloudItem* _tmp2_;
				gboolean _tmp3_;
				gboolean hitted;
				gboolean _tmp4_;
				_tmp1_ = vala_tag_cloud_hit_test (self, (*e).x, (*e).y);
				_tmp2_ = _tmp1_;
				_tmp3_ = _tmp2_ == item;
				_g_object_unref0 (_tmp2_);
				hitted = _tmp3_;
				_tmp4_ = vala_tag_cloud_item_get_hilighted (item);
				if (_tmp4_ != hitted) {
					vala_tag_cloud_item_set_hilighted (item, hitted);
					gtk_widget_queue_draw_area ((GtkWidget*) self, item->x, item->y, item->width, item->height);
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean vala_tag_cloud_real_draw (GtkWidget* base, cairo_t* c) {
	ValaTagCloud * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint w;
	gint _tmp1_;
	gint h;
	PangoRectangle ink_rect = {0};
	PangoRectangle logical_rect = {0};
	GtkStyle* _tmp2_ = NULL;
	GtkStyle* _tmp3_;
	GtkStyle* style;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* font_name;
	PangoFontDescription* _tmp6_ = NULL;
	PangoFontDescription* font;
	gdouble x;
	gdouble y;
	gdouble max_size;
	gdouble min_size;
	gint min_occ;
	gint max_occ;
	gdouble multiplier;
	gdouble last_height;
	self = (ValaTagCloud*) base;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	w = _tmp0_;
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	h = _tmp1_;
	cairo_set_source_rgb (c, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_rectangle (c, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	cairo_fill (c);
	_tmp2_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	style = _tmp3_;
	_tmp4_ = pango_font_description_get_family (style->font_desc);
	_tmp5_ = g_strdup (_tmp4_);
	font_name = _tmp5_;
	_tmp6_ = pango_font_description_new ();
	font = _tmp6_;
	pango_font_description_set_family (font, font_name);
	pango_font_description_set_weight (font, PANGO_WEIGHT_NORMAL);
	cairo_select_font_face (c, font_name, CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	x = (gdouble) 4;
	y = (gdouble) 4;
	max_size = 24.0;
	min_size = 12.0;
	min_occ = 1;
	max_occ = 8;
	multiplier = (max_size - min_size) / (max_occ - min_occ);
	last_height = (gdouble) 0;
	{
		GList* item_collection;
		GList* item_it;
		item_collection = self->priv->_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			ValaTagCloudItem* _tmp7_;
			ValaTagCloudItem* item;
			_tmp7_ = _g_object_ref0 ((ValaTagCloudItem*) item_it->data);
			item = _tmp7_;
			{
				gint _tmp8_;
				gdouble size;
				PangoLayout* _tmp9_ = NULL;
				PangoLayout* layout;
				ValaSelectStatus _tmp10_;
				PangoRectangle _tmp15_ = {0};
				PangoRectangle _tmp16_ = {0};
				gdouble _tmp17_;
				gdouble _tmp18_;
				gdouble _tmp19_;
				gdouble _tmp20_;
				gboolean _tmp21_;
				gdouble radius;
				gboolean _tmp28_ = FALSE;
				ValaSelectStatus _tmp29_;
				gboolean _tmp31_;
				_tmp8_ = vala_tag_cloud_item_get_occourrences (item);
				size = min_size + ((max_occ - (max_occ - (_tmp8_ - min_occ))) * multiplier);
				pango_font_description_set_absolute_size (font, size * PANGO_SCALE);
				_tmp9_ = pango_cairo_create_layout (c);
				layout = _tmp9_;
				pango_layout_set_font_description (layout, font);
				_tmp10_ = vala_tag_cloud_item_get_select_status (item);
				if (_tmp10_ == VALA_SELECT_STATUS_EXCLUDED) {
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp11_ = vala_tag_cloud_item_get_text (item);
					_tmp12_ = g_strdup_printf ("<s>%s</s>", _tmp11_);
					_tmp13_ = _tmp12_;
					pango_layout_set_markup (layout, _tmp13_, -1);
					_g_free0 (_tmp13_);
				} else {
					const gchar* _tmp14_ = NULL;
					_tmp14_ = vala_tag_cloud_item_get_text (item);
					pango_layout_set_text (layout, _tmp14_, -1);
				}
				pango_layout_get_pixel_extents (layout, &_tmp15_, &_tmp16_);
				ink_rect = _tmp15_;
				logical_rect = _tmp16_;
				_tmp17_ = round ((gdouble) logical_rect.width);
				item->width = ((gint) _tmp17_) + 4;
				_tmp18_ = round ((gdouble) logical_rect.height);
				item->height = ((gint) _tmp18_) + 4;
				if ((x + item->width) >= (w - 4)) {
					x = (gdouble) 4;
					y = y + (last_height + 8);
				}
				_tmp19_ = round (x);
				item->x = (gint) _tmp19_;
				_tmp20_ = round (y);
				item->y = (gint) _tmp20_;
				_tmp21_ = vala_tag_cloud_item_get_hilighted (item);
				if (_tmp21_) {
					GdkColor _tmp22_;
					_tmp22_ = style->bg[GTK_STATE_PRELIGHT];
					gdk_cairo_set_source_color (c, &_tmp22_);
				} else {
					gboolean _tmp23_ = FALSE;
					ValaSelectStatus _tmp24_;
					_tmp24_ = vala_tag_cloud_item_get_select_status (item);
					if (_tmp24_ == VALA_SELECT_STATUS_SELECTED) {
						_tmp23_ = TRUE;
					} else {
						ValaSelectStatus _tmp25_;
						_tmp25_ = vala_tag_cloud_item_get_select_status (item);
						_tmp23_ = _tmp25_ == VALA_SELECT_STATUS_EXCLUDED;
					}
					if (_tmp23_) {
						GdkColor _tmp26_;
						_tmp26_ = style->bg[GTK_STATE_SELECTED];
						gdk_cairo_set_source_color (c, &_tmp26_);
					} else {
						GdkColor _tmp27_;
						_tmp27_ = style->bg[GTK_STATE_NORMAL];
						gdk_cairo_set_source_color (c, &_tmp27_);
					}
				}
				cairo_set_line_width (c, (gdouble) 2);
				cairo_set_line_cap (c, CAIRO_LINE_CAP_ROUND);
				cairo_set_line_join (c, CAIRO_LINE_JOIN_ROUND);
				radius = (gdouble) 5;
				cairo_move_to (c, item->x + radius, y);
				cairo_arc (c, (item->x + item->width) - radius, item->y + radius, radius, G_PI * 1.5, G_PI * 2);
				cairo_arc (c, (item->x + item->width) - radius, (item->y + item->height) - radius, radius, (gdouble) 0, G_PI * 0.5);
				cairo_arc (c, item->x + radius, (item->y + item->height) - radius, radius, G_PI * 0.5, G_PI);
				cairo_arc (c, item->x + radius, item->y + radius, radius, G_PI, G_PI * 1.5);
				_tmp29_ = vala_tag_cloud_item_get_select_status (item);
				if (_tmp29_ == VALA_SELECT_STATUS_SELECTED) {
					_tmp28_ = TRUE;
				} else {
					ValaSelectStatus _tmp30_;
					_tmp30_ = vala_tag_cloud_item_get_select_status (item);
					_tmp28_ = _tmp30_ == VALA_SELECT_STATUS_EXCLUDED;
				}
				if (_tmp28_) {
					cairo_fill (c);
				} else {
					cairo_stroke (c);
				}
				_tmp31_ = vala_tag_cloud_item_get_hilighted (item);
				if (_tmp31_) {
					GtkStyle* _tmp32_ = NULL;
					GdkColor _tmp33_;
					_tmp32_ = gtk_widget_get_style ((GtkWidget*) self);
					_tmp33_ = _tmp32_->fg[GTK_STATE_ACTIVE];
					gdk_cairo_set_source_color (c, &_tmp33_);
				} else {
					GtkStyle* _tmp34_ = NULL;
					GdkColor _tmp35_;
					_tmp34_ = gtk_widget_get_style ((GtkWidget*) self);
					_tmp35_ = _tmp34_->fg[GTK_STATE_NORMAL];
					gdk_cairo_set_source_color (c, &_tmp35_);
				}
				cairo_move_to (c, (gdouble) (item->x + 1), (gdouble) (item->y + 1));
				pango_cairo_show_layout (c, layout);
				x = x + ((gdouble) (logical_rect.width + 8));
				last_height = (gdouble) item->height;
				_g_object_unref0 (layout);
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	_pango_font_description_free0 (font);
	_g_free0 (font_name);
	_g_object_unref0 (style);
	return result;
}


static void vala_tag_cloud_class_init (ValaTagCloudClass * klass) {
	vala_tag_cloud_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTagCloudPrivate));
	GTK_WIDGET_CLASS (klass)->button_release_event = vala_tag_cloud_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = vala_tag_cloud_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->draw = vala_tag_cloud_real_draw;
	G_OBJECT_CLASS (klass)->finalize = vala_tag_cloud_finalize;
	g_signal_new ("selected_items_changed", VALA_TYPE_TAG_CLOUD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vala_tag_cloud_instance_init (ValaTagCloud * self) {
	self->priv = VALA_TAG_CLOUD_GET_PRIVATE (self);
	self->priv->_items = NULL;
}


static void vala_tag_cloud_finalize (GObject* obj) {
	ValaTagCloud * self;
	self = VALA_TAG_CLOUD (obj);
	__g_list_free__g_object_unref0_0 (self->priv->_items);
	G_OBJECT_CLASS (vala_tag_cloud_parent_class)->finalize (obj);
}


GType vala_tag_cloud_get_type (void) {
	static volatile gsize vala_tag_cloud_type_id__volatile = 0;
	if (g_once_init_enter (&vala_tag_cloud_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTagCloudClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_tag_cloud_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTagCloud), 0, (GInstanceInitFunc) vala_tag_cloud_instance_init, NULL };
		GType vala_tag_cloud_type_id;
		vala_tag_cloud_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "ValaTagCloud", &g_define_type_info, 0);
		g_once_init_leave (&vala_tag_cloud_type_id__volatile, vala_tag_cloud_type_id);
	}
	return vala_tag_cloud_type_id__volatile;
}



