/* vbfautotools.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vbfautotools.vala, do not modify */

/*
 *  vbfautotools.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define VBF_TYPE_IPROJECT_BACKEND (vbf_iproject_backend_get_type ())
#define VBF_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackend))
#define VBF_IS_IPROJECT_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_IPROJECT_BACKEND))
#define VBF_IPROJECT_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VBF_TYPE_IPROJECT_BACKEND, VbfIProjectBackendIface))

typedef struct _VbfIProjectBackend VbfIProjectBackend;
typedef struct _VbfIProjectBackendIface VbfIProjectBackendIface;

#define VBF_TYPE_CONFIG_NODE (vbf_config_node_get_type ())
#define VBF_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNode))
#define VBF_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))
#define VBF_IS_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE))
#define VBF_IS_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE))
#define VBF_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE, VbfConfigNodeClass))

typedef struct _VbfConfigNode VbfConfigNode;
typedef struct _VbfConfigNodeClass VbfConfigNodeClass;

#define VBF_TYPE_PROJECT (vbf_project_get_type ())
#define VBF_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PROJECT, VbfProject))
#define VBF_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PROJECT, VbfProjectClass))
#define VBF_IS_PROJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PROJECT))
#define VBF_IS_PROJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PROJECT))
#define VBF_PROJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PROJECT, VbfProjectClass))

typedef struct _VbfProject VbfProject;
typedef struct _VbfProjectClass VbfProjectClass;

#define VBF_BACKENDS_TYPE_AUTOTOOLS (vbf_backends_autotools_get_type ())
#define VBF_BACKENDS_AUTOTOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotools))
#define VBF_BACKENDS_AUTOTOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotoolsClass))
#define VBF_BACKENDS_IS_AUTOTOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_BACKENDS_TYPE_AUTOTOOLS))
#define VBF_BACKENDS_IS_AUTOTOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_BACKENDS_TYPE_AUTOTOOLS))
#define VBF_BACKENDS_AUTOTOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotoolsClass))

typedef struct _VbfBackendsAutotools VbfBackendsAutotools;
typedef struct _VbfBackendsAutotoolsClass VbfBackendsAutotoolsClass;
typedef struct _VbfBackendsAutotoolsPrivate VbfBackendsAutotoolsPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _VbfConfigNodePrivate VbfConfigNodePrivate;
typedef struct _VbfProjectPrivate VbfProjectPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define VBF_TYPE_GROUP (vbf_group_get_type ())
#define VBF_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_GROUP, VbfGroup))
#define VBF_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_GROUP, VbfGroupClass))
#define VBF_IS_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_GROUP))
#define VBF_IS_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_GROUP))
#define VBF_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_GROUP, VbfGroupClass))

typedef struct _VbfGroup VbfGroup;
typedef struct _VbfGroupClass VbfGroupClass;

#define VBF_TYPE_VARIABLE (vbf_variable_get_type ())
#define VBF_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_VARIABLE, VbfVariable))
#define VBF_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_VARIABLE, VbfVariableClass))
#define VBF_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_VARIABLE))
#define VBF_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_VARIABLE))
#define VBF_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_VARIABLE, VbfVariableClass))

typedef struct _VbfVariable VbfVariable;
typedef struct _VbfVariableClass VbfVariableClass;

#define VBF_TYPE_MODULE (vbf_module_get_type ())
#define VBF_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_MODULE, VbfModule))
#define VBF_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_MODULE, VbfModuleClass))
#define VBF_IS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_MODULE))
#define VBF_IS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_MODULE))
#define VBF_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_MODULE, VbfModuleClass))

typedef struct _VbfModule VbfModule;
typedef struct _VbfModuleClass VbfModuleClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VBF_TYPE_PACKAGE (vbf_package_get_type ())
#define VBF_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_PACKAGE, VbfPackage))
#define VBF_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_PACKAGE, VbfPackageClass))
#define VBF_IS_PACKAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_PACKAGE))
#define VBF_IS_PACKAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_PACKAGE))
#define VBF_PACKAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_PACKAGE, VbfPackageClass))

typedef struct _VbfPackage VbfPackage;
typedef struct _VbfPackageClass VbfPackageClass;
typedef struct _VbfPackagePrivate VbfPackagePrivate;

#define VBF_TYPE_TARGET (vbf_target_get_type ())
#define VBF_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_TARGET, VbfTarget))
#define VBF_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_TARGET, VbfTargetClass))
#define VBF_IS_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_TARGET))
#define VBF_IS_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_TARGET))
#define VBF_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_TARGET, VbfTargetClass))

typedef struct _VbfTarget VbfTarget;
typedef struct _VbfTargetClass VbfTargetClass;

#define VBF_TYPE_UNRESOLVED_CONFIG_NODE (vbf_unresolved_config_node_get_type ())
#define VBF_UNRESOLVED_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_UNRESOLVED_CONFIG_NODE, VbfUnresolvedConfigNode))
#define VBF_UNRESOLVED_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_UNRESOLVED_CONFIG_NODE, VbfUnresolvedConfigNodeClass))
#define VBF_IS_UNRESOLVED_CONFIG_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_UNRESOLVED_CONFIG_NODE))
#define VBF_IS_UNRESOLVED_CONFIG_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_UNRESOLVED_CONFIG_NODE))
#define VBF_UNRESOLVED_CONFIG_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_UNRESOLVED_CONFIG_NODE, VbfUnresolvedConfigNodeClass))

typedef struct _VbfUnresolvedConfigNode VbfUnresolvedConfigNode;
typedef struct _VbfUnresolvedConfigNodeClass VbfUnresolvedConfigNodeClass;

#define VBF_TYPE_STRING_LITERAL (vbf_string_literal_get_type ())
#define VBF_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_STRING_LITERAL, VbfStringLiteral))
#define VBF_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_STRING_LITERAL, VbfStringLiteralClass))
#define VBF_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_STRING_LITERAL))
#define VBF_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_STRING_LITERAL))
#define VBF_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_STRING_LITERAL, VbfStringLiteralClass))

typedef struct _VbfStringLiteral VbfStringLiteral;
typedef struct _VbfStringLiteralClass VbfStringLiteralClass;

#define VBF_TYPE_FILE_TYPES (vbf_file_types_get_type ())
typedef struct _VbfStringLiteralPrivate VbfStringLiteralPrivate;
typedef struct _VbfGroupPrivate VbfGroupPrivate;

#define VBF_TYPE_FILE (vbf_file_get_type ())
#define VBF_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_FILE, VbfFile))
#define VBF_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_FILE, VbfFileClass))
#define VBF_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_FILE))
#define VBF_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_FILE))
#define VBF_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_FILE, VbfFileClass))

typedef struct _VbfFile VbfFile;
typedef struct _VbfFileClass VbfFileClass;

#define VBF_TYPE_SOURCE (vbf_source_get_type ())
#define VBF_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_SOURCE, VbfSource))
#define VBF_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_SOURCE, VbfSourceClass))
#define VBF_IS_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_SOURCE))
#define VBF_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_SOURCE))
#define VBF_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_SOURCE, VbfSourceClass))

typedef struct _VbfSource VbfSource;
typedef struct _VbfSourceClass VbfSourceClass;

#define VBF_TYPE_CONFIG_NODE_LIST (vbf_config_node_list_get_type ())
#define VBF_CONFIG_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE_LIST, VbfConfigNodeList))
#define VBF_CONFIG_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE_LIST, VbfConfigNodeListClass))
#define VBF_IS_CONFIG_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE_LIST))
#define VBF_IS_CONFIG_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE_LIST))
#define VBF_CONFIG_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE_LIST, VbfConfigNodeListClass))

typedef struct _VbfConfigNodeList VbfConfigNodeList;
typedef struct _VbfConfigNodeListClass VbfConfigNodeListClass;
typedef struct _VbfTargetPrivate VbfTargetPrivate;

#define VBF_TYPE_TARGET_TYPES (vbf_target_types_get_type ())
typedef struct _VbfVariablePrivate VbfVariablePrivate;
typedef struct _VbfUnresolvedConfigNodePrivate VbfUnresolvedConfigNodePrivate;

#define VBF_TYPE_CONFIG_NODE_PAIR (vbf_config_node_pair_get_type ())
#define VBF_CONFIG_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VBF_TYPE_CONFIG_NODE_PAIR, VbfConfigNodePair))
#define VBF_CONFIG_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VBF_TYPE_CONFIG_NODE_PAIR, VbfConfigNodePairClass))
#define VBF_IS_CONFIG_NODE_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VBF_TYPE_CONFIG_NODE_PAIR))
#define VBF_IS_CONFIG_NODE_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VBF_TYPE_CONFIG_NODE_PAIR))
#define VBF_CONFIG_NODE_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VBF_TYPE_CONFIG_NODE_PAIR, VbfConfigNodePairClass))

typedef struct _VbfConfigNodePair VbfConfigNodePair;
typedef struct _VbfConfigNodePairClass VbfConfigNodePairClass;
typedef struct _VbfConfigNodePairPrivate VbfConfigNodePairPrivate;

struct _VbfIProjectBackendIface {
	GTypeInterface parent_iface;
	gboolean (*probe) (VbfIProjectBackend* self, const gchar* project_file);
	VbfProject* (*open) (VbfIProjectBackend* self, const gchar* project_file);
	void (*refresh) (VbfIProjectBackend* self, VbfProject* project);
	gchar* (*get_configure_command) (VbfIProjectBackend* self);
	gchar* (*get_build_command) (VbfIProjectBackend* self);
	gchar* (*get_clean_command) (VbfIProjectBackend* self);
};

struct _VbfBackendsAutotools {
	GObject parent_instance;
	VbfBackendsAutotoolsPrivate * priv;
};

struct _VbfBackendsAutotoolsClass {
	GObjectClass parent_class;
};

struct _VbfBackendsAutotoolsPrivate {
	VbfProject* _project;
	ValaList* file_mons;
};

struct _VbfConfigNode {
	GObject parent_instance;
	VbfConfigNodePrivate * priv;
	VbfConfigNode* parent;
};

struct _VbfConfigNodeClass {
	GObjectClass parent_class;
	gchar* (*to_string) (VbfConfigNode* self);
};

struct _VbfProject {
	VbfConfigNode parent_instance;
	VbfProjectPrivate * priv;
	gchar* id;
	gchar* name;
	gchar* url;
	gchar* version;
	gchar* working_dir;
	VbfIProjectBackend* backend;
};

struct _VbfProjectClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfPackage {
	GObject parent_instance;
	VbfPackagePrivate * priv;
	gchar* id;
	gchar* name;
	gchar* constraint;
	VbfConfigNode* version;
	VbfTarget* parent_target;
	VbfGroup* parent_group;
	VbfModule* parent_module;
};

struct _VbfPackageClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_FILE_TYPES_UNKNOWN,
	VBF_FILE_TYPES_DATA,
	VBF_FILE_TYPES_VALA_SOURCE,
	VBF_FILE_TYPES_OTHER_SOURCE
} VbfFileTypes;

struct _VbfStringLiteral {
	VbfConfigNode parent_instance;
	VbfStringLiteralPrivate * priv;
	gchar* data;
};

struct _VbfStringLiteralClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfGroup {
	GObject parent_instance;
	VbfGroupPrivate * priv;
	gchar* name;
	gchar* id;
	VbfProject* project;
};

struct _VbfGroupClass {
	GObjectClass parent_class;
};

typedef enum  {
	VBF_TARGET_TYPES_PROGRAM,
	VBF_TARGET_TYPES_LIBRARY,
	VBF_TARGET_TYPES_DATA,
	VBF_TARGET_TYPES_BUILT_SOURCES
} VbfTargetTypes;

struct _VbfTarget {
	GObject parent_instance;
	VbfTargetPrivate * priv;
	gchar* id;
	gchar* name;
	VbfTargetTypes type;
	gboolean no_install;
	VbfGroup* group;
};

struct _VbfTargetClass {
	GObjectClass parent_class;
};

struct _VbfVariable {
	VbfConfigNode parent_instance;
	VbfVariablePrivate * priv;
	gchar* name;
	VbfConfigNode* data;
};

struct _VbfVariableClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfUnresolvedConfigNode {
	VbfConfigNode parent_instance;
	VbfUnresolvedConfigNodePrivate * priv;
	gchar* name;
};

struct _VbfUnresolvedConfigNodeClass {
	VbfConfigNodeClass parent_class;
};

struct _VbfConfigNodePair {
	GObject parent_instance;
	VbfConfigNodePairPrivate * priv;
	VbfConfigNode* source;
	VbfConfigNode* destination;
};

struct _VbfConfigNodePairClass {
	GObjectClass parent_class;
};


static gpointer vbf_backends_autotools_parent_class = NULL;
static VbfIProjectBackendIface* vbf_backends_autotools_vbf_iproject_backend_parent_iface = NULL;

GType vbf_config_node_get_type (void) G_GNUC_CONST;
GType vbf_project_get_type (void) G_GNUC_CONST;
GType vbf_iproject_backend_get_type (void) G_GNUC_CONST;
GType vbf_backends_autotools_get_type (void) G_GNUC_CONST;
#define VBF_BACKENDS_AUTOTOOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VBF_BACKENDS_TYPE_AUTOTOOLS, VbfBackendsAutotoolsPrivate))
enum  {
	VBF_BACKENDS_AUTOTOOLS_DUMMY_PROPERTY,
	VBF_BACKENDS_AUTOTOOLS_CONFIGURE_COMMAND,
	VBF_BACKENDS_AUTOTOOLS_BUILD_COMMAND,
	VBF_BACKENDS_AUTOTOOLS_CLEAN_COMMAND
};
static gboolean vbf_backends_autotools_real_probe (VbfIProjectBackend* base, const gchar* project_file);
gboolean vbf_utils_is_autotools_project (const gchar* path);
static VbfProject* vbf_backends_autotools_real_open (VbfIProjectBackend* base, const gchar* project_file);
VbfProject* vbf_project_new (const gchar* id);
VbfProject* vbf_project_construct (GType object_type, const gchar* id);
void vbf_iproject_backend_refresh (VbfIProjectBackend* self, VbfProject* project);
static void vbf_backends_autotools_real_refresh (VbfIProjectBackend* base, VbfProject* project);
static void vbf_backends_autotools_cleanup_file_monitors (VbfBackendsAutotools* self);
void vbf_project_clear (VbfProject* self);
static gchar* vbf_backends_autotools_normalize_string (VbfBackendsAutotools* self, const gchar* data);
GType vbf_group_get_type (void) G_GNUC_CONST;
static void vbf_backends_autotools_parse_variables (VbfBackendsAutotools* self, VbfProject* project, const gchar* buffer, VbfGroup* group, GError** error);
GType vbf_variable_get_type (void) G_GNUC_CONST;
static void vbf_backends_autotools_resolve_variables (VbfBackendsAutotools* self, VbfProject* project, ValaList* variables);
ValaList* vbf_project_get_variables (VbfProject* self);
VbfModule* vbf_module_new (VbfProject* project, const gchar* id);
VbfModule* vbf_module_construct (GType object_type, VbfProject* project, const gchar* id);
GType vbf_module_get_type (void) G_GNUC_CONST;
void vbf_project_add_module (VbfProject* self, VbfModule* module);
void vbf_utils_trace (const gchar* format, ...);
static VbfVariable* vbf_backends_autotools_resolve_variable (VbfBackendsAutotools* self, const gchar* variable_name, ValaList* variables);
VbfConfigNode* vbf_variable_get_value (VbfVariable* self);
gchar* vbf_config_node_to_string (VbfConfigNode* self);
VbfPackage* vbf_package_new (const gchar* id);
VbfPackage* vbf_package_construct (GType object_type, const gchar* id);
GType vbf_package_get_type (void) G_GNUC_CONST;
void vbf_module_add_package (VbfModule* self, VbfPackage* package);
GType vbf_target_get_type (void) G_GNUC_CONST;
VbfUnresolvedConfigNode* vbf_unresolved_config_node_new (const gchar* name);
VbfUnresolvedConfigNode* vbf_unresolved_config_node_construct (GType object_type, const gchar* name);
GType vbf_unresolved_config_node_get_type (void) G_GNUC_CONST;
VbfStringLiteral* vbf_string_literal_new (const gchar* data);
VbfStringLiteral* vbf_string_literal_construct (GType object_type, const gchar* data);
GType vbf_string_literal_get_type (void) G_GNUC_CONST;
static void vbf_backends_autotools_resolve_package_variables (VbfBackendsAutotools* self, VbfProject* project);
static void vbf_backends_autotools_parse_makefile (VbfBackendsAutotools* self, VbfProject* project, const gchar* project_file, const gchar* makefile, GError** error);
static void vbf_backends_autotools_setup_file_monitors (VbfBackendsAutotools* self, VbfProject* project);
GType vbf_file_types_get_type (void) G_GNUC_CONST;
static VbfFileTypes vbf_backends_autotools_source_file_type (VbfBackendsAutotools* self, const gchar* name);
static void vbf_backends_autotools_add_source (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* source);
VbfSource* vbf_source_new_with_type (VbfTarget* target, const gchar* filename, VbfFileTypes type);
VbfSource* vbf_source_construct_with_type (GType object_type, VbfTarget* target, const gchar* filename, VbfFileTypes type);
GType vbf_file_get_type (void) G_GNUC_CONST;
GType vbf_source_get_type (void) G_GNUC_CONST;
void vbf_target_add_source (VbfTarget* self, VbfSource* source);
GType vbf_config_node_list_get_type (void) G_GNUC_CONST;
ValaList* vbf_config_node_list_get_values (VbfConfigNodeList* self);
static void vbf_backends_autotools_add_vala_sources (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target);
static gchar* vbf_backends_autotools_convert_to_primary_name (VbfBackendsAutotools* self, const gchar* data);
GType vbf_target_types_get_type (void) G_GNUC_CONST;
ValaList* vbf_group_get_variables (VbfGroup* self);
static void vbf_backends_autotools_add_target (VbfBackendsAutotools* self, VbfGroup* group, VbfTargetTypes type, const gchar* target_id);
static gchar* vbf_backends_autotools_normalize_target_id (VbfBackendsAutotools* self, const gchar* target_id);
gboolean vbf_group_contains_target (VbfGroup* self, const gchar* id);
static gchar* vbf_backends_autotools_normalize_target_id_for_display (VbfBackendsAutotools* self, const gchar* target_id);
VbfTarget* vbf_target_new (VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name);
VbfTarget* vbf_target_construct (GType object_type, VbfGroup* group, VbfTargetTypes type, const gchar* id, const gchar* name);
void vbf_group_add_target (VbfGroup* self, VbfTarget* target);
static void vbf_backends_autotools_add_targets (VbfBackendsAutotools* self, VbfGroup* group, VbfConfigNode* node, VbfTargetTypes type);
static void vbf_backends_autotools_add_data_files (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* file);
VbfFile* vbf_file_new_with_type (VbfTarget* target, const gchar* filename, VbfFileTypes type);
VbfFile* vbf_file_construct_with_type (GType object_type, VbfTarget* target, const gchar* filename, VbfFileTypes type);
void vbf_target_add_file (VbfTarget* self, VbfFile* file);
static void vbf_backends_autotools_parse_targets (VbfBackendsAutotools* self, VbfGroup* group);
VbfVariable* vbf_variable_new (const gchar* name, VbfConfigNode* parent);
VbfVariable* vbf_variable_construct (GType object_type, const gchar* name, VbfConfigNode* parent);
VbfConfigNodeList* vbf_config_node_list_new (void);
VbfConfigNodeList* vbf_config_node_list_construct (GType object_type);
void vbf_config_node_list_add_value (VbfConfigNodeList* self, VbfConfigNode* val);
void vbf_group_add_variable (VbfGroup* self, VbfVariable* variable);
void vbf_project_add_variable (VbfProject* self, VbfVariable* variable);
ValaList* vbf_project_get_modules (VbfProject* self);
ValaList* vbf_module_get_packages (VbfModule* self);
void vbf_variable_add_child (VbfVariable* self, VbfVariable* variable);
GType vbf_config_node_pair_get_type (void) G_GNUC_CONST;
VbfConfigNodePair* vbf_config_node_pair_new (VbfConfigNode* source, VbfConfigNode* destination);
VbfConfigNodePair* vbf_config_node_pair_construct (GType object_type, VbfConfigNode* source, VbfConfigNode* destination);
void vbf_config_node_list_replace_config_node (VbfConfigNodeList* self, VbfConfigNode* source, VbfConfigNode* target);
static gchar* vbf_backends_autotools_process_include_directives (VbfBackendsAutotools* self, const gchar* makefile, const gchar* buffer, GError** error);
VbfGroup* vbf_group_new (VbfProject* project, const gchar* id);
VbfGroup* vbf_group_construct (GType object_type, VbfProject* project, const gchar* id);
void vbf_project_add_group (VbfProject* self, VbfGroup* group);
static void vbf_backends_autotools_parse_group_extended_info (VbfBackendsAutotools* self, VbfGroup* group, const gchar* buffer);
ValaList* vbf_group_get_targets (VbfGroup* self);
VbfTarget* vbf_group_get_target_for_id (VbfGroup* self, const gchar* id);
void vbf_target_add_include_dir (VbfTarget* self, const gchar* dir);
void vbf_group_add_include_dir (VbfGroup* self, const gchar* dir);
static gchar* vbf_backends_autotools_substitute_variables (VbfBackendsAutotools* self, const gchar* data, ValaList* variables);
void vbf_target_add_package (VbfTarget* self, VbfPackage* package);
void vbf_group_add_package (VbfGroup* self, VbfPackage* package);
void vbf_target_add_built_library (VbfTarget* self, const gchar* dir);
void vbf_group_add_built_library (VbfGroup* self, const gchar* dir);
ValaList* vbf_project_get_groups (VbfProject* self);
static void vbf_backends_autotools_on_project_file_changed (VbfBackendsAutotools* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
void vbf_project_update (VbfProject* self);
VbfBackendsAutotools* vbf_backends_autotools_new (void);
VbfBackendsAutotools* vbf_backends_autotools_construct (GType object_type);
static void vbf_backends_autotools_finalize (GObject* obj);
gchar* vbf_iproject_backend_get_configure_command (VbfIProjectBackend* self);
gchar* vbf_iproject_backend_get_build_command (VbfIProjectBackend* self);
gchar* vbf_iproject_backend_get_clean_command (VbfIProjectBackend* self);
static void _vala_vbf_backends_autotools_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean vbf_backends_autotools_real_probe (VbfIProjectBackend* base, const gchar* project_file) {
	VbfBackendsAutotools * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (VbfBackendsAutotools*) base;
	g_return_val_if_fail (project_file != NULL, FALSE);
	_tmp0_ = vbf_utils_is_autotools_project (project_file);
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static VbfProject* vbf_backends_autotools_real_open (VbfIProjectBackend* base, const gchar* project_file) {
	VbfBackendsAutotools * self;
	VbfProject* result = NULL;
	VbfProject* _tmp0_ = NULL;
	VbfProject* project;
	self = (VbfBackendsAutotools*) base;
	g_return_val_if_fail (project_file != NULL, NULL);
	_tmp0_ = vbf_project_new (project_file);
	project = _tmp0_;
	vbf_iproject_backend_refresh ((VbfIProjectBackend*) self, project);
	if (project->name == NULL) {
		result = NULL;
		_g_object_unref0 (project);
		return result;
	} else {
		VbfIProjectBackend* _tmp1_;
		self->priv->_project = project;
		_tmp1_ = _g_object_ref0 ((VbfIProjectBackend*) self);
		_g_object_unref0 (project->backend);
		project->backend = _tmp1_;
		result = project;
		return result;
	}
	_g_object_unref0 (project);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch6_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch6_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally6;
	__catch6_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void vbf_backends_autotools_real_refresh (VbfIProjectBackend* base, VbfProject* project) {
	VbfBackendsAutotools * self;
	gchar* _tmp0_ = NULL;
	gchar* file;
	gchar* buffer = NULL;
	gulong length = 0UL;
	gchar* _tmp1_ = NULL;
	gsize _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GRegex* _tmp5_ = NULL;
	GRegex* reg;
	GMatchInfo* match = NULL;
	gchar* name;
	gchar* version;
	gchar* url;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	gchar* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	ValaList* _tmp45_ = NULL;
	ValaList* _tmp46_;
	GRegex* _tmp47_ = NULL;
	GRegex* _tmp48_;
	GMatchInfo* _tmp49_ = NULL;
	gboolean _tmp50_;
	GRegex* _tmp106_ = NULL;
	GRegex* _tmp107_;
	GMatchInfo* _tmp108_ = NULL;
	gboolean _tmp109_;
	gboolean res;
	GError * _inner_error_ = NULL;
	self = (VbfBackendsAutotools*) base;
	g_return_if_fail (project != NULL);
	vbf_backends_autotools_cleanup_file_monitors (self);
	_tmp0_ = g_build_filename (project->id, "configure.ac", NULL);
	file = _tmp0_;
	_tmp3_ = g_file_get_contents (file, &_tmp1_, &_tmp2_, &_inner_error_);
	_g_free0 (buffer);
	buffer = _tmp1_;
	length = (gulong) _tmp2_;
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		_g_free0 (buffer);
		_g_free0 (file);
		goto __catch5_g_error;
	}
	if (!_tmp4_) {
		_g_free0 (buffer);
		_g_free0 (file);
		return;
	}
	_tmp5_ = g_regex_new ("AC_INIT\\(([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
	reg = _tmp5_;
	if (_inner_error_ != NULL) {
		_g_free0 (buffer);
		_g_free0 (file);
		goto __catch5_g_error;
	}
	name = NULL;
	version = NULL;
	url = NULL;
	_tmp7_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp6_);
	_g_match_info_free0 (match);
	match = _tmp6_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		_tmp8_ = g_match_info_fetch (match, 1);
		_g_free0 (name);
		name = _tmp8_;
	} else {
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_;
		GMatchInfo* _tmp11_ = NULL;
		gboolean _tmp12_;
		_tmp9_ = g_regex_new ("AC_INIT\\(([^\\,\\)]+),([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			_g_free0 (url);
			_g_free0 (version);
			_g_free0 (name);
			_g_match_info_free0 (match);
			_g_regex_unref0 (reg);
			_g_free0 (buffer);
			_g_free0 (file);
			goto __catch5_g_error;
		}
		_g_regex_unref0 (reg);
		reg = _tmp10_;
		_tmp12_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp11_);
		_g_match_info_free0 (match);
		match = _tmp11_;
		if (_tmp12_) {
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp13_ = g_match_info_fetch (match, 1);
			_g_free0 (name);
			name = _tmp13_;
			_tmp14_ = g_match_info_fetch (match, 2);
			_g_free0 (version);
			version = _tmp14_;
		} else {
			GRegex* _tmp15_ = NULL;
			GRegex* _tmp16_;
			GMatchInfo* _tmp17_ = NULL;
			gboolean _tmp18_;
			_tmp15_ = g_regex_new ("AC_INIT\\(([^\\,\\)]+),([^\\,\\)]+),([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
			_tmp16_ = _tmp15_;
			if (_inner_error_ != NULL) {
				_g_free0 (url);
				_g_free0 (version);
				_g_free0 (name);
				_g_match_info_free0 (match);
				_g_regex_unref0 (reg);
				_g_free0 (buffer);
				_g_free0 (file);
				goto __catch5_g_error;
			}
			_g_regex_unref0 (reg);
			reg = _tmp16_;
			_tmp18_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp17_);
			_g_match_info_free0 (match);
			match = _tmp17_;
			if (_tmp18_) {
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				_tmp19_ = g_match_info_fetch (match, 1);
				_g_free0 (name);
				name = _tmp19_;
				_tmp20_ = g_match_info_fetch (match, 2);
				_g_free0 (version);
				version = _tmp20_;
				_tmp21_ = g_match_info_fetch (match, 3);
				_g_free0 (url);
				url = _tmp21_;
			} else {
				GRegex* _tmp22_ = NULL;
				GRegex* _tmp23_;
				GMatchInfo* _tmp24_ = NULL;
				gboolean _tmp25_;
				_tmp22_ = g_regex_new ("AC_INIT\\(([^\\,\\)]+),([^\\,\\)]+),([^\\,\\)]+),([^\\,\\)]+)\\)", 0, 0, &_inner_error_);
				_tmp23_ = _tmp22_;
				if (_inner_error_ != NULL) {
					_g_free0 (url);
					_g_free0 (version);
					_g_free0 (name);
					_g_match_info_free0 (match);
					_g_regex_unref0 (reg);
					_g_free0 (buffer);
					_g_free0 (file);
					goto __catch5_g_error;
				}
				_g_regex_unref0 (reg);
				reg = _tmp23_;
				_tmp25_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp24_);
				_g_match_info_free0 (match);
				match = _tmp24_;
				if (_tmp25_) {
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					_tmp26_ = g_match_info_fetch (match, 1);
					_g_free0 (name);
					name = _tmp26_;
					_tmp27_ = g_match_info_fetch (match, 2);
					_g_free0 (version);
					version = _tmp27_;
					_tmp28_ = g_match_info_fetch (match, 3);
					_g_free0 (url);
					url = _tmp28_;
				} else {
					GRegex* _tmp29_ = NULL;
					GRegex* _tmp30_;
					GMatchInfo* _tmp31_ = NULL;
					gboolean _tmp32_;
					_tmp29_ = g_regex_new ("AC_INIT\\s*\\(\\[(.*)\\],\\s*\\[(.*)\\],\\s*\\[(.*)\\],", G_REGEX_MULTILINE, 0, &_inner_error_);
					_tmp30_ = _tmp29_;
					if (_inner_error_ != NULL) {
						_g_free0 (url);
						_g_free0 (version);
						_g_free0 (name);
						_g_match_info_free0 (match);
						_g_regex_unref0 (reg);
						_g_free0 (buffer);
						_g_free0 (file);
						goto __catch5_g_error;
					}
					_g_regex_unref0 (reg);
					reg = _tmp30_;
					_tmp32_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_ANY, &_tmp31_);
					_g_match_info_free0 (match);
					match = _tmp31_;
					if (_tmp32_) {
						gchar* _tmp33_ = NULL;
						gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						_tmp33_ = g_match_info_fetch (match, 1);
						_g_free0 (name);
						name = _tmp33_;
						_tmp34_ = g_match_info_fetch (match, 2);
						_g_free0 (version);
						version = _tmp34_;
						_tmp35_ = g_match_info_fetch (match, 3);
						_g_free0 (url);
						url = _tmp35_;
					}
				}
			}
		}
	}
	vbf_project_clear (project);
	_tmp36_ = vbf_backends_autotools_normalize_string (self, name);
	_g_free0 (project->name);
	project->name = _tmp36_;
	if (version != NULL) {
		_tmp38_ = g_strcmp0 (version, "") != 0;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		gchar _tmp39_;
		gboolean _tmp40_;
		_tmp39_ = string_get (version, (glong) 0);
		_tmp40_ = g_ascii_isdigit (_tmp39_);
		_tmp37_ = _tmp40_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		gchar* _tmp41_ = NULL;
		_tmp41_ = vbf_backends_autotools_normalize_string (self, version);
		_g_free0 (project->version);
		project->version = _tmp41_;
	} else {
		gchar* _tmp42_;
		_tmp42_ = g_strdup ("");
		_g_free0 (project->version);
		project->version = _tmp42_;
	}
	_tmp43_ = vbf_backends_autotools_normalize_string (self, url);
	_g_free0 (project->url);
	project->url = _tmp43_;
	_tmp44_ = g_strdup (project->id);
	_g_free0 (project->working_dir);
	project->working_dir = _tmp44_;
	vbf_backends_autotools_parse_variables (self, project, buffer, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (url);
		_g_free0 (version);
		_g_free0 (name);
		_g_match_info_free0 (match);
		_g_regex_unref0 (reg);
		_g_free0 (buffer);
		_g_free0 (file);
		goto __catch5_g_error;
	}
	_tmp45_ = vbf_project_get_variables (project);
	_tmp46_ = _tmp45_;
	vbf_backends_autotools_resolve_variables (self, project, _tmp46_);
	_vala_iterable_unref0 (_tmp46_);
	_tmp47_ = g_regex_new ("PKG_CHECK_MODULES\\([\\s\\[]*([^\\,\\)\\]]+)[\\s\\]]*\\,(.+?)\\)", 0, 0, &_inner_error_);
	_tmp48_ = _tmp47_;
	if (_inner_error_ != NULL) {
		_g_free0 (url);
		_g_free0 (version);
		_g_free0 (name);
		_g_match_info_free0 (match);
		_g_regex_unref0 (reg);
		_g_free0 (buffer);
		_g_free0 (file);
		goto __catch5_g_error;
	}
	_g_regex_unref0 (reg);
	reg = _tmp48_;
	_tmp50_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_CR, &_tmp49_);
	_g_match_info_free0 (match);
	match = _tmp49_;
	if (_tmp50_) {
		while (TRUE) {
			gboolean _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* mod_name;
			gchar* _tmp53_;
			gchar* pacs;
			gchar* _tmp54_ = NULL;
			gchar* line;
			GRegex* _tmp55_ = NULL;
			GRegex* mod;
			GMatchInfo* pac = NULL;
			GMatchInfo* _tmp56_ = NULL;
			gboolean _tmp57_;
			VbfModule* _tmp65_ = NULL;
			VbfModule* module;
			_tmp51_ = g_match_info_matches (match);
			if (!_tmp51_) {
				break;
			}
			_tmp52_ = g_match_info_fetch (match, 1);
			mod_name = _tmp52_;
			_tmp53_ = g_strdup ("");
			pacs = _tmp53_;
			_tmp54_ = g_match_info_fetch (match, 2);
			line = _tmp54_;
			_tmp55_ = g_regex_new ("^[\\s\\]]*([^\\,\\]]+)[\\s\\]]*,([^\\,]+),([^\\,]+)$", 0, 0, &_inner_error_);
			mod = _tmp55_;
			if (_inner_error_ != NULL) {
				_g_free0 (line);
				_g_free0 (pacs);
				_g_free0 (mod_name);
				_g_free0 (url);
				_g_free0 (version);
				_g_free0 (name);
				_g_match_info_free0 (match);
				_g_regex_unref0 (reg);
				_g_free0 (buffer);
				_g_free0 (file);
				goto __catch5_g_error;
			}
			_tmp57_ = g_regex_match (mod, line, G_REGEX_MATCH_NEWLINE_CR, &_tmp56_);
			_g_match_info_free0 (pac);
			pac = _tmp56_;
			if (_tmp57_) {
				gchar* _tmp58_ = NULL;
				_tmp58_ = g_match_info_fetch (pac, 1);
				_g_free0 (pacs);
				pacs = _tmp58_;
			} else {
				GRegex* _tmp59_ = NULL;
				GRegex* _tmp60_;
				GMatchInfo* _tmp61_ = NULL;
				gboolean _tmp62_;
				_tmp59_ = g_regex_new ("^[\\s\\]]*([^\\,\\]]+)[\\s\\]]*,([^\\,]+)$", 0, 0, &_inner_error_);
				_tmp60_ = _tmp59_;
				if (_inner_error_ != NULL) {
					_g_match_info_free0 (pac);
					_g_regex_unref0 (mod);
					_g_free0 (line);
					_g_free0 (pacs);
					_g_free0 (mod_name);
					_g_free0 (url);
					_g_free0 (version);
					_g_free0 (name);
					_g_match_info_free0 (match);
					_g_regex_unref0 (reg);
					_g_free0 (buffer);
					_g_free0 (file);
					goto __catch5_g_error;
				}
				_g_regex_unref0 (mod);
				mod = _tmp60_;
				_tmp62_ = g_regex_match (mod, line, G_REGEX_MATCH_NEWLINE_CR, &_tmp61_);
				_g_match_info_free0 (pac);
				pac = _tmp61_;
				if (_tmp62_) {
					gchar* _tmp63_ = NULL;
					_tmp63_ = g_match_info_fetch (pac, 1);
					_g_free0 (pacs);
					pacs = _tmp63_;
				} else {
					gchar* _tmp64_;
					_tmp64_ = g_strdup (line);
					_g_free0 (pacs);
					pacs = _tmp64_;
				}
			}
			_tmp65_ = vbf_module_new (project, mod_name);
			module = _tmp65_;
			vbf_project_add_module (project, module);
			if (g_strcmp0 (pacs, "") != 0) {
				gchar* _tmp66_ = NULL;
				gchar* _tmp67_;
				gchar** _tmp68_;
				gchar** _tmp69_ = NULL;
				gchar** _tmp70_;
				gchar** pkgs;
				gint pkgs_length1;
				gint _pkgs_size_;
				gint idx;
				_tmp66_ = vbf_backends_autotools_normalize_string (self, pacs);
				_tmp67_ = _tmp66_;
				_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, " ", 0);
				_tmp70_ = _tmp69_;
				_g_free0 (_tmp67_);
				pkgs = _tmp70_;
				pkgs_length1 = _vala_array_length (_tmp68_);
				_pkgs_size_ = _vala_array_length (_tmp68_);
				idx = 0;
				while (TRUE) {
					gchar* _tmp71_;
					gchar* pkg;
					gint _tmp72_;
					gint index;
					VbfPackage* _tmp93_ = NULL;
					VbfPackage* package;
					gboolean _tmp94_ = FALSE;
					gboolean _tmp95_ = FALSE;
					if (!(pkgs[idx] != NULL)) {
						break;
					}
					_tmp71_ = g_strdup (pkgs[idx]);
					pkg = _tmp71_;
					if (g_strcmp0 (pkg, "\\") == 0) {
						idx++;
						_g_free0 (pkg);
						continue;
					}
					_tmp72_ = string_index_of (pkg, "$", 0);
					index = _tmp72_;
					if (index >= 0) {
						gchar* _tmp73_ = NULL;
						gchar* variable;
						gchar* _tmp74_ = NULL;
						gchar* _tmp75_;
						gchar* _tmp76_ = NULL;
						gchar* _tmp77_;
						gchar* _tmp78_ = NULL;
						gchar* _tmp79_;
						gchar* var_name;
						ValaList* _tmp80_ = NULL;
						ValaList* _tmp81_;
						VbfVariable* _tmp82_ = NULL;
						VbfVariable* _tmp83_;
						VbfVariable* res;
						_tmp73_ = string_substring (pkg, (glong) index, (glong) (-1));
						variable = _tmp73_;
						_tmp74_ = string_replace (variable, "(", "");
						_tmp75_ = _tmp74_;
						_tmp76_ = string_replace (_tmp75_, ")", "");
						_tmp77_ = _tmp76_;
						_tmp78_ = string_substring (_tmp77_, (glong) 1, (glong) (-1));
						_tmp79_ = _tmp78_;
						_g_free0 (_tmp77_);
						_g_free0 (_tmp75_);
						var_name = _tmp79_;
						vbf_utils_trace ("vbfautotools.vala:182: Resolving variables: %s", var_name);
						_tmp80_ = vbf_project_get_variables (project);
						_tmp81_ = _tmp80_;
						_tmp82_ = vbf_backends_autotools_resolve_variable (self, var_name, _tmp81_);
						_tmp83_ = _tmp82_;
						_vala_iterable_unref0 (_tmp81_);
						res = _tmp83_;
						if (res != NULL) {
							VbfConfigNode* _tmp84_ = NULL;
							VbfConfigNode* _tmp85_;
							gchar* _tmp86_ = NULL;
							gchar* _tmp87_;
							VbfConfigNode* _tmp88_ = NULL;
							VbfConfigNode* _tmp89_;
							gchar* _tmp90_ = NULL;
							gchar* _tmp91_;
							gchar* _tmp92_ = NULL;
							_tmp84_ = vbf_variable_get_value (res);
							_tmp85_ = _tmp84_;
							_tmp86_ = vbf_config_node_to_string (_tmp85_);
							_tmp87_ = _tmp86_;
							vbf_utils_trace ("vbfautotools.vala:185: resolved: %s = %s", variable, _tmp87_);
							_g_free0 (_tmp87_);
							_g_object_unref0 (_tmp85_);
							_tmp88_ = vbf_variable_get_value (res);
							_tmp89_ = _tmp88_;
							_tmp90_ = vbf_config_node_to_string (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = string_replace (pkg, variable, _tmp91_);
							_g_free0 (pkg);
							pkg = _tmp92_;
							_g_free0 (_tmp91_);
							_g_object_unref0 (_tmp89_);
						}
						_g_object_unref0 (res);
						_g_free0 (var_name);
						_g_free0 (variable);
					}
					_tmp93_ = vbf_package_new (pkg);
					package = _tmp93_;
					vbf_module_add_package (module, package);
					idx++;
					if (g_strcmp0 (pkgs[idx], ">=") == 0) {
						_tmp95_ = TRUE;
					} else {
						_tmp95_ = g_strcmp0 (pkgs[idx], ">") == 0;
					}
					if (_tmp95_) {
						_tmp94_ = TRUE;
					} else {
						_tmp94_ = g_strcmp0 (pkgs[idx], "=") == 0;
					}
					if (_tmp94_) {
						gchar* _tmp96_;
						VbfConfigNode* node = NULL;
						gchar* _tmp97_;
						gchar* val;
						gboolean _tmp98_;
						VbfConfigNode* _tmp105_;
						_tmp96_ = g_strdup (pkgs[idx]);
						_g_free0 (package->constraint);
						package->constraint = _tmp96_;
						idx++;
						_tmp97_ = g_strdup (pkgs[idx]);
						val = _tmp97_;
						_tmp98_ = g_str_has_prefix (val, "$");
						if (_tmp98_) {
							gint _tmp99_;
							gchar* _tmp100_ = NULL;
							gchar* _tmp101_;
							VbfUnresolvedConfigNode* _tmp102_ = NULL;
							_tmp99_ = strlen (pkgs[idx]);
							_tmp100_ = string_substring (pkgs[idx], (glong) 1, (glong) (_tmp99_ - 1));
							_tmp101_ = _tmp100_;
							_tmp102_ = vbf_unresolved_config_node_new (_tmp101_);
							_g_object_unref0 (node);
							node = (VbfConfigNode*) _tmp102_;
							_g_free0 (_tmp101_);
						} else {
							if (val != NULL) {
								VbfStringLiteral* _tmp103_ = NULL;
								_tmp103_ = vbf_string_literal_new (pkgs[idx]);
								_g_object_unref0 (node);
								node = (VbfConfigNode*) _tmp103_;
							} else {
								VbfStringLiteral* _tmp104_ = NULL;
								_tmp104_ = vbf_string_literal_new ("");
								_g_object_unref0 (node);
								node = (VbfConfigNode*) _tmp104_;
							}
						}
						_tmp105_ = _g_object_ref0 (node);
						_g_object_unref0 (package->version);
						package->version = _tmp105_;
						idx++;
						_g_free0 (val);
						_g_object_unref0 (node);
					}
					_g_object_unref0 (package);
					_g_free0 (pkg);
				}
				pkgs = (_vala_array_free (pkgs, pkgs_length1, (GDestroyNotify) g_free), NULL);
			}
			g_match_info_next (match, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (module);
				_g_match_info_free0 (pac);
				_g_regex_unref0 (mod);
				_g_free0 (line);
				_g_free0 (pacs);
				_g_free0 (mod_name);
				_g_free0 (url);
				_g_free0 (version);
				_g_free0 (name);
				_g_match_info_free0 (match);
				_g_regex_unref0 (reg);
				_g_free0 (buffer);
				_g_free0 (file);
				goto __catch5_g_error;
			}
			_g_object_unref0 (module);
			_g_match_info_free0 (pac);
			_g_regex_unref0 (mod);
			_g_free0 (line);
			_g_free0 (pacs);
			_g_free0 (mod_name);
		}
	}
	vbf_backends_autotools_resolve_package_variables (self, project);
	_tmp106_ = g_regex_new ("AC_CONFIG_FILES\\(\\[([^\\]\\)]*)\\]\\)", G_REGEX_MULTILINE, 0, &_inner_error_);
	_tmp107_ = _tmp106_;
	if (_inner_error_ != NULL) {
		_g_free0 (url);
		_g_free0 (version);
		_g_free0 (name);
		_g_match_info_free0 (match);
		_g_regex_unref0 (reg);
		_g_free0 (buffer);
		_g_free0 (file);
		goto __catch5_g_error;
	}
	_g_regex_unref0 (reg);
	reg = _tmp107_;
	_tmp109_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_CR, &_tmp108_);
	_g_match_info_free0 (match);
	match = _tmp108_;
	res = _tmp109_;
	if (!res) {
		GRegex* _tmp110_ = NULL;
		GRegex* _tmp111_;
		GMatchInfo* _tmp112_ = NULL;
		gboolean _tmp113_;
		_tmp110_ = g_regex_new ("AC_OUTPUT\\(\\[([^\\]\\)]*)\\]\\)", G_REGEX_MULTILINE, 0, &_inner_error_);
		_tmp111_ = _tmp110_;
		if (_inner_error_ != NULL) {
			_g_free0 (url);
			_g_free0 (version);
			_g_free0 (name);
			_g_match_info_free0 (match);
			_g_regex_unref0 (reg);
			_g_free0 (buffer);
			_g_free0 (file);
			goto __catch5_g_error;
		}
		_g_regex_unref0 (reg);
		reg = _tmp111_;
		_tmp113_ = g_regex_match (reg, buffer, G_REGEX_MATCH_NEWLINE_CR, &_tmp112_);
		_g_match_info_free0 (match);
		match = _tmp112_;
		res = _tmp113_;
	}
	if (res) {
		gchar* _tmp114_ = NULL;
		gchar* _tmp115_;
		gchar* _tmp116_ = NULL;
		gchar* _tmp117_;
		gchar* tmp;
		gchar** _tmp118_;
		gchar** _tmp119_ = NULL;
		gchar** makefiles;
		gint makefiles_length1;
		gint _makefiles_size_;
		_tmp114_ = g_match_info_fetch (match, 1);
		_tmp115_ = _tmp114_;
		_tmp116_ = vbf_backends_autotools_normalize_string (self, _tmp115_);
		_tmp117_ = _tmp116_;
		_g_free0 (_tmp115_);
		tmp = _tmp117_;
		_tmp119_ = _tmp118_ = g_strsplit (tmp, " ", 0);
		makefiles = _tmp119_;
		makefiles_length1 = _vala_array_length (_tmp118_);
		_makefiles_size_ = _vala_array_length (_tmp118_);
		{
			gchar** makefile_collection;
			int makefile_collection_length1;
			int makefile_it;
			makefile_collection = makefiles;
			makefile_collection_length1 = makefiles_length1;
			for (makefile_it = 0; makefile_it < makefiles_length1; makefile_it = makefile_it + 1) {
				gchar* _tmp120_;
				gchar* makefile;
				_tmp120_ = g_strdup (makefile_collection[makefile_it]);
				makefile = _tmp120_;
				{
					vbf_backends_autotools_parse_makefile (self, project, project->id, makefile, &_inner_error_);
					if (_inner_error_ != NULL) {
						_g_free0 (makefile);
						makefiles = (_vala_array_free (makefiles, makefiles_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (tmp);
						_g_free0 (url);
						_g_free0 (version);
						_g_free0 (name);
						_g_match_info_free0 (match);
						_g_regex_unref0 (reg);
						_g_free0 (buffer);
						_g_free0 (file);
						goto __catch5_g_error;
					}
					_g_free0 (makefile);
				}
			}
		}
		makefiles = (_vala_array_free (makefiles, makefiles_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (tmp);
	}
	if (project->name != NULL) {
		vbf_backends_autotools_setup_file_monitors (self, project);
	}
	_g_free0 (url);
	_g_free0 (version);
	_g_free0 (name);
	_g_match_info_free0 (match);
	_g_regex_unref0 (reg);
	_g_free0 (buffer);
	_g_free0 (file);
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vbfautotools.vala:238: open: %s", err->message);
		_g_error_free0 (err);
		return;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static VbfFileTypes vbf_backends_autotools_source_file_type (VbfBackendsAutotools* self, const gchar* name) {
	VbfFileTypes result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp2_ = g_str_has_suffix (name, ".vala");
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_;
		_tmp3_ = g_str_has_suffix (name, ".vapi");
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = g_str_has_suffix (name, ".gs");
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		result = VBF_FILE_TYPES_VALA_SOURCE;
		return result;
	} else {
		result = VBF_FILE_TYPES_OTHER_SOURCE;
		return result;
	}
}


static void vbf_backends_autotools_add_source (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* source) {
	gchar* src_path = NULL;
	gchar* src_filename = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (source != NULL);
	if (VBF_IS_STRING_LITERAL (source)) {
		gchar* _tmp0_;
		gboolean _tmp1_ = FALSE;
		_tmp0_ = g_strdup (VBF_STRING_LITERAL (source)->data);
		_g_free0 (src_filename);
		src_filename = _tmp0_;
		if (src_filename != NULL) {
			_tmp1_ = g_strcmp0 (src_filename, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp2_ = NULL;
			VbfFileTypes _tmp3_;
			VbfSource* _tmp4_ = NULL;
			VbfSource* src;
			_tmp2_ = g_build_filename (group->id, src_filename, NULL);
			_g_free0 (src_path);
			src_path = _tmp2_;
			_tmp3_ = vbf_backends_autotools_source_file_type (self, src_path);
			_tmp4_ = vbf_source_new_with_type (target, src_path, _tmp3_);
			src = _tmp4_;
			vbf_target_add_source (target, src);
			_g_object_unref0 (src);
		}
	} else {
		if (VBF_IS_VARIABLE (source)) {
			VbfConfigNode* _tmp5_ = NULL;
			VbfConfigNode* _tmp6_;
			_tmp5_ = vbf_variable_get_value (VBF_VARIABLE (source));
			_tmp6_ = _tmp5_;
			vbf_backends_autotools_add_source (self, group, target, _tmp6_);
			_g_object_unref0 (_tmp6_);
		} else {
			if (VBF_IS_CONFIG_NODE_LIST (source)) {
				{
					ValaList* _tmp7_ = NULL;
					ValaList* _item_list;
					gint _tmp8_;
					gint _item_size;
					gint _item_index;
					_tmp7_ = vbf_config_node_list_get_values (VBF_CONFIG_NODE_LIST (source));
					_item_list = _tmp7_;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _item_list);
					_item_size = _tmp8_;
					_item_index = -1;
					while (TRUE) {
						gpointer _tmp9_ = NULL;
						VbfConfigNode* item;
						_item_index = _item_index + 1;
						if (!(_item_index < _item_size)) {
							break;
						}
						_tmp9_ = vala_list_get (_item_list, _item_index);
						item = (VbfConfigNode*) _tmp9_;
						if (VBF_IS_STRING_LITERAL (item)) {
							gchar* _tmp10_;
							gboolean _tmp11_ = FALSE;
							_tmp10_ = g_strdup (VBF_STRING_LITERAL (item)->data);
							_g_free0 (src_filename);
							src_filename = _tmp10_;
							if (src_filename != NULL) {
								_tmp11_ = g_strcmp0 (src_filename, "") != 0;
							} else {
								_tmp11_ = FALSE;
							}
							if (_tmp11_) {
								gchar* _tmp12_ = NULL;
								VbfFileTypes _tmp13_;
								VbfSource* _tmp14_ = NULL;
								VbfSource* src;
								_tmp12_ = g_build_filename (group->id, src_filename, NULL);
								_g_free0 (src_path);
								src_path = _tmp12_;
								_tmp13_ = vbf_backends_autotools_source_file_type (self, src_path);
								_tmp14_ = vbf_source_new_with_type (target, src_path, _tmp13_);
								src = _tmp14_;
								vbf_target_add_source (target, src);
								_g_object_unref0 (src);
							}
						} else {
							if (VBF_IS_VARIABLE (item)) {
								VbfConfigNode* _tmp15_ = NULL;
								VbfConfigNode* _tmp16_;
								_tmp15_ = vbf_variable_get_value (VBF_VARIABLE (item));
								_tmp16_ = _tmp15_;
								vbf_backends_autotools_add_source (self, group, target, _tmp16_);
								_g_object_unref0 (_tmp16_);
							} else {
								if (VBF_IS_CONFIG_NODE_LIST (item)) {
									vbf_backends_autotools_add_source (self, group, target, item);
								}
							}
						}
						_g_object_unref0 (item);
					}
					_vala_iterable_unref0 (_item_list);
				}
			} else {
				GType _tmp17_;
				const gchar* _tmp18_ = NULL;
				_tmp17_ = G_TYPE_FROM_INSTANCE (source);
				_tmp18_ = g_type_name (_tmp17_);
				g_warning ("vbfautotools.vala:279: add_vala_source: unsupported source type %s", _tmp18_);
			}
		}
	}
	_g_free0 (src_filename);
	_g_free0 (src_path);
}


static void vbf_backends_autotools_add_vala_sources (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* source_primary_name;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* valasource_primary_name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target != NULL);
	_tmp0_ = vbf_backends_autotools_convert_to_primary_name (self, target->id);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s_SOURCES", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	source_primary_name = _tmp3_;
	_tmp4_ = vbf_backends_autotools_convert_to_primary_name (self, target->id);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s_VALASOURCES", _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	valasource_primary_name = _tmp7_;
	{
		ValaList* _tmp8_ = NULL;
		ValaList* _variable_list;
		gint _tmp9_;
		gint _variable_size;
		gint _variable_index;
		_tmp8_ = vbf_group_get_variables (group);
		_variable_list = _tmp8_;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _variable_list);
		_variable_size = _tmp9_;
		_variable_index = -1;
		while (TRUE) {
			gpointer _tmp10_ = NULL;
			VbfVariable* variable;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			_variable_index = _variable_index + 1;
			if (!(_variable_index < _variable_size)) {
				break;
			}
			_tmp10_ = vala_list_get (_variable_list, _variable_index);
			variable = (VbfVariable*) _tmp10_;
			if (g_strcmp0 (variable->name, target->id) == 0) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = g_strcmp0 (variable->name, source_primary_name) == 0;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				_tmp11_ = g_strcmp0 (variable->name, valasource_primary_name) == 0;
			}
			if (_tmp11_) {
				VbfConfigNode* _tmp13_ = NULL;
				VbfConfigNode* val;
				_tmp13_ = vbf_variable_get_value (variable);
				val = _tmp13_;
				vbf_backends_autotools_add_source (self, group, target, val);
				_g_object_unref0 (val);
				_g_object_unref0 (variable);
				break;
			}
			_g_object_unref0 (variable);
		}
		_vala_iterable_unref0 (_variable_list);
	}
	_g_free0 (valasource_primary_name);
	_g_free0 (source_primary_name);
}


static void vbf_backends_autotools_add_target (VbfBackendsAutotools* self, VbfGroup* group, VbfTargetTypes type, const gchar* target_id) {
	VbfTarget* target = NULL;
	gchar* _tmp0_ = NULL;
	gchar* normalized_id;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target_id != NULL);
	_tmp0_ = vbf_backends_autotools_normalize_target_id (self, target_id);
	normalized_id = _tmp0_;
	_tmp1_ = vbf_group_contains_target (group, normalized_id);
	if (!_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* name;
		VbfTarget* _tmp3_ = NULL;
		_tmp2_ = vbf_backends_autotools_normalize_target_id_for_display (self, target_id);
		name = _tmp2_;
		_tmp3_ = vbf_target_new (group, type, normalized_id, name);
		_g_object_unref0 (target);
		target = _tmp3_;
		vbf_group_add_target (group, target);
		vbf_backends_autotools_add_vala_sources (self, group, target);
		_g_free0 (name);
	}
	_g_free0 (normalized_id);
	_g_object_unref0 (target);
}


static void vbf_backends_autotools_add_targets (VbfBackendsAutotools* self, VbfGroup* group, VbfConfigNode* node, VbfTargetTypes type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (node != NULL);
	if (VBF_IS_STRING_LITERAL (node)) {
		vbf_backends_autotools_add_target (self, group, type, VBF_STRING_LITERAL (node)->data);
	} else {
		{
			ValaList* _tmp0_ = NULL;
			ValaList* _item_list;
			gint _tmp1_;
			gint _item_size;
			gint _item_index;
			_tmp0_ = vbf_config_node_list_get_values (VBF_CONFIG_NODE_LIST (node));
			_item_list = _tmp0_;
			_tmp1_ = vala_collection_get_size ((ValaCollection*) _item_list);
			_item_size = _tmp1_;
			_item_index = -1;
			while (TRUE) {
				gpointer _tmp2_ = NULL;
				VbfConfigNode* item;
				_item_index = _item_index + 1;
				if (!(_item_index < _item_size)) {
					break;
				}
				_tmp2_ = vala_list_get (_item_list, _item_index);
				item = (VbfConfigNode*) _tmp2_;
				if (VBF_IS_STRING_LITERAL (item)) {
					vbf_backends_autotools_add_target (self, group, type, VBF_STRING_LITERAL (item)->data);
				} else {
					if (VBF_IS_CONFIG_NODE_LIST (item)) {
						vbf_backends_autotools_add_targets (self, group, item, type);
					}
				}
				_g_object_unref0 (item);
			}
			_vala_iterable_unref0 (_item_list);
		}
	}
}


static void vbf_backends_autotools_add_data_files (VbfBackendsAutotools* self, VbfGroup* group, VbfTarget* target, VbfConfigNode* file) {
	gchar* name = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (file != NULL);
	if (VBF_IS_STRING_LITERAL (file)) {
		gchar* _tmp0_ = NULL;
		VbfFile* _tmp1_ = NULL;
		VbfFile* f;
		_tmp0_ = g_build_filename (group->id, VBF_STRING_LITERAL (file)->data, NULL);
		_g_free0 (name);
		name = _tmp0_;
		_tmp1_ = vbf_file_new_with_type (target, name, VBF_FILE_TYPES_DATA);
		f = _tmp1_;
		vbf_target_add_file (target, f);
		_g_object_unref0 (f);
	} else {
		if (VBF_IS_VARIABLE (file)) {
			VbfConfigNode* _tmp2_ = NULL;
			VbfConfigNode* _tmp3_;
			_tmp2_ = vbf_variable_get_value (VBF_VARIABLE (file));
			_tmp3_ = _tmp2_;
			vbf_backends_autotools_add_data_files (self, group, target, _tmp3_);
			_g_object_unref0 (_tmp3_);
		} else {
			if (VBF_IS_CONFIG_NODE_LIST (file)) {
				{
					ValaList* _tmp4_ = NULL;
					ValaList* _item_list;
					gint _tmp5_;
					gint _item_size;
					gint _item_index;
					_tmp4_ = vbf_config_node_list_get_values (VBF_CONFIG_NODE_LIST (file));
					_item_list = _tmp4_;
					_tmp5_ = vala_collection_get_size ((ValaCollection*) _item_list);
					_item_size = _tmp5_;
					_item_index = -1;
					while (TRUE) {
						gpointer _tmp6_ = NULL;
						VbfConfigNode* item;
						_item_index = _item_index + 1;
						if (!(_item_index < _item_size)) {
							break;
						}
						_tmp6_ = vala_list_get (_item_list, _item_index);
						item = (VbfConfigNode*) _tmp6_;
						if (VBF_IS_STRING_LITERAL (item)) {
							gchar* _tmp7_ = NULL;
							VbfFile* _tmp8_ = NULL;
							VbfFile* f;
							_tmp7_ = g_build_filename (group->id, VBF_STRING_LITERAL (item)->data, NULL);
							_g_free0 (name);
							name = _tmp7_;
							_tmp8_ = vbf_file_new_with_type (target, name, VBF_FILE_TYPES_DATA);
							f = _tmp8_;
							vbf_target_add_file (target, f);
							_g_object_unref0 (f);
						} else {
							if (VBF_IS_VARIABLE (item)) {
								VbfConfigNode* _tmp9_ = NULL;
								VbfConfigNode* _tmp10_;
								_tmp9_ = vbf_variable_get_value (VBF_VARIABLE (item));
								_tmp10_ = _tmp9_;
								vbf_backends_autotools_add_data_files (self, group, target, _tmp10_);
								_g_object_unref0 (_tmp10_);
							} else {
								if (VBF_IS_CONFIG_NODE_LIST (item)) {
									vbf_backends_autotools_add_data_files (self, group, target, item);
								}
							}
						}
						_g_object_unref0 (item);
					}
					_vala_iterable_unref0 (_item_list);
				}
			} else {
				g_warning ("vbfautotools.vala:346: add_vala_source: unsupported source type");
			}
		}
	}
	_g_free0 (name);
}


static void vbf_backends_autotools_parse_targets (VbfBackendsAutotools* self, VbfGroup* group) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _variable_list;
		gint _tmp1_;
		gint _variable_size;
		gint _variable_index;
		_tmp0_ = vbf_group_get_variables (group);
		_variable_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _variable_list);
		_variable_size = _tmp1_;
		_variable_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfVariable* variable;
			gboolean _tmp3_;
			_variable_index = _variable_index + 1;
			if (!(_variable_index < _variable_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_variable_list, _variable_index);
			variable = (VbfVariable*) _tmp2_;
			_tmp3_ = g_str_has_suffix (variable->name, "_PROGRAMS");
			if (_tmp3_) {
				VbfConfigNode* _tmp4_ = NULL;
				VbfConfigNode* _tmp5_;
				_tmp4_ = vbf_variable_get_value (variable);
				_tmp5_ = _tmp4_;
				vbf_backends_autotools_add_targets (self, group, _tmp5_, VBF_TARGET_TYPES_PROGRAM);
				_g_object_unref0 (_tmp5_);
			} else {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_;
				_tmp7_ = g_str_has_suffix (variable->name, "_LTLIBRARIES");
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_;
					_tmp8_ = g_str_has_suffix (variable->name, "_LIBRARIES");
					_tmp6_ = _tmp8_;
				}
				if (_tmp6_) {
					VbfConfigNode* _tmp9_ = NULL;
					VbfConfigNode* _tmp10_;
					_tmp9_ = vbf_variable_get_value (variable);
					_tmp10_ = _tmp9_;
					vbf_backends_autotools_add_targets (self, group, _tmp10_, VBF_TARGET_TYPES_LIBRARY);
					_g_object_unref0 (_tmp10_);
				} else {
					gboolean _tmp11_;
					_tmp11_ = g_str_has_suffix (variable->name, "_DATA");
					if (_tmp11_) {
						VbfTarget* _tmp12_ = NULL;
						VbfTarget* target;
						VbfConfigNode* _tmp13_ = NULL;
						VbfConfigNode* _tmp14_;
						_tmp12_ = vbf_target_new (group, VBF_TARGET_TYPES_DATA, "data", "data");
						target = _tmp12_;
						_tmp13_ = vbf_variable_get_value (variable);
						_tmp14_ = _tmp13_;
						vbf_backends_autotools_add_data_files (self, group, target, _tmp14_);
						_g_object_unref0 (_tmp14_);
						vbf_group_add_target (group, target);
						_g_object_unref0 (target);
					} else {
						if (g_strcmp0 (variable->name, "BUILT_SOURCES") == 0) {
							VbfConfigNode* _tmp15_ = NULL;
							VbfConfigNode* _tmp16_;
							_tmp15_ = vbf_variable_get_value (variable);
							_tmp16_ = _tmp15_;
							vbf_backends_autotools_add_targets (self, group, _tmp16_, VBF_TARGET_TYPES_BUILT_SOURCES);
							_g_object_unref0 (_tmp16_);
						}
					}
				}
			}
			_g_object_unref0 (variable);
		}
		_vala_iterable_unref0 (_variable_list);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void vbf_backends_autotools_parse_variables (VbfBackendsAutotools* self, VbfProject* project, const gchar* buffer, VbfGroup* group, GError** error) {
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar* tmp;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (buffer != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (buffer, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = _vala_array_length (_tmp0_);
	tmp = NULL;
	{
		gchar** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			gchar* _tmp2_;
			gchar* line;
			_tmp2_ = g_strdup (line_collection[line_it]);
			line = _tmp2_;
			{
				gboolean _tmp9_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_;
				gboolean append;
				gchar** _tmp14_;
				gchar** _tmp15_ = NULL;
				gchar** toks;
				gint toks_length1;
				gint _toks_size_;
				gboolean _tmp18_;
				gchar** _tmp22_;
				gchar** _tmp23_ = NULL;
				gchar** lhs;
				gint lhs_length1;
				gint _lhs_size_;
				gchar** _tmp24_;
				gchar** _tmp25_ = NULL;
				gchar** rhs;
				gint rhs_length1;
				gint _rhs_size_;
				if (tmp == NULL) {
					gchar* _tmp3_ = NULL;
					_tmp3_ = vbf_backends_autotools_normalize_string (self, line);
					_g_free0 (tmp);
					tmp = _tmp3_;
				} else {
					gchar* _tmp4_ = NULL;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp4_ = vbf_backends_autotools_normalize_string (self, line);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_strconcat (" ", _tmp5_, NULL);
					_tmp7_ = _tmp6_;
					_tmp8_ = g_strconcat (tmp, _tmp7_, NULL);
					_g_free0 (tmp);
					tmp = _tmp8_;
					_g_free0 (_tmp7_);
					_g_free0 (_tmp5_);
				}
				_tmp9_ = g_str_has_suffix (tmp, "\\");
				if (_tmp9_) {
					gint _tmp10_;
					gchar* _tmp11_ = NULL;
					_tmp10_ = strlen (tmp);
					_tmp11_ = string_substring (tmp, (glong) 0, (glong) (_tmp10_ - 1));
					_g_free0 (tmp);
					tmp = _tmp11_;
					_g_free0 (line);
					continue;
				}
				_tmp13_ = g_str_has_prefix (tmp, "#");
				if (_tmp13_) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = g_strcmp0 (tmp, "") == 0;
				}
				if (_tmp12_) {
					_g_free0 (tmp);
					tmp = NULL;
					_g_free0 (line);
					continue;
				}
				append = FALSE;
				_tmp15_ = _tmp14_ = g_strsplit (tmp, "=", 2);
				toks = _tmp15_;
				toks_length1 = _vala_array_length (_tmp14_);
				_toks_size_ = _vala_array_length (_tmp14_);
				if (toks[1] == NULL) {
					gchar** _tmp16_;
					gchar** _tmp17_ = NULL;
					_tmp17_ = _tmp16_ = g_strsplit (tmp, ":", 2);
					toks = (_vala_array_free (toks, toks_length1, (GDestroyNotify) g_free), NULL);
					toks = _tmp17_;
					toks_length1 = _vala_array_length (_tmp16_);
					_toks_size_ = _vala_array_length (_tmp16_);
				}
				if (toks[1] == NULL) {
					_g_free0 (tmp);
					tmp = NULL;
					toks = (_vala_array_free (toks, toks_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp18_ = g_str_has_suffix (toks[0], "+");
				if (_tmp18_) {
					gint _tmp19_;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					append = TRUE;
					_tmp19_ = strlen (toks[0]);
					_tmp20_ = string_substring (toks[0], (glong) 0, (glong) (_tmp19_ - 1));
					_tmp21_ = _tmp20_;
					_g_free0 (toks[0]);
					toks[0] = _tmp21_;
				}
				_tmp23_ = _tmp22_ = g_strsplit (toks[0], " ", 0);
				lhs = _tmp23_;
				lhs_length1 = _vala_array_length (_tmp22_);
				_lhs_size_ = _vala_array_length (_tmp22_);
				_tmp25_ = _tmp24_ = g_strsplit (toks[1], " ", 0);
				rhs = _tmp25_;
				rhs_length1 = _vala_array_length (_tmp24_);
				_rhs_size_ = _vala_array_length (_tmp24_);
				{
					gchar** lh_collection;
					int lh_collection_length1;
					int lh_it;
					lh_collection = lhs;
					lh_collection_length1 = lhs_length1;
					for (lh_it = 0; lh_it < lhs_length1; lh_it = lh_it + 1) {
						gchar* _tmp26_;
						gchar* lh;
						_tmp26_ = g_strdup (lh_collection[lh_it]);
						lh = _tmp26_;
						{
							gboolean _tmp27_ = FALSE;
							gchar* _tmp28_ = NULL;
							gchar* name;
							VbfVariable* _tmp29_ = NULL;
							VbfVariable* variable;
							VbfConfigNode* data = NULL;
							if (lh == NULL) {
								_tmp27_ = TRUE;
							} else {
								_tmp27_ = g_strcmp0 (lh, "") == 0;
							}
							if (_tmp27_) {
								_g_free0 (lh);
								continue;
							}
							_tmp28_ = string_strip (lh);
							name = _tmp28_;
							_tmp29_ = vbf_variable_new (name, (VbfConfigNode*) project);
							variable = _tmp29_;
							if (rhs[0] != NULL) {
								VbfConfigNode* _tmp56_;
								if (rhs[1] == NULL) {
									gchar* _tmp30_ = NULL;
									gchar* val;
									gboolean _tmp31_;
									_tmp30_ = string_strip (rhs[0]);
									val = _tmp30_;
									_tmp31_ = g_str_has_prefix (val, "$");
									if (_tmp31_) {
										gint _tmp32_;
										gchar* _tmp33_ = NULL;
										gchar* _tmp34_ = NULL;
										gchar* _tmp35_;
										gchar* _tmp36_ = NULL;
										VbfUnresolvedConfigNode* _tmp37_ = NULL;
										_tmp32_ = strlen (val);
										_tmp33_ = string_substring (val, (glong) 1, (glong) (_tmp32_ - 1));
										_g_free0 (val);
										val = _tmp33_;
										_tmp34_ = string_replace (val, "(", "");
										_tmp35_ = _tmp34_;
										_tmp36_ = string_replace (_tmp35_, ")", "");
										_g_free0 (val);
										val = _tmp36_;
										_g_free0 (_tmp35_);
										_tmp37_ = vbf_unresolved_config_node_new (val);
										_g_object_unref0 (data);
										data = (VbfConfigNode*) _tmp37_;
									} else {
										if (val != NULL) {
											VbfStringLiteral* _tmp38_ = NULL;
											_tmp38_ = vbf_string_literal_new (val);
											_g_object_unref0 (data);
											data = (VbfConfigNode*) _tmp38_;
										} else {
											VbfStringLiteral* _tmp39_ = NULL;
											_tmp39_ = vbf_string_literal_new ("");
											_g_object_unref0 (data);
											data = (VbfConfigNode*) _tmp39_;
										}
									}
									_g_free0 (val);
								} else {
									VbfConfigNodeList* _tmp40_ = NULL;
									VbfConfigNodeList* items;
									VbfConfigNode* _tmp55_;
									_tmp40_ = vbf_config_node_list_new ();
									items = _tmp40_;
									{
										gchar** rh_collection;
										int rh_collection_length1;
										int rh_it;
										rh_collection = rhs;
										rh_collection_length1 = rhs_length1;
										for (rh_it = 0; rh_it < rhs_length1; rh_it = rh_it + 1) {
											gchar* _tmp41_;
											gchar* rh;
											_tmp41_ = g_strdup (rh_collection[rh_it]);
											rh = _tmp41_;
											{
												gboolean _tmp42_ = FALSE;
												if (rh != NULL) {
													gchar* _tmp43_ = NULL;
													gchar* _tmp44_;
													_tmp43_ = string_strip (rh);
													_tmp44_ = _tmp43_;
													_tmp42_ = g_strcmp0 (_tmp44_, "") != 0;
													_g_free0 (_tmp44_);
												} else {
													_tmp42_ = FALSE;
												}
												if (_tmp42_) {
													VbfConfigNode* node = NULL;
													gchar* _tmp45_ = NULL;
													gchar* val;
													gboolean _tmp46_;
													_tmp45_ = string_strip (rh);
													val = _tmp45_;
													_tmp46_ = g_str_has_prefix (val, "$");
													if (_tmp46_) {
														gint _tmp47_;
														gchar* _tmp48_ = NULL;
														gchar* _tmp49_ = NULL;
														gchar* _tmp50_;
														gchar* _tmp51_ = NULL;
														VbfUnresolvedConfigNode* _tmp52_ = NULL;
														_tmp47_ = strlen (val);
														_tmp48_ = string_substring (val, (glong) 1, (glong) (_tmp47_ - 1));
														_g_free0 (val);
														val = _tmp48_;
														_tmp49_ = string_replace (val, "(", "");
														_tmp50_ = _tmp49_;
														_tmp51_ = string_replace (_tmp50_, ")", "");
														_g_free0 (val);
														val = _tmp51_;
														_g_free0 (_tmp50_);
														_tmp52_ = vbf_unresolved_config_node_new (val);
														_g_object_unref0 (node);
														node = (VbfConfigNode*) _tmp52_;
													} else {
														if (val != NULL) {
															VbfStringLiteral* _tmp53_ = NULL;
															_tmp53_ = vbf_string_literal_new (val);
															_g_object_unref0 (node);
															node = (VbfConfigNode*) _tmp53_;
														} else {
															VbfStringLiteral* _tmp54_ = NULL;
															g_critical ("vbfautotools.vala:450: %s is null", rh);
															_tmp54_ = vbf_string_literal_new ("");
															_g_object_unref0 (node);
															node = (VbfConfigNode*) _tmp54_;
														}
													}
													vbf_config_node_list_add_value (items, node);
													_g_free0 (val);
													_g_object_unref0 (node);
												}
												_g_free0 (rh);
											}
										}
									}
									_tmp55_ = _g_object_ref0 ((VbfConfigNode*) items);
									_g_object_unref0 (data);
									data = _tmp55_;
									_g_object_unref0 (items);
								}
								_tmp56_ = _g_object_ref0 (data);
								_g_object_unref0 (variable->data);
								variable->data = _tmp56_;
							} else {
								VbfStringLiteral* _tmp57_ = NULL;
								_tmp57_ = vbf_string_literal_new ("");
								_g_object_unref0 (variable->data);
								variable->data = (VbfConfigNode*) _tmp57_;
							}
							if (group != NULL) {
								vbf_group_add_variable (group, variable);
							} else {
								vbf_project_add_variable (project, variable);
							}
							_g_object_unref0 (data);
							_g_object_unref0 (variable);
							_g_free0 (name);
							_g_free0 (lh);
						}
					}
				}
				_g_free0 (tmp);
				tmp = NULL;
				rhs = (_vala_array_free (rhs, rhs_length1, (GDestroyNotify) g_free), NULL);
				lhs = (_vala_array_free (lhs, lhs_length1, (GDestroyNotify) g_free), NULL);
				toks = (_vala_array_free (toks, toks_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	_g_free0 (tmp);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static VbfVariable* vbf_backends_autotools_resolve_variable (VbfBackendsAutotools* self, const gchar* variable_name, ValaList* variables) {
	VbfVariable* result = NULL;
	VbfVariable* variable;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (variable_name != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	variable = NULL;
	{
		ValaList* _tmp0_;
		ValaList* _item_list;
		gint _tmp1_;
		gint _item_size;
		gint _item_index;
		_tmp0_ = _vala_iterable_ref0 (variables);
		_item_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _item_list);
		_item_size = _tmp1_;
		_item_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfVariable* item;
			_item_index = _item_index + 1;
			if (!(_item_index < _item_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_item_list, _item_index);
			item = (VbfVariable*) _tmp2_;
			if (g_strcmp0 (variable_name, item->name) == 0) {
				VbfVariable* _tmp3_;
				_tmp3_ = _g_object_ref0 (item);
				_g_object_unref0 (variable);
				variable = _tmp3_;
				_g_object_unref0 (item);
				break;
			}
			_g_object_unref0 (item);
		}
		_vala_iterable_unref0 (_item_list);
	}
	result = variable;
	return result;
}


static void vbf_backends_autotools_resolve_package_variables (VbfBackendsAutotools* self, VbfProject* project) {
	ValaList* _tmp0_ = NULL;
	ValaList* variables;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	_tmp0_ = vbf_project_get_variables (project);
	variables = _tmp0_;
	{
		ValaList* _tmp1_ = NULL;
		ValaList* _module_list;
		gint _tmp2_;
		gint _module_size;
		gint _module_index;
		_tmp1_ = vbf_project_get_modules (project);
		_module_list = _tmp1_;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _module_list);
		_module_size = _tmp2_;
		_module_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			VbfModule* module;
			_module_index = _module_index + 1;
			if (!(_module_index < _module_size)) {
				break;
			}
			_tmp3_ = vala_list_get (_module_list, _module_index);
			module = (VbfModule*) _tmp3_;
			{
				ValaList* _tmp4_ = NULL;
				ValaList* _package_list;
				gint _tmp5_;
				gint _package_size;
				gint _package_index;
				_tmp4_ = vbf_module_get_packages (module);
				_package_list = _tmp4_;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _package_list);
				_package_size = _tmp5_;
				_package_index = -1;
				while (TRUE) {
					gpointer _tmp6_ = NULL;
					VbfPackage* package;
					_package_index = _package_index + 1;
					if (!(_package_index < _package_size)) {
						break;
					}
					_tmp6_ = vala_list_get (_package_list, _package_index);
					package = (VbfPackage*) _tmp6_;
					if (VBF_IS_UNRESOLVED_CONFIG_NODE (package->version)) {
						gchar* _tmp7_;
						gchar* name;
						VbfVariable* _tmp8_ = NULL;
						VbfVariable* target_variable;
						_tmp7_ = g_strdup (VBF_UNRESOLVED_CONFIG_NODE (package->version)->name);
						name = _tmp7_;
						_tmp8_ = vbf_backends_autotools_resolve_variable (self, name, variables);
						target_variable = _tmp8_;
						if (target_variable != NULL) {
							VbfConfigNode* _tmp9_;
							_tmp9_ = _g_object_ref0 (target_variable->data);
							_g_object_unref0 (package->version);
							package->version = _tmp9_;
						}
						_g_object_unref0 (target_variable);
						_g_free0 (name);
					}
					_g_object_unref0 (package);
				}
				_vala_iterable_unref0 (_package_list);
			}
			_g_object_unref0 (module);
		}
		_vala_iterable_unref0 (_module_list);
	}
	_vala_iterable_unref0 (variables);
}


static void vbf_backends_autotools_resolve_variables (VbfBackendsAutotools* self, VbfProject* project, ValaList* variables) {
	VbfVariable* target_variable = NULL;
	gchar* name = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (variables != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _variable_list;
		gint _tmp1_;
		gint _variable_size;
		gint _variable_index;
		_tmp0_ = _vala_iterable_ref0 (variables);
		_variable_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _variable_list);
		_variable_size = _tmp1_;
		_variable_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfVariable* variable;
			_variable_index = _variable_index + 1;
			if (!(_variable_index < _variable_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_variable_list, _variable_index);
			variable = (VbfVariable*) _tmp2_;
			if (VBF_IS_UNRESOLVED_CONFIG_NODE (variable->data)) {
				gchar* _tmp3_;
				VbfVariable* _tmp4_ = NULL;
				_tmp3_ = g_strdup (VBF_UNRESOLVED_CONFIG_NODE (variable->data)->name);
				_g_free0 (name);
				name = _tmp3_;
				_tmp4_ = vbf_backends_autotools_resolve_variable (self, name, variables);
				_g_object_unref0 (target_variable);
				target_variable = _tmp4_;
				if (target_variable == NULL) {
					ValaList* _tmp5_ = NULL;
					ValaList* _tmp6_;
					VbfVariable* _tmp7_ = NULL;
					_tmp5_ = vbf_project_get_variables (project);
					_tmp6_ = _tmp5_;
					_tmp7_ = vbf_backends_autotools_resolve_variable (self, name, _tmp6_);
					_g_object_unref0 (target_variable);
					target_variable = _tmp7_;
					_vala_iterable_unref0 (_tmp6_);
				}
				if (target_variable != NULL) {
					VbfConfigNode* _tmp8_;
					_tmp8_ = _g_object_ref0 ((VbfConfigNode*) target_variable);
					_g_object_unref0 (variable->data);
					variable->data = _tmp8_;
					((VbfConfigNode*) variable)->parent = (VbfConfigNode*) target_variable;
					vbf_variable_add_child (target_variable, variable);
				}
			} else {
				if (VBF_IS_CONFIG_NODE_LIST (variable->data)) {
					VbfConfigNodeList* _tmp9_;
					VbfConfigNodeList* datas;
					ValaArrayList* _tmp10_ = NULL;
					ValaList* resolved_nodes;
					_tmp9_ = _g_object_ref0 (VBF_CONFIG_NODE_LIST (variable->data));
					datas = _tmp9_;
					_tmp10_ = vala_array_list_new (VBF_TYPE_CONFIG_NODE_PAIR, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
					resolved_nodes = (ValaList*) _tmp10_;
					{
						ValaList* _tmp11_ = NULL;
						ValaList* _data_list;
						gint _tmp12_;
						gint _data_size;
						gint _data_index;
						_tmp11_ = vbf_config_node_list_get_values (datas);
						_data_list = _tmp11_;
						_tmp12_ = vala_collection_get_size ((ValaCollection*) _data_list);
						_data_size = _tmp12_;
						_data_index = -1;
						while (TRUE) {
							gpointer _tmp13_ = NULL;
							VbfConfigNode* data;
							_data_index = _data_index + 1;
							if (!(_data_index < _data_size)) {
								break;
							}
							_tmp13_ = vala_list_get (_data_list, _data_index);
							data = (VbfConfigNode*) _tmp13_;
							if (VBF_IS_UNRESOLVED_CONFIG_NODE (data)) {
								gchar* _tmp14_;
								VbfVariable* _tmp15_ = NULL;
								_tmp14_ = g_strdup (VBF_UNRESOLVED_CONFIG_NODE (data)->name);
								_g_free0 (name);
								name = _tmp14_;
								_tmp15_ = vbf_backends_autotools_resolve_variable (self, name, variables);
								_g_object_unref0 (target_variable);
								target_variable = _tmp15_;
								if (target_variable == NULL) {
									ValaList* _tmp16_ = NULL;
									ValaList* _tmp17_;
									VbfVariable* _tmp18_ = NULL;
									_tmp16_ = vbf_project_get_variables (project);
									_tmp17_ = _tmp16_;
									_tmp18_ = vbf_backends_autotools_resolve_variable (self, name, _tmp17_);
									_g_object_unref0 (target_variable);
									target_variable = _tmp18_;
									_vala_iterable_unref0 (_tmp17_);
								}
								if (target_variable != NULL) {
									if (target_variable->data != NULL) {
										VbfVariable* _tmp19_ = NULL;
										VbfVariable* child;
										VbfConfigNode* _tmp20_;
										VbfConfigNodePair* _tmp21_ = NULL;
										VbfConfigNodePair* _tmp22_;
										_tmp19_ = vbf_variable_new (name, (VbfConfigNode*) target_variable);
										child = _tmp19_;
										_tmp20_ = _g_object_ref0 ((VbfConfigNode*) target_variable);
										_g_object_unref0 (child->data);
										child->data = _tmp20_;
										vbf_variable_add_child (target_variable, child);
										_tmp21_ = vbf_config_node_pair_new (data, (VbfConfigNode*) child);
										_tmp22_ = _tmp21_;
										vala_collection_add ((ValaCollection*) resolved_nodes, _tmp22_);
										_g_object_unref0 (_tmp22_);
										_g_object_unref0 (child);
									} else {
										VbfConfigNodePair* _tmp23_ = NULL;
										VbfConfigNodePair* _tmp24_;
										_tmp23_ = vbf_config_node_pair_new (data, NULL);
										_tmp24_ = _tmp23_;
										vala_collection_add ((ValaCollection*) resolved_nodes, _tmp24_);
										_g_object_unref0 (_tmp24_);
									}
								}
							}
							_g_object_unref0 (data);
						}
						_vala_iterable_unref0 (_data_list);
					}
					{
						ValaList* _tmp25_;
						ValaList* _resolved_node_list;
						gint _tmp26_;
						gint _resolved_node_size;
						gint _resolved_node_index;
						_tmp25_ = _vala_iterable_ref0 (resolved_nodes);
						_resolved_node_list = _tmp25_;
						_tmp26_ = vala_collection_get_size ((ValaCollection*) _resolved_node_list);
						_resolved_node_size = _tmp26_;
						_resolved_node_index = -1;
						while (TRUE) {
							gpointer _tmp27_ = NULL;
							VbfConfigNodePair* resolved_node;
							_resolved_node_index = _resolved_node_index + 1;
							if (!(_resolved_node_index < _resolved_node_size)) {
								break;
							}
							_tmp27_ = vala_list_get (_resolved_node_list, _resolved_node_index);
							resolved_node = (VbfConfigNodePair*) _tmp27_;
							vbf_config_node_list_replace_config_node (datas, resolved_node->source, resolved_node->destination);
							_g_object_unref0 (resolved_node);
						}
						_vala_iterable_unref0 (_resolved_node_list);
					}
					_vala_iterable_unref0 (resolved_nodes);
					_g_object_unref0 (datas);
				}
			}
			_g_object_unref0 (variable);
		}
		_vala_iterable_unref0 (_variable_list);
	}
	_g_free0 (name);
	_g_object_unref0 (target_variable);
}


static gchar* vbf_backends_autotools_process_include_directives (VbfBackendsAutotools* self, const gchar* makefile, const gchar* buffer, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* res;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (makefile != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	_tmp0_ = g_strdup (buffer);
	res = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (buffer, "\n", 0);
	lines = _tmp2_;
	lines_length1 = _vala_array_length (_tmp1_);
	_lines_size_ = _vala_array_length (_tmp1_);
	{
		gchar** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			gchar* _tmp3_;
			gchar* line;
			_tmp3_ = g_strdup (line_collection[line_it]);
			line = _tmp3_;
			{
				gchar* _tmp4_ = NULL;
				gchar** _tmp5_;
				gchar** _tmp6_ = NULL;
				gchar** tmps;
				gint tmps_length1;
				gint _tmps_size_;
				if (g_strcmp0 (line, "") == 0) {
					_g_free0 (line);
					continue;
				}
				_tmp4_ = vbf_backends_autotools_normalize_string (self, line);
				_g_free0 (line);
				line = _tmp4_;
				_tmp6_ = _tmp5_ = g_strsplit (line, " ", 2);
				tmps = _tmp6_;
				tmps_length1 = _vala_array_length (_tmp5_);
				_tmps_size_ = _vala_array_length (_tmp5_);
				if (g_strcmp0 (tmps[0], "include") == 0) {
					gchar* _tmp7_ = NULL;
					gchar* filename;
					gchar* _tmp8_ = NULL;
					gchar* include_filename;
					gchar* included_file = NULL;
					gboolean _tmp9_;
					_tmp7_ = vbf_backends_autotools_normalize_string (self, tmps[1]);
					filename = _tmp7_;
					_tmp8_ = string_replace (makefile, "Makefile.am", filename);
					include_filename = _tmp8_;
					_tmp9_ = g_file_test (include_filename, G_FILE_TEST_EXISTS);
					if (_tmp9_) {
						gchar* _tmp10_ = NULL;
						gboolean _tmp11_;
						gboolean _tmp12_;
						_tmp11_ = g_file_get_contents (include_filename, &_tmp10_, NULL, &_inner_error_);
						_g_free0 (included_file);
						included_file = _tmp10_;
						_tmp12_ = _tmp11_;
						if (_inner_error_ != NULL) {
							goto __catch7_g_error;
						}
						if (_tmp12_) {
							gchar* _tmp13_ = NULL;
							gchar* _tmp14_;
							gchar* _tmp15_ = NULL;
							_tmp13_ = g_strdup_printf ("include %s", filename);
							_tmp14_ = _tmp13_;
							_tmp15_ = string_replace (res, _tmp14_, included_file);
							_g_free0 (res);
							res = _tmp15_;
							_g_free0 (_tmp14_);
						}
					}
					goto __finally7;
					__catch7_g_error:
					{
						GError * e;
						e = _inner_error_;
						_inner_error_ = NULL;
						g_warning ("vbfautotools.vala:577: Cannot include %s", filename);
						_g_error_free0 (e);
					}
					__finally7:
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (included_file);
						_g_free0 (include_filename);
						_g_free0 (filename);
						tmps = (_vala_array_free (tmps, tmps_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
						lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (res);
						return NULL;
					}
					_g_free0 (included_file);
					_g_free0 (include_filename);
					_g_free0 (filename);
				}
				tmps = (_vala_array_free (tmps, tmps_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	result = res;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vbf_backends_autotools_parse_makefile (VbfBackendsAutotools* self, VbfProject* project, const gchar* project_file, const gchar* makefile, GError** error) {
	gboolean _tmp0_;
	gchar* buffer = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* file;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	g_return_if_fail (project_file != NULL);
	g_return_if_fail (makefile != NULL);
	_tmp0_ = g_str_has_suffix (makefile, "Makefile");
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_build_filename (project_file, makefile, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, ".am", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	file = _tmp4_;
	_tmp6_ = g_file_get_contents (file, &_tmp5_, NULL, &_inner_error_);
	_g_free0 (buffer);
	buffer = _tmp5_;
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (file);
		_g_free0 (buffer);
		return;
	}
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		VbfGroup* _tmp10_ = NULL;
		VbfGroup* _tmp11_;
		VbfGroup* group;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		ValaList* _tmp14_ = NULL;
		ValaList* _tmp15_;
		_tmp8_ = string_replace (file, "Makefile.am", "");
		_tmp9_ = _tmp8_;
		_tmp10_ = vbf_group_new (project, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		group = _tmp11_;
		vbf_project_add_group (project, group);
		_tmp12_ = vbf_backends_autotools_process_include_directives (self, file, buffer, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (group);
			_g_free0 (file);
			_g_free0 (buffer);
			return;
		}
		_g_free0 (buffer);
		buffer = _tmp13_;
		vbf_backends_autotools_parse_variables (self, project, buffer, group, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (group);
			_g_free0 (file);
			_g_free0 (buffer);
			return;
		}
		_tmp14_ = vbf_group_get_variables (group);
		_tmp15_ = _tmp14_;
		vbf_backends_autotools_resolve_variables (self, project, _tmp15_);
		_vala_iterable_unref0 (_tmp15_);
		vbf_backends_autotools_parse_targets (self, group);
		vbf_backends_autotools_parse_group_extended_info (self, group, buffer);
		_g_object_unref0 (group);
	}
	_g_free0 (file);
	_g_free0 (buffer);
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static void vbf_backends_autotools_parse_group_extended_info (VbfBackendsAutotools* self, VbfGroup* group, const gchar* buffer) {
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	VbfTarget* target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (buffer != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (buffer, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = _vala_array_length (_tmp0_);
	target = NULL;
	{
		gchar** line_collection;
		int line_collection_length1;
		int line_it;
		line_collection = lines;
		line_collection_length1 = lines_length1;
		for (line_it = 0; line_it < lines_length1; line_it = line_it + 1) {
			gchar* _tmp2_;
			gchar* line;
			_tmp2_ = g_strdup (line_collection[line_it]);
			line = _tmp2_;
			{
				gchar* _tmp3_ = NULL;
				gchar** _tmp32_;
				gchar** _tmp33_ = NULL;
				gchar** tmps;
				gint tmps_length1;
				gint _tmps_size_;
				gint count;
				_tmp3_ = vbf_backends_autotools_normalize_string (self, line);
				_g_free0 (line);
				line = _tmp3_;
				if (g_strcmp0 (line, "") == 0) {
					if (target != NULL) {
						_g_object_unref0 (target);
						target = NULL;
					}
					_g_free0 (line);
					continue;
				}
				if (target == NULL) {
					gchar** _tmp4_;
					gchar** _tmp5_ = NULL;
					gchar** rule_parts;
					gint rule_parts_length1;
					gint _rule_parts_size_;
					gboolean _tmp6_ = FALSE;
					_tmp5_ = _tmp4_ = g_strsplit (line, "=", 2);
					rule_parts = _tmp5_;
					rule_parts_length1 = _vala_array_length (_tmp4_);
					_rule_parts_size_ = _vala_array_length (_tmp4_);
					if (rule_parts_length1 >= 2) {
						gchar* _tmp7_ = NULL;
						gchar* _tmp8_;
						gboolean _tmp9_;
						_tmp7_ = string_chomp (rule_parts[0]);
						_tmp8_ = _tmp7_;
						_tmp9_ = g_str_has_suffix (_tmp8_, "_VALAFLAGS");
						_tmp6_ = _tmp9_;
						_g_free0 (_tmp8_);
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						gchar* _tmp10_;
						gchar* target_id;
						gchar** _tmp11_;
						gchar** _tmp12_ = NULL;
						gchar** target_tmp;
						gint target_tmp_length1;
						gint _target_tmp_size_;
						gchar* _tmp18_ = NULL;
						gchar* _tmp19_ = NULL;
						const gchar* _tmp24_ = NULL;
						_tmp10_ = g_strdup ("");
						target_id = _tmp10_;
						_tmp12_ = _tmp11_ = g_strsplit (rule_parts[0], "_", 0);
						target_tmp = _tmp12_;
						target_tmp_length1 = _vala_array_length (_tmp11_);
						_target_tmp_size_ = _vala_array_length (_tmp11_);
						{
							gint i;
							i = 0;
							{
								gboolean _tmp13_;
								_tmp13_ = TRUE;
								while (TRUE) {
									gchar* _tmp14_ = NULL;
									if (!_tmp13_) {
										i++;
									}
									_tmp13_ = FALSE;
									if (!(i < (target_tmp_length1 - 1))) {
										break;
									}
									_tmp14_ = g_strconcat (target_id, target_tmp[i], ".", NULL);
									_g_free0 (target_id);
									target_id = _tmp14_;
								}
							}
						}
						while (TRUE) {
							gboolean _tmp15_;
							gint _tmp16_;
							gchar* _tmp17_ = NULL;
							_tmp15_ = g_str_has_suffix (target_id, ".");
							if (!_tmp15_) {
								break;
							}
							_tmp16_ = strlen (target_id);
							_tmp17_ = string_substring (target_id, (glong) 0, (glong) (_tmp16_ - 1));
							_g_free0 (target_id);
							target_id = _tmp17_;
						}
						_tmp18_ = vbf_backends_autotools_normalize_target_id (self, target_id);
						_g_free0 (target_id);
						target_id = _tmp18_;
						_tmp19_ = vbf_backends_autotools_convert_to_primary_name (self, target_id);
						_g_free0 (target_id);
						target_id = _tmp19_;
						{
							ValaList* _tmp20_ = NULL;
							ValaList* _t_list;
							gint _tmp21_;
							gint _t_size;
							gint _t_index;
							_tmp20_ = vbf_group_get_targets (group);
							_t_list = _tmp20_;
							_tmp21_ = vala_collection_get_size ((ValaCollection*) _t_list);
							_t_size = _tmp21_;
							_t_index = -1;
							while (TRUE) {
								gpointer _tmp22_ = NULL;
								VbfTarget* t;
								_t_index = _t_index + 1;
								if (!(_t_index < _t_size)) {
									break;
								}
								_tmp22_ = vala_list_get (_t_list, _t_index);
								t = (VbfTarget*) _tmp22_;
								if (g_strcmp0 (target_id, t->id) == 0) {
									VbfTarget* _tmp23_;
									_tmp23_ = _g_object_ref0 (t);
									_g_object_unref0 (target);
									target = _tmp23_;
									_g_object_unref0 (t);
									break;
								}
								_g_object_unref0 (t);
							}
							_vala_iterable_unref0 (_t_list);
						}
						if (target == NULL) {
							_tmp24_ = "not found!";
						} else {
							_tmp24_ = target->id;
						}
						vbf_utils_trace ("vbfautotools.vala:639: group %s - target for: %s is %s", group->id, target_id, _tmp24_);
						target_tmp = (_vala_array_free (target_tmp, target_tmp_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (target_id);
					} else {
						gchar** _tmp25_;
						gchar** _tmp26_ = NULL;
						_tmp26_ = _tmp25_ = g_strsplit (line, ":", 2);
						rule_parts = (_vala_array_free (rule_parts, rule_parts_length1, (GDestroyNotify) g_free), NULL);
						rule_parts = _tmp26_;
						rule_parts_length1 = _vala_array_length (_tmp25_);
						_rule_parts_size_ = _vala_array_length (_tmp25_);
						if (rule_parts_length1 == 2) {
							gchar** _tmp27_;
							gchar** _tmp28_ = NULL;
							gchar** trgs;
							gint trgs_length1;
							gint _trgs_size_;
							_tmp28_ = _tmp27_ = g_strsplit (rule_parts[0], " ", 0);
							trgs = _tmp28_;
							trgs_length1 = _vala_array_length (_tmp27_);
							_trgs_size_ = _vala_array_length (_tmp27_);
							{
								gchar** trg_collection;
								int trg_collection_length1;
								int trg_it;
								trg_collection = trgs;
								trg_collection_length1 = trgs_length1;
								for (trg_it = 0; trg_it < trgs_length1; trg_it = trg_it + 1) {
									gchar* _tmp29_;
									gchar* trg;
									_tmp29_ = g_strdup (trg_collection[trg_it]);
									trg = _tmp29_;
									{
										gchar* _tmp30_ = NULL;
										gchar* id;
										VbfTarget* _tmp31_ = NULL;
										_tmp30_ = vbf_backends_autotools_normalize_target_id (self, trg);
										id = _tmp30_;
										_tmp31_ = vbf_group_get_target_for_id (group, id);
										_g_object_unref0 (target);
										target = _tmp31_;
										if (target != NULL) {
											_g_free0 (id);
											_g_free0 (trg);
											break;
										}
										_g_free0 (id);
										_g_free0 (trg);
									}
								}
							}
							trgs = (_vala_array_free (trgs, trgs_length1, (GDestroyNotify) g_free), NULL);
						}
					}
					rule_parts = (_vala_array_free (rule_parts, rule_parts_length1, (GDestroyNotify) g_free), NULL);
				}
				_tmp33_ = _tmp32_ = g_strsplit (line, " ", 0);
				tmps = _tmp33_;
				tmps_length1 = _vala_array_length (_tmp32_);
				_tmps_size_ = _vala_array_length (_tmp32_);
				count = tmps_length1;
				{
					gint idx;
					idx = 0;
					{
						gboolean _tmp34_;
						_tmp34_ = TRUE;
						while (TRUE) {
							gboolean _tmp35_ = FALSE;
							if (!_tmp34_) {
								idx++;
							}
							_tmp34_ = FALSE;
							if (!(idx < count)) {
								break;
							}
							if (g_strcmp0 (tmps[idx], "--vapidir") == 0) {
								_tmp35_ = (idx + 1) < count;
							} else {
								_tmp35_ = FALSE;
							}
							if (_tmp35_) {
								gchar* _tmp36_;
								gchar* tmp;
								gboolean _tmp37_;
								_tmp36_ = g_strdup (tmps[idx + 1]);
								tmp = _tmp36_;
								vbf_utils_trace ("vbfautotools.vala:663: vapi: %s", tmp);
								_tmp37_ = g_str_has_prefix (tmp, ".");
								if (_tmp37_) {
									gchar* _tmp38_ = NULL;
									_tmp38_ = g_build_filename (group->project->id, group->name, tmp, NULL);
									_g_free0 (tmp);
									tmp = _tmp38_;
								} else {
									gboolean _tmp39_;
									_tmp39_ = g_str_has_prefix (tmp, "$(srcdir)");
									if (_tmp39_) {
										gchar* _tmp40_ = NULL;
										gchar* _tmp41_;
										gchar* _tmp42_ = NULL;
										_tmp40_ = g_build_filename (group->project->id, group->name, NULL);
										_tmp41_ = _tmp40_;
										_tmp42_ = string_replace (tmp, "$(srcdir)", _tmp41_);
										_g_free0 (tmp);
										tmp = _tmp42_;
										_g_free0 (_tmp41_);
									} else {
										gboolean _tmp43_;
										_tmp43_ = g_str_has_prefix (tmp, "$(top_srcdir)");
										if (_tmp43_) {
											gchar* _tmp44_ = NULL;
											_tmp44_ = string_replace (tmp, "$(top_srcdir)", group->project->id);
											_g_free0 (tmp);
											tmp = _tmp44_;
										} else {
											gchar* _tmp45_ = NULL;
											_tmp45_ = g_build_filename (group->project->id, group->name, tmp, NULL);
											_g_free0 (tmp);
											tmp = _tmp45_;
										}
									}
								}
								if (target != NULL) {
									vbf_target_add_include_dir (target, tmp);
								} else {
									vbf_utils_trace ("vbfautotools.vala:677: adding vapidir %s to group because target is nu" \
"ll", tmp);
									vbf_group_add_include_dir (group, tmp);
								}
								idx++;
								_g_free0 (tmp);
							} else {
								gboolean _tmp46_ = FALSE;
								if (g_strcmp0 (tmps[idx], "--pkg") == 0) {
									_tmp46_ = (idx + 1) < count;
								} else {
									_tmp46_ = FALSE;
								}
								if (_tmp46_) {
									gchar* _tmp47_;
									gchar* tmp;
									ValaList* _tmp48_ = NULL;
									ValaList* _tmp49_;
									gchar* _tmp50_ = NULL;
									_tmp47_ = g_strdup (tmps[idx + 1]);
									tmp = _tmp47_;
									_tmp48_ = vbf_project_get_variables (group->project);
									_tmp49_ = _tmp48_;
									_tmp50_ = vbf_backends_autotools_substitute_variables (self, tmp, _tmp49_);
									_g_free0 (tmp);
									tmp = _tmp50_;
									_vala_iterable_unref0 (_tmp49_);
									if (target != NULL) {
										VbfPackage* _tmp51_ = NULL;
										VbfPackage* _tmp52_;
										_tmp51_ = vbf_package_new (tmp);
										_tmp52_ = _tmp51_;
										vbf_target_add_package (target, _tmp52_);
										_g_object_unref0 (_tmp52_);
									} else {
										VbfPackage* _tmp53_ = NULL;
										VbfPackage* _tmp54_;
										vbf_utils_trace ("vbfautotools.vala:687: adding package %s to group because target is nu" \
"ll", tmp);
										_tmp53_ = vbf_package_new (tmp);
										_tmp54_ = _tmp53_;
										vbf_group_add_package (group, _tmp54_);
										_g_object_unref0 (_tmp54_);
									}
									idx++;
									_g_free0 (tmp);
								} else {
									if (g_strcmp0 (tmps[idx], "--library") == 0) {
										gchar* _tmp55_;
										gchar* tmp;
										ValaList* _tmp56_ = NULL;
										ValaList* _tmp57_;
										gchar* _tmp58_ = NULL;
										_tmp55_ = g_strdup (tmps[idx + 1]);
										tmp = _tmp55_;
										_tmp56_ = vbf_project_get_variables (group->project);
										_tmp57_ = _tmp56_;
										_tmp58_ = vbf_backends_autotools_substitute_variables (self, tmp, _tmp57_);
										_g_free0 (tmp);
										tmp = _tmp58_;
										_vala_iterable_unref0 (_tmp57_);
										if (target != NULL) {
											vbf_target_add_built_library (target, tmp);
										} else {
											vbf_group_add_built_library (group, tmp);
										}
										idx++;
										_g_free0 (tmp);
									}
								}
							}
						}
					}
				}
				tmps = (_vala_array_free (tmps, tmps_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
	}
	_g_object_unref0 (target);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* vbf_backends_autotools_substitute_variables (VbfBackendsAutotools* self, const gchar* data, ValaList* variables) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	gint _tmp1_;
	gint index;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	g_return_val_if_fail (variables != NULL, NULL);
	_tmp0_ = g_strdup (data);
	_result_ = _tmp0_;
	_tmp1_ = string_index_of (data, "$", 0);
	index = _tmp1_;
	if (index < 0) {
		gint _tmp2_;
		_tmp2_ = string_index_of (data, "@", 0);
		index = _tmp2_;
	}
	if (index >= 0) {
		gchar* _tmp3_ = NULL;
		gchar* variable;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* var_name;
		gboolean _tmp10_;
		VbfVariable* _tmp13_ = NULL;
		VbfVariable* res;
		_tmp3_ = string_substring (data, (glong) index, (glong) (-1));
		variable = _tmp3_;
		_tmp4_ = string_replace (variable, "(", "");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_replace (_tmp5_, ")", "");
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (_tmp7_, (glong) 1, (glong) (-1));
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		var_name = _tmp9_;
		_tmp10_ = g_str_has_suffix (var_name, "@");
		if (_tmp10_) {
			gint _tmp11_;
			gchar* _tmp12_ = NULL;
			_tmp11_ = strlen (var_name);
			_tmp12_ = string_substring (var_name, (glong) 0, (glong) (_tmp11_ - 1));
			_g_free0 (var_name);
			var_name = _tmp12_;
		}
		_tmp13_ = vbf_backends_autotools_resolve_variable (self, var_name, variables);
		res = _tmp13_;
		if (res != NULL) {
			VbfConfigNode* _tmp14_ = NULL;
			VbfConfigNode* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			_tmp14_ = vbf_variable_get_value (res);
			_tmp15_ = _tmp14_;
			_tmp16_ = vbf_config_node_to_string (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = string_replace (data, variable, _tmp17_);
			_g_free0 (_result_);
			_result_ = _tmp18_;
			_g_free0 (_tmp17_);
			_g_object_unref0 (_tmp15_);
		}
		_g_object_unref0 (res);
		_g_free0 (var_name);
		_g_free0 (variable);
	}
	result = _result_;
	return result;
}


static gchar* vbf_backends_autotools_normalize_string (VbfBackendsAutotools* self, const gchar* data) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* res;
	gchar* _tmp1_ = NULL;
	gchar* old;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	if (data == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = string_replace (data, "\n", " ");
	res = _tmp0_;
	_tmp1_ = string_replace (res, "\t", " ");
	_g_free0 (res);
	res = _tmp1_;
	old = NULL;
	while (TRUE) {
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		if (!(g_strcmp0 (old, res) != 0)) {
			break;
		}
		_tmp2_ = g_strdup (res);
		_g_free0 (old);
		old = _tmp2_;
		_tmp3_ = string_replace (res, "  ", " ");
		_g_free0 (res);
		res = _tmp3_;
	}
	_tmp4_ = string_strip (res);
	_g_free0 (res);
	res = _tmp4_;
	_tmp5_ = g_str_has_prefix (res, "[");
	if (_tmp5_) {
		gint _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp6_ = strlen (res);
		_tmp7_ = string_substring (res, (glong) 1, (glong) (_tmp6_ - 1));
		_g_free0 (res);
		res = _tmp7_;
	}
	_tmp8_ = g_str_has_suffix (res, "]");
	if (_tmp8_) {
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		_tmp9_ = strlen (res);
		_tmp10_ = string_substring (res, (glong) 0, (glong) (_tmp9_ - 1));
		_g_free0 (res);
		res = _tmp10_;
	}
	result = res;
	_g_free0 (old);
	return result;
}


static gchar* vbf_backends_autotools_normalize_target_id (VbfBackendsAutotools* self, const gchar* target_id) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	gboolean _tmp1_;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target_id != NULL, NULL);
	_tmp0_ = g_strdup (target_id);
	_result_ = _tmp0_;
	_tmp1_ = g_str_has_suffix (_result_, "_VALASOURCES");
	if (_tmp1_) {
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = strlen (_result_);
		_tmp3_ = strlen ("_VALASOURCES");
		_tmp4_ = string_substring (_result_, (glong) 0, (glong) (_tmp2_ - _tmp3_));
		_g_free0 (_result_);
		_result_ = _tmp4_;
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_suffix (_result_, "_SOURCES");
		if (_tmp5_) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* _tmp8_ = NULL;
			_tmp6_ = strlen (_result_);
			_tmp7_ = strlen ("_SOURCES");
			_tmp8_ = string_substring (_result_, (glong) 0, (glong) (_tmp6_ - _tmp7_));
			_g_free0 (_result_);
			_result_ = _tmp8_;
		} else {
			gboolean _tmp9_;
			_tmp9_ = g_str_has_suffix (_result_, ".stamp");
			if (_tmp9_) {
				gint _tmp10_;
				gint _tmp11_;
				gchar* _tmp12_ = NULL;
				gboolean _tmp13_;
				_tmp10_ = strlen (_result_);
				_tmp11_ = strlen (".stamp");
				_tmp12_ = string_substring (_result_, (glong) 0, (glong) (_tmp10_ - _tmp11_));
				_g_free0 (_result_);
				_result_ = _tmp12_;
				_tmp13_ = g_str_has_suffix (_result_, ".vala");
				if (_tmp13_) {
					gint _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_ = NULL;
					_tmp14_ = strlen (_result_);
					_tmp15_ = strlen (".vala");
					_tmp16_ = string_substring (_result_, (glong) 0, (glong) (_tmp14_ - _tmp15_));
					_g_free0 (_result_);
					_result_ = _tmp16_;
				}
			}
		}
	}
	_tmp17_ = vbf_backends_autotools_convert_to_primary_name (self, _result_);
	result = _tmp17_;
	_g_free0 (_result_);
	return result;
}


static gchar* vbf_backends_autotools_normalize_target_id_for_display (VbfBackendsAutotools* self, const gchar* target_id) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _result_;
	gboolean _tmp1_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (target_id != NULL, NULL);
	_tmp0_ = g_strdup (target_id);
	_result_ = _tmp0_;
	_tmp1_ = g_str_has_suffix (_result_, "_VALASOURCES");
	if (_tmp1_) {
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = strlen (_result_);
		_tmp3_ = strlen ("_VALASOURCES");
		_tmp4_ = string_substring (_result_, (glong) 0, (glong) (_tmp2_ - _tmp3_));
		_g_free0 (_result_);
		_result_ = _tmp4_;
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_suffix (_result_, "_SOURCES");
		if (_tmp5_) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* _tmp8_ = NULL;
			_tmp6_ = strlen (_result_);
			_tmp7_ = strlen ("_SOURCES");
			_tmp8_ = string_substring (_result_, (glong) 0, (glong) (_tmp6_ - _tmp7_));
			_g_free0 (_result_);
			_result_ = _tmp8_;
		} else {
			gboolean _tmp9_;
			_tmp9_ = g_str_has_suffix (_result_, ".stamp");
			if (_tmp9_) {
				gint _tmp10_;
				gint _tmp11_;
				gchar* _tmp12_ = NULL;
				gboolean _tmp13_;
				_tmp10_ = strlen (_result_);
				_tmp11_ = strlen (".stamp");
				_tmp12_ = string_substring (_result_, (glong) 0, (glong) (_tmp10_ - _tmp11_));
				_g_free0 (_result_);
				_result_ = _tmp12_;
				_tmp13_ = g_str_has_suffix (_result_, ".vala");
				if (_tmp13_) {
					gint _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_ = NULL;
					_tmp14_ = strlen (_result_);
					_tmp15_ = strlen (".vala");
					_tmp16_ = string_substring (_result_, (glong) 0, (glong) (_tmp14_ - _tmp15_));
					_g_free0 (_result_);
					_result_ = _tmp16_;
				}
			}
		}
	}
	_tmp20_ = g_str_has_suffix (_result_, "_la");
	if (_tmp20_) {
		_tmp19_ = TRUE;
	} else {
		gboolean _tmp21_;
		_tmp21_ = g_str_has_suffix (_result_, "_so");
		_tmp19_ = _tmp21_;
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp22_;
		_tmp22_ = g_str_has_suffix (_result_, ".la");
		_tmp18_ = _tmp22_;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp23_;
		_tmp23_ = g_str_has_suffix (_result_, ".so");
		_tmp17_ = _tmp23_;
	}
	if (_tmp17_) {
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		_tmp24_ = strlen (_result_);
		_tmp25_ = string_substring (_result_, (glong) 0, (glong) (_tmp24_ - 3));
		_g_free0 (_result_);
		_result_ = _tmp25_;
	}
	result = _result_;
	return result;
}


static gchar* vbf_backends_autotools_convert_to_primary_name (VbfBackendsAutotools* self, const gchar* data) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = string_replace (data, ".", "_");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static void _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	vbf_backends_autotools_on_project_file_changed (self, _sender, file, other_file, event_type);
}


static void vbf_backends_autotools_setup_file_monitors (VbfBackendsAutotools* self, VbfProject* project) {
	gchar* fname = NULL;
	GFile* file = NULL;
	GFileMonitor* file_mon = NULL;
	gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFileMonitor* _tmp9_ = NULL;
	GFileMonitor* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (project != NULL);
	{
		ValaList* _tmp0_ = NULL;
		ValaList* _group_list;
		gint _tmp1_;
		gint _group_size;
		gint _group_index;
		_tmp0_ = vbf_project_get_groups (project);
		_group_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _group_list);
		_group_size = _tmp1_;
		_group_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			VbfGroup* group;
			gchar* _tmp3_ = NULL;
			GFile* _tmp4_ = NULL;
			GFileMonitor* _tmp5_ = NULL;
			GFileMonitor* _tmp6_;
			_group_index = _group_index + 1;
			if (!(_group_index < _group_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_group_list, _group_index);
			group = (VbfGroup*) _tmp2_;
			_tmp3_ = g_build_filename (group->id, "Makefile.am", NULL);
			_g_free0 (fname);
			fname = _tmp3_;
			vbf_utils_trace ("vbfautotools.vala:806: setup_file_monitors for: %s", fname);
			_tmp4_ = g_file_new_for_path (fname);
			_g_object_unref0 (file);
			file = _tmp4_;
			_tmp5_ = g_file_monitor_file (file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (group);
				_vala_iterable_unref0 (_group_list);
				_g_object_unref0 (file_mon);
				_g_object_unref0 (file);
				_g_free0 (fname);
				goto __catch8_g_error;
			}
			_g_object_unref0 (file_mon);
			file_mon = _tmp6_;
			g_signal_connect_object (file_mon, "changed", (GCallback) _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed, self, 0);
			vala_collection_add ((ValaCollection*) self->priv->file_mons, file_mon);
			_g_object_unref0 (group);
		}
		_vala_iterable_unref0 (_group_list);
	}
	_tmp7_ = g_build_filename (project->id, "configure.ac", NULL);
	_g_free0 (fname);
	fname = _tmp7_;
	_tmp8_ = g_file_new_for_path (fname);
	_g_object_unref0 (file);
	file = _tmp8_;
	_tmp9_ = g_file_monitor_file (file, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file_mon);
		_g_object_unref0 (file);
		_g_free0 (fname);
		goto __catch8_g_error;
	}
	_g_object_unref0 (file_mon);
	file_mon = _tmp10_;
	g_signal_connect_object (file_mon, "changed", (GCallback) _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed, self, 0);
	vala_collection_add ((ValaCollection*) self->priv->file_mons, file_mon);
	_g_object_unref0 (file_mon);
	_g_object_unref0 (file);
	_g_free0 (fname);
	goto __finally8;
	__catch8_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vbfautotools.vala:819: setup_file_monitors error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void vbf_backends_autotools_cleanup_file_monitors (VbfBackendsAutotools* self) {
	g_return_if_fail (self != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _file_mon_list;
		gint _tmp1_;
		gint _file_mon_size;
		gint _file_mon_index;
		_tmp0_ = _vala_iterable_ref0 (self->priv->file_mons);
		_file_mon_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _file_mon_list);
		_file_mon_size = _tmp1_;
		_file_mon_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			GFileMonitor* file_mon;
			guint _tmp3_;
			_file_mon_index = _file_mon_index + 1;
			if (!(_file_mon_index < _file_mon_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_file_mon_list, _file_mon_index);
			file_mon = (GFileMonitor*) _tmp2_;
			g_signal_parse_name ("changed", G_TYPE_FILE_MONITOR, &_tmp3_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (file_mon, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _vbf_backends_autotools_on_project_file_changed_g_file_monitor_changed, self);
			g_file_monitor_cancel (file_mon);
			_g_object_unref0 (file_mon);
		}
		_vala_iterable_unref0 (_file_mon_list);
	}
	vala_collection_clear ((ValaCollection*) self->priv->file_mons);
}


static void vbf_backends_autotools_on_project_file_changed (VbfBackendsAutotools* self, GFileMonitor* sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_monitor_is_cancelled (sender);
	if (!_tmp0_) {
		if (event_type == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
			vbf_project_update (self->priv->_project);
		}
	}
}


VbfBackendsAutotools* vbf_backends_autotools_construct (GType object_type) {
	VbfBackendsAutotools * self = NULL;
	self = (VbfBackendsAutotools*) g_object_new (object_type, NULL);
	return self;
}


VbfBackendsAutotools* vbf_backends_autotools_new (void) {
	return vbf_backends_autotools_construct (VBF_BACKENDS_TYPE_AUTOTOOLS);
}


static gchar* vbf_backends_autotools_real_get_configure_command (VbfIProjectBackend* base) {
	gchar* result;
	VbfBackendsAutotools* self;
	gchar* _result_;
	gboolean _tmp0_ = FALSE;
	self = (VbfBackendsAutotools*) base;
	_result_ = NULL;
	if (self->priv->_project != NULL) {
		_tmp0_ = self->priv->_project->working_dir != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar** _tmp3_ = NULL;
		_tmp1_ = g_strdup ("./configure");
		_tmp2_ = g_strdup ("./autogen.sh");
		_tmp3_ = g_new0 (gchar*, 2 + 1);
		_tmp3_[0] = _tmp1_;
		_tmp3_[1] = _tmp2_;
		{
			gchar** item_collection;
			int item_collection_length1;
			int item_it;
			item_collection = _tmp3_;
			item_collection_length1 = 2;
			for (item_it = 0; item_it < 2; item_it = item_it + 1) {
				gchar* _tmp4_;
				gchar* item;
				_tmp4_ = g_strdup (item_collection[item_it]);
				item = _tmp4_;
				{
					gchar* _tmp5_ = NULL;
					gchar* file;
					gboolean _tmp6_;
					_tmp5_ = g_build_filename (self->priv->_project->working_dir, item, NULL);
					file = _tmp5_;
					_tmp6_ = g_file_test (file, G_FILE_TEST_EXISTS);
					if (_tmp6_) {
						gchar* _tmp7_;
						_tmp7_ = g_strdup (item);
						_g_free0 (_result_);
						_result_ = _tmp7_;
						_g_free0 (file);
						_g_free0 (item);
						break;
					}
					_g_free0 (file);
					_g_free0 (item);
				}
			}
			item_collection = (_vala_array_free (item_collection, item_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	result = _result_;
	return result;
}


static gchar* vbf_backends_autotools_real_get_build_command (VbfIProjectBackend* base) {
	gchar* result;
	VbfBackendsAutotools* self;
	gchar* _tmp0_;
	self = (VbfBackendsAutotools*) base;
	_tmp0_ = g_strdup ("make");
	result = _tmp0_;
	return result;
}


static gchar* vbf_backends_autotools_real_get_clean_command (VbfIProjectBackend* base) {
	gchar* result;
	VbfBackendsAutotools* self;
	gchar* _tmp0_;
	self = (VbfBackendsAutotools*) base;
	_tmp0_ = g_strdup ("make clean");
	result = _tmp0_;
	return result;
}


static void vbf_backends_autotools_class_init (VbfBackendsAutotoolsClass * klass) {
	vbf_backends_autotools_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VbfBackendsAutotoolsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_vbf_backends_autotools_get_property;
	G_OBJECT_CLASS (klass)->finalize = vbf_backends_autotools_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_AUTOTOOLS_CONFIGURE_COMMAND, "configure-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_AUTOTOOLS_BUILD_COMMAND, "build-command");
	g_object_class_override_property (G_OBJECT_CLASS (klass), VBF_BACKENDS_AUTOTOOLS_CLEAN_COMMAND, "clean-command");
}


static void vbf_backends_autotools_vbf_iproject_backend_interface_init (VbfIProjectBackendIface * iface) {
	vbf_backends_autotools_vbf_iproject_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->probe = (gboolean (*)(VbfIProjectBackend* ,const gchar*)) vbf_backends_autotools_real_probe;
	iface->open = (VbfProject* (*)(VbfIProjectBackend* ,const gchar*)) vbf_backends_autotools_real_open;
	iface->refresh = (void (*)(VbfIProjectBackend* ,VbfProject*)) vbf_backends_autotools_real_refresh;
	iface->get_configure_command = vbf_backends_autotools_real_get_configure_command;
	iface->get_build_command = vbf_backends_autotools_real_get_build_command;
	iface->get_clean_command = vbf_backends_autotools_real_get_clean_command;
}


static void vbf_backends_autotools_instance_init (VbfBackendsAutotools * self) {
	ValaArrayList* _tmp0_ = NULL;
	self->priv = VBF_BACKENDS_AUTOTOOLS_GET_PRIVATE (self);
	_tmp0_ = vala_array_list_new (G_TYPE_FILE_MONITOR, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	self->priv->file_mons = (ValaList*) _tmp0_;
}


static void vbf_backends_autotools_finalize (GObject* obj) {
	VbfBackendsAutotools * self;
	self = VBF_BACKENDS_AUTOTOOLS (obj);
	_vala_iterable_unref0 (self->priv->file_mons);
	G_OBJECT_CLASS (vbf_backends_autotools_parent_class)->finalize (obj);
}


GType vbf_backends_autotools_get_type (void) {
	static volatile gsize vbf_backends_autotools_type_id__volatile = 0;
	if (g_once_init_enter (&vbf_backends_autotools_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VbfBackendsAutotoolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vbf_backends_autotools_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VbfBackendsAutotools), 0, (GInstanceInitFunc) vbf_backends_autotools_instance_init, NULL };
		static const GInterfaceInfo vbf_iproject_backend_info = { (GInterfaceInitFunc) vbf_backends_autotools_vbf_iproject_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vbf_backends_autotools_type_id;
		vbf_backends_autotools_type_id = g_type_register_static (G_TYPE_OBJECT, "VbfBackendsAutotools", &g_define_type_info, 0);
		g_type_add_interface_static (vbf_backends_autotools_type_id, VBF_TYPE_IPROJECT_BACKEND, &vbf_iproject_backend_info);
		g_once_init_leave (&vbf_backends_autotools_type_id__volatile, vbf_backends_autotools_type_id);
	}
	return vbf_backends_autotools_type_id__volatile;
}


static void _vala_vbf_backends_autotools_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	VbfBackendsAutotools * self;
	self = VBF_BACKENDS_AUTOTOOLS (object);
	switch (property_id) {
		case VBF_BACKENDS_AUTOTOOLS_CONFIGURE_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_configure_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_AUTOTOOLS_BUILD_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_build_command ((VbfIProjectBackend*) self));
		break;
		case VBF_BACKENDS_AUTOTOOLS_CLEAN_COMMAND:
		g_value_take_string (value, vbf_iproject_backend_get_clean_command ((VbfIProjectBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



