/* vtgsymbolcompletionprovider.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vtgsymbolcompletionprovider.vala, do not modify */

/*
 *  vtgsymbolcompletionprovider.vala - Vala developer toys for GEdit
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *   
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksourceview.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <gtksourceview/gtksourcecompletionitem.h>
#include <gtk/gtk.h>
#include <afrodite.h>
#include <gedit/gedit-view.h>
#include <gdk/gdk.h>
#include <gedit/gedit-document.h>
#include <gedit/gedit-window.h>
#include <gedit/gedit-statusbar.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkkeysyms.h>
#include <valagee.h>
#include <vbf.h>


#define VTG_TYPE_SYMBOL_COMPLETION_PROVIDER (vtg_symbol_completion_provider_get_type ())
#define VTG_SYMBOL_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProvider))
#define VTG_SYMBOL_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProviderClass))
#define VTG_IS_SYMBOL_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER))
#define VTG_IS_SYMBOL_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER))
#define VTG_SYMBOL_COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProviderClass))

typedef struct _VtgSymbolCompletionProvider VtgSymbolCompletionProvider;
typedef struct _VtgSymbolCompletionProviderClass VtgSymbolCompletionProviderClass;
typedef struct _VtgSymbolCompletionProviderPrivate VtgSymbolCompletionProviderPrivate;

#define VTG_TYPE_SYMBOL_COMPLETION (vtg_symbol_completion_get_type ())
#define VTG_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletion))
#define VTG_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))
#define VTG_IS_SYMBOL_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_IS_SYMBOL_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_SYMBOL_COMPLETION))
#define VTG_SYMBOL_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_SYMBOL_COMPLETION, VtgSymbolCompletionClass))

typedef struct _VtgSymbolCompletion VtgSymbolCompletion;
typedef struct _VtgSymbolCompletionClass VtgSymbolCompletionClass;

#define VTG_TYPE_PLUGIN_INSTANCE (vtg_plugin_instance_get_type ())
#define VTG_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstance))
#define VTG_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))
#define VTG_IS_PLUGIN_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_IS_PLUGIN_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PLUGIN_INSTANCE))
#define VTG_PLUGIN_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PLUGIN_INSTANCE, VtgPluginInstanceClass))

typedef struct _VtgPluginInstance VtgPluginInstance;
typedef struct _VtgPluginInstanceClass VtgPluginInstanceClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VTG_TYPE_PROJECT_VIEW (vtg_project_view_get_type ())
#define VTG_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectView))
#define VTG_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))
#define VTG_IS_PROJECT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_VIEW))
#define VTG_IS_PROJECT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_VIEW))
#define VTG_PROJECT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_VIEW, VtgProjectViewClass))

typedef struct _VtgProjectView VtgProjectView;
typedef struct _VtgProjectViewClass VtgProjectViewClass;

#define VTG_TYPE_PROJECT_MANAGER (vtg_project_manager_get_type ())
#define VTG_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManager))
#define VTG_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))
#define VTG_IS_PROJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VTG_TYPE_PROJECT_MANAGER))
#define VTG_IS_PROJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VTG_TYPE_PROJECT_MANAGER))
#define VTG_PROJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VTG_TYPE_PROJECT_MANAGER, VtgProjectManagerClass))

typedef struct _VtgProjectManager VtgProjectManager;
typedef struct _VtgProjectManagerClass VtgProjectManagerClass;
typedef struct _VtgProjectManagerPrivate VtgProjectManagerPrivate;

#define VTG_TYPE_VCS_TYPES (vtg_vcs_types_get_type ())
#define _afrodite_source_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_item_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _afrodite_result_item_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_result_item_unref (var), NULL)))
#define _afrodite_data_type_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_data_type_unref (var), NULL)))
#define _afrodite_query_result_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_query_result_unref (var), NULL)))
#define _afrodite_query_options_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_query_options_unref (var), NULL)))
#define _afrodite_code_dom_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_code_dom_unref (var), NULL)))
#define _afrodite_source_file_unref0(var) ((var == NULL) ? NULL : (var = (afrodite_source_file_unref (var), NULL)))

struct _VtgSymbolCompletionProvider {
	GObject parent_instance;
	VtgSymbolCompletionProviderPrivate * priv;
};

struct _VtgSymbolCompletionProviderClass {
	GObjectClass parent_class;
};

struct _VtgSymbolCompletionProviderPrivate {
	GdkPixbuf* _icon;
	gint _priority;
	GList* _proposals;
	guint _timeout_id;
	guint _idle_id;
	gint _prealloc_index;
	gboolean _cache_building;
	gboolean _filter;
	guint _sb_msg_id;
	guint _sb_context_id;
	GtkSourceCompletionInfo* _calltip_window;
	GtkLabel* _calltip_window_label;
	VtgSymbolCompletion* _symbol_completion;
	AfroditeCompletionEngine* _completion;
	gunichar* _reparse_chars;
	gint _reparse_chars_length1;
	gint __reparse_chars_size_;
	gboolean _doc_changed;
	gint _last_line;
};

typedef enum  {
	VTG_VCS_TYPES_NONE,
	VTG_VCS_TYPES_GIT,
	VTG_VCS_TYPES_BZR,
	VTG_VCS_TYPES_SVN
} VtgVcsTypes;

struct _VtgProjectManager {
	GObject parent_instance;
	VtgProjectManagerPrivate * priv;
	gchar* filename;
	gboolean is_default;
	ValaList* exec_targets;
	ValaList* all_vala_sources;
	VtgVcsTypes vcs_type;
	gchar* changelog_uri;
};

struct _VtgProjectManagerClass {
	GObjectClass parent_class;
};


static gpointer vtg_symbol_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface* vtg_symbol_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static GType vtg_symbol_completion_provider_type_id = 0;

GType vtg_symbol_completion_provider_get_type (void) G_GNUC_CONST;
GType vtg_symbol_completion_provider_register_type (GTypeModule * module);
GType vtg_symbol_completion_get_type (void) G_GNUC_CONST;
GType vtg_symbol_completion_register_type (GTypeModule * module);
#define VTG_SYMBOL_COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, VtgSymbolCompletionProviderPrivate))
enum  {
	VTG_SYMBOL_COMPLETION_PROVIDER_DUMMY_PROPERTY
};
GeditView* vtg_symbol_completion_get_view (VtgSymbolCompletion* self);
static gboolean vtg_symbol_completion_provider_on_view_key_press (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventKey* evt);
static gboolean _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean vtg_symbol_completion_provider_on_view_focus_out (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventFocus* event);
static gboolean _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void vtg_symbol_completion_provider_on_completion_engine_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec);
static void _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void vtg_symbol_completion_provider_on_cursor_position_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec);
static void _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void vtg_symbol_completion_provider_on_document_saved (GeditDocument* doc, void* arg1, VtgSymbolCompletionProvider* self);
GType vtg_plugin_instance_get_type (void) G_GNUC_CONST;
GType vtg_plugin_instance_register_type (GTypeModule * module);
VtgPluginInstance* vtg_symbol_completion_get_plugin_instance (VtgSymbolCompletion* self);
GeditWindow* vtg_plugin_instance_get_window (VtgPluginInstance* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
VtgSymbolCompletionProvider* vtg_symbol_completion_provider_new (VtgSymbolCompletion* symbol_completion);
VtgSymbolCompletionProvider* vtg_symbol_completion_provider_construct (GType object_type, VtgSymbolCompletion* symbol_completion);
static void vtg_symbol_completion_provider_on_completion_window_hide (VtgSymbolCompletionProvider* self, GtkSourceCompletion* sender);
static void _vtg_symbol_completion_provider_on_completion_window_hide_gtk_source_completion_show (GtkSourceCompletion* _sender, gpointer self);
AfroditeCompletionEngine* vtg_symbol_completion_get_completion_engine (VtgSymbolCompletion* self);
static gint vtg_symbol_completion_provider_get_current_line (VtgSymbolCompletionProvider* self, GeditDocument* doc);
static gchar* vtg_symbol_completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static gint vtg_symbol_completion_provider_real_get_priority (GtkSourceCompletionProvider* base);
static gboolean vtg_symbol_completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
gboolean vtg_utils_is_inside_comment_or_literal (GtkSourceBuffer* src, GtkTextIter* pos);
void vtg_utils_trace (const gchar* format, ...);
static void vtg_symbol_completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
void vtg_parser_utils_parse_line (const gchar* line, gchar** token, gboolean* is_assignment, gboolean* is_creation, gboolean* is_declaration);
static void vtg_symbol_completion_provider_lookup_visible_symbols_in_scope (VtgSymbolCompletionProvider* self, const gchar* word, AfroditeCompareMode mode);
static void vtg_symbol_completion_provider_complete_current_word (VtgSymbolCompletionProvider* self);
gboolean vtg_string_utils_is_null_or_empty (const gchar* data);
static GdkPixbuf* vtg_symbol_completion_provider_real_get_icon (GtkSourceCompletionProvider* base);
static gboolean vtg_symbol_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static GtkSourceCompletionActivation vtg_symbol_completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static GtkWidget* vtg_symbol_completion_provider_real_get_info_widget (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal);
static gint vtg_symbol_completion_provider_real_get_interactive_delay (GtkSourceCompletionProvider* base);
static gboolean vtg_symbol_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static void vtg_symbol_completion_provider_real_update_info (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkSourceCompletionInfo* info);
static void vtg_symbol_completion_provider_hide_calltip (VtgSymbolCompletionProvider* self);
static gboolean vtg_symbol_completion_provider_parse (VtgSymbolCompletionProvider* self);
static void vtg_symbol_completion_provider_get_current_line_and_column (VtgSymbolCompletionProvider* self, gint* line, gint* column);
static void vtg_symbol_completion_provider_show_calltip (VtgSymbolCompletionProvider* self);
static void vtg_symbol_completion_provider_idle_parse (VtgSymbolCompletionProvider* self);
AfroditeSymbol* vtg_symbol_completion_provider_get_current_symbol_item (VtgSymbolCompletionProvider* self);
static void vtg_symbol_completion_provider_show_calltip_info (VtgSymbolCompletionProvider* self, const gchar* markup_text);
static void vtg_symbol_completion_provider_initialize_calltip_window (VtgSymbolCompletionProvider* self);
static gboolean _vtg_symbol_completion_provider_parse_gsource_func (gpointer self);
GType vtg_project_view_get_type (void) G_GNUC_CONST;
GType vtg_project_view_register_type (GTypeModule * module);
VtgProjectView* vtg_plugin_instance_get_project_view (VtgPluginInstance* self);
GType vtg_project_manager_get_type (void) G_GNUC_CONST;
GType vtg_project_manager_register_type (GTypeModule * module);
VtgProjectManager* vtg_project_view_get_current_project (VtgProjectView* self);
GType vtg_vcs_types_get_type (void) G_GNUC_CONST;
static gint vtg_symbol_completion_provider_autoadd_packages (VtgSymbolCompletionProvider* self, GeditDocument* doc, VtgProjectManager* project_manager);
VbfProject* vtg_project_manager_get_project (VtgProjectManager* self);
gchar* vtg_utils_get_document_name (GeditDocument* doc);
AfroditeSourceType vtg_utils_get_source_type (GeditDocument* doc);
GRegex* vtg_language_support_get_using_regex (GeditDocument* doc, GError** error);
static gboolean vtg_symbol_completion_provider_proposal_list_contains_name (VtgSymbolCompletionProvider* self, const gchar* name);
static void vtg_symbol_completion_provider_append_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, ValaList* symbols, gboolean include_private_symbols);
GdkPixbuf* vtg_utils_get_icon_for_type_name (AfroditeMemberType type);
static gint vtg_symbol_completion_provider_proposal_sort (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b);
static gint _vtg_symbol_completion_provider_proposal_sort_gcompare_func (gconstpointer a, gconstpointer b);
static void vtg_symbol_completion_provider_transform_result (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeQueryResult* _result_);
static void vtg_symbol_completion_provider_append_base_type_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeSymbol* symbol, ValaList* visited_interfaces);
const gchar* afrodite_member_type_to_string (AfroditeMemberType self);
static gchar* vtg_symbol_completion_provider_get_current_line_text (VtgSymbolCompletionProvider* self, gboolean align_to_right_word);
AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_containing_cursor (VtgSymbolCompletionProvider* self);
gboolean vtg_utils_is_vala_keyword (const gchar* word);
static AfroditeQueryOptions* vtg_symbol_completion_provider_get_options_for_line (VtgSymbolCompletionProvider* self, const gchar* line, gboolean is_assignment, gboolean is_creation);
static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeCodeDom* codedom, const gchar* word, const gchar* whole_line, gint line, gint column);
static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_type_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeCodeDom* codedom, const gchar* word, const gchar* whole_line, gint line, gint column);
static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_children (VtgSymbolCompletionProvider* self, const gchar* symbol_name, AfroditeSymbol* parent);
static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (VtgSymbolCompletionProvider* self, const gchar* symbol_name, AfroditeSymbol* parent);
static gboolean vtg_symbol_completion_provider_on_hide_calltip_timeout (VtgSymbolCompletionProvider* self);
static gboolean _vtg_symbol_completion_provider_on_hide_calltip_timeout_gsource_func (gpointer self);
static void vtg_symbol_completion_provider_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_on_view_key_press (self, _sender, event);
	return result;
}


static gboolean _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_on_view_focus_out (self, _sender, event);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vtg_symbol_completion_provider_on_completion_engine_changed (self, _sender, pspec);
}


static void _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	vtg_symbol_completion_provider_on_cursor_position_changed (self, _sender, pspec);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _vtg_symbol_completion_provider_on_completion_window_hide_gtk_source_completion_show (GtkSourceCompletion* _sender, gpointer self) {
	vtg_symbol_completion_provider_on_completion_window_hide (self, _sender);
}


VtgSymbolCompletionProvider* vtg_symbol_completion_provider_construct (GType object_type, VtgSymbolCompletion* symbol_completion) {
	VtgSymbolCompletionProvider * self = NULL;
	GeditView* _tmp0_ = NULL;
	GeditView* _tmp1_ = NULL;
	GeditView* _tmp2_ = NULL;
	GtkSourceCompletion* _tmp3_ = NULL;
	GeditView* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GeditDocument* _tmp6_;
	GeditDocument* doc;
	GdkPixbuf* _tmp7_ = NULL;
	GdkPixbuf* _tmp8_;
	VtgPluginInstance* _tmp9_ = NULL;
	GeditWindow* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GeditStatusbar* _tmp12_;
	GeditStatusbar* status_bar;
	guint _tmp13_;
	AfroditeCompletionEngine* _tmp14_ = NULL;
	gint _tmp15_;
	g_return_val_if_fail (symbol_completion != NULL, NULL);
	self = (VtgSymbolCompletionProvider*) g_object_new (object_type, NULL);
	self->priv->_symbol_completion = symbol_completion;
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	g_signal_connect_object ((GtkWidget*) _tmp0_, "key-press-event", (GCallback) _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event, self, 0);
	_tmp1_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	g_signal_connect_object ((GtkWidget*) _tmp1_, "focus-out-event", (GCallback) _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp2_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp3_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp2_);
	g_signal_connect_object (_tmp3_, "show", (GCallback) _vtg_symbol_completion_provider_on_completion_window_hide_gtk_source_completion_show, self, 0);
	_tmp4_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp4_);
	_tmp6_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp5_));
	doc = _tmp6_;
	g_signal_connect_object ((GObject*) doc, "notify::cursor-position", (GCallback) _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify, self, 0);
	g_signal_connect (doc, "saved", (GCallback) vtg_symbol_completion_provider_on_document_saved, self);
	_tmp7_ = gtk_source_completion_provider_get_icon ((GtkSourceCompletionProvider*) self);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp8_;
	_tmp9_ = vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion);
	_tmp10_ = vtg_plugin_instance_get_window (_tmp9_);
	_tmp11_ = gedit_window_get_statusbar (_tmp10_);
	_tmp12_ = _g_object_ref0 (GEDIT_STATUSBAR (_tmp11_));
	status_bar = _tmp12_;
	_tmp13_ = gtk_statusbar_get_context_id ((GtkStatusbar*) status_bar, "symbol status");
	self->priv->_sb_context_id = _tmp13_;
	self->priv->_cache_building = TRUE;
	g_signal_connect_object ((GObject*) self->priv->_symbol_completion, "notify::completion-engine", (GCallback) _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify, self, 0);
	_tmp14_ = vtg_symbol_completion_get_completion_engine (self->priv->_symbol_completion);
	self->priv->_completion = _tmp14_;
	_tmp15_ = vtg_symbol_completion_provider_get_current_line (self, NULL);
	self->priv->_last_line = _tmp15_;
	_g_object_unref0 (status_bar);
	_g_object_unref0 (doc);
	return self;
}


VtgSymbolCompletionProvider* vtg_symbol_completion_provider_new (VtgSymbolCompletion* symbol_completion) {
	return vtg_symbol_completion_provider_construct (VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, symbol_completion);
}


static gchar* vtg_symbol_completion_provider_real_get_name (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (VtgSymbolCompletionProvider*) base;
	_tmp0_ = _ ("Vala Toys Completion Provider");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint vtg_symbol_completion_provider_real_get_priority (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	gint result = 0;
	self = (VtgSymbolCompletionProvider*) base;
	result = self->priv->_priority;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}


static gboolean vtg_symbol_completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	VtgSymbolCompletionProvider * self;
	gboolean result = FALSE;
	GeditView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* src;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextMark* mark;
	GtkTextIter start = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter pos;
	gunichar _tmp5_;
	gunichar ch;
	gboolean _tmp6_;
	gboolean _result_;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _g_object_ref0 (GTK_SOURCE_BUFFER (_tmp1_));
	src = _tmp2_;
	_tmp3_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) src);
	mark = GTK_TEXT_MARK (_tmp3_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) src, &_tmp4_, mark);
	start = _tmp4_;
	pos = start;
	_tmp5_ = gtk_text_iter_get_char (&start);
	ch = _tmp5_;
	_tmp6_ = vtg_utils_is_inside_comment_or_literal (src, &pos);
	_result_ = !_tmp6_;
	if (_result_) {
		gint _tmp7_;
		gint line;
		gboolean _tmp8_;
		pos = start;
		_tmp7_ = gtk_text_iter_get_line (&pos);
		line = _tmp7_;
		_tmp8_ = gtk_text_iter_backward_char (&pos);
		if (_tmp8_) {
			gint _tmp9_;
			_tmp9_ = gtk_text_iter_get_line (&pos);
			if (_tmp9_ == line) {
				gunichar _tmp10_;
				gunichar prev_ch;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				_tmp10_ = gtk_text_iter_get_char (&pos);
				prev_ch = _tmp10_;
				if (prev_ch == '(') {
					_tmp22_ = TRUE;
				} else {
					_tmp22_ = ch == '(';
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					_tmp21_ = prev_ch == '[';
				}
				if (_tmp21_) {
					_tmp20_ = TRUE;
				} else {
					_tmp20_ = ch == '[';
				}
				if (_tmp20_) {
					_tmp19_ = TRUE;
				} else {
					_tmp19_ = prev_ch == ' ';
				}
				if (_tmp19_) {
					_tmp18_ = TRUE;
				} else {
					_tmp18_ = prev_ch == '\t';
				}
				if (_tmp18_) {
					_tmp17_ = TRUE;
				} else {
					_tmp17_ = prev_ch == ')';
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					_tmp16_ = prev_ch == ']';
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					_tmp15_ = prev_ch == ';';
				}
				if (_tmp15_) {
					_tmp14_ = TRUE;
				} else {
					_tmp14_ = prev_ch == '?';
				}
				if (_tmp14_) {
					_tmp13_ = TRUE;
				} else {
					_tmp13_ = prev_ch == '/';
				}
				if (_tmp13_) {
					_tmp12_ = TRUE;
				} else {
					_tmp12_ = ch == '/';
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = prev_ch == ',';
				}
				if (_tmp11_) {
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
					_result_ = FALSE;
					_tmp23_ = g_unichar_to_string (ch);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_unichar_to_string (prev_ch);
					_tmp26_ = _tmp25_;
					vtg_utils_trace ("vtgsymbolcompletionprovider.vala:149: not match current char: '%s', pr" \
"evious: '%s'", _tmp24_, _tmp26_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
				} else {
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_;
					_tmp27_ = g_unichar_to_string (ch);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_unichar_to_string (prev_ch);
					_tmp30_ = _tmp29_;
					vtg_utils_trace ("vtgsymbolcompletionprovider.vala:151: match current char: '%s', previo" \
"us: '%s'", _tmp28_, _tmp30_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
				}
			}
		}
	}
	result = _result_;
	_g_object_unref0 (src);
	return result;
}


static void vtg_symbol_completion_provider_on_completion_window_hide (VtgSymbolCompletionProvider* self, GtkSourceCompletion* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	self->priv->_filter = FALSE;
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void vtg_symbol_completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	VtgSymbolCompletionProvider * self;
	GtkSourceCompletion* _tmp0_ = NULL;
	GtkSourceCompletion* _tmp1_;
	GtkSourceView* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextMark* _tmp5_;
	GtkTextMark* mark;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkSourceCompletion* _tmp6_ = NULL;
	GtkSourceCompletion* _tmp7_;
	GtkSourceView* _tmp8_ = NULL;
	GtkTextBuffer* _tmp9_ = NULL;
	GtkTextIter _tmp10_ = {0};
	GtkSourceCompletion* _tmp11_ = NULL;
	GtkSourceCompletion* _tmp12_;
	GtkSourceView* _tmp13_ = NULL;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextIter _tmp15_ = {0};
	gboolean _tmp16_;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* text;
	gunichar prev_ch;
	gboolean _tmp19_;
	gboolean symbols_in_scope_mode;
	gchar* _tmp21_;
	gchar* word;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:167: populate");
	g_object_get (context, "completion", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_source_completion_get_view (_tmp1_);
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = gtk_text_buffer_get_insert (_tmp3_);
	_tmp5_ = GTK_TEXT_MARK (_tmp4_);
	_g_object_unref0 (_tmp1_);
	mark = _tmp5_;
	g_object_get (context, "completion", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = gtk_source_completion_get_view (_tmp7_);
	_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp8_);
	gtk_text_buffer_get_iter_at_mark (_tmp9_, &_tmp10_, mark);
	start = _tmp10_;
	_g_object_unref0 (_tmp7_);
	g_object_get (context, "completion", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = gtk_source_completion_get_view (_tmp12_);
	_tmp14_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp13_);
	gtk_text_buffer_get_iter_at_mark (_tmp14_, &_tmp15_, mark);
	end = _tmp15_;
	_g_object_unref0 (_tmp12_);
	_tmp16_ = gtk_text_iter_starts_line (&start);
	if (!_tmp16_) {
		gtk_text_iter_set_line_offset (&start, 0);
	}
	_tmp17_ = gtk_text_iter_get_text (&start, &end);
	_tmp18_ = g_strdup (_tmp17_);
	text = _tmp18_;
	prev_ch = (gunichar) 'a';
	_tmp19_ = gtk_text_iter_backward_char (&end);
	if (_tmp19_) {
		gunichar _tmp20_;
		_tmp20_ = gtk_text_iter_get_char (&end);
		prev_ch = _tmp20_;
		gtk_text_iter_forward_char (&end);
	}
	symbols_in_scope_mode = FALSE;
	_tmp21_ = g_strdup ("");
	word = _tmp21_;
	self->priv->_filter = TRUE;
	_tmp23_ = g_str_has_suffix (text, ".");
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp24_ = FALSE;
		if (prev_ch != '_') {
			gboolean _tmp25_;
			_tmp25_ = g_unichar_isalnum (prev_ch);
			_tmp24_ = !_tmp25_;
		} else {
			_tmp24_ = FALSE;
		}
		_tmp22_ = _tmp24_;
	}
	if (_tmp22_) {
		self->priv->_filter = FALSE;
	} else {
		gboolean dummy = FALSE;
		gboolean is_declaration = FALSE;
		gchar* _tmp26_ = NULL;
		gboolean _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		vtg_parser_utils_parse_line (text, &_tmp26_, &_tmp27_, &_tmp28_, &_tmp29_);
		_g_free0 (word);
		word = _tmp26_;
		dummy = _tmp27_;
		dummy = _tmp28_;
		is_declaration = _tmp29_;
		if (!is_declaration) {
			_tmp31_ = word != NULL;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gint _tmp32_;
			_tmp32_ = string_last_index_of (word, ".", 0);
			_tmp30_ = _tmp32_ == (-1);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			symbols_in_scope_mode = TRUE;
			self->priv->_filter = FALSE;
		}
	}
	if (!self->priv->_filter) {
		__g_list_free__g_object_unref0_0 (self->priv->_proposals);
		self->priv->_proposals = NULL;
		if (symbols_in_scope_mode) {
			if (word != NULL) {
				vtg_symbol_completion_provider_lookup_visible_symbols_in_scope (self, word, AFRODITE_COMPARE_MODE_START_WITH);
			}
		} else {
			vtg_symbol_completion_provider_complete_current_word (self);
		}
		gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, self->priv->_proposals, TRUE);
	} else {
		if (word != NULL) {
			gchar** _tmp33_;
			gchar** _tmp34_ = NULL;
			gchar** tmp;
			gint tmp_length1;
			gint _tmp_size_;
			gchar* _tmp35_;
			gchar* last_part;
			gboolean _tmp37_;
			_tmp34_ = _tmp33_ = g_strsplit (word, ".", 0);
			tmp = _tmp34_;
			tmp_length1 = _vala_array_length (_tmp33_);
			_tmp_size_ = _vala_array_length (_tmp33_);
			_tmp35_ = g_strdup ("");
			last_part = _tmp35_;
			if (tmp_length1 > 0) {
				gchar* _tmp36_;
				_tmp36_ = g_strdup (tmp[tmp_length1 - 1]);
				_g_free0 (last_part);
				last_part = _tmp36_;
			}
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:217: filtering with: '%s' - '%s'", word, last_part);
			_tmp37_ = vtg_string_utils_is_null_or_empty (last_part);
			if (!_tmp37_) {
				GList* filtered_proposals;
				gboolean _tmp44_ = FALSE;
				guint _tmp45_;
				filtered_proposals = NULL;
				{
					GList* proposal_collection;
					GList* proposal_it;
					proposal_collection = self->priv->_proposals;
					for (proposal_it = proposal_collection; proposal_it != NULL; proposal_it = proposal_it->next) {
						GtkSourceCompletionItem* _tmp38_;
						GtkSourceCompletionItem* proposal;
						_tmp38_ = _g_object_ref0 ((GtkSourceCompletionItem*) proposal_it->data);
						proposal = _tmp38_;
						{
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_;
							gboolean _tmp41_;
							gboolean _tmp42_;
							_tmp39_ = gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) proposal);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_str_has_prefix (_tmp40_, last_part);
							_tmp42_ = _tmp41_;
							_g_free0 (_tmp40_);
							if (_tmp42_) {
								GtkSourceCompletionItem* _tmp43_;
								_tmp43_ = _g_object_ref0 (proposal);
								filtered_proposals = g_list_append (filtered_proposals, _tmp43_);
							}
							_g_object_unref0 (proposal);
						}
					}
				}
				_tmp45_ = g_list_length (self->priv->_proposals);
				if (_tmp45_ > 0) {
					guint _tmp46_;
					_tmp46_ = g_list_length (filtered_proposals);
					_tmp44_ = _tmp46_ == 0;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					const gchar* _tmp47_ = NULL;
					GtkSourceCompletionItem* _tmp48_ = NULL;
					GtkSourceCompletionItem* dummy_proposal;
					GtkSourceCompletionItem* _tmp49_;
					_tmp47_ = _ ("No matching proposal");
					_tmp48_ = gtk_source_completion_item_new (_tmp47_, "", NULL, NULL);
					dummy_proposal = _tmp48_;
					_tmp49_ = _g_object_ref0 (dummy_proposal);
					filtered_proposals = g_list_append (filtered_proposals, _tmp49_);
					_g_object_unref0 (dummy_proposal);
				}
				gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, filtered_proposals, TRUE);
				__g_list_free__g_object_unref0_0 (filtered_proposals);
			} else {
				gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, self->priv->_proposals, TRUE);
			}
			_g_free0 (last_part);
			tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
		}
	}
	_g_free0 (word);
	_g_free0 (text);
}


static GdkPixbuf* vtg_symbol_completion_provider_real_get_icon (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	GdkPixbuf* result = NULL;
	GError * _inner_error_ = NULL;
	self = (VtgSymbolCompletionProvider*) base;
	if (self->priv->_icon == NULL) {
		GtkIconTheme* _tmp0_ = NULL;
		GtkIconTheme* _tmp1_;
		GtkIconTheme* theme;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		_tmp0_ = gtk_icon_theme_get_default ();
		_tmp1_ = _g_object_ref0 (_tmp0_);
		theme = _tmp1_;
		_tmp2_ = gtk_icon_theme_load_icon (theme, GTK_STOCK_DIALOG_INFO, 16, 0, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (theme);
			goto __catch4_g_error;
		}
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp3_;
		_g_object_unref0 (theme);
		goto __finally4;
		__catch4_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("vtgsymbolcompletionprovider.vala:247: error: %s", err->message);
			_g_error_free0 (err);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = self->priv->_icon;
	return result;
}


static gboolean vtg_symbol_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	VtgSymbolCompletionProvider * self;
	gboolean result = FALSE;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	self->priv->_filter = FALSE;
	result = FALSE;
	return result;
}


static GtkSourceCompletionActivation vtg_symbol_completion_provider_real_get_activation (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	GtkSourceCompletionActivation result = 0;
	self = (VtgSymbolCompletionProvider*) base;
	result = GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE | GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}


static GtkWidget* vtg_symbol_completion_provider_real_get_info_widget (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal) {
	VtgSymbolCompletionProvider * self;
	GtkWidget* result = NULL;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, NULL);
	result = GTK_WIDGET (NULL);
	return result;
}


static gint vtg_symbol_completion_provider_real_get_interactive_delay (GtkSourceCompletionProvider* base) {
	VtgSymbolCompletionProvider * self;
	gint result = 0;
	self = (VtgSymbolCompletionProvider*) base;
	result = 10;
	return result;
}


static gboolean vtg_symbol_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	VtgSymbolCompletionProvider * self;
	gboolean result = FALSE;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	result = FALSE;
	return result;
}


static void vtg_symbol_completion_provider_real_update_info (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkSourceCompletionInfo* info) {
	VtgSymbolCompletionProvider * self;
	self = (VtgSymbolCompletionProvider*) base;
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (info != NULL);
}


static gboolean vtg_symbol_completion_provider_on_view_focus_out (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventFocus* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	vtg_symbol_completion_provider_hide_calltip (self);
	result = FALSE;
	return result;
}


static void vtg_symbol_completion_provider_on_document_saved (GeditDocument* doc, void* arg1, VtgSymbolCompletionProvider* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	vtg_symbol_completion_provider_parse (self);
}


static gint vtg_symbol_completion_provider_get_current_line (VtgSymbolCompletionProvider* self, GeditDocument* doc) {
	gint result = 0;
	gint line = 0;
	gint col = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	vtg_symbol_completion_provider_get_current_line_and_column (self, &_tmp0_, &_tmp1_);
	line = _tmp0_;
	col = _tmp1_;
	result = line;
	return result;
}


static void vtg_symbol_completion_provider_on_cursor_position_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec) {
	gint _tmp0_;
	gint curr_line;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = vtg_symbol_completion_provider_get_current_line (self, NULL);
	curr_line = _tmp0_;
	if (self->priv->_doc_changed) {
		_tmp1_ = self->priv->_last_line != curr_line;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->_last_line = curr_line;
		vtg_symbol_completion_provider_parse (self);
	}
}


static void vtg_symbol_completion_provider_on_completion_engine_changed (VtgSymbolCompletionProvider* self, GObject* sender, GParamSpec* pspec) {
	AfroditeCompletionEngine* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = vtg_symbol_completion_get_completion_engine (self->priv->_symbol_completion);
	self->priv->_completion = _tmp0_;
}


static gboolean vtg_symbol_completion_provider_on_view_key_press (VtgSymbolCompletionProvider* self, GtkWidget* sender, GdkEventKey* evt) {
	gboolean result = FALSE;
	guint32 _tmp0_;
	gunichar ch;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = gdk_keyval_to_unicode ((*evt).keyval);
	ch = (gunichar) _tmp0_;
	if (ch == '(') {
		vtg_symbol_completion_provider_show_calltip (self);
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if ((*evt).keyval == GDK_KEY_Escape) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = ch == ')';
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = ch == ';';
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = ch == '{';
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			if ((*evt).keyval == GDK_KEY_Return) {
				_tmp5_ = ((*evt).state & GDK_SHIFT_MASK) != 0;
			} else {
				_tmp5_ = FALSE;
			}
			_tmp1_ = _tmp5_;
		}
		if (_tmp1_) {
			vtg_symbol_completion_provider_hide_calltip (self);
		}
	}
	if (!self->priv->_doc_changed) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		_tmp8_ = g_unichar_isalnum (ch);
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			gboolean _tmp9_;
			_tmp9_ = g_unichar_isprint (ch);
			_tmp7_ = _tmp9_;
		}
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		self->priv->_doc_changed = TRUE;
	}
	{
		gunichar* reparse_char_collection;
		int reparse_char_collection_length1;
		int reparse_char_it;
		reparse_char_collection = self->priv->_reparse_chars;
		reparse_char_collection_length1 = self->priv->_reparse_chars_length1;
		for (reparse_char_it = 0; reparse_char_it < self->priv->_reparse_chars_length1; reparse_char_it = reparse_char_it + 1) {
			gunichar reparse_char;
			reparse_char = reparse_char_collection[reparse_char_it];
			{
				gboolean _tmp10_ = FALSE;
				if (ch == reparse_char) {
					_tmp10_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					if (reparse_char == '\n') {
						_tmp11_ = (*evt).keyval == GDK_KEY_Return;
					} else {
						_tmp11_ = FALSE;
					}
					_tmp10_ = _tmp11_;
				}
				if (_tmp10_) {
					vtg_symbol_completion_provider_idle_parse (self);
					break;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void vtg_symbol_completion_provider_show_calltip (VtgSymbolCompletionProvider* self) {
	AfroditeSymbol* _tmp0_ = NULL;
	AfroditeSymbol* completion_result;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_symbol_completion_provider_get_current_symbol_item (self);
	completion_result = _tmp0_;
	if (completion_result != NULL) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = afrodite_symbol_get_info (completion_result);
		_tmp2_ = _tmp1_;
		vtg_symbol_completion_provider_show_calltip_info (self, _tmp2_);
		_g_free0 (_tmp2_);
	}
	_g_object_unref0 (completion_result);
}


static void vtg_symbol_completion_provider_show_calltip_info (VtgSymbolCompletionProvider* self, const gchar* markup_text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (markup_text != NULL);
	if (self->priv->_calltip_window == NULL) {
		vtg_symbol_completion_provider_initialize_calltip_window (self);
	}
	if (markup_text != NULL) {
		GeditView* _tmp0_ = NULL;
		gtk_label_set_markup (self->priv->_calltip_window_label, markup_text);
		_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
		gtk_source_completion_info_move_to_iter (self->priv->_calltip_window, (GtkTextView*) _tmp0_, NULL);
		gtk_widget_show_all ((GtkWidget*) self->priv->_calltip_window);
		gtk_widget_show ((GtkWidget*) self->priv->_calltip_window);
	}
}


static void vtg_symbol_completion_provider_hide_calltip (VtgSymbolCompletionProvider* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_calltip_window == NULL) {
		return;
	}
	gtk_widget_hide ((GtkWidget*) self->priv->_calltip_window);
}


static void vtg_symbol_completion_provider_initialize_calltip_window (VtgSymbolCompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_ = NULL;
	VtgPluginInstance* _tmp1_ = NULL;
	GeditWindow* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_completion_info_new ();
	_g_object_unref0 (self->priv->_calltip_window);
	self->priv->_calltip_window = g_object_ref_sink (_tmp0_);
	_tmp1_ = vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion);
	_tmp2_ = vtg_plugin_instance_get_window (_tmp1_);
	gtk_window_set_transient_for ((GtkWindow*) self->priv->_calltip_window, (GtkWindow*) _tmp2_);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (self->priv->_calltip_window_label);
	self->priv->_calltip_window_label = g_object_ref_sink (_tmp3_);
	gtk_source_completion_info_set_widget (self->priv->_calltip_window, (GtkWidget*) self->priv->_calltip_window_label);
}


static gboolean _vtg_symbol_completion_provider_parse_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_parse (self);
	return result;
}


static void vtg_symbol_completion_provider_idle_parse (VtgSymbolCompletionProvider* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_idle_id == 0) {
		guint _tmp0_;
		_tmp0_ = g_idle_add_full (G_PRIORITY_LOW, _vtg_symbol_completion_provider_parse_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_idle_id = _tmp0_;
	}
}


static gboolean vtg_symbol_completion_provider_parse (VtgSymbolCompletionProvider* self) {
	gboolean result = FALSE;
	GeditView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GeditDocument* _tmp2_;
	GeditDocument* doc;
	VtgPluginInstance* _tmp3_ = NULL;
	VtgProjectView* _tmp4_ = NULL;
	VtgProjectManager* _tmp5_ = NULL;
	VtgProjectManager* _tmp6_;
	VtgProjectManager* current_project;
	gchar* _tmp9_ = NULL;
	gchar* path;
	AfroditeSourceType _tmp10_;
	AfroditeSourceType source_type;
	AfroditeSourceItem* _tmp11_ = NULL;
	AfroditeSourceItem* source;
	gchar* _tmp12_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp1_));
	doc = _tmp2_;
	_tmp3_ = vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion);
	_tmp4_ = vtg_plugin_instance_get_project_view (_tmp3_);
	_tmp5_ = vtg_project_view_get_current_project (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	current_project = _tmp6_;
	if (current_project->is_default) {
		gint _tmp7_;
		_tmp7_ = vtg_symbol_completion_provider_autoadd_packages (self, doc, current_project);
		if (_tmp7_ > 0) {
			VbfProject* _tmp8_ = NULL;
			_tmp8_ = vtg_project_manager_get_project (current_project);
			vbf_project_update (_tmp8_);
		}
	}
	_tmp9_ = vtg_utils_get_document_name (doc);
	path = _tmp9_;
	_tmp10_ = vtg_utils_get_source_type (doc);
	source_type = _tmp10_;
	_tmp11_ = afrodite_source_item_new (path, source_type);
	source = _tmp11_;
	g_object_get ((GtkTextBuffer*) doc, "text", &_tmp12_, NULL);
	_g_free0 (source->content);
	source->content = _tmp12_;
	afrodite_completion_engine_queue_source (self->priv->_completion, source);
	self->priv->_doc_changed = FALSE;
	self->priv->_idle_id = (guint) 0;
	result = FALSE;
	_afrodite_source_item_unref0 (source);
	_g_free0 (path);
	_g_object_unref0 (current_project);
	_g_object_unref0 (doc);
	return result;
}


static gint vtg_symbol_completion_provider_autoadd_packages (VtgSymbolCompletionProvider* self, GeditDocument* doc, VtgProjectManager* project_manager) {
	gint result = 0;
	gint added_count;
	gchar* _tmp0_ = NULL;
	gchar* text;
	GRegex* _tmp1_ = NULL;
	GRegex* regex;
	GMatchInfo* match = NULL;
	GMatchInfo* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (doc != NULL, 0);
	g_return_val_if_fail (project_manager != NULL, 0);
	added_count = 0;
	g_object_get ((GtkTextBuffer*) doc, "text", &_tmp0_, NULL);
	text = _tmp0_;
	_tmp1_ = vtg_language_support_get_using_regex (doc, &_inner_error_);
	regex = _tmp1_;
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		goto __catch5_g_error;
	}
	g_regex_match (regex, text, G_REGEX_MATCH_NEWLINE_ANY, &_tmp2_);
	_g_match_info_free0 (match);
	match = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_;
		gchar* using_name;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gboolean _tmp6_;
		gchar* package_name;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp3_ = g_match_info_matches (match);
		if (!_tmp3_) {
			break;
		}
		using_name = NULL;
		_tmp4_ = g_match_info_fetch (match, 2);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strcmp0 (_tmp5_, "GLib") == 0;
		_g_free0 (_tmp5_);
		if (_tmp6_) {
			if (project_manager->is_default) {
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("gio");
				_g_free0 (using_name);
				using_name = _tmp7_;
			}
		} else {
			gchar* _tmp8_ = NULL;
			_tmp8_ = g_match_info_fetch (match, 2);
			_g_free0 (using_name);
			using_name = _tmp8_;
		}
		package_name = NULL;
		if (using_name != NULL) {
			gchar* _tmp9_ = NULL;
			_tmp9_ = vbf_utils_guess_package_vapi (using_name, NULL, 0);
			_g_free0 (package_name);
			package_name = _tmp9_;
		}
		_tmp10_ = g_match_info_fetch (match, 2);
		_tmp11_ = _tmp10_;
		vtg_utils_trace ("vtgsymbolcompletionprovider.vala:439: guessing name of using clause '%" \
"s' for package '%s': '%s'", _tmp11_, using_name, package_name);
		_g_free0 (_tmp11_);
		if (package_name != NULL) {
			VbfProject* _tmp12_ = NULL;
			VbfGroup* _tmp13_ = NULL;
			VbfGroup* group;
			VbfTarget* _tmp14_ = NULL;
			VbfTarget* target;
			gboolean _tmp15_;
			_tmp12_ = vtg_project_manager_get_project (project_manager);
			_tmp13_ = vbf_project_get_group (_tmp12_, "Sources");
			group = _tmp13_;
			_tmp14_ = vbf_group_get_target_for_id (group, "Default");
			target = _tmp14_;
			_tmp15_ = vbf_target_contains_package (target, package_name);
			if (!_tmp15_) {
				VbfPackage* _tmp16_ = NULL;
				VbfPackage* _tmp17_;
				_tmp16_ = vbf_package_new (package_name);
				_tmp17_ = _tmp16_;
				vbf_target_add_package (target, _tmp17_);
				_g_object_unref0 (_tmp17_);
				added_count++;
			}
			_g_object_unref0 (target);
			_g_object_unref0 (group);
		}
		g_match_info_next (match, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (package_name);
			_g_free0 (using_name);
			_g_match_info_free0 (match);
			_g_regex_unref0 (regex);
			_g_free0 (text);
			goto __catch5_g_error;
		}
		_g_free0 (package_name);
		_g_free0 (using_name);
	}
	_g_match_info_free0 (match);
	_g_regex_unref0 (regex);
	_g_free0 (text);
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vtgsymbolcompletionprovider.vala:453: error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = added_count;
	return result;
}


static gboolean vtg_symbol_completion_provider_proposal_list_contains_name (VtgSymbolCompletionProvider* self, const gchar* name) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		GList* proposal_collection;
		GList* proposal_it;
		proposal_collection = self->priv->_proposals;
		for (proposal_it = proposal_collection; proposal_it != NULL; proposal_it = proposal_it->next) {
			GtkSourceCompletionItem* _tmp0_;
			GtkSourceCompletionItem* proposal;
			_tmp0_ = _g_object_ref0 ((GtkSourceCompletionItem*) proposal_it->data);
			proposal = _tmp0_;
			{
				gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				gboolean _tmp3_;
				_tmp1_ = gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) proposal);
				_tmp2_ = _tmp1_;
				_tmp3_ = g_strcmp0 (_tmp2_, name) == 0;
				_g_free0 (_tmp2_);
				if (_tmp3_) {
					result = TRUE;
					_g_object_unref0 (proposal);
					return result;
				}
				_g_object_unref0 (proposal);
			}
		}
	}
	result = FALSE;
	return result;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gint _vtg_symbol_completion_provider_proposal_sort_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = vtg_symbol_completion_provider_proposal_sort (a, b);
	return result;
}


static void vtg_symbol_completion_provider_append_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, ValaList* symbols, gboolean include_private_symbols) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	{
		ValaList* _tmp0_;
		ValaList* _symbol_list;
		gint _tmp1_;
		gint _symbol_size;
		gint _symbol_index;
		_tmp0_ = _vala_iterable_ref0 (symbols);
		_symbol_list = _tmp0_;
		_tmp1_ = vala_collection_get_size ((ValaCollection*) _symbol_list);
		_symbol_size = _tmp1_;
		_symbol_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			AfroditeSymbol* symbol;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gchar* name = NULL;
			AfroditeMemberType _tmp10_;
			gboolean _tmp17_ = FALSE;
			_symbol_index = _symbol_index + 1;
			if (!(_symbol_index < _symbol_size)) {
				break;
			}
			_tmp2_ = vala_list_get (_symbol_list, _symbol_index);
			symbol = (AfroditeSymbol*) _tmp2_;
			if (!include_private_symbols) {
				AfroditeSymbolAccessibility _tmp6_;
				_tmp6_ = afrodite_symbol_get_access (symbol);
				_tmp5_ = _tmp6_ == AFRODITE_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				const gchar* _tmp7_ = NULL;
				_tmp7_ = afrodite_symbol_get_name (symbol);
				_tmp4_ = g_strcmp0 (_tmp7_, "new") == 0;
			}
			if (_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				gboolean _tmp8_ = FALSE;
				if (options != NULL) {
					gboolean _tmp9_;
					_tmp9_ = afrodite_symbol_check_options (symbol, options);
					_tmp8_ = !_tmp9_;
				} else {
					_tmp8_ = FALSE;
				}
				_tmp3_ = _tmp8_;
			}
			if (_tmp3_) {
				_g_object_unref0 (symbol);
				continue;
			}
			_tmp10_ = afrodite_symbol_get_member_type (symbol);
			if (_tmp10_ == AFRODITE_MEMBER_TYPE_CREATION_METHOD) {
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				_tmp11_ = afrodite_symbol_get_name (symbol);
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (name);
				name = _tmp12_;
			} else {
				const gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp16_;
				_tmp14_ = afrodite_symbol_get_display_name (symbol);
				if (_tmp14_ != NULL) {
					const gchar* _tmp15_ = NULL;
					_tmp15_ = afrodite_symbol_get_display_name (symbol);
					_tmp13_ = _tmp15_;
				} else {
					_tmp13_ = "<null>";
				}
				_tmp16_ = g_strdup (_tmp13_);
				_g_free0 (name);
				name = _tmp16_;
			}
			if (!symbol->overrides) {
				_tmp17_ = TRUE;
			} else {
				gboolean _tmp18_ = FALSE;
				if (symbol->overrides) {
					gboolean _tmp19_;
					_tmp19_ = vtg_symbol_completion_provider_proposal_list_contains_name (self, name);
					_tmp18_ = !_tmp19_;
				} else {
					_tmp18_ = FALSE;
				}
				_tmp17_ = _tmp18_;
			}
			if (_tmp17_) {
				GtkSourceCompletionItem* proposal = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gboolean _tmp23_;
				gchar* _tmp26_;
				gchar* info;
				AfroditeMemberType _tmp27_;
				GdkPixbuf* _tmp28_ = NULL;
				GdkPixbuf* icon;
				GtkSourceCompletionItem* _tmp29_ = NULL;
				GtkSourceCompletionItem* _tmp30_;
				_tmp21_ = afrodite_symbol_get_info (symbol);
				_tmp22_ = _tmp21_;
				_tmp23_ = _tmp22_ != NULL;
				_g_free0 (_tmp22_);
				if (_tmp23_) {
					gchar* _tmp24_ = NULL;
					_tmp24_ = afrodite_symbol_get_info (symbol);
					_g_free0 (_tmp20_);
					_tmp20_ = _tmp24_;
				} else {
					gchar* _tmp25_;
					_tmp25_ = g_strdup ("");
					_g_free0 (_tmp20_);
					_tmp20_ = _tmp25_;
				}
				_tmp26_ = g_strdup (_tmp20_);
				info = _tmp26_;
				_tmp27_ = afrodite_symbol_get_member_type (symbol);
				_tmp28_ = vtg_utils_get_icon_for_type_name (_tmp27_);
				icon = _tmp28_;
				_tmp29_ = gtk_source_completion_item_new (name, name, icon, info);
				_g_object_unref0 (proposal);
				proposal = _tmp29_;
				_tmp30_ = _g_object_ref0 (proposal);
				self->priv->_proposals = g_list_append (self->priv->_proposals, _tmp30_);
				_g_object_unref0 (icon);
				_g_free0 (info);
				_g_free0 (_tmp20_);
				_g_object_unref0 (proposal);
			}
			_g_free0 (name);
			_g_object_unref0 (symbol);
		}
		_vala_iterable_unref0 (_symbol_list);
	}
	self->priv->_proposals = g_list_sort (self->priv->_proposals, _vtg_symbol_completion_provider_proposal_sort_gcompare_func);
}


static gint vtg_symbol_completion_provider_proposal_sort (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) a);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_source_completion_proposal_get_label ((GtkSourceCompletionProposal*) b);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static void vtg_symbol_completion_provider_transform_result (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeQueryResult* _result_) {
	ValaArrayList* _tmp0_ = NULL;
	ValaArrayList* visited_interfaces;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->_prealloc_index = 0;
	__g_list_free__g_object_unref0_0 (self->priv->_proposals);
	self->priv->_proposals = NULL;
	_tmp0_ = vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	visited_interfaces = _tmp0_;
	if (_result_ != NULL) {
		gboolean _tmp2_;
		_tmp2_ = afrodite_query_result_get_is_empty (_result_);
		_tmp1_ = !_tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		afrodite_query_options_dump_settings (options);
		{
			ValaList* _tmp3_ = NULL;
			ValaList* _tmp4_;
			ValaList* _item_list;
			gint _tmp5_;
			gint _item_size;
			gint _item_index;
			_tmp3_ = afrodite_query_result_get_children (_result_);
			_tmp4_ = _vala_iterable_ref0 (_tmp3_);
			_item_list = _tmp4_;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _item_list);
			_item_size = _tmp5_;
			_item_index = -1;
			while (TRUE) {
				gpointer _tmp6_ = NULL;
				AfroditeResultItem* item;
				AfroditeSymbol* _tmp7_ = NULL;
				AfroditeSymbol* _tmp8_;
				AfroditeSymbol* symbol;
				gboolean _tmp9_ = FALSE;
				_item_index = _item_index + 1;
				if (!(_item_index < _item_size)) {
					break;
				}
				_tmp6_ = vala_list_get (_item_list, _item_index);
				item = (AfroditeResultItem*) _tmp6_;
				_tmp7_ = afrodite_result_item_get_symbol (item);
				_tmp8_ = _g_object_ref0 (_tmp7_);
				symbol = _tmp8_;
				if (options == NULL) {
					_tmp9_ = TRUE;
				} else {
					gboolean _tmp10_;
					_tmp10_ = afrodite_symbol_check_options (symbol, options);
					_tmp9_ = _tmp10_;
				}
				if (_tmp9_) {
					gboolean _tmp11_;
					_tmp11_ = afrodite_symbol_get_has_children (symbol);
					if (_tmp11_) {
						ValaList* _tmp12_ = NULL;
						_tmp12_ = afrodite_symbol_get_children (symbol);
						vtg_symbol_completion_provider_append_symbols (self, options, _tmp12_, TRUE);
					}
					vtg_symbol_completion_provider_append_base_type_symbols (self, options, symbol, (ValaList*) visited_interfaces);
				}
				_g_object_unref0 (symbol);
				_afrodite_result_item_unref0 (item);
			}
			_vala_iterable_unref0 (_item_list);
		}
	}
	_vala_iterable_unref0 (visited_interfaces);
}


static void vtg_symbol_completion_provider_append_base_type_symbols (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeSymbol* symbol, ValaList* visited_interfaces) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (visited_interfaces != NULL);
	_tmp1_ = afrodite_symbol_get_has_base_types (symbol);
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		AfroditeMemberType _tmp4_;
		_tmp4_ = afrodite_symbol_get_member_type (symbol);
		if (_tmp4_ == AFRODITE_MEMBER_TYPE_CLASS) {
			_tmp3_ = TRUE;
		} else {
			AfroditeMemberType _tmp5_;
			_tmp5_ = afrodite_symbol_get_member_type (symbol);
			_tmp3_ = _tmp5_ == AFRODITE_MEMBER_TYPE_INTERFACE;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			AfroditeMemberType _tmp6_;
			_tmp6_ = afrodite_symbol_get_member_type (symbol);
			_tmp2_ = _tmp6_ == AFRODITE_MEMBER_TYPE_STRUCT;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _tmp7_ = NULL;
			ValaList* _tmp8_;
			ValaList* _type_list;
			gint _tmp9_;
			gint _type_size;
			gint _type_index;
			_tmp7_ = afrodite_symbol_get_base_types (symbol);
			_tmp8_ = _vala_iterable_ref0 (_tmp7_);
			_type_list = _tmp8_;
			_tmp9_ = vala_collection_get_size ((ValaCollection*) _type_list);
			_type_size = _tmp9_;
			_type_index = -1;
			while (TRUE) {
				gpointer _tmp10_ = NULL;
				AfroditeDataType* type;
				const gchar* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_;
				_type_index = _type_index + 1;
				if (!(_type_index < _type_size)) {
					break;
				}
				_tmp10_ = vala_list_get (_type_list, _type_index);
				type = (AfroditeDataType*) _tmp10_;
				_tmp11_ = afrodite_data_type_get_type_name (type);
				vtg_utils_trace ("vtgsymbolcompletionprovider.vala:545: visiting base type: %s", _tmp11_);
				_tmp15_ = afrodite_data_type_get_unresolved (type);
				if (!_tmp15_) {
					AfroditeSymbol* _tmp16_ = NULL;
					gboolean _tmp17_;
					_tmp16_ = afrodite_data_type_get_symbol (type);
					_tmp17_ = afrodite_symbol_get_has_children (_tmp16_);
					_tmp14_ = _tmp17_;
				} else {
					_tmp14_ = FALSE;
				}
				if (_tmp14_) {
					gboolean _tmp18_ = FALSE;
					if (options == NULL) {
						_tmp18_ = TRUE;
					} else {
						AfroditeSymbol* _tmp19_ = NULL;
						gboolean _tmp20_;
						_tmp19_ = afrodite_data_type_get_symbol (type);
						_tmp20_ = afrodite_symbol_check_options (_tmp19_, options);
						_tmp18_ = _tmp20_;
					}
					_tmp13_ = _tmp18_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					AfroditeSymbol* _tmp23_ = NULL;
					AfroditeMemberType _tmp24_;
					_tmp23_ = afrodite_data_type_get_symbol (type);
					_tmp24_ = afrodite_symbol_get_member_type (_tmp23_);
					if (_tmp24_ == AFRODITE_MEMBER_TYPE_CLASS) {
						_tmp22_ = TRUE;
					} else {
						AfroditeSymbol* _tmp25_ = NULL;
						AfroditeMemberType _tmp26_;
						_tmp25_ = afrodite_data_type_get_symbol (type);
						_tmp26_ = afrodite_symbol_get_member_type (_tmp25_);
						_tmp22_ = _tmp26_ == AFRODITE_MEMBER_TYPE_INTERFACE;
					}
					if (_tmp22_) {
						_tmp21_ = TRUE;
					} else {
						AfroditeSymbol* _tmp27_ = NULL;
						AfroditeMemberType _tmp28_;
						_tmp27_ = afrodite_data_type_get_symbol (type);
						_tmp28_ = afrodite_symbol_get_member_type (_tmp27_);
						_tmp21_ = _tmp28_ == AFRODITE_MEMBER_TYPE_STRUCT;
					}
					_tmp12_ = _tmp21_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					AfroditeSymbol* _tmp29_ = NULL;
					gboolean _tmp30_;
					_tmp29_ = afrodite_data_type_get_symbol (type);
					_tmp30_ = vala_collection_contains ((ValaCollection*) visited_interfaces, _tmp29_);
					if (!_tmp30_) {
						AfroditeSymbol* _tmp31_ = NULL;
						AfroditeSymbol* _tmp32_ = NULL;
						ValaList* _tmp33_ = NULL;
						AfroditeSymbol* _tmp34_ = NULL;
						_tmp31_ = afrodite_data_type_get_symbol (type);
						vala_collection_add ((ValaCollection*) visited_interfaces, _tmp31_);
						_tmp32_ = afrodite_data_type_get_symbol (type);
						_tmp33_ = afrodite_symbol_get_children (_tmp32_);
						vtg_symbol_completion_provider_append_symbols (self, options, _tmp33_, FALSE);
						_tmp34_ = afrodite_data_type_get_symbol (type);
						vtg_symbol_completion_provider_append_base_type_symbols (self, options, _tmp34_, visited_interfaces);
					}
				}
				_afrodite_data_type_unref0 (type);
			}
			_vala_iterable_unref0 (_type_list);
		}
	} else {
		const gchar* _tmp35_ = NULL;
		AfroditeMemberType _tmp36_;
		GEnumValue* _tmp37_;
		_tmp35_ = afrodite_symbol_get_name (symbol);
		_tmp36_ = afrodite_symbol_get_member_type (symbol);
		_tmp37_ = g_enum_get_value (g_type_class_ref (AFRODITE_TYPE_MEMBER_TYPE), _tmp36_);
		vtg_utils_trace ("vtgsymbolcompletionprovider.vala:559: NO base type for %s-%s", _tmp35_, (_tmp37_ != NULL) ? _tmp37_->value_name : NULL);
	}
}


static void vtg_symbol_completion_provider_get_current_line_and_column (VtgSymbolCompletionProvider* self, gint* line, gint* column) {
	gint _line = 0;
	gint _column = 0;
	GeditView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GeditDocument* doc;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextMark* mark;
	GtkTextIter start = {0};
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	doc = GEDIT_DOCUMENT (_tmp1_);
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) doc);
	mark = GTK_TEXT_MARK (_tmp2_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &_tmp3_, mark);
	start = _tmp3_;
	_tmp4_ = gtk_text_iter_get_line (&start);
	_line = _tmp4_;
	_tmp5_ = gtk_text_iter_get_line_offset (&start);
	_column = _tmp5_;
	if (line) {
		*line = _line;
	}
	if (column) {
		*column = _column;
	}
}


static gchar* vtg_symbol_completion_provider_get_current_line_text (VtgSymbolCompletionProvider* self, gboolean align_to_right_word) {
	gchar* result = NULL;
	GeditView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GeditDocument* doc;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextMark* mark;
	GtkTextIter end = {0};
	GtkTextIter start = {0};
	gunichar ch = 0U;
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_;
	gint line;
	gunichar _tmp5_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	doc = GEDIT_DOCUMENT (_tmp1_);
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) doc);
	mark = GTK_TEXT_MARK (_tmp2_);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) doc, &_tmp3_, mark);
	start = _tmp3_;
	_tmp4_ = gtk_text_iter_get_line (&start);
	line = _tmp4_;
	_tmp5_ = gtk_text_iter_get_char (&start);
	ch = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		gint _tmp8_;
		gint curr_line;
		gunichar _tmp9_;
		_tmp7_ = g_unichar_isalnum (ch);
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = ch == '_';
		}
		if (!_tmp6_) {
			break;
		}
		gtk_text_iter_forward_char (&start);
		_tmp8_ = gtk_text_iter_get_line (&start);
		curr_line = _tmp8_;
		if (line != curr_line) {
			gtk_text_iter_backward_char (&start);
			break;
		}
		_tmp9_ = gtk_text_iter_get_char (&start);
		ch = _tmp9_;
	}
	end = start;
	gtk_text_iter_set_line_offset (&start, 0);
	_tmp10_ = gtk_text_iter_get_text (&start, &end);
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	return result;
}


AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_containing_cursor (VtgSymbolCompletionProvider* self) {
	AfroditeSymbol* result = NULL;
	gint line = 0;
	gint col = 0;
	AfroditeSymbol* symbol;
	GeditView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GeditDocument* _tmp2_;
	GeditDocument* doc;
	gchar* _tmp3_ = NULL;
	gchar* name;
	gint _tmp4_;
	gint _tmp5_;
	AfroditeCodeDom* _tmp6_ = NULL;
	AfroditeSymbol* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	symbol = NULL;
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp1_));
	doc = _tmp2_;
	_tmp3_ = vtg_utils_get_document_name (doc);
	name = _tmp3_;
	vtg_symbol_completion_provider_get_current_line_and_column (self, &_tmp4_, &_tmp5_);
	line = _tmp4_;
	col = _tmp5_;
	_tmp6_ = afrodite_completion_engine_get_codedom (self->priv->_completion);
	_tmp7_ = afrodite_code_dom_lookup_symbol_at (_tmp6_, name, line, col);
	_g_object_unref0 (symbol);
	symbol = _tmp7_;
	result = symbol;
	_g_free0 (name);
	_g_object_unref0 (doc);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gpointer _afrodite_code_dom_ref0 (gpointer self) {
	return self ? afrodite_code_dom_ref (self) : NULL;
}


AfroditeSymbol* vtg_symbol_completion_provider_get_current_symbol_item (VtgSymbolCompletionProvider* self) {
	AfroditeSymbol* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* text;
	gchar* word = NULL;
	gint line = 0;
	gint col = 0;
	gboolean is_assignment = FALSE;
	gboolean is_creation = FALSE;
	gboolean is_declaration = FALSE;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gint _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_ = NULL;
	gchar** tmp;
	gint tmp_length1;
	gint _tmp_size_;
	gchar* _tmp10_;
	gchar* last_part;
	gchar* _tmp11_;
	gchar* symbol_name;
	gboolean _tmp12_;
	gchar* first_part = NULL;
	AfroditeCodeDom* _tmp17_ = NULL;
	AfroditeCodeDom* _tmp18_;
	AfroditeCodeDom* codedom;
	AfroditeSymbol* symbol;
	AfroditeQueryResult* _result_;
	AfroditeQueryOptions* _tmp19_ = NULL;
	AfroditeQueryOptions* options;
	gboolean _tmp22_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vtg_symbol_completion_provider_get_current_line_text (self, TRUE);
	text = _tmp0_;
	vtg_parser_utils_parse_line (text, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (word);
	word = _tmp1_;
	is_assignment = _tmp2_;
	is_creation = _tmp3_;
	is_declaration = _tmp4_;
	if (word == NULL) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = g_strcmp0 (word, "") == 0;
	}
	if (_tmp5_) {
		result = NULL;
		_g_free0 (word);
		_g_free0 (text);
		return result;
	}
	vtg_symbol_completion_provider_get_current_line_and_column (self, &_tmp6_, &_tmp7_);
	line = _tmp6_;
	col = _tmp7_;
	_tmp9_ = _tmp8_ = g_strsplit (word, ".", 0);
	tmp = _tmp9_;
	tmp_length1 = _vala_array_length (_tmp8_);
	_tmp_size_ = _vala_array_length (_tmp8_);
	_tmp10_ = g_strdup (tmp[tmp_length1 - 1]);
	last_part = _tmp10_;
	_tmp11_ = g_strdup (last_part);
	symbol_name = _tmp11_;
	_tmp12_ = vtg_utils_is_vala_keyword (symbol_name);
	if (_tmp12_) {
		result = NULL;
		_g_free0 (symbol_name);
		_g_free0 (last_part);
		tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (word);
		_g_free0 (text);
		return result;
	}
	if (g_strcmp0 (word, last_part) != 0) {
		gint _tmp13_;
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		_tmp13_ = strlen (word);
		_tmp14_ = strlen (last_part);
		_tmp15_ = string_substring (word, (glong) 0, (glong) ((_tmp13_ - _tmp14_) - 1));
		_g_free0 (first_part);
		first_part = _tmp15_;
	} else {
		gchar* _tmp16_;
		_tmp16_ = g_strdup (word);
		_g_free0 (first_part);
		first_part = _tmp16_;
	}
	_tmp17_ = afrodite_completion_engine_get_codedom (self->priv->_completion);
	_tmp18_ = _afrodite_code_dom_ref0 (_tmp17_);
	codedom = _tmp18_;
	symbol = NULL;
	_result_ = NULL;
	_tmp19_ = vtg_symbol_completion_provider_get_options_for_line (self, text, is_assignment, is_creation);
	options = _tmp19_;
	if (g_strcmp0 (word, symbol_name) == 0) {
		AfroditeQueryResult* _tmp20_ = NULL;
		_tmp20_ = vtg_symbol_completion_provider_get_symbol_for_name (self, options, codedom, first_part, NULL, line, col);
		_afrodite_query_result_unref0 (_result_);
		_result_ = _tmp20_;
	} else {
		AfroditeQueryResult* _tmp21_ = NULL;
		_tmp21_ = vtg_symbol_completion_provider_get_symbol_type_for_name (self, options, codedom, first_part, NULL, line, col);
		_afrodite_query_result_unref0 (_result_);
		_result_ = _tmp21_;
	}
	if (_result_ != NULL) {
		gboolean _tmp23_;
		_tmp23_ = afrodite_query_result_get_is_empty (_result_);
		_tmp22_ = !_tmp23_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaList* _tmp24_ = NULL;
		gpointer _tmp25_ = NULL;
		AfroditeResultItem* first;
		_tmp24_ = afrodite_query_result_get_children (_result_);
		_tmp25_ = vala_list_get (_tmp24_, 0);
		first = (AfroditeResultItem*) _tmp25_;
		if (g_strcmp0 (word, symbol_name) == 0) {
			AfroditeSymbol* _tmp26_ = NULL;
			AfroditeSymbol* _tmp27_;
			_tmp26_ = afrodite_result_item_get_symbol (first);
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (symbol);
			symbol = _tmp27_;
		} else {
			AfroditeSymbol* _tmp28_ = NULL;
			AfroditeSymbol* _tmp29_ = NULL;
			_tmp28_ = afrodite_result_item_get_symbol (first);
			_tmp29_ = vtg_symbol_completion_provider_get_symbol_for_name_in_children (self, symbol_name, _tmp28_);
			_g_object_unref0 (symbol);
			symbol = _tmp29_;
			if (symbol == NULL) {
				AfroditeSymbol* _tmp30_ = NULL;
				AfroditeSymbol* _tmp31_ = NULL;
				_tmp30_ = afrodite_result_item_get_symbol (first);
				_tmp31_ = vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (self, symbol_name, _tmp30_);
				_g_object_unref0 (symbol);
				symbol = _tmp31_;
			}
		}
		_afrodite_result_item_unref0 (first);
	}
	result = symbol;
	_afrodite_query_options_unref0 (options);
	_afrodite_query_result_unref0 (_result_);
	_afrodite_code_dom_unref0 (codedom);
	_g_free0 (first_part);
	_g_free0 (symbol_name);
	_g_free0 (last_part);
	tmp = (_vala_array_free (tmp, tmp_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (word);
	_g_free0 (text);
	return result;
}


static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_children (VtgSymbolCompletionProvider* self, const gchar* symbol_name, AfroditeSymbol* parent) {
	AfroditeSymbol* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_name != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = afrodite_symbol_get_has_children (parent);
	if (_tmp0_) {
		{
			ValaList* _tmp1_ = NULL;
			ValaList* _tmp2_;
			ValaList* _symbol_list;
			gint _tmp3_;
			gint _symbol_size;
			gint _symbol_index;
			_tmp1_ = afrodite_symbol_get_children (parent);
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_symbol_list = _tmp2_;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _symbol_list);
			_symbol_size = _tmp3_;
			_symbol_index = -1;
			while (TRUE) {
				gpointer _tmp4_ = NULL;
				AfroditeSymbol* symbol;
				const gchar* _tmp5_ = NULL;
				_symbol_index = _symbol_index + 1;
				if (!(_symbol_index < _symbol_size)) {
					break;
				}
				_tmp4_ = vala_list_get (_symbol_list, _symbol_index);
				symbol = (AfroditeSymbol*) _tmp4_;
				_tmp5_ = afrodite_symbol_get_name (symbol);
				if (g_strcmp0 (_tmp5_, symbol_name) == 0) {
					result = symbol;
					_vala_iterable_unref0 (_symbol_list);
					return result;
				}
				_g_object_unref0 (symbol);
			}
			_vala_iterable_unref0 (_symbol_list);
		}
	}
	result = NULL;
	return result;
}


static AfroditeSymbol* vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (VtgSymbolCompletionProvider* self, const gchar* symbol_name, AfroditeSymbol* parent) {
	AfroditeSymbol* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_name != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = afrodite_symbol_get_has_base_types (parent);
	if (_tmp0_) {
		{
			ValaList* _tmp1_ = NULL;
			ValaList* _tmp2_;
			ValaList* _t_list;
			gint _tmp3_;
			gint _t_size;
			gint _t_index;
			_tmp1_ = afrodite_symbol_get_base_types (parent);
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_t_list = _tmp2_;
			_tmp3_ = vala_collection_get_size ((ValaCollection*) _t_list);
			_t_size = _tmp3_;
			_t_index = -1;
			while (TRUE) {
				gpointer _tmp4_ = NULL;
				AfroditeDataType* t;
				AfroditeSymbol* _tmp5_ = NULL;
				_t_index = _t_index + 1;
				if (!(_t_index < _t_size)) {
					break;
				}
				_tmp4_ = vala_list_get (_t_list, _t_index);
				t = (AfroditeDataType*) _tmp4_;
				_tmp5_ = afrodite_data_type_get_symbol (t);
				if (_tmp5_ != NULL) {
					AfroditeSymbol* _tmp6_ = NULL;
					AfroditeSymbol* _tmp7_ = NULL;
					AfroditeSymbol* base_symbol;
					_tmp6_ = afrodite_data_type_get_symbol (t);
					_tmp7_ = vtg_symbol_completion_provider_get_symbol_for_name_in_children (self, symbol_name, _tmp6_);
					base_symbol = _tmp7_;
					if (base_symbol == NULL) {
						AfroditeSymbol* _tmp8_ = NULL;
						AfroditeSymbol* _tmp9_ = NULL;
						_tmp8_ = afrodite_data_type_get_symbol (t);
						_tmp9_ = vtg_symbol_completion_provider_get_symbol_for_name_in_base_types (self, symbol_name, _tmp8_);
						_g_object_unref0 (base_symbol);
						base_symbol = _tmp9_;
					}
					if (base_symbol != NULL) {
						result = base_symbol;
						_afrodite_data_type_unref0 (t);
						_vala_iterable_unref0 (_t_list);
						return result;
					}
					_g_object_unref0 (base_symbol);
				}
				_afrodite_data_type_unref0 (t);
			}
			_vala_iterable_unref0 (_t_list);
		}
	}
	result = NULL;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static AfroditeQueryOptions* vtg_symbol_completion_provider_get_options_for_line (VtgSymbolCompletionProvider* self, const gchar* line, gboolean is_assignment, gboolean is_creation) {
	AfroditeQueryOptions* result = NULL;
	AfroditeQueryOptions* options;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	options = NULL;
	if (is_creation) {
		AfroditeQueryOptions* _tmp0_ = NULL;
		_tmp0_ = afrodite_query_options_creation_methods ();
		_afrodite_query_options_unref0 (options);
		options = _tmp0_;
	} else {
		gboolean _tmp1_ = FALSE;
		if (is_assignment) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (line != NULL) {
				gint _tmp3_;
				_tmp3_ = string_last_index_of (line, ":", 0);
				_tmp2_ = _tmp3_ != (-1);
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		if (_tmp1_) {
			AfroditeQueryOptions* _tmp4_ = NULL;
			_tmp4_ = afrodite_query_options_standard ();
			_afrodite_query_options_unref0 (options);
			options = _tmp4_;
			options->binding = options->binding | AFRODITE_MEMBER_BINDING_STATIC;
		} else {
			gboolean _tmp5_ = FALSE;
			if (line != NULL) {
				gboolean _tmp6_ = FALSE;
				gint _tmp7_;
				_tmp7_ = string_index_of (line, "throws ", 0);
				if (_tmp7_ != (-1)) {
					_tmp6_ = TRUE;
				} else {
					gint _tmp8_;
					_tmp8_ = string_index_of (line, "throw ", 0);
					_tmp6_ = _tmp8_ != (-1);
				}
				_tmp5_ = _tmp6_;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				AfroditeQueryOptions* _tmp9_ = NULL;
				_tmp9_ = afrodite_query_options_error_domains ();
				_afrodite_query_options_unref0 (options);
				options = _tmp9_;
			}
		}
	}
	if (options == NULL) {
		AfroditeQueryOptions* _tmp10_ = NULL;
		_tmp10_ = afrodite_query_options_standard ();
		_afrodite_query_options_unref0 (options);
		options = _tmp10_;
	}
	options->access = (AFRODITE_SYMBOL_ACCESSIBILITY_INTERNAL | AFRODITE_SYMBOL_ACCESSIBILITY_PROTECTED) | AFRODITE_SYMBOL_ACCESSIBILITY_PUBLIC;
	options->auto_member_binding_mode = TRUE;
	options->compare_mode = AFRODITE_COMPARE_MODE_EXACT;
	result = options;
	return result;
}


static gboolean _vtg_symbol_completion_provider_on_hide_calltip_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = vtg_symbol_completion_provider_on_hide_calltip_timeout (self);
	return result;
}


static void vtg_symbol_completion_provider_complete_current_word (VtgSymbolCompletionProvider* self) {
	gchar* _tmp0_ = NULL;
	gchar* text;
	gchar* word = NULL;
	gboolean is_assignment = FALSE;
	gboolean is_creation = FALSE;
	gboolean is_declaration = FALSE;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	AfroditeCodeDom* _tmp5_ = NULL;
	AfroditeCodeDom* _tmp6_;
	AfroditeCodeDom* codedom;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vtg_symbol_completion_provider_get_current_line_text (self, FALSE);
	text = _tmp0_;
	vtg_parser_utils_parse_line (text, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (word);
	word = _tmp1_;
	is_assignment = _tmp2_;
	is_creation = _tmp3_;
	is_declaration = _tmp4_;
	_tmp5_ = afrodite_completion_engine_get_codedom (self->priv->_completion);
	_tmp6_ = _afrodite_code_dom_ref0 (_tmp5_);
	codedom = _tmp6_;
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:743: completing word: '%s'", word);
	_tmp7_ = vtg_string_utils_is_null_or_empty (word);
	if (!_tmp7_) {
		AfroditeQueryOptions* _tmp8_ = NULL;
		AfroditeQueryOptions* options;
		AfroditeQueryResult* _result_;
		gint line = 0;
		gint col = 0;
		gint _tmp9_;
		gint _tmp10_;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_;
		AfroditeQueryResult* _tmp19_ = NULL;
		_tmp8_ = vtg_symbol_completion_provider_get_options_for_line (self, text, is_assignment, is_creation);
		options = _tmp8_;
		_result_ = NULL;
		vtg_symbol_completion_provider_get_current_line_and_column (self, &_tmp9_, &_tmp10_);
		line = _tmp9_;
		col = _tmp10_;
		_tmp12_ = g_str_has_prefix (word, "\"");
		if (_tmp12_) {
			gboolean _tmp13_;
			_tmp13_ = g_str_has_suffix (word, "\"");
			_tmp11_ = _tmp13_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("string");
			_g_free0 (word);
			word = _tmp14_;
		} else {
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_;
			_tmp16_ = g_str_has_prefix (word, "\'");
			if (_tmp16_) {
				gboolean _tmp17_;
				_tmp17_ = g_str_has_suffix (word, "\'");
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				gchar* _tmp18_;
				_tmp18_ = g_strdup ("unichar");
				_g_free0 (word);
				word = _tmp18_;
			}
		}
		_tmp19_ = vtg_symbol_completion_provider_get_symbol_type_for_name (self, options, codedom, word, text, line, col);
		_afrodite_query_result_unref0 (_result_);
		_result_ = _tmp19_;
		vtg_symbol_completion_provider_transform_result (self, options, _result_);
		_afrodite_query_result_unref0 (_result_);
		_afrodite_query_options_unref0 (options);
	} else {
		gboolean _tmp20_;
		_tmp20_ = vtg_string_utils_is_null_or_empty (word);
		if (!_tmp20_) {
			const gchar* _tmp21_ = NULL;
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:760: build_proposal_item_list: couldn" \
"'t acquire ast lock");
			_tmp21_ = _ ("<i>source symbol cache is still updating...</i>");
			vtg_symbol_completion_provider_show_calltip_info (self, _tmp21_);
			g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, _vtg_symbol_completion_provider_on_hide_calltip_timeout_gsource_func, g_object_ref (self), g_object_unref);
			g_signal_emit_by_name (self, "completion-lock-failed");
		}
		vtg_symbol_completion_provider_transform_result (self, NULL, NULL);
	}
	_afrodite_code_dom_unref0 (codedom);
	_g_free0 (word);
	_g_free0 (text);
}


static void vtg_symbol_completion_provider_lookup_visible_symbols_in_scope (VtgSymbolCompletionProvider* self, const gchar* word, AfroditeCompareMode mode) {
	AfroditeCodeDom* _tmp0_ = NULL;
	AfroditeCodeDom* _tmp1_;
	AfroditeCodeDom* codedom;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (word != NULL);
	_tmp0_ = afrodite_completion_engine_get_codedom (self->priv->_completion);
	_tmp1_ = _afrodite_code_dom_ref0 (_tmp0_);
	codedom = _tmp1_;
	if (mode == AFRODITE_COMPARE_MODE_EXACT) {
		_tmp2_ = "exact";
	} else {
		_tmp2_ = "start-with";
	}
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:772: lookup_all_symbols_in_scope: mod" \
"e: %s word:'%s' ", _tmp2_, word);
	_tmp3_ = vtg_string_utils_is_null_or_empty (word);
	if (!_tmp3_) {
		ValaArrayList* _tmp4_ = NULL;
		ValaList* results;
		GeditView* _tmp5_ = NULL;
		GtkTextBuffer* _tmp6_ = NULL;
		GeditDocument* doc;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		AfroditeSourceFile* _tmp9_ = NULL;
		AfroditeSourceFile* _tmp10_;
		AfroditeSourceFile* source;
		gint _tmp17_;
		_tmp4_ = vala_array_list_new (AFRODITE_TYPE_SYMBOL, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
		results = (ValaList*) _tmp4_;
		_tmp5_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
		_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp5_);
		doc = GEDIT_DOCUMENT (_tmp6_);
		_tmp7_ = vtg_utils_get_document_name (doc);
		_tmp8_ = _tmp7_;
		_tmp9_ = afrodite_code_dom_lookup_source_file (codedom, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		source = _tmp10_;
		if (source != NULL) {
			gint line = 0;
			gint column = 0;
			gint _tmp11_;
			gint _tmp12_;
			AfroditeSymbol* _tmp13_ = NULL;
			AfroditeSymbol* s;
			vtg_symbol_completion_provider_get_current_line_and_column (self, &_tmp11_, &_tmp12_);
			line = _tmp11_;
			column = _tmp12_;
			_tmp13_ = afrodite_code_dom_get_symbol_for_source_and_position (codedom, source, line, column);
			s = _tmp13_;
			if (s != NULL) {
				ValaList* _tmp14_ = NULL;
				_tmp14_ = afrodite_code_dom_lookup_visible_symbols_from_symbol (codedom, s, word, mode, AFRODITE_CASE_SENSITIVENESS_CASE_SENSITIVE);
				_vala_iterable_unref0 (results);
				results = _tmp14_;
			}
			_g_object_unref0 (s);
		} else {
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			_tmp15_ = vtg_utils_get_document_name (doc);
			_tmp16_ = _tmp15_;
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:790: no source file for: %s", _tmp16_);
			_g_free0 (_tmp16_);
		}
		_tmp17_ = vala_collection_get_size ((ValaCollection*) results);
		if (_tmp17_ == 0) {
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:794: no symbol visible");
			vtg_symbol_completion_provider_transform_result (self, NULL, NULL);
		} else {
			__g_list_free__g_object_unref0_0 (self->priv->_proposals);
			self->priv->_proposals = NULL;
			vtg_symbol_completion_provider_append_symbols (self, NULL, results, TRUE);
		}
		_afrodite_source_file_unref0 (source);
		_vala_iterable_unref0 (results);
	} else {
		gboolean _tmp18_;
		_tmp18_ = vtg_string_utils_is_null_or_empty (word);
		if (!_tmp18_) {
			vtg_utils_trace ("vtgsymbolcompletionprovider.vala:802: build_proposal_item_list: couldn" \
"'t acquire ast lock");
			g_signal_emit_by_name (self, "completion-lock-failed");
		}
		vtg_symbol_completion_provider_transform_result (self, NULL, NULL);
	}
	_afrodite_code_dom_unref0 (codedom);
}


static gboolean vtg_symbol_completion_provider_on_hide_calltip_timeout (VtgSymbolCompletionProvider* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	vtg_symbol_completion_provider_hide_calltip (self);
	result = FALSE;
	return result;
}


static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_type_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeCodeDom* codedom, const gchar* word, const gchar* whole_line, gint line, gint column) {
	AfroditeQueryResult* result = NULL;
	AfroditeQueryResult* _result_;
	GeditView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GeditDocument* _tmp2_;
	GeditDocument* doc;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	AfroditeQueryResult* _tmp5_ = NULL;
	ValaList* _tmp6_ = NULL;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (codedom != NULL, NULL);
	g_return_val_if_fail (word != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp1_));
	doc = _tmp2_;
	_tmp3_ = vtg_utils_get_document_name (doc);
	_tmp4_ = _tmp3_;
	_tmp5_ = afrodite_code_dom_get_symbol_type_for_name_and_path (codedom, options, word, _tmp4_, line, column);
	_afrodite_query_result_unref0 (_result_);
	_result_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = afrodite_query_result_get_children (_result_);
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	vtg_utils_trace ("vtgsymbolcompletionprovider.vala:821: symbol matched %d", _tmp7_);
	result = _result_;
	_g_object_unref0 (doc);
	return result;
}


static AfroditeQueryResult* vtg_symbol_completion_provider_get_symbol_for_name (VtgSymbolCompletionProvider* self, AfroditeQueryOptions* options, AfroditeCodeDom* codedom, const gchar* word, const gchar* whole_line, gint line, gint column) {
	AfroditeQueryResult* result = NULL;
	AfroditeQueryResult* _result_;
	GeditView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GeditDocument* _tmp2_;
	GeditDocument* doc;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	AfroditeQueryResult* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (options != NULL, NULL);
	g_return_val_if_fail (codedom != NULL, NULL);
	g_return_val_if_fail (word != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp1_));
	doc = _tmp2_;
	_tmp3_ = vtg_utils_get_document_name (doc);
	_tmp4_ = _tmp3_;
	_tmp5_ = afrodite_code_dom_get_symbol_for_name_and_path (codedom, options, word, _tmp4_, line, column);
	_afrodite_query_result_unref0 (_result_);
	_result_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _result_;
	_g_object_unref0 (doc);
	return result;
}


static void vtg_symbol_completion_provider_class_init (VtgSymbolCompletionProviderClass * klass) {
	vtg_symbol_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (VtgSymbolCompletionProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = vtg_symbol_completion_provider_finalize;
	g_signal_new ("completion_lock_failed", VTG_TYPE_SYMBOL_COMPLETION_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void vtg_symbol_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	vtg_symbol_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*)(GtkSourceCompletionProvider*)) vtg_symbol_completion_provider_real_get_name;
	iface->get_priority = (gint (*)(GtkSourceCompletionProvider*)) vtg_symbol_completion_provider_real_get_priority;
	iface->match = (gboolean (*)(GtkSourceCompletionProvider* ,GtkSourceCompletionContext*)) vtg_symbol_completion_provider_real_match;
	iface->populate = (void (*)(GtkSourceCompletionProvider* ,GtkSourceCompletionContext*)) vtg_symbol_completion_provider_real_populate;
	iface->get_icon = (GdkPixbuf* (*)(GtkSourceCompletionProvider*)) vtg_symbol_completion_provider_real_get_icon;
	iface->activate_proposal = (gboolean (*)(GtkSourceCompletionProvider* ,GtkSourceCompletionProposal* ,GtkTextIter*)) vtg_symbol_completion_provider_real_activate_proposal;
	iface->get_activation = (GtkSourceCompletionActivation (*)(GtkSourceCompletionProvider*)) vtg_symbol_completion_provider_real_get_activation;
	iface->get_info_widget = (GtkWidget* (*)(GtkSourceCompletionProvider* ,GtkSourceCompletionProposal*)) vtg_symbol_completion_provider_real_get_info_widget;
	iface->get_interactive_delay = (gint (*)(GtkSourceCompletionProvider*)) vtg_symbol_completion_provider_real_get_interactive_delay;
	iface->get_start_iter = (gboolean (*)(GtkSourceCompletionProvider* ,GtkSourceCompletionContext* ,GtkSourceCompletionProposal* ,GtkTextIter*)) vtg_symbol_completion_provider_real_get_start_iter;
	iface->update_info = (void (*)(GtkSourceCompletionProvider* ,GtkSourceCompletionProposal* ,GtkSourceCompletionInfo*)) vtg_symbol_completion_provider_real_update_info;
}


static void vtg_symbol_completion_provider_instance_init (VtgSymbolCompletionProvider * self) {
	gunichar* _tmp0_ = NULL;
	self->priv = VTG_SYMBOL_COMPLETION_PROVIDER_GET_PRIVATE (self);
	self->priv->_priority = 1;
	self->priv->_timeout_id = (guint) 0;
	self->priv->_idle_id = (guint) 0;
	self->priv->_prealloc_index = 0;
	self->priv->_cache_building = FALSE;
	self->priv->_filter = FALSE;
	self->priv->_sb_msg_id = (guint) 0;
	self->priv->_sb_context_id = (guint) 0;
	self->priv->_calltip_window = NULL;
	self->priv->_calltip_window_label = NULL;
	self->priv->_symbol_completion = NULL;
	self->priv->_completion = NULL;
	_tmp0_ = g_new0 (gunichar, 3);
	_tmp0_[0] = (gunichar) '\n';
	_tmp0_[1] = (gunichar) '}';
	_tmp0_[2] = (gunichar) ';';
	self->priv->_reparse_chars = _tmp0_;
	self->priv->_reparse_chars_length1 = 3;
	self->priv->__reparse_chars_size_ = self->priv->_reparse_chars_length1;
	self->priv->_doc_changed = FALSE;
	self->priv->_last_line = 0;
}


static void vtg_symbol_completion_provider_finalize (GObject* obj) {
	VtgSymbolCompletionProvider * self;
	GeditView* _tmp0_ = NULL;
	guint _tmp1_;
	GeditView* _tmp2_ = NULL;
	guint _tmp3_;
	GeditView* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GeditDocument* _tmp6_;
	GeditDocument* doc;
	guint _tmp7_;
	GQuark _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	self = VTG_SYMBOL_COMPLETION_PROVIDER (obj);
	if (self->priv->_timeout_id != 0) {
		g_source_remove (self->priv->_timeout_id);
	}
	if (self->priv->_idle_id != 0) {
		g_source_remove (self->priv->_idle_id);
	}
	_tmp0_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	g_signal_parse_name ("key-press-event", GTK_TYPE_WIDGET, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _vtg_symbol_completion_provider_on_view_key_press_gtk_widget_key_press_event, self);
	_tmp2_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	g_signal_parse_name ("focus-out-event", GTK_TYPE_WIDGET, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _vtg_symbol_completion_provider_on_view_focus_out_gtk_widget_focus_out_event, self);
	_tmp4_ = vtg_symbol_completion_get_view (self->priv->_symbol_completion);
	_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp4_);
	_tmp6_ = _g_object_ref0 (GEDIT_DOCUMENT (_tmp5_));
	doc = _tmp6_;
	g_signal_parse_name ("notify::completion-engine", G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) self->priv->_symbol_completion, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) _vtg_symbol_completion_provider_on_completion_engine_changed_g_object_notify, self);
	g_signal_parse_name ("notify::cursor-position", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) doc, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _vtg_symbol_completion_provider_on_cursor_position_changed_g_object_notify, self);
	g_signal_handlers_disconnect_by_func (doc, (void*) vtg_symbol_completion_provider_on_document_saved, self);
	if (self->priv->_sb_msg_id != 0) {
		VtgPluginInstance* _tmp11_ = NULL;
		GeditWindow* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
		GeditStatusbar* _tmp14_;
		GeditStatusbar* status_bar;
		_tmp11_ = vtg_symbol_completion_get_plugin_instance (self->priv->_symbol_completion);
		_tmp12_ = vtg_plugin_instance_get_window (_tmp11_);
		_tmp13_ = gedit_window_get_statusbar (_tmp12_);
		_tmp14_ = _g_object_ref0 (GEDIT_STATUSBAR (_tmp13_));
		status_bar = _tmp14_;
		gtk_statusbar_remove ((GtkStatusbar*) status_bar, self->priv->_sb_context_id, self->priv->_sb_msg_id);
		_g_object_unref0 (status_bar);
	}
	_g_object_unref0 (doc);
	_g_object_unref0 (self->priv->_icon);
	__g_list_free__g_object_unref0_0 (self->priv->_proposals);
	_g_object_unref0 (self->priv->_calltip_window);
	_g_object_unref0 (self->priv->_calltip_window_label);
	self->priv->_reparse_chars = (g_free (self->priv->_reparse_chars), NULL);
	G_OBJECT_CLASS (vtg_symbol_completion_provider_parent_class)->finalize (obj);
}


GType vtg_symbol_completion_provider_get_type (void) {
	return vtg_symbol_completion_provider_type_id;
}


GType vtg_symbol_completion_provider_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VtgSymbolCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vtg_symbol_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VtgSymbolCompletionProvider), 0, (GInstanceInitFunc) vtg_symbol_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) vtg_symbol_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	vtg_symbol_completion_provider_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "VtgSymbolCompletionProvider", &g_define_type_info, 0);
	g_type_module_add_interface (module, vtg_symbol_completion_provider_type_id, GTK_SOURCE_TYPE_COMPLETION_PROVIDER, &gtk_source_completion_provider_info);
	return vtg_symbol_completion_provider_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



