############################################################################
##
## Copyright (C) 2006-2008 University of Utah. All rights reserved.
##
## This file is part of VisTrails.
##
## This file may be used under the terms of the GNU General Public
## License version 2.0 as published by the Free Software Foundation
## and appearing in the file LICENSE.GPL included in the packaging of
## this file.  Please review the following to ensure GNU General Public
## Licensing requirements will be met:
## http://www.opensource.org/licenses/gpl-license.php
##
## If you are unsure which license is appropriate for your use (for
## instance, you are interested in developing a commercial derivative
## of VisTrails), please contact us at contact@vistrails.org.
##
## This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
## WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
##
############################################################################
""" Do not edit this file!

File automatically generated by scripts/gen_init.py
Change History:
version : description
  0.2   : Integrated quickplot module that displays the CDAT plot
          widget inside the spreadsheet  
  0.1   : First automatically generated package based on xml descriptions

"""
from PyQt4 import QtCore, QtGui
import sip
import core.modules
import core.modules.module_registry
from core.modules.vistrails_module import (Module, NotCacheable,
                                           ModuleError, new_module)
from core.bundles import py_import
import os, sys, re

#cdat specific packages
vcs = py_import('vcs',{})
cdms2 = py_import('cdms2', {})
cdutil = py_import('cdutil', {})
import MV2
import genutil

#local python modules
from cdat_window import QCDATWindow
from cdat_cell import QCDATWidget, CDATCell, Variable, GraphicsMethod, Quickplot
#from quickplot import quickplot
from packages.spreadsheet.basic_widgets import CellLocation
from packages.spreadsheet.basic_widgets import SpreadsheetCell

version = "0.2"
identifier = "edu.utah.sci.vistrails.cdat"
name = "CDAT"

vt_type_dict = {}
def get_late_type(type):
    return vt_type_dict[type]

Canvas = new_module(Module,'Canvas')
Dp = new_module(Module,'Dp')
vt_type_dict['vcs.displayplot.Dp'] = Dp
Gfb = new_module(Module,'Gfb')
vt_type_dict['vcs.boxfill.Gfb'] = Gfb
Gfi = new_module(Module,'Gfi')
vt_type_dict['vcs.isofill.Gfi'] = Gfi
Gi = new_module(Module,'Gi')
vt_type_dict['vcs.isoline.Gi'] = Gi
Gfo = new_module(Module,'Gfo')
vt_type_dict['vcs.outfill.Gfo'] = Gfo
Go = new_module(Module,'Go')
vt_type_dict['vcs.outline.Go'] = Go
GSp = new_module(Module,'GSp')
vt_type_dict['vcs.scatter.GSp'] = GSp
GXY = new_module(Module,'GXY')
vt_type_dict['vcs.xvsy.GXY'] = GXY
GXy = new_module(Module,'GXy')
vt_type_dict['vcs.xyvsy.GXy'] = GXy
GYx = new_module(Module,'GYx')
vt_type_dict['vcs.yxvsx.GYx'] = GYx
CdmsFile = new_module(Module,'CdmsFile')
vt_type_dict['cdms2.dataset.CdmsFile'] = CdmsFile
TransientVariable = new_module(Module,'TransientVariable')
vt_type_dict['cdms2.tvariable.TransientVariable'] = TransientVariable


class boxfill(SpreadsheetCell,NotCacheable):
    """
			Function: boxfill                        # Generate a boxfill plot

 Description of Function:
    Generate a boxfill plot given the data, boxfill graphics method, and
    template. If no boxfill class object is given, then the 'default' boxfill
    graphics method is used. Similarly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('boxfill')                        # Show all the existing boxfill graphics methods
    box=a.getboxfill('quick')                # Create instance of 'quick'
    a.boxfill(array,box)                # Plot array using specified box and default
                                        #         template
    templt=a.gettemplate('AMIP')        # Create an instance of template 'AMIP'
    a.clear()                           # Clear VCS canvas
    a.boxfill(array,box,template)       # Plot array using specified box and template
    a.boxfill(box,array,template)       # Plot array using specified box and template
    a.boxfill(template,array,box)       # Plot array using specified box and template
    a.boxfill(template,array,box)       # Plot array using specified box and template
    a.boxfill(array,'AMIP','quick')     # Use 'AMIP' template and 'quick' boxfill
    a.boxfill('AMIP',array,'quick')     # Use 'AMIP' template and 'quick' boxfill
    a.boxfill('AMIP','quick',array)     # Use 'AMIP' template and 'quick' boxfill

###################################################################################################################
###########################################                         ###############################################
########################################## End boxfill Description ################################################
#########################################                         #################################################
###################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
            print 'got canvas'
            print canvas
        else:
            print 'no canvas'
            canvas = vcs.init()

        # Build the argument list
        args = []        
        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
            args.append(slab)
        # slab is a required port
        if slab is None:
            raise ModuleError(self, "'slab' is a mandatory port")

        template = None
        if self.hasInputFromPort('template'):
            template = self.getInputFromPort('template')
            args.append(template)
        # template is a required port
        if template is None:
            raise ModuleError(self, "'template' is a mandatory port")

        args.append('Boxfill')

        gm_name = None
        if self.hasInputFromPort('gm_name'):
            gm_name = self.getInputFromPort('gm_name')
            args.append(gm_name)
        # gm_name is a required port
        if gm_name is None:
            raise ModuleError(self, "'template' is a mandatory port")        

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
            
        # force images to be created in the background
        # kwargs['bg'] = 1

        # TODO

        #res = canvas.boxfill(*args,**kwargs)
        #res = canvas.plot(slab, 'ASD', 'Boxfill', 'ASD')

        #plotArgs = (graphics_method, 'ASD', dataset)
        inputPorts = (canvas, args, kwargs)
        self.displayAndWait(QCDATWidget, inputPorts)
        
        # self.setResult('display', res) 
        self.setResult('canvas',canvas)

class createboxfill(Module):
    """
			Function: createboxfill                # Construct a new boxfill graphics method

 Description of Function:
    Create a new boxfill graphics method given the the name and the existing
    boxfill graphics method to copy the attributes from. If no existing
    boxfill graphics method name is given, then the default boxfill graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:
    a=vcs.init()
    a.show('boxfill')
    box=a.createboxfill('example1',)
    a.show('boxfill')
    box=a.createboxfill('example2','quick')
    a.show('boxfill')

#########################################################################################################################
###########################################                               ###############################################
########################################## End createboxfill Description ################################################
#########################################                               #################################################
#########################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)
            
        source_GM_name = None
        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        gm = canvas.createboxfill(*args,**kwargs)
        self.setResult('boxfill', gm)
        self.setResult('canvas', canvas)

class createisofill(Module):
    """
			Function: createisofill  # Construct a new isofill graphics method

 Description of Function:
    Create a new isofill graphics method given the the name and the existing
    isofill graphics method to copy the attributes from. If no existing
    isofill graphics method name is given, then the default isofill graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:
    a=vcs.init()
    a.show('isofill')
    iso=a.createisofill('example1',)
    a.show('isofill')
    iso=a.createisofill('example2','quick')
    a.show('isofill')

#########################################################################################################################
###########################################                               ###############################################
########################################## End createisofill Description ################################################
#########################################                               #################################################
#########################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)

        source_GM_name = None
        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1
        res = canvas.createisofill(*args,**kwargs)
        self.setResult('isofill',res)
        self.setResult('canvas',canvas)

class createisoline(Module):
    """
			Function: createisoline                # Construct a new isoline graphics method

 Description of Function:
    Create a new isoline graphics method given the the name and the existing
    isoline graphics method to copy the attributes from. If no existing
    isoline graphics method name is given, then the default isoline graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:

    a=vcs.init()
    a.show('isoline')
    iso=a.createisoline('example1',)
    a.show('isoline')
    iso=a.createisoline('example2','quick')
    a.show('isoline')

#########################################################################################################################
###########################################                               ###############################################
########################################## End createisoline Description ################################################
#########################################                               #################################################
#########################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)
        source_GM_name = None

        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1
        res = canvas.createisoline(*args,**kwargs)
        self.setResult('isoline',res)
        self.setResult('canvas',canvas)

class createoutfill(Module):
    """
			Function: createoutfill                # Construct a new outfill graphics method

 Description of Function:
    Create a new outfill graphics method given the the name and the existing
    outfill graphics method to copy the attributes from. If no existing
    outfill graphics method name is given, then the default outfill graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:

    a=vcs.init()
    a.show('outfill')
    out=a.createoutfill('example1',)
    a.show('outfill')
    out=a.createoutfill('example2','quick')
    a.show('outfill')

#########################################################################################################################
###########################################                               ###############################################
########################################## End createoutfill Description ################################################
#########################################                               #################################################
#########################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
            
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)
        
        source_GM_name = None
        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1
        res = canvas.createoutfill(*args,**kwargs)
        self.setResult('outfill',res)
        self.setResult('canvas',canvas)

class createoutline(Module):
    """
			Function: createoutline                # Construct a new outline graphics method

 Description of Function:
    Create a new outline graphics method given the the name and the existing
    outline graphics method to copy the attributes from. If no existing
    outline graphics method name is given, then the default outline graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:

    a=vcs.init()
    a.show('outline')
    out=a.createoutline('example1',)
    a.show('outline')
    out=a.createoutline('example2','quick')
    a.show('outline')

#########################################################################################################################
###########################################                               ###############################################
########################################## End createoutline Description ################################################
#########################################                               #################################################
#########################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)
        source_GM_name = None

        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1
        res = canvas.createoutline(*args,**kwargs)
        self.setResult('outline',res)
        self.setResult('canvas',canvas)

class createscatter(Module):
    """
			Function: createscatter                # Construct a new scatter graphics method

 Description of Function:
    Create a new scatter graphics method given the the name and the existing
    scatter graphics method to copy the attributes from. If no existing
    scatter graphics method name is given, then the default scatter graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:
    a=vcs.init()
    a.show('scatter')
    sct=a.createscatter('example1',)
    a.show('scatter')
    sct=a.createscatter('example2','quick')
    a.show('scatter')

#########################################################################################################################
###########################################                               ###############################################
########################################## End createscatter Description ################################################
#########################################                               #################################################
#########################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)

        source_GM_name = None
        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1
        res = canvas.createscatter(*args,**kwargs)
        self.setResult('scatter',res)
        self.setResult('canvas',canvas)

class createxvsy(Module):
    """
			Function: createxvsy                      # Construct a new XvsY graphics method

 Description of Function:
    Create a new XvsY graphics method given the the name and the existing
    XvsY graphics method to copy the attributes from. If no existing
    XvsY graphics method name is given, then the default XvsY graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:
    a=vcs.init()
    a.show('xvsy')
    xy=a.createxvsy('example1',)
    a.show('xvsy')
    xy=a.createxvsy('example2','quick')
    a.show('xvsy')

######################################################################################################################
###########################################                            ###############################################
########################################## End createxvsy Description ################################################
#########################################                            #################################################
######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)
        source_GM_name = None

        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1
        res = canvas.createxvsy(*args,**kwargs)
        self.setResult('xvsy',res)
        self.setResult('canvas',canvas)

class createxyvsy(Module):
    """
			Function: createxyvsy                  # Construct a new Xyvsy graphics method

 Description of Function:
    Create a new Xyvsy graphics method given the the name and the existing
    Xyvsy graphics method to copy the attributes from. If no existing
    Xyvsy graphics method name is given, then the default Xyvsy graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:

    a=vcs.init()
    a.show('xyvsy')
    xyy=a.createxyvsy('example1',)
    a.show('xyvsy')
    xyy=a.createxyvsy('example2','quick')
    a.show('xyvsy')

#######################################################################################################################
###########################################                             ###############################################
########################################## End createxyvsy Description ################################################
#########################################                             #################################################
#######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)
        source_GM_name = None

        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1
        res = canvas.createxyvsy(*args,**kwargs)
        self.setResult('xyvsy',res)
        self.setResult('canvas',canvas)

class createyxvsx(Module):
    """
			Function: createyxvsx                  # Construct a new Yxvsx graphics method

 Description of Function:
    Create a new Yxvsx graphics method given the the name and the existing
    Yxvsx graphics method to copy the attributes from. If no existing
    Yxvsx graphics method name is given, then the default Yxvsx graphics
    method will be used as the graphics method to which the attributes will
    be copied from.

    If the name provided already exists, then a error will be returned. Graphics
    method names must be unique.

 Example of Use:

    a=vcs.init()
    a.show('yxvsx')
    yxx=a.createyxvsx('example1',)
    a.show('yxvsx')
    yxx=a.createyxvsx('example2','quick')
    a.show('yxvsx')

#######################################################################################################################
###########################################                             ###############################################
########################################## End createyxvsx Description ################################################
#########################################                             #################################################
#######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        new_GM_name = None
        if self.hasInputFromPort('new_GM_name'):
            new_GM_name = self.getInputFromPort('new_GM_name')
            args.append(new_GM_name)
        source_GM_name = None

        if self.hasInputFromPort('source_GM_name'):
            source_GM_name = self.getInputFromPort('source_GM_name')
            args.append(source_GM_name)

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
        self.setResult('slab_0_out', slab)            

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        #kwargs['bg'] = 1

        res = canvas.createyxvsx(*args,**kwargs)
        self.setResult('yxvsx',res)
        self.setResult('canvas',canvas)

class getboxfill(Module):
    """
			Function: getboxfill                        # Construct a new boxfill graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    boxfill class object from an existing VCS boxfill graphics method. If
    no boxfill name is given, then boxfill 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createboxfill function.)

 Example of Use:
    a=vcs.init()
    a.show('boxfill')                   # Show all the existing boxfill graphics methods
    box=a.getboxfill()                  # box instance of 'default' boxfill graphics
                                        # method
    box2=a.getboxfill('quick')          # box2 instance of existing 'quick' boxfill
                                        #         graphics method
######################################################################################################################
###########################################                            ###############################################
########################################## End getboxfill Description ################################################
#########################################                            #################################################
######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getboxfill(*args)
        self.setResult('boxfill',res)
        self.setResult('canvas',canvas)

class getisofill(Module):
    """
			Function: getisofill          Construct a new isofill graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    isofill class object from an existing VCS isofill graphics method. If
    no isofill name is given, then isofill 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createisofill function.)

 Example of Use:
    a=vcs.init()
    a.show('isofill')                   # Show all the existing isofill graphics methods
    iso=a.getisofill()                  # iso instance of 'default' isofill graphics
                                        #       method
    iso2=a.getisofill('quick')          # iso2 instance of existing 'quick' isofill
                                        #       graphics method
######################################################################################################################
###########################################                            ###############################################
########################################## End getisofill Description ################################################
#########################################                            #################################################
######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getisofill(*args)
        
        self.setResult('isofill',res)
        self.setResult('canvas',canvas)

class getisoline(Module):
    """
			Function: getisoline                        # Construct a new isoline graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    isoline class object from an existing VCS isoline graphics method. If
    no isoline name is given, then isoline 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createisoline function.)

 Example of Use:
    a=vcs.init()
    a.show('isoline')                   # Show all the existing isoline graphics methods
    iso=a.getisoline()                  # iso instance of 'default' isoline graphics
                                        #       method
    iso2=a.getisoline('quick')          # iso2 instance of existing 'quick' isoline
                                        #       graphics method
######################################################################################################################
###########################################                            ###############################################
########################################## End getisoline Description ################################################
#########################################                            #################################################
######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getisoline(*args)
        self.setResult('isoline',res)
        self.setResult('canvas',canvas)

class getoutfill(Module):
    """
			Function: getoutfill                        # Construct a new outfill graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    outfill class object from an existing VCS outfill graphics method. If
    no outfill name is given, then outfill 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createoutfill function.)

 Example of Use:
    a=vcs.init()
    a.show('outfill')                   # Show all the existing outfill graphics methods
    out=a.getoutfill()                  # out instance of 'default' outfill graphics
                                        #       method
    out2=a.getoutfill('quick')          # out2 instance of existing 'quick' outfill
                                        #       graphics method

######################################################################################################################
###########################################                            ###############################################
########################################## End getoutfill Description ################################################
#########################################                            #################################################
######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getoutfill(*args,**kwargs)
        self.setResult('outfill',res)
        self.setResult('canvas',canvas)

class getoutline(Module):
    """
			Function: getoutline                        # Construct a new outline graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    outline class object from an existing VCS outline graphics method. If
    no outline name is given, then outline 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createoutline function.)

 Example of Use:
    a=vcs.init()
    a.show('outline')                   # Show all the existing outline graphics methods
    out=a.getoutline()                  # out instance of 'default' outline graphics
                                        #       method
    out2=a.getoutline('quick')          # out2 instance of existing 'quick' outline
                                        #       graphics method

######################################################################################################################
###########################################                            ###############################################
########################################## End getoutline Description ################################################
#########################################                            #################################################
######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getoutline(*args)
        self.setResult('outline',res)
        self.setResult('canvas',canvas)

class getscatter(Module):
    """
			Function: getscatter                   # Construct a new scatter graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    scatter class object from an existing VCS scatter graphics method. If
    no scatter name is given, then scatter 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createscatter function.)

 Example of Use:
    a=vcs.init()
    a.show('scatter')                   # Show all the existing scatter graphics methods
    sct=a.getscatter()                  # sct instance of 'default' scatter graphics
                                        #       method
    sct2=a.getscatter('quick')          # sct2 instance of existing 'quick' scatter
                                        #       graphics method

######################################################################################################################
###########################################                            ###############################################
########################################## End getscatter Description ################################################
#########################################                            #################################################
######################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getscatter(*args)
        self.setResult('scatter',res)
        self.setResult('canvas',canvas)

class getxvsy(Module):
    """
			Function: getxvsy                   # Construct a new XvsY graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    XvsY class object from an existing VCS XvsY graphics method. If
    no XvsY name is given, then XvsY 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createxvsy function.)

 Example of Use:
    a=vcs.init()
    a.show('xvsy')                      # Show all the existing XvsY graphics methods
    xy=a.getxvsy()                      # xy instance of 'default' XvsY graphics
                                        #       method
    xy2=a.getxvsy('quick')              # xy2 instance of existing 'quick' XvsY
                                        #       graphics method

###################################################################################################################
###########################################                         ###############################################
########################################## End getxvsy Description ################################################
#########################################                         #################################################
###################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getxvsy(*args)
        self.setResult('xvsy',res)
        self.setResult('canvas',canvas)

class getxyvsy(Module):
    """
			Function: getxyvsy        # Construct a new Xyvsy graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    Xyvsy class object from an existing VCS Xyvsy graphics method. If
    no Xyvsy name is given, then Xyvsy 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createxyvsy function.)

 Example of Use:
    a=vcs.init()
    a.show('xyvsy')                     # Show all the existing Xyvsy graphics methods
    xyy=a.getxyvsy()                    # xyy instance of 'default' Xyvsy graphics
                                        #       method
    xyy2=a.getxyvsy('quick')            # xyy2 instance of existing 'quick' Xyvsy
                                        #       graphics method
####################################################################################################################
###########################################                          ###############################################
########################################## End getxyvsy Description ################################################
#########################################                          #################################################
####################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getxyvsy(*args)
        self.setResult('xyvsy',res)
        self.setResult('canvas',canvas)

class getyxvsx(Module):
    """
			Function: getyxvsx                     # Construct a new Yxvsx graphics method

 Description of Function:
    VCS contains a list of graphics methods. This function will create a
    Yxvsx class object from an existing VCS Yxvsx graphics method. If
    no Yxvsx name is given, then Yxvsx 'default' will be used.

    Note, VCS does not allow the modification of `default' attribute
    sets. However, a `default' attribute set that has been copied under a
    different name can be modified. (See the createyxvsx function.)

 Example of Use:
    a=vcs.init()
    a.show('yxvsx')                     # Show all the existing Yxvsx graphics methods
    yxx=a.getyxvsx()                    # yxx instance of 'default' Yxvsx graphics
                                        #       method
    yxx2=a.getyxvsx('quick')            # yxx2 instance of existing 'quick' Yxvsx
                                        #       graphics method
####################################################################################################################
###########################################                          ###############################################
########################################## End getyxvsx Description ################################################
#########################################                          #################################################
####################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        GM_name = None
        if self.hasInputFromPort('GM_name'):
            GM_name = self.getInputFromPort('GM_name')
            args.append(GM_name)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        res = canvas.getyxvsx(*args,**kwargs)
        self.setResult('yxvsx',res)
        self.setResult('canvas',canvas)

class isofill(Module,NotCacheable):
    """
			Function: isofill                        # Generate an isofill plot

 Description of Function:
    Generate a isofill plot given the data, isofill graphics method, and
    template. If no isofill class object is given, then the 'default' isofill
    graphics method is used. Similarly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('isofill')                   # Show all the existing isofill graphics methods
    iso=a.getisofill('quick')           # Create instance of 'quick'
    a.isofill(array,iso)                # Plot array using specified iso and default
                                        #       template
    a.clear()                           # Clear VCS canvas
    a.isofill(array,iso,template)       # Plot array using specified iso and template

###################################################################################################################
###########################################                         ###############################################
########################################## End isofill Description ################################################
#########################################                         #################################################
###################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
            
        args = []
        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
            args.append(slab)
            
        template = None
        if self.hasInputFromPort('template'):
            template = self.getInputFromPort('template')
            args.append(template)
        # template is a required port
        if template is None:
            raise ModuleError(self, "'template' is a mandatory port")

        args.append('Isofill')

        gm_name = None
        if self.hasInputFromPort('gm_name'):
            gm_name = self.getInputFromPort('gm_name')
            args.append(gm_name)
        # gm_name is a required port
        if gm_name is None:
            raise ModuleError(self, "'template' is a mandatory port")                    

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.isofill(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class isoline(Module,NotCacheable):
    """
			Function: isoline                        # Generate an isoline plot

 Description of Function:
    Generate a isoline plot given the data, isoline graphics method, and
    template. If no isoline class object is given, then the 'default' isoline
    graphics method is used. Similarly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('isoline')                   # Show all the existing isoline graphics methods
    iso=a.getisoline('quick')           # Create instance of 'quick'
    a.isoline(array,iso)                # Plot array using specified iso and default
                                        #       template
    a.clear()                           # Clear VCS canvas
    a.isoline(array,iso,template)       # Plot array using specified iso and template

###################################################################################################################
###########################################                         ###############################################
########################################## End isoline Description ################################################
#########################################                         #################################################
###################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
            
        args = []
        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
            args.append(slab)

        template = None
        if self.hasInputFromPort('template'):
            template = self.getInputFromPort('template')
            args.append(template)
        # template is a required port
        if template is None:
            raise ModuleError(self, "'template' is a mandatory port")

        args.append('Isoline')

        gm_name = None
        if self.hasInputFromPort('gm_name'):
            gm_name = self.getInputFromPort('gm_name')
            args.append(gm_name)
        # gm_name is a required port
        if gm_name is None:
            raise ModuleError(self, "'template' is a mandatory port")                    

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.isoline(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class outfill(Module):
    """
			Function: outfill                        # Generate an outfill plot

 Description of Function:
    Generate a outfill plot given the data, outfill graphics method, and
    template. If no outfill class object is given, then the 'default' outfill
    graphics method is used. Simerly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('outfill')                   # Show all the existing outfill graphics methods
    out=a.getoutfill('quick')           # Create instance of 'quick'
    a.outfill(array,out)                # Plot array using specified out and default
                                        #       template
    a.clear()                           # Clear VCS canvas
    a.outfill(array,out,template)       # Plot array using specified out and template

###################################################################################################################
###########################################                         ###############################################
########################################## End outfill Description ################################################
#########################################                         #################################################
###################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()

        args = []
        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
            args.append(slab)

        template = None
        if self.hasInputFromPort('template'):
            template = self.getInputFromPort('template')
            args.append(template)
        # template is a required port
        if template is None:
            raise ModuleError(self, "'template' is a mandatory port")

        args.append('Outfill')

        gm_name = None
        if self.hasInputFromPort('gm_name'):
            gm_name = self.getInputFromPort('gm_name')
            args.append(gm_name)
        # gm_name is a required port
        if gm_name is None:
            raise ModuleError(self, "'template' is a mandatory port")                    

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.outfill(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class outline(Module):
    """
			Function: outline                        # Generate an outline plot

 Description of Function:
    Generate a outline plot given the data, outline graphics method, and
    template. If no outline class object is given, then the 'default' outline
    graphics method is used. Simerly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('outline')                   # Show all the existing outline graphics methods
    out=a.getoutline('quick')           # Create instance of 'quick'
    a.outline(array,out)                # Plot array using specified out and default
                                        #       template
    a.clear()                           # Clear VCS canvas
    a.outline(array,out,template)       # Plot array using specified out and template

###################################################################################################################
###########################################                         ###############################################
########################################## End outline Description ################################################
#########################################                         #################################################
###################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []

        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
            args.append(slab)

        template = None
        if self.hasInputFromPort('template'):
            template = self.getInputFromPort('template')
            args.append(template)
        # template is a required port
        if template is None:
            raise ModuleError(self, "'template' is a mandatory port")

        args.append('Outline')

        gm_name = None
        if self.hasInputFromPort('gm_name'):
            gm_name = self.getInputFromPort('gm_name')
            args.append(gm_name)
        # gm_name is a required port
        if gm_name is None:
            raise ModuleError(self, "'template' is a mandatory port")                    

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.outline(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class plot(SpreadsheetCell,NotCacheable):
    """
			Function: plot

 Description of plot:
    Plot an array(s) of data given a template and graphics method. The VCS template is
    used to define where the data and variable attributes will be displayed on the VCS
    Canvas. The VCS graphics method is used to define how the array(s) will be shown
    on the VCS Canvas.

 The form of the call is:
    plot(array1=None, array2=None, template_name=None, graphics_method=None,
            graphics_name=None, [key=value [, key=value [, ...]]])

            where array1 and array2 are NumPy arrays.

    Plot keywords:
      ratio [default is none]
            None: let the self.ratio attribute decide
            0,'off': overwritte self.ratio and do nothing about the ratio
            'auto': computes an automatic ratio
            '3',3: y dim will be 3 times bigger than x dim (restricted to original tempalte.data area
            Adding a 't' at the end of the ratio, makes the tickmarks and boxes move along.

    Variable attribute keys:
       comment1         = string   #Comment plotted above file_comment
       comment2         = string   #Comment plotted above comment1
       comment3         = string   #Comment plotted above comment2
       comment4         = string   #Comment plotted above comment4
       file_comment     = string   #Comment (defaults to file.comment)
       hms              = string (hh:mm:ss) #Hour, minute, second
       long_name        = string   #Descriptive variable name
       name             = string   #Variable name (defaults to var.id)
       time             = cdtime   #instance (relative or absolute),
                                    cdtime, reltime or abstime value
       units            = string   #Variable units
       ymd              = string (yy/mm/dd) #Year, month, day

    Dimension attribute keys (dimension length=n):
       [x|y|z|t|w]array = NumPy array of length n    # x or y Dimension values
       [x|y|z|t|w]array = NumPy array of length n    # x or y Dimension values
       [x|y]bounds       = NumPy array of shape (n,2) # x or y Dimension boundaries
       [x|y|z|t|w]name   = string                     # x or y Dimension name
       [x|y|z|t|w]units  = string                     # x or y Dimension units
       [x|y]weights      = NumPy array of length n    # x or y Dimension weights (used to
                                                        calculate area-weighted mean)

    CDMS object:
       [x|y|z|t|w]axis   = CDMS axis object           # x or y Axis
       grid              = CDMS grid object           # Grid object (e.g. grid=var.getGrid()
       variable          = CDMS variable object       # Variable object

    Other:
       [x|y]rev         = 0|1                         # if ==1, reverse the direction of the x
    							     or y axis
       continents	= 0,1,2,3,4,5,6,7,8,9,10,11   #	if >=1, plot continental outlines
    							     (default: plot if xaxis is
    							     longitude, yaxis is latitude -or-
    							     xname is 'longitude' and yname is
    							     'latitude'
                                                      # The continents-type values are integers
						      # ranging from 0 to 11, where:
						      #    0 signifies "No Continents"
						      #    1 signifies "Fine Continents"
						      #    2 signifies "Coarse Continents"
						      #    3 signifies "United States"
						      #    4 signifies "Political Borders"
						      #    5 signifies "Rivers"

						      # Values 6 through 11 signify the line type
                                                      # defined by the files data_continent_other7
                                                      # through data_continent_other12.

    Graphics Output in Background Mode:
       bg                 = 0|1   # if ==1, create images in the background
                                                             (Don't display the VCS Canvas)

 Note:
    More specific attributes take precedence over general attributes. In particular,
    specifie attributes override variable object attributes, dimension attributes and
    arrays override axis objects, which override grid objects, which override variable
    objects.

    For example, if both 'file_comment' and 'variable' keywords are specified, the value of
    'file_comment' is used instead of the file comment in the parent of variable. Similarly,
    if both 'xaxis' and 'grid' keywords are specified, the value of 'xaxis' takes precedence
    over the x-axis of grid.

 Example of Use:
    x=vcs.init()        # x is an instance of the VCS class object (constructor)
    x.plot(array)       # this call will use default settings for template and boxfill
    x.plot(array, 'AMIP', 'isofill','AMIP_psl') # this is specifying the template and
                                                  graphics method
    t=x.gettemplate('AMIP')        # get a predefined the template 'AMIP'
    vec=x.getvector('quick')       # get a predefined the vector graphics method 'quick'
    x.plot(array1, array2, t, vec) # plot the data as a vector using the 'AMIP' template
    x.clear()                      # clear the VCS Canvas of all plots
    box=x.createboxfill('new')     # create boxfill graphics method 'new'
    x.plot(box,t,array)            # plot array data using box 'new' and template 't'

###############################################################################################################
###########################################                      ##############################################
########################################## End plot Description ###############################################
#########################################                      ################################################
###############################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
            
        # Build up the argument list
        args = []
        slab2 = None
        if self.hasInputFromPort('slab2_0'):
            slab2 = self.getInputFromPort('slab2_0')
            args.append(slab2)
        slab1 = None
        if self.hasInputFromPort('slab1_0'):
            slab1 = self.getInputFromPort('slab1_0')
            args.append(slab1)
        template = None
        if self.hasInputFromPort('template'):
            template = self.getInputFromPort('template')
            args.append(template)
        plot_type = None
        if self.hasInputFromPort('plot_type'):
            plot_type = self.getInputFromPort('plot_type')
            args.append(plot_type)
        gm_name = None
        if self.hasInputFromPort('gm_name'):
            gm_name = self.getInputFromPort('gm_name')
            args.append(gm_name)

        # slab1 is a required port
        if slab1 is None:
            raise ModuleError(self, "'slab1' is a mandatory port")
        # template is a required port
        if template is None:
            raise ModuleError(self, "'template' is a mandatory port")
        # plot_type is a required port
        if plot_type is None:
            raise ModuleError(self, "'plot_type' is a mandatory port")
        # gm_name is a required port
        if gm_name is None:
            raise ModuleError(self, "'gm_name' is a mandatory port")
        
        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')

        # Set the cell row / col
        self.location = CellLocation()
        if self.hasInputFromPort('row'):
            self.location.row = self.getInputFromPort('row')
        if self.hasInputFromPort('col'):
            self.location.col = self.getInputFromPort('col')            

        # Plot into the cell
        inputPorts = (canvas, args, kwargs)
        self.displayAndWait(QCDATWidget, inputPorts)
        
        self.setResult('canvas',canvas)

class scatter(Module):
    """
			Function: scatter                      # Generate a scatter plot

 Description of Function:
    Generate a scatter plot given the data, scatter graphics method, and
    template. If no scatter class object is given, then the 'default' scatter
    graphics method is used. Similarly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('scatter')                   # Show all the existing scatter graphics methods
    sct=a.getscatter('quick')           # Create instance of 'quick'
    a.scatter(array,sct)                # Plot array using specified sct and default
                                        #       template
    a.clear()                           # Clear VCS canvas
    a.scatter(array,sct,template)       # Plot array using specified sct and template

###################################################################################################################
###########################################                         ###############################################
########################################## End scatter Description ################################################
#########################################                         #################################################
###################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        slab2 = None
        if self.hasInputFromPort('slab2_0'):
            slab2 = self.getInputFromPort('slab2_0')
            args.append(slab2)
        slab1 = None
        if self.hasInputFromPort('slab1_0'):
            slab1 = self.getInputFromPort('slab1_0')
            args.append(slab1)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.scatter(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class xvsy(Module):
    """
			Function: xvsy                      # Generate a XvsY plot

 Description of Function:
    Generate a XvsY plot given the data, XvsY graphics method, and
    template. If no XvsY class object is given, then the 'default' XvsY
    graphics method is used. Similarly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('xvsy')                   # Show all the existing XvsY graphics methods
    xy=a.getxvsy('quick')            # Create instance of 'quick'
    a.xvsy(array,xy)                 # Plot array using specified xy and default
                                     #       template
    a.clear()                        # Clear VCS canvas
    a.xvsy(array,xy,template)        # Plot array using specified xy and template

#################################################################################################################
###########################################                       ###############################################
########################################## End xvsy Description ################################################
#########################################                       #################################################
#################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        slab2 = None
        if self.hasInputFromPort('slab2_0'):
            slab2 = self.getInputFromPort('slab2_0')
            args.append(slab2)
        slab1 = None
        if self.hasInputFromPort('slab1_0'):
            slab1 = self.getInputFromPort('slab1_0')
            args.append(slab1)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('yaxisconvert'):
            kwargs['yaxisconvert'] = self.getInputFromPort('yaxisconvert')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.xvsy(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class xyvsy(Module):
    """
			Function: xyvsy                        # Generate a Xyvsy plot

 Description of Function:
    Generate a Xyvsy plot given the data, Xyvsy graphics method, and
    template. If no Xyvsy class object is given, then the 'default' Xyvsy
    graphics method is used. Simerly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('xyvsy')                   # Show all the existing Xyvsy graphics methods
    xyy=a.getxyvsy('quick')           # Create instance of 'quick'
    a.xyvsy(array,xyy)                # Plot array using specified xyy and default
                                        #       template
    a.clear()                           # Clear VCS canvas
    a.xyvsy(array,xyy,template)       # Plot array using specified xyy and template

#################################################################################################################
###########################################                       ###############################################
########################################## End xyvsy Description ################################################
#########################################                       #################################################
#################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
            args.append(slab)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.xyvsy(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class yxvsx(Module):
    """
			Function: yxvsx                        # Generate a Yxvsx plot

 Description of Function:
    Generate a Yxvsx plot given the data, Yxvsx graphics method, and
    template. If no Yxvsx class object is given, then the 'default' Yxvsx
    graphics method is used. Simerly, if no template class object is given,
    then the 'default' template is used.

 Example of Use:
    a=vcs.init()
    a.show('yxvsx')                   # Show all the existing Yxvsx graphics methods
    yxx=a.getyxvsx('quick')           # Create instance of 'quick'
    a.yxvsx(array,yxx)                # Plot array using specified yxx and default
                                      #       template
    a.clear()                         # Clear VCS canvas
    a.yxvsx(array,yxx,template)       # Plot array using specified yxx and template

#################################################################################################################
###########################################                       ###############################################
########################################## End yxvsx Description ################################################
#########################################                       #################################################
#################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        slab = None
        if self.hasInputFromPort('slab_0'):
            slab = self.getInputFromPort('slab_0')
            args.append(slab)

        # build up the keyword arguments from the optional inputs.
        kwargs = {}
        if self.hasInputFromPort('datawc_timeunits'):
            kwargs['datawc_timeunits'] = self.getInputFromPort('datawc_timeunits')
        if self.hasInputFromPort('long_name'):
            kwargs['long_name'] = self.getInputFromPort('long_name')
        if self.hasInputFromPort('projection_0'):
            kwargs['projection'] = self.getInputFromPort('projection_0')
        if self.hasInputFromPort('xticlabels2_0'):
            kwargs['xticlabels2'] = self.getInputFromPort('xticlabels2_0')
        if self.hasInputFromPort('xarray_0'):
            kwargs['xarray'] = self.getInputFromPort('xarray_0')
        if self.hasInputFromPort('yweights_0'):
            kwargs['yweights'] = self.getInputFromPort('yweights_0')
        if self.hasInputFromPort('xweights_0'):
            kwargs['xweights'] = self.getInputFromPort('xweights_0')
        if self.hasInputFromPort('warray_0'):
            kwargs['warray'] = self.getInputFromPort('warray_0')
        if self.hasInputFromPort('tunits'):
            kwargs['tunits'] = self.getInputFromPort('tunits')
        if self.hasInputFromPort('ymtics1_0'):
            kwargs['ymtics1'] = self.getInputFromPort('ymtics1_0')
        if self.hasInputFromPort('ymtics2_0'):
            kwargs['ymtics2'] = self.getInputFromPort('ymtics2_0')
        if self.hasInputFromPort('datawc_x1'):
            kwargs['datawc_x1'] = self.getInputFromPort('datawc_x1')
        if self.hasInputFromPort('datawc_x2'):
            kwargs['datawc_x2'] = self.getInputFromPort('datawc_x2')
        if self.hasInputFromPort('continents'):
            kwargs['continents'] = self.getInputFromPort('continents')
        if self.hasInputFromPort('xmtics1_0'):
            kwargs['xmtics1'] = self.getInputFromPort('xmtics1_0')
        if self.hasInputFromPort('xmtics2_0'):
            kwargs['xmtics2'] = self.getInputFromPort('xmtics2_0')
        if self.hasInputFromPort('xbounds_0'):
            kwargs['xbounds'] = self.getInputFromPort('xbounds_0')
        if self.hasInputFromPort('ybounds_0'):
            kwargs['ybounds'] = self.getInputFromPort('ybounds_0')
        if self.hasInputFromPort('datawc_y2'):
            kwargs['datawc_y2'] = self.getInputFromPort('datawc_y2')
        if self.hasInputFromPort('wname'):
            kwargs['wname'] = self.getInputFromPort('wname')
        if self.hasInputFromPort('file_comment'):
            kwargs['file_comment'] = self.getInputFromPort('file_comment')
        if self.hasInputFromPort('datawc_calendar'):
            kwargs['datawc_calendar'] = self.getInputFromPort('datawc_calendar')
        if self.hasInputFromPort('wunits'):
            kwargs['wunits'] = self.getInputFromPort('wunits')
        if self.hasInputFromPort('xrev'):
            kwargs['xrev'] = self.getInputFromPort('xrev')
        if self.hasInputFromPort('ymd'):
            kwargs['ymd'] = self.getInputFromPort('ymd')
        if self.hasInputFromPort('yarray_0'):
            kwargs['yarray'] = self.getInputFromPort('yarray_0')
        if self.hasInputFromPort('units'):
            kwargs['units'] = self.getInputFromPort('units')
        if self.hasInputFromPort('yunits'):
            kwargs['yunits'] = self.getInputFromPort('yunits')
        if self.hasInputFromPort('zarray_0'):
            kwargs['zarray'] = self.getInputFromPort('zarray_0')
        if self.hasInputFromPort('xname'):
            kwargs['xname'] = self.getInputFromPort('xname')
        if self.hasInputFromPort('tarray_0'):
            kwargs['tarray'] = self.getInputFromPort('tarray_0')
        if self.hasInputFromPort('bg_0'):
            kwargs['bg'] = self.getInputFromPort('bg_0')
        elif self.hasInputFromPort('bg_1'):
            kwargs['bg'] = self.getInputFromPort('bg_1')
        if self.hasInputFromPort('xaxisconvert'):
            kwargs['xaxisconvert'] = self.getInputFromPort('xaxisconvert')
        if self.hasInputFromPort('zname'):
            kwargs['zname'] = self.getInputFromPort('zname')
        if self.hasInputFromPort('hms'):
            kwargs['hms'] = self.getInputFromPort('hms')
        if self.hasInputFromPort('tname'):
            kwargs['tname'] = self.getInputFromPort('tname')
        if self.hasInputFromPort('yname'):
            kwargs['yname'] = self.getInputFromPort('yname')
        if self.hasInputFromPort('ratio_0'):
            kwargs['ratio'] = self.getInputFromPort('ratio_0')
        elif self.hasInputFromPort('ratio_1'):
            kwargs['ratio'] = self.getInputFromPort('ratio_1')
        if self.hasInputFromPort('datawc_y1'):
            kwargs['datawc_y1'] = self.getInputFromPort('datawc_y1')
        if self.hasInputFromPort('xunits'):
            kwargs['xunits'] = self.getInputFromPort('xunits')
        if self.hasInputFromPort('name'):
            kwargs['name'] = self.getInputFromPort('name')
        if self.hasInputFromPort('yticlabels1_0'):
            kwargs['yticlabels1'] = self.getInputFromPort('yticlabels1_0')
        if self.hasInputFromPort('yticlabels2_0'):
            kwargs['yticlabels2'] = self.getInputFromPort('yticlabels2_0')
        if self.hasInputFromPort('comment1'):
            kwargs['comment1'] = self.getInputFromPort('comment1')
        if self.hasInputFromPort('zunits'):
            kwargs['zunits'] = self.getInputFromPort('zunits')
        if self.hasInputFromPort('comment3'):
            kwargs['comment3'] = self.getInputFromPort('comment3')
        if self.hasInputFromPort('comment2'):
            kwargs['comment2'] = self.getInputFromPort('comment2')
        if self.hasInputFromPort('xticlabels1_0'):
            kwargs['xticlabels1'] = self.getInputFromPort('xticlabels1_0')
        if self.hasInputFromPort('comment4'):
            kwargs['comment4'] = self.getInputFromPort('comment4')
        if self.hasInputFromPort('yrev'):
            kwargs['yrev'] = self.getInputFromPort('yrev')
        #force images to be created in the background
        kwargs['bg'] = 1
        res = canvas.yxvsx(*args,**kwargs)
        self.setResult('display',res)
        self.setResult('canvas',canvas)

class png(Module,NotCacheable):
    """
			Function: png

 Description of Function:
    Png output is another form of raster graphics.

 Example of Use:
    a=vcs.init()
    a.plot(array)
    a.png('example')       # Overwrite a png file
    a.png('example', width=11.5, height= 8.5)  # US Legal
    a.png('example', width=21, height=29.7, units='cm')  # A4
#################################################################################################################
###########################################                       ###############################################
########################################## End png Description ################################################
#########################################                       #################################################
#################################################################################################################
		
    """
    def compute(self):
        if self.hasInputFromPort('canvas'):
            canvas = self.getInputFromPort('canvas')
        else:
            canvas = vcs.init()
        args = []
        file = None
        if self.hasInputFromPort('file'):
            file = self.getInputFromPort('file')
            args.append(file)

        # file is a required port
        if file is None:
            raise ModuleError(self, "'file' is a mandatory port")
        width = None
        if self.hasInputFromPort('width'):
            width = self.getInputFromPort('width')
            args.append(width)
        height = None
        if self.hasInputFromPort('height'):
            height = self.getInputFromPort('height')
            args.append(height)
        units = None
        if self.hasInputFromPort('units'):
            units = self.getInputFromPort('units')
            args.append(units)
        ofile = core.modules.basic_modules.File()
        ofile.name = file
        canvas.png(*args)
        self.setResult('file',ofile)

class open(Module):
    """
        Function: open     # Open an existing dataset

Description of Function:
    'uri' is a Uniform Resource Identifier, referring to a cdunif file, XML file,
    or LDAP URL of a catalog dataset entry.
    'mode' is 'r', 'r+', 'a', or 'w'
###################################################################################################################
###########################################                         ###############################################
########################################## End open Description ################################################
#########################################                         #################################################
###################################################################################################################
    
    """
    def compute(self):
        args = []
        uri = None
        if self.hasInputFromPort('uri'):
            uri = self.getInputFromPort('uri')
            args.append(uri)

        # uri is a required port
        if uri is None:
            raise ModuleError(self, "'uri' is a mandatory port")
        mode = None
        if self.hasInputFromPort('mode'):
            mode = self.getInputFromPort('mode')
            args.append(mode)
        template = None
        if self.hasInputFromPort('template'):
            template = self.getInputFromPort('template')
            args.append(template)
        dods = None
        if self.hasInputFromPort('dods'):
            dods = self.getInputFromPort('dods')
            args.append(dods)
        res = cdms2.open(*args)
        self.setResult('dataset',res)

class __call__(Module):
    """
        Function: __call__     # Call a variable object with the given id

Description of Function:
    Call a variable object with the given id
    Exception if not found.
    Call the variable with the other arguments.
###################################################################################################################
###########################################                         ###############################################
########################################## End _call_ Description ################################################
#########################################                         #################################################
###################################################################################################################
    
    """
    def compute(self):
        # Check ports
        if not self.hasInputFromPort('cdmsfile'):
            raise ModuleError(self, "'cdmsfile' is mandatory.")
        if not self.hasInputFromPort('type'):
            raise ModuleError(self, "'type' is mandatory.")
        if not self.hasInputFromPort('id'):
            raise ModuleError(self, "'id' is mandatory.")        
        if not self.hasInputFromPort('axes'):
            raise ModuleError(self, "'axes' is mandatory.")
        if not self.hasInputFromPort('axesOperations'):
            raise ModuleError(self, "'axesOperations' is mandatory.")

        # Get input from ports
        cdmsfile = self.getInputFromPort('cdmsfile')
        varType = self.getInputFromPort('type')
        id = self.getInputFromPort('id')
        axes = self.getInputFromPort('axes')
        axesOperations = self.getInputFromPort('axesOperations')                

        # Get the variable
        if (varType == 'variable'):
            var = cdmsfile.__call__(id)
        elif (varType == 'axis'):
            varID = self.getAxisID(id)            
            axis = getattr(cdmsfile, 'axes')[varID]
            var = MV2.array(axis)
            var.setAxis(0, axis)
        elif (varType == 'weighted-axis'):
            varID, axisID = self.getVarAndAxisID(id)
            var = cdmsfile.__call__(varID)            
            var = genutil.getAxisWeightByName(var, axisID)
            var.id = varID +'_' + axisID + '_weight'
        else:
            var = None

        # Get the updated variable
        if axes is not None and var is not None:
            try:
                kwargs = eval(axes)
                var = var(**kwargs)
            except:
                raise ModuleError(self, "Invalid 'axes' specification", axes)

        # Apply axes ops to the variable
        var = self.applyAxesOperations(var, axesOperations)

        self.setResult('variable', var)

    def applyAxesOperations(self, var, axesOperations):
        """ Apply kwargs / axis operations to update the dataset """
        try:
            axesOperations = eval(axesOperations)
        except:
            raise TypeError("Invalid string 'axesOperations'")

        for axis in list(axesOperations):
            if axesOperations[axis] == 'sum':
                var = cdutil.averager(var, axis="(%s)" % axis, weight='equal',
                                      action='sum')
            elif axesOperations[axis] == 'avg':
                var = cdutil.averager(var, axis="(%s)" % axis, weight='equal')
            elif axesOperations[axis] == 'wgt':
                var = cdutil.averager(var, axis="(%s)" % axis)
            elif axesOperations[axis] == 'gtm':
                var = genutil.statistics.geometricmean(var, axis="(%s)" % axis)
            elif axesOperations[axis] == 'std':
                var = genutil.statistics.std(var, axis="(%s)" % axis)                
                
        return var

    def getVarAndAxisID(self, varID):
        """ get the varID and axisID from a string with format
        varID_axisID_weight """
        
        match = re.compile('(.+)(_)(.+)(_)(weight)').match(varID)
        if match:
            return (match.group(1), match.group(3))

        return None

    def getAxisID(self, varID):
        """ get the axisID from a string with format varID_axisID_axis """

        match = re.compile('(.+)(_)(.+)(_)(axis)').match(varID)
        if match:
            return match.group(3)

        return varID

def initialize(*args, **keywords):
    reg = core.modules.module_registry.get_module_registry()

    reg.add_module(Canvas,namespace='vcs|Canvas')
    reg.add_module(GSp,namespace='vcs|scatter')
    reg.add_module(CdmsFile,namespace='cdms2|dataset')
    reg.add_module(TransientVariable,namespace='cdms2|tvariable')
    reg.add_module(GXy,namespace='vcs|xyvsy')
    reg.add_module(Go,namespace='vcs|outline')
    reg.add_module(Gfi,namespace='vcs|isofill')
    reg.add_module(Dp,namespace='vcs|displayplot')
    reg.add_module(Gfb,namespace='vcs|boxfill')
    reg.add_module(GYx,namespace='vcs|yxvsx')
    reg.add_module(GXY,namespace='vcs|xvsy')
    reg.add_module(Gi,namespace='vcs|isoline')
    reg.add_module(Gfo,namespace='vcs|outfill')

    
    ##########################################################################
    # included from cdatwindow_init_inc.py
    #display = sip.unwrapinstance(QtGui.QX11Info.display())
    #vcs._vcs.setdisplay(display)

    #cdat GUI modules
    global cdatWindow
    cdatWindow = QCDATWindow()
    cdatWindow.show()


    reg.add_module(CDATCell,namespace='cdat')
    reg.add_input_port(CDATCell, 'slab1',
                       (TransientVariable, "variable to be plotted"))
    reg.add_input_port(CDATCell, 'slab2',
                       (TransientVariable, "variable to be plotted"))    
    reg.add_input_port(CDATCell, 'plotType',
                       (core.modules.basic_modules.String, "Plot type"))
    reg.add_input_port(CDATCell, 'template',
                       (core.modules.basic_modules.String, "template name"))
    reg.add_input_port(CDATCell, 'gmName',
                       (core.modules.basic_modules.String, "graphics method name"))    
    reg.add_input_port(CDATCell, 'canvas',
                       (Canvas, "Canvas object"))
    reg.add_input_port(CDATCell, 'col',
                       (core.modules.basic_modules.Integer, "Cell Col"))
    reg.add_input_port(CDATCell, 'row',
                       (core.modules.basic_modules.Integer, "Cell Row"))
    reg.add_input_port(CDATCell, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)    
    reg.add_output_port(CDATCell, 'canvas', 
                       (Canvas, ""), True)    

    reg.add_module(Variable, namespace='cdat')
    reg.add_module(Quickplot, namespace='cdat')    
    reg.add_input_port(Variable, 'id', 
                       (core.modules.basic_modules.String,
                        ""))
    reg.add_input_port(Variable, 'type', 
                       (core.modules.basic_modules.String,
                        "variable, axis, or weighted-axis"))
    reg.add_input_port(Variable, 'inputVariable', 
                       (core.modules.basic_modules.List,
                        ""))
    reg.add_output_port(Variable, 'variable', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        ""))
    reg.add_input_port(Variable, 'axes',
                       (core.modules.basic_modules.String, "Axes of variables"))    
    reg.add_input_port(Variable, 'axesOperations',
                       (core.modules.basic_modules.String, "Axes Operations"))
    reg.add_input_port(Variable, 'cdmsfile', 
                       (CdmsFile, "cdmsfile"))    

    reg.add_module(GraphicsMethod, namespace='cdat')
    reg.add_input_port(GraphicsMethod, 'gmName', 
                       (core.modules.basic_modules.String,
                        "Get the graphics method object of the given name."))
    reg.add_input_port(GraphicsMethod, 'plotType',
                       (core.modules.basic_modules.String, "Plot type"))    
    reg.add_input_port(GraphicsMethod, 'slab1', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "slab1"))
    reg.add_input_port(GraphicsMethod, 'slab2', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "slab2"))
    reg.add_input_port(GraphicsMethod, 'color_1',
                       (core.modules.basic_modules.Integer, "color_1"), True)
    reg.add_input_port(GraphicsMethod, 'color_2',
                       (core.modules.basic_modules.Integer, "color_2"), True)
    reg.add_input_port(GraphicsMethod, 'level_1',
                       (core.modules.basic_modules.Float, "level_1"), True)
    reg.add_input_port(GraphicsMethod, 'level_2',
                       (core.modules.basic_modules.Float, "level_2"), True)        
    reg.add_output_port(GraphicsMethod, 'slab1', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "slab1"))
    reg.add_output_port(GraphicsMethod, 'slab2', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "slab2"))            
    reg.add_output_port(GraphicsMethod, 'canvas', (Canvas, "Canvas object"))
    
    # end of cdatwindow_init_inc.py
    ##########################################################################
    
    
    #Module boxfill
    reg.add_module(boxfill,namespace='vcs|Canvas')
    reg.add_input_port(boxfill, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_input_port(boxfill, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(boxfill, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))
    reg.add_input_port(boxfill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(boxfill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(boxfill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(boxfill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(boxfill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(boxfill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(boxfill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(boxfill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(boxfill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(boxfill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(boxfill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(boxfill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(boxfill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(boxfill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(boxfill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(boxfill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(boxfill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(boxfill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(boxfill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(boxfill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(boxfill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(boxfill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(boxfill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(boxfill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(boxfill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(boxfill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(boxfill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(boxfill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(boxfill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(boxfill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(boxfill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(boxfill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(boxfill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(boxfill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(boxfill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(boxfill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(boxfill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(boxfill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(boxfill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(boxfill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(boxfill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(boxfill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(boxfill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(boxfill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(boxfill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(boxfill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(boxfill, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))
    
    #Module createboxfill
    reg.add_module(createboxfill,namespace='vcs|Canvas')
    reg.add_input_port(createboxfill, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createboxfill, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))        
    reg.add_input_port(createboxfill, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createboxfill, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createboxfill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createboxfill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createboxfill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createboxfill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createboxfill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createboxfill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createboxfill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createboxfill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createboxfill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createboxfill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createboxfill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createboxfill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createboxfill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createboxfill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createboxfill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createboxfill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createboxfill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createboxfill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createboxfill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createboxfill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createboxfill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createboxfill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createboxfill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createboxfill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createboxfill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createboxfill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createboxfill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createboxfill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createboxfill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createboxfill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createboxfill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createboxfill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createboxfill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createboxfill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createboxfill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createboxfill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createboxfill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createboxfill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createboxfill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createboxfill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createboxfill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createboxfill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createboxfill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createboxfill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createboxfill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createboxfill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createboxfill, 'boxfill', 
                       (get_late_type('vcs.boxfill.Gfb'),
                        "no default"))

    #Module createisofill
    reg.add_module(createisofill,namespace='vcs|Canvas')
    reg.add_input_port(createisofill, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createisofill, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createisofill, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createisofill, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))            
    reg.add_input_port(createisofill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createisofill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createisofill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createisofill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createisofill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createisofill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createisofill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createisofill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createisofill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createisofill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createisofill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createisofill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createisofill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createisofill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createisofill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createisofill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createisofill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createisofill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createisofill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createisofill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createisofill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createisofill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createisofill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createisofill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createisofill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createisofill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createisofill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createisofill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createisofill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createisofill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createisofill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createisofill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createisofill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createisofill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createisofill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createisofill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createisofill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createisofill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createisofill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createisofill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createisofill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createisofill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createisofill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createisofill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createisofill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createisofill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createisofill, 'isofill', 
                       (get_late_type('vcs.isofill.Gfi'),
                        "no default"))

    #Module createisoline
    reg.add_module(createisoline,namespace='vcs|Canvas')
    reg.add_input_port(createisoline, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createisoline, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createisoline, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createisoline, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))            
    reg.add_input_port(createisoline, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createisoline, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createisoline, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createisoline, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createisoline, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createisoline, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createisoline, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createisoline, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createisoline, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createisoline, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createisoline, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createisoline, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createisoline, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createisoline, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createisoline, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createisoline, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createisoline, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createisoline, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createisoline, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createisoline, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createisoline, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createisoline, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createisoline, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createisoline, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createisoline, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createisoline, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createisoline, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createisoline, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createisoline, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createisoline, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createisoline, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createisoline, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createisoline, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createisoline, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createisoline, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createisoline, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createisoline, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createisoline, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createisoline, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createisoline, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createisoline, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createisoline, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createisoline, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createisoline, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createisoline, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createisoline, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createisoline, 'isoline', 
                       (get_late_type('vcs.isoline.Gi'),
                        "no default"))

    #Module createoutfill
    reg.add_module(createoutfill,namespace='vcs|Canvas')
    reg.add_input_port(createoutfill, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createoutfill, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createoutfill, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createoutfill, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))        
    reg.add_input_port(createoutfill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createoutfill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createoutfill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createoutfill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createoutfill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createoutfill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createoutfill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createoutfill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createoutfill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createoutfill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createoutfill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createoutfill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createoutfill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createoutfill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createoutfill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createoutfill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createoutfill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createoutfill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createoutfill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createoutfill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createoutfill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createoutfill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createoutfill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createoutfill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createoutfill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createoutfill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createoutfill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createoutfill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createoutfill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createoutfill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createoutfill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createoutfill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createoutfill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createoutfill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createoutfill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createoutfill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createoutfill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createoutfill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createoutfill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createoutfill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createoutfill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createoutfill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createoutfill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createoutfill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createoutfill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createoutfill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createoutfill, 'outfill', 
                       (get_late_type('vcs.outfill.Gfo'),
                        "no default"))

    #Module createoutline
    reg.add_module(createoutline,namespace='vcs|Canvas')
    reg.add_input_port(createoutline, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createoutline, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createoutline, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createoutline, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))        
    reg.add_input_port(createoutline, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createoutline, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createoutline, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createoutline, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createoutline, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createoutline, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createoutline, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createoutline, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createoutline, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createoutline, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createoutline, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createoutline, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createoutline, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createoutline, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createoutline, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createoutline, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createoutline, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createoutline, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createoutline, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createoutline, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createoutline, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createoutline, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createoutline, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createoutline, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createoutline, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createoutline, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createoutline, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createoutline, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createoutline, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createoutline, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createoutline, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createoutline, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createoutline, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createoutline, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createoutline, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createoutline, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createoutline, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createoutline, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createoutline, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createoutline, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createoutline, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createoutline, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createoutline, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createoutline, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createoutline, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createoutline, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createoutline, 'outline', 
                       (get_late_type('vcs.outline.Go'),
                        "no default"))

    #Module createscatter
    reg.add_module(createscatter,namespace='vcs|Canvas')
    reg.add_input_port(createscatter, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createscatter, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createscatter, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createscatter, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))            
    reg.add_input_port(createscatter, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createscatter, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createscatter, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createscatter, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createscatter, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createscatter, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createscatter, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createscatter, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createscatter, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createscatter, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createscatter, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createscatter, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createscatter, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createscatter, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createscatter, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createscatter, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createscatter, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createscatter, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createscatter, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createscatter, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createscatter, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createscatter, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createscatter, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createscatter, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createscatter, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createscatter, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createscatter, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createscatter, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createscatter, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createscatter, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createscatter, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createscatter, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createscatter, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createscatter, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createscatter, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createscatter, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createscatter, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createscatter, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createscatter, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createscatter, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createscatter, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createscatter, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createscatter, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createscatter, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createscatter, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createscatter, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createscatter, 'scatter', 
                       (get_late_type('vcs.scatter.GSp'),
                        "no default"))

    #Module createxvsy
    reg.add_module(createxvsy,namespace='vcs|Canvas')
    reg.add_input_port(createxvsy, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createxvsy, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createxvsy, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createxvsy, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))        
    reg.add_input_port(createxvsy, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createxvsy, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createxvsy, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createxvsy, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createxvsy, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createxvsy, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createxvsy, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createxvsy, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createxvsy, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createxvsy, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createxvsy, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createxvsy, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createxvsy, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createxvsy, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createxvsy, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createxvsy, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createxvsy, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createxvsy, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createxvsy, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createxvsy, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createxvsy, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createxvsy, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createxvsy, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createxvsy, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createxvsy, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createxvsy, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createxvsy, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createxvsy, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createxvsy, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createxvsy, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createxvsy, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createxvsy, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createxvsy, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createxvsy, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createxvsy, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createxvsy, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createxvsy, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createxvsy, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createxvsy, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createxvsy, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createxvsy, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createxvsy, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createxvsy, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createxvsy, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createxvsy, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createxvsy, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createxvsy, 'xvsy', 
                       (get_late_type('vcs.xvsy.GXY'),
                        "no default"))

    #Module createxyvsy
    reg.add_module(createxyvsy,namespace='vcs|Canvas')
    reg.add_input_port(createxyvsy, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createxyvsy, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createxyvsy, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createxyvsy, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))            
    reg.add_input_port(createxyvsy, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createxyvsy, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createxyvsy, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createxyvsy, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createxyvsy, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createxyvsy, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createxyvsy, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createxyvsy, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createxyvsy, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createxyvsy, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createxyvsy, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createxyvsy, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createxyvsy, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createxyvsy, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createxyvsy, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createxyvsy, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createxyvsy, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createxyvsy, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createxyvsy, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createxyvsy, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createxyvsy, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createxyvsy, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createxyvsy, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createxyvsy, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createxyvsy, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createxyvsy, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createxyvsy, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createxyvsy, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createxyvsy, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createxyvsy, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createxyvsy, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createxyvsy, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createxyvsy, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createxyvsy, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createxyvsy, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createxyvsy, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createxyvsy, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createxyvsy, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createxyvsy, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createxyvsy, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createxyvsy, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createxyvsy, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createxyvsy, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createxyvsy, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createxyvsy, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createxyvsy, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createxyvsy, 'xyvsy', 
                       (get_late_type('vcs.xyvsy.GXy'),
                        "no default"))

    #Module createyxvsx
    reg.add_module(createyxvsx,namespace='vcs|Canvas')
    reg.add_input_port(createyxvsx, 'new_GM_name', 
                       (core.modules.basic_modules.String,
                        "name of the new graphics method object. If no name is given, then one will be created for use."))
    reg.add_input_port(createyxvsx, 'source_GM_name', 
                       (core.modules.basic_modules.String,
                        "copy the contents of the source object to the newly created one. If no name is given, then the 'default' graphics methond contents is copied over to the new object."))
    reg.add_input_port(createyxvsx, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_output_port(createyxvsx, 'slab_0_out', 
                        (get_late_type('cdms2.tvariable.TransientVariable'),
                         "Data at least 2D, last 2 dimensions will be plotted"))            
    reg.add_input_port(createyxvsx, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(createyxvsx, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(createyxvsx, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(createyxvsx, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(createyxvsx, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(createyxvsx, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createyxvsx, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(createyxvsx, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(createyxvsx, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createyxvsx, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createyxvsx, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(createyxvsx, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(createyxvsx, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(createyxvsx, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(createyxvsx, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(createyxvsx, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(createyxvsx, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(createyxvsx, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(createyxvsx, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(createyxvsx, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(createyxvsx, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(createyxvsx, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(createyxvsx, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(createyxvsx, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(createyxvsx, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(createyxvsx, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(createyxvsx, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(createyxvsx, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(createyxvsx, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(createyxvsx, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createyxvsx, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(createyxvsx, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createyxvsx, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(createyxvsx, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(createyxvsx, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(createyxvsx, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(createyxvsx, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(createyxvsx, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(createyxvsx, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(createyxvsx, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(createyxvsx, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(createyxvsx, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(createyxvsx, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(createyxvsx, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(createyxvsx, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(createyxvsx, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(createyxvsx, 'yxvsx', 
                       (get_late_type('vcs.yxvsx.GYx'),
                        "no default"))

    #Module getboxfill
    reg.add_module(getboxfill,namespace='vcs|Canvas')
    reg.add_input_port(getboxfill, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getboxfill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getboxfill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getboxfill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getboxfill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getboxfill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getboxfill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getboxfill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getboxfill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getboxfill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getboxfill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getboxfill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getboxfill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getboxfill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getboxfill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getboxfill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getboxfill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getboxfill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getboxfill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getboxfill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getboxfill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getboxfill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getboxfill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getboxfill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getboxfill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getboxfill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getboxfill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getboxfill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getboxfill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getboxfill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getboxfill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getboxfill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getboxfill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getboxfill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getboxfill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getboxfill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getboxfill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getboxfill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getboxfill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getboxfill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getboxfill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getboxfill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getboxfill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getboxfill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getboxfill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getboxfill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getboxfill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getboxfill, 'boxfill', 
                       (get_late_type('vcs.boxfill.Gfb'),
                        "no default"))

    #Module getisofill
    reg.add_module(getisofill,namespace='vcs|Canvas')
    reg.add_input_port(getisofill, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getisofill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getisofill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getisofill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getisofill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getisofill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getisofill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getisofill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getisofill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getisofill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getisofill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getisofill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getisofill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getisofill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getisofill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getisofill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getisofill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getisofill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getisofill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getisofill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getisofill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getisofill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getisofill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getisofill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getisofill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getisofill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getisofill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getisofill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getisofill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getisofill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getisofill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getisofill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getisofill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getisofill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getisofill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getisofill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getisofill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getisofill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getisofill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getisofill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getisofill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getisofill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getisofill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getisofill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getisofill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getisofill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getisofill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getisofill, 'isofill', 
                       (get_late_type('vcs.isofill.Gfi'),
                        "no default"))

    #Module getisoline
    reg.add_module(getisoline,namespace='vcs|Canvas')
    reg.add_input_port(getisoline, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getisoline, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getisoline, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getisoline, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getisoline, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getisoline, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getisoline, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getisoline, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getisoline, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getisoline, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getisoline, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getisoline, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getisoline, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getisoline, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getisoline, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getisoline, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getisoline, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getisoline, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getisoline, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getisoline, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getisoline, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getisoline, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getisoline, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getisoline, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getisoline, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getisoline, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getisoline, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getisoline, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getisoline, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getisoline, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getisoline, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getisoline, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getisoline, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getisoline, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getisoline, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getisoline, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getisoline, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getisoline, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getisoline, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getisoline, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getisoline, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getisoline, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getisoline, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getisoline, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getisoline, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getisoline, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getisoline, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getisoline, 'isoline', 
                       (get_late_type('vcs.isoline.Gi'),
                        "no default"))

    #Module getoutfill
    reg.add_module(getoutfill,namespace='vcs|Canvas')
    reg.add_input_port(getoutfill, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getoutfill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getoutfill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getoutfill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getoutfill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getoutfill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getoutfill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getoutfill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getoutfill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getoutfill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getoutfill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getoutfill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getoutfill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getoutfill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getoutfill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getoutfill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getoutfill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getoutfill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getoutfill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getoutfill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getoutfill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getoutfill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getoutfill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getoutfill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getoutfill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getoutfill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getoutfill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getoutfill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getoutfill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getoutfill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getoutfill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getoutfill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getoutfill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getoutfill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getoutfill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getoutfill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getoutfill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getoutfill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getoutfill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getoutfill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getoutfill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getoutfill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getoutfill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getoutfill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getoutfill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getoutfill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getoutfill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getoutfill, 'outfill', 
                       (get_late_type('vcs.outfill.Gfo'),
                        "no default"))

    #Module getoutline
    reg.add_module(getoutline,namespace='vcs|Canvas')
    reg.add_input_port(getoutline, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getoutline, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getoutline, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getoutline, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getoutline, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getoutline, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getoutline, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getoutline, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getoutline, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getoutline, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getoutline, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getoutline, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getoutline, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getoutline, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getoutline, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getoutline, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getoutline, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getoutline, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getoutline, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getoutline, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getoutline, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getoutline, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getoutline, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getoutline, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getoutline, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getoutline, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getoutline, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getoutline, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getoutline, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getoutline, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getoutline, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getoutline, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getoutline, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getoutline, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getoutline, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getoutline, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getoutline, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getoutline, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getoutline, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getoutline, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getoutline, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getoutline, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getoutline, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getoutline, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getoutline, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getoutline, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getoutline, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getoutline, 'outline', 
                       (get_late_type('vcs.outline.Go'),
                        "no default"))

    #Module getscatter
    reg.add_module(getscatter,namespace='vcs|Canvas')
    reg.add_input_port(getscatter, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getscatter, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getscatter, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getscatter, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getscatter, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getscatter, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getscatter, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getscatter, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getscatter, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getscatter, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getscatter, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getscatter, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getscatter, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getscatter, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getscatter, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getscatter, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getscatter, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getscatter, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getscatter, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getscatter, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getscatter, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getscatter, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getscatter, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getscatter, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getscatter, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getscatter, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getscatter, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getscatter, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getscatter, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getscatter, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getscatter, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getscatter, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getscatter, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getscatter, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getscatter, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getscatter, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getscatter, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getscatter, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getscatter, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getscatter, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getscatter, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getscatter, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getscatter, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getscatter, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getscatter, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getscatter, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getscatter, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getscatter, 'scatter', 
                       (get_late_type('vcs.scatter.GSp'),
                        "no default"))

    #Module getxvsy
    reg.add_module(getxvsy,namespace='vcs|Canvas')
    reg.add_input_port(getxvsy, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getxvsy, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getxvsy, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getxvsy, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getxvsy, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getxvsy, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getxvsy, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getxvsy, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getxvsy, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getxvsy, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getxvsy, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getxvsy, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getxvsy, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getxvsy, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getxvsy, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getxvsy, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getxvsy, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getxvsy, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getxvsy, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getxvsy, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getxvsy, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getxvsy, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getxvsy, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getxvsy, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getxvsy, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getxvsy, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getxvsy, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getxvsy, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getxvsy, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getxvsy, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getxvsy, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getxvsy, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getxvsy, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getxvsy, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getxvsy, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getxvsy, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getxvsy, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getxvsy, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getxvsy, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getxvsy, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getxvsy, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getxvsy, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getxvsy, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getxvsy, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getxvsy, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getxvsy, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getxvsy, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getxvsy, 'xvsy', 
                       (get_late_type('vcs.xvsy.GXY'),
                        "no default"))

    #Module getxyvsy
    reg.add_module(getxyvsy,namespace='vcs|Canvas')
    reg.add_input_port(getxyvsy, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getxyvsy, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getxyvsy, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getxyvsy, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getxyvsy, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getxyvsy, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getxyvsy, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getxyvsy, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getxyvsy, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getxyvsy, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getxyvsy, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getxyvsy, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getxyvsy, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getxyvsy, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getxyvsy, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getxyvsy, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getxyvsy, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getxyvsy, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getxyvsy, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getxyvsy, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getxyvsy, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getxyvsy, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getxyvsy, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getxyvsy, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getxyvsy, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getxyvsy, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getxyvsy, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getxyvsy, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getxyvsy, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getxyvsy, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getxyvsy, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getxyvsy, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getxyvsy, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getxyvsy, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getxyvsy, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getxyvsy, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getxyvsy, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getxyvsy, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getxyvsy, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getxyvsy, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getxyvsy, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getxyvsy, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getxyvsy, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getxyvsy, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getxyvsy, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getxyvsy, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getxyvsy, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getxyvsy, 'xyvsy', 
                       (get_late_type('vcs.xyvsy.GXy'),
                        "no default"))

    #Module getyxvsx
    reg.add_module(getyxvsx,namespace='vcs|Canvas')
    reg.add_input_port(getyxvsx, 'GM_name', 
                       (core.modules.basic_modules.String,
                        "retrieve the graphics method object of the given name. If no name is given, then retrieve the 'default' graphics method."))
    reg.add_input_port(getyxvsx, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(getyxvsx, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(getyxvsx, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(getyxvsx, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(getyxvsx, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(getyxvsx, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getyxvsx, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(getyxvsx, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(getyxvsx, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getyxvsx, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getyxvsx, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(getyxvsx, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(getyxvsx, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(getyxvsx, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(getyxvsx, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(getyxvsx, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(getyxvsx, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(getyxvsx, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(getyxvsx, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(getyxvsx, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(getyxvsx, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(getyxvsx, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(getyxvsx, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(getyxvsx, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(getyxvsx, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(getyxvsx, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(getyxvsx, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(getyxvsx, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(getyxvsx, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(getyxvsx, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getyxvsx, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(getyxvsx, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getyxvsx, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(getyxvsx, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(getyxvsx, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(getyxvsx, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(getyxvsx, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(getyxvsx, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(getyxvsx, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(getyxvsx, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(getyxvsx, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(getyxvsx, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(getyxvsx, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(getyxvsx, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(getyxvsx, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(getyxvsx, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(getyxvsx, 'yxvsx', 
                       (get_late_type('vcs.yxvsx.GYx'),
                        "no default"))

    #Module isofill
    reg.add_module(isofill,namespace='vcs|Canvas')
    reg.add_input_port(isofill, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_input_port(isofill, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(isofill, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))    
    reg.add_input_port(isofill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(isofill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(isofill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(isofill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(isofill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(isofill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(isofill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(isofill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(isofill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(isofill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(isofill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(isofill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(isofill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(isofill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(isofill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(isofill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(isofill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(isofill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(isofill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(isofill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(isofill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(isofill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(isofill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(isofill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(isofill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(isofill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(isofill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(isofill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(isofill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(isofill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(isofill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(isofill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(isofill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(isofill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(isofill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(isofill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(isofill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(isofill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(isofill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(isofill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(isofill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(isofill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(isofill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(isofill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(isofill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(isofill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(isofill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(isofill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(isofill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(isofill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(isofill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(isofill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(isofill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(isofill, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module isoline
    reg.add_module(isoline,namespace='vcs|Canvas')
    reg.add_input_port(isoline, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_input_port(isoline, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(isoline, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))    
    reg.add_input_port(isoline, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(isoline, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(isoline, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(isoline, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(isoline, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(isoline, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(isoline, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(isoline, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(isoline, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(isoline, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(isoline, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(isoline, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(isoline, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(isoline, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(isoline, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(isoline, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(isoline, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(isoline, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(isoline, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(isoline, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(isoline, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(isoline, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(isoline, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(isoline, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(isoline, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(isoline, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(isoline, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(isoline, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(isoline, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(isoline, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(isoline, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(isoline, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(isoline, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(isoline, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(isoline, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(isoline, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(isoline, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(isoline, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(isoline, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(isoline, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(isoline, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(isoline, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(isoline, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(isoline, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(isoline, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(isoline, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(isoline, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(isoline, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(isoline, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(isoline, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(isoline, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(isoline, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(isoline, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(isoline, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module outfill
    reg.add_module(outfill,namespace='vcs|Canvas')
    reg.add_input_port(outfill, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_input_port(outfill, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(outfill, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))    
    reg.add_input_port(outfill, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(outfill, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(outfill, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(outfill, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(outfill, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(outfill, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(outfill, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(outfill, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(outfill, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(outfill, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(outfill, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(outfill, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(outfill, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(outfill, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(outfill, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(outfill, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(outfill, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(outfill, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(outfill, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(outfill, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(outfill, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(outfill, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(outfill, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(outfill, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(outfill, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(outfill, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(outfill, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(outfill, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(outfill, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(outfill, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(outfill, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(outfill, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(outfill, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(outfill, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(outfill, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(outfill, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(outfill, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(outfill, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(outfill, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(outfill, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(outfill, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(outfill, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(outfill, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(outfill, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(outfill, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(outfill, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(outfill, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(outfill, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(outfill, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(outfill, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(outfill, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(outfill, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(outfill, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(outfill, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module outline
    reg.add_module(outline,namespace='vcs|Canvas')
    reg.add_input_port(outline, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 2D, last 2 dimensions will be plotted"))
    reg.add_input_port(outline, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(outline, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))
    reg.add_input_port(outline, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(outline, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(outline, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(outline, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(outline, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(outline, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(outline, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(outline, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(outline, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(outline, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(outline, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(outline, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(outline, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(outline, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(outline, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(outline, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(outline, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(outline, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(outline, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(outline, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(outline, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(outline, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(outline, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(outline, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(outline, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(outline, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(outline, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(outline, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(outline, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(outline, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(outline, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(outline, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(outline, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(outline, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(outline, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(outline, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(outline, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(outline, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(outline, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(outline, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(outline, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(outline, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(outline, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(outline, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(outline, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(outline, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(outline, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(outline, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(outline, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(outline, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(outline, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(outline, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(outline, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(outline, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module plot
    reg.add_module(plot,namespace='vcs|Canvas')
    reg.add_input_port(plot, 'row',
                       (core.modules.basic_modules.Integer, "Cell Row"))
    reg.add_input_port(plot, 'col',
                       (core.modules.basic_modules.Integer, "Cell Col"))
    reg.add_input_port(plot, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(plot, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))
    reg.add_input_port(plot, 'plot_type', 
                       (core.modules.basic_modules.String,
                        "Type of plot - boxfill, isoline, etc"))
    reg.add_input_port(plot, 'slab2_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))
    reg.add_input_port(plot, 'slab1_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))
    
    reg.add_input_port(plot, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(plot, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(plot, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(plot, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(plot, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(plot, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(plot, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(plot, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(plot, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(plot, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(plot, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(plot, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(plot, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(plot, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(plot, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(plot, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(plot, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(plot, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(plot, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(plot, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(plot, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(plot, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(plot, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(plot, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(plot, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(plot, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(plot, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(plot, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(plot, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(plot, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(plot, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(plot, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(plot, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(plot, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(plot, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(plot, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(plot, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(plot, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(plot, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(plot, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(plot, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(plot, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(plot, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(plot, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(plot, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(plot, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(plot, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(plot, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(plot, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(plot, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(plot, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(plot, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(plot, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(plot, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module scatter
    reg.add_module(scatter,namespace='vcs|Canvas')
    reg.add_input_port(scatter, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(scatter, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))        
    reg.add_input_port(scatter, 'slab2_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))
    reg.add_input_port(scatter, 'slab1_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))    
    reg.add_input_port(scatter, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(scatter, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(scatter, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(scatter, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(scatter, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(scatter, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(scatter, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(scatter, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(scatter, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(scatter, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(scatter, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(scatter, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(scatter, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(scatter, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(scatter, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(scatter, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(scatter, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(scatter, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(scatter, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(scatter, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(scatter, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(scatter, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(scatter, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(scatter, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(scatter, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(scatter, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(scatter, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(scatter, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(scatter, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(scatter, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(scatter, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(scatter, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(scatter, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(scatter, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(scatter, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(scatter, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(scatter, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(scatter, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(scatter, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(scatter, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(scatter, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(scatter, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(scatter, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(scatter, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(scatter, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(scatter, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(scatter, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(scatter, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(scatter, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(scatter, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(scatter, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(scatter, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(scatter, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(scatter, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module xvsy
    reg.add_module(xvsy,namespace='vcs|Canvas')
    reg.add_input_port(xvsy, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(xvsy, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))        
    reg.add_input_port(xvsy, 'slab2_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))
    reg.add_input_port(xvsy, 'slab1_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))
    reg.add_input_port(xvsy, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(xvsy, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(xvsy, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(xvsy, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(xvsy, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(xvsy, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(xvsy, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(xvsy, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(xvsy, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(xvsy, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(xvsy, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(xvsy, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(xvsy, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(xvsy, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(xvsy, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(xvsy, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(xvsy, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(xvsy, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(xvsy, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(xvsy, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(xvsy, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(xvsy, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(xvsy, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(xvsy, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(xvsy, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(xvsy, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(xvsy, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(xvsy, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(xvsy, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(xvsy, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(xvsy, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(xvsy, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(xvsy, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(xvsy, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(xvsy, 'yaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting yaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(xvsy, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(xvsy, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(xvsy, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(xvsy, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(xvsy, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(xvsy, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(xvsy, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(xvsy, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(xvsy, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(xvsy, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(xvsy, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(xvsy, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module xyvsy
    reg.add_module(xyvsy,namespace='vcs|Canvas')
    reg.add_input_port(xyvsy, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(xyvsy, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))        
    reg.add_input_port(xyvsy, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))
    reg.add_input_port(xyvsy, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(xyvsy, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(xyvsy, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(xyvsy, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(xyvsy, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(xyvsy, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(xyvsy, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(xyvsy, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(xyvsy, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(xyvsy, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(xyvsy, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(xyvsy, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(xyvsy, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(xyvsy, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(xyvsy, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(xyvsy, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(xyvsy, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(xyvsy, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(xyvsy, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(xyvsy, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(xyvsy, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(xyvsy, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(xyvsy, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(xyvsy, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(xyvsy, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(xyvsy, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(xyvsy, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(xyvsy, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(xyvsy, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(xyvsy, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(xyvsy, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(xyvsy, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(xyvsy, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(xyvsy, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(xyvsy, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(xyvsy, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(xyvsy, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(xyvsy, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(xyvsy, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(xyvsy, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(xyvsy, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(xyvsy, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(xyvsy, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(xyvsy, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(xyvsy, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(xyvsy, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module yxvsx
    reg.add_module(yxvsx,namespace='vcs|Canvas')
    reg.add_input_port(yxvsx, 'template', 
                       (core.modules.basic_modules.String,
                        "Name of the template")) 
    reg.add_input_port(yxvsx, 'gm_name', 
                       (core.modules.basic_modules.String,
                        "Name of the graphics method"))        
    reg.add_input_port(yxvsx, 'slab_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Data at least 1D, last dimension will be plotted"))
    reg.add_input_port(yxvsx, 'datawc_timeunits', 
                       (core.modules.basic_modules.String,
                        "units to use when disaplaying time dimension auto tick"), True)
    reg.add_input_port(yxvsx, 'long_name', 
                       (core.modules.basic_modules.String,
                        "replaces long_name on plot"), True)
    reg.add_input_port(yxvsx, 'projection_0', 
                       (core.modules.basic_modules.String,
                        "projection to use, name or object"), True)
    reg.add_input_port(yxvsx, 'xticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of x axis"), True)
    reg.add_input_port(yxvsx, 'xarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis"), True)
    reg.add_input_port(yxvsx, 'yweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(yxvsx, 'xweights_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "replace xaxis weights used for computing mean"), True)
    reg.add_input_port(yxvsx, 'warray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of w axis, only if var has more than 4D"), True)
    reg.add_input_port(yxvsx, 'tunits', 
                       (core.modules.basic_modules.String,
                        "replace taxis units on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'ymtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(yxvsx, 'ymtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(yxvsx, 'datawc_x1', 
                       (core.modules.basic_modules.Float,
                        "first value of xaxis on plot"), True)
    reg.add_input_port(yxvsx, 'datawc_x2', 
                       (core.modules.basic_modules.Float,
                        "second value of xaxis on plot"), True)
    reg.add_input_port(yxvsx, 'continents', 
                       (core.modules.basic_modules.Integer,
                        "continents type number"), True)
    reg.add_input_port(yxvsx, 'xmtics1_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 1st side of y axis"), True)
    reg.add_input_port(yxvsx, 'xmtics2_0', 
                       (core.modules.basic_modules.String,
                        "dictionary with location of intermediate tics as keys for 2nd side of y axis"), True)
    reg.add_input_port(yxvsx, 'xbounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of x axis bounds values"), True)
    reg.add_input_port(yxvsx, 'ybounds_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis bounds values (if exist)"), True)
    reg.add_input_port(yxvsx, 'datawc_y2', 
                       (core.modules.basic_modules.Float,
                        "second value of yaxis on plot"), True)
    reg.add_input_port(yxvsx, 'wname', 
                       (core.modules.basic_modules.String,
                        "replace waxis name on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'file_comment', 
                       (core.modules.basic_modules.String,
                        "replaces file_comment on plot"), True)
    reg.add_input_port(yxvsx, 'datawc_calendar', 
                       (core.modules.basic_modules.Integer,
                        "calendar to use when displaying time dimension auto tick, default is proleptic gregorian calendar"), True)
    reg.add_input_port(yxvsx, 'wunits', 
                       (core.modules.basic_modules.String,
                        "replace waxis units on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'xrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse x axis"), True)
    reg.add_input_port(yxvsx, 'ymd', 
                       (core.modules.basic_modules.String,
                        "replaces year/month/day on plot"), True)
    reg.add_input_port(yxvsx, 'yarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of y axis, only if var has more than 1D"), True)
    reg.add_input_port(yxvsx, 'units', 
                       (core.modules.basic_modules.String,
                        "replaces units value on plot"), True)
    reg.add_input_port(yxvsx, 'yunits', 
                       (core.modules.basic_modules.String,
                        "replace yaxis units on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'zarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of z axis, only if var has more than 2D"), True)
    reg.add_input_port(yxvsx, 'xname', 
                       (core.modules.basic_modules.String,
                        "replace xaxis name on plot"), True)
    reg.add_input_port(yxvsx, 'tarray_0', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        "Values to use instead of t axis, only if var has more than 3D"), True)
    reg.add_input_port(yxvsx, 'bg_0', 
                       (core.modules.basic_modules.Boolean,
                        "plots in background mode"), True)
    reg.add_input_port(yxvsx, 'bg_1', 
                       (core.modules.basic_modules.Integer,
                        "plots in background mode"), True)
    reg.add_input_port(yxvsx, 'xaxisconvert', 
                       (core.modules.basic_modules.String,
                        "converting xaxis linear/log/log10/ln/exp/area_wt"), True)
    reg.add_input_port(yxvsx, 'zname', 
                       (core.modules.basic_modules.String,
                        "replace zaxis name on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'hms', 
                       (core.modules.basic_modules.String,
                        "replaces hh/mm/ss on plot"), True)
    reg.add_input_port(yxvsx, 'tname', 
                       (core.modules.basic_modules.String,
                        "replace taxis name on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'yname', 
                       (core.modules.basic_modules.String,
                        "replace yaxis name on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'ratio_0', 
                       (core.modules.basic_modules.Integer,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(yxvsx, 'ratio_1', 
                       (core.modules.basic_modules.String,
                        "sets the y/x ratio ,if passed as a string with 't' at the end, will aslo moves the ticks"), True)
    reg.add_input_port(yxvsx, 'datawc_y1', 
                       (core.modules.basic_modules.Float,
                        "first value of yaxis on plot"), True)
    reg.add_input_port(yxvsx, 'xunits', 
                       (core.modules.basic_modules.String,
                        "replace xaxis units on plot"), True)
    reg.add_input_port(yxvsx, 'name', 
                       (core.modules.basic_modules.String,
                        "replaces variable name on plot time "" (cdtime.comptime/cdtime.reltime/cdtime.abstime) () replaces time name on plot"), True)
    reg.add_input_port(yxvsx, 'yticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of y axis"), True)
    reg.add_input_port(yxvsx, 'yticlabels2_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 2nd side of y axis"), True)
    reg.add_input_port(yxvsx, 'comment1', 
                       (core.modules.basic_modules.String,
                        "replaces comment1 on plot"), True)
    reg.add_input_port(yxvsx, 'zunits', 
                       (core.modules.basic_modules.String,
                        "replace zaxis units on plot (if exists)"), True)
    reg.add_input_port(yxvsx, 'comment3', 
                       (core.modules.basic_modules.String,
                        "replaces comment3 on plot"), True)
    reg.add_input_port(yxvsx, 'comment2', 
                       (core.modules.basic_modules.String,
                        "replaces comment2 on plot"), True)
    reg.add_input_port(yxvsx, 'xticlabels1_0', 
                       (core.modules.basic_modules.String,
                        "values for labels on 1st side of x axis"), True)
    reg.add_input_port(yxvsx, 'comment4', 
                       (core.modules.basic_modules.String,
                        "replaces comment4 on plot"), True)
    reg.add_input_port(yxvsx, 'yrev', 
                       (core.modules.basic_modules.Boolean,
                        "reverse y axis, only if slab has more than 1D"), True)
    reg.add_output_port(yxvsx, 'display', 
                       (get_late_type('vcs.displayplot.Dp'),
                        "no default"))

    #Module png
    reg.add_module(png,namespace='vcs|Canvas')
    reg.add_input_port(png, 'file', 
                       (core.modules.basic_modules.String,
                        ""))
    reg.add_input_port(png, 'width', 
                       (core.modules.basic_modules.Float,
                        ""))
    reg.add_input_port(png, 'height', 
                       (core.modules.basic_modules.Float,
                        ""))
    reg.add_input_port(png, 'units', 
                       (core.modules.basic_modules.String,
                        ""))
    reg.add_output_port(png, 'file', 
                       (core.modules.basic_modules.File,
                        "File output"))

    #extra input ports not available in the xml file
    reg.add_input_port(boxfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createboxfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createisofill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createisoline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createoutfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createoutline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createscatter, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createxvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createxyvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(createyxvsx, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getboxfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getisofill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getisoline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getoutfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getoutline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getscatter, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getxvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getxyvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(getyxvsx, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(isofill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(isoline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(outfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(outline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(plot, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(scatter, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(xvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(xyvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(yxvsx, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_input_port(png, 'canvas', 
                       (Canvas,
                        "Canvas object"))

    #extra output ports not available in the xml file
    reg.add_output_port(boxfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createboxfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createisofill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createisoline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createoutfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createoutline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createscatter, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createxvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createxyvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(createyxvsx, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getboxfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getisofill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getisoline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getoutfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getoutline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getscatter, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getxvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getxyvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(getyxvsx, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(isofill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(isoline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(outfill, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(outline, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(plot, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(scatter, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(xvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(xyvsy, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(yxvsx, 'canvas', 
                       (Canvas,
                        "Canvas object"))
    reg.add_output_port(png, 'canvas', 
                       (Canvas,
                        "Canvas object"))

    #Module open
    reg.add_module(open,namespace='cdms2')
    reg.add_input_port(open, 'uri', 
                       (core.modules.basic_modules.String,
                        ""))
    reg.add_input_port(open, 'mode', 
                       (core.modules.basic_modules.String,
                        ""))
    reg.add_input_port(open, 'template', 
                       (core.modules.basic_modules.String,
                        ""))
    reg.add_input_port(open, 'dods', 
                       (core.modules.basic_modules.Integer,
                        ""))
    reg.add_output_port(open, 'dataset', 
                       (get_late_type('cdms2.dataset.CdmsFile'),
                        ""))

    #Module __call__
    reg.add_module(__call__,namespace='cdms2|dataset')
    reg.add_input_port(__call__, 'id', 
                       (core.modules.basic_modules.String,
                        ""))
    reg.add_input_port(__call__, 'type', 
                       (core.modules.basic_modules.String,
                        "variable, axis, or weighted-axis"))    
    reg.add_output_port(__call__, 'variable', 
                       (get_late_type('cdms2.tvariable.TransientVariable'),
                        ""))

    #extra input ports not available in the xml file
    reg.add_input_port(__call__, 'axes',
                       (core.modules.basic_modules.String, "Axes of variables"))
    reg.add_input_port(__call__, 'axesOperations',
                       (core.modules.basic_modules.String, "Axes Operations"))
    reg.add_input_port(__call__, 'cdmsfile', 
                       (CdmsFile, "cdmsfile"))

def package_dependencies():
  return []

def package_requirements():
    import core.requirements
    if not core.requirements.python_module_exists('vcs'):
        raise core.requirements.MissingRequirements('vcs')
    if not core.requirements.python_module_exists('cdms2'):
        raise core.requirements.MissingRequirements('cdms2')
    if not core.requirements.python_module_exists('cdutil'):
        raise core.requirements.MissingRequirements('cdutil')
    import vcs, cdms2, cdutil


