/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "updatebatch.h"

#include "commands/command.h"
#include "datamanager.h"

UpdateBatch::UpdateBatch( int priority ) : AbstractBatch( priority ),
    m_next( 0 ),
    m_ifNeeded( false )
{
}

UpdateBatch::~UpdateBatch()
{
}

void UpdateBatch::updateUsers()
{
    m_units.append( Unit( UpdateEvent::Users ) );
}

void UpdateBatch::updateTypes()
{
    m_units.append( Unit( UpdateEvent::Types ) );
}

void UpdateBatch::updateProjects()
{
    m_units.append( Unit( UpdateEvent::Projects ) );
}

void UpdateBatch::updateFolder( int folderId )
{
    m_units.append( Unit( UpdateEvent::Folder, folderId ) );
}

void UpdateBatch::updateIssue( int issueId )
{
    m_units.append( Unit( UpdateEvent::Issue, issueId ) );
}

void UpdateBatch::updatePreferences()
{
    m_units.append( Unit( UpdateEvent::Preferences ) );
}

void UpdateBatch::updateNotifications()
{
    m_units.append( Unit( UpdateEvent::Notifications ) );
}

void UpdateBatch::setIfNeeded( bool value )
{
    m_ifNeeded = value;
}

Command* UpdateBatch::fetchNext()
{
    while ( m_next < m_units.count() ) {
        Unit unit = m_units[ m_next++ ];

        switch ( unit.m_unit ) {
            case UpdateEvent::Users:
                return dataManager->updateUsers();
            case UpdateEvent::Types:
                return dataManager->updateTypes();
            case UpdateEvent::Projects:
                return dataManager->updateProjects();
            case UpdateEvent::Folder:
                if ( !m_ifNeeded || dataManager->folderUpdateNeeded( unit.m_id ) )
                    return dataManager->updateFolder( unit.m_id );
            case UpdateEvent::Issue:
                if ( !m_ifNeeded || dataManager->issueUpdateNeeded( unit.m_id ) )
                    return dataManager->updateIssue( unit.m_id );
            case UpdateEvent::Preferences:
                return dataManager->updatePreferences();
            case UpdateEvent::Notifications:
                return dataManager->updateNotifications();
        }
    }

    return NULL;
}
