/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <QDateTime>

#include "commanddialog.h"

class QLineEdit;
class QRadioButton;
class QComboBox;
class QTimeEdit;

class PreferencesData;

/**
* Dialog for modifying user preferences using <tt>SET PREFERENCE</tt> commands.
*/
class PreferencesDialog : public CommandDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param userId Identifier of the user to change preferences for.
    *
    * @param parent The parent widget.
    */
    PreferencesDialog( int userId, QWidget* parent );

    /**
    * Destructor.
    */
    ~PreferencesDialog();

public: // overrides
    void accept();

protected: // overrides
    bool batchSuccessful( AbstractBatch* batch );
    bool batchFailed( AbstractBatch* batch );

private slots:
    void frequencyChanged();

private:
    void loadPreferences();

private:
    int m_userId;

    const PreferencesData* m_preferences;

    QLineEdit* m_emailEdit;

    QRadioButton* m_defaultZoneRadio;
    QRadioButton* m_selectedZoneRadio;
    QComboBox* m_zoneCombo;

    QRadioButton* m_noNotifyRadio;
    QRadioButton* m_immediateNotifyRadio;
    QRadioButton* m_dailyNotifyRadio;
    QRadioButton* m_weeklyNotifyRadio;
    QComboBox* m_dayCombo;
    QTimeEdit* m_timeEdit;
};

#endif
