/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef SAVEFILTERDIALOG_H
#define SAVEFILTERDIALOG_H

#include <QDialog>

class QComboBox;
class QDialogButtonBox;

/**
* Dialog for entering the name of a filter.
*/
class SaveFilterDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    SaveFilterDialog( QWidget* parent );

    /**
    * Destructor.
    */
    ~SaveFilterDialog();

public:
    /**
    * Set the name displayed in the dialog.
    */
    void setFilterName( const QString& name );

    /**
    * Read the name from the dialog.
    */
    QString filterName() const;

    /**
    * Set the list of existing filter names.
    *
    * A warning will be displayed when an existing filter is overwritten.
    */
    void setExistingFilters( const QStringList& filters );

    /**
    * Return the list of existing filters.
    */
    const QStringList& existingFilters() const { return m_existingFilters; }

public: // overrides
    void accept();

private slots:
    void nameChanged( const QString& name );

private:
    QStringList m_existingFilters;

    QString m_oldName;

    QComboBox* m_nameCombo;

    QDialogButtonBox* m_buttonBox;
};

#endif
