.TH ZABBIX_AGENTD 8 "10 November 2011"
.SH NAME
zabbix_agentd \- Zabbix agent daemon.
.SH SYNOPSIS
.B zabbix_agentd [-hpV] [-c \fI<config-file>\fB] [-t \fI<item-key>\fB]
.SH DESCRIPTION
.B zabbix_agentd
is a daemon for monitoring of various server parameters.
.SS Options
.IP "-c, --config \fI<config-file>\fR"
Use the alternate \fIconfig-file\fR instead of the default one.
Absolute path should be specified.
.
.IP "-p, --print"
Print known items and exit. For each item either generic defaults are used, or specific defaults for testing are supplied. These defaults are listed in square brackets as item key parameters.
Returned values are enclosed in square brackets and prefixed with the type of the returned value, separated by a pipe character.
For user parameters type is always \fBt\fR, as the agent can not determine all possible return values.
Items, displayed as working, are not guaranteed to work from the Zabbix server or zabbix_get when querying a running agent daemon as permissions or environment may be different.
Returned value types are:
.RS 4
.TP 4
d
Number with a decimal part.
.RE
.RE
.RS 4
.TP 4
m
Not supported. This could be caused by querying an item that only works in the active mode like a log monitoring item or an item that requires multiple collected values.
Permission issues or incorrect user parameters could also result in the not supported state.
.RE
.RE
.RS 4
.TP 4
s
Text. Maximum length not limited.
.RE
.RE
.RS 4
.TP 4
t
Text. Same as \fBs\fR.
.RE
.RE
.RS 4
.TP 4
u
Unsigned integer.
.RE
.RE
.IP "-t, --test \fI<item-key>\fR"
Test single item and exit. See \fB--print\fR for output description.
.IP "-h, --help"
Display this help and exit.
.IP "-V, --version"
Output version information and exit.
.SH FILES
.TP
.I /usr/local/etc/zabbix_agentd.conf
Default location of Zabbix agent configuration file (if not modified during compile time).
.SH "SEE ALSO"
.BR zabbix_get (8),
.BR zabbix_proxy (8),
.BR zabbix_sender (8),
.BR zabbix_server (8)
.SH AUTHOR
Alexei Vladishev <alex@zabbix.com>
