.TH ZABBIX_SENDER 1 "2018\-10\-11" Zabbix
.if n .ad l
.SH NAME
zabbix_sender \- Zabbix sender utility
.SH SYNOPSIS
.B zabbix_sender
.RB [ \-v ]
.B \-z
.I server
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.B \-s
.I host
.B \-k
.I key
.B \-o
.I value
.br
.B zabbix_sender
.RB [ \-v ]
.B \-z
.I server
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-s
.IR host ]
.RB [ \-T ]
.RB [ \-r ]
.B \-i
.I input\-file
.br
.B zabbix_sender
.RB [ \-v ]
.B \-c
.I config\-file
.RB [ \-z
.IR server ]
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP-address ]
.RB [ \-s
.IR host ]
.B \-k
.I key
.B \-o
.I value
.br
.B zabbix_sender
.RB [ \-v ]
.B \-c
.I config\-file
.RB [ \-z
.IR server ]
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP-address ]
.RB [ \-s
.IR host ]
.RB [ \-T ]
.RB [ \-r ]
.B \-i
.I input-file
.br
.B zabbix_sender
.RB [ \-v ]
.B \-z
.I server
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.B \-s
.I host
.B \-\-tls\-connect
.B cert
.B \-\-tls\-ca\-file
.I CA\-file
.RB [ \-\-tls\-crl\-file
.IR CRL\-file ]
.RB [ \-\-tls\-server\-cert\-issuer
.IR cert\-issuer ]
.RB [ \-\-tls\-server\-cert\-subject
.IR cert\-subject ]
.B \-\-tls\-cert\-file
.I cert\-file
.B \-\-tls\-key\-file
.I key\-file
.B \-k
.I key
.B \-o
.I value
.br
.B zabbix_sender
.RB [ \-v ]
.B \-z
.I server
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-s
.IR host ]
.B \-\-tls\-connect
.B cert
.B \-\-tls\-ca\-file
.I CA\-file
.RB [ \-\-tls\-crl\-file
.IR CRL\-file ]
.RB [ \-\-tls\-server\-cert\-issuer
.IR cert\-issuer ]
.RB [ \-\-tls\-server\-cert\-subject
.IR cert\-subject ]
.B \-\-tls\-cert\-file
.I cert\-file
.B \-\-tls\-key\-file
.I key\-file
.RB [ \-T ]
.RB [ \-r ]
.B \-i
.I input\-file
.br
.B zabbix_sender
.RB [ \-v ]
.B \-c
.I config-file
.RB [ \-z
.IR server ]
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-s
.IR host ]
.B \-\-tls\-connect
.B cert
.B \-\-tls\-ca\-file
.I CA\-file
.RB [ \-\-tls\-crl\-file
.IR CRL\-file ]
.RB [ \-\-tls\-server\-cert\-issuer
.IR cert\-issuer ]
.RB [ \-\-tls\-server\-cert\-subject
.IR cert\-subject ]
.B \-\-tls\-cert\-file
.I cert\-file
.B \-\-tls\-key\-file
.I key\-file
.B \-k
.I key
.B \-o
.I value
.br
.B zabbix_sender
.RB [ \-v ]
.B \-c
.I config-file
.RB [ \-z
.IR server ]
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-s
.IR host ]
.B \-\-tls\-connect
.B cert
.B \-\-tls\-ca\-file
.I CA\-file
.RB [ \-\-tls\-crl\-file
.IR CRL\-file ]
.RB [ \-\-tls\-server\-cert\-issuer
.IR cert\-issuer ]
.RB [ \-\-tls\-server\-cert\-subject
.IR cert\-subject ]
.B \-\-tls\-cert\-file
.I cert\-file
.B \-\-tls\-key\-file
.I key\-file
.RB [ \-T ]
.RB [ \-r ]
.B \-i
.I input\-file
.br
.B zabbix_sender
.RB [ \-v ]
.B \-z
.I server
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.B \-s
.I host
.B \-\-tls\-connect
.B psk
.B \-\-tls\-psk\-identity
.I PSK\-identity
.B \-\-tls\-psk\-file
.I PSK\-file
.B \-k
.I key
.B \-o
.I value
.br
.B zabbix_sender
.RB [ \-v ]
.B \-z
.I server
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP\-address ]
.RB [ \-s
.IR host ]
.B \-\-tls\-connect
.B psk
.B \-\-tls\-psk\-identity
.I PSK\-identity
.B \-\-tls\-psk\-file
.I PSK\-file
.RB [ \-T ]
.RB [ \-r ]
.B \-i
.I input\-file
.br
.B zabbix_sender
.RB [ \-v ]
.B \-c
.I config\-file
.RB [ \-z
.IR server ]
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP-address ]
.RB [ \-s
.IR host ]
.B \-\-tls\-connect
.B psk
.B \-\-tls\-psk\-identity
.I PSK\-identity
.B \-\-tls\-psk\-file
.I PSK\-file
.B \-k
.I key
.B \-o
.I value
.br
.B zabbix_sender
.RB [ \-v ]
.B \-c
.I config\-file
.RB [ \-z
.IR server ]
.RB [ \-p
.IR port ]
.RB [ \-I
.IR IP-address ]
.RB [ \-s
.IR host ]
.B \-\-tls\-connect
.B psk
.B \-\-tls\-psk\-identity
.I PSK\-identity
.B \-\-tls\-psk\-file
.I PSK\-file
.RB [ \-T ]
.RB [ \-r ]
.B \-i
.I input\-file
.br
.B zabbix_sender \-h
.br
.B zabbix_sender \-V
.SH DESCRIPTION
.B zabbix_sender
is a command line utility for sending monitoring data to Zabbix server or proxy.
On the Zabbix server an item of type \fBZabbix trapper\fR should be created with corresponding key.
Note that incoming values will only be accepted from hosts specified in \fBAllowed hosts\fR field for this item.
.SH OPTIONS
.IP "\fB\-c\fR, \fB\-\-config\fR \fIconfig\-file\fR"
Use \fIconfig\-file\fR.
\fBZabbix sender\fR reads server details from the agentd configuration file.
By default
.B Zabbix sender
does not read any configuration file.
Only parameters \fBHostname\fR, \fBServerActive\fR, \fBSourceIP\fR, \fBTLSConnect\fR, \fBTLSCAFile\fR, \fBTLSCRLFile\fR,
\fBTLSServerCertIssuer\fR, \fBTLSServerCertSubject\fR, \fBTLSCertFile\fR, \fBTLSKeyFile\fR, \fBTLSPSKIdentity\fR and \fBTLSPSKFile\fR are supported.
First entry from the \fBServerActive\fR parameter is used.
.IP "\fB\-z\fR, \fB\-\-zabbix\-server\fR \fIserver\fR"
Hostname or IP address of Zabbix server.
If a host is monitored by a proxy, proxy hostname or IP address should be used instead.
When used together with \fB\-\-config\fR, overrides the first entry of \fBServerActive\fR parameter specified in agentd configuration file.
.IP "\fB\-p\fR, \fB\-\-port\fR \fIport\fR"
Specify port number of Zabbix server trapper running on the server.
Default is 10051.
When used together with \fB\-\-config\fR, overrides the port of first entry of \fBServerActive\fR parameter specified in agentd configuration file.
.IP "\fB\-I\fR, \fB\-\-source\-address\fR \fIIP\-address\fR"
Specify source IP address.
When used together with \fB\-\-config\fR, overrides \fBSourceIP\fR parameter specified in agentd configuration file.
.IP "\fB\-s\fR, \fB\-\-host\fR \fIhost\fR"
Specify host name the item belongs to (as registered in Zabbix frontend).
Host IP address and DNS name will not work.
When used together with \fB\-\-config\fR, overrides \fBHostname\fR parameter specified in agentd configuration file.
.IP "\fB\-k\fR, \fB\-\-key\fR \fIkey\fR"
Specify item key to send value to.
.IP "\fB\-o\fR, \fB\-\-value\fR \fIvalue\fR"
Specify item value.
.IP "\fB\-i\fR, \fB\-\-input\-file\fR \fIinput\-file\fR"
Load values from input file.
Specify \fB\-\fR as \fB<input-file>\fR to read values from standard input.
Each line of file contains whitespace delimited: \fB<hostname> <key> <value>\fR.
Each value must be specified on its own line.  Each line must contain 3 whitespace delimited entries:
\fB<hostname> <key> <value>\fR, where "hostname" is the name of monitored host as registered in Zabbix frontend,
"key" is target item key and "value" \- the value to send. Specify \fB-\fR as \fB<hostname>\fR to use hostname from
agent configuration file or from \fB\-\-host\fR argument.

An example of a line of an input file:

\fB "Linux DB3" db.connections 43\fR

The value type must be correctly set in item configuration of Zabbix frontend.
Zabbix sender will send up to 250 values in one connection.
Contents of the input file must be in the UTF\-8 encoding.
All values from the input file are sent in a sequential order top\-down.
Entries must be formatted using the following rules:

.RS
.RS
.IP \[bu] 2
Quoted and non-quoted entries are supported.
.IP \[bu]
Double-quote is the quoting character.
.IP \[bu]
Entries with whitespace must be quoted.
.IP \[bu]
Double-quote and backslash characters inside quoted entry must be escaped with a backslash.
.IP \[bu]
Escaping is not supported in non-quoted entries.
.IP \[bu]
Linefeed escape sequences (\\n) are supported in quoted strings.
.IP \[bu]
Linefeed escape sequences are trimmed from the end of an entry.
.RE
.RE

.IP "\fB\-T\fR, \fB\-\-with\-timestamps\fR"
This option can be only used with \fB\-\-input\-file\fR option.

Each line of the input file must contain 4 whitespace delimited entries: \fB<hostname> <key> <timestamp> <value>\fR.
Timestamp should be specified in Unix timestamp format.
If target item has triggers referencing it, all timestamps must be in an increasing order, otherwise event calculation will not be correct.

An example of a line of the input file:

\fB "Linux DB3" db.connections 1429533600 43\fR

For more details please see option \fB\-\-input\-file\fR.

.IP "\fB\-r\fR, \fB\-\-real\-time\fR"
Send values one by one as soon as they are received.
This can be used when reading from standard input.
.IP "\fB\-\-tls\-connect\fR \fIvalue\fR"
How to connect to server or proxy. Values:\fR
.SS
.RS 12
.TP 12
.B unencrypted
connect without encryption (default)
.RE
.RS 12
.TP 12
.B psk
connect using TLS and a pre-shared key
.RE
.RS 12
.TP 12
.B cert
connect using TLS and a certificate
.RE
.RE
.IP "\fB\-\-tls\-ca\-file\fR \fICA\-file\fR"
Full pathname of a file containing the top-level CA(s) certificates for peer certificate verification.
.IP "\fB\-\-tls\-crl\-file\fR \fICRL\-file\fR"
Full pathname of a file containing revoked certificates.
.IP "\fB\-\-tls\-server\-cert\-issuer\fR \fIcert\-issuer\fR"
Allowed server certificate issuer.
.IP "\fB\-\-tls\-server\-cert\-subject\fR \fIcert\-subject\fR"
Allowed server certificate subject.
.IP "\fB\-\-tls\-cert\-file\fR \fIcert\-file\fR"
Full pathname of a file containing the certificate or certificate chain.
.IP "\fB\-\-tls\-key\-file\fR \fIkey\-file\fR"
Full pathname of a file containing the private key.
.IP "\fB\-\-tls\-psk\-identity\fR \fIPSK\-identity\fR"
PSK\-identity string.
.IP "\fB\-\-tls\-psk\-file\fR \fIPSK\-file\fR"
Full pathname of a file containing the pre-shared key.
.IP "\fB\-v\fR, \fB\-\-verbose\fR"
Verbose mode, \fB\-vv\fR for more details.
.IP "\fB\-h\fR, \fB\-\-help\fR"
Display this help and exit.
.IP "\fB\-V\fR, \fB\-\-version\fR"
Output version information and exit.

.SH "EXIT STATUS"
The exit status is 0 if the values were sent and all of them were successfully processed by server.
If data was sent, but processing of at least one of the values failed, the exit status is 2.
If data sending failed, the exit status is 1.

.SH "EXAMPLES"
\fBzabbix_sender \-c /etc/zabbix/zabbix_agentd.conf \-k mysql.queries \-o 342.45\fR
.br
.RS
Send \fB342.45\fR as the value for \fBmysql.queries\fR item of monitored host. Use monitored host and Zabbix server defined in agent configuration file.
.RE

\fBzabbix_sender \-c /etc/zabbix/zabbix_agentd.conf \-s "Monitored Host" \-k mysql.queries \-o 342.45\fR
.br
.RS
Send \fB342.45\fR as the value for \fBmysql.queries\fR item of \fBMonitored Host\fR host using Zabbix server defined in agent configuration file.
.RE

.br
\fBzabbix_sender \-z 192.168.1.113 \-i data_values.txt\fR
.RS
.br
Send values from file \fBdata_values.txt\fR to Zabbix server with IP \fB192.168.1.113\fR.
Host names and keys are defined in the file.
.RE

.br
\fBecho "\- hw.serial.number 1287872261 SQ4321ASDF" | zabbix_sender \-c /usr/local/etc/zabbix_agentd.conf \-T \-i \-\fR
.br
.RS
Send a timestamped value from the commandline to Zabbix server, specified in the agent configuration file.
Dash in the input data indicates that hostname also should be used from the same configuration file.
.RE

.br
\fBecho '"Zabbix server" trapper.item ""' | zabbix_sender \-z 192.168.1.113 \-p 10000 \-i \-\fR
.br
.RS
Send empty value of an item to the Zabbix server with IP address \fB192.168.1.113\fR on port \fB10000\fR from the commandline.
Empty values must be indicated by empty double quotes.
.RE

\fBzabbix_sender \-z 192.168.1.113  \-s "Monitored Host" \-k mysql.queries \-o 342.45 \-\-tls\-connect cert \-\-tls\-ca\-file /home/zabbix/zabbix_ca_file \-\-tls\-cert\-file /home/zabbix/zabbix_agentd.crt \-\-tls\-key\-file /home/zabbix/zabbix_agentd.key\fR
.br
.RS
Send \fB342.45\fR as the value for \fBmysql.queries\fR item in \fBMonitored Host\fR host to server with IP \fB192.168.1.113\fR using TLS with certificate.
.RE

\fBzabbix_sender \-z 192.168.1.113  \-s "Monitored Host" \-k mysql.queries \-o 342.45 \-\-tls\-connect psk \-\-tls\-psk\-identity "PSK ID Zabbix agentd" \-\-tls\-psk\-file /home/zabbix/zabbix_agentd.psk\fR
.br
.RS
Send \fB342.45\fR as the value for \fBmysql.queries\fR item in \fBMonitored Host\fR host to server with IP \fB192.168.1.113\fR using TLS with pre-shared key (PSK).
.RE

.SH "SEE ALSO"
.BR zabbix_agentd (8),
.BR zabbix_get (8),
.BR zabbix_proxy (8),
.BR zabbix_server (8)
.SH AUTHOR
Alexei Vladishev <alex@zabbix.com>
