/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */

package org.broad.igv.track.tribble;


import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.util.LineReader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: jrobinso
 * Date: May 13, 2010
 * Time: 9:32:03 PM
 * To change this template use File | Settings | File Templates.
 */
public class VCFCodec implements FeatureCodec {

    static String[] buffer = new String[8];
    List<String> headerStrings = new ArrayList();


    public Object readHeader(LineReader reader)  {
        return null;

    }

    public Class getFeatureType() {
        return VCFFeature.class;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public Object getHeader(Class clazz) throws ClassCastException {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public Feature decodeLoc(String line) {
        return decode(line);  //To change body of implemented methods use File | Settings | File Templates.
    }

    public VCFFeature decode(String line) {
        if (line.startsWith("#")) {
            return null;
        }

        //    public VCFFeature(String chr, int start, String id, String ref, String alt, float quality, String filter, String info) {

        int nTokens = ParsingUtils.split(line, buffer, '\t');
        if (nTokens >= 8) {
            String chr = buffer[0];
            Integer start = Integer.parseInt(buffer[1]) - 1;
            String quality = buffer[5];

            return new VCFFeature(chr, start, buffer[2], buffer[3], buffer[4], quality, buffer[6], buffer[7]);
        }
        return null;

    }


}
