/*
 * Copyright (c) 2007-2010 by The Broad Institute, Inc. and the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL), Version 2.1 which
 * is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR WARRANTIES OF
 * ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT
 * OR OTHER DEFECTS, WHETHER OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR
 * RESPECTIVE TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES OF
 * ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES, ECONOMIC
 * DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER THE BROAD OR MIT SHALL
 * BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT SHALL KNOW OF THE POSSIBILITY OF THE
 * FOREGOING.
 */
package org.broad.igv.ui;

import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.feature.ProbeToGeneMap;
import org.broad.igv.main.CommandListener;
import org.broad.igv.ui.legend.ChromosomeColorLegend;
import org.broad.igv.ui.legend.LegendDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.Utilities;

import javax.swing.*;
import java.util.HashMap;
import java.util.Map;

/**
 * @author jrobinso
 */
public class PreferencesEditor extends javax.swing.JDialog {

    private boolean canceled = false;
    Map<String, String> updatedPreferenceMap = new HashMap();
    PreferenceManager prefMgr = PreferenceManager.getInstance();
    boolean updateOverlays = false;
    boolean inputValidated = true;
    int initialSamMaxLevel = 0;
    int initialSamQualityThreshold = 0;
    float initialAlleleFreqThreshold;
    boolean initialShowDuplicates = false;
    private static int lastSelectedIndex = 0;
    boolean proxySettingsChanged;


    /**
     * Creates new form PreferencesEditor
     */
    public PreferencesEditor(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        initValues();

        tabbedPane.setSelectedIndex(lastSelectedIndex);
        setLocationRelativeTo(parent);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        featureStyleButtonGroup = new javax.swing.ButtonGroup();
        probeMappingButtonGroup = new javax.swing.ButtonGroup();
        rnaiMapapingButtonGroup = new javax.swing.ButtonGroup();
        tabbedPane = new javax.swing.JTabbedPane();
        generalPanel = new javax.swing.JPanel();
        jPanel10 = new javax.swing.JPanel();
        missingDataExplanation = new javax.swing.JLabel();
        showMissingDataCB = new javax.swing.JCheckBox();
        combinePanelsCB = new javax.swing.JCheckBox();
        joinSegmentsCB = new javax.swing.JCheckBox();
        showAttributesDisplayCheckBox = new javax.swing.JCheckBox();
        searchZoomCB = new javax.swing.JCheckBox();
        missingDataExplanation6 = new javax.swing.JLabel();
        missingDataExplanation7 = new javax.swing.JLabel();
        tracksPanel = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        defaultChartTrackHeightField = new javax.swing.JTextField();
        trackNameAttributeLabel = new javax.swing.JLabel();
        trackNameAttributeField = new javax.swing.JTextField();
        missingDataExplanation2 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        defaultTrackHeightField = new javax.swing.JTextField();
        missingDataExplanation4 = new javax.swing.JLabel();
        missingDataExplanation5 = new javax.swing.JLabel();
        missingDataExplanation3 = new javax.swing.JLabel();
        expandCB = new javax.swing.JCheckBox();
        normalizeCoverageCB = new javax.swing.JCheckBox();
        missingDataExplanation8 = new javax.swing.JLabel();
        overlaysPanel = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        overlayAttributeTextField = new javax.swing.JTextField();
        overlayTrackCB = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        displayTracksCB = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        colorOverlyCB = new javax.swing.JCheckBox();
        chooseOverlayColorsButton = new com.jidesoft.swing.JideButton();
        chartPanel = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        topBorderCB = new javax.swing.JCheckBox();
        label1 = new java.awt.Label();
        chartDrawTrackNameCB = new javax.swing.JCheckBox();
        bottomBorderCB = new javax.swing.JCheckBox();
        jLabel7 = new javax.swing.JLabel();
        colorBordersCB = new javax.swing.JCheckBox();
        labelYAxisCB = new javax.swing.JCheckBox();
        autoscaleCB = new javax.swing.JCheckBox();
        jLabel9 = new javax.swing.JLabel();
        showDatarangeCB = new javax.swing.JCheckBox();
        alignmentPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jPanel11 = new javax.swing.JPanel();
        samMaxLevelField = new javax.swing.JTextField();
        snpThresholdField = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jLabel26 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        mappingQualityThresholdField = new javax.swing.JTextField();
        jLabel14 = new javax.swing.JLabel();
        insertSizeThresholdField = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        jLabel18 = new javax.swing.JLabel();
        samMaxWindowSizeField = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        jPanel12 = new javax.swing.JPanel();
        samMinBaseQualityField = new javax.swing.JTextField();
        samShadeMismatchedBaseCB = new javax.swing.JCheckBox();
        jLabel20 = new javax.swing.JLabel();
        samMaxBaseQualityField = new javax.swing.JTextField();
        showCovTrackCB = new javax.swing.JCheckBox();
        samShowDuplicatesCB = new javax.swing.JCheckBox();
        showRefSeqCB = new javax.swing.JCheckBox();
        jLabel19 = new javax.swing.JLabel();
        filterCB = new javax.swing.JCheckBox();
        filterURL = new javax.swing.JTextField();
        samFlagUnmappedPairCB = new javax.swing.JCheckBox();
        shadeCenterCB = new javax.swing.JCheckBox();
        jLabel10 = new javax.swing.JLabel();
        legendPanel = new ChromosomeColorLegend();
        jPanel13 = new javax.swing.JPanel();
        expressionPane = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        expMapToGeneCB = new javax.swing.JRadioButton();
        jLabel24 = new javax.swing.JLabel();
        expMapToLociCB = new javax.swing.JRadioButton();
        jLabel21 = new javax.swing.JLabel();
        advancedPanel = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        genomeServerURLTextField = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        dataServerURLTextField = new javax.swing.JTextField();
        editServerPropertiesCB = new javax.swing.JCheckBox();
        clearGenomeCacheButton = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        jPanel7 = new javax.swing.JPanel();
        enablePortCB = new javax.swing.JCheckBox();
        portField = new javax.swing.JTextField();
        jLabel22 = new javax.swing.JLabel();
        jPanel9 = new javax.swing.JPanel();
        useByteRangeCB = new javax.swing.JCheckBox();
        jLabel25 = new javax.swing.JLabel();
        jPanel14 = new javax.swing.JPanel();
        jPanel15 = new javax.swing.JPanel();
        jPanel16 = new javax.swing.JPanel();
        proxyUsernameField = new javax.swing.JTextField();
        jLabel28 = new javax.swing.JLabel();
        authenticateProxyCB = new javax.swing.JCheckBox();
        jLabel29 = new javax.swing.JLabel();
        proxyPasswordField = new javax.swing.JPasswordField();
        jPanel17 = new javax.swing.JPanel();
        proxyHostField = new javax.swing.JTextField();
        proxyPortField = new javax.swing.JTextField();
        jLabel27 = new javax.swing.JLabel();
        jLabel23 = new javax.swing.JLabel();
        useProxyCB = new javax.swing.JCheckBox();
        okCancelButtonPanel = new com.jidesoft.dialog.ButtonPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);

        generalPanel.setLayout(null);

        missingDataExplanation.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation.setText("<html>Distinguish  regions with zero values from regions with no data on plots <br>(e.g. bar charts).  Regions with no data are indicated with a gray background."); // NOI18N

        showMissingDataCB.setText("Distinguish Missing Data");
        showMissingDataCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showMissingDataCBActionPerformed(evt);
            }
        });

        combinePanelsCB.setText("Combine Data and Feature Panels");
        combinePanelsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                combinePanelsCBActionPerformed(evt);
            }
        });

        joinSegmentsCB.setText("Join Adjacent CopyNumber Segments");
        joinSegmentsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                joinSegmentsCBActionPerformed(evt);
            }
        });

        showAttributesDisplayCheckBox.setText("Show Attribute Display");
        showAttributesDisplayCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showAttributesDisplayCheckBoxActionPerformed(evt);
            }
        });

        searchZoomCB.setText("Zoom to features");
        searchZoomCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                searchZoomCBActionPerformed(evt);
            }
        });

        missingDataExplanation6.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation6.setText("<html>This option applies to segmented copy number data only.  When selected, gaps between<br>adjacent segments are filled by extending segment endpoints."); // NOI18N

        missingDataExplanation7.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation7.setText("<html>This option controls the behavior of feature searchs.  If true, the zoom level is changed as required to size the view to the feature size.  If false the zoom level is unchanged."); // NOI18N
        missingDataExplanation7.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        org.jdesktop.layout.GroupLayout jPanel10Layout = new org.jdesktop.layout.GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(
            jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel10Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(35, 35, 35)
                        .add(missingDataExplanation, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(showMissingDataCB)
                    .add(combinePanelsCB)
                    .add(joinSegmentsCB)
                    .add(searchZoomCB)
                    .add(showAttributesDisplayCheckBox)
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(44, 44, 44)
                        .add(jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(missingDataExplanation7, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 508, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(missingDataExplanation6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(39, Short.MAX_VALUE))
        );
        jPanel10Layout.setVerticalGroup(
            jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel10Layout.createSequentialGroup()
                .addContainerGap()
                .add(showMissingDataCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(combinePanelsCB)
                .add(26, 26, 26)
                .add(joinSegmentsCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation6, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(showAttributesDisplayCheckBox)
                .add(28, 28, 28)
                .add(searchZoomCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation7, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 78, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(45, Short.MAX_VALUE))
        );

        missingDataExplanation7.getAccessibleContext().setAccessibleName("<html>This option controls the zoom behavior when using search by feature.  If checked, the zoom level is changed as required to size the view width to exactly match the feature size.  If unchecked the zoom level is not changed.");

        generalPanel.add(jPanel10);
        jPanel10.setBounds(0, 0, 610, 420);

        tabbedPane.addTab("General", generalPanel);

        tracksPanel.setLayout(null);

        jLabel5.setText("Default Track Height, Charts (Pixels)"); // NOI18N

        defaultChartTrackHeightField.setText("40"); // NOI18N
        defaultChartTrackHeightField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultChartTrackHeightFieldActionPerformed(evt);
            }
        });
        defaultChartTrackHeightField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                defaultChartTrackHeightFieldFocusLost(evt);
            }
        });

        trackNameAttributeLabel.setText("Track Name Attribute"); // NOI18N

        trackNameAttributeField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                trackNameAttributeFieldActionPerformed(evt);
            }
        });
        trackNameAttributeField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                trackNameAttributeFieldFocusLost(evt);
            }
        });

        missingDataExplanation2.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation2.setText("<html>Name of an attribute to be used to label  tracks.  If provided tracks will be labeled with the corresponding attribute values from the sample information file"); // NOI18N

        jLabel8.setText("Default Track Height, Other (Pixels)"); // NOI18N

        defaultTrackHeightField.setText("15"); // NOI18N
        defaultTrackHeightField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultTrackHeightFieldActionPerformed(evt);
            }
        });
        defaultTrackHeightField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                defaultTrackHeightFieldFocusLost(evt);
            }
        });

        missingDataExplanation4.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation4.setText("<html>Default height of chart tracks (barcharts, scatterplots, etc)"); // NOI18N

        missingDataExplanation5.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation5.setText("<html>Default height of all other tracks"); // NOI18N

        missingDataExplanation3.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation3.setText("<html><i> If selected feature tracks are expanded by default."); // NOI18N

        expandCB.setText("Expand Feature Tracks");
        expandCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                expandCBActionPerformed(evt);
            }
        });

        normalizeCoverageCB.setText("Normalize Coverage Data");
        normalizeCoverageCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                normalizeCoverageCBActionPerformed(evt);
            }
        });


        missingDataExplanation8.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation8.setText("<html><i> Applies to coverage tracks computed with igvtools (.tdf files).  If selected coverage values are scaled by (1,000,000 / totalCount),  where totalCount is the total number of features or alignments."); // NOI18N
        missingDataExplanation8.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        org.jdesktop.layout.GroupLayout jPanel6Layout = new org.jdesktop.layout.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel6Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(24, 24, 24)
                                .add(missingDataExplanation4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 354, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(trackNameAttributeLabel)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(trackNameAttributeField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 216, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(jLabel8)
                                .add(39, 39, 39)
                                .add(defaultTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 57, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(24, 24, 24)
                                .add(missingDataExplanation5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 1127, Short.MAX_VALUE))
                            .add(jPanel6Layout.createSequentialGroup()
                                .add(jLabel5)
                                .add(36, 36, 36)
                                .add(defaultChartTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 57, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(63, 63, 63)
                        .add(missingDataExplanation2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 354, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(expandCB))
                    .add(jPanel6Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(normalizeCoverageCB))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(876, 876, 876)
                        .add(missingDataExplanation3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(61, 61, 61)
                        .add(missingDataExplanation8, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 608, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(defaultChartTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel8)
                    .add(defaultTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(26, 26, 26)
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(trackNameAttributeLabel)
                    .add(trackNameAttributeField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 65, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(32, 32, 32)
                .add(expandCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(29, 29, 29)
                .add(normalizeCoverageCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation8, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 71, Short.MAX_VALUE))
        );

        missingDataExplanation2.getAccessibleContext().setAccessibleName("<html>Name of an attribute to be used to label  tracks.  If provided   <br>tracks will be labeled with the corresponding attribute values from the sample information file. ");

        tracksPanel.add(jPanel6);
        jPanel6.setBounds(40, 20, 690, 480);

        tabbedPane.addTab("Tracks", tracksPanel);

        jLabel3.setText("Overlay tracks based on attribute:"); // NOI18N

        overlayAttributeTextField.setText("LINKING_ID"); // NOI18N
        overlayAttributeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overlayAttributeTextFieldActionPerformed(evt);
            }
        });
        overlayAttributeTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                overlayAttributeTextFieldFocusLost(evt);
            }
        });
        overlayAttributeTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                overlayAttributeTextFieldKeyTyped(evt);
            }
        });

        overlayTrackCB.setSelected(true);
        overlayTrackCB.setText("Overlay mutation tracks"); // NOI18N
        overlayTrackCB.setActionCommand("overlayTracksCB"); // NOI18N
        overlayTrackCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overlayTrackCBActionPerformed(evt);
            }
        });

        jLabel2.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        jLabel2.setText(getOverlayText());

        displayTracksCB.setText("Display mutation data as distinct tracks"); // NOI18N
        displayTracksCB.setActionCommand("displayTracksCB"); // NOI18N
        displayTracksCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                displayTracksCBActionPerformed(evt);
            }
        });

        jLabel4.setFont(new java.awt.Font("Lucida Grande", 2, 12));

        colorOverlyCB.setText("Color code overlay"); // NOI18N
        colorOverlyCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorOverlyCBActionPerformed(evt);
            }
        });

        chooseOverlayColorsButton.setForeground(new java.awt.Color(0, 0, 247));
        chooseOverlayColorsButton.setText("Choose colors"); // NOI18N
        chooseOverlayColorsButton.setButtonStyle(
            com.jidesoft.swing.ButtonStyle.HYPERLINK_STYLE
        );
        chooseOverlayColorsButton.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        chooseOverlayColorsButton.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        chooseOverlayColorsButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        chooseOverlayColorsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseOverlayColorsButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(displayTracksCB)
                    .add(jLabel4)
                    .add(overlayTrackCB)
                    .add(jLabel2)
                    .add(jPanel5Layout.createSequentialGroup()
                        .add(59, 59, 59)
                        .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel5Layout.createSequentialGroup()
                                .add(colorOverlyCB)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(chooseOverlayColorsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel5Layout.createSequentialGroup()
                                .add(jLabel3)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(overlayAttributeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 228, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel4)
                .add(39, 39, 39)
                .add(overlayTrackCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(overlayAttributeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(6, 6, 6)
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(colorOverlyCB)
                    .add(chooseOverlayColorsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(36, 36, 36)
                .add(displayTracksCB)
                .addContainerGap(30, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout overlaysPanelLayout = new org.jdesktop.layout.GroupLayout(overlaysPanel);
        overlaysPanel.setLayout(overlaysPanelLayout);
        overlaysPanelLayout.setHorizontalGroup(
            overlaysPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(overlaysPanelLayout.createSequentialGroup()
                .add(28, 28, 28)
                .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(208, Short.MAX_VALUE))
        );
        overlaysPanelLayout.setVerticalGroup(
            overlaysPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(overlaysPanelLayout.createSequentialGroup()
                .add(55, 55, 55)
                .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(229, Short.MAX_VALUE))
        );

        tabbedPane.addTab("Overlays", overlaysPanel);

        chartPanel.setLayout(null);

        topBorderCB.setText("Draw Top Border");
        topBorderCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                topBorderCBActionPerformed(evt);
            }
        });

        label1.setFont(label1.getFont());
        label1.setText("Default settings for barcharts and scatterplots:");

        chartDrawTrackNameCB.setText("Draw Track Label");
        chartDrawTrackNameCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chartDrawTrackNameCBActionPerformed(evt);
            }
        });

        bottomBorderCB.setText("Draw Bottom Border");
        bottomBorderCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bottomBorderCBActionPerformed(evt);
            }
        });

        jLabel7.setText("<html><i>If selected charts are dynamically rescaled to the range of the data in view.");

        colorBordersCB.setText("Color Borders");
        colorBordersCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorBordersCBActionPerformed(evt);
            }
        });

        labelYAxisCB.setText("Label Y Axis");
        labelYAxisCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                labelYAxisCBActionPerformed(evt);
            }
        });

        autoscaleCB.setText("Continuous Autoscale");
        autoscaleCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                autoscaleCBActionPerformed(evt);
            }
        });

        jLabel9.setText("<html><i>Draw a label centered over the track provided<br>the track height is at least 25 pixels. ");

        showDatarangeCB.setText("Show Data Range");
        showDatarangeCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showDatarangeCBActionPerformed(evt);
            }
        });
        showDatarangeCB.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                showDatarangeCBFocusLost(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(label1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel4Layout.createSequentialGroup()
                        .add(20, 20, 20)
                        .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel4Layout.createSequentialGroup()
                                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(autoscaleCB)
                                    .add(showDatarangeCB))
                                .add(18, 18, 18)
                                .add(jLabel7, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE))
                            .add(jPanel4Layout.createSequentialGroup()
                                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(topBorderCB)
                                    .add(colorBordersCB)
                                    .add(bottomBorderCB)
                                    .add(labelYAxisCB)
                                    .add(chartDrawTrackNameCB))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 403, Short.MAX_VALUE)))))
                .addContainerGap())
            .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel4Layout.createSequentialGroup()
                    .addContainerGap(221, Short.MAX_VALUE)
                    .add(jLabel9, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(84, 84, 84)))
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(label1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(topBorderCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(bottomBorderCB)
                .add(7, 7, 7)
                .add(colorBordersCB)
                .add(18, 18, 18)
                .add(chartDrawTrackNameCB)
                .add(23, 23, 23)
                .add(labelYAxisCB)
                .add(18, 18, 18)
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(autoscaleCB)
                    .add(jLabel7, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 50, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(showDatarangeCB)
                .add(36, 36, 36))
            .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(jPanel4Layout.createSequentialGroup()
                    .add(131, 131, 131)
                    .add(jLabel9, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .addContainerGap(177, Short.MAX_VALUE)))
        );

        chartPanel.add(jPanel4);
        jPanel4.setBounds(20, 30, 590, 340);

        tabbedPane.addTab("Charts", chartPanel);

        alignmentPanel.setLayout(null);

        samMaxLevelField.setText("jTextField1");
        samMaxLevelField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMaxLevelFieldActionPerformed(evt);
            }
        });
        samMaxLevelField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMaxLevelFieldFocusLost(evt);
            }
        });

        snpThresholdField.setText("0");
        snpThresholdField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                snpThresholdFieldActionPerformed(evt);
            }
        });
        snpThresholdField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                snpThresholdFieldFocusLost(evt);
            }
        });

        jLabel11.setText("Visibility range threshold (kb)");

        jLabel26.setText("Coverage allele-freq threshold");

        jLabel17.setText("Insert size flagging threshold:");

        jLabel16.setText("<html><i>Reads with qualities  below the threshold are not shown.");

        mappingQualityThresholdField.setText("0");
        mappingQualityThresholdField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mappingQualityThresholdFieldActionPerformed(evt);
            }
        });
        mappingQualityThresholdField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                mappingQualityThresholdFieldFocusLost(evt);
            }
        });

        jLabel14.setText("<html><i>Maximum number of rows of alignments to display.");

        insertSizeThresholdField.setText("0");
        insertSizeThresholdField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                insertSizeThresholdFieldActionPerformed(evt);
            }
        });
        insertSizeThresholdField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                insertSizeThresholdFieldFocusLost(evt);
            }
        });

        jLabel13.setText("Maximum read depth");

        jLabel15.setText("Mapping quality threshold:");

        jLabel18.setText("<html><i>Paired end alignments with insert sizes > this value are flagged.");

        samMaxWindowSizeField.setText("jTextField1");
        samMaxWindowSizeField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMaxWindowSizeFieldActionPerformed(evt);
            }
        });
        samMaxWindowSizeField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMaxWindowSizeFieldFocusLost(evt);
            }
        });

        jLabel12.setText("<html><i>Nominal window size at which alignments become visible");

        org.jdesktop.layout.GroupLayout jPanel11Layout = new org.jdesktop.layout.GroupLayout(jPanel11);
        jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(
            jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel11Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel11Layout.createSequentialGroup()
                        .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel11)
                            .add(jLabel13)
                            .add(jLabel15)
                            .add(jLabel17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 200, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(samMaxWindowSizeField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(samMaxLevelField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(mappingQualityThresholdField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 80, Short.MAX_VALUE)
                            .add(insertSizeThresholdField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 80, Short.MAX_VALUE)))
                    .add(jPanel11Layout.createSequentialGroup()
                        .add(jLabel26, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 200, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(snpThresholdField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 75, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel12, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 390, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 414, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel11Layout.linkSize(new java.awt.Component[] {insertSizeThresholdField, mappingQualityThresholdField, samMaxLevelField, samMaxWindowSizeField, snpThresholdField}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        jPanel11Layout.setVerticalGroup(
            jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel11Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(jLabel11)
                    .add(samMaxWindowSizeField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel12, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(jLabel13)
                    .add(samMaxLevelField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel14, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(jLabel15)
                    .add(mappingQualityThresholdField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel11Layout.createSequentialGroup()
                        .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel17)
                            .add(insertSizeThresholdField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel11Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel26)
                            .add(snpThresholdField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(jLabel18, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 40, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        samMinBaseQualityField.setText("0");
        samMinBaseQualityField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMinBaseQualityFieldActionPerformed(evt);
            }
        });
        samMinBaseQualityField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMinBaseQualityFieldFocusLost(evt);
            }
        });

        samShadeMismatchedBaseCB.setText("Shade mismatched bases by quality. ");
        samShadeMismatchedBaseCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samShadeMismatchedBaseCBActionPerformed(evt);
            }
        });

        jLabel20.setText("Max:");

        samMaxBaseQualityField.setText("0");
        samMaxBaseQualityField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMaxBaseQualityFieldActionPerformed(evt);
            }
        });
        samMaxBaseQualityField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMaxBaseQualityFieldFocusLost(evt);
            }
        });

        showCovTrackCB.setText("Show coverage track");
        showCovTrackCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showCovTrackCBActionPerformed(evt);
            }
        });

        samShowDuplicatesCB.setText("Show duplicate reads");
        samShowDuplicatesCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samShowDuplicatesCBActionPerformed(evt);
            }
        });

        showRefSeqCB.setText("Show reference sequence");
        showRefSeqCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showRefSeqCBActionPerformed(evt);
            }
        });

        jLabel19.setText("Min: ");

        filterCB.setText("Filter alignments");
        filterCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterCBActionPerformed(evt);
            }
        });

        filterURL.setText("URL or path to filter file");
        filterURL.setEnabled(false);
        filterURL.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                filterURLActionPerformed(evt);
            }
        });
        filterURL.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                filterURLFocusLost(evt);
            }
        });

        samFlagUnmappedPairCB.setText("Flag unmapped pairs");
        samFlagUnmappedPairCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samFlagUnmappedPairCBActionPerformed(evt);
            }
        });

        shadeCenterCB.setText("Shade alignments intersecting center");
        shadeCenterCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                shadeCenterCBActionPerformed(evt);
            }
        });

        jLabel10.setText("<html>Chromosome color legend &nbsp;&nbsp;&nbsp;<i>Used to flag paired end reads with mates on other chromosomes");

        org.jdesktop.layout.GroupLayout legendPanelLayout = new org.jdesktop.layout.GroupLayout(legendPanel);
        legendPanel.setLayout(legendPanelLayout);
        legendPanelLayout.setHorizontalGroup(
            legendPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 602, Short.MAX_VALUE)
        );
        legendPanelLayout.setVerticalGroup(
            legendPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 25, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout jPanel12Layout = new org.jdesktop.layout.GroupLayout(jPanel12);
        jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(
            jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel12Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel12Layout.createSequentialGroup()
                        .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(showCovTrackCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 270, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jPanel12Layout.createSequentialGroup()
                                .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(jPanel12Layout.createSequentialGroup()
                                        .add(samShadeMismatchedBaseCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 290, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .add(12, 12, 12)
                                        .add(jLabel19))
                                    .add(samFlagUnmappedPairCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 310, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(samShowDuplicatesCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 290, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(showRefSeqCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 270, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(shadeCenterCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 450, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(jPanel12Layout.createSequentialGroup()
                                        .add(samMinBaseQualityField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 50, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                        .add(71, 71, 71)
                                        .add(samMaxBaseQualityField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 50, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jLabel20))
                    .add(jLabel10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 640, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel12Layout.createSequentialGroup()
                        .add(filterCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 144, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(42, 42, 42)
                        .add(filterURL, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 482, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(legendPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel12Layout.setVerticalGroup(
            jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel12Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jPanel12Layout.createSequentialGroup()
                        .add(samShowDuplicatesCB)
                        .add(30, 30, 30))
                    .add(samFlagUnmappedPairCB)
                    .add(jPanel12Layout.createSequentialGroup()
                        .add(showRefSeqCB)
                        .add(7, 7, 7)
                        .add(shadeCenterCB)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(showCovTrackCB)
                .add(11, 11, 11)
                .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel20)
                    .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                        .add(samShadeMismatchedBaseCB)
                        .add(samMinBaseQualityField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(samMaxBaseQualityField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(jLabel19)))
                .add(18, 18, 18)
                .add(jPanel12Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(filterCB)
                    .add(filterURL, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(jLabel10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 30, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(legendPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout jPanel13Layout = new org.jdesktop.layout.GroupLayout(jPanel13);
        jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(
            jPanel13Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 656, Short.MAX_VALUE)
        );
        jPanel13Layout.setVerticalGroup(
            jPanel13Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 132, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel12, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 740, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel13, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel11, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(20, 20, 20)
                .add(jPanel11, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 203, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel12, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel13, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        alignmentPanel.add(jPanel1);
        jPanel1.setBounds(0, 0, 760, 510);

        tabbedPane.addTab("Alignments", alignmentPanel);

        expressionPane.setLayout(null);

        probeMappingButtonGroup.add(expMapToGeneCB);
        expMapToGeneCB.setText("Map probes to genes");
        expMapToGeneCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                expMapToGeneCBActionPerformed(evt);
            }
        });

        jLabel24.setText("Expression probe mapping options: ");

        probeMappingButtonGroup.add(expMapToLociCB);
        expMapToLociCB.setText("<html>Map probes to target loci");
        expMapToLociCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                expMapToLociCBActionPerformed(evt);
            }
        });

        jLabel21.setText("<html><i>Note: Changes will not affect currently loaded datasets.");

        org.jdesktop.layout.GroupLayout jPanel8Layout = new org.jdesktop.layout.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel8Layout.createSequentialGroup()
                .add(jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel8Layout.createSequentialGroup()
                        .add(45, 45, 45)
                        .add(jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(expMapToLociCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(expMapToGeneCB)))
                    .add(jPanel8Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel8Layout.createSequentialGroup()
                                .add(24, 24, 24)
                                .add(jLabel21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 497, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jLabel24))))
                .addContainerGap(179, Short.MAX_VALUE))
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel24)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 44, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(expMapToLociCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(14, 14, 14)
                .add(expMapToGeneCB)
                .addContainerGap(158, Short.MAX_VALUE))
        );

        expressionPane.add(jPanel8);
        jPanel8.setBounds(10, 30, 720, 310);

        tabbedPane.addTab("Probes", expressionPane);

        advancedPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 10, 1, 10));
        advancedPanel.setLayout(null);

        jLabel1.setText("Genome Server URL");

        genomeServerURLTextField.setText("jTextField1");
        genomeServerURLTextField.setEnabled(false);
        genomeServerURLTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                genomeServerURLTextFieldActionPerformed(evt);
            }
        });
        genomeServerURLTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                genomeServerURLTextFieldFocusLost(evt);
            }
        });

        jLabel6.setText("Data Registry URL");

        dataServerURLTextField.setEnabled(false);
        dataServerURLTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dataServerURLTextFieldActionPerformed(evt);
            }
        });
        dataServerURLTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                dataServerURLTextFieldFocusLost(evt);
            }
        });

        editServerPropertiesCB.setText("Edit server properties");
        editServerPropertiesCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editServerPropertiesCBActionPerformed(evt);
            }
        });

        clearGenomeCacheButton.setText("Clear Genome Cache");
        clearGenomeCacheButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearGenomeCacheButtonActionPerformed(evt);
            }
        });

        jButton1.setText("Reset to Defaults");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(29, 29, 29)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel1)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jLabel6)
                                .add(44, 44, 44)
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                    .add(dataServerURLTextField)
                                    .add(genomeServerURLTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 494, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))))
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(editServerPropertiesCB)
                        .add(18, 18, 18)
                        .add(jButton1))
                    .add(clearGenomeCacheButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(editServerPropertiesCB)
                    .add(jButton1))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(jLabel1)
                    .add(genomeServerURLTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(dataServerURLTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(clearGenomeCacheButton)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        enablePortCB.setText("Enable port");
        enablePortCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enablePortCBActionPerformed(evt);
            }
        });

        portField.setText("60151");
        portField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                portFieldActionPerformed(evt);
            }
        });
        portField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                portFieldFocusLost(evt);
            }
        });

        jLabel22.setFont(new java.awt.Font("Lucida Grande", 2, 13));
        jLabel22.setText("Enable port to send commands and http requests to IGV. ");

        org.jdesktop.layout.GroupLayout jPanel7Layout = new org.jdesktop.layout.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel7Layout.createSequentialGroup()
                .add(jPanel7Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel7Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(enablePortCB)
                        .add(39, 39, 39)
                        .add(portField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 126, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel7Layout.createSequentialGroup()
                        .add(48, 48, 48)
                        .add(jLabel22)))
                .addContainerGap(308, Short.MAX_VALUE))
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel7Layout.createSequentialGroup()
                .add(28, 28, 28)
                .add(jPanel7Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(enablePortCB)
                    .add(portField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jLabel22)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel7, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(20, 20, 20)
                .add(jPanel7, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 1, Short.MAX_VALUE)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );

        advancedPanel.add(jPanel3);
        jPanel3.setBounds(10, 0, 750, 330);

        useByteRangeCB.setText("Use http byte-range requests");
        useByteRangeCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useByteRangeCBActionPerformed(evt);
            }
        });

        jLabel25.setFont(new java.awt.Font("Lucida Grande", 2, 13));
        jLabel25.setText("<html>This option applies to certain \"Load from Server...\" tracks hosted at the Broad.    Disable this option if you are unable to load the phastCons conservation track under the hg18 annotations.");

        org.jdesktop.layout.GroupLayout jPanel9Layout = new org.jdesktop.layout.GroupLayout(jPanel9);
        jPanel9.setLayout(jPanel9Layout);
        jPanel9Layout.setHorizontalGroup(
            jPanel9Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel9Layout.createSequentialGroup()
                .add(jPanel9Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel9Layout.createSequentialGroup()
                        .add(44, 44, 44)
                        .add(jLabel25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 601, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel9Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(useByteRangeCB)))
                .addContainerGap(65, Short.MAX_VALUE))
        );
        jPanel9Layout.setVerticalGroup(
            jPanel9Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel9Layout.createSequentialGroup()
                .addContainerGap()
                .add(useByteRangeCB, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 38, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel25, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 54, Short.MAX_VALUE)
                .add(6, 6, 6))
        );

        advancedPanel.add(jPanel9);
        jPanel9.setBounds(30, 340, 710, 120);

        tabbedPane.addTab("Advanced", advancedPanel);

        proxyUsernameField.setText("jTextField1");
        proxyUsernameField.setEnabled(false);
        proxyUsernameField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                proxyUsernameFieldFocusLost(evt);
            }
        });
        jLabel28.setText("Username");

        authenticateProxyCB.setText("Authentication required");
        authenticateProxyCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                authenticateProxyCBActionPerformed(evt);
            }
        });

        jLabel29.setText("Password");

        proxyPasswordField.setText("jPasswordField1");
        proxyPasswordField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                proxyPasswordFieldFocusLost(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel16Layout = new org.jdesktop.layout.GroupLayout(jPanel16);
        jPanel16.setLayout(jPanel16Layout);
        jPanel16Layout.setHorizontalGroup(
            jPanel16Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel16Layout.createSequentialGroup()
                .add(jPanel16Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel16Layout.createSequentialGroup()
                        .add(28, 28, 28)
                        .add(jPanel16Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel28)
                            .add(jLabel29))
                        .add(37, 37, 37)
                        .add(jPanel16Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                            .add(proxyPasswordField)
                            .add(proxyUsernameField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 261, Short.MAX_VALUE)))
                    .add(jPanel16Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(authenticateProxyCB)))
                .addContainerGap(219, Short.MAX_VALUE))
        );
        jPanel16Layout.setVerticalGroup(
            jPanel16Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel16Layout.createSequentialGroup()
                .add(17, 17, 17)
                .add(authenticateProxyCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel16Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel28)
                    .add(proxyUsernameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel16Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel29)
                    .add(proxyPasswordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        proxyHostField.setText("jTextField1");
        proxyHostField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                proxyHostFieldActionPerformed(evt);
            }
        });
        proxyHostField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                proxyHostFieldFocusLost(evt);
            }
        });

        proxyPortField.setText("jTextField1");
        proxyPortField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                proxyPortFieldActionPerformed(evt);
            }
        });
        proxyPortField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                proxyPortFieldFocusLost(evt);
            }
        });

        jLabel27.setText("Proxy port");

        jLabel23.setText("Proxy host");

        useProxyCB.setText("Use proxy");
        useProxyCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                useProxyCBActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel17Layout = new org.jdesktop.layout.GroupLayout(jPanel17);
        jPanel17.setLayout(jPanel17Layout);
        jPanel17Layout.setHorizontalGroup(
            jPanel17Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel17Layout.createSequentialGroup()
                .add(jPanel17Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel17Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel17Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel27)
                            .add(jLabel23))
                        .add(28, 28, 28)
                        .add(jPanel17Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(proxyPortField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 108, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(proxyHostField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 485, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(jPanel17Layout.createSequentialGroup()
                        .add(9, 9, 9)
                        .add(useProxyCB)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPanel17Layout.setVerticalGroup(
            jPanel17Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel17Layout.createSequentialGroup()
                .addContainerGap(29, Short.MAX_VALUE)
                .add(useProxyCB)
                .add(18, 18, 18)
                .add(jPanel17Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel23)
                    .add(proxyHostField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel17Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel27)
                    .add(proxyPortField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout jPanel15Layout = new org.jdesktop.layout.GroupLayout(jPanel15);
        jPanel15.setLayout(jPanel15Layout);
        jPanel15Layout.setHorizontalGroup(
            jPanel15Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel15Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel15Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel15Layout.createSequentialGroup()
                        .add(jPanel17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 607, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .add(jPanel15Layout.createSequentialGroup()
                        .add(jPanel16, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(33, 33, 33))))
        );
        jPanel15Layout.setVerticalGroup(
            jPanel15Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel15Layout.createSequentialGroup()
                .add(16, 16, 16)
                .add(jPanel17, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(18, 18, 18)
                .add(jPanel16, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(39, 39, 39))
        );

        org.jdesktop.layout.GroupLayout jPanel14Layout = new org.jdesktop.layout.GroupLayout(jPanel14);
        jPanel14.setLayout(jPanel14Layout);
        jPanel14Layout.setHorizontalGroup(
            jPanel14Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel14Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(103, Short.MAX_VALUE))
        );
        jPanel14Layout.setVerticalGroup(
            jPanel14Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel14Layout.createSequentialGroup()
                .add(28, 28, 28)
                .add(jPanel15, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(146, Short.MAX_VALUE))
        );

        tabbedPane.addTab("Proxy", jPanel14);

        getContentPane().add(tabbedPane, java.awt.BorderLayout.CENTER);
        tabbedPane.getAccessibleContext().setAccessibleName("Advanced");

        okButton.setText("OK"); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        okCancelButtonPanel.add(okButton);

        cancelButton.setText("Cancel"); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        okCancelButtonPanel.add(cancelButton);

        getContentPane().add(okCancelButtonPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        canceled = true;
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed

        if (inputValidated) {

            checkForProbeChanges();

            lastSelectedIndex = tabbedPane.getSelectedIndex();

            // Store the changed preferences
            prefMgr.putAll(updatedPreferenceMap);

            if (updatedPreferenceMap.containsKey(PreferenceManager.PORT_ENABLED) ||
                    updatedPreferenceMap.containsKey(PreferenceManager.PORT_NUMBER)) {
                CommandListener.halt();
                if (enablePortCB.isSelected()) {
                    CommandListener.start();
                }
            }

            // Clear the map that holds recents preference changes
            updatedPreferenceMap.clear();

            checkForSAMChanges();

            // Overlays
            if (updateOverlays) {
                IGVMainFrame.getInstance().getTrackManager().resetOverlayTracks();
            }

            // Proxies
            if (proxySettingsChanged) {
                IGVHttpUtils.updateProxySettings();
            }


            IGVMainFrame.getInstance().repaint();
            setVisible(false);
        } else {
            resetValidation();
        }
    }//GEN-LAST:event_okButtonActionPerformed

    private void expMapToLociCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToLociCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(
                expMapToGeneCB.isSelected()));
    }//GEN-LAST:event_expMapToLociCBActionPerformed

    private void clearGenomeCacheButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearGenomeCacheButtonActionPerformed
        GenomeManager.getInstance().clearGenomeCache();
        JOptionPane.showMessageDialog(this, "<html>Cached genomes have been removed.");
    }//GEN-LAST:event_clearGenomeCacheButtonActionPerformed

    private void editServerPropertiesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editServerPropertiesCBActionPerformed
        boolean edit = editServerPropertiesCB.isSelected();
        dataServerURLTextField.setEnabled(edit);
        genomeServerURLTextField.setEnabled(edit);
    }//GEN-LAST:event_editServerPropertiesCBActionPerformed

    private void dataServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldFocusLost
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }//GEN-LAST:event_dataServerURLTextFieldFocusLost

    private void dataServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldActionPerformed
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }//GEN-LAST:event_dataServerURLTextFieldActionPerformed

    private void genomeServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldFocusLost
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, attributeName);
    }//GEN-LAST:event_genomeServerURLTextFieldFocusLost

    private void genomeServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldActionPerformed
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, attributeName);
    }//GEN-LAST:event_genomeServerURLTextFieldActionPerformed

    private void insertSizeThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_insertSizeThresholdFieldFocusLost
        this.insertSizeThresholdFieldActionPerformed(null);
    }//GEN-LAST:event_insertSizeThresholdFieldFocusLost

    private void insertSizeThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_insertSizeThresholdFieldActionPerformed
        String insertThreshold = insertSizeThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.INSERT_SIZE_THRESHOLD,
                    insertThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("BlastMapping quality threshold must be an integer.");
        }
    }//GEN-LAST:event_insertSizeThresholdFieldActionPerformed

    private void mappingQualityThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_mappingQualityThresholdFieldFocusLost
        mappingQualityThresholdFieldActionPerformed(null);
    }//GEN-LAST:event_mappingQualityThresholdFieldFocusLost

    private void mappingQualityThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mappingQualityThresholdFieldActionPerformed
        String qualityThreshold = mappingQualityThresholdField.getText().trim();
        try {
            Integer.parseInt(qualityThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.QUALITY_THRESHOLD,
                    qualityThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage(
                    "BlastMapping quality threshold must be an integer.");
        }
    }//GEN-LAST:event_mappingQualityThresholdFieldActionPerformed

    private void samMaxLevelFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxLevelFieldFocusLost
        samMaxLevelFieldActionPerformed(null);
    }//GEN-LAST:event_samMaxLevelFieldFocusLost

    private void samMaxLevelFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMaxLevelFieldActionPerformed
        String maxLevelString = samMaxLevelField.getText().trim();
        try {
            Integer.parseInt(maxLevelString);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_LEVELS,
                    maxLevelString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Maximum read depth must be an integer.");
        }
    }//GEN-LAST:event_samMaxLevelFieldActionPerformed

    private void samShadeMismatchedBaseCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samShadeMismatchedBaseCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHADE_BASE_QUALITY,
                String.valueOf(samShadeMismatchedBaseCB.isSelected()));
        samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());

    }//GEN-LAST:event_samShadeMismatchedBaseCBActionPerformed

    private void samFlagUnmappedPairCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samFlagUnmappedPairCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.FLAG_UNMAPPED_PAIR,
                String.valueOf(samFlagUnmappedPairCB.isSelected()));
    }//GEN-LAST:event_samFlagUnmappedPairCBActionPerformed

    private void samShowDuplicatesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samShowDuplicatesCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHOW_DUPLICATES,
                String.valueOf(samShowDuplicatesCB.isSelected()));
    }//GEN-LAST:event_samShowDuplicatesCBActionPerformed

    private void samMaxWindowSizeFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxWindowSizeFieldFocusLost
        String maxSAMWindowSize = samMaxWindowSizeField.getText().trim();
        try {
            Float.parseFloat(maxSAMWindowSize);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_VISIBLE_RANGE,
                    maxSAMWindowSize);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number.");
        }
    }//GEN-LAST:event_samMaxWindowSizeFieldFocusLost

    private void samMaxWindowSizeFieldActionPerformed(java.awt.event.ActionEvent evt) {
        String maxSAMWindowSize = String.valueOf(samMaxWindowSizeField.getText());
        try {
            Float.parseFloat(maxSAMWindowSize);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_VISIBLE_RANGE,
                    maxSAMWindowSize);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Visibility range must be a number.");
        }
    }

    private void chartDrawTrackNameCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.DRAW_TRACK_NAME,
                String.valueOf(chartDrawTrackNameCB.isSelected()));
    }

    private void autoscaleCBActionPerformed(java.awt.event.ActionEvent evt) {
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.AUTOSCALE, String.valueOf(autoscaleCB.isSelected()));
    }


    private void colorBordersCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorBordersCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.COLOR_BORDERS,
                String.valueOf(colorBordersCB.isSelected()));
    }//GEN-LAST:event_colorBordersCBActionPerformed

    private void bottomBorderCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bottomBorderCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.DRAW_BOTTOM_BORDER,
                String.valueOf(bottomBorderCB.isSelected()));
    }//GEN-LAST:event_bottomBorderCBActionPerformed

    private void topBorderCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_topBorderCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.DRAW_TOP_BORDER,
                String.valueOf(topBorderCB.isSelected()));
    }//GEN-LAST:event_topBorderCBActionPerformed

    private void chooseOverlayColorsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseOverlayColorsButtonActionPerformed
        (new LegendDialog(IGVMainFrame.getInstance(), true)).setVisible(true);
    }//GEN-LAST:event_chooseOverlayColorsButtonActionPerformed

    private void colorOverlyCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorOverlyCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.COLOR_OVERLAY_KEY, String.valueOf(
                colorOverlyCB.isSelected()));
    }//GEN-LAST:event_colorOverlyCBActionPerformed

    private void displayTracksCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_displayTracksCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.DISPLAY_OVERLAY_TRACKS_KEY, String.valueOf(
                displayTracksCB.isSelected()));
        updateOverlays = true;
    }//GEN-LAST:event_displayTracksCBActionPerformed

    private void overlayTrackCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overlayTrackCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_TRACKS_KEY, String.valueOf(
                overlayTrackCB.isSelected()));
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        colorOverlyCB.setEnabled(overlayTrackCB.isSelected());
        chooseOverlayColorsButton.setEnabled(overlayTrackCB.isSelected());

        updateOverlays = true;
    }//GEN-LAST:event_overlayTrackCBActionPerformed

    private void overlayAttributeTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldKeyTyped
        // TODO add your handling code here:
    }//GEN-LAST:event_overlayAttributeTextFieldKeyTyped

    private void overlayAttributeTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldFocusLost
        String attributeName = String.valueOf(overlayAttributeTextField.getText());
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY, attributeName);
        updateOverlays = true;
    }//GEN-LAST:event_overlayAttributeTextFieldFocusLost

    private void overlayAttributeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldActionPerformed
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY, String.valueOf(
                overlayAttributeTextField.getText()));
        updateOverlays = true;
        // TODO add your handling code here:
    }//GEN-LAST:event_overlayAttributeTextFieldActionPerformed

    private void defaultTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_defaultTrackHeightFieldFocusLost
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultTrackHeightFieldFocusLost

    private void defaultTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultTrackHeightFieldActionPerformed
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultTrackHeightFieldActionPerformed

    private void trackNameAttributeFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_trackNameAttributeFieldFocusLost
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.toUpperCase().trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }//GEN-LAST:event_trackNameAttributeFieldFocusLost

    private void trackNameAttributeFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trackNameAttributeFieldActionPerformed
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.toUpperCase().trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }//GEN-LAST:event_trackNameAttributeFieldActionPerformed

    private void defaultChartTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_defaultChartTrackHeightFieldFocusLost
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.CHART_TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultChartTrackHeightFieldFocusLost

    private void defaultChartTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultChartTrackHeightFieldActionPerformed
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.CHART_TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultChartTrackHeightFieldActionPerformed

    private void showAttributesDisplayCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showAttributesDisplayCheckBoxActionPerformed
        boolean state = ((JCheckBox) evt.getSource()).isSelected();
        updatedPreferenceMap.put(PreferenceManager.SHOW_ATTRIBUTE_VIEWS_KEY, String.valueOf(state));
        IGVMainFrame.getInstance().doShowAttributeDisplay(state);
    }//GEN-LAST:event_showAttributesDisplayCheckBoxActionPerformed

    private void joinSegmentsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_joinSegmentsCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.JOIN_ADJACENT_SEGMENTS_KEY, String.valueOf(
                joinSegmentsCB.isSelected()));
    }//GEN-LAST:event_joinSegmentsCBActionPerformed

    private void combinePanelsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_combinePanelsCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SHOW_SINGLE_TRACK_PANE_KEY, String.valueOf(
                combinePanelsCB.isSelected()));
    }//GEN-LAST:event_combinePanelsCBActionPerformed

    private void showMissingDataCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showMissingDataCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SHOW_MISSING_DATA_KEY, String.valueOf(
                showMissingDataCB.isSelected()));
    }//GEN-LAST:event_showMissingDataCBActionPerformed

    private void showRefSeqCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showRefSeqCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHOW_REF_SEQ,
                String.valueOf(showRefSeqCB.isSelected()));

    }//GEN-LAST:event_showRefSeqCBActionPerformed

    private void samMinBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMinBaseQualityFieldActionPerformed
        String baseQuality = samMinBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.BASE_QUALITY_MIN, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }
    }//GEN-LAST:event_samMinBaseQualityFieldActionPerformed

    private void samMinBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMinBaseQualityFieldFocusLost
        samMinBaseQualityFieldActionPerformed(null);
    }//GEN-LAST:event_samMinBaseQualityFieldFocusLost

    private void samMaxBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMaxBaseQualityFieldActionPerformed
        String baseQuality = samMaxBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.BASE_QUALITY_MAX, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Base quality must be an integer.");
        }

    }//GEN-LAST:event_samMaxBaseQualityFieldActionPerformed

    private void samMaxBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxBaseQualityFieldFocusLost
        samMaxBaseQualityFieldActionPerformed(null);
    }//GEN-LAST:event_samMaxBaseQualityFieldFocusLost

    private void expMapToGeneCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToGeneCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(expMapToGeneCB.isSelected()));

    }//GEN-LAST:event_expMapToGeneCBActionPerformed

    private void labelYAxisCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_labelYAxisCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.Y_AXIS, String.valueOf(labelYAxisCB.isSelected()));
    }//GEN-LAST:event_labelYAxisCBActionPerformed

    private void shadeCenterCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_shadeCenterCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAMPreferences.SHADE_CENTER, String.valueOf(shadeCenterCB.isSelected()));

    }//GEN-LAST:event_shadeCenterCBActionPerformed

    private void showCovTrackCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showCovTrackCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAMPreferences.SHOW_COV_TRACK, String.valueOf(showCovTrackCB.isSelected()));
    }//GEN-LAST:event_showCovTrackCBActionPerformed

    private void filterCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAMPreferences.FILTER_ALIGNMENTS, String.valueOf(filterCB.isSelected()));
        filterURL.setEnabled(filterCB.isSelected());
    }//GEN-LAST:event_filterCBActionPerformed

    private void filterURLActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterURLActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.FILTER_URL,
                String.valueOf(filterURL.getText()));

    }//GEN-LAST:event_filterURLActionPerformed

    private void filterURLFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_filterURLFocusLost
        filterURLActionPerformed(null);
    }//GEN-LAST:event_filterURLFocusLost

    private void portFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_portFieldActionPerformed
        String portString = portField.getText().trim();
        try {
            Integer.parseInt(portString);
            updatedPreferenceMap.put(PreferenceManager.PORT_NUMBER, portString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Port must be an integer.");
        }
    }//GEN-LAST:event_portFieldActionPerformed

    private void portFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_portFieldFocusLost
        portFieldActionPerformed(null);
    }//GEN-LAST:event_portFieldFocusLost

    private void enablePortCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enablePortCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PORT_ENABLED, String.valueOf(enablePortCB.isSelected()));
        portField.setEnabled(enablePortCB.isSelected());

    }//GEN-LAST:event_enablePortCBActionPerformed

    private void expandCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expandCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.EXPAND_FEAUTRE_TRACKS,
                String.valueOf(expandCB.isSelected()));
    }//GEN-LAST:event_expandCBActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        genomeServerURLTextField.setEnabled(true);
        genomeServerURLTextField.setText(UIConstants.DEFAULT_SERVER_GENOME_ARCHIVE_LIST);
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, null);
        dataServerURLTextField.setEnabled(true);
        dataServerURLTextField.setText(PreferenceManager.DEFAULT_DATA_SERVER_URL);
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, null);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void searchZoomCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchZoomCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SEARCH_ZOOM, String.valueOf(searchZoomCB.isSelected()));
    }//GEN-LAST:event_searchZoomCBActionPerformed

    private void useByteRangeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_useByteRangeCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.USE_BYTE_RANGE, String.valueOf(useByteRangeCB.isSelected()));
    }//GEN-LAST:event_useByteRangeCBActionPerformed

    private void showDatarangeCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showDatarangeCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.SHOW_DATA_RANGE, String.valueOf(showDatarangeCB.isSelected()));
    }//GEN-LAST:event_showDatarangeCBActionPerformed

    private void showDatarangeCBFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_showDatarangeCBFocusLost
        showDatarangeCBActionPerformed(null);
    }//GEN-LAST:event_showDatarangeCBFocusLost

    private void snpThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {                                                  
        String snpThreshold = snpThresholdField.getText().trim();
        try {
            Double.parseDouble(snpThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.ALLELE_THRESHOLD, snpThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            MessageUtils.showMessage("Allele frequency threshold must be a number.");
        }
    }

    private void snpThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {                                            
        snpThresholdFieldActionPerformed(null);
    }

    private void normalizeCoverageCBActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        updatedPreferenceMap.put(PreferenceManager.NORMALIZE_COVERAGE, String.valueOf(normalizeCoverageCB.isSelected()));
        portField.setEnabled(enablePortCB.isSelected());

    }


    // Proxy settings

    private void useProxyCBActionPerformed(java.awt.event.ActionEvent evt) {                                           
        proxySettingsChanged = true;
        boolean useProxy = useProxyCB.isSelected();
        boolean authenticateProxy = authenticateProxyCB.isSelected();
        portField.setEnabled(enablePortCB.isSelected());
        updateProxyState(useProxy, authenticateProxy);
        updatedPreferenceMap.put(PreferenceManager.USE_PROXY, String.valueOf(useProxy));

    }


    private void authenticateProxyCBActionPerformed(java.awt.event.ActionEvent evt) {                                                    
        proxySettingsChanged = true;
        boolean useProxy = useProxyCB.isSelected();
        boolean authenticateProxy = authenticateProxyCB.isSelected();
        portField.setEnabled(enablePortCB.isSelected());
        updateProxyState(useProxy, authenticateProxy);
        updatedPreferenceMap.put(PreferenceManager.PROXY_AUTHENTICATE, String.valueOf(authenticateProxy));

    }


    // Host

    private void proxyHostFieldFocusLost(java.awt.event.FocusEvent evt) {                                         
        proxyHostFieldActionPerformed(null);
    }

    private void proxyHostFieldActionPerformed(java.awt.event.ActionEvent evt) {                                               
        proxySettingsChanged = true;
        updatedPreferenceMap.put(PreferenceManager.PROXY_HOST, proxyHostField.getText());
    }

    private void proxyPortFieldFocusLost(java.awt.event.FocusEvent evt) {                                         
        proxyPortFieldActionPerformed(null);
    }

    private void proxyPortFieldActionPerformed(java.awt.event.ActionEvent evt) {                                               
        try {
            Integer.parseInt(proxyPortField.getText());
            proxySettingsChanged = true;
            updatedPreferenceMap.put(PreferenceManager.PROXY_PORT, proxyPortField.getText());
        }
        catch (NumberFormatException e) {
            MessageUtils.showMessage("Proxy port must be an integer.");
        }
    }

    // Username

    private void proxyUsernameFieldFocusLost(java.awt.event.FocusEvent evt) {
        proxyUsernameFieldActionPerformed(null);
    }

    private void proxyUsernameFieldActionPerformed(java.awt.event.ActionEvent evt) {
        proxySettingsChanged = true;
        String user = proxyUsernameField.getText();
        updatedPreferenceMap.put(PreferenceManager.PROXY_USER, user);

    }

    // Password

    private void proxyPasswordFieldFocusLost(java.awt.event.FocusEvent evt) {                                             
        proxyPasswordFieldActionPerformed(null);
    }

    private void proxyPasswordFieldActionPerformed(java.awt.event.ActionEvent evt) {                                               
        proxySettingsChanged = true;
        String pw = proxyPasswordField.getText();
        String pwEncoded = Utilities.base64Encode(pw);
        updatedPreferenceMap.put(PreferenceManager.PROXY_PW, pwEncoded);

    }


    private void updateProxyState(boolean useProxy, boolean authenticateProxy) {
        proxyHostField.setEnabled(useProxy);
        proxyPortField.setEnabled(useProxy);
        proxyUsernameField.setEnabled(useProxy && authenticateProxy);
        proxyPasswordField.setEnabled(useProxy && authenticateProxy);
    }

    private void resetValidation() {
        // Assume valid input until proven otherwise
        inputValidated = true;
    }

    /*
     *    Object selection = geneMappingFile.getSelectedItem();
    String filename = (selection == null ? null : selection.toString().trim());
    updatedPreferenceMap.put(
    PreferenceManager.USER_PROBE_MAP_KEY,
    filename);
     * */

    private void initValues() {
        combinePanelsCB.setSelected(prefMgr.getShowSingleTrackPane());
        //drawExonNumbersCB.setSelected(preferenceManager.getDrawExonNumbers());
        defaultChartTrackHeightField.setText(String.valueOf(prefMgr.getDefaultChartTrackHeight()));
        defaultTrackHeightField.setText(String.valueOf(prefMgr.getDefaultTrackHeight()));
        displayTracksCB.setSelected(prefMgr.getDiplayOverlayTracks());
        overlayAttributeTextField.setText(prefMgr.getOverlayAttribute());
        overlayTrackCB.setSelected(prefMgr.getOverlayTracks());
        showMissingDataCB.setSelected(prefMgr.getShowMissingData());
        joinSegmentsCB.setSelected(prefMgr.isJoinAdjacentSegments());
        colorOverlyCB.setSelected(prefMgr.getColorOverlay());
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        colorOverlyCB.setEnabled(overlayTrackCB.isSelected());
        chooseOverlayColorsButton.setEnabled(overlayTrackCB.isSelected());

        enablePortCB.setSelected(prefMgr.isPortEnabled());
        portField.setText(String.valueOf(prefMgr.getPortNumber()));
        portField.setEnabled(enablePortCB.isSelected());

        expandCB.setSelected(prefMgr.isExpandTracks());
        searchZoomCB.setSelected(prefMgr.getBooleanPreference(PreferenceManager.SEARCH_ZOOM, true));

        useByteRangeCB.setSelected(prefMgr.getBooleanPreference(PreferenceManager.USE_BYTE_RANGE, true));
        showAttributesDisplayCheckBox.setSelected(prefMgr.getShowAttributeView());
        trackNameAttributeField.setText(prefMgr.getTrackAttributeName());
        PreferenceManager prefManager = PreferenceManager.getInstance();
        genomeServerURLTextField.setText(prefManager.getGenomeListURL());
        dataServerURLTextField.setText(prefMgr.getDataServerURL());

        // Chart panel
        PreferenceManager.ChartPreferences cp = prefManager.getChartPreferences();
        topBorderCB.setSelected(cp.isDrawTopBorder());
        bottomBorderCB.setSelected(cp.isDrawBottomBorder());
        colorBordersCB.setSelected(cp.isColorBorders());
        chartDrawTrackNameCB.setSelected(cp.isDrawTrackName());
        autoscaleCB.setSelected(cp.isAutoscale());
        showDatarangeCB.setSelected(cp.isShowDataRange());
        labelYAxisCB.setSelected(cp.isDrawAxis());

        PreferenceManager.SAMPreferences samPrefs = prefManager.getSAMPreferences();
        samMaxWindowSizeField.setText(String.valueOf(samPrefs.getMaxVisibleRange()));
        samMaxLevelField.setText(String.valueOf(samPrefs.getMaxLevels()));
        mappingQualityThresholdField.setText((String.valueOf(samPrefs.getQualityThreshold())));
        insertSizeThresholdField.setText((String.valueOf(samPrefs.getInsertSizeThreshold())));
        snpThresholdField.setText((String.valueOf(samPrefs.getAlleleFreqThreshold())));
        //samShowZeroQualityCB.setSelected(samPrefs.isShowZeroQuality());
        samShowDuplicatesCB.setSelected(samPrefs.isShowDuplicates());
        samFlagUnmappedPairCB.setSelected(samPrefs.isFlagUnmappedPair());
        showRefSeqCB.setSelected(samPrefs.isShowRefSequence());
        samShadeMismatchedBaseCB.setSelected(samPrefs.isShadeBaseQuality());
        samMinBaseQualityField.setText((String.valueOf(samPrefs.getBaseQualityMin())));
        samMaxBaseQualityField.setText((String.valueOf(samPrefs.getBaseQualityMax())));
        samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        shadeCenterCB.setSelected(samPrefs.isShadeCenter());
        showCovTrackCB.setSelected(samPrefs.isShowCoverageTrack());
        initialSamMaxLevel = samPrefs.getMaxLevels();
        initialSamQualityThreshold = samPrefs.getQualityThreshold();
        initialShowDuplicates = samPrefs.isShowDuplicates();
        initialAlleleFreqThreshold = samPrefs.getAlleleFreqThreshold();
        filterCB.setSelected(samPrefs.isFilterAlignments());
        if (samPrefs.getFilterURL() != null) {
            filterURL.setText(samPrefs.getFilterURL());
        }


        expMapToGeneCB.setSelected(prefMgr.isMapProbesToGenes());
        expMapToLociCB.setSelected(!prefMgr.isMapProbesToGenes());

        normalizeCoverageCB.setSelected(prefMgr.getBooleanPreference(PreferenceManager.NORMALIZE_COVERAGE, false));

        boolean useProxy = prefMgr.getBooleanPreference(PreferenceManager.USE_PROXY, false);
        useProxyCB.setSelected(useProxy);

        boolean authenticateProxy = prefMgr.getBooleanPreference(PreferenceManager.PROXY_AUTHENTICATE, false);
        authenticateProxyCB.setSelected(authenticateProxy);

        proxyHostField.setText(prefMgr.get(PreferenceManager.PROXY_HOST, ""));
        proxyPortField.setText(prefMgr.get(PreferenceManager.PROXY_PORT, ""));
        proxyUsernameField.setText(prefMgr.get(PreferenceManager.PROXY_USER, ""));
        String pwCoded = prefMgr.get(PreferenceManager.PROXY_PW, "");
        proxyPasswordField.setText(Utilities.base64Decode(pwCoded));

        updateProxyState(useProxy, authenticateProxy);
    }

    private void checkForSAMChanges() {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            int maxLevel = Integer.parseInt(samMaxLevelField.getText());
            int qualThreshold = Integer.parseInt(mappingQualityThresholdField.getText());
            boolean showDoops = samShowDuplicatesCB.isSelected();
            if (maxLevel > initialSamMaxLevel || qualThreshold != initialSamQualityThreshold ||
                    showDoops != initialShowDuplicates) {

                IGVMainFrame.getInstance().getTrackManager().reloadSAMTracks();
                IGVMainFrame.getInstance().repaint();


            }
        } catch (NumberFormatException numberFormatException) {
        } finally {
            WaitCursorManager.removeWaitCursor(token);
        }
    }

    private void checkForProbeChanges() {
        if (updatedPreferenceMap.containsKey(PreferenceManager.PROBE_MAPPING_KEY)) {
            ProbeToGeneMap.getInstance().clearProbeMappings();
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                PreferencesEditor dialog = new PreferencesEditor(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    //TODO move this to another class,  or resource bundle
    static String overlayText = "<html>These options control the treatment of mutation tracks.  " +
            "Mutation data may optionally<br>be overlayed on other tracks that have a matching attribute value " +
            "from the sample info <br>file. " +
            "This is normally an attribute that identifies a sample or patient. The attribute key <br>is specified in the" +
            "text field below.";

    public String getOverlayText() {
        return overlayText;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel advancedPanel;
    private javax.swing.JPanel alignmentPanel;
    private javax.swing.JCheckBox authenticateProxyCB;
    private javax.swing.JCheckBox autoscaleCB;
    private javax.swing.JCheckBox bottomBorderCB;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox chartDrawTrackNameCB;
    private javax.swing.JPanel chartPanel;
    private com.jidesoft.swing.JideButton chooseOverlayColorsButton;
    private javax.swing.JButton clearGenomeCacheButton;
    private javax.swing.JCheckBox colorBordersCB;
    private javax.swing.JCheckBox colorOverlyCB;
    private javax.swing.JCheckBox combinePanelsCB;
    private javax.swing.JTextField dataServerURLTextField;
    private javax.swing.JTextField defaultChartTrackHeightField;
    private javax.swing.JTextField defaultTrackHeightField;
    private javax.swing.JCheckBox displayTracksCB;
    private javax.swing.JCheckBox editServerPropertiesCB;
    private javax.swing.JCheckBox enablePortCB;
    private javax.swing.JRadioButton expMapToGeneCB;
    private javax.swing.JRadioButton expMapToLociCB;
    private javax.swing.JCheckBox expandCB;
    private javax.swing.JPanel expressionPane;
    private javax.swing.ButtonGroup featureStyleButtonGroup;
    private javax.swing.JCheckBox filterCB;
    private javax.swing.JTextField filterURL;
    private javax.swing.JPanel generalPanel;
    private javax.swing.JTextField genomeServerURLTextField;
    private javax.swing.JTextField insertSizeThresholdField;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel17;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JCheckBox joinSegmentsCB;
    private java.awt.Label label1;
    private javax.swing.JCheckBox labelYAxisCB;
    private javax.swing.JPanel legendPanel;
    private javax.swing.JTextField mappingQualityThresholdField;
    private javax.swing.JLabel missingDataExplanation;
    private javax.swing.JLabel missingDataExplanation2;
    private javax.swing.JLabel missingDataExplanation3;
    private javax.swing.JLabel missingDataExplanation4;
    private javax.swing.JLabel missingDataExplanation5;
    private javax.swing.JLabel missingDataExplanation6;
    private javax.swing.JLabel missingDataExplanation7;
    private javax.swing.JLabel missingDataExplanation8;
    private javax.swing.JCheckBox normalizeCoverageCB;
    private javax.swing.JButton okButton;
    private com.jidesoft.dialog.ButtonPanel okCancelButtonPanel;
    private javax.swing.JTextField overlayAttributeTextField;
    private javax.swing.JCheckBox overlayTrackCB;
    private javax.swing.JPanel overlaysPanel;
    private javax.swing.JTextField portField;
    private javax.swing.ButtonGroup probeMappingButtonGroup;
    private javax.swing.JTextField proxyHostField;
    private javax.swing.JPasswordField proxyPasswordField;
    private javax.swing.JTextField proxyPortField;
    private javax.swing.JTextField proxyUsernameField;
    private javax.swing.ButtonGroup rnaiMapapingButtonGroup;
    private javax.swing.JCheckBox samFlagUnmappedPairCB;
    private javax.swing.JTextField samMaxBaseQualityField;
    private javax.swing.JTextField samMaxLevelField;
    private javax.swing.JTextField samMaxWindowSizeField;
    private javax.swing.JTextField samMinBaseQualityField;
    private javax.swing.JCheckBox samShadeMismatchedBaseCB;
    private javax.swing.JCheckBox samShowDuplicatesCB;
    private javax.swing.JCheckBox searchZoomCB;
    private javax.swing.JCheckBox shadeCenterCB;
    private javax.swing.JCheckBox showAttributesDisplayCheckBox;
    private javax.swing.JCheckBox showCovTrackCB;
    private javax.swing.JCheckBox showDatarangeCB;
    private javax.swing.JCheckBox showMissingDataCB;
    private javax.swing.JCheckBox showRefSeqCB;
    private javax.swing.JTextField snpThresholdField;
    private javax.swing.JTabbedPane tabbedPane;
    private javax.swing.JCheckBox topBorderCB;
    private javax.swing.JTextField trackNameAttributeField;
    private javax.swing.JLabel trackNameAttributeLabel;
    private javax.swing.JPanel tracksPanel;
    private javax.swing.JCheckBox useByteRangeCB;
    private javax.swing.JCheckBox useProxyCB;
    // End of variables declaration//GEN-END:variables

    public boolean isCanceled() {
        return canceled;
    }
}
