/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.metal.MetalMenuItemUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class MetalMenuUI
extends MetalMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic = true;
    private boolean isMouseOver = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateDefaultBackgroundColor();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIDefaultsLookup.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    void updateMnemonicBinding() {
        int n = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
        if (n == this.lastMnemonic || nArray == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (int n2 : nArray) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n2, false));
            }
        }
        if (n != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (int n2 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n, n2, false), "selectMenu");
            }
        }
        this.lastMnemonic = n;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected MenuListener createMenuListener(JComponent jComponent) {
        return null;
    }

    protected ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MenuKeyHandler();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    protected static void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    private void updateDefaultBackgroundColor() {
        if (!UIDefaultsLookup.getBoolean("Menu.useMenuBarBackgroundForTopLevel")) {
            return;
        }
        JMenu jMenu = (JMenu)this.menuItem;
        if (jMenu.getBackground() instanceof UIResource) {
            if (jMenu.isTopLevelMenu()) {
                jMenu.setBackground(UIDefaultsLookup.getColor("MenuBar.background"));
            } else {
                jMenu.setBackground(UIDefaultsLookup.getColor(this.getPropertyPrefix() + ".background"));
            }
        }
    }

    static JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i = menuElementArray.length - 1; i >= 0; --i) {
            MenuElement menuElement = menuElementArray[i];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    protected void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
        this.menuItem.getModel().setRollover(this.isMouseOver);
    }

    protected boolean isMouseOver() {
        return this.isMouseOver;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu() && this.isDownArrowVisible(this.menuItem.getParent())) {
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                dimension.width += 11;
            } else {
                dimension.height += 11;
            }
        }
        return dimension;
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        Color color2 = graphics.getColor();
        int n = 0;
        int n2 = 0;
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getModel().isArmed() || jMenuItem instanceof JMenu && jMenuItem.getModel().isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            graphics.setColor(color2);
        }
        if (this.isDownArrowVisible(jMenuItem.getParent())) {
            graphics.setColor(Color.BLACK);
            int n3 = n - 9;
            graphics.drawLine(n3 - 2, n2 / 2 - 1, n3 + 2, n2 / 2 - 1);
            graphics.drawLine(n3 - 1, n2 / 2, n3 + 1, n2 / 2);
            graphics.drawLine(n3, n2 / 2 + 1, n3, n2 / 2 + 1);
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            JPopupMenu jPopupMenu;
            if (!crossMenuMnemonic && (jPopupMenu = MetalMenuUI.getActivePopupMenu()) != null && jPopupMenu != MetalMenuUI.this.menuItem.getParent()) {
                return;
            }
            int n = MetalMenuUI.this.menuItem.getMnemonic();
            if (n == 0) {
                return;
            }
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            if (this.lower((char)n) == this.lower(menuKeyEvent.getKeyChar())) {
                JPopupMenu jPopupMenu2 = ((JMenu)MetalMenuUI.this.menuItem).getPopupMenu();
                ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>(Arrays.asList(menuElementArray));
                arrayList.add(jPopupMenu2);
                MenuElement[] menuElementArray2 = jPopupMenu2.getSubElements();
                if (menuElementArray2.length > 0) {
                    arrayList.add(menuElementArray2[0]);
                }
                MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
                MenuElement[] menuElementArray3 = new MenuElement[]{};
                menuElementArray3 = arrayList.toArray(menuElementArray3);
                menuSelectionManager.setSelectedPath(menuElementArray3);
                menuKeyEvent.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            char c = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuKeyEvent.getPath();
            MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
            for (int i = menuElementArray2.length - 1; i >= 0; --i) {
                if (menuElementArray2[i] != MetalMenuUI.this.menuItem) continue;
                JPopupMenu jPopupMenu = ((JMenu)MetalMenuUI.this.menuItem).getPopupMenu();
                if (!jPopupMenu.isVisible()) {
                    return;
                }
                MenuElement[] menuElementArray3 = jPopupMenu.getSubElements();
                MenuElement menuElement = menuElementArray2[menuElementArray2.length - 1];
                int n = -1;
                int n2 = 0;
                int n3 = -1;
                int[] nArray = null;
                for (int j = 0; j < menuElementArray3.length; ++j) {
                    int n4 = ((JMenuItem)menuElementArray3[j]).getMnemonic();
                    if (this.lower((char)n4) == this.lower(c)) {
                        if (n2 == 0) {
                            n3 = j;
                            ++n2;
                        } else {
                            if (nArray == null) {
                                nArray = new int[menuElementArray3.length];
                                nArray[0] = n3;
                            }
                            nArray[n2++] = j;
                        }
                    }
                    if (menuElement != menuElementArray3[j]) continue;
                    n = n2 - 1;
                }
                if (n2 != 0) {
                    if (n2 == 1) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray3[n3];
                        if (!(jMenuItem instanceof JMenu)) {
                            menuSelectionManager.clearSelectedPath();
                            jMenuItem.doClick();
                        }
                    } else {
                        MenuElement menuElement2 = null;
                        menuElement2 = menuElementArray3[nArray[(n + 1) % n2]];
                        MenuElement[] menuElementArray4 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray4, 0, menuElementArray.length);
                        menuElementArray4[menuElementArray.length] = jPopupMenu;
                        menuElementArray4[menuElementArray.length + 1] = menuElement2;
                        menuSelectionManager.setSelectedPath(menuElementArray4);
                    }
                }
                menuKeyEvent.consume();
                return;
            }
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c) {
            return Character.toLowerCase(c);
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent menuDragMouseEvent) {
            Component component;
            if (!MetalMenuUI.this.menuItem.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuDragMouseEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray = menuDragMouseEvent.getPath();
            Point point = menuDragMouseEvent.getPoint();
            if (point.x >= 0 && point.x < MetalMenuUI.this.menuItem.getWidth() && point.y >= 0 && point.y < MetalMenuUI.this.menuItem.getHeight()) {
                JMenu jMenu = (JMenu)MetalMenuUI.this.menuItem;
                MenuElement[] menuElementArray2 = menuSelectionManager.getSelectedPath();
                if (menuElementArray2.length <= 0 || menuElementArray2[menuElementArray2.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0 || menuDragMouseEvent.getID() == 506) {
                        MetalMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(menuElementArray);
                        MetalMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuDragMouseEvent.getID() == 502 && (component = menuSelectionManager.componentForPoint(menuDragMouseEvent.getComponent(), menuDragMouseEvent.getPoint())) == null) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void menuDragMouseExited(MenuDragMouseEvent menuDragMouseEvent) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent menuDragMouseEvent) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public JMenu menu;
        public MetalMenuUI ui;
        public boolean isSelected = false;
        public Component wasFocused;

        public ChangeHandler(JMenu jMenu, MetalMenuUI metalMenuUI2) {
            this.menu = jMenu;
            this.ui = metalMenuUI2;
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuElement[] menuElementArray;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!(MetalMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)MetalMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.getParent() instanceof JMenuBar || jMenu.getParent() instanceof TopLevelMenuContainer) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    menuElementArray = jMenu.getParent();
                    if (menuElementArray != null && menuElementArray.getParent() instanceof MenuElement) {
                        MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)menuElementArray.getParent()), (MenuElement)menuElementArray, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                    } else if (menuElementArray != null && menuElementArray instanceof MenuElement) {
                        MenuElement[] menuElementArray3 = new MenuElement[]{(MenuElement)menuElementArray, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    }
                }
            }
            if ((menuElementArray = menuSelectionManager.getSelectedPath()).length > 0 && menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    MetalMenuUI.appendPath(menuElementArray, jMenu.getPopupMenu());
                } else {
                    MetalMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!(MetalMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)MetalMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!(MetalMenuUI.this.menuItem instanceof JMenu)) {
                return;
            }
            JMenu jMenu = (JMenu)MetalMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        MetalMenuUI.appendPath(MetalMenuUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(MetalMenuUI.this.getPath());
                        MetalMenuUI.this.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)MetalMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("mnemonic")) {
                MetalMenuUI.this.updateMnemonicBinding();
            } else if (string.equals("ancestor")) {
                MetalMenuUI.this.updateDefaultBackgroundColor();
            }
        }
    }

    private static class PostAction
    extends AbstractAction {
        JMenu menu;
        boolean force = false;

        PostAction(JMenu jMenu, boolean bl) {
            this.menu = jMenu;
            this.force = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            if (!crossMenuMnemonic && (object = MetalMenuUI.getActivePopupMenu()) != null && object != this.menu.getParent()) {
                return;
            }
            object = MenuSelectionManager.defaultManager();
            if (this.force) {
                Container container = this.menu.getParent();
                if (container != null && container instanceof JMenuBar) {
                    MenuElement[] menuElementArray = this.menu.getPopupMenu().getSubElements();
                    MenuElement[] menuElementArray2 = menuElementArray.length > 0 ? new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu(), menuElementArray[0]} : new MenuElement[]{(MenuElement)((Object)container), this.menu, this.menu.getPopupMenu()};
                    ((MenuSelectionManager)object).setSelectedPath(menuElementArray2);
                }
            } else {
                MenuElement[] menuElementArray = ((MenuSelectionManager)object).getSelectedPath();
                if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1] == this.menu) {
                    MetalMenuUI.appendPath(menuElementArray, this.menu.getPopupMenu());
                }
            }
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

