/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathUtils {
    protected MathUtils() {
    }

    public static double sum(List<Number> list) {
        double d = 0.0;
        for (Number number : list) {
            d += number.doubleValue();
        }
        return d;
    }

    public static double mean(List<Number> list) {
        double d = MathUtils.sum(list);
        return d / (double)list.size();
    }

    public static double min(List<Number> list) {
        double d = 2.147483647E9;
        for (Number number : list) {
            double d2 = number.doubleValue();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    public static double max(List<Number> list) {
        double d = -2.147483648E9;
        for (Number number : list) {
            double d2 = number.doubleValue();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public static double stddev(List<Number> list, boolean bl) {
        double d = Double.NaN;
        int n = list.size();
        if (n > 0) {
            d = n > 1 ? Math.sqrt(MathUtils.var(list, bl)) : 0.0;
        }
        return d;
    }

    public static double var(List<Number> list, boolean bl) {
        int n = list.size();
        if (n == 0) {
            return Double.NaN;
        }
        if (n == 1) {
            return 0.0;
        }
        double d = MathUtils.mean(list);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        for (Number number : list) {
            double d2 = number.doubleValue() - d;
            arrayList.add(Math.pow(d2, 2.0));
        }
        double d3 = MathUtils.sum(arrayList);
        return d3 / (double)(bl ? n - 1 : n);
    }
}

