/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.ValidationStringency;
import java.io.File;
import java.io.InputStream;

class Indexer
implements Runnable {
    private final File index;
    private final InputStream stream;

    Indexer(File index, InputStream stream) {
        this.index = index;
        this.stream = stream;
    }

    @Override
    public void run() {
        SAMFileReader in = new SAMFileReader(this.stream);
        in.enableFileSource(true);
        in.setValidationStringency(ValidationStringency.SILENT);
        in.enableCrcChecking(false);
        BAMIndexer indexer = new BAMIndexer(this.index, in.getFileHeader());
        for (SAMRecord rec : in) {
            indexer.processAlignment(rec);
        }
        indexer.finish();
        in.close();
    }
}

