/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.readers;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.AsynchronousLineReader;
import htsjdk.tribble.readers.LineReader;
import htsjdk.tribble.readers.LongLineBufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class LineReaderUtil {
    public static LineReader fromBufferedStream(InputStream stream) {
        return LineReaderUtil.fromBufferedStream(stream, Defaults.USE_ASYNC_IO ? LineReaderOption.ASYNCHRONOUS : LineReaderOption.SYNCHRONOUS);
    }

    public static LineReader fromBufferedStream(InputStream bufferedStream, LineReaderOption option) {
        final InputStreamReader bufferedInputStreamReader = new InputStreamReader(bufferedStream);
        switch (option) {
            case ASYNCHRONOUS: {
                return new AsynchronousLineReader(bufferedInputStreamReader);
            }
            case SYNCHRONOUS: {
                return new LineReader(){
                    final LongLineBufferedReader reader;
                    {
                        this.reader = new LongLineBufferedReader(bufferedInputStreamReader);
                    }

                    @Override
                    public String readLine() {
                        try {
                            return this.reader.readLine();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void close() {
                        CloserUtil.close(this.reader);
                    }
                };
            }
        }
        throw new TribbleException(String.format("Unrecognized LineReaderUtil option: %s.", new Object[]{option}));
    }

    public static enum LineReaderOption {
        ASYNCHRONOUS,
        SYNCHRONOUS;

    }
}

