/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;

class ResultSetAccessor
extends Accessor {
    static final int MAXLENGTH = 16;
    OracleStatement currentStmt;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    ResultSetAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.RESULT_SET, oracleStatement, 16, bl);
        this.init(oracleStatement, 102, 116, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    ResultSetAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        super(Representation.RESULT_SET, oracleStatement, 16, false);
        this.init(oracleStatement, 102, 116, s2, false);
        this.initForDescribe(102, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    ResultSet getCursor(int n2) throws SQLException {
        OracleResultSet oracleResultSet;
        if (this.currentStmt != null && this.currentStmt.refCursorRowNumber == n2 && this.currentStmt.currentResultSet != null) {
            return this.currentStmt.currentResultSet;
        }
        byte[] byArray = this.getBytes(n2);
        OracleStatement oracleStatement = this.statement.connection.RefCursorBytesToStatement(byArray, this.statement);
        oracleStatement.refCursorRowNumber = n2;
        oracleStatement.doDescribe(false);
        if (oracleStatement.numberOfDefinePositions > 0) {
            oracleStatement.prepareAccessors();
        }
        oracleStatement.setPrefetchInternal(this.statement.getFetchSize(), false, false);
        oracleStatement.closeOnCompletion();
        oracleStatement.currentResultSet = oracleResultSet = OracleResultSet.createResultSet(oracleStatement);
        this.currentStmt = oracleStatement;
        return oracleResultSet;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getCursor(n2);
    }
}

