
#include "emu.h"
#include "cpu/m6809/m6809.h"

class wpc_95_state : public driver_device
{
public:
	wpc_95_state(const machine_config &mconfig, device_type type, const char *tag)
		: driver_device(mconfig, type, tag),
		  m_maincpu(*this, "maincpu")
	{ }

protected:

	// devices
	required_device<cpu_device> m_maincpu;

	// driver_device overrides
	virtual void machine_reset();
};


static ADDRESS_MAP_START( wpc_95_map, AS_PROGRAM, 8, wpc_95_state )
	AM_RANGE(0x0000, 0xffff) AM_NOP
ADDRESS_MAP_END

static INPUT_PORTS_START( wpc_95 )
INPUT_PORTS_END

void wpc_95_state::machine_reset()
{
}

static DRIVER_INIT( wpc_95 )
{
}

static MACHINE_CONFIG_START( wpc_95, wpc_95_state )
	/* basic machine hardware */
	MCFG_CPU_ADD("maincpu", M6809, 2000000)
	MCFG_CPU_PROGRAM_MAP(wpc_95_map)
MACHINE_CONFIG_END

/*-----------------
/  Attack From Mars
/------------------*/
ROM_START(afm_11)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("mars1_1.rom", 0x00000, 0x080000, CRC(13b174d9) SHA1(57952f3184496b0316e4cf301e0181cb9de3519a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("afm_s2.l1", 0x000000, 0x100000, CRC(6e39d96e) SHA1(b34e31bb1734c86614f153f7201163aaa9943cec))
	ROM_LOAD("afm_s3.l1", 0x100000, 0x100000, CRC(1cbce9b1) SHA1(7f258bfe1904a879a2cb007419483f4fee91e072))
	ROM_LOAD("afm_s4.l1", 0x200000, 0x100000, CRC(5ff7fbb7) SHA1(ebaf825d3b90b6acee1920e6703801a4bcddfc5b))
ROM_END

ROM_START(afm_10)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("afm_1_00.g11", 0x00000, 0x080000, CRC(1a30fe95) SHA1(218674e63ce4efeecb266f35f0f315758f7c72fc))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("afm_1_00.s2", 0x000000, 0x100000, CRC(610ff107) SHA1(9590f809a05cb2bda4979fa16f165e2e994719a0))
	ROM_LOAD("afm_s3.l1", 0x100000, 0x100000, CRC(1cbce9b1) SHA1(7f258bfe1904a879a2cb007419483f4fee91e072))
	ROM_LOAD("afm_s4.l1", 0x200000, 0x100000, CRC(5ff7fbb7) SHA1(ebaf825d3b90b6acee1920e6703801a4bcddfc5b))
ROM_END

ROM_START(afm_113)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("afm_1_13.bin", 0x00000, 0x100000, CRC(e1fbd81b) SHA1(0ff35253d8eac7b75abb3e4db84cdcca458182cd))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("afm_s2.l1", 0x000000, 0x100000, CRC(6e39d96e) SHA1(b34e31bb1734c86614f153f7201163aaa9943cec))
	ROM_LOAD("afm_s3.l1", 0x100000, 0x100000, CRC(1cbce9b1) SHA1(7f258bfe1904a879a2cb007419483f4fee91e072))
	ROM_LOAD("afm_s4.l1", 0x200000, 0x100000, CRC(5ff7fbb7) SHA1(ebaf825d3b90b6acee1920e6703801a4bcddfc5b))
ROM_END

ROM_START(afm_113b)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("afm_113b.bin", 0x00000, 0x100000, CRC(34fd2d7d) SHA1(57a41bd686286429880e63696d7d9d3990ca5d05))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("afm_s2.l1", 0x000000, 0x100000, CRC(6e39d96e) SHA1(b34e31bb1734c86614f153f7201163aaa9943cec))
	ROM_LOAD("afm_s3.l1", 0x100000, 0x100000, CRC(1cbce9b1) SHA1(7f258bfe1904a879a2cb007419483f4fee91e072))
	ROM_LOAD("afm_s4.l1", 0x200000, 0x100000, CRC(5ff7fbb7) SHA1(ebaf825d3b90b6acee1920e6703801a4bcddfc5b))
ROM_END

ROM_START(afm_11u)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("marsu1_1.rom", 0x00000, 0x080000, CRC(bc1c0a0a) SHA1(859b40aaae46623f9b3519b5e422977d1724b715))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("afm_s2.l1", 0x000000, 0x100000, CRC(6e39d96e) SHA1(b34e31bb1734c86614f153f7201163aaa9943cec))
	ROM_LOAD("afm_s3.l1", 0x100000, 0x100000, CRC(1cbce9b1) SHA1(7f258bfe1904a879a2cb007419483f4fee91e072))
	ROM_LOAD("afm_s4.l1", 0x200000, 0x100000, CRC(5ff7fbb7) SHA1(ebaf825d3b90b6acee1920e6703801a4bcddfc5b))
ROM_END
/*-----------------
/  Cactus Canyon
/------------------*/
ROM_START(cc_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("cc_g11.1_2", 0x00000, 0x100000, CRC(17ad9266) SHA1(b18c4e2cc9f4269904c05e5e414675a94f96e955))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("sav2_8.rom", 0x000000, 0x100000, CRC(94928841) SHA1(953586d6abe8222a6cd6b74e417fa4ce078efa43))
	ROM_LOAD("sav3_8.rom", 0x100000, 0x100000, CRC(a22b13f0) SHA1(5df6ea9d5059cd04bdb369c1c7255b09d64b3c65))
	ROM_LOAD("sav4_8.rom", 0x200000, 0x100000, CRC(fe8324e2) SHA1(72c56d094cb4185a083a7da81fd527a908ce9de0))
	ROM_LOAD("sav5_8.rom", 0x300000, 0x100000, CRC(1b2a1ff3) SHA1(2d9a5952c7ac000c47d87d198ff7ca62913ec73f))
	ROM_LOAD("sav6_8.rom", 0x400000, 0x100000, CRC(2cccf10e) SHA1(3b9b9c87ab3c0d74eaacde416d18f3357f8302bd))
	ROM_LOAD("sav7_8.rom", 0x500000, 0x100000, CRC(90fb1277) SHA1(502c920e1d54d285a4d4af401e574f785149da47))
ROM_END

ROM_START(cc_13)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("cc_g11.1_3", 0x00000, 0x100000, CRC(7741fa4e) SHA1(adaf6b07d2f2714e87e367db28d15ae0145b6ae6))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("sav2_8.rom", 0x000000, 0x100000, CRC(94928841) SHA1(953586d6abe8222a6cd6b74e417fa4ce078efa43))
	ROM_LOAD("sav3_8.rom", 0x100000, 0x100000, CRC(a22b13f0) SHA1(5df6ea9d5059cd04bdb369c1c7255b09d64b3c65))
	ROM_LOAD("sav4_8.rom", 0x200000, 0x100000, CRC(fe8324e2) SHA1(72c56d094cb4185a083a7da81fd527a908ce9de0))
	ROM_LOAD("sav5_8.rom", 0x300000, 0x100000, CRC(1b2a1ff3) SHA1(2d9a5952c7ac000c47d87d198ff7ca62913ec73f))
	ROM_LOAD("sav6_8.rom", 0x400000, 0x100000, CRC(2cccf10e) SHA1(3b9b9c87ab3c0d74eaacde416d18f3357f8302bd))
	ROM_LOAD("sav7_8.rom", 0x500000, 0x100000, CRC(90fb1277) SHA1(502c920e1d54d285a4d4af401e574f785149da47))
ROM_END

/*-----------------
/  Cirqus Voltaire
/------------------*/
ROM_START(cv_14)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("cirq_14.rom", 0x00000, 0x100000, CRC(7a8bf999) SHA1(b33baabf4f6cbf8615cc00eb1286238c5aea386a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("s2v1_0.rom", 0x000000, 0x080000, CRC(79dbb8ee) SHA1(f76c0db93b89beaf1e90c5f2199262e296fb1b78))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("s3v0_4.rom", 0x100000, 0x100000, CRC(8c6c0c56) SHA1(792431cc5b06c3d5028168297614f5eb7e8af34f))
	ROM_LOAD("s4v0_4.rom", 0x200000, 0x100000, CRC(a9014b78) SHA1(abffe32ab729fb39ab2360d850c8b5476094fd92))
	ROM_LOAD("s5v0_4.rom", 0x300000, 0x100000, CRC(7e07a2fc) SHA1(f908363c968c15c0dc62e32695e5e2d0ca869391))
	ROM_LOAD("s6v0_4.rom", 0x400000, 0x100000, CRC(36ca43d3) SHA1(b599f88649c220143aa44cd5213e725e62afb0bc))
ROM_END

ROM_START(cv_20h)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("cv200h.rom", 0x00000, 0x100000, CRC(138a0c3c) SHA1(dd6d4b5519ca161bd6779ed60cc7f52542a10147))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("s2v1_0.rom", 0x000000, 0x080000, CRC(79dbb8ee) SHA1(f76c0db93b89beaf1e90c5f2199262e296fb1b78))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("s3v0_4.rom", 0x100000, 0x100000, CRC(8c6c0c56) SHA1(792431cc5b06c3d5028168297614f5eb7e8af34f))
	ROM_LOAD("s4v0_4.rom", 0x200000, 0x100000, CRC(a9014b78) SHA1(abffe32ab729fb39ab2360d850c8b5476094fd92))
	ROM_LOAD("s5v0_4.rom", 0x300000, 0x100000, CRC(7e07a2fc) SHA1(f908363c968c15c0dc62e32695e5e2d0ca869391))
	ROM_LOAD("s6v0_4.rom", 0x400000, 0x100000, CRC(36ca43d3) SHA1(b599f88649c220143aa44cd5213e725e62afb0bc))
ROM_END

ROM_START(cv_10)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("g11_100.rom", 0x00000, 0x100000, CRC(00028589) SHA1(46639c45abbdc59ca0f861824eca3efa10547123))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("s2v1_0.rom", 0x000000, 0x080000, CRC(79dbb8ee) SHA1(f76c0db93b89beaf1e90c5f2199262e296fb1b78))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("s3v0_4.rom", 0x100000, 0x100000, CRC(8c6c0c56) SHA1(792431cc5b06c3d5028168297614f5eb7e8af34f))
	ROM_LOAD("s4v0_4.rom", 0x200000, 0x100000, CRC(a9014b78) SHA1(abffe32ab729fb39ab2360d850c8b5476094fd92))
	ROM_LOAD("s5v0_4.rom", 0x300000, 0x100000, CRC(7e07a2fc) SHA1(f908363c968c15c0dc62e32695e5e2d0ca869391))
	ROM_LOAD("s6v0_4.rom", 0x400000, 0x100000, CRC(36ca43d3) SHA1(b599f88649c220143aa44cd5213e725e62afb0bc))
ROM_END

ROM_START(cv_11)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("g11_110.rom", 0x00000, 0x100000, CRC(c7a4c104) SHA1(a96d34b2cf94591879de5b7838db0c98c9abfad8))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("s2v1_0.rom", 0x000000, 0x080000, CRC(79dbb8ee) SHA1(f76c0db93b89beaf1e90c5f2199262e296fb1b78))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("s3v0_4.rom", 0x100000, 0x100000, CRC(8c6c0c56) SHA1(792431cc5b06c3d5028168297614f5eb7e8af34f))
	ROM_LOAD("s4v0_4.rom", 0x200000, 0x100000, CRC(a9014b78) SHA1(abffe32ab729fb39ab2360d850c8b5476094fd92))
	ROM_LOAD("s5v0_4.rom", 0x300000, 0x100000, CRC(7e07a2fc) SHA1(f908363c968c15c0dc62e32695e5e2d0ca869391))
	ROM_LOAD("s6v0_4.rom", 0x400000, 0x100000, CRC(36ca43d3) SHA1(b599f88649c220143aa44cd5213e725e62afb0bc))
ROM_END

ROM_START(cv_13)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("cv_g11.1_3", 0x00000, 0x100000, CRC(58b3bea0) SHA1(243f15c6b383921faf735caece2073cb6f88601a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("s2v1_0.rom", 0x000000, 0x080000, CRC(79dbb8ee) SHA1(f76c0db93b89beaf1e90c5f2199262e296fb1b78))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("s3v0_4.rom", 0x100000, 0x100000, CRC(8c6c0c56) SHA1(792431cc5b06c3d5028168297614f5eb7e8af34f))
	ROM_LOAD("s4v0_4.rom", 0x200000, 0x100000, CRC(a9014b78) SHA1(abffe32ab729fb39ab2360d850c8b5476094fd92))
	ROM_LOAD("s5v0_4.rom", 0x300000, 0x100000, CRC(7e07a2fc) SHA1(f908363c968c15c0dc62e32695e5e2d0ca869391))
	ROM_LOAD("s6v0_4.rom", 0x400000, 0x100000, CRC(36ca43d3) SHA1(b599f88649c220143aa44cd5213e725e62afb0bc))
ROM_END

/*-----------------
/  Congo
/------------------*/
ROM_START(congo_21)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("cg_g11.2_1", 0x00000, 0x80000, CRC(5d8435bf) SHA1(1356758fd788bbb3c7ab29abaaea7d2baac75f55))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("cgs2v1_1.rom", 0x000000, 0x100000, CRC(2b7637ae) SHA1(5b5d7214c632a506b986c892b39b1356b2909598))
	ROM_LOAD("cgs3v1_0.rom", 0x100000, 0x100000, CRC(6cfd9fe0) SHA1(a76267f865c645648c8cb27aec2d05062a4a20b5))
	ROM_LOAD("cgs4v1_0.rom", 0x200000, 0x100000, CRC(2a1980e7) SHA1(0badf27c2b8bc7b0074dc5e606d64490470bc108))
ROM_END

ROM_START(congo_20)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("cong2_00.rom", 0x00000, 0x80000, CRC(e1a256ac) SHA1(f1f7a1865b5a0220e2f2ef492059df158451ca5b))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("cgs2v1_1.rom", 0x000000, 0x100000, CRC(2b7637ae) SHA1(5b5d7214c632a506b986c892b39b1356b2909598))
	ROM_LOAD("cgs3v1_0.rom", 0x100000, 0x100000, CRC(6cfd9fe0) SHA1(a76267f865c645648c8cb27aec2d05062a4a20b5))
	ROM_LOAD("cgs4v1_0.rom", 0x200000, 0x100000, CRC(2a1980e7) SHA1(0badf27c2b8bc7b0074dc5e606d64490470bc108))
ROM_END

ROM_START(congo_13)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("cong1_30.rom", 0x00000, 0x80000, CRC(e68c0404) SHA1(e851f42e6bd0e910fc87b9500cbacac3c088b488))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("cgs2v1_1.rom", 0x000000, 0x100000, CRC(2b7637ae) SHA1(5b5d7214c632a506b986c892b39b1356b2909598))
	ROM_LOAD("cgs3v1_0.rom", 0x100000, 0x100000, CRC(6cfd9fe0) SHA1(a76267f865c645648c8cb27aec2d05062a4a20b5))
	ROM_LOAD("cgs4v1_0.rom", 0x200000, 0x100000, CRC(2a1980e7) SHA1(0badf27c2b8bc7b0074dc5e606d64490470bc108))
ROM_END

/*-----------------
/  Junk Yard
/------------------*/
ROM_START(jy_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jy_g11.1_2", 0x00000, 0x80000, CRC(16fb4bb3) SHA1(fbd8b37c129f7e07e8c44b7a33754ee346473377))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("jy_s2.rom", 0x000000, 0x080000, CRC(1a1bc2ca) SHA1(db949d49560a26fc280cd9e746aa99dfafbd6daa))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jy_s3.rom", 0x100000, 0x100000, CRC(0fc36a8e) SHA1(335013ebe08d34a24b0b472c6d5f042e455facee))
	ROM_LOAD("jy_s4.rom", 0x200000, 0x100000, CRC(0aebcd77) SHA1(62aee2685c0ae4bc1df8e4a4515ca34a078c72ad))
	ROM_LOAD("jy_s5.rom", 0x300000, 0x100000, CRC(f18ad10b) SHA1(1d02a388b43d3863030e01bf567f30337d37b2e8))
ROM_END

ROM_START(jy_11)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jy_g11.1_1", 0x00000, 0x80000, CRC(2810fcb9) SHA1(58bb828e4d37a0ac65108a4dfb4ba25615b2b6f7))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("jy_s2.rom", 0x000000, 0x080000, CRC(1a1bc2ca) SHA1(db949d49560a26fc280cd9e746aa99dfafbd6daa))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("jy_s3.rom", 0x100000, 0x100000, CRC(0fc36a8e) SHA1(335013ebe08d34a24b0b472c6d5f042e455facee))
	ROM_LOAD("jy_s4.rom", 0x200000, 0x100000, CRC(0aebcd77) SHA1(62aee2685c0ae4bc1df8e4a4515ca34a078c72ad))
	ROM_LOAD("jy_s5.rom", 0x300000, 0x100000, CRC(f18ad10b) SHA1(1d02a388b43d3863030e01bf567f30337d37b2e8))
ROM_END

ROM_START(jy_03)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("jy_cpu.0_3", 0x00000, 0x80000, CRC(015d0253) SHA1(733740645fb300f48f57a74dea5fa31758628d24))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("jy_s2.0_2", 0x000000, 0x100000, CRC(8a6e0eaa) SHA1(758609b946d10dca70c46da0403d8ed36f8cbd5c))
	ROM_LOAD("jy_s3.0_2", 0x100000, 0x100000, CRC(53987d09) SHA1(c1f34d564a8f69413878a7adc089181e562a347c))
	ROM_LOAD("jy_s4.0_2", 0x200000, 0x100000, CRC(f82481cd) SHA1(a8283ac4a2dee636f4ec17d3fddf09920c7e3802))
	ROM_LOAD("jy_s5.0_2", 0x300000, 0x100000, CRC(5adb2d4c) SHA1(566a27238d643aaf7764e23bc1ce46cc5d7883dd))
ROM_END

/*-----------------
/  Medieval Madness
/------------------*/
ROM_START(mm_109)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("mm_1_09.bin", 0x00000, 0x100000, CRC(9bac4d0c) SHA1(92cbe21802e1a77feff77b78f4dbbdbffb7b14bc))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("mm_s2.1_0", 0x000000, 0x080000, CRC(c55c3b71) SHA1(95febbf16645dd897bdd459ccad9501d2457d1f1))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mm_sav3.rom", 0x100000, 0x100000, CRC(ed1be570) SHA1(ead4c4f89d63ee0b46d8a8bcd8650d506542d1ee))
	ROM_LOAD("mm_sav4.rom", 0x200000, 0x100000, CRC(9c89eacf) SHA1(594a2aa81e34658862a9b7f0a83cf514182f2a2d))
	ROM_LOAD("mm_sav5.rom", 0x300000, 0x100000, CRC(45089e30) SHA1(e83492109c59e8a2f1ba9e1f793788b97d150a9b))
	ROM_LOAD("mm_sav6.rom", 0x400000, 0x100000, CRC(439d55f2) SHA1(d80e7268223157d864674261d140322634fb3bc2))
ROM_END

ROM_START(mm_109b)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("mm_109b.bin", 0x00000, 0x100000, CRC(4eaab86a) SHA1(694cbb1154e7374275becfbe4f743fb8d31df8fb))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("mm_s2.1_0", 0x000000, 0x080000, CRC(c55c3b71) SHA1(95febbf16645dd897bdd459ccad9501d2457d1f1))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mm_sav3.rom", 0x100000, 0x100000, CRC(ed1be570) SHA1(ead4c4f89d63ee0b46d8a8bcd8650d506542d1ee))
	ROM_LOAD("mm_sav4.rom", 0x200000, 0x100000, CRC(9c89eacf) SHA1(594a2aa81e34658862a9b7f0a83cf514182f2a2d))
	ROM_LOAD("mm_sav5.rom", 0x300000, 0x100000, CRC(45089e30) SHA1(e83492109c59e8a2f1ba9e1f793788b97d150a9b))
	ROM_LOAD("mm_sav6.rom", 0x400000, 0x100000, CRC(439d55f2) SHA1(d80e7268223157d864674261d140322634fb3bc2))
ROM_END

ROM_START(mm_109c)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("mm_1_09c.bin", 0x00000, 0x100000, CRC(d9e5189f) SHA1(fc01855c139d408559605fe9932236250cd566a8))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("mm_s2.1_0", 0x000000, 0x080000, CRC(c55c3b71) SHA1(95febbf16645dd897bdd459ccad9501d2457d1f1))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mm_sav3.rom", 0x100000, 0x100000, CRC(ed1be570) SHA1(ead4c4f89d63ee0b46d8a8bcd8650d506542d1ee))
	ROM_LOAD("mm_sav4.rom", 0x200000, 0x100000, CRC(9c89eacf) SHA1(594a2aa81e34658862a9b7f0a83cf514182f2a2d))
	ROM_LOAD("mm_sav5.rom", 0x300000, 0x100000, CRC(45089e30) SHA1(e83492109c59e8a2f1ba9e1f793788b97d150a9b))
	ROM_LOAD("mm_sav6.rom", 0x400000, 0x100000, CRC(439d55f2) SHA1(d80e7268223157d864674261d140322634fb3bc2))
ROM_END

ROM_START(mm_10)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("mm_g11.1_0", 0x00000, 0x080000, CRC(6bd735c6) SHA1(3922df00e785610837230d5d9c24b9e082aa6fb6))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("mm_s2.1_0", 0x000000, 0x080000, CRC(c55c3b71) SHA1(95febbf16645dd897bdd459ccad9501d2457d1f1))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mm_sav3.rom", 0x100000, 0x100000, CRC(ed1be570) SHA1(ead4c4f89d63ee0b46d8a8bcd8650d506542d1ee))
	ROM_LOAD("mm_sav4.rom", 0x200000, 0x100000, CRC(9c89eacf) SHA1(594a2aa81e34658862a9b7f0a83cf514182f2a2d))
	ROM_LOAD("mm_sav5.rom", 0x300000, 0x100000, CRC(45089e30) SHA1(e83492109c59e8a2f1ba9e1f793788b97d150a9b))
	ROM_LOAD("mm_sav6.rom", 0x400000, 0x100000, CRC(439d55f2) SHA1(d80e7268223157d864674261d140322634fb3bc2))
ROM_END

ROM_START(mm_10u)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("mmu_g11.1_0", 0x00000, 0x080000, CRC(265e6192) SHA1(bd9606df5fb85b2048a07db0927e4a856c344276))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("mm_s2.1_0", 0x000000, 0x080000, CRC(c55c3b71) SHA1(95febbf16645dd897bdd459ccad9501d2457d1f1))
	ROM_RELOAD(0x000000 +0x080000, 0x080000)
	ROM_LOAD("mm_sav3.rom", 0x100000, 0x100000, CRC(ed1be570) SHA1(ead4c4f89d63ee0b46d8a8bcd8650d506542d1ee))
	ROM_LOAD("mm_sav4.rom", 0x200000, 0x100000, CRC(9c89eacf) SHA1(594a2aa81e34658862a9b7f0a83cf514182f2a2d))
	ROM_LOAD("mm_sav5.rom", 0x300000, 0x100000, CRC(45089e30) SHA1(e83492109c59e8a2f1ba9e1f793788b97d150a9b))
	ROM_LOAD("mm_sav6.rom", 0x400000, 0x100000, CRC(439d55f2) SHA1(d80e7268223157d864674261d140322634fb3bc2))
ROM_END

ROM_START(mm_05)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x080000, "user2", 0)
	ROM_LOAD("g11-050.rom", 0x00000, 0x080000, CRC(d211ad16) SHA1(539fb0c4ca6fe19ac6140f5792c5b7cd51f737ce))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("s2-020.rom", 0x000000, 0x080000, CRC(ee009ce4) SHA1(36843b2f1a07cf1e23bdff9b7347ceeca7e915bc))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mm_sav3.rom", 0x100000, 0x100000, CRC(ed1be570) SHA1(ead4c4f89d63ee0b46d8a8bcd8650d506542d1ee))
	ROM_LOAD("mm_sav4.rom", 0x200000, 0x100000, CRC(9c89eacf) SHA1(594a2aa81e34658862a9b7f0a83cf514182f2a2d))
	ROM_LOAD("mm_sav5.rom", 0x300000, 0x100000, CRC(45089e30) SHA1(e83492109c59e8a2f1ba9e1f793788b97d150a9b))
	ROM_LOAD("mm_sav6.rom", 0x400000, 0x100000, CRC(439d55f2) SHA1(d80e7268223157d864674261d140322634fb3bc2))
ROM_END

/*-----------------
/  Monster Bash
/------------------*/
ROM_START(mb_106)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("mb_1_06.bin", 0x00000, 0x100000, CRC(381a8822) SHA1(b0b5bf58accff24a4023c102952c89c1f116a174))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("mb_s2.rom", 0x000000, 0x080000, CRC(9152f559) SHA1(68d455d8b875101caedafd21b59c447f326566dd))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mb_s3.rom", 0x100000, 0x100000, CRC(c3cd6e81) SHA1(b041979c8955907090b30960780cecb19258bd5e))
	ROM_LOAD("mb_s4.rom", 0x200000, 0x100000, CRC(00b88352) SHA1(5da75e0b400eb71583681e06088eb97fc12e7f17))
	ROM_LOAD("mb_s5.rom", 0x300000, 0x100000, CRC(dae16105) SHA1(15878ef8685f3e9fc8eb2a2401581d30fe706e89))
	ROM_LOAD("mb_s6.rom", 0x400000, 0x100000, CRC(3975d5da) SHA1(6dbb34a827c0956e6aef1401c12cba88ae370e1f))
	ROM_LOAD("mb_s7.rom", 0x500000, 0x100000, CRC(c242fb78) SHA1(c5a2a37ff3414d1e946cddb69b5e8f067b50bcc6))
ROM_END

ROM_START(mb_106b)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("mb_106b.bin", 0x00000, 0x100000, CRC(c7c5d855) SHA1(96a43a955c0abaef8d6af1b64eaf50a7eeb69fe0))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("mb_s2.rom", 0x000000, 0x080000, CRC(9152f559) SHA1(68d455d8b875101caedafd21b59c447f326566dd))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mb_s3.rom", 0x100000, 0x100000, CRC(c3cd6e81) SHA1(b041979c8955907090b30960780cecb19258bd5e))
	ROM_LOAD("mb_s4.rom", 0x200000, 0x100000, CRC(00b88352) SHA1(5da75e0b400eb71583681e06088eb97fc12e7f17))
	ROM_LOAD("mb_s5.rom", 0x300000, 0x100000, CRC(dae16105) SHA1(15878ef8685f3e9fc8eb2a2401581d30fe706e89))
	ROM_LOAD("mb_s6.rom", 0x400000, 0x100000, CRC(3975d5da) SHA1(6dbb34a827c0956e6aef1401c12cba88ae370e1f))
	ROM_LOAD("mb_s7.rom", 0x500000, 0x100000, CRC(c242fb78) SHA1(c5a2a37ff3414d1e946cddb69b5e8f067b50bcc6))
ROM_END

ROM_START(mb_10)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x100000, "user2", 0)
	ROM_LOAD("mb_g11.1_0", 0x00000, 0x100000, CRC(6b8db967) SHA1(e24d801ed9d326b9d4ddb26100c85cfd8e697d17))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("mb_s2.rom", 0x000000, 0x080000, CRC(9152f559) SHA1(68d455d8b875101caedafd21b59c447f326566dd))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("mb_s3.rom", 0x100000, 0x100000, CRC(c3cd6e81) SHA1(b041979c8955907090b30960780cecb19258bd5e))
	ROM_LOAD("mb_s4.rom", 0x200000, 0x100000, CRC(00b88352) SHA1(5da75e0b400eb71583681e06088eb97fc12e7f17))
	ROM_LOAD("mb_s5.rom", 0x300000, 0x100000, CRC(dae16105) SHA1(15878ef8685f3e9fc8eb2a2401581d30fe706e89))
	ROM_LOAD("mb_s6.rom", 0x400000, 0x100000, CRC(3975d5da) SHA1(6dbb34a827c0956e6aef1401c12cba88ae370e1f))
	ROM_LOAD("mb_s7.rom", 0x500000, 0x100000, CRC(c242fb78) SHA1(c5a2a37ff3414d1e946cddb69b5e8f067b50bcc6))
ROM_END

/*-----------------
/  NBA Fastbreak
/------------------*/
ROM_START(nbaf_31)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("fb_g11.3_1", 0x00000, 0x80000, CRC(acd84ec2) SHA1(bd641b26e7a577be9f8705b21de4a694400945ce))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("fb-s2.3_0", 0x000000, 0x100000, CRC(4594abd3) SHA1(d14654f0c2d29c28cae604e2dbcc9adf361b28a9))
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_31a)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("fb_g11.3_1", 0x00000, 0x80000, CRC(acd84ec2) SHA1(bd641b26e7a577be9f8705b21de4a694400945ce))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("fb-s2.1_0", 0x000000, 0x080000, CRC(32f42a82) SHA1(387636c8e9f8525e7442ccdced735392db113044))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_11)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-11.rom", 0x00000, 0x80000, CRC(debfb64a) SHA1(7f50246f5fde1e7fc295be6b6bbd455e244e4c99))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("fb-s2.1_0", 0x000000, 0x080000, CRC(32f42a82) SHA1(387636c8e9f8525e7442ccdced735392db113044))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_11a)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-11.rom", 0x00000, 0x80000, CRC(debfb64a) SHA1(7f50246f5fde1e7fc295be6b6bbd455e244e4c99))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("fb-s2.2_0", 0x000000, 0x100000, CRC(f950f481) SHA1(8d7c54c5f27a85889179ee690512fa69b1357bb6))
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_11s)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-11.rom", 0x00000, 0x80000, CRC(debfb64a) SHA1(7f50246f5fde1e7fc295be6b6bbd455e244e4c99))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("fb-s2.0_4", 0x000000, 0x080000, CRC(6a96f42b) SHA1(b6019bccdf62c9cf044a88d35019ebf0593b24d7))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_115)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-115", 0x00000, 0x80000, CRC(c0ed9848) SHA1(196d13cf93fe61db36d3bd936549210875a88948))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("fb-s2.1_0", 0x000000, 0x080000, CRC(32f42a82) SHA1(387636c8e9f8525e7442ccdced735392db113044))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_21)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-21.rom", 0x00000, 0x80000, CRC(598d33d0) SHA1(98c2bfcca573a6e790a4d3ba306953ff0fb3b042))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("fb-s2.1_0", 0x000000, 0x080000, CRC(32f42a82) SHA1(387636c8e9f8525e7442ccdced735392db113044))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_22)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-22.rom", 0x00000, 0x80000, CRC(2e7a9685) SHA1(2af250a947089469c942cf2c570063bdebd4abe4))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("fb-s2.1_0", 0x000000, 0x080000, CRC(32f42a82) SHA1(387636c8e9f8525e7442ccdced735392db113044))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

ROM_START(nbaf_23)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-23.rom", 0x00000, 0x80000, CRC(a6ceb6de) SHA1(055387ee7da57e1a8fbce803a0dd9e67d6dbb1bd))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("fb-s2.1_0", 0x000000, 0x080000, CRC(32f42a82) SHA1(387636c8e9f8525e7442ccdced735392db113044))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("fb-s3.1_0", 0x100000, 0x100000, CRC(033aa54a) SHA1(9221f3013f204a9a857aced5d774c606a7e48648))
	ROM_LOAD("fb-s4.1_0", 0x200000, 0x100000, CRC(6965a7c5) SHA1(7e72bbd3bad9accc8da1754c57c24ebdf13e57b9))
	ROM_LOAD("fb-s5.1_0", 0x300000, 0x100000, CRC(db50b79a) SHA1(9753d599cd822b55ed64bcf64955f625dc51997d))
	ROM_LOAD("fb-s6.1_0", 0x400000, 0x100000, CRC(f1633371) SHA1(a707748d3298ffb6d10d8308f4dae7982b540fa0))
ROM_END

/*-----------------
/  No Good Gofers
/------------------*/
ROM_START(ngg_13)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("go_g11.1_3", 0x00000, 0x80000, CRC(64e73117) SHA1(ce7ba5a6d309677e51dcbc9e3058f98e69d1e917))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("nggsndl1.s2", 0x000000, 0x080000, CRC(6263866d) SHA1(c72a2f176aa24e91ecafe1704affd16b86d671e2))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("nggsndl1.s3", 0x100000, 0x100000, CRC(6871b20d) SHA1(0109c02282806016a6b22f7dfe3ac964931ba609))
	ROM_LOAD("nggsndl1.s4", 0x200000, 0x100000, CRC(86ed8f5a) SHA1(231f6313adff89ef4cec0d9f25b13e69ea96213d))
	ROM_LOAD("nggsndl1.s5", 0x300000, 0x100000, CRC(ea2062f0) SHA1(f8e45c1fcc6b8677a0745a5d83ca93b77fbde752))
	ROM_LOAD("nggsndl1.s6", 0x400000, 0x100000, CRC(b1b8b514) SHA1(e16651bcb2eae747987dc3c13a5dc20a33c0a1f8))
ROM_END

ROM_START(ngg_10)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ngg_10.rom", 0x00000, 0x80000, CRC(6680f6c1) SHA1(8ac37e3ea427c998f84a0c9c55e3f1e1da395870))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("nggsndl1.s2", 0x000000, 0x080000, CRC(6263866d) SHA1(c72a2f176aa24e91ecafe1704affd16b86d671e2))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("nggsndl1.s3", 0x100000, 0x100000, CRC(6871b20d) SHA1(0109c02282806016a6b22f7dfe3ac964931ba609))
	ROM_LOAD("nggsndl1.s4", 0x200000, 0x100000, CRC(86ed8f5a) SHA1(231f6313adff89ef4cec0d9f25b13e69ea96213d))
	ROM_LOAD("nggsndl1.s5", 0x300000, 0x100000, CRC(ea2062f0) SHA1(f8e45c1fcc6b8677a0745a5d83ca93b77fbde752))
	ROM_LOAD("nggsndl1.s6", 0x400000, 0x100000, CRC(b1b8b514) SHA1(e16651bcb2eae747987dc3c13a5dc20a33c0a1f8))
ROM_END

ROM_START(ngg_p06)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ngg0_6.rom", 0x00000, 0x80000, CRC(e0e0d331) SHA1(e1b91eccec6034bcd2029c15596aa0b129c9e53f))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ngg_s2.0_2", 0x000000, 0x080000, CRC(dde128d5) SHA1(214ee807d2323ecb407a3d116b038e15c60e5580))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("nggsndl1.s3", 0x100000, 0x100000, CRC(6871b20d) SHA1(0109c02282806016a6b22f7dfe3ac964931ba609))
	ROM_LOAD("nggsndl1.s4", 0x200000, 0x100000, CRC(86ed8f5a) SHA1(231f6313adff89ef4cec0d9f25b13e69ea96213d))
	ROM_LOAD("nggsndl1.s5", 0x300000, 0x100000, CRC(ea2062f0) SHA1(f8e45c1fcc6b8677a0745a5d83ca93b77fbde752))
	ROM_LOAD("nggsndl1.s6", 0x400000, 0x100000, CRC(b1b8b514) SHA1(e16651bcb2eae747987dc3c13a5dc20a33c0a1f8))
ROM_END

/*-----------------
/  Safe Cracker
/------------------*/
ROM_START(sc_18)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("safe_18g.rom", 0x00000, 0x80000, CRC(aeb4b669) SHA1(2925eb11133526ddff8ae92bb53f9b45c6ed8134))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("safsnds2.rom", 0x000000, 0x100000, CRC(20e14c63) SHA1(61b1c000a7afe5d0e9c31093e3fa963d6a594d54))
	ROM_LOAD("safsnds3.rom", 0x100000, 0x100000, CRC(99e318e7) SHA1(918f9013da82b29a559cb474bce93fb4ce88b731))
	ROM_LOAD("safsnds4.rom", 0x200000, 0x100000, CRC(9c8a23eb) SHA1(a0ee1174c8af0f262f9bec950da588cc9eb8747d))
ROM_END

ROM_START(sc_18n)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("safe_18n.rom", 0x00000, 0x80000, CRC(4d5d5626) SHA1(2d6f201d47f24df2195f10267ec1426cf0a087c9))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("safsnds2.rom", 0x000000, 0x100000, CRC(20e14c63) SHA1(61b1c000a7afe5d0e9c31093e3fa963d6a594d54))
	ROM_LOAD("safsnds3.rom", 0x100000, 0x100000, CRC(99e318e7) SHA1(918f9013da82b29a559cb474bce93fb4ce88b731))
	ROM_LOAD("safsnds4.rom", 0x200000, 0x100000, CRC(9c8a23eb) SHA1(a0ee1174c8af0f262f9bec950da588cc9eb8747d))
ROM_END

ROM_START(sc_18s2)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("safe_18g.rom", 0x00000, 0x80000, CRC(aeb4b669) SHA1(2925eb11133526ddff8ae92bb53f9b45c6ed8134))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("su2-24g.rom", 0x000000, 0x100000, CRC(712ce42e) SHA1(5d3b8e3eccdd1bc09a92de610161dd51293181b1))
	ROM_LOAD("safsnds3.rom", 0x100000, 0x100000, CRC(99e318e7) SHA1(918f9013da82b29a559cb474bce93fb4ce88b731))
	ROM_LOAD("safsnds4.rom", 0x200000, 0x100000, CRC(9c8a23eb) SHA1(a0ee1174c8af0f262f9bec950da588cc9eb8747d))
ROM_END

ROM_START(sc_17)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-17g.rom", 0x00000, 0x80000, CRC(f3d64156) SHA1(9226664b59c7b65ac39e2f32597efc45672cf505))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("safsnds2.rom", 0x000000, 0x100000, CRC(20e14c63) SHA1(61b1c000a7afe5d0e9c31093e3fa963d6a594d54))
	ROM_LOAD("safsnds3.rom", 0x100000, 0x100000, CRC(99e318e7) SHA1(918f9013da82b29a559cb474bce93fb4ce88b731))
	ROM_LOAD("safsnds4.rom", 0x200000, 0x100000, CRC(9c8a23eb) SHA1(a0ee1174c8af0f262f9bec950da588cc9eb8747d))
ROM_END

ROM_START(sc_17n)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-17n.rom", 0x00000, 0x80000, CRC(97628907) SHA1(3435f496e1850bf433add1bc403e3148de05c13a))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("safsnds2.rom", 0x000000, 0x100000, CRC(20e14c63) SHA1(61b1c000a7afe5d0e9c31093e3fa963d6a594d54))
	ROM_LOAD("safsnds3.rom", 0x100000, 0x100000, CRC(99e318e7) SHA1(918f9013da82b29a559cb474bce93fb4ce88b731))
	ROM_LOAD("safsnds4.rom", 0x200000, 0x100000, CRC(9c8a23eb) SHA1(a0ee1174c8af0f262f9bec950da588cc9eb8747d))
ROM_END

ROM_START(sc_14)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11-14.rom", 0x00000, 0x80000, CRC(1103f976) SHA1(6d6d23af1cd03f63b94a0ceb9711be51dce202f8))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1",0)
	ROM_LOAD("safsnds2.rom", 0x000000, 0x100000, CRC(20e14c63) SHA1(61b1c000a7afe5d0e9c31093e3fa963d6a594d54))
	ROM_LOAD("safsnds3.rom", 0x100000, 0x100000, CRC(99e318e7) SHA1(918f9013da82b29a559cb474bce93fb4ce88b731))
	ROM_LOAD("safsnds4.rom", 0x200000, 0x100000, CRC(9c8a23eb) SHA1(a0ee1174c8af0f262f9bec950da588cc9eb8747d))
ROM_END
/*-----------------
/  Scared Stiff
/------------------*/
ROM_START(ss_15)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ss_g11.1_5", 0x00000, 0x80000, CRC(5de8d0a0) SHA1(91cdd5f4e1654fd4dbde8b9cb03db935cba5d876))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("sssnd_11.s2", 0x000000, 0x100000, CRC(1b080a72) SHA1(be80e99e6bcc482379fe99519a4122f3b225be30))
	ROM_LOAD("sssnd_11.s3", 0x100000, 0x100000, CRC(c4f2e08a) SHA1(e20ff622a3f475db11f1f44d36a6669e160437a3))
	ROM_LOAD("sssnd_11.s4", 0x200000, 0x100000, CRC(258b0a27) SHA1(83763b98907cf38e6f7b9fe4f26ce93a54ba3568))
ROM_END

ROM_START(ss_14)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("stiffg11.1_4", 0x00000, 0x80000, CRC(17359ed6) SHA1(2ae549064a3666ea8b0b09aff9f5551db906d1d2))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("sssnd_11.s2", 0x000000, 0x100000, CRC(1b080a72) SHA1(be80e99e6bcc482379fe99519a4122f3b225be30))
	ROM_LOAD("sssnd_11.s3", 0x100000, 0x100000, CRC(c4f2e08a) SHA1(e20ff622a3f475db11f1f44d36a6669e160437a3))
	ROM_LOAD("sssnd_11.s4", 0x200000, 0x100000, CRC(258b0a27) SHA1(83763b98907cf38e6f7b9fe4f26ce93a54ba3568))
ROM_END

ROM_START(ss_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("stiffg11.1_2", 0x00000, 0x80000, CRC(70eca59c) SHA1(07d50a32a4fb287780c4e6c1cb6fbeba97480219))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("sssnd_11.s2", 0x000000, 0x100000, CRC(1b080a72) SHA1(be80e99e6bcc482379fe99519a4122f3b225be30))
	ROM_LOAD("sssnd_11.s3", 0x100000, 0x100000, CRC(c4f2e08a) SHA1(e20ff622a3f475db11f1f44d36a6669e160437a3))
	ROM_LOAD("sssnd_11.s4", 0x200000, 0x100000, CRC(258b0a27) SHA1(83763b98907cf38e6f7b9fe4f26ce93a54ba3568))
ROM_END

ROM_START(ss_03)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ss_g11.0_3", 0x00000, 0x80000, CRC(5b9755d6) SHA1(207d9ea858c76c4991747b401dc83183c1ddf7e4))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("sssnd_s2.22", 0x000000, 0x100000, CRC(12b92d7a) SHA1(69151ffb5d2befe28e1ed2c8153c2227552b681c))
	ROM_LOAD("sssnd_s3.21", 0x100000, 0x100000, CRC(c4f2e08a) SHA1(e20ff622a3f475db11f1f44d36a6669e160437a3))
	ROM_LOAD("sssnd_s4.21", 0x200000, 0x100000, CRC(258b0a27) SHA1(83763b98907cf38e6f7b9fe4f26ce93a54ba3568))
ROM_END

ROM_START(ss_01)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("ss_g11.rom", 0x00000, 0x80000, CRC(affd278f) SHA1(e6f41da169fa15c25cfaac22057f3e491da18fc5))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ss_s2.rom", 0x000000, 0x100000, CRC(ad079cbc) SHA1(77c7f676fc2f46e22b74b381638725269f7d23f4))
	ROM_LOAD("sssnd_s3.21", 0x100000, 0x100000, CRC(c4f2e08a) SHA1(e20ff622a3f475db11f1f44d36a6669e160437a3))
	ROM_LOAD("sssnd_s4.21", 0x200000, 0x100000, CRC(258b0a27) SHA1(83763b98907cf38e6f7b9fe4f26ce93a54ba3568))
ROM_END

/*-----------------
/  Tales Of The Arabian Nights
/------------------*/
ROM_START(totan_14)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("an_g11.1_4", 0x00000, 0x80000, CRC(54db749e) SHA1(8f8b44febf3b672107e7715ec16e39dd91ee4cbb))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ans2v1_1.rom", 0x000000, 0x100000, CRC(0d023f90) SHA1(e411f7824df89374cf3385a2660d5bc91e0e9ef0))
	ROM_LOAD("ans3v1_0.rom", 0x100000, 0x100000, CRC(3f677813) SHA1(b1e67c74b927c0c8cb76be8794a04a53fdf643d4))
	ROM_LOAD("ans4v1_0.rom", 0x200000, 0x100000, CRC(c26dff5f) SHA1(d86323f0df15cf7abd4480d173e6b217ef715396))
	ROM_LOAD("ans5v1_0.rom", 0x300000, 0x080000, CRC(32ca1602) SHA1(e4c7235b5d387bdde16ebef4d3aeeb7276c69d6d))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
ROM_END

ROM_START(totan_13)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("arab1_3.rom", 0x00000, 0x80000, CRC(2e4b9439) SHA1(ba564c5984d3b68eaeba27d06f3acd95d26073ee))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ans2v1_1.rom", 0x000000, 0x100000, CRC(0d023f90) SHA1(e411f7824df89374cf3385a2660d5bc91e0e9ef0))
	ROM_LOAD("ans3v1_0.rom", 0x100000, 0x100000, CRC(3f677813) SHA1(b1e67c74b927c0c8cb76be8794a04a53fdf643d4))
	ROM_LOAD("ans4v1_0.rom", 0x200000, 0x100000, CRC(c26dff5f) SHA1(d86323f0df15cf7abd4480d173e6b217ef715396))
	ROM_LOAD("ans5v1_0.rom", 0x300000, 0x080000, CRC(32ca1602) SHA1(e4c7235b5d387bdde16ebef4d3aeeb7276c69d6d))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
ROM_END

ROM_START(totan_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("arab1_2.rom", 0x00000, 0x80000, CRC(f9ae3796) SHA1(06e4ce89cab2e0fe5039de4261f7b5ebd4c11c0b))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ans2v1_1.rom", 0x000000, 0x100000, CRC(0d023f90) SHA1(e411f7824df89374cf3385a2660d5bc91e0e9ef0))
	ROM_LOAD("ans3v1_0.rom", 0x100000, 0x100000, CRC(3f677813) SHA1(b1e67c74b927c0c8cb76be8794a04a53fdf643d4))
	ROM_LOAD("ans4v1_0.rom", 0x200000, 0x100000, CRC(c26dff5f) SHA1(d86323f0df15cf7abd4480d173e6b217ef715396))
	ROM_LOAD("ans5v1_0.rom", 0x300000, 0x080000, CRC(32ca1602) SHA1(e4c7235b5d387bdde16ebef4d3aeeb7276c69d6d))
	ROM_RELOAD(0x300000+0x080000, 0x080000)
ROM_END

ROM_START(totan_04)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("an_g11.0_4", 0x00000, 0x80000, CRC(20da3800) SHA1(c8c048f35b1828f9ee1e7fc3201f1a316974b924))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ans2v1_1.rom", 0x000000, 0x100000, CRC(0d023f90) SHA1(e411f7824df89374cf3385a2660d5bc91e0e9ef0))
	ROM_LOAD("ans3v1_0.rom", 0x100000, 0x100000, CRC(3f677813) SHA1(b1e67c74b927c0c8cb76be8794a04a53fdf643d4))
	ROM_LOAD("ans4v1_0.rom", 0x200000, 0x100000, CRC(c26dff5f) SHA1(d86323f0df15cf7abd4480d173e6b217ef715396))
	ROM_LOAD("ans5v1_0.rom", 0x300000, 0x080000, CRC(32ca1602) SHA1(e4c7235b5d387bdde16ebef4d3aeeb7276c69d6d))
	ROM_RELOAD(0x300000 +0x080000, 0x080000)
ROM_END

/*-----------------
/  The Champion Pub
/------------------*/
ROM_START(cp_16)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("cp_g11.1_6", 0x00000, 0x80000, CRC(d6d0b921) SHA1(6784bd5116d239f307310d4a1ddac1068292dd60))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("cp_s2.bin", 0x000000, 0x080000, CRC(e0b67f6f) SHA1(48fbf01eca4fd6250df18bb5f35959100f40f6e0))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("cp_s3.bin", 0x100000, 0x100000, CRC(68accf24) SHA1(9f86ac84ef8130592e471f1da0e05ba811dbc38b))
	ROM_LOAD("cp_s4.bin", 0x200000, 0x100000, CRC(50d1c920) SHA1(00b247853ef1f91c6245746c9311f8463b9335d1))
	ROM_LOAD("cp_s5.bin", 0x300000, 0x100000, CRC(69af347a) SHA1(d15683e6297603104e4ba777224331c24565be7c))
	ROM_LOAD("cp_s6.bin", 0x400000, 0x100000, CRC(76ca4fed) SHA1(8995e518c8dafbdd8bf994533b71f42172057b27))
	ROM_LOAD("cp_s7.bin", 0x500000, 0x100000, CRC(be619157) SHA1(b18acde4f683b5f8b2248b46bb3dc7c3e0ab1c26))
ROM_END

ROM_START(cp_15)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("cp_g11.1_5", 0x00000, 0x80000, CRC(4255bfcb) SHA1(4ec17e6c0e07fd8d52af9d33776007930d8422c6))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("cp_s2.bin", 0x000000, 0x080000, CRC(e0b67f6f) SHA1(48fbf01eca4fd6250df18bb5f35959100f40f6e0))
	ROM_RELOAD(0x000000+0x080000, 0x080000)
	ROM_LOAD("cp_s3.bin", 0x100000, 0x100000, CRC(68accf24) SHA1(9f86ac84ef8130592e471f1da0e05ba811dbc38b))
	ROM_LOAD("cp_s4.bin", 0x200000, 0x100000, CRC(50d1c920) SHA1(00b247853ef1f91c6245746c9311f8463b9335d1))
	ROM_LOAD("cp_s5.bin", 0x300000, 0x100000, CRC(69af347a) SHA1(d15683e6297603104e4ba777224331c24565be7c))
	ROM_LOAD("cp_s6.bin", 0x400000, 0x100000, CRC(76ca4fed) SHA1(8995e518c8dafbdd8bf994533b71f42172057b27))
	ROM_LOAD("cp_s7.bin", 0x500000, 0x100000, CRC(be619157) SHA1(b18acde4f683b5f8b2248b46bb3dc7c3e0ab1c26))
ROM_END

/*-------------
/ Ticket Tac Toe
/--------------*/
ROM_START(ttt_10)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("tikt1_0.rom", 0x00000, 0x80000, CRC(bf1d0382) SHA1(3d26413400915594e9f1cc08a551c05526b94223))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("ttt_s2.rom", 0x000000, 0x100000, CRC(faae93eb) SHA1(672758544b260d7751ac296f5beb2e271e77c50a))
	ROM_LOAD("ttt_s3.rom", 0x100000, 0x100000, CRC(371ba9b3) SHA1(de6a8cb78e08a434f6668dd4a93cad857acba310))
ROM_END

/*--------------
/ Test Fixture WPC95
/---------------*/
ROM_START(tf95_12)
	ROM_REGION(0x10000, "maincpu", ROMREGION_ERASEFF)
	ROM_REGION(0x2000, "user1",  ROMREGION_ERASEFF)
	ROM_REGION(0x80000, "user2", 0)
	ROM_LOAD("g11_12.rom", 0x00000, 0x80000, CRC(259a2b23) SHA1(16f8c15e046809e0b1587b0c981d36f4d8a750ca))
	ROM_REGION(0x20000, "cpu2", ROMREGION_ERASEFF)
	ROM_REGION(0x1000*2, "user3", ROMREGION_ERASEFF)
	ROM_REGION(0x800000, "sound1", 0)
	ROM_LOAD("s2_10.rom", 0x000000, 0x100000, CRC(ceff7fe4) SHA1(ff2574f65e09d446b9e446abd58159a7d100059b))
ROM_END

GAME(1996,	tf95_12,	0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"WPC 95 Test Fixture (1.2)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	afm_113,	0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Attack From Mars (1.13)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	afm_113b,	afm_113,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Attack From Mars (1.13b)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	afm_11,		afm_113,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Attack From Mars (1.1)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	afm_11u,	afm_113,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Attack From Mars (1.1 Ultrapin)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	afm_10,		afm_113,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Attack From Mars (1.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	cc_13,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Cactus Canyon (1.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	cc_12,		cc_13,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Cactus Canyon (1.2)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	cv_14,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Cirqus Voltaire (1.4)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	cv_20h,		cv_14,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Cirqus Voltaire (2.0H)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	cv_10,		cv_14,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Cirqus Voltaire (1.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	cv_11,		cv_14,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Cirqus Voltaire (1.1)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	cv_13,		cv_14,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Cirqus Voltaire (1.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	congo_21,	0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Congo (2.1)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	congo_20,	congo_21,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Congo (2.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1995,	congo_13,	congo_21,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Congo (1.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	jy_12,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Junk Yard (1.2)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	jy_11,		jy_12,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Junk Yard (1.1)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	jy_03,		jy_12,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Junk Yard (0.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1999,	mm_10,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Medieval Madness (1.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1999,	mm_10u,		mm_10,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Medieval Madness (1.0 Ultrapin)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1999,	mm_109,		mm_10,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Medieval Madness (1.09)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1999,	mm_109b,	mm_10,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Medieval Madness (1.09B)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1999,	mm_109c,	mm_10,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Medieval Madness (1.09C Profanity)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	mm_05,		mm_10,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Medieval Madness (0.50)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	mb_10,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Monster Bash (1.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	mb_106,		mb_10,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Monster Bash (1.06)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	mb_106b,	mb_10,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Monster Bash (1.06b)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_31,	0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (3.1 - S3.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_31a,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (3.1 - S1.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_11s,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (1.1 - S0.4)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_11,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (1.1)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_11a,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (1.1 - S2.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_115,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (1.15)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_21,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (2.1)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_22,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (2.2)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	nbaf_23,	nbaf_31,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"NBA Fastbreak (2.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	ngg_13,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"No Good Gofers (1.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	ngg_p06,	ngg_13,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"No Good Gofers (p0.6)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1997,	ngg_10,		ngg_13,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"No Good Gofers (1.0)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	sc_18,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Safe Cracker (1.8)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	sc_18n,		sc_18,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Safe Cracker (1.8N)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	sc_18s2,	sc_18,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Safe Cracker (1.8 alternate sound)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	sc_17,		sc_18,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Safe Cracker (1.7)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	sc_17n,		sc_18,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Safe Cracker (1.7N)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	sc_14,		sc_18,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Safe Cracker (1.4)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	ss_15,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Scared Stiff (1.5)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	ss_14,		ss_15,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Scared Stiff (1.4)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	ss_12,		ss_15,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Scared Stiff (1.2)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	ss_03,		ss_15,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Scared Stiff (0.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	ss_01,		ss_15,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"Scared Stiff (D0.1R with sound rev.25)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	totan_14,	0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Tales Of The Arabian Nights (1.4)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	totan_13,	totan_14,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Tales Of The Arabian Nights (1.3)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	totan_12,	totan_14,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Tales Of The Arabian Nights (1.2)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	totan_04,	totan_14,	wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Tales Of The Arabian Nights (0.4)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	cp_16,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"The Champion Pub (1.6)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1998,	cp_15,		cp_16,		wpc_95,	wpc_95,	wpc_95,	ROT0,	"Bally",				"The Champion Pub (1.5)",				GAME_IS_SKELETON_MECHANICAL)
GAME(1996,	ttt_10,		0,			wpc_95,	wpc_95,	wpc_95,	ROT0,	"Williams",				"Ticket Tac Toe (1.0)",				GAME_IS_SKELETON_MECHANICAL)
