# coding: utf-8
=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: Skin prepared for Little Brother, Cory Doctorow
 * License: Same as SiSU see http://www.jus.uio.no/sisu
 * Notes: Site default appearance variables set in defaults.rb
     Generic site wide modifications set here scribe_skin.rb, and this file required by other "scribes" instead of defaults.rb
=end
module SiSU_Viz
  require SiSU_lib + '/defaults'
  class Skin
    #% path
    def path_root                                                                     # the only parameter that cannot be changed here
      './sisu/'
    end
    def path_rel
      '../'
    end
    #% url
    def url_home
      'http://craphound.com/littlebrother'
    end
    def url_txt                                                                      # text to go with url usually stripped url
      'craphound.com/littlebrother'
    end
    #% color
    def color_band1
      '"#ffffff"'
    end
    #% text
    def text_hp
      'craphound.com/littlebrother'
    end
    def text_home
      'Little Brother'
    end
    #% icon
    def icon_home_button
      'little_brother_doctorow.png'
    end
    def icon_home_banner
      icon_home_button
    end
    #% banner
    def banner_home_button
      %{<table summary="home button" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_white}><a href="#{url_home}">#{png_home}</a></td></tr></table>\n}
    end
    def banner_home_and_index_buttons
      %{<table><tr><td width="20%"><table summary="home and index buttons" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_white}><a href="#{url_home}" target="_top">#{png_home}</a></td><td width="40%"><center><table summary="buttons" border="1" cellpadding="3" cellspacing="0"><tr><td align="center" bgcolor="#f1e8de"><font face="arial" size="2"><a href="toc.html" target="_top">&nbsp;This&nbsp;text&nbsp;sub-&nbsp;<br />&nbsp;Table&nbsp;of&nbsp;Contents&nbsp;</a></font>#{table_close}</center></td><td width="20%">&nbsp;#{table_close}}
    end
    def banner_band
      %{<table summary="band" border="0" cellpadding="3" cellspacing="0"><tr><td align="left" bgcolor=#{color_white}><a href="#{url_home}" target="_top">#{png_home}</a>#{table_close}}
    end
    #% credits
    def credits_splash
      %{<table summary="credits" align="center" bgcolor="#ffffff"><tr><td><font color="black"><center>
<a href="http://craphound.com/littlebrother">The author's original pdf is available</a> at<br /><a href="http://craphound.com/littlebrother">craphound.com/littlebrother</a><br />
available at<br /><a href="http://www.amazon.com/Little-Brother-Cory-Doctorow/dp/B002IT5OMA">Amazon.com</a> and <br />
<a href="http://search.barnesandnoble.com/Little-Brother/Cory-Doctorow/e/9780765319852">Barnes & Noble</a><br />
This book is Copyright Cory Doctorow © 2008<br />
Under a Creative Commons License,<br />
Attribution-NonCommercial-NoDerivs 3.0:<br />
* Attribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work);<br />
* Noncommercial. You may not use this work for commercial purposes;<br />
* Share Alike - If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.
<br />
&lt;<a href="http://creativecommons.org/licenses/by-nc-sa/3.0/">http://creativecommons.org/licenses/by-nc-sa/3.0/</a>&gt;<br />
</center></font></td></tr></table>}
    end
  end
  class TeX
    def header_center
	    "\\chead{\\href{#{@vz.url_home}}{craphound.com/littlebrother}}"
    end
    def home_url
	    "\\href{#{@vz.url_home}}{craphound.com/littlebrother}"
    end
    def home
	    "\\href{#{@vz.url_home}}{Little Brother}"
    end
    def owner_chapter
      "Document owner details"
    end
  end
end
__END__
