+++
title = "HemiEllipsoid"
+++

### HemiEllipsoid

An horizontally oriented ellipsoid, truncated at the central plane.

<img src="/img/draw/ff/3d/HemiEllipsoid.png" width="30%" >
<img src="/img/draw/ff/2d/HemiEllipsoid_xy.svg" width="30%">
<img src="/img/draw/ff/2d/HemiEllipsoid_xz.svg" width="30%">

#### Constructor

```python
HemiEllipsoid(R_x, R_y, R_z)
```

Parameters:
- R_x, radius $R_{x}$ in $x$ direction
- R_y, radius $R_{y}$ in $y$ direction
- R_z, radius $R_{z}$ in $z$ direction

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "HemiEllipsoid" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.

Computation involves numerical integration in vertical direction,

$$ F(\mathbf{q})=2\pi \int_{0}^{R_z} \text{d}z \space r_{x,z} r_{y,z} \frac{J_1(\gamma_{z})}{\gamma_{z}}  \thinspace \exp(iq_z z) , $$

with the notation 

$$ r_{x,z}:=R_{x}\sqrt{1-\Big( \dfrac{z}{R_z} \Big)^2}, \quad r_{y,z}:=R_{y}\sqrt{1-\Big( \dfrac{z}{R_z} \Big)^2}, $$ 

$$ \quad \gamma_{z} := \sqrt{(q_xr_{x,z})^2 + (q_yr_{y,z})^2}. $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$ V=\dfrac{2\pi}{3} R_xR_yR_z. $$

#### Related shapes

- [SphericalSegment](/ref/sample/particle/ff/hard/sphericalsegment), sphere truncated from the top and/or the bottom.
- [SpheroidalSegment](/ref/sample/particle/ff/hard/spheroidalsegment), spheroid truncated from the top and/or the bottom.
  
#### Example

Scattering by uncorrelated, oriented hemiellipsoids for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/HemiEllipsoid.png">

Generated by {{% ref-ex "ff/HemiEllipsoid.py" %}}.

#### History

Agrees with the IsGISAXS form factor "Anisotropic hemi-ellipsoid" [[manual](/lit/lazzari2006), Eq. 2.41] with wrong sign in the z-dependent phase factor and "Hemi-spheroid" [[Renaud 2009](/lit/renaud2009), Eq. 229].
