/*
 *    This file is part of CasADi.
 *
 *    CasADi -- A symbolic framework for dynamic optimization.
 *    Copyright (C) 2010-2023 Joel Andersson, Joris Gillis, Moritz Diehl,
 *                            KU Leuven. All rights reserved.
 *    Copyright (C) 2011-2014 Greg Horn
 *
 *    CasADi is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 3 of the License, or (at your option) any later version.
 *
 *    CasADi is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with CasADi; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


      #include "sqpmethod.hpp"
      #include <string>

      const std::string casadi::Sqpmethod::meta_doc=
      "\n"
"\n"
"\n"
"A textbook SQPMethod\n"
"\n"
"Extra doc: https://github.com/casadi/casadi/wiki/L_22x \n"
"\n"
"\n"
">List of available options\n"
"\n"
"+--------------------------+-------------+---------------------------------+\n"
"|            Id            |    Type     |           Description           |\n"
"+==========================+=============+=================================+\n"
"| beta                     | OT_DOUBLE   | Line-search parameter,          |\n"
"|                          |             | restoration factor of stepsize  |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| c1                       | OT_DOUBLE   | Armijo condition, coefficient   |\n"
"|                          |             | of decrease in merit            |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| convexify_margin         | OT_DOUBLE   | When using a convexification    |\n"
"|                          |             | strategy, make sure that the    |\n"
"|                          |             | smallest eigenvalue is at least |\n"
"|                          |             | this (default: 1e-7).           |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| convexify_strategy       | OT_STRING   | NONE|regularize|eigen-          |\n"
"|                          |             | reflect|eigen-clip. Strategy to |\n"
"|                          |             | convexify the Lagrange Hessian  |\n"
"|                          |             | before passing it to the        |\n"
"|                          |             | solver.                         |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| elastic_mode             | OT_BOOL     | Enable the elastic mode which   |\n"
"|                          |             | is used when the QP is          |\n"
"|                          |             | infeasible (default: false).    |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| gamma_0                  | OT_DOUBLE   | Starting value for the penalty  |\n"
"|                          |             | parameter of elastic mode       |\n"
"|                          |             | (default: 1).                   |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| gamma_1_min              | OT_DOUBLE   | Minimum value for gamma_1       |\n"
"|                          |             | (default: 1e-5).                |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| gamma_max                | OT_DOUBLE   | Maximum value for the penalty   |\n"
"|                          |             | parameter of elastic mode       |\n"
"|                          |             | (default: 1e20).                |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| hess_lag                 | OT_FUNCTION | Function for calculating the    |\n"
"|                          |             | Hessian of the Lagrangian       |\n"
"|                          |             | (autogenerated by default)      |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| hessian_approximation    | OT_STRING   | limited-memory|exact            |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| init_feasible            | OT_BOOL     | Initialize the QP subproblems   |\n"
"|                          |             | with a feasible initial value   |\n"
"|                          |             | (default: false).               |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| jac_fg                   | OT_FUNCTION | Function for calculating the    |\n"
"|                          |             | gradient of the objective and   |\n"
"|                          |             | Jacobian of the constraints     |\n"
"|                          |             | (autogenerated by default)      |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| lbfgs_memory             | OT_INT      | Size of L-BFGS memory.          |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| max_iter                 | OT_INT      | Maximum number of SQP           |\n"
"|                          |             | iterations                      |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| max_iter_eig             | OT_DOUBLE   | Maximum number of iterations to |\n"
"|                          |             | compute an eigenvalue           |\n"
"|                          |             | decomposition (default: 50).    |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| max_iter_ls              | OT_INT      | Maximum number of linesearch    |\n"
"|                          |             | iterations                      |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| merit_memory             | OT_INT      | Size of memory to store history |\n"
"|                          |             | of merit function values        |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| min_iter                 | OT_INT      | Minimum number of SQP           |\n"
"|                          |             | iterations                      |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| min_step_size            | OT_DOUBLE   | The size (inf-norm) of the step |\n"
"|                          |             | size should not become smaller  |\n"
"|                          |             | than this.                      |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| print_header             | OT_BOOL     | Print the header with problem   |\n"
"|                          |             | statistics                      |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| print_iteration          | OT_BOOL     | Print the iterations            |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| print_status             | OT_BOOL     | Print a status message after    |\n"
"|                          |             | solving                         |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| qpsol                    | OT_STRING   | The QP solver to be used by the |\n"
"|                          |             | SQP method [qpoases]            |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| qpsol_options            | OT_DICT     | Options to be passed to the QP  |\n"
"|                          |             | solver                          |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| second_order_corrections | OT_BOOL     | Enable second order             |\n"
"|                          |             | corrections. These are used     |\n"
"|                          |             | when a step is considered bad   |\n"
"|                          |             | by the merit function and       |\n"
"|                          |             | constraint norm (default:       |\n"
"|                          |             | false).                         |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| tol_du                   | OT_DOUBLE   | Stopping criterion for dual     |\n"
"|                          |             | infeasability                   |\n"
"+--------------------------+-------------+---------------------------------+\n"
"| tol_pr                   | OT_DOUBLE   | Stopping criterion for primal   |\n"
"|                          |             | infeasibility                   |\n"
"+--------------------------+-------------+---------------------------------+\n"
"\n"
"\n"
"\n"
"\n"
;
