#
# Copyright (C) 2017-2020 Red Hat, Inc.
#
# Cockpit is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation; either version 2.1 of the License, or
# (at your option) any later version.
#
# Cockpit is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Cockpit; If not, see <http://www.gnu.org/licenses/>.
#

Name:           cockpit-podman
Version:        67
Release:        1%{?dist}
Summary:        Cockpit component for Podman containers
License:        LGPL-2.1-or-later
URL:            https://github.com/cockpit-project/cockpit-podman

Source0:        https://github.com/cockpit-project/%{name}/releases/download/%{version}/%{name}-%{version}.tar.xz
BuildArch:      noarch
BuildRequires:  libappstream-glib
BuildRequires:  make
BuildRequires: gettext
%if 0%{?rhel} && 0%{?rhel} <= 8
BuildRequires: libappstream-glib-devel
%endif

Requires:       cockpit-bridge
Requires:       podman >= 2.0.4
# HACK https://github.com/containers/crun/issues/1091
%if 0%{?fedora} == 36 || 0%{?fedora} == 37 || 0%{?centos} == 9
Requires:       criu-libs
%endif

Provides: bundled(npm(@patternfly/patternfly)) = 4.224.4
Provides: bundled(npm(@patternfly/react-core)) = 4.276.9
Provides: bundled(npm(@patternfly/react-icons)) = 4.93.6
Provides: bundled(npm(@patternfly/react-styles)) = 4.92.7
Provides: bundled(npm(@patternfly/react-table)) = 4.113.1
Provides: bundled(npm(@patternfly/react-tokens)) = 4.94.6
Provides: bundled(npm(attr-accept)) = 1.1.3
Provides: bundled(npm(core-js)) = 2.6.12
Provides: bundled(npm(date-fns)) = 2.28.0
Provides: bundled(npm(docker-names)) = 1.2.1
Provides: bundled(npm(file-selector)) = 0.1.19
Provides: bundled(npm(focus-trap)) = 6.9.2
Provides: bundled(npm(js-tokens)) = 4.0.0
Provides: bundled(npm(lodash)) = 4.17.21
Provides: bundled(npm(loose-envify)) = 1.4.0
Provides: bundled(npm(object-assign)) = 4.1.1
Provides: bundled(npm(popper.js)) = 1.16.1
Provides: bundled(npm(prop-types-extra)) = 1.1.1
Provides: bundled(npm(prop-types)) = 15.8.1
Provides: bundled(npm(react-dom)) = 18.2.0
Provides: bundled(npm(react-dropzone)) = 9.0.0
Provides: bundled(npm(react-is)) = 16.13.1
Provides: bundled(npm(react)) = 18.2.0
Provides: bundled(npm(scheduler)) = 0.23.0
Provides: bundled(npm(tabbable)) = 5.3.3
Provides: bundled(npm(throttle-debounce)) = 2.3.0
Provides: bundled(npm(tippy.js)) = 5.1.2
Provides: bundled(npm(tslib)) = 2.5.0
Provides: bundled(npm(warning)) = 4.0.3
Provides: bundled(npm(xterm)) = 4.18.0

%description
The Cockpit user interface for Podman containers.

%prep
%setup -q -n %{name}

%build
# Nothing to build

%install
%make_install
appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/metainfo/*

%files
%doc README.md
%license LICENSE dist/index.js.LEGAL.txt dist/index.css.LEGAL.txt
%{_datadir}/cockpit/*
%{_datadir}/metainfo/*

%changelog
