/* ROM function interface esp32c2.rom.ld for esp32c2
 *
 *
 * Generated from ./interface-esp8684.yml md5sum 6c4d0f3a9f2d0c93477024a1a8f13746
 *
 * Compatible with ROM where ECO version equal or greater to 0.
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED. DO NOT EDIT.
 */

/***************************************
 Group common
 ***************************************/

PROVIDE ( SPIWrite = esp_rom_spiflash_write);
PROVIDE ( SPI_read_status_high = esp_rom_spiflash_read_statushigh);
PROVIDE ( SPI_write_status = esp_rom_spiflash_write_status);
PROVIDE ( SPIRead = esp_rom_spiflash_read);
PROVIDE ( SPIParamCfg = esp_rom_spiflash_config_param);
PROVIDE ( SPIEraseChip = esp_rom_spiflash_erase_chip);
PROVIDE ( SPIEraseSector = esp_rom_spiflash_erase_sector);
PROVIDE ( SPIEraseBlock = esp_rom_spiflash_erase_block);
PROVIDE ( SPI_Write_Encrypt_Enable = esp_rom_spiflash_write_encrypted_enable);
PROVIDE ( SPI_Write_Encrypt_Disable = esp_rom_spiflash_write_encrypted_disable);
PROVIDE ( SPI_Encrypt_Write = esp_rom_spiflash_write_encrypted);

PROVIDE ( mbedtls_md5_starts_ret = mbedtls_md5_starts_ret );
PROVIDE ( mbedtls_md5_update_ret = mbedtls_md5_update_ret );
PROVIDE ( mbedtls_md5_finish_ret = mbedtls_md5_finish_ret );

/***************************************
 Group common
 ***************************************/

/* Functions */
rtc_get_reset_reason = 0x40000018;
analog_super_wdt_reset_happened = 0x4000001c;
rtc_get_wakeup_cause = 0x40000020;
rtc_select_apb_bridge = 0x40000024;
rtc_unhold_all_pads = 0x40000028;
ets_is_print_boot = 0x4000002c;
ets_vprintf = 0x40000030;
ets_printf = 0x40000034;
ets_install_putc1 = 0x40000038;
ets_install_uart_printf = 0x4000003c;
ets_install_putc2 = 0x40000040;
PROVIDE( ets_delay_us = 0x40000044 );
ets_get_stack_info = 0x40000048;
ets_install_lock = 0x4000004c;
UartRxString = 0x40000050;
UartGetCmdLn = 0x40000054;
uart_tx_one_char = 0x40000058;
uart_tx_one_char2 = 0x4000005c;
uart_rx_one_char = 0x40000060;
uart_rx_one_char_block = 0x40000064;
uart_rx_readbuff = 0x40000068;
uartAttach = 0x4000006c;
uart_tx_flush = 0x40000070;
uart_tx_wait_idle = 0x40000074;
uart_div_modify = 0x40000078;
ets_write_char_uart = 0x4000007c;
uart_tx_switch = 0x40000080;
multofup = 0x40000084;
software_reset = 0x40000088;
software_reset_cpu = 0x4000008c;
assist_debug_clock_enable = 0x40000090;
assist_debug_record_enable = 0x40000094;
clear_super_wdt_reset_flag = 0x40000098;
disable_default_watchdog = 0x4000009c;
send_packet = 0x400000a0;
recv_packet = 0x400000a4;
GetUartDevice = 0x400000a8;
UartDwnLdProc = 0x400000ac;
GetSecurityInfoProc = 0x400000b0;
Uart_Init = 0x400000b4;
ets_set_user_start = 0x400000b8;
/* Data (.data, .bss, .rodata) */
ets_rom_layout_p = 0x3ff4fffc;
ets_ops_table_ptr = 0x3fcdfffc;


/***************************************
 Group miniz
 ***************************************/

/* Functions */
mz_adler32 = 0x400000bc;
mz_free = 0x400000c0;
tdefl_compress = 0x400000c4;
tdefl_compress_buffer = 0x400000c8;
tdefl_compress_mem_to_heap = 0x400000cc;
tdefl_compress_mem_to_mem = 0x400000d0;
tdefl_compress_mem_to_output = 0x400000d4;
tdefl_get_adler32 = 0x400000d8;
tdefl_get_prev_return_status = 0x400000dc;
tdefl_init = 0x400000e0;
tdefl_write_image_to_png_file_in_memory = 0x400000e4;
tdefl_write_image_to_png_file_in_memory_ex = 0x400000e8;
tinfl_decompress = 0x400000ec;
tinfl_decompress_mem_to_callback = 0x400000f0;
tinfl_decompress_mem_to_heap = 0x400000f4;
tinfl_decompress_mem_to_mem = 0x400000f8;


/***************************************
 Group spiflash_legacy
 ***************************************/

/* Functions */
PROVIDE( esp_rom_spiflash_wait_idle = 0x400000fc );
PROVIDE( esp_rom_spiflash_write_encrypted = 0x40000100 );
PROVIDE( esp_rom_spiflash_write_encrypted_dest = 0x40000104 );
PROVIDE( esp_rom_spiflash_write_encrypted_enable = 0x40000108 );
PROVIDE( esp_rom_spiflash_write_encrypted_disable = 0x4000010c );
PROVIDE( esp_rom_spiflash_erase_chip = 0x40000110 );
PROVIDE( _esp_rom_spiflash_erase_sector = 0x40000114 );
PROVIDE( _esp_rom_spiflash_erase_block = 0x40000118 );
PROVIDE( _esp_rom_spiflash_write = 0x4000011c );
PROVIDE( _esp_rom_spiflash_read = 0x40000120 );
PROVIDE( _esp_rom_spiflash_unlock = 0x40000124 );
PROVIDE( _SPIEraseArea = 0x40000128 );
PROVIDE( _SPI_write_enable = 0x4000012c );
PROVIDE( esp_rom_spiflash_erase_sector = 0x40000130 );
PROVIDE( esp_rom_spiflash_erase_block = 0x40000134 );
PROVIDE( esp_rom_spiflash_write = 0x40000138 );
PROVIDE( esp_rom_spiflash_read = 0x4000013c );
PROVIDE( esp_rom_spiflash_unlock = 0x40000140 );
PROVIDE( SPIEraseArea = 0x40000144 );
PROVIDE( SPI_write_enable = 0x40000148 );
PROVIDE( esp_rom_spiflash_config_param = 0x4000014c );
PROVIDE( esp_rom_spiflash_read_user_cmd = 0x40000150 );
PROVIDE( esp_rom_spiflash_select_qio_pins = 0x40000154 );
PROVIDE( esp_rom_spi_flash_auto_sus_res = 0x40000158 );
PROVIDE( esp_rom_spi_flash_send_resume = 0x4000015c );
PROVIDE( esp_rom_spi_flash_update_id = 0x40000160 );
PROVIDE( esp_rom_spiflash_config_clk = 0x40000164 );
PROVIDE( esp_rom_spiflash_config_readmode = 0x40000168 );
PROVIDE( esp_rom_spiflash_read_status = 0x4000016c );
PROVIDE( esp_rom_spiflash_read_statushigh = 0x40000170 );
PROVIDE( esp_rom_spiflash_write_status = 0x40000174 );
PROVIDE( spi_flash_attach = 0x40000178 );
PROVIDE( spi_flash_get_chip_size = 0x4000017c );
PROVIDE( spi_flash_guard_set = 0x40000180 );
PROVIDE( spi_flash_guard_get = 0x40000184 );
PROVIDE( spi_flash_read_encrypted = 0x40000188 );
PROVIDE( spi_flash_mmap_os_func_set = 0x4000018c );
PROVIDE( spi_flash_mmap_page_num_init = 0x40000190 );
PROVIDE( spi_flash_mmap = 0x40000194 );
PROVIDE( spi_flash_mmap_pages = 0x40000198 );
PROVIDE( spi_flash_munmap = 0x4000019c );
PROVIDE( spi_flash_mmap_dump = 0x400001a0 );
PROVIDE( spi_flash_check_and_flush_cache = 0x400001a4 );
PROVIDE( spi_flash_mmap_get_free_pages = 0x400001a8 );
PROVIDE( spi_flash_cache2phys = 0x400001ac );
PROVIDE( spi_flash_phys2cache = 0x400001b0 );
PROVIDE( spi_flash_disable_cache = 0x400001b4 );
PROVIDE( spi_flash_restore_cache = 0x400001b8 );
PROVIDE( spi_flash_cache_enabled = 0x400001bc );
PROVIDE( spi_flash_enable_cache = 0x400001c0 );
PROVIDE( spi_cache_mode_switch = 0x400001c4 );
PROVIDE( spi_common_set_dummy_output = 0x400001c8 );
PROVIDE( spi_common_set_flash_cs_timing = 0x400001cc );
PROVIDE( esp_rom_spi_set_address_bit_len = 0x400001d0 );
PROVIDE( esp_enable_cache_flash_wrap = 0x400001d4 );
PROVIDE( SPILock = 0x400001d8 );
PROVIDE( SPIMasterReadModeCnfig = 0x400001dc );
PROVIDE( SPI_Common_Command = 0x400001e0 );
PROVIDE( SPI_WakeUp = 0x400001e4 );
PROVIDE( SPI_block_erase = 0x400001e8 );
PROVIDE( SPI_chip_erase = 0x400001ec );
PROVIDE( SPI_init = 0x400001f0 );
PROVIDE( SPI_page_program = 0x400001f4 );
PROVIDE( SPI_read_data = 0x400001f8 );
PROVIDE( SPI_sector_erase = 0x400001fc );
PROVIDE( SelectSpiFunction = 0x40000200 );
PROVIDE( SetSpiDrvs = 0x40000204 );
PROVIDE( Wait_SPI_Idle = 0x40000208 );
PROVIDE( spi_dummy_len_fix = 0x4000020c );
PROVIDE( Disable_QMode = 0x40000210 );
PROVIDE( Enable_QMode = 0x40000214 );
/* Data (.data, .bss, .rodata) */
PROVIDE( rom_spiflash_legacy_funcs = 0x3fcdfff4 );
PROVIDE( rom_spiflash_legacy_data = 0x3fcdfff0 );
PROVIDE( g_flash_guard_ops = 0x3fcdfff8 );


/***************************************
 Group hal_soc
 ***************************************/

/* Functions */
PROVIDE( spi_flash_hal_poll_cmd_done = 0x40000218 );
PROVIDE( spi_flash_hal_device_config = 0x4000021c );
PROVIDE( spi_flash_hal_configure_host_io_mode = 0x40000220 );
PROVIDE( spi_flash_hal_common_command = 0x40000224 );
PROVIDE( spi_flash_hal_read = 0x40000228 );
PROVIDE( spi_flash_hal_erase_chip = 0x4000022c );
PROVIDE( spi_flash_hal_erase_sector = 0x40000230 );
PROVIDE( spi_flash_hal_erase_block = 0x40000234 );
PROVIDE( spi_flash_hal_program_page = 0x40000238 );
PROVIDE( spi_flash_hal_set_write_protect = 0x4000023c );
PROVIDE( spi_flash_hal_host_idle = 0x40000240 );
PROVIDE( spi_flash_hal_check_status = 0x40000244 );
PROVIDE( spi_flash_hal_setup_read_suspend = 0x40000248 );
PROVIDE( spi_flash_hal_setup_auto_suspend_mode = 0x4000024c );
PROVIDE( spi_flash_hal_setup_auto_resume_mode = 0x40000250 );
PROVIDE( spi_flash_hal_disable_auto_suspend_mode = 0x40000254 );
PROVIDE( spi_flash_hal_disable_auto_resume_mode = 0x40000258 );
PROVIDE( spi_flash_hal_resume = 0x4000025c );
PROVIDE( spi_flash_hal_suspend = 0x40000260 );
PROVIDE( spi_flash_encryption_hal_enable = 0x40000264 );
PROVIDE( spi_flash_encryption_hal_disable = 0x40000268 );
PROVIDE( spi_flash_encryption_hal_prepare = 0x4000026c );
PROVIDE( spi_flash_encryption_hal_done = 0x40000270 );
PROVIDE( spi_flash_encryption_hal_destroy = 0x40000274 );
PROVIDE( spi_flash_encryption_hal_check = 0x40000278 );
PROVIDE( wdt_hal_init = 0x4000027c );
PROVIDE( wdt_hal_deinit = 0x40000280 );
PROVIDE( wdt_hal_config_stage = 0x40000284 );
PROVIDE( wdt_hal_write_protect_disable = 0x40000288 );
PROVIDE( wdt_hal_write_protect_enable = 0x4000028c );
PROVIDE( wdt_hal_enable = 0x40000290 );
PROVIDE( wdt_hal_disable = 0x40000294 );
PROVIDE( wdt_hal_handle_intr = 0x40000298 );
PROVIDE( wdt_hal_feed = 0x4000029c );
PROVIDE( wdt_hal_set_flashboot_en = 0x400002a0 );
PROVIDE( wdt_hal_is_enabled = 0x400002a4 );
PROVIDE( systimer_hal_init = 0x400002a8 );
PROVIDE( systimer_hal_get_counter_value = 0x400002ac );
PROVIDE( systimer_hal_get_time = 0x400002b0 );
PROVIDE( systimer_hal_set_alarm_target = 0x400002b4 );
PROVIDE( systimer_hal_set_alarm_period = 0x400002b8 );
PROVIDE( systimer_hal_get_alarm_value = 0x400002bc );
PROVIDE( systimer_hal_enable_alarm_int = 0x400002c0 );
PROVIDE( systimer_hal_on_apb_freq_update = 0x400002c4 );
PROVIDE( systimer_hal_counter_value_advance = 0x400002c8 );
PROVIDE( systimer_hal_enable_counter = 0x400002cc );
PROVIDE( systimer_hal_select_alarm_mode = 0x400002d0 );
PROVIDE( systimer_hal_connect_alarm_counter = 0x400002d4 );
PROVIDE( systimer_hal_counter_can_stall_by_cpu = 0x400002d8 );


/***************************************
 Group heap
 ***************************************/

/* Functions */
PROVIDE( tlsf_create = 0x400002dc );
PROVIDE( tlsf_create_with_pool = 0x400002e0 );
PROVIDE( tlsf_get_pool = 0x400002e4 );
PROVIDE( tlsf_add_pool = 0x400002e8 );
PROVIDE( tlsf_remove_pool = 0x400002ec );
PROVIDE( tlsf_malloc = 0x400002f0 );
PROVIDE( tlsf_memalign = 0x400002f4 );
PROVIDE( tlsf_memalign_offs = 0x400002f8 );
PROVIDE( tlsf_realloc = 0x400002fc );
PROVIDE( tlsf_free = 0x40000300 );
PROVIDE( tlsf_block_size = 0x40000304 );
PROVIDE( tlsf_size = 0x40000308 );
PROVIDE( tlsf_align_size = 0x4000030c );
PROVIDE( tlsf_block_size_min = 0x40000310 );
PROVIDE( tlsf_block_size_max = 0x40000314 );
PROVIDE( tlsf_pool_overhead = 0x40000318 );
PROVIDE( tlsf_alloc_overhead = 0x4000031c );
PROVIDE( tlsf_walk_pool = 0x40000320 );
PROVIDE( tlsf_check = 0x40000324 );
PROVIDE( tlsf_check_pool = 0x40000328 );
PROVIDE( tlsf_poison_fill_pfunc_set = 0x4000032c );
PROVIDE( multi_heap_get_block_address_impl = 0x40000330 );
PROVIDE( multi_heap_get_allocated_size_impl = 0x40000334 );
PROVIDE( multi_heap_register_impl = 0x40000338 );
PROVIDE( multi_heap_set_lock = 0x4000033c );
PROVIDE( multi_heap_mutex_init = 0x40000340 );
PROVIDE( multi_heap_internal_lock = 0x40000344 );
PROVIDE( multi_heap_internal_unlock = 0x40000348 );
PROVIDE( multi_heap_get_first_block = 0x4000034c );
PROVIDE( multi_heap_get_next_block = 0x40000350 );
PROVIDE( multi_heap_is_free = 0x40000354 );
PROVIDE( multi_heap_malloc_impl = 0x40000358 );
PROVIDE( multi_heap_free_impl = 0x4000035c );
PROVIDE( multi_heap_realloc_impl = 0x40000360 );
PROVIDE( multi_heap_aligned_alloc_impl_offs = 0x40000364 );
PROVIDE( multi_heap_aligned_alloc_impl = 0x40000368 );
PROVIDE( multi_heap_check = 0x4000036c );
PROVIDE( multi_heap_dump = 0x40000370 );
PROVIDE( multi_heap_free_size_impl = 0x40000374 );
PROVIDE( multi_heap_minimum_free_size_impl = 0x40000378 );
PROVIDE( multi_heap_get_info_impl = 0x4000037c );
/* Data (.data, .bss, .rodata) */
PROVIDE( heap_tlsf_table_ptr = 0x3fcdffec );


/***************************************
 Group spi_flash_chips
 ***************************************/

/* Functions */
PROVIDE( spi_flash_chip_generic_probe = 0x40000380 );
PROVIDE( spi_flash_chip_generic_detect_size = 0x40000384 );
PROVIDE( spi_flash_chip_generic_write = 0x40000388 );
PROVIDE( spi_flash_chip_generic_write_encrypted = 0x4000038c );
PROVIDE( spi_flash_chip_generic_set_write_protect = 0x40000390 );
PROVIDE( spi_flash_common_write_status_16b_wrsr = 0x40000394 );
PROVIDE( spi_flash_chip_generic_reset = 0x40000398 );
PROVIDE( spi_flash_chip_generic_erase_chip = 0x4000039c );
PROVIDE( spi_flash_chip_generic_erase_sector = 0x400003a0 );
PROVIDE( spi_flash_chip_generic_erase_block = 0x400003a4 );
PROVIDE( spi_flash_chip_generic_page_program = 0x400003a8 );
PROVIDE( spi_flash_chip_generic_get_write_protect = 0x400003ac );
PROVIDE( spi_flash_common_read_status_16b_rdsr_rdsr2 = 0x400003b0 );
PROVIDE( spi_flash_chip_generic_read_reg = 0x400003b4 );
PROVIDE( spi_flash_chip_generic_yield = 0x400003b8 );
PROVIDE( spi_flash_generic_wait_host_idle = 0x400003bc );
PROVIDE( spi_flash_chip_generic_wait_idle = 0x400003c0 );
PROVIDE( spi_flash_chip_generic_config_host_io_mode = 0x400003c4 );
PROVIDE( spi_flash_chip_generic_read = 0x400003c8 );
PROVIDE( spi_flash_common_read_status_8b_rdsr2 = 0x400003cc );
PROVIDE( spi_flash_chip_generic_get_io_mode = 0x400003d0 );
PROVIDE( spi_flash_common_read_status_8b_rdsr = 0x400003d4 );
PROVIDE( spi_flash_common_write_status_8b_wrsr = 0x400003d8 );
PROVIDE( spi_flash_common_write_status_8b_wrsr2 = 0x400003dc );
PROVIDE( spi_flash_common_set_io_mode = 0x400003e0 );
PROVIDE( spi_flash_chip_generic_set_io_mode = 0x400003e4 );
PROVIDE( spi_flash_chip_generic_read_unique_id = 0x400003e8 );
PROVIDE( spi_flash_chip_generic_get_caps = 0x400003ec );
PROVIDE( spi_flash_chip_generic_suspend_cmd_conf = 0x400003f0 );
PROVIDE( spi_flash_chip_gd_get_io_mode = 0x400003f4 );
PROVIDE( spi_flash_chip_gd_probe = 0x400003f8 );
PROVIDE( spi_flash_chip_gd_set_io_mode = 0x400003fc );
/* Data (.data, .bss, .rodata) */
PROVIDE( spi_flash_chip_generic_config_data = 0x3fcdffe8 );
PROVIDE( spi_flash_encryption = 0x3fcdffe4 );


/***************************************
 Group memspi_host
 ***************************************/

/* Functions */
PROVIDE( memspi_host_read_id_hs = 0x40000400 );
PROVIDE( memspi_host_read_status_hs = 0x40000404 );
PROVIDE( memspi_host_flush_cache = 0x40000408 );
PROVIDE( memspi_host_erase_chip = 0x4000040c );
PROVIDE( memspi_host_erase_sector = 0x40000410 );
PROVIDE( memspi_host_erase_block = 0x40000414 );
PROVIDE( memspi_host_program_page = 0x40000418 );
PROVIDE( memspi_host_read = 0x4000041c );
PROVIDE( memspi_host_set_write_protect = 0x40000420 );
PROVIDE( memspi_host_set_max_read_len = 0x40000424 );
PROVIDE( memspi_host_read_data_slicer = 0x40000428 );
PROVIDE( memspi_host_write_data_slicer = 0x4000042c );


/***************************************
 Group esp_flash
 ***************************************/

/* Functions */
PROVIDE( esp_flash_chip_driver_initialized = 0x40000430 );
PROVIDE( esp_flash_read_id = 0x40000434 );
PROVIDE( esp_flash_get_size = 0x40000438 );
PROVIDE( esp_flash_erase_chip = 0x4000043c );
PROVIDE( esp_flash_erase_region = 0x40000440 );
PROVIDE( esp_flash_get_chip_write_protect = 0x40000444 );
PROVIDE( esp_flash_set_chip_write_protect = 0x40000448 );
PROVIDE( esp_flash_get_protectable_regions = 0x4000044c );
PROVIDE( esp_flash_get_protected_region = 0x40000450 );
PROVIDE( esp_flash_set_protected_region = 0x40000454 );
PROVIDE( esp_flash_read = 0x40000458 );
PROVIDE( esp_flash_write = 0x4000045c );
PROVIDE( esp_flash_write_encrypted = 0x40000460 );
PROVIDE( esp_flash_read_encrypted = 0x40000464 );
PROVIDE( esp_flash_get_io_mode = 0x40000468 );
PROVIDE( esp_flash_set_io_mode = 0x4000046c );
PROVIDE( spi_flash_boot_attach = 0x40000470 );
PROVIDE( esp_flash_read_chip_id = 0x40000474 );
PROVIDE( detect_spi_flash_chip = 0x40000478 );
PROVIDE( esp_rom_spiflash_write_disable = 0x4000047c );
PROVIDE( esp_flash_suspend_cmd_init = 0x40000480 );
/* Data (.data, .bss, .rodata) */
PROVIDE( esp_flash_default_chip = 0x3fcdffe0 );
PROVIDE( esp_flash_api_funcs = 0x3fcdffdc );


/***************************************
 Group cache
 ***************************************/

/* Functions */
PROVIDE( Cache_Get_ICache_Line_Size = 0x400006e0 );
PROVIDE( Cache_Get_Mode = 0x400006e4 );
PROVIDE( Cache_Address_Through_IBus = 0x400006e8 );
PROVIDE( Cache_Address_Through_DBus = 0x400006ec );
PROVIDE( Cache_Set_Default_Mode = 0x400006f0 );
PROVIDE( Cache_Enable_Defalut_ICache_Mode = 0x400006f4 );
PROVIDE( ROM_Boot_Cache_Init = 0x400006f8 );
PROVIDE( MMU_Set_Page_Mode = 0x400006fc );
PROVIDE( MMU_Get_Page_Mode = 0x40000700 );
PROVIDE( Cache_Invalidate_ICache_Items = 0x40000704 );
PROVIDE( Cache_Op_Addr = 0x40000708 );
PROVIDE( Cache_Invalidate_Addr = 0x4000070c );
PROVIDE( Cache_Invalidate_ICache_All = 0x40000710 );
PROVIDE( Cache_Mask_All = 0x40000714 );
PROVIDE( Cache_UnMask_Dram0 = 0x40000718 );
PROVIDE( Cache_Disable_ICache = 0x4000071c );
PROVIDE( Cache_Enable_ICache = 0x40000720 );
PROVIDE( Cache_Suspend_ICache = 0x40000724 );
PROVIDE( Cache_Resume_ICache = 0x40000728 );
PROVIDE( Cache_Freeze_ICache_Enable = 0x4000072c );
PROVIDE( Cache_Freeze_ICache_Disable = 0x40000730 );
PROVIDE( Cache_Set_IDROM_MMU_Size = 0x40000734 );
PROVIDE( Cache_Get_IROM_MMU_End = 0x40000738 );
PROVIDE( Cache_Get_DROM_MMU_End = 0x4000073c );
PROVIDE( Cache_Owner_Init = 0x40000740 );
PROVIDE( Cache_Occupy_ICache_MEMORY = 0x40000744 );
PROVIDE( Cache_MMU_Init = 0x40000748 );
PROVIDE( Cache_Ibus_MMU_Set = 0x4000074c );
PROVIDE( Cache_Dbus_MMU_Set = 0x40000750 );
PROVIDE( Cache_Count_Flash_Pages = 0x40000754 );
PROVIDE( Cache_Travel_Tag_Memory = 0x40000758 );
PROVIDE( Cache_Get_Virtual_Addr = 0x4000075c );
PROVIDE( Cache_Get_Memory_BaseAddr = 0x40000760 );
PROVIDE( Cache_Get_Memory_Addr = 0x40000764 );
PROVIDE( Cache_Get_Memory_value = 0x40000768 );
/* Data (.data, .bss, .rodata) */
PROVIDE( rom_cache_op_cb = 0x3fcdffd0 );
PROVIDE( rom_cache_internal_table_ptr = 0x3fcdffcc );


/***************************************
 Group clock
 ***************************************/

/* Functions */
ets_get_apb_freq = 0x4000076c;
ets_get_cpu_frequency = 0x40000770;
ets_update_cpu_frequency = 0x40000774;
ets_get_printf_channel = 0x40000778;
ets_get_xtal_div = 0x4000077c;
ets_set_xtal_div = 0x40000780;
ets_get_xtal_freq = 0x40000784;


/***************************************
 Group gpio
 ***************************************/

/* Functions */
gpio_input_get = 0x40000788;
gpio_matrix_in = 0x4000078c;
gpio_matrix_out = 0x40000790;
gpio_output_disable = 0x40000794;
gpio_output_enable = 0x40000798;
gpio_output_set = 0x4000079c;
gpio_pad_hold = 0x400007a0;
gpio_pad_input_disable = 0x400007a4;
gpio_pad_input_enable = 0x400007a8;
gpio_pad_pulldown = 0x400007ac;
gpio_pad_pullup = 0x400007b0;
gpio_pad_select_gpio = 0x400007b4;
gpio_pad_set_drv = 0x400007b8;
gpio_pad_unhold = 0x400007bc;
gpio_pin_wakeup_disable = 0x400007c0;
gpio_pin_wakeup_enable = 0x400007c4;
gpio_bypass_matrix_in = 0x400007c8;


/***************************************
 Group interrupts
 ***************************************/

/* Functions */
esprv_intc_int_set_priority = 0x400007cc;
esprv_intc_int_set_threshold = 0x400007d0;
esprv_intc_int_enable = 0x400007d4;
esprv_intc_int_disable = 0x400007d8;
esprv_intc_int_set_type = 0x400007dc;
PROVIDE( intr_handler_set = 0x400007e0 );
intr_matrix_set = 0x400007e4;
ets_intr_lock = 0x400007e8;
ets_intr_unlock = 0x400007ec;
ets_isr_attach = 0x400007f0;
ets_isr_mask = 0x400007f4;
ets_isr_unmask = 0x400007f8;


/***************************************
 Group crypto
 ***************************************/

/* Functions */
crc32_le = 0x400007fc;
crc16_le = 0x40000800;
crc8_le = 0x40000804;
crc32_be = 0x40000808;
crc16_be = 0x4000080c;
crc8_be = 0x40000810;
esp_crc8 = 0x40000814;
ets_sha_enable = 0x40000818;
ets_sha_disable = 0x4000081c;
ets_sha_get_state = 0x40000820;
ets_sha_init = 0x40000824;
ets_sha_process = 0x40000828;
ets_sha_starts = 0x4000082c;
ets_sha_update = 0x40000830;
ets_sha_finish = 0x40000834;
ets_sha_clone = 0x40000838;
/* Data (.data, .bss, .rodata) */
crc32_le_table_ptr = 0x3ff4fff8;
crc16_le_table_ptr = 0x3ff4fff4;
crc8_le_table_ptr = 0x3ff4fff0;
crc32_be_table_ptr = 0x3ff4ffec;
crc16_be_table_ptr = 0x3ff4ffe8;
crc8_be_table_ptr = 0x3ff4ffe4;


/***************************************
 Group efuse
 ***************************************/

/* Functions */
ets_efuse_read = 0x4000083c;
ets_efuse_program = 0x40000840;
ets_efuse_clear_program_registers = 0x40000844;
ets_efuse_write_key = 0x40000848;
ets_efuse_get_read_register_address = 0x4000084c;
ets_efuse_get_key_purpose = 0x40000850;
ets_efuse_key_block_unused = 0x40000854;
ets_efuse_find_unused_key_block = 0x40000858;
ets_efuse_rs_calculate = 0x4000085c;
ets_efuse_count_unused_key_blocks = 0x40000860;
ets_efuse_secure_boot_enabled = 0x40000864;
ets_efuse_secure_boot_aggressive_revoke_enabled = 0x40000868;
ets_efuse_cache_encryption_enabled = 0x4000086c;
ets_efuse_download_modes_disabled = 0x40000870;
ets_efuse_find_purpose = 0x40000874;
ets_efuse_force_send_resume = 0x40000878;
ets_efuse_get_flash_delay_us = 0x4000087c;
ets_efuse_get_mac = 0x40000880;
ets_efuse_get_uart_print_control = 0x40000884;
ets_efuse_direct_boot_mode_disabled = 0x40000888;
ets_efuse_security_download_modes_enabled = 0x4000088c;
ets_efuse_set_timing = 0x40000890;
ets_efuse_jtag_disabled = 0x40000894;


/***************************************
 Group secureboot
 ***************************************/

/* Functions */
ets_ecdsa_verify = 0x40000898;
ets_secure_boot_verify_bootloader_with_keys = 0x4000089c;
ets_secure_boot_verify_signature = 0x400008a0;
ets_secure_boot_read_key_digests = 0x400008a4;


/***************************************
 Group usb_uart
 ***************************************/

/* Data (.data, .bss, .rodata) */
g_uart_print = 0x3fcdffc9;
g_usb_print = 0x3fcdffc8;


/***************************************
 Group bluetooth
 ***************************************/

/* Functions */
ble_controller_rom_data_init = 0x40000aa8;
ble_osi_coex_funcs_register = 0x40000aac;
bt_rf_coex_cfg_get_default = 0x40000ab0;
bt_rf_coex_dft_pti_get_default = 0x40000ab4;
bt_rf_coex_hooks_p_set = 0x40000ab8;
r__os_mbuf_copypkthdr = 0x40000abc;
r__os_msys_find_pool = 0x40000ac0;
r_ble_controller_get_rom_compile_version = 0x40000ac4;
r_ble_hci_ram_hs_acl_tx = 0x40000ac8;
r_ble_hci_ram_hs_cmd_tx = 0x40000acc;
r_ble_hci_ram_ll_acl_tx = 0x40000ad0;
r_ble_hci_ram_ll_evt_tx = 0x40000ad4;
r_ble_hci_ram_reset = 0x40000ad8;
r_ble_hci_ram_set_acl_free_cb = 0x40000adc;
r_ble_hci_trans_acl_buf_alloc = 0x40000ae0;
r_ble_hci_trans_buf_alloc = 0x40000ae4;
r_ble_hci_trans_buf_free = 0x40000ae8;
r_ble_hci_trans_cfg_hs = 0x40000aec;
r_ble_hci_trans_cfg_ll = 0x40000af0;
r_ble_hci_trans_deinit = 0x40000af4;
r_ble_hci_trans_env_init = 0x40000af8;
r_ble_hci_trans_init = 0x40000afc;
r_ble_hci_uart_acl_tx = 0x40000b00;
r_ble_hci_uart_cmdevt_tx = 0x40000b04;
r_ble_hci_uart_config = 0x40000b08;
r_ble_hci_uart_free_pkt = 0x40000b0c;
r_ble_hci_uart_hs_acl_tx = 0x40000b10;
r_ble_hci_uart_hs_cmd_tx = 0x40000b14;
r_ble_hci_uart_ll_acl_tx = 0x40000b18;
r_ble_hci_uart_ll_evt_tx = 0x40000b1c;
r_ble_hci_uart_rx_acl = 0x40000b20;
r_ble_hci_uart_rx_char = 0x40000b24;
r_ble_hci_uart_rx_cmd = 0x40000b28;
r_ble_hci_uart_rx_evt = 0x40000b2c;
r_ble_hci_uart_rx_evt_cb = 0x40000b30;
r_ble_hci_uart_rx_le_evt = 0x40000b34;
r_ble_hci_uart_rx_pkt_type = 0x40000b38;
r_ble_hci_uart_rx_skip_acl = 0x40000b3c;
r_ble_hci_uart_rx_skip_cmd = 0x40000b40;
r_ble_hci_uart_rx_skip_evt = 0x40000b44;
r_ble_hci_uart_rx_sync_loss = 0x40000b48;
r_ble_hci_uart_set_acl_free_cb = 0x40000b4c;
r_ble_hci_uart_sync_lost = 0x40000b50;
r_ble_hci_uart_trans_reset = 0x40000b54;
r_ble_hci_uart_tx_char = 0x40000b58;
r_ble_hci_uart_tx_pkt_type = 0x40000b5c;
r_ble_hw_driver_deinit = 0x40000b60;
r_ble_hw_driver_env_init = 0x40000b64;
r_ble_hw_encrypt_block = 0x40000b68;
r_ble_hw_get_public_addr = 0x40000b6c;
r_ble_hw_get_static_addr = 0x40000b70;
r_ble_hw_periodiclist_add = 0x40000b74;
r_ble_hw_periodiclist_clear = 0x40000b78;
r_ble_hw_periodiclist_rmv = 0x40000b7c;
r_ble_hw_resolv_list_cur_entry = 0x40000b80;
r_ble_hw_resolv_list_get_cur_entry = 0x40000b84;
r_ble_hw_resolv_list_set = 0x40000b88;
r_ble_hw_rng_init = 0x40000b8c;
r_ble_hw_rng_start = 0x40000b90;
r_ble_hw_rng_stop = 0x40000b94;
r_ble_hw_rx_local_is_resolved = 0x40000b98;
r_ble_hw_rx_local_is_rpa = 0x40000b9c;
r_ble_hw_whitelist_add = 0x40000ba0;
r_ble_hw_whitelist_clear = 0x40000ba4;
r_ble_hw_whitelist_dev_num = 0x40000ba8;
r_ble_hw_whitelist_get_base = 0x40000bac;
r_ble_hw_whitelist_rmv = 0x40000bb0;
r_ble_hw_whitelist_search = 0x40000bb4;
r_ble_hw_whitelist_sort = 0x40000bb8;
r_ble_ll_acl_data_in = 0x40000bbc;
r_ble_ll_addr_is_id = 0x40000bc0;
r_ble_ll_addr_subtype = 0x40000bc4;
r_ble_ll_adv_active_chanset_clear = 0x40000bc8;
r_ble_ll_adv_active_chanset_is_pri = 0x40000bcc;
r_ble_ll_adv_active_chanset_is_sec = 0x40000bd0;
r_ble_ll_adv_active_chanset_set_pri = 0x40000bd4;
r_ble_ll_adv_active_chanset_set_sec = 0x40000bd8;
r_ble_ll_adv_aux_calculate = 0x40000bdc;
r_ble_ll_adv_aux_conn_rsp_pdu_make = 0x40000be0;
r_ble_ll_adv_aux_pdu_make = 0x40000be4;
r_ble_ll_adv_aux_scannable_pdu_make = 0x40000be8;
r_ble_ll_adv_aux_txed = 0x40000bec;
r_ble_ll_adv_can_chg_whitelist = 0x40000bf0;
r_ble_ll_adv_chk_rpa_timeout = 0x40000bf4;
r_ble_ll_adv_clear_all = 0x40000bf8;
r_ble_ll_adv_conn_req_rxd = 0x40000bfc;
r_ble_ll_adv_deinit = 0x40000c00;
r_ble_ll_adv_enabled = 0x40000c04;
r_ble_ll_adv_env_init = 0x40000c08;
r_ble_ll_adv_ext_set_adv_data = 0x40000c0c;
r_ble_ll_adv_ext_set_enable = 0x40000c10;
r_ble_ll_adv_ext_set_param = 0x40000c14;
r_ble_ll_adv_ext_set_scan_rsp = 0x40000c18;
r_ble_ll_adv_final_chan = 0x40000c1c;
r_ble_ll_adv_first_chan = 0x40000c20;
r_ble_ll_adv_flags_clear = 0x40000c24;
r_ble_ll_adv_flags_set = 0x40000c28;
r_ble_ll_adv_get_chan_num = 0x40000c2c;
r_ble_ll_adv_get_local_rpa = 0x40000c30;
r_ble_ll_adv_get_peer_rpa = 0x40000c34;
r_ble_ll_adv_hci_set_random_addr = 0x40000c38;
r_ble_ll_adv_init = 0x40000c3c;
r_ble_ll_adv_legacy_pdu_make = 0x40000c40;
r_ble_ll_adv_next_chan = 0x40000c44;
r_ble_ll_adv_pdu_make = 0x40000c48;
r_ble_ll_adv_periodic_check_data_itvl = 0x40000c4c;
r_ble_ll_adv_periodic_enable = 0x40000c50;
r_ble_ll_adv_periodic_estimate_data_itvl = 0x40000c54;
r_ble_ll_adv_periodic_send_sync_ind = 0x40000c58;
r_ble_ll_adv_periodic_set_data = 0x40000c5c;
r_ble_ll_adv_periodic_set_info_transfer = 0x40000c60;
r_ble_ll_adv_periodic_set_param = 0x40000c64;
r_ble_ll_adv_pre_process = 0x40000c68;
r_ble_ll_adv_put_acad_chM_update_ind = 0x40000c6c;
r_ble_ll_adv_put_aux_ptr = 0x40000c70;
r_ble_ll_adv_put_syncinfo = 0x40000c74;
r_ble_ll_adv_rd_max_adv_data_len = 0x40000c78;
r_ble_ll_adv_rd_sup_adv_sets = 0x40000c7c;
r_ble_ll_adv_read_txpwr = 0x40000c80;
r_ble_ll_adv_remove = 0x40000c84;
r_ble_ll_adv_reset = 0x40000c88;
r_ble_ll_adv_rpa_timeout = 0x40000c8c;
r_ble_ll_adv_rpa_update = 0x40000c90;
r_ble_ll_adv_rx_pkt_in = 0x40000c94;
r_ble_ll_adv_scan_req_rxd = 0x40000c98;
r_ble_ll_adv_scan_rsp_legacy_pdu_make = 0x40000c9c;
r_ble_ll_adv_scan_rsp_pdu_make = 0x40000ca0;
r_ble_ll_adv_scheduled = 0x40000ca4;
r_ble_ll_adv_send_conn_comp_ev = 0x40000ca8;
r_ble_ll_adv_set_adv_data = 0x40000cac;
r_ble_ll_adv_set_adv_params = 0x40000cb0;
r_ble_ll_adv_set_enable = 0x40000cb4;
r_ble_ll_adv_set_random_addr = 0x40000cb8;
r_ble_ll_adv_set_scan_rsp_data = 0x40000cbc;
r_ble_ll_adv_set_sched = 0x40000cc0;
r_ble_ll_adv_sm_deinit = 0x40000cc4;
r_ble_ll_adv_sm_event_init = 0x40000cc8;
r_ble_ll_adv_sm_find_configured = 0x40000ccc;
r_ble_ll_adv_sm_get = 0x40000cd0;
r_ble_ll_adv_sm_init = 0x40000cd4;
r_ble_ll_adv_sm_reset = 0x40000cd8;
r_ble_ll_adv_sm_start = 0x40000cdc;
r_ble_ll_adv_sm_start_periodic = 0x40000ce0;
r_ble_ll_adv_sm_stop = 0x40000ce4;
r_ble_ll_adv_sm_stop_limit_reached = 0x40000ce8;
r_ble_ll_adv_sm_stop_periodic = 0x40000cec;
r_ble_ll_adv_sm_stop_timeout = 0x40000cf0;
r_ble_ll_adv_sync_calculate = 0x40000cf4;
r_ble_ll_adv_sync_get_pdu_len = 0x40000cf8;
r_ble_ll_adv_sync_pdu_make = 0x40000cfc;
r_ble_ll_adv_update_adv_scan_rsp_data = 0x40000d00;
r_ble_ll_adv_update_data_mbuf = 0x40000d04;
r_ble_ll_adv_update_did = 0x40000d08;
r_ble_ll_adv_update_periodic_data = 0x40000d0c;
r_ble_ll_arr_pool_init = 0x40000d10;
r_ble_ll_auth_pyld_tmo_event_send = 0x40000d14;
r_ble_ll_calc_offset_ticks_us_for_rampup = 0x40000d18;
r_ble_ll_calc_session_key = 0x40000d1c;
r_ble_ll_calc_ticks_per_slot = 0x40000d20;
r_ble_ll_check_scan_params = 0x40000d24;
r_ble_ll_chk_txrx_octets = 0x40000d28;
r_ble_ll_chk_txrx_time = 0x40000d2c;
r_ble_ll_conn_adjust_pyld_len = 0x40000d30;
r_ble_ll_conn_auth_pyld_timer_cb = 0x40000d34;
r_ble_ll_conn_auth_pyld_timer_start = 0x40000d38;
r_ble_ll_conn_calc_dci = 0x40000d3c;
r_ble_ll_conn_calc_dci_csa1 = 0x40000d40;
r_ble_ll_conn_calc_itvl_ticks = 0x40000d44;
r_ble_ll_conn_chk_csm_flags = 0x40000d48;
r_ble_ll_conn_chk_phy_upd_start = 0x40000d4c;
r_ble_ll_conn_comp_event_send = 0x40000d50;
r_ble_ll_conn_connect_ind_pdu_make = 0x40000d54;
r_ble_ll_conn_create = 0x40000d58;
r_ble_ll_conn_create_cancel = 0x40000d5c;
r_ble_ll_conn_created = 0x40000d60;
r_ble_ll_conn_cth_flow_enable = 0x40000d64;
r_ble_ll_conn_cth_flow_error_fn = 0x40000d68;
r_ble_ll_conn_cth_flow_have_credit = 0x40000d6c;
r_ble_ll_conn_cth_flow_is_enabled = 0x40000d70;
r_ble_ll_conn_cth_flow_process_cmd = 0x40000d74;
r_ble_ll_conn_cth_flow_set_buffers = 0x40000d78;
r_ble_ll_conn_enqueue_pkt = 0x40000d7c;
r_ble_ll_conn_env_init = 0x40000d80;
r_ble_ll_conn_ext_master_init = 0x40000d84;
r_ble_ll_conn_find_active_conn = 0x40000d88;
r_ble_ll_conn_get_active_conn = 0x40000d8c;
r_ble_ll_conn_get_anchor = 0x40000d90;
r_ble_ll_conn_hcc_params_set_fallback = 0x40000d94;
r_ble_ll_conn_hci_cancel_conn_complete_event = 0x40000d98;
r_ble_ll_conn_hci_chk_conn_params = 0x40000d9c;
r_ble_ll_conn_hci_chk_scan_params = 0x40000da0;
r_ble_ll_conn_hci_disconnect_cmd = 0x40000da4;
r_ble_ll_conn_hci_le_ltk_neg_reply = 0x40000da8;
r_ble_ll_conn_hci_le_ltk_reply = 0x40000dac;
r_ble_ll_conn_hci_le_rd_phy = 0x40000db0;
r_ble_ll_conn_hci_le_set_phy = 0x40000db4;
r_ble_ll_conn_hci_le_start_encrypt = 0x40000db8;
r_ble_ll_conn_hci_param_nrr = 0x40000dbc;
r_ble_ll_conn_hci_param_rr = 0x40000dc0;
r_ble_ll_conn_hci_rd_auth_pyld_tmo = 0x40000dc4;
r_ble_ll_conn_hci_rd_chan_map = 0x40000dc8;
r_ble_ll_conn_hci_rd_rem_ver_cmd = 0x40000dcc;
r_ble_ll_conn_hci_rd_rssi = 0x40000dd0;
r_ble_ll_conn_hci_read_rem_features = 0x40000dd4;
r_ble_ll_conn_hci_set_chan_class = 0x40000dd8;
r_ble_ll_conn_hci_set_data_len = 0x40000ddc;
r_ble_ll_conn_hci_update = 0x40000de0;
r_ble_ll_conn_hci_wr_auth_pyld_tmo = 0x40000de4;
r_ble_ll_conn_init_phy = 0x40000de8;
r_ble_ll_conn_is_dev_connected = 0x40000dec;
r_ble_ll_conn_is_empty_pdu = 0x40000df0;
r_ble_ll_conn_is_lru = 0x40000df4;
r_ble_ll_conn_master_init = 0x40000df8;
r_ble_ll_conn_module_deinit = 0x40000dfc;
r_ble_ll_conn_module_init = 0x40000e00;
r_ble_ll_conn_module_reset = 0x40000e04;
r_ble_ll_conn_next_event = 0x40000e08;
r_ble_ll_conn_num_comp_pkts_event_send = 0x40000e0c;
r_ble_ll_conn_prepare_tx_pdu = 0x40000e10;
r_ble_ll_conn_process_conn_params = 0x40000e14;
r_ble_ll_conn_req_peer_sca = 0x40000e18;
r_ble_ll_conn_rx_data_pdu = 0x40000e1c;
r_ble_ll_conn_set_csa = 0x40000e20;
r_ble_ll_conn_set_ext_con_params = 0x40000e24;
r_ble_ll_conn_set_global_chanmap = 0x40000e28;
r_ble_ll_conn_set_phy = 0x40000e2c;
r_ble_ll_conn_set_txpwr_by_handle = 0x40000e30;
r_ble_ll_conn_set_unknown_rx_octets = 0x40000e34;
r_ble_ll_conn_slave_start = 0x40000e38;
r_ble_ll_conn_sm_get = 0x40000e3c;
r_ble_ll_conn_sm_new = 0x40000e40;
r_ble_ll_conn_sm_npl_deinit = 0x40000e44;
r_ble_ll_conn_sm_npl_init = 0x40000e48;
r_ble_ll_conn_tx_pkt_in = 0x40000e4c;
r_ble_ll_conn_update_eff_data_len = 0x40000e50;
r_ble_ll_ctrl_chanmap_req_make = 0x40000e54;
r_ble_ll_ctrl_chk_proc_start = 0x40000e58;
r_ble_ll_ctrl_conn_param_pdu_make = 0x40000e5c;
r_ble_ll_ctrl_conn_param_pdu_proc = 0x40000e60;
r_ble_ll_ctrl_conn_param_reply = 0x40000e64;
r_ble_ll_ctrl_conn_upd_make = 0x40000e68;
r_ble_ll_ctrl_datalen_upd_make = 0x40000e6c;
r_ble_ll_ctrl_enc_allowed_pdu = 0x40000e70;
r_ble_ll_ctrl_enc_allowed_pdu_rx = 0x40000e74;
r_ble_ll_ctrl_enc_allowed_pdu_tx = 0x40000e78;
r_ble_ll_ctrl_enc_req_make = 0x40000e7c;
r_ble_ll_ctrl_find_new_phy = 0x40000e80;
r_ble_ll_ctrl_initiate_dle = 0x40000e84;
r_ble_ll_ctrl_len_proc = 0x40000e88;
r_ble_ll_ctrl_min_used_chan_rsp = 0x40000e8c;
r_ble_ll_ctrl_phy_from_phy_mask = 0x40000e90;
r_ble_ll_ctrl_phy_req_rsp_make = 0x40000e94;
r_ble_ll_ctrl_phy_tx_transition_get = 0x40000e98;
r_ble_ll_ctrl_phy_update_cancel = 0x40000e9c;
r_ble_ll_ctrl_phy_update_ind_make = 0x40000ea0;
r_ble_ll_ctrl_phy_update_proc_complete = 0x40000ea4;
r_ble_ll_ctrl_proc_init = 0x40000ea8;
r_ble_ll_ctrl_proc_rsp_timer_cb = 0x40000eac;
r_ble_ll_ctrl_proc_start = 0x40000eb0;
r_ble_ll_ctrl_proc_stop = 0x40000eb4;
r_ble_ll_ctrl_proc_unk_rsp = 0x40000eb8;
r_ble_ll_ctrl_proc_with_instant_initiated = 0x40000ebc;
r_ble_ll_ctrl_rej_ext_ind_make = 0x40000ec0;
r_ble_ll_ctrl_reject_ind_send = 0x40000ec4;
r_ble_ll_ctrl_rx_chanmap_req = 0x40000ec8;
r_ble_ll_ctrl_rx_conn_param_req = 0x40000ecc;
r_ble_ll_ctrl_rx_conn_param_rsp = 0x40000ed0;
r_ble_ll_ctrl_rx_conn_update = 0x40000ed4;
r_ble_ll_ctrl_rx_enc_req = 0x40000ed8;
r_ble_ll_ctrl_rx_enc_rsp = 0x40000edc;
r_ble_ll_ctrl_rx_feature_req = 0x40000ee0;
r_ble_ll_ctrl_rx_feature_rsp = 0x40000ee4;
r_ble_ll_ctrl_rx_pause_enc_req = 0x40000ee8;
r_ble_ll_ctrl_rx_pause_enc_rsp = 0x40000eec;
r_ble_ll_ctrl_rx_pdu = 0x40000ef0;
r_ble_ll_ctrl_rx_periodic_sync_ind = 0x40000ef4;
r_ble_ll_ctrl_rx_phy_req = 0x40000ef8;
r_ble_ll_ctrl_rx_phy_rsp = 0x40000efc;
r_ble_ll_ctrl_rx_phy_update_ind = 0x40000f00;
r_ble_ll_ctrl_rx_ping_rsp = 0x40000f04;
r_ble_ll_ctrl_rx_reject_ind = 0x40000f08;
r_ble_ll_ctrl_rx_sca_req = 0x40000f0c;
r_ble_ll_ctrl_rx_sca_rsp = 0x40000f10;
r_ble_ll_ctrl_rx_start_enc_req = 0x40000f14;
r_ble_ll_ctrl_rx_start_enc_rsp = 0x40000f18;
r_ble_ll_ctrl_rx_version_ind = 0x40000f1c;
r_ble_ll_ctrl_sca_req_rsp_make = 0x40000f20;
r_ble_ll_ctrl_start_enc_send = 0x40000f24;
r_ble_ll_ctrl_start_rsp_timer = 0x40000f28;
r_ble_ll_ctrl_terminate_start = 0x40000f2c;
r_ble_ll_ctrl_tx_done = 0x40000f30;
r_ble_ll_ctrl_update_features = 0x40000f34;
r_ble_ll_ctrl_version_ind_make = 0x40000f38;
r_ble_ll_data_buffer_overflow = 0x40000f3c;
r_ble_ll_deinit = 0x40000f40;
r_ble_ll_disconn_comp_event_send = 0x40000f44;
r_ble_ll_env_init = 0x40000f48;
r_ble_ll_event_comp_pkts = 0x40000f4c;
r_ble_ll_event_dbuf_overflow = 0x40000f50;
r_ble_ll_event_send = 0x40000f54;
r_ble_ll_event_tx_pkt = 0x40000f58;
r_ble_ll_ext_adv_phy_mode_to_local_phy = 0x40000f5c;
r_ble_ll_ext_conn_create = 0x40000f60;
r_ble_ll_ext_scan_parse_adv_info = 0x40000f64;
r_ble_ll_ext_scan_parse_aux_ptr = 0x40000f68;
r_ble_ll_flush_pkt_queue = 0x40000f6c;
r_ble_ll_generate_dh_key_v1 = 0x40000f70;
r_ble_ll_generate_dh_key_v2 = 0x40000f74;
r_ble_ll_generic_data_init = 0x40000f78;
r_ble_ll_get_addr_type = 0x40000f7c;
r_ble_ll_get_chan_to_scan = 0x40000f80;
r_ble_ll_get_our_devaddr = 0x40000f84;
r_ble_ll_get_tx_pwr_compensation = 0x40000f88;
r_ble_ll_hci_acl_rx = 0x40000f8c;
r_ble_ll_hci_adv_mode_ext = 0x40000f90;
r_ble_ll_hci_adv_set_enable = 0x40000f94;
r_ble_ll_hci_cb_host_buf_size = 0x40000f98;
r_ble_ll_hci_cb_set_ctrlr_to_host_fc = 0x40000f9c;
r_ble_ll_hci_cb_set_event_mask = 0x40000fa0;
r_ble_ll_hci_cb_set_event_mask2 = 0x40000fa4;
r_ble_ll_hci_chk_phy_masks = 0x40000fa8;
r_ble_ll_hci_cmd_proc = 0x40000fac;
r_ble_ll_hci_cmd_rx = 0x40000fb0;
r_ble_ll_hci_ctlr_bb_cmd_proc = 0x40000fb4;
r_ble_ll_hci_deinit = 0x40000fb8;
r_ble_ll_hci_disconnect = 0x40000fbc;
r_ble_ll_hci_env_init = 0x40000fc0;
r_ble_ll_hci_ev_conn_update = 0x40000fc4;
r_ble_ll_hci_ev_databuf_overflow = 0x40000fc8;
r_ble_ll_hci_ev_datalen_chg = 0x40000fcc;
r_ble_ll_hci_ev_encrypt_chg = 0x40000fd0;
r_ble_ll_hci_ev_hw_err = 0x40000fd4;
r_ble_ll_hci_ev_le_csa = 0x40000fd8;
r_ble_ll_hci_ev_ltk_req = 0x40000fdc;
r_ble_ll_hci_ev_phy_update = 0x40000fe0;
r_ble_ll_hci_ev_rd_rem_used_feat = 0x40000fe4;
r_ble_ll_hci_ev_rd_rem_ver = 0x40000fe8;
r_ble_ll_hci_ev_rem_conn_parm_req = 0x40000fec;
r_ble_ll_hci_ev_sca_update = 0x40000ff0;
r_ble_ll_hci_ev_send_adv_set_terminated = 0x40000ff4;
r_ble_ll_hci_ev_send_scan_req_recv = 0x40000ff8;
r_ble_ll_hci_ev_send_scan_timeout = 0x40000ffc;
r_ble_ll_hci_ev_send_vendor_err = 0x40001000;
r_ble_ll_hci_event_send = 0x40001004;
r_ble_ll_hci_ext_scan_set_enable = 0x40001008;
r_ble_ll_hci_get_num_cmd_pkts = 0x4000100c;
r_ble_ll_hci_info_params_cmd_proc = 0x40001010;
r_ble_ll_hci_init = 0x40001014;
r_ble_ll_hci_init_support_cmd_base_on_lmp_ver = 0x40001018;
r_ble_ll_hci_is_event_enabled = 0x4000101c;
r_ble_ll_hci_is_le_event_enabled = 0x40001020;
r_ble_ll_hci_le_cmd_proc = 0x40001024;
r_ble_ll_hci_le_cmd_send_cmd_status = 0x40001028;
r_ble_ll_hci_le_encrypt = 0x4000102c;
r_ble_ll_hci_le_rand = 0x40001030;
r_ble_ll_hci_le_rd_max_data_len = 0x40001034;
r_ble_ll_hci_le_rd_sugg_data_len = 0x40001038;
r_ble_ll_hci_le_read_bufsize = 0x4000103c;
r_ble_ll_hci_le_read_local_features = 0x40001040;
r_ble_ll_hci_le_read_supp_states = 0x40001044;
r_ble_ll_hci_le_set_def_phy = 0x40001048;
r_ble_ll_hci_le_wr_sugg_data_len = 0x4000104c;
r_ble_ll_hci_link_ctrl_cmd_proc = 0x40001050;
r_ble_ll_hci_npl_init = 0x40001054;
r_ble_ll_hci_post_gen_dhkey_cmp_evt = 0x40001058;
r_ble_ll_hci_post_rd_p256_pubkey_cmp_evt = 0x4000105c;
r_ble_ll_hci_rd_bd_addr = 0x40001060;
r_ble_ll_hci_rd_local_supp_cmd = 0x40001064;
r_ble_ll_hci_rd_local_supp_feat = 0x40001068;
r_ble_ll_hci_rd_local_version = 0x4000106c;
r_ble_ll_hci_scan_set_enable = 0x40001070;
r_ble_ll_hci_send_adv_report = 0x40001074;
r_ble_ll_hci_send_dir_adv_report = 0x40001078;
r_ble_ll_hci_send_ext_adv_report = 0x4000107c;
r_ble_ll_hci_send_legacy_ext_adv_report = 0x40001080;
r_ble_ll_hci_send_noop = 0x40001084;
r_ble_ll_hci_set_adv_data = 0x40001088;
r_ble_ll_hci_set_le_event_mask = 0x4000108c;
r_ble_ll_hci_set_scan_rsp_data = 0x40001090;
r_ble_ll_hci_status_params_cmd_proc = 0x40001094;
r_ble_ll_hci_vs_cmd_proc = 0x40001098;
r_ble_ll_hci_vs_rd_static_addr = 0x4000109c;
r_ble_ll_hw_err_timer_cb = 0x400010a0;
r_ble_ll_hw_error = 0x400010a4;
r_ble_ll_init = 0x400010a8;
r_ble_ll_init_alloc_conn_comp_ev = 0x400010ac;
r_ble_ll_init_get_conn_comp_ev = 0x400010b0;
r_ble_ll_init_rx_pkt_in = 0x400010b4;
r_ble_ll_is_addr_empty = 0x400010b8;
r_ble_ll_is_controller_busy = 0x400010bc;
r_ble_ll_is_on_resolv_list = 0x400010c0;
r_ble_ll_is_our_devaddr = 0x400010c4;
r_ble_ll_is_rpa = 0x400010c8;
r_ble_ll_is_valid_adv_mode = 0x400010cc;
r_ble_ll_is_valid_own_addr_type = 0x400010d0;
r_ble_ll_is_valid_public_addr = 0x400010d4;
r_ble_ll_is_valid_random_addr = 0x400010d8;
r_ble_ll_mbuf_init = 0x400010dc;
r_ble_ll_misc_options_set = 0x400010e0;
r_ble_ll_modify_sca = 0x400010e4;
r_ble_ll_modify_sca_action = 0x400010e8;
r_ble_ll_pdu_max_tx_octets_get = 0x400010ec;
r_ble_ll_pdu_tx_time_get = 0x400010f0;
r_ble_ll_phy_to_phy_mode = 0x400010f4;
r_ble_ll_qa_enable = 0x400010f8;
r_ble_ll_rand = 0x400010fc;
r_ble_ll_rand_data_get = 0x40001100;
r_ble_ll_rand_deinit = 0x40001104;
r_ble_ll_rand_env_init = 0x40001108;
r_ble_ll_rand_init = 0x4000110c;
r_ble_ll_rand_prand_get = 0x40001110;
r_ble_ll_rand_sample = 0x40001114;
r_ble_ll_rand_start = 0x40001118;
r_ble_ll_read_local_p256_pub_key = 0x4000111c;
r_ble_ll_read_rf_path_compensation = 0x40001120;
r_ble_ll_read_supp_features = 0x40001124;
r_ble_ll_read_supp_states = 0x40001128;
r_ble_ll_read_tx_power = 0x4000112c;
r_ble_ll_reset = 0x40001130;
r_ble_ll_resolv_clear_all_pl_bit = 0x40001134;
r_ble_ll_resolv_clear_all_wl_bit = 0x40001138;
r_ble_ll_resolv_deinit = 0x4000113c;
r_ble_ll_resolv_enable_cmd = 0x40001140;
r_ble_ll_resolv_enabled = 0x40001144;
r_ble_ll_resolv_env_init = 0x40001148;
r_ble_ll_resolv_gen_priv_addr = 0x4000114c;
r_ble_ll_resolv_gen_rpa = 0x40001150;
r_ble_ll_resolv_get_addr_pointer = 0x40001154;
r_ble_ll_resolv_get_index = 0x40001158;
r_ble_ll_resolv_get_irk_pointer = 0x4000115c;
r_ble_ll_resolv_get_list = 0x40001160;
r_ble_ll_resolv_get_priv_addr = 0x40001164;
r_ble_ll_resolv_get_rpa_tmo = 0x40001168;
r_ble_ll_resolv_init = 0x4000116c;
r_ble_ll_resolv_irk_nonzero = 0x40001170;
r_ble_ll_resolv_list_add = 0x40001174;
r_ble_ll_resolv_list_chg_allowed = 0x40001178;
r_ble_ll_resolv_list_clr = 0x4000117c;
r_ble_ll_resolv_list_find = 0x40001180;
r_ble_ll_resolv_list_read_size = 0x40001184;
r_ble_ll_resolv_list_reset = 0x40001188;
r_ble_ll_resolv_list_rmv = 0x4000118c;
r_ble_ll_resolv_local_addr_rd = 0x40001190;
r_ble_ll_resolv_peer_addr_rd = 0x40001194;
r_ble_ll_resolv_peer_rpa_any = 0x40001198;
r_ble_ll_resolv_reset = 0x4000119c;
r_ble_ll_resolv_rpa = 0x400011a0;
r_ble_ll_resolv_rpa_timer_cb = 0x400011a4;
r_ble_ll_resolv_set_local_rpa = 0x400011a8;
r_ble_ll_resolv_set_peer_rpa = 0x400011ac;
r_ble_ll_resolv_set_rpa_tmo = 0x400011b0;
r_ble_ll_resolve_set_priv_mode = 0x400011b4;
r_ble_ll_rxpdu_alloc = 0x400011b8;
r_ble_ll_scan_add_scan_rsp_adv = 0x400011bc;
r_ble_ll_scan_adv_decode_addr = 0x400011c0;
r_ble_ll_scan_aux_data_ref = 0x400011c4;
r_ble_ll_scan_aux_data_unref = 0x400011c8;
r_ble_ll_scan_can_chg_whitelist = 0x400011cc;
r_ble_ll_scan_check_periodic_sync = 0x400011d0;
r_ble_ll_scan_classify_filter_aux_init = 0x400011d4;
r_ble_ll_scan_classify_filter_init = 0x400011d8;
r_ble_ll_scan_common_init = 0x400011dc;
r_ble_ll_scan_continue_en = 0x400011e0;
r_ble_ll_scan_deinit = 0x400011e4;
r_ble_ll_scan_dup_check_ext = 0x400011e8;
r_ble_ll_scan_dup_check_legacy = 0x400011ec;
r_ble_ll_scan_dup_move_to_head = 0x400011f0;
r_ble_ll_scan_dup_new = 0x400011f4;
r_ble_ll_scan_dup_update_ext = 0x400011f8;
r_ble_ll_scan_dup_update_legacy = 0x400011fc;
r_ble_ll_scan_enabled = 0x40001200;
r_ble_ll_scan_end_adv_evt = 0x40001204;
r_ble_ll_scan_env_init = 0x40001208;
r_ble_ll_scan_ext_initiator_start = 0x4000120c;
r_ble_ll_scan_get_addr_data_from_legacy = 0x40001210;
r_ble_ll_scan_get_addr_from_ext_adv = 0x40001214;
r_ble_ll_scan_get_cur_sm = 0x40001218;
r_ble_ll_scan_get_ext_adv_report = 0x4000121c;
r_ble_ll_scan_get_local_rpa = 0x40001220;
r_ble_ll_scan_get_next_adv_prim_chan = 0x40001224;
r_ble_ll_scan_get_peer_rpa = 0x40001228;
r_ble_ll_scan_have_rxd_scan_rsp = 0x4000122c;
r_ble_ll_scan_init = 0x40001230;
r_ble_ll_scan_initiator_start = 0x40001234;
r_ble_ll_scan_is_inside_window = 0x40001238;
r_ble_ll_scan_move_window_to = 0x4000123c;
r_ble_ll_scan_npl_reset = 0x40001240;
r_ble_ll_scan_parse_auxptr = 0x40001244;
r_ble_ll_scan_parse_ext_hdr = 0x40001248;
r_ble_ll_scan_pre_process = 0x4000124c;
r_ble_ll_scan_record_new_adv = 0x40001250;
r_ble_ll_scan_refresh_nrpa = 0x40001254;
r_ble_ll_scan_reset = 0x40001258;
r_ble_ll_scan_rx_pkt_in = 0x4000125c;
r_ble_ll_scan_rx_pkt_in_on_aux = 0x40001260;
r_ble_ll_scan_rx_pkt_in_on_legacy = 0x40001264;
r_ble_ll_scan_rx_pkt_in_restore_addr_data = 0x40001268;
r_ble_ll_scan_rxed = 0x4000126c;
r_ble_ll_scan_send_adv_report = 0x40001270;
r_ble_ll_scan_send_truncated = 0x40001274;
r_ble_ll_scan_set_enable = 0x40001278;
r_ble_ll_scan_set_peer_rpa = 0x4000127c;
r_ble_ll_scan_set_perfer_addr = 0x40001280;
r_ble_ll_scan_set_scan_params = 0x40001284;
r_ble_ll_scan_sm_start = 0x40001288;
r_ble_ll_scan_sm_stop = 0x4000128c;
r_ble_ll_scan_time_hci_to_ticks = 0x40001290;
r_ble_ll_scan_update_aux_data = 0x40001294;
r_ble_ll_scan_whitelist_enabled = 0x40001298;
r_ble_ll_set_default_privacy_mode = 0x4000129c;
r_ble_ll_set_default_sync_transfer_params = 0x400012a0;
r_ble_ll_set_ext_scan_params = 0x400012a4;
r_ble_ll_set_host_feat = 0x400012a8;
r_ble_ll_set_public_addr = 0x400012ac;
r_ble_ll_set_random_addr = 0x400012b0;
r_ble_ll_set_sync_transfer_params = 0x400012b4;
r_ble_ll_state_get = 0x400012b8;
r_ble_ll_state_set = 0x400012bc;
r_ble_ll_sync_adjust_ext_hdr = 0x400012c0;
r_ble_ll_sync_cancel = 0x400012c4;
r_ble_ll_sync_cancel_complete_event = 0x400012c8;
r_ble_ll_sync_check_acad = 0x400012cc;
r_ble_ll_sync_check_failed = 0x400012d0;
r_ble_ll_sync_create = 0x400012d4;
r_ble_ll_sync_deinit = 0x400012d8;
r_ble_ll_sync_enabled = 0x400012dc;
r_ble_ll_sync_env_init = 0x400012e0;
r_ble_ll_sync_est_event_failed = 0x400012e4;
r_ble_ll_sync_est_event_success = 0x400012e8;
r_ble_ll_sync_established = 0x400012ec;
r_ble_ll_sync_filter_enabled = 0x400012f0;
r_ble_ll_sync_find = 0x400012f4;
r_ble_ll_sync_get_cur_sm = 0x400012f8;
r_ble_ll_sync_get_handle = 0x400012fc;
r_ble_ll_sync_get_sm = 0x40001300;
r_ble_ll_sync_info_event = 0x40001304;
r_ble_ll_sync_init = 0x40001308;
r_ble_ll_sync_list_add = 0x4000130c;
r_ble_ll_sync_list_clear = 0x40001310;
r_ble_ll_sync_list_empty = 0x40001314;
r_ble_ll_sync_list_get_free = 0x40001318;
r_ble_ll_sync_list_remove = 0x4000131c;
r_ble_ll_sync_list_search = 0x40001320;
r_ble_ll_sync_list_size = 0x40001324;
r_ble_ll_sync_lost_event = 0x40001328;
r_ble_ll_sync_next_event = 0x4000132c;
r_ble_ll_sync_on_list = 0x40001330;
r_ble_ll_sync_parse_ext_hdr = 0x40001334;
r_ble_ll_sync_periodic_ind = 0x40001338;
r_ble_ll_sync_phy_mode_to_aux_phy = 0x4000133c;
r_ble_ll_sync_phy_mode_to_hci = 0x40001340;
r_ble_ll_sync_put_syncinfo = 0x40001344;
r_ble_ll_sync_receive_enable = 0x40001348;
r_ble_ll_sync_reserve = 0x4000134c;
r_ble_ll_sync_reset = 0x40001350;
r_ble_ll_sync_reset_sm = 0x40001354;
r_ble_ll_sync_rx_pkt_in = 0x40001358;
r_ble_ll_sync_send_per_adv_rpt = 0x4000135c;
r_ble_ll_sync_send_sync_ind = 0x40001360;
r_ble_ll_sync_send_truncated_per_adv_rpt = 0x40001364;
r_ble_ll_sync_sm_clear = 0x40001368;
r_ble_ll_sync_terminate = 0x4000136c;
r_ble_ll_sync_transfer = 0x40001370;
r_ble_ll_sync_transfer_get = 0x40001374;
r_ble_ll_sync_transfer_received = 0x40001378;
r_ble_ll_task = 0x4000137c;
r_ble_ll_trace_set_func = 0x40001380;
r_ble_ll_trace_u32 = 0x40001384;
r_ble_ll_trace_u32x2 = 0x40001388;
r_ble_ll_trace_u32x3 = 0x4000138c;
r_ble_ll_tx_flat_mbuf_pducb = 0x40001390;
r_ble_ll_tx_mbuf_pducb = 0x40001394;
r_ble_ll_tx_pkt_in = 0x40001398;
r_ble_ll_update_max_tx_octets_phy_mode = 0x4000139c;
r_ble_ll_usecs_to_ticks_round_up = 0x400013a0;
r_ble_ll_utils_calc_access_addr = 0x400013a4;
r_ble_ll_utils_calc_dci_csa2 = 0x400013a8;
r_ble_ll_utils_calc_num_used_chans = 0x400013ac;
r_ble_ll_utils_calc_window_widening = 0x400013b0;
r_ble_ll_utils_csa2_perm = 0x400013b4;
r_ble_ll_utils_csa2_prng = 0x400013b8;
r_ble_ll_utils_remapped_channel = 0x400013bc;
r_ble_ll_whitelist_add = 0x400013c0;
r_ble_ll_whitelist_chg_allowed = 0x400013c4;
r_ble_ll_whitelist_clear = 0x400013c8;
r_ble_ll_whitelist_read_size = 0x400013cc;
r_ble_ll_whitelist_rmv = 0x400013d0;
r_ble_ll_whitelist_search = 0x400013d4;
r_ble_ll_write_rf_path_compensation = 0x400013d8;
r_ble_lll_adv_aux_scannable_pdu_payload_len = 0x400013dc;
r_ble_lll_adv_aux_schedule = 0x400013e0;
r_ble_lll_adv_aux_schedule_first = 0x400013e4;
r_ble_lll_adv_aux_schedule_next = 0x400013e8;
r_ble_lll_adv_aux_scheduled = 0x400013ec;
r_ble_lll_adv_aux_set_start_time = 0x400013f0;
r_ble_lll_adv_coex_dpc_calc_pti_update_itvl = 0x400013f4;
r_ble_lll_adv_coex_dpc_process_pri = 0x400013f8;
r_ble_lll_adv_coex_dpc_process_sec = 0x400013fc;
r_ble_lll_adv_coex_dpc_pti_get = 0x40001400;
r_ble_lll_adv_coex_dpc_update = 0x40001404;
r_ble_lll_adv_coex_dpc_update_on_adv_start = 0x40001408;
r_ble_lll_adv_coex_dpc_update_on_aux_scheduled = 0x4000140c;
r_ble_lll_adv_coex_dpc_update_on_data_updated = 0x40001410;
r_ble_lll_adv_coex_dpc_update_on_event_end = 0x40001414;
r_ble_lll_adv_coex_dpc_update_on_event_scheduled = 0x40001418;
r_ble_lll_adv_done = 0x4000141c;
r_ble_lll_adv_drop_event = 0x40001420;
r_ble_lll_adv_event_done = 0x40001424;
r_ble_lll_adv_event_rmvd_from_sched = 0x40001428;
r_ble_lll_adv_ext_estimate_data_itvl = 0x4000142c;
r_ble_lll_adv_get_sec_pdu_len = 0x40001430;
r_ble_lll_adv_halt = 0x40001434;
r_ble_lll_adv_make_done = 0x40001438;
r_ble_lll_adv_periodic_done = 0x4000143c;
r_ble_lll_adv_periodic_event_done = 0x40001440;
r_ble_lll_adv_periodic_rmvd_from_sched = 0x40001444;
r_ble_lll_adv_periodic_schedule_first = 0x40001448;
r_ble_lll_adv_periodic_schedule_next = 0x4000144c;
r_ble_lll_adv_periodic_start = 0x40001450;
r_ble_lll_adv_periodic_stop = 0x40001454;
r_ble_lll_adv_pri_schedule_tx_pdu = 0x40001458;
r_ble_lll_adv_reschedule_event = 0x4000145c;
r_ble_lll_adv_reschedule_periodic_event = 0x40001460;
r_ble_lll_adv_rx_pkt_isr = 0x40001464;
r_ble_lll_adv_sec_done = 0x40001468;
r_ble_lll_adv_sec_event_done = 0x4000146c;
r_ble_lll_adv_sec_schedule_next_aux = 0x40001470;
r_ble_lll_adv_secondary_tx_start_cb = 0x40001474;
r_ble_lll_adv_sm_deinit = 0x40001478;
r_ble_lll_adv_sm_event_init = 0x4000147c;
r_ble_lll_adv_sm_event_restore = 0x40001480;
r_ble_lll_adv_sm_event_store = 0x40001484;
r_ble_lll_adv_sm_init = 0x40001488;
r_ble_lll_adv_sm_reset = 0x4000148c;
r_ble_lll_adv_start = 0x40001490;
r_ble_lll_adv_stop = 0x40001494;
r_ble_lll_adv_sync_next_scheduled = 0x40001498;
r_ble_lll_adv_sync_schedule = 0x4000149c;
r_ble_lll_adv_sync_tx_done = 0x400014a0;
r_ble_lll_adv_sync_tx_end = 0x400014a4;
r_ble_lll_adv_sync_tx_start_cb = 0x400014a8;
r_ble_lll_adv_tx_done = 0x400014ac;
r_ble_lll_adv_tx_start_cb = 0x400014b0;
r_ble_lll_adv_update_rsp_offset = 0x400014b4;
r_ble_lll_aux_scan_cb = 0x400014b8;
r_ble_lll_aux_scan_drop = 0x400014bc;
r_ble_lll_aux_scan_drop_event_cb = 0x400014c0;
r_ble_lll_calc_us_convert_tick_unit = 0x400014c4;
r_ble_lll_conn_append_tx_buffer = 0x400014c8;
r_ble_lll_conn_can_send_next_pdu = 0x400014cc;
r_ble_lll_conn_check_opcode_matched = 0x400014d0;
r_ble_lll_conn_coex_dpc_process = 0x400014d4;
r_ble_lll_conn_coex_dpc_pti_get = 0x400014d8;
r_ble_lll_conn_coex_dpc_update = 0x400014dc;
r_ble_lll_conn_coex_dpc_update_on_event_end = 0x400014e0;
r_ble_lll_conn_coex_dpc_update_on_event_scheduled = 0x400014e4;
r_ble_lll_conn_coex_dpc_update_on_event_started = 0x400014e8;
r_ble_lll_conn_cth_flow_alloc_credit = 0x400014ec;
r_ble_lll_conn_cth_flow_free_credit = 0x400014f0;
r_ble_lll_conn_current_sm_over = 0x400014f4;
r_ble_lll_conn_end = 0x400014f8;
r_ble_lll_conn_env_deinit = 0x400014fc;
r_ble_lll_conn_env_init = 0x40001500;
r_ble_lll_conn_event_end = 0x40001504;
r_ble_lll_conn_event_end_timer_cb = 0x40001508;
r_ble_lll_conn_event_halt = 0x4000150c;
r_ble_lll_conn_event_is_over = 0x40001510;
r_ble_lll_conn_event_start_cb = 0x40001514;
r_ble_lll_conn_free_rx_mbuf = 0x40001518;
r_ble_lll_conn_get_addr_info_from_rx_buf = 0x4000151c;
r_ble_lll_conn_get_ce_end_time = 0x40001520;
r_ble_lll_conn_get_next_sched_time = 0x40001524;
r_ble_lll_conn_get_rx_mbuf = 0x40001528;
r_ble_lll_conn_halt = 0x4000152c;
r_ble_lll_conn_master_common_init = 0x40001530;
r_ble_lll_conn_master_new = 0x40001534;
r_ble_lll_conn_module_deinit = 0x40001538;
r_ble_lll_conn_module_init = 0x4000153c;
r_ble_lll_conn_module_reset = 0x40001540;
r_ble_lll_conn_no_mem_evt_pre_cb = 0x40001544;
r_ble_lll_conn_pre_process = 0x40001548;
r_ble_lll_conn_process_acked_pdu = 0x4000154c;
r_ble_lll_conn_process_in_isr = 0x40001550;
r_ble_lll_conn_recv_ack = 0x40001554;
r_ble_lll_conn_recv_valid_packet = 0x40001558;
r_ble_lll_conn_reset_pending_sched = 0x4000155c;
r_ble_lll_conn_rx_pkt_isr = 0x40001560;
r_ble_lll_conn_sched_next_anchor = 0x40001564;
r_ble_lll_conn_sched_next_event = 0x40001568;
r_ble_lll_conn_set_slave_flow_control = 0x4000156c;
r_ble_lll_conn_slave_new = 0x40001570;
r_ble_lll_conn_sm_new = 0x40001574;
r_ble_lll_conn_sm_npl_deinit = 0x40001578;
r_ble_lll_conn_sm_npl_init = 0x4000157c;
r_ble_lll_conn_superversion_timer_cb = 0x40001580;
r_ble_lll_conn_timeout = 0x40001584;
r_ble_lll_conn_update_anchor = 0x40001588;
r_ble_lll_conn_update_conn_ind_params = 0x4000158c;
r_ble_lll_conn_update_encryption = 0x40001590;
r_ble_lll_conn_update_tx_buffer = 0x40001594;
r_ble_lll_deinit = 0x40001598;
r_ble_lll_dtm_calculate_itvl = 0x4000159c;
r_ble_lll_dtm_ctx_free = 0x400015a0;
r_ble_lll_dtm_deinit = 0x400015a4;
r_ble_lll_dtm_end_test = 0x400015a8;
r_ble_lll_dtm_ev_rx_restart_cb = 0x400015ac;
r_ble_lll_dtm_ev_tx_resched_cb = 0x400015b0;
r_ble_lll_dtm_init = 0x400015b4;
r_ble_lll_dtm_reset = 0x400015b8;
r_ble_lll_dtm_rx_create_ctx = 0x400015bc;
r_ble_lll_dtm_rx_isr_end = 0x400015c0;
r_ble_lll_dtm_rx_isr_start = 0x400015c4;
r_ble_lll_dtm_rx_pkt_in = 0x400015c8;
r_ble_lll_dtm_rx_sched_cb = 0x400015cc;
r_ble_lll_dtm_rx_start = 0x400015d0;
r_ble_lll_dtm_rx_test = 0x400015d4;
r_ble_lll_dtm_set_next = 0x400015d8;
r_ble_lll_dtm_tx_create_ctx = 0x400015dc;
r_ble_lll_dtm_tx_done = 0x400015e0;
r_ble_lll_dtm_tx_sched_cb = 0x400015e4;
r_ble_lll_dtm_tx_test = 0x400015e8;
r_ble_lll_dtm_wfr_timer_exp = 0x400015ec;
r_ble_lll_event_rx_pkt = 0x400015f0;
r_ble_lll_ext_scan_coex_dpc_process = 0x400015f4;
r_ble_lll_ext_scan_coex_dpc_pti_get = 0x400015f8;
r_ble_lll_ext_scan_coex_dpc_update = 0x400015fc;
r_ble_lll_ext_scan_coex_dpc_update_on_start = 0x40001600;
r_ble_lll_hci_dtm_rx_test = 0x40001604;
r_ble_lll_hci_dtm_rx_test_v2 = 0x40001608;
r_ble_lll_hci_dtm_tx_test = 0x4000160c;
r_ble_lll_hci_dtm_tx_test_ext = 0x40001610;
r_ble_lll_hci_dtm_tx_test_v2 = 0x40001614;
r_ble_lll_hci_dtm_tx_test_v2_ext = 0x40001618;
r_ble_lll_init = 0x4000161c;
r_ble_lll_init_pre_process = 0x40001620;
r_ble_lll_init_rx_pkt_isr = 0x40001624;
r_ble_lll_per_adv_coex_dpc_calc_pti_update_itvl = 0x40001628;
r_ble_lll_per_adv_coex_dpc_process = 0x4000162c;
r_ble_lll_per_adv_coex_dpc_pti_get = 0x40001630;
r_ble_lll_per_adv_coex_dpc_update = 0x40001634;
r_ble_lll_per_adv_coex_dpc_update_on_data_updated = 0x40001638;
r_ble_lll_per_adv_coex_dpc_update_on_scheduled = 0x4000163c;
r_ble_lll_per_adv_coex_dpc_update_on_start = 0x40001640;
r_ble_lll_reset = 0x40001644;
r_ble_lll_rfmgmt_controller_sleep_en = 0x40001648;
r_ble_lll_rfmgmt_deinit = 0x4000164c;
r_ble_lll_rfmgmt_disable = 0x40001650;
r_ble_lll_rfmgmt_enable = 0x40001654;
r_ble_lll_rfmgmt_enable_now = 0x40001658;
r_ble_lll_rfmgmt_init = 0x4000165c;
r_ble_lll_rfmgmt_is_enabled = 0x40001660;
r_ble_lll_rfmgmt_release = 0x40001664;
r_ble_lll_rfmgmt_release_ev = 0x40001668;
r_ble_lll_rfmgmt_reset = 0x4000166c;
r_ble_lll_rfmgmt_scan_changed = 0x40001670;
r_ble_lll_rfmgmt_sched_changed = 0x40001674;
r_ble_lll_rfmgmt_set_sleep_cb = 0x40001678;
r_ble_lll_rfmgmt_ticks_to_enabled = 0x4000167c;
r_ble_lll_rfmgmt_timer_exp = 0x40001680;
r_ble_lll_rfmgmt_timer_reschedule = 0x40001684;
r_ble_lll_rx_pdu_in = 0x40001688;
r_ble_lll_rx_pkt_in = 0x4000168c;
r_ble_lll_rx_pkt_isr = 0x40001690;
r_ble_lll_scan_abort_aux_sched = 0x40001694;
r_ble_lll_scan_aux_data_free = 0x40001698;
r_ble_lll_scan_chk_resume = 0x4000169c;
r_ble_lll_scan_clean_cur_aux_data = 0x400016a0;
r_ble_lll_scan_coex_event_cb = 0x400016a4;
r_ble_lll_scan_common_init = 0x400016a8;
r_ble_lll_scan_deinit = 0x400016ac;
r_ble_lll_scan_duration_period_timers_restart = 0x400016b0;
r_ble_lll_scan_duration_period_timers_stop = 0x400016b4;
r_ble_lll_scan_duration_timer_cb = 0x400016b8;
r_ble_lll_scan_event_proc = 0x400016bc;
r_ble_lll_scan_ext_adv_init = 0x400016c0;
r_ble_lll_scan_halt = 0x400016c4;
r_ble_lll_scan_has_sent_scan_req = 0x400016c8;
r_ble_lll_scan_init = 0x400016cc;
r_ble_lll_scan_npl_init = 0x400016d0;
r_ble_lll_scan_npl_reset = 0x400016d4;
r_ble_lll_scan_npl_restore = 0x400016d8;
r_ble_lll_scan_npl_store = 0x400016dc;
r_ble_lll_scan_period_timer_cb = 0x400016e0;
r_ble_lll_scan_process_adv_in_isr = 0x400016e4;
r_ble_lll_scan_process_rsp_in_isr = 0x400016e8;
r_ble_lll_scan_req_backoff = 0x400016ec;
r_ble_lll_scan_restart = 0x400016f0;
r_ble_lll_scan_rx_isr_on_aux = 0x400016f4;
r_ble_lll_scan_rx_isr_on_legacy = 0x400016f8;
r_ble_lll_scan_rx_pkt_isr = 0x400016fc;
r_ble_lll_scan_sched_next_aux = 0x40001700;
r_ble_lll_scan_sched_remove = 0x40001704;
r_ble_lll_scan_start = 0x40001708;
r_ble_lll_scan_start_rx = 0x4000170c;
r_ble_lll_scan_stop = 0x40001710;
r_ble_lll_scan_targeta_is_matched = 0x40001714;
r_ble_lll_scan_timer_cb = 0x40001718;
r_ble_lll_sched_adv_new = 0x4000171c;
r_ble_lll_sched_adv_resched_pdu = 0x40001720;
r_ble_lll_sched_adv_reschedule = 0x40001724;
r_ble_lll_sched_aux_scan = 0x40001728;
r_ble_lll_sched_conn_overlap = 0x4000172c;
r_ble_lll_sched_conn_reschedule = 0x40001730;
r_ble_lll_sched_deinit = 0x40001734;
r_ble_lll_sched_dtm = 0x40001738;
r_ble_lll_sched_env_init = 0x4000173c;
r_ble_lll_sched_execute_check = 0x40001740;
r_ble_lll_sched_execute_item = 0x40001744;
r_ble_lll_sched_init = 0x40001748;
r_ble_lll_sched_insert_if_empty = 0x4000174c;
r_ble_lll_sched_is_overlap = 0x40001750;
r_ble_lll_sched_master_new = 0x40001754;
r_ble_lll_sched_next_time = 0x40001758;
r_ble_lll_sched_overlaps_current = 0x4000175c;
r_ble_lll_sched_periodic_adv = 0x40001760;
r_ble_lll_sched_rmv_elem = 0x40001764;
r_ble_lll_sched_rmv_elem_type = 0x40001768;
r_ble_lll_sched_run = 0x4000176c;
r_ble_lll_sched_scan_req_over_aux_ptr = 0x40001770;
r_ble_lll_sched_slave_new = 0x40001774;
r_ble_lll_sched_stop = 0x40001778;
r_ble_lll_sched_sync = 0x4000177c;
r_ble_lll_sched_sync_overlaps_current = 0x40001780;
r_ble_lll_sched_sync_reschedule = 0x40001784;
r_ble_lll_sync_chain_start_cb = 0x40001788;
r_ble_lll_sync_coex_dpc_process = 0x4000178c;
r_ble_lll_sync_coex_dpc_pti_get = 0x40001790;
r_ble_lll_sync_coex_dpc_update = 0x40001794;
r_ble_lll_sync_current_sm_over = 0x40001798;
r_ble_lll_sync_deinit = 0x4000179c;
r_ble_lll_sync_event_end = 0x400017a0;
r_ble_lll_sync_event_end_cb = 0x400017a4;
r_ble_lll_sync_event_start_cb = 0x400017a8;
r_ble_lll_sync_get_event_end_time = 0x400017ac;
r_ble_lll_sync_halt = 0x400017b0;
r_ble_lll_sync_init = 0x400017b4;
r_ble_lll_sync_new = 0x400017b8;
r_ble_lll_sync_reset = 0x400017bc;
r_ble_lll_sync_reset_sm = 0x400017c0;
r_ble_lll_sync_rmvd_from_sched = 0x400017c4;
r_ble_lll_sync_rx_pkt_isr = 0x400017c8;
r_ble_lll_sync_schedule_chain = 0x400017cc;
r_ble_lll_sync_stop = 0x400017d0;
r_ble_lll_sync_trnasfer_sched = 0x400017d4;
r_ble_phy_access_addr_get = 0x400017d8;
r_ble_phy_calculate_rxtx_ifs = 0x400017dc;
r_ble_phy_calculate_rxwindow = 0x400017e0;
r_ble_phy_calculate_txrx_ifs = 0x400017e4;
r_ble_phy_check_bb_status = 0x400017e8;
r_ble_phy_complete_rx_info = 0x400017ec;
r_ble_phy_config_access_addr = 0x400017f0;
r_ble_phy_data_make = 0x400017f4;
r_ble_phy_disable = 0x400017f8;
r_ble_phy_disable_irq = 0x400017fc;
r_ble_phy_disable_whitening = 0x40001800;
r_ble_phy_enable_whitening = 0x40001804;
r_ble_phy_encrypt_disable = 0x40001808;
r_ble_phy_env_init = 0x4000180c;
r_ble_phy_get_current_phy = 0x40001810;
r_ble_phy_get_packet_counter = 0x40001814;
r_ble_phy_get_packet_status = 0x40001818;
r_ble_phy_get_pyld_time_offset = 0x4000181c;
r_ble_phy_get_rx_phy_mode = 0x40001820;
r_ble_phy_get_seq_end_st = 0x40001824;
r_ble_phy_init = 0x40001828;
r_ble_phy_isr = 0x4000182c;
r_ble_phy_max_data_pdu_pyld = 0x40001830;
r_ble_phy_mode_config = 0x40001834;
r_ble_phy_mode_convert = 0x40001838;
r_ble_phy_mode_write = 0x4000183c;
r_ble_phy_module_deinit = 0x40001840;
r_ble_phy_module_init = 0x40001844;
r_ble_phy_monitor_bb_sync = 0x40001848;
r_ble_phy_reset_bb_monitor = 0x4000184c;
r_ble_phy_resolv_list_disable = 0x40001850;
r_ble_phy_resolv_list_enable = 0x40001854;
r_ble_phy_restart_sequence = 0x40001858;
r_ble_phy_rx_set_start_time_forcibly = 0x4000185c;
r_ble_phy_rxpdu_copy = 0x40001860;
r_ble_phy_seq_encrypt_enable = 0x40001864;
r_ble_phy_seq_encrypt_set_pkt_cntr = 0x40001868;
r_ble_phy_sequence_end_isr = 0x4000186c;
r_ble_phy_sequence_get_mode = 0x40001870;
r_ble_phy_sequence_is_running = 0x40001874;
r_ble_phy_sequence_is_waiting_rsp = 0x40001878;
r_ble_phy_sequence_single_end = 0x4000187c;
r_ble_phy_sequence_tx_end_invoke = 0x40001880;
r_ble_phy_sequence_update_conn_ind_params = 0x40001884;
r_ble_phy_set_adv_mode = 0x40001888;
r_ble_phy_set_coex_pti = 0x4000188c;
r_ble_phy_set_conn_ind_pdu = 0x40001890;
r_ble_phy_set_conn_mode = 0x40001894;
r_ble_phy_set_dev_address = 0x40001898;
r_ble_phy_set_rx_pwr_compensation = 0x4000189c;
r_ble_phy_set_rxhdr = 0x400018a0;
r_ble_phy_set_scan_mode = 0x400018a4;
r_ble_phy_set_sequence_mode = 0x400018a8;
r_ble_phy_set_single_packet_rx_sequence = 0x400018ac;
r_ble_phy_set_single_packet_tx_sequence = 0x400018b0;
r_ble_phy_set_tx_rx_transition = 0x400018b4;
r_ble_phy_set_txend_cb = 0x400018b8;
r_ble_phy_setchan = 0x400018bc;
r_ble_phy_start_rx_immediately = 0x400018c0;
r_ble_phy_state_get = 0x400018c4;
r_ble_phy_timer_config_start_time = 0x400018c8;
r_ble_phy_timer_start_now = 0x400018cc;
r_ble_phy_timer_stop = 0x400018d0;
r_ble_phy_tx_set_start_time = 0x400018d4;
r_ble_phy_txpower_round = 0x400018d8;
r_ble_phy_txpwr_set = 0x400018dc;
r_ble_phy_update_conn_sequence = 0x400018e0;
r_ble_phy_update_encryption = 0x400018e4;
r_ble_phy_update_ifs = 0x400018e8;
r_ble_phy_xcvr_state_get = 0x400018ec;
r_ble_plf_set_log_level = 0x400018f0;
r_ble_rtc_wake_up_cpu_init = 0x400018f4;
r_ble_rtc_wake_up_state_clr = 0x400018f8;
r_ble_vendor_hci_register = 0x400018fc;
r_bt_rf_coex_cfg_set = 0x40001900;
r_bt_rf_coex_coded_txrx_time_upper_lim = 0x40001904;
r_bt_rf_coex_dft_pti_set = 0x40001908;
r_bt_rf_coex_hook_deinit = 0x4000190c;
r_bt_rf_coex_hook_init = 0x40001910;
r_bt_rf_coex_hook_st_set = 0x40001914;
r_bt_rf_coex_hooks_p_set_default = 0x40001918;
r_btdm_disable_adv_delay = 0x4000191c;
r_btdm_switch_phy_coded = 0x40001920;
r_esp_wait_disabled = 0x40001924;
r_get_be16 = 0x40001928;
r_get_be24 = 0x4000192c;
r_get_be32 = 0x40001930;
r_get_be64 = 0x40001934;
r_get_le16 = 0x40001938;
r_get_le24 = 0x4000193c;
r_get_le32 = 0x40001940;
r_get_le64 = 0x40001944;
r_get_local_irk_offset = 0x40001948;
r_get_local_rpa_offset = 0x4000194c;
r_get_max_skip = 0x40001950;
r_get_peer_id_offset = 0x40001954;
r_get_peer_irk_offset = 0x40001958;
r_get_peer_rpa_offset = 0x4000195c;
r_hal_rtc_intr_init = 0x40001960;
r_hal_rtc_irq_handler = 0x40001964;
r_hal_timer_deinit = 0x40001968;
r_hal_timer_disable_irq = 0x4000196c;
r_hal_timer_env_init = 0x40001970;
r_hal_timer_init = 0x40001974;
r_hal_timer_process = 0x40001978;
r_hal_timer_read = 0x4000197c;
r_hal_timer_read_tick = 0x40001980;
r_hal_timer_set_cb = 0x40001984;
r_hal_timer_set_exp_tick = 0x40001988;
r_hal_timer_start = 0x4000198c;
r_hal_timer_start_at = 0x40001990;
r_hal_timer_stop = 0x40001994;
r_hal_timer_task_start = 0x40001998;
r_ll_assert = 0x4000199c;
r_mem_init_mbuf_pool = 0x400019a0;
r_mem_malloc_mbuf_pool = 0x400019a4;
r_mem_malloc_mbufpkt_pool = 0x400019a8;
r_mem_malloc_mempool = 0x400019ac;
r_mem_malloc_mempool_ext = 0x400019b0;
r_mem_malloc_mempool_gen = 0x400019b4;
r_mem_pullup_obj = 0x400019b8;
r_mem_split_frag = 0x400019bc;
r_os_cputime_get32 = 0x400019c0;
r_os_cputime_ticks_to_usecs = 0x400019c4;
r_os_cputime_timer_init = 0x400019c8;
r_os_cputime_timer_relative = 0x400019cc;
r_os_cputime_timer_start = 0x400019d0;
r_os_cputime_timer_stop = 0x400019d4;
r_os_cputime_usecs_to_ticks = 0x400019d8;
r_os_mbuf_adj = 0x400019dc;
r_os_mbuf_append = 0x400019e0;
r_os_mbuf_appendfrom = 0x400019e4;
r_os_mbuf_cmpf = 0x400019e8;
r_os_mbuf_cmpm = 0x400019ec;
r_os_mbuf_concat = 0x400019f0;
r_os_mbuf_copydata = 0x400019f4;
r_os_mbuf_copyinto = 0x400019f8;
r_os_mbuf_dup = 0x400019fc;
r_os_mbuf_extend = 0x40001a00;
r_os_mbuf_free = 0x40001a04;
r_os_mbuf_free_chain = 0x40001a08;
r_os_mbuf_get = 0x40001a0c;
r_os_mbuf_get_pkthdr = 0x40001a10;
r_os_mbuf_leadingspace = 0x40001a14;
r_os_mbuf_len = 0x40001a18;
r_os_mbuf_off = 0x40001a1c;
r_os_mbuf_pack_chains = 0x40001a20;
r_os_mbuf_pool_init = 0x40001a24;
r_os_mbuf_prepend = 0x40001a28;
r_os_mbuf_prepend_pullup = 0x40001a2c;
r_os_mbuf_pullup = 0x40001a30;
r_os_mbuf_trailingspace = 0x40001a34;
r_os_mbuf_trim_front = 0x40001a38;
r_os_mbuf_widen = 0x40001a3c;
r_os_memblock_from = 0x40001a40;
r_os_memblock_get = 0x40001a44;
r_os_memblock_put = 0x40001a48;
r_os_memblock_put_from_cb = 0x40001a4c;
r_os_mempool_clear = 0x40001a50;
r_os_mempool_ext_clear = 0x40001a54;
r_os_mempool_ext_init = 0x40001a58;
r_os_mempool_info_get_next = 0x40001a5c;
r_os_mempool_init = 0x40001a60;
r_os_mempool_init_internal = 0x40001a64;
r_os_mempool_is_sane = 0x40001a68;
r_os_mempool_module_init = 0x40001a6c;
r_os_mempool_unregister = 0x40001a70;
r_os_mqueue_get = 0x40001a74;
r_os_mqueue_init = 0x40001a78;
r_os_mqueue_put = 0x40001a7c;
r_os_msys_count = 0x40001a80;
r_os_msys_get = 0x40001a84;
r_os_msys_get_pkthdr = 0x40001a88;
r_os_msys_num_free = 0x40001a8c;
r_os_msys_register = 0x40001a90;
r_os_msys_reset = 0x40001a94;
r_pri_phy_valid = 0x40001a98;
r_put_be16 = 0x40001a9c;
r_put_be24 = 0x40001aa0;
r_put_be32 = 0x40001aa4;
r_put_be64 = 0x40001aa8;
r_put_le16 = 0x40001aac;
r_put_le24 = 0x40001ab0;
r_put_le32 = 0x40001ab4;
r_put_le64 = 0x40001ab8;
r_rtc0_timer_handler = 0x40001abc;
r_sdkconfig_get_opts = 0x40001ac0;
r_sdkconfig_set_opts = 0x40001ac4;
r_sec_phy_valid = 0x40001ac8;
r_swap_buf = 0x40001acc;
r_swap_in_place = 0x40001ad0;
/* Data (.data, .bss, .rodata) */
ble_lll_dtm_module_env_p = 0x3fcdffc4;
g_ble_lll_dtm_prbs15_data = 0x3ff4fee4;
g_ble_lll_dtm_prbs9_data = 0x3ff4fde4;
g_channel_rf_to_index = 0x3ff4fdbc;
g_ble_lll_rfmgmt_data = 0x3fcdff7c;
g_ble_sleep_enter_cb = 0x3fcdff78;
g_ble_sleep_exit_cb = 0x3fcdff74;
ble_lll_sched_env_p = 0x3fcdff70;
ble_ll_env_p = 0x3fcdff6c;
g_ble_ll_pdu_header_tx_time_ro = 0x3ff4fdb4;
ble_ll_adv_env_p = 0x3fcdff68;
ble_ll_conn_env_p = 0x3fcdff64;
ble_ll_conn_required_phy_mask = 0x3ff4fdb0;
ble_ll_valid_conn_phy_mask = 0x3ff4fdaf;
g_ble_ll_ctrl_pkt_lengths_ro = 0x3ff4fd8c;
ble_ll_hci_env_p = 0x3fcdff60;
g_debug_le_private_key = 0x3ff4fd6c;
g_ecc_key = 0x3fcdfefc;
ble_ll_rand_env_p = 0x3fcdfef8;
ble_ll_resolv_env_p = 0x3fcdfef4;
g_ble_ll_resolve_hdr = 0x3fcdfeec;
g_device_mode_default = 0x3fcdfe68;
ble_ll_scan_classify_filter_aux_check_cb = 0x3fcdfee8;
ble_ll_scan_classify_filter_check_cb = 0x3fcdfee4;
ble_ll_scan_env_p = 0x3fcdfee0;
g_ble_ll_supp_cmds_ro = 0x3ff4fd3c;
ble_ll_sync_env_p = 0x3fcdfedc;
g_ble_sca_ppm_tbl_ro = 0x3ff4fd2c;
priv_config_opts = 0x3fcdfe48;
ble_hci_uart_reset_cmd = 0x3ff4fd28;
ble_hci_trans_env_p = 0x3fcdfed8;
ble_hci_trans_mode = 0x3fcdfe44;
ble_hci_trans_funcs_ptr = 0x3fcdfed4;
r_ble_lll_stub_funcs_ptr = 0x3fcdfed0;
r_ble_stub_funcs_ptr = 0x3fcdfecc;
r_ext_funcs_p = 0x3fcdfec8;
r_npl_funcs = 0x3fcdfec4;
ble_hw_env_p = 0x3fcdfec0;
ble_phy_module_env_p = 0x3fcdfebc;
g_ble_phy_chan_freq_ro = 0x3ff4fd00;
g_ble_phy_mode_pkt_start_off_ro = 0x3ff4fcf8;
g_ble_phy_rxtx_ifs_compensation_ro = 0x3ff4fce8;
g_ble_phy_t_rxaddrdelay_ro = 0x3ff4fce4;
g_ble_phy_t_rxenddelay_ro = 0x3ff4fce0;
g_ble_phy_t_txdelay_ro = 0x3ff4fcdc;
g_ble_phy_t_txenddelay_ro = 0x3ff4fcd8;
g_ble_phy_txrx_ifs_compensation_ro = 0x3ff4fcc8;
hal_timer_env_p = 0x3fcdfeb8;
r_osi_coex_funcs_p = 0x3fcdfeb4;
bt_rf_coex_hooks = 0x3fcdfeac;
bt_rf_coex_hooks_p = 0x3fcdfea8;
coex_hook_st_group_tab = 0x3ff4fcbc;
coex_hook_st_group_to_coex_schm_st_tab = 0x3ff4fcb8;
s_ble_act_count_by_group = 0x3fcdfea4;
s_ble_coex_st_map = 0x3fcdfe90;
bt_rf_coex_cfg_cb = 0x3fcdfe74;
bt_rf_coex_cfg_p = 0x3fcdfe70;
bt_rf_coex_cfg_rom = 0x3ff4fc9c;
bt_rf_coex_pti_dft_p = 0x3fcdfe6c;
bt_rf_coex_pti_dft_rom = 0x3fcdfe04;
conn_dynamic_pti_param_rom = 0x3ff4fc84;
conn_phy_coded_max_data_time_param_rom = 0x3ff4fc80;
ext_adv_dynamic_pti_param_rom = 0x3ff4fc4c;
ext_scan_dynamic_param_rom = 0x3ff4fc14;
legacy_adv_dynamic_pti_param_rom = 0x3ff4fbf4;
per_adv_dynamic_pti_param_rom = 0x3ff4fbd8;
sync_dynamic_param_rom = 0x3ff4fbc0;
g_ble_plf_log_level = 0x3fcdfe00;
g_msys_pool_list = 0x3fcdfdf8;
g_os_mempool_list = 0x3fcdfdf0;


/***************************************
 Group rom_pp
 ***************************************/

/* Functions */
esp_pp_rom_version_get = 0x40001ad4;
RC_GetBlockAckTime = 0x40001ad8;
ebuf_list_remove = 0x40001adc;
esf_buf_alloc = 0x40001ae0;
esf_buf_alloc_dynamic = 0x40001ae4;
esf_buf_recycle = 0x40001ae8;
GetAccess = 0x40001aec;
hal_mac_is_low_rate_enabled = 0x40001af0;
hal_mac_tx_get_blockack = 0x40001af4;
hal_mac_tx_set_ppdu = 0x40001af8;
ic_get_trc = 0x40001afc;
ic_mac_deinit = 0x40001b00;
ic_mac_init = 0x40001b04;
ic_interface_enabled = 0x40001b08;
is_lmac_idle = 0x40001b0c;
lmacAdjustTimestamp = 0x40001b10;
lmacDiscardAgedMSDU = 0x40001b14;
lmacDiscardMSDU = 0x40001b18;
lmacEndFrameExchangeSequence = 0x40001b1c;
lmacIsIdle = 0x40001b20;
lmacIsLongFrame = 0x40001b24;
lmacMSDUAged = 0x40001b28;
lmacPostTxComplete = 0x40001b2c;
lmacProcessAllTxTimeout = 0x40001b30;
lmacProcessCollisions = 0x40001b34;
lmacProcessRxSucData = 0x40001b38;
lmacReachLongLimit = 0x40001b3c;
lmacReachShortLimit = 0x40001b40;
lmacRecycleMPDU = 0x40001b44;
lmacRxDone = 0x40001b48;
lmacSetTxFrame = 0x40001b4c;
lmacTxDone = 0x40001b50;
lmacTxFrame = 0x40001b54;
mac_tx_set_duration = 0x40001b58;
mac_tx_set_htsig = 0x40001b5c;
mac_tx_set_plcp0 = 0x40001b60;
mac_tx_set_plcp1 = 0x40001b64;
mac_tx_set_plcp2 = 0x40001b68;
pm_check_state = 0x40001b6c;
pm_disable_dream_timer = 0x40001b70;
pm_disable_sleep_delay_timer = 0x40001b74;
pm_dream = 0x40001b78;
pm_mac_wakeup = 0x40001b7c;
pm_mac_sleep = 0x40001b80;
pm_enable_active_timer = 0x40001b84;
pm_enable_sleep_delay_timer = 0x40001b88;
pm_local_tsf_process = 0x40001b8c;
pm_set_beacon_filter = 0x40001b90;
pm_is_in_wifi_slice_threshold = 0x40001b94;
pm_is_waked = 0x40001b98;
pm_keep_alive = 0x40001b9c;
pm_on_beacon_rx = 0x40001ba0;
pm_on_data_rx = 0x40001ba4;
pm_on_tbtt = 0x40001ba8;
pm_parse_beacon = 0x40001bac;
pm_process_tim = 0x40001bb0;
pm_rx_beacon_process = 0x40001bb4;
pm_rx_data_process = 0x40001bb8;
pm_sleep = 0x40001bbc;
pm_sleep_for = 0x40001bc0;
pm_tbtt_process = 0x40001bc4;
ppAMPDU2Normal = 0x40001bc8;
ppAssembleAMPDU = 0x40001bcc;
ppCalFrameTimes = 0x40001bd0;
ppCalSubFrameLength = 0x40001bd4;
ppCalTxAMPDULength = 0x40001bd8;
ppCheckTxAMPDUlength = 0x40001bdc;
ppDequeueRxq_Locked = 0x40001be0;
ppDequeueTxQ = 0x40001be4;
ppEmptyDelimiterLength = 0x40001be8;
ppEnqueueRxq = 0x40001bec;
ppEnqueueTxDone = 0x40001bf0;
ppGetTxQFirstAvail_Locked = 0x40001bf4;
ppGetTxframe = 0x40001bf8;
ppMapTxQueue = 0x40001bfc;
ppProcTxSecFrame = 0x40001c00;
ppProcessRxPktHdr = 0x40001c04;
ppProcessTxQ = 0x40001c08;
ppRecordBarRRC = 0x40001c0c;
lmacRequestTxopQueue = 0x40001c10;
lmacReleaseTxopQueue = 0x40001c14;
ppRecycleAmpdu = 0x40001c18;
ppRecycleRxPkt = 0x40001c1c;
ppResortTxAMPDU = 0x40001c20;
ppResumeTxAMPDU = 0x40001c24;
ppRxFragmentProc = 0x40001c28;
ppRxPkt = 0x40001c2c;
ppRxProtoProc = 0x40001c30;
ppSearchTxQueue = 0x40001c34;
ppSearchTxframe = 0x40001c38;
ppSelectNextQueue = 0x40001c3c;
ppSubFromAMPDU = 0x40001c40;
ppTask = 0x40001c44;
ppTxPkt = 0x40001c48;
ppTxProtoProc = 0x40001c4c;
ppTxqUpdateBitmap = 0x40001c50;
pp_coex_tx_request = 0x40001c54;
pp_hdrsize = 0x40001c58;
pp_post = 0x40001c5c;
pp_process_hmac_waiting_txq = 0x40001c60;
rcGetAmpduSched = 0x40001c64;
rcUpdateRxDone = 0x40001c68;
rc_get_trc = 0x40001c6c;
rc_get_trc_by_index = 0x40001c70;
rcAmpduLowerRate = 0x40001c74;
rcampduuprate = 0x40001c78;
rcClearCurAMPDUSched = 0x40001c7c;
rcClearCurSched = 0x40001c80;
rcClearCurStat = 0x40001c84;
rcGetSched = 0x40001c88;
rcLowerSched = 0x40001c8c;
rcSetTxAmpduLimit = 0x40001c90;
rcTxUpdatePer = 0x40001c94;
rcUpdateAckSnr = 0x40001c98;
rcUpdateRate = 0x40001c9c;
rcUpdateTxDone = 0x40001ca0;
rcUpdateTxDoneAmpdu2 = 0x40001ca4;
rcUpSched = 0x40001ca8;
rssi_margin = 0x40001cac;
rx11NRate2AMPDULimit = 0x40001cb0;
TRC_AMPDU_PER_DOWN_THRESHOLD = 0x40001cb4;
TRC_AMPDU_PER_UP_THRESHOLD = 0x40001cb8;
trc_calc_duration = 0x40001cbc;
trc_isTxAmpduOperational = 0x40001cc0;
trc_onAmpduOp = 0x40001cc4;
TRC_PER_IS_GOOD = 0x40001cc8;
trc_SetTxAmpduState = 0x40001ccc;
trc_tid_isTxAmpduOperational = 0x40001cd0;
trcAmpduSetState = 0x40001cd4;
wDevCheckBlockError = 0x40001cd8;
wDev_AppendRxBlocks = 0x40001cdc;
wDev_DiscardFrame = 0x40001ce0;
wDev_GetNoiseFloor = 0x40001ce4;
wDev_IndicateAmpdu = 0x40001ce8;
wDev_IndicateFrame = 0x40001cec;
wdev_mac_reg_load = 0x40001cf0;
wdev_mac_reg_store = 0x40001cf4;
wdev_mac_special_reg_load = 0x40001cf8;
wdev_mac_special_reg_store = 0x40001cfc;
wdev_mac_wakeup = 0x40001d00;
wdev_mac_sleep = 0x40001d04;
wDev_ProcessFiq = 0x40001d08;
wDev_ProcessRxSucData = 0x40001d0c;
wdevProcessRxSucDataAll = 0x40001d10;
wdev_csi_len_align = 0x40001d14;
ppDequeueTxDone_Locked = 0x40001d18;
ppProcTxDone = 0x40001d1c;
pm_tx_data_done_process = 0x40001d20;
config_is_cache_tx_buf_enabled = 0x40001d24;
ppMapWaitTxq = 0x40001d28;
ppProcessWaitingQueue = 0x40001d2c;
ppDisableQueue = 0x40001d30;
pm_allow_tx = 0x40001d34;
wdev_is_data_in_rxlist = 0x40001d38;
ppProcTxCallback = 0x40001d3c;
pm_is_open = 0x40001d40;
pm_wake_up = 0x40001d44;
pm_wake_done = 0x40001d48;
pm_disable_disconnected_sleep_delay_timer = 0x40001d4c;
pm_enable_disconnected_sleep_delay_timer = 0x40001d50;
hal_mac_get_txq_state = 0x40001d54;
hal_mac_clr_txq_state = 0x40001d58;
hal_mac_tx_set_cca = 0x40001d5c;
hal_mac_set_txq_invalid = 0x40001d60;
hal_mac_txq_disable = 0x40001d64;
hal_mac_is_txq_enabled = 0x40001d68;
hal_mac_get_txq_pmd = 0x40001d6c;
lmacDiscardFrameExchangeSequence = 0x40001d70;
lmacDisableTransmit = 0x40001d74;
lmacProcessTxTimeout = 0x40001d78;
lmacProcessTxSuccess = 0x40001d7c;
lmacProcessCollision = 0x40001d80;
lmacProcessTxRtsError = 0x40001d84;
lmacProcessCtsTimeout = 0x40001d88;
lmacProcessTxComplete = 0x40001d8c;
lmacProcessAckTimeout = 0x40001d90;
lmacProcessTxError = 0x40001d94;
lmacProcessTxseckiderr = 0x40001d98;
rcReachRetryLimit = 0x40001d9c;
lmacProcessShortRetryFail = 0x40001da0;
lmacEndRetryAMPDUFail = 0x40001da4;
ppFillAMPDUBar = 0x40001da8;
rcGetRate = 0x40001dac;
ppReSendBar = 0x40001db0;
lmacProcessLongRetryFail = 0x40001db4;
lmacRetryTxFrame = 0x40001db8;
lmacProcessCollisions_task = 0x40001dbc;
lmacProcessTxopQComplete = 0x40001dc0;
lmacInitAc = 0x40001dc4;
lmacInit = 0x40001dc8;
mac_tx_set_txop_q = 0x40001dcc;
hal_init = 0x40001dd0;
hal_mac_rx_set_policy = 0x40001dd4;
hal_mac_set_bssid = 0x40001dd8;
mac_rx_policy_init = 0x40001ddc;
mac_txrx_init = 0x40001de0;
mac_rxbuf_init = 0x40001de4;
mac_last_rxbuf_init = 0x40001de8;
hal_attenna_init = 0x40001dec;
hal_timer_update_by_rtc = 0x40001df0;
hal_coex_pti_init = 0x40001df4;
lmac_stop_hw_txq = 0x40001df8;
ppDirectRecycleAmpdu = 0x40001dfc;
esp_wifi_internal_set_rts = 0x40001e00;
esp_wifi_internal_get_rts = 0x40001e04;
ppTxFragmentProc = 0x40001e08;
esf_buf_setup = 0x40001e0c;
hal_agreement_add_rx_ba = 0x40001e10;
hal_agreement_del_rx_ba = 0x40001e14;
hal_crypto_set_key_entry = 0x40001e18;
hal_crypto_get_key_entry = 0x40001e1c;
hal_crypto_clr_key_entry = 0x40001e20;
config_get_wifi_task_stack_size = 0x40001e24;
pp_create_task = 0x40001e28;
hal_set_sta_tsf_wakeup = 0x40001e2c;
hal_set_rx_beacon_pti = 0x40001e30;
pm_start = 0x40001e34;
pm_stop = 0x40001e38;
hal_disable_sta_tbtt = 0x40001e3c;
ppCalTxopDur = 0x40001e40;
wDev_IndicateCtrlFrame = 0x40001e44;
hal_enable_sta_tbtt = 0x40001e48;
hal_set_sta_tbtt = 0x40001e4c;
pm_update_next_tbtt = 0x40001e50;
pm_set_sleep_type = 0x40001e54;
wDev_Rxbuf_Init = 0x40001e58;
wDev_Rxbuf_Deinit = 0x40001e5c;
ppCalTkipMic = 0x40001e60;
wDev_SnifferRxData = 0x40001e64;
hal_crypto_enable = 0x40001e68;
hal_crypto_disable = 0x40001e6c;
wDev_Insert_KeyEntry = 0x40001e70;
wDev_remove_KeyEntry = 0x40001e74;
rc_enable_trc = 0x40001e78;
rc_set_per_conn_fix_rate = 0x40001e7c;
wdev_csi_rx_process = 0x40001e80;
wDev_SnifferRxAmpdu = 0x40001e84;
hal_mac_tsf_reset = 0x40001e88;
dbg_lmac_statis_dump = 0x40001e8c;
dbg_lmac_rxtx_statis_dump = 0x40001e90;
dbg_lmac_hw_statis_dump = 0x40001e94;
dbg_lmac_diag_statis_dump = 0x40001e98;
dbg_lmac_ps_statis_dump = 0x40001e9c;
pp_timer_do_process = 0x40001ea0;
rcUpdateAMPDUParam = 0x40001ea4;
rcUpdatePhyMode = 0x40001ea8;
rcGetHighestRateIdx = 0x40001eac;
pm_tx_null_data_done_process = 0x40001eb0;
pm_tx_data_process = 0x40001eb4;
pm_attach = 0x40001eb8;
pm_coex_schm_process = 0x40001ebc;
ppInitTxq = 0x40001ec0;
pp_attach = 0x40001ec4;
pp_deattach = 0x40001ec8;
pm_on_probe_resp_rx = 0x40001ecc;
hal_set_sta_tsf = 0x40001ed0;
ic_update_sta_tsf = 0x40001ed4;
ic_tx_pkt = 0x40001ed8;
pm_send_probe_stop = 0x40001edc;
pm_send_probe_start = 0x40001ee0;
pm_on_coex_schm_process_restart = 0x40001ee4;
hal_mac_set_rxq_policy = 0x40001ee8;
hal_sniffer_enable = 0x40001eec;
hal_sniffer_disable = 0x40001ef0;
hal_sniffer_rx_set_promis = 0x40001ef4;
hal_sniffer_rx_clr_statistics = 0x40001ef8;
hal_sniffer_set_promis_misc_pkt = 0x40001efc;
tsf_hal_set_tsf_enable = 0x40001f00;
tsf_hal_set_tsf_disable = 0x40001f04;
tsf_hal_is_tsf_enabled = 0x40001f08;
tsf_hal_set_modem_wakeup_early_time = 0x40001f0c;
tsf_hal_get_counter_value = 0x40001f10;
tsf_hal_set_counter_value = 0x40001f14;
tsf_hal_get_time = 0x40001f18;
tsf_hal_set_time = 0x40001f1c;
tsf_hal_set_tbtt_enable = 0x40001f20;
tsf_hal_set_tbtt_disable = 0x40001f24;
tsf_hal_set_tbtt_intr_enable = 0x40001f28;
tsf_hal_set_tbtt_intr_disable = 0x40001f2c;
tsf_hal_set_tbtt_soc_wakeup_enable = 0x40001f30;
tsf_hal_set_tbtt_soc_wakeup_disable = 0x40001f34;
tsf_hal_set_tbtt_start_time = 0x40001f38;
tsf_hal_set_tbtt_early_time = 0x40001f3c;
tsf_hal_set_tbtt_interval = 0x40001f40;
tsf_hal_get_tbtt_interval = 0x40001f44;
tsf_hal_set_timer_enable = 0x40001f48;
tsf_hal_set_timer_disable = 0x40001f4c;
tsf_hal_set_timer_target = 0x40001f50;
tsf_hal_get_timer_target = 0x40001f54;
tsf_hal_set_timer_intr_enable = 0x40001f58;
tsf_hal_set_timer_intr_disable = 0x40001f5c;
tsf_hal_set_timer_soc_wakeup_enable = 0x40001f60;
tsf_hal_set_timer_soc_wakeup_disable = 0x40001f64;
pm_disconnected_wake = 0x40001f68;
pm_get_connectionless_status = 0x40001f6c;
pm_update_by_connectionless_status = 0x40001f70;
pm_connectionless_wake_interval_timeout_process = 0x40001f74;
pm_connectionless_wake_window_timeout_process = 0x40001f78;
/* Data (.data, .bss, .rodata) */
our_instances_ptr = 0x3ff4fbbc;
pTxRx = 0x3fcdfdec;
lmacConfMib_ptr = 0x3fcdfde8;
our_wait_eb = 0x3fcdfde4;
our_tx_eb = 0x3fcdfde0;
pp_wdev_funcs = 0x3fcdfddc;
g_osi_funcs_p = 0x3fcdfdd8;
wDevCtrl_ptr = 0x3fcdfdd4;
g_wdev_last_desc_reset_ptr = 0x3ff4fbb8;
wDevMacSleep_ptr = 0x3fcdfdd0;
g_lmac_cnt_ptr = 0x3fcdfdcc;
our_controls_ptr = 0x3ff4fbb4;
pp_sig_cnt_ptr = 0x3fcdfdc8;
g_eb_list_desc_ptr = 0x3fcdfdc4;
s_fragment_ptr = 0x3fcdfdc0;
if_ctrl_ptr = 0x3fcdfdbc;
g_intr_lock_mux = 0x3fcdfdb8;
g_wifi_global_lock = 0x3fcdfdb4;
s_wifi_queue = 0x3fcdfdb0;
pp_task_hdl = 0x3fcdfdac;
s_pp_task_create_sem = 0x3fcdfda8;
s_pp_task_del_sem = 0x3fcdfda4;
g_wifi_menuconfig_ptr = 0x3fcdfda0;
xphyQueue = 0x3fcdfd9c;
ap_no_lr_ptr = 0x3fcdfd98;
rc11BSchedTbl_ptr = 0x3fcdfd94;
rc11NSchedTbl_ptr = 0x3fcdfd90;
rcLoRaSchedTbl_ptr = 0x3fcdfd8c;
BasicOFDMSched_ptr = 0x3fcdfd88;
trc_ctl_ptr = 0x3fcdfd84;
g_pm_cnt_ptr = 0x3fcdfd80;
g_pm_ptr = 0x3fcdfd7c;
g_pm_cfg_ptr = 0x3fcdfd78;
g_esp_mesh_quick_funcs_ptr = 0x3fcdfd74;
g_txop_queue_status_ptr = 0x3fcdfd70;
g_mac_sleep_en_ptr = 0x3fcdfd6c;
g_mesh_is_root_ptr = 0x3fcdfd68;
g_mesh_topology_ptr = 0x3fcdfd64;
g_mesh_init_ps_type_ptr = 0x3fcdfd60;
g_mesh_is_started_ptr = 0x3fcdfd5c;
g_config_func = 0x3fcdfd58;
g_net80211_tx_func = 0x3fcdfd54;
g_timer_func = 0x3fcdfd50;
s_michael_mic_failure_cb = 0x3fcdfd4c;
wifi_sta_rx_probe_req = 0x3fcdfd48;
g_tx_done_cb_func = 0x3fcdfd44;
g_per_conn_trc = 0x3fcdfd28;
s_encap_amsdu_func = 0x3fcdfd24;
bars = 0x3fcdfc84;
eb_txdesc_space = 0x3fcdfbf4;
eb_space = 0x3fcdfb54;
g_pd_mac_in_light_sleep = 0x3fcdfb50;
s_fix_rate_mask = 0x3fcdfb4c;
s_fix_rate = 0x3fcdfb44;
g_wdev_csi_rx = 0x3fcdfb40;
g_wdev_csi_rx_ctx = 0x3fcdfb3c;
BcnSendTick = 0x3fcdfb38;
g_pp_timer_info_ptr = 0x3fcdfb34;
rcP2P11NSchedTbl_ptr = 0x3fcdfb30;
rcP2P11GSchedTbl_ptr = 0x3fcdfb2c;
rc11GSchedTbl_ptr = 0x3fcdfb28;


/***************************************
 Group rom_net80211
 ***************************************/

/* Functions */
esp_net80211_rom_version_get = 0x40001f7c;
ampdu_dispatch = 0x40001f80;
ampdu_dispatch_all = 0x40001f84;
ampdu_dispatch_as_many_as_possible = 0x40001f88;
ampdu_dispatch_movement = 0x40001f8c;
ampdu_dispatch_upto = 0x40001f90;
chm_is_at_home_channel = 0x40001f94;
cnx_node_is_existing = 0x40001f98;
cnx_node_search = 0x40001f9c;
ic_ebuf_recycle_rx = 0x40001fa0;
ic_ebuf_recycle_tx = 0x40001fa4;
ic_reset_rx_ba = 0x40001fa8;
ieee80211_align_eb = 0x40001fac;
ieee80211_ampdu_reorder = 0x40001fb0;
ieee80211_ampdu_start_age_timer = 0x40001fb4;
ieee80211_encap_esfbuf = 0x40001fb8;
ieee80211_is_tx_allowed = 0x40001fbc;
ieee80211_output_pending_eb = 0x40001fc0;
ieee80211_output_process = 0x40001fc4;
ieee80211_set_tx_desc = 0x40001fc8;
sta_input = 0x40001fcc;
wifi_get_macaddr = 0x40001fd0;
wifi_rf_phy_disable = 0x40001fd4;
wifi_rf_phy_enable = 0x40001fd8;
ic_ebuf_alloc = 0x40001fdc;
ieee80211_classify = 0x40001fe0;
ieee80211_copy_eb_header = 0x40001fe4;
ieee80211_recycle_cache_eb = 0x40001fe8;
ieee80211_search_node = 0x40001fec;
roundup2 = 0x40001ff0;
ieee80211_crypto_encap = 0x40001ff4;
ieee80211_crypto_decap = 0x40001ff8;
ieee80211_decap = 0x40001ffc;
ieee80211_set_tx_pti = 0x40002000;
wifi_is_started = 0x40002004;
ieee80211_gettid = 0x40002008;
ieee80211_ccmp_decrypt = 0x4000200c;
ieee80211_ccmp_encrypt = 0x40002010;
ccmp_encap = 0x40002014;
ccmp_decap = 0x40002018;
tkip_encap = 0x4000201c;
tkip_decap = 0x40002020;
wep_encap = 0x40002024;
wep_decap = 0x40002028;
dbg_hmac_rxtx_statis_dump = 0x4000202c;
dbg_hmac_statis_dump = 0x40002030;
ieee80211_send_action_vendor_spec = 0x40002034;
ieee80211_send_mgmt = 0x40002038;
ieee80211_auth_construct = 0x4000203c;
ieee80211_deauth_construct = 0x40002040;
ieee80211_disassoc_construct = 0x40002044;
ieee80211_vnd_lora_ie_size = 0x40002048;
ieee80211_vnd_ie_size = 0x4000204c;
ieee80211_add_ssid = 0x40002050;
ieee80211_add_rates = 0x40002054;
ieee80211_add_xrates = 0x40002058;
ieee80211_is_ht_cipher = 0x4000205c;
ieee80211_assoc_req_construct = 0x40002060;
ieee80211_assoc_resp_construct = 0x40002064;
ieee80211_setup_lr_rates = 0x40002068;
ieee80211_ht_node_init = 0x4000206c;
ieee80211_is_support_rate = 0x40002070;
ieee80211_setup_rates = 0x40002074;
ieee80211_is_lr_only = 0x40002078;
ieee80211_setup_phy_mode = 0x4000207c;
ieee80211_sta_is_connected = 0x40002080;
current_task_is_wifi_task = 0x40002084;
wifi_get_init_state = 0x40002088;
ieee80211_timer_process = 0x4000208c;
cnx_coexist_timeout = 0x40002090;
sta_recv_mgmt = 0x40002094;
ieee80211_send_setup = 0x40002098;
ieee80211_send_probereq = 0x4000209c;
sta_auth_open = 0x400020a0;
sta_auth_shared = 0x400020a4;
sta_auth_sae = 0x400020a8;
cnx_coexist_timeout_process = 0x400020ac;
ieee80211_alloc_challenge = 0x400020b0;
cnx_assoc_timeout = 0x400020b4;
ieee80211_vnd_ie_set = 0x400020b8;
ieee80211_vnd_lora_ie_set = 0x400020bc;
ieee80211_add_wme_param = 0x400020c0;
ieee80211_add_dsparams = 0x400020c4;
ieee80211_add_csa = 0x400020c8;
ieee80211_add_extcap = 0x400020cc;
ieee80211_regdomain_get_country = 0x400020d0;
ieee80211_add_countryie = 0x400020d4;
ieee80211_alloc_proberesp = 0x400020d8;
ieee80211_amsdu_adjust_head = 0x400020dc;
ieee80211_amsdu_adjust_last_length = 0x400020e0;
ieee80211_amsdu_send_check = 0x400020e4;
ieee80211_amsdu_encap_check = 0x400020e8;
ieee80211_amsdu_length_check = 0x400020ec;
ieee80211_encap_amsdu = 0x400020f0;
ieee80211_output_raw_process = 0x400020f4;
esp_wifi_80211_tx = 0x400020f8;
ieee80211_raw_frame_sanity_check = 0x400020fc;
ieee80211_crypto_aes_128_cmac_encrypt = 0x40002100;
ieee80211_crypto_aes_128_cmac_decrypt = 0x40002104;
ieee80211_alloc_tx_buf = 0x40002108;
ieee80211_output_do = 0x4000210c;
ieee80211_send_nulldata = 0x40002110;
ieee80211_setup_robust_mgmtframe = 0x40002114;
ieee80211_mgmt_output = 0x40002118;
ieee80211_encap_null_data = 0x4000211c;
ieee80211_send_deauth = 0x40002120;
ieee80211_alloc_deauth = 0x40002124;
ieee80211_send_proberesp = 0x40002128;
ieee80211_tx_mgt_cb = 0x4000212c;
ieee80211_getcapinfo = 0x40002130;
sta_rx_csa = 0x40002134;
sta_send_sa_query_req = 0x40002138;
sta_send_sa_query_resp = 0x4000213c;
sta_recv_sa_query_req = 0x40002140;
sta_recv_sa_query_resp = 0x40002144;
ieee80211_parse_beacon = 0x40002148;
ieee80211_set_max_rate = 0x4000214c;
ic_set_sta = 0x40002150;
ieee80211_match_security = 0x40002154;
ieee80211_parse_wpa = 0x40002158;
ieee80211_parse_rsn = 0x4000215c;
ieee80211_add_assoc_req_ies = 0x40002160;
ieee80211_add_probe_req_ies = 0x40002164;
/* Data (.data, .bss, .rodata) */
net80211_funcs = 0x3fcdfb24;
g_scan = 0x3fcdfb20;
g_chm = 0x3fcdfb1c;
g_ic_ptr = 0x3fcdfb18;
g_hmac_cnt_ptr = 0x3fcdfaf4;
g_tx_cacheq_ptr = 0x3fcdfb14;
s_netstack_free = 0x3fcdfb10;
mesh_rxcb = 0x3fcdfb0c;
sta_rxcb = 0x3fcdfb08;
ccmp_ptr = 0x3fcdfb04;
s_wifi_nvs_ptr = 0x3fcdfb00;
tkip_ptr = 0x3fcdfafc;
wep_ptr = 0x3fcdfaf8;
g_hmac_cnt_ptr = 0x3fcdfaf4;
g_misc_nvs = 0x3fcdfaf0;
s_wifi_init_state = 0x3fcdfac0;
s_wifi_task_hdl = 0x3fcdfaec;
in_rssi_adjust = 0x3fcdfae8;
rssi_saved = 0x3fcdfae0;
rssi_index = 0x3fcdfadc;
s_sa_query_retries = 0x3fcdfad8;
s_sa_query_success = 0x3fcdfad5;
g_sta_connected_flag = 0x3fcdfad4;
wpa_crypto_funcs_ptr = 0x3fcdfad0;
s_netstack_ref = 0x3fcdfacc;
sta_csa_timer_ptr = 0x3fcdfac8;
s_trans_id = 0x3fcdfac4;


/***************************************
 Group rom_coexist
 ***************************************/

/* Functions */
esp_coex_rom_version_get = 0x40002168;
coex_bt_release = 0x4000216c;
coex_bt_request = 0x40002170;
coex_core_ble_conn_dyn_prio_get = 0x40002174;
coex_core_event_duration_get = 0x40002178;
coex_core_pti_get = 0x4000217c;
coex_core_release = 0x40002180;
coex_core_request = 0x40002184;
coex_core_status_get = 0x40002188;
coex_core_timer_idx_get = 0x4000218c;
coex_event_duration_get = 0x40002190;
coex_hw_timer_disable = 0x40002194;
coex_hw_timer_enable = 0x40002198;
coex_hw_timer_set = 0x4000219c;
coex_schm_interval_set = 0x400021a0;
coex_schm_lock = 0x400021a4;
coex_schm_unlock = 0x400021a8;
coex_status_get = 0x400021ac;
coex_wifi_release = 0x400021b0;
esp_coex_ble_conn_dynamic_prio_get = 0x400021b4;
coex_hw_timer_tick_get = 0x400021b8;
/* Data (.data, .bss, .rodata) */
coex_env_ptr = 0x3fcdfabc;
coex_pti_tab_ptr = 0x3fcdfab8;
coex_schm_env_ptr = 0x3fcdfab4;
coexist_funcs = 0x3fcdfab0;
g_coa_funcs_p = 0x3fcdfaac;
g_coex_param_ptr = 0x3fcdfaa8;


/***************************************
 Group rom_phy
 ***************************************/

/* Functions */
phy_param_addr = 0x400021bc;
phy_get_romfuncs = 0x400021c0;
chip729_phyrom_version = 0x400021c4;
chip729_phyrom_version_num = 0x400021c8;
rom_get_rc_dout = 0x400021cc;
rc_cal = 0x400021d0;
phy_analog_delay_cal = 0x400021d4;
phy_rx_rifs_en = 0x400021d8;
phy_current_level_set = 0x400021dc;
phy_bbpll_en_usb = 0x400021e0;
phy_bt_power_track = 0x400021e4;
phy_xpd_tsens = 0x400021e8;
bb_wdt_rst_enable = 0x400021ec;
bb_wdt_int_enable = 0x400021f0;
bb_wdt_timeout_clear = 0x400021f4;
bb_wdt_get_status = 0x400021f8;
rom_enter_critical_phy = 0x400021fc;
rom_exit_critical_phy = 0x40002200;
rom_bb_bss_cbw40 = 0x40002204;
rom_set_chan_reg = 0x40002208;
abs_temp = 0x4000220c;
set_chan_cal_interp = 0x40002210;
loopback_mode_en = 0x40002214;
get_data_sat = 0x40002218;
phy_byte_to_word = 0x4000221c;
phy_get_rx_freq = 0x40002220;
i2c_master_reset = 0x40002224;
chan14_mic_enable = 0x40002228;
chan14_mic_cfg = 0x4000222c;
set_adc_rand = 0x40002230;
phy_set_most_tpw = 0x40002234;
phy_get_most_tpw = 0x40002238;
esp_tx_state_out = 0x4000223c;
phy_get_adc_rand = 0x40002240;
phy_internal_delay = 0x40002244;
phy_ftm_comp = 0x40002248;
phy_11p_set = 0x4000224c;
phy_freq_mem_backup = 0x40002250;
ant_dft_cfg = 0x40002254;
ant_wifitx_cfg = 0x40002258;
ant_wifirx_cfg = 0x4000225c;
ant_bttx_cfg = 0x40002260;
ant_btrx_cfg = 0x40002264;
phy_chan_dump_cfg = 0x40002268;
phy_enable_low_rate = 0x4000226c;
phy_disable_low_rate = 0x40002270;
phy_dig_reg_backup = 0x40002274;
phy_chan_filt_set = 0x40002278;
phy_rx11blr_cfg = 0x4000227c;
set_cca = 0x40002280;
set_rx_sense = 0x40002284;
rx_gain_force = 0x40002288;
rom_phy_en_hw_set_freq = 0x4000228c;
rom_phy_dis_hw_set_freq = 0x40002290;
wr_rf_freq_mem = 0x40002294;
freq_i2c_write_set = 0x40002298;
write_pll_cap_mem = 0x4000229c;
pll_dac_mem_update = 0x400022a0;
pll_cap_mem_update = 0x400022a4;
get_rf_freq_cap = 0x400022a8;
get_rf_freq_init = 0x400022ac;
freq_get_i2c_data = 0x400022b0;
freq_i2c_data_write = 0x400022b4;
set_chan_freq_hw_init = 0x400022b8;
set_chan_freq_sw_start = 0x400022bc;
rom_get_i2c_read_mask = 0x400022c0;
rom_get_i2c_mst0_mask = 0x400022c4;
rom_get_i2c_hostid = 0x400022c8;
rom_chip_i2c_readReg_org = 0x400022cc;
rom_chip_i2c_readReg = 0x400022d0;
rom_i2c_paral_set_mst0 = 0x400022d4;
rom_i2c_paral_set_read = 0x400022d8;
rom_i2c_paral_read = 0x400022dc;
rom_i2c_paral_write = 0x400022e0;
rom_i2c_paral_write_num = 0x400022e4;
rom_i2c_paral_write_mask = 0x400022e8;
rom_i2c_readReg = 0x400022ec;
rom_chip_i2c_writeReg = 0x400022f0;
rom_i2c_writeReg = 0x400022f4;
rom_i2c_readReg_Mask = 0x400022f8;
rom_i2c_writeReg_Mask = 0x400022fc;
rom_set_txcap_reg = 0x40002300;
i2c_sar2_init_code = 0x40002304;
phy_i2c_init1 = 0x40002308;
phy_i2c_init2 = 0x4000230c;
phy_get_i2c_data = 0x40002310;
bias_reg_set = 0x40002314;
i2c_rc_cal_set = 0x40002318;
i2c_bbpll_set = 0x4000231c;
rom_phy_xpd_rf = 0x40002320;
phy_wakeup_init_rom = 0x40002324;
register_chipv7_phy_init_param = 0x40002328;
phy_reg_init = 0x4000232c;
phy_close_rf_rom = 0x40002330;
rom_pbus_force_mode = 0x40002334;
rom_pbus_rd_addr = 0x40002338;
rom_pbus_rd_shift = 0x4000233c;
rom_pbus_force_test = 0x40002340;
rom_pbus_rd = 0x40002344;
rom_pbus_debugmode = 0x40002348;
rom_pbus_workmode = 0x4000234c;
rom_pbus_set_rxgain = 0x40002350;
rom_pbus_xpd_rx_off = 0x40002354;
rom_pbus_xpd_rx_on = 0x40002358;
rom_pbus_xpd_tx_off = 0x4000235c;
rom_pbus_xpd_tx_on = 0x40002360;
rom_pbus_set_dco = 0x40002364;
rom_set_loopback_gain = 0x40002368;
rom_txcal_debuge_mode = 0x4000236c;
rom_txcal_work_mode = 0x40002370;
set_pbus_mem = 0x40002374;
rom_pwdet_sar2_init = 0x40002378;
rom_en_pwdet = 0x4000237c;
rom_get_sar_sig_ref = 0x40002380;
rom_pwdet_tone_start = 0x40002384;
rom_get_tone_sar_dout = 0x40002388;
rom_get_fm_sar_dout = 0x4000238c;
rom_txtone_linear_pwr = 0x40002390;
rom_get_power_db = 0x40002394;
rom_meas_tone_pwr_db = 0x40002398;
rom_pkdet_vol_start = 0x4000239c;
rom_read_sar_dout = 0x400023a0;
rom_read_sar2_code = 0x400023a4;
rom_get_sar2_vol = 0x400023a8;
rom_get_pll_vol = 0x400023ac;
rom_tx_pwctrl_bg_init = 0x400023b0;
rom_phy_pwdet_always_en = 0x400023b4;
rom_phy_pwdet_onetime_en = 0x400023b8;
linear_to_db = 0x400023bc;
rom_disable_agc = 0x400023c0;
rom_enable_agc = 0x400023c4;
rom_disable_wifi_agc = 0x400023c8;
rom_enable_wifi_agc = 0x400023cc;
rom_write_gain_mem = 0x400023d0;
rom_bb_bss_cbw40_dig = 0x400023d4;
rom_cbw2040_cfg = 0x400023d8;
rom_mac_tx_chan_offset = 0x400023dc;
rom_tx_paon_set = 0x400023e0;
rom_i2cmst_reg_init = 0x400023e4;
rom_bt_gain_offset = 0x400023e8;
rom_fe_reg_init = 0x400023ec;
rom_mac_enable_bb = 0x400023f0;
rom_bb_wdg_cfg = 0x400023f4;
rom_fe_txrx_reset = 0x400023f8;
rom_set_rx_comp = 0x400023fc;
rom_write_chan_freq = 0x40002400;
rom_agc_reg_init = 0x40002404;
rom_bb_reg_init = 0x40002408;
rom_write_txrate_power_offset = 0x4000240c;
rom_open_i2c_xpd = 0x40002410;
rom_txiq_set_reg = 0x40002414;
rom_rxiq_set_reg = 0x40002418;
rom_phy_bbpll_cal = 0x4000241c;
phy_disable_cca = 0x40002420;
phy_enable_cca = 0x40002424;
force_txon = 0x40002428;
set_txclk_en = 0x4000242c;
set_rxclk_en = 0x40002430;
start_tx_tone_step = 0x40002434;
stop_tx_tone = 0x40002438;
bb_wdg_test_en = 0x4000243c;
noise_floor_auto_set = 0x40002440;
read_hw_noisefloor = 0x40002444;
iq_corr_enable = 0x40002448;
bt_tx_dig_gain = 0x4000244c;
wifi_tx_dig_reg = 0x40002450;
wifi_agc_sat_gain = 0x40002454;
phy_ant_init = 0x40002458;
phy_set_bbfreq_init = 0x4000245c;
wifi_fbw_sel = 0x40002460;
phy_rx_sense_set = 0x40002464;
tx_state_set = 0x40002468;
phy_close_pa = 0x4000246c;
bt_filter_reg = 0x40002470;
phy_freq_correct = 0x40002474;
set_pbus_reg = 0x40002478;
wifi_rifs_mode_en = 0x4000247c;
rfagc_disable = 0x40002480;
rom_restart_cal = 0x40002484;
rom_write_rfpll_sdm = 0x40002488;
rom_wait_rfpll_cal_end = 0x4000248c;
rom_rfpll_set_freq = 0x40002490;
rom_rfpll_cap_init_cal = 0x40002494;
rom_set_rfpll_freq = 0x40002498;
rom_write_pll_cap = 0x4000249c;
rom_read_pll_cap = 0x400024a0;
mhz2ieee = 0x400024a4;
chan_to_freq = 0x400024a8;
set_rf_freq_offset = 0x400024ac;
set_channel_rfpll_freq = 0x400024b0;
rfpll_cap_correct = 0x400024b4;
phy_set_freq = 0x400024b8;
correct_rfpll_offset = 0x400024bc;
pll_vol_cal = 0x400024c0;
chip_v7_set_chan_misc = 0x400024c4;
chip_v7_set_chan = 0x400024c8;
chip_v7_set_chan_offset = 0x400024cc;
chip_v7_set_chan_ana = 0x400024d0;
set_chanfreq = 0x400024d4;
rom_rxiq_cover_mg_mp = 0x400024d8;
rom_rfcal_rxiq = 0x400024dc;
rom_get_rfcal_rxiq_data = 0x400024e0;
rom_pbus_rx_dco_cal = 0x400024e4;
rom_rxdc_est_min = 0x400024e8;
rom_pbus_rx_dco_cal_1step = 0x400024ec;
rom_set_lb_txiq = 0x400024f0;
rom_set_rx_gain_cal_iq = 0x400024f4;
rom_set_rx_gain_cal_dc = 0x400024f8;
iq_est_enable = 0x400024fc;
iq_est_disable = 0x40002500;
dc_iq_est = 0x40002504;
set_cal_rxdc = 0x40002508;
rxiq_get_mis = 0x4000250c;
spur_reg_write_one_tone = 0x40002510;
spur_cal = 0x40002514;
spur_coef_cfg = 0x40002518;
gen_rx_gain_table = 0x4000251c;
wr_rx_gain_mem = 0x40002520;
set_rx_gain_param = 0x40002524;
set_rx_gain_table = 0x40002528;
rom_tester_wifi_cali = 0x4000252c;
esp_recover_efuse_data = 0x40002530;
bt_track_pll_cap = 0x40002534;
rfpll_cap_track = 0x40002538;
phy_param_track = 0x4000253c;
txpwr_correct = 0x40002540;
txpwr_cal_track = 0x40002544;
tx_pwctrl_background = 0x40002548;
bt_track_tx_power = 0x4000254c;
wifi_track_tx_power = 0x40002550;
rom_code_to_temp = 0x40002554;
rom_tsens_index_to_dac = 0x40002558;
rom_tsens_index_to_offset = 0x4000255c;
rom_tsens_dac_cal = 0x40002560;
rom_tsens_code_read = 0x40002564;
rom_tsens_temp_read = 0x40002568;
rom_temp_to_power = 0x4000256c;
tsens_read_init = 0x40002570;
get_temp_init = 0x40002574;
rom_txiq_cover = 0x40002578;
rom_rfcal_txiq = 0x4000257c;
rom_get_power_atten = 0x40002580;
rom_tx_pwctrl_init_cal = 0x40002584;
bt_txdc_cal = 0x40002588;
bt_txiq_cal = 0x4000258c;
txiq_cal_init = 0x40002590;
txdc_cal_init = 0x40002594;
txdc_cal_v70 = 0x40002598;
txiq_get_mis_pwr = 0x4000259c;
pwdet_ref_code = 0x400025a0;
pwdet_code_cal = 0x400025a4;
rfcal_txcap = 0x400025a8;
tx_cap_init = 0x400025ac;
rfcal_pwrctrl = 0x400025b0;
tx_pwctrl_init = 0x400025b4;
bt_tx_pwctrl_init = 0x400025b8;
bt_txpwr_freq = 0x400025bc;
rom_txbbgain_to_index = 0x400025c0;
rom_index_to_txbbgain = 0x400025c4;
rom_bt_index_to_bb = 0x400025c8;
rom_bt_bb_to_index = 0x400025cc;
rom_bt_get_tx_gain = 0x400025d0;
rom_get_tx_gain_value = 0x400025d4;
rom_wifi_get_tx_gain = 0x400025d8;
rom_set_tx_gain_mem = 0x400025dc;
rom_get_rate_fcc_index = 0x400025e0;
rom_get_chan_target_power = 0x400025e4;
rom_wifi_tx_dig_gain = 0x400025e8;
rom_wifi_set_tx_gain = 0x400025ec;
rom_bt_set_tx_gain = 0x400025f0;
wifi_11g_rate_chg = 0x400025f4;
bt_chan_pwr_interp = 0x400025f8;
bt_tx_gain_init = 0x400025fc;
/* Data (.data, .bss, .rodata) */
phy_param_rom = 0x3fcdfaa4;


/***************************************
 Group rom_btbb
 ***************************************/

/* Functions */
bt_agc_gain_offset = 0x40002600;
bt_agc_gain_max = 0x40002604;
bt_set_rx_comp = 0x40002608;
bt_agc_gain_set = 0x4000260c;
bt_agc_rssi_thresh = 0x40002610;
bt_agc_target_set = 0x40002614;
bt_agc_restart_set = 0x40002618;
bt_agc_recorrect_set = 0x4000261c;
bt_agc_detect_set = 0x40002620;
bt_bb_rx_correlator_set = 0x40002624;
bt_bb_rx_dpo_set = 0x40002628;
bt_bb_rx_filter_sel = 0x4000262c;
bt_bb_rx_set1 = 0x40002630;
bt_bb_v2_rx_set = 0x40002634;
bt_bb_v2_tx_set = 0x40002638;
bt_bb_tx_cca_set = 0x4000263c;
bt_bb_tx_cca_period = 0x40002640;
bt_bb_tx_cca_fifo_reset = 0x40002644;
bt_bb_tx_cca_fifo_empty = 0x40002648;
bt_bb_tx_cca_fifo_full = 0x4000264c;
bt_bb_tx_cca_fifo_count = 0x40002650;
bt_bb_tx_cca_fifo_read = 0x40002654;
coex_pti_v2 = 0x40002658;
bt_bb_set_le_tx_on_delay = 0x4000265c;
bt_bb_set_corr_thresh_le = 0x40002660;

/* ROM function interface esp8684.rom.mbedtls.ld for esp8684
 *
 *
 * Generated from ./interface-esp8684.yml md5sum c679b6ed5e9f0a9c3e7b93e5e0f2a1a3
 *
 * Compatible with ROM where ECO version equal or greater to 1.
 *
 * THIS FILE WAS AUTOMATICALLY GENERATED. DO NOT EDIT.
 */

/***************************************
 Group rom_mbedtls
 ***************************************/

/* Functions */
mbedtls_aes_init = 0x40002664;
ssl_write_client_hello = 0x40002668;
ssl_parse_server_hello = 0x4000266c;
ssl_parse_server_key_exchange = 0x40002670;
ssl_parse_certificate_request = 0x40002674;
ssl_parse_server_hello_done = 0x40002678;
ssl_write_client_key_exchange = 0x4000267c;
ssl_write_certificate_verify = 0x40002680;
ssl_parse_new_session_ticket = 0x40002684;
mbedtls_aes_free = 0x40002688;
mbedtls_aes_setkey_enc = 0x4000268c;
mbedtls_aes_setkey_dec = 0x40002690;
mbedtls_aes_crypt_ecb = 0x40002694;
mbedtls_aes_crypt_cbc = 0x40002698;
mbedtls_internal_aes_encrypt = 0x4000269c;
mbedtls_internal_aes_decrypt = 0x400026a0;
mbedtls_asn1_get_len = 0x400026a4;
mbedtls_asn1_get_tag = 0x400026a8;
mbedtls_asn1_get_bool = 0x400026ac;
mbedtls_asn1_get_int = 0x400026b0;
mbedtls_asn1_get_bitstring = 0x400026b4;
mbedtls_asn1_get_bitstring_null = 0x400026b8;
mbedtls_asn1_get_sequence_of = 0x400026bc;
mbedtls_asn1_get_mpi = 0x400026c0;
mbedtls_asn1_get_alg = 0x400026c4;
mbedtls_asn1_get_alg_null = 0x400026c8;
mbedtls_asn1_write_len = 0x400026cc;
mbedtls_asn1_write_tag = 0x400026d0;
mbedtls_asn1_write_mpi = 0x400026d4;
mbedtls_base64_decode = 0x400026d8;
mbedtls_mpi_init = 0x400026dc;
mbedtls_mpi_free = 0x400026e0;
mbedtls_mpi_grow = 0x400026e4;
mbedtls_mpi_shrink = 0x400026e8;
mbedtls_mpi_copy = 0x400026ec;
mbedtls_mpi_safe_cond_assign = 0x400026f0;
mbedtls_mpi_safe_cond_swap = 0x400026f4;
mbedtls_mpi_lset = 0x400026f8;
mbedtls_mpi_get_bit = 0x400026fc;
mbedtls_mpi_set_bit = 0x40002700;
mbedtls_mpi_lsb = 0x40002704;
mbedtls_mpi_bitlen = 0x40002708;
mbedtls_mpi_size = 0x4000270c;
mbedtls_mpi_read_binary = 0x40002710;
mbedtls_mpi_write_binary = 0x40002714;
mbedtls_mpi_shift_l = 0x40002718;
mbedtls_mpi_shift_r = 0x4000271c;
mbedtls_mpi_cmp_abs = 0x40002720;
mbedtls_mpi_cmp_mpi = 0x40002724;
mbedtls_mpi_lt_mpi_ct = 0x40002728;
mbedtls_mpi_cmp_int = 0x4000272c;
mbedtls_mpi_add_abs = 0x40002730;
mbedtls_mpi_sub_abs = 0x40002734;
mbedtls_mpi_add_mpi = 0x40002738;
mbedtls_mpi_sub_mpi = 0x4000273c;
mbedtls_mpi_add_int = 0x40002740;
mbedtls_mpi_sub_int = 0x40002744;
mbedtls_mpi_mul_mpi = 0x40002748;
mbedtls_mpi_mul_int = 0x4000274c;
mbedtls_mpi_div_mpi = 0x40002750;
mbedtls_mpi_div_int = 0x40002754;
mbedtls_mpi_mod_mpi = 0x40002758;
mbedtls_mpi_mod_int = 0x4000275c;
mbedtls_mpi_exp_mod = 0x40002760;
mbedtls_mpi_fill_random = 0x40002764;
mbedtls_mpi_gcd = 0x40002768;
mbedtls_mpi_inv_mod = 0x4000276c;
mbedtls_mpi_is_prime_ext = 0x40002770;
mbedtls_ccm_star_encrypt_and_tag = 0x40002774;
mbedtls_ccm_star_auth_decrypt = 0x40002778;
mbedtls_cipher_init = 0x4000277c;
mbedtls_cipher_set_padding_mode = 0x40002780;
mbedtls_cipher_reset = 0x40002784;
mbedtls_cipher_finish = 0x40002788;
mbedtls_cipher_crypt = 0x4000278c;
mbedtls_cipher_cmac_starts = 0x40002790;
mbedtls_cipher_cmac_update = 0x40002794;
mbedtls_cipher_cmac_finish = 0x40002798;
mbedtls_ctr_drbg_init = 0x4000279c;
mbedtls_ctr_drbg_seed = 0x400027a0;
mbedtls_ctr_drbg_free = 0x400027a4;
mbedtls_ctr_drbg_reseed = 0x400027a8;
mbedtls_ctr_drbg_random_with_add = 0x400027ac;
mbedtls_ctr_drbg_random = 0x400027b0;
mbedtls_dhm_init = 0x400027b4;
mbedtls_dhm_read_params = 0x400027b8;
mbedtls_dhm_make_public = 0x400027bc;
mbedtls_dhm_calc_secret = 0x400027c0;
mbedtls_dhm_free = 0x400027c4;
mbedtls_ecdh_init = 0x400027c8;
mbedtls_ecdh_setup = 0x400027cc;
mbedtls_ecdh_free = 0x400027d0;
mbedtls_ecdh_read_params = 0x400027d4;
mbedtls_ecdh_get_params = 0x400027d8;
mbedtls_ecdh_make_public = 0x400027dc;
mbedtls_ecdh_calc_secret = 0x400027e0;
mbedtls_ecdh_enable_restart = 0x400027e4;
mbedtls_ecdsa_write_signature = 0x400027e8;
mbedtls_ecdsa_write_signature_restartable = 0x400027ec;
mbedtls_ecdsa_read_signature = 0x400027f0;
mbedtls_ecdsa_read_signature_restartable = 0x400027f4;
mbedtls_ecdsa_from_keypair = 0x400027f8;
mbedtls_ecdsa_init = 0x400027fc;
mbedtls_ecdsa_free = 0x40002800;
mbedtls_ecdsa_restart_init = 0x40002804;
mbedtls_ecdsa_restart_free = 0x40002808;
mbedtls_ecjpake_init = 0x4000280c;
mbedtls_ecjpake_check = 0x40002810;
mbedtls_ecjpake_write_round_one = 0x40002814;
mbedtls_ecjpake_read_round_one = 0x40002818;
mbedtls_ecjpake_write_round_two = 0x4000281c;
mbedtls_ecjpake_read_round_two = 0x40002820;
mbedtls_ecjpake_derive_secret = 0x40002824;
mbedtls_ecjpake_free = 0x40002828;
mbedtls_ecp_check_budget = 0x4000282c;
mbedtls_ecp_restart_is_enabled = 0x40002830;
mbedtls_ecp_curve_list = 0x40002834;
mbedtls_ecp_grp_id_list = 0x40002838;
mbedtls_ecp_curve_info_from_grp_id = 0x4000283c;
mbedtls_ecp_curve_info_from_tls_id = 0x40002840;
mbedtls_ecp_point_init = 0x40002844;
mbedtls_ecp_group_init = 0x40002848;
mbedtls_ecp_keypair_init = 0x4000284c;
mbedtls_ecp_point_free = 0x40002850;
mbedtls_ecp_group_free = 0x40002854;
mbedtls_ecp_keypair_free = 0x40002858;
mbedtls_ecp_restart_init = 0x4000285c;
mbedtls_ecp_restart_free = 0x40002860;
mbedtls_ecp_copy = 0x40002864;
mbedtls_ecp_group_copy = 0x40002868;
mbedtls_ecp_set_zero = 0x4000286c;
mbedtls_ecp_is_zero = 0x40002870;
mbedtls_ecp_point_cmp = 0x40002874;
mbedtls_ecp_point_write_binary = 0x40002878;
mbedtls_ecp_point_read_binary = 0x4000287c;
mbedtls_ecp_tls_read_point = 0x40002880;
mbedtls_ecp_tls_write_point = 0x40002884;
mbedtls_ecp_group_load = 0x40002888;
mbedtls_ecp_tls_read_group = 0x4000288c;
mbedtls_ecp_tls_read_group_id = 0x40002890;
mbedtls_ecp_tls_write_group = 0x40002894;
mbedtls_ecp_mul = 0x40002898;
mbedtls_ecp_mul_restartable = 0x4000289c;
mbedtls_ecp_muladd = 0x400028a0;
mbedtls_ecp_muladd_restartable = 0x400028a4;
mbedtls_ecp_check_pubkey = 0x400028a8;
mbedtls_ecp_check_privkey = 0x400028ac;
mbedtls_ecp_gen_privkey = 0x400028b0;
mbedtls_ecp_gen_keypair_base = 0x400028b4;
mbedtls_ecp_check_pub_priv = 0x400028b8;
mbedtls_entropy_add_source = 0x400028bc;
mbedtls_entropy_func = 0x400028c0;
mbedtls_gcm_crypt_and_tag = 0x400028c4;
mbedtls_gcm_starts = 0x400028c8;
mbedtls_gcm_update = 0x400028cc;
mbedtls_gcm_finish = 0x400028d0;
mbedtls_hmac_drbg_init = 0x400028d4;
mbedtls_hmac_drbg_seed_buf = 0x400028d8;
mbedtls_hmac_drbg_update_ret = 0x400028dc;
mbedtls_hmac_drbg_reseed = 0x400028e0;
mbedtls_hmac_drbg_random_with_add = 0x400028e4;
mbedtls_hmac_drbg_random = 0x400028e8;
mbedtls_hmac_drbg_free = 0x400028ec;
mbedtls_md_list = 0x400028f0;
mbedtls_md_init = 0x400028f4;
mbedtls_md_free = 0x400028f8;
mbedtls_md_setup = 0x400028fc;
mbedtls_md_clone = 0x40002900;
mbedtls_md_get_size = 0x40002904;
mbedtls_md_get_type = 0x40002908;
mbedtls_md_starts = 0x4000290c;
mbedtls_md_update = 0x40002910;
mbedtls_md_finish = 0x40002914;
mbedtls_md = 0x40002918;
mbedtls_md_hmac_starts = 0x4000291c;
mbedtls_md_hmac_update = 0x40002920;
mbedtls_md_hmac_finish = 0x40002924;
mbedtls_md_hmac_reset = 0x40002928;
mbedtls_oid_get_x509_ext_type = 0x4000292c;
mbedtls_oid_get_pk_alg = 0x40002930;
mbedtls_oid_get_ec_grp = 0x40002934;
mbedtls_oid_get_sig_alg = 0x40002938;
mbedtls_oid_get_md_alg = 0x4000293c;
mbedtls_oid_get_md_hmac = 0x40002940;
mbedtls_oid_get_oid_by_md = 0x40002944;
mbedtls_oid_get_cipher_alg = 0x40002948;
mbedtls_oid_get_pkcs12_pbe_alg = 0x4000294c;
mbedtls_pem_init = 0x40002950;
mbedtls_pem_free = 0x40002954;
mbedtls_pkcs12_pbe_sha1_rc4_128 = 0x40002958;
mbedtls_pkcs12_pbe = 0x4000295c;
mbedtls_pkcs12_derivation = 0x40002960;
mbedtls_pkcs5_pbes2 = 0x40002964;
mbedtls_pkcs5_pbkdf2_hmac = 0x40002968;
mbedtls_pk_info_from_type = 0x4000296c;
mbedtls_pk_init = 0x40002970;
mbedtls_pk_free = 0x40002974;
mbedtls_pk_restart_init = 0x40002978;
mbedtls_pk_restart_free = 0x4000297c;
mbedtls_pk_setup = 0x40002980;
mbedtls_pk_can_do = 0x40002984;
mbedtls_pk_verify = 0x40002988;
mbedtls_pk_verify_restartable = 0x4000298c;
mbedtls_pk_verify_ext = 0x40002990;
mbedtls_pk_sign_restartable = 0x40002994;
mbedtls_pk_encrypt = 0x40002998;
mbedtls_pk_get_type = 0x4000299c;
mbedtls_pk_parse_subpubkey = 0x400029a0;
mbedtls_rsa_init = 0x400029a4;
mbedtls_rsa_import = 0x400029a8;
mbedtls_rsa_import_raw = 0x400029ac;
mbedtls_rsa_complete = 0x400029b0;
mbedtls_rsa_set_padding = 0x400029b4;
mbedtls_rsa_get_len = 0x400029b8;
mbedtls_rsa_check_pubkey = 0x400029bc;
mbedtls_rsa_check_privkey = 0x400029c0;
mbedtls_rsa_check_pub_priv = 0x400029c4;
mbedtls_rsa_public = 0x400029c8;
mbedtls_rsa_private = 0x400029cc;
mbedtls_rsa_pkcs1_encrypt = 0x400029d0;
mbedtls_rsa_rsaes_pkcs1_v15_encrypt = 0x400029d4;
mbedtls_rsa_rsaes_oaep_encrypt = 0x400029d8;
mbedtls_rsa_pkcs1_decrypt = 0x400029dc;
mbedtls_rsa_rsaes_pkcs1_v15_decrypt = 0x400029e0;
mbedtls_rsa_rsaes_oaep_decrypt = 0x400029e4;
mbedtls_rsa_pkcs1_sign = 0x400029e8;
mbedtls_rsa_rsassa_pkcs1_v15_sign = 0x400029ec;
mbedtls_rsa_rsassa_pss_sign = 0x400029f0;
mbedtls_rsa_pkcs1_verify = 0x400029f4;
mbedtls_rsa_rsassa_pkcs1_v15_verify = 0x400029f8;
mbedtls_rsa_rsassa_pss_verify = 0x400029fc;
mbedtls_rsa_rsassa_pss_verify_ext = 0x40002a00;
mbedtls_rsa_free = 0x40002a04;
mbedtls_rsa_deduce_primes = 0x40002a08;
mbedtls_rsa_deduce_private_exponent = 0x40002a0c;
mbedtls_rsa_deduce_crt = 0x40002a10;
mbedtls_rsa_validate_params = 0x40002a14;
mbedtls_rsa_validate_crt = 0x40002a18;
mbedtls_sha1_init = 0x40002a1c;
mbedtls_sha1_free = 0x40002a20;
mbedtls_sha1_clone = 0x40002a24;
mbedtls_sha1_starts_ret = 0x40002a28;
mbedtls_sha1_finish_ret = 0x40002a2c;
mbedtls_sha256_init = 0x40002a30;
mbedtls_sha256_free = 0x40002a34;
mbedtls_sha256_clone = 0x40002a38;
mbedtls_sha256_starts_ret = 0x40002a3c;
mbedtls_sha256_finish_ret = 0x40002a40;
mbedtls_sha256_ret = 0x40002a44;
mbedtls_sha512_init = 0x40002a48;
mbedtls_sha512_free = 0x40002a4c;
mbedtls_sha512_clone = 0x40002a50;
mbedtls_sha512_starts_ret = 0x40002a54;
mbedtls_sha512_update_ret = 0x40002a58;
mbedtls_sha512_finish_ret = 0x40002a5c;
mbedtls_internal_sha512_process = 0x40002a60;
mbedtls_sha512_ret = 0x40002a64;
mbedtls_ssl_conf_endpoint = 0x40002a68;
mbedtls_ssl_conf_transport = 0x40002a6c;
mbedtls_ssl_set_bio = 0x40002a70;
mbedtls_ssl_conf_dh_param_bin = 0x40002a74;
mbedtls_ssl_get_max_frag_len = 0x40002a78;
mbedtls_ssl_get_max_out_record_payload = 0x40002a7c;
mbedtls_ssl_handshake = 0x40002a80;
mbedtls_ssl_handshake_step = 0x40002a84;
mbedtls_ssl_renegotiate = 0x40002a88;
mbedtls_ssl_send_alert_message = 0x40002a8c;
mbedtls_ssl_config_defaults = 0x40002a90;
mbedtls_ssl_session_init = 0x40002a94;
mbedtls_ssl_session_free = 0x40002a98;
mbedtls_ssl_transform_free = 0x40002a9c;
mbedtls_ssl_handshake_free = 0x40002aa0;
mbedtls_ssl_handshake_client_step = 0x40002aa4;
mbedtls_ssl_handshake_wrapup = 0x40002aa8;
mbedtls_ssl_derive_keys = 0x40002aac;
mbedtls_ssl_handle_message_type = 0x40002ab0;
mbedtls_ssl_prepare_handshake_record = 0x40002ab4;
mbedtls_ssl_update_handshake_status = 0x40002ab8;
mbedtls_ssl_read_record = 0x40002abc;
mbedtls_ssl_fetch_input = 0x40002ac0;
mbedtls_ssl_write_handshake_msg = 0x40002ac4;
mbedtls_ssl_write_record = 0x40002ac8;
mbedtls_ssl_flush_output = 0x40002acc;
mbedtls_ssl_parse_certificate = 0x40002ad0;
mbedtls_ssl_write_certificate = 0x40002ad4;
mbedtls_ssl_parse_change_cipher_spec = 0x40002ad8;
mbedtls_ssl_write_change_cipher_spec = 0x40002adc;
mbedtls_ssl_parse_finished = 0x40002ae0;
mbedtls_ssl_write_finished = 0x40002ae4;
mbedtls_ssl_optimize_checksum = 0x40002ae8;
mbedtls_ssl_psk_derive_premaster = 0x40002aec;
mbedtls_ssl_sig_from_pk = 0x40002af0;
mbedtls_ssl_pk_alg_from_sig = 0x40002af4;
mbedtls_ssl_md_alg_from_hash = 0x40002af8;
mbedtls_ssl_hash_from_md_alg = 0x40002afc;
mbedtls_ssl_check_curve = 0x40002b00;
mbedtls_ssl_check_sig_hash = 0x40002b04;
mbedtls_ssl_write_version = 0x40002b08;
mbedtls_ssl_read_version = 0x40002b0c;
mbedtls_ssl_get_key_exchange_md_ssl_tls = 0x40002b10;
mbedtls_ssl_get_key_exchange_md_tls1_2 = 0x40002b14;
mbedtls_ssl_cf_hmac = 0x40002b18;
mbedtls_ssl_cf_memcpy_offset = 0x40002b1c;
mbedtls_x509_crt_parse_der = 0x40002b20;
mbedtls_x509_crt_verify_restartable = 0x40002b24;
mbedtls_x509_crt_check_key_usage = 0x40002b28;
mbedtls_x509_crt_check_extended_key_usage = 0x40002b2c;
mbedtls_x509_crt_is_revoked = 0x40002b30;
mbedtls_x509_crt_init = 0x40002b34;
mbedtls_x509_crt_free = 0x40002b38;
mbedtls_x509_crt_restart_init = 0x40002b3c;
mbedtls_x509_crt_restart_free = 0x40002b40;
mbedtls_x509_get_name = 0x40002b44;
mbedtls_x509_get_alg_null = 0x40002b48;
mbedtls_x509_get_alg = 0x40002b4c;
mbedtls_x509_get_rsassa_pss_params = 0x40002b50;
mbedtls_x509_get_sig = 0x40002b54;
mbedtls_x509_get_sig_alg = 0x40002b58;
mbedtls_x509_get_time = 0x40002b5c;
mbedtls_x509_get_serial = 0x40002b60;
mbedtls_x509_get_ext = 0x40002b64;
mbedtls_aes_xts_init = 0x40002b68;
mbedtls_aes_xts_free = 0x40002b6c;
mbedtls_aes_xts_setkey_enc = 0x40002b70;
mbedtls_aes_xts_setkey_dec = 0x40002b74;
mbedtls_aes_crypt_xts = 0x40002b78;
mbedtls_aes_crypt_cfb128 = 0x40002b7c;
mbedtls_aes_crypt_ofb = 0x40002b80;
mbedtls_aes_crypt_ctr = 0x40002b84;
mbedtls_arc4_init = 0x40002b88;
mbedtls_arc4_free = 0x40002b8c;
mbedtls_arc4_setup = 0x40002b90;
mbedtls_arc4_crypt = 0x40002b94;
mbedtls_ccm_init = 0x40002b98;
mbedtls_ccm_setkey = 0x40002b9c;
mbedtls_ccm_free = 0x40002ba0;
mbedtls_ccm_encrypt_and_tag = 0x40002ba4;
mbedtls_ccm_auth_decrypt = 0x40002ba8;
mbedtls_dhm_make_params = 0x40002bac;
mbedtls_dhm_set_group = 0x40002bb0;
mbedtls_dhm_read_public = 0x40002bb4;
mbedtls_ecdh_make_params = 0x40002bb8;
mbedtls_ecdh_read_public = 0x40002bbc;
mbedtls_entropy_init = 0x40002bc0;
mbedtls_entropy_free = 0x40002bc4;
mbedtls_gcm_init = 0x40002bc8;
mbedtls_gcm_setkey = 0x40002bcc;
mbedtls_gcm_auth_decrypt = 0x40002bd0;
mbedtls_gcm_free = 0x40002bd4;
mbedtls_md5_init = 0x40002bd8;
mbedtls_md5_free = 0x40002bdc;
mbedtls_md5_clone = 0x40002be0;
mbedtls_md5_starts_ret = 0x40002be4;
mbedtls_md5_update_ret = 0x40002be8;
mbedtls_md5_finish_ret = 0x40002bec;
mbedtls_internal_md5_process = 0x40002bf0;
mbedtls_md5_ret = 0x40002bf4;
mbedtls_pk_get_bitlen = 0x40002bf8;
mbedtls_pk_sign = 0x40002bfc;
mbedtls_pk_decrypt = 0x40002c00;
mbedtls_pk_parse_key = 0x40002c04;
mbedtls_sha1_ret = 0x40002c08;
mbedtls_ssl_init = 0x40002c0c;
mbedtls_ssl_setup = 0x40002c10;
mbedtls_ssl_conf_authmode = 0x40002c14;
mbedtls_ssl_conf_rng = 0x40002c18;
mbedtls_ssl_conf_ca_chain = 0x40002c1c;
mbedtls_ssl_conf_own_cert = 0x40002c20;
mbedtls_ssl_read = 0x40002c24;
mbedtls_ssl_write = 0x40002c28;
mbedtls_ssl_config_init = 0x40002c2c;
mbedtls_ssl_sig_hash_set_find = 0x40002c30;
mbedtls_ssl_sig_hash_set_add = 0x40002c34;
mbedtls_ssl_sig_hash_set_const_hash = 0x40002c38;
mbedtls_ssl_sig_from_pk_alg = 0x40002c3c;
mbedtls_ssl_set_calc_verify_md = 0x40002c40;
mbedtls_x509_crt_parse = 0x40002c44;
/* Data (.data, .bss, .rodata) */
p_osi_mbedtls_rom_funcs = 0x3fcdfaa0;
mbedtls_x509_crt_profile_default = 0x3ff4fba4;
mbedtls_x509_crt_profile_suiteb = 0x3ff4fb94;
aes_FSb_ptr = 0x3fcdfa9c;
AES_RT0_ptr = 0x3fcdfa98;
AES_RT1_ptr = 0x3fcdfa94;
AES_RT2_ptr = 0x3fcdfa90;
AES_RT3_ptr = 0x3fcdfa8c;
AES_FT0_ptr = 0x3fcdfa88;
AES_FT1_ptr = 0x3fcdfa84;
AES_FT2_ptr = 0x3fcdfa80;
AES_FT3_ptr = 0x3fcdfa7c;
bignum_small_prime_ptr = 0x3fcdfa78;
sha512_K_ptr = 0x3fcdfa74;

