/* sittingboy.c
**
**    code for display sitting boy
**
**    Updated Version foobillard++ started at 12/2010
**    Copyright (C) 2012 - 2013 Holger Schaekel (foobillardplus@go4more.de)
**
**    This program is free software; you can redistribute it and/or modify
**    it under the terms of the GNU General Public License Version 2 as
**    published by the Free Software Foundation;
**
**    This program is distributed in the hope that it will be useful,
**    but WITHOUT ANY WARRANTY; without even the implied warranty of
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**    GNU General Public License for more details.
**
**    You should have received a copy of the GNU General Public License
**    along with this program; if not, write to the Free Software
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include "sittingboy.h"

static int sittingboy_id = -1;

/***********************************************************************
 *        This is a general routine to make a new material active      *
 ***********************************************************************/

void sittingboy_Material_Parameters(float shininess, float r_diffuseColor, float g_diffuseColor, float b_diffuseColor, float r_specularColor, float g_specularColor, float b_specularColor) {
	GLfloat glfModelSpecular[4];

	// This causes the polygon's ambient & diffuse colors to be derived from the glColor() value.
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, shininess);
	/* Set the specular shading color. */
	glfModelSpecular[0] = r_specularColor;
	glfModelSpecular[1] = g_specularColor;
	glfModelSpecular[2] = b_specularColor;
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, glfModelSpecular);
	glColor3f(r_diffuseColor, g_diffuseColor, b_diffuseColor);
}

/***********************************************************************
 *                          Make an glcallist                          *
 ***********************************************************************/

void init_sittingboy(void) {
	 if(sittingboy_id != -1) {
	 	glDeleteLists(sittingboy_id,1);
	 }
 	fprintf(stderr,"Initialize high-res sitting-boy graphics\n");
  sittingboy_id = glGenLists(1);
  glNewList(sittingboy_id, GL_COMPILE);
  sittingboy();
  glEndList();
}

/***********************************************************************
 *                         display the boy                             *
 ***********************************************************************/

void display_sittingboy(void) {
	 if(sittingboy_id == -1) {
	 	init_sittingboy();
	 } else {
	 	glCallList(sittingboy_id);
	 }
}

/***********************************************************************
 *                           build the boy                             *
 *               Polygons for object (8415 polygons)                   *
 *               gloves with errors - disabled in source               *
 ***********************************************************************/

void sittingboy(void) {

	static GLfloat VertexData[] = {
		-4.11330f, 0.443552f, 1.71106f, -4.11215f, 0.456755f, 1.83671f, -4.10937f, 0.551727f, 1.79709f, 
		-4.10937f, 0.551727f, 1.79709f, -4.10438f, 0.531342f, 1.69694f, 
		-4.10438f, 0.531342f, 1.69694f, -4.10265f, 0.361124f, 1.73259f, 
		-4.10031f, 0.369663f, 1.83308f, -4.09774f, 0.557970f, 1.85235f, 
		-4.09774f, 0.557970f, 1.85235f, -4.09325f, 0.412772f, 1.65729f, 
		-4.08787f, 0.515205f, 1.64314f, -4.08787f, 0.515205f, 1.64314f, 
		-4.07899f, 0.278349f, 1.75087f, -4.07750f, 0.632280f, 1.73714f, 
		-4.07750f, 0.632280f, 1.73714f, -4.07750f, 0.632280f, 1.73714f, 
		-4.07436f, 0.640624f, 1.78862f, -4.07436f, 0.640624f, 1.78862f, 
		-4.07436f, 0.640624f, 1.78862f, -4.07436f, 0.640624f, 1.78862f, 
		-4.07434f, -0.0189990f, 2.39440f, -4.07434f, -0.0189990f, 2.39440f, 
		-4.07434f, -0.0189990f, 2.39440f, -4.07434f, -0.0189990f, 2.39440f, 
		-4.07433f, 0.618771f, 1.69205f, -4.07433f, 0.618771f, 1.69205f, 
		-4.07282f, 0.292061f, 1.83186f, -4.07254f, 0.455643f, 1.93681f, 
		-4.07254f, 0.455643f, 1.93681f, -4.06890f, -0.0361970f, 2.41900f, 
		-4.06890f, -0.0361970f, 2.41900f, -4.06890f, -0.0361970f, 2.41900f, 
		-4.06878f, 0.00817804f, 2.32822f, -4.06815f, 0.00404627f, 2.34456f, 
		-4.06815f, 0.00404627f, 2.34456f, -4.06815f, 0.00404627f, 2.34456f, 
		-4.06648f, 0.0122710f, 2.30352f, -4.06648f, 0.0122710f, 2.30352f, 
		-4.06648f, 0.0122710f, 2.30352f, -4.06569f, 0.648727f, 1.82262f, 
		-4.06569f, 0.648727f, 1.82262f, -4.06509f, 0.559823f, 1.93500f, 
		-4.06509f, 0.559823f, 1.93500f, -4.06381f, -0.0458720f, 2.39792f, 
		-4.06381f, -0.0458720f, 2.39792f, -4.06381f, -0.0458720f, 2.39792f, 
		-4.06315f, 0.0271938f, 2.33745f, -4.06315f, 0.0271938f, 2.33745f, 
		-4.06315f, 0.0271938f, 2.33745f, -4.06315f, 0.0271938f, 2.33745f, 
		-4.06224f, 0.0194745f, 2.35046f, -4.06224f, 0.0194745f, 2.35046f, 
		-4.06224f, 0.0194745f, 2.35046f, -4.06224f, 0.0194745f, 2.35046f, 
		-4.06171f, 0.00947600f, 2.38534f, -4.06171f, 0.00947600f, 2.38534f, 
		-4.06171f, 0.00947600f, 2.38534f, -4.06171f, 0.00947600f, 2.38534f, 
		-4.06171f, 0.00947600f, 2.38534f, -4.06081f, -0.0171660f, 2.42971f, 
		-4.06081f, -0.0171660f, 2.42971f, -4.06081f, -0.0171660f, 2.42971f, 
		-4.06081f, -0.0171660f, 2.42971f, -4.06073f, -0.0130803f, 2.34021f, 
		-4.06073f, -0.0130803f, 2.34021f, -4.06073f, -0.0130803f, 2.34021f, 
		-4.06073f, -0.0130803f, 2.34021f, -4.06073f, -0.0130803f, 2.34021f, 
		-4.06073f, -0.0130803f, 2.34021f, -4.06047f, -0.0129180f, 2.32512f, 
		-4.06047f, -0.0129180f, 2.32512f, -4.05987f, 0.0176622f, 2.27607f, 
		-4.05986f, 0.0324594f, 2.30588f, -4.05986f, 0.0324594f, 2.30588f, 
		-4.05986f, 0.0324594f, 2.30588f, -4.05971f, 0.00322500f, 2.33737f, 
		-4.05971f, 0.00322500f, 2.33737f, -4.05971f, 0.00322500f, 2.33737f, 
		-4.05971f, 0.00322500f, 2.33737f, -4.05971f, 0.00322500f, 2.33737f, 
		-4.05869f, 0.447528f, 1.76818f, -4.05766f, -0.00801974f, 2.30535f, 
		-4.05766f, -0.00801974f, 2.30535f, -4.05766f, -0.00801974f, 2.30535f, 
		-4.05656f, 0.438394f, 1.71022f, -4.05655f, 0.369814f, 1.94059f, 
		-4.05522f, -0.0100520f, 2.33761f, -4.05522f, -0.0100520f, 2.33761f, 
		-4.05522f, -0.0100520f, 2.33761f, -4.05522f, -0.0100520f, 2.33761f, 
		-4.05522f, -0.0100520f, 2.33761f, -4.05516f, 0.0366482f, 2.27578f, 
		-4.05516f, 0.0366482f, 2.27578f, -4.05516f, 0.0366482f, 2.27578f, 
		-4.05516f, 0.0366482f, 2.27578f, -4.05516f, 0.0366482f, 2.27578f, 
		-4.05369f, 0.496519f, 1.58631f, -4.05369f, 0.496519f, 1.58631f, 
		-4.05363f, 0.0133070f, 2.34196f, -4.05363f, 0.0133070f, 2.34196f, 
		-4.05363f, 0.0133070f, 2.34196f, -4.05363f, 0.0133070f, 2.34196f, 
		-4.05324f, 0.411550f, 1.60301f, -4.05316f, 0.0366207f, 2.29615f, 
		-4.05316f, 0.0366207f, 2.29615f, -4.05198f, 0.0170340f, 2.28354f, 
		-4.05198f, 0.0170340f, 2.28354f, -4.05198f, 0.0170340f, 2.28354f, 
		-4.05198f, 0.0170340f, 2.28354f, -4.05198f, 0.0170340f, 2.28354f, 
		-4.05174f, -0.00148188f, 2.28313f, -4.05174f, -0.00148188f, 2.28313f, 
		-4.05163f, -0.00935380f, 2.33491f, -4.05163f, -0.00935380f, 2.33491f, 
		-4.05163f, -0.00935380f, 2.33491f, -4.05163f, -0.00935380f, 2.33491f, 
		-4.05001f, 0.452059f, 1.82823f, -4.04979f, 0.00943600f, 2.40450f, 
		-4.04979f, 0.00943600f, 2.40450f, -4.04979f, 0.00943600f, 2.40450f, 
		-4.04979f, 0.00943600f, 2.40450f, -4.04957f, 0.523467f, 1.70361f, 
		-4.04874f, 0.368040f, 1.76430f, -4.04859f, -0.0155437f, 2.34098f, 
		-4.04859f, -0.0155437f, 2.34098f, -4.04859f, -0.0155437f, 2.34098f, 
		-4.04779f, 0.0335920f, 2.27946f, -4.04779f, 0.0335920f, 2.27946f, 
		-4.04779f, 0.0335920f, 2.27946f, -4.04778f, 0.0226872f, 2.35468f, 
		-4.04778f, 0.0226872f, 2.35468f, -4.04778f, 0.0226872f, 2.35468f, 
		-4.04765f, -0.0519710f, 2.40040f, -4.04765f, -0.0519710f, 2.40040f, 
		-4.04765f, -0.0519710f, 2.40040f, -4.04765f, -0.0519710f, 2.40040f, 
		-4.04765f, -0.0519710f, 2.40040f, -4.04496f, 0.0334055f, 2.34342f, 
		-4.04496f, 0.0334055f, 2.34342f, -4.04496f, 0.0334055f, 2.34342f, 
		-4.04496f, 0.0334055f, 2.34342f, -4.04496f, 0.0334055f, 2.34342f, 
		-4.04466f, 0.370485f, 1.82347f, -4.04466f, 0.00206966f, 2.25871f, 
		-4.04466f, 0.00206966f, 2.25871f, -4.04466f, 0.00206966f, 2.25871f, 
		-4.04419f, 0.362964f, 1.70744f, -4.04404f, 0.540610f, 1.75567f, 
		-4.04266f, 0.0124984f, 2.34423f, -4.04266f, 0.0124984f, 2.34423f, 
		-4.04266f, 0.0124984f, 2.34423f, -4.04266f, 0.0124984f, 2.34423f, 
		-4.04259f, 0.0244505f, 2.22101f, -4.04193f, 0.508118f, 1.66157f, 
		-4.04176f, -0.0258994f, 2.32736f, -4.04176f, -0.0258994f, 2.32736f, 
		-4.04176f, -0.0258994f, 2.32736f, -4.04176f, -0.0258994f, 2.32736f, 
		-4.04176f, -0.0258994f, 2.32736f, -4.04176f, -0.0258994f, 2.32736f, 
		-4.04168f, 0.213663f, 1.79138f, -4.04057f, 0.0397211f, 2.30176f, 
		-4.04057f, 0.0397211f, 2.30176f, -4.03941f, 0.576668f, 1.60299f, 
		-4.03930f, -0.0217154f, 2.30956f, -4.03930f, -0.0217154f, 2.30956f, 
		-4.03930f, -0.0217154f, 2.30956f, -4.03930f, -0.0217154f, 2.30956f, 
		-4.03930f, -0.0217154f, 2.30956f, -4.03926f, -0.00255805f, 2.33350f, 
		-4.03926f, -0.00255805f, 2.33350f, -4.03926f, -0.00255805f, 2.33350f, 
		-4.03926f, -0.00255805f, 2.33350f, -4.03926f, -0.00255805f, 2.33350f, 
		-4.03926f, -0.00255805f, 2.33350f, -4.03926f, -0.00255805f, 2.33350f, 
		-4.03926f, -0.00255805f, 2.33350f, -4.03926f, -0.00255805f, 2.33350f, 
		-4.03874f, 0.0377034f, 2.32031f, -4.03836f, 0.421201f, 1.65304f, 
		-4.03802f, -0.0368140f, 2.42770f, -4.03802f, -0.0368140f, 2.42770f, 
		-4.03802f, -0.0368140f, 2.42770f, -4.03802f, -0.0368140f, 2.42770f, 
		-4.03802f, -0.0368140f, 2.42770f, -4.03802f, -0.0368140f, 2.42770f, 
		-4.03796f, -0.0163540f, 2.33804f, -4.03796f, -0.0163540f, 2.33804f, 
		-4.03796f, -0.0163540f, 2.33804f, -4.03764f, 0.0438251f, 2.28517f, 
		-4.03764f, 0.0438251f, 2.28517f, -4.03691f, 0.00576600f, 2.24492f, 
		-4.03691f, 0.00576600f, 2.24492f, -4.03691f, 0.00576600f, 2.24492f, 
		-4.03691f, 0.00576600f, 2.24492f, -4.03691f, 0.00576600f, 2.24492f, 
		-4.03691f, 0.00576600f, 2.24492f, -4.03664f, -0.0101445f, 2.28754f, 
		-4.03664f, -0.0101445f, 2.28754f, -4.03664f, -0.0101445f, 2.28754f, 
		-4.03664f, -0.0101445f, 2.28754f, -4.03641f, -0.00287406f, 2.33450f, 
		-4.03641f, -0.00287406f, 2.33450f, -4.03641f, -0.00287406f, 2.33450f, 
		-4.03641f, -0.00287406f, 2.33450f, -4.03641f, -0.00287406f, 2.33450f, 
		-4.03641f, -0.00287406f, 2.33450f, -4.03641f, -0.00287406f, 2.33450f, 
		-4.03641f, -0.00287406f, 2.33450f, -4.03641f, -0.00287406f, 2.33450f, 
		-4.03630f, -0.0164340f, 2.42949f, -4.03630f, -0.0164340f, 2.42949f, 
		-4.03630f, -0.0164340f, 2.42949f, -4.03630f, -0.0164340f, 2.42949f, 
		-4.03630f, -0.0164340f, 2.42949f, -4.03627f, 0.000798292f, 2.32253f, 
		-4.03627f, 0.000798292f, 2.32253f, -4.03627f, 0.000798292f, 2.32253f, 
		-4.03627f, 0.000798292f, 2.32253f, -4.03627f, 0.000798292f, 2.32253f, 
		-4.03627f, 0.000798292f, 2.32253f, -4.03606f, 0.00446415f, 2.32848f, 
		-4.03606f, 0.00446415f, 2.32848f, -4.03606f, 0.00446415f, 2.32848f, 
		-4.03500f, 0.0420316f, 2.21133f, -4.03500f, 0.0420316f, 2.21133f, 
		-4.03500f, 0.0420316f, 2.21133f, -4.03495f, -0.00951150f, 2.34439f, 
		-4.03495f, -0.00951150f, 2.34439f, -4.03495f, -0.00951150f, 2.34439f, 
		-4.03495f, -0.00951150f, 2.34439f, -4.03491f, 0.00822247f, 2.21551f, 
		-4.03491f, 0.00822247f, 2.21551f, -4.03491f, 0.00822247f, 2.21551f, 
		-4.03491f, 0.00822247f, 2.21551f, -4.03486f, 0.453761f, 1.88056f, 
		-4.03473f, 0.293621f, 1.92070f, -4.03448f, 0.00310018f, 2.33779f, 
		-4.03448f, 0.00310018f, 2.33779f, -4.03448f, 0.00310018f, 2.33779f, 
		-4.03448f, 0.00310018f, 2.33779f, -4.03448f, 0.00310018f, 2.33779f, 
		-4.03448f, 0.00310018f, 2.33779f, -4.03448f, 0.00310018f, 2.33779f, 
		-4.03430f, -0.00609098f, 2.32993f, -4.03430f, -0.00609098f, 2.32993f, 
		-4.03430f, -0.00609098f, 2.32993f, -4.03430f, -0.00609098f, 2.32993f, 
		-4.03430f, -0.00609098f, 2.32993f, -4.03422f, 0.0127311f, 2.26476f, 
		-4.03422f, 0.0127311f, 2.26476f, -4.03422f, 0.0127311f, 2.26476f, 
		-4.03422f, 0.0127311f, 2.26476f, -4.03422f, 0.0127311f, 2.26476f, 
		-4.03393f, 0.0387590f, 2.28986f, -4.03393f, 0.0387590f, 2.28986f, 
		-4.03393f, 0.0387590f, 2.28986f, -4.03301f, 0.0182330f, 2.35494f, 
		-4.03301f, 0.0182330f, 2.35494f, -4.03301f, 0.0182330f, 2.35494f, 
		-4.03301f, 0.0182330f, 2.35494f, -4.03269f, 0.0460929f, 2.26449f, 
		-4.03269f, 0.0460929f, 2.26449f, -4.03269f, 0.0460929f, 2.26449f, 
		-4.03269f, 0.0460929f, 2.26449f, -4.03269f, 0.0460929f, 2.26449f, 
		-4.03225f, 0.00951855f, 2.28008f, -4.03225f, 0.00951855f, 2.28008f, 
		-4.03225f, 0.00951855f, 2.28008f, -4.03225f, 0.00951855f, 2.28008f, 
		-4.03225f, 0.00951855f, 2.28008f, -4.03203f, -0.00858889f, 2.31243f, 
		-4.03203f, -0.00858889f, 2.31243f, -4.03203f, -0.00858889f, 2.31243f, 
		-4.03203f, -0.00858889f, 2.31243f, -4.03203f, -0.00858889f, 2.31243f, 
		-4.03187f, -0.0214338f, 2.33427f, -4.03118f, -0.0419230f, 2.40342f, 
		-4.03118f, -0.0419230f, 2.40342f, -4.03118f, -0.0419230f, 2.40342f, 
		-4.03118f, -0.0419230f, 2.40342f, -4.03118f, -0.0419230f, 2.40342f, 
		-4.03090f, -0.00505700f, 2.28024f, -4.03090f, -0.00505700f, 2.28024f, 
		-4.03090f, -0.00505700f, 2.28024f, -4.03086f, 0.328190f, 1.74849f, 
		-4.03086f, 0.328190f, 1.74849f, -4.03086f, 0.328190f, 1.74849f, 
		-4.03078f, 0.298738f, 1.81313f, -4.03052f, 0.304516f, 1.75359f, 
		-4.03001f, 0.0227657f, 2.26875f, -4.03001f, 0.0227657f, 2.26875f, 
		-4.03001f, 0.0227657f, 2.26875f, -4.03001f, 0.0227657f, 2.26875f, 
		-4.03001f, 0.0227657f, 2.26875f, -4.03001f, 0.0227657f, 2.26875f, 
		-4.02999f, 0.552441f, 1.81407f, -4.02994f, 0.0146482f, 2.24708f, 
		-4.02994f, 0.0146482f, 2.24708f, -4.02994f, 0.0146482f, 2.24708f, 
		-4.02968f, 0.00606116f, 2.31179f, -4.02968f, 0.00606116f, 2.31179f, 
		-4.02968f, 0.00606116f, 2.31179f, -4.02968f, 0.00606116f, 2.31179f, 
		-4.02968f, 0.00606116f, 2.31179f, -4.02968f, 0.00606116f, 2.31179f, 
		-4.02919f, -0.00393686f, 2.31043f, -4.02919f, -0.00393686f, 2.31043f, 
		-4.02919f, -0.00393686f, 2.31043f, -4.02919f, -0.00393686f, 2.31043f, 
		-4.02885f, 0.371750f, 1.87783f, -4.02877f, -0.000812731f, 2.26886f, 
		-4.02877f, -0.000812731f, 2.26886f, -4.02877f, -0.000812731f, 2.26886f, 
		-4.02877f, -0.000812731f, 2.26886f, -4.02877f, -0.000812731f, 2.26886f, 
		-4.02863f, 0.0424405f, 2.26135f, -4.02863f, 0.0424405f, 2.26135f, 
		-4.02863f, 0.0424405f, 2.26135f, -4.02863f, 0.0424405f, 2.26135f, 
		-4.02852f, -0.000968493f, 2.28875f, -4.02852f, -0.000968493f, 2.28875f, 
		-4.02852f, -0.000968493f, 2.28875f, -4.02852f, -0.000968493f, 2.28875f, 
		-4.02851f, 0.0159090f, 2.37701f, -4.02851f, 0.0159090f, 2.37701f, 
		-4.02851f, 0.0159090f, 2.37701f, -4.02839f, 0.0267450f, 2.25352f, 
		-4.02839f, 0.0267450f, 2.25352f, -4.02839f, 0.0267450f, 2.25352f, 
		-4.02839f, 0.0267450f, 2.25352f, -4.02839f, 0.0267450f, 2.25352f, 
		-4.02836f, -0.00549212f, 2.26054f, -4.02836f, -0.00549212f, 2.26054f, 
		-4.02801f, -0.0221764f, 2.32473f, -4.02723f, 0.257869f, 1.76394f, 
		-4.02723f, 0.257869f, 1.76394f, -4.02723f, 0.257869f, 1.76394f, 
		-4.02723f, 0.257869f, 1.76394f, -4.02723f, 0.257869f, 1.76394f, 
		-4.02721f, 0.0273790f, 2.19292f, -4.02721f, 0.0273790f, 2.19292f, 
		-4.02721f, 0.0273790f, 2.19292f, -4.02655f, 0.0264841f, 2.34551f, 
		-4.02655f, 0.0264841f, 2.34551f, -4.02655f, 0.0264841f, 2.34551f, 
		-4.02655f, 0.0264841f, 2.34551f, -4.02655f, 0.0264841f, 2.34551f, 
		-4.02630f, 0.00593135f, 2.34999f, -4.02630f, 0.00593135f, 2.34999f, 
		-4.02630f, 0.00593135f, 2.34999f, -4.02581f, -0.00956374f, 2.31451f, 
		-4.02581f, -0.00956374f, 2.31451f, -4.02581f, -0.00956374f, 2.31451f, 
		-4.02581f, -0.00956374f, 2.31451f, -4.02581f, -0.00956374f, 2.31451f, 
		-4.02504f, 0.0272596f, 2.17823f, -4.02455f, 0.0476460f, 2.22703f, 
		-4.02455f, 0.0476460f, 2.22703f, -4.02455f, 0.0476460f, 2.22703f, 
		-4.02455f, 0.0476460f, 2.22703f, -4.02437f, -0.0180010f, 2.40825f, 
		-4.02437f, -0.0180010f, 2.40825f, -4.02437f, -0.0180010f, 2.40825f, 
		-4.02431f, 0.0284439f, 2.33209f, -4.02431f, 0.0284439f, 2.33209f, 
		-4.02431f, 0.0284439f, 2.33209f, -4.02431f, 0.0284439f, 2.33209f, 
		-4.02431f, 0.0284439f, 2.33209f, -4.02430f, -0.00611931f, 2.31475f, 
		-4.02430f, -0.00611931f, 2.31475f, -4.02430f, -0.00611931f, 2.31475f, 
		-4.02430f, -0.00611931f, 2.31475f, -4.02416f, 0.657704f, 1.93591f, 
		-4.02411f, -0.000127136f, 2.29917f, -4.02411f, -0.000127136f, 2.29917f, 
		-4.02411f, -0.000127136f, 2.29917f, -4.02411f, -0.000127136f, 2.29917f, 
		-4.02411f, -0.000127136f, 2.29917f, -4.02411f, -0.000127136f, 2.29917f, 
		-4.02411f, -0.000127136f, 2.29917f, -4.02411f, -0.000127136f, 2.29917f, 
		-4.02411f, -0.000127136f, 2.29917f, -4.02411f, -0.000127136f, 2.29917f, 
		-4.02411f, -0.000127136f, 2.29917f, -4.02404f, 0.563618f, 1.66341f, 
		-4.02391f, 0.000863162f, 2.24950f, -4.02391f, 0.000863162f, 2.24950f, 
		-4.02391f, 0.000863162f, 2.24950f, -4.02391f, 0.000863162f, 2.24950f, 
		-4.02391f, 0.000863162f, 2.24950f, -4.02391f, 0.000863162f, 2.24950f, 
		-4.02381f, 0.0174173f, 2.22268f, -4.02381f, 0.0174173f, 2.22268f, 
		-4.02381f, 0.0174173f, 2.22268f, -4.02381f, 0.0174173f, 2.22268f, 
		-4.02381f, 0.0174173f, 2.22268f, -4.02309f, 0.00252361f, 2.31487f, 
		-4.02309f, 0.00252361f, 2.31487f, -4.02309f, 0.00252361f, 2.31487f, 
		-4.02309f, 0.00252361f, 2.31487f, -4.02309f, 0.00252361f, 2.31487f, 
		-4.02275f, 0.0443105f, 2.18101f, -4.02275f, 0.0443105f, 2.18101f, 
		-4.02275f, 0.0443105f, 2.18101f, -4.02264f, 0.349755f, 1.65896f, 
		-4.02248f, 0.550837f, 1.98992f, -4.02213f, 0.0329885f, 2.31012f, 
		-4.02213f, 0.0329885f, 2.31012f, -4.02213f, 0.0329885f, 2.31012f, 
		-4.02184f, -0.00475571f, 2.28861f, -4.02184f, -0.00475571f, 2.28861f, 
		-4.02184f, -0.00475571f, 2.28861f, -4.02184f, -0.00475571f, 2.28861f, 
		-4.02170f, 0.304922f, 1.70202f, -4.02056f, 0.214022f, 1.83658f, 
		-4.02047f, 0.0444760f, 2.22714f, -4.02047f, 0.0444760f, 2.22714f, 
		-4.02047f, 0.0444760f, 2.22714f, -4.02047f, 0.0444760f, 2.22714f, 
		-4.02042f, 0.0446030f, 2.18405f, -4.02042f, 0.0446030f, 2.18405f, 
		-4.02038f, -0.0150233f, 2.33607f, -4.02038f, -0.0150233f, 2.33607f, 
		-4.02038f, -0.0150233f, 2.33607f, -4.02038f, -0.0150233f, 2.33607f, 
		-4.02038f, -0.0150233f, 2.33607f, -4.02038f, -0.0150233f, 2.33607f, 
		-4.02030f, -0.00816237f, 2.29752f, -4.02030f, -0.00816237f, 2.29752f, 
		-4.02030f, -0.00816237f, 2.29752f, -4.02030f, -0.00816237f, 2.29752f, 
		-4.02019f, 0.00492733f, 2.22503f, -4.02019f, 0.00492733f, 2.22503f, 
		-4.02019f, 0.00492733f, 2.22503f, -4.02019f, 0.00492733f, 2.22503f, 
		-4.01974f, 0.00228407f, 2.29824f, -4.01974f, 0.00228407f, 2.29824f, 
		-4.01974f, 0.00228407f, 2.29824f, -4.01974f, 0.00228407f, 2.29824f, 
		-4.01974f, 0.00228407f, 2.29824f, -4.01974f, 0.00228407f, 2.29824f, 
		-4.01974f, 0.00228407f, 2.29824f, -4.01974f, 0.00228407f, 2.29824f, 
		-4.01974f, 0.00228407f, 2.29824f, -4.01949f, -0.00218273f, 2.22634f, 
		-4.01949f, -0.00218273f, 2.22634f, -4.01949f, -0.00218273f, 2.22634f, 
		-4.01949f, -0.00218273f, 2.22634f, -4.01919f, 0.0112475f, 2.17430f, 
		-4.01919f, 0.0112475f, 2.17430f, -4.01919f, 0.0112475f, 2.17430f, 
		-4.01919f, 0.0112475f, 2.17430f, -4.01919f, 0.0112475f, 2.17430f, 
		-4.01911f, -0.00453765f, 2.24106f, -4.01911f, -0.00453765f, 2.24106f, 
		-4.01909f, 0.0426101f, 2.29376f, -4.01909f, 0.0426101f, 2.29376f, 
		-4.01909f, 0.0426101f, 2.29376f, -4.01885f, 0.0321703f, 2.31945f, 
		-4.01885f, 0.0321703f, 2.31945f, -4.01874f, 0.00964461f, 2.32164f, 
		-4.01874f, 0.00964461f, 2.32164f, -4.01874f, 0.00964461f, 2.32164f, 
		-4.01861f, 0.509862f, 1.62621f, -4.01830f, 0.0104376f, 2.31012f, 
		-4.01830f, 0.0104376f, 2.31012f, -4.01830f, 0.0104376f, 2.31012f, 
		-4.01815f, 0.0240375f, 2.27401f, -4.01815f, 0.0240375f, 2.27401f, 
		-4.01815f, 0.0240375f, 2.27401f, -4.01815f, 0.0240375f, 2.27401f, 
		-4.01815f, 0.0240375f, 2.27401f, -4.01814f, 0.00167600f, 2.29903f, 
		-4.01814f, 0.00167600f, 2.29903f, -4.01814f, 0.00167600f, 2.29903f, 
		-4.01814f, 0.00167600f, 2.29903f, -4.01814f, 0.00167600f, 2.29903f, 
		-4.01769f, -0.00650470f, 2.26973f, -4.01769f, -0.00650470f, 2.26973f, 
		-4.01769f, -0.00650470f, 2.26973f, -4.01769f, -0.00650470f, 2.26973f, 
		-4.01769f, -0.00650470f, 2.26973f, -4.01769f, -0.00650470f, 2.26973f, 
		-4.01769f, -0.0161165f, 2.32572f, -4.01769f, -0.0161165f, 2.32572f, 
		-4.01769f, -0.0161165f, 2.32572f, -4.01769f, -0.0161165f, 2.32572f, 
		-4.01754f, 0.0514487f, 2.19813f, -4.01754f, 0.0514487f, 2.19813f, 
		-4.01754f, 0.0514487f, 2.19813f, -4.01724f, -0.0145558f, 2.31258f, 
		-4.01724f, -0.0145558f, 2.31258f, -4.01724f, -0.0145558f, 2.31258f, 
		-4.01724f, -0.0145558f, 2.31258f, -4.01724f, -0.0145558f, 2.31258f, 
		-4.01724f, -0.0145558f, 2.31258f, -4.01700f, 0.00933061f, 2.17782f, 
		-4.01700f, 0.00933061f, 2.17782f, -4.01700f, 0.00933061f, 2.17782f, 
		-4.01700f, 0.00933061f, 2.17782f, -4.01700f, 0.00933061f, 2.17782f, 
		-4.01697f, 0.0320968f, 2.25880f, -4.01697f, 0.0320968f, 2.25880f, 
		-4.01697f, 0.0320968f, 2.25880f, -4.01697f, 0.0320968f, 2.25880f, 
		-4.01697f, 0.0320968f, 2.25880f, -4.01692f, 0.251632f, 1.63321f, 
		-4.01692f, 0.251632f, 1.63321f, -4.01692f, 0.251632f, 1.63321f, 
		-4.01692f, 0.251632f, 1.63321f, -4.01677f, 0.00721481f, 2.34288f, 
		-4.01677f, 0.00721481f, 2.34288f, -4.01677f, 0.00721481f, 2.34288f, 
		-4.01677f, 0.00721481f, 2.34288f, -4.01677f, 0.00721481f, 2.34288f, 
		-4.01572f, 0.702269f, 1.71466f, -4.01572f, 0.702269f, 1.71466f, 
		-4.01540f, 0.00192026f, 2.19488f, -4.01540f, 0.00192026f, 2.19488f, 
		-4.01540f, 0.00192026f, 2.19488f, -4.01540f, 0.00192026f, 2.19488f, 
		-4.01539f, 0.0480467f, 2.20111f, -4.01539f, 0.0480467f, 2.20111f, 
		-4.01539f, 0.0480467f, 2.20111f, -4.01539f, 0.0480467f, 2.20111f, 
		-4.01539f, 0.0480467f, 2.20111f, -4.01539f, 0.593820f, 1.69220f, 
		-4.01462f, 0.294693f, 1.87133f, -4.01434f, 0.000339986f, 2.30455f, 
		-4.01434f, 0.000339986f, 2.30455f, -4.01434f, 0.000339986f, 2.30455f, 
		-4.01434f, 0.000339986f, 2.30455f, -4.01429f, -0.00496989f, 2.25399f, 
		-4.01429f, -0.00496989f, 2.25399f, -4.01428f, 0.0240260f, 2.29880f, 
		-4.01428f, 0.0240260f, 2.29880f, -4.01428f, 0.0240260f, 2.29880f, 
		-4.01428f, 0.0240260f, 2.29880f, -4.01428f, 0.0240260f, 2.29880f, 
		-4.01428f, 0.0240260f, 2.29880f, -4.01406f, -0.000780389f, 2.29119f, 
		-4.01406f, -0.000780389f, 2.29119f, -4.01406f, -0.000780389f, 2.29119f, 
		-4.01406f, -0.000780389f, 2.29119f, -4.01352f, 0.0459150f, 2.27851f, 
		-4.01352f, 0.0459150f, 2.27851f, -4.01352f, 0.0459150f, 2.27851f, 
		-4.01352f, 0.0459150f, 2.27851f, -4.01352f, 0.0459150f, 2.27851f, 
		-4.01352f, 0.0459150f, 2.27851f, -4.01324f, 0.0172700f, 2.31944f, 
		-4.01311f, 0.0200860f, 2.19477f, -4.01311f, 0.0200860f, 2.19477f, 
		-4.01311f, 0.0200860f, 2.19477f, -4.01311f, 0.0200860f, 2.19477f, 
		-4.01285f, 0.0299015f, 2.31272f, -4.01285f, 0.0299015f, 2.31272f, 
		-4.01285f, 0.0299015f, 2.31272f, -4.01285f, 0.0299015f, 2.31272f, 
		-4.01285f, 0.0299015f, 2.31272f, -4.01285f, 0.0299015f, 2.31272f, 
		-4.01227f, -0.00407194f, 2.27551f, -4.01215f, 0.198906f, 1.72641f, 
		-4.01176f, 0.00940781f, 2.30994f, -4.01176f, 0.00940781f, 2.30994f, 
		-4.01176f, 0.00940781f, 2.30994f, -4.01153f, 0.00612197f, 2.32410f, 
		-4.01149f, 0.00265279f, 2.35982f, -4.01149f, 0.00265279f, 2.35982f, 
		-4.01149f, 0.00265279f, 2.35982f, -4.01149f, 0.00265279f, 2.35982f, 
		-4.01149f, 0.00265279f, 2.35982f, -4.01147f, 0.0322450f, 2.19744f, 
		-4.01147f, 0.0322450f, 2.19744f, -4.01147f, 0.0322450f, 2.19744f, 
		-4.01147f, 0.0322450f, 2.19744f, -4.01147f, 0.0322450f, 2.19744f, 
		-4.01147f, 0.0322450f, 2.19744f, -4.01147f, 0.0322450f, 2.19744f, 
		-4.01129f, 0.0281015f, 2.15200f, -4.01129f, 0.0281015f, 2.15200f, 
		-4.01129f, 0.0281015f, 2.15200f, -4.01114f, 0.0348212f, 2.23109f, 
		-4.01114f, 0.0348212f, 2.23109f, -4.01114f, 0.0348212f, 2.23109f, 
		-4.01044f, 0.0159468f, 2.28142f, -4.01044f, 0.0159468f, 2.28142f, 
		-4.01044f, 0.0159468f, 2.28142f, -4.01044f, 0.0159468f, 2.28142f, 
		-4.01038f, 0.447675f, 2.01037f, -4.01038f, 0.447675f, 2.01037f, 
		-4.00998f, 0.0412684f, 2.27254f, -4.00998f, 0.0412684f, 2.27254f, 
		-4.00998f, 0.0412684f, 2.27254f, -4.00998f, 0.0412684f, 2.27254f, 
		-4.00983f, 0.556078f, 1.86909f, -4.00963f, 0.0346529f, 2.31210f, 
		-4.00963f, 0.0346529f, 2.31210f, -4.00946f, 0.0114456f, 2.36005f, 
		-4.00946f, 0.0114456f, 2.36005f, -4.00946f, 0.0114456f, 2.36005f, 
		-4.00943f, -0.00533245f, 2.29627f, -4.00943f, -0.00533245f, 2.29627f, 
		-4.00943f, -0.00533245f, 2.29627f, -4.00943f, -0.00533245f, 2.29627f, 
		-4.00902f, 0.0310604f, 2.32801f, -4.00902f, 0.0310604f, 2.32801f, 
		-4.00868f, 0.000586000f, 2.29295f, -4.00868f, 0.000586000f, 2.29295f, 
		-4.00868f, 0.000586000f, 2.29295f, -4.00866f, 0.245162f, 1.75649f, 
		-4.00855f, 0.00841478f, 2.19286f, -4.00855f, 0.00841478f, 2.19286f, 
		-4.00855f, 0.00841478f, 2.19286f, -4.00855f, 0.00841478f, 2.19286f, 
		-4.00855f, 0.00841478f, 2.19286f, -4.00855f, 0.00841478f, 2.19286f, 
		-4.00842f, -0.00127375f, 2.27943f, -4.00842f, -0.00127375f, 2.27943f, 
		-4.00842f, -0.00127375f, 2.27943f, -4.00842f, -0.00127375f, 2.27943f, 
		-4.00842f, -0.00127375f, 2.27943f, -4.00836f, 0.0406107f, 2.15276f, 
		-4.00836f, 0.0406107f, 2.15276f, -4.00836f, 0.0406107f, 2.15276f, 
		-4.00836f, 0.0406107f, 2.15276f, -4.00836f, 0.0406107f, 2.15276f, 
		-4.00826f, 0.0376070f, 2.28662f, -4.00826f, 0.0376070f, 2.28662f, 
		-4.00826f, 0.0376070f, 2.28662f, -4.00826f, 0.0376070f, 2.28662f, 
		-4.00826f, 0.0376070f, 2.28662f, -4.00826f, -0.00247662f, 2.23184f, 
		-4.00826f, -0.00247662f, 2.23184f, -4.00826f, -0.00247662f, 2.23184f, 
		-4.00826f, -0.00247662f, 2.23184f, -4.00789f, 0.0153227f, 2.15123f, 
		-4.00789f, 0.0153227f, 2.15123f, -4.00789f, 0.0153227f, 2.15123f, 
		-4.00789f, 0.0153227f, 2.15123f, -4.00765f, 0.00911100f, 2.33629f, 
		-4.00765f, 0.00911100f, 2.33629f, -4.00765f, 0.00911100f, 2.33629f, 
		-4.00755f, 0.0507210f, 2.20977f, -4.00755f, -0.0229010f, 2.42565f, 
		-4.00755f, -0.0229010f, 2.42565f, -4.00755f, -0.0229010f, 2.42565f, 
		-4.00755f, -0.0229010f, 2.42565f, -4.00755f, -0.0229010f, 2.42565f, 
		-4.00719f, 0.00847674f, 2.28101f, -4.00719f, 0.00847674f, 2.28101f, 
		-4.00719f, 0.00847674f, 2.28101f, -4.00719f, 0.00847674f, 2.28101f, 
		-4.00719f, 0.00847674f, 2.28101f, -4.00680f, 0.00180447f, 2.20602f, 
		-4.00680f, 0.00180447f, 2.20602f, -4.00680f, 0.00180447f, 2.20602f, 
		-4.00680f, 0.00180447f, 2.20602f, -4.00673f, -0.00884123f, 2.31953f, 
		-4.00673f, -0.00884123f, 2.31953f, -4.00666f, 0.248281f, 1.81052f, 
		-4.00664f, 0.0366763f, 2.21019f, -4.00664f, 0.0366763f, 2.21019f, 
		-4.00664f, 0.0366763f, 2.21019f, -4.00664f, 0.0366763f, 2.21019f, 
		-4.00660f, 0.433918f, 1.61330f, -4.00653f, 0.00267909f, 2.34955f, 
		-4.00653f, 0.00267909f, 2.34955f, -4.00653f, 0.00267909f, 2.34955f, 
		-4.00653f, 0.00267909f, 2.34955f, -4.00653f, 0.00267909f, 2.34955f, 
		-4.00653f, 0.00267909f, 2.34955f, -4.00602f, 0.0374315f, 2.15725f, 
		-4.00602f, 0.0374315f, 2.15725f, -4.00602f, 0.0374315f, 2.15725f, 
		-4.00602f, 0.0374315f, 2.15725f, -4.00529f, 0.706386f, 1.74237f, 
		-4.00529f, 0.706386f, 1.74237f, -4.00522f, -0.0106576f, 2.33646f, 
		-4.00522f, -0.0106576f, 2.33646f, -4.00522f, -0.0106576f, 2.33646f, 
		-4.00522f, -0.0106576f, 2.33646f, -4.00520f, 0.452073f, 1.92625f, 
		-4.00495f, 0.364935f, 2.00338f, -4.00495f, 0.364935f, 2.00338f, 
		-4.00493f, 0.629401f, 1.61514f, -4.00417f, 0.270957f, 1.61162f, 
		-4.00417f, 0.270957f, 1.61162f, -4.00417f, 0.270957f, 1.61162f, 
		-4.00417f, 0.270957f, 1.61162f, -4.00417f, 0.270957f, 1.61162f, 
		-4.00417f, 0.270957f, 1.61162f, -4.00417f, 0.270957f, 1.61162f, 
		-4.00406f, 0.202255f, 1.65941f, -4.00406f, 0.202255f, 1.65941f, 
		-4.00406f, 0.202255f, 1.65941f, -4.00406f, 0.202255f, 1.65941f, 
		-4.00388f, 0.0300795f, 2.18571f, -4.00388f, 0.0300795f, 2.18571f, 
		-4.00388f, 0.0300795f, 2.18571f, -4.00388f, 0.0300795f, 2.18571f, 
		-4.00388f, 0.0300795f, 2.18571f, -4.00376f, -0.00911823f, 2.22995f, 
		-4.00376f, -0.00911823f, 2.22995f, -4.00376f, -0.00911823f, 2.22995f, 
		-4.00375f, -0.0132707f, 2.35328f, -4.00375f, -0.0132707f, 2.35328f, 
		-4.00375f, -0.0132707f, 2.35328f, -4.00375f, -0.0132707f, 2.35328f, 
		-4.00375f, -0.0132707f, 2.35328f, -4.00375f, -0.0132707f, 2.35328f, 
		-4.00322f, 0.297791f, 1.65816f, -4.00306f, 0.0193993f, 2.36321f, 
		-4.00306f, 0.0193993f, 2.36321f, -4.00306f, 0.0193993f, 2.36321f, 
		-4.00306f, 0.0193993f, 2.36321f, -4.00306f, 0.0193993f, 2.36321f, 
		-4.00286f, 0.0495016f, 2.16864f, -4.00267f, 0.250624f, 1.68242f, 
		-4.00267f, 0.250624f, 1.68242f, -4.00267f, 0.250624f, 1.68242f, 
		-4.00267f, 0.250624f, 1.68242f, -4.00267f, 0.250624f, 1.68242f, 
		-4.00267f, 0.250624f, 1.68242f, -4.00263f, 0.339416f, 1.59705f, 
		-4.00263f, 0.339416f, 1.59705f, -4.00263f, 0.339416f, 1.59705f, 
		-4.00239f, 0.0299303f, 2.26810f, -4.00239f, 0.0299303f, 2.26810f, 
		-4.00239f, 0.0299303f, 2.26810f, -4.00239f, 0.0299303f, 2.26810f, 
		-4.00239f, 0.0299303f, 2.26810f, -4.00233f, 0.0191728f, 2.17665f, 
		-4.00233f, 0.0191728f, 2.17665f, -4.00233f, 0.0191728f, 2.17665f, 
		-4.00233f, 0.0191728f, 2.17665f, -4.00233f, 0.0191728f, 2.17665f, 
		-4.00224f, 0.0257870f, 2.32390f, -4.00224f, 0.0257870f, 2.32390f, 
		-4.00224f, 0.0257870f, 2.32390f, -4.00224f, 0.0257870f, 2.32390f, 
		-4.00212f, 0.488190f, 1.54391f, -4.00212f, 0.488190f, 1.54391f, 
		-4.00208f, 0.0537540f, 2.19445f, -4.00208f, 0.0537540f, 2.19445f, 
		-4.00208f, 0.0537540f, 2.19445f, -4.00208f, 0.0537540f, 2.19445f, 
		-4.00174f, 0.0237779f, 2.27559f, -4.00174f, 0.0237779f, 2.27559f, 
		-4.00174f, 0.0237779f, 2.27559f, -4.00174f, 0.0237779f, 2.27559f, 
		-4.00160f, 0.710545f, 1.75888f, -4.00160f, 0.710545f, 1.75888f, 
		-4.00144f, -0.00330062f, 2.27096f, -4.00144f, -0.00330062f, 2.27096f, 
		-4.00144f, -0.00330062f, 2.27096f, -4.00144f, -0.00330062f, 2.27096f, 
		-4.00144f, -0.00330062f, 2.27096f, -4.00078f, -0.00545200f, 2.33416f, 
		-4.00078f, -0.00545200f, 2.33416f, -4.00078f, -0.00545200f, 2.33416f, 
		-4.00017f, -0.00724300f, 2.22379f, -4.00017f, -0.00724300f, 2.22379f, 
		-4.00017f, -0.00724300f, 2.22379f, -4.00000f, -0.00164966f, 2.27848f, 
		-4.00000f, -0.00164966f, 2.27848f, -4.00000f, -0.00164966f, 2.27848f, 
		-4.00000f, -0.00164966f, 2.27848f, -4.00000f, -0.00164966f, 2.27848f, 
		-3.99996f, 0.0104137f, 2.17584f, -3.99996f, 0.0104137f, 2.17584f, 
		-3.99996f, 0.0104137f, 2.17584f, -3.99996f, 0.0104137f, 2.17584f, 
		-3.99980f, -0.0111858f, 2.34355f, -3.99980f, -0.0111858f, 2.34355f, 
		-3.99980f, -0.0111858f, 2.34355f, -3.99980f, -0.0111858f, 2.34355f, 
		-3.99980f, -0.0111858f, 2.34355f, -3.99980f, -0.0111858f, 2.34355f, 
		-3.99965f, 0.0283862f, 2.17644f, -3.99965f, 0.0283862f, 2.17644f, 
		-3.99965f, 0.0283862f, 2.17644f, -3.99965f, 0.0283862f, 2.17644f, 
		-3.99963f, 0.0186819f, 2.27989f, -3.99963f, 0.0186819f, 2.27989f, 
		-3.99963f, 0.0186819f, 2.27989f, -3.99963f, 0.0186819f, 2.27989f, 
		-3.99963f, 0.0186819f, 2.27989f, -3.99963f, 0.0186819f, 2.27989f, 
		-3.99963f, 0.0186819f, 2.27989f, -3.99963f, 0.0186819f, 2.27989f, 
		-3.99963f, 0.0186819f, 2.27989f, -3.99941f, -0.0434940f, 2.41428f, 
		-3.99941f, -0.0434940f, 2.41428f, -3.99941f, -0.0434940f, 2.41428f, 
		-3.99941f, -0.0434940f, 2.41428f, -3.99900f, 0.0143607f, 2.35237f, 
		-3.99900f, 0.0143607f, 2.35237f, -3.99900f, 0.0143607f, 2.35237f, 
		-3.99900f, 0.0143607f, 2.35237f, -3.99898f, 0.235649f, 1.70443f, 
		-3.99897f, 0.398344f, 1.55552f, -3.99897f, 0.398344f, 1.55552f, 
		-3.99897f, 0.398344f, 1.55552f, -3.99857f, 0.576663f, 1.64063f, 
		-3.99855f, 0.00135200f, 2.41978f, -3.99855f, 0.00135200f, 2.41978f, 
		-3.99855f, 0.00135200f, 2.41978f, -3.99855f, 0.00135200f, 2.41978f, 
		-3.99832f, 0.00749203f, 2.28580f, -3.99832f, 0.00749203f, 2.28580f, 
		-3.99832f, 0.00749203f, 2.28580f, -3.99832f, 0.00749203f, 2.28580f, 
		-3.99808f, 0.370498f, 1.92534f, -3.99773f, 0.0249270f, 2.13305f, 
		-3.99773f, 0.0249270f, 2.13305f, -3.99773f, 0.0249270f, 2.13305f, 
		-3.99773f, 0.0249270f, 2.13305f, -3.99731f, -0.00731114f, 2.23419f, 
		-3.99731f, -0.00731114f, 2.23419f, -3.99731f, -0.00731114f, 2.23419f, 
		-3.99731f, -0.00731114f, 2.23419f, -3.99731f, -0.00731114f, 2.23419f, 
		-3.99669f, 0.623611f, 1.73630f, -3.99659f, 0.336662f, 1.57788f, 
		-3.99659f, 0.336662f, 1.57788f, -3.99537f, 0.00852439f, 2.15343f, 
		-3.99537f, 0.00852439f, 2.15343f, -3.99508f, 0.0427910f, 2.13307f, 
		-3.99508f, 0.0427910f, 2.13307f, -3.99508f, 0.0427910f, 2.13307f, 
		-3.99477f, 0.245628f, 1.86227f, -3.99464f, 0.0395512f, 2.20695f, 
		-3.99464f, 0.0395512f, 2.20695f, -3.99464f, 0.0395512f, 2.20695f, 
		-3.99446f, 0.725642f, 1.78831f, -3.99446f, 0.725642f, 1.78831f, 
		-3.99445f, -0.00862171f, 2.32944f, -3.99445f, -0.00862171f, 2.32944f, 
		-3.99445f, -0.00862171f, 2.32944f, -3.99445f, -0.00862171f, 2.32944f, 
		-3.99439f, 0.00105716f, 2.33389f, -3.99439f, 0.00105716f, 2.33389f, 
		-3.99439f, 0.00105716f, 2.33389f, -3.99439f, 0.00105716f, 2.33389f, 
		-3.99439f, 0.00105716f, 2.33389f, -3.99437f, -0.00330234f, 2.29652f, 
		-3.99437f, -0.00330234f, 2.29652f, -3.99437f, -0.00330234f, 2.29652f, 
		-3.99426f, 0.0449560f, 2.30310f, -3.99274f, 0.328864f, 1.62657f, 
		-3.99213f, -0.0226019f, 2.34211f, -3.99213f, -0.0226019f, 2.34211f, 
		-3.99213f, -0.0226019f, 2.34211f, -3.99168f, -0.00653007f, 2.31551f, 
		-3.99168f, -0.00653007f, 2.31551f, -3.99168f, -0.00653007f, 2.31551f, 
		-3.99168f, -0.00653007f, 2.31551f, -3.99157f, -0.0119605f, 2.31586f, 
		-3.99157f, -0.0119605f, 2.31586f, -3.99157f, -0.0119605f, 2.31586f, 
		-3.99157f, -0.0119605f, 2.31586f, -3.99157f, -0.0119605f, 2.31586f, 
		-3.99146f, -0.00828940f, 2.29404f, -3.99128f, 0.0511683f, 2.27625f, 
		-3.99128f, 0.0511683f, 2.27625f, -3.99128f, 0.0511683f, 2.27625f, 
		-3.99128f, 0.0511683f, 2.27625f, -3.99125f, 0.224955f, 1.64040f, 
		-3.99125f, 0.224955f, 1.64040f, -3.99125f, 0.224955f, 1.64040f, 
		-3.99125f, 0.224955f, 1.64040f, -3.99125f, 0.224955f, 1.64040f, 
		-3.99125f, 0.224955f, 1.64040f, -3.99125f, 0.224955f, 1.64040f, 
		-3.99125f, 0.224955f, 1.64040f, -3.99027f, 0.00175728f, 2.31482f, 
		-3.99027f, 0.00175728f, 2.31482f, -3.99027f, 0.00175728f, 2.31482f, 
		-3.98980f, -0.0117416f, 2.34341f, -3.98980f, -0.0117416f, 2.34341f, 
		-3.98980f, -0.0117416f, 2.34341f, -3.98980f, -0.0117416f, 2.34341f, 
		-3.98966f, 0.0476916f, 2.27181f, -3.98966f, 0.0476916f, 2.27181f, 
		-3.98966f, 0.0476916f, 2.27181f, -3.98966f, 0.0476916f, 2.27181f, 
		-3.98951f, 0.00996900f, 2.16071f, -3.98951f, 0.00996900f, 2.16071f, 
		-3.98951f, 0.00996900f, 2.16071f, -3.98951f, 0.00996900f, 2.16071f, 
		-3.98951f, 0.00996900f, 2.16071f, -3.98951f, 0.00996900f, 2.16071f, 
		-3.98928f, 0.0124903f, 2.29756f, -3.98928f, 0.0124903f, 2.29756f, 
		-3.98928f, 0.0124903f, 2.29756f, -3.98928f, 0.0124903f, 2.29756f, 
		-3.98915f, 0.348328f, 1.58847f, -3.98915f, 0.348328f, 1.58847f, 
		-3.98883f, -0.00530400f, 2.28819f, -3.98883f, -0.00530400f, 2.28819f, 
		-3.98883f, -0.00530400f, 2.28819f, -3.98883f, -0.00530400f, 2.28819f, 
		-3.98883f, -0.00530400f, 2.28819f, -3.98883f, 0.00119686f, 2.17278f, 
		-3.98883f, 0.00119686f, 2.17278f, -3.98873f, 0.0485160f, 2.28232f, 
		-3.98873f, 0.0485160f, 2.28232f, -3.98873f, 0.0485160f, 2.28232f, 
		-3.98857f, -0.00768368f, 2.27839f, -3.98854f, 0.0534288f, 2.15416f, 
		-3.98854f, 0.0534288f, 2.15416f, -3.98854f, 0.0534288f, 2.15416f, 
		-3.98854f, 0.0534288f, 2.15416f, -3.98854f, 0.0534288f, 2.15416f, 
		-3.98854f, 0.0534288f, 2.15416f, -3.98854f, 0.0534288f, 2.15416f, 
		-3.98838f, -0.0123257f, 2.32825f, -3.98838f, -0.0123257f, 2.32825f, 
		-3.98838f, -0.0123257f, 2.32825f, -3.98838f, -0.0123257f, 2.32825f, 
		-3.98838f, -0.0123257f, 2.32825f, -3.98817f, -0.0403220f, 2.45053f, 
		-3.98817f, -0.0403220f, 2.45053f, -3.98817f, -0.0403220f, 2.45053f, 
		-3.98817f, -0.0403220f, 2.45053f, -3.98817f, -0.0403220f, 2.45053f, 
		-3.98817f, -0.0403220f, 2.45053f, -3.98806f, 0.0356614f, 2.34326f, 
		-3.98805f, 0.000687042f, 2.17808f, -3.98805f, 0.000687042f, 2.17808f, 
		-3.98805f, 0.000687042f, 2.17808f, -3.98805f, 0.000687042f, 2.17808f, 
		-3.98752f, 0.0496079f, 2.15860f, -3.98752f, 0.0496079f, 2.15860f, 
		-3.98752f, 0.0496079f, 2.15860f, -3.98752f, 0.0496079f, 2.15860f, 
		-3.98740f, 0.0522520f, 2.16804f, -3.98740f, 0.0522520f, 2.16804f, 
		-3.98740f, 0.0522520f, 2.16804f, -3.98740f, 0.0522520f, 2.16804f, 
		-3.98739f, 0.0551203f, 2.17761f, -3.98739f, 0.0551203f, 2.17761f, 
		-3.98739f, 0.0551203f, 2.17761f, -3.98739f, 0.0551203f, 2.17761f, 
		-3.98733f, 0.0425132f, 2.31499f, -3.98733f, 0.299571f, 1.61358f, 
		-3.98733f, 0.299571f, 1.61358f, -3.98733f, 0.299571f, 1.61358f, 
		-3.98733f, 0.299571f, 1.61358f, -3.98733f, 0.299571f, 1.61358f, 
		-3.98733f, 0.299571f, 1.61358f, -3.98733f, 0.299571f, 1.61358f, 
		-3.98733f, 0.299571f, 1.61358f, -3.98711f, 0.0239830f, 2.36273f, 
		-3.98711f, 0.0239830f, 2.36273f, -3.98711f, 0.0239830f, 2.36273f, 
		-3.98705f, 0.0323330f, 2.31847f, -3.98705f, 0.0323330f, 2.31847f, 
		-3.98705f, 0.0323330f, 2.31847f, -3.98675f, -0.0188287f, 2.34351f, 
		-3.98675f, -0.0188287f, 2.34351f, -3.98675f, -0.0188287f, 2.34351f, 
		-3.98675f, -0.0188287f, 2.34351f, -3.98660f, 0.00328076f, 2.33318f, 
		-3.98660f, 0.00328076f, 2.33318f, -3.98660f, 0.00328076f, 2.33318f, 
		-3.98660f, 0.00328076f, 2.33318f, -3.98660f, 0.00328076f, 2.33318f, 
		-3.98660f, 0.00328076f, 2.33318f, -3.98658f, 0.264748f, 1.65632f, 
		-3.98658f, 0.264748f, 1.65632f, -3.98658f, 0.264748f, 1.65632f, 
		-3.98658f, 0.264748f, 1.65632f, -3.98655f, 0.00113666f, 2.19201f, 
		-3.98655f, 0.00113666f, 2.19201f, -3.98655f, 0.00113666f, 2.19201f, 
		-3.98655f, 0.00113666f, 2.19201f, -3.98642f, -0.00713531f, 2.28020f, 
		-3.98642f, -0.00713531f, 2.28020f, -3.98642f, -0.00713531f, 2.28020f, 
		-3.98642f, -0.00713531f, 2.28020f, -3.98642f, -0.00713531f, 2.28020f, 
		-3.98636f, 0.00630395f, 2.15647f, -3.98636f, 0.00630395f, 2.15647f, 
		-3.98636f, 0.00630395f, 2.15647f, -3.98634f, 0.336617f, 1.58679f, 
		-3.98634f, 0.336617f, 1.58679f, -3.98613f, 0.735096f, 1.81448f, 
		-3.98613f, 0.735096f, 1.81448f, -3.98606f, 0.215356f, 1.88295f, 
		-3.98583f, 0.0369503f, 2.26733f, -3.98583f, 0.0369503f, 2.26733f, 
		-3.98583f, 0.0369503f, 2.26733f, -3.98583f, 0.0369503f, 2.26733f, 
		-3.98577f, 0.0305578f, 2.27956f, -3.98577f, 0.0305578f, 2.27956f, 
		-3.98577f, 0.0305578f, 2.27956f, -3.98577f, 0.0305578f, 2.27956f, 
		-3.98577f, 0.0305578f, 2.27956f, -3.98577f, 0.0305578f, 2.27956f, 
		-3.98577f, 0.0305578f, 2.27956f, -3.98577f, 0.0305578f, 2.27956f, 
		-3.98530f, 0.263886f, 1.63854f, -3.98530f, 0.263886f, 1.63854f, 
		-3.98530f, 0.263886f, 1.63854f, -3.98530f, 0.263886f, 1.63854f, 
		-3.98522f, -0.00656749f, 2.27108f, -3.98522f, -0.00656749f, 2.27108f, 
		-3.98522f, -0.00656749f, 2.27108f, -3.98522f, -0.00656749f, 2.27108f, 
		-3.98497f, 0.00450301f, 2.18213f, -3.98497f, 0.00450301f, 2.18213f, 
		-3.98497f, 0.00450301f, 2.18213f, -3.98497f, 0.00450301f, 2.18213f, 
		-3.98497f, 0.00450301f, 2.18213f, -3.98497f, 0.00450301f, 2.18213f, 
		-3.98497f, 0.00450301f, 2.18213f, -3.98497f, 0.00450301f, 2.18213f, 
		-3.98477f, 0.0157936f, 2.35083f, -3.98477f, 0.0157936f, 2.35083f, 
		-3.98477f, 0.0157936f, 2.35083f, -3.98477f, 0.0157936f, 2.35083f, 
		-3.98475f, -0.00973546f, 2.23360f, -3.98475f, -0.00973546f, 2.23360f, 
		-3.98475f, -0.00973546f, 2.23360f, -3.98470f, 0.317515f, 1.65041f, 
		-3.98470f, 0.317515f, 1.65041f, -3.98428f, -0.0263051f, 2.34052f, 
		-3.98428f, -0.0263051f, 2.34052f, -3.98428f, -0.0263051f, 2.34052f, 
		-3.98428f, -0.0263051f, 2.34052f, -3.98426f, 0.0372283f, 2.17873f, 
		-3.98426f, 0.0372283f, 2.17873f, -3.98426f, 0.0372283f, 2.17873f, 
		-3.98426f, 0.0372283f, 2.17873f, -3.98426f, 0.0372283f, 2.17873f, 
		-3.98426f, 0.0372283f, 2.17873f, -3.98395f, -0.0168270f, 2.34840f, 
		-3.98395f, -0.0168270f, 2.34840f, -3.98395f, -0.0168270f, 2.34840f, 
		-3.98395f, -0.0168270f, 2.34840f, -3.98395f, -0.0168270f, 2.34840f, 
		-3.98382f, -0.00971506f, 2.30168f, -3.98382f, -0.00971506f, 2.30168f, 
		-3.98382f, -0.00971506f, 2.30168f, -3.98382f, -0.00971506f, 2.30168f, 
		-3.98382f, -0.00971506f, 2.30168f, -3.98371f, 0.332291f, 1.57650f, 
		-3.98371f, 0.332291f, 1.57650f, -3.98367f, -0.0123305f, 2.22850f, 
		-3.98367f, -0.0123305f, 2.22850f, -3.98367f, -0.0123305f, 2.22850f, 
		-3.98326f, 0.0400458f, 2.19494f, -3.98326f, 0.0400458f, 2.19494f, 
		-3.98326f, 0.0400458f, 2.19494f, -3.98326f, 0.0400458f, 2.19494f, 
		-3.98326f, 0.0400458f, 2.19494f, -3.98317f, 0.00803459f, 2.30758f, 
		-3.98317f, 0.00803459f, 2.30758f, -3.98317f, 0.00803459f, 2.30758f, 
		-3.98317f, 0.00803459f, 2.30758f, -3.98317f, 0.00803459f, 2.30758f, 
		-3.98317f, 0.00803459f, 2.30758f, -3.98290f, -0.0215510f, 2.45503f, 
		-3.98290f, -0.0215510f, 2.45503f, -3.98290f, -0.0215510f, 2.45503f, 
		-3.98290f, -0.0215510f, 2.45503f, -3.98261f, 0.312817f, 1.59134f, 
		-3.98261f, 0.312817f, 1.59134f, -3.98237f, 0.311571f, 1.58159f, 
		-3.98237f, 0.311571f, 1.58159f, -3.98201f, -0.0144123f, 2.32039f, 
		-3.98201f, -0.0144123f, 2.32039f, -3.98201f, -0.0144123f, 2.32039f, 
		-3.98201f, -0.0144123f, 2.32039f, -3.98168f, 0.238116f, 1.66298f, 
		-3.98151f, 0.00467873f, 2.33595f, -3.98151f, 0.00467873f, 2.33595f, 
		-3.98140f, 0.552459f, 1.92034f, -3.98119f, 0.345758f, 1.60536f, 
		-3.98117f, 0.298753f, 1.92163f, -3.98116f, 0.342489f, 1.57742f, 
		-3.98116f, 0.342489f, 1.57742f, -3.98116f, 0.342489f, 1.57742f, 
		-3.98116f, 0.342489f, 1.57742f, -3.98026f, 0.506283f, 1.59194f, 
		-3.97953f, 0.380939f, 1.59772f, -3.97903f, 0.00719400f, 2.42661f, 
		-3.97903f, 0.00719400f, 2.42661f, -3.97903f, 0.00719400f, 2.42661f, 
		-3.97869f, 0.0523685f, 2.16644f, -3.97803f, 0.216382f, 1.78964f, 
		-3.97760f, 0.248618f, 1.63761f, -3.97760f, 0.248618f, 1.63761f, 
		-3.97760f, 0.248618f, 1.63761f, -3.97760f, 0.248618f, 1.63761f, 
		-3.97759f, 0.275217f, 1.85976f, -3.97759f, 0.275217f, 1.85976f, 
		-3.97759f, 0.275217f, 1.85976f, -3.97662f, -0.0530190f, 2.41902f, 
		-3.97662f, -0.0530190f, 2.41902f, -3.97662f, -0.0530190f, 2.41902f, 
		-3.97662f, -0.0530190f, 2.41902f, -3.97662f, -0.0530190f, 2.41902f, 
		-3.97659f, 0.0119190f, 2.11610f, -3.97659f, 0.0119190f, 2.11610f, 
		-3.97648f, 0.319013f, 1.61219f, -3.97635f, 0.179131f, 1.77200f, 
		-3.97635f, 0.179131f, 1.77200f, -3.97635f, 0.179131f, 1.77200f, 
		-3.97635f, 0.179131f, 1.77200f, -3.97635f, 0.179131f, 1.77200f, 
		-3.97617f, 0.351646f, 1.57845f, -3.97617f, 0.351646f, 1.57845f, 
		-3.97613f, -0.00666879f, 2.27451f, -3.97609f, 0.215129f, 1.70264f, 
		-3.97609f, 0.215129f, 1.70264f, -3.97609f, 0.215129f, 1.70264f, 
		-3.97609f, 0.215129f, 1.70264f, -3.97609f, 0.215129f, 1.70264f, 
		-3.97609f, 0.215129f, 1.70264f, -3.97575f, 0.00423643f, 2.31963f, 
		-3.97575f, 0.00423643f, 2.31963f, -3.97575f, 0.00423643f, 2.31963f, 
		-3.97575f, 0.00423643f, 2.31963f, -3.97575f, 0.00423643f, 2.31963f, 
		-3.97575f, 0.00423643f, 2.31963f, -3.97557f, 0.286526f, 1.64836f, 
		-3.97557f, 0.286526f, 1.64836f, -3.97557f, 0.286526f, 1.64836f, 
		-3.97557f, 0.286526f, 1.64836f, -3.97550f, 0.336082f, 1.59431f, 
		-3.97550f, 0.336082f, 1.59431f, -3.97541f, 0.644374f, 1.78838f, 
		-3.97514f, 0.0151811f, 2.29522f, -3.97514f, 0.0151811f, 2.29522f, 
		-3.97514f, 0.0151811f, 2.29522f, -3.97514f, 0.0151811f, 2.29522f, 
		-3.97493f, 0.336081f, 1.87782f, -3.97489f, 0.566293f, 1.55227f, 
		-3.97444f, 0.00598237f, 2.33233f, -3.97444f, 0.00598237f, 2.33233f, 
		-3.97444f, 0.00598237f, 2.33233f, -3.97444f, 0.00598237f, 2.33233f, 
		-3.97444f, 0.00598237f, 2.33233f, -3.97444f, 0.00598237f, 2.33233f, 
		-3.97444f, 0.00598237f, 2.33233f, -3.97415f, 0.397966f, 1.54353f, 
		-3.97415f, 0.397966f, 1.54353f, -3.97415f, 0.397966f, 1.54353f, 
		-3.97415f, 0.397966f, 1.54353f, -3.97415f, 0.397966f, 1.54353f, 
		-3.97408f, 0.0454878f, 2.28028f, -3.97408f, 0.0454878f, 2.28028f, 
		-3.97408f, 0.0454878f, 2.28028f, -3.97408f, 0.0454878f, 2.28028f, 
		-3.97408f, 0.0454878f, 2.28028f, -3.97408f, 0.0454878f, 2.28028f, 
		-3.97369f, 0.260171f, 1.65238f, -3.97369f, 0.260171f, 1.65238f, 
		-3.97369f, 0.260171f, 1.65238f, -3.97369f, 0.260171f, 1.65238f, 
		-3.97358f, -0.00178772f, 2.29573f, -3.97358f, -0.00178772f, 2.29573f, 
		-3.97358f, -0.00178772f, 2.29573f, -3.97358f, -0.00178772f, 2.29573f, 
		-3.97347f, 0.337358f, 1.59108f, -3.97347f, 0.337358f, 1.59108f, 
		-3.97347f, 0.337358f, 1.59108f, -3.97347f, 0.337358f, 1.59108f, 
		-3.97347f, 0.337358f, 1.59108f, -3.97347f, 0.337358f, 1.59108f, 
		-3.97347f, 0.346612f, 1.56897f, -3.97347f, 0.346612f, 1.56897f, 
		-3.97323f, -0.00197724f, 2.28090f, -3.97323f, -0.00197724f, 2.28090f, 
		-3.97323f, -0.00197724f, 2.28090f, -3.97323f, -0.00197724f, 2.28090f, 
		-3.97323f, -0.00197724f, 2.28090f, -3.97323f, -0.00197724f, 2.28090f, 
		-3.97312f, -5.90000e-005f, 2.00614f, -3.97312f, -5.90000e-005f, 2.00614f, 
		-3.97312f, -5.90000e-005f, 2.00614f, -3.97300f, 0.00207000f, 2.29422f, 
		-3.97300f, 0.00207000f, 2.29422f, -3.97300f, 0.00207000f, 2.29422f, 
		-3.97300f, 0.00207000f, 2.29422f, -3.97300f, 0.00207000f, 2.29422f, 
		-3.97300f, 0.00207000f, 2.29422f, -3.97275f, -0.00213800f, 2.00659f, 
		-3.97275f, -0.00213800f, 2.00659f, -3.97275f, -0.00213800f, 2.00659f, 
		-3.97270f, -0.00249024f, 2.29362f, -3.97270f, -0.00249024f, 2.29362f, 
		-3.97270f, -0.00249024f, 2.29362f, -3.97270f, -0.00249024f, 2.29362f, 
		-3.97270f, -0.00249024f, 2.29362f, -3.97233f, -0.00636517f, 2.34159f, 
		-3.97233f, -0.00636517f, 2.34159f, -3.97233f, -0.00636517f, 2.34159f, 
		-3.97233f, -0.00636517f, 2.34159f, -3.97233f, -0.00636517f, 2.34159f, 
		-3.97233f, -0.00636517f, 2.34159f, -3.97233f, -0.00636517f, 2.34159f, 
		-3.97233f, -0.00636517f, 2.34159f, -3.97228f, 0.0325100f, 2.02284f, 
		-3.97228f, 0.0325100f, 2.02284f, -3.97228f, 0.0325100f, 2.02284f, 
		-3.97228f, 0.0325100f, 2.02284f, -3.97228f, 0.0325100f, 2.02284f, 
		-3.97228f, 0.0325100f, 2.02284f, -3.97201f, 0.0560118f, 2.19408f, 
		-3.97201f, 0.0560118f, 2.19408f, -3.97201f, 0.0560118f, 2.19408f, 
		-3.97201f, 0.0560118f, 2.19408f, -3.97200f, 0.0143673f, 2.34821f, 
		-3.97200f, 0.0143673f, 2.34821f, -3.97200f, 0.0143673f, 2.34821f, 
		-3.97200f, 0.0143673f, 2.34821f, -3.97179f, 0.0415477f, 2.20632f, 
		-3.97179f, 0.0415477f, 2.20632f, -3.97179f, 0.0415477f, 2.20632f, 
		-3.97179f, 0.0415477f, 2.20632f, -3.97172f, 0.00902130f, 2.29707f, 
		-3.97172f, 0.00902130f, 2.29707f, -3.97172f, 0.00902130f, 2.29707f, 
		-3.97172f, 0.00902130f, 2.29707f, -3.97172f, 0.00902130f, 2.29707f, 
		-3.97172f, 0.00902130f, 2.29707f, -3.97164f, 0.197374f, 1.80946f, 
		-3.97141f, 0.322869f, 1.57378f, -3.97141f, 0.322869f, 1.57378f, 
		-3.97131f, 0.0376450f, 2.28922f, -3.97131f, 0.0376450f, 2.28922f, 
		-3.97131f, 0.0376450f, 2.28922f, -3.97131f, 0.0376450f, 2.28922f, 
		-3.97114f, 0.0371692f, 2.19273f, -3.97105f, 0.0259980f, 2.32342f, 
		-3.97105f, 0.0259980f, 2.32342f, -3.97093f, -0.0110163f, 2.23209f, 
		-3.97093f, -0.0110163f, 2.23209f, -3.97093f, -0.0110163f, 2.23209f, 
		-3.97084f, 0.0488450f, 2.02464f, -3.97071f, 0.0173920f, 2.16102f, 
		-3.97071f, 0.0173920f, 2.16102f, -3.97071f, 0.0173920f, 2.16102f, 
		-3.97071f, 0.0173920f, 2.16102f, -3.97071f, 0.0173920f, 2.16102f, 
		-3.97069f, 0.360179f, 1.59121f, -3.97063f, 0.0136029f, 2.17657f, 
		-3.97063f, 0.0136029f, 2.17657f, -3.97063f, 0.0136029f, 2.17657f, 
		-3.97063f, 0.0136029f, 2.17657f, -3.97054f, 0.0214762f, 2.28031f, 
		-3.97054f, 0.0214762f, 2.28031f, -3.97054f, 0.0214762f, 2.28031f, 
		-3.97054f, 0.0214762f, 2.28031f, -3.97054f, 0.0214762f, 2.28031f, 
		-3.97054f, 0.0214762f, 2.28031f, -3.97054f, 0.0214762f, 2.28031f, 
		-3.97015f, 0.0309947f, 2.17733f, -3.97015f, 0.0309947f, 2.17733f, 
		-3.97015f, 0.0309947f, 2.17733f, -3.97015f, 0.0309947f, 2.17733f, 
		-3.97015f, 0.0309947f, 2.17733f, -3.96993f, 0.307277f, 1.57903f, 
		-3.96993f, 0.307277f, 1.57903f, -3.96990f, 0.00399619f, 2.31502f, 
		-3.96990f, 0.00399619f, 2.31502f, -3.96990f, 0.00399619f, 2.31502f, 
		-3.96990f, 0.00399619f, 2.31502f, -3.96987f, -0.00866052f, 2.31930f, 
		-3.96987f, -0.00866052f, 2.31930f, -3.96987f, -0.00866052f, 2.31930f, 
		-3.96987f, -0.00866052f, 2.31930f, -3.96987f, -0.00866052f, 2.31930f, 
		-3.96987f, -0.00866052f, 2.31930f, -3.96971f, 0.00913382f, 2.28255f, 
		-3.96971f, 0.00913382f, 2.28255f, -3.96971f, 0.00913382f, 2.28255f, 
		-3.96971f, 0.00913382f, 2.28255f, -3.96930f, -0.0134317f, 2.22650f, 
		-3.96930f, -0.0134317f, 2.22650f, -3.96930f, -0.0134317f, 2.22650f, 
		-3.96924f, 0.0179900f, 2.29931f, -3.96924f, 0.0179900f, 2.29931f, 
		-3.96920f, 0.0210727f, 2.36008f, -3.96920f, 0.0210727f, 2.36008f, 
		-3.96920f, 0.0210727f, 2.36008f, -3.96920f, 0.0210727f, 2.36008f, 
		-3.96910f, 0.0322537f, 2.27017f, -3.96910f, 0.0322537f, 2.27017f, 
		-3.96910f, 0.0322537f, 2.27017f, -3.96910f, 0.0322537f, 2.27017f, 
		-3.96910f, 0.0334781f, 2.30049f, -3.96910f, 0.0334781f, 2.30049f, 
		-3.96910f, 0.0334781f, 2.30049f, -3.96910f, 0.0334781f, 2.30049f, 
		-3.96910f, 0.0334781f, 2.30049f, -3.96910f, 0.0334781f, 2.30049f, 
		-3.96901f, 0.285439f, 1.59026f, -3.96901f, 0.285439f, 1.59026f, 
		-3.96901f, 0.285439f, 1.59026f, -3.96901f, 0.285439f, 1.59026f, 
		-3.96886f, -0.00399988f, 2.31493f, -3.96886f, -0.00399988f, 2.31493f, 
		-3.96886f, -0.00399988f, 2.31493f, -3.96886f, -0.00399988f, 2.31493f, 
		-3.96875f, -0.00665129f, 2.26158f, -3.96875f, -0.00665129f, 2.26158f, 
		-3.96875f, -0.00665129f, 2.26158f, -3.96868f, 0.0414823f, 2.27560f, 
		-3.96868f, 0.0414823f, 2.27560f, -3.96868f, 0.0414823f, 2.27560f, 
		-3.96868f, 0.0414823f, 2.27560f, -3.96868f, 0.0414823f, 2.27560f, 
		-3.96857f, 0.284509f, 1.59986f, -3.96857f, 0.284509f, 1.59986f, 
		-3.96843f, 0.0265681f, 2.27573f, -3.96843f, 0.0265681f, 2.27573f, 
		-3.96843f, 0.0265681f, 2.27573f, -3.96843f, 0.0265681f, 2.27573f, 
		-3.96843f, 0.0265681f, 2.27573f, -3.96811f, 0.0427720f, 2.15311f, 
		-3.96811f, 0.0427720f, 2.15311f, -3.96811f, 0.0427720f, 2.15311f, 
		-3.96811f, 0.0427720f, 2.15311f, -3.96811f, 0.0427720f, 2.15311f, 
		-3.96811f, 0.0427720f, 2.15311f, -3.96806f, 0.374298f, 1.56384f, 
		-3.96806f, 0.374298f, 1.56384f, -3.96806f, 0.374298f, 1.56384f, 
		-3.96806f, 0.374298f, 1.56384f, -3.96806f, 0.374298f, 1.56384f, 
		-3.96792f, 0.313464f, 1.59988f, -3.96792f, 0.313464f, 1.59988f, 
		-3.96788f, 0.0219736f, 2.17957f, -3.96788f, 0.0219736f, 2.17957f, 
		-3.96788f, 0.0219736f, 2.17957f, -3.96788f, 0.0219736f, 2.17957f, 
		-3.96788f, 0.0219736f, 2.17957f, -3.96788f, 0.0219736f, 2.17957f, 
		-3.96783f, 0.00209905f, 2.32673f, -3.96783f, 0.00209905f, 2.32673f, 
		-3.96783f, 0.00209905f, 2.32673f, -3.96783f, 0.00209905f, 2.32673f, 
		-3.96776f, 0.0381718f, 2.29159f, -3.96776f, 0.0381718f, 2.29159f, 
		-3.96776f, 0.0381718f, 2.29159f, -3.96768f, 0.349555f, 1.58484f, 
		-3.96768f, 0.349555f, 1.58484f, -3.96752f, -0.0116392f, 2.34544f, 
		-3.96752f, -0.0116392f, 2.34544f, -3.96752f, -0.0116392f, 2.34544f, 
		-3.96752f, -0.0116392f, 2.34544f, -3.96752f, -0.0116392f, 2.34544f, 
		-3.96749f, 0.439109f, 2.04492f, -3.96746f, 0.00175500f, 2.18729f, 
		-3.96742f, 0.0187086f, 2.15256f, -3.96742f, 0.0187086f, 2.15256f, 
		-3.96742f, 0.0187086f, 2.15256f, -3.96742f, 0.0187086f, 2.15256f, 
		-3.96742f, 0.0187086f, 2.15256f, -3.96742f, 0.0187086f, 2.15256f, 
		-3.96727f, 0.230922f, 1.62711f, -3.96727f, 0.230922f, 1.62711f, 
		-3.96727f, 0.230922f, 1.62711f, -3.96727f, 0.230922f, 1.62711f, 
		-3.96727f, 0.230922f, 1.62711f, -3.96717f, 0.000200931f, 2.27855f, 
		-3.96717f, 0.000200931f, 2.27855f, -3.96717f, 0.000200931f, 2.27855f, 
		-3.96717f, 0.000200931f, 2.27855f, -3.96717f, 0.000200931f, 2.27855f, 
		-3.96717f, 0.000200931f, 2.27855f, -3.96702f, 0.360296f, 1.60849f, 
		-3.96702f, 0.360296f, 1.60849f, -3.96702f, 0.360296f, 1.60849f, 
		-3.96702f, 0.360296f, 1.60849f, -3.96702f, 0.360296f, 1.60849f, 
		-3.96702f, 0.360296f, 1.60849f, -3.96683f, 0.321229f, 1.57897f, 
		-3.96683f, 0.321229f, 1.57897f, -3.96675f, -0.00291544f, 2.27343f, 
		-3.96675f, -0.00291544f, 2.27343f, -3.96675f, -0.00291544f, 2.27343f, 
		-3.96675f, -0.00291544f, 2.27343f, -3.96654f, 0.0567220f, 2.10987f, 
		-3.96654f, 0.0567220f, 2.10987f, -3.96652f, 0.0348230f, 2.16042f, 
		-3.96652f, 0.0348230f, 2.16042f, -3.96652f, 0.0348230f, 2.16042f, 
		-3.96652f, 0.0348230f, 2.16042f, -3.96652f, 0.0348230f, 2.16042f, 
		-3.96652f, 0.0348230f, 2.16042f, -3.96652f, 0.0348230f, 2.16042f, 
		-3.96628f, 0.629956f, 1.66977f, -3.96626f, 0.00774100f, 2.06641f, 
		-3.96626f, 0.00774100f, 2.06641f, -3.96626f, 0.00774100f, 2.06641f, 
		-3.96626f, 0.00774100f, 2.06641f, -3.96626f, 0.00774100f, 2.06641f, 
		-3.96610f, 0.0114406f, 2.18481f, -3.96610f, 0.0114406f, 2.18481f, 
		-3.96610f, 0.0114406f, 2.18481f, -3.96610f, 0.0114406f, 2.18481f, 
		-3.96606f, 0.0300214f, 2.34029f, -3.96606f, 0.0300214f, 2.34029f, 
		-3.96606f, 0.0300214f, 2.34029f, -3.96606f, 0.0300214f, 2.34029f, 
		-3.96576f, 0.255966f, 1.63079f, -3.96576f, 0.255966f, 1.63079f, 
		-3.96576f, 0.255966f, 1.63079f, -3.96576f, 0.255966f, 1.63079f, 
		-3.96560f, 0.0145176f, 2.29691f, -3.96560f, 0.0145176f, 2.29691f, 
		-3.96560f, 0.0145176f, 2.29691f, -3.96546f, 0.447558f, 1.97210f, 
		-3.96534f, 0.0325736f, 2.32116f, -3.96534f, 0.0325736f, 2.32116f, 
		-3.96493f, 0.00565104f, 2.34427f, -3.96493f, 0.00565104f, 2.34427f, 
		-3.96493f, 0.00565104f, 2.34427f, -3.96493f, 0.00565104f, 2.34427f, 
		-3.96418f, 0.0313350f, 2.15196f, -3.96418f, 0.0313350f, 2.15196f, 
		-3.96418f, 0.0313350f, 2.15196f, -3.96403f, 0.0422384f, 1.98245f, 
		-3.96403f, 0.0422384f, 1.98245f, -3.96403f, 0.0422384f, 1.98245f, 
		-3.96403f, 0.0422384f, 1.98245f, -3.96403f, 0.0422384f, 1.98245f, 
		-3.96391f, 0.334801f, 1.56746f, -3.96391f, 0.334801f, 1.56746f, 
		-3.96382f, 0.306085f, 1.58346f, -3.96382f, 0.306085f, 1.58346f, 
		-3.96370f, -0.0167450f, 2.36737f, -3.96370f, -0.0167450f, 2.36737f, 
		-3.96370f, -0.0167450f, 2.36737f, -3.96370f, -0.0167450f, 2.36737f, 
		-3.96370f, -0.0167450f, 2.36737f, -3.96370f, -0.0167450f, 2.36737f, 
		-3.96342f, 0.0457626f, 2.16045f, -3.96342f, 0.0457626f, 2.16045f, 
		-3.96342f, 0.0457626f, 2.16045f, -3.96342f, 0.0457626f, 2.16045f, 
		-3.96341f, 0.248388f, 1.90510f, -3.96331f, 0.203330f, 1.84789f, 
		-3.96304f, 0.0331163f, 2.29703f, -3.96304f, 0.0331163f, 2.29703f, 
		-3.96304f, 0.0331163f, 2.29703f, -3.96304f, 0.0331163f, 2.29703f, 
		-3.96304f, 0.0331163f, 2.29703f, -3.96301f, 0.491435f, 1.52470f, 
		-3.96301f, 0.491435f, 1.52470f, -3.96301f, 0.491435f, 1.52470f, 
		-3.96283f, -0.000472276f, 2.29208f, -3.96283f, -0.000472276f, 2.29208f, 
		-3.96276f, -0.0171561f, 2.34162f, -3.96276f, -0.0171561f, 2.34162f, 
		-3.96276f, -0.0171561f, 2.34162f, -3.96276f, -0.0171561f, 2.34162f, 
		-3.96205f, 0.0397025f, 2.20725f, -3.96205f, 0.0397025f, 2.20725f, 
		-3.96205f, 0.0397025f, 2.20725f, -3.96205f, 0.0397025f, 2.20725f, 
		-3.96199f, 0.0110400f, 2.39955f, -3.96199f, 0.0110400f, 2.39955f, 
		-3.96199f, 0.0110400f, 2.39955f, -3.96199f, 0.0110400f, 2.39955f, 
		-3.96199f, 0.0110400f, 2.39955f, -3.96181f, 0.00936209f, 2.28212f, 
		-3.96181f, 0.00936209f, 2.28212f, -3.96181f, 0.00936209f, 2.28212f, 
		-3.96181f, 0.00936209f, 2.28212f, -3.96167f, 0.333600f, 1.57416f, 
		-3.96167f, 0.333600f, 1.57416f, -3.96167f, 0.333600f, 1.57416f, 
		-3.96167f, 0.333600f, 1.57416f, -3.96112f, 0.0173479f, 2.16055f, 
		-3.96112f, 0.0173479f, 2.16055f, -3.96112f, 0.0173479f, 2.16055f, 
		-3.96096f, 0.289237f, 1.61703f, -3.96094f, 0.00689424f, 2.35338f, 
		-3.96094f, 0.00689424f, 2.35338f, -3.96094f, 0.00689424f, 2.35338f, 
		-3.96094f, 0.00689424f, 2.35338f, -3.96094f, 0.00689424f, 2.35338f, 
		-3.96093f, 0.175077f, 1.72984f, -3.96090f, 0.0139682f, 2.29761f, 
		-3.96090f, 0.0139682f, 2.29761f, -3.96066f, 0.00873463f, 2.17205f, 
		-3.96066f, 0.00873463f, 2.17205f, -3.96052f, 0.00729854f, 2.19001f, 
		-3.96052f, 0.00729854f, 2.19001f, -3.96052f, 0.00729854f, 2.19001f, 
		-3.96052f, 0.00729854f, 2.19001f, -3.96052f, 0.00729854f, 2.19001f, 
		-3.96052f, 0.00729854f, 2.19001f, -3.96052f, 0.00729854f, 2.19001f, 
		-3.96052f, 0.00729854f, 2.19001f, -3.96025f, 0.0132254f, 2.31762f, 
		-3.96025f, 0.0132254f, 2.31762f, -3.96025f, 0.0132254f, 2.31762f, 
		-3.95960f, 0.252252f, 1.63742f, -3.95954f, 0.533187f, 2.04988f, 
		-3.95947f, 0.0527335f, 2.19641f, -3.95947f, 0.0527335f, 2.19641f, 
		-3.95947f, 0.0527335f, 2.19641f, -3.95947f, 0.0527335f, 2.19641f, 
		-3.95941f, -0.0445010f, 2.41700f, -3.95941f, -0.0445010f, 2.41700f, 
		-3.95940f, 0.0540490f, 2.21201f, -3.95919f, 0.0621680f, 2.02409f, 
		-3.95919f, 0.0621680f, 2.02409f, -3.95919f, 0.0621680f, 2.02409f, 
		-3.95919f, 0.0621680f, 2.02409f, -3.95919f, 0.0621680f, 2.02409f, 
		-3.95919f, 0.0621680f, 2.02409f, -3.95896f, 0.0188140f, 2.12264f, 
		-3.95896f, 0.0188140f, 2.12264f, -3.95896f, 0.0188140f, 2.12264f, 
		-3.95896f, 0.0188140f, 2.12264f, -3.95895f, 0.0564204f, 2.19333f, 
		-3.95895f, 0.0564204f, 2.19333f, -3.95895f, 0.0564204f, 2.19333f, 
		-3.95878f, 0.0341386f, 2.19372f, -3.95878f, 0.0341386f, 2.19372f, 
		-3.95878f, 0.0341386f, 2.19372f, -3.95878f, 0.0341386f, 2.19372f, 
		-3.95878f, 0.0341386f, 2.19372f, -3.95872f, -0.000538647f, 2.27946f, 
		-3.95872f, -0.000538647f, 2.27946f, -3.95872f, -0.000538647f, 2.27946f, 
		-3.95872f, -0.000538647f, 2.27946f, -3.95872f, -0.000538647f, 2.27946f, 
		-3.95858f, 0.0228614f, 2.28328f, -3.95858f, 0.0228614f, 2.28328f, 
		-3.95858f, 0.0228614f, 2.28328f, -3.95858f, 0.0228614f, 2.28328f, 
		-3.95858f, 0.0228614f, 2.28328f, -3.95858f, 0.0228614f, 2.28328f, 
		-3.95788f, 0.00941382f, 2.33755f, -3.95788f, 0.00941382f, 2.33755f, 
		-3.95788f, 0.00941382f, 2.33755f, -3.95788f, 0.00941382f, 2.33755f, 
		-3.95788f, 0.00941382f, 2.33755f, -3.95787f, -0.0135384f, 2.22096f, 
		-3.95787f, -0.0135384f, 2.22096f, -3.95787f, -0.0135384f, 2.22096f, 
		-3.95787f, -0.0135384f, 2.22096f, -3.95774f, 0.286429f, 1.58748f, 
		-3.95774f, 0.286429f, 1.58748f, -3.95770f, 0.0308674f, 2.16166f, 
		-3.95762f, 0.578418f, 1.60876f, -3.95760f, 0.00990800f, 2.03806f, 
		-3.95760f, 0.00990800f, 2.03806f, -3.95760f, 0.00990800f, 2.03806f, 
		-3.95756f, 0.348724f, 1.56063f, -3.95756f, 0.348724f, 1.56063f, 
		-3.95726f, 0.355496f, 1.56749f, -3.95726f, 0.355496f, 1.56749f, 
		-3.95686f, -0.0175180f, 2.44692f, -3.95686f, -0.0175180f, 2.44692f, 
		-3.95686f, -0.0175180f, 2.44692f, -3.95686f, -0.0175180f, 2.44692f, 
		-3.95686f, -0.0175180f, 2.44692f, -3.95665f, 0.0462650f, 2.17400f, 
		-3.95665f, 0.0462650f, 2.17400f, -3.95665f, 0.0462650f, 2.17400f, 
		-3.95665f, 0.0462650f, 2.17400f, -3.95665f, 0.0462650f, 2.17400f, 
		-3.95653f, 0.319401f, 1.57031f, -3.95653f, 0.319401f, 1.57031f, 
		-3.95653f, 0.319401f, 1.57031f, -3.95651f, 0.00433900f, 2.29625f, 
		-3.95651f, 0.00433900f, 2.29625f, -3.95651f, 0.00433900f, 2.29625f, 
		-3.95651f, 0.00433900f, 2.29625f, -3.95651f, 0.00433900f, 2.29625f, 
		-3.95633f, 0.0354838f, 2.29904f, -3.95633f, 0.0354838f, 2.29904f, 
		-3.95633f, 0.0354838f, 2.29904f, -3.95633f, 0.0354838f, 2.29904f, 
		-3.95633f, 0.0354838f, 2.29904f, -3.95623f, 0.0146057f, 2.31567f, 
		-3.95600f, 0.368068f, 1.96714f, -3.95592f, 0.207239f, 1.66226f, 
		-3.95592f, 0.207239f, 1.66226f, -3.95592f, 0.207239f, 1.66226f, 
		-3.95592f, 0.207239f, 1.66226f, -3.95592f, 0.207239f, 1.66226f, 
		-3.95592f, 0.207239f, 1.66226f, -3.95553f, 0.0174104f, 2.19351f, 
		-3.95553f, 0.0174104f, 2.19351f, -3.95553f, 0.0174104f, 2.19351f, 
		-3.95553f, 0.0174104f, 2.19351f, -3.95548f, 0.267245f, 1.99319f, 
		-3.95548f, 0.267245f, 1.99319f, -3.95466f, 0.0126030f, 2.17123f, 
		-3.95466f, 0.0126030f, 2.17123f, -3.95466f, 0.0126030f, 2.17123f, 
		-3.95466f, 0.0126030f, 2.17123f, -3.95460f, 0.000148251f, 2.29387f, 
		-3.95460f, 0.000148251f, 2.29387f, -3.95460f, 0.000148251f, 2.29387f, 
		-3.95460f, 0.000148251f, 2.29387f, -3.95460f, 0.000148251f, 2.29387f, 
		-3.95460f, 0.000148251f, 2.29387f, -3.95445f, 0.0403975f, 2.23660f, 
		-3.95445f, 0.0403975f, 2.23660f, -3.95445f, 0.0403975f, 2.23660f, 
		-3.95445f, 0.0403975f, 2.23660f, -3.95445f, 0.0403975f, 2.23660f, 
		-3.95414f, 0.633108f, 2.01395f, -3.95401f, 0.287310f, 1.60835f, 
		-3.95401f, 0.287310f, 1.60835f, -3.95400f, -0.0346090f, 2.43941f, 
		-3.95400f, -0.0346090f, 2.43941f, -3.95400f, -0.0346090f, 2.43941f, 
		-3.95400f, -0.0346090f, 2.43941f, -3.95398f, 0.00398054f, 2.31314f, 
		-3.95391f, 0.0489992f, 2.27444f, -3.95391f, 0.0489992f, 2.27444f, 
		-3.95391f, 0.0489992f, 2.27444f, -3.95391f, 0.0489992f, 2.27444f, 
		-3.95388f, 0.0557131f, 2.21428f, -3.95388f, 0.0557131f, 2.21428f, 
		-3.95388f, 0.0557131f, 2.21428f, -3.95388f, 0.0557131f, 2.21428f, 
		-3.95388f, 0.0557131f, 2.21428f, -3.95378f, 0.361123f, 1.57837f, 
		-3.95355f, 0.0102844f, 2.34071f, -3.95319f, 0.00872532f, 2.17494f, 
		-3.95319f, 0.00872532f, 2.17494f, -3.95319f, 0.00872532f, 2.17494f, 
		-3.95319f, 0.00872532f, 2.17494f, -3.95311f, 0.288198f, 1.59112f, 
		-3.95311f, 0.288198f, 1.59112f, -3.95310f, 0.0763782f, 1.99696f, 
		-3.95310f, 0.0763782f, 1.99696f, -3.95310f, 0.0763782f, 1.99696f, 
		-3.95310f, 0.0763782f, 1.99696f, -3.95308f, 0.0328370f, 2.29919f, 
		-3.95308f, 0.0328370f, 2.29919f, -3.95308f, 0.0328370f, 2.29919f, 
		-3.95308f, 0.0328370f, 2.29919f, -3.95308f, 0.0328370f, 2.29919f, 
		-3.95243f, 0.0489845f, 2.17355f, -3.95243f, 0.0489845f, 2.17355f, 
		-3.95243f, 0.0489845f, 2.17355f, -3.95236f, 0.0528792f, 2.18411f, 
		-3.95166f, -0.00895131f, 2.33652f, -3.95166f, -0.00895131f, 2.33652f, 
		-3.95161f, -0.00673472f, 2.25556f, -3.95161f, -0.00673472f, 2.25556f, 
		-3.95161f, -0.00673472f, 2.25556f, -3.95131f, 0.354248f, 1.57371f, 
		-3.95131f, 0.354248f, 1.57371f, -3.95117f, 0.0113802f, 2.16968f, 
		-3.95117f, 0.0113802f, 2.16968f, -3.95117f, 0.0113802f, 2.16968f, 
		-3.95117f, 0.0113802f, 2.16968f, -3.95117f, 0.0113802f, 2.16968f, 
		-3.95097f, 0.413239f, 1.57486f, -3.95097f, 0.742807f, 1.90035f, 
		-3.95091f, 0.0385183f, 2.26103f, -3.95091f, 0.0385183f, 2.26103f, 
		-3.95091f, 0.0385183f, 2.26103f, -3.95091f, 0.0385183f, 2.26103f, 
		-3.95091f, 0.0385183f, 2.26103f, -3.95087f, 0.303752f, 1.57669f, 
		-3.95063f, 0.0508776f, 2.23499f, -3.95063f, 0.0508776f, 2.23499f, 
		-3.95063f, 0.0508776f, 2.23499f, -3.95063f, 0.0508776f, 2.23499f, 
		-3.95056f, 0.271848f, 1.91698f, -3.95056f, 0.271848f, 1.91698f, 
		-3.95056f, 0.271848f, 1.91698f, -3.95056f, 0.271848f, 1.91698f, 
		-3.95056f, 0.271848f, 1.91698f, -3.95056f, 0.271848f, 1.91698f, 
		-3.95051f, 0.0434588f, 2.17087f, -3.95051f, 0.0434588f, 2.17087f, 
		-3.95028f, 0.652573f, 1.84185f, -3.94985f, -0.00332267f, 2.30953f, 
		-3.94985f, -0.00332267f, 2.30953f, -3.94985f, -0.00332267f, 2.30953f, 
		-3.94985f, -0.00332267f, 2.30953f, -3.94984f, 0.0367862f, 2.25955f, 
		-3.94984f, 0.0367862f, 2.25955f, -3.94984f, 0.0367862f, 2.25955f, 
		-3.94983f, -0.0181180f, 2.41965f, -3.94983f, -0.0181180f, 2.41965f, 
		-3.94983f, -0.0181180f, 2.41965f, -3.94960f, 0.337705f, 1.56765f, 
		-3.94960f, 0.337705f, 1.56765f, -3.94943f, -0.0130430f, 1.94548f, 
		-3.94943f, -0.0130430f, 1.94548f, -3.94943f, -0.0130430f, 1.94548f, 
		-3.94943f, -0.0130430f, 1.94548f, -3.94850f, -0.0163884f, 2.33463f, 
		-3.94850f, -0.0163884f, 2.33463f, -3.94850f, -0.0163884f, 2.33463f, 
		-3.94850f, -0.0163884f, 2.33463f, -3.94795f, 0.00382324f, 2.32021f, 
		-3.94795f, 0.00382324f, 2.32021f, -3.94795f, 0.00382324f, 2.32021f, 
		-3.94795f, 0.00382324f, 2.32021f, -3.94795f, 0.00382324f, 2.32021f, 
		-3.94795f, 0.00382324f, 2.32021f, -3.94792f, 0.0330315f, 2.27259f, 
		-3.94792f, 0.0330315f, 2.27259f, -3.94792f, 0.0330315f, 2.27259f, 
		-3.94792f, 0.0330315f, 2.27259f, -3.94736f, 0.0548405f, 2.23785f, 
		-3.94736f, 0.0548405f, 2.23785f, -3.94736f, -0.00458034f, 2.26967f, 
		-3.94736f, -0.00458034f, 2.26967f, -3.94736f, -0.00458034f, 2.26967f, 
		-3.94736f, -0.00458034f, 2.26967f, -3.94736f, -0.00458034f, 2.26967f, 
		-3.94726f, 0.0292332f, 2.32926f, -3.94726f, 0.0292332f, 2.32926f, 
		-3.94726f, 0.0292332f, 2.32926f, -3.94723f, 0.265856f, 1.60045f, 
		-3.94723f, 0.265856f, 1.60045f, -3.94723f, 0.265856f, 1.60045f, 
		-3.94723f, 0.0256596f, 2.16951f, -3.94723f, 0.0256596f, 2.16951f, 
		-3.94710f, 0.262147f, 1.61083f, -3.94710f, 0.262147f, 1.61083f, 
		-3.94710f, 0.262147f, 1.61083f, -3.94710f, 0.262147f, 1.61083f, 
		-3.94704f, -0.00525119f, 2.31098f, -3.94704f, -0.00525119f, 2.31098f, 
		-3.94704f, -0.00525119f, 2.31098f, -3.94704f, -0.00525119f, 2.31098f, 
		-3.94672f, 0.206199f, 1.92241f, -3.94646f, 0.00204133f, 2.19942f, 
		-3.94646f, 0.00204133f, 2.19942f, -3.94642f, 0.540646f, 1.96918f, 
		-3.94608f, 0.00783092f, 2.35115f, -3.94608f, 0.00783092f, 2.35115f, 
		-3.94608f, 0.00783092f, 2.35115f, -3.94608f, 0.00783092f, 2.35115f, 
		-3.94608f, 0.00783092f, 2.35115f, -3.94589f, -0.0123145f, 2.22624f, 
		-3.94589f, -0.0123145f, 2.22624f, -3.94532f, -0.000631000f, 2.37543f, 
		-3.94532f, -0.000631000f, 2.37543f, -3.94532f, -0.000631000f, 2.37543f, 
		-3.94532f, -0.000631000f, 2.37543f, -3.94532f, -0.000631000f, 2.37543f, 
		-3.94532f, -0.000631000f, 2.37543f, -3.94523f, 0.0281867f, 2.28422f, 
		-3.94523f, 0.0281867f, 2.28422f, -3.94523f, 0.0281867f, 2.28422f, 
		-3.94523f, 0.0281867f, 2.28422f, -3.94515f, 0.288915f, 1.58562f, 
		-3.94493f, 0.0124000f, 2.08776f, -3.94493f, 0.0124000f, 2.08776f, 
		-3.94493f, 0.0124000f, 2.08776f, -3.94493f, 0.0124000f, 2.08776f, 
		-3.94493f, 0.0124000f, 2.08776f, -3.94479f, 0.0485430f, 2.27655f, 
		-3.94479f, 0.0485430f, 2.27655f, -3.94479f, 0.0485430f, 2.27655f, 
		-3.94476f, 0.0521500f, 2.26502f, -3.94476f, 0.0521500f, 2.26502f, 
		-3.94476f, 0.0521500f, 2.26502f, -3.94476f, 0.0521500f, 2.26502f, 
		-3.94476f, 0.0521500f, 2.26502f, -3.94476f, 0.0521500f, 2.26502f, 
		-3.94476f, 0.0521500f, 2.26502f, -3.94445f, 0.0118098f, 2.32009f, 
		-3.94445f, 0.0118098f, 2.32009f, -3.94445f, 0.0118098f, 2.32009f, 
		-3.94445f, 0.0118098f, 2.32009f, -3.94445f, 0.0118098f, 2.32009f, 
		-3.94445f, 0.0118098f, 2.32009f, -3.94437f, 0.337678f, 1.55818f, 
		-3.94437f, 0.337678f, 1.55818f, -3.94437f, 0.337678f, 1.55818f, 
		-3.94437f, 0.337678f, 1.55818f, -3.94426f, 0.328129f, 1.56320f, 
		-3.94426f, 0.328129f, 1.56320f, -3.94426f, 0.328129f, 1.56320f, 
		-3.94364f, 0.00679860f, 2.34041f, -3.94364f, 0.00679860f, 2.34041f, 
		-3.94364f, 0.00679860f, 2.34041f, -3.94364f, 0.00679860f, 2.34041f, 
		-3.94346f, 0.174573f, 1.70627f, -3.94346f, 0.174573f, 1.70627f, 
		-3.94346f, 0.174573f, 1.70627f, -3.94346f, 0.174573f, 1.70627f, 
		-3.94345f, -0.00866331f, 2.33634f, -3.94345f, -0.00866331f, 2.33634f, 
		-3.94345f, -0.00866331f, 2.33634f, -3.94345f, -0.00866331f, 2.33634f, 
		-3.94345f, -0.00866331f, 2.33634f, -3.94324f, -0.0118872f, 2.22122f, 
		-3.94324f, -0.0118872f, 2.22122f, -3.94324f, -0.0118872f, 2.22122f, 
		-3.94324f, -0.0118872f, 2.22122f, -3.94306f, -0.00311400f, 2.27711f, 
		-3.94306f, -0.00311400f, 2.27711f, -3.94306f, -0.00311400f, 2.27711f, 
		-3.94306f, -0.00311400f, 2.27711f, -3.94306f, -0.00311400f, 2.27711f, 
		-3.94306f, -0.00311400f, 2.27711f, -3.94298f, -0.00761900f, 2.33851f, 
		-3.94298f, -0.00761900f, 2.33851f, -3.94298f, -0.00761900f, 2.33851f, 
		-3.94278f, 0.262748f, 1.62474f, -3.94270f, 0.318378f, 1.56998f, 
		-3.94104f, 0.0392026f, 2.22694f, -3.94104f, 0.0392026f, 2.22694f, 
		-3.94104f, 0.0392026f, 2.22694f, -3.94101f, 0.145938f, 1.70321f, 
		-3.94101f, 0.145938f, 1.70321f, -3.94101f, 0.145938f, 1.70321f, 
		-3.94101f, 0.145938f, 1.70321f, -3.94096f, 0.368178f, 1.57050f, 
		-3.94080f, 0.0402860f, 1.91673f, -3.94080f, 0.0402860f, 1.91673f, 
		-3.93997f, 0.0167210f, 2.00136f, -3.93997f, 0.0167210f, 2.00136f, 
		-3.93997f, 0.0167210f, 2.00136f, -3.93991f, -0.00152200f, 1.95383f, 
		-3.93991f, -0.00152200f, 1.95383f, -3.93991f, -0.00152200f, 1.95383f, 
		-3.93991f, -0.00152200f, 1.95383f, -3.93988f, 0.0193603f, 2.34164f, 
		-3.93988f, 0.0193603f, 2.34164f, -3.93988f, 0.0193603f, 2.34164f, 
		-3.93988f, 0.0193603f, 2.34164f, -3.93988f, 0.0193603f, 2.34164f, 
		-3.93983f, 0.0115660f, 1.98640f, -3.93983f, 0.0115660f, 1.98640f, 
		-3.93983f, 0.0115660f, 1.98640f, -3.93983f, 0.0115660f, 1.98640f, 
		-3.93968f, 0.197851f, 1.87933f, -3.93951f, -0.00721378f, 2.29613f, 
		-3.93951f, -0.00721378f, 2.29613f, -3.93951f, -0.00721378f, 2.29613f, 
		-3.93951f, -0.00721378f, 2.29613f, -3.93912f, 0.0230792f, 2.35197f, 
		-3.93912f, 0.0230792f, 2.35197f, -3.93912f, 0.0230792f, 2.35197f, 
		-3.93912f, 0.0230792f, 2.35197f, -3.93912f, 0.0230792f, 2.35197f, 
		-3.93912f, 0.0230792f, 2.35197f, -3.93886f, 0.266049f, 1.61722f, 
		-3.93886f, 0.266049f, 1.61722f, -3.93816f, 0.178070f, 1.68222f, 
		-3.93803f, 0.386196f, 1.53685f, -3.93803f, 0.386196f, 1.53685f, 
		-3.93803f, 0.386196f, 1.53685f, -3.93782f, 0.0461592f, 2.28691f, 
		-3.93782f, 0.0461592f, 2.28691f, -3.93782f, 0.0461592f, 2.28691f, 
		-3.93782f, 0.0461592f, 2.28691f, -3.93782f, 0.0461592f, 2.28691f, 
		-3.93772f, -0.00677062f, 2.26868f, -3.93754f, 0.274840f, 1.59488f, 
		-3.93754f, 0.274840f, 1.59488f, -3.93754f, 0.274840f, 1.59488f, 
		-3.93730f, 0.359832f, 1.61170f, -3.93730f, 0.359832f, 1.61170f, 
		-3.93730f, 0.359832f, 1.61170f, -3.93716f, -0.00467446f, 2.28177f, 
		-3.93716f, -0.00467446f, 2.28177f, -3.93716f, -0.00467446f, 2.28177f, 
		-3.93716f, -0.00467446f, 2.28177f, -3.93716f, -0.00467446f, 2.28177f, 
		-3.93710f, 0.0211753f, 2.30957f, -3.93710f, 0.0211753f, 2.30957f, 
		-3.93710f, 0.0211753f, 2.30957f, -3.93710f, 0.0211753f, 2.30957f, 
		-3.93710f, 0.0211753f, 2.30957f, -3.93710f, 0.0211753f, 2.30957f, 
		-3.93656f, 0.332684f, 1.93105f, -3.93656f, 0.332684f, 1.93105f, 
		-3.93624f, -0.00225253f, 2.33286f, -3.93624f, -0.00225253f, 2.33286f, 
		-3.93624f, -0.00225253f, 2.33286f, -3.93624f, -0.00225253f, 2.33286f, 
		-3.93624f, -0.00225253f, 2.33286f, -3.93624f, -0.00225253f, 2.33286f, 
		-3.93609f, 0.343215f, 1.55281f, -3.93609f, 0.343215f, 1.55281f, 
		-3.93605f, 0.0658220f, 2.04587f, -3.93605f, 0.0658220f, 2.04587f, 
		-3.93605f, 0.0658220f, 2.04587f, -3.93605f, 0.0658220f, 2.04587f, 
		-3.93597f, 0.304543f, 1.96038f, -3.93575f, -0.0131440f, 2.21744f, 
		-3.93575f, -0.0131440f, 2.21744f, -3.93575f, -0.0131440f, 2.21744f, 
		-3.93559f, -0.00643108f, 2.31135f, -3.93559f, -0.00643108f, 2.31135f, 
		-3.93559f, -0.00643108f, 2.31135f, -3.93552f, 0.0348890f, 1.97406f, 
		-3.93552f, 0.0348890f, 1.97406f, -3.93552f, 0.0348890f, 1.97406f, 
		-3.93541f, 0.206380f, 1.61698f, -3.93541f, 0.206380f, 1.61698f, 
		-3.93541f, 0.206380f, 1.61698f, -3.93515f, 0.0360330f, 2.30687f, 
		-3.93515f, 0.0360330f, 2.30687f, -3.93515f, 0.0360330f, 2.30687f, 
		-3.93486f, 0.0545506f, 2.21116f, -3.93475f, -0.0232120f, 2.41815f, 
		-3.93475f, -0.0232120f, 2.41815f, -3.93475f, -0.0232120f, 2.41815f, 
		-3.93475f, -0.0232120f, 2.41815f, -3.93475f, -0.0232120f, 2.41815f, 
		-3.93452f, 0.00124754f, 2.26770f, -3.93452f, 0.00124754f, 2.26770f, 
		-3.93452f, 0.00124754f, 2.26770f, -3.93452f, 0.00124754f, 2.26770f, 
		-3.93452f, 0.00124754f, 2.26770f, -3.93452f, 0.00124754f, 2.26770f, 
		-3.93451f, 0.0176094f, 2.31933f, -3.93451f, 0.0176094f, 2.31933f, 
		-3.93451f, 0.0176094f, 2.31933f, -3.93451f, 0.0176094f, 2.31933f, 
		-3.93451f, 0.0176094f, 2.31933f, -3.93447f, -0.0164011f, 2.21586f, 
		-3.93447f, -0.0164011f, 2.21586f, -3.93447f, -0.0164011f, 2.21586f, 
		-3.93447f, -0.0164011f, 2.21586f, -3.93447f, -0.0164011f, 2.21586f, 
		-3.93447f, -0.0164011f, 2.21586f, -3.93447f, -0.0164011f, 2.21586f, 
		-3.93447f, -0.0164011f, 2.21586f, -3.93445f, -0.0107693f, 2.20569f, 
		-3.93445f, -0.0107693f, 2.20569f, -3.93438f, 0.350375f, 1.55732f, 
		-3.93438f, 0.350375f, 1.55732f, -3.93438f, 0.350375f, 1.55732f, 
		-3.93438f, 0.350375f, 1.55732f, -3.93430f, 0.0831640f, 2.01217f, 
		-3.93430f, 0.0831640f, 2.01217f, -3.93430f, 0.0831640f, 2.01217f, 
		-3.93430f, 0.0831640f, 2.01217f, -3.93424f, 0.0382610f, 1.93334f, 
		-3.93424f, 0.0382610f, 1.93334f, -3.93424f, 0.0382610f, 1.93334f, 
		-3.93404f, 0.0385700f, 2.30567f, -3.93404f, 0.0385700f, 2.30567f, 
		-3.93404f, 0.0385700f, 2.30567f, -3.93400f, 0.302823f, 1.57834f, 
		-3.93369f, 0.254258f, 2.01090f, -3.93369f, 0.254258f, 2.01090f, 
		-3.93338f, 0.0535670f, 2.22407f, -3.93281f, 0.0241206f, 2.26804f, 
		-3.93281f, 0.0241206f, 2.26804f, -3.93281f, 0.0241206f, 2.26804f, 
		-3.93281f, 0.0241206f, 2.26804f, -3.93281f, 0.0241206f, 2.26804f, 
		-3.93281f, 0.0241206f, 2.26804f, -3.93280f, 0.331868f, 1.59835f, 
		-3.93280f, 0.331868f, 1.59835f, -3.93280f, 0.331868f, 1.59835f, 
		-3.93240f, 0.0104080f, 2.39365f, -3.93240f, 0.0104080f, 2.39365f, 
		-3.93240f, 0.0104080f, 2.39365f, -3.93240f, 0.0104080f, 2.39365f, 
		-3.93211f, -0.00956718f, 2.30185f, -3.93211f, -0.00956718f, 2.30185f, 
		-3.93211f, -0.00956718f, 2.30185f, -3.93194f, 0.280224f, 1.59571f, 
		-3.93194f, 0.280224f, 1.59571f, -3.93194f, 0.280224f, 1.59571f, 
		-3.93194f, 0.280224f, 1.59571f, -3.93194f, 0.280224f, 1.59571f, 
		-3.93193f, 0.616809f, 1.57425f, -3.93189f, 0.351261f, 1.56333f, 
		-3.93189f, 0.351261f, 1.56333f, -3.93184f, 0.334477f, 1.56090f, 
		-3.93184f, 0.334477f, 1.56090f, -3.93165f, 0.0268460f, 2.07986f, 
		-3.93144f, 0.0476065f, 2.24901f, -3.93140f, 0.0853950f, 2.01280f, 
		-3.93140f, 0.0853950f, 2.01280f, -3.93140f, 0.0853950f, 2.01280f, 
		-3.93140f, 0.0853950f, 2.01280f, -3.93140f, 0.666384f, 1.70713f, 
		-3.93114f, 0.361242f, 1.55458f, -3.93114f, 0.361242f, 1.55458f, 
		-3.93114f, 0.361242f, 1.55458f, -3.93111f, -0.000813144f, 2.28354f, 
		-3.93111f, -0.000813144f, 2.28354f, -3.93111f, -0.000813144f, 2.28354f, 
		-3.93111f, -0.000813144f, 2.28354f, -3.93099f, -0.00108469f, 2.25033f, 
		-3.93099f, -0.00108469f, 2.25033f, -3.93099f, -0.00108469f, 2.25033f, 
		-3.93099f, -0.00108469f, 2.25033f, -3.93052f, 0.0251897f, 2.25344f, 
		-3.93052f, 0.0251897f, 2.25344f, -3.93052f, 0.0251897f, 2.25344f, 
		-3.93052f, 0.0251897f, 2.25344f, -3.93052f, 0.0251897f, 2.25344f, 
		-3.93052f, 0.0251897f, 2.25344f, -3.93047f, -0.0402790f, 2.40275f, 
		-3.93047f, -0.0402790f, 2.40275f, -3.93047f, -0.0402790f, 2.40275f, 
		-3.93047f, -0.0402790f, 2.40275f, -3.93045f, 0.0222293f, 2.28738f, 
		-3.93045f, 0.0222293f, 2.28738f, -3.93045f, 0.0222293f, 2.28738f, 
		-3.93045f, 0.0222293f, 2.28738f, -3.93039f, 0.169149f, 1.68473f, 
		-3.93039f, 0.169149f, 1.68473f, -3.93039f, 0.169149f, 1.68473f, 
		-3.93037f, -0.0158886f, 2.21873f, -3.93037f, -0.0158886f, 2.21873f, 
		-3.93037f, -0.0158886f, 2.21873f, -3.93015f, 0.0124188f, 2.26986f, 
		-3.93015f, 0.0124188f, 2.26986f, -3.93015f, 0.0124188f, 2.26986f, 
		-3.92958f, -0.0213748f, 2.31928f, -3.92945f, 0.497411f, 1.56205f, 
		-3.92928f, -0.0106718f, 2.22629f, -3.92928f, -0.0106718f, 2.22629f, 
		-3.92928f, -0.0106718f, 2.22629f, -3.92928f, -0.0106718f, 2.22629f, 
		-3.92928f, -0.0106718f, 2.22629f, -3.92928f, -0.0106718f, 2.22629f, 
		-3.92925f, 0.167796f, 1.76604f, -3.92925f, 0.167796f, 1.76604f, 
		-3.92925f, 0.167796f, 1.76604f, -3.92925f, 0.167796f, 1.76604f, 
		-3.92925f, 0.167796f, 1.76604f, -3.92896f, 0.0532600f, 1.98075f, 
		-3.92896f, 0.0532600f, 1.98075f, -3.92896f, 0.0532600f, 1.98075f, 
		-3.92876f, 0.0454760f, 1.96929f, -3.92876f, 0.0454760f, 1.96929f, 
		-3.92876f, 0.0454760f, 1.96929f, -3.92839f, 0.734681f, 1.67903f, 
		-3.92839f, 0.734681f, 1.67903f, -3.92839f, 0.734681f, 1.67903f, 
		-3.92839f, 0.734681f, 1.67903f, -3.92839f, 0.734681f, 1.67903f, 
		-3.92839f, 0.734681f, 1.67903f, -3.92800f, 0.0114836f, 2.25879f, 
		-3.92800f, 0.0114836f, 2.25879f, -3.92800f, 0.0114836f, 2.25879f, 
		-3.92800f, 0.0114836f, 2.25879f, -3.92800f, 0.0114836f, 2.25879f, 
		-3.92800f, 0.0114836f, 2.25879f, -3.92800f, 0.0114836f, 2.25879f, 
		-3.92800f, 0.0114836f, 2.25879f, -3.92775f, 0.0536180f, 2.22298f, 
		-3.92768f, 0.0815810f, 1.93349f, -3.92768f, 0.0815810f, 1.93349f, 
		-3.92768f, 0.0815810f, 1.93349f, -3.92768f, 0.0815810f, 1.93349f, 
		-3.92746f, 0.251005f, 1.96597f, -3.92746f, 0.251005f, 1.96597f, 
		-3.92746f, 0.251005f, 1.96597f, -3.92746f, 0.251005f, 1.96597f, 
		-3.92746f, -0.0133656f, 2.32698f, -3.92746f, -0.0133656f, 2.32698f, 
		-3.92720f, 0.0109160f, 2.28395f, -3.92720f, 0.0109160f, 2.28395f, 
		-3.92720f, 0.0109160f, 2.28395f, -3.92667f, 0.0430410f, 2.06990f, 
		-3.92667f, 0.0430410f, 2.06990f, -3.92667f, 0.0430410f, 2.06990f, 
		-3.92667f, 0.0430410f, 2.06990f, -3.92628f, 0.644392f, 1.89585f, 
		-3.92612f, 0.285190f, 1.59187f, -3.92612f, 0.285190f, 1.59187f, 
		-3.92605f, -0.00331240f, 2.32885f, -3.92605f, -0.00331240f, 2.32885f, 
		-3.92605f, -0.00331240f, 2.32885f, -3.92603f, -0.00290779f, 2.29767f, 
		-3.92603f, -0.00290779f, 2.29767f, -3.92603f, -0.00290779f, 2.29767f, 
		-3.92603f, -0.00290779f, 2.29767f, -3.92603f, -0.00290779f, 2.29767f, 
		-3.92603f, -0.00290779f, 2.29767f, -3.92522f, 0.0250840f, 2.33817f, 
		-3.92522f, 0.0250840f, 2.33817f, -3.92522f, 0.0250840f, 2.33817f, 
		-3.92522f, 0.0250840f, 2.33817f, -3.92522f, 0.294968f, 1.58637f, 
		-3.92522f, 0.294968f, 1.58637f, -3.92522f, 0.294968f, 1.58637f, 
		-3.92522f, 0.294968f, 1.58637f, -3.92522f, 0.294968f, 1.58637f, 
		-3.92506f, -0.0151230f, 2.33985f, -3.92506f, -0.0151230f, 2.33985f, 
		-3.92506f, -0.0151230f, 2.33985f, -3.92506f, -0.0151230f, 2.33985f, 
		-3.92506f, -0.0151230f, 2.33985f, -3.92492f, 0.0324366f, 2.22341f, 
		-3.92492f, 0.0324366f, 2.22341f, -3.92492f, 0.0324366f, 2.22341f, 
		-3.92490f, 0.0260083f, 2.20552f, -3.92490f, 0.0260083f, 2.20552f, 
		-3.92490f, 0.0260083f, 2.20552f, -3.92490f, 0.0260083f, 2.20552f, 
		-3.92470f, -0.00352702f, 2.31080f, -3.92470f, -0.00352702f, 2.31080f, 
		-3.92470f, -0.00352702f, 2.31080f, -3.92470f, -0.00352702f, 2.31080f, 
		-3.92453f, 0.0186283f, 2.30636f, -3.92453f, 0.0186283f, 2.30636f, 
		-3.92453f, 0.0186283f, 2.30636f, -3.92453f, 0.0186283f, 2.30636f, 
		-3.92449f, 0.0689890f, 1.94574f, -3.92449f, 0.0689890f, 1.94574f, 
		-3.92449f, 0.0689890f, 1.94574f, -3.92437f, -0.0254942f, 2.32538f, 
		-3.92437f, -0.0254942f, 2.32538f, -3.92437f, -0.0254942f, 2.32538f, 
		-3.92437f, -0.0254942f, 2.32538f, -3.92422f, -0.0174600f, 2.01042f, 
		-3.92422f, -0.0174600f, 2.01042f, -3.92422f, -0.0174600f, 2.01042f, 
		-3.92422f, -0.0174600f, 2.01042f, -3.92417f, 0.0310650f, 1.96327f, 
		-3.92417f, 0.0310650f, 1.96327f, -3.92417f, 0.0310650f, 1.96327f, 
		-3.92405f, 0.246964f, 1.61622f, -3.92405f, 0.246964f, 1.61622f, 
		-3.92405f, 0.246964f, 1.61622f, -3.92405f, 0.246964f, 1.61622f, 
		-3.92389f, 0.223577f, 1.92908f, -3.92389f, 0.223577f, 1.92908f, 
		-3.92389f, 0.223577f, 1.92908f, -3.92389f, 0.223577f, 1.92908f, 
		-3.92389f, 0.223577f, 1.92908f, -3.92389f, 0.223577f, 1.92908f, 
		-3.92384f, 0.245994f, 1.94196f, -3.92377f, 0.321782f, 1.56311f, 
		-3.92336f, 0.0239653f, 2.24583f, -3.92336f, 0.0239653f, 2.24583f, 
		-3.92336f, 0.0239653f, 2.24583f, -3.92336f, 0.0239653f, 2.24583f, 
		-3.92336f, 0.0239653f, 2.24583f, -3.92336f, 0.0239653f, 2.24583f, 
		-3.92335f, 0.00507800f, 2.28556f, -3.92335f, 0.00507800f, 2.28556f, 
		-3.92335f, 0.00507800f, 2.28556f, -3.92335f, 0.00507800f, 2.28556f, 
		-3.92334f, 0.303670f, 1.57447f, -3.92334f, 0.303670f, 1.57447f, 
		-3.92334f, 0.303670f, 1.57447f, -3.92324f, 0.0281127f, 2.34851f, 
		-3.92324f, 0.0281127f, 2.34851f, -3.92324f, 0.0281127f, 2.34851f, 
		-3.92320f, 0.0119010f, 1.98407f, -3.92320f, 0.0119010f, 1.98407f, 
		-3.92320f, 0.0119010f, 1.98407f, -3.92320f, 0.0119010f, 1.98407f, 
		-3.92293f, 0.0112792f, 2.25122f, -3.92293f, 0.0112792f, 2.25122f, 
		-3.92293f, 0.0112792f, 2.25122f, -3.92293f, 0.0112792f, 2.25122f, 
		-3.92293f, 0.0112792f, 2.25122f, -3.92286f, 0.0161789f, 2.31488f, 
		-3.92286f, 0.0161789f, 2.31488f, -3.92286f, 0.0161789f, 2.31488f, 
		-3.92286f, 0.0161789f, 2.31488f, -3.92274f, -0.00140444f, 2.24545f, 
		-3.92274f, -0.00140444f, 2.24545f, -3.92274f, -0.00140444f, 2.24545f, 
		-3.92274f, -0.00140444f, 2.24545f, -3.92274f, -0.00140444f, 2.24545f, 
		-3.92274f, -0.00140444f, 2.24545f, -3.92274f, -0.00140444f, 2.24545f, 
		-3.92273f, 0.0335880f, 2.28908f, -3.92273f, 0.0335880f, 2.28908f, 
		-3.92273f, 0.0335880f, 2.28908f, -3.92273f, 0.0335880f, 2.28908f, 
		-3.92273f, 0.0335880f, 2.28908f, -3.92273f, 0.0335880f, 2.28908f, 
		-3.92257f, -0.00669934f, 2.21162f, -3.92257f, -0.00669934f, 2.21162f, 
		-3.92257f, -0.00669934f, 2.21162f, -3.92257f, -0.00669934f, 2.21162f, 
		-3.92257f, -0.00669934f, 2.21162f, -3.92257f, -0.00669934f, 2.21162f, 
		-3.92189f, 0.00640893f, 2.20605f, -3.92189f, 0.00640893f, 2.20605f, 
		-3.92189f, 0.00640893f, 2.20605f, -3.92167f, 0.327253f, 1.55463f, 
		-3.92167f, 0.327253f, 1.55463f, -3.92167f, 0.327253f, 1.55463f, 
		-3.92167f, 0.327253f, 1.55463f, -3.92167f, 0.327253f, 1.55463f, 
		-3.92160f, 0.328213f, 1.56144f, -3.92160f, 0.328213f, 1.56144f, 
		-3.92150f, 0.136997f, 1.73941f, -3.92150f, 0.136997f, 1.73941f, 
		-3.92149f, 0.0189660f, 2.01653f, -3.92149f, 0.0189660f, 2.01653f, 
		-3.92149f, 0.0189660f, 2.01653f, -3.92149f, 0.0189660f, 2.01653f, 
		-3.92149f, 0.0189660f, 2.01653f, -3.92149f, 0.0189660f, 2.01653f, 
		-3.92149f, 0.0189660f, 2.01653f, -3.92149f, 0.0189660f, 2.01653f, 
		-3.92147f, 0.153336f, 1.80401f, -3.92134f, -0.0346150f, 2.43320f, 
		-3.92134f, -0.0346150f, 2.43320f, -3.92134f, -0.0346150f, 2.43320f, 
		-3.92134f, -0.0346150f, 2.43320f, -3.92134f, -0.0346150f, 2.43320f, 
		-3.92121f, -0.0205230f, 2.01177f, -3.92121f, -0.0205230f, 2.01177f, 
		-3.92121f, -0.0205230f, 2.01177f, -3.92121f, -0.0205230f, 2.01177f, 
		-3.92121f, -0.0205230f, 2.01177f, -3.92081f, 0.345700f, 2.04946f, 
		-3.92081f, 0.345700f, 2.04946f, -3.92081f, 0.345700f, 2.04946f, 
		-3.92061f, 0.00826985f, 2.30219f, -3.92061f, 0.00826985f, 2.30219f, 
		-3.92061f, 0.00826985f, 2.30219f, -3.92061f, 0.00826985f, 2.30219f, 
		-3.92048f, 0.248042f, 1.62213f, -3.92048f, 0.248042f, 1.62213f, 
		-3.92048f, 0.248042f, 1.62213f, -3.92025f, 0.00234131f, 2.28031f, 
		-3.92025f, 0.00234131f, 2.28031f, -3.92023f, 0.438437f, 2.00841f, 
		-3.92021f, 0.147980f, 1.77807f, -3.92021f, 0.147980f, 1.77807f, 
		-3.92021f, 0.147980f, 1.77807f, -3.91991f, 0.140044f, 1.76307f, 
		-3.91991f, 0.140044f, 1.76307f, -3.91958f, 0.00552733f, 2.31121f, 
		-3.91958f, 0.00552733f, 2.31121f, -3.91958f, 0.00552733f, 2.31121f, 
		-3.91958f, 0.00552733f, 2.31121f, -3.91958f, 0.00552733f, 2.31121f, 
		-3.91938f, 0.0206950f, 2.28180f, -3.91938f, 0.0206950f, 2.28180f, 
		-3.91938f, 0.0206950f, 2.28180f, -3.91938f, 0.0206950f, 2.28180f, 
		-3.91938f, 0.0206950f, 2.28180f, -3.91938f, 0.0206950f, 2.28180f, 
		-3.91926f, 0.240286f, 1.62925f, -3.91923f, 0.0347707f, 2.28131f, 
		-3.91923f, 0.0347707f, 2.28131f, -3.91923f, 0.0347707f, 2.28131f, 
		-3.91923f, 0.0347707f, 2.28131f, -3.91923f, 0.0347707f, 2.28131f, 
		-3.91897f, 0.0530600f, 1.97469f, -3.91897f, 0.0530600f, 1.97469f, 
		-3.91897f, 0.0530600f, 1.97469f, -3.91897f, 0.0530600f, 1.97469f, 
		-3.91886f, -0.0110387f, 2.25139f, -3.91886f, -0.0110387f, 2.25139f, 
		-3.91886f, -0.0110387f, 2.25139f, -3.91818f, 0.0577610f, 1.99035f, 
		-3.91818f, 0.0577610f, 1.99035f, -3.91818f, 0.0577610f, 1.99035f, 
		-3.91815f, 0.292729f, 1.59333f, -3.91750f, 0.316973f, 1.56474f, 
		-3.91750f, 0.316973f, 1.56474f, -3.91750f, 0.316973f, 1.56474f, 
		-3.91750f, 0.316973f, 1.56474f, -3.91750f, 0.316973f, 1.56474f, 
		-3.91750f, 0.316973f, 1.56474f, -3.91749f, -0.00742700f, 1.94956f, 
		-3.91749f, -0.00742700f, 1.94956f, -3.91749f, -0.00742700f, 1.94956f, 
		-3.91722f, 0.154154f, 1.82561f, -3.91715f, 0.331261f, 1.55125f, 
		-3.91715f, 0.331261f, 1.55125f, -3.91715f, 0.331261f, 1.55125f, 
		-3.91715f, 0.331261f, 1.55125f, -3.91680f, 0.253658f, 1.60547f, 
		-3.91642f, 0.0276740f, 1.92796f, -3.91642f, 0.0276740f, 1.92796f, 
		-3.91580f, 0.0190334f, 2.28193f, -3.91574f, -3.17967e-005f, 2.29960f, 
		-3.91574f, -3.17967e-005f, 2.29960f, -3.91574f, -3.17967e-005f, 2.29960f, 
		-3.91574f, -3.17967e-005f, 2.29960f, -3.91574f, -3.17967e-005f, 2.29960f, 
		-3.91574f, -3.17967e-005f, 2.29960f, -3.91574f, -3.17967e-005f, 2.29960f, 
		-3.91549f, 0.636639f, 1.63457f, -3.91526f, 0.207314f, 1.64579f, 
		-3.91526f, 0.207314f, 1.64579f, -3.91526f, 0.207314f, 1.64579f, 
		-3.91520f, 0.0348740f, 2.25898f, -3.91520f, 0.0348740f, 2.25898f, 
		-3.91505f, -0.0172670f, 2.43778f, -3.91505f, -0.0172670f, 2.43778f, 
		-3.91505f, -0.0172670f, 2.43778f, -3.91505f, -0.0172670f, 2.43778f, 
		-3.91500f, 0.0311946f, 2.30630f, -3.91500f, 0.0311946f, 2.30630f, 
		-3.91482f, 0.0290040f, 2.02234f, -3.91482f, 0.0290040f, 2.02234f, 
		-3.91482f, 0.0290040f, 2.02234f, -3.91482f, 0.0290040f, 2.02234f, 
		-3.91482f, 0.0290040f, 2.02234f, -3.91473f, 0.215639f, 1.89365f, 
		-3.91473f, 0.215639f, 1.89365f, -3.91473f, 0.215639f, 1.89365f, 
		-3.91418f, 0.0165430f, 2.39372f, -3.91418f, 0.0165430f, 2.39372f, 
		-3.91418f, 0.0165430f, 2.39372f, -3.91391f, 0.376372f, 1.52645f, 
		-3.91391f, 0.376372f, 1.52645f, -3.91391f, 0.376372f, 1.52645f, 
		-3.91391f, 0.376372f, 1.52645f, -3.91391f, 0.376372f, 1.52645f, 
		-3.91386f, -0.00752620f, 2.26223f, -3.91386f, -0.00752620f, 2.26223f, 
		-3.91386f, -0.00752620f, 2.26223f, -3.91386f, -0.00752620f, 2.26223f, 
		-3.91386f, -0.00752620f, 2.26223f, -3.91386f, -0.00330749f, 2.24693f, 
		-3.91386f, -0.00330749f, 2.24693f, -3.91386f, -0.00330749f, 2.24693f, 
		-3.91367f, 0.420937f, 1.55124f, -3.91350f, 0.186041f, 1.90490f, 
		-3.91341f, 0.00139800f, 1.99894f, -3.91341f, 0.00139800f, 1.99894f, 
		-3.91341f, 0.00139800f, 1.99894f, -3.91341f, 0.00139800f, 1.99894f, 
		-3.91331f, 0.337181f, 1.55230f, -3.91331f, 0.337181f, 1.55230f, 
		-3.91331f, 0.337181f, 1.55230f, -3.91331f, 0.337181f, 1.55230f, 
		-3.91331f, 0.337181f, 1.55230f, -3.91331f, 0.337181f, 1.55230f, 
		-3.91299f, 0.0186817f, 2.24699f, -3.91299f, 0.0186817f, 2.24699f, 
		-3.91299f, 0.0186817f, 2.24699f, -3.91299f, 0.0186817f, 2.24699f, 
		-3.91247f, 0.318547f, 1.55783f, -3.91247f, 0.318547f, 1.55783f, 
		-3.91247f, 0.318547f, 1.55783f, -3.91247f, 0.318547f, 1.55783f, 
		-3.91247f, 0.318547f, 1.55783f, -3.91245f, 0.348645f, 1.57022f, 
		-3.91245f, 0.348645f, 1.57022f, -3.91245f, 0.348645f, 1.57022f, 
		-3.91245f, 0.348645f, 1.57022f, -3.91245f, 0.348645f, 1.57022f, 
		-3.91203f, 0.0345540f, 2.24767f, -3.91203f, 0.0345540f, 2.24767f, 
		-3.91203f, 0.0345540f, 2.24767f, -3.91203f, 0.0345540f, 2.24767f, 
		-3.91199f, -0.00341966f, 2.32725f, -3.91199f, -0.00341966f, 2.32725f, 
		-3.91199f, -0.00341966f, 2.32725f, -3.91199f, -0.00341966f, 2.32725f, 
		-3.91194f, 0.0234812f, 2.22979f, -3.91194f, 0.0234812f, 2.22979f, 
		-3.91187f, -0.000465948f, 2.21831f, -3.91187f, -0.000465948f, 2.21831f, 
		-3.91187f, -0.000465948f, 2.21831f, -3.91187f, -0.000465948f, 2.21831f, 
		-3.91187f, -0.000465948f, 2.21831f, -3.91177f, 0.0575810f, 2.00059f, 
		-3.91177f, 0.0575810f, 2.00059f, -3.91177f, 0.0575810f, 2.00059f, 
		-3.91177f, 0.0575810f, 2.00059f, -3.91144f, 0.345059f, 1.55602f, 
		-3.91144f, 0.345059f, 1.55602f, -3.91144f, 0.345059f, 1.55602f, 
		-3.91141f, 0.00362690f, 2.18818f, -3.91131f, 0.308166f, 1.56764f, 
		-3.91131f, 0.308166f, 1.56764f, -3.91131f, 0.308166f, 1.56764f, 
		-3.91119f, 0.0169635f, 2.30098f, -3.91091f, 0.0404830f, 2.02055f, 
		-3.91091f, 0.0404830f, 2.02055f, -3.91091f, 0.0404830f, 2.02055f, 
		-3.91091f, 0.0404830f, 2.02055f, -3.91091f, 0.0404830f, 2.02055f, 
		-3.91088f, 0.00326181f, 2.25114f, -3.91088f, 0.00326181f, 2.25114f, 
		-3.91088f, 0.00326181f, 2.25114f, -3.91088f, 0.00326181f, 2.25114f, 
		-3.91088f, 0.00326181f, 2.25114f, -3.91088f, 0.00326181f, 2.25114f, 
		-3.91087f, 0.0173116f, 2.26947f, -3.91087f, 0.0173116f, 2.26947f, 
		-3.91087f, 0.0173116f, 2.26947f, -3.91087f, 0.0173116f, 2.26947f, 
		-3.91066f, 0.523519f, 2.00742f, -3.91061f, 0.214924f, 1.98921f, 
		-3.91061f, 0.214924f, 1.98921f, -3.91061f, 0.214924f, 1.98921f, 
		-3.91061f, 0.214924f, 1.98921f, -3.91061f, 0.214924f, 1.98921f, 
		-3.91061f, 0.214924f, 1.98921f, -3.91061f, 0.214924f, 1.98921f, 
		-3.91051f, 0.293189f, 1.58576f, -3.91051f, 0.293189f, 1.58576f, 
		-3.91047f, 0.0168163f, 2.21602f, -3.91047f, 0.0168163f, 2.21602f, 
		-3.91047f, 0.0168163f, 2.21602f, -3.91047f, 0.0168163f, 2.21602f, 
		-3.91002f, 0.363004f, 2.00089f, -3.90956f, -0.00221200f, 2.25129f, 
		-3.90956f, -0.00221200f, 2.25129f, -3.90956f, -0.00221200f, 2.25129f, 
		-3.90956f, -0.00221200f, 2.25129f, -3.90956f, -0.00221200f, 2.25129f, 
		-3.90956f, -0.00221200f, 2.25129f, -3.90956f, -0.00221200f, 2.25129f, 
		-3.90956f, -0.00221200f, 2.25129f, -3.90955f, -0.0220743f, 2.22557f, 
		-3.90955f, -0.0220743f, 2.22557f, -3.90955f, -0.0220743f, 2.22557f, 
		-3.90933f, 0.184287f, 1.66786f, -3.90933f, 0.184287f, 1.66786f, 
		-3.90933f, 0.184287f, 1.66786f, -3.90933f, 0.184287f, 1.66786f, 
		-3.90899f, 0.0228502f, 2.33248f, -3.90899f, 0.0228502f, 2.33248f, 
		-3.90899f, 0.0228502f, 2.33248f, -3.90899f, 0.0228502f, 2.33248f, 
		-3.90879f, -0.00869979f, 2.24385f, -3.90879f, -0.00869979f, 2.24385f, 
		-3.90879f, -0.00869979f, 2.24385f, -3.90879f, -0.00869979f, 2.24385f, 
		-3.90879f, -0.00869979f, 2.24385f, -3.90874f, 0.0366120f, 2.19334f, 
		-3.90874f, 0.0366120f, 2.19334f, -3.90874f, 0.0366120f, 2.19334f, 
		-3.90874f, 0.0366120f, 2.19334f, -3.90841f, -0.00599800f, 2.20032f, 
		-3.90841f, -0.00599800f, 2.20032f, -3.90841f, -0.00599800f, 2.20032f, 
		-3.90841f, -0.00599800f, 2.20032f, -3.90818f, -0.000594434f, 2.26495f, 
		-3.90818f, -0.000594434f, 2.26495f, -3.90818f, -0.000594434f, 2.26495f, 
		-3.90818f, -0.000594434f, 2.26495f, -3.90805f, 0.0459891f, 2.21522f, 
		-3.90798f, 0.286205f, 1.58982f, -3.90798f, 0.286205f, 1.58982f, 
		-3.90798f, 0.286205f, 1.58982f, -3.90763f, 0.0217810f, 1.88432f, 
		-3.90763f, 0.0217810f, 1.88432f, -3.90763f, 0.0217810f, 1.88432f, 
		-3.90763f, 0.0217810f, 1.88432f, -3.90763f, 0.0217810f, 1.88432f, 
		-3.90763f, 0.0217810f, 1.88432f, -3.90763f, 0.0125740f, 2.19075f, 
		-3.90763f, 0.0125740f, 2.19075f, -3.90763f, 0.0125740f, 2.19075f, 
		-3.90763f, 0.0125740f, 2.19075f, -3.90763f, 0.0125740f, 2.19075f, 
		-3.90745f, 0.131409f, 1.79138f, -3.90745f, 0.131409f, 1.79138f, 
		-3.90704f, 0.302910f, 1.57819f, -3.90704f, 0.302910f, 1.57819f, 
		-3.90704f, 0.302910f, 1.57819f, -3.90704f, 0.302910f, 1.57819f, 
		-3.90702f, 0.0543180f, 1.93849f, -3.90702f, 0.0543180f, 1.93849f, 
		-3.90696f, 0.0147071f, 2.18630f, -3.90677f, -0.00723584f, 2.32835f, 
		-3.90677f, -0.00723584f, 2.32835f, -3.90677f, -0.00723584f, 2.32835f, 
		-3.90677f, -0.00723584f, 2.32835f, -3.90677f, -0.00723584f, 2.32835f, 
		-3.90677f, -0.00723584f, 2.32835f, -3.90672f, -0.0141870f, 2.23335f, 
		-3.90672f, -0.0141870f, 2.23335f, -3.90672f, -0.0141870f, 2.23335f, 
		-3.90672f, -0.0141870f, 2.23335f, -3.90672f, -0.0141870f, 2.23335f, 
		-3.90666f, -0.0102259f, 2.23991f, -3.90666f, -0.0102259f, 2.23991f, 
		-3.90666f, -0.0102259f, 2.23991f, -3.90666f, -0.0102259f, 2.23991f, 
		-3.90645f, -0.0105807f, 2.26733f, -3.90645f, -0.0105807f, 2.26733f, 
		-3.90645f, -0.0105807f, 2.26733f, -3.90645f, -0.0105807f, 2.26733f, 
		-3.90645f, -0.0105807f, 2.26733f, -3.90644f, -0.00676995f, 2.25194f, 
		-3.90644f, -0.00676995f, 2.25194f, -3.90644f, -0.00676995f, 2.25194f, 
		-3.90644f, -0.00676995f, 2.25194f, -3.90644f, -0.00676995f, 2.25194f, 
		-3.90644f, -0.00676995f, 2.25194f, -3.90639f, 0.0189607f, 2.26480f, 
		-3.90639f, 0.0189607f, 2.26480f, -3.90639f, 0.0189607f, 2.26480f, 
		-3.90639f, 0.0189607f, 2.26480f, -3.90632f, 0.0381742f, 2.19101f, 
		-3.90632f, 0.0381742f, 2.19101f, -3.90629f, -0.0161022f, 2.26154f, 
		-3.90629f, -0.0161022f, 2.26154f, -3.90629f, -0.0161022f, 2.26154f, 
		-3.90629f, -0.0161022f, 2.26154f, -3.90629f, -0.0161022f, 2.26154f, 
		-3.90629f, -0.0161022f, 2.26154f, -3.90629f, -0.0161022f, 2.26154f, 
		-3.90610f, 0.733878f, 1.69826f, -3.90610f, 0.733878f, 1.69826f, 
		-3.90610f, 0.733878f, 1.69826f, -3.90610f, 0.733878f, 1.69826f, 
		-3.90594f, 0.0350123f, 2.24742f, -3.90594f, 0.0350123f, 2.24742f, 
		-3.90579f, 0.321776f, 1.55789f, -3.90579f, 0.321776f, 1.55789f, 
		-3.90579f, 0.321776f, 1.55789f, -3.90579f, 0.321776f, 1.55789f, 
		-3.90573f, 0.0769290f, 1.96074f, -3.90573f, 0.0769290f, 1.96074f, 
		-3.90551f, 0.297974f, 1.57712f, -3.90551f, 0.297974f, 1.57712f, 
		-3.90551f, 0.297974f, 1.57712f, -3.90551f, 0.297974f, 1.57712f, 
		-3.90551f, 0.297974f, 1.57712f, -3.90543f, 0.0788788f, 2.02231f, 
		-3.90543f, 0.0788788f, 2.02231f, -3.90543f, 0.0788788f, 2.02231f, 
		-3.90543f, 0.0788788f, 2.02231f, -3.90530f, -0.0488420f, 2.40482f, 
		-3.90530f, -0.0488420f, 2.40482f, -3.90530f, -0.0488420f, 2.40482f, 
		-3.90530f, -0.0488420f, 2.40482f, -3.90530f, -0.0488420f, 2.40482f, 
		-3.90530f, -0.0488420f, 2.40482f, -3.90491f, 0.361041f, 1.55391f, 
		-3.90491f, 0.568629f, 1.57584f, -3.90460f, 0.0313937f, 2.18864f, 
		-3.90446f, 0.0257758f, 2.34227f, -3.90446f, 0.0257758f, 2.34227f, 
		-3.90446f, 0.0257758f, 2.34227f, -3.90446f, 0.0257758f, 2.34227f, 
		-3.90446f, 0.0257758f, 2.34227f, -3.90446f, 0.0257758f, 2.34227f, 
		-3.90446f, 0.0257758f, 2.34227f, -3.90431f, -0.0178990f, 1.98184f, 
		-3.90431f, -0.0178990f, 1.98184f, -3.90431f, -0.0178990f, 1.98184f, 
		-3.90431f, -0.0178990f, 1.98184f, -3.90431f, -0.0178990f, 1.98184f, 
		-3.90431f, -0.0178990f, 1.98184f, -3.90418f, 0.423198f, 2.07538f, 
		-3.90418f, 0.423198f, 2.07538f, -3.90406f, 0.153701f, 1.84305f, 
		-3.90392f, -0.0112587f, 2.32370f, -3.90392f, -0.0112587f, 2.32370f, 
		-3.90392f, -0.0112587f, 2.32370f, -3.90392f, -0.0112587f, 2.32370f, 
		-3.90392f, -0.0112587f, 2.32370f, -3.90364f, 0.292175f, 1.59950f, 
		-3.90364f, 0.292175f, 1.59950f, -3.90357f, 0.00875126f, 2.25251f, 
		-3.90357f, 0.00875126f, 2.25251f, -3.90357f, 0.00875126f, 2.25251f, 
		-3.90357f, 0.00875126f, 2.25251f, -3.90296f, -0.0350260f, 1.98512f, 
		-3.90296f, -0.0350260f, 1.98512f, -3.90296f, -0.0350260f, 1.98512f, 
		-3.90296f, -0.0350260f, 1.98512f, -3.90281f, -0.00888612f, 2.20000f, 
		-3.90281f, -0.00888612f, 2.20000f, -3.90281f, -0.00888612f, 2.20000f, 
		-3.90273f, -0.00498831f, 2.23153f, -3.90273f, -0.00498831f, 2.23153f, 
		-3.90273f, -0.00498831f, 2.23153f, -3.90273f, -0.00498831f, 2.23153f, 
		-3.90270f, 0.0145880f, 2.25638f, -3.90270f, 0.0145880f, 2.25638f, 
		-3.90270f, 0.0145880f, 2.25638f, -3.90270f, 0.0145880f, 2.25638f, 
		-3.90270f, 0.0145880f, 2.25638f, -3.90245f, 0.0922350f, 1.95371f, 
		-3.90245f, 0.0922350f, 1.95371f, -3.90221f, 0.00345000f, 2.03024f, 
		-3.90221f, 0.00345000f, 2.03024f, -3.90214f, 0.248441f, 1.60970f, 
		-3.90214f, 0.248441f, 1.60970f, -3.90214f, 0.248441f, 1.60970f, 
		-3.90212f, 0.0383180f, 2.21944f, -3.90212f, 0.0383180f, 2.21944f, 
		-3.90212f, 0.0383180f, 2.21944f, -3.90155f, -0.00470780f, 2.32344f, 
		-3.90155f, -0.00470780f, 2.32344f, -3.90155f, -0.00470780f, 2.32344f, 
		-3.90127f, 0.0123780f, 2.32118f, -3.90114f, 0.00908329f, 2.24099f, 
		-3.90114f, 0.00908329f, 2.24099f, -3.90114f, 0.00908329f, 2.24099f, 
		-3.90111f, -0.0301276f, 2.24025f, -3.90111f, -0.0301276f, 2.24025f, 
		-3.90111f, -0.0301276f, 2.24025f, -3.90111f, -0.0301276f, 2.24025f, 
		-3.90111f, -0.0301276f, 2.24025f, -3.90081f, 0.623647f, 1.94601f, 
		-3.90067f, 0.155057f, 1.74306f, -3.90049f, 0.302824f, 1.59359f, 
		-3.90049f, 0.302824f, 1.59359f, -3.90049f, 0.302824f, 1.59359f, 
		-3.90033f, 0.00495221f, 2.22879f, -3.90033f, 0.00495221f, 2.22879f, 
		-3.90033f, 0.00495221f, 2.22879f, -3.90033f, 0.00495221f, 2.22879f, 
		-3.90024f, 0.327252f, 1.55837f, -3.90024f, 0.327252f, 1.55837f, 
		-3.90015f, 0.0518110f, 2.00101f, -3.90015f, 0.0518110f, 2.00101f, 
		-3.90014f, 0.0125800f, 2.00599f, -3.90014f, 0.0125800f, 2.00599f, 
		-3.89998f, -0.0222800f, 1.91982f, -3.89998f, -0.0222800f, 1.91982f, 
		-3.89965f, -0.0100751f, 2.26754f, -3.89965f, -0.0100751f, 2.26754f, 
		-3.89965f, -0.0100751f, 2.26754f, -3.89965f, -0.0100751f, 2.26754f, 
		-3.89965f, -0.0100751f, 2.26754f, -3.89965f, -0.0100751f, 2.26754f, 
		-3.89965f, -0.0100751f, 2.26754f, -3.89949f, -0.0377930f, 2.43147f, 
		-3.89949f, -0.0377930f, 2.43147f, -3.89949f, -0.0377930f, 2.43147f, 
		-3.89942f, 0.00836930f, 2.19246f, -3.89930f, 0.234698f, 1.94446f, 
		-3.89930f, 0.234698f, 1.94446f, -3.89930f, 0.234698f, 1.94446f, 
		-3.89930f, 0.234698f, 1.94446f, -3.89929f, 0.0361660f, 1.77883f, 
		-3.89919f, -0.00992600f, 2.43696f, -3.89919f, -0.00992600f, 2.43696f, 
		-3.89919f, -0.00992600f, 2.43696f, -3.89919f, -0.00992600f, 2.43696f, 
		-3.89919f, 0.00865077f, 2.33358f, -3.89919f, 0.00865077f, 2.33358f, 
		-3.89919f, 0.00865077f, 2.33358f, -3.89919f, 0.00865077f, 2.33358f, 
		-3.89919f, 0.00865077f, 2.33358f, -3.89919f, 0.00865077f, 2.33358f, 
		-3.89919f, 0.00865077f, 2.33358f, -3.89876f, 0.248538f, 1.61449f, 
		-3.89876f, 0.248538f, 1.61449f, -3.89876f, 0.248538f, 1.61449f, 
		-3.89876f, 0.248538f, 1.61449f, -3.89876f, 0.248538f, 1.61449f, 
		-3.89846f, 0.0139861f, 2.26951f, -3.89846f, 0.0139861f, 2.26951f, 
		-3.89846f, 0.0139861f, 2.26951f, -3.89840f, 0.273968f, 1.59325f, 
		-3.89840f, 0.273968f, 1.59325f, -3.89840f, 0.273968f, 1.59325f, 
		-3.89833f, 0.00109100f, 2.03139f, -3.89833f, 0.00109100f, 2.03139f, 
		-3.89833f, 0.00109100f, 2.03139f, -3.89833f, 0.00109100f, 2.03139f, 
		-3.89821f, 0.313466f, 1.98178f, -3.89821f, 0.313466f, 1.98178f, 
		-3.89821f, 0.313466f, 1.98178f, -3.89788f, 0.0288310f, 1.68511f, 
		-3.89788f, 0.0288310f, 1.68511f, -3.89788f, 0.0288310f, 1.68511f, 
		-3.89788f, 0.0288310f, 1.68511f, -3.89788f, 0.0288310f, 1.68511f, 
		-3.89775f, 0.401881f, 1.52095f, -3.89775f, 0.401881f, 1.52095f, 
		-3.89775f, 0.401881f, 1.52095f, -3.89775f, 0.401881f, 1.52095f, 
		-3.89770f, -0.0693850f, 1.77837f, -3.89770f, -0.0693850f, 1.77837f, 
		-3.89770f, -0.0693850f, 1.77837f, -3.89697f, -0.0150330f, 2.22501f, 
		-3.89697f, -0.0150330f, 2.22501f, -3.89697f, -0.0150330f, 2.22501f, 
		-3.89697f, -0.0150330f, 2.22501f, -3.89645f, 0.189945f, 1.91972f, 
		-3.89645f, 0.189945f, 1.91972f, -3.89645f, 0.189945f, 1.91972f, 
		-3.89645f, 0.189945f, 1.91972f, -3.89639f, 0.703036f, 1.96903f, 
		-3.89632f, 0.692219f, 1.75136f, -3.89621f, 0.0147730f, 2.38141f, 
		-3.89621f, 0.0147730f, 2.38141f, -3.89621f, 0.0147730f, 2.38141f, 
		-3.89621f, 0.0147730f, 2.38141f, -3.89584f, 0.00784200f, 1.78006f, 
		-3.89494f, 0.0133600f, 1.87542f, -3.89494f, 0.0133600f, 1.87542f, 
		-3.89494f, 0.0133600f, 1.87542f, -3.89494f, 0.0133600f, 1.87542f, 
		-3.89480f, 0.244038f, 1.61825f, -3.89479f, 0.409116f, 1.49768f, 
		-3.89479f, 0.409116f, 1.49768f, -3.89479f, 0.409116f, 1.49768f, 
		-3.89479f, 0.409116f, 1.49768f, -3.89465f, 0.0613420f, 1.89320f, 
		-3.89465f, 0.0613420f, 1.89320f, -3.89386f, 0.0209190f, 1.84905f, 
		-3.89386f, 0.0209190f, 1.84905f, -3.89386f, 0.0209190f, 1.84905f, 
		-3.89386f, 0.0209190f, 1.84905f, -3.89386f, 0.0209190f, 1.84905f, 
		-3.89382f, -0.0191398f, 2.21596f, -3.89382f, -0.0191398f, 2.21596f, 
		-3.89382f, -0.0191398f, 2.21596f, -3.89382f, -0.0191398f, 2.21596f, 
		-3.89382f, -0.0191398f, 2.21596f, -3.89382f, -0.0191398f, 2.21596f, 
		-3.89352f, 0.294457f, 1.59492f, -3.89352f, 0.294457f, 1.59492f, 
		-3.89352f, 0.294457f, 1.59492f, -3.89352f, 0.294457f, 1.59492f, 
		-3.89340f, 0.0293218f, 2.20093f, -3.89340f, 0.0293218f, 2.20093f, 
		-3.89280f, 0.0291090f, 1.78222f, -3.89280f, 0.0291090f, 1.78222f, 
		-3.89265f, -0.00826219f, 2.25690f, -3.89265f, -0.00826219f, 2.25690f, 
		-3.89265f, -0.00826219f, 2.25690f, -3.89265f, -0.00826219f, 2.25690f, 
		-3.89202f, 0.00112800f, 2.21188f, -3.89202f, 0.00112800f, 2.21188f, 
		-3.89202f, 0.00112800f, 2.21188f, -3.89202f, 0.00112800f, 2.21188f, 
		-3.89170f, -0.0432850f, 1.70497f, -3.89165f, 0.765162f, 1.73844f, 
		-3.89163f, 0.0437140f, 1.78354f, -3.89163f, 0.0437140f, 1.78354f, 
		-3.89163f, 0.0437140f, 1.78354f, -3.89132f, -0.0131700f, 2.24710f, 
		-3.89132f, -0.0131700f, 2.24710f, -3.89132f, -0.0131700f, 2.24710f, 
		-3.89119f, 0.304959f, 1.98745f, -3.89085f, 0.252208f, 2.02539f, 
		-3.89085f, 0.252208f, 2.02539f, -3.89085f, 0.252208f, 2.02539f, 
		-3.89085f, 0.252208f, 2.02539f, -3.89078f, 0.259029f, 1.97477f, 
		-3.89078f, 0.259029f, 1.97477f, -3.89078f, 0.259029f, 1.97477f, 
		-3.89078f, 0.259029f, 1.97477f, -3.89078f, 0.259029f, 1.97477f, 
		-3.89066f, 0.0592760f, 1.95343f, -3.89066f, 0.304186f, 1.59053f, 
		-3.89066f, 0.304186f, 1.59053f, -3.89066f, 0.304186f, 1.59053f, 
		-3.89031f, 0.513183f, 2.07917f, -3.89031f, 0.513183f, 2.07917f, 
		-3.89023f, 0.440820f, 1.49284f, -3.89023f, 0.440820f, 1.49284f, 
		-3.89023f, 0.440820f, 1.49284f, -3.89023f, 0.440820f, 1.49284f, 
		-3.89020f, 0.371056f, 1.54585f, -3.88967f, 0.0283632f, 2.25434f, 
		-3.88967f, 0.0283632f, 2.25434f, -3.88967f, 0.0283632f, 2.25434f, 
		-3.88967f, 0.0283632f, 2.25434f, -3.88967f, 0.0283632f, 2.25434f, 
		-3.88950f, 0.227806f, 1.62474f, -3.88914f, 0.00300383f, 2.26325f, 
		-3.88914f, 0.00300383f, 2.26325f, -3.88914f, 0.00300383f, 2.26325f, 
		-3.88914f, 0.00300383f, 2.26325f, -3.88914f, 0.00300383f, 2.26325f, 
		-3.88898f, 0.324777f, 1.55967f, -3.88898f, 0.324777f, 1.55967f, 
		-3.88898f, 0.324777f, 1.55967f, -3.88884f, -0.0386050f, 2.39765f, 
		-3.88884f, -0.0386050f, 2.39765f, -3.88884f, -0.0386050f, 2.39765f, 
		-3.88884f, -0.0386050f, 2.39765f, -3.88884f, -0.0386050f, 2.39765f, 
		-3.88842f, 0.0689420f, 1.78164f, -3.88842f, 0.0689420f, 1.78164f, 
		-3.88842f, 0.0689420f, 1.78164f, -3.88842f, 0.0689420f, 1.78164f, 
		-3.88842f, 0.0689420f, 1.78164f, -3.88807f, -0.0174780f, 1.97123f, 
		-3.88807f, -0.0174780f, 1.97123f, -3.88807f, -0.0174780f, 1.97123f, 
		-3.88807f, -0.0174780f, 1.97123f, -3.88803f, 0.00161182f, 2.20653f, 
		-3.88803f, 0.00161182f, 2.20653f, -3.88803f, 0.00161182f, 2.20653f, 
		-3.88803f, 0.00161182f, 2.20653f, -3.88781f, -0.0169994f, 2.23545f, 
		-3.88781f, -0.0169994f, 2.23545f, -3.88781f, -0.0169994f, 2.23545f, 
		-3.88781f, -0.0169994f, 2.23545f, -3.88779f, 0.0356330f, 2.00547f, 
		-3.88779f, 0.0356330f, 2.00547f, -3.88779f, 0.0356330f, 2.00547f, 
		-3.88779f, 0.0356330f, 2.00547f, -3.88764f, 0.773504f, 1.76530f, 
		-3.88764f, 0.773504f, 1.76530f, -3.88700f, 0.0313355f, 2.22605f, 
		-3.88689f, 0.164428f, 1.82653f, -3.88689f, 0.164428f, 1.82653f, 
		-3.88689f, 0.164428f, 1.82653f, -3.88665f, 0.0663490f, 1.78347f, 
		-3.88665f, 0.0663490f, 1.78347f, -3.88602f, -0.0165690f, 1.86653f, 
		-3.88602f, -0.0165690f, 1.86653f, -3.88602f, -0.0165690f, 1.86653f, 
		-3.88602f, -0.0165690f, 1.86653f, -3.88602f, -0.0165690f, 1.86653f, 
		-3.88602f, -0.0165690f, 1.86653f, -3.88571f, 0.135774f, 1.77725f, 
		-3.88571f, 0.135774f, 1.77725f, -3.88571f, 0.135774f, 1.77725f, 
		-3.88571f, 0.135774f, 1.77725f, -3.88570f, 0.00182000f, 1.99560f, 
		-3.88570f, 0.00182000f, 1.99560f, -3.88568f, 0.538417f, 1.52759f, 
		-3.88559f, 0.287739f, 1.58374f, -3.88502f, 0.00695648f, 2.27468f, 
		-3.88502f, 0.00695648f, 2.27468f, -3.88502f, 0.00695648f, 2.27468f, 
		-3.88502f, 0.00695648f, 2.27468f, -3.88502f, 0.0158290f, 2.25911f, 
		-3.88502f, 0.0158290f, 2.25911f, -3.88502f, 0.0158290f, 2.25911f, 
		-3.88502f, 0.0158290f, 2.25911f, -3.88502f, 0.0158290f, 2.25911f, 
		-3.88502f, 0.0158290f, 2.25911f, -3.88475f, 0.0587090f, 1.87895f, 
		-3.88475f, 0.0587090f, 1.87895f, -3.88475f, 0.0587090f, 1.87895f, 
		-3.88475f, 0.0587090f, 1.87895f, -3.88414f, 0.0544260f, 1.73649f, 
		-3.88414f, 0.0544260f, 1.73649f, -3.88356f, 0.0549100f, 1.70490f, 
		-3.88343f, -0.0158812f, 2.22450f, -3.88343f, -0.0158812f, 2.22450f, 
		-3.88343f, -0.0158812f, 2.22450f, -3.88343f, -0.0158812f, 2.22450f, 
		-3.88334f, 0.0575260f, 1.76094f, -3.88334f, 0.0575260f, 1.76094f, 
		-3.88334f, 0.0575260f, 1.76094f, -3.88334f, 0.0575260f, 1.76094f, 
		-3.88331f, -0.0134490f, 2.42661f, -3.88331f, -0.0134490f, 2.42661f, 
		-3.88331f, -0.0134490f, 2.42661f, -3.88331f, -0.0134490f, 2.42661f, 
		-3.88316f, 0.140486f, 1.79275f, -3.88316f, 0.140486f, 1.79275f, 
		-3.88284f, 0.153218f, 1.85724f, -3.88255f, 0.352290f, 1.53653f, 
		-3.88255f, 0.352290f, 1.53653f, -3.88255f, 0.352290f, 1.53653f, 
		-3.88255f, 0.352290f, 1.53653f, -3.88255f, 0.352290f, 1.53653f, 
		-3.88245f, 0.340712f, 1.55178f, -3.88174f, 0.0534480f, 1.78576f, 
		-3.88174f, 0.0534480f, 1.78576f, -3.88174f, 0.0534480f, 1.78576f, 
		-3.88166f, 0.0439800f, 2.02696f, -3.88166f, 0.0439800f, 2.02696f, 
		-3.88149f, -0.0306630f, 2.41890f, -3.88149f, -0.0306630f, 2.41890f, 
		-3.88149f, -0.0306630f, 2.41890f, -3.88149f, -0.0306630f, 2.41890f, 
		-3.88149f, -0.0306630f, 2.41890f, -3.88123f, -0.0248370f, 2.27551f, 
		-3.88123f, -0.0248370f, 2.27551f, -3.88123f, -0.0248370f, 2.27551f, 
		-3.88123f, -0.0248370f, 2.27551f, -3.88123f, -0.0248370f, 2.27551f, 
		-3.88123f, -0.0248370f, 2.27551f, -3.88108f, 0.0672830f, 1.98490f, 
		-3.88108f, 0.0672830f, 1.98490f, -3.88108f, 0.0672830f, 1.98490f, 
		-3.88066f, -0.0140280f, 2.39860f, -3.88066f, -0.0140280f, 2.39860f, 
		-3.88066f, -0.0140280f, 2.39860f, -3.88059f, 0.0160921f, 2.23841f, 
		-3.88059f, 0.0160921f, 2.23841f, -3.88059f, 0.0160921f, 2.23841f, 
		-3.88059f, 0.0160921f, 2.23841f, -3.88051f, 0.273944f, 1.59430f, 
		-3.88051f, 0.273944f, 1.59430f, -3.88051f, 0.273944f, 1.59430f, 
		-3.88043f, -0.134190f, 1.77947f, -3.88010f, 0.0194080f, 2.26261f, 
		-3.88010f, 0.0194080f, 2.26261f, -3.88010f, 0.0194080f, 2.26261f, 
		-3.88010f, 0.0194080f, 2.26261f, -3.87973f, 0.00864164f, 2.22064f, 
		-3.87973f, 0.00864164f, 2.22064f, -3.87973f, 0.00864164f, 2.22064f, 
		-3.87973f, 0.00864164f, 2.22064f, -3.87968f, 0.593870f, 1.98901f, 
		-3.87919f, 0.420045f, 1.53072f, -3.87867f, -0.0615500f, 1.66655f, 
		-3.87867f, -0.0615500f, 1.66655f, -3.87867f, -0.0615500f, 1.66655f, 
		-3.87867f, -0.0615500f, 1.66655f, -3.87867f, -0.0615500f, 1.66655f, 
		-3.87849f, 0.0484220f, 1.71513f, -3.87849f, 0.0484220f, 1.71513f, 
		-3.87849f, 0.0484220f, 1.71513f, -3.87849f, 0.0484220f, 1.71513f, 
		-3.87849f, 0.0484220f, 1.71513f, -3.87845f, -0.0343160f, 1.82578f, 
		-3.87845f, -0.0343160f, 1.82578f, -3.87845f, -0.0343160f, 1.82578f, 
		-3.87845f, -0.0343160f, 1.82578f, -3.87845f, -0.0343160f, 1.82578f, 
		-3.87844f, 0.183729f, 1.63578f, -3.87844f, 0.183729f, 1.63578f, 
		-3.87844f, 0.183729f, 1.63578f, -3.87844f, 0.183729f, 1.63578f, 
		-3.87841f, -0.0358300f, 1.90542f, -3.87841f, -0.0358300f, 1.90542f, 
		-3.87841f, -0.0358300f, 1.90542f, -3.87841f, -0.0358300f, 1.90542f, 
		-3.87841f, -0.0358300f, 1.90542f, -3.87811f, 0.237275f, 1.96870f, 
		-3.87796f, 0.0575450f, 1.80799f, -3.87796f, 0.0575450f, 1.80799f, 
		-3.87796f, 0.0575450f, 1.80799f, -3.87796f, 0.0575450f, 1.80799f, 
		-3.87774f, 0.480013f, 1.49501f, -3.87774f, 0.480013f, 1.49501f, 
		-3.87774f, 0.480013f, 1.49501f, -3.87774f, 0.480013f, 1.49501f, 
		-3.87774f, 0.480013f, 1.49501f, -3.87774f, 0.480013f, 1.49501f, 
		-3.87773f, 0.113509f, 1.77924f, -3.87765f, 0.307541f, 1.56707f, 
		-3.87740f, -0.00830044f, 2.22025f, -3.87740f, -0.00830044f, 2.22025f, 
		-3.87740f, -0.00830044f, 2.22025f, -3.87740f, -0.00830044f, 2.22025f, 
		-3.87740f, -0.00830044f, 2.22025f, -3.87740f, -0.00830044f, 2.22025f, 
		-3.87740f, 0.160969f, 1.70048f, -3.87700f, -0.00849000f, 2.00279f, 
		-3.87700f, -0.00849000f, 2.00279f, -3.87658f, 0.0676470f, 1.77377f, 
		-3.87658f, 0.0676470f, 1.77377f, -3.87632f, 0.135000f, 1.84268f, 
		-3.87632f, 0.135000f, 1.84268f, -3.87632f, 0.135000f, 1.84268f, 
		-3.87631f, 0.116554f, 1.79339f, -3.87576f, 0.0544570f, 1.82882f, 
		-3.87576f, 0.0544570f, 1.82882f, -3.87576f, 0.0544570f, 1.82882f, 
		-3.87576f, 0.0544570f, 1.82882f, -3.87544f, 0.0817570f, 1.73192f, 
		-3.87544f, 0.0817570f, 1.73192f, -3.87544f, 0.0817570f, 1.73192f, 
		-3.87540f, 0.483247f, 1.53290f, -3.87535f, -0.0297190f, 1.95041f, 
		-3.87535f, -0.0297190f, 1.95041f, -3.87535f, -0.0297190f, 1.95041f, 
		-3.87535f, -0.0297190f, 1.95041f, -3.87505f, -0.122208f, 1.72237f, 
		-3.87505f, 0.0908760f, 1.78673f, -3.87496f, 0.0193659f, 2.24103f, 
		-3.87496f, 0.0193659f, 2.24103f, -3.87496f, 0.0193659f, 2.24103f, 
		-3.87477f, 0.0617770f, 1.84842f, -3.87458f, 0.0843320f, 1.72941f, 
		-3.87458f, 0.0843320f, 1.72941f, -3.87458f, 0.0843320f, 1.72941f, 
		-3.87458f, 0.0843320f, 1.72941f, -3.87458f, 0.0843320f, 1.72941f, 
		-3.87434f, 0.0461520f, 1.89933f, -3.87434f, 0.0461520f, 1.89933f, 
		-3.87434f, 0.0461520f, 1.89933f, -3.87434f, 0.0461520f, 1.89933f, 
		-3.87434f, 0.0461520f, 1.89933f, -3.87434f, 0.0461520f, 1.89933f, 
		-3.87422f, -0.0151380f, 1.61226f, -3.87422f, -0.0151380f, 1.61226f, 
		-3.87422f, -0.0151380f, 1.61226f, -3.87422f, -0.0151380f, 1.61226f, 
		-3.87422f, -0.0151380f, 1.61226f, -3.87395f, -0.00263700f, 1.98555f, 
		-3.87387f, 0.508181f, 2.02915f, -3.87369f, 0.137373f, 1.75298f, 
		-3.87353f, 0.0735020f, 1.75384f, -3.87353f, 0.0735020f, 1.75384f, 
		-3.87353f, 0.0735020f, 1.75384f, -3.87343f, 0.701883f, 1.62619f, 
		-3.87338f, 0.0103343f, 2.21900f, -3.87338f, 0.0103343f, 2.21900f, 
		-3.87338f, 0.0103343f, 2.21900f, -3.87338f, 0.0103343f, 2.21900f, 
		-3.87338f, 0.0103343f, 2.21900f, -3.87312f, 0.0442010f, 2.02578f, 
		-3.87312f, 0.0442010f, 2.02578f, -3.87312f, 0.0442010f, 2.02578f, 
		-3.87312f, 0.0442010f, 2.02578f, -3.87308f, 0.140988f, 1.81738f, 
		-3.87308f, 0.140988f, 1.81738f, -3.87271f, -0.0640090f, 1.64375f, 
		-3.87271f, -0.0640090f, 1.64375f, -3.87271f, -0.0640090f, 1.64375f, 
		-3.87271f, -0.0640090f, 1.64375f, -3.87265f, 0.0916200f, 1.77061f, 
		-3.87265f, 0.0916200f, 1.77061f, -3.87265f, 0.0916200f, 1.77061f, 
		-3.87257f, 0.264384f, 1.59801f, -3.87240f, 0.176976f, 1.92327f, 
		-3.87235f, -0.0553260f, 2.27664f, -3.87235f, -0.0553260f, 2.27664f, 
		-3.87235f, -0.0553260f, 2.27664f, -3.87235f, -0.0553260f, 2.27664f, 
		-3.87217f, -0.0448140f, 2.29143f, -3.87217f, -0.0448140f, 2.29143f, 
		-3.87217f, -0.0448140f, 2.29143f, -3.87217f, -0.0448140f, 2.29143f, 
		-3.87205f, 0.172879f, 1.67095f, -3.87189f, 0.0673194f, 1.80002f, 
		-3.87189f, 0.0673194f, 1.80002f, -3.87189f, 0.0673194f, 1.80002f, 
		-3.87189f, 0.0673194f, 1.80002f, -3.87051f, 0.373173f, 1.53648f, 
		-3.87019f, 0.0492200f, 1.97673f, -3.87000f, -0.0399420f, 1.60987f, 
		-3.87000f, -0.0399420f, 1.60987f, -3.86983f, 0.0670960f, 1.91395f, 
		-3.86952f, 0.0922793f, 1.80466f, -3.86947f, 0.0791910f, 1.98639f, 
		-3.86947f, 0.0791910f, 1.98639f, -3.86911f, 0.0484560f, 1.84642f, 
		-3.86911f, 0.0484560f, 1.84642f, -3.86911f, 0.0484560f, 1.84642f, 
		-3.86911f, 0.0484560f, 1.84642f, -3.86911f, 0.0484560f, 1.84642f, 
		-3.86911f, 0.0484560f, 1.84642f, -3.86906f, 0.0817720f, 1.82861f, 
		-3.86906f, 0.0817720f, 1.82861f, -3.86906f, 0.0817720f, 1.82861f, 
		-3.86906f, 0.0817720f, 1.82861f, -3.86900f, 0.119349f, 1.81147f, 
		-3.86839f, -0.0790120f, 1.63360f, -3.86839f, -0.0790120f, 1.63360f, 
		-3.86839f, -0.0790120f, 1.63360f, -3.86826f, 0.675246f, 1.66642f, 
		-3.86814f, 0.174716f, 1.62962f, -3.86814f, 0.174716f, 1.62962f, 
		-3.86814f, 0.174716f, 1.62962f, -3.86814f, 0.174716f, 1.62962f, 
		-3.86804f, 0.271848f, 1.98031f, -3.86804f, 0.271848f, 1.98031f, 
		-3.86804f, 0.271848f, 1.98031f, -3.86804f, 0.271848f, 1.98031f, 
		-3.86804f, 0.271848f, 1.98031f, -3.86794f, 0.0843460f, 1.83092f, 
		-3.86794f, 0.0843460f, 1.83092f, -3.86794f, 0.0843460f, 1.83092f, 
		-3.86744f, -0.116448f, 1.83569f, -3.86695f, 0.115596f, 1.76056f, 
		-3.86695f, 0.115596f, 1.76056f, -3.86695f, 0.115596f, 1.76056f, 
		-3.86678f, -0.105877f, 1.59630f, -3.86678f, -0.105877f, 1.59630f, 
		-3.86677f, 0.0406250f, 1.99814f, -3.86677f, 0.0406250f, 1.99814f, 
		-3.86677f, 0.0406250f, 1.99814f, -3.86677f, 0.0406250f, 1.99814f, 
		-3.86677f, 0.0406250f, 1.99814f, -3.86635f, 0.0712510f, 1.71057f, 
		-3.86635f, 0.0712510f, 1.71057f, -3.86635f, 0.0712510f, 1.71057f, 
		-3.86635f, 0.0712510f, 1.71057f, -3.86635f, 0.0712510f, 1.71057f, 
		-3.86635f, 0.0712510f, 1.71057f, -3.86590f, -0.0333850f, 2.24014f, 
		-3.86590f, -0.0333850f, 2.24014f, -3.86590f, -0.0333850f, 2.24014f, 
		-3.86590f, -0.0333850f, 2.24014f, -3.86590f, -0.0333850f, 2.24014f, 
		-3.86587f, 0.701050f, 1.80325f, -3.86574f, 0.0548920f, 1.68307f, 
		-3.86574f, 0.0548920f, 1.68307f, -3.86518f, 0.241645f, 1.96051f, 
		-3.86518f, 0.241645f, 1.96051f, -3.86518f, 0.241645f, 1.96051f, 
		-3.86518f, 0.241645f, 1.96051f, -3.86513f, 0.250330f, 1.59739f, 
		-3.86507f, 0.421252f, 2.03205f, -3.86489f, -0.0255320f, 2.29363f, 
		-3.86489f, -0.0255320f, 2.29363f, -3.86489f, -0.0255320f, 2.29363f, 
		-3.86489f, -0.0255320f, 2.29363f, -3.86467f, 0.167944f, 1.89972f, 
		-3.86467f, 0.167944f, 1.89972f, -3.86467f, 0.167944f, 1.89972f, 
		-3.86421f, -0.0575390f, 2.25765f, -3.86421f, -0.0575390f, 2.25765f, 
		-3.86421f, -0.0575390f, 2.25765f, -3.86356f, 0.563678f, 2.01440f, 
		-3.86323f, 0.00234300f, 2.26962f, -3.86323f, 0.00234300f, 2.26962f, 
		-3.86323f, 0.00234300f, 2.26962f, -3.86323f, 0.00234300f, 2.26962f, 
		-3.86323f, 0.00234300f, 2.26962f, -3.86307f, 0.0958200f, 1.75208f, 
		-3.86307f, 0.0958200f, 1.75208f, -3.86307f, 0.0958200f, 1.75208f, 
		-3.86237f, 0.136924f, 1.83153f, -3.86237f, 0.136924f, 1.83153f, 
		-3.86237f, 0.136924f, 1.83153f, -3.86237f, 0.136924f, 1.83153f, 
		-3.86232f, 0.0735360f, 1.81918f, -3.86232f, 0.0735360f, 1.81918f, 
		-3.86232f, 0.0735360f, 1.81918f, -3.86230f, 0.0822730f, 1.73821f, 
		-3.86230f, 0.0822730f, 1.73821f, -3.86230f, 0.0822730f, 1.73821f, 
		-3.86230f, 0.0822730f, 1.73821f, -3.86230f, 0.0822730f, 1.73821f, 
		-3.86230f, 0.0822730f, 1.73821f, -3.86225f, -0.0579760f, 1.59951f, 
		-3.86225f, -0.0579760f, 1.59951f, -3.86111f, 0.115291f, 1.82025f, 
		-3.85967f, -0.196779f, 1.77762f, -3.85924f, 0.350216f, 2.01632f, 
		-3.85914f, 0.0275180f, 1.98872f, -3.85914f, 0.0275180f, 1.98872f, 
		-3.85898f, 0.0916710f, 1.81662f, -3.85898f, 0.0916710f, 1.81662f, 
		-3.85898f, 0.0916710f, 1.81662f, -3.85883f, 0.240469f, 1.59199f, 
		-3.85880f, -0.00858400f, 2.23695f, -3.85880f, -0.00858400f, 2.23695f, 
		-3.85880f, -0.00858400f, 2.23695f, -3.85880f, -0.00858400f, 2.23695f, 
		-3.85860f, 0.332994f, 1.54072f, -3.85860f, 0.332994f, 1.54072f, 
		-3.85860f, 0.332994f, 1.54072f, -3.85860f, 0.332994f, 1.54072f, 
		-3.85846f, 0.301517f, 1.56412f, -3.85820f, 0.628856f, 1.59742f, 
		-3.85809f, 0.219843f, 1.99711f, -3.85809f, 0.219843f, 1.99711f, 
		-3.85809f, 0.219843f, 1.99711f, -3.85809f, 0.219843f, 1.99711f, 
		-3.85809f, 0.219843f, 1.99711f, -3.85702f, 0.0634140f, 1.89917f, 
		-3.85702f, 0.0634140f, 1.89917f, -3.85702f, 0.0634140f, 1.89917f, 
		-3.85699f, 0.262013f, 1.99673f, -3.85699f, 0.262013f, 1.99673f, 
		-3.85699f, 0.262013f, 1.99673f, -3.85699f, 0.262013f, 1.99673f, 
		-3.85699f, 0.262013f, 1.99673f, -3.85699f, 0.262013f, 1.99673f, 
		-3.85698f, 0.0683450f, 1.83355f, -3.85698f, 0.0683450f, 1.83355f, 
		-3.85698f, 0.0683450f, 1.83355f, -3.85698f, 0.0683450f, 1.83355f, 
		-3.85698f, 0.0683450f, 1.83355f, -3.85698f, 0.0683450f, 1.83355f, 
		-3.85631f, 0.0706210f, 1.71080f, -3.85631f, 0.0706210f, 1.71080f, 
		-3.85631f, 0.0706210f, 1.71080f, -3.85631f, 0.0706210f, 1.71080f, 
		-3.85631f, 0.0706210f, 1.71080f, -3.85631f, 0.0706210f, 1.71080f, 
		-3.85625f, 0.433626f, 1.48426f, -3.85625f, 0.433626f, 1.48426f, 
		-3.85625f, 0.433626f, 1.48426f, -3.85625f, 0.433626f, 1.48426f, 
		-3.85574f, 0.166737f, 1.62327f, -3.85568f, 0.389846f, 1.50072f, 
		-3.85568f, 0.389846f, 1.50072f, -3.85568f, 0.389846f, 1.50072f, 
		-3.85568f, 0.389846f, 1.50072f, -3.85568f, 0.389846f, 1.50072f, 
		-3.85568f, 0.389846f, 1.50072f, -3.85471f, 0.782008f, 1.83737f, 
		-3.85471f, 0.782008f, 1.83737f, -3.85393f, -0.00218600f, 2.25634f, 
		-3.85393f, -0.00218600f, 2.25634f, -3.85393f, -0.00218600f, 2.25634f, 
		-3.85393f, -0.00218600f, 2.25634f, -3.85393f, -0.00218600f, 2.25634f, 
		-3.85344f, -0.0861340f, 1.55578f, -3.85344f, -0.0861340f, 1.55578f, 
		-3.85344f, -0.0861340f, 1.55578f, -3.85344f, -0.0861340f, 1.55578f, 
		-3.85344f, -0.0861340f, 1.55578f, -3.85327f, 0.334938f, 1.54445f, 
		-3.85270f, 0.0600710f, 1.69169f, -3.85270f, 0.0600710f, 1.69169f, 
		-3.85270f, 0.0600710f, 1.69169f, -3.85270f, 0.0600710f, 1.69169f, 
		-3.85270f, 0.0600710f, 1.69169f, -3.85270f, 0.0600710f, 1.69169f, 
		-3.85266f, 0.367663f, 1.53178f, -3.85236f, 0.341381f, 2.06298f, 
		-3.85236f, 0.341381f, 2.06298f, -3.85236f, 0.341381f, 2.06298f, 
		-3.85227f, 0.411290f, 1.51887f, -3.85207f, -0.0358200f, 2.29621f, 
		-3.85207f, -0.0358200f, 2.29621f, -3.85207f, -0.0358200f, 2.29621f, 
		-3.85207f, -0.0358200f, 2.29621f, -3.85207f, -0.0358200f, 2.29621f, 
		-3.85207f, -0.0358200f, 2.29621f, -3.85168f, 0.140439f, 1.72459f, 
		-3.85045f, 0.0431950f, 2.00460f, -3.85045f, 0.0431950f, 2.00460f, 
		-3.85045f, 0.0431950f, 2.00460f, -3.85045f, 0.0431950f, 2.00460f, 
		-3.85030f, -0.0149280f, 1.96548f, -3.85030f, -0.0149280f, 1.96548f, 
		-3.84998f, 0.322220f, 1.99340f, -3.84998f, 0.322220f, 1.99340f, 
		-3.84994f, 0.195299f, 1.95463f, -3.84994f, 0.195299f, 1.95463f, 
		-3.84994f, 0.195299f, 1.95463f, -3.84973f, -0.181426f, 1.82883f, 
		-3.84962f, 0.0776810f, 1.72289f, -3.84962f, 0.0776810f, 1.72289f, 
		-3.84962f, 0.0776810f, 1.72289f, -3.84962f, 0.0776810f, 1.72289f, 
		-3.84962f, 0.0776810f, 1.72289f, -3.84962f, 0.0776810f, 1.72289f, 
		-3.84962f, 0.0776810f, 1.72289f, -3.84962f, 0.616937f, 2.04304f, 
		-3.84945f, 0.285017f, 1.99756f, -3.84945f, 0.285017f, 1.99756f, 
		-3.84945f, 0.285017f, 1.99756f, -3.84945f, 0.285017f, 1.99756f, 
		-3.84945f, 0.285017f, 1.99756f, -3.84945f, 0.285017f, 1.99756f, 
		-3.84945f, 0.285017f, 1.99756f, -3.84922f, -0.0453790f, 1.92619f, 
		-3.84922f, -0.0453790f, 1.92619f, -3.84922f, -0.0453790f, 1.92619f, 
		-3.84922f, -0.0453790f, 1.92619f, -3.84922f, -0.0453790f, 1.92619f, 
		-3.84922f, -0.0453790f, 1.92619f, -3.84856f, 0.0915840f, 1.70654f, 
		-3.84856f, 0.0915840f, 1.70654f, -3.84856f, 0.0915840f, 1.70654f, 
		-3.84856f, 0.0915840f, 1.70654f, -3.84833f, -0.112010f, 1.59131f, 
		-3.84833f, -0.112010f, 1.59131f, -3.84833f, -0.112010f, 1.59131f, 
		-3.84817f, -0.196178f, 1.72531f, -3.84772f, 0.0676690f, 1.87286f, 
		-3.84772f, 0.0676690f, 1.87286f, -3.84770f, 0.233730f, 1.98995f, 
		-3.84770f, 0.233730f, 1.98995f, -3.84770f, 0.233730f, 1.98995f, 
		-3.84770f, 0.233730f, 1.98995f, -3.84753f, -0.0600760f, 2.25867f, 
		-3.84753f, -0.0600760f, 2.25867f, -3.84753f, -0.0600760f, 2.25867f, 
		-3.84753f, -0.0600760f, 2.25867f, -3.84737f, 0.183439f, 1.92339f, 
		-3.84737f, 0.183439f, 1.92339f, -3.84737f, 0.183439f, 1.92339f, 
		-3.84684f, 0.0928000f, 1.70871f, -3.84684f, 0.0928000f, 1.70871f, 
		-3.84684f, 0.0928000f, 1.70871f, -3.84684f, 0.0928000f, 1.70871f, 
		-3.84655f, 0.692238f, 1.86023f, -3.84645f, 0.231038f, 1.58233f, 
		-3.84642f, 0.550274f, 1.54168f, -3.84628f, 0.283138f, 1.55329f, 
		-3.84628f, 0.283138f, 1.55329f, -3.84628f, 0.283138f, 1.55329f, 
		-3.84613f, -0.0588490f, 2.28473f, -3.84613f, -0.0588490f, 2.28473f, 
		-3.84613f, -0.0588490f, 2.28473f, -3.84613f, -0.0588490f, 2.28473f, 
		-3.84610f, 0.248758f, 1.96969f, -3.84610f, 0.248758f, 1.96969f, 
		-3.84610f, 0.248758f, 1.96969f, -3.84609f, 0.669445f, 1.57536f, 
		-3.84608f, 0.117667f, 1.74343f, -3.84608f, 0.117667f, 1.74343f, 
		-3.84608f, 0.117667f, 1.74343f, -3.84608f, 0.117667f, 1.74343f, 
		-3.84608f, 0.117667f, 1.74343f, -3.84590f, 0.299277f, 2.00217f, 
		-3.84584f, 0.0981120f, 1.74289f, -3.84584f, 0.0981120f, 1.74289f, 
		-3.84584f, 0.0981120f, 1.74289f, -3.84584f, 0.0981120f, 1.74289f, 
		-3.84584f, 0.0981120f, 1.74289f, -3.84490f, 0.0823180f, 1.83132f, 
		-3.84490f, 0.0823180f, 1.83132f, -3.84490f, 0.0823180f, 1.83132f, 
		-3.84490f, 0.0823180f, 1.83132f, -3.84490f, 0.0823180f, 1.83132f, 
		-3.84490f, 0.0823180f, 1.83132f, -3.84448f, 0.156213f, 1.86833f, 
		-3.84379f, -0.0733110f, 1.90690f, -3.84379f, -0.0733110f, 1.90690f, 
		-3.84379f, -0.0733110f, 1.90690f, -3.84329f, -0.265637f, 1.77340f, 
		-3.84315f, 0.0706660f, 1.84935f, -3.84315f, 0.0706660f, 1.84935f, 
		-3.84315f, 0.0706660f, 1.84935f, -3.84315f, 0.0706660f, 1.84935f, 
		-3.84315f, 0.0706660f, 1.84935f, -3.84313f, -0.127202f, 1.89100f, 
		-3.84313f, -0.127202f, 1.89100f, -3.84313f, -0.127202f, 1.89100f, 
		-3.84300f, -0.121176f, 1.66349f, -3.84300f, -0.121176f, 1.66349f, 
		-3.84300f, -0.121176f, 1.66349f, -3.84300f, -0.121176f, 1.66349f, 
		-3.84259f, 0.0600940f, 1.86496f, -3.84259f, 0.0600940f, 1.86496f, 
		-3.84259f, 0.0600940f, 1.86496f, -3.84259f, 0.0600940f, 1.86496f, 
		-3.84259f, 0.0600940f, 1.86496f, -3.84259f, 0.0600940f, 1.86496f, 
		-3.84259f, 0.773408f, 1.87724f, -3.84192f, 0.294777f, 2.03531f, 
		-3.84192f, 0.294777f, 2.03531f, -3.84192f, 0.294777f, 2.03531f, 
		-3.84192f, 0.294777f, 2.03531f, -3.84192f, 0.294777f, 2.03531f, 
		-3.84192f, 0.294777f, 2.03531f, -3.84192f, 0.294777f, 2.03531f, 
		-3.84192f, 0.294777f, 2.03531f, -3.84160f, -0.104491f, 1.60835f, 
		-3.84160f, -0.104491f, 1.60835f, -3.84127f, 0.115955f, 1.82763f, 
		-3.84119f, -0.0459530f, 2.25840f, -3.84119f, -0.0459530f, 2.25840f, 
		-3.84119f, -0.0459530f, 2.25840f, -3.84090f, -0.149402f, 1.63005f, 
		-3.84090f, -0.149402f, 1.63005f, -3.84090f, -0.149402f, 1.63005f, 
		-3.84090f, -0.149402f, 1.63005f, -3.84090f, -0.149402f, 1.63005f, 
		-3.84082f, 0.0568070f, 1.67990f, -3.84082f, 0.0568070f, 1.67990f, 
		-3.84082f, 0.0568070f, 1.67990f, -3.84059f, 0.0958880f, 1.82708f, 
		-3.84059f, 0.0958880f, 1.82708f, -3.84059f, 0.0958880f, 1.82708f, 
		-3.84048f, 0.178366f, 1.94535f, -3.84048f, 0.178366f, 1.94535f, 
		-3.84048f, 0.178366f, 1.94535f, -3.84031f, 0.0858710f, 1.73398f, 
		-3.84031f, 0.0858710f, 1.73398f, -3.84031f, 0.0858710f, 1.73398f, 
		-3.84013f, 0.294869f, 1.56105f, -3.83992f, 0.279061f, 2.01776f, 
		-3.83992f, 0.279061f, 2.01776f, -3.83992f, 0.279061f, 2.01776f, 
		-3.83992f, 0.279061f, 2.01776f, -3.83992f, 0.279061f, 2.01776f, 
		-3.83964f, -0.0956190f, 1.56226f, -3.83964f, -0.0956190f, 1.56226f, 
		-3.83964f, -0.0956190f, 1.56226f, -3.83964f, -0.0956190f, 1.56226f, 
		-3.83964f, -0.0956190f, 1.56226f, -3.83885f, 0.465451f, 1.51527f, 
		-3.83864f, 0.0928070f, 1.84739f, -3.83864f, 0.0928070f, 1.84739f, 
		-3.83864f, 0.0928070f, 1.84739f, -3.83828f, 0.158662f, 1.61310f, 
		-3.83758f, 0.0953520f, 1.84949f, -3.83758f, 0.0953520f, 1.84949f, 
		-3.83758f, 0.0953520f, 1.84949f, -3.83756f, 0.0507800f, 1.94987f, 
		-3.83756f, 0.0507800f, 1.94987f, -3.83756f, 0.0507800f, 1.94987f, 
		-3.83756f, 0.0507800f, 1.94987f, -3.83756f, 0.0507800f, 1.94987f, 
		-3.83715f, 0.518044f, 1.49571f, -3.83657f, 0.137935f, 1.84051f, 
		-3.83656f, -0.0406640f, 2.27871f, -3.83656f, -0.0406640f, 2.27871f, 
		-3.83656f, -0.0406640f, 2.27871f, -3.83656f, -0.0406640f, 2.27871f, 
		-3.83656f, -0.0406640f, 2.27871f, -3.83644f, 0.0590080f, 1.90163f, 
		-3.83644f, 0.0590080f, 1.90163f, -3.83644f, 0.0590080f, 1.90163f, 
		-3.83644f, 0.0590080f, 1.90163f, -3.83644f, 0.0590080f, 1.90163f, 
		-3.83644f, 0.0590080f, 1.90163f, -3.83603f, 0.666420f, 1.91571f, 
		-3.83544f, 0.239933f, 1.98274f, -3.83425f, 0.244143f, 1.98163f, 
		-3.83425f, 0.244143f, 1.98163f, -3.83425f, 0.244143f, 1.98163f, 
		-3.83425f, 0.244143f, 1.98163f, -3.83423f, 0.0777220f, 1.83845f, 
		-3.83423f, 0.0777220f, 1.83845f, -3.83423f, 0.0777220f, 1.83845f, 
		-3.83423f, 0.0777220f, 1.83845f, -3.83423f, 0.0777220f, 1.83845f, 
		-3.83423f, 0.0777220f, 1.83845f, -3.83365f, 0.710171f, 1.67453f, 
		-3.83365f, 0.710171f, 1.67453f, -3.83365f, 0.710171f, 1.67453f, 
		-3.83365f, 0.710171f, 1.67453f, -3.83340f, -0.181084f, 1.66446f, 
		-3.83340f, -0.181084f, 1.66446f, -3.83340f, -0.181084f, 1.66446f, 
		-3.83290f, -0.0253570f, 1.60261f, -3.83222f, 0.201484f, 1.95954f, 
		-3.83222f, 0.201484f, 1.95954f, -3.83222f, 0.201484f, 1.95954f, 
		-3.83222f, 0.201484f, 1.95954f, -3.83222f, 0.201484f, 1.95954f, 
		-3.83222f, 0.201484f, 1.95954f, -3.83222f, 0.201484f, 1.95954f, 
		-3.83187f, 0.509932f, 2.03465f, -3.83174f, -0.0907840f, 1.66343f, 
		-3.83174f, -0.0907840f, 1.66343f, -3.83174f, -0.0907840f, 1.66343f, 
		-3.83174f, -0.0907840f, 1.66343f, -3.83154f, -0.0889090f, 1.58324f, 
		-3.83154f, -0.0889090f, 1.58324f, -3.83154f, -0.0889090f, 1.58324f, 
		-3.83154f, -0.0889090f, 1.58324f, -3.83073f, -0.142155f, 1.61813f, 
		-3.83073f, -0.142155f, 1.61813f, -3.83073f, -0.142155f, 1.61813f, 
		-3.83073f, -0.142155f, 1.61813f, -3.83073f, -0.142155f, 1.61813f, 
		-3.83067f, 0.340555f, 1.51861f, -3.83067f, 0.340555f, 1.51861f, 
		-3.83059f, 0.630006f, 1.96654f, -3.83004f, 0.718639f, 1.64731f, 
		-3.83004f, 0.718639f, 1.64731f, -3.83004f, 0.718639f, 1.64731f, 
		-3.83003f, 0.0700990f, 1.69435f, -3.83003f, 0.0700990f, 1.69435f, 
		-3.83003f, 0.0700990f, 1.69435f, -3.83003f, 0.0700990f, 1.69435f, 
		-3.83002f, 0.341798f, 2.01392f, -3.83002f, 0.341798f, 2.01392f, 
		-3.83002f, 0.341798f, 2.01392f, -3.83002f, 0.341798f, 2.01392f, 
		-3.83002f, 0.341798f, 2.01392f, -3.82993f, 0.358741f, 1.52961f, 
		-3.82974f, -0.174837f, 1.88910f, -3.82974f, -0.174837f, 1.88910f, 
		-3.82974f, -0.174837f, 1.88910f, -3.82974f, -0.174837f, 1.88910f, 
		-3.82967f, 0.576726f, 2.01004f, -3.82877f, 0.0589730f, 1.68869f, 
		-3.82877f, 0.0589730f, 1.68869f, -3.82877f, 0.0589730f, 1.68869f, 
		-3.82877f, 0.0589730f, 1.68869f, -3.82877f, 0.0589730f, 1.68869f, 
		-3.82877f, 0.0589730f, 1.68869f, -3.82864f, 0.00196200f, 1.61016f, 
		-3.82864f, 0.00196200f, 1.61016f, -3.82864f, 0.00196200f, 1.61016f, 
		-3.82864f, 0.00196200f, 1.61016f, -3.82864f, 0.00196200f, 1.61016f, 
		-3.82864f, 0.00196200f, 1.61016f, -3.82848f, -0.0428970f, 1.59050f, 
		-3.82847f, -0.108540f, 1.65380f, -3.82847f, -0.108540f, 1.65380f, 
		-3.82847f, -0.108540f, 1.65380f, -3.82847f, -0.108540f, 1.65380f, 
		-3.82847f, -0.108540f, 1.65380f, -3.82740f, 0.185321f, 1.97083f, 
		-3.82740f, 0.185321f, 1.97083f, -3.82740f, 0.185321f, 1.97083f, 
		-3.82740f, 0.185321f, 1.97083f, -3.82714f, 0.327590f, 1.54118f, 
		-3.82690f, 0.00640800f, 1.87593f, -3.82690f, 0.00640800f, 1.87593f, 
		-3.82690f, 0.00640800f, 1.87593f, -3.82690f, 0.00640800f, 1.87593f, 
		-3.82690f, 0.00640800f, 1.87593f, -3.82630f, -0.0291050f, 1.93482f, 
		-3.82630f, -0.0291050f, 1.93482f, -3.82630f, -0.0291050f, 1.93482f, 
		-3.82630f, -0.0291050f, 1.93482f, -3.82630f, -0.0291050f, 1.93482f, 
		-3.82573f, 0.0186820f, 1.96872f, -3.82573f, 0.0186820f, 1.96872f, 
		-3.82544f, 0.173278f, 1.95699f, -3.82544f, 0.173278f, 1.95699f, 
		-3.82544f, 0.173278f, 1.95699f, -3.82544f, 0.173278f, 1.95699f, 
		-3.82523f, 0.0640580f, 1.87463f, -3.82392f, -0.0754420f, 1.54238f, 
		-3.82392f, -0.0754420f, 1.54238f, -3.82388f, 0.143108f, 1.70356f, 
		-3.82388f, 0.143108f, 1.70356f, -3.82388f, 0.143108f, 1.70356f, 
		-3.82306f, 0.391139f, 1.51505f, -3.82304f, -0.0944260f, 1.66325f, 
		-3.82304f, -0.0944260f, 1.66325f, -3.82304f, -0.0944260f, 1.66325f, 
		-3.82304f, -0.0944260f, 1.66325f, -3.82304f, -0.0944260f, 1.66325f, 
		-3.82304f, -0.0944260f, 1.66325f, -3.82279f, 0.0650240f, 1.72576f, 
		-3.82279f, 0.0650240f, 1.72576f, -3.82263f, 0.0963810f, 1.70364f, 
		-3.82263f, 0.0963810f, 1.70364f, -3.82263f, 0.0963810f, 1.70364f, 
		-3.82263f, 0.0963810f, 1.70364f, -3.82263f, 0.0963810f, 1.70364f, 
		-3.82257f, 0.0962320f, 1.74351f, -3.82257f, 0.0962320f, 1.74351f, 
		-3.82257f, 0.0962320f, 1.74351f, -3.82257f, 0.0962320f, 1.74351f, 
		-3.82257f, 0.0962320f, 1.74351f, -3.82257f, 0.0858940f, 1.82738f, 
		-3.82257f, 0.0858940f, 1.82738f, -3.82242f, 0.145185f, 1.67808f, 
		-3.82223f, -0.280225f, 1.83264f, -3.82207f, 0.0989010f, 1.70129f, 
		-3.82207f, 0.0989010f, 1.70129f, -3.82207f, 0.0989010f, 1.70129f, 
		-3.82199f, -0.0163680f, 1.88921f, -3.82199f, -0.0163680f, 1.88921f, 
		-3.82199f, -0.0163680f, 1.88921f, -3.82199f, -0.0163680f, 1.88921f, 
		-3.82161f, 0.335992f, 1.53130f, -3.82161f, 0.335992f, 1.53130f, 
		-3.82161f, 0.335992f, 1.53130f, -3.82161f, 0.335992f, 1.53130f, 
		-3.82148f, 0.181216f, 1.93725f, -3.82122f, 0.223401f, 1.56842f, 
		-3.82118f, -0.131439f, 1.57392f, -3.82118f, -0.131439f, 1.57392f, 
		-3.82118f, -0.131439f, 1.57392f, -3.82118f, -0.131439f, 1.57392f, 
		-3.82118f, -0.131439f, 1.57392f, -3.82118f, -0.131439f, 1.57392f, 
		-3.82118f, -0.131439f, 1.57392f, -3.82116f, 0.0707830f, 1.84475f, 
		-3.82116f, 0.0707830f, 1.84475f, -3.82085f, 0.288192f, 1.55393f, 
		-3.82040f, 0.701643f, 1.70720f, -3.82027f, 0.739748f, 1.93060f, 
		-3.81990f, 0.490857f, 2.07837f, -3.81990f, 0.490857f, 2.07837f, 
		-3.81965f, 0.0981730f, 1.82573f, -3.81955f, 0.339536f, 2.04130f, 
		-3.81955f, 0.339536f, 2.04130f, -3.81955f, 0.339536f, 2.04130f, 
		-3.81953f, 0.00860000f, 1.71700f, -3.81953f, 0.00860000f, 1.71700f, 
		-3.81953f, 0.00860000f, 1.71700f, -3.81951f, 0.0499770f, 1.93201f, 
		-3.81951f, 0.0499770f, 1.93201f, -3.81951f, 0.0499770f, 1.93201f, 
		-3.81947f, 0.000907000f, 1.68258f, -3.81947f, 0.000907000f, 1.68258f, 
		-3.81947f, 0.000907000f, 1.68258f, -3.81947f, 0.000907000f, 1.68258f, 
		-3.81947f, 0.000907000f, 1.68258f, -3.81947f, 0.000907000f, 1.68258f, 
		-3.81930f, -0.161944f, 1.55630f, -3.81930f, -0.161944f, 1.55630f, 
		-3.81930f, -0.161944f, 1.55630f, -3.81930f, -0.161944f, 1.55630f, 
		-3.81930f, -0.161944f, 1.55630f, -3.81930f, -0.161944f, 1.55630f, 
		-3.81890f, -0.244817f, 1.89086f, -3.81890f, -0.244817f, 1.89086f, 
		-3.81890f, -0.244817f, 1.89086f, -3.81890f, -0.244817f, 1.89086f, 
		-3.81890f, -0.244817f, 1.89086f, -3.81884f, 0.117964f, 1.73509f, 
		-3.81862f, 0.0254360f, 1.88182f, -3.81862f, 0.0254360f, 1.88182f, 
		-3.81862f, 0.0254360f, 1.88182f, -3.81824f, 0.772051f, 1.72952f, 
		-3.81802f, 0.371891f, 2.01124f, -3.81802f, 0.371891f, 2.01124f, 
		-3.81802f, 0.371891f, 2.01124f, -3.81802f, 0.371891f, 2.01124f, 
		-3.81745f, -0.132796f, 1.62673f, -3.81745f, -0.132796f, 1.62673f, 
		-3.81745f, -0.132796f, 1.62673f, -3.81745f, -0.132796f, 1.62673f, 
		-3.81745f, -0.132796f, 1.62673f, -3.81737f, -0.0895990f, 1.55222f, 
		-3.81737f, -0.0895990f, 1.55222f, -3.81737f, -0.0895990f, 1.55222f, 
		-3.81737f, -0.0895990f, 1.55222f, -3.81737f, -0.0895990f, 1.55222f, 
		-3.81678f, 0.568820f, 1.53018f, -3.81614f, -0.119243f, 1.59392f, 
		-3.81614f, -0.119243f, 1.59392f, -3.81614f, -0.00271000f, 1.70772f, 
		-3.81614f, -0.00271000f, 1.70772f, -3.81614f, -0.00271000f, 1.70772f, 
		-3.81614f, -0.00271000f, 1.70772f, -3.81590f, 0.0636030f, 1.86479f, 
		-3.81590f, 0.0636030f, 1.86479f, -3.81590f, 0.0636030f, 1.86479f, 
		-3.81590f, 0.0636030f, 1.86479f, -3.81590f, 0.0636030f, 1.86479f, 
		-3.81590f, 0.0636030f, 1.86479f, -3.81582f, -0.273273f, 1.71565f, 
		-3.81565f, -0.000705000f, 1.74028f, -3.81565f, -0.000705000f, 1.74028f, 
		-3.81556f, 0.0193430f, 1.70184f, -3.81556f, 0.0193430f, 1.70184f, 
		-3.81556f, 0.0193430f, 1.70184f, -3.81556f, 0.0193430f, 1.70184f, 
		-3.81556f, 0.0193430f, 1.70184f, -3.81519f, 0.0210010f, 1.73568f, 
		-3.81519f, 0.0210010f, 1.73568f, -3.81516f, 0.330102f, 2.01490f, 
		-3.81511f, -0.142275f, 1.57399f, -3.81511f, -0.142275f, 1.57399f, 
		-3.81511f, -0.142275f, 1.57399f, -3.81476f, 0.0964240f, 1.84945f, 
		-3.81476f, 0.0964240f, 1.84945f, -3.81476f, 0.0964240f, 1.84945f, 
		-3.81456f, -0.0221820f, 1.66544f, -3.81456f, -0.0221820f, 1.66544f, 
		-3.81456f, -0.0221820f, 1.66544f, -3.81456f, -0.0221820f, 1.66544f, 
		-3.81456f, -0.0221820f, 1.66544f, -3.81456f, -0.0221820f, 1.66544f, 
		-3.81445f, 0.00760700f, 1.86391f, -3.81445f, 0.00760700f, 1.86391f, 
		-3.81445f, 0.00760700f, 1.86391f, -3.81445f, 0.00760700f, 1.86391f, 
		-3.81445f, 0.00760700f, 1.86391f, -3.81445f, 0.00760700f, 1.86391f, 
		-3.81445f, 0.00760700f, 1.86391f, -3.81445f, 0.00760700f, 1.86391f, 
		-3.81445f, 0.00760700f, 1.86391f, -3.81441f, 0.0154210f, 1.67465f, 
		-3.81441f, 0.0154210f, 1.67465f, -3.81441f, 0.0154210f, 1.67465f, 
		-3.81441f, 0.0154210f, 1.67465f, -3.81435f, 0.345456f, 2.03874f, 
		-3.81435f, 0.345456f, 2.03874f, -3.81435f, 0.345456f, 2.03874f, 
		-3.81435f, 0.345456f, 2.03874f, -3.81435f, 0.345456f, 2.03874f, 
		-3.81435f, 0.345456f, 2.03874f, -3.81432f, -0.136731f, 1.53238f, 
		-3.81432f, -0.136731f, 1.53238f, -3.81432f, -0.136731f, 1.53238f, 
		-3.81432f, -0.136731f, 1.53238f, -3.81425f, 0.433931f, 2.03405f, 
		-3.81415f, -0.0207260f, 1.65241f, -3.81415f, -0.0207260f, 1.65241f, 
		-3.81415f, -0.0207260f, 1.65241f, -3.81394f, 0.131470f, 1.67059f, 
		-3.81392f, 0.0989430f, 1.85172f, -3.81392f, 0.0989430f, 1.85172f, 
		-3.81392f, 0.0989430f, 1.85172f, -3.81392f, 0.0989430f, 1.85172f, 
		-3.81387f, 0.000150000f, 1.80473f, -3.81387f, 0.000150000f, 1.80473f, 
		-3.81387f, 0.000150000f, 1.80473f, -3.81252f, 0.117754f, 1.82705f, 
		-3.81251f, -0.244918f, 1.66184f, -3.81192f, -0.125027f, 1.55805f, 
		-3.81192f, -0.125027f, 1.55805f, -3.81192f, -0.125027f, 1.55805f, 
		-3.81192f, -0.125027f, 1.55805f, -3.81192f, -0.125027f, 1.55805f, 
		-3.81179f, -0.00442900f, 1.83837f, -3.81179f, -0.00442900f, 1.83837f, 
		-3.81179f, -0.00442900f, 1.83837f, -3.81179f, -0.00442900f, 1.83837f, 
		-3.81166f, -0.00416500f, 1.86060f, -3.81166f, -0.00416500f, 1.86060f, 
		-3.81166f, -0.00416500f, 1.86060f, -3.81166f, -0.00416500f, 1.86060f, 
		-3.81154f, -0.162515f, 1.61500f, -3.81154f, -0.162515f, 1.61500f, 
		-3.81154f, -0.162515f, 1.61500f, -3.81131f, 0.0650140f, 1.82841f, 
		-3.81131f, 0.0650140f, 1.82841f, -3.81077f, -0.0819130f, 1.57594f, 
		-3.81065f, -0.162998f, 1.61702f, -3.81065f, -0.162998f, 1.61702f, 
		-3.81065f, -0.162998f, 1.61702f, -3.81065f, -0.162998f, 1.61702f, 
		-3.81065f, -0.162998f, 1.61702f, -3.81030f, 0.0171670f, 1.84119f, 
		-3.81030f, 0.0171670f, 1.84119f, -3.81030f, 0.0171670f, 1.84119f, 
		-3.81030f, 0.0171670f, 1.84119f, -3.81030f, 0.0171670f, 1.84119f, 
		-3.81018f, 0.0128350f, 1.94100f, -3.81018f, 0.0128350f, 1.94100f, 
		-3.81018f, 0.0128350f, 1.94100f, -3.81018f, 0.0128350f, 1.94100f, 
		-3.81003f, 0.0168840f, 1.80817f, -3.81003f, 0.0168840f, 1.80817f, 
		-3.80993f, 0.0757350f, 1.74172f, -3.80968f, -0.0101520f, 1.64811f, 
		-3.80968f, -0.0101520f, 1.64811f, -3.80968f, -0.0101520f, 1.64811f, 
		-3.80949f, 0.0177610f, 1.86293f, -3.80949f, 0.0177610f, 1.86293f, 
		-3.80949f, 0.0177610f, 1.86293f, -3.80949f, 0.0177610f, 1.86293f, 
		-3.80842f, -0.139016f, 1.55435f, -3.80842f, -0.139016f, 1.55435f, 
		-3.80842f, -0.139016f, 1.55435f, -3.80842f, -0.139016f, 1.55435f, 
		-3.80841f, 0.484980f, 1.48365f, -3.80841f, 0.484980f, 1.48365f, 
		-3.80841f, 0.484980f, 1.48365f, -3.80841f, 0.484980f, 1.48365f, 
		-3.80817f, 0.351450f, 1.52913f, -3.80745f, -0.148884f, 1.59859f, 
		-3.80745f, -0.148884f, 1.59859f, -3.80745f, -0.148884f, 1.59859f, 
		-3.80745f, -0.148884f, 1.59859f, -3.80745f, -0.148884f, 1.59859f, 
		-3.80706f, -0.301830f, 1.77241f, -3.80706f, -0.301830f, 1.77241f, 
		-3.80684f, -0.0771020f, 1.91586f, -3.80684f, -0.0771020f, 1.91586f, 
		-3.80684f, -0.0771020f, 1.91586f, -3.80645f, 0.664715f, 1.62575f, 
		-3.80622f, 0.326226f, 1.53502f, -3.80602f, -0.192454f, 1.54822f, 
		-3.80602f, -0.192454f, 1.54822f, -3.80602f, -0.192454f, 1.54822f, 
		-3.80602f, -0.192454f, 1.54822f, -3.80602f, -0.192454f, 1.54822f, 
		-3.80602f, -0.192454f, 1.54822f, -3.80522f, 0.346019f, 1.63730f, 
		-3.80510f, 0.522505f, 1.51780f, -3.80465f, 0.335542f, 1.65534f, 
		-3.80448f, -0.302235f, 1.75291f, -3.80448f, -0.302235f, 1.75291f, 
		-3.80368f, 0.351681f, 2.02454f, -3.80368f, 0.351681f, 2.02454f, 
		-3.80368f, 0.351681f, 2.02454f, -3.80368f, 0.351681f, 2.02454f, 
		-3.80352f, -0.0150200f, 1.91021f, -3.80352f, -0.0150200f, 1.91021f, 
		-3.80352f, -0.0150200f, 1.91021f, -3.80352f, -0.0150200f, 1.91021f, 
		-3.80344f, 0.326274f, 1.62848f, -3.80342f, -0.296241f, 1.77228f, 
		-3.80334f, 0.0595740f, 1.69906f, -3.80334f, 0.0595740f, 1.69906f, 
		-3.80334f, 0.0595740f, 1.69906f, -3.80334f, 0.0595740f, 1.69906f, 
		-3.80324f, -0.127430f, 1.64407f, -3.80324f, -0.127430f, 1.64407f, 
		-3.80315f, -0.303702f, 1.79173f, -3.80315f, -0.303702f, 1.79173f, 
		-3.80278f, 0.412715f, 1.49864f, -3.80278f, 0.412715f, 1.49864f, 
		-3.80278f, 0.412715f, 1.49864f, -3.80278f, 0.412715f, 1.49864f, 
		-3.80254f, -0.308552f, 1.72984f, -3.80254f, -0.308552f, 1.72984f, 
		-3.80253f, -0.185004f, 1.53342f, -3.80253f, -0.185004f, 1.53342f, 
		-3.80253f, -0.185004f, 1.53342f, -3.80252f, -0.339308f, 1.76817f, 
		-3.80225f, 0.436173f, 1.50487f, -3.80222f, -0.183383f, 1.64096f, 
		-3.80222f, -0.183383f, 1.64096f, -3.80222f, -0.183383f, 1.64096f, 
		-3.80166f, 0.253965f, 1.98276f, -3.80135f, -0.354080f, 1.82980f, 
		-3.80135f, -0.354080f, 1.82980f, -3.80135f, -0.354080f, 1.82980f, 
		-3.80103f, 0.122029f, 1.66056f, -3.80103f, 0.155485f, 1.60225f, 
		-3.80100f, -0.297088f, 1.75280f, -3.80098f, 0.362149f, 1.62385f, 
		-3.80095f, 0.366356f, 1.65470f, -3.80070f, 0.337258f, 1.67100f, 
		-3.80045f, 0.0268170f, 1.90210f, -3.80045f, 0.0268170f, 1.90210f, 
		-3.80045f, 0.0268170f, 1.90210f, -3.80045f, 0.0268170f, 1.90210f, 
		-3.80044f, 0.0756990f, 1.80974f, -3.80042f, 0.310738f, 1.63777f, 
		-3.79991f, 0.341916f, 1.61040f, -3.79978f, 0.160476f, 1.75969f, 
		-3.79978f, 0.160476f, 1.75969f, -3.79978f, 0.160476f, 1.75969f, 
		-3.79978f, 0.160476f, 1.75969f, -3.79976f, 0.0594200f, 1.68809f, 
		-3.79976f, 0.0594200f, 1.68809f, -3.79959f, -0.311464f, 1.81405f, 
		-3.79959f, -0.311464f, 1.81405f, -3.79944f, 0.140739f, 1.84433f, 
		-3.79908f, -0.164978f, 1.57811f, -3.79908f, -0.164978f, 1.57811f, 
		-3.79908f, -0.164978f, 1.57811f, -3.79908f, -0.164978f, 1.57811f, 
		-3.79908f, -0.164978f, 1.57811f, -3.79900f, 0.361668f, 2.02171f, 
		-3.79900f, 0.361668f, 2.02171f, -3.79900f, 0.361668f, 2.02171f, 
		-3.79900f, 0.361668f, 2.02171f, -3.79900f, 0.361668f, 2.02171f, 
		-3.79900f, 0.361668f, 2.02171f, -3.79888f, 0.0963010f, 1.81150f, 
		-3.79867f, 0.166605f, 1.76421f, -3.79867f, 0.166605f, 1.76421f, 
		-3.79866f, 0.452332f, 1.48917f, -3.79866f, 0.452332f, 1.48917f, 
		-3.79841f, -0.302560f, 1.73339f, -3.79841f, -0.302560f, 1.73339f, 
		-3.79841f, -0.302560f, 1.73339f, -3.79828f, 0.281399f, 1.54161f, 
		-3.79821f, -0.316735f, 1.77209f, -3.79817f, 0.372653f, 1.51972f, 
		-3.79800f, 0.150719f, 1.75449f, -3.79800f, 0.150719f, 1.75449f, 
		-3.79800f, 0.150719f, 1.75449f, -3.79800f, 0.150719f, 1.75449f, 
		-3.79798f, 0.603906f, 2.04889f, -3.79798f, 0.603906f, 2.04889f, 
		-3.79750f, 0.0574450f, 1.83464f, -3.79750f, 0.0574450f, 1.83464f, 
		-3.79750f, 0.0574450f, 1.83464f, -3.79750f, 0.0574450f, 1.83464f, 
		-3.79746f, -0.298109f, 1.79337f, -3.79740f, -0.145660f, 1.59369f, 
		-3.79740f, -0.145660f, 1.59369f, -3.79740f, -0.145660f, 1.59369f, 
		-3.79740f, -0.145660f, 1.59369f, -3.79740f, -0.145660f, 1.59369f, 
		-3.79706f, -0.128210f, 1.55454f, -3.79706f, -0.128210f, 1.55454f, 
		-3.79706f, -0.128210f, 1.55454f, -3.79706f, -0.128210f, 1.55454f, 
		-3.79706f, -0.128210f, 1.55454f, -3.79706f, -0.128210f, 1.55454f, 
		-3.79702f, 0.0496170f, 1.73581f, -3.79702f, 0.0496170f, 1.73581f, 
		-3.79702f, 0.0496170f, 1.73581f, -3.79702f, -0.0361890f, 1.67844f, 
		-3.79702f, -0.0361890f, 1.67844f, -3.79702f, -0.0361890f, 1.67844f, 
		-3.79702f, -0.0361890f, 1.67844f, -3.79702f, -0.0361890f, 1.67844f, 
		-3.79697f, 0.313428f, 1.66860f, -3.79664f, -0.0877710f, 1.66500f, 
		-3.79664f, -0.0877710f, 1.66500f, -3.79664f, -0.0877710f, 1.66500f, 
		-3.79664f, -0.0877710f, 1.66500f, -3.79657f, -0.316006f, 1.72950f, 
		-3.79613f, 0.169290f, 1.76835f, -3.79613f, 0.169290f, 1.76835f, 
		-3.79603f, 0.356139f, 1.67871f, -3.79575f, 0.378979f, 1.62896f, 
		-3.79567f, 0.162247f, 1.87935f, -3.79535f, -0.0196150f, 1.68404f, 
		-3.79535f, -0.0196150f, 1.68404f, -3.79535f, -0.0196150f, 1.68404f, 
		-3.79535f, -0.0196150f, 1.68404f, -3.79535f, -0.0196150f, 1.68404f, 
		-3.79510f, -0.0174460f, 1.70525f, -3.79510f, -0.0174460f, 1.70525f, 
		-3.79510f, -0.0174460f, 1.70525f, -3.79510f, -0.0174460f, 1.70525f, 
		-3.79487f, 0.298899f, 1.65066f, -3.79485f, 0.197881f, 1.95258f, 
		-3.79485f, 0.197881f, 1.95258f, -3.79485f, 0.197881f, 1.95258f, 
		-3.79485f, 0.197881f, 1.95258f, -3.79437f, -0.0160570f, 1.73723f, 
		-3.79437f, -0.0160570f, 1.73723f, -3.79432f, -0.176514f, 1.91113f, 
		-3.79432f, -0.176514f, 1.91113f, -3.79400f, 0.0878240f, 1.72203f, 
		-3.79400f, 0.0878240f, 1.72203f, -3.79400f, 0.0878240f, 1.72203f, 
		-3.79391f, 0.0938030f, 1.74650f, -3.79391f, 0.0938030f, 1.74650f, 
		-3.79391f, 0.0938030f, 1.74650f, -3.79387f, 0.316696f, 1.60416f, 
		-3.79380f, -0.174325f, 1.52554f, -3.79380f, -0.174325f, 1.52554f, 
		-3.79380f, -0.174325f, 1.52554f, -3.79380f, -0.174325f, 1.52554f, 
		-3.79380f, -0.174325f, 1.52554f, -3.79380f, -0.174325f, 1.52554f, 
		-3.79377f, -0.135838f, 1.52677f, -3.79377f, -0.135838f, 1.52677f, 
		-3.79377f, -0.135838f, 1.52677f, -3.79359f, 0.169813f, 1.77414f, 
		-3.79359f, 0.169813f, 1.77414f, -3.79357f, 0.320562f, 2.01208f, 
		-3.79343f, 0.0903450f, 1.71963f, -3.79343f, 0.0903450f, 1.71963f, 
		-3.79343f, 0.0903450f, 1.71963f, -3.79343f, 0.0903450f, 1.71963f, 
		-3.79338f, -0.124118f, 1.91220f, -3.79338f, -0.124118f, 1.91220f, 
		-3.79333f, -0.319298f, 1.81177f, -3.79310f, 0.374784f, 2.01359f, 
		-3.79310f, 0.374784f, 2.01359f, -3.79310f, 0.374784f, 2.01359f, 
		-3.79310f, 0.374784f, 2.01359f, -3.79309f, 0.00464400f, 1.91730f, 
		-3.79309f, 0.00464400f, 1.91730f, -3.79309f, 0.00464400f, 1.91730f, 
		-3.79309f, 0.00464400f, 1.91730f, -3.79309f, 0.00464400f, 1.91730f, 
		-3.79309f, 0.00464400f, 1.91730f, -3.79268f, -0.340335f, 1.30024f, 
		-3.79268f, -0.340335f, 1.30024f, -3.79268f, -0.340335f, 1.30024f, 
		-3.79268f, -0.340335f, 1.30024f, -3.79268f, -0.340335f, 1.30024f, 
		-3.79268f, -0.340335f, 1.30024f, -3.79246f, 0.210190f, 1.67332f, 
		-3.79246f, 0.210190f, 1.67332f, -3.79201f, -0.136140f, 1.53132f, 
		-3.79201f, -0.136140f, 1.53132f, -3.79201f, -0.136140f, 1.53132f, 
		-3.79201f, -0.136140f, 1.53132f, -3.79201f, -0.136140f, 1.53132f, 
		-3.79197f, -0.0210600f, 1.86478f, -3.79197f, -0.0210600f, 1.86478f, 
		-3.79197f, -0.0210600f, 1.86478f, -3.79197f, -0.0210600f, 1.86478f, 
		-3.79176f, 0.168787f, 1.77914f, -3.79176f, 0.168787f, 1.77914f, 
		-3.79164f, 0.0532160f, 1.91229f, -3.79164f, 0.0532160f, 1.91229f, 
		-3.79164f, 0.0532160f, 1.91229f, -3.79164f, 0.0532160f, 1.91229f, 
		-3.79164f, 0.0532160f, 1.91229f, -3.79164f, 0.600490f, 1.55175f, 
		-3.79156f, 0.0547640f, 1.70804f, -3.79156f, 0.0547640f, 1.70804f, 
		-3.79156f, 0.0547640f, 1.70804f, -3.79156f, 0.0547640f, 1.70804f, 
		-3.79156f, 0.0547640f, 1.70804f, -3.79156f, 0.0547640f, 1.70804f, 
		-3.79151f, 0.384432f, 1.66050f, -3.79141f, 0.346856f, 2.02003f, 
		-3.79136f, 0.0495870f, 1.81423f, -3.79136f, 0.0495870f, 1.81423f, 
		-3.79136f, 0.0495870f, 1.81423f, -3.79121f, 0.0596760f, 1.86262f, 
		-3.79121f, 0.0596760f, 1.86262f, -3.79093f, 0.114468f, 1.73936f, 
		-3.79077f, 0.0342300f, 1.72877f, -3.79077f, 0.0342300f, 1.72877f, 
		-3.79071f, 0.363563f, 1.59801f, -3.79059f, 0.0313330f, 1.69356f, 
		-3.79059f, 0.0313330f, 1.69356f, -3.79059f, 0.0313330f, 1.69356f, 
		-3.79059f, 0.0313330f, 1.69356f, -3.79050f, 0.324665f, 1.68921f, 
		-3.79041f, -0.0214280f, 1.84271f, -3.79041f, -0.0214280f, 1.84271f, 
		-3.79041f, -0.0214280f, 1.84271f, -3.79041f, -0.0214280f, 1.84271f, 
		-3.79031f, 0.222371f, 1.67157f, -3.79031f, 0.222371f, 1.67157f, 
		-3.78993f, -0.324448f, 1.70093f, -3.78993f, -0.324448f, 1.70093f, 
		-3.78993f, -0.324448f, 1.70093f, -3.78993f, -0.324448f, 1.70093f, 
		-3.78990f, 0.296428f, 1.61635f, -3.78983f, -0.318385f, 1.70557f, 
		-3.78983f, -0.318385f, 1.70557f, -3.78983f, -0.318385f, 1.70557f, 
		-3.78967f, -0.317123f, 1.83692f, -3.78967f, -0.317123f, 1.83692f, 
		-3.78967f, -0.317123f, 1.83692f, -3.78967f, -0.317123f, 1.83692f, 
		-3.78964f, -0.0215950f, 1.80952f, -3.78964f, -0.0215950f, 1.80952f, 
		-3.78913f, -0.323816f, 1.84070f, -3.78913f, -0.323816f, 1.84070f, 
		-3.78913f, -0.323816f, 1.84070f, -3.78913f, -0.323816f, 1.84070f, 
		-3.78897f, 0.371570f, 1.68367f, -3.78882f, 0.0877970f, 1.82828f, 
		-3.78882f, 0.0877970f, 1.82828f, -3.78882f, 0.0877970f, 1.82828f, 
		-3.78882f, -0.257534f, 1.63389f, -3.78882f, -0.257534f, 1.63389f, 
		-3.78882f, -0.257534f, 1.63389f, -3.78882f, -0.257534f, 1.63389f, 
		-3.78882f, -0.257534f, 1.63389f, -3.78881f, 0.199975f, 1.67761f, 
		-3.78881f, 0.199975f, 1.67761f, -3.78881f, 0.199975f, 1.67761f, 
		-3.78881f, 0.199975f, 1.67761f, -3.78881f, 0.199975f, 1.67761f, 
		-3.78873f, -0.127902f, 1.54748f, -3.78873f, -0.127902f, 1.54748f, 
		-3.78873f, -0.127902f, 1.54748f, -3.78873f, -0.127902f, 1.54748f, 
		-3.78873f, -0.127902f, 1.54748f, -3.78873f, -0.127902f, 1.54748f, 
		-3.78853f, -0.357457f, 1.27534f, -3.78853f, -0.357457f, 1.27534f, 
		-3.78853f, -0.357457f, 1.27534f, -3.78852f, 0.343588f, 1.69433f, 
		-3.78847f, -0.288731f, 1.76633f, -3.78845f, 0.392832f, 1.63854f, 
		-3.78799f, 0.0903210f, 1.83060f, -3.78799f, 0.0903210f, 1.83060f, 
		-3.78799f, 0.0903210f, 1.83060f, -3.78799f, 0.0903210f, 1.83060f, 
		-3.78789f, -0.0885340f, 1.66109f, -3.78789f, -0.0885340f, 1.66109f, 
		-3.78784f, -0.109630f, 1.65094f, -3.78784f, -0.109630f, 1.65094f, 
		-3.78743f, 0.188747f, 1.71624f, -3.78743f, 0.188747f, 1.71624f, 
		-3.78743f, 0.188747f, 1.71624f, -3.78739f, -0.200618f, 1.57151f, 
		-3.78739f, -0.200618f, 1.57151f, -3.78739f, -0.200618f, 1.57151f, 
		-3.78739f, -0.200618f, 1.57151f, -3.78735f, 0.291930f, 1.66588f, 
		-3.78733f, 0.340218f, 1.52916f, -3.78715f, 0.290695f, 1.99712f, 
		-3.78714f, 0.0203170f, 1.66405f, -3.78714f, 0.0203170f, 1.66405f, 
		-3.78714f, 0.0203170f, 1.66405f, -3.78714f, 0.0203170f, 1.66405f, 
		-3.78671f, -0.291884f, 1.78975f, -3.78655f, -0.295264f, 1.74070f, 
		-3.78646f, 0.337765f, 1.58632f, -3.78606f, 0.116500f, 1.64800f, 
		-3.78601f, 0.163089f, 1.78386f, -3.78601f, 0.163089f, 1.78386f, 
		-3.78601f, 0.163089f, 1.78386f, -3.78582f, 0.200915f, 1.71979f, 
		-3.78582f, 0.200915f, 1.71979f, -3.78582f, 0.200915f, 1.71979f, 
		-3.78572f, 0.0546850f, 1.84186f, -3.78572f, 0.0546850f, 1.84186f, 
		-3.78572f, 0.0546850f, 1.84186f, -3.78572f, 0.0546850f, 1.84186f, 
		-3.78572f, 0.0546850f, 1.84186f, -3.78572f, 0.0546850f, 1.84186f, 
		-3.78570f, 0.117607f, 1.81361f, -3.78549f, 0.785668f, 1.80362f, 
		-3.78549f, 0.785668f, 1.80362f, -3.78549f, 0.785668f, 1.80362f, 
		-3.78544f, 0.0456050f, 1.74548f, -3.78544f, 0.0456050f, 1.74548f, 
		-3.78544f, 0.0456050f, 1.74548f, -3.78544f, 0.0456050f, 1.74548f, 
		-3.78544f, 0.0456050f, 1.74548f, -3.78514f, 0.311074f, 1.69034f, 
		-3.78472f, 0.381614f, 2.02377f, -3.78456f, -0.137593f, 1.61343f, 
		-3.78456f, -0.137593f, 1.61343f, -3.78456f, -0.137593f, 1.61343f, 
		-3.78456f, -0.137593f, 1.61343f, -3.78456f, -0.137593f, 1.61343f, 
		-3.78447f, 0.0451150f, 1.71265f, -3.78447f, 0.0451150f, 1.71265f, 
		-3.78437f, 0.129100f, 1.72575f, -3.78437f, 0.129100f, 1.72575f, 
		-3.78437f, 0.129100f, 1.72575f, -3.78437f, 0.129100f, 1.72575f, 
		-3.78406f, -0.140173f, 1.63062f, -3.78406f, -0.140173f, 1.63062f, 
		-3.78406f, -0.140173f, 1.63062f, -3.78406f, -0.140173f, 1.63062f, 
		-3.78399f, 0.0283390f, 1.81446f, -3.78399f, 0.0283390f, 1.81446f, 
		-3.78396f, -0.338178f, 1.72727f, -3.78390f, 0.385576f, 1.60467f, 
		-3.78381f, -0.0842640f, 1.56177f, -3.78375f, -0.330058f, 1.70154f, 
		-3.78367f, -0.323102f, 1.86465f, -3.78367f, -0.323102f, 1.86465f, 
		-3.78367f, -0.323102f, 1.86465f, -3.78367f, -0.323102f, 1.86465f, 
		-3.78337f, 0.209822f, 1.72742f, -3.78327f, 0.175275f, 1.71840f, 
		-3.78327f, 0.175275f, 1.71840f, -3.78327f, 0.175275f, 1.71840f, 
		-3.78327f, 0.175275f, 1.71840f, -3.78327f, 0.175275f, 1.71840f, 
		-3.78313f, -0.00653000f, 1.64135f, -3.78313f, -0.00653000f, 1.64135f, 
		-3.78313f, -0.00653000f, 1.64135f, -3.78313f, -0.00653000f, 1.64135f, 
		-3.78302f, 0.0274970f, 1.84907f, -3.78302f, 0.0274970f, 1.84907f, 
		-3.78302f, 0.0274970f, 1.84907f, -3.78302f, 0.0274970f, 1.84907f, 
		-3.78263f, 0.281000f, 1.63321f, -3.78243f, 0.0455890f, 1.80407f, 
		-3.78243f, 0.0455890f, 1.80407f, -3.78243f, 0.0455890f, 1.80407f, 
		-3.78243f, 0.0455890f, 1.80407f, -3.78243f, 0.0455890f, 1.80407f, 
		-3.78243f, 0.0243390f, 1.87607f, -3.78243f, 0.0243390f, 1.87607f, 
		-3.78243f, 0.0243390f, 1.87607f, -3.78243f, 0.0243390f, 1.87607f, 
		-3.78240f, -0.0245870f, 1.60737f, -3.78240f, -0.0245870f, 1.60737f, 
		-3.78240f, -0.0245870f, 1.60737f, -3.78240f, -0.377341f, 1.70761f, 
		-3.78235f, -0.367198f, 1.29610f, -3.78235f, -0.367198f, 1.29610f, 
		-3.78235f, -0.367198f, 1.29610f, -3.78204f, -0.330808f, 1.83956f, 
		-3.78188f, 0.314239f, 2.03029f, -3.78188f, 0.314239f, 2.03029f, 
		-3.78182f, 0.0703150f, 1.75402f, -3.78166f, -0.323790f, 1.67840f, 
		-3.78166f, -0.323790f, 1.67840f, -3.78166f, -0.323790f, 1.67840f, 
		-3.78166f, -0.323790f, 1.67840f, -3.78166f, -0.323790f, 1.67840f, 
		-3.78147f, 0.191234f, 1.68322f, -3.78133f, 0.713109f, 1.76460f, 
		-3.78119f, 0.235982f, 1.67255f, -3.78119f, 0.235982f, 1.67255f, 
		-3.78107f, 0.264245f, 1.97834f, -3.78100f, -0.338394f, 1.26428f, 
		-3.78100f, -0.338394f, 1.26428f, -3.78100f, -0.338394f, 1.26428f, 
		-3.78100f, -0.338394f, 1.26428f, -3.78089f, 0.338084f, 2.03608f, 
		-3.78089f, 0.338084f, 2.03608f, -3.78086f, 0.506355f, 2.02807f, 
		-3.78074f, 0.218532f, 1.74065f, -3.78065f, -0.00959200f, 1.90274f, 
		-3.78065f, -0.00959200f, 1.90274f, -3.78065f, -0.00959200f, 1.90274f, 
		-3.78065f, -0.00959200f, 1.90274f, -3.78065f, -0.00959200f, 1.90274f, 
		-3.78065f, -0.00959200f, 1.90274f, -3.78065f, -0.00959200f, 1.90274f, 
		-3.78062f, -0.106278f, 1.57228f, -3.78062f, -0.106278f, 1.57228f, 
		-3.78048f, 0.00994600f, 1.62156f, -3.78048f, 0.00994600f, 1.62156f, 
		-3.78048f, 0.00994600f, 1.62156f, -3.78048f, 0.00994600f, 1.62156f, 
		-3.78037f, -0.126566f, 1.63390f, -3.78037f, -0.126566f, 1.63390f, 
		-3.78037f, -0.126566f, 1.63390f, -3.78037f, -0.126566f, 1.63390f, 
		-3.78037f, -0.126566f, 1.63390f, -3.78000f, -0.314418f, 1.34931f, 
		-3.78000f, -0.314418f, 1.34931f, -3.78000f, -0.314418f, 1.34931f, 
		-3.77997f, 0.373366f, 1.69484f, -3.77995f, 0.0425780f, 1.82974f, 
		-3.77995f, 0.0425780f, 1.82974f, -3.77987f, -0.310781f, 1.36274f, 
		-3.77979f, -0.308675f, 1.71956f, -3.77979f, 0.402349f, 1.65163f, 
		-3.77970f, 0.170003f, 1.72447f, -3.77970f, 0.170003f, 1.72447f, 
		-3.77970f, 0.170003f, 1.72447f, -3.77970f, 0.170003f, 1.72447f, 
		-3.77962f, -0.342938f, 1.81577f, -3.77958f, -0.311890f, 1.30873f, 
		-3.77958f, -0.311890f, 1.30873f, -3.77958f, -0.311890f, 1.30873f, 
		-3.77958f, -0.311890f, 1.30873f, -3.77958f, -0.311890f, 1.30873f, 
		-3.77956f, 0.223643f, 1.75323f, -3.77948f, 0.337552f, 2.02296f, 
		-3.77948f, 0.337552f, 2.02296f, -3.77928f, -0.306605f, 1.82302f, 
		-3.77926f, -0.166057f, 1.61594f, -3.77926f, -0.166057f, 1.61594f, 
		-3.77926f, -0.166057f, 1.61594f, -3.77926f, -0.166057f, 1.61594f, 
		-3.77919f, -0.124418f, 1.54034f, -3.77919f, -0.124418f, 1.54034f, 
		-3.77919f, -0.124418f, 1.54034f, -3.77919f, -0.124418f, 1.54034f, 
		-3.77919f, -0.124418f, 1.54034f, -3.77919f, -0.124418f, 1.54034f, 
		-3.77914f, 0.285903f, 2.01411f, -3.77914f, 0.285903f, 2.01411f, 
		-3.77910f, 0.389783f, 1.68136f, -3.77893f, 0.210606f, 1.94375f, 
		-3.77893f, 0.210606f, 1.94375f, -3.77893f, 0.210606f, 1.94375f, 
		-3.77889f, 0.0432640f, 1.75858f, -3.77889f, 0.0432640f, 1.75858f, 
		-3.77889f, 0.0432640f, 1.75858f, -3.77889f, 0.0432640f, 1.75858f, 
		-3.77889f, 0.0432640f, 1.75858f, -3.77889f, 0.0432640f, 1.75858f, 
		-3.77886f, -0.327949f, 1.67450f, -3.77886f, -0.327949f, 1.67450f, 
		-3.77886f, -0.327949f, 1.67450f, -3.77886f, -0.327949f, 1.67450f, 
		-3.77886f, -0.327949f, 1.67450f, -3.77886f, -0.327949f, 1.67450f, 
		-3.77878f, 0.578485f, 1.99991f, -3.77873f, 0.314900f, 2.01359f, 
		-3.77873f, 0.314900f, 2.01359f, -3.77863f, 0.0510930f, 1.69378f, 
		-3.77863f, 0.0510930f, 1.69378f, -3.77857f, 0.290498f, 1.68193f, 
		-3.77830f, 0.0687190f, 1.72249f, -3.77830f, 0.0687190f, 1.72249f, 
		-3.77830f, 0.0687190f, 1.72249f, -3.77830f, 0.0687190f, 1.72249f, 
		-3.77829f, -0.0801730f, 1.58311f, -3.77825f, -0.0162940f, 1.88209f, 
		-3.77825f, -0.0162940f, 1.88209f, -3.77825f, -0.0162940f, 1.88209f, 
		-3.77825f, -0.0162940f, 1.88209f, -3.77825f, -0.0162940f, 1.88209f, 
		-3.77793f, -0.328257f, 1.86715f, -3.77775f, -0.0711220f, 1.55208f, 
		-3.77775f, -0.0711220f, 1.55208f, -3.77771f, 0.0938480f, 1.79028f, 
		-3.77769f, -0.147815f, 1.64382f, -3.77769f, -0.147815f, 1.64382f, 
		-3.77769f, -0.147815f, 1.64382f, -3.77769f, -0.147815f, 1.64382f, 
		-3.77764f, 0.0702890f, 1.79192f, -3.77760f, 0.0712450f, 1.72016f, 
		-3.77760f, 0.0712450f, 1.72016f, -3.77760f, 0.0712450f, 1.72016f, 
		-3.77760f, 0.0712450f, 1.72016f, -3.77758f, 0.347520f, 1.70656f, 
		-3.77752f, 0.0432550f, 1.79090f, -3.77752f, 0.0432550f, 1.79090f, 
		-3.77752f, 0.0432550f, 1.79090f, -3.77752f, 0.0432550f, 1.79090f, 
		-3.77722f, -0.0462590f, 1.59336f, -3.77722f, -0.0462590f, 1.59336f, 
		-3.77722f, -0.0462590f, 1.59336f, -3.77722f, -0.0462590f, 1.59336f, 
		-3.77722f, -0.0462590f, 1.59336f, -3.77706f, 0.0427460f, 1.69057f, 
		-3.77706f, 0.0427460f, 1.69057f, -3.77705f, -0.307525f, 1.38769f, 
		-3.77705f, -0.307525f, 1.38769f, -3.77705f, -0.307525f, 1.38769f, 
		-3.77683f, 0.225243f, 1.76262f, -3.77672f, 0.309431f, 1.58335f, 
		-3.77603f, 0.288736f, 1.99754f, -3.77603f, 0.288736f, 1.99754f, 
		-3.77571f, 0.0356870f, 1.70939f, -3.77571f, 0.0356870f, 1.70939f, 
		-3.77571f, 0.0356870f, 1.70939f, -3.77571f, 0.0356870f, 1.70939f, 
		-3.77565f, -0.357526f, 1.77285f, -3.77564f, -0.157886f, 1.57472f, 
		-3.77564f, -0.157886f, 1.57472f, -3.77564f, -0.157886f, 1.57472f, 
		-3.77564f, -0.157886f, 1.57472f, -3.77564f, -0.157886f, 1.57472f, 
		-3.77564f, -0.157886f, 1.57472f, -3.77536f, -0.111827f, 1.53979f, 
		-3.77536f, -0.111827f, 1.53979f, -3.77536f, -0.111827f, 1.53979f, 
		-3.77474f, -0.291548f, 1.35707f, -3.77474f, -0.291548f, 1.35707f, 
		-3.77472f, 0.213970f, 1.55756f, -3.77467f, -0.357124f, 1.74770f, 
		-3.77461f, 0.0686570f, 1.82705f, -3.77461f, 0.0686570f, 1.82705f, 
		-3.77461f, 0.0686570f, 1.82705f, -3.77461f, 0.0686570f, 1.82705f, 
		-3.77460f, 0.0424260f, 1.77692f, -3.77460f, 0.0424260f, 1.77692f, 
		-3.77457f, -0.168235f, 1.61710f, -3.77457f, -0.168235f, 1.61710f, 
		-3.77457f, -0.168235f, 1.61710f, -3.77457f, -0.168235f, 1.61710f, 
		-3.77457f, -0.168235f, 1.61710f, -3.77448f, -0.299132f, 1.34293f, 
		-3.77448f, -0.299132f, 1.34293f, -3.77448f, -0.299132f, 1.34293f, 
		-3.77448f, -0.299132f, 1.34293f, -3.77448f, -0.299132f, 1.34293f, 
		-3.77438f, 0.311620f, 2.03649f, -3.77438f, 0.311620f, 2.03649f, 
		-3.77437f, 0.403710f, 1.61713f, -3.77427f, 0.0310430f, 1.73013f, 
		-3.77427f, 0.0310430f, 1.73013f, -3.77411f, -0.310862f, 1.84146f, 
		-3.77395f, 0.394267f, 1.51412f, -3.77368f, 0.0711790f, 1.82925f, 
		-3.77368f, 0.0711790f, 1.82925f, -3.77368f, 0.0711790f, 1.82925f, 
		-3.77368f, 0.0711790f, 1.82925f, -3.77364f, -0.0673470f, 1.66099f, 
		-3.77364f, -0.0673470f, 1.66099f, -3.77364f, -0.0673470f, 1.66099f, 
		-3.77364f, -0.0673470f, 1.66099f, -3.77364f, -0.0673470f, 1.66099f, 
		-3.77356f, 0.0929250f, 1.75236f, -3.77353f, -0.285093f, 1.92034f, 
		-3.77353f, -0.285093f, 1.92034f, -3.77353f, -0.285093f, 1.92034f, 
		-3.77353f, -0.285093f, 1.92034f, -3.77346f, -0.314243f, 1.69968f, 
		-3.77346f, -0.314243f, 1.69968f, -3.77337f, 0.264220f, 1.99069f, 
		-3.77337f, 0.264220f, 1.99069f, -3.77337f, 0.264220f, 1.99069f, 
		-3.77315f, 0.362799f, 1.57632f, -3.77298f, 0.0510480f, 1.85565f, 
		-3.77298f, 0.0510480f, 1.85565f, -3.77286f, -0.313989f, 1.36312f, 
		-3.77286f, -0.313989f, 1.36312f, -3.77286f, -0.313989f, 1.36312f, 
		-3.77282f, 0.267491f, 1.98029f, -3.77282f, 0.267491f, 1.98029f, 
		-3.77278f, 0.271941f, 1.65311f, -3.77249f, -0.332569f, 1.67575f, 
		-3.77249f, -0.332569f, 1.67575f, -3.77249f, -0.332569f, 1.67575f, 
		-3.77247f, 0.343928f, 1.53015f, -3.77243f, 0.0357120f, 1.84094f, 
		-3.77243f, 0.0357120f, 1.84094f, -3.77243f, 0.0357120f, 1.84094f, 
		-3.77243f, 0.0357120f, 1.84094f, -3.77243f, 0.0357120f, 1.84094f, 
		-3.77221f, -0.331469f, 1.35299f, -3.77221f, -0.331469f, 1.35299f, 
		-3.77221f, -0.331469f, 1.35299f, -3.77221f, -0.331469f, 1.35299f, 
		-3.77221f, -0.331469f, 1.35299f, -3.77220f, 0.286360f, 1.59724f, 
		-3.77218f, 0.285485f, 2.02072f, -3.77218f, 0.285485f, 2.02072f, 
		-3.77218f, 0.285485f, 2.02072f, -3.77218f, 0.285485f, 2.02072f, 
		-3.77215f, 0.174594f, 1.73192f, -3.77215f, 0.174594f, 1.73192f, 
		-3.77215f, 0.174594f, 1.73192f, -3.77174f, -0.223484f, 1.56596f, 
		-3.77174f, -0.223484f, 1.56596f, -3.77174f, -0.223484f, 1.56596f, 
		-3.77165f, 0.334820f, 1.57188f, -3.77155f, -0.315450f, 1.35733f, 
		-3.77155f, -0.315450f, 1.35733f, -3.77155f, -0.315450f, 1.35733f, 
		-3.77155f, -0.315450f, 1.35733f, -3.77155f, -0.315450f, 1.35733f, 
		-3.77153f, 0.0427210f, 1.85896f, -3.77153f, 0.0427210f, 1.85896f, 
		-3.77152f, 0.223599f, 1.77084f, -3.77148f, 0.0310090f, 1.81955f, 
		-3.77148f, 0.0310090f, 1.81955f, -3.77141f, 0.332340f, 2.04083f, 
		-3.77141f, 0.332340f, 2.04083f, -3.77131f, 0.183805f, 1.68991f, 
		-3.77131f, 0.183805f, 1.68991f, -3.77131f, 0.183805f, 1.68991f, 
		-3.77129f, -0.332381f, 1.86572f, -3.77122f, 0.00355400f, 1.88897f, 
		-3.77122f, 0.00355400f, 1.88897f, -3.77122f, 0.00355400f, 1.88897f, 
		-3.77122f, 0.00355400f, 1.88897f, -3.77122f, 0.00355400f, 1.88897f, 
		-3.77106f, -0.124057f, 1.60724f, -3.77106f, -0.124057f, 1.60724f, 
		-3.77099f, -0.330273f, 1.37468f, -3.77099f, -0.330273f, 1.37468f, 
		-3.77093f, 0.362914f, 2.02128f, -3.77093f, 0.362914f, 2.02128f, 
		-3.77093f, 0.362914f, 2.02128f, -3.77084f, 0.773598f, 1.84294f, 
		-3.77084f, 0.773598f, 1.84294f, -3.77078f, 0.0706100f, 1.76365f, 
		-3.77078f, 0.0706100f, 1.76365f, -3.77078f, 0.0706100f, 1.76365f, 
		-3.77074f, 0.636693f, 1.95115f, -3.77063f, -0.331568f, 1.35599f, 
		-3.77063f, -0.331568f, 1.35599f, -3.77063f, -0.331568f, 1.35599f, 
		-3.77063f, -0.331568f, 1.35599f, -3.77062f, 0.406601f, 1.66695f, 
		-3.77058f, 0.313595f, 1.70739f, -3.77027f, 0.0515350f, 1.73333f, 
		-3.77027f, 0.0515350f, 1.73333f, -3.77027f, 0.0515350f, 1.73333f, 
		-3.77027f, 0.0515350f, 1.73333f, -3.77027f, 0.0515350f, 1.73333f, 
		-3.77022f, -0.123953f, 1.64113f, -3.77022f, -0.123953f, 1.64113f, 
		-3.77022f, -0.123953f, 1.64113f, -3.77022f, -0.00432300f, 1.69141f, 
		-3.77022f, -0.00432300f, 1.69141f, -3.77022f, -0.00432300f, 1.69141f, 
		-3.77022f, -0.00432300f, 1.69141f, -3.77022f, -0.00432300f, 1.69141f, 
		-3.76982f, -0.134604f, 1.56254f, -3.76982f, -0.134604f, 1.56254f, 
		-3.76972f, 0.174875f, 1.89464f, -3.76966f, 0.0540630f, 1.73081f, 
		-3.76966f, 0.0540630f, 1.73081f, -3.76966f, 0.0540630f, 1.73081f, 
		-3.76966f, 0.0540630f, 1.73081f, -3.76964f, -0.0326890f, 1.67155f, 
		-3.76964f, -0.0326890f, 1.67155f, -3.76964f, -0.0326890f, 1.67155f, 
		-3.76964f, -0.0326890f, 1.67155f, -3.76964f, -0.0326890f, 1.67155f, 
		-3.76959f, 0.671395f, 1.99314f, -3.76940f, -0.0585180f, 1.90423f, 
		-3.76940f, -0.0585180f, 1.90423f, -3.76940f, -0.0585180f, 1.90423f, 
		-3.76940f, -0.0585180f, 1.90423f, -3.76940f, 0.294749f, 1.69726f, 
		-3.76913f, 0.113881f, 1.79020f, -3.76907f, 0.242415f, 1.95760f, 
		-3.76902f, 0.379960f, 1.70184f, -3.76896f, -0.305793f, 1.41598f, 
		-3.76892f, 0.334146f, 1.71354f, -3.76873f, 0.123345f, 1.71211f, 
		-3.76870f, -0.362412f, 1.72344f, -3.76869f, -0.147866f, 1.56196f, 
		-3.76869f, -0.147866f, 1.56196f, -3.76869f, -0.147866f, 1.56196f, 
		-3.76869f, -0.147866f, 1.56196f, -3.76869f, -0.147866f, 1.56196f, 
		-3.76869f, -0.147866f, 1.56196f, -3.76869f, -0.147866f, 1.56196f, 
		-3.76868f, -0.311873f, 1.28898f, -3.76868f, -0.311873f, 1.28898f, 
		-3.76868f, -0.311873f, 1.28898f, -3.76868f, -0.311873f, 1.28898f, 
		-3.76856f, 0.110553f, 1.74556f, -3.76834f, -0.423556f, 1.81682f, 
		-3.76819f, 0.0515500f, 1.81675f, -3.76819f, 0.0515500f, 1.81675f, 
		-3.76819f, 0.0515500f, 1.81675f, -3.76819f, 0.0515500f, 1.81675f, 
		-3.76819f, 0.0515500f, 1.81675f, -3.76819f, 0.0515500f, 1.81675f, 
		-3.76807f, -0.180983f, 1.64010f, -3.76807f, -0.180983f, 1.64010f, 
		-3.76807f, -0.180983f, 1.64010f, -3.76792f, 0.353198f, 2.03384f, 
		-3.76792f, 0.353198f, 2.03384f, -3.76756f, 0.0179430f, 1.69405f, 
		-3.76756f, 0.0179430f, 1.69405f, -3.76756f, 0.0179430f, 1.69405f, 
		-3.76755f, -0.106886f, 1.58875f, -3.76755f, -0.106886f, 1.58875f, 
		-3.76755f, -0.106886f, 1.58875f, -3.76755f, -0.106886f, 1.58875f, 
		-3.76746f, 0.0540790f, 1.81924f, -3.76746f, 0.0540790f, 1.81924f, 
		-3.76746f, 0.0540790f, 1.81924f, -3.76746f, 0.0540790f, 1.81924f, 
		-3.76745f, 0.0201750f, 1.74541f, -3.76744f, -0.284950f, 1.40088f, 
		-3.76744f, -0.284950f, 1.40088f, -3.76744f, -0.284950f, 1.40088f, 
		-3.76739f, 0.0208480f, 1.72693f, -3.76739f, 0.0208480f, 1.72693f, 
		-3.76739f, 0.0208480f, 1.72693f, -3.76738f, 0.0184970f, 1.72080f, 
		-3.76738f, 0.0184970f, 1.72080f, -3.76738f, 0.0184970f, 1.72080f, 
		-3.76738f, 0.0184970f, 1.72080f, -3.76721f, 0.351101f, 2.02324f, 
		-3.76721f, 0.351101f, 2.02324f, -3.76646f, -0.0104320f, 1.85121f, 
		-3.76646f, -0.0104320f, 1.85121f, -3.76646f, -0.0104320f, 1.85121f, 
		-3.76646f, -0.0104320f, 1.85121f, -3.76646f, -0.0104320f, 1.85121f, 
		-3.76644f, 0.00192600f, 1.72992f, -3.76644f, 0.00192600f, 1.72992f, 
		-3.76644f, 0.00192600f, 1.72992f, -3.76636f, 0.352711f, 2.03772f, 
		-3.76636f, 0.352711f, 2.03772f, -3.76635f, -0.373292f, 1.29277f, 
		-3.76635f, -0.373292f, 1.29277f, -3.76635f, -0.373292f, 1.29277f, 
		-3.76635f, -0.373292f, 1.29277f, -3.76635f, -0.373292f, 1.29277f, 
		-3.76632f, 0.0705808f, 1.77502f, -3.76632f, 0.0705808f, 1.77502f, 
		-3.76632f, 0.0705808f, 1.77502f, -3.76632f, 0.0705808f, 1.77502f, 
		-3.76632f, 0.0705808f, 1.77502f, -3.76632f, 0.0705808f, 1.77502f, 
		-3.76605f, -0.304558f, 1.35201f, -3.76605f, -0.304558f, 1.35201f, 
		-3.76605f, -0.304558f, 1.35201f, -3.76605f, -0.304558f, 1.35201f, 
		-3.76605f, -0.304558f, 1.35201f, -3.76603f, 0.0927210f, 1.77325f, 
		-3.76601f, 0.610406f, 1.53466f, -3.76598f, 0.0201860f, 1.80456f, 
		-3.76565f, 0.482192f, 1.50393f, -3.76562f, 0.267039f, 1.99759f, 
		-3.76562f, 0.267039f, 1.99759f, -3.76562f, 0.267039f, 1.99759f, 
		-3.76540f, 0.387875f, 1.58388f, -3.76526f, -0.121170f, 1.61729f, 
		-3.76513f, 0.358705f, 1.71414f, -3.76511f, -0.426070f, 1.85313f, 
		-3.76511f, -0.426070f, 1.85313f, -3.76511f, -0.315795f, 1.65285f, 
		-3.76511f, -0.315795f, 1.65285f, -3.76482f, 0.249290f, 1.68103f, 
		-3.76482f, 0.249290f, 1.68103f, -3.76482f, 0.249290f, 1.68103f, 
		-3.76482f, 0.249290f, 1.68103f, -3.76482f, 0.249290f, 1.68103f, 
		-3.76470f, 0.312702f, 1.53227f, -3.76468f, 0.0185170f, 1.82914f, 
		-3.76468f, 0.0185170f, 1.82914f, -3.76468f, 0.0185170f, 1.82914f, 
		-3.76468f, 0.0185170f, 1.82914f, -3.76460f, 0.00598700f, 1.67840f, 
		-3.76460f, 0.00598700f, 1.67840f, -3.76460f, 0.00598700f, 1.67840f, 
		-3.76460f, 0.00598700f, 1.67840f, -3.76460f, 0.00598700f, 1.67840f, 
		-3.76460f, 0.00598700f, 1.67840f, -3.76460f, 0.00598700f, 1.67840f, 
		-3.76460f, 0.00598700f, 1.67840f, -3.76460f, 0.00598700f, 1.67840f, 
		-3.76451f, -0.352570f, 1.69630f, -3.76449f, -0.284140f, 1.41765f, 
		-3.76449f, -0.284140f, 1.41765f, -3.76449f, -0.284140f, 1.41765f, 
		-3.76449f, 0.249866f, 1.96318f, -3.76449f, 0.249866f, 1.96318f, 
		-3.76449f, 0.249866f, 1.96318f, -3.76445f, -0.00950300f, 1.81647f, 
		-3.76445f, -0.00950300f, 1.81647f, -3.76430f, 0.307325f, 2.02876f, 
		-3.76430f, 0.307325f, 2.02876f, -3.76408f, -0.328316f, 1.35850f, 
		-3.76408f, -0.328316f, 1.35850f, -3.76408f, -0.328316f, 1.35850f, 
		-3.76408f, -0.328316f, 1.35850f, -3.76395f, 0.675285f, 1.89458f, 
		-3.76391f, 0.268813f, 1.61646f, -3.76376f, -0.185100f, 1.91088f, 
		-3.76376f, -0.185100f, 1.91088f, -3.76376f, -0.185100f, 1.91088f, 
		-3.76366f, 0.306131f, 2.02124f, -3.76366f, 0.306131f, 2.02124f, 
		-3.76352f, 0.0233610f, 1.69048f, -3.76351f, 0.178521f, 1.74185f, 
		-3.76348f, 0.701664f, 1.83170f, -3.76328f, 0.143130f, 1.83707f, 
		-3.76328f, 0.143130f, 1.83707f, -3.76328f, 0.143130f, 1.83707f, 
		-3.76309f, 0.112763f, 1.70074f, -3.76307f, 0.416191f, 1.63422f, 
		-3.76277f, 0.218490f, 1.77995f, -3.76275f, -0.134213f, 1.60687f, 
		-3.76275f, -0.134213f, 1.60687f, -3.76275f, -0.134213f, 1.60687f, 
		-3.76272f, 0.0110630f, 1.85573f, -3.76272f, 0.0110630f, 1.85573f, 
		-3.76272f, 0.0110630f, 1.85573f, -3.76272f, 0.0110630f, 1.85573f, 
		-3.76272f, 0.0110630f, 1.85573f, -3.76271f, 0.286474f, 2.01401f, 
		-3.76271f, 0.286474f, 2.01401f, -3.76260f, -0.353938f, 1.84358f, 
		-3.76248f, -0.320387f, 1.88948f, -3.76248f, -0.320387f, 1.88948f, 
		-3.76243f, 0.288241f, 2.00814f, -3.76243f, 0.288241f, 2.00814f, 
		-3.76236f, 0.248626f, 1.96975f, -3.76236f, 0.248626f, 1.96975f, 
		-3.76236f, 0.248626f, 1.96975f, -3.76236f, 0.248626f, 1.96975f, 
		-3.76236f, 0.248626f, 1.96975f, -3.76223f, 0.321276f, 2.02645f, 
		-3.76223f, 0.321276f, 2.02645f, -3.76220f, -0.0938520f, 1.63916f, 
		-3.76220f, -0.0938520f, 1.63916f, -3.76220f, -0.0938520f, 1.63916f, 
		-3.76220f, -0.0938520f, 1.63916f, -3.76220f, -0.0938520f, 1.63916f, 
		-3.76197f, -0.374246f, 1.88531f, -3.76197f, -0.374246f, 1.88531f, 
		-3.76197f, -0.374246f, 1.88531f, -3.76196f, -0.0190520f, 1.65483f, 
		-3.76196f, -0.0190520f, 1.65483f, -3.76196f, -0.0190520f, 1.65483f, 
		-3.76196f, -0.0190520f, 1.65483f, -3.76196f, -0.0190520f, 1.65483f, 
		-3.76188f, -0.0254390f, 1.66383f, -3.76188f, -0.0254390f, 1.66383f, 
		-3.76184f, 0.405172f, 1.68301f, -3.76177f, 0.0930330f, 1.76230f, 
		-3.76177f, 0.0930330f, 1.76230f, -3.76177f, 0.0930330f, 1.76230f, 
		-3.76177f, 0.0930330f, 1.76230f, -3.76165f, 0.00130100f, 1.73750f, 
		-3.76165f, 0.00130100f, 1.73750f, -3.76165f, 0.00130100f, 1.73750f, 
		-3.76165f, 0.00130100f, 1.73750f, -3.76165f, 0.00130100f, 1.73750f, 
		-3.76165f, 0.00130100f, 1.73750f, -3.76165f, 0.00130100f, 1.73750f, 
		-3.76139f, 0.0131680f, 1.81931f, -3.76139f, 0.0131680f, 1.81931f, 
		-3.76130f, 0.322918f, 2.03330f, -3.76130f, 0.322918f, 2.03330f, 
		-3.76130f, 0.270124f, 1.67409f, -3.76127f, -0.167140f, 1.52811f, 
		-3.76127f, -0.167140f, 1.52811f, -3.76127f, -0.167140f, 1.52811f, 
		-3.76127f, -0.167140f, 1.52811f, -3.76124f, 0.529901f, 1.48790f, 
		-3.76124f, 0.529901f, 1.48790f, -3.76124f, 0.529901f, 1.48790f, 
		-3.76124f, 0.529901f, 1.48790f, -3.76124f, -0.112427f, 1.62366f, 
		-3.76124f, -0.112427f, 1.62366f, -3.76124f, -0.112427f, 1.62366f, 
		-3.76124f, -0.112427f, 1.62366f, -3.76124f, -0.112427f, 1.62366f, 
		-3.76115f, -0.373708f, 1.65394f, -3.76114f, 0.364907f, 2.00504f, 
		-3.76114f, 0.364907f, 2.00504f, -3.76114f, 0.364907f, 2.00504f, 
		-3.76114f, 0.364907f, 2.00504f, -3.76114f, 0.364907f, 2.00504f, 
		-3.76104f, -0.120791f, 1.90965f, -3.76099f, -0.309257f, 1.68157f, 
		-3.76058f, -0.0871100f, 1.58919f, -3.76058f, -0.0871100f, 1.58919f, 
		-3.76058f, -0.0871100f, 1.58919f, -3.76058f, -0.0871100f, 1.58919f, 
		-3.76058f, -0.0871100f, 1.58919f, -3.76057f, 0.686507f, 1.57544f, 
		-3.76057f, 0.686507f, 1.57544f, -3.76057f, 0.686507f, 1.57544f, 
		-3.76057f, 0.686507f, 1.57544f, -3.76057f, 0.686507f, 1.57544f, 
		-3.76057f, 0.686507f, 1.57544f, -3.76056f, -0.318573f, 1.64943f, 
		-3.76056f, -0.318573f, 1.64943f, -3.76056f, -0.318573f, 1.64943f, 
		-3.76056f, -0.318573f, 1.64943f, -3.76052f, 1.40000e-005f, 1.84681f, 
		-3.76052f, 1.40000e-005f, 1.84681f, -3.76052f, 1.40000e-005f, 1.84681f, 
		-3.76042f, 0.117659f, 1.63865f, -3.76017f, -0.288106f, 1.41381f, 
		-3.76017f, -0.288106f, 1.41381f, -3.76017f, -0.288106f, 1.41381f, 
		-3.76017f, -0.288106f, 1.41381f, -3.75983f, -0.296578f, 1.33807f, 
		-3.75983f, -0.296578f, 1.33807f, -3.75983f, -0.296578f, 1.33807f, 
		-3.75979f, 0.00131500f, 1.81218f, -3.75979f, 0.00131500f, 1.81218f, 
		-3.75979f, 0.00131500f, 1.81218f, -3.75979f, 0.00131500f, 1.81218f, 
		-3.75979f, 0.00131500f, 1.81218f, -3.75979f, 0.00131500f, 1.81218f, 
		-3.75979f, 0.00131500f, 1.81218f, -3.75978f, -0.394521f, 1.76642f, 
		-3.75969f, -0.0599740f, 1.67005f, -3.75969f, -0.0599740f, 1.67005f, 
		-3.75969f, -0.0599740f, 1.67005f, -3.75969f, -0.0599740f, 1.67005f, 
		-3.75969f, -0.0599740f, 1.67005f, -3.75969f, -0.0599740f, 1.67005f, 
		-3.75952f, -0.0364280f, 1.63646f, -3.75952f, -0.0364280f, 1.63646f, 
		-3.75952f, -0.0364280f, 1.63646f, -3.75952f, -0.0364280f, 1.63646f, 
		-3.75952f, -0.0364280f, 1.63646f, -3.75952f, -0.0364280f, 1.63646f, 
		-3.75936f, -0.328257f, 1.41534f, -3.75936f, -0.328257f, 1.41534f, 
		-3.75932f, 0.0233980f, 1.85923f, -3.75902f, 0.346658f, 2.03801f, 
		-3.75902f, 0.346658f, 2.03801f, -3.75894f, -0.299467f, 1.44419f, 
		-3.75875f, -0.311019f, 1.86084f, -3.75867f, -0.373060f, 1.81824f, 
		-3.75816f, 0.110259f, 1.77009f, -3.75814f, -0.358052f, 1.26505f, 
		-3.75814f, -0.358052f, 1.26505f, -3.75814f, -0.358052f, 1.26505f, 
		-3.75814f, -0.358052f, 1.26505f, -3.75814f, -0.358052f, 1.26505f, 
		-3.75814f, -0.358052f, 1.26505f, -3.75780f, -0.331938f, 1.35136f, 
		-3.75780f, -0.331938f, 1.35136f, -3.75780f, -0.331938f, 1.35136f, 
		-3.75778f, 0.121209f, 1.73811f, -3.75778f, 0.121209f, 1.73811f, 
		-3.75757f, -0.261181f, 1.62411f, -3.75757f, -0.261181f, 1.62411f, 
		-3.75757f, -0.261181f, 1.62411f, -3.75752f, -0.286376f, 1.34861f, 
		-3.75752f, -0.286376f, 1.34861f, -3.75752f, -0.286376f, 1.34861f, 
		-3.75752f, -0.286376f, 1.34861f, -3.75720f, 0.180364f, 1.70040f, 
		-3.75720f, 0.180364f, 1.70040f, -3.75720f, 0.180364f, 1.70040f, 
		-3.75720f, 0.180364f, 1.70040f, -3.75720f, 0.180364f, 1.70040f, 
		-3.75709f, -0.319993f, 1.65298f, -3.75709f, -0.319993f, 1.65298f, 
		-3.75709f, -0.319993f, 1.65298f, -3.75704f, -0.281427f, 1.43672f, 
		-3.75704f, -0.281427f, 1.43672f, -3.75681f, -0.322823f, 1.89315f, 
		-3.75681f, -0.322823f, 1.89315f, -3.75681f, -0.322823f, 1.89315f, 
		-3.75681f, -0.322823f, 1.89315f, -3.75669f, -0.0862780f, 1.60169f, 
		-3.75669f, -0.0862780f, 1.60169f, -3.75669f, -0.0862780f, 1.60169f, 
		-3.75669f, -0.0862780f, 1.60169f, -3.75652f, -0.337666f, 1.26323f, 
		-3.75652f, -0.337666f, 1.26323f, -3.75652f, -0.337666f, 1.26323f, 
		-3.75652f, -0.337666f, 1.26323f, -3.75652f, -0.337666f, 1.26323f, 
		-3.75577f, 0.206838f, 1.65068f, -3.75577f, 0.206838f, 1.65068f, 
		-3.75577f, 0.206838f, 1.65068f, -3.75570f, 0.104040f, 1.68955f, 
		-3.75569f, -0.298576f, 1.44811f, -3.75569f, -0.298576f, 1.44811f, 
		-3.75569f, -0.298576f, 1.44811f, -3.75522f, 0.333646f, 2.02569f, 
		-3.75522f, 0.333646f, 2.02569f, -3.75522f, 0.333646f, 2.02569f, 
		-3.75522f, 0.333646f, 2.02569f, -3.75479f, -0.305742f, 1.34893f, 
		-3.75479f, -0.305742f, 1.34893f, -3.75479f, -0.305742f, 1.34893f, 
		-3.75479f, -0.305742f, 1.34893f, -3.75479f, -0.305742f, 1.34893f, 
		-3.75456f, 0.408536f, 1.59806f, -3.75449f, 0.209802f, 1.79060f, 
		-3.75443f, 0.110249f, 1.75589f, -3.75443f, 0.110249f, 1.75589f, 
		-3.75443f, 0.110249f, 1.75589f, -3.75443f, 0.110249f, 1.75589f, 
		-3.75441f, 0.468928f, 2.06332f, -3.75431f, 0.398194f, 1.69823f, 
		-3.75406f, 0.127750f, 1.79286f, -3.75406f, 0.127750f, 1.79286f, 
		-3.75406f, 0.127750f, 1.79286f, -3.75406f, 0.127750f, 1.79286f, 
		-3.75400f, 0.332164f, 1.56076f, -3.75397f, -0.00572400f, 1.89639f, 
		-3.75397f, -0.00572400f, 1.89639f, -3.75397f, -0.00572400f, 1.89639f, 
		-3.75397f, -0.00572400f, 1.89639f, -3.75397f, -0.00572400f, 1.89639f, 
		-3.75379f, -0.130277f, 1.61493f, -3.75379f, -0.130277f, 1.61493f, 
		-3.75379f, -0.130277f, 1.61493f, -3.75379f, -0.130277f, 1.61493f, 
		-3.75379f, -0.130277f, 1.61493f, -3.75377f, 0.273607f, 1.99110f, 
		-3.75377f, 0.273607f, 1.99110f, -3.75377f, 0.273607f, 1.99110f, 
		-3.75366f, 0.305167f, 1.56815f, -3.75344f, 0.318121f, 1.71992f, 
		-3.75343f, -0.342423f, 1.36066f, -3.75343f, -0.342423f, 1.36066f, 
		-3.75342f, -0.337870f, 1.35465f, -3.75342f, -0.337870f, 1.35465f, 
		-3.75342f, -0.337870f, 1.35465f, -3.75306f, 0.288959f, 2.00571f, 
		-3.75303f, -0.123221f, 1.62524f, -3.75303f, -0.123221f, 1.62524f, 
		-3.75297f, -0.384103f, 1.77034f, -3.75268f, 0.258513f, 1.63913f, 
		-3.75265f, -0.281638f, 1.37381f, -3.75265f, -0.281638f, 1.37381f, 
		-3.75265f, -0.281638f, 1.37381f, -3.75262f, 0.178643f, 1.76472f, 
		-3.75259f, -0.349472f, 1.66950f, -3.75259f, -0.349472f, 1.66950f, 
		-3.75250f, -0.386067f, 1.74814f, -3.75205f, 0.280264f, 1.98912f, 
		-3.75205f, 0.280264f, 1.98912f, -3.75205f, 0.280264f, 1.98912f, 
		-3.75205f, 0.280264f, 1.98912f, -3.75205f, 0.280264f, 1.98912f, 
		-3.75190f, -0.325172f, 1.88915f, -3.75190f, -0.325172f, 1.88915f, 
		-3.75190f, -0.325172f, 1.88915f, -3.75185f, 0.163472f, 1.79543f, 
		-3.75185f, 0.163472f, 1.79543f, -3.75185f, 0.163472f, 1.79543f, 
		-3.75185f, 0.163472f, 1.79543f, -3.75185f, 0.163472f, 1.79543f, 
		-3.75173f, 0.221888f, 1.64670f, -3.75162f, 0.334848f, 2.03177f, 
		-3.75162f, 0.334848f, 2.03177f, -3.75129f, 0.688576f, 1.60626f, 
		-3.75129f, 0.688576f, 1.60626f, -3.75129f, 0.688576f, 1.60626f, 
		-3.75129f, 0.688576f, 1.60626f, -3.75129f, 0.688576f, 1.60626f, 
		-3.75129f, 0.688576f, 1.60626f, -3.75109f, 0.421798f, 1.65422f, 
		-3.75096f, 0.190352f, 1.65746f, -3.75095f, -0.322296f, 1.43939f, 
		-3.75095f, -0.322296f, 1.43939f, -3.75095f, -0.322296f, 1.43939f, 
		-3.75095f, -0.322296f, 1.43939f, -3.75092f, -0.429445f, 1.70603f, 
		-3.75069f, -0.344211f, 1.37669f, -3.75069f, -0.344211f, 1.37669f, 
		-3.75059f, -0.321141f, 1.35824f, -3.75059f, -0.321141f, 1.35824f, 
		-3.75059f, -0.321141f, 1.35824f, -3.75059f, -0.321141f, 1.35824f, 
		-3.75059f, -0.321141f, 1.35824f, -3.75059f, -0.321141f, 1.35824f, 
		-3.75054f, 0.173110f, 1.77920f, -3.75054f, 0.173110f, 1.77920f, 
		-3.75054f, 0.173110f, 1.77920f, -3.75035f, -0.280220f, 1.39032f, 
		-3.75035f, -0.280220f, 1.39032f, -3.75035f, -0.280220f, 1.39032f, 
		-3.75035f, -0.280220f, 1.39032f, -3.75032f, 0.200621f, 1.79745f, 
		-3.75006f, 0.303799f, 2.01587f, -3.75005f, -0.363237f, 1.28892f, 
		-3.75005f, -0.363237f, 1.28892f, -3.75005f, -0.363237f, 1.28892f, 
		-3.75005f, -0.363237f, 1.28892f, -3.75005f, -0.363237f, 1.28892f, 
		-3.75001f, 0.359870f, 1.56093f, -3.74987f, 0.163297f, 1.78984f, 
		-3.74987f, 0.163297f, 1.78984f, -3.74987f, 0.163297f, 1.78984f, 
		-3.74987f, 0.163297f, 1.78984f, -3.74980f, 0.295722f, 1.71162f, 
		-3.74979f, 0.683281f, 1.66960f, -3.74972f, -0.120174f, 1.56198f, 
		-3.74972f, -0.120174f, 1.56198f, -3.74972f, -0.120174f, 1.56198f, 
		-3.74972f, -0.120174f, 1.56198f, -3.74972f, -0.120174f, 1.56198f, 
		-3.74971f, -0.299873f, 1.62926f, -3.74971f, -0.299873f, 1.62926f, 
		-3.74971f, -0.299873f, 1.62926f, -3.74970f, -0.297599f, 1.66498f, 
		-3.74936f, 0.556321f, 1.52034f, -3.74932f, 0.275734f, 1.69410f, 
		-3.74924f, -0.0934730f, 1.58265f, -3.74924f, -0.0934730f, 1.58265f, 
		-3.74924f, -0.0934730f, 1.58265f, -3.74924f, -0.0934730f, 1.58265f, 
		-3.74924f, -0.0934730f, 1.58265f, -3.74924f, -0.0934730f, 1.58265f, 
		-3.74901f, 0.281526f, 1.58240f, -3.74894f, -0.352718f, 1.87034f, 
		-3.74894f, 0.319451f, 2.02433f, -3.74894f, 0.319451f, 2.02433f, 
		-3.74894f, 0.319451f, 2.02433f, -3.74878f, 0.413256f, 2.01713f, 
		-3.74877f, 0.386360f, 1.71112f, -3.74867f, 0.190987f, 1.80056f, 
		-3.74854f, 0.754435f, 1.89632f, -3.74843f, 0.255113f, 1.96991f, 
		-3.74824f, -0.327426f, 1.34805f, -3.74824f, -0.327426f, 1.34805f, 
		-3.74824f, -0.327426f, 1.34805f, -3.74824f, -0.327426f, 1.34805f, 
		-3.74822f, -0.0617420f, 1.61498f, -3.74822f, -0.0617420f, 1.61498f, 
		-3.74821f, 0.334951f, 1.72505f, -3.74810f, 0.354290f, 2.01814f, 
		-3.74810f, 0.354290f, 2.01814f, -3.74810f, 0.354290f, 2.01814f, 
		-3.74810f, 0.354290f, 2.01814f, -3.74804f, -0.321323f, 1.35829f, 
		-3.74804f, -0.321323f, 1.35829f, -3.74804f, -0.321323f, 1.35829f, 
		-3.74804f, -0.321323f, 1.35829f, -3.74804f, -0.321323f, 1.35829f, 
		-3.74804f, -0.321323f, 1.35829f, -3.74804f, -0.321323f, 1.35829f, 
		-3.74804f, -0.321323f, 1.35829f, -3.74804f, -0.321323f, 1.35829f, 
		-3.74804f, -0.321323f, 1.35829f, -3.74804f, -0.321323f, 1.35829f, 
		-3.74800f, 0.176341f, 1.80102f, -3.74790f, -0.317250f, 1.37081f, 
		-3.74790f, -0.317250f, 1.37081f, -3.74790f, -0.317250f, 1.37081f, 
		-3.74790f, -0.317250f, 1.37081f, -3.74790f, -0.317250f, 1.37081f, 
		-3.74790f, -0.317250f, 1.37081f, -3.74777f, -0.313015f, 1.36424f, 
		-3.74777f, -0.313015f, 1.36424f, -3.74777f, -0.313015f, 1.36424f, 
		-3.74777f, -0.313015f, 1.36424f, -3.74762f, 0.0161390f, 1.77753f, 
		-3.74762f, 0.0161390f, 1.77753f, -3.74762f, 0.0161390f, 1.77753f, 
		-3.74729f, 0.355539f, 2.02671f, -3.74729f, 0.355539f, 2.02671f, 
		-3.74726f, 0.187278f, 1.92248f, -3.74726f, 0.187278f, 1.92248f, 
		-3.74726f, 0.187278f, 1.92248f, -3.74726f, 0.187278f, 1.92248f, 
		-3.74710f, 0.271763f, 1.53709f, -3.74691f, -0.276211f, 1.40696f, 
		-3.74691f, -0.276211f, 1.40696f, -3.74689f, -0.370873f, 1.69164f, 
		-3.74687f, -0.282908f, 1.40273f, -3.74687f, -0.282908f, 1.40273f, 
		-3.74687f, -0.282908f, 1.40273f, -3.74669f, 0.0416630f, 1.73301f, 
		-3.74669f, 0.0416630f, 1.73301f, -3.74669f, 0.0416630f, 1.73301f, 
		-3.74660f, -0.295147f, 1.47650f, -3.74660f, -0.295147f, 1.47650f, 
		-3.74660f, -0.295147f, 1.47650f, -3.74646f, -0.324391f, 1.36367f, 
		-3.74646f, -0.324391f, 1.36367f, -3.74646f, -0.324391f, 1.36367f, 
		-3.74646f, -0.324391f, 1.36367f, -3.74646f, -0.324391f, 1.36367f, 
		-3.74644f, -0.314289f, 1.35417f, -3.74644f, -0.314289f, 1.35417f, 
		-3.74644f, -0.314289f, 1.35417f, -3.74644f, -0.314289f, 1.35417f, 
		-3.74644f, -0.314289f, 1.35417f, -3.74644f, -0.314289f, 1.35417f, 
		-3.74641f, -0.390891f, 1.72523f, -3.74641f, -0.315338f, 1.45216f, 
		-3.74641f, -0.315338f, 1.45216f, -3.74641f, -0.315338f, 1.45216f, 
		-3.74641f, -0.315338f, 1.45216f, -3.74641f, -0.315338f, 1.45216f, 
		-3.74618f, 0.230188f, 1.93805f, -3.74616f, -0.0782790f, 1.58680f, 
		-3.74616f, -0.0782790f, 1.58680f, -3.74616f, -0.0782790f, 1.58680f, 
		-3.74616f, -0.0782790f, 1.58680f, -3.74604f, -0.300255f, 1.33684f, 
		-3.74604f, -0.300255f, 1.33684f, -3.74604f, -0.300255f, 1.33684f, 
		-3.74604f, -0.300255f, 1.33684f, -3.74599f, -0.305488f, 1.31534f, 
		-3.74599f, -0.305488f, 1.31534f, -3.74599f, -0.305488f, 1.31534f, 
		-3.74597f, 0.0391410f, 1.73550f, -3.74597f, 0.0391410f, 1.73550f, 
		-3.74597f, 0.0391410f, 1.73550f, -3.74597f, 0.0391410f, 1.73550f, 
		-3.74597f, 0.0391410f, 1.73550f, -3.74589f, -0.389464f, 1.79233f, 
		-3.74578f, -0.271512f, 1.92798f, -3.74578f, -0.271512f, 1.92798f, 
		-3.74578f, -0.271512f, 1.92798f, -3.74578f, -0.271512f, 1.92798f, 
		-3.74578f, -0.271512f, 1.92798f, -3.74575f, 0.370831f, 1.72042f, 
		-3.74568f, 0.120704f, 1.76519f, -3.74568f, 0.120704f, 1.76519f, 
		-3.74556f, 0.353113f, 1.72522f, -3.74554f, -0.00640600f, 1.67894f, 
		-3.74554f, -0.00640600f, 1.67894f, -3.74554f, -0.00640600f, 1.67894f, 
		-3.74534f, 0.285230f, 1.98724f, -3.74534f, 0.285230f, 1.98724f, 
		-3.74528f, 0.260665f, 1.70570f, -3.74512f, 0.118798f, 1.74986f, 
		-3.74512f, 0.118798f, 1.74986f, -3.74489f, -0.302348f, 1.87901f, 
		-3.74489f, -0.302348f, 1.87901f, -3.74478f, -0.302470f, 1.62746f, 
		-3.74478f, -0.302470f, 1.62746f, -3.74478f, -0.302470f, 1.62746f, 
		-3.74476f, 0.245959f, 1.94631f, -3.74463f, 0.0416790f, 1.81590f, 
		-3.74463f, 0.0416790f, 1.81590f, -3.74463f, 0.0416790f, 1.81590f, 
		-3.74463f, 0.0416790f, 1.81590f, -3.74463f, 0.0416790f, 1.81590f, 
		-3.74450f, 0.250312f, 1.95176f, -3.74450f, 0.250312f, 1.95176f, 
		-3.74450f, 0.250312f, 1.95176f, -3.74450f, 0.250312f, 1.95176f, 
		-3.74450f, 0.250312f, 1.95176f, -3.74445f, -0.338338f, 1.41161f, 
		-3.74445f, -0.338338f, 1.41161f, -3.74444f, -0.330196f, 1.38044f, 
		-3.74444f, -0.330196f, 1.38044f, -3.74444f, -0.330196f, 1.38044f, 
		-3.74444f, -0.330196f, 1.38044f, -3.74428f, 0.0974600f, 1.67892f, 
		-3.74428f, 0.0974600f, 1.67892f, -3.74428f, 0.0974600f, 1.67892f, 
		-3.74404f, 0.0391560f, 1.81339f, -3.74404f, 0.0391560f, 1.81339f, 
		-3.74404f, 0.0391560f, 1.81339f, -3.74404f, 0.0391560f, 1.81339f, 
		-3.74404f, 0.0391560f, 1.81339f, -3.74353f, -0.308069f, 1.91251f, 
		-3.74353f, -0.308069f, 1.91251f, -3.74353f, -0.308069f, 1.91251f, 
		-3.74353f, -0.308069f, 1.91251f, -3.74349f, -0.339301f, 1.28382f, 
		-3.74349f, -0.339301f, 1.28382f, -3.74349f, -0.339301f, 1.28382f, 
		-3.74336f, -0.326754f, 1.41204f, -3.74336f, -0.326754f, 1.41204f, 
		-3.74336f, -0.326754f, 1.41204f, -3.74333f, -0.311519f, 1.47204f, 
		-3.74333f, -0.311519f, 1.47204f, -3.74333f, -0.311519f, 1.47204f, 
		-3.74310f, 0.250047f, 1.95745f, -3.74310f, 0.250047f, 1.95745f, 
		-3.74310f, 0.250047f, 1.95745f, -3.74292f, -0.317396f, 1.41878f, 
		-3.74292f, -0.317396f, 1.41878f, -3.74292f, -0.317396f, 1.41878f, 
		-3.74292f, -0.317396f, 1.41878f, -3.74292f, -0.317396f, 1.41878f, 
		-3.74292f, -0.317396f, 1.41878f, -3.74292f, -0.317396f, 1.41878f, 
		-3.74283f, -0.313565f, 1.42899f, -3.74283f, -0.313565f, 1.42899f, 
		-3.74283f, -0.313565f, 1.42899f, -3.74267f, 0.145660f, 1.85246f, 
		-3.74266f, -0.280889f, 1.47235f, -3.74266f, -0.280889f, 1.47235f, 
		-3.74249f, -0.255533f, 1.55049f, -3.74249f, -0.255533f, 1.55049f, 
		-3.74246f, -0.303111f, 1.63179f, -3.74246f, -0.303111f, 1.63179f, 
		-3.74246f, -0.303111f, 1.63179f, -3.74246f, -0.303111f, 1.63179f, 
		-3.74246f, -0.303111f, 1.63179f, -3.74240f, 0.337751f, 2.02083f, 
		-3.74240f, 0.337751f, 2.02083f, -3.74230f, 0.348770f, 2.03143f, 
		-3.74230f, 0.348770f, 2.03143f, -3.74206f, 0.385574f, 1.56867f, 
		-3.74197f, 0.343698f, 1.80414f, -3.74193f, -0.274297f, 1.42697f, 
		-3.74193f, -0.274297f, 1.42697f, -3.74193f, -0.274297f, 1.42697f, 
		-3.74193f, -0.274297f, 1.42697f, -3.74169f, 0.422767f, 1.61750f, 
		-3.74159f, 0.235459f, 1.64606f, -3.74146f, 0.112328f, 1.73027f, 
		-3.74122f, -0.218748f, 1.56976f, -3.74122f, -0.218748f, 1.56976f, 
		-3.74122f, -0.218748f, 1.56976f, -3.74122f, -0.218748f, 1.56976f, 
		-3.74122f, -0.218748f, 1.56976f, -3.74120f, 0.172168f, 1.71780f, 
		-3.74118f, 0.294272f, 1.98913f, -3.74118f, 0.294272f, 1.98913f, 
		-3.74118f, 0.294272f, 1.98913f, -3.74083f, -0.314391f, 1.38069f, 
		-3.74083f, -0.314391f, 1.38069f, -3.74083f, -0.314391f, 1.38069f, 
		-3.74083f, -0.314391f, 1.38069f, -3.74083f, -0.314391f, 1.38069f, 
		-3.74083f, -0.314391f, 1.38069f, -3.74078f, -0.339508f, 1.61813f, 
		-3.74078f, -0.339508f, 1.61813f, -3.74055f, -0.375681f, 1.84685f, 
		-3.74055f, 0.327255f, 1.79013f, -3.74051f, 0.263551f, 1.60211f, 
		-3.74047f, -0.115231f, 1.65916f, -3.74047f, -0.115231f, 1.65916f, 
		-3.74032f, -0.326008f, 1.38247f, -3.74032f, -0.326008f, 1.38247f, 
		-3.74032f, -0.326008f, 1.38247f, -3.74032f, -0.326008f, 1.38247f, 
		-3.74032f, -0.326008f, 1.38247f, -3.74027f, 0.302865f, 2.00204f, 
		-3.74020f, 0.333896f, 2.00579f, -3.74020f, 0.333896f, 2.00579f, 
		-3.74020f, 0.333896f, 2.00579f, -3.74020f, 0.333896f, 2.00579f, 
		-3.74020f, 0.333896f, 2.00579f, -3.74020f, 0.333896f, 2.00579f, 
		-3.74020f, 0.333896f, 2.00579f, -3.73993f, -0.300509f, 1.42613f, 
		-3.73993f, -0.300509f, 1.42613f, -3.73993f, -0.300509f, 1.42613f, 
		-3.73993f, -0.300509f, 1.42613f, -3.73993f, -0.300509f, 1.42613f, 
		-3.73993f, -0.182661f, 1.55214f, -3.73993f, -0.182661f, 1.55214f, 
		-3.73993f, -0.182661f, 1.55214f, -3.73988f, 0.361997f, 1.79427f, 
		-3.73986f, -0.334709f, 1.42873f, -3.73986f, -0.334709f, 1.42873f, 
		-3.73964f, 0.318425f, 2.01408f, -3.73961f, 0.419981f, 1.67520f, 
		-3.73961f, 0.256464f, 1.66302f, -3.73959f, -0.319958f, 1.40351f, 
		-3.73959f, -0.319958f, 1.40351f, -3.73959f, -0.319958f, 1.40351f, 
		-3.73959f, 0.350469f, 1.77921f, -3.73931f, -0.313062f, 1.34191f, 
		-3.73931f, -0.313062f, 1.34191f, -3.73931f, -0.313062f, 1.34191f, 
		-3.73931f, -0.313062f, 1.34191f, -3.73904f, 0.350004f, 1.53917f, 
		-3.73900f, 0.174392f, 1.66736f, -3.73895f, -0.328993f, 1.40378f, 
		-3.73895f, -0.328993f, 1.40378f, -3.73895f, -0.328993f, 1.40378f, 
		-3.73895f, -0.328993f, 1.40378f, -3.73891f, 0.368226f, 2.01241f, 
		-3.73884f, -0.291914f, 1.34734f, -3.73884f, -0.291914f, 1.34734f, 
		-3.73884f, -0.291914f, 1.34734f, -3.73884f, -0.291914f, 1.34734f, 
		-3.73884f, -0.291914f, 1.34734f, -3.73884f, -0.291914f, 1.34734f, 
		-3.73878f, 0.415000f, 1.51289f, -3.73868f, -0.310673f, 1.91523f, 
		-3.73868f, -0.310673f, 1.91523f, -3.73868f, -0.310673f, 1.91523f, 
		-3.73868f, -0.310673f, 1.91523f, -3.73868f, -0.310673f, 1.91523f, 
		-3.73865f, 0.717264f, 1.64504f, -3.73855f, -0.330365f, 1.41806f, 
		-3.73855f, -0.330365f, 1.41806f, -3.73855f, -0.330365f, 1.41806f, 
		-3.73855f, -0.330365f, 1.41806f, -3.73844f, 0.327511f, 1.81941f, 
		-3.73835f, -0.277902f, 1.43056f, -3.73835f, -0.277902f, 1.43056f, 
		-3.73835f, -0.277902f, 1.43056f, -3.73835f, -0.277902f, 1.43056f, 
		-3.73825f, -0.307799f, 1.41659f, -3.73825f, -0.307799f, 1.41659f, 
		-3.73825f, -0.307799f, 1.41659f, -3.73825f, -0.307799f, 1.41659f, 
		-3.73815f, -0.283138f, 1.63896f, -3.73815f, -0.283138f, 1.63896f, 
		-3.73815f, -0.283138f, 1.63896f, -3.73815f, -0.283138f, 1.63896f, 
		-3.73815f, -0.283138f, 1.63896f, -3.73788f, 0.150270f, 1.60153f, 
		-3.73761f, -0.199678f, 1.56415f, -3.73722f, 0.291833f, 1.96665f, 
		-3.73722f, 0.291833f, 1.96665f, -3.73716f, -0.309293f, 1.44604f, 
		-3.73716f, -0.309293f, 1.44604f, -3.73716f, -0.309293f, 1.44604f, 
		-3.73698f, -0.330247f, 1.37737f, -3.73698f, -0.330247f, 1.37737f, 
		-3.73698f, -0.330247f, 1.37737f, -3.73698f, -0.330247f, 1.37737f, 
		-3.73698f, -0.330247f, 1.37737f, -3.73698f, -0.330247f, 1.37737f, 
		-3.73690f, 0.355512f, 1.98130f, -3.73690f, 0.355512f, 1.98130f, 
		-3.73687f, -0.290997f, 1.35990f, -3.73687f, -0.290997f, 1.35990f, 
		-3.73687f, -0.290997f, 1.35990f, -3.73687f, -0.290997f, 1.35990f, 
		-3.73684f, 0.314454f, 1.81209f, -3.73667f, -0.433906f, 1.66933f, 
		-3.73666f, -0.328388f, 1.42863f, -3.73666f, -0.328388f, 1.42863f, 
		-3.73666f, -0.328388f, 1.42863f, -3.73666f, -0.328388f, 1.42863f, 
		-3.73666f, -0.328388f, 1.42863f, -3.73641f, 0.297252f, 1.96712f, 
		-3.73641f, 0.297252f, 1.96712f, -3.73641f, 0.297252f, 1.96712f, 
		-3.73641f, 0.297252f, 1.96712f, -3.73641f, 0.297252f, 1.96712f, 
		-3.73640f, -0.294748f, 1.44006f, -3.73640f, -0.294748f, 1.44006f, 
		-3.73640f, -0.294748f, 1.44006f, -3.73640f, -0.294748f, 1.44006f, 
		-3.73640f, -0.294748f, 1.44006f, -3.73639f, 0.516781f, 1.47568f, 
		-3.73639f, 0.516781f, 1.47568f, -3.73639f, 0.516781f, 1.47568f, 
		-3.73600f, 0.617635f, 1.57495f, -3.73587f, 0.177984f, 1.91873f, 
		-3.73587f, 0.177984f, 1.91873f, -3.73587f, 0.177984f, 1.91873f, 
		-3.73554f, 0.328177f, 2.01970f, -3.73554f, 0.328177f, 2.01970f, 
		-3.73554f, 0.328177f, 2.01970f, -3.73516f, -0.326985f, 1.37756f, 
		-3.73516f, -0.326985f, 1.37756f, -3.73516f, -0.326985f, 1.37756f, 
		-3.73516f, -0.326985f, 1.37756f, -3.73514f, -0.325199f, 1.39329f, 
		-3.73514f, -0.325199f, 1.39329f, -3.73514f, -0.325199f, 1.39329f, 
		-3.73514f, -0.325199f, 1.39329f, -3.73514f, -0.325199f, 1.39329f, 
		-3.73514f, -0.325199f, 1.39329f, -3.73514f, -0.325199f, 1.39329f, 
		-3.73514f, -0.325199f, 1.39329f, -3.73514f, -0.325199f, 1.39329f, 
		-3.73514f, -0.325199f, 1.39329f, -3.73512f, 0.338110f, 1.83341f, 
		-3.73506f, -0.00578200f, 1.67411f, -3.73480f, -0.310865f, 1.91168f, 
		-3.73480f, -0.310865f, 1.91168f, -3.73480f, -0.310865f, 1.91168f, 
		-3.73480f, -0.310865f, 1.91168f, -3.73480f, -0.310865f, 1.91168f, 
		-3.73475f, 0.359123f, 1.82963f, -3.73474f, -0.0122910f, 1.70473f, 
		-3.73474f, -0.0122910f, 1.70473f, -3.73474f, -0.0122910f, 1.70473f, 
		-3.73474f, -0.0122910f, 1.70473f, -3.73468f, 0.374936f, 1.81313f, 
		-3.73451f, 0.568798f, 1.49872f, -3.73451f, 0.568798f, 1.49872f, 
		-3.73451f, 0.568798f, 1.49872f, -3.73439f, -0.319620f, 1.40059f, 
		-3.73439f, -0.319620f, 1.40059f, -3.73439f, -0.319620f, 1.40059f, 
		-3.73439f, -0.319620f, 1.40059f, -3.73439f, -0.319620f, 1.40059f, 
		-3.73439f, -0.319620f, 1.40059f, -3.73439f, -0.319620f, 1.40059f, 
		-3.73437f, 0.319363f, 1.76841f, -3.73409f, 0.264507f, 1.72562f, 
		-3.73403f, -0.316912f, 1.37680f, -3.73403f, -0.316912f, 1.37680f, 
		-3.73403f, -0.316912f, 1.37680f, -3.73403f, -0.316912f, 1.37680f, 
		-3.73403f, -0.316912f, 1.37680f, -3.73388f, -0.00523800f, 1.77678f, 
		-3.73388f, -0.00523800f, 1.77678f, -3.73388f, -0.00523800f, 1.77678f, 
		-3.73388f, -0.00523800f, 1.77678f, -3.73388f, -0.00523800f, 1.77678f, 
		-3.73388f, -0.00523800f, 1.77678f, -3.73388f, -0.00523800f, 1.77678f, 
		-3.73384f, -0.269971f, 1.52728f, -3.73384f, -0.269971f, 1.52728f, 
		-3.73384f, -0.269971f, 1.52728f, -3.73384f, -0.269971f, 1.52728f, 
		-3.73380f, 0.0969610f, 1.71427f, -3.73376f, 0.336378f, 1.76006f, 
		-3.73351f, 0.370876f, 1.77283f, -3.73331f, 0.120841f, 1.78963f, 
		-3.73321f, 0.305598f, 1.78140f, -3.73319f, -0.175609f, 1.65811f, 
		-3.73301f, -0.333711f, 1.35539f, -3.73301f, -0.333711f, 1.35539f, 
		-3.73301f, -0.333711f, 1.35539f, -3.73301f, -0.333711f, 1.35539f, 
		-3.73281f, -0.287714f, 1.38133f, -3.73281f, -0.287714f, 1.38133f, 
		-3.73281f, -0.287714f, 1.38133f, -3.73281f, -0.287714f, 1.38133f, 
		-3.73281f, -0.287714f, 1.38133f, -3.73245f, -0.348530f, 1.92659f, 
		-3.73245f, -0.348530f, 1.92659f, -3.73207f, 0.304596f, 1.99791f, 
		-3.73207f, 0.304596f, 1.99791f, -3.73207f, 0.304596f, 1.99791f, 
		-3.73192f, 0.286244f, 1.97485f, -3.73192f, 0.286244f, 1.97485f, 
		-3.73192f, 0.286244f, 1.97485f, -3.73192f, 0.286244f, 1.97485f, 
		-3.73192f, 0.286244f, 1.97485f, -3.73191f, -0.365357f, 1.66341f, 
		-3.73191f, -0.365357f, 1.66341f, -3.73189f, -0.332100f, 1.40310f, 
		-3.73189f, -0.332100f, 1.40310f, -3.73189f, -0.332100f, 1.40310f, 
		-3.73189f, -0.332100f, 1.40310f, -3.73186f, -0.324219f, 1.44251f, 
		-3.73186f, -0.324219f, 1.44251f, -3.73186f, -0.324219f, 1.44251f, 
		-3.73186f, -0.324219f, 1.44251f, -3.73184f, -0.322705f, 1.39308f, 
		-3.73184f, -0.322705f, 1.39308f, -3.73184f, -0.322705f, 1.39308f, 
		-3.73184f, -0.322705f, 1.39308f, -3.73184f, -0.322705f, 1.39308f, 
		-3.73184f, -0.322705f, 1.39308f, -3.73184f, -0.322705f, 1.39308f, 
		-3.73184f, -0.322705f, 1.39308f, -3.73184f, -0.322705f, 1.39308f, 
		-3.73181f, 0.337726f, 2.02306f, -3.73181f, 0.337726f, 2.02306f, 
		-3.73181f, 0.337726f, 2.02306f, -3.73181f, 0.337726f, 2.02306f, 
		-3.73173f, -0.0136140f, 1.77683f, -3.73173f, -0.0136140f, 1.77683f, 
		-3.73173f, -0.0136140f, 1.77683f, -3.73173f, -0.0136140f, 1.77683f, 
		-3.73173f, -0.0136140f, 1.77683f, -3.73173f, -0.0136140f, 1.77683f, 
		-3.73173f, -0.0136140f, 1.77683f, -3.73170f, -0.310231f, 1.38162f, 
		-3.73170f, -0.310231f, 1.38162f, -3.73170f, -0.310231f, 1.38162f, 
		-3.73170f, -0.310231f, 1.38162f, -3.73159f, -0.319964f, 1.39263f, 
		-3.73159f, -0.319964f, 1.39263f, -3.73159f, -0.319964f, 1.39263f, 
		-3.73159f, -0.319964f, 1.39263f, -3.73159f, -0.319964f, 1.39263f, 
		-3.73151f, -0.398695f, 1.81457f, -3.73151f, -0.112650f, 1.89037f, 
		-3.73151f, -0.112650f, 1.89037f, -3.73145f, 0.132062f, 1.85097f, 
		-3.73143f, 0.354976f, 1.75718f, -3.73121f, -0.0122620f, 1.84362f, 
		-3.73121f, -0.0122620f, 1.84362f, -3.73121f, -0.0122620f, 1.84362f, 
		-3.73121f, -0.0122620f, 1.84362f, -3.73121f, -0.0122620f, 1.84362f, 
		-3.73121f, -0.0122620f, 1.84362f, -3.73113f, -0.270090f, 1.66888f, 
		-3.73095f, 0.406761f, 1.58320f, -3.73067f, 0.385175f, 1.79103f, 
		-3.73050f, 0.293229f, 1.97942f, -3.73050f, 0.293229f, 1.97942f, 
		-3.73039f, 0.296419f, 1.79775f, -3.73017f, 0.246823f, 1.64859f, 
		-3.73017f, 0.246823f, 1.64859f, -3.73017f, 0.246823f, 1.64859f, 
		-3.73008f, -0.00574500f, 1.87417f, -3.73008f, -0.332423f, 1.39377f, 
		-3.73008f, -0.332423f, 1.39377f, -3.73008f, -0.332423f, 1.39377f, 
		-3.73008f, -0.332423f, 1.39377f, -3.73008f, -0.332423f, 1.39377f, 
		-3.72990f, -0.286647f, 1.37225f, -3.72990f, -0.286647f, 1.37225f, 
		-3.72990f, -0.286647f, 1.37225f, -3.72990f, -0.286647f, 1.37225f, 
		-3.72990f, -0.286647f, 1.37225f, -3.72990f, -0.286647f, 1.37225f, 
		-3.72989f, 0.316967f, 1.83668f, -3.72986f, 0.303253f, 1.96650f, 
		-3.72986f, 0.303253f, 1.96650f, -3.72986f, 0.303253f, 1.96650f, 
		-3.72976f, 0.410920f, 1.69510f, -3.72956f, -0.177236f, 1.89117f, 
		-3.72955f, -0.275179f, 1.87888f, -3.72948f, -0.306237f, 1.41283f, 
		-3.72948f, -0.306237f, 1.41283f, -3.72948f, -0.306237f, 1.41283f, 
		-3.72948f, -0.306237f, 1.41283f, -3.72941f, 0.112989f, 1.76017f, 
		-3.72923f, 0.0922480f, 1.66952f, -3.72916f, -0.311127f, 1.34957f, 
		-3.72916f, -0.311127f, 1.34957f, -3.72916f, -0.311127f, 1.34957f, 
		-3.72916f, -0.311127f, 1.34957f, -3.72916f, -0.311127f, 1.34957f, 
		-3.72915f, -0.334197f, 1.41711f, -3.72915f, -0.334197f, 1.41711f, 
		-3.72915f, -0.334197f, 1.41711f, -3.72915f, -0.334197f, 1.41711f, 
		-3.72915f, -0.334197f, 1.41711f, -3.72912f, 0.322727f, 1.53864f, 
		-3.72900f, -0.246962f, 1.63929f, -3.72900f, -0.246962f, 1.63929f, 
		-3.72900f, -0.246962f, 1.63929f, -3.72900f, -0.246962f, 1.63929f, 
		-3.72900f, -0.246962f, 1.63929f, -3.72900f, -0.246962f, 1.63929f, 
		-3.72900f, 0.253003f, 1.62535f, -3.72878f, -0.0626970f, 1.69234f, 
		-3.72856f, -0.312055f, 1.34179f, -3.72856f, -0.312055f, 1.34179f, 
		-3.72849f, 0.306349f, 1.72365f, -3.72823f, -0.295273f, 1.41985f, 
		-3.72823f, -0.295273f, 1.41985f, -3.72823f, -0.295273f, 1.41985f, 
		-3.72823f, -0.295273f, 1.41985f, -3.72823f, -0.295273f, 1.41985f, 
		-3.72822f, -0.335790f, 1.37413f, -3.72822f, -0.335790f, 1.37413f, 
		-3.72814f, -0.326629f, 1.38974f, -3.72814f, -0.326629f, 1.38974f, 
		-3.72814f, -0.326629f, 1.38974f, -3.72814f, -0.326629f, 1.38974f, 
		-3.72814f, -0.326629f, 1.38974f, -3.72805f, 0.429171f, 1.64027f, 
		-3.72786f, 0.173128f, 1.74028f, -3.72785f, -0.291331f, 1.51337f, 
		-3.72771f, -0.297615f, 1.39272f, -3.72771f, -0.297615f, 1.39272f, 
		-3.72771f, -0.297615f, 1.39272f, -3.72771f, -0.297615f, 1.39272f, 
		-3.72771f, -0.297615f, 1.39272f, -3.72771f, -0.297615f, 1.39272f, 
		-3.72760f, -0.344149f, 1.26556f, -3.72760f, -0.344149f, 1.26556f, 
		-3.72760f, -0.344149f, 1.26556f, -3.72760f, -0.344149f, 1.26556f, 
		-3.72760f, -0.344149f, 1.26556f, -3.72754f, 0.351307f, 2.01025f, 
		-3.72754f, 0.351307f, 2.01025f, -3.72754f, 0.351307f, 2.01025f, 
		-3.72754f, 0.351307f, 2.01025f, -3.72749f, -0.276293f, 1.46556f, 
		-3.72749f, -0.276293f, 1.46556f, -3.72749f, -0.276293f, 1.46556f, 
		-3.72724f, 0.329338f, 1.55321f, -3.72722f, -0.369123f, 1.87454f, 
		-3.72700f, -0.306191f, 1.47014f, -3.72700f, -0.306191f, 1.47014f, 
		-3.72700f, -0.306191f, 1.47014f, -3.72699f, -0.265412f, 1.64345f, 
		-3.72699f, -0.265412f, 1.64345f, -3.72699f, -0.265412f, 1.64345f, 
		-3.72699f, -0.265412f, 1.64345f, -3.72692f, 0.304305f, 1.56008f, 
		-3.72675f, -0.277756f, 1.39568f, -3.72675f, -0.277756f, 1.39568f, 
		-3.72675f, -0.277756f, 1.39568f, -3.72675f, -0.277756f, 1.39568f, 
		-3.72664f, 0.378684f, 1.83363f, -3.72661f, 0.353242f, 1.84776f, 
		-3.72650f, 0.752960f, 1.70328f, -3.72649f, -0.314592f, 1.33051f, 
		-3.72649f, -0.314592f, 1.33051f, -3.72649f, -0.314592f, 1.33051f, 
		-3.72649f, -0.314592f, 1.33051f, -3.72649f, -0.314592f, 1.33051f, 
		-3.72647f, 0.295197f, 1.96012f, -3.72647f, 0.295197f, 1.96012f, 
		-3.72647f, 0.295197f, 1.96012f, -3.72647f, 0.295197f, 1.96012f, 
		-3.72646f, -0.333435f, 1.42502f, -3.72646f, -0.333435f, 1.42502f, 
		-3.72646f, -0.333435f, 1.42502f, -3.72646f, -0.333435f, 1.42502f, 
		-3.72646f, -0.333435f, 1.42502f, -3.72619f, 0.292733f, 1.81587f, 
		-3.72610f, 0.0891780f, 1.70668f, -3.72598f, 0.262870f, 1.68580f, 
		-3.72591f, -0.321963f, 1.46414f, -3.72591f, -0.321963f, 1.46414f, 
		-3.72591f, -0.321963f, 1.46414f, -3.72578f, -0.288961f, 1.43283f, 
		-3.72578f, -0.288961f, 1.43283f, -3.72578f, -0.288961f, 1.43283f, 
		-3.72578f, -0.288961f, 1.43283f, -3.72578f, -0.288961f, 1.43283f, 
		-3.72578f, -0.288961f, 1.43283f, -3.72569f, 0.281953f, 1.70903f, 
		-3.72558f, 0.334526f, 2.01175f, -3.72558f, 0.334526f, 2.01175f, 
		-3.72518f, -0.318337f, 1.46733f, -3.72518f, -0.318337f, 1.46733f, 
		-3.72518f, -0.318337f, 1.46733f, -3.72518f, -0.318337f, 1.46733f, 
		-3.72518f, -0.318337f, 1.46733f, -3.72518f, -0.295736f, 1.37750f, 
		-3.72518f, -0.295736f, 1.37750f, -3.72518f, -0.295736f, 1.37750f, 
		-3.72518f, -0.295736f, 1.37750f, -3.72502f, 0.497484f, 2.00919f, 
		-3.72500f, -0.310983f, 1.36030f, -3.72500f, -0.310983f, 1.36030f, 
		-3.72500f, -0.310983f, 1.36030f, -3.72463f, -0.294542f, 1.46694f, 
		-3.72463f, -0.294542f, 1.46694f, -3.72463f, 0.350422f, 2.01607f, 
		-3.72463f, 0.350422f, 2.01607f, -3.72463f, 0.350422f, 2.01607f, 
		-3.72463f, 0.350422f, 2.01607f, -3.72459f, -0.279655f, 1.46639f, 
		-3.72459f, -0.279655f, 1.46639f, -3.72459f, -0.279655f, 1.46639f, 
		-3.72459f, -0.279655f, 1.46639f, -3.72451f, -0.317797f, 1.39981f, 
		-3.72451f, -0.317797f, 1.39981f, -3.72451f, -0.317797f, 1.39981f, 
		-3.72451f, -0.317797f, 1.39981f, -3.72429f, -0.330494f, 1.43404f, 
		-3.72429f, -0.330494f, 1.43404f, -3.72414f, -0.325871f, 1.40052f, 
		-3.72414f, -0.325871f, 1.40052f, -3.72414f, -0.325871f, 1.40052f, 
		-3.72414f, -0.325871f, 1.40052f, -3.72403f, -0.308551f, 1.51633f, 
		-3.72403f, -0.308551f, 1.51633f, -3.72403f, -0.308551f, 1.51633f, 
		-3.72403f, -0.308551f, 1.51633f, -3.72397f, -0.396234f, 1.63655f, 
		-3.72355f, 0.355034f, 1.55336f, -3.72350f, -0.274233f, 1.91180f, 
		-3.72350f, -0.274233f, 1.91180f, -3.72350f, -0.274233f, 1.91180f, 
		-3.72347f, 0.155981f, 1.67974f, -3.72347f, 0.155981f, 1.67974f, 
		-3.72347f, 0.155981f, 1.67974f, -3.72347f, 0.155981f, 1.67974f, 
		-3.72347f, 0.155981f, 1.67974f, -3.72343f, 0.115519f, 1.63312f, 
		-3.72340f, -0.267285f, 1.63982f, -3.72340f, -0.267285f, 1.63982f, 
		-3.72340f, -0.267285f, 1.63982f, -3.72340f, -0.267285f, 1.63982f, 
		-3.72340f, -0.267285f, 1.63982f, -3.72331f, -0.277330f, 1.50895f, 
		-3.72331f, -0.277330f, 1.50895f, -3.72331f, -0.277330f, 1.50895f, 
		-3.72331f, -0.277330f, 1.50895f, -3.72331f, -0.277330f, 1.50895f, 
		-3.72331f, -0.349014f, 1.64652f, -3.72331f, -0.349014f, 1.64652f, 
		-3.72328f, -0.274522f, 1.41276f, -3.72328f, -0.274522f, 1.41276f, 
		-3.72328f, -0.274522f, 1.41276f, -3.72328f, -0.274522f, 1.41276f, 
		-3.72316f, -0.286064f, 1.37932f, -3.72316f, -0.286064f, 1.37932f, 
		-3.72316f, -0.286064f, 1.37932f, -3.72316f, -0.286064f, 1.37932f, 
		-3.72316f, -0.286064f, 1.37932f, -3.72316f, -0.286064f, 1.37932f, 
		-3.72312f, -0.0178980f, 1.74056f, -3.72312f, -0.0178980f, 1.74056f, 
		-3.72312f, -0.0178980f, 1.74056f, -3.72312f, -0.0178980f, 1.74056f, 
		-3.72312f, -0.0178980f, 1.74056f, -3.72312f, -0.0178980f, 1.74056f, 
		-3.72312f, -0.0178980f, 1.74056f, -3.72312f, -0.0178980f, 1.74056f, 
		-3.72305f, -0.312415f, 1.35489f, -3.72305f, -0.312415f, 1.35489f, 
		-3.72305f, -0.312415f, 1.35489f, -3.72304f, 0.395358f, 1.81333f, 
		-3.72297f, 0.169454f, 1.91352f, -3.72288f, -0.330171f, 1.40781f, 
		-3.72288f, -0.330171f, 1.40781f, -3.72288f, -0.330171f, 1.40781f, 
		-3.72288f, -0.330171f, 1.40781f, -3.72288f, -0.330171f, 1.40781f, 
		-3.72281f, 0.265109f, 1.74979f, -3.72279f, -0.249932f, 1.91277f, 
		-3.72279f, -0.249932f, 1.91277f, -3.72279f, -0.249932f, 1.91277f, 
		-3.72279f, -0.249932f, 1.91277f, -3.72279f, -0.249932f, 1.91277f, 
		-3.72279f, -0.249932f, 1.91277f, -3.72273f, 0.487285f, 1.55158f, 
		-3.72269f, 0.389650f, 1.76832f, -3.72260f, 0.282385f, 1.57331f, 
		-3.72250f, 0.302956f, 1.98175f, -3.72250f, 0.302956f, 1.98175f, 
		-3.72250f, 0.302956f, 1.98175f, -3.72250f, 0.302956f, 1.98175f, 
		-3.72249f, 0.395502f, 1.71197f, -3.72234f, 0.343264f, 2.02031f, 
		-3.72234f, 0.343264f, 2.02031f, -3.72234f, 0.333827f, 1.85451f, 
		-3.72229f, -0.312056f, 1.38175f, -3.72229f, -0.312056f, 1.38175f, 
		-3.72229f, -0.312056f, 1.38175f, -3.72229f, -0.312056f, 1.38175f, 
		-3.72229f, -0.312056f, 1.38175f, -3.72229f, -0.312056f, 1.38175f, 
		-3.72211f, -0.287718f, 1.36388f, -3.72211f, -0.287718f, 1.36388f, 
		-3.72211f, -0.287718f, 1.36388f, -3.72211f, -0.287718f, 1.36388f, 
		-3.72200f, -0.411022f, 1.76844f, -3.72200f, -0.411022f, 1.76844f, 
		-3.72182f, -0.321074f, 1.39820f, -3.72182f, -0.321074f, 1.39820f, 
		-3.72182f, -0.321074f, 1.39820f, -3.72171f, -0.311920f, 1.51331f, 
		-3.72171f, -0.311920f, 1.51331f, -3.72171f, -0.311920f, 1.51331f, 
		-3.72171f, -0.311920f, 1.51331f, -3.72171f, -0.311920f, 1.51331f, 
		-3.72171f, -0.311920f, 1.51331f, -3.72168f, 0.328362f, 1.73030f, 
		-3.72149f, -0.249953f, 1.55497f, -3.72149f, -0.249953f, 1.55497f, 
		-3.72149f, -0.249953f, 1.55497f, -3.72149f, -0.249953f, 1.55497f, 
		-3.72146f, -0.315422f, 1.34137f, -3.72146f, -0.315422f, 1.34137f, 
		-3.72146f, -0.315422f, 1.34137f, -3.72146f, -0.315422f, 1.34137f, 
		-3.72146f, -0.315422f, 1.34137f, -3.72146f, -0.315422f, 1.34137f, 
		-3.72138f, -0.0178830f, 1.80726f, -3.72138f, -0.0178830f, 1.80726f, 
		-3.72138f, -0.0178830f, 1.80726f, -3.72138f, -0.0178830f, 1.80726f, 
		-3.72138f, -0.0178830f, 1.80726f, -3.72138f, -0.0178830f, 1.80726f, 
		-3.72138f, -0.0178830f, 1.80726f, -3.72127f, -0.330145f, 1.39328f, 
		-3.72127f, -0.330145f, 1.39328f, -3.72127f, -0.330145f, 1.39328f, 
		-3.72122f, 0.305411f, 1.96130f, -3.72122f, 0.305411f, 1.96130f, 
		-3.72122f, 0.305411f, 1.96130f, -3.72113f, -0.393722f, 1.69070f, 
		-3.72107f, -0.284073f, 1.40462f, -3.72107f, -0.284073f, 1.40462f, 
		-3.72107f, -0.284073f, 1.40462f, -3.72107f, -0.284073f, 1.40462f, 
		-3.72107f, -0.284073f, 1.40462f, -3.72101f, 0.294901f, 1.83398f, 
		-3.72100f, 0.111629f, 1.79281f, -3.72073f, -0.292694f, 1.34567f, 
		-3.72073f, -0.292694f, 1.34567f, -3.72073f, -0.292694f, 1.34567f, 
		-3.72070f, 0.298015f, 1.98129f, -3.72070f, 0.298015f, 1.98129f, 
		-3.72070f, 0.298015f, 1.98129f, -3.72070f, 0.298015f, 1.98129f, 
		-3.72070f, 0.298015f, 1.98129f, -3.72061f, -0.288508f, 1.52296f, 
		-3.72061f, -0.288508f, 1.52296f, -3.72061f, -0.288508f, 1.52296f, 
		-3.72061f, -0.288508f, 1.52296f, -3.72061f, -0.288508f, 1.52296f, 
		-3.72041f, 0.198668f, 1.82733f, -3.72041f, 0.198668f, 1.82733f, 
		-3.72041f, 0.198668f, 1.82733f, -3.72040f, 0.271242f, 1.95271f, 
		-3.72040f, 0.271242f, 1.95271f, -3.72040f, 0.271242f, 1.95271f, 
		-3.72040f, 0.271242f, 1.95271f, -3.72036f, -0.0598430f, 1.85632f, 
		-3.72034f, -0.278630f, 1.51728f, -3.72034f, -0.278630f, 1.51728f, 
		-3.72034f, -0.278630f, 1.51728f, -3.72034f, -0.278630f, 1.51728f, 
		-3.72034f, -0.278630f, 1.51728f, -3.72024f, -0.279133f, 1.41867f, 
		-3.72024f, -0.279133f, 1.41867f, -3.72024f, -0.279133f, 1.41867f, 
		-3.72024f, -0.279133f, 1.41867f, -3.72024f, -0.279133f, 1.41867f, 
		-3.72021f, -0.271745f, 1.64821f, -3.72021f, -0.271745f, 1.64821f, 
		-3.72019f, -0.329657f, 1.37363f, -3.72019f, -0.329657f, 1.37363f, 
		-3.72019f, -0.329657f, 1.37363f, -3.71996f, 0.199008f, 1.56504f, 
		-3.71988f, 0.189201f, 1.81814f, -3.71979f, 0.375089f, 1.74808f, 
		-3.71971f, -0.415730f, 1.74676f, -3.71960f, -0.307226f, 1.41118f, 
		-3.71960f, -0.307226f, 1.41118f, -3.71960f, -0.307226f, 1.41118f, 
		-3.71960f, -0.307226f, 1.41118f, -3.71960f, -0.307226f, 1.41118f, 
		-3.71960f, -0.307226f, 1.41118f, -3.71960f, -0.307226f, 1.41118f, 
		-3.71960f, -0.307226f, 1.41118f, -3.71958f, 0.171260f, 1.76508f, 
		-3.71957f, -0.274125f, 1.49161f, -3.71957f, -0.274125f, 1.49161f, 
		-3.71957f, -0.274125f, 1.49161f, -3.71951f, 0.209852f, 1.83288f, 
		-3.71951f, 0.209852f, 1.83288f, -3.71951f, 0.209852f, 1.83288f, 
		-3.71951f, 0.209852f, 1.83288f, -3.71940f, 0.568697f, 1.98159f, 
		-3.71918f, 0.473663f, 2.04441f, -3.71903f, -0.328777f, 1.49615f, 
		-3.71903f, -0.328777f, 1.49615f, -3.71903f, -0.328777f, 1.49615f, 
		-3.71903f, -0.328777f, 1.49615f, -3.71903f, -0.328777f, 1.49615f, 
		-3.71903f, -0.328777f, 1.49615f, -3.71902f, 0.305568f, 1.74845f, 
		-3.71901f, -0.328201f, 1.35372f, -3.71901f, -0.328201f, 1.35372f, 
		-3.71889f, -0.364778f, 1.27642f, -3.71889f, -0.364778f, 1.27642f, 
		-3.71889f, -0.364778f, 1.27642f, -3.71889f, -0.364778f, 1.27642f, 
		-3.71888f, -0.299549f, 1.32752f, -3.71888f, -0.299549f, 1.32752f, 
		-3.71888f, -0.299549f, 1.32752f, -3.71888f, -0.299549f, 1.32752f, 
		-3.71884f, 0.328804f, 2.00359f, -3.71884f, 0.328804f, 2.00359f, 
		-3.71866f, -0.328507f, 1.41222f, -3.71866f, -0.328507f, 1.41222f, 
		-3.71866f, -0.328507f, 1.41222f, -3.71866f, -0.328507f, 1.41222f, 
		-3.71866f, -0.328507f, 1.41222f, -3.71866f, -0.328507f, 1.41222f, 
		-3.71866f, -0.328507f, 1.41222f, -3.71852f, 0.375234f, 1.72416f, 
		-3.71830f, -0.319916f, 1.27102f, -3.71830f, -0.319916f, 1.27102f, 
		-3.71830f, -0.319916f, 1.27102f, -3.71830f, -0.319916f, 1.27102f, 
		-3.71828f, 0.180181f, 1.80608f, -3.71828f, 0.180181f, 1.80608f, 
		-3.71828f, 0.180181f, 1.80608f, -3.71827f, -0.304155f, 1.52331f, 
		-3.71827f, -0.304155f, 1.52331f, -3.71827f, -0.304155f, 1.52331f, 
		-3.71827f, -0.304155f, 1.52331f, -3.71827f, -0.304155f, 1.52331f, 
		-3.71825f, 0.352096f, 1.73047f, -3.71823f, 0.327776f, 1.73749f, 
		-3.71809f, -0.304470f, 1.52753f, -3.71809f, -0.304470f, 1.52753f, 
		-3.71807f, -0.277947f, 1.90886f, -3.71807f, -0.277947f, 1.90886f, 
		-3.71807f, -0.277947f, 1.90886f, -3.71807f, -0.277947f, 1.90886f, 
		-3.71807f, -0.277947f, 1.90886f, -3.71780f, -0.329921f, 1.34326f, 
		-3.71780f, -0.329921f, 1.34326f, -3.71780f, -0.329921f, 1.34326f, 
		-3.71780f, -0.329921f, 1.34326f, -3.71780f, -0.329921f, 1.34326f, 
		-3.71780f, -0.329921f, 1.34326f, -3.71777f, 0.421358f, 1.60312f, 
		-3.71772f, 0.321417f, 2.00044f, -3.71772f, 0.321417f, 2.00044f, 
		-3.71772f, 0.321417f, 2.00044f, -3.71772f, 0.321417f, 2.00044f, 
		-3.71772f, 0.321417f, 2.00044f, -3.71772f, 0.321417f, 2.00044f, 
		-3.71769f, -0.317051f, 1.41029f, -3.71769f, -0.317051f, 1.41029f, 
		-3.71769f, -0.317051f, 1.41029f, -3.71769f, -0.317051f, 1.41029f, 
		-3.71748f, 0.287611f, 1.76545f, -3.71733f, 0.308211f, 1.99188f, 
		-3.71722f, 0.283586f, 1.96160f, -3.71714f, 0.402332f, 1.78129f, 
		-3.71708f, 0.358596f, 1.85878f, -3.71700f, -0.295778f, 1.36704f, 
		-3.71700f, -0.295778f, 1.36704f, -3.71700f, -0.295778f, 1.36704f, 
		-3.71700f, -0.295778f, 1.36704f, -3.71696f, 0.173150f, 1.78855f, 
		-3.71696f, 0.173150f, 1.78855f, -3.71696f, 0.173150f, 1.78855f, 
		-3.71696f, 0.173150f, 1.78855f, -3.71680f, -0.285461f, 1.53057f, 
		-3.71680f, -0.285461f, 1.53057f, -3.71680f, -0.285461f, 1.53057f, 
		-3.71680f, -0.285461f, 1.53057f, -3.71680f, -0.285461f, 1.53057f, 
		-3.71677f, 0.222122f, 1.83241f, -3.71677f, 0.222122f, 1.83241f, 
		-3.71673f, 0.588561f, 1.44849f, -3.71673f, 0.588561f, 1.44849f, 
		-3.71673f, 0.588561f, 1.44849f, -3.71673f, 0.588561f, 1.44849f, 
		-3.71673f, 0.588561f, 1.44849f, -3.71673f, 0.588561f, 1.44849f, 
		-3.71659f, 0.256924f, 1.65932f, -3.71659f, 0.256924f, 1.65932f, 
		-3.71659f, 0.256924f, 1.65932f, -3.71659f, 0.256924f, 1.65932f, 
		-3.71659f, 0.256924f, 1.65932f, -3.71658f, -0.278266f, 1.49044f, 
		-3.71658f, -0.278266f, 1.49044f, -3.71658f, -0.278266f, 1.49044f, 
		-3.71658f, -0.278266f, 1.49044f, -3.71624f, -0.271882f, 1.47792f, 
		-3.71619f, 0.378880f, 1.56053f, -3.71616f, -0.280645f, 1.90409f, 
		-3.71616f, -0.280645f, 1.90409f, -3.71612f, 0.381817f, 1.84786f, 
		-3.71608f, -0.326986f, 1.35663f, -3.71608f, -0.326986f, 1.35663f, 
		-3.71608f, -0.326986f, 1.35663f, -3.71572f, 0.0884200f, 1.73471f, 
		-3.71561f, 0.250916f, 1.64984f, -3.71542f, 0.122610f, 1.84778f, 
		-3.71537f, 0.302713f, 1.85031f, -3.71530f, -0.324045f, 1.46053f, 
		-3.71530f, -0.324045f, 1.46053f, -3.71530f, -0.324045f, 1.46053f, 
		-3.71530f, -0.324045f, 1.46053f, -3.71530f, -0.324045f, 1.46053f, 
		-3.71530f, -0.324045f, 1.46053f, -3.71524f, -0.415963f, 1.78957f, 
		-3.71524f, -0.415963f, 1.78957f, -3.71524f, -0.415963f, 1.78957f, 
		-3.71524f, -0.415963f, 1.78957f, -3.71520f, 0.352066f, 1.73366f, 
		-3.71498f, 0.427121f, 1.66417f, -3.71494f, 0.264344f, 1.94274f, 
		-3.71472f, 0.265725f, 1.59159f, -3.71451f, -0.290023f, 1.46212f, 
		-3.71451f, -0.290023f, 1.46212f, -3.71451f, -0.290023f, 1.46212f, 
		-3.71443f, -0.329516f, 1.34643f, -3.71443f, -0.329516f, 1.34643f, 
		-3.71443f, -0.329516f, 1.34643f, -3.71443f, -0.329516f, 1.34643f, 
		-3.71443f, -0.329516f, 1.34643f, -3.71443f, -0.329516f, 1.34643f, 
		-3.71428f, -0.310982f, 1.49909f, -3.71428f, -0.310982f, 1.49909f, 
		-3.71428f, -0.310982f, 1.49909f, -3.71428f, -0.310982f, 1.49909f, 
		-3.71427f, 0.327302f, 2.00822f, -3.71427f, 0.327302f, 2.00822f, 
		-3.71427f, 0.327302f, 2.00822f, -3.71427f, 0.327302f, 2.00822f, 
		-3.71427f, 0.327302f, 2.00822f, -3.71426f, -0.303791f, 1.53349f, 
		-3.71426f, -0.303791f, 1.53349f, -3.71426f, -0.303791f, 1.53349f, 
		-3.71426f, -0.303791f, 1.53349f, -3.71426f, -0.303791f, 1.53349f, 
		-3.71418f, -0.329547f, 1.46126f, -3.71418f, -0.329547f, 1.46126f, 
		-3.71418f, -0.329547f, 1.46126f, -3.71418f, -0.329547f, 1.46126f, 
		-3.71418f, -0.329547f, 1.46126f, -3.71403f, -0.259791f, 1.67091f, 
		-3.71403f, -0.259791f, 1.67091f, -3.71403f, -0.259791f, 1.67091f, 
		-3.71393f, -0.304031f, 1.33854f, -3.71393f, -0.304031f, 1.33854f, 
		-3.71393f, -0.304031f, 1.33854f, -3.71393f, -0.304031f, 1.33854f, 
		-3.71393f, -0.304031f, 1.33854f, -3.71388f, -0.277941f, 1.51332f, 
		-3.71388f, -0.277941f, 1.51332f, -3.71388f, -0.277941f, 1.51332f, 
		-3.71388f, -0.277941f, 1.51332f, -3.71388f, -0.277941f, 1.51332f, 
		-3.71379f, 0.275674f, 1.78684f, -3.71366f, 0.0246820f, 1.71316f, 
		-3.71366f, 0.0246820f, 1.71316f, -3.71318f, 0.172841f, 1.66161f, 
		-3.71318f, 0.172841f, 1.66161f, -3.71313f, 0.260459f, 1.77602f, 
		-3.71298f, -0.274587f, 1.52892f, -3.71298f, -0.274587f, 1.52892f, 
		-3.71298f, -0.274587f, 1.52892f, -3.71298f, -0.274587f, 1.52892f, 
		-3.71288f, 0.0809170f, 1.69906f, -3.71287f, 0.399236f, 1.83271f, 
		-3.71272f, -0.324670f, 1.49988f, -3.71272f, -0.324670f, 1.49988f, 
		-3.71272f, -0.324670f, 1.49988f, -3.71272f, -0.324670f, 1.49988f, 
		-3.71272f, -0.324670f, 1.49988f, -3.71272f, -0.324670f, 1.49988f, 
		-3.71272f, -0.324670f, 1.49988f, -3.71245f, -0.300127f, 1.41557f, 
		-3.71245f, -0.300127f, 1.41557f, -3.71245f, -0.300127f, 1.41557f, 
		-3.71245f, -0.300127f, 1.41557f, -3.71245f, -0.300127f, 1.41557f, 
		-3.71245f, -0.300127f, 1.41557f, -3.71215f, -0.330549f, 1.41711f, 
		-3.71215f, -0.330549f, 1.41711f, -3.71215f, -0.330549f, 1.41711f, 
		-3.71215f, -0.330549f, 1.41711f, -3.71207f, 0.0222400f, 1.71543f, 
		-3.71207f, 0.0222400f, 1.71543f, -3.71207f, 0.0222400f, 1.71543f, 
		-3.71207f, 0.0222400f, 1.71543f, -3.71206f, 0.0967190f, 1.76182f, 
		-3.71190f, -0.320924f, 1.41133f, -3.71190f, -0.320924f, 1.41133f, 
		-3.71190f, -0.320924f, 1.41133f, -3.71190f, -0.320924f, 1.41133f, 
		-3.71188f, -0.291901f, 1.42259f, -3.71188f, -0.291901f, 1.42259f, 
		-3.71188f, -0.291901f, 1.42259f, -3.71188f, -0.291901f, 1.42259f, 
		-3.71182f, -0.292594f, 1.54343f, -3.71182f, -0.292594f, 1.54343f, 
		-3.71182f, -0.292594f, 1.54343f, -3.71155f, 0.235748f, 1.82487f, 
		-3.71155f, 0.235748f, 1.82487f, -3.71150f, 0.410140f, 1.79762f, 
		-3.71134f, -0.397704f, 1.84535f, -3.71127f, -0.329417f, 1.42460f, 
		-3.71127f, -0.329417f, 1.42460f, -3.71127f, -0.329417f, 1.42460f, 
		-3.71112f, -0.278315f, 1.52675f, -3.71112f, -0.278315f, 1.52675f, 
		-3.71112f, -0.278315f, 1.52675f, -3.71112f, -0.278315f, 1.52675f, 
		-3.71089f, -0.353523f, 1.89983f, -3.71083f, -0.272993f, 1.51242f, 
		-3.71083f, -0.272993f, 1.51242f, -3.71083f, -0.272993f, 1.51242f, 
		-3.71083f, -0.272993f, 1.51242f, -3.71080f, 0.489219f, 1.51218f, 
		-3.71076f, 0.318791f, 1.99941f, -3.71076f, 0.318791f, 1.99941f, 
		-3.71076f, 0.318791f, 1.99941f, -3.71076f, 0.318791f, 1.99941f, 
		-3.71065f, 0.0247040f, 1.83410f, -3.71065f, 0.0247040f, 1.83410f, 
		-3.71058f, -0.297501f, 1.49640f, -3.71058f, -0.297501f, 1.49640f, 
		-3.71058f, -0.297501f, 1.49640f, -3.71058f, -0.297501f, 1.49640f, 
		-3.71058f, -0.297501f, 1.49640f, -3.71058f, -0.297501f, 1.49640f, 
		-3.70992f, -0.333385f, 1.48577f, -3.70992f, -0.333385f, 1.48577f, 
		-3.70992f, -0.333385f, 1.48577f, -3.70992f, -0.333385f, 1.48577f, 
		-3.70984f, -0.115219f, 1.69185f, -3.70984f, -0.115219f, 1.69185f, 
		-3.70981f, 0.315398f, 1.86326f, -3.70966f, -0.329072f, 1.46764f, 
		-3.70966f, -0.329072f, 1.46764f, -3.70966f, -0.329072f, 1.46764f, 
		-3.70958f, 0.251611f, 1.93753f, -3.70955f, -0.0623000f, 1.73550f, 
		-3.70955f, -0.0623000f, 1.73550f, -3.70955f, -0.361495f, 1.23965f, 
		-3.70955f, -0.361495f, 1.23965f, -3.70955f, -0.361495f, 1.23965f, 
		-3.70955f, -0.361495f, 1.23965f, -3.70955f, -0.361495f, 1.23965f, 
		-3.70955f, -0.361495f, 1.23965f, -3.70945f, -0.422015f, 1.72409f, 
		-3.70945f, -0.422015f, 1.72409f, -3.70945f, -0.422015f, 1.72409f, 
		-3.70945f, -0.422015f, 1.72409f, -3.70926f, 0.178136f, 1.66107f, 
		-3.70926f, 0.178136f, 1.66107f, -3.70926f, 0.178136f, 1.66107f, 
		-3.70926f, 0.178136f, 1.66107f, -3.70912f, 0.0222630f, 1.83177f, 
		-3.70912f, 0.0222630f, 1.83177f, -3.70912f, 0.0222630f, 1.83177f, 
		-3.70912f, 0.0222630f, 1.83177f, -3.70903f, -0.305038f, 1.40959f, 
		-3.70903f, -0.305038f, 1.40959f, -3.70903f, -0.305038f, 1.40959f, 
		-3.70903f, -0.305038f, 1.40959f, -3.70903f, -0.305038f, 1.40959f, 
		-3.70903f, -0.305038f, 1.40959f, -3.70903f, -0.305038f, 1.40959f, 
		-3.70896f, 0.307377f, 1.54439f, -3.70896f, 0.149994f, 1.69824f, 
		-3.70895f, -0.331801f, 1.41073f, -3.70895f, -0.331801f, 1.41073f, 
		-3.70895f, -0.331801f, 1.41073f, -3.70895f, -0.331801f, 1.41073f, 
		-3.70895f, -0.331801f, 1.41073f, -3.70895f, -0.331801f, 1.41073f, 
		-3.70877f, 0.331311f, 2.00701f, -3.70877f, 0.331311f, 2.00701f, 
		-3.70877f, 0.331311f, 2.00701f, -3.70877f, 0.331311f, 2.00701f, 
		-3.70875f, 0.344065f, 1.99969f, -3.70875f, 0.344065f, 1.99969f, 
		-3.70828f, 0.270911f, 1.81052f, -3.70817f, -0.292249f, 1.48292f, 
		-3.70817f, -0.292249f, 1.48292f, -3.70817f, -0.292249f, 1.48292f, 
		-3.70816f, -0.0384550f, 1.72825f, -3.70797f, -0.324414f, 1.62181f, 
		-3.70797f, -0.324414f, 1.62181f, -3.70792f, 0.370953f, 1.53699f, 
		-3.70789f, -0.317775f, 1.35860f, -3.70789f, -0.317775f, 1.35860f, 
		-3.70789f, -0.317775f, 1.35860f, -3.70769f, 0.103629f, 1.79455f, 
		-3.70758f, -0.256207f, 1.65642f, -3.70758f, -0.256207f, 1.65642f, 
		-3.70757f, -0.256626f, 1.69657f, -3.70757f, -0.256626f, 1.69657f, 
		-3.70744f, -0.310808f, 1.60375f, -3.70744f, -0.310808f, 1.60375f, 
		-3.70744f, -0.310808f, 1.60375f, -3.70744f, -0.310808f, 1.60375f, 
		-3.70737f, -0.407991f, 1.90132f, -3.70735f, -0.307413f, 1.51330f, 
		-3.70735f, -0.307413f, 1.51330f, -3.70735f, -0.307413f, 1.51330f, 
		-3.70735f, -0.307413f, 1.51330f, -3.70735f, -0.307413f, 1.51330f, 
		-3.70727f, -0.0622770f, 1.81182f, -3.70727f, -0.0622770f, 1.81182f, 
		-3.70727f, 0.249066f, 1.80694f, -3.70727f, 0.249066f, 1.80694f, 
		-3.70727f, 0.249066f, 1.80694f, -3.70727f, 0.249066f, 1.80694f, 
		-3.70727f, 0.249066f, 1.80694f, -3.70724f, -0.261402f, 1.88877f, 
		-3.70724f, -0.261402f, 1.88877f, -3.70724f, -0.261402f, 1.88877f, 
		-3.70724f, -0.261402f, 1.88877f, -3.70714f, -0.296936f, 1.50515f, 
		-3.70714f, -0.296936f, 1.50515f, -3.70714f, -0.296936f, 1.50515f, 
		-3.70714f, -0.296936f, 1.50515f, -3.70714f, -0.296936f, 1.50515f, 
		-3.70710f, 0.188342f, 1.66091f, -3.70710f, 0.188342f, 1.66091f, 
		-3.70710f, 0.188342f, 1.66091f, -3.70704f, 0.337231f, 2.00342f, 
		-3.70704f, 0.337231f, 2.00342f, -3.70704f, 0.337231f, 2.00342f, 
		-3.70704f, 0.337231f, 2.00342f, -3.70704f, 0.337231f, 2.00342f, 
		-3.70694f, 0.172569f, 1.67266f, -3.70694f, 0.172569f, 1.67266f, 
		-3.70690f, 0.275467f, 1.70259f, -3.70686f, -0.322065f, 1.39341f, 
		-3.70686f, -0.322065f, 1.39341f, -3.70686f, -0.322065f, 1.39341f, 
		-3.70686f, -0.322065f, 1.39341f, -3.70673f, -0.331033f, 1.39523f, 
		-3.70673f, -0.331033f, 1.39523f, -3.70673f, -0.331033f, 1.39523f, 
		-3.70668f, 0.501975f, 1.53358f, -3.70668f, 0.501975f, 1.53358f, 
		-3.70668f, 0.501975f, 1.53358f, -3.70653f, 0.322522f, 1.99362f, 
		-3.70653f, 0.322522f, 1.99362f, -3.70653f, 0.322522f, 1.99362f, 
		-3.70653f, 0.322522f, 1.99362f, -3.70653f, 0.322522f, 1.99362f, 
		-3.70652f, 0.420967f, 2.00437f, -3.70632f, 0.412309f, 1.81573f, 
		-3.70590f, -0.319248f, 1.51480f, -3.70590f, -0.319248f, 1.51480f, 
		-3.70590f, -0.319248f, 1.51480f, -3.70590f, -0.319248f, 1.51480f, 
		-3.70590f, -0.319248f, 1.51480f, -3.70589f, 0.398538f, 1.57400f, 
		-3.70575f, -0.0384340f, 1.81887f, -3.70573f, -0.329037f, 1.45697f, 
		-3.70573f, -0.329037f, 1.45697f, -3.70573f, -0.329037f, 1.45697f, 
		-3.70573f, -0.329037f, 1.45697f, -3.70573f, -0.329037f, 1.45697f, 
		-3.70565f, -0.328632f, 1.36873f, -3.70565f, -0.328632f, 1.36873f, 
		-3.70565f, -0.328632f, 1.36873f, -3.70565f, -0.328632f, 1.36873f, 
		-3.70565f, -0.328632f, 1.36873f, -3.70565f, -0.328632f, 1.36873f, 
		-3.70556f, 0.0896900f, 1.66062f, -3.70537f, -0.385735f, 1.66007f, 
		-3.70537f, -0.385735f, 1.66007f, -3.70517f, 0.628913f, 1.93213f, 
		-3.70516f, -0.270277f, 1.49541f, -3.70516f, -0.270277f, 1.49541f, 
		-3.70516f, -0.270277f, 1.49541f, -3.70506f, 0.177916f, 1.67006f, 
		-3.70506f, 0.177916f, 1.67006f, -3.70506f, 0.177916f, 1.67006f, 
		-3.70506f, 0.177916f, 1.67006f, -3.70489f, 0.331715f, 1.87157f, 
		-3.70452f, -0.295512f, 1.51316f, -3.70452f, -0.295512f, 1.51316f, 
		-3.70452f, -0.295512f, 1.51316f, -3.70452f, -0.295512f, 1.51316f, 
		-3.70452f, -0.342711f, 1.23494f, -3.70452f, -0.342711f, 1.23494f, 
		-3.70452f, -0.342711f, 1.23494f, -3.70452f, -0.342711f, 1.23494f, 
		-3.70405f, 0.255953f, 1.61315f, -3.70399f, -0.273868f, 1.49422f, 
		-3.70399f, -0.273868f, 1.49422f, -3.70399f, -0.273868f, 1.49422f, 
		-3.70399f, -0.273868f, 1.49422f, -3.70388f, 0.160977f, 1.90700f, 
		-3.70381f, 0.397412f, 1.74813f, -3.70378f, 0.427932f, 1.62646f, 
		-3.70377f, 0.317758f, 1.98045f, -3.70377f, 0.317758f, 1.98045f, 
		-3.70377f, 0.317758f, 1.98045f, -3.70375f, 0.416822f, 1.68683f, 
		-3.70321f, -0.336924f, 1.39521f, -3.70321f, -0.336924f, 1.39521f, 
		-3.70321f, -0.336924f, 1.39521f, -3.70318f, 0.188400f, 1.66882f, 
		-3.70318f, 0.188400f, 1.66882f, -3.70318f, 0.188400f, 1.66882f, 
		-3.70314f, 0.336862f, 2.00481f, -3.70314f, 0.336862f, 2.00481f, 
		-3.70314f, 0.336862f, 2.00481f, -3.70314f, 0.336862f, 2.00481f, 
		-3.70314f, 0.336862f, 2.00481f, -3.70314f, 0.336862f, 2.00481f, 
		-3.70314f, 0.336862f, 2.00481f, -3.70301f, -0.319997f, 1.37325f, 
		-3.70301f, -0.319997f, 1.37325f, -3.70294f, -0.255512f, 1.69388f, 
		-3.70294f, -0.255512f, 1.69388f, -3.70284f, -0.272357f, 1.39637f, 
		-3.70284f, -0.272357f, 1.39637f, -3.70284f, -0.272357f, 1.39637f, 
		-3.70284f, -0.272357f, 1.39637f, -3.70284f, -0.272357f, 1.39637f, 
		-3.70280f, -0.0594460f, 1.73612f, -3.70280f, -0.0594460f, 1.73612f, 
		-3.70278f, 0.361093f, 1.99601f, -3.70265f, -0.313608f, 1.35451f, 
		-3.70265f, -0.313608f, 1.35451f, -3.70265f, -0.313608f, 1.35451f, 
		-3.70265f, -0.313608f, 1.35451f, -3.70265f, 0.335438f, 1.54496f, 
		-3.70263f, -0.225087f, 1.68559f, -3.70263f, -0.225087f, 1.68559f, 
		-3.70263f, -0.225087f, 1.68559f, -3.70263f, -0.225087f, 1.68559f, 
		-3.70246f, -0.294988f, 1.32745f, -3.70246f, -0.294988f, 1.32745f, 
		-3.70246f, -0.294988f, 1.32745f, -3.70243f, -0.333578f, 1.37490f, 
		-3.70243f, -0.333578f, 1.37490f, -3.70243f, -0.333578f, 1.37490f, 
		-3.70242f, 0.689430f, 1.72852f, -3.70227f, -0.0631620f, 1.72781f, 
		-3.70227f, -0.0631620f, 1.72781f, -3.70226f, 0.297763f, 1.71942f, 
		-3.70218f, -0.113355f, 1.85642f, -3.70218f, -0.113355f, 1.85642f, 
		-3.70217f, 0.546225f, 2.03715f, -3.70216f, -0.260108f, 1.66158f, 
		-3.70216f, -0.260108f, 1.66158f, -3.70216f, -0.260108f, 1.66158f, 
		-3.70214f, -0.322703f, 1.94189f, -3.70214f, -0.322703f, 1.94189f, 
		-3.70214f, -0.322703f, 1.94189f, -3.70214f, -0.322703f, 1.94189f, 
		-3.70208f, 0.770932f, 1.76200f, -3.70208f, 0.770932f, 1.76200f, 
		-3.70208f, 0.770932f, 1.76200f, -3.70208f, 0.770932f, 1.76200f, 
		-3.70206f, -0.275967f, 1.37671f, -3.70206f, -0.275967f, 1.37671f, 
		-3.70206f, -0.275967f, 1.37671f, -3.70205f, -0.337633f, 1.40668f, 
		-3.70187f, -0.262797f, 1.89289f, -3.70187f, -0.262797f, 1.89289f, 
		-3.70187f, -0.262797f, 1.89289f, -3.70187f, -0.262797f, 1.89289f, 
		-3.70176f, -0.326982f, 1.40190f, -3.70176f, -0.326982f, 1.40190f, 
		-3.70176f, -0.326982f, 1.40190f, -3.70176f, -0.326982f, 1.40190f, 
		-3.70176f, -0.326982f, 1.40190f, -3.70170f, 0.216523f, 1.63173f, 
		-3.70170f, 0.216523f, 1.63173f, -3.70170f, 0.216523f, 1.63173f, 
		-3.70163f, 0.257492f, 1.67318f, -3.70155f, -0.268854f, 1.41443f, 
		-3.70155f, -0.268854f, 1.41443f, -3.70155f, -0.268854f, 1.41443f, 
		-3.70155f, -0.268854f, 1.41443f, -3.70154f, -0.274321f, 1.40543f, 
		-3.70154f, -0.274321f, 1.40543f, -3.70154f, -0.274321f, 1.40543f, 
		-3.70154f, -0.289251f, 1.37169f, -3.70154f, -0.289251f, 1.37169f, 
		-3.70154f, -0.289251f, 1.37169f, -3.70153f, 0.198719f, 1.63567f, 
		-3.70153f, 0.198719f, 1.63567f, -3.70152f, -0.313423f, 1.39270f, 
		-3.70152f, -0.313423f, 1.39270f, -3.70152f, -0.313423f, 1.39270f, 
		-3.70152f, -0.313423f, 1.39270f, -3.70151f, 0.273800f, 1.83418f, 
		-3.70146f, 0.339741f, 1.97340f, -3.70146f, 0.339741f, 1.97340f, 
		-3.70146f, 0.339741f, 1.97340f, -3.70146f, 0.339741f, 1.97340f, 
		-3.70139f, -0.335504f, 1.34723f, -3.70139f, -0.335504f, 1.34723f, 
		-3.70137f, -0.283879f, 1.34640f, -3.70137f, 0.241933f, 1.93631f, 
		-3.70128f, 0.0890580f, 1.76097f, -3.70126f, -0.256386f, 1.85163f, 
		-3.70126f, -0.256386f, 1.85163f, -3.70115f, -0.340717f, 1.35614f, 
		-3.70115f, -0.340717f, 1.35614f, -3.70115f, -0.340717f, 1.35614f, 
		-3.70107f, 0.350070f, 1.87442f, -3.70093f, -0.345080f, 1.34972f, 
		-3.70093f, -0.345080f, 1.34972f, -3.70093f, -0.345080f, 1.34972f, 
		-3.70091f, 0.590907f, 1.51081f, -3.70091f, 0.590907f, 1.51081f, 
		-3.70091f, 0.590907f, 1.51081f, -3.70091f, 0.590907f, 1.51081f, 
		-3.70091f, 0.590907f, 1.51081f, -3.70091f, 0.590907f, 1.51081f, 
		-3.70068f, -0.422162f, 1.81061f, -3.70068f, -0.422162f, 1.81061f, 
		-3.70068f, -0.422162f, 1.81061f, -3.70068f, -0.422162f, 1.81061f, 
		-3.70068f, -0.422162f, 1.81061f, -3.70065f, -0.335972f, 1.42049f, 
		-3.70062f, 0.206000f, 1.63250f, -3.70062f, 0.206000f, 1.63250f, 
		-3.70061f, -0.0594240f, 1.81082f, -3.70061f, -0.0594240f, 1.81082f, 
		-3.70040f, 0.0776840f, 1.72776f, -3.70038f, -0.272396f, 1.41890f, 
		-3.70038f, -0.272396f, 1.41890f, -3.70038f, -0.272396f, 1.41890f, 
		-3.70038f, -0.272396f, 1.41890f, -3.70036f, -0.0636080f, 1.75026f, 
		-3.70018f, -0.325983f, 1.34756f, -3.70018f, -0.325983f, 1.34756f, 
		-3.70018f, -0.325983f, 1.34756f, -3.70018f, -0.325983f, 1.34756f, 
		-3.70018f, -0.325983f, 1.34756f, -3.70011f, -0.289905f, 1.90567f, 
		-3.70002f, -0.338318f, 1.34149f, -3.70002f, -0.338318f, 1.34149f, 
		-3.70002f, -0.338318f, 1.34149f, -3.70002f, -0.338318f, 1.34149f, 
		-3.70002f, -0.338318f, 1.34149f, -3.69993f, -0.302456f, 1.33920f, 
		-3.69993f, -0.302456f, 1.33920f, -3.69993f, -0.302456f, 1.33920f, 
		-3.69993f, -0.302456f, 1.33920f, -3.69993f, -0.302456f, 1.33920f, 
		-3.69988f, 0.601767f, 1.43243f, -3.69988f, 0.601767f, 1.43243f, 
		-3.69988f, 0.601767f, 1.43243f, -3.69988f, 0.601767f, 1.43243f, 
		-3.69976f, -0.0631400f, 1.81909f, -3.69976f, -0.0631400f, 1.81909f, 
		-3.69976f, -0.0631400f, 1.81909f, -3.69970f, -0.288082f, 1.48416f, 
		-3.69970f, -0.288082f, 1.48416f, -3.69970f, -0.288082f, 1.48416f, 
		-3.69970f, -0.288082f, 1.48416f, -3.69943f, 0.327539f, 1.55422f, 
		-3.69938f, 0.281645f, 1.54842f, -3.69929f, 0.399451f, 1.85019f, 
		-3.69923f, -0.171711f, 1.69044f, -3.69923f, -0.171711f, 1.69044f, 
		-3.69918f, 0.376209f, 1.72804f, -3.69916f, -0.314054f, 1.26321f, 
		-3.69916f, -0.314054f, 1.26321f, -3.69916f, -0.314054f, 1.26321f, 
		-3.69915f, 0.306886f, 1.55992f, -3.69883f, -0.281675f, 1.64322f, 
		-3.69875f, -0.266093f, 1.88894f, -3.69875f, -0.266093f, 1.88894f, 
		-3.69875f, -0.266093f, 1.88894f, -3.69875f, -0.266093f, 1.88894f, 
		-3.69875f, 0.368668f, 1.87153f, -3.69871f, -0.257352f, 1.85198f, 
		-3.69871f, -0.257352f, 1.85198f, -3.69868f, -0.0635880f, 1.79665f, 
		-3.69816f, -0.335519f, 1.46203f, -3.69816f, -0.335519f, 1.46203f, 
		-3.69813f, 0.385681f, 1.86318f, -3.69776f, 0.198096f, 1.64236f, 
		-3.69776f, 0.198096f, 1.64236f, -3.69769f, 0.317756f, 1.98129f, 
		-3.69769f, 0.317756f, 1.98129f, -3.69769f, 0.317756f, 1.98129f, 
		-3.69769f, 0.317756f, 1.98129f, -3.69769f, 0.317756f, 1.98129f, 
		-3.69769f, 0.267924f, 1.68570f, -3.69769f, 0.267924f, 1.68570f, 
		-3.69769f, 0.267924f, 1.68570f, -3.69750f, -0.389891f, 1.87512f, 
		-3.69742f, -0.336707f, 1.41010f, -3.69742f, -0.336707f, 1.41010f, 
		-3.69742f, -0.336707f, 1.41010f, -3.69742f, -0.336707f, 1.41010f, 
		-3.69742f, -0.336707f, 1.41010f, -3.69742f, -0.336707f, 1.41010f, 
		-3.69732f, -0.317155f, 1.37343f, -3.69732f, -0.317155f, 1.37343f, 
		-3.69732f, -0.317155f, 1.37343f, -3.69732f, -0.317155f, 1.37343f, 
		-3.69732f, -0.317155f, 1.37343f, -3.69732f, -0.317155f, 1.37343f, 
		-3.69730f, -0.226238f, 1.86646f, -3.69730f, -0.226238f, 1.86646f, 
		-3.69730f, -0.226238f, 1.86646f, -3.69730f, -0.226238f, 1.86646f, 
		-3.69723f, -0.272245f, 1.55123f, -3.69723f, -0.272245f, 1.55123f, 
		-3.69723f, -0.272245f, 1.55123f, -3.69709f, -0.337285f, 1.39541f, 
		-3.69709f, -0.337285f, 1.39541f, -3.69709f, -0.337285f, 1.39541f, 
		-3.69709f, -0.337285f, 1.39541f, -3.69709f, -0.337285f, 1.39541f, 
		-3.69709f, -0.337285f, 1.39541f, -3.69706f, -0.291273f, 1.41185f, 
		-3.69706f, -0.291273f, 1.41185f, -3.69706f, -0.291273f, 1.41185f, 
		-3.69706f, -0.291273f, 1.41185f, -3.69689f, 0.295249f, 1.73318f, 
		-3.69666f, 0.307976f, 1.56174f, -3.69665f, -0.300438f, 1.40236f, 
		-3.69665f, -0.300438f, 1.40236f, -3.69665f, -0.300438f, 1.40236f, 
		-3.69656f, -0.309919f, 1.91310f, -3.69655f, 0.414028f, 1.76502f, 
		-3.69655f, -0.335143f, 1.41825f, -3.69655f, -0.335143f, 1.41825f, 
		-3.69655f, -0.335143f, 1.41825f, -3.69639f, 0.348747f, 1.55433f, 
		-3.69638f, -0.374292f, 1.27048f, -3.69638f, -0.374292f, 1.27048f, 
		-3.69638f, -0.374292f, 1.27048f, -3.69638f, -0.374292f, 1.27048f, 
		-3.69638f, -0.374292f, 1.27048f, -3.69637f, 0.252229f, 1.55008f, 
		-3.69635f, 0.330374f, 1.56102f, -3.69619f, -0.285232f, 1.42378f, 
		-3.69619f, -0.285232f, 1.42378f, -3.69619f, -0.285232f, 1.42378f, 
		-3.69619f, -0.285232f, 1.42378f, -3.69619f, -0.285232f, 1.42378f, 
		-3.69619f, -0.285232f, 1.42378f, -3.69612f, 0.117114f, 1.84469f, 
		-3.69607f, 0.143461f, 1.60617f, -3.69602f, -0.326782f, 1.53424f, 
		-3.69602f, -0.326782f, 1.53424f, -3.69602f, -0.326782f, 1.53424f, 
		-3.69602f, -0.326782f, 1.53424f, -3.69602f, -0.326782f, 1.53424f, 
		-3.69601f, -0.335509f, 1.38080f, -3.69601f, -0.335509f, 1.38080f, 
		-3.69601f, -0.335509f, 1.38080f, -3.69600f, 0.320531f, 1.72069f, 
		-3.69600f, 0.299193f, 1.56797f, -3.69600f, 0.299193f, 1.56797f, 
		-3.69600f, 0.299193f, 1.56797f, -3.69589f, -0.311110f, 1.39093f, 
		-3.69589f, -0.311110f, 1.39093f, -3.69589f, -0.311110f, 1.39093f, 
		-3.69589f, -0.311110f, 1.39093f, -3.69589f, -0.311110f, 1.39093f, 
		-3.69588f, -0.314112f, 1.35357f, -3.69588f, -0.314112f, 1.35357f, 
		-3.69588f, -0.314112f, 1.35357f, -3.69588f, -0.314112f, 1.35357f, 
		-3.69583f, 0.527433f, 1.50151f, -3.69582f, -0.335124f, 1.36923f, 
		-3.69582f, -0.335124f, 1.36923f, -3.69582f, -0.335124f, 1.36923f, 
		-3.69582f, -0.335124f, 1.36923f, -3.69558f, 0.288811f, 1.57085f, 
		-3.69553f, -0.332769f, 1.42813f, -3.69553f, -0.332769f, 1.42813f, 
		-3.69553f, -0.332769f, 1.42813f, -3.69547f, 0.399276f, 1.70605f, 
		-3.69538f, 0.335413f, 1.98586f, -3.69514f, 0.274817f, 1.75256f, 
		-3.69504f, -0.258109f, 1.65488f, -3.69504f, -0.258109f, 1.65488f, 
		-3.69504f, -0.258109f, 1.65488f, -3.69503f, 0.186903f, 1.65469f, 
		-3.69503f, 0.186903f, 1.65469f, -3.69503f, 0.186903f, 1.65469f, 
		-3.69503f, 0.186903f, 1.65469f, -3.69503f, 0.186903f, 1.65469f, 
		-3.69491f, -0.334856f, 1.51612f, -3.69491f, -0.334856f, 1.51612f, 
		-3.69491f, -0.334856f, 1.51612f, -3.69486f, -0.312291f, 1.52468f, 
		-3.69486f, -0.312291f, 1.52468f, -3.69486f, -0.312291f, 1.52468f, 
		-3.69486f, -0.312291f, 1.52468f, -3.69486f, -0.312291f, 1.52468f, 
		-3.69482f, 0.307636f, 1.96679f, -3.69480f, -0.252817f, 1.71963f, 
		-3.69480f, -0.252817f, 1.71963f, -3.69480f, -0.252817f, 1.71963f, 
		-3.69451f, 0.322837f, 1.72698f, -3.69420f, -0.335855f, 1.51298f, 
		-3.69420f, -0.335855f, 1.51298f, -3.69420f, -0.335855f, 1.51298f, 
		-3.69420f, -0.335855f, 1.51298f, -3.69414f, 0.284053f, 1.85549f, 
		-3.69404f, -0.264282f, 1.52906f, -3.69404f, -0.264282f, 1.52906f, 
		-3.69404f, -0.264282f, 1.52906f, -3.69404f, -0.264282f, 1.52906f, 
		-3.69391f, -0.0653230f, 1.77332f, -3.69379f, 0.331636f, 1.54927f, 
		-3.69374f, -0.332509f, 1.45752f, -3.69374f, -0.332509f, 1.45752f, 
		-3.69374f, -0.332509f, 1.45752f, -3.69374f, -0.332509f, 1.45752f, 
		-3.69366f, 0.412086f, 1.59246f, -3.69361f, 0.150990f, 1.72463f, 
		-3.69336f, -0.268543f, 1.52726f, -3.69336f, -0.268543f, 1.52726f, 
		-3.69336f, -0.268543f, 1.52726f, -3.69336f, -0.268543f, 1.52726f, 
		-3.69336f, -0.268543f, 1.52726f, -3.69322f, -0.171185f, 1.85745f, 
		-3.69322f, -0.171185f, 1.85745f, -3.69279f, -0.331268f, 1.51540f, 
		-3.69279f, -0.331268f, 1.51540f, -3.69279f, -0.331268f, 1.51540f, 
		-3.69279f, -0.331268f, 1.51540f, -3.69274f, 0.664758f, 1.87445f, 
		-3.69262f, 0.174855f, 1.63330f, -3.69262f, 0.174855f, 1.63330f, 
		-3.69255f, 0.348187f, 1.71630f, -3.69226f, -0.336698f, 1.50672f, 
		-3.69226f, -0.336698f, 1.50672f, -3.69226f, -0.336698f, 1.50672f, 
		-3.69226f, -0.336698f, 1.50672f, -3.69226f, -0.336698f, 1.50672f, 
		-3.69217f, 0.0975050f, 1.79287f, -3.69217f, 0.0975050f, 1.79287f, 
		-3.69217f, 0.0975050f, 1.79287f, -3.69167f, -0.337667f, 1.92520f, 
		-3.69167f, -0.337667f, 1.92520f, -3.69162f, 0.254028f, 1.63586f, 
		-3.69153f, 0.299045f, 1.56463f, -3.69153f, 0.299045f, 1.56463f, 
		-3.69153f, 0.299045f, 1.56463f, -3.69142f, -0.245728f, 1.67271f, 
		-3.69142f, -0.245728f, 1.67271f, -3.69142f, -0.245728f, 1.67271f, 
		-3.69142f, -0.245728f, 1.67271f, -3.69100f, -0.365027f, 1.63628f, 
		-3.69096f, 0.0745170f, 1.68329f, -3.69094f, 0.376206f, 1.71995f, 
		-3.69092f, 0.261239f, 1.77692f, -3.69078f, -0.285595f, 1.51226f, 
		-3.69078f, -0.285595f, 1.51226f, -3.69078f, -0.285595f, 1.51226f, 
		-3.69078f, -0.285595f, 1.51226f, -3.69078f, -0.285595f, 1.51226f, 
		-3.69078f, -0.285595f, 1.51226f, -3.69076f, 0.185530f, 1.66273f, 
		-3.69076f, 0.185530f, 1.66273f, -3.69076f, 0.185530f, 1.66273f, 
		-3.69076f, 0.185530f, 1.66273f, -3.69061f, 0.349866f, 1.72716f, 
		-3.69051f, -0.315960f, 1.37830f, -3.69051f, -0.315960f, 1.37830f, 
		-3.69051f, -0.315960f, 1.37830f, -3.69051f, -0.315960f, 1.37830f, 
		-3.69051f, -0.315960f, 1.37830f, -3.69051f, -0.315960f, 1.37830f, 
		-3.69051f, -0.315960f, 1.37830f, -3.69038f, 0.425845f, 1.65095f, 
		-3.69033f, 0.368434f, 1.56022f, -3.69019f, -0.287328f, 1.50461f, 
		-3.69019f, -0.287328f, 1.50461f, -3.69019f, -0.287328f, 1.50461f, 
		-3.69019f, -0.287328f, 1.50461f, -3.69019f, -0.287328f, 1.50461f, 
		-3.69002f, 0.190486f, 1.66115f, -3.69002f, 0.190486f, 1.66115f, 
		-3.69002f, 0.190486f, 1.66115f, -3.69002f, 0.190486f, 1.66115f, 
		-3.69002f, 0.190486f, 1.66115f, -3.69002f, 0.190486f, 1.66115f, 
		-3.69002f, 0.416423f, 1.83418f, -3.69001f, 0.314012f, 1.55019f, 
		-3.69001f, 0.314012f, 1.55019f, -3.69001f, 0.314012f, 1.55019f, 
		-3.68991f, 0.174073f, 1.57541f, -3.68969f, -0.271413f, 1.51682f, 
		-3.68969f, -0.271413f, 1.51682f, -3.68969f, -0.271413f, 1.51682f, 
		-3.68969f, -0.271413f, 1.51682f, -3.68956f, -0.287569f, 1.49623f, 
		-3.68956f, -0.287569f, 1.49623f, -3.68956f, -0.287569f, 1.49623f, 
		-3.68956f, -0.287569f, 1.49623f, -3.68956f, -0.287569f, 1.49623f, 
		-3.68952f, 0.409657f, 1.52989f, -3.68944f, 0.173595f, 1.65167f, 
		-3.68944f, 0.173595f, 1.65167f, -3.68934f, -0.316389f, 1.36345f, 
		-3.68934f, -0.316389f, 1.36345f, -3.68934f, -0.316389f, 1.36345f, 
		-3.68934f, -0.316389f, 1.36345f, -3.68934f, -0.316389f, 1.36345f, 
		-3.68934f, -0.316389f, 1.36345f, -3.68934f, -0.316389f, 1.36345f, 
		-3.68927f, -0.415088f, 1.68865f, -3.68927f, -0.415088f, 1.68865f, 
		-3.68927f, -0.415088f, 1.68865f, -3.68927f, -0.415088f, 1.68865f, 
		-3.68927f, -0.415088f, 1.68865f, -3.68919f, 0.424278f, 1.78634f, 
		-3.68906f, 0.275083f, 1.58595f, -3.68906f, 0.187544f, 1.63096f, 
		-3.68905f, 0.222055f, 1.62425f, -3.68905f, 0.222055f, 1.62425f, 
		-3.68899f, -0.269183f, 1.51148f, -3.68899f, -0.269183f, 1.51148f, 
		-3.68899f, -0.269183f, 1.51148f, -3.68899f, -0.269183f, 1.51148f, 
		-3.68899f, -0.269183f, 1.51148f, -3.68899f, -0.269183f, 1.51148f, 
		-3.68899f, -0.269183f, 1.51148f, -3.68899f, -0.269183f, 1.51148f, 
		-3.68899f, -0.269183f, 1.51148f, -3.68899f, -0.269183f, 1.51148f, 
		-3.68899f, -0.269183f, 1.51148f, -3.68896f, -0.243386f, 1.82800f, 
		-3.68896f, -0.243386f, 1.82800f, -3.68896f, -0.243386f, 1.82800f, 
		-3.68896f, 0.561461f, 1.46890f, -3.68896f, 0.561461f, 1.46890f, 
		-3.68896f, 0.561461f, 1.46890f, -3.68895f, -0.252772f, 1.72967f, 
		-3.68895f, -0.252772f, 1.72967f, -3.68885f, 0.683303f, 1.80290f, 
		-3.68861f, -0.310042f, 1.62908f, -3.68857f, 0.361638f, 1.54556f, 
		-3.68857f, 0.361638f, 1.54556f, -3.68856f, 0.166173f, 1.64833f, 
		-3.68843f, 0.272087f, 1.69309f, -3.68841f, -0.116643f, 1.73582f, 
		-3.68841f, -0.116643f, 1.73582f, -3.68813f, 0.118057f, 1.62839f, 
		-3.68806f, -0.324628f, 1.34812f, -3.68806f, -0.324628f, 1.34812f, 
		-3.68806f, -0.324628f, 1.34812f, -3.68806f, -0.324628f, 1.34812f, 
		-3.68806f, -0.324628f, 1.34812f, -3.68789f, 0.193382f, 1.65638f, 
		-3.68789f, 0.193382f, 1.65638f, -3.68789f, 0.193382f, 1.65638f, 
		-3.68783f, -0.116970f, 1.81103f, -3.68783f, -0.116970f, 1.81103f, 
		-3.68778f, -0.274558f, 1.50914f, -3.68778f, -0.274558f, 1.50914f, 
		-3.68778f, -0.274558f, 1.50914f, -3.68778f, -0.274558f, 1.50914f, 
		-3.68758f, -0.311177f, 1.39354f, -3.68758f, -0.311177f, 1.39354f, 
		-3.68758f, -0.311177f, 1.39354f, -3.68758f, -0.311177f, 1.39354f, 
		-3.68718f, -0.415864f, 1.75003f, -3.68706f, 0.371110f, 1.99016f, 
		-3.68705f, 0.270876f, 1.70471f, -3.68703f, -0.303787f, 1.34056f, 
		-3.68703f, -0.303787f, 1.34056f, -3.68703f, -0.303787f, 1.34056f, 
		-3.68703f, -0.303787f, 1.34056f, -3.68688f, 0.307644f, 1.56032f, 
		-3.68688f, 0.307644f, 1.56032f, -3.68688f, 0.307644f, 1.56032f, 
		-3.68688f, 0.307644f, 1.56032f, -3.68688f, 0.307644f, 1.56032f, 
		-3.68688f, 0.300667f, 1.87238f, -3.68686f, 0.0809170f, 1.75597f, 
		-3.68626f, -0.319591f, 1.39508f, -3.68626f, -0.319591f, 1.39508f, 
		-3.68626f, -0.319591f, 1.39508f, -3.68626f, -0.319591f, 1.39508f, 
		-3.68626f, -0.319591f, 1.39508f, -3.68626f, -0.319591f, 1.39508f, 
		-3.68595f, 0.232387f, 1.93327f, -3.68593f, -0.329239f, 1.39411f, 
		-3.68593f, -0.329239f, 1.39411f, -3.68593f, -0.329239f, 1.39411f, 
		-3.68593f, -0.329239f, 1.39411f, -3.68592f, -0.412886f, 1.76744f, 
		-3.68592f, -0.412886f, 1.76744f, -3.68582f, -0.295572f, 1.36590f, 
		-3.68582f, -0.295572f, 1.36590f, -3.68550f, 0.293620f, 1.57046f, 
		-3.68550f, 0.293620f, 1.57046f, -3.68550f, 0.293620f, 1.57046f, 
		-3.68523f, 0.226964f, 1.64745f, -3.68523f, -0.241683f, 1.82497f, 
		-3.68523f, -0.241683f, 1.82497f, -3.68513f, -0.248565f, 1.87717f, 
		-3.68513f, -0.248565f, 1.87717f, -3.68513f, -0.248565f, 1.87717f, 
		-3.68495f, -0.331926f, 1.40939f, -3.68495f, -0.331926f, 1.40939f, 
		-3.68495f, -0.331926f, 1.40939f, -3.68495f, -0.331926f, 1.40939f, 
		-3.68495f, -0.331926f, 1.40939f, -3.68493f, -0.330622f, 1.39589f, 
		-3.68493f, -0.330622f, 1.39589f, -3.68493f, -0.330622f, 1.39589f, 
		-3.68493f, -0.330622f, 1.39589f, -3.68479f, -0.293130f, 1.54127f, 
		-3.68479f, -0.293130f, 1.54127f, -3.68479f, -0.293130f, 1.54127f, 
		-3.68465f, 0.255839f, 1.80389f, -3.68450f, 0.322822f, 1.55751f, 
		-3.68450f, 0.322822f, 1.55751f, -3.68450f, 0.322822f, 1.55751f, 
		-3.68444f, -0.297921f, 1.32877f, -3.68444f, -0.297921f, 1.32877f, 
		-3.68444f, -0.297921f, 1.32877f, -3.68444f, -0.297921f, 1.32877f, 
		-3.68444f, -0.297921f, 1.32877f, -3.68443f, -0.249853f, 1.67434f, 
		-3.68443f, -0.249853f, 1.67434f, -3.68443f, -0.249853f, 1.67434f, 
		-3.68443f, -0.249853f, 1.67434f, -3.68433f, -0.281447f, 1.89808f, 
		-3.68433f, -0.281447f, 1.89808f, -3.68433f, -0.281447f, 1.89808f, 
		-3.68433f, -0.319065f, 1.39340f, -3.68433f, -0.319065f, 1.39340f, 
		-3.68433f, -0.319065f, 1.39340f, -3.68433f, -0.319065f, 1.39340f, 
		-3.68433f, -0.319065f, 1.39340f, -3.68431f, -0.284031f, 1.40011f, 
		-3.68431f, -0.284031f, 1.40011f, -3.68431f, -0.284031f, 1.40011f, 
		-3.68431f, -0.284031f, 1.40011f, -3.68396f, -0.330838f, 1.37850f, 
		-3.68396f, -0.330838f, 1.37850f, -3.68396f, -0.330838f, 1.37850f, 
		-3.68396f, -0.330838f, 1.37850f, -3.68373f, -0.267039f, 1.65586f, 
		-3.68372f, 0.555212f, 1.54258f, -3.68369f, 0.149905f, 1.75351f, 
		-3.68360f, 0.308763f, 1.55569f, -3.68360f, 0.308763f, 1.55569f, 
		-3.68360f, 0.308763f, 1.55569f, -3.68360f, 0.308763f, 1.55569f, 
		-3.68360f, 0.308763f, 1.55569f, -3.68357f, -0.328153f, 1.37584f, 
		-3.68357f, -0.328153f, 1.37584f, -3.68357f, -0.328153f, 1.37584f, 
		-3.68357f, -0.328153f, 1.37584f, -3.68354f, 0.161961f, 1.65684f, 
		-3.68354f, 0.161961f, 1.65684f, -3.68354f, 0.161961f, 1.65684f, 
		-3.68343f, -0.319496f, 1.37453f, -3.68343f, -0.319496f, 1.37453f, 
		-3.68343f, -0.319496f, 1.37453f, -3.68343f, -0.319496f, 1.37453f, 
		-3.68343f, -0.319496f, 1.37453f, -3.68336f, 0.342124f, 1.97891f, 
		-3.68330f, -0.330918f, 1.36895f, -3.68330f, -0.330918f, 1.36895f, 
		-3.68330f, -0.330918f, 1.36895f, -3.68330f, -0.330918f, 1.36895f, 
		-3.68330f, -0.330918f, 1.36895f, -3.68329f, -0.305872f, 1.40869f, 
		-3.68329f, -0.305872f, 1.40869f, -3.68329f, -0.305872f, 1.40869f, 
		-3.68329f, -0.305872f, 1.40869f, -3.68329f, -0.305872f, 1.40869f, 
		-3.68329f, -0.305872f, 1.40869f, -3.68329f, -0.305872f, 1.40869f, 
		-3.68301f, -0.274603f, 1.53614f, -3.68301f, -0.274603f, 1.53614f, 
		-3.68301f, -0.274603f, 1.53614f, -3.68301f, -0.274603f, 1.53614f, 
		-3.68301f, -0.274603f, 1.53614f, -3.68301f, -0.274603f, 1.53614f, 
		-3.68301f, -0.274603f, 1.53614f, -3.68289f, -0.328896f, 1.34343f, 
		-3.68289f, -0.328896f, 1.34343f, -3.68289f, -0.328896f, 1.34343f, 
		-3.68289f, -0.328896f, 1.34343f, -3.68289f, -0.328896f, 1.34343f, 
		-3.68289f, -0.328896f, 1.34343f, -3.68289f, -0.328896f, 1.34343f, 
		-3.68281f, -0.414385f, 1.78474f, -3.68277f, -0.303655f, 1.38986f, 
		-3.68277f, -0.303655f, 1.38986f, -3.68271f, -0.318746f, 1.36553f, 
		-3.68271f, -0.318746f, 1.36553f, -3.68271f, -0.318746f, 1.36553f, 
		-3.68271f, -0.318746f, 1.36553f, -3.68271f, -0.318746f, 1.36553f, 
		-3.68266f, -0.170306f, 1.73679f, -3.68266f, -0.170306f, 1.73679f, 
		-3.68264f, 0.291038f, 1.55506f, -3.68264f, 0.291038f, 1.55506f, 
		-3.68256f, -0.302282f, 1.90891f, -3.68248f, -0.272559f, 1.89212f, 
		-3.68242f, 0.427166f, 1.80999f, -3.68230f, 0.198781f, 1.63079f, 
		-3.68230f, -0.240955f, 1.69368f, -3.68230f, -0.240955f, 1.69368f, 
		-3.68218f, -0.118390f, 1.72957f, -3.68216f, -0.418108f, 1.73211f, 
		-3.68196f, 0.719020f, 1.91912f, -3.68196f, 0.719020f, 1.91912f, 
		-3.68184f, 0.384671f, 1.57132f, -3.68180f, 0.357361f, 1.56249f, 
		-3.68175f, -0.289664f, 1.38920f, -3.68175f, -0.289664f, 1.38920f, 
		-3.68175f, -0.289664f, 1.38920f, -3.68175f, -0.289664f, 1.38920f, 
		-3.68175f, -0.289664f, 1.38920f, -3.68165f, -0.118611f, 1.81726f, 
		-3.68160f, -0.171703f, 1.75198f, -3.68158f, -0.288683f, 1.34851f, 
		-3.68158f, -0.288683f, 1.34851f, -3.68158f, -0.288683f, 1.34851f, 
		-3.68135f, -0.114013f, 1.73705f, -3.68135f, -0.114013f, 1.73705f, 
		-3.68108f, 0.199684f, 1.62701f, -3.68108f, 0.199684f, 1.62701f, 
		-3.68108f, 0.199684f, 1.62701f, -3.68102f, -0.114287f, 1.80952f, 
		-3.68102f, -0.114287f, 1.80952f, -3.68094f, 0.357783f, 1.55052f, 
		-3.68094f, 0.357783f, 1.55052f, -3.68094f, 0.357783f, 1.55052f, 
		-3.68085f, 0.322075f, 1.55429f, -3.68085f, 0.322075f, 1.55429f, 
		-3.68082f, -0.252482f, 1.87385f, -3.68082f, -0.252482f, 1.87385f, 
		-3.68082f, -0.252482f, 1.87385f, -3.68082f, -0.252482f, 1.87385f, 
		-3.68078f, -0.338179f, 1.32150f, -3.68078f, -0.338179f, 1.32150f, 
		-3.68078f, -0.338179f, 1.32150f, -3.68078f, -0.338179f, 1.32150f, 
		-3.68078f, -0.338179f, 1.32150f, -3.68078f, -0.338179f, 1.32150f, 
		-3.68074f, -0.292610f, 1.41946f, -3.68074f, -0.292610f, 1.41946f, 
		-3.68074f, -0.292610f, 1.41946f, -3.68074f, -0.292610f, 1.41946f, 
		-3.68074f, -0.310295f, 1.28936f, -3.68074f, -0.310295f, 1.28936f, 
		-3.68074f, -0.310295f, 1.28936f, -3.68074f, -0.310295f, 1.28936f, 
		-3.68074f, -0.310295f, 1.28936f, -3.68069f, 0.418195f, 1.61410f, 
		-3.68058f, -0.299882f, 1.41303f, -3.68058f, -0.299882f, 1.41303f, 
		-3.68058f, -0.299882f, 1.41303f, -3.68058f, -0.299882f, 1.41303f, 
		-3.68058f, -0.299882f, 1.41303f, -3.68058f, -0.299882f, 1.41303f, 
		-3.68058f, -0.299882f, 1.41303f, -3.68058f, -0.299882f, 1.41303f, 
		-3.68058f, -0.299882f, 1.41303f, -3.68055f, -0.320961f, 1.41020f, 
		-3.68055f, -0.320961f, 1.41020f, -3.68055f, -0.320961f, 1.41020f, 
		-3.68055f, -0.320961f, 1.41020f, -3.68055f, -0.320961f, 1.41020f, 
		-3.68055f, -0.372768f, 1.90307f, -3.68050f, -0.277254f, 1.40839f, 
		-3.68050f, -0.277254f, 1.40839f, -3.68050f, -0.277254f, 1.40839f, 
		-3.68050f, -0.277254f, 1.40839f, -3.68048f, -0.280758f, 1.41333f, 
		-3.68048f, -0.280758f, 1.41333f, -3.68048f, -0.280758f, 1.41333f, 
		-3.68048f, -0.280758f, 1.41333f, -3.68046f, -0.334445f, 1.45858f, 
		-3.68046f, -0.334445f, 1.45858f, -3.68046f, -0.334445f, 1.45858f, 
		-3.68045f, 0.322018f, 1.88318f, -3.68039f, 0.166927f, 1.66256f, 
		-3.68035f, 0.187995f, 1.81189f, -3.68025f, -0.284307f, 1.39855f, 
		-3.68025f, -0.284307f, 1.39855f, -3.68025f, -0.284307f, 1.39855f, 
		-3.68025f, -0.284307f, 1.39855f, -3.68024f, 0.267045f, 1.60375f, 
		-3.68009f, 0.301559f, 1.95422f, -3.68008f, 0.171574f, 1.79640f, 
		-3.68008f, 0.171574f, 1.79640f, -3.68008f, 0.171574f, 1.79640f, 
		-3.68000f, -0.282924f, 1.48148f, -3.68000f, -0.282924f, 1.48148f, 
		-3.68000f, -0.282924f, 1.48148f, -3.67962f, -0.313460f, 1.34441f, 
		-3.67962f, -0.313460f, 1.34441f, -3.67962f, -0.313460f, 1.34441f, 
		-3.67962f, -0.313460f, 1.34441f, -3.67962f, -0.313460f, 1.34441f, 
		-3.67962f, -0.313460f, 1.34441f, -3.67962f, -0.253708f, 1.74087f, 
		-3.67962f, -0.253708f, 1.74087f, -3.67959f, 0.399839f, 1.73275f, 
		-3.67949f, -0.333135f, 1.42532f, -3.67949f, -0.333135f, 1.42532f, 
		-3.67949f, -0.333135f, 1.42532f, -3.67942f, -0.416170f, 1.84397f, 
		-3.67942f, -0.416170f, 1.84397f, -3.67942f, -0.416170f, 1.84397f, 
		-3.67936f, 0.172118f, 1.65974f, -3.67936f, 0.172118f, 1.65974f, 
		-3.67922f, 0.152521f, 1.77658f, -3.67922f, 0.152521f, 1.77658f, 
		-3.67922f, 0.152521f, 1.77658f, -3.67922f, 0.152521f, 1.77658f, 
		-3.67922f, 0.152521f, 1.77658f, -3.67915f, 0.207466f, 1.62537f, 
		-3.67915f, 0.207466f, 1.62537f, -3.67915f, 0.207466f, 1.62537f, 
		-3.67908f, -0.365782f, 1.27163f, -3.67908f, -0.365782f, 1.27163f, 
		-3.67897f, -0.331786f, 1.41534f, -3.67897f, -0.331786f, 1.41534f, 
		-3.67897f, -0.331786f, 1.41534f, -3.67897f, -0.331786f, 1.41534f, 
		-3.67888f, 0.415298f, 1.67419f, -3.67880f, -0.335303f, 1.41658f, 
		-3.67874f, -0.342486f, 1.61393f, -3.67874f, -0.342486f, 1.61393f, 
		-3.67873f, 0.198967f, 1.63516f, -3.67873f, 0.198967f, 1.63516f, 
		-3.67873f, 0.198967f, 1.63516f, -3.67872f, -0.287556f, 1.36849f, 
		-3.67872f, -0.287556f, 1.36849f, -3.67872f, -0.287556f, 1.36849f, 
		-3.67865f, 0.260141f, 1.65751f, -3.67865f, 0.355902f, 1.55068f, 
		-3.67865f, 0.290236f, 1.58992f, -3.67858f, -0.117380f, 1.75028f, 
		-3.67852f, -0.312588f, 1.39121f, -3.67852f, -0.312588f, 1.39121f, 
		-3.67852f, -0.312588f, 1.39121f, -3.67852f, -0.312588f, 1.39121f, 
		-3.67843f, -0.117648f, 1.79598f, -3.67837f, 0.206564f, 1.81997f, 
		-3.67837f, 0.206564f, 1.81997f, -3.67837f, 0.206564f, 1.81997f, 
		-3.67822f, -0.317832f, 1.51259f, -3.67822f, -0.317832f, 1.51259f, 
		-3.67822f, -0.317832f, 1.51259f, -3.67822f, -0.317832f, 1.51259f, 
		-3.67822f, 0.751187f, 1.86379f, -3.67822f, 0.751187f, 1.86379f, 
		-3.67813f, 0.614514f, 1.54395f, -3.67813f, 0.614514f, 1.54395f, 
		-3.67813f, 0.614514f, 1.54395f, -3.67813f, 0.614514f, 1.54395f, 
		-3.67809f, -0.338706f, 1.24170f, -3.67809f, -0.338706f, 1.24170f, 
		-3.67809f, -0.338706f, 1.24170f, -3.67809f, -0.338706f, 1.24170f, 
		-3.67809f, -0.338706f, 1.24170f, -3.67808f, -0.330893f, 1.40264f, 
		-3.67808f, -0.330893f, 1.40264f, -3.67808f, -0.330893f, 1.40264f, 
		-3.67796f, -0.325211f, 1.39560f, -3.67796f, -0.325211f, 1.39560f, 
		-3.67796f, -0.325211f, 1.39560f, -3.67796f, -0.325211f, 1.39560f, 
		-3.67796f, -0.325211f, 1.39560f, -3.67796f, -0.325211f, 1.39560f, 
		-3.67790f, -0.295347f, 1.51211f, -3.67790f, -0.295347f, 1.51211f, 
		-3.67790f, -0.295347f, 1.51211f, -3.67790f, -0.295347f, 1.51211f, 
		-3.67772f, -0.295849f, 1.39209f, -3.67772f, -0.295849f, 1.39209f, 
		-3.67769f, 0.334377f, 1.56040f, -3.67763f, -0.270324f, 1.49484f, 
		-3.67763f, -0.270324f, 1.49484f, -3.67763f, -0.270324f, 1.49484f, 
		-3.67763f, -0.270324f, 1.49484f, -3.67763f, -0.270324f, 1.49484f, 
		-3.67753f, -0.266369f, 1.49623f, -3.67753f, -0.266369f, 1.49623f, 
		-3.67753f, -0.266369f, 1.49623f, -3.67741f, -0.236979f, 1.85931f, 
		-3.67741f, -0.236979f, 1.85931f, -3.67737f, 0.289296f, 1.58420f, 
		-3.67737f, 0.289296f, 1.58420f, -3.67737f, 0.289296f, 1.58420f, 
		-3.67737f, 0.289296f, 1.58420f, -3.67733f, 0.293275f, 1.70763f, 
		-3.67727f, -0.334102f, 1.34717f, -3.67727f, -0.334102f, 1.34717f, 
		-3.67727f, -0.334102f, 1.34717f, -3.67727f, -0.334102f, 1.34717f, 
		-3.67727f, -0.334102f, 1.34717f, -3.67719f, -0.278069f, 1.53083f, 
		-3.67719f, -0.278069f, 1.53083f, -3.67719f, -0.278069f, 1.53083f, 
		-3.67719f, -0.278069f, 1.53083f, -3.67717f, -0.243937f, 1.80795f, 
		-3.67713f, -0.274724f, 1.53517f, -3.67713f, -0.274724f, 1.53517f, 
		-3.67713f, -0.274724f, 1.53517f, -3.67713f, -0.274724f, 1.53517f, 
		-3.67713f, -0.291467f, 1.63831f, -3.67713f, -0.306972f, 1.53204f, 
		-3.67713f, -0.306972f, 1.53204f, -3.67713f, -0.306972f, 1.53204f, 
		-3.67713f, -0.306972f, 1.53204f, -3.67704f, 0.151420f, 1.66150f, 
		-3.67704f, 0.290564f, 1.72600f, -3.67701f, 0.303334f, 1.56942f, 
		-3.67693f, 0.259145f, 1.83083f, -3.67690f, 0.182036f, 1.65871f, 
		-3.67690f, 0.182036f, 1.65871f, -3.67690f, 0.182036f, 1.65871f, 
		-3.67665f, -0.312374f, 1.33413f, -3.67665f, -0.312374f, 1.33413f, 
		-3.67665f, -0.312374f, 1.33413f, -3.67665f, -0.312374f, 1.33413f, 
		-3.67653f, 0.197973f, 1.63035f, -3.67653f, 0.197973f, 1.63035f, 
		-3.67653f, 0.197973f, 1.63035f, -3.67653f, 0.197973f, 1.63035f, 
		-3.67652f, -0.303472f, 1.53667f, -3.67652f, -0.303472f, 1.53667f, 
		-3.67652f, -0.303472f, 1.53667f, -3.67652f, -0.303472f, 1.53667f, 
		-3.67639f, 0.206453f, 1.63721f, -3.67639f, 0.206453f, 1.63721f, 
		-3.67639f, 0.206453f, 1.63721f, -3.67639f, 0.206453f, 1.63721f, 
		-3.67639f, 0.206453f, 1.63721f, -3.67620f, -0.338892f, 1.46659f, 
		-3.67620f, -0.338892f, 1.46659f, -3.67620f, -0.338892f, 1.46659f, 
		-3.67620f, -0.338892f, 1.46659f, -3.67613f, 0.316475f, 1.71319f, 
		-3.67577f, -0.307035f, 1.50958f, -3.67577f, -0.307035f, 1.50958f, 
		-3.67577f, -0.307035f, 1.50958f, -3.67577f, -0.307035f, 1.50958f, 
		-3.67575f, -0.402888f, 1.65621f, -3.67575f, -0.402888f, 1.65621f, 
		-3.67575f, -0.402888f, 1.65621f, -3.67560f, 0.0711260f, 1.71644f, 
		-3.67548f, -0.167485f, 1.73848f, -3.67548f, -0.167485f, 1.73848f, 
		-3.67548f, -0.167485f, 1.73848f, -3.67548f, 0.346012f, 1.88685f, 
		-3.67524f, 0.269628f, 1.74587f, -3.67521f, 0.0925090f, 1.78765f, 
		-3.67512f, -0.319437f, 1.40781f, -3.67512f, -0.319437f, 1.40781f, 
		-3.67512f, -0.319437f, 1.40781f, -3.67512f, -0.319437f, 1.40781f, 
		-3.67496f, 0.293974f, 1.56003f, -3.67496f, 0.293974f, 1.56003f, 
		-3.67496f, 0.293974f, 1.56003f, -3.67493f, -0.244896f, 1.69395f, 
		-3.67493f, -0.244896f, 1.69395f, -3.67486f, -0.171041f, 1.79670f, 
		-3.67485f, -0.355820f, 1.24899f, -3.67485f, -0.355820f, 1.24899f, 
		-3.67485f, -0.355820f, 1.24899f, -3.67485f, -0.355820f, 1.24899f, 
		-3.67473f, -0.169438f, 1.81118f, -3.67473f, -0.169438f, 1.81118f, 
		-3.67465f, -0.310422f, 1.34206f, -3.67465f, -0.310422f, 1.34206f, 
		-3.67465f, -0.310422f, 1.34206f, -3.67465f, -0.310422f, 1.34206f, 
		-3.67444f, 0.270991f, 1.73172f, -3.67422f, -0.416436f, 1.80183f, 
		-3.67422f, -0.416436f, 1.80183f, -3.67416f, -0.314075f, 1.39090f, 
		-3.67416f, -0.314075f, 1.39090f, -3.67416f, -0.314075f, 1.39090f, 
		-3.67403f, -0.287457f, 1.53397f, -3.67403f, -0.287457f, 1.53397f, 
		-3.67403f, -0.287457f, 1.53397f, -3.67403f, -0.287457f, 1.53397f, 
		-3.67402f, 0.0957360f, 1.64602f, -3.67401f, -0.172690f, 1.77470f, 
		-3.67399f, -0.311018f, 1.37216f, -3.67371f, 0.373996f, 1.71477f, 
		-3.67348f, -0.321705f, 1.50572f, -3.67348f, -0.321705f, 1.50572f, 
		-3.67348f, -0.321705f, 1.50572f, -3.67327f, -0.219660f, 1.74869f, 
		-3.67327f, -0.219660f, 1.74869f, -3.67327f, -0.219660f, 1.74869f, 
		-3.67326f, -0.293924f, 1.50500f, -3.67326f, -0.293924f, 1.50500f, 
		-3.67326f, -0.293924f, 1.50500f, -3.67326f, -0.293924f, 1.50500f, 
		-3.67326f, -0.293924f, 1.50500f, -3.67321f, -0.255909f, 1.81516f, 
		-3.67321f, -0.255909f, 1.81516f, -3.67321f, -0.255909f, 1.81516f, 
		-3.67321f, -0.255909f, 1.81516f, -3.67321f, -0.255909f, 1.81516f, 
		-3.67321f, -0.255909f, 1.81516f, -3.67321f, 0.410467f, 1.85506f, 
		-3.67309f, -0.301378f, 1.40792f, -3.67309f, -0.301378f, 1.40792f, 
		-3.67309f, -0.301378f, 1.40792f, -3.67309f, -0.301378f, 1.40792f, 
		-3.67309f, -0.301378f, 1.40792f, -3.67309f, -0.301378f, 1.40792f, 
		-3.67309f, -0.301378f, 1.40792f, -3.67309f, -0.301378f, 1.40792f, 
		-3.67308f, 0.210848f, 1.63374f, -3.67308f, 0.210848f, 1.63374f, 
		-3.67308f, 0.210848f, 1.63374f, -3.67289f, 0.350258f, 1.55104f, 
		-3.67289f, 0.350258f, 1.55104f, -3.67289f, 0.350258f, 1.55104f, 
		-3.67289f, 0.350258f, 1.55104f, -3.67289f, 0.350258f, 1.55104f, 
		-3.67283f, -0.309359f, 1.35115f, -3.67272f, 0.221607f, 1.81952f, 
		-3.67261f, 0.344826f, 1.70869f, -3.67258f, 0.759092f, 1.80089f, 
		-3.67258f, 0.759092f, 1.80089f, -3.67251f, -0.118961f, 1.77302f, 
		-3.67246f, 0.370304f, 1.88302f, -3.67228f, 0.118175f, 1.83142f, 
		-3.67216f, 0.298741f, 1.56795f, -3.67216f, 0.298741f, 1.56795f, 
		-3.67186f, -0.329524f, 1.41032f, -3.67186f, -0.329524f, 1.41032f, 
		-3.67186f, -0.329524f, 1.41032f, -3.67186f, -0.329524f, 1.41032f, 
		-3.67186f, -0.329524f, 1.41032f, -3.67175f, 0.395874f, 1.58654f, 
		-3.67167f, 0.392515f, 1.87207f, -3.67162f, -0.171029f, 1.72983f, 
		-3.67162f, -0.171029f, 1.72983f, -3.67162f, -0.171029f, 1.72983f, 
		-3.67133f, 0.418772f, 1.75196f, -3.67130f, 0.156714f, 1.88594f, 
		-3.67126f, -0.238982f, 1.71316f, -3.67126f, -0.238982f, 1.71316f, 
		-3.67126f, -0.238982f, 1.71316f, -3.67126f, -0.238982f, 1.71316f, 
		-3.67121f, -0.309025f, 1.35255f, -3.67118f, -0.331692f, 1.60577f, 
		-3.67118f, -0.331692f, 1.60577f, -3.67117f, -0.311845f, 1.37349f, 
		-3.67105f, 0.190054f, 1.65275f, -3.67105f, 0.190054f, 1.65275f, 
		-3.67105f, 0.190054f, 1.65275f, -3.67105f, 0.190054f, 1.65275f, 
		-3.67101f, -0.287306f, 1.39099f, -3.67101f, -0.287306f, 1.39099f, 
		-3.67101f, -0.287306f, 1.39099f, -3.67101f, -0.287306f, 1.39099f, 
		-3.67101f, -0.287306f, 1.39099f, -3.67091f, 0.255715f, 1.77085f, 
		-3.67055f, 0.617791f, 1.57137f, -3.67055f, 0.617791f, 1.57137f, 
		-3.67055f, 0.617791f, 1.57137f, -3.67055f, 0.617791f, 1.57137f, 
		-3.67055f, -0.321200f, 1.39510f, -3.67055f, -0.321200f, 1.39510f, 
		-3.67055f, -0.321200f, 1.39510f, -3.67054f, 0.296548f, 1.56358f, 
		-3.67054f, 0.296548f, 1.56358f, -3.67054f, 0.296548f, 1.56358f, 
		-3.67054f, 0.296548f, 1.56358f, -3.67052f, -0.282083f, 1.48231f, 
		-3.67052f, -0.282083f, 1.48231f, -3.67052f, -0.282083f, 1.48231f, 
		-3.67052f, -0.282083f, 1.48231f, -3.67048f, -0.274069f, 1.52668f, 
		-3.67048f, -0.274069f, 1.52668f, -3.67048f, 0.344053f, 1.55809f, 
		-3.67048f, 0.344053f, 1.55809f, -3.67048f, 0.344053f, 1.55809f, 
		-3.67048f, 0.344053f, 1.55809f, -3.67048f, 0.344053f, 1.55809f, 
		-3.67038f, 0.397323f, 1.69389f, -3.67028f, -0.306029f, 1.52801f, 
		-3.67028f, -0.306029f, 1.52801f, -3.67028f, -0.306029f, 1.52801f, 
		-3.67028f, -0.306029f, 1.52801f, -3.67017f, 0.226858f, 1.63960f, 
		-3.66998f, 0.265481f, 1.62249f, -3.66995f, 0.179334f, 1.64798f, 
		-3.66995f, 0.179334f, 1.64798f, -3.66995f, 0.179334f, 1.64798f, 
		-3.66990f, -0.218456f, 1.81347f, -3.66990f, -0.218456f, 1.81347f, 
		-3.66990f, -0.218456f, 1.81347f, -3.66989f, -0.317317f, 1.39221f, 
		-3.66989f, -0.317317f, 1.39221f, -3.66989f, -0.317317f, 1.39221f, 
		-3.66989f, -0.317317f, 1.39221f, -3.66989f, -0.317317f, 1.39221f, 
		-3.66965f, -0.339392f, 1.26856f, -3.66965f, -0.339392f, 1.26856f, 
		-3.66965f, -0.339392f, 1.26856f, -3.66949f, 0.217844f, 1.63759f, 
		-3.66938f, 0.318980f, 1.71536f, -3.66933f, -0.218929f, 1.73368f, 
		-3.66933f, -0.218929f, 1.73368f, -3.66933f, -0.218929f, 1.73368f, 
		-3.66933f, -0.218929f, 1.73368f, -3.66922f, -0.319937f, 1.62212f, 
		-3.66890f, 0.343908f, 1.55386f, -3.66890f, 0.343908f, 1.55386f, 
		-3.66889f, -0.309634f, 1.34443f, -3.66889f, -0.309634f, 1.34443f, 
		-3.66889f, -0.309634f, 1.34443f, -3.66889f, -0.309634f, 1.34443f, 
		-3.66889f, -0.309634f, 1.34443f, -3.66877f, 0.364290f, 1.56886f, 
		-3.66874f, -0.221318f, 1.79842f, -3.66874f, -0.221318f, 1.79842f, 
		-3.66870f, -0.242494f, 1.85077f, -3.66870f, -0.242494f, 1.85077f, 
		-3.66858f, -0.335463f, 1.46297f, -3.66858f, -0.335463f, 1.46297f, 
		-3.66858f, -0.335463f, 1.46297f, -3.66853f, 0.270838f, 1.85509f, 
		-3.66851f, -0.253184f, 1.66838f, -3.66844f, 0.420133f, 1.99172f, 
		-3.66844f, -0.268157f, 1.47420f, -3.66840f, -0.329715f, 1.39563f, 
		-3.66840f, -0.329715f, 1.39563f, -3.66840f, -0.329715f, 1.39563f, 
		-3.66840f, -0.329715f, 1.39563f, -3.66826f, 0.416274f, 1.63682f, 
		-3.66824f, -0.265483f, 1.61354f, -3.66824f, -0.265483f, 1.61354f, 
		-3.66824f, -0.265483f, 1.61354f, -3.66824f, -0.265483f, 1.61354f, 
		-3.66819f, 0.185689f, 1.64827f, -3.66819f, 0.185689f, 1.64827f, 
		-3.66819f, 0.185689f, 1.64827f, -3.66819f, 0.185689f, 1.64827f, 
		-3.66814f, -0.228189f, 1.84238f, -3.66814f, -0.228189f, 1.84238f, 
		-3.66814f, -0.228189f, 1.84238f, -3.66814f, -0.228189f, 1.84238f, 
		-3.66777f, 0.183526f, 1.65653f, -3.66777f, 0.183526f, 1.65653f, 
		-3.66777f, 0.183526f, 1.65653f, -3.66777f, 0.183526f, 1.65653f, 
		-3.66777f, 0.183526f, 1.65653f, -3.66777f, 0.183526f, 1.65653f, 
		-3.66777f, 0.183526f, 1.65653f, -3.66768f, 0.198600f, 1.63434f, 
		-3.66768f, 0.198600f, 1.63434f, -3.66768f, 0.198600f, 1.63434f, 
		-3.66767f, -0.307631f, 1.39472f, -3.66767f, -0.307631f, 1.39472f, 
		-3.66767f, -0.307631f, 1.39472f, -3.66762f, 0.483319f, 1.98740f, 
		-3.66715f, 0.151219f, 1.60897f, -3.66713f, -0.289752f, 1.52571f, 
		-3.66711f, -0.268233f, 1.49461f, -3.66711f, -0.268233f, 1.49461f, 
		-3.66711f, -0.268233f, 1.49461f, -3.66711f, -0.268233f, 1.49461f, 
		-3.66710f, 0.373190f, 1.98140f, -3.66709f, 0.187645f, 1.64902f, 
		-3.66709f, 0.187645f, 1.64902f, -3.66709f, 0.187645f, 1.64902f, 
		-3.66699f, 0.282996f, 1.59247f, -3.66691f, 0.380743f, 1.54955f, 
		-3.66691f, 0.380743f, 1.54955f, -3.66691f, 0.380743f, 1.54955f, 
		-3.66690f, -0.353792f, 1.93017f, -3.66690f, -0.353792f, 1.93017f, 
		-3.66686f, 0.267733f, 1.75314f, -3.66686f, 0.267733f, 1.75314f, 
		-3.66686f, 0.267733f, 1.75314f, -3.66681f, -0.324834f, 1.49922f, 
		-3.66681f, -0.324834f, 1.49922f, -3.66681f, -0.324834f, 1.49922f, 
		-3.66681f, -0.324834f, 1.49922f, -3.66681f, -0.324834f, 1.49922f, 
		-3.66681f, -0.324834f, 1.49922f, -3.66681f, -0.324834f, 1.49922f, 
		-3.66681f, -0.324834f, 1.49922f, -3.66674f, 0.188491f, 1.65549f, 
		-3.66674f, 0.188491f, 1.65549f, -3.66674f, 0.188491f, 1.65549f, 
		-3.66673f, -0.289192f, 1.49697f, -3.66673f, -0.289192f, 1.49697f, 
		-3.66673f, -0.289192f, 1.49697f, -3.66673f, -0.289192f, 1.49697f, 
		-3.66673f, -0.289192f, 1.49697f, -3.66673f, -0.289192f, 1.49697f, 
		-3.66661f, -0.288811f, 1.38919f, -3.66661f, -0.288811f, 1.38919f, 
		-3.66661f, -0.288811f, 1.38919f, -3.66661f, -0.288811f, 1.38919f, 
		-3.66661f, -0.288811f, 1.38919f, -3.66659f, 0.183585f, 1.58501f, 
		-3.66659f, 0.183585f, 1.58501f, -3.66659f, 0.183585f, 1.58501f, 
		-3.66655f, -0.247922f, 1.73460f, -3.66655f, -0.247922f, 1.73460f, 
		-3.66655f, -0.247922f, 1.73460f, -3.66655f, -0.247922f, 1.73460f, 
		-3.66645f, -0.166742f, 1.80946f, -3.66645f, -0.166742f, 1.80946f, 
		-3.66645f, -0.166742f, 1.80946f, -3.66641f, 0.273692f, 1.67597f, 
		-3.66635f, -0.264585f, 1.49639f, -3.66635f, -0.264585f, 1.49639f, 
		-3.66635f, -0.264585f, 1.49639f, -3.66635f, -0.264585f, 1.49639f, 
		-3.66631f, -0.280845f, 1.45523f, -3.66631f, -0.280845f, 1.45523f, 
		-3.66631f, -0.280845f, 1.45523f, -3.66625f, -0.289488f, 1.37237f, 
		-3.66625f, -0.289488f, 1.37237f, -3.66625f, -0.289488f, 1.37237f, 
		-3.66589f, 0.274098f, 1.55725f, -3.66589f, 0.274098f, 1.55725f, 
		-3.66589f, 0.274098f, 1.55725f, -3.66584f, -0.277128f, 1.93654f, 
		-3.66584f, -0.277128f, 1.93654f, -3.66577f, 0.294910f, 1.94237f, 
		-3.66573f, 0.373681f, 1.70814f, -3.66564f, -0.334498f, 1.35276f, 
		-3.66564f, -0.334498f, 1.35276f, -3.66564f, -0.334498f, 1.35276f, 
		-3.66564f, -0.334498f, 1.35276f, -3.66560f, 0.235174f, 1.81226f, 
		-3.66559f, 0.199091f, 1.62629f, -3.66559f, 0.199091f, 1.62629f, 
		-3.66559f, 0.199091f, 1.62629f, -3.66557f, -0.406049f, 1.87602f, 
		-3.66552f, -0.341749f, 1.93659f, -3.66552f, -0.341749f, 1.93659f, 
		-3.66539f, 0.346686f, 1.71554f, -3.66512f, 0.379069f, 1.58001f, 
		-3.66505f, -0.329363f, 1.37899f, -3.66505f, -0.329363f, 1.37899f, 
		-3.66499f, -0.170797f, 1.81732f, -3.66499f, -0.170797f, 1.81732f, 
		-3.66499f, -0.170797f, 1.81732f, -3.66481f, 0.624643f, 1.58490f, 
		-3.66481f, 0.624643f, 1.58490f, -3.66481f, 0.624643f, 1.58490f, 
		-3.66475f, 0.315095f, 1.96202f, -3.66475f, 0.315095f, 1.96202f, 
		-3.66475f, 0.315095f, 1.96202f, -3.66448f, 0.250189f, 1.79849f, 
		-3.66443f, -0.320352f, 1.37240f, -3.66443f, -0.320352f, 1.37240f, 
		-3.66443f, -0.320352f, 1.37240f, -3.66443f, -0.320352f, 1.37240f, 
		-3.66434f, -0.331738f, 1.92261f, -3.66415f, 0.205534f, 1.62593f, 
		-3.66415f, 0.205534f, 1.62593f, -3.66415f, 0.205534f, 1.62593f, 
		-3.66415f, 0.205534f, 1.62593f, -3.66399f, 0.171862f, 1.76388f, 
		-3.66399f, 0.171862f, 1.76388f, -3.66390f, -0.378708f, 1.63118f, 
		-3.66390f, -0.378708f, 1.63118f, -3.66368f, -0.309287f, 1.49753f, 
		-3.66368f, -0.309287f, 1.49753f, -3.66368f, -0.309287f, 1.49753f, 
		-3.66368f, -0.309287f, 1.49753f, -3.66362f, 0.590186f, 1.49634f, 
		-3.66362f, 0.590186f, 1.49634f, -3.66362f, 0.590186f, 1.49634f, 
		-3.66362f, 0.590186f, 1.49634f, -3.66362f, 0.590186f, 1.49634f, 
		-3.66354f, -0.332823f, 1.38202f, -3.66354f, -0.332823f, 1.38202f, 
		-3.66354f, -0.332823f, 1.38202f, -3.66354f, -0.332823f, 1.38202f, 
		-3.66350f, -0.242715f, 1.71223f, -3.66350f, -0.242715f, 1.71223f, 
		-3.66340f, 0.207162f, 1.63644f, -3.66340f, 0.207162f, 1.63644f, 
		-3.66340f, 0.207162f, 1.63644f, -3.66340f, 0.207162f, 1.63644f, 
		-3.66340f, 0.207162f, 1.63644f, -3.66340f, 0.207162f, 1.63644f, 
		-3.66340f, 0.207162f, 1.63644f, -3.66333f, -0.217584f, 1.72768f, 
		-3.66333f, -0.217584f, 1.72768f, -3.66333f, -0.217584f, 1.72768f, 
		-3.66319f, -0.332934f, 1.43126f, -3.66319f, -0.332934f, 1.43126f, 
		-3.66319f, -0.332934f, 1.43126f, -3.66313f, 0.139188f, 1.66716f, 
		-3.66313f, 0.139188f, 1.66716f, -3.66309f, 0.426431f, 1.83231f, 
		-3.66294f, 0.430467f, 1.77623f, -3.66291f, -0.221032f, 1.77313f, 
		-3.66291f, -0.221032f, 1.77313f, -3.66291f, -0.221032f, 1.77313f, 
		-3.66291f, -0.221032f, 1.77313f, -3.66291f, -0.221032f, 1.77313f, 
		-3.66284f, -0.322043f, 1.31254f, -3.66284f, -0.322043f, 1.31254f, 
		-3.66284f, -0.322043f, 1.31254f, -3.66284f, -0.322043f, 1.31254f, 
		-3.66284f, -0.322043f, 1.31254f, -3.66284f, -0.322043f, 1.31254f, 
		-3.66273f, -0.283597f, 1.42757f, -3.66273f, -0.283597f, 1.42757f, 
		-3.66273f, -0.283597f, 1.42757f, -3.66273f, -0.283597f, 1.42757f, 
		-3.66273f, -0.283597f, 1.42757f, -3.66269f, -0.277359f, 1.64701f, 
		-3.66269f, -0.311795f, 1.33571f, -3.66269f, -0.311795f, 1.33571f, 
		-3.66269f, -0.311795f, 1.33571f, -3.66269f, -0.311795f, 1.33571f, 
		-3.66259f, 0.197261f, 1.62846f, -3.66259f, 0.197261f, 1.62846f, 
		-3.66259f, 0.197261f, 1.62846f, -3.66254f, -0.313747f, 1.51609f, 
		-3.66254f, -0.313747f, 1.51609f, -3.66254f, -0.313747f, 1.51609f, 
		-3.66254f, -0.313747f, 1.51609f, -3.66243f, -0.257473f, 1.75057f, 
		-3.66232f, -0.309898f, 1.37672f, -3.66232f, -0.309898f, 1.37672f, 
		-3.66232f, -0.309898f, 1.37672f, -3.66223f, 0.216726f, 1.62378f, 
		-3.66223f, 0.216726f, 1.62378f, -3.66223f, 0.216726f, 1.62378f, 
		-3.66223f, 0.216726f, 1.62378f, -3.66212f, -0.275284f, 1.51596f, 
		-3.66212f, -0.275284f, 1.51596f, -3.66212f, -0.275284f, 1.51596f, 
		-3.66212f, -0.275284f, 1.51596f, -3.66200f, 0.285991f, 1.56497f, 
		-3.66200f, 0.285991f, 1.56497f, -3.66200f, 0.285991f, 1.56497f, 
		-3.66199f, 0.168310f, 1.64796f, -3.66199f, 0.168310f, 1.64796f, 
		-3.66198f, -0.283515f, 1.89852f, -3.66198f, 0.310901f, 1.57667f, 
		-3.66197f, -0.412561f, 1.69302f, -3.66189f, -0.269016f, 1.45941f, 
		-3.66189f, -0.269016f, 1.45941f, -3.66189f, -0.269016f, 1.45941f, 
		-3.66189f, -0.269016f, 1.45941f, -3.66185f, 0.334990f, 1.96317f, 
		-3.66161f, 0.294447f, 1.58422f, -3.66161f, 0.294447f, 1.58422f, 
		-3.66161f, 0.294447f, 1.58422f, -3.66148f, -0.256503f, 1.87914f, 
		-3.66145f, -0.310751f, 1.51980f, -3.66145f, -0.310751f, 1.51980f, 
		-3.66145f, -0.310751f, 1.51980f, -3.66145f, -0.310751f, 1.51980f, 
		-3.66145f, -0.310751f, 1.51980f, -3.66145f, -0.310751f, 1.51980f, 
		-3.66145f, -0.259603f, 1.81739f, -3.66145f, -0.259603f, 1.81739f, 
		-3.66145f, -0.259603f, 1.81739f, -3.66145f, -0.259603f, 1.81739f, 
		-3.66145f, -0.259603f, 1.81739f, -3.66136f, -0.271382f, 1.51649f, 
		-3.66136f, -0.271382f, 1.51649f, -3.66136f, -0.271382f, 1.51649f, 
		-3.66136f, -0.271382f, 1.51649f, -3.66136f, -0.271382f, 1.51649f, 
		-3.66108f, -0.238674f, 1.83841f, -3.66108f, -0.238674f, 1.83841f, 
		-3.66108f, -0.238674f, 1.83841f, -3.66108f, -0.238674f, 1.83841f, 
		-3.66108f, -0.238674f, 1.83841f, -3.66105f, 0.400942f, 1.60440f, 
		-3.66100f, -0.308607f, 1.51938f, -3.66100f, -0.308607f, 1.51938f, 
		-3.66100f, -0.308607f, 1.51938f, -3.66100f, -0.308607f, 1.51938f, 
		-3.66100f, 0.385687f, 1.56212f, -3.66100f, 0.385687f, 1.56212f, 
		-3.66100f, 0.385687f, 1.56212f, -3.66100f, 0.385687f, 1.56212f, 
		-3.66086f, 0.290559f, 1.61738f, -3.66081f, -0.265500f, 1.45837f, 
		-3.66081f, -0.265500f, 1.45837f, -3.66081f, -0.265500f, 1.45837f, 
		-3.66081f, -0.265500f, 1.45837f, -3.66081f, -0.265500f, 1.45837f, 
		-3.66079f, 0.381712f, 1.56860f, -3.66079f, 0.381712f, 1.56860f, 
		-3.66079f, 0.381712f, 1.56860f, -3.66079f, 0.381712f, 1.56860f, 
		-3.66076f, 0.0817860f, 1.66117f, -3.66074f, 0.177405f, 1.76414f, 
		-3.66074f, 0.177405f, 1.76414f, -3.66074f, 0.177405f, 1.76414f, 
		-3.66074f, 0.177405f, 1.76414f, -3.66071f, -0.244090f, 1.72988f, 
		-3.66071f, -0.244090f, 1.72988f, -3.66057f, 0.0746390f, 1.74977f, 
		-3.66027f, 0.289774f, 1.87430f, -3.66016f, -0.231601f, 1.68201f, 
		-3.66016f, -0.231601f, 1.68201f, -3.66013f, -0.288573f, 1.41554f, 
		-3.66013f, -0.288573f, 1.41554f, -3.66013f, -0.288573f, 1.41554f, 
		-3.66013f, -0.288573f, 1.41554f, -3.66006f, -0.312406f, 1.34809f, 
		-3.66006f, -0.312406f, 1.34809f, -3.66006f, -0.312406f, 1.34809f, 
		-3.66006f, -0.312406f, 1.34809f, -3.66006f, -0.312406f, 1.34809f, 
		-3.66005f, -0.216130f, 1.72904f, -3.66005f, -0.216130f, 1.72904f, 
		-3.66005f, -0.216130f, 1.72904f, -3.66005f, -0.216130f, 1.72904f, 
		-3.66004f, 0.246538f, 1.80198f, -3.66004f, 0.246538f, 1.80198f, 
		-3.66004f, 0.246538f, 1.80198f, -3.66002f, 0.129619f, 1.62751f, 
		-3.65998f, -0.333970f, 1.41950f, -3.65998f, -0.333970f, 1.41950f, 
		-3.65998f, -0.333970f, 1.41950f, -3.65998f, -0.333970f, 1.41950f, 
		-3.65998f, -0.333970f, 1.41950f, -3.65998f, -0.333970f, 1.41950f, 
		-3.65998f, -0.333970f, 1.41950f, -3.65996f, 0.289374f, 1.57967f, 
		-3.65996f, 0.289374f, 1.57967f, -3.65987f, -0.292090f, 1.34720f, 
		-3.65987f, -0.292090f, 1.34720f, -3.65987f, -0.292090f, 1.34720f, 
		-3.65987f, -0.292090f, 1.34720f, -3.65987f, -0.292090f, 1.34720f, 
		-3.65987f, -0.292090f, 1.34720f, -3.65974f, -0.264031f, 1.82806f, 
		-3.65974f, -0.264031f, 1.82806f, -3.65974f, -0.264031f, 1.82806f, 
		-3.65974f, -0.264031f, 1.82806f, -3.65974f, -0.264031f, 1.82806f, 
		-3.65974f, -0.264031f, 1.82806f, -3.65970f, -0.297389f, 1.63031f, 
		-3.65949f, -0.237487f, 1.72766f, -3.65949f, -0.237487f, 1.72766f, 
		-3.65949f, -0.237487f, 1.72766f, -3.65946f, -0.311034f, 1.36696f, 
		-3.65946f, -0.311034f, 1.36696f, -3.65946f, -0.311034f, 1.36696f, 
		-3.65946f, -0.311034f, 1.36696f, -3.65932f, -0.327221f, 1.35294f, 
		-3.65932f, -0.327221f, 1.35294f, -3.65932f, -0.327221f, 1.35294f, 
		-3.65932f, -0.327221f, 1.35294f, -3.65932f, -0.327221f, 1.35294f, 
		-3.65932f, -0.327221f, 1.35294f, -3.65931f, 0.397774f, 1.72552f, 
		-3.65928f, 0.270549f, 1.64034f, -3.65928f, 0.287741f, 1.57510f, 
		-3.65928f, 0.287741f, 1.57510f, -3.65927f, 0.256656f, 1.78469f, 
		-3.65927f, 0.256656f, 1.78469f, -3.65927f, 0.256656f, 1.78469f, 
		-3.65927f, 0.256656f, 1.78469f, -3.65927f, 0.256656f, 1.78469f, 
		-3.65926f, 0.329952f, 1.57295f, -3.65907f, 0.289762f, 1.61300f, 
		-3.65907f, 0.289762f, 1.61300f, -3.65900f, -0.254741f, 1.78787f, 
		-3.65893f, 0.224482f, 1.92331f, -3.65885f, 0.176212f, 1.62221f, 
		-3.65885f, 0.176212f, 1.62221f, -3.65885f, 0.176212f, 1.62221f, 
		-3.65885f, 0.176212f, 1.62221f, -3.65885f, 0.176212f, 1.62221f, 
		-3.65881f, 0.370052f, 1.58057f, -3.65881f, 0.370052f, 1.58057f, 
		-3.65869f, -0.259528f, 1.82063f, -3.65869f, -0.259528f, 1.82063f, 
		-3.65869f, -0.259528f, 1.82063f, -3.65858f, -0.329146f, 1.34926f, 
		-3.65858f, -0.329146f, 1.34926f, -3.65858f, -0.329146f, 1.34926f, 
		-3.65858f, 0.375344f, 1.57001f, -3.65858f, 0.375344f, 1.57001f, 
		-3.65858f, 0.375344f, 1.57001f, -3.65853f, 0.187885f, 1.76376f, 
		-3.65853f, 0.187885f, 1.76376f, -3.65853f, 0.187885f, 1.76376f, 
		-3.65844f, -0.294961f, 1.40559f, -3.65844f, -0.294961f, 1.40559f, 
		-3.65844f, -0.294961f, 1.40559f, -3.65797f, -0.218998f, 1.82099f, 
		-3.65797f, -0.218998f, 1.82099f, -3.65797f, -0.218998f, 1.82099f, 
		-3.65797f, -0.218998f, 1.82099f, -3.65758f, 0.406504f, 1.65837f, 
		-3.65741f, 0.184320f, 1.61955f, -3.65741f, 0.184320f, 1.61955f, 
		-3.65741f, 0.184320f, 1.61955f, -3.65741f, 0.184320f, 1.61955f, 
		-3.65741f, 0.184320f, 1.61955f, -3.65736f, 0.171438f, 1.77681f, 
		-3.65736f, 0.171438f, 1.77681f, -3.65731f, 0.234421f, 1.56087f, 
		-3.65728f, -0.271309f, 1.42378f, -3.65728f, -0.271309f, 1.42378f, 
		-3.65728f, -0.271309f, 1.42378f, -3.65728f, -0.271309f, 1.42378f, 
		-3.65722f, 0.634925f, 1.60099f, -3.65722f, 0.634925f, 1.60099f, 
		-3.65722f, 0.634925f, 1.60099f, -3.65722f, 0.634925f, 1.60099f, 
		-3.65722f, 0.634925f, 1.60099f, -3.65718f, -0.292896f, 1.51743f, 
		-3.65718f, -0.292896f, 1.51743f, -3.65715f, -0.273177f, 1.41141f, 
		-3.65715f, -0.273177f, 1.41141f, -3.65715f, -0.273177f, 1.41141f, 
		-3.65707f, -0.234713f, 1.82125f, -3.65707f, -0.234713f, 1.82125f, 
		-3.65671f, -0.260397f, 1.76353f, -3.65663f, -0.299025f, 1.34564f, 
		-3.65663f, -0.299025f, 1.34564f, -3.65663f, -0.299025f, 1.34564f, 
		-3.65663f, -0.299025f, 1.34564f, -3.65663f, -0.299025f, 1.34564f, 
		-3.65662f, 0.192983f, 1.59101f, -3.65657f, 0.253590f, 1.82610f, 
		-3.65657f, -0.335817f, 1.42489f, -3.65655f, 0.177536f, 1.77315f, 
		-3.65655f, 0.177536f, 1.77315f, -3.65655f, 0.177536f, 1.77315f, 
		-3.65655f, 0.177536f, 1.77315f, -3.65648f, -0.295929f, 1.33501f, 
		-3.65648f, -0.295929f, 1.33501f, -3.65648f, -0.295929f, 1.33501f, 
		-3.65648f, -0.295929f, 1.33501f, -3.65642f, -0.354078f, 1.60811f, 
		-3.65642f, -0.354078f, 1.60811f, -3.65642f, -0.354078f, 1.60811f, 
		-3.65625f, 0.336290f, 1.96543f, -3.65625f, 0.336290f, 1.96543f, 
		-3.65625f, 0.336290f, 1.96543f, -3.65625f, 0.336290f, 1.96543f, 
		-3.65625f, 0.336290f, 1.96543f, -3.65625f, 0.336290f, 1.96543f, 
		-3.65616f, 0.197102f, 1.63504f, -3.65616f, 0.197102f, 1.63504f, 
		-3.65616f, 0.197102f, 1.63504f, -3.65616f, 0.197102f, 1.63504f, 
		-3.65612f, 0.293349f, 1.68944f, -3.65596f, 0.370297f, 1.57704f, 
		-3.65596f, 0.370297f, 1.57704f, -3.65595f, -0.267922f, 1.41974f, 
		-3.65595f, -0.267922f, 1.41974f, -3.65595f, -0.267922f, 1.41974f, 
		-3.65595f, -0.267922f, 1.41974f, -3.65595f, -0.267922f, 1.41974f, 
		-3.65595f, -0.267922f, 1.41974f, -3.65591f, -0.334926f, 1.40258f, 
		-3.65591f, -0.334926f, 1.40258f, -3.65591f, -0.334926f, 1.40258f, 
		-3.65584f, 0.288362f, 1.72234f, -3.65581f, -0.299439f, 1.39315f, 
		-3.65581f, -0.299439f, 1.39315f, -3.65581f, -0.299439f, 1.39315f, 
		-3.65581f, -0.299439f, 1.39315f, -3.65581f, -0.299439f, 1.39315f, 
		-3.65565f, 0.292258f, 1.57658f, -3.65565f, 0.292258f, 1.57658f, 
		-3.65547f, -0.324832f, 1.41060f, -3.65547f, -0.324832f, 1.41060f, 
		-3.65547f, -0.324832f, 1.41060f, -3.65547f, -0.324832f, 1.41060f, 
		-3.65547f, -0.324832f, 1.41060f, -3.65547f, -0.324832f, 1.41060f, 
		-3.65533f, -0.217966f, 1.81878f, -3.65533f, -0.217966f, 1.81878f, 
		-3.65533f, -0.217966f, 1.81878f, -3.65533f, -0.217966f, 1.81878f, 
		-3.65531f, 0.550342f, 1.95972f, -3.65528f, -0.247922f, 1.87314f, 
		-3.65528f, -0.247922f, 1.87314f, -3.65528f, -0.247922f, 1.87314f, 
		-3.65528f, -0.247922f, 1.87314f, -3.65528f, -0.247922f, 1.87314f, 
		-3.65522f, 0.433776f, 1.80316f, -3.65520f, 0.612306f, 1.61882f, 
		-3.65495f, 0.313637f, 1.70983f, -3.65490f, 0.187774f, 1.77194f, 
		-3.65490f, 0.187774f, 1.77194f, -3.65490f, 0.187774f, 1.77194f, 
		-3.65473f, 0.281750f, 1.61217f, -3.65451f, -0.344492f, 1.26925f, 
		-3.65451f, -0.344492f, 1.26925f, -3.65451f, -0.344492f, 1.26925f, 
		-3.65451f, -0.344492f, 1.26925f, -3.65451f, -0.344492f, 1.26925f, 
		-3.65428f, 0.348447f, 1.57718f, -3.65413f, 0.226544f, 1.65882f, 
		-3.65408f, 0.267942f, 1.74173f, -3.65364f, 0.381660f, 1.59158f, 
		-3.65356f, 0.632303f, 1.53266f, -3.65356f, 0.632303f, 1.53266f, 
		-3.65356f, 0.632303f, 1.53266f, -3.65356f, 0.632303f, 1.53266f, 
		-3.65356f, 0.632303f, 1.53266f, -3.65356f, 0.632303f, 1.53266f, 
		-3.65299f, 0.0897670f, 1.77561f, -3.65296f, 0.314096f, 1.88659f, 
		-3.65287f, -0.334088f, 1.38780f, -3.65287f, -0.334088f, 1.38780f, 
		-3.65287f, -0.334088f, 1.38780f, -3.65254f, -0.256104f, 1.66277f, 
		-3.65254f, -0.256104f, 1.66277f, -3.65242f, -0.272931f, 1.40293f, 
		-3.65242f, -0.272931f, 1.40293f, -3.65238f, 0.177464f, 1.65794f, 
		-3.65238f, 0.177464f, 1.65794f, -3.65238f, 0.177464f, 1.65794f, 
		-3.65237f, 0.300416f, 1.59252f, -3.65234f, -0.335896f, 1.46454f, 
		-3.65234f, -0.335896f, 1.46454f, -3.65234f, -0.335896f, 1.46454f, 
		-3.65234f, -0.335896f, 1.46454f, -3.65234f, -0.335896f, 1.46454f, 
		-3.65229f, -0.301870f, 1.37807f, -3.65229f, -0.301870f, 1.37807f, 
		-3.65229f, -0.301870f, 1.37807f, -3.65229f, -0.301870f, 1.37807f, 
		-3.65229f, -0.301870f, 1.37807f, -3.65228f, -0.335011f, 1.40969f, 
		-3.65228f, -0.335011f, 1.40969f, -3.65228f, -0.335011f, 1.40969f, 
		-3.65216f, -0.411138f, 1.73994f, -3.65216f, -0.411138f, 1.73994f, 
		-3.65216f, -0.411138f, 1.73994f, -3.65216f, -0.411138f, 1.73994f, 
		-3.65216f, -0.411138f, 1.73994f, -3.65212f, -0.280090f, 1.46034f, 
		-3.65212f, -0.280090f, 1.46034f, -3.65212f, -0.280090f, 1.46034f, 
		-3.65212f, -0.280090f, 1.46034f, -3.65212f, -0.280090f, 1.46034f, 
		-3.65192f, 0.228520f, 1.64437f, -3.65186f, 0.367681f, 1.97098f, 
		-3.65179f, 0.165404f, 1.60760f, -3.65177f, -0.413765f, 1.83828f, 
		-3.65158f, -0.320973f, 1.35485f, -3.65158f, -0.320973f, 1.35485f, 
		-3.65158f, -0.320973f, 1.35485f, -3.65158f, -0.320973f, 1.35485f, 
		-3.65158f, -0.320973f, 1.35485f, -3.65152f, 0.341294f, 1.70544f, 
		-3.65149f, 0.192706f, 1.62253f, -3.65149f, 0.192706f, 1.62253f, 
		-3.65097f, -0.227854f, 1.74084f, -3.65097f, -0.227854f, 1.74084f, 
		-3.65097f, -0.227854f, 1.74084f, -3.65097f, -0.227854f, 1.74084f, 
		-3.65088f, -0.310949f, 1.29370f, -3.65088f, -0.310949f, 1.29370f, 
		-3.65088f, -0.310949f, 1.29370f, -3.65088f, -0.310949f, 1.29370f, 
		-3.65085f, 0.417189f, 1.74521f, -3.65079f, -0.329860f, 1.37572f, 
		-3.65079f, -0.329860f, 1.37572f, -3.65079f, 0.399381f, 1.62314f, 
		-3.65051f, 0.166723f, 1.66009f, -3.65051f, 0.166723f, 1.66009f, 
		-3.65051f, 0.166723f, 1.66009f, -3.65051f, 0.166723f, 1.66009f, 
		-3.65049f, -0.303860f, 1.36883f, -3.65049f, -0.303860f, 1.36883f, 
		-3.65049f, -0.303860f, 1.36883f, -3.65049f, -0.303860f, 1.36883f, 
		-3.65049f, -0.303860f, 1.36883f, -3.65043f, 0.197643f, 1.62897f, 
		-3.65043f, 0.197643f, 1.62897f, -3.65043f, 0.197643f, 1.62897f, 
		-3.65043f, 0.197643f, 1.62897f, -3.65043f, 0.197643f, 1.62897f, 
		-3.65025f, -0.385553f, 1.90615f, -3.65019f, -0.408202f, 1.75339f, 
		-3.65019f, -0.408202f, 1.75339f, -3.65018f, 0.205980f, 1.63729f, 
		-3.65018f, 0.205980f, 1.63729f, -3.65018f, 0.205980f, 1.63729f, 
		-3.65018f, 0.205980f, 1.63729f, -3.65018f, 0.205980f, 1.63729f, 
		-3.65018f, 0.205980f, 1.63729f, -3.65017f, 0.211922f, 1.62974f, 
		-3.65017f, 0.211922f, 1.62974f, -3.65017f, 0.211922f, 1.62974f, 
		-3.65017f, 0.211922f, 1.62974f, -3.65017f, 0.211922f, 1.62974f, 
		-3.65017f, 0.211922f, 1.62974f, -3.65014f, 0.205877f, 1.62724f, 
		-3.65014f, 0.205877f, 1.62724f, -3.65014f, 0.205877f, 1.62724f, 
		-3.65014f, 0.205877f, 1.62724f, -3.65011f, -0.279468f, 1.38904f, 
		-3.65011f, -0.279468f, 1.38904f, -3.65011f, -0.279468f, 1.38904f, 
		-3.65011f, -0.279468f, 1.38904f, -3.65011f, -0.279468f, 1.38904f, 
		-3.65006f, 0.192022f, 1.59894f, -3.65005f, 0.185794f, 1.65589f, 
		-3.65005f, 0.185794f, 1.65589f, -3.65005f, 0.185794f, 1.65589f, 
		-3.65000f, -0.247060f, 1.81578f, -3.65000f, -0.247060f, 1.81578f, 
		-3.65000f, -0.247060f, 1.81578f, -3.65000f, -0.247060f, 1.81578f, 
		-3.64986f, 0.254378f, 1.76610f, -3.64970f, 0.389843f, 1.67665f, 
		-3.64955f, -0.329237f, 1.61523f, -3.64945f, -0.361607f, 1.28436f, 
		-3.64945f, -0.361607f, 1.28436f, -3.64945f, -0.361607f, 1.28436f, 
		-3.64945f, -0.361607f, 1.28436f, -3.64919f, 0.281755f, 1.65556f, 
		-3.64911f, -0.285593f, 1.38059f, -3.64911f, -0.285593f, 1.38059f, 
		-3.64911f, -0.285593f, 1.38059f, -3.64908f, 0.175373f, 1.64866f, 
		-3.64896f, -0.405250f, 1.65697f, -3.64876f, 0.317194f, 1.69660f, 
		-3.64874f, 0.196627f, 1.63343f, -3.64874f, 0.196627f, 1.63343f, 
		-3.64874f, 0.196627f, 1.63343f, -3.64874f, 0.196627f, 1.63343f, 
		-3.64840f, -0.253681f, 1.73603f, -3.64840f, -0.253681f, 1.73603f, 
		-3.64840f, -0.253681f, 1.73603f, -3.64807f, 0.113939f, 1.64055f, 
		-3.64797f, 0.265585f, 1.85097f, -3.64790f, 0.168598f, 1.64654f, 
		-3.64777f, 0.288231f, 1.93246f, -3.64759f, 0.223749f, 1.62354f, 
		-3.64759f, 0.223749f, 1.62354f, -3.64745f, 0.193441f, 1.62860f, 
		-3.64745f, 0.193441f, 1.62860f, -3.64745f, 0.193441f, 1.62860f, 
		-3.64745f, 0.193441f, 1.62860f, -3.64745f, 0.193441f, 1.62860f, 
		-3.64731f, 0.341424f, 1.89074f, -3.64728f, -0.250233f, 1.68336f, 
		-3.64728f, -0.250233f, 1.68336f, -3.64703f, 0.678587f, 1.62944f, 
		-3.64695f, -0.327473f, 1.42021f, -3.64695f, -0.327473f, 1.42021f, 
		-3.64695f, -0.327473f, 1.42021f, -3.64695f, -0.327473f, 1.42021f, 
		-3.64695f, -0.327473f, 1.42021f, -3.64662f, -0.334151f, 1.38533f, 
		-3.64662f, -0.334151f, 1.38533f, -3.64662f, -0.334151f, 1.38533f, 
		-3.64662f, -0.334151f, 1.38533f, -3.64654f, -0.283806f, 1.37167f, 
		-3.64617f, 0.185034f, 1.75793f, -3.64617f, 0.185034f, 1.75793f, 
		-3.64617f, 0.185034f, 1.75793f, -3.64617f, 0.185034f, 1.75793f, 
		-3.64617f, 0.217586f, 1.58020f, -3.64613f, 0.213920f, 1.59048f, 
		-3.64587f, 0.368626f, 1.70957f, -3.64573f, -0.230125f, 1.73676f, 
		-3.64573f, -0.230125f, 1.73676f, -3.64573f, -0.230125f, 1.73676f, 
		-3.64573f, -0.230125f, 1.73676f, -3.64568f, -0.300618f, 1.41724f, 
		-3.64568f, -0.300618f, 1.41724f, -3.64568f, -0.300618f, 1.41724f, 
		-3.64568f, -0.300618f, 1.41724f, -3.64558f, -0.244464f, 1.84226f, 
		-3.64558f, -0.244464f, 1.84226f, -3.64548f, -0.253843f, 1.74442f, 
		-3.64548f, -0.253843f, 1.74442f, -3.64548f, 0.160699f, 1.66379f, 
		-3.64548f, 0.160699f, 1.66379f, -3.64538f, 0.367923f, 1.68988f, 
		-3.64534f, 0.359920f, 1.59030f, -3.64528f, -0.676308f, 1.68190f, 
		-3.64528f, -0.676308f, 1.68190f, -3.64528f, -0.676308f, 1.68190f, 
		-3.64516f, 0.217622f, 1.62694f, -3.64516f, 0.217622f, 1.62694f, 
		-3.64513f, -0.335040f, 1.46976f, -3.64513f, -0.335040f, 1.46976f, 
		-3.64513f, -0.335040f, 1.46976f, -3.64506f, 0.342890f, 1.69676f, 
		-3.64506f, 0.488094f, 1.60945f, -3.64491f, 0.180755f, 1.65807f, 
		-3.64491f, 0.180755f, 1.65807f, -3.64491f, 0.180755f, 1.65807f, 
		-3.64491f, 0.180755f, 1.65807f, -3.64491f, 0.180755f, 1.65807f, 
		-3.64491f, 0.180755f, 1.65807f, -3.64491f, 0.180755f, 1.65807f, 
		-3.64474f, -0.329327f, 1.40436f, -3.64474f, -0.329327f, 1.40436f, 
		-3.64474f, -0.329327f, 1.40436f, -3.64474f, -0.329327f, 1.40436f, 
		-3.64474f, -0.329327f, 1.40436f, -3.64473f, 0.414797f, 1.85450f, 
		-3.64451f, 0.582106f, 1.51112f, -3.64451f, 0.582106f, 1.51112f, 
		-3.64451f, 0.582106f, 1.51112f, -3.64440f, 0.366566f, 2.00064f, 
		-3.64440f, 0.366566f, 2.00064f, -3.64440f, 0.366566f, 2.00064f, 
		-3.64421f, -0.301876f, 1.40075f, -3.64421f, -0.301876f, 1.40075f, 
		-3.64421f, -0.301876f, 1.40075f, -3.64421f, -0.301876f, 1.40075f, 
		-3.64415f, 0.196732f, 1.62839f, -3.64415f, 0.196732f, 1.62839f, 
		-3.64415f, 0.196732f, 1.62839f, -3.64409f, 0.461017f, 1.54888f, 
		-3.64406f, -0.407237f, 1.78016f, -3.64401f, 0.167488f, 1.75248f, 
		-3.64397f, 0.284190f, 1.61085f, -3.64397f, 0.284190f, 1.61085f, 
		-3.64397f, -0.299992f, 1.42374f, -3.64397f, -0.299992f, 1.42374f, 
		-3.64397f, -0.299992f, 1.42374f, -3.64397f, -0.299992f, 1.42374f, 
		-3.64388f, 0.116193f, 1.80708f, -3.64387f, 0.369083f, 1.88636f, 
		-3.64380f, 0.208206f, 1.63502f, -3.64380f, 0.208206f, 1.63502f, 
		-3.64380f, 0.208206f, 1.63502f, -3.64380f, 0.208206f, 1.63502f, 
		-3.64380f, 0.208206f, 1.63502f, -3.64377f, 0.157830f, 1.64792f, 
		-3.64374f, -0.339223f, 1.47152f, -3.64374f, -0.339223f, 1.47152f, 
		-3.64374f, -0.339223f, 1.47152f, -3.64374f, -0.339223f, 1.47152f, 
		-3.64374f, -0.339223f, 1.47152f, -3.64374f, -0.339223f, 1.47152f, 
		-3.64374f, -0.339223f, 1.47152f, -3.64372f, 0.140165f, 1.67413f, 
		-3.64372f, 0.140165f, 1.67413f, -3.64372f, 0.140165f, 1.67413f, 
		-3.64367f, 0.294026f, 1.60649f, -3.64367f, 0.294026f, 1.60649f, 
		-3.64365f, 0.190652f, 1.75818f, -3.64365f, 0.190652f, 1.75818f, 
		-3.64365f, 0.190652f, 1.75818f, -3.64365f, 0.190652f, 1.75818f, 
		-3.64365f, 0.190652f, 1.75818f, -3.64365f, 0.190652f, 1.75818f, 
		-3.64365f, 0.190652f, 1.75818f, -3.64359f, -0.403464f, 1.76660f, 
		-3.64359f, -0.403464f, 1.76660f, -3.64357f, 0.248997f, 1.79307f, 
		-3.64342f, 0.287645f, 1.63348f, -3.64338f, 0.326593f, 1.59055f, 
		-3.64338f, 0.385528f, 1.60654f, -3.64337f, -0.409301f, 1.79325f, 
		-3.64337f, -0.409301f, 1.79325f, -3.64337f, -0.409301f, 1.79325f, 
		-3.64337f, -0.409301f, 1.79325f, -3.64328f, -0.314701f, 1.41763f, 
		-3.64328f, -0.314701f, 1.41763f, -3.64328f, -0.314701f, 1.41763f, 
		-3.64327f, -0.326323f, 1.43594f, -3.64327f, -0.326323f, 1.43594f, 
		-3.64327f, -0.326323f, 1.43594f, -3.64327f, -0.326323f, 1.43594f, 
		-3.64327f, -0.326323f, 1.43594f, -3.64327f, -0.326323f, 1.43594f, 
		-3.64323f, -0.254590f, 1.72750f, -3.64317f, -0.693027f, 1.68299f, 
		-3.64317f, -0.693027f, 1.68299f, -3.64317f, -0.693027f, 1.68299f, 
		-3.64304f, -0.268317f, 1.46324f, -3.64298f, 0.394365f, 1.87387f, 
		-3.64286f, 0.244730f, 1.67449f, -3.64285f, 0.179852f, 1.65093f, 
		-3.64285f, 0.179852f, 1.65093f, -3.64285f, 0.179852f, 1.65093f, 
		-3.64285f, 0.179852f, 1.65093f, -3.64263f, -0.332195f, 1.36112f, 
		-3.64249f, 0.183426f, 1.65019f, -3.64249f, 0.183426f, 1.65019f, 
		-3.64249f, 0.183426f, 1.65019f, -3.64249f, 0.183426f, 1.65019f, 
		-3.64237f, 0.389919f, 1.59499f, -3.64237f, 0.389919f, 1.59499f, 
		-3.64237f, 0.389919f, 1.59499f, -3.64237f, 0.389919f, 1.59499f, 
		-3.64232f, -0.321095f, 1.35774f, -3.64232f, -0.321095f, 1.35774f, 
		-3.64232f, -0.321095f, 1.35774f, -3.64232f, -0.321095f, 1.35774f, 
		-3.64225f, 0.327637f, 1.94554f, -3.64224f, 0.185112f, 1.76631f, 
		-3.64224f, 0.185112f, 1.76631f, -3.64224f, 0.185112f, 1.76631f, 
		-3.64224f, 0.185112f, 1.76631f, -3.64224f, 0.429185f, 1.77008f, 
		-3.64222f, 0.341888f, 1.59113f, -3.64204f, -0.302638f, 1.62249f, 
		-3.64202f, -0.298287f, 1.43321f, -3.64202f, -0.298287f, 1.43321f, 
		-3.64202f, -0.298287f, 1.43321f, -3.64202f, -0.298287f, 1.43321f, 
		-3.64202f, -0.298287f, 1.43321f, -3.64202f, -0.298287f, 1.43321f, 
		-3.64202f, 0.163318f, 1.65002f, -3.64202f, 0.163318f, 1.65002f, 
		-3.64202f, 0.163318f, 1.65002f, -3.64197f, 0.391343f, 1.64093f, 
		-3.64190f, -0.355850f, 1.25350f, -3.64190f, -0.355850f, 1.25350f, 
		-3.64190f, -0.355850f, 1.25350f, -3.64190f, -0.355850f, 1.25350f, 
		-3.64190f, -0.355850f, 1.25350f, -3.64184f, 0.411546f, 1.97910f, 
		-3.64176f, -0.293679f, 1.34838f, -3.64176f, -0.293679f, 1.34838f, 
		-3.64176f, -0.293679f, 1.34838f, -3.64176f, -0.293679f, 1.34838f, 
		-3.64173f, -0.676268f, 1.83195f, -3.64173f, -0.676268f, 1.83195f, 
		-3.64173f, -0.676268f, 1.83195f, -3.64171f, 0.382259f, 1.61400f, 
		-3.64161f, -0.255837f, 1.78583f, -3.64145f, -0.264468f, 1.46551f, 
		-3.64141f, 0.216464f, 1.64204f, -3.64130f, -0.344066f, 1.36096f, 
		-3.64130f, -0.344066f, 1.36096f, -3.64130f, -0.344066f, 1.36096f, 
		-3.64130f, -0.344066f, 1.36096f, -3.64130f, -0.344066f, 1.36096f, 
		-3.64124f, 0.314667f, 1.59973f, -3.64119f, -0.246156f, 1.70217f, 
		-3.64119f, -0.246156f, 1.70217f, -3.64097f, -0.365227f, 1.93513f, 
		-3.64097f, -0.365227f, 1.93513f, -3.64096f, -0.315392f, 1.40296f, 
		-3.64096f, -0.315392f, 1.40296f, -3.64096f, -0.315392f, 1.40296f, 
		-3.64090f, -0.327867f, 1.38834f, -3.64090f, -0.327867f, 1.38834f, 
		-3.64090f, -0.327867f, 1.38834f, -3.64090f, -0.327867f, 1.38834f, 
		-3.64090f, -0.327867f, 1.38834f, -3.64090f, -0.327867f, 1.38834f, 
		-3.64077f, -0.336648f, 1.34697f, -3.64077f, -0.336648f, 1.34697f, 
		-3.64077f, -0.336648f, 1.34697f, -3.64077f, -0.336648f, 1.34697f, 
		-3.64077f, -0.336648f, 1.34697f, -3.64076f, -0.313764f, 1.42753f, 
		-3.64076f, -0.313764f, 1.42753f, -3.64076f, -0.313764f, 1.42753f, 
		-3.64076f, -0.313764f, 1.42753f, -3.64076f, -0.313764f, 1.42753f, 
		-3.64076f, -0.313764f, 1.42753f, -3.64076f, -0.313764f, 1.42753f, 
		-3.64076f, -0.313764f, 1.42753f, -3.64071f, 0.377440f, 1.60616f, 
		-3.64071f, 0.377440f, 1.60616f, -3.64071f, 0.377440f, 1.60616f, 
		-3.64070f, 0.297993f, 1.66667f, -3.64063f, -0.325750f, 1.37704f, 
		-3.64063f, -0.325750f, 1.37704f, -3.64063f, -0.325750f, 1.37704f, 
		-3.64063f, -0.325750f, 1.37704f, -3.64063f, -0.325750f, 1.37704f, 
		-3.64050f, 0.394565f, 1.58749f, -3.64050f, 0.394565f, 1.58749f, 
		-3.64049f, 0.190539f, 1.76515f, -3.64049f, 0.190539f, 1.76515f, 
		-3.64049f, 0.190539f, 1.76515f, -3.64049f, 0.190539f, 1.76515f, 
		-3.64049f, 0.190539f, 1.76515f, -3.64049f, 0.190539f, 1.76515f, 
		-3.64023f, 0.213374f, 1.77687f, -3.64023f, 0.213374f, 1.77687f, 
		-3.64002f, 0.185846f, 1.65558f, -3.64002f, 0.185846f, 1.65558f, 
		-3.64002f, 0.185846f, 1.65558f, -3.64002f, 0.185846f, 1.65558f, 
		-3.63986f, -0.250068f, 1.80106f, -3.63986f, -0.250068f, 1.80106f, 
		-3.63974f, 0.302202f, 1.61482f, -3.63969f, -0.693009f, 1.83074f, 
		-3.63969f, -0.693009f, 1.83074f, -3.63969f, -0.693009f, 1.83074f, 
		-3.63960f, -0.302473f, 1.38179f, -3.63960f, -0.302473f, 1.38179f, 
		-3.63960f, -0.302473f, 1.38179f, -3.63960f, -0.302473f, 1.38179f, 
		-3.63950f, 0.285001f, 1.87065f, -3.63945f, -0.342782f, 1.92907f, 
		-3.63934f, 0.192758f, 1.75899f, -3.63934f, 0.192758f, 1.75899f, 
		-3.63934f, 0.192758f, 1.75899f, -3.63900f, -0.290803f, 1.33812f, 
		-3.63900f, -0.290803f, 1.33812f, -3.63900f, -0.290803f, 1.33812f, 
		-3.63895f, -0.319756f, 1.92295f, -3.63860f, 0.357552f, 1.97042f, 
		-3.63860f, 0.357552f, 1.97042f, -3.63859f, 0.290179f, 1.60719f, 
		-3.63859f, 0.290179f, 1.60719f, -3.63856f, -0.304164f, 1.37239f, 
		-3.63856f, -0.304164f, 1.37239f, -3.63856f, -0.304164f, 1.37239f, 
		-3.63856f, -0.304164f, 1.37239f, -3.63855f, 0.392954f, 1.72184f, 
		-3.63854f, 0.384393f, 1.59836f, -3.63844f, 0.278272f, 1.60772f, 
		-3.63836f, 0.249089f, 1.57582f, -3.63823f, 0.300398f, 1.63480f, 
		-3.63823f, 0.300398f, 1.63480f, -3.63823f, 0.300398f, 1.63480f, 
		-3.63819f, 0.378893f, 1.60301f, -3.63819f, 0.378893f, 1.60301f, 
		-3.63819f, 0.378893f, 1.60301f, -3.63819f, 0.378893f, 1.60301f, 
		-3.63813f, 0.0737770f, 1.69953f, -3.63805f, -0.255996f, 1.81481f, 
		-3.63785f, 0.201007f, 1.77663f, -3.63785f, 0.201007f, 1.77663f, 
		-3.63785f, 0.201007f, 1.77663f, -3.63785f, 0.201007f, 1.77663f, 
		-3.63759f, -0.259658f, 1.75700f, -3.63759f, -0.259658f, 1.75700f, 
		-3.63748f, 0.190079f, 1.63331f, -3.63748f, 0.190079f, 1.63331f, 
		-3.63748f, 0.190079f, 1.63331f, -3.63748f, 0.190079f, 1.63331f, 
		-3.63732f, 0.203780f, 1.64052f, -3.63732f, 0.203780f, 1.64052f, 
		-3.63732f, 0.203780f, 1.64052f, -3.63732f, 0.203780f, 1.64052f, 
		-3.63732f, 0.203780f, 1.64052f, -3.63704f, 0.195259f, 1.63678f, 
		-3.63704f, 0.195259f, 1.63678f, -3.63704f, 0.195259f, 1.63678f, 
		-3.63704f, 0.195259f, 1.63678f, -3.63689f, -0.299384f, 1.78332f, 
		-3.63689f, -0.299384f, 1.78332f, -3.63683f, 0.252254f, 1.68570f, 
		-3.63679f, 0.172987f, 1.76364f, -3.63679f, 0.172987f, 1.76364f, 
		-3.63674f, -0.706231f, 1.68193f, -3.63674f, -0.706231f, 1.68193f, 
		-3.63674f, -0.706231f, 1.68193f, -3.63660f, 0.171630f, 1.75065f, 
		-3.63660f, 0.171630f, 1.75065f, -3.63659f, 0.164041f, 1.65265f, 
		-3.63659f, 0.164041f, 1.65265f, -3.63658f, -0.632891f, 1.68004f, 
		-3.63658f, -0.632891f, 1.68004f, -3.63656f, 0.381125f, 1.57317f, 
		-3.63656f, 0.381125f, 1.57317f, -3.63656f, 0.381125f, 1.57317f, 
		-3.63656f, 0.381125f, 1.57317f, -3.63623f, -0.316616f, 1.40116f, 
		-3.63623f, -0.316616f, 1.40116f, -3.63623f, -0.316616f, 1.40116f, 
		-3.63623f, -0.316616f, 1.40116f, -3.63586f, -0.338489f, 1.24865f, 
		-3.63586f, -0.338489f, 1.24865f, -3.63586f, -0.338489f, 1.24865f, 
		-3.63586f, -0.338489f, 1.24865f, -3.63586f, 0.252323f, 1.82000f, 
		-3.63578f, -0.288095f, 1.39770f, -3.63578f, -0.288095f, 1.39770f, 
		-3.63578f, -0.288095f, 1.39770f, -3.63578f, -0.288095f, 1.39770f, 
		-3.63578f, -0.288095f, 1.39770f, -3.63578f, -0.288095f, 1.39770f, 
		-3.63577f, 0.360097f, 1.60744f, -3.63577f, -0.287348f, 1.46371f, 
		-3.63577f, -0.287348f, 1.46371f, -3.63577f, -0.287348f, 1.46371f, 
		-3.63575f, 0.161694f, 1.76138f, -3.63575f, 0.161694f, 1.76138f, 
		-3.63575f, 0.161694f, 1.76138f, -3.63565f, -0.332333f, 1.45717f, 
		-3.63565f, -0.332333f, 1.45717f, -3.63565f, -0.332333f, 1.45717f, 
		-3.63565f, -0.332333f, 1.45717f, -3.63565f, -0.332333f, 1.45717f, 
		-3.63565f, 0.334727f, 1.95449f, -3.63565f, 0.334727f, 1.95449f, 
		-3.63565f, 0.334727f, 1.95449f, -3.63563f, -0.409128f, 1.87346f, 
		-3.63562f, 0.206010f, 1.63098f, -3.63562f, 0.206010f, 1.63098f, 
		-3.63562f, 0.206010f, 1.63098f, -3.63560f, 0.134309f, 1.63486f, 
		-3.63551f, -0.314520f, 1.38576f, -3.63551f, -0.314520f, 1.38576f, 
		-3.63551f, -0.314520f, 1.38576f, -3.63551f, -0.314520f, 1.38576f, 
		-3.63546f, -0.296570f, 1.44138f, -3.63546f, -0.296570f, 1.44138f, 
		-3.63546f, -0.296570f, 1.44138f, -3.63546f, -0.296570f, 1.44138f, 
		-3.63546f, -0.296570f, 1.44138f, -3.63546f, -0.296570f, 1.44138f, 
		-3.63545f, 0.377614f, 1.65603f, -3.63545f, -0.312938f, 1.43549f, 
		-3.63545f, -0.312938f, 1.43549f, -3.63545f, -0.312938f, 1.43549f, 
		-3.63545f, -0.312938f, 1.43549f, -3.63542f, 0.206705f, 1.61272f, 
		-3.63542f, 0.206705f, 1.61272f, -3.63542f, 0.206705f, 1.61272f, 
		-3.63542f, 0.206705f, 1.61272f, -3.63535f, 0.358758f, 1.95522f, 
		-3.63524f, -0.314881f, 1.37566f, -3.63524f, -0.314881f, 1.37566f, 
		-3.63524f, -0.314881f, 1.37566f, -3.63524f, -0.314881f, 1.37566f, 
		-3.63512f, 0.612039f, 1.98328f, -3.63512f, 0.612039f, 1.98328f, 
		-3.63512f, 0.612039f, 1.98328f, -3.63502f, 0.145155f, 1.75344f, 
		-3.63502f, 0.145155f, 1.75344f, -3.63500f, -0.593608f, 1.66276f, 
		-3.63500f, -0.593608f, 1.66276f, -3.63481f, 0.181773f, 1.75027f, 
		-3.63481f, 0.181773f, 1.75027f, -3.63481f, 0.181773f, 1.75027f, 
		-3.63481f, 0.181773f, 1.75027f, -3.63479f, 0.428202f, 1.82716f, 
		-3.63476f, -0.410092f, 1.69744f, -3.63469f, -0.677979f, 1.68034f, 
		-3.63469f, -0.677979f, 1.68034f, -3.63469f, -0.677979f, 1.68034f, 
		-3.63467f, 0.193269f, 1.77805f, -3.63467f, 0.193269f, 1.77805f, 
		-3.63467f, 0.193269f, 1.77805f, -3.63464f, 0.317677f, 1.67256f, 
		-3.63457f, -0.325419f, 1.44272f, -3.63457f, -0.325419f, 1.44272f, 
		-3.63457f, -0.325419f, 1.44272f, -3.63457f, -0.325419f, 1.44272f, 
		-3.63457f, -0.325419f, 1.44272f, -3.63457f, -0.325419f, 1.44272f, 
		-3.63457f, -0.325419f, 1.44272f, -3.63446f, -0.258454f, 1.78571f, 
		-3.63446f, -0.258454f, 1.78571f, -3.63433f, 0.432585f, 1.79769f, 
		-3.63433f, 0.174539f, 1.66492f, -3.63433f, 0.174539f, 1.66492f, 
		-3.63433f, 0.174539f, 1.66492f, -3.63432f, 0.181323f, 1.63534f, 
		-3.63432f, 0.181323f, 1.63534f, -3.63432f, 0.181323f, 1.63534f, 
		-3.63432f, 0.181323f, 1.63534f, -3.63432f, 0.181323f, 1.63534f, 
		-3.63421f, 0.215710f, 1.79092f, -3.63421f, 0.215710f, 1.79092f, 
		-3.63421f, 0.215710f, 1.79092f, -3.63421f, 0.215710f, 1.79092f, 
		-3.63418f, 0.164629f, 1.66742f, -3.63418f, 0.164629f, 1.66742f, 
		-3.63388f, 0.193307f, 1.64117f, -3.63388f, 0.193307f, 1.64117f, 
		-3.63388f, 0.193307f, 1.64117f, -3.63380f, -0.265664f, 1.79360f, 
		-3.63380f, -0.265664f, 1.79360f, -3.63380f, -0.265664f, 1.79360f, 
		-3.63380f, -0.265664f, 1.79360f, -3.63377f, 0.377180f, 1.62070f, 
		-3.63373f, 0.194397f, 1.63311f, -3.63373f, 0.194397f, 1.63311f, 
		-3.63373f, 0.194397f, 1.63311f, -3.63373f, 0.194397f, 1.63311f, 
		-3.63367f, 0.341377f, 1.60659f, -3.63350f, -0.599406f, 1.66232f, 
		-3.63350f, -0.599406f, 1.66232f, -3.63350f, -0.599406f, 1.66232f, 
		-3.63350f, -0.599406f, 1.66232f, -3.63348f, 0.662981f, 1.94774f, 
		-3.63348f, 0.662981f, 1.94774f, -3.63339f, -0.324112f, 1.40702f, 
		-3.63339f, -0.324112f, 1.40702f, -3.63339f, -0.324112f, 1.40702f, 
		-3.63339f, -0.324112f, 1.40702f, -3.63339f, -0.324112f, 1.40702f, 
		-3.63337f, -0.293501f, 1.48363f, -3.63337f, -0.293501f, 1.48363f, 
		-3.63337f, -0.293501f, 1.48363f, -3.63337f, -0.293501f, 1.48363f, 
		-3.63337f, -0.293501f, 1.48363f, -3.63334f, -0.259863f, 1.65270f, 
		-3.63334f, -0.259863f, 1.65270f, -3.63334f, -0.259863f, 1.65270f, 
		-3.63334f, -0.259863f, 1.65270f, -3.63334f, -0.259863f, 1.65270f, 
		-3.63324f, -0.706245f, 1.83150f, -3.63324f, -0.706245f, 1.83150f, 
		-3.63324f, -0.706245f, 1.83150f, -3.63314f, -0.271622f, 1.77289f, 
		-3.63314f, -0.271622f, 1.77289f, -3.63314f, -0.271622f, 1.77289f, 
		-3.63314f, -0.271622f, 1.77289f, -3.63314f, -0.271622f, 1.77289f, 
		-3.63314f, -0.271622f, 1.77289f, -3.63306f, -0.564783f, 1.66124f, 
		-3.63306f, -0.564783f, 1.66124f, -3.63306f, -0.564783f, 1.66124f, 
		-3.63306f, -0.564783f, 1.66124f, -3.63306f, -0.564783f, 1.66124f, 
		-3.63306f, 0.324526f, 1.61192f, -3.63301f, 0.311407f, 1.62457f, 
		-3.63288f, -0.632772f, 1.83339f, -3.63288f, -0.632772f, 1.83339f, 
		-3.63287f, 0.198088f, 1.62936f, -3.63287f, 0.198088f, 1.62936f, 
		-3.63287f, 0.198088f, 1.62936f, -3.63287f, 0.198088f, 1.62936f, 
		-3.63287f, 0.198088f, 1.62936f, -3.63287f, 0.198088f, 1.62936f, 
		-3.63287f, 0.198088f, 1.62936f, -3.63278f, -0.584669f, 1.66386f, 
		-3.63278f, -0.584669f, 1.66386f, -3.63268f, -0.304816f, 1.29271f, 
		-3.63268f, -0.304816f, 1.29271f, -3.63268f, -0.304816f, 1.29271f, 
		-3.63264f, -0.260539f, 1.77008f, -3.63264f, -0.260539f, 1.77008f, 
		-3.63263f, -0.286809f, 1.40530f, -3.63263f, -0.286809f, 1.40530f, 
		-3.63263f, -0.286809f, 1.40530f, -3.63263f, -0.286809f, 1.40530f, 
		-3.63263f, -0.286809f, 1.40530f, -3.63263f, -0.286809f, 1.40530f, 
		-3.63263f, -0.286809f, 1.40530f, -3.63262f, -0.385463f, 1.62803f, 
		-3.63218f, -0.329247f, 1.47669f, -3.63218f, -0.329247f, 1.47669f, 
		-3.63218f, -0.329247f, 1.47669f, -3.63218f, -0.329247f, 1.47669f, 
		-3.63218f, -0.329247f, 1.47669f, -3.63218f, -0.329247f, 1.47669f, 
		-3.63218f, -0.329247f, 1.47669f, -3.63211f, 0.274176f, 1.60689f, 
		-3.63211f, 0.274176f, 1.60689f, -3.63211f, 0.274176f, 1.60689f, 
		-3.63208f, 0.200096f, 1.78736f, -3.63208f, 0.200096f, 1.78736f, 
		-3.63208f, 0.200096f, 1.78736f, -3.63208f, 0.200096f, 1.78736f, 
		-3.63208f, 0.200096f, 1.78736f, -3.63206f, -0.301011f, 1.40476f, 
		-3.63206f, -0.301011f, 1.40476f, -3.63206f, -0.301011f, 1.40476f, 
		-3.63206f, -0.301011f, 1.40476f, -3.63206f, -0.301011f, 1.40476f, 
		-3.63206f, -0.301011f, 1.40476f, -3.63205f, 0.371623f, 1.63275f, 
		-3.63200f, 0.309935f, 1.88324f, -3.63188f, 0.359539f, 1.66696f, 
		-3.63179f, 0.320086f, 1.64039f, -3.63169f, 0.173062f, 1.65463f, 
		-3.63169f, 0.253481f, 1.69632f, -3.63160f, 0.338887f, 1.67266f, 
		-3.63146f, -0.273586f, 1.74841f, -3.63137f, 0.302462f, 1.63059f, 
		-3.63137f, 0.302462f, 1.63059f, -3.63137f, 0.302462f, 1.63059f, 
		-3.63119f, -0.313634f, 1.48395f, -3.63119f, -0.313634f, 1.48395f, 
		-3.63119f, -0.313634f, 1.48395f, -3.63110f, -0.677966f, 1.83302f, 
		-3.63110f, -0.677966f, 1.83302f, -3.63110f, -0.677966f, 1.83302f, 
		-3.63107f, -0.588710f, 1.82979f, -3.63107f, -0.588710f, 1.82979f, 
		-3.63107f, -0.588710f, 1.82979f, -3.63107f, -0.588710f, 1.82979f, 
		-3.63078f, 0.201314f, 1.62264f, -3.63078f, 0.201314f, 1.62264f, 
		-3.63078f, 0.201314f, 1.62264f, -3.63078f, 0.201314f, 1.62264f, 
		-3.63078f, 0.201314f, 1.62264f, -3.63078f, 0.201314f, 1.62264f, 
		-3.63078f, 0.201314f, 1.62264f, -3.63077f, -0.322388f, 1.38759f, 
		-3.63077f, -0.322388f, 1.38759f, -3.63077f, -0.322388f, 1.38759f, 
		-3.63077f, -0.322388f, 1.38759f, -3.63077f, -0.322388f, 1.38759f, 
		-3.63076f, 0.312497f, 1.64991f, -3.63072f, 0.161755f, 1.65339f, 
		-3.63072f, -0.287647f, 1.38229f, -3.63072f, -0.287647f, 1.38229f, 
		-3.63072f, -0.287647f, 1.38229f, -3.63036f, 0.465522f, 1.97130f, 
		-3.63029f, 0.411900f, 1.74105f, -3.63020f, -0.562071f, 1.83174f, 
		-3.63020f, -0.562071f, 1.83174f, -3.63020f, -0.562071f, 1.83174f, 
		-3.63018f, -0.677532f, 1.63837f, -3.63018f, -0.677532f, 1.63837f, 
		-3.63018f, -0.677532f, 1.63837f, -3.63016f, 0.139830f, 1.73926f, 
		-3.63016f, 0.139830f, 1.73926f, -3.63016f, 0.139830f, 1.73926f, 
		-3.63016f, 0.139830f, 1.73926f, -3.63015f, -0.594840f, 1.83026f, 
		-3.63015f, -0.594840f, 1.83026f, -3.63015f, -0.594840f, 1.83026f, 
		-3.63005f, 0.226123f, 1.65258f, -3.62961f, -0.325629f, 1.41441f, 
		-3.62961f, -0.325629f, 1.41441f, -3.62961f, -0.325629f, 1.41441f, 
		-3.62961f, -0.325629f, 1.41441f, -3.62955f, 0.102191f, 1.65289f, 
		-3.62954f, 0.710957f, 1.88998f, -3.62954f, 0.710957f, 1.88998f, 
		-3.62954f, 0.710957f, 1.88998f, -3.62954f, 0.710957f, 1.88998f, 
		-3.62954f, 0.710957f, 1.88998f, -3.62948f, 0.234167f, 1.59302f, 
		-3.62945f, 0.150997f, 1.83867f, -3.62936f, 0.223032f, 1.76537f, 
		-3.62931f, 0.224603f, 1.60512f, -3.62920f, -0.304736f, 1.40584f, 
		-3.62920f, -0.304736f, 1.40584f, -3.62920f, -0.304736f, 1.40584f, 
		-3.62918f, -0.321902f, 1.35898f, -3.62918f, -0.321902f, 1.35898f, 
		-3.62918f, -0.321902f, 1.35898f, -3.62918f, -0.321902f, 1.35898f, 
		-3.62918f, -0.321902f, 1.35898f, -3.62918f, -0.321902f, 1.35898f, 
		-3.62916f, 0.348765f, 1.62215f, -3.62910f, 0.183439f, 1.66465f, 
		-3.62910f, 0.183439f, 1.66465f, -3.62910f, 0.183439f, 1.66465f, 
		-3.62910f, 0.183439f, 1.66465f, -3.62910f, 0.183439f, 1.66465f, 
		-3.62910f, -0.275526f, 1.76327f, -3.62878f, -0.278341f, 1.60567f, 
		-3.62878f, -0.278341f, 1.60567f, -3.62852f, 0.360647f, 1.63498f, 
		-3.62852f, 0.360647f, 1.63498f, -3.62852f, 0.360647f, 1.63498f, 
		-3.62852f, -0.693549f, 1.63974f, -3.62852f, -0.693549f, 1.63974f, 
		-3.62810f, 0.181233f, 1.75681f, -3.62810f, 0.181233f, 1.75681f, 
		-3.62810f, 0.181233f, 1.75681f, -3.62809f, 0.330150f, 1.62872f, 
		-3.62788f, -0.580629f, 1.82894f, -3.62788f, -0.580629f, 1.82894f, 
		-3.62788f, -0.580629f, 1.82894f, -3.62788f, -0.580629f, 1.82894f, 
		-3.62771f, -0.285787f, 1.42763f, -3.62771f, -0.285787f, 1.42763f, 
		-3.62771f, -0.285787f, 1.42763f, -3.62771f, -0.285787f, 1.42763f, 
		-3.62747f, 0.264032f, 1.84426f, -3.62742f, 0.176776f, 1.66839f, 
		-3.62742f, 0.176776f, 1.66839f, -3.62742f, 0.176776f, 1.66839f, 
		-3.62742f, 0.176776f, 1.66839f, -3.62742f, 0.176776f, 1.66839f, 
		-3.62742f, 0.176776f, 1.66839f, -3.62742f, 0.355322f, 1.63144f, 
		-3.62742f, 0.355322f, 1.63144f, -3.62725f, -0.265678f, 1.89158f, 
		-3.62725f, -0.265678f, 1.89158f, -3.62725f, -0.265678f, 1.89158f, 
		-3.62717f, -0.279217f, 1.78427f, -3.62715f, 0.163836f, 1.75880f, 
		-3.62714f, 0.290125f, 1.72421f, -3.62712f, 0.206574f, 1.64019f, 
		-3.62712f, 0.206574f, 1.64019f, -3.62710f, 0.600549f, 1.91168f, 
		-3.62702f, 0.252136f, 1.70714f, -3.62702f, 0.177510f, 1.63931f, 
		-3.62686f, 0.180702f, 1.74416f, -3.62686f, 0.180702f, 1.74416f, 
		-3.62686f, 0.180702f, 1.74416f, -3.62686f, 0.180702f, 1.74416f, 
		-3.62686f, 0.180702f, 1.74416f, -3.62686f, 0.180702f, 1.74416f, 
		-3.62666f, -0.637311f, 1.67873f, -3.62666f, -0.637311f, 1.67873f, 
		-3.62666f, -0.637311f, 1.67873f, -3.62666f, -0.637311f, 1.67873f, 
		-3.62654f, 0.298815f, 1.63278f, -3.62654f, 0.298815f, 1.63278f, 
		-3.62649f, 0.320808f, 1.63656f, -3.62649f, 0.320808f, 1.63656f, 
		-3.62649f, 0.320808f, 1.63656f, -3.62649f, 0.320808f, 1.63656f, 
		-3.62649f, 0.320808f, 1.63656f, -3.62649f, 0.320808f, 1.63656f, 
		-3.62644f, -0.263165f, 1.82948f, -3.62644f, -0.263165f, 1.82948f, 
		-3.62644f, -0.263165f, 1.82948f, -3.62641f, 0.344577f, 1.64963f, 
		-3.62637f, 0.312313f, 1.71321f, -3.62635f, 0.144491f, 1.69396f, 
		-3.62635f, 0.144491f, 1.69396f, -3.62635f, 0.144491f, 1.69396f, 
		-3.62629f, -0.303705f, 1.38539f, -3.62621f, 0.337949f, 1.88749f, 
		-3.62617f, 0.189863f, 1.74963f, -3.62617f, 0.189863f, 1.74963f, 
		-3.62617f, 0.189863f, 1.74963f, -3.62617f, 0.189863f, 1.74963f, 
		-3.62617f, 0.189863f, 1.74963f, -3.62609f, 0.183053f, 1.66756f, 
		-3.62609f, 0.183053f, 1.66756f, -3.62609f, 0.183053f, 1.66756f, 
		-3.62607f, -0.330061f, 1.45782f, -3.62607f, -0.330061f, 1.45782f, 
		-3.62607f, -0.330061f, 1.45782f, -3.62607f, -0.330061f, 1.45782f, 
		-3.62599f, -0.295497f, 1.91038f, -3.62599f, 0.192430f, 1.78130f, 
		-3.62599f, 0.192430f, 1.78130f, -3.62599f, 0.192430f, 1.78130f, 
		-3.62599f, 0.192430f, 1.78130f, -3.62593f, -0.542402f, 1.65913f, 
		-3.62587f, 0.187185f, 1.74392f, -3.62587f, 0.187185f, 1.74392f, 
		-3.62587f, 0.187185f, 1.74392f, -3.62587f, 0.187185f, 1.74392f, 
		-3.62587f, 0.187185f, 1.74392f, -3.62587f, 0.187185f, 1.74392f, 
		-3.62582f, 0.391958f, 1.57504f, -3.62574f, -0.637768f, 1.63567f, 
		-3.62574f, -0.637768f, 1.63567f, -3.62574f, -0.637768f, 1.63567f, 
		-3.62568f, 0.208267f, 1.65293f, -3.62559f, 0.272206f, 1.74125f, 
		-3.62522f, -0.332100f, 1.42620f, -3.62522f, -0.332100f, 1.42620f, 
		-3.62522f, -0.332100f, 1.42620f, -3.62522f, -0.332100f, 1.42620f, 
		-3.62522f, -0.332100f, 1.42620f, -3.62522f, -0.332100f, 1.42620f, 
		-3.62521f, -0.295683f, 1.35308f, -3.62521f, -0.295683f, 1.35308f, 
		-3.62521f, -0.295683f, 1.35308f, -3.62521f, -0.295683f, 1.35308f, 
		-3.62508f, -0.314810f, 1.43815f, -3.62508f, -0.314810f, 1.43815f, 
		-3.62508f, -0.314810f, 1.43815f, -3.62508f, -0.314810f, 1.43815f, 
		-3.62508f, -0.314810f, 1.43815f, -3.62508f, -0.314810f, 1.43815f, 
		-3.62504f, -0.280854f, 1.79308f, -3.62500f, -0.252543f, 1.84921f, 
		-3.62500f, -0.252543f, 1.84921f, -3.62500f, -0.252543f, 1.84921f, 
		-3.62500f, -0.252543f, 1.84921f, -3.62496f, -0.300575f, 1.44080f, 
		-3.62496f, -0.300575f, 1.44080f, -3.62496f, -0.300575f, 1.44080f, 
		-3.62496f, -0.300575f, 1.44080f, -3.62467f, -0.677817f, 1.87496f, 
		-3.62467f, -0.677817f, 1.87496f, -3.62467f, -0.677817f, 1.87496f, 
		-3.62441f, -0.370167f, 1.28096f, -3.62441f, -0.370167f, 1.28096f, 
		-3.62441f, -0.370167f, 1.28096f, -3.62441f, -0.370167f, 1.28096f, 
		-3.62441f, -0.370167f, 1.28096f, -3.62441f, -0.370167f, 1.28096f, 
		-3.62428f, 0.162324f, 1.73259f, -3.62407f, 0.379280f, 1.62090f, 
		-3.62407f, 0.379280f, 1.62090f, -3.62407f, 0.379280f, 1.62090f, 
		-3.62404f, 0.182975f, 1.66199f, -3.62404f, 0.182975f, 1.66199f, 
		-3.62404f, 0.182975f, 1.66199f, -3.62400f, -0.418034f, 1.73297f, 
		-3.62400f, -0.418034f, 1.73297f, -3.62397f, 0.0819790f, 1.74165f, 
		-3.62391f, 0.326272f, 1.93376f, -3.62388f, 0.174798f, 1.78364f, 
		-3.62388f, 0.174798f, 1.78364f, -3.62387f, 0.355628f, 1.63021f, 
		-3.62387f, 0.355628f, 1.63021f, -3.62387f, 0.355628f, 1.63021f, 
		-3.62387f, 0.355628f, 1.63021f, -3.62371f, -0.410854f, 1.83259f, 
		-3.62368f, 0.281437f, 1.92346f, -3.62362f, 0.641592f, 1.54534f, 
		-3.62362f, 0.641592f, 1.54534f, -3.62362f, 0.641592f, 1.54534f, 
		-3.62362f, 0.641592f, 1.54534f, -3.62362f, 0.641592f, 1.54534f, 
		-3.62357f, 0.413148f, 1.85031f, -3.62347f, -0.367084f, 1.60118f, 
		-3.62347f, -0.367084f, 1.60118f, -3.62338f, -0.287992f, 1.94157f, 
		-3.62338f, -0.287992f, 1.94157f, -3.62336f, 0.336598f, 1.70933f, 
		-3.62326f, -0.264894f, 1.82031f, -3.62322f, -0.296466f, 1.45708f, 
		-3.62322f, -0.296466f, 1.45708f, -3.62320f, -0.253264f, 1.69440f, 
		-3.62306f, -0.693825f, 1.87352f, -3.62306f, -0.693825f, 1.87352f, 
		-3.62305f, 0.200124f, 1.63397f, -3.62305f, 0.200124f, 1.63397f, 
		-3.62305f, 0.200124f, 1.63397f, -3.62305f, 0.200124f, 1.63397f, 
		-3.62294f, -0.287259f, 1.43850f, -3.62294f, -0.287259f, 1.43850f, 
		-3.62294f, -0.287259f, 1.43850f, -3.62294f, -0.287259f, 1.43850f, 
		-3.62293f, -0.637236f, 1.83433f, -3.62293f, -0.637236f, 1.83433f, 
		-3.62293f, -0.637236f, 1.83433f, -3.62293f, -0.637236f, 1.83433f, 
		-3.62280f, -0.706063f, 1.64306f, -3.62280f, -0.706063f, 1.64306f, 
		-3.62272f, 0.163234f, 1.68003f, -3.62272f, 0.163234f, 1.68003f, 
		-3.62272f, 0.163234f, 1.68003f, -3.62272f, 0.163234f, 1.68003f, 
		-3.62272f, 0.163234f, 1.68003f, -3.62272f, 0.163234f, 1.68003f, 
		-3.62271f, 0.140225f, 1.72008f, -3.62271f, 0.140225f, 1.72008f, 
		-3.62271f, 0.140225f, 1.72008f, -3.62271f, 0.140225f, 1.72008f, 
		-3.62271f, 0.140225f, 1.72008f, -3.62268f, 0.366299f, 1.88299f, 
		-3.62265f, -0.325383f, 1.35753f, -3.62265f, -0.325383f, 1.35753f, 
		-3.62265f, -0.325383f, 1.35753f, -3.62265f, -0.325383f, 1.35753f, 
		-3.62265f, -0.325383f, 1.35753f, -3.62265f, -0.325383f, 1.35753f, 
		-3.62265f, -0.325383f, 1.35753f, -3.62249f, 0.244519f, 1.71904f, 
		-3.62249f, 0.244519f, 1.71904f, -3.62249f, 0.244519f, 1.71904f, 
		-3.62241f, 0.158335f, 1.68710f, -3.62237f, -0.320998f, 1.46842f, 
		-3.62237f, -0.320998f, 1.46842f, -3.62237f, -0.320998f, 1.46842f, 
		-3.62237f, -0.320998f, 1.46842f, -3.62237f, -0.320998f, 1.46842f, 
		-3.62237f, -0.305483f, 1.41984f, -3.62237f, -0.305483f, 1.41984f, 
		-3.62237f, -0.305483f, 1.41984f, -3.62237f, -0.305483f, 1.41984f, 
		-3.62237f, -0.305483f, 1.41984f, -3.62237f, -0.305483f, 1.41984f, 
		-3.62209f, -0.326070f, 1.43894f, -3.62209f, -0.326070f, 1.43894f, 
		-3.62209f, -0.326070f, 1.43894f, -3.62209f, -0.326070f, 1.43894f, 
		-3.62209f, -0.326070f, 1.43894f, -3.62209f, -0.326070f, 1.43894f, 
		-3.62209f, -0.326070f, 1.43894f, -3.62197f, -0.302435f, 1.47168f, 
		-3.62197f, -0.302435f, 1.47168f, -3.62197f, -0.302435f, 1.47168f, 
		-3.62197f, -0.302435f, 1.47168f, -3.62197f, -0.302435f, 1.47168f, 
		-3.62197f, -0.302435f, 1.47168f, -3.62190f, 0.651763f, 1.50811f, 
		-3.62190f, 0.651763f, 1.50811f, -3.62190f, 0.651763f, 1.50811f, 
		-3.62190f, 0.651763f, 1.50811f, -3.62190f, 0.651763f, 1.50811f, 
		-3.62189f, 0.423610f, 1.76530f, -3.62188f, 0.260309f, 1.76266f, 
		-3.62178f, 0.392210f, 1.87018f, -3.62176f, -0.293455f, 1.34349f, 
		-3.62176f, -0.293455f, 1.34349f, -3.62176f, -0.293455f, 1.34349f, 
		-3.62176f, -0.293455f, 1.34349f, -3.62176f, -0.293455f, 1.34349f, 
		-3.62176f, -0.293455f, 1.34349f, -3.62171f, -0.328687f, 1.44298f, 
		-3.62171f, -0.328687f, 1.44298f, -3.62171f, -0.328687f, 1.44298f, 
		-3.62171f, -0.328687f, 1.44298f, -3.62171f, -0.328687f, 1.44298f, 
		-3.62147f, 0.221369f, 1.63573f, -3.62147f, 0.221369f, 1.63573f, 
		-3.62137f, 0.178341f, 1.66084f, -3.62137f, 0.178341f, 1.66084f, 
		-3.62137f, 0.178341f, 1.66084f, -3.62137f, 0.178341f, 1.66084f, 
		-3.62129f, -0.342458f, 1.46101f, -3.62129f, -0.342458f, 1.46101f, 
		-3.62129f, -0.342458f, 1.46101f, -3.62129f, -0.342458f, 1.46101f, 
		-3.62126f, 0.149092f, 1.63449f, -3.62123f, 0.0959320f, 1.76146f, 
		-3.62120f, 0.172082f, 1.66187f, -3.62120f, 0.172082f, 1.66187f, 
		-3.62120f, 0.172082f, 1.66187f, -3.62102f, -0.559487f, 1.68966f, 
		-3.62089f, -0.606059f, 1.66714f, -3.62088f, 0.181267f, 1.66175f, 
		-3.62088f, 0.181267f, 1.66175f, -3.62088f, 0.181267f, 1.66175f, 
		-3.62077f, -0.679147f, 1.63979f, -3.62077f, -0.679147f, 1.63979f, 
		-3.62077f, -0.679147f, 1.63979f, -3.62075f, 0.351467f, 1.93907f, 
		-3.62074f, -0.335668f, 1.42651f, -3.62074f, -0.335668f, 1.42651f, 
		-3.62074f, -0.335668f, 1.42651f, -3.62074f, -0.335668f, 1.42651f, 
		-3.62067f, -0.324015f, 1.43464f, -3.62067f, -0.324015f, 1.43464f, 
		-3.62067f, -0.324015f, 1.43464f, -3.62067f, -0.324015f, 1.43464f, 
		-3.62067f, -0.324015f, 1.43464f, -3.62067f, -0.324015f, 1.43464f, 
		-3.62067f, -0.324015f, 1.43464f, -3.62067f, -0.324015f, 1.43464f, 
		-3.62066f, 0.211824f, 1.65572f, -3.62033f, 0.179735f, 1.74939f, 
		-3.62033f, 0.179735f, 1.74939f, -3.62033f, 0.179735f, 1.74939f, 
		-3.62033f, 0.179735f, 1.74939f, -3.62033f, 0.179735f, 1.74939f, 
		-3.62030f, 0.214605f, 1.89527f, -3.62018f, 0.185975f, 1.74862f, 
		-3.62018f, 0.185975f, 1.74862f, -3.62018f, 0.185975f, 1.74862f, 
		-3.62018f, 0.185975f, 1.74862f, -3.62018f, 0.185975f, 1.74862f, 
		-3.62018f, 0.185975f, 1.74862f, -3.62018f, 0.185975f, 1.74862f, 
		-3.62017f, -0.638087f, 1.87735f, -3.62017f, -0.638087f, 1.87735f, 
		-3.62017f, -0.638087f, 1.87735f, -3.62010f, -0.264205f, 1.71526f, 
		-3.62003f, -0.310005f, 1.35767f, -3.62003f, -0.310005f, 1.35767f, 
		-3.62003f, -0.310005f, 1.35767f, -3.62003f, -0.310005f, 1.35767f, 
		-3.62003f, -0.310005f, 1.35767f, -3.62003f, -0.310005f, 1.35767f, 
		-3.62003f, -0.405378f, 1.65718f, -3.62000f, -0.359036f, 1.25407f, 
		-3.62000f, -0.359036f, 1.25407f, -3.62000f, -0.359036f, 1.25407f, 
		-3.61998f, -0.331152f, 1.24866f, -3.61998f, -0.331152f, 1.24866f, 
		-3.61998f, -0.331152f, 1.24866f, -3.61998f, -0.331152f, 1.24866f, 
		-3.61984f, 0.391205f, 1.95952f, -3.61978f, 0.187451f, 1.78249f, 
		-3.61974f, -0.674082f, 1.72327f, -3.61974f, -0.674082f, 1.72327f, 
		-3.61974f, -0.674082f, 1.72327f, -3.61962f, 0.212496f, 1.63938f, 
		-3.61962f, 0.212496f, 1.63938f, -3.61951f, -0.291205f, 1.79398f, 
		-3.61950f, -0.248200f, 1.72148f, -3.61950f, -0.248200f, 1.72148f, 
		-3.61950f, -0.248200f, 1.72148f, -3.61942f, -0.496738f, 1.65715f, 
		-3.61920f, 0.282982f, 1.86346f, -3.61917f, -0.566460f, 1.62903f, 
		-3.61916f, -0.274124f, 1.47024f, -3.61897f, 0.322055f, 1.63841f, 
		-3.61897f, 0.322055f, 1.63841f, -3.61891f, -0.520618f, 1.65695f, 
		-3.61885f, -0.333872f, 1.42143f, -3.61885f, -0.333872f, 1.42143f, 
		-3.61885f, -0.333872f, 1.42143f, -3.61885f, -0.333872f, 1.42143f, 
		-3.61885f, -0.333872f, 1.42143f, -3.61885f, -0.333872f, 1.42143f, 
		-3.61868f, 0.364196f, 1.63390f, -3.61868f, -0.285105f, 1.43892f, 
		-3.61868f, -0.285105f, 1.43892f, -3.61862f, -0.327322f, 1.36206f, 
		-3.61862f, -0.327322f, 1.36206f, -3.61862f, -0.327322f, 1.36206f, 
		-3.61862f, -0.327322f, 1.36206f, -3.61862f, -0.327322f, 1.36206f, 
		-3.61858f, -0.394327f, 1.90471f, -3.61848f, 0.723809f, 1.83595f, 
		-3.61848f, 0.723809f, 1.83595f, -3.61848f, 0.723809f, 1.83595f, 
		-3.61848f, 0.723809f, 1.83595f, -3.61848f, 0.723809f, 1.83595f, 
		-3.61844f, -0.597998f, 1.90498f, -3.61844f, -0.597998f, 1.90498f, 
		-3.61844f, -0.597998f, 1.90498f, -3.61841f, -0.246415f, 1.86440f, 
		-3.61841f, -0.246415f, 1.86440f, -3.61841f, -0.246415f, 1.86440f, 
		-3.61841f, 0.360604f, 1.71295f, -3.61839f, 0.161782f, 1.66617f, 
		-3.61839f, 0.161782f, 1.66617f, -3.61835f, -0.691763f, 1.72389f, 
		-3.61835f, -0.691763f, 1.72389f, -3.61835f, -0.691763f, 1.72389f, 
		-3.61835f, -0.691763f, 1.72389f, -3.61824f, 0.386851f, 1.61760f, 
		-3.61824f, 0.386851f, 1.61760f, -3.61810f, 0.154328f, 1.66443f, 
		-3.61801f, 0.226291f, 1.73782f, -3.61801f, -0.673720f, 1.78949f, 
		-3.61801f, -0.673720f, 1.78949f, -3.61801f, -0.673720f, 1.78949f, 
		-3.61782f, -0.279813f, 1.73423f, -3.61773f, 0.159266f, 1.71025f, 
		-3.61771f, -0.263755f, 1.64414f, -3.61771f, -0.263755f, 1.64414f, 
		-3.61771f, -0.263755f, 1.64414f, -3.61771f, -0.263755f, 1.64414f, 
		-3.61757f, -0.596542f, 1.90521f, -3.61757f, -0.596542f, 1.90521f, 
		-3.61757f, -0.596542f, 1.90521f, -3.61757f, -0.596542f, 1.90521f, 
		-3.61748f, -0.706317f, 1.86995f, -3.61748f, -0.706317f, 1.86995f, 
		-3.61736f, -0.236264f, 1.68906f, -3.61736f, -0.236264f, 1.68906f, 
		-3.61732f, 0.189052f, 1.65267f, -3.61732f, 0.189052f, 1.65267f, 
		-3.61732f, 0.189052f, 1.65267f, -3.61732f, 0.189052f, 1.65267f, 
		-3.61729f, -0.330305f, 1.44711f, -3.61729f, -0.330305f, 1.44711f, 
		-3.61729f, -0.330305f, 1.44711f, -3.61729f, -0.330305f, 1.44711f, 
		-3.61718f, 0.118731f, 1.78355f, -3.61713f, 0.213371f, 1.76394f, 
		-3.61706f, 0.211950f, 1.78137f, -3.61706f, 0.211950f, 1.78137f, 
		-3.61700f, -0.296087f, 1.74709f, -3.61700f, -0.296087f, 1.74709f, 
		-3.61700f, -0.296087f, 1.74709f, -3.61699f, -0.498996f, 1.84718f, 
		-3.61694f, -0.472708f, 1.65706f, -3.61691f, -0.336045f, 1.45238f, 
		-3.61691f, -0.336045f, 1.45238f, -3.61691f, -0.336045f, 1.45238f, 
		-3.61691f, -0.336045f, 1.45238f, -3.61691f, -0.336045f, 1.45238f, 
		-3.61688f, -0.327959f, 1.48548f, -3.61688f, -0.327959f, 1.48548f, 
		-3.61688f, -0.327959f, 1.48548f, -3.61688f, -0.327959f, 1.48548f, 
		-3.61682f, 0.165942f, 1.72472f, -3.61682f, 0.165942f, 1.72472f, 
		-3.61682f, 0.165942f, 1.72472f, -3.61672f, -0.641905f, 1.63740f, 
		-3.61672f, -0.641905f, 1.63740f, -3.61672f, -0.641905f, 1.63740f, 
		-3.61672f, -0.641905f, 1.63740f, -3.61669f, -0.691434f, 1.78874f, 
		-3.61669f, -0.691434f, 1.78874f, -3.61669f, -0.691434f, 1.78874f, 
		-3.61669f, -0.691434f, 1.78874f, -3.61668f, -0.303475f, 1.42418f, 
		-3.61668f, -0.303475f, 1.42418f, -3.61668f, -0.303475f, 1.42418f, 
		-3.61668f, -0.303475f, 1.42418f, -3.61668f, -0.303475f, 1.42418f, 
		-3.61668f, -0.303475f, 1.42418f, -3.61668f, -0.303475f, 1.42418f, 
		-3.61657f, -0.285510f, 1.49234f, -3.61657f, -0.285510f, 1.49234f, 
		-3.61657f, -0.285510f, 1.49234f, -3.61657f, -0.285510f, 1.49234f, 
		-3.61657f, -0.517867f, 1.84530f, -3.61656f, 0.167780f, 1.74456f, 
		-3.61656f, 0.167780f, 1.74456f, -3.61652f, 0.198086f, 1.65523f, 
		-3.61652f, 0.198086f, 1.65523f, -3.61652f, 0.198086f, 1.65523f, 
		-3.61652f, 0.198086f, 1.65523f, -3.61652f, 0.198086f, 1.65523f, 
		-3.61640f, 0.201717f, 1.76490f, -3.61640f, 0.201717f, 1.76490f, 
		-3.61640f, 0.201717f, 1.76490f, -3.61640f, 0.201717f, 1.76490f, 
		-3.61637f, 0.247771f, 1.60955f, -3.61637f, 0.247771f, 1.60955f, 
		-3.61637f, 0.247771f, 1.60955f, -3.61636f, 0.255600f, 1.78635f, 
		-3.61628f, -0.600886f, 1.82510f, -3.61617f, -0.640459f, 1.72273f, 
		-3.61617f, -0.640459f, 1.72273f, -3.61617f, -0.640459f, 1.72273f, 
		-3.61612f, -0.413253f, 1.79545f, -3.61612f, -0.413253f, 1.79545f, 
		-3.61608f, -0.320040f, 1.43620f, -3.61608f, -0.320040f, 1.43620f, 
		-3.61608f, -0.320040f, 1.43620f, -3.61608f, -0.320040f, 1.43620f, 
		-3.61598f, 0.162881f, 1.65946f, -3.61587f, -0.282150f, 1.49805f, 
		-3.61587f, -0.282150f, 1.49805f, -3.61587f, -0.282150f, 1.49805f, 
		-3.61587f, -0.282150f, 1.49805f, -3.61586f, -0.533225f, 1.69006f, 
		-3.61580f, 0.191196f, 1.64451f, -3.61580f, 0.191196f, 1.64451f, 
		-3.61580f, 0.191196f, 1.64451f, -3.61579f, 0.173572f, 1.68448f, 
		-3.61579f, 0.173572f, 1.68448f, -3.61579f, 0.173572f, 1.68448f, 
		-3.61579f, 0.173572f, 1.68448f, -3.61579f, 0.173572f, 1.68448f, 
		-3.61568f, -0.307193f, 1.35765f, -3.61568f, -0.307193f, 1.35765f, 
		-3.61568f, -0.307193f, 1.35765f, -3.61568f, -0.307193f, 1.35765f, 
		-3.61567f, -0.304491f, 1.75739f, -3.61567f, -0.304491f, 1.75739f, 
		-3.61567f, -0.304491f, 1.75739f, -3.61567f, -0.304491f, 1.75739f, 
		-3.61567f, -0.304491f, 1.75739f, -3.61565f, -0.258234f, 1.66818f, 
		-3.61560f, -0.309417f, 1.49505f, -3.61560f, -0.309417f, 1.49505f, 
		-3.61560f, -0.309417f, 1.49505f, -3.61539f, -0.576449f, 1.91373f, 
		-3.61539f, -0.576449f, 1.91373f, -3.61539f, -0.576449f, 1.91373f, 
		-3.61539f, -0.576449f, 1.91373f, -3.61534f, -0.679430f, 1.87312f, 
		-3.61534f, -0.679430f, 1.87312f, -3.61534f, -0.679430f, 1.87312f, 
		-3.61532f, 0.163299f, 1.69838f, -3.61532f, 0.163299f, 1.69838f, 
		-3.61528f, -0.307718f, 1.77556f, -3.61528f, -0.307718f, 1.77556f, 
		-3.61528f, -0.307718f, 1.77556f, -3.61528f, -0.307718f, 1.77556f, 
		-3.61528f, -0.307718f, 1.77556f, -3.61528f, -0.307718f, 1.77556f, 
		-3.61524f, 0.198635f, 1.77746f, -3.61514f, 0.235453f, 1.61103f, 
		-3.61511f, -0.590600f, 1.90332f, -3.61511f, -0.590600f, 1.90332f, 
		-3.61511f, -0.590600f, 1.90332f, -3.61511f, -0.590600f, 1.90332f, 
		-3.61511f, -0.590600f, 1.90332f, -3.61511f, -0.590600f, 1.90332f, 
		-3.61503f, 0.186778f, 1.65290f, -3.61503f, 0.186778f, 1.65290f, 
		-3.61503f, 0.186778f, 1.65290f, -3.61503f, 0.186778f, 1.65290f, 
		-3.61503f, 0.186778f, 1.65290f, -3.61485f, 0.176316f, 1.72554f, 
		-3.61485f, 0.176316f, 1.72554f, -3.61485f, 0.176316f, 1.72554f, 
		-3.61485f, 0.176316f, 1.72554f, -3.61485f, 0.176316f, 1.72554f, 
		-3.61485f, 0.176316f, 1.72554f, -3.61470f, -0.308864f, 1.34839f, 
		-3.61470f, -0.308864f, 1.34839f, -3.61470f, -0.308864f, 1.34839f, 
		-3.61470f, -0.308864f, 1.34839f, -3.61440f, -0.324932f, 1.45499f, 
		-3.61440f, -0.324932f, 1.45499f, -3.61440f, -0.324932f, 1.45499f, 
		-3.61440f, -0.324932f, 1.45499f, -3.61440f, -0.324932f, 1.45499f, 
		-3.61440f, -0.324932f, 1.45499f, -3.61431f, -0.639980f, 1.78992f, 
		-3.61431f, -0.639980f, 1.78992f, -3.61431f, -0.639980f, 1.78992f, 
		-3.61427f, 0.196820f, 1.76589f, -3.61427f, 0.196820f, 1.76589f, 
		-3.61427f, 0.196820f, 1.76589f, -3.61427f, 0.196820f, 1.76589f, 
		-3.61427f, 0.196820f, 1.76589f, -3.61427f, 0.196820f, 1.76589f, 
		-3.61424f, -0.328024f, 1.48842f, -3.61424f, -0.328024f, 1.48842f, 
		-3.61424f, -0.328024f, 1.48842f, -3.61418f, 0.426942f, 1.79223f, 
		-3.61416f, 0.181553f, 1.68322f, -3.61416f, 0.181553f, 1.68322f, 
		-3.61416f, 0.181553f, 1.68322f, -3.61410f, -0.306626f, 1.30406f, 
		-3.61410f, -0.306626f, 1.30406f, -3.61410f, -0.306626f, 1.30406f, 
		-3.61410f, -0.306626f, 1.30406f, -3.61410f, 0.166306f, 1.63327f, 
		-3.61408f, -0.307199f, 1.42926f, -3.61408f, -0.307199f, 1.42926f, 
		-3.61408f, -0.307199f, 1.42926f, -3.61408f, -0.307199f, 1.42926f, 
		-3.61408f, -0.307199f, 1.42926f, -3.61394f, 0.0927180f, 1.68861f, 
		-3.61392f, -0.311696f, 1.43704f, -3.61392f, -0.311696f, 1.43704f, 
		-3.61392f, -0.311696f, 1.43704f, -3.61392f, -0.311696f, 1.43704f, 
		-3.61380f, -0.349495f, 1.44458f, -3.61380f, -0.349495f, 1.44458f, 
		-3.61380f, -0.349495f, 1.44458f, -3.61380f, -0.349495f, 1.44458f, 
		-3.61367f, 0.736137f, 1.74817f, -3.61367f, 0.736137f, 1.74817f, 
		-3.61367f, 0.736137f, 1.74817f, -3.61363f, -0.472152f, 1.85350f, 
		-3.61354f, 0.216683f, 1.78229f, -3.61354f, 0.216683f, 1.78229f, 
		-3.61350f, 0.173345f, 1.69297f, -3.61350f, 0.173345f, 1.69297f, 
		-3.61350f, 0.173345f, 1.69297f, -3.61346f, 0.181961f, 1.68439f, 
		-3.61346f, 0.181961f, 1.68439f, -3.61346f, 0.181961f, 1.68439f, 
		-3.61319f, -0.705914f, 1.71844f, -3.61319f, -0.705914f, 1.71844f, 
		-3.61319f, -0.705914f, 1.71844f, -3.61319f, -0.705914f, 1.71844f, 
		-3.61314f, -0.299296f, 1.79477f, -3.61291f, -0.307535f, 1.49850f, 
		-3.61291f, -0.307535f, 1.49850f, -3.61291f, -0.307535f, 1.49850f, 
		-3.61263f, -0.270994f, 1.89787f, -3.61263f, -0.270994f, 1.89787f, 
		-3.61263f, -0.270994f, 1.89787f, -3.61263f, -0.270994f, 1.89787f, 
		-3.61258f, 0.183551f, 1.72597f, -3.61258f, 0.183551f, 1.72597f, 
		-3.61258f, 0.183551f, 1.72597f, -3.61258f, 0.183551f, 1.72597f, 
		-3.61227f, -0.311099f, 1.44740f, -3.61227f, -0.311099f, 1.44740f, 
		-3.61227f, -0.311099f, 1.44740f, -3.61210f, -0.483617f, 1.69105f, 
		-3.61204f, -0.314768f, 1.45776f, -3.61204f, -0.314768f, 1.45776f, 
		-3.61204f, -0.314768f, 1.45776f, -3.61204f, -0.314768f, 1.45776f, 
		-3.61203f, -0.270534f, 1.82297f, -3.61198f, 0.381977f, 1.72371f, 
		-3.61197f, -0.262266f, 1.87562f, -3.61197f, -0.262266f, 1.87562f, 
		-3.61189f, 0.307310f, 1.87573f, -3.61165f, -0.438395f, 1.65640f, 
		-3.61158f, -0.283585f, 1.46619f, -3.61158f, -0.283585f, 1.46619f, 
		-3.61158f, -0.283585f, 1.46619f, -3.61154f, -0.542988f, 1.62044f, 
		-3.61143f, 0.210665f, 1.76858f, -3.61143f, 0.210665f, 1.76858f, 
		-3.61140f, -0.276629f, 1.81389f, -3.61140f, -0.276629f, 1.81389f, 
		-3.61140f, -0.276629f, 1.81389f, -3.61138f, 0.184838f, 1.72355f, 
		-3.61138f, 0.184838f, 1.72355f, -3.61138f, 0.184838f, 1.72355f, 
		-3.61138f, 0.184838f, 1.72355f, -3.61133f, -0.705660f, 1.79389f, 
		-3.61133f, -0.705660f, 1.79389f, -3.61133f, -0.705660f, 1.79389f, 
		-3.61133f, -0.705660f, 1.79389f, -3.61129f, 0.288884f, 1.63716f, 
		-3.61124f, -0.257309f, 1.85378f, -3.61124f, -0.257309f, 1.85378f, 
		-3.61121f, -0.642210f, 1.87532f, -3.61121f, -0.642210f, 1.87532f, 
		-3.61121f, -0.642210f, 1.87532f, -3.61121f, -0.642210f, 1.87532f, 
		-3.61120f, -0.414710f, 1.69323f, -3.61119f, 0.200302f, 1.64871f, 
		-3.61119f, 0.200302f, 1.64871f, -3.61119f, 0.200302f, 1.64871f, 
		-3.61119f, 0.200302f, 1.64871f, -3.61119f, 0.200302f, 1.64871f, 
		-3.61119f, -0.592509f, 1.72050f, -3.61119f, -0.592509f, 1.72050f, 
		-3.61107f, 0.366190f, 1.63640f, -3.61107f, 0.366190f, 1.63640f, 
		-3.61106f, -0.675889f, 1.71893f, -3.61106f, -0.675889f, 1.71893f, 
		-3.61106f, -0.675889f, 1.71893f, -3.61091f, 0.174257f, 1.70632f, 
		-3.61091f, 0.174257f, 1.70632f, -3.61091f, 0.174257f, 1.70632f, 
		-3.61091f, 0.174257f, 1.70632f, -3.61091f, 0.174257f, 1.70632f, 
		-3.61091f, 0.174257f, 1.70632f, -3.61088f, 0.200957f, 1.64642f, 
		-3.61081f, -0.331599f, 1.42409f, -3.61081f, -0.331599f, 1.42409f, 
		-3.61081f, -0.331599f, 1.42409f, -3.61081f, -0.331599f, 1.42409f, 
		-3.61081f, -0.331599f, 1.42409f, -3.61069f, 0.128544f, 1.65251f, 
		-3.61069f, -0.506957f, 1.69046f, -3.61036f, 0.178753f, 1.63438f, 
		-3.61036f, 0.178753f, 1.63438f, -3.61029f, -0.379275f, 1.76650f, 
		-3.61029f, -0.379275f, 1.76650f, -3.61029f, -0.379275f, 1.76650f, 
		-3.61021f, 0.522573f, 1.94410f, -3.61017f, 0.184947f, 1.64412f, 
		-3.61014f, 0.219158f, 1.66957f, -3.60992f, -0.541176f, 1.76852f, 
		-3.60992f, -0.541176f, 1.76852f, -3.60987f, 0.212373f, 1.64891f, 
		-3.60987f, 0.212373f, 1.64891f, -3.60986f, 0.194186f, 1.76018f, 
		-3.60986f, 0.194186f, 1.76018f, -3.60986f, 0.194186f, 1.76018f, 
		-3.60986f, 0.194186f, 1.76018f, -3.60986f, 0.194186f, 1.76018f, 
		-3.60959f, 0.258537f, 1.81000f, -3.60936f, -0.598361f, 1.72093f, 
		-3.60936f, -0.598361f, 1.72093f, -3.60936f, -0.598361f, 1.72093f, 
		-3.60936f, -0.598361f, 1.72093f, -3.60929f, -0.339464f, 1.44102f, 
		-3.60929f, -0.339464f, 1.44102f, -3.60916f, -0.675573f, 1.79344f, 
		-3.60916f, -0.675573f, 1.79344f, -3.60916f, -0.675573f, 1.79344f, 
		-3.60910f, -0.582393f, 1.71925f, -3.60910f, -0.582393f, 1.71925f, 
		-3.60909f, -0.588265f, 1.67745f, -3.60897f, 0.158595f, 1.73667f, 
		-3.60893f, -0.554641f, 1.71811f, -3.60893f, -0.554641f, 1.71811f, 
		-3.60871f, 0.223600f, 1.67683f, -3.60871f, 0.223600f, 1.67683f, 
		-3.60867f, 0.182408f, 1.70337f, -3.60867f, 0.182408f, 1.70337f, 
		-3.60867f, 0.182408f, 1.70337f, -3.60867f, 0.182408f, 1.70337f, 
		-3.60842f, -0.461683f, 1.69094f, -3.60833f, 0.161146f, 1.68147f, 
		-3.60833f, 0.161146f, 1.68147f, -3.60831f, 0.201755f, 1.77269f, 
		-3.60831f, 0.201755f, 1.77269f, -3.60831f, 0.201755f, 1.77269f, 
		-3.60831f, 0.201755f, 1.77269f, -3.60831f, 0.201755f, 1.77269f, 
		-3.60831f, 0.201755f, 1.77269f, -3.60825f, 0.617681f, 1.85442f, 
		-3.60804f, 0.183120f, 1.70513f, -3.60804f, 0.183120f, 1.70513f, 
		-3.60804f, 0.183120f, 1.70513f, -3.60793f, 0.183338f, 1.63727f, 
		-3.60793f, 0.183338f, 1.63727f, -3.60793f, 0.183338f, 1.63727f, 
		-3.60790f, 0.421558f, 1.81920f, -3.60775f, -0.644410f, 1.71849f, 
		-3.60775f, -0.644410f, 1.71849f, -3.60775f, -0.644410f, 1.71849f, 
		-3.60768f, 0.203248f, 1.75492f, -3.60768f, 0.203248f, 1.75492f, 
		-3.60768f, 0.203248f, 1.75492f, -3.60768f, 0.203248f, 1.75492f, 
		-3.60768f, 0.203248f, 1.75492f, -3.60762f, -0.553853f, 1.92514f, 
		-3.60762f, -0.553853f, 1.92514f, -3.60762f, -0.553853f, 1.92514f, 
		-3.60761f, -0.359955f, 1.28730f, -3.60761f, -0.359955f, 1.28730f, 
		-3.60761f, -0.359955f, 1.28730f, -3.60761f, -0.359955f, 1.28730f, 
		-3.60761f, -0.359955f, 1.28730f, -3.60758f, -0.272745f, 1.81964f, 
		-3.60745f, -0.503768f, 1.89323f, -3.60744f, 0.194598f, 1.76909f, 
		-3.60744f, 0.194598f, 1.76909f, -3.60744f, 0.194598f, 1.76909f, 
		-3.60744f, 0.194598f, 1.76909f, -3.60743f, -0.305288f, 1.42288f, 
		-3.60743f, -0.305288f, 1.42288f, -3.60743f, -0.305288f, 1.42288f, 
		-3.60742f, 0.171280f, 1.68123f, -3.60742f, 0.171280f, 1.68123f, 
		-3.60742f, 0.171280f, 1.68123f, -3.60742f, 0.171280f, 1.68123f, 
		-3.60714f, 0.340232f, 1.92331f, -3.60710f, 0.731926f, 1.70820f, 
		-3.60710f, 0.731926f, 1.70820f, -3.60709f, 0.372713f, 1.93766f, 
		-3.60696f, -0.604603f, 1.89148f, -3.60678f, 0.372187f, 1.61756f, 
		-3.60678f, 0.372187f, 1.61756f, -3.60674f, -0.336918f, 1.46020f, 
		-3.60674f, -0.336918f, 1.46020f, -3.60674f, -0.336918f, 1.46020f, 
		-3.60674f, -0.336918f, 1.46020f, -3.60671f, -0.385048f, 1.75728f, 
		-3.60671f, -0.385048f, 1.75728f, -3.60671f, -0.385048f, 1.75728f, 
		-3.60648f, 0.224934f, 1.74372f, -3.60644f, 0.180471f, 1.68121f, 
		-3.60644f, 0.180471f, 1.68121f, -3.60644f, 0.180471f, 1.68121f, 
		-3.60642f, 0.175265f, 1.72866f, -3.60642f, 0.175265f, 1.72866f, 
		-3.60642f, 0.175265f, 1.72866f, -3.60642f, 0.175265f, 1.72866f, 
		-3.60642f, 0.175265f, 1.72866f, -3.60642f, -0.391540f, 1.62575f, 
		-3.60640f, 0.183090f, 1.72822f, -3.60640f, 0.183090f, 1.72822f, 
		-3.60640f, 0.183090f, 1.72822f, -3.60634f, 0.180267f, 1.68022f, 
		-3.60634f, 0.180267f, 1.68022f, -3.60634f, 0.180267f, 1.68022f, 
		-3.60630f, 0.275459f, 1.63670f, -3.60628f, -0.557855f, 1.77191f, 
		-3.60628f, -0.557855f, 1.77191f, -3.60624f, 0.334642f, 1.87987f, 
		-3.60621f, -0.435223f, 1.86008f, -3.60618f, -0.409039f, 1.87094f, 
		-3.60598f, -0.380911f, 1.93525f, -3.60598f, -0.380911f, 1.93525f, 
		-3.60588f, 0.183814f, 1.72715f, -3.60588f, 0.183814f, 1.72715f, 
		-3.60588f, 0.183814f, 1.72715f, -3.60588f, 0.183814f, 1.72715f, 
		-3.60579f, -0.524048f, 1.72100f, -3.60579f, -0.524048f, 1.72100f, 
		-3.60579f, -0.712125f, 1.67744f, -3.60573f, -0.644011f, 1.79383f, 
		-3.60573f, -0.644011f, 1.79383f, -3.60573f, -0.644011f, 1.79383f, 
		-3.60571f, -0.453985f, 1.82952f, -3.60556f, 0.144009f, 1.80410f, 
		-3.60540f, -0.520299f, 1.61526f, -3.60533f, -0.383244f, 1.77529f, 
		-3.60533f, -0.383244f, 1.77529f, -3.60533f, -0.383244f, 1.77529f, 
		-3.60532f, 0.222312f, 1.68435f, -3.60519f, -0.588088f, 1.83495f, 
		-3.60519f, -0.466167f, 1.87958f, -3.60494f, 0.233838f, 1.61880f, 
		-3.60491f, -0.594264f, 1.59944f, -3.60491f, -0.594264f, 1.59944f, 
		-3.60491f, -0.594264f, 1.59944f, -3.60491f, -0.594264f, 1.59944f, 
		-3.60491f, -0.594264f, 1.59944f, -3.60491f, -0.594264f, 1.59944f, 
		-3.60491f, -0.594264f, 1.59944f, -3.60484f, 0.176870f, 1.65492f, 
		-3.60484f, 0.176870f, 1.65492f, -3.60484f, 0.176870f, 1.65492f, 
		-3.60473f, 0.398627f, 1.74056f, -3.60459f, 0.153705f, 1.68725f, 
		-3.60458f, -0.599602f, 1.63952f, -3.60458f, -0.599602f, 1.63952f, 
		-3.60458f, -0.599602f, 1.63952f, -3.60458f, -0.599602f, 1.63952f, 
		-3.60450f, 0.169570f, 1.74103f, -3.60444f, -0.408342f, 1.65516f, 
		-3.60444f, -0.408342f, 1.65516f, -3.60436f, -0.339055f, 1.46746f, 
		-3.60436f, -0.339055f, 1.46746f, -3.60436f, -0.339055f, 1.46746f, 
		-3.60436f, -0.339055f, 1.46746f, -3.60420f, -0.428093f, 1.69610f, 
		-3.60409f, 0.163664f, 1.72177f, -3.60409f, 0.163664f, 1.72177f, 
		-3.60401f, -0.404461f, 1.65465f, -3.60401f, -0.404461f, 1.65465f, 
		-3.60401f, -0.404461f, 1.65465f, -3.60396f, 0.305457f, 1.64527f, 
		-3.60375f, -0.289251f, 1.43664f, -3.60375f, -0.289251f, 1.43664f, 
		-3.60375f, -0.289251f, 1.43664f, -3.60368f, 0.407993f, 1.84358f, 
		-3.60358f, -0.334710f, 1.25817f, -3.60358f, -0.334710f, 1.25817f, 
		-3.60358f, -0.334710f, 1.25817f, -3.60358f, -0.334710f, 1.25817f, 
		-3.60348f, 0.326907f, 1.64334f, -3.60348f, 0.326907f, 1.64334f, 
		-3.60348f, 0.326907f, 1.64334f, -3.60333f, 0.259932f, 1.62957f, 
		-3.60333f, 0.259932f, 1.62957f, -3.60333f, 0.259932f, 1.62957f, 
		-3.60332f, -0.516669f, 1.77620f, -3.60332f, -0.516669f, 1.77620f, 
		-3.60319f, 0.162636f, 1.73467f, -3.60318f, 0.247351f, 1.61927f, 
		-3.60318f, 0.247351f, 1.61927f, -3.60318f, 0.247351f, 1.61927f, 
		-3.60295f, 0.161601f, 1.69900f, -3.60295f, 0.161601f, 1.69900f, 
		-3.60293f, 0.519215f, 1.97912f, -3.60293f, 0.519215f, 1.97912f, 
		-3.60282f, -0.586107f, 1.59995f, -3.60282f, -0.586107f, 1.59995f, 
		-3.60282f, -0.586107f, 1.59995f, -3.60282f, -0.586107f, 1.59995f, 
		-3.60282f, -0.586107f, 1.59995f, -3.60281f, 0.362298f, 1.87547f, 
		-3.60277f, 0.354939f, 1.63862f, -3.60277f, 0.354939f, 1.63862f, 
		-3.60273f, 0.211638f, 1.68220f, -3.60272f, -0.567169f, 1.59024f, 
		-3.60272f, -0.567169f, 1.59024f, -3.60272f, -0.567169f, 1.59024f, 
		-3.60272f, -0.567169f, 1.59024f, -3.60265f, 0.173670f, 1.71782f, 
		-3.60265f, 0.173670f, 1.71782f, -3.60265f, 0.173670f, 1.71782f, 
		-3.60258f, -0.575650f, 1.77559f, -3.60258f, -0.575650f, 1.77559f, 
		-3.60258f, -0.575650f, 1.77559f, -3.60256f, -0.390037f, 1.74801f, 
		-3.60256f, -0.390037f, 1.74801f, -3.60248f, 0.195922f, 1.74964f, 
		-3.60248f, 0.195922f, 1.74964f, -3.60248f, 0.195922f, 1.74964f, 
		-3.60248f, 0.195922f, 1.74964f, -3.60247f, -0.493296f, 1.72397f, 
		-3.60247f, -0.493296f, 1.72397f, -3.60236f, 0.186797f, 1.65897f, 
		-3.60236f, 0.186797f, 1.65897f, -3.60232f, 0.173046f, 1.70487f, 
		-3.60232f, 0.173046f, 1.70487f, -3.60232f, 0.173046f, 1.70487f, 
		-3.60232f, 0.173046f, 1.70487f, -3.60232f, 0.173046f, 1.70487f, 
		-3.60229f, -0.342064f, 1.60368f, -3.60222f, 0.268837f, 1.83129f, 
		-3.60219f, 0.197189f, 1.76007f, -3.60219f, 0.197189f, 1.76007f, 
		-3.60219f, 0.197189f, 1.76007f, -3.60219f, 0.197189f, 1.76007f, 
		-3.60219f, 0.197189f, 1.76007f, -3.60219f, 0.197189f, 1.76007f, 
		-3.60219f, 0.197189f, 1.76007f, -3.60209f, -0.712192f, 1.83472f, 
		-3.60207f, -0.591177f, 1.77466f, -3.60207f, -0.591177f, 1.77466f, 
		-3.60207f, -0.591177f, 1.77466f, -3.60193f, 0.387574f, 1.86297f, 
		-3.60186f, 0.224429f, 1.69443f, -3.60185f, -0.286073f, 1.46099f, 
		-3.60180f, 0.181010f, 1.71605f, -3.60180f, 0.181010f, 1.71605f, 
		-3.60180f, 0.181010f, 1.71605f, -3.60179f, -0.471088f, 1.72452f, 
		-3.60179f, -0.471088f, 1.72452f, -3.60179f, 0.183532f, 1.67529f, 
		-3.60179f, 0.183532f, 1.67529f, -3.60179f, 0.183532f, 1.67529f, 
		-3.60170f, 0.171679f, 1.69889f, -3.60170f, 0.171679f, 1.69889f, 
		-3.60170f, 0.171679f, 1.69889f, -3.60140f, -0.420022f, 1.72812f, 
		-3.60140f, -0.420022f, 1.72812f, -3.60140f, -0.420022f, 1.72812f, 
		-3.60140f, -0.420022f, 1.72812f, -3.60137f, -0.351948f, 1.26572f, 
		-3.60137f, -0.351948f, 1.26572f, -3.60137f, -0.351948f, 1.26572f, 
		-3.60137f, -0.351948f, 1.26572f, -3.60137f, -0.351948f, 1.26572f, 
		-3.60132f, 0.214255f, 1.63105f, -3.60126f, -0.418946f, 1.86393f, 
		-3.60126f, -0.418946f, 1.86393f, -3.60124f, -0.331194f, 1.44180f, 
		-3.60124f, -0.331194f, 1.44180f, -3.60124f, -0.331194f, 1.44180f, 
		-3.60124f, -0.331194f, 1.44180f, -3.60124f, -0.331194f, 1.44180f, 
		-3.60118f, 0.109887f, 1.68270f, -3.60115f, 0.155224f, 1.71361f, 
		-3.60114f, 0.182070f, 1.70498f, -3.60114f, 0.182070f, 1.70498f, 
		-3.60114f, 0.182070f, 1.70498f, -3.60114f, 0.182070f, 1.70498f, 
		-3.60111f, 0.197280f, 1.67905f, -3.60111f, 0.197280f, 1.67905f, 
		-3.60111f, 0.197280f, 1.67905f, -3.60111f, 0.197280f, 1.67905f, 
		-3.60111f, 0.197280f, 1.67905f, -3.60110f, -0.320799f, 1.47310f, 
		-3.60110f, -0.320799f, 1.47310f, -3.60110f, -0.320799f, 1.47310f, 
		-3.60110f, -0.320799f, 1.47310f, -3.60079f, 0.419309f, 1.93543f, 
		-3.60079f, 0.419309f, 1.93543f, -3.60068f, 0.296763f, 1.73324f, 
		-3.60066f, 0.542884f, 1.60431f, -3.60065f, -0.327094f, 1.43449f, 
		-3.60065f, -0.327094f, 1.43449f, -3.60065f, -0.327094f, 1.43449f, 
		-3.60065f, -0.327094f, 1.43449f, -3.60065f, -0.327094f, 1.43449f, 
		-3.60060f, 0.180608f, 1.70341f, -3.60060f, 0.180608f, 1.70341f, 
		-3.60060f, 0.180608f, 1.70341f, -3.60060f, 0.180608f, 1.70341f, 
		-3.60059f, 0.387796f, 1.96658f, -3.60059f, 0.387796f, 1.96658f, 
		-3.60059f, 0.387796f, 1.96658f, -3.60059f, 0.387796f, 1.96658f, 
		-3.60059f, 0.387796f, 1.96658f, -3.60059f, 0.387796f, 1.96658f, 
		-3.60035f, -0.293751f, 1.48137f, -3.60035f, -0.293751f, 1.48137f, 
		-3.60015f, 0.156754f, 1.64862f, -3.60014f, -0.413138f, 1.83327f, 
		-3.60011f, 0.313727f, 1.72478f, -3.60007f, 0.114196f, 1.74552f, 
		-3.60002f, -0.411212f, 1.69059f, -3.60002f, -0.411212f, 1.69059f, 
		-3.60002f, -0.411212f, 1.69059f, -3.60001f, -0.386632f, 1.78406f, 
		-3.60001f, -0.386632f, 1.78406f, -3.59985f, 0.202149f, 1.74447f, 
		-3.59985f, 0.202149f, 1.74447f, -3.59985f, 0.202149f, 1.74447f, 
		-3.59985f, 0.202149f, 1.74447f, -3.59985f, 0.202149f, 1.74447f, 
		-3.59985f, 0.202149f, 1.74447f, -3.59985f, 0.202149f, 1.74447f, 
		-3.59985f, 0.202149f, 1.74447f, -3.59976f, -0.531331f, 1.93679f, 
		-3.59976f, -0.531331f, 1.93679f, -3.59976f, -0.531331f, 1.93679f, 
		-3.59976f, -0.531331f, 1.93679f, -3.59965f, -0.318422f, 1.76249f, 
		-3.59965f, -0.318422f, 1.76249f, -3.59965f, -0.318422f, 1.76249f, 
		-3.59965f, -0.318422f, 1.76249f, -3.59965f, -0.318422f, 1.76249f, 
		-3.59965f, -0.318422f, 1.76249f, -3.59954f, -0.334868f, 1.45149f, 
		-3.59954f, -0.334868f, 1.45149f, -3.59954f, -0.334868f, 1.45149f, 
		-3.59954f, -0.334868f, 1.45149f, -3.59949f, 0.283077f, 1.74630f, 
		-3.59947f, -0.335376f, 1.28600f, -3.59947f, -0.335376f, 1.28600f, 
		-3.59947f, -0.335376f, 1.28600f, -3.59943f, -0.318025f, 1.47842f, 
		-3.59943f, -0.318025f, 1.47842f, -3.59930f, -0.602484f, 1.72080f, 
		-3.59919f, 0.198169f, 1.65763f, -3.59919f, -0.599915f, 1.87266f, 
		-3.59919f, -0.599915f, 1.87266f, -3.59919f, -0.599915f, 1.87266f, 
		-3.59919f, -0.599915f, 1.87266f, -3.59906f, 0.214057f, 1.73858f, 
		-3.59904f, 0.220136f, 1.69626f, -3.59901f, -0.436788f, 1.72530f, 
		-3.59901f, -0.436788f, 1.72530f, -3.59891f, -0.599124f, 1.71484f, 
		-3.59891f, -0.599124f, 1.71484f, -3.59891f, -0.599124f, 1.71484f, 
		-3.59891f, -0.318280f, 1.77883f, -3.59891f, -0.318280f, 1.77883f, 
		-3.59891f, -0.318280f, 1.77883f, -3.59891f, -0.318280f, 1.77883f, 
		-3.59891f, -0.318280f, 1.77883f, -3.59891f, -0.318280f, 1.77883f, 
		-3.59885f, 0.223883f, 1.72025f, -3.59885f, 0.223883f, 1.72025f, 
		-3.59874f, 0.533838f, 1.80844f, -3.59874f, 0.533838f, 1.80844f, 
		-3.59874f, 0.533838f, 1.80844f, -3.59854f, 0.436241f, 1.95044f, 
		-3.59853f, -0.568591f, 1.67636f, -3.59853f, -0.568591f, 1.67636f, 
		-3.59853f, -0.568591f, 1.67636f, -3.59853f, -0.568591f, 1.67636f, 
		-3.59834f, 0.156392f, 1.72404f, -3.59834f, 0.156392f, 1.72404f, 
		-3.59834f, 0.156392f, 1.72404f, -3.59815f, 0.343978f, 1.91141f, 
		-3.59810f, 0.130004f, 1.76293f, -3.59800f, -0.472613f, 1.78579f, 
		-3.59800f, -0.472613f, 1.78579f, -3.59800f, -0.472613f, 1.78579f, 
		-3.59784f, 0.183824f, 1.67991f, -3.59784f, 0.183824f, 1.67991f, 
		-3.59784f, 0.183824f, 1.67991f, -3.59781f, 0.332306f, 1.72177f, 
		-3.59740f, 0.213624f, 1.76233f, -3.59740f, 0.213624f, 1.76233f, 
		-3.59737f, -0.543069f, 1.58242f, -3.59737f, -0.543069f, 1.58242f, 
		-3.59737f, -0.543069f, 1.58242f, -3.59737f, -0.543069f, 1.58242f, 
		-3.59735f, 0.408927f, 1.76185f, -3.59731f, -0.316680f, 1.43044f, 
		-3.59731f, -0.316680f, 1.43044f, -3.59731f, -0.316680f, 1.43044f, 
		-3.59731f, -0.316680f, 1.43044f, -3.59731f, -0.316680f, 1.43044f, 
		-3.59720f, 0.102386f, 1.72365f, -3.59709f, 0.167138f, 1.68222f, 
		-3.59708f, -0.503696f, 1.93728f, -3.59708f, -0.503696f, 1.93728f, 
		-3.59697f, -0.360507f, 1.93235f, -3.59694f, -0.321074f, 1.60750f, 
		-3.59669f, -0.414208f, 1.69009f, -3.59669f, -0.414208f, 1.69009f, 
		-3.59669f, -0.414208f, 1.69009f, -3.59668f, 0.176827f, 1.75772f, 
		-3.59668f, 0.176827f, 1.75772f, -3.59668f, 0.176827f, 1.75772f, 
		-3.59668f, 0.176827f, 1.75772f, -3.59665f, -0.491952f, 1.78382f, 
		-3.59665f, -0.491952f, 1.78382f, -3.59664f, 0.274006f, 1.76271f, 
		-3.59657f, -0.598560f, 1.79721f, -3.59657f, -0.598560f, 1.79721f, 
		-3.59657f, -0.598560f, 1.79721f, -3.59621f, -0.412034f, 1.86724f, 
		-3.59621f, -0.412034f, 1.86724f, -3.59621f, -0.412034f, 1.86724f, 
		-3.59621f, -0.412034f, 1.86724f, -3.59612f, 0.194512f, 1.65278f, 
		-3.59612f, 0.194512f, 1.65278f, -3.59612f, 0.194512f, 1.65278f, 
		-3.59612f, 0.194512f, 1.65278f, -3.59593f, -0.448328f, 1.78932f, 
		-3.59593f, -0.448328f, 1.78932f, -3.59581f, 0.215030f, 1.70558f, 
		-3.59579f, 0.209459f, 1.66816f, -3.59579f, 0.209459f, 1.66816f, 
		-3.59578f, -0.712130f, 1.64515f, -3.59575f, 0.183958f, 1.67420f, 
		-3.59575f, 0.183958f, 1.67420f, -3.59575f, 0.183958f, 1.67420f, 
		-3.59575f, 0.183958f, 1.67420f, -3.59566f, -0.241566f, 1.72672f, 
		-3.59566f, -0.241566f, 1.72672f, -3.59546f, 0.193204f, 1.74562f, 
		-3.59546f, 0.193204f, 1.74562f, -3.59546f, 0.193204f, 1.74562f, 
		-3.59546f, 0.193204f, 1.74562f, -3.59537f, 0.124311f, 1.67998f, 
		-3.59537f, -0.400315f, 1.63069f, -3.59537f, -0.400315f, 1.63069f, 
		-3.59537f, -0.400315f, 1.63069f, -3.59537f, -0.400315f, 1.63069f, 
		-3.59532f, -0.432057f, 1.79141f, -3.59532f, -0.432057f, 1.79141f, 
		-3.59532f, -0.432057f, 1.79141f, -3.59500f, -0.411446f, 1.83054f, 
		-3.59500f, -0.411446f, 1.83054f, -3.59496f, 0.285493f, 1.84814f, 
		-3.59486f, 0.209138f, 1.71357f, -3.59486f, 0.209138f, 1.71357f, 
		-3.59486f, 0.209138f, 1.71357f, -3.59485f, 0.178821f, 1.65196f, 
		-3.59485f, 0.178821f, 1.65196f, -3.59485f, 0.178821f, 1.65196f, 
		-3.59485f, 0.178821f, 1.65196f, -3.59485f, 0.178821f, 1.65196f, 
		-3.59481f, -0.418426f, 1.72510f, -3.59481f, -0.418426f, 1.72510f, 
		-3.59481f, -0.418426f, 1.72510f, -3.59481f, -0.418426f, 1.72510f, 
		-3.59466f, 0.312706f, 1.90417f, -3.59463f, 0.195451f, 1.75222f, 
		-3.59463f, 0.195451f, 1.75222f, -3.59463f, 0.195451f, 1.75222f, 
		-3.59463f, 0.195451f, 1.75222f, -3.59455f, 0.630536f, 1.60941f, 
		-3.59455f, 0.630536f, 1.60941f, -3.59455f, 0.630536f, 1.60941f, 
		-3.59455f, 0.630536f, 1.60941f, -3.59455f, 0.630536f, 1.60941f, 
		-3.59452f, -0.568393f, 1.83574f, -3.59452f, -0.568393f, 1.83574f, 
		-3.59452f, -0.568393f, 1.83574f, -3.59452f, -0.568393f, 1.83574f, 
		-3.59447f, 0.203728f, 1.67947f, -3.59435f, -0.308560f, 1.75045f, 
		-3.59412f, -0.379354f, 1.59462f, -3.59412f, -0.379354f, 1.59462f, 
		-3.59407f, -0.603736f, 1.61114f, -3.59404f, 0.184548f, 1.75777f, 
		-3.59403f, 0.350690f, 1.72450f, -3.59383f, 0.624454f, 1.58158f, 
		-3.59383f, 0.624454f, 1.58158f, -3.59383f, 0.624454f, 1.58158f, 
		-3.59383f, 0.624454f, 1.58158f, -3.59383f, 0.624454f, 1.58158f, 
		-3.59381f, 0.200825f, 1.73300f, -3.59381f, 0.200825f, 1.73300f, 
		-3.59381f, 0.200825f, 1.73300f, -3.59381f, 0.200825f, 1.73300f, 
		-3.59381f, 0.200825f, 1.73300f, -3.59381f, 0.200825f, 1.73300f, 
		-3.59381f, 0.200825f, 1.73300f, -3.59377f, -0.326096f, 1.46394f, 
		-3.59377f, -0.326096f, 1.46394f, -3.59377f, -0.326096f, 1.46394f, 
		-3.59377f, -0.326096f, 1.46394f, -3.59377f, -0.326096f, 1.46394f, 
		-3.59377f, -0.326096f, 1.46394f, -3.59365f, -0.346567f, 1.40891f, 
		-3.59365f, -0.346567f, 1.40891f, -3.59365f, -0.346567f, 1.40891f, 
		-3.59365f, -0.346567f, 1.40891f, -3.59365f, -0.346567f, 1.40891f, 
		-3.59365f, -0.346567f, 1.40891f, -3.59349f, 0.198026f, 1.70429f, 
		-3.59349f, 0.198026f, 1.70429f, -3.59349f, 0.198026f, 1.70429f, 
		-3.59349f, 0.198026f, 1.70429f, -3.59349f, 0.198026f, 1.70429f, 
		-3.59348f, -0.303971f, 1.43314f, -3.59348f, -0.303971f, 1.43314f, 
		-3.59348f, -0.303971f, 1.43314f, -3.59348f, -0.303971f, 1.43314f, 
		-3.59348f, -0.303971f, 1.43314f, -3.59333f, 0.160746f, 1.70897f, 
		-3.59318f, -0.303264f, 1.79531f, -3.59307f, -0.411479f, 1.79571f, 
		-3.59307f, -0.411479f, 1.79571f, -3.59307f, -0.411479f, 1.79571f, 
		-3.59307f, -0.411479f, 1.79571f, -3.59307f, -0.411479f, 1.79571f, 
		-3.59307f, -0.411479f, 1.79571f, -3.59301f, 0.565562f, 1.74904f, 
		-3.59301f, 0.565562f, 1.74904f, -3.59292f, 0.242902f, 1.62135f, 
		-3.59292f, 0.242902f, 1.62135f, -3.59292f, 0.242902f, 1.62135f, 
		-3.59292f, 0.242902f, 1.62135f, -3.59292f, 0.242902f, 1.62135f, 
		-3.59292f, 0.242902f, 1.62135f, -3.59277f, 0.197800f, 1.67601f, 
		-3.59277f, 0.197800f, 1.67601f, -3.59277f, 0.197800f, 1.67601f, 
		-3.59277f, 0.197800f, 1.67601f, -3.59277f, 0.197800f, 1.67601f, 
		-3.59277f, 0.197800f, 1.67601f, -3.59272f, 0.217106f, 1.66855f, 
		-3.59272f, 0.217106f, 1.66855f, -3.59268f, 0.199954f, 1.64262f, 
		-3.59245f, 0.192832f, 1.73507f, -3.59245f, 0.192832f, 1.73507f, 
		-3.59245f, 0.192832f, 1.73507f, -3.59240f, 0.270447f, 1.78085f, 
		-3.59230f, -0.595124f, 1.77559f, -3.59230f, -0.595124f, 1.77559f, 
		-3.59226f, -0.235652f, 1.72153f, -3.59226f, -0.235652f, 1.72153f, 
		-3.59207f, 0.187550f, 1.70375f, -3.59207f, 0.187550f, 1.70375f, 
		-3.59207f, 0.187550f, 1.70375f, -3.59207f, 0.187550f, 1.70375f, 
		-3.59205f, 0.276756f, 1.64800f, -3.59205f, 0.276756f, 1.64800f, 
		-3.59205f, 0.276756f, 1.64800f, -3.59190f, -0.314549f, 1.41840f, 
		-3.59190f, -0.314549f, 1.41840f, -3.59190f, -0.314549f, 1.41840f, 
		-3.59190f, -0.314549f, 1.41840f, -3.59190f, -0.314549f, 1.41840f, 
		-3.59189f, -0.519175f, 1.57435f, -3.59189f, -0.519175f, 1.57435f, 
		-3.59188f, -0.499286f, 1.57624f, -3.59188f, -0.499286f, 1.57624f, 
		-3.59188f, 0.172050f, 1.65190f, -3.59180f, 0.193134f, 1.73153f, 
		-3.59180f, 0.193134f, 1.73153f, -3.59180f, 0.193134f, 1.73153f, 
		-3.59180f, 0.193134f, 1.73153f, -3.59180f, 0.193134f, 1.73153f, 
		-3.59176f, 0.202228f, 1.74961f, -3.59176f, 0.202228f, 1.74961f, 
		-3.59176f, 0.202228f, 1.74961f, -3.59176f, 0.202228f, 1.74961f, 
		-3.59176f, 0.202228f, 1.74961f, -3.59173f, -0.711790f, 1.70739f, 
		-3.59168f, 0.353388f, 1.64566f, -3.59159f, 0.631921f, 1.86972f, 
		-3.59159f, 0.631921f, 1.86972f, -3.59158f, 0.191353f, 1.70878f, 
		-3.59158f, 0.191353f, 1.70878f, -3.59158f, 0.191353f, 1.70878f, 
		-3.59158f, 0.191353f, 1.70878f, -3.59158f, -0.400923f, 1.90302f, 
		-3.59158f, -0.400923f, 1.90302f, -3.59158f, -0.400923f, 1.90302f, 
		-3.59147f, 0.289262f, 1.65305f, -3.59147f, 0.289262f, 1.65305f, 
		-3.59147f, 0.289262f, 1.65305f, -3.59134f, 0.215325f, 1.75382f, 
		-3.59134f, 0.215325f, 1.75382f, -3.59134f, 0.215325f, 1.75382f, 
		-3.59134f, 0.215325f, 1.75382f, -3.59134f, 0.215325f, 1.75382f, 
		-3.59114f, 0.184650f, 1.68124f, -3.59114f, 0.184650f, 1.68124f, 
		-3.59114f, 0.184650f, 1.68124f, -3.59083f, 0.290072f, 1.76953f, 
		-3.59071f, -0.412297f, 1.83295f, -3.59071f, -0.412297f, 1.83295f, 
		-3.59071f, -0.412297f, 1.83295f, -3.59058f, 0.411870f, 1.78550f, 
		-3.59053f, -0.303116f, 1.44997f, -3.59053f, -0.303116f, 1.44997f, 
		-3.59053f, -0.303116f, 1.44997f, -3.59053f, -0.303116f, 1.44997f, 
		-3.59051f, -0.712336f, 1.86678f, -3.59047f, -0.309650f, 1.46584f, 
		-3.59047f, -0.309650f, 1.46584f, -3.59047f, -0.309650f, 1.46584f, 
		-3.59047f, -0.309650f, 1.46584f, -3.59014f, -0.417563f, 1.72513f, 
		-3.59014f, -0.417563f, 1.72513f, -3.59014f, -0.417563f, 1.72513f, 
		-3.59014f, -0.417563f, 1.72513f, -3.59014f, -0.417563f, 1.72513f, 
		-3.59014f, -0.417563f, 1.72513f, -3.59006f, 0.199355f, 1.84911f, 
		-3.59004f, 0.149871f, 1.77757f, -3.58994f, 0.190606f, 1.74289f, 
		-3.58994f, 0.190606f, 1.74289f, -3.58994f, 0.190606f, 1.74289f, 
		-3.58982f, 0.611218f, 1.67706f, -3.58982f, 0.611218f, 1.67706f, 
		-3.58982f, 0.611218f, 1.67706f, -3.58982f, 0.611218f, 1.67706f, 
		-3.58982f, 0.611218f, 1.67706f, -3.58977f, 0.219642f, 1.75593f, 
		-3.58977f, 0.219642f, 1.75593f, -3.58943f, -0.711651f, 1.80395f, 
		-3.58935f, 0.300167f, 1.74142f, -3.58935f, 0.300167f, 1.74142f, 
		-3.58935f, 0.300167f, 1.74142f, -3.58912f, 0.367068f, 1.73270f, 
		-3.58905f, -0.282849f, 1.82463f, -3.58903f, 0.331057f, 1.65830f, 
		-3.58889f, 0.308537f, 1.65989f, -3.58889f, 0.267249f, 1.63612f, 
		-3.58889f, 0.267249f, 1.63612f, -3.58889f, 0.267249f, 1.63612f, 
		-3.58885f, 0.203341f, 1.74165f, -3.58885f, 0.203341f, 1.74165f, 
		-3.58885f, 0.203341f, 1.74165f, -3.58885f, 0.203341f, 1.74165f, 
		-3.58885f, 0.203341f, 1.74165f, -3.58855f, 0.612331f, 1.76461f, 
		-3.58854f, 0.306865f, 1.85890f, -3.58848f, -0.339605f, 1.92942f, 
		-3.58841f, -0.299204f, 1.73763f, -3.58838f, 0.194304f, 1.65286f, 
		-3.58838f, 0.194304f, 1.65286f, -3.58838f, 0.194304f, 1.65286f, 
		-3.58838f, 0.194304f, 1.65286f, -3.58838f, 0.194304f, 1.65286f, 
		-3.58824f, -0.300563f, 1.42863f, -3.58824f, -0.300563f, 1.42863f, 
		-3.58824f, -0.300563f, 1.42863f, -3.58824f, -0.300563f, 1.42863f, 
		-3.58823f, 0.314774f, 1.73476f, -3.58812f, 0.376492f, 1.62538f, 
		-3.58801f, 0.329273f, 1.73236f, -3.58801f, 0.329273f, 1.73236f, 
		-3.58801f, 0.329273f, 1.73236f, -3.58754f, 0.185902f, 1.73743f, 
		-3.58754f, 0.185902f, 1.73743f, -3.58754f, 0.185902f, 1.73743f, 
		-3.58748f, 0.214794f, 1.73653f, -3.58748f, 0.214794f, 1.73653f, 
		-3.58745f, -0.269031f, 1.85542f, -3.58740f, 0.258616f, 1.62383f, 
		-3.58740f, 0.258616f, 1.62383f, -3.58740f, 0.258616f, 1.62383f, 
		-3.58740f, 0.258616f, 1.62383f, -3.58740f, 0.258616f, 1.62383f, 
		-3.58740f, 0.258616f, 1.62383f, -3.58731f, -0.461479f, 1.93782f, 
		-3.58731f, -0.461479f, 1.93782f, -3.58721f, 0.272738f, 1.79894f, 
		-3.58712f, 0.200141f, 1.73640f, -3.58712f, 0.200141f, 1.73640f, 
		-3.58712f, 0.200141f, 1.73640f, -3.58712f, 0.200141f, 1.73640f, 
		-3.58712f, 0.200141f, 1.73640f, -3.58712f, 0.200141f, 1.73640f, 
		-3.58706f, 0.135992f, 1.74015f, -3.58701f, 0.394326f, 1.92299f, 
		-3.58696f, 0.217764f, 1.64283f, -3.58696f, 0.176689f, 1.67610f, 
		-3.58696f, 0.176689f, 1.67610f, -3.58696f, 0.176689f, 1.67610f, 
		-3.58679f, -0.327738f, 1.46426f, -3.58679f, -0.327738f, 1.46426f, 
		-3.58679f, -0.327738f, 1.46426f, -3.58679f, -0.327738f, 1.46426f, 
		-3.58679f, -0.327738f, 1.46426f, -3.58679f, -0.327738f, 1.46426f, 
		-3.58679f, -0.327738f, 1.46426f, -3.58676f, 0.271788f, 1.88776f, 
		-3.58672f, 0.696301f, 1.66030f, -3.58666f, 0.289921f, 1.77136f, 
		-3.58666f, 0.289921f, 1.77136f, -3.58664f, 0.201179f, 1.75202f, 
		-3.58664f, 0.201179f, 1.75202f, -3.58664f, 0.201179f, 1.75202f, 
		-3.58664f, 0.201179f, 1.75202f, -3.58664f, 0.201179f, 1.75202f, 
		-3.58659f, -0.463412f, 1.57933f, -3.58659f, -0.463412f, 1.57933f, 
		-3.58652f, -0.281755f, 1.71294f, -3.58637f, -0.576600f, 1.64183f, 
		-3.58637f, -0.576600f, 1.64183f, -3.58637f, -0.576600f, 1.64183f, 
		-3.58637f, -0.576600f, 1.64183f, -3.58598f, 0.212845f, 1.74224f, 
		-3.58598f, 0.212845f, 1.74224f, -3.58590f, -0.266646f, 1.68773f, 
		-3.58587f, -0.698878f, 1.60733f, -3.58570f, 0.602689f, 1.56767f, 
		-3.58570f, 0.602689f, 1.56767f, -3.58570f, 0.602689f, 1.56767f, 
		-3.58558f, 0.186418f, 1.69851f, -3.58558f, 0.186418f, 1.69851f, 
		-3.58558f, 0.186418f, 1.69851f, -3.58558f, 0.186418f, 1.69851f, 
		-3.58543f, -0.366496f, 1.39249f, -3.58543f, -0.366496f, 1.39249f, 
		-3.58543f, -0.366496f, 1.39249f, -3.58543f, -0.366496f, 1.39249f, 
		-3.58523f, -0.308389f, 1.46573f, -3.58523f, -0.308389f, 1.46573f, 
		-3.58523f, -0.308389f, 1.46573f, -3.58523f, -0.308389f, 1.46573f, 
		-3.58511f, -0.300621f, 1.44837f, -3.58511f, -0.300621f, 1.44837f, 
		-3.58511f, -0.300621f, 1.44837f, -3.58506f, 0.407162f, 1.80919f, 
		-3.58503f, 0.587972f, 1.94473f, -3.58503f, 0.587972f, 1.94473f, 
		-3.58503f, 0.587972f, 1.94473f, -3.58503f, 0.587972f, 1.94473f, 
		-3.58485f, -0.377054f, 1.40723f, -3.58485f, -0.377054f, 1.40723f, 
		-3.58485f, -0.377054f, 1.40723f, -3.58485f, -0.377054f, 1.40723f, 
		-3.58472f, 0.128645f, 1.70964f, -3.58463f, 0.191280f, 1.71171f, 
		-3.58463f, 0.191280f, 1.71171f, -3.58463f, 0.191280f, 1.71171f, 
		-3.58463f, 0.191280f, 1.71171f, -3.58456f, 0.277860f, 1.64999f, 
		-3.58456f, 0.277860f, 1.64999f, -3.58456f, 0.277860f, 1.64999f, 
		-3.58456f, 0.277860f, 1.64999f, -3.58456f, 0.277860f, 1.64999f, 
		-3.58456f, 0.277860f, 1.64999f, -3.58445f, -0.708814f, 1.61111f, 
		-3.58445f, -0.708814f, 1.61111f, -3.58438f, 0.175325f, 1.70494f, 
		-3.58404f, -0.685410f, 1.60857f, -3.58404f, -0.685410f, 1.60857f, 
		-3.58399f, -0.358738f, 1.76717f, -3.58399f, -0.358738f, 1.76717f, 
		-3.58391f, 0.195047f, 1.72668f, -3.58391f, 0.195047f, 1.72668f, 
		-3.58391f, 0.195047f, 1.72668f, -3.58391f, 0.195047f, 1.72668f, 
		-3.58391f, 0.195047f, 1.72668f, -3.58388f, 0.203524f, 1.72225f, 
		-3.58388f, 0.203524f, 1.72225f, -3.58388f, 0.203524f, 1.72225f, 
		-3.58388f, 0.203524f, 1.72225f, -3.58388f, 0.203524f, 1.72225f, 
		-3.58377f, 0.199645f, 1.70572f, -3.58377f, 0.199645f, 1.70572f, 
		-3.58377f, 0.199645f, 1.70572f, -3.58377f, 0.199645f, 1.70572f, 
		-3.58377f, 0.199645f, 1.70572f, -3.58377f, 0.199645f, 1.70572f, 
		-3.58358f, 0.330871f, 1.86252f, -3.58357f, 0.379845f, 1.74556f, 
		-3.58349f, -0.406283f, 1.90313f, -3.58349f, -0.406283f, 1.90313f, 
		-3.58348f, 0.200348f, 1.65310f, -3.58310f, 0.350048f, 1.88023f, 
		-3.58306f, 0.361071f, 1.73419f, -3.58306f, 0.361071f, 1.73419f, 
		-3.58306f, 0.361071f, 1.73419f, -3.58302f, -0.268630f, 1.66130f, 
		-3.58246f, 0.210469f, 1.70641f, -3.58246f, 0.210469f, 1.70641f, 
		-3.58234f, 0.175865f, 1.67399f, -3.58234f, 0.175865f, 1.67399f, 
		-3.58229f, -0.276543f, 1.63436f, -3.58229f, -0.276543f, 1.63436f, 
		-3.58229f, -0.276543f, 1.63436f, -3.58221f, 0.320707f, 1.73020f, 
		-3.58221f, 0.320707f, 1.73020f, -3.58221f, 0.320707f, 1.73020f, 
		-3.58221f, 0.320707f, 1.73020f, -3.58187f, -0.387437f, 1.59053f, 
		-3.58187f, -0.387437f, 1.59053f, -3.58179f, 0.613587f, 1.82627f, 
		-3.58179f, 0.613587f, 1.82627f, -3.58179f, 0.613587f, 1.82627f, 
		-3.58179f, 0.613587f, 1.82627f, -3.58178f, -0.420140f, 1.58404f, 
		-3.58178f, -0.420140f, 1.58404f, -3.58176f, 0.302465f, 1.73909f, 
		-3.58176f, 0.302465f, 1.73909f, -3.58176f, 0.302465f, 1.73909f, 
		-3.58166f, 0.289757f, 1.80085f, -3.58166f, 0.289757f, 1.80085f, 
		-3.58166f, 0.289757f, 1.80085f, -3.58156f, 0.280660f, 1.81521f, 
		-3.58135f, 0.395265f, 1.83060f, -3.58117f, 0.201184f, 1.73892f, 
		-3.58117f, 0.201184f, 1.73892f, -3.58117f, 0.201184f, 1.73892f, 
		-3.58117f, 0.201184f, 1.73892f, -3.58117f, 0.201184f, 1.73892f, 
		-3.58117f, 0.201184f, 1.73892f, -3.58117f, 0.201184f, 1.73892f, 
		-3.58117f, 0.201184f, 1.73892f, -3.58117f, 0.201184f, 1.73892f, 
		-3.58108f, -0.576960f, 1.86970f, -3.58108f, -0.576960f, 1.86970f, 
		-3.58108f, -0.576960f, 1.86970f, -3.58108f, -0.576960f, 1.86970f, 
		-3.58102f, -0.603803f, 1.92574f, -3.58102f, -0.603803f, 1.92574f, 
		-3.58102f, -0.603803f, 1.92574f, -3.58102f, -0.603803f, 1.92574f, 
		-3.58102f, -0.603803f, 1.92574f, -3.58088f, 0.201394f, 1.71085f, 
		-3.58057f, 0.355156f, 1.85863f, -3.58050f, 0.198360f, 1.69944f, 
		-3.58046f, -0.428316f, 1.93766f, -3.58046f, -0.428316f, 1.93766f, 
		-3.58034f, 0.308301f, 1.67285f, -3.58025f, 0.298823f, 1.73401f, 
		-3.58025f, 0.298823f, 1.73401f, -3.58025f, 0.226981f, 1.64596f, 
		-3.58025f, 0.226981f, 1.64596f, -3.58025f, 0.226981f, 1.64596f, 
		-3.57999f, 0.168390f, 1.67285f, -3.57999f, 0.330981f, 1.67267f, 
		-3.57985f, 0.355332f, 1.73548f, -3.57985f, 0.355332f, 1.73548f, 
		-3.57985f, 0.355332f, 1.73548f, -3.57985f, 0.355332f, 1.73548f, 
		-3.57985f, 0.355332f, 1.73548f, -3.57980f, 0.377345f, 1.84764f, 
		-3.57957f, 0.322071f, 1.72458f, -3.57957f, 0.322071f, 1.72458f, 
		-3.57950f, -0.314104f, 1.91813f, -3.57937f, 0.218085f, 1.72137f, 
		-3.57937f, 0.218085f, 1.72137f, -3.57933f, -0.396696f, 1.58741f, 
		-3.57933f, -0.396696f, 1.58741f, -3.57930f, 0.192287f, 1.72798f, 
		-3.57930f, 0.192287f, 1.72798f, -3.57930f, 0.192287f, 1.72798f, 
		-3.57915f, 0.172896f, 1.81757f, -3.57889f, 0.200044f, 1.72864f, 
		-3.57889f, 0.200044f, 1.72864f, -3.57889f, 0.200044f, 1.72864f, 
		-3.57889f, 0.200044f, 1.72864f, -3.57870f, 0.179594f, 1.69809f, 
		-3.57870f, 0.179594f, 1.69809f, -3.57870f, 0.179594f, 1.69809f, 
		-3.57870f, 0.179594f, 1.69809f, -3.57866f, 0.232383f, 1.63677f, 
		-3.57866f, 0.232383f, 1.63677f, -3.57866f, 0.232383f, 1.63677f, 
		-3.57856f, 0.268659f, 1.62914f, -3.57852f, 0.204953f, 1.73826f, 
		-3.57852f, 0.204953f, 1.73826f, -3.57852f, 0.204953f, 1.73826f, 
		-3.57851f, 0.186950f, 1.71827f, -3.57851f, 0.186950f, 1.71827f, 
		-3.57851f, 0.186950f, 1.71827f, -3.57851f, 0.186950f, 1.71827f, 
		-3.57846f, -0.699091f, 1.90441f, -3.57844f, -0.573299f, 1.71200f, 
		-3.57844f, -0.573299f, 1.71200f, -3.57844f, -0.573299f, 1.71200f, 
		-3.57844f, -0.573299f, 1.71200f, -3.57827f, -0.347208f, 1.38997f, 
		-3.57827f, -0.347208f, 1.38997f, -3.57827f, -0.347208f, 1.38997f, 
		-3.57827f, -0.347208f, 1.38997f, -3.57816f, 0.247945f, 1.62445f, 
		-3.57814f, -0.686578f, 1.61200f, -3.57814f, -0.686578f, 1.61200f, 
		-3.57792f, 0.387763f, 1.76184f, -3.57765f, 0.150846f, 1.72997f, 
		-3.57742f, -0.393431f, 1.93511f, -3.57742f, -0.393431f, 1.93511f, 
		-3.57742f, -0.393431f, 1.93511f, -3.57734f, -0.275414f, 1.88103f, 
		-3.57721f, -0.649771f, 1.61287f, -3.57721f, -0.649771f, 1.61287f, 
		-3.57718f, -0.708977f, 1.90057f, -3.57718f, -0.708977f, 1.90057f, 
		-3.57715f, -0.395406f, 1.74298f, -3.57679f, -0.685676f, 1.90308f, 
		-3.57679f, -0.685676f, 1.90308f, -3.57660f, 0.355639f, 1.73361f, 
		-3.57660f, 0.355639f, 1.73361f, -3.57660f, 0.355639f, 1.73361f, 
		-3.57660f, 0.355639f, 1.73361f, -3.57650f, -0.355227f, 1.44342f, 
		-3.57650f, -0.355227f, 1.44342f, -3.57650f, -0.355227f, 1.44342f, 
		-3.57650f, -0.355227f, 1.44342f, -3.57650f, -0.355227f, 1.44342f, 
		-3.57646f, 0.299029f, 1.82865f, -3.57646f, 0.299029f, 1.82865f, 
		-3.57646f, 0.299029f, 1.82865f, -3.57635f, -0.411808f, 1.93741f, 
		-3.57635f, -0.411808f, 1.93741f, -3.57624f, 0.303021f, 1.75490f, 
		-3.57620f, 0.322765f, 1.87310f, -3.57619f, 0.321507f, 1.74397f, 
		-3.57619f, 0.279043f, 1.65263f, -3.57619f, 0.279043f, 1.65263f, 
		-3.57619f, 0.279043f, 1.65263f, -3.57614f, 0.308538f, 1.68779f, 
		-3.57606f, 0.287644f, 1.80456f, -3.57606f, 0.287644f, 1.80456f, 
		-3.57606f, 0.287644f, 1.80456f, -3.57606f, 0.287644f, 1.80456f, 
		-3.57601f, 0.293439f, 1.82808f, -3.57600f, 0.364206f, 1.72726f, 
		-3.57590f, 0.377195f, 1.74729f, -3.57587f, -0.572625f, 1.79937f, 
		-3.57587f, -0.572625f, 1.79937f, -3.57587f, -0.572625f, 1.79937f, 
		-3.57587f, -0.572625f, 1.79937f, -3.57582f, 0.261217f, 1.62297f, 
		-3.57582f, 0.261217f, 1.62297f, -3.57582f, 0.261217f, 1.62297f, 
		-3.57582f, 0.261217f, 1.62297f, -3.57574f, -0.379326f, 1.42577f, 
		-3.57574f, -0.379326f, 1.42577f, -3.57574f, -0.379326f, 1.42577f, 
		-3.57573f, 0.423983f, 1.90628f, -3.57573f, 0.423983f, 1.90628f, 
		-3.57573f, 0.423983f, 1.90628f, -3.57567f, 0.556383f, 1.90028f, 
		-3.57550f, 0.200878f, 1.74377f, -3.57550f, 0.200878f, 1.74377f, 
		-3.57550f, 0.200878f, 1.74377f, -3.57550f, 0.200878f, 1.74377f, 
		-3.57550f, 0.200878f, 1.74377f, -3.57550f, 0.200878f, 1.74377f, 
		-3.57550f, 0.200878f, 1.74377f, -3.57550f, 0.200878f, 1.74377f, 
		-3.57539f, 0.195238f, 1.70179f, -3.57539f, 0.195238f, 1.70179f, 
		-3.57539f, 0.195238f, 1.70179f, -3.57536f, -0.319408f, 1.41395f, 
		-3.57536f, -0.319408f, 1.41395f, -3.57536f, -0.319408f, 1.41395f, 
		-3.57536f, -0.319408f, 1.41395f, -3.57536f, -0.319408f, 1.41395f, 
		-3.57506f, 0.284189f, 1.76157f, -3.57506f, 0.284189f, 1.76157f, 
		-3.57503f, 0.331059f, 1.68890f, -3.57497f, -0.712324f, 1.62098f, 
		-3.57493f, 0.305456f, 1.70875f, -3.57478f, 0.157215f, 1.70427f, 
		-3.57462f, 0.182107f, 1.76085f, -3.57437f, -0.400611f, 1.93678f, 
		-3.57437f, -0.400611f, 1.93678f, -3.57437f, -0.400611f, 1.93678f, 
		-3.57437f, -0.400611f, 1.93678f, -3.57430f, 0.291606f, 1.67010f, 
		-3.57430f, 0.291606f, 1.67010f, -3.57430f, 0.291606f, 1.67010f, 
		-3.57430f, 0.291606f, 1.67010f, -3.57430f, 0.291606f, 1.67010f, 
		-3.57430f, 0.291606f, 1.67010f, -3.57427f, 0.376787f, 1.64107f, 
		-3.57413f, 0.178406f, 1.69575f, -3.57413f, 0.178406f, 1.69575f, 
		-3.57402f, 0.182934f, 1.77563f, -3.57395f, -0.389719f, 1.78541f, 
		-3.57390f, 0.482257f, 1.92335f, -3.57383f, 0.178276f, 1.78783f, 
		-3.57383f, 0.178276f, 1.78783f, -3.57383f, 0.178276f, 1.78783f, 
		-3.57383f, -0.690550f, 1.74783f, -3.57383f, -0.690550f, 1.74783f, 
		-3.57383f, -0.690550f, 1.74783f, -3.57383f, -0.690550f, 1.74783f, 
		-3.57356f, 0.288834f, 1.71958f, -3.57356f, 0.189302f, 1.72287f, 
		-3.57356f, 0.189302f, 1.72287f, -3.57356f, 0.189302f, 1.72287f, 
		-3.57356f, 0.189302f, 1.72287f, -3.57356f, 0.189302f, 1.72287f, 
		-3.57323f, -0.690034f, 1.76294f, -3.57323f, -0.690034f, 1.76294f, 
		-3.57323f, -0.690034f, 1.76294f, -3.57323f, -0.690034f, 1.76294f, 
		-3.57317f, 0.326916f, 1.70962f, -3.57317f, 0.326916f, 1.70962f, 
		-3.57317f, 0.326916f, 1.70962f, -3.57314f, 0.356490f, 1.66952f, 
		-3.57310f, -0.340593f, 1.76661f, -3.57310f, -0.340593f, 1.76661f, 
		-3.57302f, 0.294310f, 1.77298f, -3.57291f, 0.366199f, 1.71987f, 
		-3.57291f, 0.366199f, 1.71987f, -3.57291f, 0.203775f, 1.75055f, 
		-3.57291f, 0.203775f, 1.75055f, -3.57291f, 0.203775f, 1.75055f, 
		-3.57291f, 0.203775f, 1.75055f, -3.57291f, 0.203775f, 1.75055f, 
		-3.57273f, 0.390057f, 1.77993f, -3.57264f, 0.289267f, 1.69423f, 
		-3.57251f, -0.702776f, 1.74127f, -3.57251f, -0.702776f, 1.74127f, 
		-3.57251f, -0.702776f, 1.74127f, -3.57251f, -0.702776f, 1.74127f, 
		-3.57247f, 0.165452f, 1.72460f, -3.57241f, 0.308058f, 1.83347f, 
		-3.57230f, 0.341269f, 1.74579f, -3.57229f, -0.674733f, 1.74601f, 
		-3.57229f, -0.674733f, 1.74601f, -3.57225f, 0.195116f, 1.75364f, 
		-3.57191f, -0.360707f, 1.77130f, -3.57191f, -0.360707f, 1.77130f, 
		-3.57191f, -0.360707f, 1.77130f, -3.57191f, -0.360707f, 1.77130f, 
		-3.57191f, -0.360707f, 1.77130f, -3.57187f, -0.653232f, 1.61607f, 
		-3.57187f, -0.653232f, 1.61607f, -3.57180f, 0.172644f, 1.69586f, 
		-3.57180f, 0.172644f, 1.69586f, -3.57180f, 0.172644f, 1.69586f, 
		-3.57170f, -0.648883f, 1.74083f, -3.57170f, -0.648883f, 1.74083f, 
		-3.57168f, 0.330470f, 1.83368f, -3.57165f, -0.702307f, 1.76925f, 
		-3.57165f, -0.702307f, 1.76925f, -3.57165f, -0.702307f, 1.76925f, 
		-3.57165f, -0.702307f, 1.76925f, -3.57159f, 0.454272f, 1.61428f, 
		-3.57158f, -0.674233f, 1.76483f, -3.57158f, -0.674233f, 1.76483f, 
		-3.57157f, 0.294030f, 1.76417f, -3.57157f, 0.294030f, 1.76417f, 
		-3.57150f, 0.218280f, 1.66891f, -3.57148f, 0.385548f, 1.76381f, 
		-3.57117f, 0.183610f, 1.71704f, -3.57117f, 0.183610f, 1.71704f, 
		-3.57117f, 0.183610f, 1.71704f, -3.57117f, 0.183610f, 1.71704f, 
		-3.57117f, 0.183610f, 1.71704f, -3.57111f, -0.364545f, 1.76202f, 
		-3.57111f, -0.364545f, 1.76202f, -3.57111f, -0.364545f, 1.76202f, 
		-3.57111f, 0.309815f, 1.83628f, -3.57105f, -0.686816f, 1.89937f, 
		-3.57105f, -0.686816f, 1.89937f, -3.57094f, -0.588782f, 1.94763f, 
		-3.57094f, -0.588782f, 1.94763f, -3.57094f, -0.588782f, 1.94763f, 
		-3.57094f, -0.588782f, 1.94763f, -3.57071f, -0.648369f, 1.77011f, 
		-3.57071f, -0.648369f, 1.77011f, -3.57053f, 0.179370f, 1.72022f, 
		-3.57053f, 0.179370f, 1.72022f, -3.57048f, -0.650182f, 1.89836f, 
		-3.57048f, -0.650182f, 1.89836f, -3.57040f, 0.293436f, 1.81987f, 
		-3.57040f, 0.293436f, 1.81987f, -3.57040f, 0.293436f, 1.81987f, 
		-3.57040f, 0.293436f, 1.81987f, -3.57040f, -0.287967f, 1.90690f, 
		-3.57040f, -0.287967f, 1.90690f, -3.57033f, 0.293030f, 1.79494f, 
		-3.57029f, 0.299230f, 1.82731f, -3.57029f, 0.299230f, 1.82731f, 
		-3.57021f, 0.194360f, 1.69535f, -3.57021f, 0.194360f, 1.69535f, 
		-3.57021f, 0.194360f, 1.69535f, -3.57016f, 0.685536f, 1.75667f, 
		-3.57016f, 0.685536f, 1.75667f, -3.57016f, 0.685536f, 1.75667f, 
		-3.56997f, 0.275460f, 1.71616f, -3.56986f, -0.601687f, 1.93462f, 
		-3.56986f, -0.601687f, 1.93462f, -3.56986f, -0.601687f, 1.93462f, 
		-3.56971f, 0.379294f, 1.73982f, -3.56971f, 0.379294f, 1.73982f, 
		-3.56971f, 0.379294f, 1.73982f, -3.56963f, 0.204717f, 1.76253f, 
		-3.56944f, 0.377460f, 1.76204f, -3.56944f, 0.377460f, 1.76204f, 
		-3.56944f, 0.377460f, 1.76204f, -3.56929f, 0.228956f, 1.63758f, 
		-3.56929f, 0.228956f, 1.63758f, -3.56924f, -0.330437f, 1.44631f, 
		-3.56924f, -0.330437f, 1.44631f, -3.56924f, -0.330437f, 1.44631f, 
		-3.56924f, -0.330437f, 1.44631f, -3.56916f, 0.354947f, 1.71214f, 
		-3.56916f, 0.354947f, 1.71214f, -3.56902f, 0.278189f, 1.75928f, 
		-3.56884f, 0.276857f, 1.69726f, -3.56884f, 0.276857f, 1.69726f, 
		-3.56884f, 0.276857f, 1.69726f, -3.56884f, 0.276857f, 1.69726f, 
		-3.56884f, 0.276857f, 1.69726f, -3.56884f, 0.276857f, 1.69726f, 
		-3.56884f, 0.276857f, 1.69726f, -3.56878f, -0.603405f, 1.93512f, 
		-3.56878f, -0.603405f, 1.93512f, -3.56878f, 0.290183f, 1.75986f, 
		-3.56878f, 0.290183f, 1.75986f, -3.56850f, 0.386490f, 1.79806f, 
		-3.56817f, -0.712408f, 1.89028f, -3.56813f, 0.401626f, 1.62711f, 
		-3.56799f, -0.327264f, 1.76668f, -3.56799f, -0.327264f, 1.76668f, 
		-3.56799f, -0.327264f, 1.76668f, -3.56799f, -0.327264f, 1.76668f, 
		-3.56771f, 0.200390f, 1.68674f, -3.56771f, -0.605126f, 1.93563f, 
		-3.56771f, -0.605126f, 1.93563f, -3.56771f, -0.605126f, 1.93563f, 
		-3.56771f, -0.605126f, 1.93563f, -3.56735f, 0.307317f, 1.85414f, 
		-3.56732f, 0.328195f, 1.83901f, -3.56722f, 0.353395f, 1.69915f, 
		-3.56722f, -0.549189f, 1.76273f, -3.56717f, -0.676550f, 1.74015f, 
		-3.56717f, -0.676550f, 1.74015f, -3.56714f, 0.223289f, 1.66689f, 
		-3.56714f, 0.223289f, 1.66689f, -3.56714f, 0.223289f, 1.66689f, 
		-3.56714f, 0.223289f, 1.66689f, -3.56660f, -0.652362f, 1.73532f, 
		-3.56660f, -0.652362f, 1.73532f, -3.56646f, 0.294461f, 1.79229f, 
		-3.56646f, 0.294461f, 1.79229f, -3.56632f, 0.356920f, 1.75910f, 
		-3.56622f, -0.676112f, 1.77049f, -3.56622f, -0.676112f, 1.77049f, 
		-3.56610f, -0.339566f, 1.77622f, -3.56610f, -0.339566f, 1.77622f, 
		-3.56610f, -0.339566f, 1.77622f, -3.56565f, 0.377422f, 1.81447f, 
		-3.56563f, 0.379090f, 1.79762f, -3.56561f, -0.357490f, 1.38669f, 
		-3.56561f, -0.357490f, 1.38669f, -3.56561f, -0.357490f, 1.38669f, 
		-3.56561f, -0.357490f, 1.38669f, -3.56561f, -0.357490f, 1.38669f, 
		-3.56561f, -0.357490f, 1.38669f, -3.56542f, 0.378913f, 1.76220f, 
		-3.56542f, 0.378913f, 1.76220f, -3.56542f, 0.378913f, 1.76220f, 
		-3.56542f, 0.378913f, 1.76220f, -3.56539f, -0.651924f, 1.77542f, 
		-3.56539f, -0.651924f, 1.77542f, -3.56539f, -0.323979f, 1.42671f, 
		-3.56539f, -0.323979f, 1.42671f, -3.56539f, -0.323979f, 1.42671f, 
		-3.56539f, -0.323979f, 1.42671f, -3.56539f, -0.323979f, 1.42671f, 
		-3.56526f, -0.653597f, 1.89496f, -3.56526f, -0.653597f, 1.89496f, 
		-3.56521f, 0.199998f, 1.70344f, -3.56513f, 0.217364f, 1.75176f, 
		-3.56503f, 0.346778f, 1.83600f, -3.56466f, 0.306878f, 1.82635f, 
		-3.56466f, 0.306878f, 1.82635f, -3.56466f, 0.306878f, 1.82635f, 
		-3.56466f, 0.306878f, 1.82635f, -3.56466f, 0.306878f, 1.82635f, 
		-3.56445f, 0.363740f, 1.82755f, -3.56432f, -0.320615f, 1.78110f, 
		-3.56432f, -0.320615f, 1.78110f, -3.56429f, 0.274183f, 1.75515f, 
		-3.56429f, 0.274183f, 1.75515f, -3.56429f, 0.274183f, 1.75515f, 
		-3.56408f, 0.281664f, 1.84432f, -3.56367f, 0.335474f, 1.84894f, 
		-3.56345f, -0.342850f, 1.75756f, -3.56341f, -0.475189f, 1.73866f, 
		-3.56341f, -0.475189f, 1.73866f, -3.56340f, 0.386867f, 1.73757f, 
		-3.56340f, 0.386867f, 1.73757f, -3.56335f, -0.573171f, 1.63007f, 
		-3.56335f, -0.573171f, 1.63007f, -3.56333f, -0.568742f, 1.95281f, 
		-3.56329f, 0.357436f, 1.82170f, -3.56320f, 0.270323f, 1.63399f, 
		-3.56320f, 0.270323f, 1.63399f, -3.56320f, 0.270323f, 1.63399f, 
		-3.56315f, 0.279365f, 1.68356f, -3.56315f, 0.279365f, 1.68356f, 
		-3.56315f, 0.279365f, 1.68356f, -3.56308f, 0.415056f, 1.89720f, 
		-3.56263f, 0.259935f, 1.71858f, -3.56263f, 0.259935f, 1.71858f, 
		-3.56263f, 0.259935f, 1.71858f, -3.56263f, 0.259935f, 1.71858f, 
		-3.56263f, 0.259935f, 1.71858f, -3.56247f, -0.443681f, 1.73901f, 
		-3.56243f, -0.621008f, 1.73228f, -3.56241f, 0.357832f, 1.77114f, 
		-3.56229f, 0.214219f, 1.71680f, -3.56214f, 0.384414f, 1.76550f, 
		-3.56209f, 0.389942f, 1.77060f, -3.56209f, 0.389942f, 1.77060f, 
		-3.56209f, 0.389942f, 1.77060f, -3.56193f, 0.370079f, 1.79247f, 
		-3.56193f, 0.370079f, 1.79247f, -3.56189f, 0.289413f, 1.79401f, 
		-3.56189f, 0.289413f, 1.79401f, -3.56186f, 0.217530f, 1.69750f, 
		-3.56186f, 0.367045f, 1.78191f, -3.56185f, 0.337090f, 1.76433f, 
		-3.56177f, -0.422810f, 1.73925f, -3.56177f, -0.422810f, 1.73925f, 
		-3.56175f, -0.711095f, 1.72629f, -3.56167f, 0.311380f, 1.80626f, 
		-3.56150f, 0.322467f, 1.76774f, -3.56149f, 0.379637f, 1.66418f, 
		-3.56128f, 0.322849f, 1.82701f, -3.56128f, 0.322849f, 1.82701f, 
		-3.56128f, 0.322849f, 1.82701f, -3.56113f, 0.331667f, 1.83943f, 
		-3.56111f, 0.370996f, 1.85811f, -3.56106f, 0.298754f, 1.81091f, 
		-3.56106f, 0.298754f, 1.81091f, -3.56100f, -0.620480f, 1.77837f, 
		-3.56083f, -0.399289f, 1.74012f, -3.56083f, -0.399289f, 1.74012f, 
		-3.56083f, -0.399289f, 1.74012f, -3.56080f, -0.571115f, 1.72709f, 
		-3.56080f, -0.571115f, 1.72709f, -3.56080f, -0.571115f, 1.72709f, 
		-3.56061f, -0.560232f, 1.73315f, -3.56058f, 0.280432f, 1.66383f, 
		-3.56058f, 0.280432f, 1.66383f, -3.56058f, 0.280432f, 1.66383f, 
		-3.56057f, -0.571935f, 1.56902f, -3.56057f, -0.571935f, 1.56902f, 
		-3.56044f, 0.243207f, 1.63123f, -3.56040f, -0.378902f, 1.93527f, 
		-3.56028f, -0.710741f, 1.78351f, -3.56023f, -0.589747f, 1.73380f, 
		-3.56015f, -0.406264f, 1.73919f, -3.56015f, -0.406264f, 1.73919f, 
		-3.56002f, 0.314694f, 1.78326f, -3.56001f, 0.222827f, 1.76298f, 
		-3.55986f, 0.226507f, 1.69052f, -3.55986f, 0.226507f, 1.69052f, 
		-3.55986f, 0.226507f, 1.69052f, -3.55965f, 0.426210f, 1.89631f, 
		-3.55965f, 0.426210f, 1.89631f, -3.55965f, 0.426210f, 1.89631f, 
		-3.55965f, 0.426210f, 1.89631f, -3.55965f, 0.426210f, 1.89631f, 
		-3.55965f, 0.426210f, 1.89631f, -3.55965f, 0.426210f, 1.89631f, 
		-3.55965f, -0.362694f, 1.77554f, -3.55965f, -0.362694f, 1.77554f, 
		-3.55965f, -0.362694f, 1.77554f, -3.55965f, -0.362694f, 1.77554f, 
		-3.55965f, -0.362694f, 1.77554f, -3.55952f, 0.320255f, 1.80505f, 
		-3.55944f, 0.262217f, 1.62815f, -3.55944f, 0.262217f, 1.62815f, 
		-3.55935f, 0.311616f, 1.83464f, -3.55930f, 0.308730f, 1.82756f, 
		-3.55930f, 0.308730f, 1.82756f, -3.55930f, 0.308730f, 1.82756f, 
		-3.55930f, 0.308730f, 1.82756f, -3.55925f, 0.221556f, 1.66326f, 
		-3.55915f, 0.493677f, 1.86251f, -3.55913f, -0.381862f, 1.42387f, 
		-3.55913f, -0.381862f, 1.42387f, -3.55913f, -0.381862f, 1.42387f, 
		-3.55913f, -0.381862f, 1.42387f, -3.55908f, -0.380555f, 1.39778f, 
		-3.55908f, -0.380555f, 1.39778f, -3.55908f, -0.380555f, 1.39778f, 
		-3.55908f, -0.380555f, 1.39778f, -3.55907f, -0.612459f, 1.73734f, 
		-3.55907f, -0.612459f, 1.73734f, -3.55890f, -0.570298f, 1.78372f, 
		-3.55890f, -0.570298f, 1.78372f, -3.55890f, -0.570298f, 1.78372f, 
		-3.55875f, 0.333728f, 1.81560f, -3.55873f, -0.311576f, 1.79643f, 
		-3.55873f, -0.311576f, 1.79643f, -3.55873f, -0.311576f, 1.79643f, 
		-3.55858f, -0.322502f, 1.75378f, -3.55858f, -0.322502f, 1.75378f, 
		-3.55839f, -0.527096f, 1.76589f, -3.55839f, -0.338152f, 1.78623f, 
		-3.55839f, -0.338152f, 1.78623f, -3.55816f, 0.291055f, 1.82731f, 
		-3.55816f, 0.291055f, 1.82731f, -3.55814f, 0.267249f, 1.70336f, 
		-3.55814f, 0.267249f, 1.70336f, -3.55814f, 0.267249f, 1.70336f, 
		-3.55814f, 0.267249f, 1.70336f, -3.55814f, 0.267249f, 1.70336f, 
		-3.55811f, 0.355979f, 1.80398f, -3.55797f, -0.393088f, 1.78521f, 
		-3.55796f, 0.287798f, 1.79648f, -3.55796f, 0.287798f, 1.79648f, 
		-3.55781f, -0.369142f, 1.75687f, -3.55781f, -0.369142f, 1.75687f, 
		-3.55781f, -0.369142f, 1.75687f, -3.55781f, -0.369142f, 1.75687f, 
		-3.55781f, -0.369142f, 1.75687f, -3.55756f, -0.573705f, 1.88069f, 
		-3.55756f, -0.573705f, 1.88069f, -3.55740f, 0.370324f, 1.79263f, 
		-3.55740f, 0.370324f, 1.79263f, -3.55728f, -0.296049f, 1.82673f, 
		-3.55717f, -0.519877f, 1.73715f, -3.55717f, -0.519877f, 1.73715f, 
		-3.55700f, -0.590921f, 1.58002f, -3.55700f, -0.590921f, 1.58002f, 
		-3.55690f, 0.293990f, 1.81823f, -3.55690f, 0.293990f, 1.81823f, 
		-3.55682f, 0.349209f, 1.79789f, -3.55676f, 0.292282f, 1.79278f, 
		-3.55676f, 0.292282f, 1.79278f, -3.55669f, 0.296563f, 1.81256f, 
		-3.55669f, 0.296563f, 1.81256f, -3.55669f, 0.296563f, 1.81256f, 
		-3.55669f, 0.296563f, 1.81256f, -3.55645f, 0.322102f, 1.82636f, 
		-3.55645f, 0.322102f, 1.82636f, -3.55641f, 0.235344f, 1.73997f, 
		-3.55624f, 0.247122f, 1.74208f, -3.55624f, 0.247122f, 1.74208f, 
		-3.55624f, 0.247122f, 1.74208f, -3.55621f, -0.607991f, 1.62442f, 
		-3.55616f, 0.338101f, 1.78465f, -3.55602f, -0.612454f, 1.92238f, 
		-3.55587f, 0.372201f, 1.72893f, -3.55587f, 0.372201f, 1.72893f, 
		-3.55572f, -0.548723f, 1.95802f, -3.55546f, 0.233799f, 1.72684f, 
		-3.55546f, 0.233799f, 1.72684f, -3.55546f, 0.233799f, 1.72684f, 
		-3.55520f, -0.279884f, 1.85754f, -3.55520f, -0.279884f, 1.85754f, 
		-3.55520f, -0.279884f, 1.85754f, -3.55519f, 0.394590f, 1.77409f, 
		-3.55519f, 0.394590f, 1.77409f, -3.55507f, -0.583100f, 1.76580f, 
		-3.55492f, 0.374634f, 1.79544f, -3.55492f, 0.361675f, 1.83788f, 
		-3.55492f, 0.361675f, 1.83788f, -3.55478f, 0.246768f, 1.72529f, 
		-3.55478f, 0.246768f, 1.72529f, -3.55478f, 0.246768f, 1.72529f, 
		-3.55476f, 0.215133f, 1.77992f, -3.55468f, -0.596439f, 1.58073f, 
		-3.55464f, -0.593268f, 1.57944f, -3.55464f, -0.593268f, 1.57944f, 
		-3.55464f, -0.593268f, 1.57944f, -3.55464f, -0.593268f, 1.57944f, 
		-3.55459f, -0.505554f, 1.76983f, -3.55443f, -0.597791f, 1.58150f, 
		-3.55443f, -0.597791f, 1.58150f, -3.55441f, -0.607828f, 1.76476f, 
		-3.55441f, -0.607828f, 1.76476f, -3.55427f, -0.617385f, 1.73441f, 
		-3.55426f, 0.381782f, 1.80154f, -3.55426f, 0.381782f, 1.80154f, 
		-3.55426f, 0.381782f, 1.80154f, -3.55426f, 0.381782f, 1.80154f, 
		-3.55426f, 0.381782f, 1.80154f, -3.55426f, 0.381782f, 1.80154f, 
		-3.55426f, 0.381782f, 1.80154f, -3.55417f, 0.532729f, 1.66078f, 
		-3.55368f, 0.357817f, 1.82887f, -3.55368f, 0.357817f, 1.82887f, 
		-3.55368f, 0.357817f, 1.82887f, -3.55309f, -0.605269f, 1.72854f, 
		-3.55309f, -0.605269f, 1.72854f, -3.55309f, -0.605269f, 1.72854f, 
		-3.55309f, -0.605269f, 1.72854f, -3.55309f, -0.605269f, 1.72854f, 
		-3.55278f, -0.367741f, 1.42385f, -3.55278f, -0.367741f, 1.42385f, 
		-3.55278f, -0.367741f, 1.42385f, -3.55260f, -0.344026f, 1.74806f, 
		-3.55260f, -0.344026f, 1.74806f, -3.55260f, -0.344026f, 1.74806f, 
		-3.55256f, 0.344083f, 1.81601f, -3.55256f, 0.344083f, 1.81601f, 
		-3.55256f, 0.344083f, 1.81601f, -3.55256f, 0.344083f, 1.81601f, 
		-3.55256f, 0.344083f, 1.81601f, -3.55237f, 0.376793f, 1.68896f, 
		-3.55230f, 0.355936f, 1.82703f, -3.55220f, 0.233852f, 1.76202f, 
		-3.55193f, 0.285933f, 1.80495f, -3.55193f, 0.285933f, 1.80495f, 
		-3.55193f, 0.285933f, 1.80495f, -3.55190f, 0.231965f, 1.69529f, 
		-3.55190f, 0.231965f, 1.69529f, -3.55190f, 0.231965f, 1.69529f, 
		-3.55145f, -0.604724f, 1.78179f, -3.55145f, -0.604724f, 1.78179f, 
		-3.55145f, -0.604724f, 1.78179f, -3.55145f, -0.604724f, 1.78179f, 
		-3.55145f, -0.604724f, 1.78179f, -3.55130f, 0.409729f, 1.65950f, 
		-3.55126f, -0.519617f, 1.95678f, -3.55124f, -0.275788f, 1.68322f, 
		-3.55124f, -0.275788f, 1.68322f, -3.55124f, -0.275788f, 1.68322f, 
		-3.55124f, -0.275788f, 1.68322f, -3.55124f, -0.275788f, 1.68322f, 
		-3.55055f, 0.257339f, 1.71421f, -3.55055f, 0.257339f, 1.71421f, 
		-3.55055f, 0.257339f, 1.71421f, -3.55048f, -0.552672f, 1.67510f, 
		-3.55013f, -0.290861f, 1.62540f, -3.55013f, -0.290861f, 1.62540f, 
		-3.55013f, -0.290861f, 1.62540f, -3.55013f, -0.290861f, 1.62540f, 
		-3.55007f, -0.608455f, 1.88596f, -3.54989f, -0.297325f, 1.71157f, 
		-3.54985f, 0.524865f, 1.63801f, -3.54975f, -0.552705f, 1.56213f, 
		-3.54965f, -0.422007f, 1.94507f, -3.54963f, -0.612386f, 1.76816f, 
		-3.54961f, 0.242560f, 1.71617f, -3.54961f, 0.242560f, 1.71617f, 
		-3.54961f, 0.242560f, 1.71617f, -3.54961f, 0.242560f, 1.71617f, 
		-3.54961f, 0.242560f, 1.71617f, -3.54961f, 0.242560f, 1.71617f, 
		-3.54961f, 0.242560f, 1.71617f, -3.54961f, 0.242560f, 1.71617f, 
		-3.54958f, 0.376503f, 1.70969f, -3.54955f, 0.555260f, 1.83609f, 
		-3.54942f, 0.385720f, 1.80619f, -3.54942f, 0.385720f, 1.80619f, 
		-3.54942f, 0.385720f, 1.80619f, -3.54942f, 0.385720f, 1.80619f, 
		-3.54921f, -0.362390f, 1.40335f, -3.54921f, -0.362390f, 1.40335f, 
		-3.54921f, -0.362390f, 1.40335f, -3.54921f, -0.362390f, 1.40335f, 
		-3.54921f, -0.362390f, 1.40335f, -3.54919f, -0.283649f, 1.65391f, 
		-3.54884f, 0.350271f, 1.82277f, -3.54884f, 0.350271f, 1.82277f, 
		-3.54884f, 0.350271f, 1.82277f, -3.54884f, 0.350271f, 1.82277f, 
		-3.54884f, 0.350271f, 1.82277f, -3.54884f, 0.350271f, 1.82277f, 
		-3.54854f, 0.274278f, 1.81321f, -3.54854f, 0.274278f, 1.81321f, 
		-3.54854f, 0.274278f, 1.81321f, -3.54842f, 0.223912f, 1.65828f, 
		-3.54842f, 0.223912f, 1.65828f, -3.54842f, 0.223912f, 1.65828f, 
		-3.54842f, 0.223912f, 1.65828f, -3.54842f, 0.223912f, 1.65828f, 
		-3.54842f, 0.223912f, 1.65828f, -3.54832f, 0.343939f, 1.81759f, 
		-3.54832f, 0.343939f, 1.81759f, -3.54806f, -0.317143f, 1.73986f, 
		-3.54806f, -0.317143f, 1.73986f, -3.54806f, -0.317143f, 1.73986f, 
		-3.54796f, -0.610478f, 1.67494f, -3.54796f, -0.610478f, 1.67494f, 
		-3.54786f, 0.478984f, 1.94916f, -3.54786f, 0.478984f, 1.94916f, 
		-3.54786f, 0.478984f, 1.94916f, -3.54786f, 0.478984f, 1.94916f, 
		-3.54760f, -0.589411f, 1.62429f, -3.54733f, -0.605776f, 1.59311f, 
		-3.54658f, 0.552059f, 1.79726f, -3.54658f, 0.552059f, 1.79726f, 
		-3.54658f, 0.552059f, 1.79726f, -3.54658f, 0.552059f, 1.79726f, 
		-3.54651f, -0.552511f, 1.83605f, -3.54640f, 0.228971f, 1.68764f, 
		-3.54640f, 0.228971f, 1.68764f, -3.54640f, 0.228971f, 1.68764f, 
		-3.54640f, 0.228971f, 1.68764f, -3.54598f, -0.470581f, 1.95251f, 
		-3.54590f, 0.258735f, 1.70772f, -3.54586f, 0.268405f, 1.69991f, 
		-3.54571f, -0.584959f, 1.73091f, -3.54547f, 0.460053f, 1.65682f, 
		-3.54545f, 0.234844f, 1.80491f, -3.54521f, -0.551937f, 1.69025f, 
		-3.54447f, 0.249166f, 1.78024f, -3.54447f, 0.249166f, 1.78024f, 
		-3.54447f, 0.249166f, 1.78024f, -3.54434f, -0.581739f, 1.67554f, 
		-3.54434f, -0.581739f, 1.67554f, -3.54434f, -0.581739f, 1.67554f, 
		-3.54426f, 0.489276f, 1.87647f, -3.54412f, -0.584300f, 1.77924f, 
		-3.54412f, -0.610395f, 1.83382f, -3.54412f, -0.610395f, 1.83382f, 
		-3.54378f, 0.380781f, 1.81888f, -3.54378f, 0.380781f, 1.81888f, 
		-3.54378f, 0.380781f, 1.81888f, -3.54373f, 0.271578f, 1.65613f, 
		-3.54373f, 0.271578f, 1.65613f, -3.54373f, 0.271578f, 1.65613f, 
		-3.54371f, 0.409704f, 1.84882f, -3.54347f, -0.552399f, 1.65935f, 
		-3.54347f, -0.552399f, 1.65935f, -3.54347f, -0.552399f, 1.65935f, 
		-3.54344f, -0.364096f, 1.93540f, -3.54308f, -0.609741f, 1.67544f, 
		-3.54308f, -0.609741f, 1.67544f, -3.54296f, -0.609394f, 1.65634f, 
		-3.54296f, -0.609394f, 1.65634f, -3.54296f, -0.609394f, 1.65634f, 
		-3.54216f, -0.349064f, 1.58826f, -3.54214f, 0.247794f, 1.70268f, 
		-3.54211f, -0.533123f, 1.55685f, -3.54188f, 0.542906f, 1.73289f, 
		-3.54179f, 0.381154f, 1.78047f, -3.54179f, 0.381154f, 1.78047f, 
		-3.54179f, 0.381154f, 1.78047f, -3.54179f, 0.381154f, 1.78047f, 
		-3.54155f, -0.293619f, 1.88660f, -3.54147f, -0.589872f, 1.88582f, 
		-3.54139f, -0.445634f, 1.57019f, -3.54139f, -0.445634f, 1.57019f, 
		-3.54130f, -0.550567f, 1.82092f, -3.54089f, -0.608214f, 1.69542f, 
		-3.54089f, -0.608214f, 1.69542f, -3.54066f, 0.242946f, 1.65473f, 
		-3.54065f, 0.441672f, 1.89749f, -3.54065f, 0.441672f, 1.89749f, 
		-3.54065f, 0.441672f, 1.89749f, -3.54065f, 0.441672f, 1.89749f, 
		-3.54065f, 0.441672f, 1.89749f, -3.54044f, -0.581504f, 1.83324f, 
		-3.54044f, -0.581504f, 1.83324f, -3.54044f, -0.581504f, 1.83324f, 
		-3.54029f, -0.662613f, 1.60126f, -3.54029f, -0.662613f, 1.60126f, 
		-3.54029f, -0.662613f, 1.60126f, -3.53998f, 0.270004f, 1.68492f, 
		-3.53998f, 0.270004f, 1.68492f, -3.53998f, 0.270004f, 1.68492f, 
		-3.53993f, 0.642389f, 1.78442f, -3.53993f, 0.642389f, 1.78442f, 
		-3.53993f, 0.642389f, 1.78442f, -3.53993f, 0.642389f, 1.78442f, 
		-3.53993f, 0.642389f, 1.78442f, -3.53991f, -0.578475f, 1.69075f, 
		-3.53963f, 0.261216f, 1.70209f, -3.53963f, 0.261216f, 1.70209f, 
		-3.53963f, 0.261216f, 1.70209f, -3.53963f, 0.261216f, 1.70209f, 
		-3.53946f, -0.552876f, 1.85224f, -3.53946f, -0.552876f, 1.85224f, 
		-3.53927f, -0.609645f, 1.83318f, -3.53927f, -0.609645f, 1.83318f, 
		-3.53908f, -0.608997f, 1.65955f, -3.53908f, -0.608997f, 1.65955f, 
		-3.53908f, -0.608997f, 1.65955f, -3.53884f, 0.262072f, 1.65390f, 
		-3.53884f, 0.262072f, 1.65390f, -3.53884f, 0.262072f, 1.65390f, 
		-3.53884f, 0.262072f, 1.65390f, -3.53884f, 0.262072f, 1.65390f, 
		-3.53884f, 0.262072f, 1.65390f, -3.53884f, 0.262072f, 1.65390f, 
		-3.53847f, -0.609862f, 1.85261f, -3.53847f, -0.609862f, 1.85261f, 
		-3.53847f, -0.609862f, 1.85261f, -3.53843f, -0.586125f, 1.65900f, 
		-3.53843f, -0.586125f, 1.65900f, -3.53843f, -0.586125f, 1.65900f, 
		-3.53843f, -0.586125f, 1.65900f, -3.53843f, -0.586125f, 1.65900f, 
		-3.53843f, -0.586125f, 1.65900f, -3.53789f, 0.633897f, 1.57683f, 
		-3.53789f, 0.633897f, 1.57683f, -3.53789f, 0.633897f, 1.57683f, 
		-3.53782f, 0.401636f, 1.69342f, -3.53772f, -0.665280f, 1.60519f, 
		-3.53772f, -0.665280f, 1.60519f, -3.53772f, -0.665280f, 1.60519f, 
		-3.53770f, -0.607517f, 1.81354f, -3.53770f, -0.607517f, 1.81354f, 
		-3.53753f, -0.608606f, 1.69230f, -3.53753f, -0.608606f, 1.69230f, 
		-3.53667f, 0.456351f, 1.91885f, -3.53667f, 0.456351f, 1.91885f, 
		-3.53656f, 0.477966f, 1.84754f, -3.53656f, 0.477966f, 1.84754f, 
		-3.53618f, 0.391987f, 1.77112f, -3.53615f, -0.577431f, 1.81823f, 
		-3.53596f, -0.607059f, 1.70344f, -3.53596f, -0.607059f, 1.70344f, 
		-3.53596f, -0.607059f, 1.70344f, -3.53583f, 0.243207f, 1.68506f, 
		-3.53575f, 0.539024f, 1.89786f, -3.53575f, 0.539024f, 1.89786f, 
		-3.53575f, 0.539024f, 1.89786f, -3.53495f, -0.377095f, 1.75396f, 
		-3.53495f, -0.377095f, 1.75396f, -3.53495f, -0.377095f, 1.75396f, 
		-3.53484f, -0.337904f, 1.92560f, -3.53472f, -0.609380f, 1.84927f, 
		-3.53472f, -0.609380f, 1.84927f, -3.53472f, -0.609380f, 1.84927f, 
		-3.53446f, 0.514524f, 1.68500f, -3.53446f, 0.514524f, 1.68500f, 
		-3.53446f, 0.514524f, 1.68500f, -3.53446f, 0.514524f, 1.68500f, 
		-3.53422f, -0.608000f, 1.81645f, -3.53422f, -0.608000f, 1.81645f, 
		-3.53417f, -0.368221f, 1.77490f, -3.53400f, -0.583153f, 1.84924f, 
		-3.53400f, -0.583153f, 1.84924f, -3.53400f, -0.583153f, 1.84924f, 
		-3.53400f, -0.583153f, 1.84924f, -3.53400f, -0.583153f, 1.84924f, 
		-3.53400f, -0.583153f, 1.84924f, -3.53303f, -0.606229f, 1.80548f, 
		-3.53303f, -0.606229f, 1.80548f, -3.53303f, -0.606229f, 1.80548f, 
		-3.53284f, 0.262217f, 1.68632f, -3.53284f, 0.262217f, 1.68632f, 
		-3.53265f, -0.662744f, 1.90857f, -3.53265f, -0.662744f, 1.90857f, 
		-3.53265f, -0.662744f, 1.90857f, -3.53226f, -0.607640f, 1.65338f, 
		-3.53226f, -0.607640f, 1.65338f, -3.53194f, -0.607486f, 1.70019f, 
		-3.53194f, -0.607486f, 1.70019f, -3.53194f, -0.607486f, 1.70019f, 
		-3.53179f, -0.606700f, 1.64908f, -3.53179f, -0.606700f, 1.64908f, 
		-3.53127f, -0.550087f, 1.70104f, -3.53127f, -0.550087f, 1.70104f, 
		-3.53039f, 0.454287f, 1.70442f, -3.53025f, -0.665387f, 1.90451f, 
		-3.53025f, -0.665387f, 1.90451f, -3.53025f, -0.665387f, 1.90451f, 
		-3.52966f, 0.561039f, 1.73442f, -3.52966f, 0.561039f, 1.73442f, 
		-3.52966f, 0.561039f, 1.73442f, -3.52966f, 0.561039f, 1.73442f, 
		-3.52966f, 0.561039f, 1.73442f, -3.52902f, -0.384315f, 1.94276f, 
		-3.52898f, -0.601167f, 1.98145f, -3.52898f, -0.601167f, 1.98145f, 
		-3.52898f, -0.601167f, 1.98145f, -3.52891f, -0.606724f, 1.80856f, 
		-3.52891f, -0.606724f, 1.80856f, -3.52891f, -0.606724f, 1.80856f, 
		-3.52886f, -0.291535f, 1.85799f, -3.52873f, -0.309767f, 1.91572f, 
		-3.52873f, -0.309767f, 1.91572f, -3.52837f, 0.461057f, 1.80203f, 
		-3.52818f, 0.512368f, 1.84412f, -3.52818f, 0.512368f, 1.84412f, 
		-3.52818f, 0.512368f, 1.84412f, -3.52759f, -0.608096f, 1.85548f, 
		-3.52759f, -0.608096f, 1.85548f, -3.52754f, -0.612830f, 1.96591f, 
		-3.52754f, -0.612830f, 1.96591f, -3.52754f, -0.612830f, 1.96591f, 
		-3.52754f, -0.612830f, 1.96591f, -3.52754f, -0.608820f, 1.97146f, 
		-3.52754f, -0.608820f, 1.97146f, -3.52754f, -0.548156f, 1.80999f, 
		-3.52754f, -0.548156f, 1.80999f, -3.52706f, -0.549435f, 1.65098f, 
		-3.52706f, -0.549435f, 1.65098f, -3.52704f, -0.301581f, 1.82636f, 
		-3.52704f, -0.607272f, 1.85987f, -3.52704f, -0.607272f, 1.85987f, 
		-3.52701f, -0.315820f, 1.79537f, -3.52701f, -0.315820f, 1.79537f, 
		-3.52701f, -0.315820f, 1.79537f, -3.52701f, -0.315820f, 1.79537f, 
		-3.52701f, -0.315820f, 1.79537f, -3.52701f, -0.315820f, 1.79537f, 
		-3.52695f, -0.392606f, 1.75306f, -3.52695f, -0.392606f, 1.75306f, 
		-3.52695f, -0.392606f, 1.75306f, -3.52536f, -0.583595f, 1.70113f, 
		-3.52536f, -0.583595f, 1.70113f, -3.52536f, -0.583595f, 1.70113f, 
		-3.52536f, -0.583595f, 1.70113f, -3.52531f, -0.701287f, 1.59035f, 
		-3.52505f, -0.384319f, 1.77298f, -3.52466f, -0.614082f, 1.96598f, 
		-3.52466f, -0.614082f, 1.96598f, -3.52466f, -0.614082f, 1.96598f, 
		-3.52462f, -0.461810f, 1.75244f, -3.52434f, -0.709353f, 1.59363f, 
		-3.52434f, -0.709353f, 1.59363f, -3.52434f, -0.689709f, 1.59362f, 
		-3.52434f, -0.689709f, 1.59362f, -3.52434f, -0.689709f, 1.59362f, 
		-3.52430f, -0.421900f, 1.75265f, -3.52411f, -0.569148f, 1.65118f, 
		-3.52411f, -0.569148f, 1.65118f, -3.52333f, -0.409423f, 1.94884f, 
		-3.52327f, -0.586631f, 1.64952f, -3.52327f, -0.586631f, 1.64952f, 
		-3.52327f, -0.586631f, 1.64952f, -3.52327f, -0.586631f, 1.64952f, 
		-3.52294f, -0.690658f, 1.59805f, -3.52294f, -0.690658f, 1.59805f, 
		-3.52294f, -0.690658f, 1.59805f, -3.52280f, -0.551039f, 1.85997f, 
		-3.52280f, -0.551039f, 1.85997f, -3.52272f, -0.351546f, 1.74615f, 
		-3.52264f, -0.290671f, 1.67991f, -3.52264f, -0.290671f, 1.67991f, 
		-3.52264f, -0.290671f, 1.67991f, -3.52238f, -0.583833f, 1.80761f, 
		-3.52238f, -0.583833f, 1.80761f, -3.52238f, -0.583833f, 1.80761f, 
		-3.52238f, -0.583833f, 1.80761f, -3.52184f, -0.377622f, 1.57817f, 
		-3.52169f, -0.423532f, 1.76776f, -3.52157f, -0.615317f, 1.96603f, 
		-3.52157f, -0.615317f, 1.96603f, -3.52157f, -0.615317f, 1.96603f, 
		-3.52157f, -0.615317f, 1.96603f, -3.52157f, -0.615317f, 1.96603f, 
		-3.52157f, -0.615317f, 1.96603f, -3.52144f, -0.583524f, 1.98025f, 
		-3.52144f, -0.583524f, 1.98025f, -3.52144f, -0.583524f, 1.98025f, 
		-3.52144f, -0.583524f, 1.98025f, -3.52110f, 0.562582f, 1.83167f, 
		-3.52110f, 0.562582f, 1.83167f, -3.52110f, 0.562582f, 1.83167f, 
		-3.52110f, 0.562582f, 1.83167f, -3.52084f, -0.458428f, 1.76316f, 
		-3.52041f, -0.487609f, 1.75146f, -3.52038f, -0.584690f, 1.62194f, 
		-3.52038f, -0.584690f, 1.62194f, -3.51953f, -0.616903f, 1.96331f, 
		-3.51953f, -0.616903f, 1.96331f, -3.51953f, -0.616903f, 1.96331f, 
		-3.51953f, -0.616903f, 1.96331f, -3.51935f, -0.569689f, 1.85820f, 
		-3.51935f, -0.569689f, 1.85820f, -3.51930f, -0.300049f, 1.64829f, 
		-3.51909f, -0.449887f, 1.95705f, -3.51877f, -0.307050f, 1.70948f, 
		-3.51874f, -0.618895f, 1.94663f, -3.51835f, -0.586975f, 1.85955f, 
		-3.51835f, -0.586975f, 1.85955f, -3.51835f, -0.586975f, 1.85955f, 
		-3.51835f, -0.586975f, 1.85955f, -3.51794f, 0.705571f, 1.69893f, 
		-3.51794f, 0.705571f, 1.69893f, -3.51794f, 0.705571f, 1.69893f, 
		-3.51793f, -0.567871f, 1.62577f, -3.51793f, -0.567871f, 1.62577f, 
		-3.51793f, -0.567871f, 1.62577f, -3.51793f, -0.567871f, 1.62577f, 
		-3.51792f, -0.496149f, 1.96530f, -3.51792f, -0.496149f, 1.96530f, 
		-3.51792f, -0.496149f, 1.96530f, -3.51792f, -0.496149f, 1.96530f, 
		-3.51778f, -0.638958f, 1.60501f, -3.51778f, -0.638958f, 1.60501f, 
		-3.51778f, -0.638958f, 1.60501f, -3.51778f, -0.638958f, 1.60501f, 
		-3.51775f, -0.604085f, 1.64664f, -3.51775f, -0.604085f, 1.64664f, 
		-3.51775f, -0.604085f, 1.64664f, -3.51759f, -0.605096f, 1.65142f, 
		-3.51759f, -0.605096f, 1.65142f, -3.51759f, -0.605096f, 1.65142f, 
		-3.51755f, -0.309014f, 1.61680f, -3.51755f, -0.309014f, 1.61680f, 
		-3.51733f, -0.605054f, 1.70177f, -3.51733f, -0.605054f, 1.70177f, 
		-3.51733f, -0.605054f, 1.70177f, -3.51710f, -0.579825f, 1.54476f, 
		-3.51710f, -0.579825f, 1.54476f, -3.51710f, -0.579825f, 1.54476f, 
		-3.51710f, -0.579825f, 1.54476f, -3.51710f, -0.579825f, 1.54476f, 
		-3.51710f, -0.579825f, 1.54476f, -3.51705f, -0.598467f, 1.56039f, 
		-3.51705f, -0.598467f, 1.56039f, -3.51705f, -0.598467f, 1.56039f, 
		-3.51705f, -0.598467f, 1.56039f, -3.51705f, -0.598467f, 1.56039f, 
		-3.51702f, -0.701243f, 1.91888f, -3.51643f, -0.560328f, 1.74480f, 
		-3.51643f, -0.560328f, 1.74480f, -3.51640f, -0.642132f, 1.60882f, 
		-3.51640f, -0.642132f, 1.60882f, -3.51640f, -0.642132f, 1.60882f, 
		-3.51627f, -0.709330f, 1.91557f, -3.51627f, -0.709330f, 1.91557f, 
		-3.51615f, -0.689638f, 1.91555f, -3.51615f, -0.689638f, 1.91555f, 
		-3.51615f, -0.689638f, 1.91555f, -3.51597f, -0.565304f, 1.72926f, 
		-3.51597f, -0.565304f, 1.72926f, -3.51597f, -0.565304f, 1.72926f, 
		-3.51577f, -0.603380f, 1.70592f, -3.51577f, -0.603380f, 1.70592f, 
		-3.51577f, -0.603380f, 1.70592f, -3.51577f, -0.603380f, 1.70592f, 
		-3.51522f, -0.548410f, 1.69194f, -3.51522f, -0.548410f, 1.69194f, 
		-3.51496f, -0.690576f, 1.91105f, -3.51496f, -0.690576f, 1.91105f, 
		-3.51496f, -0.690576f, 1.91105f, -3.51491f, -0.540343f, 1.97386f, 
		-3.51491f, -0.540343f, 1.97386f, -3.51491f, -0.540343f, 1.97386f, 
		-3.51491f, -0.540343f, 1.97386f, -3.51467f, -0.712855f, 1.67050f, 
		-3.51454f, -0.600375f, 1.56055f, -3.51454f, -0.600375f, 1.56055f, 
		-3.51454f, -0.600375f, 1.56055f, -3.51453f, -0.309516f, 1.88893f, 
		-3.51440f, -0.603898f, 1.80624f, -3.51440f, -0.603898f, 1.80624f, 
		-3.51440f, -0.603898f, 1.80624f, -3.51438f, -0.564727f, 1.77981f, 
		-3.51438f, -0.564727f, 1.77981f, -3.51438f, -0.564727f, 1.77981f, 
		-3.51416f, -0.579581f, 1.73291f, -3.51415f, -0.402500f, 1.57163f, 
		-3.51411f, -0.324417f, 1.73868f, -3.51411f, -0.324417f, 1.73868f, 
		-3.51411f, -0.324417f, 1.73868f, -3.51411f, -0.324417f, 1.73868f, 
		-3.51406f, -0.585040f, 1.88708f, -3.51406f, -0.585040f, 1.88708f, 
		-3.51404f, -0.565702f, 1.97891f, -3.51404f, -0.565702f, 1.97891f, 
		-3.51386f, -0.563235f, 1.75780f, -3.51377f, -0.534919f, 1.74895f, 
		-3.51344f, -0.581372f, 1.74350f, -3.51344f, -0.581372f, 1.74350f, 
		-3.51319f, -0.602755f, 1.80260f, -3.51319f, -0.602755f, 1.80260f, 
		-3.51319f, -0.602755f, 1.80260f, -3.51319f, -0.602755f, 1.80260f, 
		-3.51315f, -0.538920f, 1.75678f, -3.51295f, -0.632725f, 1.74707f, 
		-3.51295f, -0.632725f, 1.74707f, -3.51295f, -0.632725f, 1.74707f, 
		-3.51295f, -0.632725f, 1.74707f, -3.51295f, -0.632725f, 1.74707f, 
		-3.51295f, -0.632725f, 1.74707f, -3.51281f, -0.579079f, 1.77596f, 
		-3.51274f, -0.600360f, 1.74306f, -3.51274f, -0.600360f, 1.74306f, 
		-3.51265f, -0.605334f, 1.85735f, -3.51265f, -0.605334f, 1.85735f, 
		-3.51265f, -0.605334f, 1.85735f, -3.51259f, -0.604377f, 1.86208f, 
		-3.51259f, -0.604377f, 1.86208f, -3.51259f, -0.604377f, 1.86208f, 
		-3.51237f, -0.520436f, 1.75658f, -3.51222f, -0.602268f, 1.56090f, 
		-3.51222f, -0.602268f, 1.56090f, -3.51222f, -0.602268f, 1.56090f, 
		-3.51222f, -0.602268f, 1.56090f, -3.51199f, -0.652437f, 1.73549f, 
		-3.51199f, -0.652437f, 1.73549f, -3.51199f, -0.652437f, 1.73549f, 
		-3.51177f, -0.568226f, 1.88325f, -3.51177f, -0.568226f, 1.88325f, 
		-3.51177f, -0.568226f, 1.88325f, -3.51177f, -0.568226f, 1.88325f, 
		-3.51177f, -0.638919f, 1.74304f, -3.51177f, -0.638919f, 1.74304f, 
		-3.51177f, -0.638919f, 1.74304f, -3.51156f, -0.547889f, 1.65830f, 
		-3.51156f, -0.547889f, 1.65830f, -3.51147f, -0.655779f, 1.73031f, 
		-3.51147f, -0.655779f, 1.73031f, -3.51147f, -0.655779f, 1.73031f, 
		-3.51141f, -0.547182f, 1.81892f, -3.51141f, -0.547182f, 1.81892f, 
		-3.51124f, -0.621019f, 1.74642f, -3.51095f, -0.712578f, 1.69750f, 
		-3.51095f, -0.652204f, 1.77310f, -3.51095f, -0.652204f, 1.77310f, 
		-3.51095f, -0.652204f, 1.77310f, -3.51072f, -0.632436f, 1.76046f, 
		-3.51072f, -0.632436f, 1.76046f, -3.51072f, -0.632436f, 1.76046f, 
		-3.51040f, -0.597105f, 1.76053f, -3.51039f, -0.639033f, 1.90384f, 
		-3.51039f, -0.639033f, 1.90384f, -3.51039f, -0.639033f, 1.90384f, 
		-3.51039f, -0.639033f, 1.90384f, -3.51026f, -0.604801f, 1.56319f, 
		-3.51026f, -0.604801f, 1.56319f, -3.51017f, -0.655553f, 1.77824f, 
		-3.51017f, -0.655553f, 1.77824f, -3.51017f, -0.655553f, 1.77824f, 
		-3.50939f, -0.712925f, 1.60583f, -3.50936f, 0.546429f, 1.69573f, 
		-3.50936f, 0.546429f, 1.69573f, -3.50936f, 0.546429f, 1.69573f, 
		-3.50936f, 0.546429f, 1.69573f, -3.50936f, 0.546429f, 1.69573f, 
		-3.50927f, -0.637759f, 1.76478f, -3.50927f, -0.637759f, 1.76478f, 
		-3.50925f, -0.618790f, 1.75970f, -3.50918f, -0.642186f, 1.89998f, 
		-3.50918f, -0.642186f, 1.89998f, -3.50918f, -0.642186f, 1.89998f, 
		-3.50900f, -0.610875f, 1.57596f, -3.50870f, -0.707680f, 1.72076f, 
		-3.50864f, -0.429807f, 1.56511f, -3.50761f, 0.637985f, 1.59919f, 
		-3.50761f, 0.637985f, 1.59919f, -3.50761f, 0.637985f, 1.59919f, 
		-3.50761f, 0.637985f, 1.59919f, -3.50761f, 0.637985f, 1.59919f, 
		-3.50744f, -0.547594f, 1.67580f, -3.50732f, 0.292629f, 1.77013f, 
		-3.50732f, 0.292629f, 1.77013f, -3.50732f, 0.292629f, 1.77013f, 
		-3.50731f, -0.548867f, 1.85243f, -3.50731f, -0.548867f, 1.85243f, 
		-3.50726f, -0.603243f, 1.81121f, -3.50726f, -0.603243f, 1.81121f, 
		-3.50696f, -0.564478f, 1.54183f, -3.50696f, -0.564478f, 1.54183f, 
		-3.50696f, -0.564478f, 1.54183f, -3.50696f, -0.564478f, 1.54183f, 
		-3.50690f, -0.707450f, 1.78757f, -3.50661f, -0.712472f, 1.81166f, 
		-3.50612f, -0.361450f, 1.78400f, -3.50548f, -0.581927f, 1.68920f, 
		-3.50548f, -0.581927f, 1.68920f, -3.50539f, -0.695173f, 1.73400f, 
		-3.50539f, -0.695173f, 1.73400f, -3.50537f, 0.547725f, 1.66656f, 
		-3.50537f, 0.547725f, 1.66656f, -3.50537f, 0.547725f, 1.66656f, 
		-3.50537f, 0.547725f, 1.66656f, -3.50506f, 0.498279f, 1.85361f, 
		-3.50506f, 0.498279f, 1.85361f, -3.50506f, 0.498279f, 1.85361f, 
		-3.50506f, 0.498279f, 1.85361f, -3.50506f, 0.498279f, 1.85361f, 
		-3.50426f, -0.694940f, 1.77423f, -3.50426f, -0.694940f, 1.77423f, 
		-3.50425f, 0.648412f, 1.63923f, -3.50425f, 0.648412f, 1.63923f, 
		-3.50399f, -0.459476f, 1.55832f, -3.50380f, -0.591668f, 1.65951f, 
		-3.50380f, -0.591668f, 1.65951f, -3.50380f, -0.591668f, 1.65951f, 
		-3.50380f, -0.591668f, 1.65951f, -3.50380f, -0.591668f, 1.65951f, 
		-3.50369f, -0.602922f, 1.66005f, -3.50369f, -0.602922f, 1.66005f, 
		-3.50343f, -0.547433f, 1.83491f, -3.50203f, -0.487749f, 1.55251f, 
		-3.50195f, -0.563865f, 1.63234f, -3.50195f, -0.563865f, 1.63234f, 
		-3.50191f, -0.686664f, 1.74028f, -3.50191f, -0.686664f, 1.74028f, 
		-3.50191f, -0.686664f, 1.74028f, -3.50188f, -0.583292f, 1.81879f, 
		-3.50188f, -0.583292f, 1.81879f, -3.50138f, 0.485952f, 1.84877f, 
		-3.50138f, 0.485952f, 1.84877f, -3.50138f, 0.485952f, 1.84877f, 
		-3.50138f, 0.485952f, 1.84877f, -3.50138f, 0.485952f, 1.84877f, 
		-3.50138f, 0.485952f, 1.84877f, -3.50136f, -0.581326f, 1.84869f, 
		-3.50136f, -0.581326f, 1.84869f, -3.50136f, -0.581326f, 1.84869f, 
		-3.50136f, -0.581326f, 1.84869f, -3.50136f, -0.581326f, 1.84869f, 
		-3.50135f, -0.309515f, 1.85841f, -3.50111f, -0.686450f, 1.76783f, 
		-3.50111f, -0.686450f, 1.76783f, -3.50111f, -0.686450f, 1.76783f, 
		-3.50097f, -0.330937f, 1.91998f, -3.50097f, -0.330937f, 1.91998f, 
		-3.50078f, 0.359776f, 1.76756f, -3.50078f, 0.359776f, 1.76756f, 
		-3.50059f, -0.712914f, 1.90289f, -3.50030f, -0.601094f, 1.65645f, 
		-3.50030f, -0.601094f, 1.65645f, -3.50022f, -0.609134f, 1.62190f, 
		-3.50022f, -0.609134f, 1.62190f, -3.50022f, -0.609134f, 1.62190f, 
		-3.49964f, -0.599396f, 1.68953f, -3.49964f, -0.599396f, 1.68953f, 
		-3.49964f, -0.599396f, 1.68953f, -3.49964f, -0.599396f, 1.68953f, 
		-3.49964f, -0.599396f, 1.68953f, -3.49961f, -0.602429f, 1.61921f, 
		-3.49961f, -0.602429f, 1.61921f, -3.49961f, -0.602429f, 1.61921f, 
		-3.49961f, -0.602429f, 1.61921f, -3.49961f, -0.602429f, 1.61921f, 
		-3.49936f, 0.662090f, 1.74533f, -3.49936f, 0.662090f, 1.74533f, 
		-3.49910f, -0.320313f, 1.82648f, -3.49908f, -0.602996f, 1.84824f, 
		-3.49908f, -0.602996f, 1.84824f, -3.49862f, -0.513666f, 1.54662f, 
		-3.49836f, -0.590716f, 1.67479f, -3.49836f, -0.590716f, 1.67479f, 
		-3.49819f, -0.593897f, 1.84968f, -3.49819f, -0.593897f, 1.84968f, 
		-3.49782f, -0.676543f, 1.73340f, -3.49782f, -0.676543f, 1.73340f, 
		-3.49782f, -0.676543f, 1.73340f, -3.49751f, 0.600632f, 1.81629f, 
		-3.49751f, 0.600632f, 1.81629f, -3.49726f, -0.386164f, 1.78184f, 
		-3.49725f, -0.674635f, 1.73879f, -3.49725f, -0.674635f, 1.73879f, 
		-3.49725f, -0.674635f, 1.73879f, -3.49681f, -0.563239f, 1.71942f, 
		-3.49681f, -0.563239f, 1.71942f, -3.49674f, -0.630536f, 1.72648f, 
		-3.49674f, -0.630536f, 1.72648f, -3.49674f, -0.630536f, 1.72648f, 
		-3.49670f, -0.676362f, 1.77453f, -3.49670f, -0.676362f, 1.77453f, 
		-3.49670f, -0.676362f, 1.77453f, -3.49649f, -0.332164f, 1.79464f, 
		-3.49649f, -0.332164f, 1.79464f, -3.49641f, -0.674461f, 1.76913f, 
		-3.49641f, -0.674461f, 1.76913f, -3.49641f, -0.674461f, 1.76913f, 
		-3.49635f, -0.599244f, 1.81850f, -3.49635f, -0.599244f, 1.81850f, 
		-3.49635f, -0.599244f, 1.81850f, -3.49635f, -0.599244f, 1.81850f, 
		-3.49635f, -0.599244f, 1.81850f, -3.49617f, -0.548960f, 1.53901f, 
		-3.49617f, -0.548960f, 1.53901f, -3.49617f, -0.548960f, 1.53901f, 
		-3.49617f, -0.548960f, 1.53901f, -3.49607f, -0.625416f, 1.73147f, 
		-3.49607f, -0.625416f, 1.73147f, -3.49607f, -0.625416f, 1.73147f, 
		-3.49603f, -0.564079f, 1.87595f, -3.49603f, -0.564079f, 1.87595f, 
		-3.49596f, -0.409858f, 1.74419f, -3.49552f, -0.601178f, 1.85167f, 
		-3.49552f, -0.601178f, 1.85167f, -3.49547f, -0.599111f, 1.67243f, 
		-3.49547f, -0.599111f, 1.67243f, -3.49547f, -0.599111f, 1.67243f, 
		-3.49547f, -0.599111f, 1.67243f, -3.49532f, -0.630415f, 1.78145f, 
		-3.49532f, -0.630415f, 1.78145f, -3.49532f, -0.630415f, 1.78145f, 
		-3.49491f, -0.562903f, 1.78874f, -3.49491f, -0.562903f, 1.78874f, 
		-3.49488f, -0.625242f, 1.77641f, -3.49488f, -0.625242f, 1.77641f, 
		-3.49488f, -0.625242f, 1.77641f, -3.49438f, -0.590822f, 1.83290f, 
		-3.49438f, -0.590822f, 1.83290f, -3.49381f, -0.609242f, 1.88617f, 
		-3.49381f, -0.609242f, 1.88617f, -3.49381f, -0.609242f, 1.88617f, 
		-3.49319f, -0.602634f, 1.88884f, -3.49319f, -0.602634f, 1.88884f, 
		-3.49319f, -0.602634f, 1.88884f, -3.49319f, -0.602634f, 1.88884f, 
		-3.49319f, -0.602634f, 1.88884f, -3.49241f, 0.623894f, 1.62104f, 
		-3.49241f, 0.623894f, 1.62104f, -3.49241f, 0.623894f, 1.62104f, 
		-3.49239f, -0.313639f, 1.67616f, -3.49152f, -0.599678f, 1.71969f, 
		-3.49152f, -0.599678f, 1.71969f, -3.49152f, -0.599678f, 1.71969f, 
		-3.49141f, -0.599115f, 1.83544f, -3.49141f, -0.599115f, 1.83544f, 
		-3.49141f, -0.599115f, 1.83544f, -3.49141f, -0.599115f, 1.83544f, 
		-3.49069f, -0.329622f, 1.70667f, -3.49046f, -0.592353f, 1.72422f, 
		-3.49046f, -0.592353f, 1.72422f, -3.49046f, -0.592353f, 1.72422f, 
		-3.49046f, -0.592353f, 1.72422f, -3.48979f, -0.599591f, 1.78800f, 
		-3.48979f, -0.599591f, 1.78800f, -3.48979f, -0.599591f, 1.78800f, 
		-3.48892f, -0.592197f, 1.78344f, -3.48892f, -0.592197f, 1.78344f, 
		-3.48892f, -0.592197f, 1.78344f, -3.48892f, -0.592197f, 1.78344f, 
		-3.48853f, 0.598090f, 1.68022f, -3.48853f, 0.598090f, 1.68022f, 
		-3.48853f, 0.598090f, 1.68022f, -3.48853f, 0.598090f, 1.68022f, 
		-3.48853f, 0.598090f, 1.68022f, -3.48853f, 0.598090f, 1.68022f, 
		-3.48853f, 0.598090f, 1.68022f, -3.48783f, -0.327332f, 1.64214f, 
		-3.48760f, -0.337833f, 1.60868f, -3.48760f, -0.337833f, 1.60868f, 
		-3.48707f, -0.589727f, 1.96702f, -3.48662f, 0.377099f, 1.79729f, 
		-3.48662f, 0.377099f, 1.79729f, -3.48660f, -0.607727f, 1.95491f, 
		-3.48660f, -0.607727f, 1.95491f, -3.48660f, -0.607727f, 1.95491f, 
		-3.48660f, -0.607727f, 1.95491f, -3.48652f, -0.350488f, 1.73692f, 
		-3.48652f, -0.350488f, 1.73692f, -3.48640f, 0.615365f, 1.65152f, 
		-3.48640f, 0.615365f, 1.65152f, -3.48640f, 0.615365f, 1.65152f, 
		-3.48640f, 0.615365f, 1.65152f, -3.48626f, -0.597527f, 1.96151f, 
		-3.48616f, -0.335390f, 1.89099f, -3.48472f, -0.455629f, 1.94436f, 
		-3.48418f, 0.537881f, 1.84618f, -3.48418f, 0.537881f, 1.84618f, 
		-3.48418f, 0.537881f, 1.84618f, -3.48418f, 0.537881f, 1.84618f, 
		-3.48418f, 0.537881f, 1.84618f, -3.48418f, 0.537881f, 1.84618f, 
		-3.48418f, 0.537881f, 1.84618f, -3.48400f, -0.663652f, 1.61187f, 
		-3.48400f, -0.663652f, 1.61187f, -3.48400f, -0.663652f, 1.61187f, 
		-3.48300f, -0.566688f, 1.96099f, -3.48148f, -0.659682f, 1.59008f, 
		-3.48148f, -0.659682f, 1.59008f, -3.48148f, -0.659682f, 1.59008f, 
		-3.48148f, -0.659682f, 1.59008f, -3.48113f, -0.657812f, 1.58915f, 
		-3.48113f, -0.657812f, 1.58915f, -3.48113f, -0.657812f, 1.58915f, 
		-3.48113f, -0.657812f, 1.58915f, -3.47983f, -0.509046f, 1.77028f, 
		-3.47947f, 0.597815f, 1.72701f, -3.47947f, 0.597815f, 1.72701f, 
		-3.47947f, 0.597815f, 1.72701f, -3.47947f, 0.597815f, 1.72701f, 
		-3.47947f, 0.597815f, 1.72701f, -3.47947f, 0.597815f, 1.72701f, 
		-3.47904f, -0.700503f, 1.57883f, -3.47884f, -0.557959f, 1.64372f, 
		-3.47884f, -0.557959f, 1.64372f, -3.47856f, -0.709353f, 1.58264f, 
		-3.47856f, -0.709353f, 1.58264f, -3.47831f, -0.361702f, 1.92323f, 
		-3.47831f, -0.361702f, 1.92323f, -3.47816f, -0.544415f, 1.95556f, 
		-3.47812f, -0.575712f, 1.55040f, -3.47812f, -0.575712f, 1.55040f, 
		-3.47790f, 0.593736f, 1.80457f, -3.47790f, 0.593736f, 1.80457f, 
		-3.47790f, 0.593736f, 1.80457f, -3.47790f, 0.593736f, 1.80457f, 
		-3.47790f, 0.593736f, 1.80457f, -3.47790f, 0.593736f, 1.80457f, 
		-3.47703f, 0.659941f, 1.70733f, -3.47703f, 0.659941f, 1.70733f, 
		-3.47703f, 0.659941f, 1.70733f, -3.47703f, 0.659941f, 1.70733f, 
		-3.47703f, 0.659941f, 1.70733f, -3.47703f, 0.659941f, 1.70733f, 
		-3.47703f, 0.659941f, 1.70733f, -3.47694f, -0.663652f, 1.89535f, 
		-3.47694f, -0.663652f, 1.89535f, -3.47694f, -0.663652f, 1.89535f, 
		-3.47565f, -0.529298f, 1.76881f, -3.47563f, -0.599825f, 1.56441f, 
		-3.47563f, -0.599825f, 1.56441f, -3.47563f, -0.599825f, 1.56441f, 
		-3.47563f, -0.599825f, 1.56441f, -3.47529f, -0.502410f, 1.94650f, 
		-3.47497f, -0.363835f, 1.79338f, -3.47497f, -0.363835f, 1.79338f, 
		-3.47441f, -0.612599f, 1.94600f, -3.47340f, -0.557999f, 1.86335f, 
		-3.47340f, -0.557999f, 1.86335f, -3.47334f, -0.659682f, 1.91700f, 
		-3.47334f, -0.659682f, 1.91700f, -3.47334f, -0.659682f, 1.91700f, 
		-3.47334f, -0.659682f, 1.91700f, -3.47313f, -0.339393f, 1.85831f, 
		-3.47293f, -0.657811f, 1.91790f, -3.47293f, -0.657811f, 1.91790f, 
		-3.47293f, -0.657811f, 1.91790f, -3.47293f, -0.657811f, 1.91790f, 
		-3.47275f, -0.556921f, 1.70203f, -3.47275f, -0.556921f, 1.70203f, 
		-3.47275f, -0.556921f, 1.70203f, -3.47275f, -0.556921f, 1.70203f, 
		-3.47226f, -0.555062f, 1.55348f, -3.47226f, -0.555062f, 1.55348f, 
		-3.47226f, -0.555062f, 1.55348f, -3.47212f, -0.353980f, 1.82595f, 
		-3.47185f, 0.636288f, 1.65372f, -3.47185f, 0.636288f, 1.65372f, 
		-3.47185f, 0.636288f, 1.65372f, -3.47185f, 0.636288f, 1.65372f, 
		-3.47185f, 0.636288f, 1.65372f, -3.47185f, 0.636288f, 1.65372f, 
		-3.47087f, 0.613111f, 1.67749f, -3.47087f, 0.613111f, 1.67749f, 
		-3.47087f, 0.613111f, 1.67749f, -3.47087f, 0.613111f, 1.67749f, 
		-3.47087f, 0.613111f, 1.67749f, -3.47087f, 0.613111f, 1.67749f, 
		-3.47087f, 0.613111f, 1.67749f, -3.47079f, -0.383972f, 1.73564f, 
		-3.47079f, -0.383972f, 1.73564f, -3.47034f, -0.700503f, 1.92811f, 
		-3.47015f, -0.556829f, 1.80484f, -3.47015f, -0.556829f, 1.80484f, 
		-3.47015f, -0.556829f, 1.80484f, -3.47015f, -0.556829f, 1.80484f, 
		-3.47005f, -0.709353f, 1.92428f, -3.47005f, -0.709353f, 1.92428f, 
		-3.46910f, -0.604535f, 1.56975f, -3.46801f, -0.372369f, 1.60176f, 
		-3.46801f, -0.372369f, 1.60176f, -3.46693f, 0.617578f, 1.79041f, 
		-3.46693f, 0.617578f, 1.79041f, -3.46693f, 0.617578f, 1.79041f, 
		-3.46693f, 0.617578f, 1.79041f, -3.46693f, 0.617578f, 1.79041f, 
		-3.46675f, -0.389613f, 1.92528f, -3.46675f, -0.389613f, 1.92528f, 
		-3.46672f, -0.594642f, 1.63626f, -3.46672f, -0.594642f, 1.63626f, 
		-3.46672f, -0.594642f, 1.63626f, -3.46672f, -0.594642f, 1.63626f, 
		-3.46671f, -0.627356f, 1.72994f, -3.46671f, -0.627356f, 1.72994f, 
		-3.46650f, -0.638334f, 1.60659f, -3.46650f, -0.638334f, 1.60659f, 
		-3.46650f, -0.638334f, 1.60659f, -3.46650f, -0.638334f, 1.60659f, 
		-3.46635f, -0.368371f, 1.70379f, -3.46627f, -0.534576f, 1.55669f, 
		-3.46627f, -0.534576f, 1.55669f, -3.46627f, -0.534576f, 1.55669f, 
		-3.46623f, -0.368083f, 1.89193f, -3.46586f, -0.557884f, 1.76985f, 
		-3.46584f, -0.599130f, 1.76845f, -3.46565f, -0.619872f, 1.76879f, 
		-3.46526f, -0.395089f, 1.79135f, -3.46526f, -0.395089f, 1.79135f, 
		-3.46510f, -0.363010f, 1.63692f, -3.46458f, -0.665317f, 1.72855f, 
		-3.46458f, -0.665317f, 1.72855f, -3.46458f, -0.665317f, 1.72855f, 
		-3.46360f, -0.587050f, 1.63460f, -3.46360f, -0.587050f, 1.63460f, 
		-3.46360f, -0.587050f, 1.63460f, -3.46360f, -0.587050f, 1.63460f, 
		-3.46355f, -0.352216f, 1.67224f, -3.46336f, -0.633763f, 1.60277f, 
		-3.46336f, -0.633763f, 1.60277f, -3.46335f, -0.665319f, 1.77785f, 
		-3.46335f, -0.665319f, 1.77785f, -3.46335f, -0.665319f, 1.77785f, 
		-3.46134f, -0.406723f, 1.92600f, -3.46134f, -0.406723f, 1.92600f, 
		-3.46090f, -0.594643f, 1.87014f, -3.46090f, -0.594643f, 1.87014f, 
		-3.46090f, -0.594643f, 1.87014f, -3.46090f, -0.594643f, 1.87014f, 
		-3.46052f, -0.554038f, 1.67062f, -3.46052f, -0.554038f, 1.67062f, 
		-3.46052f, -0.554038f, 1.67062f, -3.45992f, -0.431452f, 1.73511f, 
		-3.45992f, -0.431452f, 1.73511f, -3.45976f, -0.384801f, 1.82426f, 
		-3.45973f, -0.616506f, 1.71733f, -3.45973f, -0.616506f, 1.71733f, 
		-3.45973f, -0.616506f, 1.71733f, -3.45919f, -0.638334f, 1.89975f, 
		-3.45919f, -0.638334f, 1.89975f, -3.45919f, -0.638334f, 1.89975f, 
		-3.45919f, -0.638334f, 1.89975f, -3.45836f, 0.485092f, 1.73123f, 
		-3.45836f, 0.485092f, 1.73123f, -3.45831f, -0.666923f, 1.73471f, 
		-3.45831f, -0.666923f, 1.73471f, -3.45831f, -0.666923f, 1.73471f, 
		-3.45831f, -0.666923f, 1.73471f, -3.45814f, 0.652505f, 1.62488f, 
		-3.45814f, 0.652505f, 1.62488f, -3.45814f, 0.652505f, 1.62488f, 
		-3.45795f, -0.616505f, 1.78882f, -3.45795f, -0.616505f, 1.78882f, 
		-3.45795f, -0.616505f, 1.78882f, -3.45770f, -0.587049f, 1.87164f, 
		-3.45770f, -0.587049f, 1.87164f, -3.45770f, -0.587049f, 1.87164f, 
		-3.45770f, -0.587049f, 1.87164f, -3.45739f, -0.666922f, 1.77139f, 
		-3.45739f, -0.666922f, 1.77139f, -3.45739f, -0.666922f, 1.77139f, 
		-3.45739f, -0.666922f, 1.77139f, -3.45739f, -0.666922f, 1.77139f, 
		-3.45739f, -0.666922f, 1.77139f, -3.45667f, -0.403916f, 1.59600f, 
		-3.45667f, -0.403916f, 1.59600f, -3.45641f, -0.554039f, 1.83550f, 
		-3.45641f, -0.554039f, 1.83550f, -3.45641f, -0.554039f, 1.83550f, 
		-3.45634f, 0.574856f, 1.81172f, -3.45634f, 0.574856f, 1.81172f, 
		-3.45634f, 0.574856f, 1.81172f, -3.45634f, 0.574856f, 1.81172f, 
		-3.45634f, 0.574856f, 1.81172f, -3.45587f, -0.633763f, 1.90342f, 
		-3.45587f, -0.633763f, 1.90342f, -3.45514f, -0.373952f, 1.85702f, 
		-3.45505f, -0.593371f, 1.69895f, -3.45505f, -0.593371f, 1.69895f, 
		-3.45505f, -0.593371f, 1.69895f, -3.45505f, -0.593371f, 1.69895f, 
		-3.45500f, -0.456168f, 1.78638f, -3.45500f, -0.456168f, 1.78638f, 
		-3.45465f, -0.470642f, 1.73432f, -3.45465f, -0.470642f, 1.73432f, 
		-3.45458f, -0.687469f, 1.73834f, -3.45458f, -0.687469f, 1.73834f, 
		-3.45458f, -0.687469f, 1.73834f, -3.45385f, -0.687469f, 1.76758f, 
		-3.45385f, -0.687469f, 1.76758f, -3.45385f, -0.687469f, 1.76758f, 
		-3.45349f, -0.440907f, 1.92769f, -3.45349f, -0.440907f, 1.92769f, 
		-3.45309f, -0.412617f, 1.82224f, -3.45299f, -0.614046f, 1.72236f, 
		-3.45299f, -0.614046f, 1.72236f, -3.45299f, -0.614046f, 1.72236f, 
		-3.45299f, -0.614046f, 1.72236f, -3.45236f, -0.593371f, 1.80694f, 
		-3.45236f, -0.593371f, 1.80694f, -3.45236f, -0.593371f, 1.80694f, 
		-3.45236f, -0.593371f, 1.80694f, -3.45147f, -0.614046f, 1.78346f, 
		-3.45147f, -0.614046f, 1.78346f, -3.45147f, -0.614046f, 1.78346f, 
		-3.45147f, -0.614046f, 1.78346f, -3.45101f, -0.585687f, 1.70183f, 
		-3.45101f, -0.585687f, 1.70183f, -3.45101f, -0.585687f, 1.70183f, 
		-3.45101f, -0.585687f, 1.70183f, -3.45094f, -0.699739f, 1.73303f, 
		-3.45094f, -0.699739f, 1.73303f, -3.44995f, -0.699739f, 1.77270f, 
		-3.44995f, -0.699739f, 1.77270f, -3.44978f, -0.495184f, 1.73330f, 
		-3.44978f, -0.495184f, 1.73330f, -3.44952f, -0.387229f, 1.67043f, 
		-3.44872f, -0.495529f, 1.78416f, -3.44872f, -0.495529f, 1.78416f, 
		-3.44854f, 0.462121f, 1.78075f, -3.44854f, 0.462121f, 1.78075f, 
		-3.44846f, -0.585686f, 1.80386f, -3.44846f, -0.585686f, 1.80386f, 
		-3.44846f, -0.585686f, 1.80386f, -3.44846f, -0.585686f, 1.80386f, 
		-3.44817f, -0.435447f, 1.59032f, -3.44817f, -0.435447f, 1.59032f, 
		-3.44693f, 0.580404f, 1.77380f, -3.44693f, 0.580404f, 1.77380f, 
		-3.44666f, -0.588356f, 1.66757f, -3.44666f, -0.588356f, 1.66757f, 
		-3.44666f, -0.588356f, 1.66757f, -3.44666f, -0.588356f, 1.66757f, 
		-3.44613f, -0.403542f, 1.85511f, -3.44588f, -0.495932f, 1.93045f, 
		-3.44588f, -0.495932f, 1.93045f, -3.44484f, -0.579945f, 1.95374f, 
		-3.44484f, -0.579945f, 1.95374f, -3.44476f, -0.522905f, 1.73114f, 
		-3.44476f, -0.522905f, 1.73114f, -3.44453f, -0.589684f, 1.95044f, 
		-3.44453f, -0.589684f, 1.95044f, -3.44402f, 0.528454f, 1.75790f, 
		-3.44402f, 0.528454f, 1.75790f, -3.44396f, -0.599619f, 1.94690f, 
		-3.44396f, -0.599619f, 1.94690f, -3.44370f, -0.451644f, 1.89119f, 
		-3.44352f, -0.409070f, 1.66948f, -3.44352f, -0.409070f, 1.66948f, 
		-3.44348f, -0.551187f, 1.94272f, -3.44348f, -0.551187f, 1.94272f, 
		-3.44333f, -0.460323f, 1.58586f, -3.44333f, -0.460323f, 1.58586f, 
		-3.44242f, -0.588356f, 1.83787f, -3.44242f, -0.588356f, 1.83787f, 
		-3.44242f, -0.588356f, 1.83787f, -3.44242f, -0.588356f, 1.83787f, 
		-3.44240f, -0.709272f, 1.71667f, -3.44232f, -0.615919f, 1.92128f, 
		-3.44228f, -0.476419f, 1.69961f, -3.44224f, -0.611791f, 1.62975f, 
		-3.44224f, -0.611791f, 1.62975f, -3.44224f, -0.611791f, 1.62975f, 
		-3.44212f, -0.523233f, 1.93228f, -3.44212f, -0.523233f, 1.93228f, 
		-3.44182f, -0.580341f, 1.66818f, -3.44182f, -0.580341f, 1.66818f, 
		-3.44182f, -0.580341f, 1.66818f, -3.44061f, -0.709272f, 1.78861f, 
		-3.44004f, -0.606252f, 1.69814f, -3.44004f, -0.606252f, 1.69814f, 
		-3.44004f, -0.606252f, 1.69814f, -3.44004f, -0.606252f, 1.69814f, 
		-3.43974f, -0.604687f, 1.94107f, -3.43974f, -0.604687f, 1.94107f, 
		-3.43974f, -0.604687f, 1.94107f, -3.43974f, -0.604687f, 1.94107f, 
		-3.43974f, -0.604687f, 1.94107f, -3.43974f, -0.604687f, 1.94107f, 
		-3.43968f, -0.536064f, 1.72618f, -3.43968f, -0.536064f, 1.72618f, 
		-3.43966f, -0.431759f, 1.85292f, -3.43923f, -0.591422f, 1.56235f, 
		-3.43923f, -0.591422f, 1.56235f, -3.43923f, -0.591422f, 1.56235f, 
		-3.43914f, -0.578940f, 1.55764f, -3.43914f, -0.578940f, 1.55764f, 
		-3.43879f, -0.610462f, 1.93424f, -3.43879f, -0.610462f, 1.93424f, 
		-3.43879f, -0.610462f, 1.93424f, -3.43879f, -0.610462f, 1.93424f, 
		-3.43865f, -0.572134f, 1.55504f, -3.43865f, -0.572134f, 1.55504f, 
		-3.43865f, -0.572134f, 1.55504f, -3.43797f, -0.522163f, 1.78055f, 
		-3.43797f, -0.522163f, 1.78055f, -3.43761f, -0.580341f, 1.83701f, 
		-3.43761f, -0.580341f, 1.83701f, -3.43761f, -0.580341f, 1.83701f, 
		-3.43740f, -0.695227f, 1.58307f, -3.43740f, -0.695227f, 1.58307f, 
		-3.43740f, -0.695227f, 1.58307f, -3.43737f, -0.611813f, 1.58424f, 
		-3.43737f, -0.611813f, 1.58424f, -3.43732f, -0.606252f, 1.80700f, 
		-3.43732f, -0.606252f, 1.80700f, -3.43732f, -0.606252f, 1.80700f, 
		-3.43732f, -0.606252f, 1.80700f, -3.43714f, -0.545942f, 1.56441f, 
		-3.43714f, -0.545942f, 1.56441f, -3.43708f, -0.605487f, 1.62758f, 
		-3.43708f, -0.605487f, 1.62758f, -3.43708f, -0.605487f, 1.62758f, 
		-3.43629f, -0.503168f, 1.89061f, -3.43612f, -0.611791f, 1.87542f, 
		-3.43612f, -0.611791f, 1.87542f, -3.43612f, -0.611791f, 1.87542f, 
		-3.43600f, -0.709353f, 1.57537f, -3.43600f, -0.709353f, 1.57537f, 
		-3.43595f, -0.444632f, 1.66741f, -3.43589f, -0.597425f, 1.56676f, 
		-3.43589f, -0.597425f, 1.56676f, -3.43589f, -0.597425f, 1.56676f, 
		-3.43587f, -0.699971f, 1.57162f, -3.43587f, -0.699971f, 1.57162f, 
		-3.43569f, -0.687072f, 1.57604f, -3.43569f, -0.687072f, 1.57604f, 
		-3.43569f, -0.687072f, 1.57604f, -3.43569f, -0.687072f, 1.57604f, 
		-3.43569f, -0.687072f, 1.57604f, -3.43567f, -0.519699f, 1.57469f, 
		-3.43567f, -0.519699f, 1.57469f, -3.43454f, -0.601403f, 1.66239f, 
		-3.43454f, -0.601403f, 1.66239f, -3.43444f, -0.603997f, 1.57312f, 
		-3.43444f, -0.603997f, 1.57312f, -3.43444f, -0.603997f, 1.57312f, 
		-3.43414f, 0.474643f, 1.71156f, -3.43414f, 0.474643f, 1.71156f, 
		-3.43414f, 0.474643f, 1.71156f, -3.43414f, 0.474643f, 1.71156f, 
		-3.43304f, -0.601704f, 1.69944f, -3.43304f, -0.601704f, 1.69944f, 
		-3.43225f, -0.558731f, 1.71678f, -3.43225f, -0.558731f, 1.71678f, 
		-3.43190f, -0.511587f, 1.61804f, -3.43122f, -0.482908f, 1.84837f, 
		-3.43110f, -0.532262f, 1.89439f, -3.43088f, -0.543857f, 1.77921f, 
		-3.43088f, -0.543857f, 1.77921f, -3.43086f, -0.605487f, 1.87732f, 
		-3.43086f, -0.605487f, 1.87732f, -3.43086f, -0.605487f, 1.87732f, 
		-3.43074f, -0.608589f, 1.88979f, -3.43040f, -0.601704f, 1.80535f, 
		-3.43040f, -0.601704f, 1.80535f, -3.43021f, -0.600285f, 1.70016f, 
		-3.43021f, -0.600285f, 1.70016f, -3.43021f, -0.600285f, 1.70016f, 
		-3.43005f, -0.601403f, 1.84243f, -3.43005f, -0.601403f, 1.84243f, 
		-3.42895f, -0.695228f, 1.92180f, -3.42895f, -0.695228f, 1.92180f, 
		-3.42895f, -0.695228f, 1.92180f, -3.42841f, -0.502055f, 1.66448f, 
		-3.42761f, -0.600285f, 1.80450f, -3.42761f, -0.600285f, 1.80450f, 
		-3.42761f, -0.600285f, 1.80450f, -3.42742f, -0.538034f, 1.60981f, 
		-3.42730f, -0.596601f, 1.66252f, -3.42730f, -0.596601f, 1.66252f, 
		-3.42717f, -0.709353f, 1.92942f, -3.42717f, -0.709353f, 1.92942f, 
		-3.42690f, -0.687072f, 1.92873f, -3.42690f, -0.687072f, 1.92873f, 
		-3.42690f, -0.687072f, 1.92873f, -3.42690f, -0.687072f, 1.92873f, 
		-3.42690f, -0.687072f, 1.92873f, -3.42686f, -0.699971f, 1.93316f, 
		-3.42686f, -0.699971f, 1.93316f, -3.42675f, -0.567133f, 1.89516f, 
		-3.42640f, -0.580983f, 1.89658f, -3.42593f, -0.628997f, 1.71630f, 
		-3.42593f, -0.628997f, 1.71630f, -3.42551f, -0.553463f, 1.77815f, 
		-3.42551f, -0.553463f, 1.77815f, -3.42452f, -0.625603f, 1.77732f, 
		-3.42452f, -0.625603f, 1.77732f, -3.42434f, -0.595104f, 1.66262f, 
		-3.42434f, -0.595104f, 1.66262f, -3.42434f, -0.595104f, 1.66262f, 
		-3.42398f, -0.565213f, 1.60156f, -3.42364f, -0.657863f, 1.60083f, 
		-3.42364f, -0.657863f, 1.60083f, -3.42361f, -0.595399f, 1.89095f, 
		-3.42361f, -0.595399f, 1.89095f, -3.42352f, -0.587688f, 1.89443f, 
		-3.42308f, -0.574191f, 1.60209f, -3.42283f, -0.596601f, 1.84194f, 
		-3.42283f, -0.596601f, 1.84194f, -3.42187f, -0.649631f, 1.59533f, 
		-3.42187f, -0.649631f, 1.59533f, -3.42117f, -0.577015f, 1.71248f, 
		-3.42117f, -0.577015f, 1.71248f, -3.42107f, -0.561515f, 1.77746f, 
		-3.42107f, -0.561515f, 1.77746f, -3.41997f, -0.512984f, 1.84574f, 
		-3.41987f, -0.595104f, 1.84170f, -3.41987f, -0.595104f, 1.84170f, 
		-3.41987f, -0.595104f, 1.84170f, -3.41904f, -0.547958f, 1.81623f, 
		-3.41731f, -0.601795f, 1.77656f, -3.41731f, -0.601795f, 1.77656f, 
		-3.41730f, -0.608929f, 1.71416f, -3.41730f, -0.608929f, 1.71416f, 
		-3.41730f, -0.608929f, 1.71416f, -3.41721f, -0.529881f, 1.65531f, 
		-3.41684f, -0.576228f, 1.77689f, -3.41684f, -0.576228f, 1.77689f, 
		-3.41610f, -0.657863f, 1.90338f, -3.41610f, -0.657863f, 1.90338f, 
		-3.41598f, -0.589522f, 1.71245f, -3.41598f, -0.589522f, 1.71245f, 
		-3.41554f, -0.570799f, 1.68022f, -3.41459f, -0.712853f, 1.69267f, 
		-3.41406f, -0.649631f, 1.90878f, -3.41406f, -0.649631f, 1.90878f, 
		-3.41299f, -0.598840f, 1.84489f, -3.41299f, -0.598840f, 1.84489f, 
		-3.41051f, -0.601423f, 1.64307f, -3.41051f, -0.601423f, 1.64307f, 
		-3.41012f, -0.550755f, 1.84521f, -3.40832f, -0.558158f, 1.64763f, 
		-3.40832f, -0.558158f, 1.64763f, -3.40832f, -0.558158f, 1.64763f, 
		-3.40691f, -0.561584f, 1.84633f, -3.40654f, -0.580434f, 1.84793f, 
		-3.40654f, -0.580434f, 1.84793f, -3.40643f, -0.565320f, 1.64516f, 
		-3.40643f, -0.565320f, 1.64516f, -3.40643f, -0.565320f, 1.64516f, 
		-3.40643f, -0.565320f, 1.64516f, -3.40643f, -0.565320f, 1.64516f, 
		-3.40564f, -0.712855f, 1.81080f, -3.40526f, -0.569773f, 1.84776f, 
		-3.40443f, -0.588237f, 1.63849f, -3.40443f, -0.588237f, 1.63849f, 
		-3.40269f, -0.580033f, 1.63991f, -3.40269f, -0.580033f, 1.63991f, 
		-3.40269f, -0.580033f, 1.63991f, -3.40269f, -0.580033f, 1.63991f, 
		-3.40269f, -0.580033f, 1.63991f, -3.40269f, -0.580033f, 1.63991f, 
		-3.39909f, -0.680972f, 1.73395f, -3.39909f, -0.680972f, 1.73395f, 
		-3.39909f, -0.680972f, 1.73395f, -3.39821f, -0.680972f, 1.76920f, 
		-3.39821f, -0.680972f, 1.76920f, -3.39821f, -0.680972f, 1.76920f, 
		-3.39780f, -0.694269f, 1.58008f, -3.39780f, -0.694269f, 1.58008f, 
		-3.39780f, -0.694269f, 1.58008f, -3.39716f, -0.701232f, 1.73564f, 
		-3.39716f, -0.701232f, 1.73564f, -3.39716f, -0.701232f, 1.73564f, 
		-3.39716f, -0.701232f, 1.73564f, -3.39714f, -0.632222f, 1.62314f, 
		-3.39714f, -0.632222f, 1.62314f, -3.39714f, -0.632222f, 1.62314f, 
		-3.39706f, -0.672827f, 1.73927f, -3.39706f, -0.672827f, 1.73927f, 
		-3.39706f, -0.672827f, 1.73927f, -3.39667f, -0.709353f, 1.57157f, 
		-3.39667f, -0.709353f, 1.57157f, -3.39667f, -0.709353f, 1.57157f, 
		-3.39645f, -0.672827f, 1.76378f, -3.39645f, -0.672827f, 1.76378f, 
		-3.39645f, -0.672827f, 1.76378f, -3.39636f, -0.701232f, 1.76741f, 
		-3.39636f, -0.701232f, 1.76741f, -3.39636f, -0.701232f, 1.76741f, 
		-3.39636f, -0.701232f, 1.76741f, -3.39609f, -0.686088f, 1.57290f, 
		-3.39609f, -0.686088f, 1.57290f, -3.39609f, -0.686088f, 1.57290f, 
		-3.39598f, -0.699485f, 1.56801f, -3.39598f, -0.699485f, 1.56801f, 
		-3.39583f, -0.649669f, 1.72274f, -3.39583f, -0.649669f, 1.72274f, 
		-3.39536f, -0.624055f, 1.61945f, -3.39536f, -0.624055f, 1.61945f, 
		-3.39536f, -0.624055f, 1.61945f, -3.39440f, -0.649669f, 1.78023f, 
		-3.39440f, -0.649669f, 1.78023f, -3.39387f, -0.641486f, 1.72714f, 
		-3.39387f, -0.641486f, 1.72714f, -3.39265f, -0.641486f, 1.77574f, 
		-3.39265f, -0.641486f, 1.77574f, -3.39246f, -0.710545f, 1.71874f, 
		-3.39084f, -0.710545f, 1.78405f, -3.39075f, -0.632222f, 1.87977f, 
		-3.39075f, -0.632222f, 1.87977f, -3.39075f, -0.632222f, 1.87977f, 
		-3.38925f, -0.694270f, 1.92282f, -3.38925f, -0.694270f, 1.92282f, 
		-3.38925f, -0.694270f, 1.92282f, -3.38879f, -0.624055f, 1.88337f, 
		-3.38879f, -0.624055f, 1.88337f, -3.38879f, -0.624055f, 1.88337f, 
		-3.38771f, -0.709353f, 1.93126f, -3.38771f, -0.709353f, 1.93126f, 
		-3.38771f, -0.709353f, 1.93126f, -3.38719f, -0.686089f, 1.92990f, 
		-3.38719f, -0.686089f, 1.92990f, -3.38719f, -0.686089f, 1.92990f, 
		-3.38684f, -0.699485f, 1.93478f, -3.38684f, -0.699485f, 1.93478f, 
		-3.38593f, -0.667662f, 1.59691f, -3.38593f, -0.667662f, 1.59691f, 
		-3.38416f, -0.659405f, 1.59119f, -3.38416f, -0.659405f, 1.59119f, 
		-3.38416f, -0.659405f, 1.59119f, -3.38416f, -0.659405f, 1.59119f, 
		-3.37824f, -0.667663f, 1.90541f, -3.37824f, -0.667663f, 1.90541f, 
		-3.37694f, -0.627659f, 1.69587f, -3.37694f, -0.627659f, 1.69587f, 
		-3.37694f, -0.627659f, 1.69587f, -3.37618f, -0.659405f, 1.91104f, 
		-3.37618f, -0.659405f, 1.91104f, -3.37618f, -0.659405f, 1.91104f, 
		-3.37618f, -0.659405f, 1.91104f, -3.37497f, -0.619500f, 1.69814f, 
		-3.37497f, -0.619500f, 1.69814f, -3.37497f, -0.619500f, 1.69814f, 
		-3.37419f, -0.627659f, 1.80613f, -3.37419f, -0.627659f, 1.80613f, 
		-3.37419f, -0.627659f, 1.80613f, -3.37369f, -0.622805f, 1.65952f, 
		-3.37369f, -0.622805f, 1.65952f, -3.37234f, -0.619500f, 1.80376f, 
		-3.37234f, -0.619500f, 1.80376f, -3.37234f, -0.619500f, 1.80376f, 
		-3.37176f, -0.614655f, 1.65877f, -3.37176f, -0.614655f, 1.65877f, 
		-3.36913f, -0.622805f, 1.84227f, -3.36913f, -0.622805f, 1.84227f, 
		-3.36717f, -0.614655f, 1.84292f, -3.36717f, -0.614655f, 1.84292f, 
		-3.35975f, -0.646400f, 1.62036f, -3.35975f, -0.646400f, 1.62036f, 
		-3.35975f, -0.646400f, 1.62036f, -3.35798f, -0.638233f, 1.61653f, 
		-3.35798f, -0.638233f, 1.61653f, -3.35326f, -0.646400f, 1.88068f, 
		-3.35326f, -0.646400f, 1.88068f, -3.35326f, -0.646400f, 1.88068f, 
		-3.35294f, -0.681377f, 1.73528f, -3.35294f, -0.681377f, 1.73528f, 
		-3.35294f, -0.681377f, 1.73528f, -3.35219f, -0.681377f, 1.76557f, 
		-3.35219f, -0.681377f, 1.76557f, -3.35219f, -0.681377f, 1.76557f, 
		-3.35194f, -0.658046f, 1.72390f, -3.35194f, -0.658046f, 1.72390f, 
		-3.35130f, -0.638233f, 1.88443f, -3.35130f, -0.638233f, 1.88443f, 
		-3.35096f, -0.709335f, 1.73847f, -3.35096f, -0.709335f, 1.73847f, 
		-3.35089f, -0.673194f, 1.74079f, -3.35089f, -0.673194f, 1.74079f, 
		-3.35089f, -0.673194f, 1.74079f, -3.35062f, -0.658046f, 1.77688f, 
		-3.35062f, -0.658046f, 1.77688f, -3.35042f, -0.673194f, 1.75996f, 
		-3.35042f, -0.673194f, 1.75996f, -3.35042f, -0.673194f, 1.75996f, 
		-3.35037f, -0.709335f, 1.76228f, -3.35037f, -0.709335f, 1.76228f, 
		-3.35006f, -0.692057f, 1.74376f, -3.34997f, -0.649840f, 1.72846f, 
		-3.34997f, -0.649840f, 1.72846f, -3.34997f, -0.649840f, 1.72846f, 
		-3.34973f, -0.692058f, 1.75696f, -3.34888f, -0.649840f, 1.77223f, 
		-3.34888f, -0.649840f, 1.77223f, -3.34888f, -0.649840f, 1.77223f, 
		-3.34619f, -0.712852f, 1.72097f, -3.34473f, -0.712852f, 1.77952f, 
		-3.34146f, -0.712886f, 1.58477f, -3.33898f, -0.712854f, 1.69129f, 
		-3.33711f, -0.639874f, 1.69376f, -3.33711f, -0.639874f, 1.69376f, 
		-3.33711f, -0.639874f, 1.69376f, -3.33668f, -0.685305f, 1.58957f, 
		-3.33668f, -0.685305f, 1.58957f, -3.33668f, -0.685305f, 1.58957f, 
		-3.33623f, -0.637404f, 1.65587f, -3.33623f, -0.637404f, 1.65587f, 
		-3.33605f, -0.712854f, 1.80882f, -3.33533f, -0.697276f, 1.58545f, 
		-3.33533f, -0.697276f, 1.58545f, -3.33533f, -0.697276f, 1.58545f, 
		-3.33514f, -0.631725f, 1.69596f, -3.33514f, -0.631725f, 1.69596f, 
		-3.33432f, -0.629284f, 1.65489f, -3.33432f, -0.629284f, 1.65489f, 
		-3.33430f, -0.639874f, 1.80625f, -3.33430f, -0.639874f, 1.80625f, 
		-3.33430f, -0.639874f, 1.80625f, -3.33322f, -0.712886f, 1.91532f, 
		-3.33271f, -0.684626f, 1.57600f, -3.33271f, -0.684626f, 1.57600f, 
		-3.33271f, -0.684626f, 1.57600f, -3.33244f, -0.631725f, 1.80396f, 
		-3.33244f, -0.631725f, 1.80396f, -3.33196f, -0.709353f, 1.57443f, 
		-3.33196f, -0.709353f, 1.57443f, -3.33154f, -0.637405f, 1.84405f, 
		-3.33154f, -0.637405f, 1.84405f, -3.33113f, -0.698803f, 1.57116f, 
		-3.33113f, -0.698803f, 1.57116f, -3.33113f, -0.698803f, 1.57116f, 
		-3.32958f, -0.629284f, 1.84493f, -3.32958f, -0.629284f, 1.84493f, 
		-3.32869f, -0.685305f, 1.91028f, -3.32869f, -0.685305f, 1.91028f, 
		-3.32869f, -0.685305f, 1.91028f, -3.32713f, -0.697277f, 1.91434f, 
		-3.32713f, -0.697277f, 1.91434f, -3.32713f, -0.697277f, 1.91434f, 
		-3.32404f, -0.684626f, 1.92365f, -3.32404f, -0.684626f, 1.92365f, 
		-3.32404f, -0.684626f, 1.92365f, -3.32322f, -0.709353f, 1.92517f, 
		-3.32322f, -0.709353f, 1.92517f, -3.32223f, -0.698803f, 1.92840f, 
		-3.32223f, -0.698803f, 1.92840f, -3.32223f, -0.698803f, 1.92840f, 
		-3.31111f, -0.671994f, 1.60646f, -3.31111f, -0.671994f, 1.60646f, 
		-3.31111f, -0.671994f, 1.60646f, -3.31111f, -0.671994f, 1.60646f, 
		-3.31111f, -0.671994f, 1.60646f, -3.31028f, -0.668190f, 1.59424f, 
		-3.31028f, -0.668190f, 1.59424f, -3.31028f, -0.668190f, 1.59424f, 
		-3.31028f, -0.668190f, 1.59424f, -3.31028f, -0.668190f, 1.59424f, 
		-3.31028f, -0.668190f, 1.59424f, -3.30399f, -0.671994f, 1.89215f, 
		-3.30399f, -0.671994f, 1.89215f, -3.30399f, -0.671994f, 1.89215f, 
		-3.30399f, -0.671994f, 1.89215f, -3.30399f, -0.671994f, 1.89215f, 
		-3.30319f, -0.712852f, 1.71777f, -3.30255f, -0.668190f, 1.90431f, 
		-3.30255f, -0.668190f, 1.90431f, -3.30255f, -0.668190f, 1.90431f, 
		-3.30255f, -0.668190f, 1.90431f, -3.30255f, -0.668190f, 1.90431f, 
		-3.30255f, -0.668190f, 1.90431f, -3.30162f, -0.712852f, 1.78058f, 
		-3.29766f, -0.712875f, 1.61056f, -3.29615f, -0.677664f, 1.72455f, 
		-3.29615f, -0.677664f, 1.72455f, -3.29615f, -0.677664f, 1.72455f, 
		-3.29615f, -0.677664f, 1.72455f, -3.29615f, -0.677664f, 1.72455f, 
		-3.29615f, -0.677664f, 1.72455f, -3.29493f, -0.677664f, 1.77346f, 
		-3.29493f, -0.677664f, 1.77346f, -3.29493f, -0.677664f, 1.77346f, 
		-3.29493f, -0.677664f, 1.77346f, -3.29493f, -0.677664f, 1.77346f, 
		-3.29493f, -0.677664f, 1.77346f, -3.29449f, -0.693486f, 1.72789f, 
		-3.29449f, -0.693486f, 1.72789f, -3.29449f, -0.693486f, 1.72789f, 
		-3.29344f, -0.693486f, 1.77004f, -3.29344f, -0.693486f, 1.77004f, 
		-3.29344f, -0.693486f, 1.77004f, -3.29149f, -0.709332f, 1.73023f, 
		-3.29149f, -0.709332f, 1.73023f, -3.29147f, -0.676004f, 1.73014f, 
		-3.29147f, -0.676004f, 1.73014f, -3.29147f, -0.676004f, 1.73014f, 
		-3.29075f, -0.712875f, 1.88738f, -3.29056f, -0.709332f, 1.76755f, 
		-3.29056f, -0.709332f, 1.76755f, -3.29053f, -0.676004f, 1.76765f, 
		-3.29053f, -0.676004f, 1.76765f, -3.29053f, -0.676004f, 1.76765f, 
		-3.28980f, -0.694403f, 1.73395f, -3.28980f, -0.694403f, 1.73395f, 
		-3.28980f, -0.694403f, 1.73395f, -3.28962f, -0.668261f, 1.62919f, 
		-3.28962f, -0.668261f, 1.62919f, -3.28906f, -0.694403f, 1.76375f, 
		-3.28906f, -0.694403f, 1.76375f, -3.28906f, -0.694403f, 1.76375f, 
		-3.28719f, -0.674764f, 1.72323f, -3.28719f, -0.674764f, 1.72323f, 
		-3.28719f, -0.674764f, 1.72323f, -3.28719f, -0.674764f, 1.72323f, 
		-3.28706f, -0.665388f, 1.62378f, -3.28706f, -0.665388f, 1.62378f, 
		-3.28706f, -0.665388f, 1.62378f, -3.28592f, -0.674764f, 1.77433f, 
		-3.28592f, -0.674764f, 1.77433f, -3.28592f, -0.674764f, 1.77433f, 
		-3.28592f, -0.674764f, 1.77433f, -3.28546f, -0.680069f, 1.61484f, 
		-3.28546f, -0.680069f, 1.61484f, -3.28546f, -0.680069f, 1.61484f, 
		-3.28546f, -0.680069f, 1.61484f, -3.28546f, -0.680069f, 1.61484f, 
		-3.28521f, -0.672678f, 1.63257f, -3.28521f, -0.672678f, 1.63257f, 
		-3.28521f, -0.672678f, 1.63257f, -3.28390f, -0.676583f, 1.72283f, 
		-3.28390f, -0.676583f, 1.72283f, -3.28390f, -0.676583f, 1.72283f, 
		-3.28390f, -0.676583f, 1.72283f, -3.28366f, -0.668261f, 1.86838f, 
		-3.28366f, -0.668261f, 1.86838f, -3.28294f, -0.666788f, 1.62356f, 
		-3.28294f, -0.666788f, 1.62356f, -3.28294f, -0.666788f, 1.62356f, 
		-3.28261f, -0.676583f, 1.77456f, -3.28261f, -0.676583f, 1.77456f, 
		-3.28261f, -0.676583f, 1.77456f, -3.28261f, -0.676583f, 1.77456f, 
		-3.28100f, -0.671544f, 1.72734f, -3.28100f, -0.671544f, 1.72734f, 
		-3.28100f, -0.671544f, 1.72734f, -3.28100f, -0.671544f, 1.72734f, 
		-3.28083f, -0.665388f, 1.87365f, -3.28083f, -0.665388f, 1.87365f, 
		-3.28083f, -0.665388f, 1.87365f, -3.28060f, -0.694717f, 1.61119f, 
		-3.28060f, -0.694717f, 1.61119f, -3.28046f, -0.712855f, 1.69209f, 
		-3.28008f, -0.671491f, 1.76991f, -3.28008f, -0.671491f, 1.76991f, 
		-3.28008f, -0.671491f, 1.76991f, -3.28008f, -0.671491f, 1.76991f, 
		-3.27943f, -0.672678f, 1.86478f, -3.27943f, -0.672678f, 1.86478f, 
		-3.27943f, -0.672678f, 1.86478f, -3.27879f, -0.680069f, 1.88250f, 
		-3.27879f, -0.680069f, 1.88250f, -3.27879f, -0.680069f, 1.88250f, 
		-3.27879f, -0.680069f, 1.88250f, -3.27879f, -0.680069f, 1.88250f, 
		-3.27764f, -0.712855f, 1.80509f, -3.27671f, -0.666789f, 1.87367f, 
		-3.27671f, -0.666789f, 1.87367f, -3.27671f, -0.666789f, 1.87367f, 
		-3.27632f, -0.695826f, 1.60074f, -3.27632f, -0.695826f, 1.60074f, 
		-3.27490f, -0.709361f, 1.60170f, -3.27490f, -0.709361f, 1.60170f, 
		-3.27475f, -0.667425f, 1.70101f, -3.27475f, -0.667425f, 1.70101f, 
		-3.27444f, -0.664132f, 1.70131f, -3.27444f, -0.664132f, 1.70131f, 
		-3.27444f, -0.664132f, 1.70131f, -3.27391f, -0.669964f, 1.69928f, 
		-3.27391f, -0.669964f, 1.69928f, -3.27391f, -0.669964f, 1.69928f, 
		-3.27391f, -0.669964f, 1.69928f, -3.27391f, -0.669964f, 1.69928f, 
		-3.27375f, -0.694717f, 1.88590f, -3.27375f, -0.694717f, 1.88590f, 
		-3.27243f, -0.712860f, 1.64806f, -3.27239f, -0.667425f, 1.79590f, 
		-3.27239f, -0.667425f, 1.79590f, -3.27209f, -0.664132f, 1.79559f, 
		-3.27209f, -0.664132f, 1.79559f, -3.27209f, -0.664132f, 1.79559f, 
		-3.27146f, -0.669964f, 1.79759f, -3.27146f, -0.669964f, 1.79759f, 
		-3.27146f, -0.669964f, 1.79759f, -3.27146f, -0.669964f, 1.79759f, 
		-3.27146f, -0.669964f, 1.79759f, -3.26952f, -0.661691f, 1.70162f, 
		-3.26952f, -0.661691f, 1.70162f, -3.26896f, -0.695826f, 1.89612f, 
		-3.26896f, -0.695826f, 1.89612f, -3.26759f, -0.709361f, 1.89510f, 
		-3.26759f, -0.709361f, 1.89510f, -3.26743f, -0.712860f, 1.84867f, 
		-3.26719f, -0.661692f, 1.79504f, -3.26719f, -0.661692f, 1.79504f, 
		-3.26449f, -0.669188f, 1.65595f, -3.26449f, -0.669188f, 1.65595f, 
		-3.26449f, -0.669188f, 1.65595f, -3.26385f, -0.662341f, 1.65099f, 
		-3.26385f, -0.662341f, 1.65099f, -3.26385f, -0.662341f, 1.65099f, 
		-3.26112f, -0.663780f, 1.65217f, -3.26112f, -0.663780f, 1.65217f, 
		-3.26112f, -0.663780f, 1.65217f, -3.26112f, -0.663780f, 1.65217f, 
		-3.26112f, -0.663780f, 1.65217f, -3.26106f, -0.668601f, 1.65169f, 
		-3.26106f, -0.668601f, 1.65169f, -3.26106f, -0.668601f, 1.65169f, 
		-3.25990f, -0.669188f, 1.84040f, -3.25990f, -0.669188f, 1.84040f, 
		-3.25990f, -0.669188f, 1.84040f, -3.25901f, -0.662341f, 1.84532f, 
		-3.25901f, -0.662341f, 1.84532f, -3.25901f, -0.662341f, 1.84532f, 
		-3.25887f, -0.676835f, 1.70056f, -3.25887f, -0.676835f, 1.70056f, 
		-3.25887f, -0.676835f, 1.70056f, -3.25887f, -0.676835f, 1.70056f, 
		-3.25651f, -0.676836f, 1.79556f, -3.25651f, -0.676836f, 1.79556f, 
		-3.25651f, -0.676836f, 1.79556f, -3.25651f, -0.676836f, 1.79556f, 
		-3.25634f, -0.663781f, 1.84401f, -3.25634f, -0.663781f, 1.84401f, 
		-3.25634f, -0.663781f, 1.84401f, -3.25634f, -0.663781f, 1.84401f, 
		-3.25634f, -0.663781f, 1.84401f, -3.25625f, -0.668601f, 1.84448f, 
		-3.25625f, -0.668601f, 1.84448f, -3.25625f, -0.668601f, 1.84448f, 
		-3.25389f, -0.692203f, 1.70165f, -3.25389f, -0.692203f, 1.70165f, 
		-3.25389f, -0.692203f, 1.70165f, -3.25158f, -0.692203f, 1.79423f, 
		-3.25158f, -0.692203f, 1.79423f, -3.25158f, -0.692203f, 1.79423f, 
		-3.25139f, -0.709340f, 1.70180f, -3.25139f, -0.709340f, 1.70180f, 
		-3.25139f, -0.709340f, 1.70180f, -3.24929f, -0.692899f, 1.70413f, 
		-3.24929f, -0.692899f, 1.70413f, -3.24929f, -0.692899f, 1.70413f, 
		-3.24910f, -0.709340f, 1.79395f, -3.24910f, -0.709340f, 1.79395f, 
		-3.24910f, -0.709340f, 1.79395f, -3.24711f, -0.692899f, 1.79151f, 
		-3.24711f, -0.692899f, 1.79151f, -3.24711f, -0.692899f, 1.79151f, 
		-3.24442f, -0.673695f, 1.64965f, -3.24442f, -0.673695f, 1.64965f, 
		-3.24442f, -0.673695f, 1.64965f, -3.24117f, -0.691196f, 1.64888f, 
		-3.24117f, -0.691196f, 1.64888f, -3.24117f, -0.691196f, 1.64888f, 
		-3.23953f, -0.673695f, 1.84569f, -3.23953f, -0.673695f, 1.84569f, 
		-3.23953f, -0.673695f, 1.84569f, -3.23894f, -0.709344f, 1.64442f, 
		-3.23894f, -0.709344f, 1.64442f, -3.23894f, -0.709344f, 1.64442f, 
		-3.23675f, -0.691725f, 1.64392f, -3.23675f, -0.691725f, 1.64392f, 
		-3.23675f, -0.691725f, 1.64392f, -3.23625f, -0.691197f, 1.84630f, 
		-3.23625f, -0.691197f, 1.84630f, -3.23625f, -0.691197f, 1.84630f, 
		-3.23380f, -0.709345f, 1.85064f, -3.23380f, -0.709345f, 1.85064f, 
		-3.23380f, -0.709345f, 1.85064f, -3.23159f, -0.691725f, 1.85103f, 
		-3.23159f, -0.691725f, 1.85103f, -3.23159f, -0.691725f, 1.85103f
	};
	static GLfloat NormalData[] = {
		-0.990601f, -0.0310639f, -0.133211f, -0.978987f, -0.0492545f, 0.197884f, -0.976260f, 0.214658f, 0.0289692f, 
		-0.976260f, 0.214658f, 0.0289692f, -0.940973f, 0.207048f, -0.267769f, 
		-0.940973f, 0.207048f, -0.267769f, -0.972565f, -0.211135f, -0.0976682f, 
		-0.939739f, -0.259423f, 0.222690f, -0.934808f, 0.239214f, 0.262508f, 
		-0.934808f, 0.239214f, 0.262508f, -0.898946f, -0.166770f, -0.405073f, 
		-0.872901f, 0.109889f, -0.475361f, -0.872901f, 0.109889f, -0.475361f, 
		-0.897356f, -0.421094f, -0.132026f, -0.883984f, 0.453252f, -0.114605f, 
		-0.883984f, 0.453252f, -0.114605f, -0.883984f, 0.453252f, -0.114605f, 
		-0.812939f, 0.580197f, 0.0500182f, -0.812939f, 0.580197f, 0.0500182f, 
		-0.812939f, 0.580197f, 0.0500182f, -0.812939f, 0.580197f, 0.0500182f, 
		0.912214f, -0.359000f, -0.197447f, 0.980046f, 0.169804f, 0.103329f, 
		0.972635f, -0.184106f, -0.141726f, 0.853951f, 0.455389f, 0.251771f, 
		-0.791455f, 0.475647f, -0.383873f, -0.791455f, 0.475647f, -0.383873f, 
		-0.863826f, -0.421563f, 0.275843f, -0.861620f, -0.00273749f, 0.507547f, 
		-0.861620f, -0.00273749f, 0.507547f, 0.282236f, 0.742539f, -0.607436f, 
		0.282236f, 0.742539f, -0.607436f, 0.983899f, 0.0917280f, -0.153390f, 
		0.998448f, 0.0411413f, 0.0375263f, -0.623388f, 0.200088f, -0.755878f, 
		-0.623388f, 0.200088f, -0.755878f, 0.994707f, -0.0446940f, -0.0925203f, 
		0.971479f, 0.126802f, 0.200373f, 0.983380f, 0.0502470f, 0.174469f, 
		0.988808f, -0.0256546f, 0.146972f, -0.801366f, 0.582828f, 0.134630f, 
		-0.801366f, 0.582828f, 0.134630f, -0.855214f, 0.248519f, 0.454804f, 
		-0.855214f, 0.248519f, 0.454804f, 0.376974f, 0.872981f, -0.309507f, 
		0.230253f, 0.821927f, 0.520980f, 0.902261f, 0.380154f, 0.203488f, 
		0.388872f, -0.858774f, -0.333596f, 0.529530f, -0.781554f, -0.329805f, 
		0.883524f, -0.409936f, -0.226576f, 0.957356f, -0.273681f, -0.0925681f, 
		-0.311492f, 0.635176f, -0.706770f, -0.311492f, 0.635176f, -0.706770f, 
		0.324409f, -0.803371f, -0.499353f, 0.935271f, -0.271751f, -0.226759f, 
		0.747565f, -0.643663f, -0.163843f, 0.879976f, -0.451651f, -0.147154f, 
		0.814753f, -0.559689f, -0.151413f, 0.672946f, -0.709496f, -0.209186f, 
		0.582743f, -0.766049f, -0.271255f, 0.670723f, -0.556748f, -0.490064f, 
		0.125335f, 0.243987f, -0.961645f, 0.820028f, -0.448453f, -0.355590f, 
		0.352628f, -0.716560f, -0.601826f, -0.559313f, -0.107696f, -0.821931f, 
		-0.436947f, -0.336847f, -0.834033f, -0.302378f, -0.453597f, -0.838342f, 
		0.407394f, 0.872690f, -0.269152f, 0.732992f, 0.669688f, -0.119336f, 
		0.838518f, 0.543772f, 0.0346393f, 0.766432f, 0.620623f, 0.165557f, 
		0.766432f, 0.620623f, 0.165557f, 0.938939f, 0.179228f, 0.293719f, 
		0.441263f, -0.893933f, -0.0785610f, 0.806718f, -0.590900f, 0.00652871f, 
		0.876226f, -0.480494f, 0.0367789f, -0.331471f, 0.303384f, -0.893356f, 
		-0.395246f, 0.239284f, -0.886862f, -0.461349f, 0.192315f, -0.866125f, 
		-0.395246f, 0.239284f, -0.886862f, -0.395246f, 0.239284f, -0.886862f, 
		-0.998089f, 0.0185571f, 0.0589414f, -0.943560f, -0.149600f, -0.295491f, 
		0.749144f, 0.587225f, 0.306514f, 0.749144f, 0.587225f, 0.306514f, 
		-0.978101f, -0.0664598f, -0.197237f, -0.823544f, -0.238634f, 0.514615f, 
		0.614571f, 0.713653f, 0.336158f, 0.395637f, 0.838631f, 0.374392f, 
		0.835478f, 0.452187f, 0.312253f, 0.489450f, 0.784133f, 0.381543f, 
		0.563326f, 0.739347f, 0.368821f, 0.898981f, -0.406082f, 0.164106f, 
		0.943410f, -0.259885f, 0.206004f, 0.415885f, -0.909416f, 0.00120033f, 
		0.527369f, -0.849425f, 0.0189476f, 0.415885f, -0.909416f, 0.00120033f, 
		-0.745587f, 0.0695442f, -0.662769f, -0.745587f, 0.0695442f, -0.662769f, 
		0.0529380f, 0.654176f, -0.754488f, 0.0529380f, 0.654176f, -0.754488f, 
		0.0529380f, 0.654176f, -0.754488f, 0.0529380f, 0.654176f, -0.754488f, 
		-0.737735f, -0.180654f, -0.650470f, 0.372905f, -0.922192f, -0.102493f, 
		0.372905f, -0.922192f, -0.102493f, 0.962332f, 0.101377f, 0.252268f, 
		0.973451f, 0.0278425f, 0.227196f, 0.977455f, -0.0714223f, 0.198697f, 
		0.969415f, -0.161297f, 0.184979f, 0.861688f, 0.415373f, 0.291477f, 
		-0.943560f, -0.149600f, -0.295491f, 0.422906f, 0.829838f, 0.364032f, 
		-0.316873f, -0.0176249f, -0.948304f, -0.263281f, -0.274798f, -0.924754f, 
		0.0753618f, -0.679272f, -0.730007f, -0.113723f, -0.529857f, -0.840428f, 
		-0.966814f, 0.110429f, 0.230383f, 0.252436f, -0.870422f, -0.422660f, 
		-0.161820f, -0.837187f, -0.522430f, 0.109468f, -0.879604f, -0.462940f, 
		0.252436f, -0.870422f, -0.422660f, -0.962373f, 0.245882f, -0.115676f, 
		-0.972931f, -0.229711f, -0.0252689f, 0.203220f, -0.686337f, -0.698314f, 
		0.203220f, -0.686337f, -0.698314f, 0.0548094f, 0.766972f, -0.639335f, 
		0.965032f, -0.203922f, 0.164708f, 0.404706f, -0.913033f, -0.0508262f, 
		0.404706f, -0.913033f, -0.0508262f, 0.140250f, 0.773065f, -0.618628f, 
		0.140250f, 0.773065f, -0.618628f, 0.100216f, -0.752490f, -0.650934f, 
		0.0308032f, 0.912820f, -0.407199f, 0.273545f, 0.864927f, -0.420801f, 
		-0.314807f, 0.931953f, -0.179886f, 0.257326f, 0.817715f, 0.514903f, 
		-0.524323f, 0.851087f, 0.0271255f, 0.105101f, -0.963104f, -0.247761f, 
		0.233789f, -0.907552f, -0.348845f, -0.0513134f, -0.913904f, -0.402674f, 
		-0.00350959f, -0.962087f, -0.272719f, 0.0633614f, -0.943817f, -0.324338f, 
		-0.975235f, -0.152023f, 0.160641f, -0.943560f, -0.149600f, -0.295491f, 
		0.727692f, 0.622122f, 0.288839f, 0.727692f, 0.622122f, 0.288839f, 
		-0.951649f, -0.240852f, -0.190668f, -0.916448f, 0.392271f, 0.0790320f, 
		0.169600f, 0.670139f, -0.722600f, 0.169600f, 0.670139f, -0.722600f, 
		0.169600f, 0.670139f, -0.722600f, 0.169600f, 0.670139f, -0.722600f, 
		0.943650f, 0.0718991f, 0.323040f, -0.900455f, 0.107036f, -0.421574f, 
		-0.261084f, 0.965315f, 0.00178994f, -0.0710677f, 0.951211f, -0.300244f, 
		0.143578f, 0.925176f, -0.351333f, -0.0144977f, 0.891275f, -0.453231f, 
		0.465457f, 0.880670f, -0.0881435f, 0.552608f, 0.821313f, 0.141662f, 
		-0.701519f, -0.708144f, 0.0800201f, 0.0779895f, -0.973703f, -0.214055f, 
		0.0779895f, -0.973703f, -0.214055f, -0.657196f, 0.401303f, -0.638004f, 
		-0.0108608f, 0.929600f, 0.368410f, 0.352198f, 0.876116f, 0.329208f, 
		0.157818f, 0.923259f, 0.350267f, -0.144678f, 0.924608f, 0.352376f, 
		0.477351f, 0.808070f, 0.345194f, -0.936300f, 0.312953f, -0.159380f, 
		0.0379695f, 0.416535f, -0.908327f, 0.138142f, 0.560480f, -0.816565f, 
		-0.195867f, 0.627951f, 0.753202f, -0.105824f, 0.267623f, -0.957695f, 
		0.753392f, -0.510396f, -0.414604f, 0.669193f, -0.549117f, -0.500651f, 
		0.614521f, -0.497727f, -0.612071f, 0.669193f, -0.549117f, -0.500651f, 
		-0.206539f, -0.963393f, -0.170923f, -0.841853f, -0.124703f, -0.525103f, 
		-0.0127405f, 0.769504f, -0.638515f, 0.147660f, 0.474499f, -0.867783f, 
		-0.885636f, 0.219192f, -0.409395f, -0.457986f, 0.770724f, -0.442982f, 
		0.125335f, 0.243987f, -0.961645f, -0.794104f, 0.456846f, -0.400863f, 
		0.173741f, 0.909718f, 0.377132f, -0.415978f, 0.864574f, 0.281910f, 
		-0.130303f, 0.931465f, 0.339697f, 0.207339f, -0.969853f, -0.128044f, 
		0.207339f, -0.969853f, -0.128044f, 0.516816f, 0.809095f, 0.279761f, 
		0.738312f, 0.607176f, 0.293653f, 0.611293f, 0.740405f, 0.279502f, 
		0.797661f, 0.517410f, 0.309878f, 0.681220f, 0.673605f, 0.286699f, 
		0.681220f, 0.673605f, 0.286699f, -0.562685f, -0.768342f, -0.305016f, 
		0.0476365f, 0.960944f, 0.272613f, 0.149966f, 0.962470f, 0.226188f, 
		-0.131428f, 0.952727f, 0.273932f, 0.857764f, 0.300055f, 0.417383f, 
		0.803449f, 0.498901f, 0.324911f, 0.793480f, 0.168408f, 0.584832f, 
		0.213334f, -0.934663f, 0.284418f, 0.144018f, 0.590982f, -0.793725f, 
		-0.195867f, 0.627951f, 0.753202f, 0.144018f, 0.590982f, -0.793725f, 
		-0.0374914f, 0.606854f, -0.793928f, -0.342375f, 0.535149f, -0.772266f, 
		-0.760935f, -0.394711f, -0.514958f, -0.436136f, -0.679019f, -0.590523f, 
		-0.862582f, -0.185220f, -0.470793f, -0.0117431f, 0.0885186f, -0.996005f, 
		-0.222705f, -0.734964f, -0.640493f, -0.946602f, -0.224590f, -0.231309f, 
		-0.970809f, 0.0377660f, -0.236864f, -0.959107f, 0.184331f, -0.214793f, 
		-0.959107f, 0.184331f, -0.214793f, -0.970809f, 0.0377660f, -0.236864f, 
		0.760739f, -0.648999f, 0.00873339f, 0.557070f, 0.710711f, 0.429607f, 
		-0.889283f, 0.402881f, -0.216478f, -0.195867f, 0.627951f, 0.753202f, 
		0.874176f, -0.378843f, 0.303798f, 0.773346f, -0.593959f, 0.221694f, 
		0.485043f, -0.871432f, 0.0730719f, 0.656991f, -0.490098f, -0.572859f, 
		0.656991f, -0.490098f, -0.572859f, -0.313628f, 0.538046f, -0.782396f, 
		-0.313628f, 0.538046f, -0.782396f, 0.701187f, 0.651650f, 0.289291f, 
		0.650543f, 0.709784f, 0.270185f, 0.701187f, 0.651650f, 0.289291f, 
		0.784143f, 0.534614f, 0.315132f, -0.908944f, 0.0336116f, 0.415561f, 
		-0.741751f, -0.492877f, 0.454838f, -0.981535f, -0.135079f, 0.135438f, 
		0.823855f, -0.512931f, -0.241173f, -0.130463f, 0.625212f, -0.769474f, 
		-0.342375f, 0.535149f, -0.772266f, 0.291063f, 0.624260f, -0.724970f, 
		0.823855f, -0.512931f, -0.241173f, 0.468546f, 0.642259f, -0.606604f, 
		-0.882461f, -0.449566f, -0.138395f, 0.190956f, 0.974906f, -0.114431f, 
		0.859762f, 0.509216f, 0.0388413f, -0.882461f, -0.449566f, -0.138395f, 
		-0.563656f, 0.530299f, -0.633305f, -0.988499f, 0.151057f, 0.00719364f, 
		-0.994832f, -0.0509370f, -0.0878383f, -0.994832f, -0.0509370f, -0.0878383f, 
		-0.988499f, 0.151057f, 0.00719364f, -0.950018f, -0.257689f, -0.176242f, 
		0.0555280f, -0.961314f, -0.269801f, -0.201690f, -0.908860f, -0.365096f, 
		0.208447f, -0.964860f, -0.159982f, 0.393528f, 0.683984f, -0.614249f, 
		0.393528f, 0.683984f, -0.614249f, -0.749729f, -0.149667f, -0.644598f, 
		-0.189457f, -0.670967f, -0.716875f, -0.453392f, -0.891311f, 0.000936934f, 
		-0.674356f, -0.713581f, -0.189860f, -0.327529f, -0.941491f, 0.0794896f, 
		-0.0237789f, -0.997996f, 0.0586462f, 0.288464f, -0.957322f, -0.0179473f, 
		-0.981148f, -0.0996514f, 0.165584f, -0.864478f, 0.310519f, 0.395292f, 
		-0.964131f, 0.0430954f, 0.261905f, -0.981148f, -0.0996514f, 0.165584f, 
		-0.964131f, 0.0430954f, 0.261905f, 0.0804585f, 0.973056f, 0.216076f, 
		0.310535f, -0.950275f, -0.0233566f, 0.0804585f, 0.973056f, 0.216076f, 
		0.859762f, 0.509216f, 0.0388413f, 0.310535f, -0.950275f, -0.0233566f, 
		-0.208872f, 0.812729f, -0.543916f, -0.868780f, 0.495065f, 0.0114780f, 
		-0.572632f, 0.819262f, 0.0300513f, -0.828269f, 0.513043f, -0.225293f, 
		-0.587659f, 0.800271f, 0.119259f, -0.393260f, 0.906816f, 0.151762f, 
		0.178768f, 0.982803f, 0.0462674f, 0.0508688f, 0.997106f, 0.0564985f, 
		-0.282348f, 0.952442f, -0.114601f, 0.934009f, 0.0367148f, 0.355358f, 
		0.998856f, 0.0268758f, -0.0395447f, 0.977905f, 0.0481428f, -0.203432f, 
		-0.943538f, -0.306807f, 0.124921f, -0.956591f, -0.284750f, -0.0620516f, 
		-0.649357f, 0.673123f, 0.353895f, -0.785712f, 0.568950f, 0.242803f, 
		-0.785712f, 0.568950f, 0.242803f, -0.443198f, 0.773456f, 0.453146f, 
		-0.649357f, 0.673123f, 0.353895f, -0.443198f, 0.773456f, 0.453146f, 
		-0.897723f, 0.383264f, 0.217259f, -0.963212f, -0.101896f, -0.248674f, 
		-0.963212f, -0.101896f, -0.248674f, -0.963212f, -0.101896f, -0.248674f, 
		0.490579f, -0.677150f, 0.548452f, -0.857893f, 0.192210f, -0.476523f, 
		0.462471f, 0.886192f, 0.0280171f, -0.857893f, 0.192210f, -0.476523f, 
		-0.857893f, 0.192210f, -0.476523f, 0.462471f, 0.886192f, 0.0280171f, 
		-0.778467f, -0.384094f, -0.496449f, -0.852022f, -0.287650f, -0.437397f, 
		-0.660866f, -0.633292f, -0.402737f, -0.852022f, -0.287650f, -0.437397f, 
		-0.896567f, -0.167691f, 0.409935f, -0.788098f, -0.613757f, -0.0469471f, 
		-0.699806f, -0.708654f, -0.0898984f, -0.699806f, -0.708654f, -0.0898984f, 
		-0.699806f, -0.708654f, -0.0898984f, -0.641129f, -0.760161f, -0.105393f, 
		-0.403820f, -0.726982f, 0.555361f, -0.595777f, -0.800482f, 0.0654076f, 
		-0.692812f, -0.690095f, -0.209237f, -0.532798f, -0.781804f, 0.323897f, 
		-0.796268f, -0.575181f, 0.187415f, -0.680031f, -0.726575f, 0.0982175f, 
		-0.963283f, -0.171912f, 0.206234f, -0.680031f, -0.726575f, 0.0982175f, 
		-0.351015f, -0.876158f, -0.330356f, -0.599521f, -0.723417f, -0.342405f, 
		-0.711141f, -0.612891f, -0.344445f, -0.892466f, 0.424089f, -0.153794f, 
		-0.803464f, 0.588793f, -0.0881434f, -0.892466f, 0.424089f, -0.153794f, 
		-0.803464f, 0.588793f, -0.0881434f, -0.622399f, 0.782362f, 0.0230261f, 
		-0.140917f, 0.988336f, 0.0577452f, -0.562685f, -0.768342f, -0.305016f, 
		-0.390284f, 0.920538f, -0.0169820f, 0.954142f, 0.299014f, -0.0142476f, 
		0.705477f, 0.692589f, -0.150411f, 0.816182f, 0.576192f, -0.0430084f, 
		0.945672f, 0.223518f, -0.236103f, 0.807280f, 0.537291f, -0.244167f, 
		0.906168f, 0.138907f, 0.399454f, 0.931632f, -0.0614795f, 0.358165f, 
		0.927330f, 0.0586738f, 0.369617f, -0.772116f, -0.262838f, -0.578579f, 
		-0.568351f, -0.466166f, -0.677987f, -0.712847f, -0.472081f, -0.518642f, 
		-0.345111f, -0.671846f, -0.655378f, -0.435911f, -0.747331f, -0.501475f, 
		0.818686f, -0.305514f, -0.486225f, 0.622200f, 0.559907f, -0.547148f, 
		-0.666490f, 0.0742545f, -0.741807f, -0.0718295f, 0.947610f, 0.311248f, 
		-0.570251f, -0.678328f, -0.463340f, -0.198163f, 0.844508f, 0.497531f, 
		0.0804585f, 0.973056f, 0.216076f, -0.570251f, -0.678328f, -0.463340f, 
		0.909704f, -0.00969842f, 0.415144f, -0.633830f, -0.743020f, -0.214896f, 
		-0.633830f, -0.743020f, -0.214896f, -0.633830f, -0.743020f, -0.214896f, 
		0.431572f, -0.901428f, 0.0342534f, -0.895984f, -0.226619f, -0.381913f, 
		-0.965873f, 0.0197602f, -0.258261f, -0.968394f, 0.121267f, -0.217961f, 
		-0.695762f, -0.648362f, -0.309099f, -0.855012f, -0.399976f, -0.330111f, 
		-0.630731f, -0.703763f, -0.326950f, -0.570090f, -0.768323f, -0.290994f, 
		-0.466727f, -0.831282f, -0.301888f, 0.956330f, -0.137474f, 0.257941f, 
		0.310535f, -0.950275f, -0.0233566f, 0.956330f, -0.137474f, 0.257941f, 
		0.310535f, -0.950275f, -0.0233566f, -0.658301f, 0.528893f, 0.535641f, 
		0.422749f, -0.720686f, 0.549450f, -0.330216f, 0.754119f, 0.567681f, 
		-0.462943f, 0.672103f, 0.577893f, 0.422749f, -0.720686f, 0.549450f, 
		0.989584f, -0.137999f, -0.0409846f, -0.330216f, 0.754119f, 0.567681f, 
		0.375311f, -0.866662f, -0.328692f, 0.527619f, 0.831340f, -0.174619f, 
		-0.330216f, 0.754119f, 0.567681f, -0.812552f, 0.301570f, 0.498813f, 
		-0.470765f, -0.840800f, 0.267274f, -0.798166f, 0.440452f, -0.411016f, 
		-0.731719f, -0.638135f, -0.239522f, -0.773988f, -0.585629f, -0.240792f, 
		-0.731719f, -0.638135f, -0.239522f, -0.731719f, -0.638135f, -0.239522f, 
		-0.685054f, -0.686409f, -0.244016f, -0.731719f, -0.638135f, -0.239522f, 
		-0.951852f, -0.0839128f, -0.294851f, -0.954840f, -0.0233338f, -0.296202f, 
		-0.951852f, -0.0839128f, -0.294851f, -0.951852f, -0.0839128f, -0.294851f, 
		-0.941333f, -0.156976f, -0.298749f, 0.956330f, -0.137474f, 0.257941f, 
		0.721016f, 0.465284f, 0.513466f, 0.572061f, 0.787068f, 0.230803f, 
		0.916756f, 0.0671995f, 0.393754f, 0.462471f, 0.886192f, 0.0280171f, 
		0.835371f, -0.421943f, 0.352306f, 0.689998f, -0.637621f, 0.342553f, 
		0.460581f, -0.851826f, 0.249513f, -0.863592f, -0.237538f, -0.444730f, 
		-0.709985f, 0.185944f, 0.679225f, 0.310906f, 0.143683f, -0.939517f, 
		-0.899095f, -0.367731f, 0.237491f, -0.205847f, -0.936063f, -0.285331f, 
		0.350166f, -0.884942f, 0.307020f, -0.477521f, -0.874627f, 0.0836739f, 
		0.350166f, -0.884942f, 0.307020f, -0.477521f, -0.874627f, 0.0836739f, 
		-0.922025f, -0.320305f, -0.217427f, -0.645144f, -0.669357f, 0.368443f, 
		-0.657219f, -0.724912f, -0.206315f, -0.657219f, -0.724912f, -0.206315f, 
		-0.657219f, -0.724912f, -0.206315f, -0.657219f, -0.724912f, -0.206315f, 
		0.932318f, -0.185233f, 0.310599f, 0.329242f, -0.939183f, 0.0976433f, 
		-0.572910f, 0.706647f, -0.415241f, -0.397590f, 0.809846f, -0.431361f, 
		-0.297179f, 0.469436f, -0.831454f, -0.408091f, 0.714334f, -0.568496f, 
		-0.838242f, 0.473686f, -0.270134f, -0.933007f, 0.237077f, -0.270725f, 
		-0.261202f, 0.717243f, -0.646015f, -0.297712f, 0.903620f, 0.307957f, 
		-0.533193f, 0.774915f, 0.339430f, -0.663977f, 0.630354f, 0.402230f, 
		-0.698017f, -0.667037f, -0.260449f, -0.756037f, -0.597015f, -0.268294f, 
		-0.614939f, -0.740858f, -0.270148f, -0.698017f, -0.667037f, -0.260449f, 
		0.629839f, -0.432496f, 0.645175f, 0.0673658f, 0.728327f, 0.681910f, 
		-0.167295f, 0.779090f, 0.604178f, 0.481460f, -0.642105f, 0.596571f, 
		-0.167295f, 0.779090f, 0.604178f, -0.368869f, -0.680475f, -0.633158f, 
		-0.800035f, 0.0423162f, -0.598460f, 0.600280f, 0.398564f, 0.693405f, 
		0.724156f, -0.0894458f, 0.683811f, -0.389144f, -0.489896f, 0.780108f, 
		0.270752f, 0.947814f, 0.168353f, 0.270752f, 0.947814f, 0.168353f, 
		0.270752f, 0.947814f, 0.168353f, 0.354793f, 0.882948f, 0.307449f, 
		0.354793f, 0.882948f, 0.307449f, 0.606543f, 0.694166f, 0.387607f, 
		0.831457f, 0.379863f, 0.405443f, 0.354793f, 0.882948f, 0.307449f, 
		-0.562685f, -0.768342f, -0.305016f, 0.158360f, 0.985559f, 0.0599606f, 
		0.472968f, -0.692802f, -0.544358f, 0.140452f, -0.903026f, -0.405978f, 
		0.0472234f, -0.930780f, -0.362517f, -0.932129f, -0.350685f, -0.0903091f, 
		-0.270762f, -0.944343f, -0.186825f, 0.993978f, 0.0283239f, -0.105859f, 
		0.977133f, -0.179101f, -0.114602f, 0.948698f, 0.306661f, -0.0770073f, 
		-0.717866f, 0.154558f, -0.678808f, 0.998599f, 0.0338434f, 0.0406812f, 
		0.998599f, 0.0338434f, 0.0406812f, -0.0252820f, -0.322484f, 0.946237f, 
		-0.139745f, 0.760258f, 0.634412f, -0.139745f, 0.760258f, 0.634412f, 
		-0.139745f, 0.760258f, 0.634412f, -0.139745f, 0.760258f, 0.634412f, 
		-0.139745f, 0.760258f, 0.634412f, -0.893128f, 0.449297f, 0.0213190f, 
		-0.974752f, 0.222751f, -0.0155075f, -0.531582f, 0.0834102f, -0.842890f, 
		-0.498616f, 0.865452f, 0.0487321f, -0.267488f, 0.961591f, 0.0615792f, 
		-0.109121f, -0.990440f, 0.0843919f, 0.115650f, -0.979409f, 0.165478f, 
		0.0334718f, -0.992587f, 0.116838f, -0.138510f, -0.990171f, -0.0193868f, 
		0.0334718f, -0.992587f, 0.116838f, 0.227521f, -0.953927f, 0.195596f, 
		-0.702683f, 0.709942f, -0.0470980f, -0.868531f, 0.491161f, -0.0664483f, 
		-0.695641f, 0.703849f, -0.143806f, -0.855181f, 0.488330f, -0.173782f, 
		-0.699064f, -0.667130f, -0.257385f, -0.0711223f, -0.682393f, -0.727517f, 
		0.408096f, -0.901305f, 0.145283f, -0.388272f, 0.870873f, 0.301372f, 
		-0.615160f, 0.738506f, 0.276018f, -0.905882f, 0.407051f, 0.116989f, 
		-0.509135f, 0.799033f, 0.319887f, -0.955200f, 0.271114f, 0.118704f, 
		-0.790184f, 0.572110f, 0.219772f, -0.344270f, 0.838852f, 0.421669f, 
		-0.576153f, 0.713438f, 0.398816f, 0.274298f, 0.948507f, 0.158418f, 
		0.274298f, 0.948507f, 0.158418f, 0.126075f, 0.968095f, 0.216557f, 
		-0.345921f, 0.898461f, 0.270384f, -0.785431f, -0.577706f, -0.222159f, 
		-0.345921f, 0.898461f, 0.270384f, -0.467671f, -0.669113f, 0.577557f, 
		-0.785431f, -0.577706f, -0.222159f, -0.732308f, -0.384188f, -0.562249f, 
		-0.815267f, -0.351503f, -0.460201f, -0.774353f, -0.379482f, -0.506331f, 
		-0.774353f, -0.379482f, -0.506331f, -0.833590f, -0.0336256f, -0.551359f, 
		-0.527460f, 0.241779f, -0.814450f, -0.663027f, 0.251363f, -0.705133f, 
		-0.879524f, -0.0993701f, -0.465363f, -0.889179f, -0.229194f, -0.396019f, 
		-0.637546f, 0.739927f, -0.214578f, -0.637546f, 0.739927f, -0.214578f, 
		-0.134569f, 0.953212f, 0.270698f, 0.0877147f, 0.959959f, 0.266054f, 
		0.0877147f, 0.959959f, 0.266054f, 0.204551f, 0.951841f, 0.228378f, 
		-0.267649f, -0.752504f, -0.601749f, -0.657501f, -0.715461f, -0.236237f, 
		-0.657501f, -0.715461f, -0.236237f, -0.459590f, -0.753155f, -0.470675f, 
		-0.267649f, -0.752504f, -0.601749f, -0.783114f, 0.596197f, -0.176869f, 
		-0.852046f, -0.349451f, 0.389745f, -0.0552214f, -0.498749f, 0.864985f, 
		-0.261202f, 0.717243f, -0.646015f, -0.934645f, 0.291827f, 0.203165f, 
		0.840683f, 0.541526f, 0.000932488f, -0.258130f, -0.957768f, -0.126684f, 
		-0.258130f, -0.957768f, -0.126684f, -0.604702f, -0.666288f, -0.436343f, 
		-0.964089f, -0.0716956f, -0.255719f, -0.922870f, -0.287494f, -0.256239f, 
		-0.716330f, 0.00306570f, -0.697755f, -0.901888f, -0.0335364f, -0.430667f, 
		-0.354960f, -0.783352f, -0.510258f, 0.382584f, -0.845829f, 0.371757f, 
		0.601614f, -0.644554f, 0.471817f, 0.382584f, -0.845829f, 0.371757f, 
		0.762400f, -0.251626f, 0.596180f, -0.155773f, -0.812749f, 0.561403f, 
		-0.105256f, -0.904898f, 0.412409f, -0.0792086f, -0.953439f, 0.290998f, 
		-0.0420259f, -0.997861f, 0.0500695f, 0.0257012f, -0.998800f, -0.0416794f, 
		0.111976f, -0.980181f, -0.163419f, -0.937631f, -0.333216f, -0.0990731f, 
		-0.893162f, -0.0627458f, -0.445337f, -0.893162f, -0.0627458f, -0.445337f, 
		-0.893162f, -0.0627458f, -0.445337f, -0.893162f, -0.0627458f, -0.445337f, 
		0.865221f, -0.443391f, -0.234087f, 0.865221f, -0.443391f, -0.234087f, 
		0.00563249f, -0.133782f, 0.990995f, 0.865221f, -0.443391f, -0.234087f, 
		-0.134628f, -0.842997f, -0.520799f, 0.310906f, 0.143683f, -0.939517f, 
		0.0336853f, 0.999153f, 0.0236549f, -0.727252f, -0.676542f, -0.115737f, 
		-0.0252820f, -0.322484f, 0.946237f, 0.310906f, 0.143683f, -0.939517f, 
		-0.996359f, -0.0251657f, 0.0814556f, -0.987024f, 0.0971809f, -0.127822f, 
		-0.894124f, 0.121116f, -0.431130f, -0.894124f, 0.121116f, -0.431130f, 
		0.927978f, 0.183933f, -0.324077f, 0.804461f, -0.170769f, -0.568930f, 
		0.958595f, 0.264547f, -0.105406f, -0.864964f, 0.283911f, -0.413802f, 
		-0.769510f, 0.517422f, -0.374338f, -0.350471f, 0.910253f, -0.220474f, 
		-0.864964f, 0.283911f, -0.413802f, -0.835850f, 0.412450f, -0.362271f, 
		-0.551504f, 0.777868f, -0.301272f, -0.454047f, 0.838128f, -0.302297f, 
		-0.903100f, 0.108594f, 0.415473f, -0.903100f, 0.108594f, 0.415473f, 
		0.883297f, 0.0601412f, 0.464940f, -0.726195f, -0.653402f, -0.213791f, 
		-0.726195f, -0.653402f, -0.213791f, -0.726195f, -0.653402f, -0.213791f, 
		0.288949f, 0.600903f, 0.745267f, 0.0756304f, 0.495358f, 0.865390f, 
		0.300855f, 0.347814f, 0.887982f, 0.368152f, 0.379345f, 0.848859f, 
		-0.711362f, -0.0349342f, 0.701957f, -0.711362f, -0.0349342f, 0.701957f, 
		-0.0357851f, -0.670710f, 0.740856f, 0.0425286f, -0.606616f, 0.793857f, 
		-0.0357851f, -0.670710f, 0.740856f, -0.0773286f, -0.748451f, 0.658666f, 
		-0.850132f, 0.355305f, 0.388632f, 0.572496f, -0.729186f, -0.374882f, 
		0.572496f, -0.729186f, -0.374882f, 0.852033f, -0.316710f, -0.416816f, 
		0.897181f, -0.366469f, -0.246507f, 0.819893f, -0.299529f, -0.487911f, 
		-0.261202f, 0.717243f, -0.646015f, -0.0217876f, 0.993616f, 0.110689f, 
		0.389610f, 0.918970f, 0.0608189f, 0.146879f, 0.984488f, 0.0959651f, 
		0.708208f, -0.658134f, -0.255542f, 0.708208f, -0.658134f, -0.255542f, 
		-0.716330f, 0.00306570f, -0.697755f, 0.0824398f, 0.990795f, -0.107369f, 
		0.995525f, 0.0388832f, -0.0861265f, -0.920013f, -0.389032f, -0.0472263f, 
		-0.826657f, -0.414973f, -0.380047f, -0.754265f, -0.540506f, -0.372743f, 
		-0.826657f, -0.414973f, -0.380047f, -0.459637f, -0.841353f, -0.284355f, 
		-0.655883f, 0.635785f, 0.406933f, 0.298421f, 0.950798f, -0.0832313f, 
		0.170857f, -0.926180f, 0.336152f, 0.507201f, -0.163566f, 0.846164f, 
		0.256574f, -0.135166f, 0.957027f, 0.170857f, -0.926180f, 0.336152f, 
		0.680439f, -0.200448f, 0.704857f, -0.663132f, 0.403136f, 0.630664f, 
		-0.663132f, 0.403136f, 0.630664f, 0.793142f, -0.438439f, 0.422726f, 
		0.718317f, -0.562071f, 0.409995f, 0.465936f, -0.831056f, 0.303726f, 
		0.268563f, -0.925673f, -0.266463f, -0.856915f, -0.0774678f, -0.509604f, 
		0.122598f, -0.889913f, -0.439346f, 0.984316f, -0.0404823f, -0.171707f, 
		0.196130f, -0.902209f, -0.384125f, -0.415958f, -0.887199f, -0.199644f, 
		-0.415958f, -0.887199f, -0.199644f, -0.389193f, -0.508778f, 0.767902f, 
		-0.109003f, 0.984396f, 0.138143f, -0.931694f, -0.268711f, 0.244420f, 
		-0.473884f, -0.880289f, -0.0228985f, 0.864964f, 0.202265f, 0.459268f, 
		0.400102f, 0.848714f, 0.345837f, 0.997974f, -0.0463329f, -0.0436141f, 
		0.932228f, -0.353061f, -0.0793687f, 0.979911f, 0.197854f, 0.0250485f, 
		0.246255f, -0.968185f, -0.0444685f, 0.973750f, 0.223413f, -0.0435612f, 
		0.912488f, 0.409009f, -0.00877539f, 0.793837f, -0.404374f, -0.454207f, 
		0.943139f, -0.177176f, -0.281242f, 0.912488f, 0.409009f, -0.00877539f, 
		0.548881f, 0.0455032f, 0.834661f, 0.637136f, -0.00248805f, 0.770747f, 
		0.637136f, -0.00248805f, 0.770747f, 0.737602f, -0.00481186f, 0.675218f, 
		0.637136f, -0.00248805f, 0.770747f, -0.524460f, -0.818331f, -0.235107f, 
		-0.459028f, 0.826350f, 0.326250f, -0.459028f, 0.826350f, 0.326250f, 
		-0.459028f, 0.826350f, 0.326250f, 0.457712f, 0.885427f, 0.0807321f, 
		0.457712f, 0.885427f, 0.0807321f, -0.866507f, -0.468141f, 0.173236f, 
		-0.746568f, -0.626754f, -0.223193f, -0.421599f, 0.900939f, -0.102778f, 
		-0.0637170f, -0.667057f, -0.742277f, -0.746568f, -0.626754f, -0.223193f, 
		-0.690424f, -0.0435041f, -0.722096f, -0.884368f, -0.000778097f, -0.466790f, 
		-0.847095f, 0.168621f, -0.503981f, -0.717223f, 0.468309f, -0.516022f, 
		-0.717223f, 0.468309f, -0.516022f, -0.847095f, 0.168621f, -0.503981f, 
		-0.884368f, -0.000778097f, -0.466790f, -0.649382f, 0.494628f, 0.577621f, 
		-0.649382f, 0.494628f, 0.577621f, -0.649382f, 0.494628f, 0.577621f, 
		-0.649382f, 0.494628f, 0.577621f, -0.451648f, 0.891540f, 0.0342039f, 
		-0.451648f, 0.891540f, 0.0342039f, 0.721583f, 0.690620f, 0.0485932f, 
		0.783520f, 0.620022f, 0.0408663f, 0.721583f, 0.690620f, 0.0485932f, 
		0.573123f, 0.810543f, 0.120626f, -0.806747f, 0.110492f, 0.580474f, 
		-0.640896f, -0.241531f, 0.728639f, -0.640896f, -0.241531f, 0.728639f, 
		-0.467340f, 0.601747f, -0.647684f, 0.656289f, -0.332249f, -0.677419f, 
		-0.237129f, -0.496323f, -0.835125f, -0.401819f, -0.454439f, -0.795001f, 
		-0.237129f, -0.496323f, -0.835125f, 0.599534f, 0.153705f, 0.785452f, 
		0.255631f, -0.463320f, -0.848521f, -0.401819f, -0.454439f, -0.795001f, 
		-0.235212f, -0.576684f, -0.782375f, -0.353849f, -0.669352f, -0.653268f, 
		-0.812160f, -0.569570f, -0.126439f, -0.734007f, -0.580714f, -0.352144f, 
		-0.629426f, 0.629069f, -0.456175f, -0.588858f, 0.704516f, -0.396110f, 
		-0.722596f, 0.504151f, -0.472955f, -0.365252f, 0.888328f, -0.278324f, 
		-0.487374f, 0.792961f, -0.365621f, -0.219387f, -0.757578f, 0.614772f, 
		-0.219387f, -0.757578f, 0.614772f, 0.234257f, 0.971962f, -0.0203301f, 
		-0.787106f, -0.255262f, -0.561521f, -0.0571643f, -0.971208f, -0.231271f, 
		-0.787106f, -0.255262f, -0.561521f, -0.233985f, 0.612522f, -0.755029f, 
		0.794220f, 0.607117f, 0.0249723f, 0.794220f, 0.607117f, 0.0249723f, 
		-0.831847f, -0.327310f, -0.448218f, -0.595090f, 0.647432f, -0.476130f, 
		-0.595090f, 0.647432f, -0.476130f, 0.549609f, -0.628425f, -0.550465f, 
		0.716858f, -0.333689f, -0.612182f, 0.507672f, -0.759882f, -0.406016f, 
		0.349771f, -0.914141f, 0.204955f, 0.907883f, 0.0346140f, 0.417793f, 
		0.907883f, 0.0346140f, 0.417793f, 0.925374f, 0.288611f, 0.245736f, 
		0.565165f, 0.725768f, 0.392237f, 0.804069f, 0.554267f, 0.215085f, 
		0.880022f, 0.471804f, 0.0544304f, -0.104735f, -0.415134f, -0.903711f, 
		0.797579f, -0.142626f, -0.586110f, 0.599534f, 0.153705f, 0.785452f, 
		-0.164187f, 0.800328f, 0.576643f, -0.164187f, 0.800328f, 0.576643f, 
		-0.165240f, -0.500219f, 0.849986f, -0.459557f, -0.621258f, 0.634701f, 
		-0.0507498f, -0.417544f, 0.907239f, -0.959856f, 0.0179732f, -0.279915f, 
		-0.844531f, 0.162219f, -0.510345f, -0.844531f, 0.162219f, -0.510345f, 
		-0.945527f, -0.0948105f, 0.311431f, -0.985746f, -0.126022f, 0.111461f, 
		0.965227f, -0.244395f, -0.0927754f, 0.882935f, -0.447325f, -0.142572f, 
		0.313254f, -0.910246f, -0.270786f, 0.492594f, -0.832798f, -0.252584f, 
		-0.570906f, 0.0668933f, -0.818286f, -0.570906f, 0.0668933f, -0.818286f, 
		-0.180550f, -0.696709f, -0.694261f, -0.180550f, -0.696709f, -0.694261f, 
		-0.180550f, -0.696709f, -0.694261f, 0.220918f, -0.963370f, 0.152030f, 
		-0.254466f, 0.702316f, 0.664830f, -0.254466f, 0.702316f, 0.664830f, 
		-0.254466f, 0.702316f, 0.664830f, -0.254466f, 0.702316f, 0.664830f, 
		-0.584943f, 0.790078f, -0.183351f, -0.584943f, 0.790078f, -0.183351f, 
		-0.0362251f, -0.993326f, 0.109501f, -0.0362251f, -0.993326f, 0.109501f, 
		-0.0362251f, -0.993326f, 0.109501f, -0.0362251f, -0.993326f, 0.109501f, 
		-0.0362251f, -0.993326f, 0.109501f, 0.692699f, 0.706591f, 0.144563f, 
		0.347283f, 0.913808f, 0.210590f, 0.845419f, 0.528578f, 0.0766264f, 
		0.103197f, 0.992726f, 0.0620102f, 0.191290f, 0.974154f, 0.120136f, 
		0.235894f, 0.959946f, 0.151188f, -0.155116f, -0.973023f, 0.170778f, 
		-0.966040f, -0.0283973f, 0.256827f, -0.155116f, -0.973023f, 0.170778f, 
		0.108588f, -0.0707720f, 0.991564f, -0.155116f, -0.973023f, 0.170778f, 
		-0.933701f, -0.254059f, -0.252302f, -0.347887f, -0.923755f, -0.160162f, 
		-0.933701f, -0.254059f, -0.252302f, -0.347887f, -0.923755f, -0.160162f, 
		0.0652506f, -0.997800f, -0.0117625f, -0.666523f, -0.637314f, -0.386754f, 
		-0.801877f, -0.447207f, -0.396232f, -0.801877f, -0.447207f, -0.396232f, 
		-0.149032f, -0.979864f, -0.132877f, -0.0268106f, -0.242321f, -0.969826f, 
		-0.696175f, 0.579493f, -0.423709f, -0.696175f, 0.579493f, -0.423709f, 
		-0.714710f, 0.507570f, 0.481210f, -0.714710f, 0.507570f, 0.481210f, 
		-0.741626f, 0.360481f, 0.565724f, -0.914905f, 0.0992562f, 0.391275f, 
		-0.199068f, 0.520728f, 0.830189f, -0.149679f, 0.430774f, 0.889961f, 
		0.0228303f, 0.277662f, 0.960407f, 0.217537f, -0.0877611f, 0.972099f, 
		0.155804f, 0.0989029f, 0.982824f, -0.401517f, 0.555940f, 0.727815f, 
		-0.322281f, 0.482911f, 0.814206f, 0.488062f, 0.868110f, 0.0904417f, 
		0.909045f, 0.407438f, -0.0873621f, 0.784931f, 0.604632f, -0.135288f, 
		0.326286f, 0.919903f, 0.217521f, -0.363652f, 0.739716f, -0.566195f, 
		-0.363652f, 0.739716f, -0.566195f, -0.363652f, 0.739716f, -0.566195f, 
		-0.363652f, 0.739716f, -0.566195f, -0.833185f, -0.488841f, -0.258529f, 
		-0.531137f, -0.198250f, -0.823766f, -0.531137f, -0.198250f, -0.823766f, 
		-0.531137f, -0.198250f, -0.823766f, -0.608121f, 0.495587f, -0.620147f, 
		0.739391f, -0.522284f, -0.424877f, 0.739391f, -0.522284f, -0.424877f, 
		0.790886f, -0.419022f, -0.446004f, 0.612199f, -0.638661f, -0.466181f, 
		-0.943999f, 0.113162f, 0.309935f, -0.943999f, 0.113162f, 0.309935f, 
		-0.954675f, 0.0122410f, 0.297398f, -0.918454f, 0.188043f, 0.347968f, 
		-0.759484f, -0.151950f, 0.632531f, 0.771160f, 0.564910f, 0.293581f, 
		0.771160f, 0.564910f, 0.293581f, 0.916936f, 0.220932f, 0.332292f, 
		0.627600f, 0.738157f, 0.247473f, -0.189500f, -0.981877f, -0.00252623f, 
		-0.180999f, -0.973018f, 0.143094f, -0.180999f, -0.973018f, 0.143094f, 
		-0.311728f, -0.616714f, 0.722834f, -0.242995f, -0.827877f, 0.505542f, 
		-0.706576f, 0.706076f, -0.0469763f, -0.544992f, -0.323018f, -0.773720f, 
		-0.544992f, -0.323018f, -0.773720f, -0.356608f, -0.933903f, -0.0256006f, 
		0.283103f, 0.910089f, 0.302639f, 0.804250f, -0.542197f, 0.243318f, 
		0.923843f, -0.239169f, 0.298851f, 0.509240f, -0.854101f, 0.105765f, 
		-0.763609f, -0.541973f, 0.350952f, -0.280432f, 0.933983f, -0.221434f, 
		-0.358225f, -0.717193f, -0.597754f, -0.358225f, -0.717193f, -0.597754f, 
		-0.611357f, 0.773850f, -0.165524f, -0.611357f, 0.773850f, -0.165524f, 
		-0.686571f, -0.645521f, -0.334551f, -0.686571f, -0.645521f, -0.334551f, 
		-0.850262f, -0.339548f, -0.402196f, -0.911665f, 0.0382178f, -0.409153f, 
		-0.421484f, 0.803237f, -0.420905f, -0.871560f, 0.278620f, -0.403428f, 
		-0.788076f, 0.397140f, -0.470337f, -0.739851f, 0.529769f, -0.414687f, 
		-0.527396f, 0.694594f, -0.489277f, -0.458496f, -0.888211f, -0.0293492f, 
		-0.458496f, -0.888211f, -0.0293492f, -0.967642f, -0.161290f, 0.194050f, 
		0.226581f, -0.938847f, -0.259282f, -0.758443f, -0.282795f, -0.587189f, 
		-0.127383f, 0.498279f, -0.857608f, -0.127383f, 0.498279f, -0.857608f, 
		0.565209f, 0.788007f, 0.244099f, -0.692543f, -0.713682f, -0.105086f, 
		-0.554503f, -0.815914f, -0.163741f, -0.999117f, 0.0420037f, 0.000966782f, 
		-0.959881f, -0.269354f, -0.0779477f, -0.00234609f, 0.964923f, 0.262523f, 
		-0.0990834f, 0.966259f, 0.237751f, 0.257726f, 0.915691f, 0.308362f, 
		0.375802f, 0.897043f, 0.232564f, 0.0846490f, 0.956848f, 0.277987f, 
		0.00554436f, 0.995981f, 0.0893950f, 0.0379185f, -0.771227f, 0.635429f, 
		-0.0452953f, -0.886995f, 0.459552f, -0.108631f, -0.993541f, -0.0327957f, 
		-0.00906233f, -0.978634f, -0.205408f, 0.810371f, -0.188812f, -0.554662f, 
		0.0480755f, -0.516136f, -0.855156f, 0.145141f, -0.496289f, -0.855939f, 
		0.371220f, -0.388911f, -0.843175f, 0.440376f, 0.897676f, 0.0157464f, 
		-0.0417671f, -0.575996f, -0.816385f, 0.446646f, -0.324896f, -0.833636f, 
		0.957986f, -0.154015f, -0.241955f, -0.880602f, 0.456272f, 0.127891f, 
		-0.495390f, 0.837885f, 0.229210f, -0.721552f, 0.667726f, 0.183041f, 
		0.0117106f, -0.816508f, -0.577215f, -0.106129f, -0.265850f, -0.958155f, 
		-0.106129f, -0.265850f, -0.958155f, -0.105245f, -0.454450f, -0.884533f, 
		-0.0787372f, -0.629648f, 0.772880f, 0.0701597f, -0.465809f, 0.882100f, 
		-0.0787372f, -0.629648f, 0.772880f, -0.196127f, -0.754825f, 0.625918f, 
		-0.147941f, 0.858136f, 0.491646f, 0.0584831f, 0.934117f, 0.352144f, 
		-0.0699478f, 0.928604f, 0.364421f, 0.251715f, 0.910869f, 0.327044f, 
		-0.182765f, 0.958001f, 0.220976f, 0.394869f, 0.877139f, 0.273324f, 
		-0.663917f, 0.541786f, 0.515443f, -0.586525f, 0.616152f, 0.525685f, 
		-0.505792f, 0.702185f, 0.501109f, -0.586525f, 0.616152f, 0.525685f, 
		-0.757682f, 0.160353f, -0.632617f, 0.629000f, 0.0304247f, 0.776810f, 
		0.0147777f, 0.973927f, -0.226379f, 0.175465f, 0.980071f, -0.0931312f, 
		0.0634748f, 0.997063f, -0.0428534f, 0.254552f, 0.966633f, 0.0286994f, 
		-0.272875f, 0.957468f, 0.0937761f, 0.0940693f, 0.970371f, 0.222556f, 
		0.0940693f, 0.970371f, 0.222556f, -0.183845f, -0.966953f, -0.176646f, 
		0.247703f, -0.956321f, -0.155220f, 0.0242708f, -0.975496f, -0.218675f, 
		-0.0240311f, 0.997069f, -0.0726340f, -0.447956f, 0.614928f, 0.648998f, 
		0.411398f, 0.735716f, 0.538028f, -0.308432f, -0.910251f, 0.276247f, 
		-0.156390f, -0.960775f, 0.229026f, 0.216927f, -0.965227f, 0.145876f, 
		-0.0174671f, -0.968176f, 0.249660f, 0.0769993f, -0.984042f, 0.160416f, 
		-0.550360f, -0.802173f, -0.231565f, -0.449892f, -0.883756f, -0.128730f, 
		0.134645f, -0.954891f, 0.264678f, -0.0786644f, -0.988532f, 0.128907f, 
		-0.550360f, -0.802173f, -0.231565f, 0.364777f, 0.856199f, -0.365870f, 
		0.799740f, 0.472460f, -0.370402f, -0.157531f, 0.689896f, -0.706560f, 
		-0.336553f, 0.522851f, -0.783173f, 0.835840f, -0.0113262f, -0.548857f, 
		0.743944f, -0.266745f, -0.612695f, 0.0517650f, -0.924278f, -0.378193f, 
		0.0231266f, 0.999622f, 0.0148576f, 0.0231266f, 0.999622f, 0.0148576f, 
		0.0231266f, 0.999622f, 0.0148576f, 0.0231266f, 0.999622f, 0.0148576f, 
		0.409440f, 0.772651f, 0.485149f, -0.481579f, 0.680639f, 0.552098f, 
		-0.481579f, 0.680639f, 0.552098f, 0.409440f, 0.772651f, 0.485149f, 
		0.00669690f, -0.990972f, 0.133901f, -0.256193f, -0.840020f, 0.478258f, 
		0.169763f, -0.981495f, 0.0885938f, -0.478809f, -0.875816f, -0.0607235f, 
		0.650184f, -0.489976f, -0.580676f, -0.426716f, -0.844262f, -0.324245f, 
		-0.104906f, -0.991352f, -0.0788410f, 0.0692380f, -0.992365f, 0.102071f, 
		-0.272136f, -0.943935f, -0.186894f, -0.273283f, -0.402569f, -0.873644f, 
		-0.0867070f, -0.410594f, -0.907686f, -0.423502f, -0.409918f, -0.807845f, 
		0.530644f, 0.281425f, 0.799510f, -0.615106f, -0.380249f, -0.690692f, 
		-0.573874f, 0.257118f, 0.777534f, -0.423502f, -0.409918f, -0.807845f, 
		0.414092f, -0.327023f, -0.849461f, -0.0903942f, 0.837564f, -0.538809f, 
		-0.0903942f, 0.837564f, -0.538809f, 0.00673919f, -0.857454f, -0.514517f, 
		-0.0903663f, -0.956161f, -0.278550f, 0.0434701f, -0.957571f, -0.284899f, 
		-0.0207478f, -0.953644f, -0.300221f, -0.241713f, -0.116585f, -0.963318f, 
		-0.160776f, 0.242748f, -0.956674f, -0.0517468f, 0.352839f, -0.934252f, 
		-0.0517468f, 0.352839f, -0.934252f, -0.110323f, 0.993554f, 0.0260554f, 
		-0.365482f, 0.913771f, -0.177328f, -0.198109f, 0.946996f, -0.252885f, 
		-0.198109f, 0.946996f, -0.252885f, -0.169160f, 0.903422f, -0.393971f, 
		-0.256449f, 0.910162f, -0.325330f, 0.680705f, 0.0575168f, 0.730296f, 
		0.623788f, 0.279184f, 0.730031f, 0.470911f, 0.394238f, 0.789189f, 
		-0.532063f, 0.514901f, 0.672150f, -0.112092f, -0.945048f, -0.307116f, 
		-0.112092f, -0.945048f, -0.307116f, 0.0417899f, 0.998450f, -0.0367502f, 
		0.0417899f, 0.998450f, -0.0367502f, -0.415956f, -0.908572f, -0.0384527f, 
		-0.234030f, -0.971661f, -0.0332412f, 0.131770f, -0.986630f, -0.0959059f, 
		-0.00200965f, -0.997960f, -0.0638124f, -0.111106f, -0.991953f, -0.0607082f, 
		-0.221061f, -0.973629f, -0.0563843f, 0.532949f, -0.841570f, -0.0878924f, 
		-0.174776f, 0.909510f, 0.377154f, -0.921539f, 0.191942f, -0.337527f, 
		-0.520609f, 0.257741f, 0.813963f, -0.548128f, 0.836054f, -0.0238720f, 
		-0.548128f, 0.836054f, -0.0238720f, -0.537126f, -0.744792f, 0.395955f, 
		-0.0929144f, 0.810705f, 0.578036f, -0.0929144f, 0.810705f, 0.578036f, 
		-0.131063f, -0.430063f, 0.893235f, -0.131063f, -0.430063f, 0.893235f, 
		0.321474f, 0.751405f, 0.576233f, -0.00655774f, 0.772039f, 0.635541f, 
		-0.340627f, 0.711029f, 0.615152f, -0.468620f, 0.659361f, 0.587910f, 
		-0.236719f, 0.709437f, 0.663825f, 0.175729f, 0.800566f, 0.572899f, 
		-0.237957f, 0.759971f, 0.604830f, 0.184803f, 0.736603f, 0.650587f, 
		0.651963f, -0.157088f, -0.741800f, 0.527325f, -0.204994f, -0.824564f, 
		0.412139f, -0.316563f, -0.854359f, 0.980153f, -0.143178f, 0.137115f, 
		-0.00503504f, -0.992470f, 0.122388f, -0.00503504f, -0.992470f, 0.122388f, 
		-0.00503504f, -0.992470f, 0.122388f, -0.00503504f, -0.992470f, 0.122388f, 
		0.228997f, -0.917866f, -0.324163f, 0.0465697f, -0.974693f, -0.218644f, 
		0.361085f, -0.833334f, -0.418534f, 0.152878f, -0.945336f, -0.288041f, 
		-0.156493f, -0.971569f, -0.177661f, 0.0465697f, -0.974693f, -0.218644f, 
		0.228997f, -0.917866f, -0.324163f, 0.406929f, -0.883560f, -0.231798f, 
		-0.109433f, 0.814462f, -0.569803f, -0.109433f, 0.814462f, -0.569803f, 
		-0.109433f, 0.814462f, -0.569803f, -0.109433f, 0.814462f, -0.569803f, 
		-0.0903542f, -0.954459f, 0.284330f, -0.0903542f, -0.954459f, 0.284330f, 
		-0.0903542f, -0.954459f, 0.284330f, 0.769302f, 0.0256495f, 0.638370f, 
		0.769302f, 0.0256495f, 0.638370f, -0.0595605f, 0.869995f, 0.489451f, 
		-0.311875f, 0.801292f, 0.510554f, -0.0707073f, 0.399716f, -0.913908f, 
		0.107022f, 0.872799f, 0.476202f, 0.217491f, 0.974886f, 0.0479178f, 
		-0.214434f, 0.948836f, -0.231792f, 0.104549f, 0.994196f, -0.0253774f, 
		-0.169239f, 0.979563f, -0.108691f, 0.363712f, 0.926766f, 0.0939113f, 
		-0.460603f, 0.864385f, 0.201701f, 0.194069f, 0.926914f, 0.321196f, 
		0.0685075f, 0.930443f, 0.359977f, -0.135351f, 0.918218f, 0.372231f, 
		-0.0284687f, 0.939892f, 0.340283f, -0.239461f, 0.905536f, 0.350234f, 
		0.418763f, -0.889585f, -0.182418f, -0.529470f, -0.840054f, -0.118199f, 
		0.418763f, -0.889585f, -0.182418f, -0.529470f, -0.840054f, -0.118199f, 
		0.418763f, -0.889585f, -0.182418f, -0.978936f, 0.0505992f, -0.197798f, 
		-0.382851f, -0.225760f, -0.895800f, -0.0589224f, -0.894798f, 0.442565f, 
		0.0324947f, 0.994005f, -0.104391f, 0.0324947f, 0.994005f, -0.104391f, 
		-0.118535f, 0.962391f, -0.244445f, -0.118535f, 0.962391f, -0.244445f, 
		-0.118535f, 0.962391f, -0.244445f, 0.648170f, -0.488735f, -0.583963f, 
		-0.495977f, -0.710267f, -0.499527f, -0.0996114f, 0.871109f, 0.480880f, 
		-0.00214822f, 0.897640f, 0.440725f, -0.390443f, 0.827974f, 0.402509f, 
		-0.271253f, 0.846027f, 0.458977f, -0.197884f, 0.884749f, 0.421973f, 
		-0.197884f, 0.884749f, 0.421973f, -0.326014f, 0.306033f, -0.894460f, 
		0.689815f, -0.427756f, -0.584107f, 0.155990f, -0.705051f, -0.691787f, 
		0.447947f, -0.569048f, -0.689585f, -0.971040f, -0.233301f, -0.0514975f, 
		-0.504099f, 0.0357453f, 0.862906f, -0.945380f, -0.325936f, 0.00467196f, 
		-0.336990f, -0.340338f, -0.877843f, 0.318114f, -0.945508f, 0.0694203f, 
		-0.217824f, -0.972549f, 0.0818613f, 0.118239f, -0.992947f, 0.00875880f, 
		0.318114f, -0.945508f, 0.0694203f, -0.730545f, -0.439771f, -0.522404f, 
		-0.207196f, 0.906272f, -0.368431f, -0.207196f, 0.906272f, -0.368431f, 
		-0.751657f, 0.383319f, 0.536729f, -0.813789f, -0.185766f, -0.550672f, 
		-0.710767f, -0.307736f, 0.632541f, -0.523528f, -0.283114f, -0.803595f, 
		-0.712376f, 0.0533102f, -0.699771f, 0.670522f, -0.335033f, 0.661931f, 
		-0.623491f, -0.136037f, -0.769905f, -0.555464f, 0.215354f, -0.803170f, 
		-0.664662f, -0.0664512f, -0.744183f, -0.251524f, -0.847130f, -0.468088f, 
		0.0655637f, -0.893831f, -0.443585f, 0.179595f, -0.883737f, -0.432151f, 
		-0.199197f, -0.948708f, 0.245508f, 0.639728f, 0.673123f, -0.371017f, 
		-0.198914f, -0.583398f, 0.787452f, -0.887751f, -0.323930f, -0.327059f, 
		-0.573874f, 0.257118f, 0.777534f, 0.428699f, 0.152576f, 0.890471f, 
		0.828227f, 0.330554f, -0.452519f, 0.794536f, 0.452124f, -0.405335f, 
		0.822807f, 0.383567f, -0.419362f, 0.152225f, 0.984269f, -0.0896820f, 
		-0.414886f, 0.907931f, 0.0594148f, -0.118020f, 0.935648f, -0.332616f, 
		-0.0214968f, 0.946560f, 0.321809f, -0.261027f, 0.917969f, 0.298660f, 
		-0.340245f, 0.935717f, -0.0930936f, 0.593311f, 0.794339f, 0.130414f, 
		-0.725543f, -0.385449f, -0.570102f, -0.661615f, -0.749761f, 0.0111083f, 
		-0.635531f, -0.747308f, -0.193989f, -0.706282f, -0.707687f, 0.0185742f, 
		-0.738970f, -0.667361f, 0.0924783f, -0.803540f, -0.584333f, 0.113486f, 
		-0.588936f, 0.605844f, -0.534890f, -0.264065f, 0.780979f, 0.565988f, 
		-0.0747692f, 0.980514f, -0.181662f, 0.622003f, 0.638098f, 0.453810f, 
		-0.532063f, 0.514901f, 0.672150f, 0.789692f, 0.613363f, 0.0131414f, 
		0.773489f, 0.568574f, 0.280068f, 0.677325f, 0.706515f, 0.205104f, 
		0.622003f, 0.638098f, 0.453810f, 0.0808383f, 0.989516f, 0.119680f, 
		0.556429f, 0.787077f, 0.266265f, -0.0519137f, 0.994864f, 0.0868887f, 
		-0.0519137f, 0.994864f, 0.0868887f, -0.0519137f, 0.994864f, 0.0868887f, 
		-0.0519137f, 0.994864f, 0.0868887f, 0.647548f, 0.186182f, 0.738930f, 
		-0.532063f, 0.514901f, 0.672150f, 0.125867f, -0.141001f, -0.981976f, 
		0.647548f, 0.186182f, 0.738930f, -0.466752f, 0.464258f, 0.752733f, 
		-0.900853f, -0.0534210f, -0.430826f, -0.684610f, 0.720792f, 0.108479f, 
		0.574160f, 0.677974f, 0.459012f, 0.440127f, 0.764195f, 0.471481f, 
		0.574160f, 0.677974f, 0.459012f, 0.168110f, 0.846555f, 0.505057f, 
		0.880684f, 0.0381820f, -0.472162f, -0.346334f, 0.401899f, -0.847662f, 
		0.0256933f, 0.961456f, -0.273756f, 0.296223f, 0.917773f, -0.264471f, 
		-0.0831869f, 0.940946f, -0.328177f, 0.207803f, 0.947615f, -0.242576f, 
		0.383220f, 0.875813f, -0.293416f, 0.115138f, 0.944000f, -0.309205f, 
		-0.189544f, 0.920532f, -0.341605f, -0.343098f, -0.300699f, -0.889867f, 
		-0.147235f, -0.378438f, -0.913842f, 0.436812f, -0.428253f, -0.791071f, 
		-0.343098f, -0.300699f, -0.889867f, 0.686785f, -0.363421f, -0.629484f, 
		-0.338387f, -0.911457f, 0.233968f, -0.421996f, -0.900944f, 0.101087f, 
		0.320210f, -0.505818f, 0.801008f, -0.320542f, -0.939699f, -0.119243f, 
		-0.266610f, -0.882130f, -0.388285f, -0.292733f, -0.924606f, -0.243743f, 
		0.388211f, -0.330308f, -0.860343f, 0.730134f, -0.176454f, -0.660127f, 
		0.497929f, 0.165652f, 0.851250f, 0.551272f, -0.173686f, -0.816047f, 
		-0.395403f, 0.918003f, 0.0304496f, -0.659490f, 0.717605f, 0.223866f, 
		-0.272206f, 0.962057f, -0.0186999f, -0.338515f, 0.231662f, -0.911998f, 
		0.530644f, 0.281425f, 0.799510f, -0.267291f, -0.430137f, -0.862286f, 
		0.971173f, -0.0236717f, -0.237196f, -0.0265360f, -0.793546f, -0.607931f, 
		0.0982601f, -0.966862f, -0.235634f, -0.211238f, -0.557853f, -0.802607f, 
		-0.715930f, 0.526028f, -0.459062f, -0.398055f, -0.234667f, -0.886839f, 
		0.511931f, -0.854713f, 0.0859815f, 0.386707f, -0.915726f, 0.109100f, 
		0.786056f, -0.615445f, -0.0578218f, 0.386707f, -0.915726f, 0.109100f, 
		0.464270f, -0.529082f, 0.710299f, 0.425259f, -0.867487f, 0.258109f, 
		-0.860699f, 0.376659f, 0.342527f, -0.153221f, 0.0651274f, 0.986043f, 
		-0.635921f, -0.268584f, -0.723510f, -0.951740f, 0.136843f, 0.274709f, 
		-0.124200f, 0.868217f, -0.480389f, -0.266677f, 0.954814f, -0.131202f, 
		0.140155f, -0.144503f, -0.979528f, -0.951740f, 0.136843f, 0.274709f, 
		-0.287497f, 0.957491f, 0.0235783f, -0.390566f, -0.911757f, 0.127110f, 
		0.0338677f, 0.341856f, 0.939142f, -0.815701f, -0.144419f, -0.560156f, 
		0.455491f, -0.876301f, -0.156921f, 0.987455f, -0.157397f, -0.0125968f, 
		0.668587f, -0.732043f, -0.130784f, 0.987455f, -0.157397f, -0.0125968f, 
		0.933254f, -0.358324f, -0.0253317f, 0.237561f, -0.944800f, 0.225650f, 
		0.535926f, -0.841134f, 0.0726479f, 0.903207f, -0.423217f, -0.0714433f, 
		0.822386f, -0.568624f, -0.0186389f, 0.807147f, -0.199088f, -0.555768f, 
		0.862092f, -0.471804f, -0.184926f, 0.0264102f, -0.397389f, -0.917270f, 
		0.0264102f, -0.397389f, -0.917270f, 0.758372f, 0.501539f, 0.416330f, 
		0.898913f, -0.103577f, 0.425709f, 0.880754f, 0.236920f, 0.410050f, 
		0.880711f, 0.300610f, 0.366035f, 0.915182f, 0.0376351f, 0.401281f, 
		0.758372f, 0.501539f, 0.416330f, 0.256450f, -0.619678f, -0.741776f, 
		0.256450f, -0.619678f, -0.741776f, 0.256450f, -0.619678f, -0.741776f, 
		0.0326063f, -0.999189f, 0.0236372f, 0.244548f, 0.817719f, -0.521087f, 
		0.244548f, 0.817719f, -0.521087f, 0.244548f, 0.817719f, -0.521087f, 
		0.244548f, 0.817719f, -0.521087f, 0.187163f, 0.937567f, -0.293152f, 
		0.187163f, 0.937567f, -0.293152f, 0.320472f, -0.609327f, -0.725271f, 
		0.320472f, -0.609327f, -0.725271f, 0.622007f, 0.708283f, 0.333831f, 
		0.937103f, 0.309415f, 0.161558f, 0.994389f, 0.0856339f, 0.0621025f, 
		0.976850f, 0.167926f, 0.132530f, 0.758748f, 0.578769f, 0.298879f, 
		0.994389f, 0.0856339f, 0.0621025f, -0.684370f, -0.684358f, 0.251579f, 
		0.684368f, -0.440834f, -0.580780f, -0.353983f, -0.270233f, -0.895360f, 
		-0.984161f, -0.0129513f, 0.176804f, 0.319504f, -0.0576594f, -0.945829f, 
		-0.984161f, -0.0129513f, 0.176804f, -0.147372f, -0.927966f, -0.342288f, 
		0.238124f, 0.925732f, -0.293799f, -0.960003f, -0.279438f, 0.0175340f, 
		-0.296733f, -0.927399f, -0.227772f, 0.0274598f, -0.969177f, 0.244831f, 
		0.0274598f, -0.969177f, 0.244831f, 0.0274598f, -0.969177f, 0.244831f, 
		0.837112f, -0.382333f, 0.391237f, -0.265317f, 0.642636f, 0.718767f, 
		-0.745088f, 0.0645240f, 0.663838f, -0.967812f, 0.235829f, 0.0878882f, 
		-0.914191f, 0.131289f, 0.383429f, -0.353166f, 0.933125f, -0.0674622f, 
		-0.737528f, 0.0747644f, -0.671165f, 0.945630f, -0.227000f, -0.232926f, 
		0.438448f, -0.856886f, -0.271128f, 0.853203f, -0.478537f, -0.207476f, 
		0.656739f, -0.733771f, -0.173994f, 0.328445f, 0.698694f, 0.635571f, 
		0.913774f, 0.257821f, 0.313918f, 0.749714f, 0.462129f, 0.473673f, 
		-0.309569f, -0.0814579f, 0.947381f, 0.328445f, 0.698694f, 0.635571f, 
		0.913774f, 0.257821f, 0.313918f, 0.173522f, 0.721811f, 0.669984f, 
		0.814544f, 0.0618152f, -0.576799f, 0.360022f, 0.928739f, -0.0884762f, 
		0.302252f, 0.891370f, -0.337793f, 0.407966f, 0.911408f, 0.0538437f, 
		0.931963f, 0.288978f, 0.218945f, 0.627625f, -0.0918158f, -0.773083f, 
		-0.267096f, -0.411383f, -0.871449f, 0.243647f, 0.968380f, 0.0536350f, 
		0.987955f, -0.0477261f, -0.147196f, 0.243647f, 0.968380f, 0.0536350f, 
		0.987955f, -0.0477261f, -0.147196f, 0.413423f, -0.901574f, -0.127457f, 
		0.991867f, -0.105429f, -0.0713106f, 0.413423f, -0.901574f, -0.127457f, 
		0.991867f, -0.105429f, -0.0713106f, 0.413423f, -0.901574f, -0.127457f, 
		0.991867f, -0.105429f, -0.0713106f, 0.988813f, -0.0525760f, 0.139586f, 
		0.988813f, -0.0525760f, 0.139586f, 0.428634f, -0.264531f, 0.863885f, 
		0.988813f, -0.0525760f, 0.139586f, 0.0522637f, -0.902049f, 0.428457f, 
		0.0522637f, -0.902049f, 0.428457f, -0.00342542f, 0.991344f, -0.131243f, 
		-0.985268f, 0.0300731f, 0.168355f, -0.985268f, 0.0300731f, 0.168355f, 
		0.458473f, 0.742494f, -0.488369f, 0.458473f, 0.742494f, -0.488369f, 
		-0.878411f, -0.367439f, -0.305585f, -0.244720f, -0.851275f, -0.464158f, 
		0.0944761f, 0.701182f, 0.706695f, 0.0944761f, 0.701182f, 0.706695f, 
		0.520432f, -0.448870f, 0.726406f, -0.276041f, -0.477417f, 0.834191f, 
		-0.895036f, -0.444599f, 0.0352564f, -0.948528f, -0.248702f, 0.196067f, 
		-0.387364f, -0.866235f, -0.315573f, -0.543763f, -0.805622f, -0.235148f, 
		-0.491453f, 0.0733208f, -0.867812f, -0.387364f, -0.866235f, -0.315573f, 
		-0.598462f, -0.669143f, -0.440558f, -0.742889f, -0.660983f, -0.105914f, 
		-0.322063f, -0.596483f, -0.735176f, -0.216605f, -0.495813f, -0.840983f, 
		-0.648347f, 0.678968f, 0.344454f, -0.896042f, 0.362773f, 0.255940f, 
		-0.318360f, 0.855864f, 0.407607f, -0.824640f, 0.470616f, 0.313832f, 
		0.0283243f, -0.980867f, 0.192608f, 0.0283243f, -0.980867f, 0.192608f, 
		0.0283243f, -0.980867f, 0.192608f, 0.463367f, -0.653405f, 0.598627f, 
		-0.152793f, -0.622107f, 0.767879f, -0.309243f, -0.628268f, 0.713896f, 
		0.167005f, -0.626757f, 0.761108f, 0.463367f, -0.653405f, 0.598627f, 
		-0.843322f, -0.537404f, -0.00216791f, -0.525921f, -0.0441453f, 0.849387f, 
		0.0259331f, 0.765526f, 0.642882f, 0.0259331f, 0.765526f, 0.642882f, 
		0.0259331f, 0.765526f, 0.642882f, 0.0259331f, 0.765526f, 0.642882f, 
		0.0259331f, 0.765526f, 0.642882f, 0.568519f, 0.701712f, 0.429403f, 
		0.663979f, 0.633729f, 0.396886f, 0.809782f, 0.470926f, 0.349974f, 
		0.663979f, 0.633729f, 0.396886f, -0.576385f, -0.558613f, 0.596433f, 
		-0.576385f, -0.558613f, 0.596433f, 0.599534f, 0.153705f, 0.785452f, 
		0.686785f, -0.363421f, -0.629484f, -0.373573f, -0.357659f, -0.855876f, 
		0.686785f, -0.363421f, -0.629484f, -0.373573f, -0.357659f, -0.855876f, 
		-0.525824f, 0.0365645f, 0.849807f, -0.864796f, -0.385908f, -0.321253f, 
		0.903805f, -0.122805f, -0.409946f, 0.794677f, -0.0278683f, -0.606392f, 
		0.903805f, -0.122805f, -0.409946f, 0.794677f, -0.0278683f, -0.606392f, 
		0.995266f, -0.00573918f, -0.0970169f, 0.989681f, 0.00266200f, 0.143261f, 
		0.439218f, 0.892797f, -0.100003f, 0.955996f, -0.291882f, -0.0296272f, 
		0.439218f, 0.892797f, -0.100003f, 0.955996f, -0.291882f, -0.0296272f, 
		0.0413590f, -0.824979f, -0.563648f, -0.0335492f, -0.866784f, -0.497555f, 
		0.116233f, -0.812361f, -0.571454f, -0.681434f, 0.228483f, -0.695301f, 
		-0.149441f, 0.887507f, 0.435888f, 0.403192f, 0.0535836f, -0.913545f, 
		0.0857988f, 0.156003f, -0.984023f, 0.0886727f, -0.269293f, -0.958967f, 
		-0.0754284f, 0.331928f, -0.940284f, -0.0754284f, 0.331928f, -0.940284f, 
		-0.538434f, -0.102396f, 0.836423f, -0.0323688f, 0.919044f, 0.392823f, 
		0.790878f, -0.611365f, -0.0272921f, 0.865111f, -0.501555f, 0.00504519f, 
		0.696512f, -0.715649f, -0.0521260f, 0.790878f, -0.611365f, -0.0272921f, 
		-0.575475f, 0.574550f, 0.581998f, -0.575475f, 0.574550f, 0.581998f, 
		-0.198914f, -0.583398f, 0.787452f, -0.726994f, -0.331065f, -0.601562f, 
		-0.587234f, -0.177572f, -0.789699f, -0.356141f, -0.0787468f, -0.931108f, 
		0.971173f, -0.0236717f, -0.237196f, -0.0576072f, -0.430476f, 0.900762f, 
		-0.255926f, -0.217305f, 0.941956f, 0.275168f, -0.473578f, 0.836664f, 
		0.938057f, 0.122072f, 0.324264f, 0.275879f, -0.679370f, 0.679961f, 
		0.0730494f, -0.694969f, 0.715319f, -0.0408022f, -0.970586f, 0.237270f, 
		-0.573874f, 0.257118f, 0.777534f, 0.506937f, 0.325203f, 0.798284f, 
		0.506937f, 0.325203f, 0.798284f, 0.404477f, -0.313304f, -0.859208f, 
		0.980153f, -0.143178f, 0.137115f, -0.651646f, -0.182089f, -0.736343f, 
		0.628104f, -0.266292f, -0.731146f, 0.103676f, -0.920294f, 0.377241f, 
		0.103676f, -0.920294f, 0.377241f, 0.103676f, -0.920294f, 0.377241f, 
		0.103676f, -0.920294f, 0.377241f, 0.382684f, -0.923714f, 0.0174569f, 
		-0.628027f, -0.701088f, -0.337724f, -0.628168f, -0.714029f, -0.309139f, 
		-0.924044f, 0.0315264f, -0.380984f, -0.891918f, 0.270687f, -0.362231f, 
		-0.946300f, 0.276441f, -0.167619f, -0.967812f, 0.235829f, 0.0878882f, 
		-0.264258f, -0.634281f, 0.726537f, -0.783274f, -0.501687f, -0.367141f, 
		-0.550887f, 0.724715f, -0.413899f, -0.188061f, 0.975954f, -0.110214f, 
		0.551857f, 0.828692f, 0.0934015f, -0.00241610f, 0.997132f, -0.0756491f, 
		-0.188061f, 0.975954f, -0.110214f, 0.693751f, 0.697250f, 0.180423f, 
		0.484474f, -0.568562f, -0.664848f, 0.659464f, -0.246560f, -0.710152f, 
		0.625377f, -0.384485f, -0.679025f, 0.625377f, -0.384485f, -0.679025f, 
		-0.866585f, -0.476027f, -0.149760f, -0.932178f, -0.332558f, -0.143005f, 
		-0.311318f, -0.911208f, -0.269781f, -0.483103f, -0.823792f, -0.296610f, 
		-0.0463169f, -0.145295f, -0.988304f, 0.971173f, -0.0236717f, -0.237196f, 
		-0.0463169f, -0.145295f, -0.988304f, 0.431959f, 0.133091f, 0.892019f, 
		-0.943154f, 0.206337f, 0.260547f, -0.134237f, 0.164665f, -0.977172f, 
		-0.134237f, 0.164665f, -0.977172f, -0.697539f, 0.0186755f, 0.716304f, 
		-0.963964f, -0.262047f, 0.0458852f, -0.399585f, -0.915326f, -0.0501047f, 
		0.552820f, 0.728644f, -0.404312f, 0.855364f, -0.488300f, -0.172959f, 
		0.855364f, -0.488300f, -0.172959f, 0.552820f, 0.728644f, -0.404312f, 
		0.989598f, 0.0263470f, 0.141424f, 0.989598f, 0.0263470f, 0.141424f, 
		-0.802105f, -0.0510918f, 0.594993f, -0.889715f, 0.0273136f, -0.455699f, 
		-0.963548f, 0.200673f, -0.176931f, -0.911709f, 0.251378f, 0.324954f, 
		-0.780859f, 0.122608f, 0.612558f, -0.867136f, -0.105164f, -0.486842f, 
		0.406956f, -0.865829f, -0.291078f, -0.386702f, -0.212956f, -0.897280f, 
		-0.528980f, -0.461894f, -0.711923f, 0.590538f, -0.0280785f, -0.806521f, 
		-0.514805f, 0.765062f, 0.386854f, -0.775053f, 0.527431f, 0.348007f, 
		-0.853500f, 0.428565f, 0.296428f, -0.934553f, 0.276585f, 0.223856f, 
		-0.620124f, 0.691477f, 0.370548f, -0.343970f, 0.847901f, 0.403420f, 
		-0.590242f, -0.546501f, 0.594097f, -0.590242f, -0.546501f, 0.594097f, 
		-0.654417f, -0.381261f, 0.652977f, -0.392899f, -0.798746f, 0.455670f, 
		-0.677640f, -0.481750f, 0.555627f, -0.666444f, -0.678355f, 0.309332f, 
		0.0939213f, -0.112090f, -0.989249f, 0.287581f, -0.166112f, -0.943241f, 
		-0.182986f, 0.0314426f, -0.982613f, -0.322341f, -0.816567f, -0.478867f, 
		0.287581f, -0.166112f, -0.943241f, -0.357762f, 0.0821598f, -0.930191f, 
		-0.357762f, 0.0821598f, -0.930191f, 0.850103f, -0.199524f, -0.487355f, 
		-0.0314625f, 0.965612f, -0.258076f, 0.00515389f, 0.307920f, -0.951398f, 
		-0.364453f, 0.799563f, 0.477360f, -0.172492f, 0.455845f, -0.873185f, 
		-0.172492f, 0.455845f, -0.873185f, -0.978161f, 0.192032f, 0.0795279f, 
		0.206578f, 0.948755f, -0.239142f, 0.206578f, 0.948755f, -0.239142f, 
		-0.0365066f, -0.641335f, -0.766392f, 0.903360f, -0.365028f, -0.225155f, 
		-0.696321f, -0.690606f, -0.195449f, -0.471863f, -0.842254f, -0.260679f, 
		-0.317212f, -0.910967f, -0.263659f, -0.595377f, -0.776343f, -0.206926f, 
		-0.794163f, -0.572424f, -0.204049f, -0.251043f, -0.153894f, 0.955664f, 
		-0.251043f, -0.153894f, 0.955664f, -0.931569f, -0.183349f, 0.313946f, 
		-0.931569f, -0.183349f, 0.313946f, 0.427262f, -0.897512f, -0.109177f, 
		-0.559892f, 0.0441028f, -0.827391f, 0.645947f, -0.567800f, -0.510250f, 
		0.488768f, -0.830203f, -0.268084f, -0.609706f, 0.425531f, 0.668716f, 
		-0.707103f, 0.299698f, 0.640458f, -0.304730f, 0.756582f, 0.578552f, 
		-0.594644f, -0.523495f, -0.610206f, 0.837230f, 0.0834419f, -0.540447f, 
		0.807147f, -0.199088f, -0.555768f, 0.724832f, 0.352457f, -0.591940f, 
		-0.190305f, 0.442612f, -0.876287f, -0.952187f, -0.187950f, -0.240862f, 
		-0.478005f, -0.849528f, -0.223190f, 0.961723f, 0.176027f, -0.210010f, 
		0.199539f, 0.165723f, -0.965774f, -0.250208f, 0.907820f, 0.336539f, 
		-0.250208f, 0.907820f, 0.336539f, 0.531733f, -0.210076f, -0.820444f, 
		0.0469644f, 0.993567f, 0.103045f, 0.168863f, -0.832842f, -0.527125f, 
		0.531733f, -0.210076f, -0.820444f, 0.359860f, -0.622790f, -0.694718f, 
		0.168863f, -0.832842f, -0.527125f, 0.0469644f, 0.993567f, 0.103045f, 
		0.0469644f, 0.993567f, 0.103045f, -0.955527f, -0.280445f, 0.0912059f, 
		-0.988442f, -0.0524696f, 0.142233f, -0.986636f, 0.0166525f, 0.162087f, 
		-0.448292f, -0.482248f, -0.752643f, -0.471918f, 0.166832f, 0.865714f, 
		-0.0233573f, -0.637618f, -0.769999f, 0.911753f, -0.343208f, -0.225643f, 
		0.911753f, -0.343208f, -0.225643f, -0.0233573f, -0.637618f, -0.769999f, 
		-0.429610f, 0.895554f, 0.115836f, -0.932213f, 0.321518f, 0.166146f, 
		-0.0555301f, -0.998109f, -0.0263493f, 0.577635f, -0.764232f, 0.286858f, 
		0.203252f, -0.967116f, 0.152891f, 0.367383f, -0.904748f, 0.215549f, 
		0.367383f, -0.904748f, 0.215549f, 0.511361f, -0.829827f, 0.223378f, 
		0.305819f, -0.939621f, 0.153581f, -0.476665f, 0.840942f, -0.256139f, 
		-0.228807f, 0.963891f, -0.136238f, -0.832963f, 0.421597f, -0.358369f, 
		-0.678702f, 0.680076f, -0.277238f, 0.908473f, -0.350214f, -0.228096f, 
		-0.0237663f, -0.638595f, -0.769176f, -0.148361f, -0.979362f, 0.137259f, 
		0.665257f, 0.102842f, -0.739497f, 0.280991f, 0.905589f, -0.317731f, 
		0.280991f, 0.905589f, -0.317731f, 0.665257f, 0.102842f, -0.739497f, 
		0.280991f, 0.905589f, -0.317731f, -0.137605f, -0.612735f, 0.778216f, 
		-0.200785f, -0.953971f, 0.222768f, -0.893056f, -0.353715f, 0.278094f, 
		-0.200785f, -0.953971f, 0.222768f, -0.202448f, -0.891395f, 0.405501f, 
		-0.238251f, -0.0265654f, 0.970840f, -0.318268f, 0.807217f, 0.497098f, 
		-0.417296f, 0.757785f, 0.501623f, -0.874635f, 0.279696f, 0.395960f, 
		-0.566107f, 0.673416f, 0.475430f, -0.417296f, 0.757785f, 0.501623f, 
		-0.995990f, -0.0889183f, -0.00986460f, -0.988746f, 0.110544f, 0.100808f, 
		-0.973865f, -0.190970f, -0.122955f, -0.999327f, 0.0178085f, 0.0320614f, 
		-0.955670f, 0.270414f, 0.116497f, 0.0628402f, -0.944762f, 0.321676f, 
		0.0628402f, -0.944762f, 0.321676f, 0.0628402f, -0.944762f, 0.321676f, 
		0.0166643f, 0.988952f, -0.147299f, 0.572216f, 0.133484f, -0.809166f, 
		-0.105701f, -0.524954f, -0.844542f, -0.711574f, -0.00744816f, 0.702571f, 
		-0.462069f, 0.498112f, -0.733741f, 0.730471f, 0.551822f, 0.402374f, 
		-0.263027f, 0.964607f, 0.0187101f, 0.730471f, 0.551822f, 0.402374f, 
		-0.314417f, 0.719935f, -0.618736f, -0.400765f, -0.285691f, -0.870499f, 
		-0.265905f, 0.647029f, -0.714596f, 0.0407396f, 0.979112f, 0.199199f, 
		-0.823583f, -0.473797f, -0.311812f, -0.519938f, -0.705815f, -0.481134f, 
		-0.930773f, -0.281120f, -0.233738f, -0.333808f, 0.317845f, -0.887438f, 
		-0.307855f, -0.753573f, -0.580822f, -0.572652f, -0.168027f, 0.802394f, 
		-0.572652f, -0.168027f, 0.802394f, -0.230434f, -0.905717f, 0.355777f, 
		-0.638692f, 0.00874058f, 0.769413f, -0.355044f, -0.714330f, 0.603056f, 
		-0.320290f, -0.463324f, -0.826284f, -0.491251f, -0.249430f, -0.834540f, 
		-0.425678f, -0.312877f, -0.849062f, 0.428053f, 0.899643f, -0.0861017f, 
		0.983932f, -0.103458f, -0.145511f, 0.565906f, 0.823898f, 0.0307175f, 
		0.285507f, 0.954339f, -0.0878841f, 0.319504f, -0.0576594f, -0.945829f, 
		0.933177f, -0.220993f, -0.283449f, 0.355934f, -0.241936f, -0.902651f, 
		0.811567f, -0.326620f, -0.484436f, 0.259191f, -0.817740f, -0.513927f, 
		0.422546f, -0.653602f, -0.627900f, 0.982172f, -0.0457460f, -0.182333f, 
		-0.617342f, -0.229614f, 0.752440f, 0.308614f, -0.130173f, -0.942238f, 
		0.878635f, 0.284986f, 0.383123f, 0.646833f, 0.0162833f, -0.762458f, 
		0.489126f, -0.0386706f, -0.871355f, 0.438924f, 0.898045f, 0.0293461f, 
		0.438924f, 0.898045f, 0.0293461f, 0.539933f, -0.0300585f, -0.841171f, 
		0.539933f, -0.0300585f, -0.841171f, 0.539933f, -0.0300585f, -0.841171f, 
		0.539933f, -0.0300585f, -0.841171f, -0.668992f, -0.431586f, 0.605131f, 
		-0.668992f, -0.431586f, 0.605131f, -0.431528f, 0.0325615f, 0.901512f, 
		-0.431528f, 0.0325615f, 0.901512f, -0.312071f, 0.490208f, 0.813823f, 
		-0.172374f, 0.769146f, 0.615387f, 0.653877f, 0.756584f, -0.00502092f, 
		0.739020f, 0.671421f, -0.0551606f, 0.544187f, 0.834732f, -0.0841579f, 
		0.423772f, 0.902945f, -0.0714716f, 0.251955f, 0.966702f, -0.0447834f, 
		0.176847f, 0.331657f, -0.926676f, 0.312166f, 0.943207f, 0.113631f, 
		0.461906f, 0.884312f, 0.0680765f, 0.911788f, -0.362293f, -0.193355f, 
		0.911788f, -0.362293f, -0.193355f, 0.582353f, 0.806421f, 0.102710f, 
		-0.415610f, 0.477935f, 0.773851f, -0.504007f, 0.00760568f, 0.863666f, 
		-0.736439f, -0.544952f, -0.400854f, -0.372567f, 0.855621f, -0.359314f, 
		-0.386577f, 0.725184f, -0.569795f, -0.334035f, 0.625459f, -0.705140f, 
		-0.985605f, 0.144853f, -0.0871747f, 0.922510f, 0.379876f, -0.0683306f, 
		0.420491f, -0.746900f, 0.515099f, 0.293326f, -0.953107f, 0.0744736f, 
		0.175404f, -0.941683f, -0.287171f, 0.0696044f, -0.906054f, -0.417398f, 
		0.942904f, -0.259459f, -0.208836f, -0.0488601f, -0.998799f, 0.00363541f, 
		0.942904f, -0.259459f, -0.208836f, -0.0488601f, -0.998799f, 0.00363541f, 
		-0.0488601f, -0.998799f, 0.00363541f, -0.552710f, 0.193493f, -0.810600f, 
		0.902702f, -0.191059f, -0.385519f, 0.192176f, 0.930332f, 0.312331f, 
		0.192176f, 0.930332f, 0.312331f, 0.192176f, 0.930332f, 0.312331f, 
		0.192176f, 0.930332f, 0.312331f, -0.379794f, -0.686107f, -0.620495f, 
		0.448233f, 0.112900f, -0.886759f, -0.859172f, 0.404311f, -0.313618f, 
		-0.500848f, 0.840238f, 0.207727f, -0.588704f, -0.149078f, 0.794483f, 
		-0.500848f, 0.840238f, 0.207727f, 0.927228f, -0.298955f, -0.225552f, 
		0.611134f, -0.722696f, -0.322840f, 0.255389f, -0.883064f, -0.393668f, 
		0.485804f, 0.0315396f, -0.873499f, 0.386566f, -0.835903f, -0.389659f, 
		-0.385162f, -0.721044f, 0.575974f, -0.385162f, -0.721044f, 0.575974f, 
		-0.385162f, -0.721044f, 0.575974f, -0.260394f, -0.936652f, 0.234261f, 
		-0.0352894f, 0.462943f, -0.885685f, 0.959908f, 0.272113f, -0.0673166f, 
		0.212714f, -0.967723f, 0.135150f, 0.212714f, -0.967723f, 0.135150f, 
		0.212714f, -0.967723f, 0.135150f, -0.488845f, 0.361463f, -0.793962f, 
		0.0641512f, 0.997399f, 0.0328672f, -0.0264977f, 0.833421f, 0.552003f, 
		-0.473143f, 0.243568f, 0.846647f, -0.197294f, 0.682491f, 0.703762f, 
		-0.473143f, 0.243568f, 0.846647f, -0.0264977f, 0.833421f, 0.552003f, 
		-0.518660f, -0.0263774f, -0.854574f, -0.387771f, 0.854543f, 0.345528f, 
		0.841063f, 0.540241f, -0.0274288f, -0.0454839f, 0.800930f, 0.597028f, 
		0.519775f, -0.447767f, 0.727557f, 0.917668f, -0.362701f, -0.162274f, 
		0.841063f, 0.540241f, -0.0274288f, -0.237282f, -0.506382f, -0.829020f, 
		0.922436f, -0.328490f, -0.202995f, 0.922436f, -0.328490f, -0.202995f, 
		0.922436f, -0.328490f, -0.202995f, 0.922436f, -0.328490f, -0.202995f, 
		0.872169f, 0.0332105f, -0.488076f, 0.872162f, 0.134126f, -0.470472f, 
		0.872162f, 0.134126f, -0.470472f, 0.897475f, 0.195244f, -0.395498f, 
		0.879466f, 0.420376f, -0.223212f, 0.889301f, 0.272159f, -0.367524f, 
		-0.525164f, -0.342880f, 0.778868f, -0.525164f, -0.342880f, 0.778868f, 
		-0.663394f, 0.684092f, 0.303194f, 0.652697f, 0.730945f, 0.199262f, 
		0.767347f, 0.606797f, 0.207307f, 0.711500f, 0.676143f, 0.191307f, 
		0.711500f, 0.676143f, 0.191307f, 0.673642f, 0.736817f, 0.0575049f, 
		0.673642f, 0.736817f, 0.0575049f, 0.673642f, 0.736817f, 0.0575049f, 
		-0.942018f, -0.321994f, -0.0944515f, -0.998566f, -0.0423435f, 0.0327574f, 
		-0.996448f, 0.0393972f, 0.0744219f, -0.405389f, 0.189210f, -0.894349f, 
		0.109918f, -0.991905f, 0.0635846f, -0.938852f, -0.0181199f, -0.343845f, 
		0.713445f, -0.146724f, -0.685177f, -0.426653f, -0.904414f, -0.00145690f, 
		0.713445f, -0.146724f, -0.685177f, -0.252625f, 0.236437f, -0.938231f, 
		-0.252625f, 0.236437f, -0.938231f, 0.653959f, 0.709239f, 0.263284f, 
		0.653959f, 0.709239f, 0.263284f, -0.892009f, -0.234222f, 0.386600f, 
		-0.934371f, 0.0162593f, 0.355930f, -0.935866f, 0.156297f, 0.315794f, 
		-0.893718f, 0.322827f, 0.311529f, -0.772030f, -0.547292f, 0.323174f, 
		-0.854803f, -0.381549f, 0.351757f, -0.241606f, 0.832881f, 0.497932f, 
		-0.241606f, 0.832881f, 0.497932f, 0.663385f, 0.736125f, 0.134313f, 
		0.663385f, 0.736125f, 0.134313f, -0.0943346f, -0.990634f, -0.0987198f, 
		-0.0943346f, -0.990634f, -0.0987198f, 0.0794264f, -0.990120f, 0.115561f, 
		0.0794264f, -0.990120f, 0.115561f, 0.0794264f, -0.990120f, 0.115561f, 
		0.0794264f, -0.990120f, 0.115561f, 0.0794264f, -0.990120f, 0.115561f, 
		0.591266f, -0.736975f, -0.327525f, 0.359829f, -0.871077f, -0.334288f, 
		0.869348f, -0.389669f, -0.303960f, -0.367201f, -0.772771f, -0.517676f, 
		-0.100456f, -0.598424f, -0.794856f, -0.257747f, -0.706860f, -0.658722f, 
		-0.486457f, -0.00283025f, 0.873700f, -0.486457f, -0.00283025f, 0.873700f, 
		-0.678161f, -0.604658f, 0.417716f, -0.612713f, -0.789540f, -0.0347710f, 
		-0.594641f, -0.778436f, -0.201097f, -0.564466f, -0.387579f, 0.728808f, 
		-0.847499f, -0.415158f, 0.330741f, -0.173705f, -0.981616f, 0.0790920f, 
		-0.173705f, -0.981616f, 0.0790920f, -0.847499f, -0.415158f, 0.330741f, 
		-0.504433f, -0.764909f, 0.400576f, 0.391853f, -0.193346f, -0.899482f, 
		0.320895f, 0.945839f, 0.0491352f, -0.659365f, 0.392364f, 0.641318f, 
		-0.587778f, 0.557618f, -0.586156f, -0.818918f, -0.558307f, -0.132914f, 
		-0.793094f, 0.431998f, -0.429394f, -0.379786f, 0.583782f, -0.717608f, 
		0.806119f, -0.0558236f, -0.589115f, 0.0366498f, -0.950199f, 0.309482f, 
		0.594496f, 0.712302f, 0.373096f, 0.972386f, 0.179596f, -0.149033f, 
		0.978639f, -0.0599131f, -0.196660f, 0.905243f, -0.316323f, -0.283682f, 
		0.956417f, -0.165640f, -0.240478f, 0.899988f, 0.432954f, -0.0507163f, 
		0.948814f, 0.306328f, -0.0769075f, 0.420196f, 0.897134f, 0.136329f, 
		-0.137431f, 0.933194f, 0.332057f, 0.114942f, 0.958302f, 0.261619f, 
		0.420196f, 0.897134f, 0.136329f, -0.0702502f, -0.666575f, -0.742121f, 
		-0.177456f, 0.983721f, -0.0283267f, -0.559135f, 0.815046f, -0.151883f, 
		-0.177456f, 0.983721f, -0.0283267f, -0.778440f, 0.550228f, -0.302127f, 
		-0.311148f, 0.948097f, -0.0655736f, 0.195298f, -0.927191f, -0.319649f, 
		-0.291826f, -0.923080f, -0.250521f, -0.113403f, -0.953944f, -0.277725f, 
		0.530921f, -0.628400f, 0.568538f, 0.860442f, -0.504449f, -0.0719062f, 
		0.951725f, -0.251954f, -0.175327f, 0.00202323f, -0.996015f, -0.0891619f, 
		0.554969f, -0.805562f, 0.207554f, -0.118469f, -0.981752f, -0.148753f, 
		0.00202323f, -0.996015f, -0.0891619f, -0.672200f, 0.694171f, 0.257438f, 
		-0.672200f, 0.694171f, 0.257438f, -0.761183f, 0.565487f, 0.317529f, 
		-0.613060f, 0.762996f, 0.204925f, -0.908199f, 0.352339f, 0.225901f, 
		-0.737742f, 0.632710f, 0.235403f, 0.0905493f, -0.995539f, -0.0265223f, 
		-0.170007f, -0.984152f, 0.0504145f, -0.0149987f, -0.994519f, 0.103473f, 
		-0.377890f, -0.289998f, -0.879261f, -0.0673549f, -0.461685f, -0.884483f, 
		-0.275909f, -0.170539f, -0.945934f, -0.362340f, 0.0541558f, -0.930471f, 
		-0.937075f, 0.349034f, -0.00813465f, -0.749268f, -0.659802f, 0.0570815f, 
		-0.749268f, -0.659802f, 0.0570815f, -0.937075f, 0.349034f, -0.00813465f, 
		0.784949f, 0.0459340f, 0.617855f, 0.814545f, -0.200103f, 0.544495f, 
		0.746946f, 0.279651f, 0.603214f, 0.887243f, 0.385421f, -0.253478f, 
		-0.413688f, 0.421594f, -0.806920f, -0.339146f, 0.389155f, -0.856469f, 
		-0.339146f, 0.389155f, -0.856469f, -0.339146f, 0.389155f, -0.856469f, 
		-0.241314f, 0.366573f, -0.898550f, 0.204132f, -0.917429f, -0.341548f, 
		0.204132f, -0.917429f, -0.341548f, 0.528931f, 0.793385f, 0.301284f, 
		0.528931f, 0.793385f, 0.301284f, -0.110356f, 0.954982f, -0.275374f, 
		0.0595918f, 0.985944f, -0.156084f, -0.0211842f, 0.970651f, -0.239559f, 
		-0.168011f, 0.965643f, -0.198257f, -0.0824418f, 0.981121f, -0.174945f, 
		-0.181727f, 0.980414f, -0.0759185f, 0.654966f, 0.746289f, 0.118628f, 
		0.868148f, 0.494804f, -0.0385813f, 0.517441f, 0.841533f, 0.155170f, 
		-0.426831f, -0.554098f, -0.714696f, -0.159268f, -0.398707f, -0.903142f, 
		0.327230f, 0.944904f, -0.00878853f, 0.327230f, 0.944904f, -0.00878853f, 
		0.327230f, 0.944904f, -0.00878853f, 0.856871f, 0.0181277f, 0.515212f, 
		-0.0142346f, -0.627727f, -0.778304f, 0.886040f, 0.123496f, -0.446857f, 
		-0.604818f, -0.794816f, 0.0496341f, -0.502851f, 0.0470062f, -0.863094f, 
		-0.906693f, 0.266409f, -0.327007f, 0.873829f, -0.276331f, -0.400079f, 
		-0.135888f, 0.989507f, -0.0490887f, -0.135888f, 0.989507f, -0.0490887f, 
		0.763745f, 0.432124f, 0.479543f, 0.924420f, -0.199402f, -0.325095f, 
		0.803941f, -0.223565f, -0.551088f, 0.584938f, 0.752086f, -0.303668f, 
		0.949170f, -0.250666f, -0.190375f, -0.435929f, 0.874474f, -0.212746f, 
		-0.604280f, 0.776403f, -0.179007f, -0.958542f, 0.282605f, 0.0364950f, 
		-0.863745f, 0.502247f, -0.0411323f, -0.435929f, 0.874474f, -0.212746f, 
		0.550633f, 0.727152f, -0.409943f, 0.986782f, -0.151194f, 0.0583310f, 
		-0.907535f, -0.130012f, -0.399346f, -0.430949f, -0.881451f, 0.193203f, 
		-0.593676f, -0.693551f, 0.408089f, 0.0983625f, -0.990588f, -0.0951862f, 
		0.0983625f, -0.990588f, -0.0951862f, 0.0983625f, -0.990588f, -0.0951862f, 
		0.0983625f, -0.990588f, -0.0951862f, -0.703359f, 0.679826f, -0.207658f, 
		-0.924983f, 0.354187f, -0.137687f, -0.572751f, 0.778346f, -0.257165f, 
		0.619533f, -0.620381f, -0.480943f, 0.523654f, -0.756067f, -0.392618f, 
		0.758367f, -0.406711f, -0.509378f, -0.526199f, -0.143541f, 0.838159f, 
		-0.591312f, -0.628319f, -0.505535f, -0.429198f, -0.745651f, -0.509700f, 
		-0.697525f, 0.0293902f, -0.715958f, -0.697525f, 0.0293902f, -0.715958f, 
		0.483727f, 0.329366f, 0.810880f, 0.0349443f, -0.931527f, -0.361991f, 
		-0.423358f, -0.889805f, -0.170338f, -0.201660f, -0.934359f, -0.293779f, 
		-0.0690339f, -0.935713f, -0.345942f, -0.265954f, -0.925051f, -0.271200f, 
		-0.0472843f, 0.972976f, -0.226014f, 0.225900f, 0.169775f, -0.959242f, 
		0.101760f, -0.184841f, -0.977486f, 0.0135303f, -0.286428f, -0.958006f, 
		-0.0408022f, -0.970586f, 0.237270f, 0.497929f, 0.165652f, 0.851250f, 
		0.368674f, -0.416850f, -0.830852f, 0.0250404f, 0.998441f, -0.0498922f, 
		-0.0630732f, 0.995715f, -0.0676266f, -0.288436f, 0.955722f, 0.0583070f, 
		-0.133331f, 0.991072f, -0.000108107f, -0.231901f, 0.972298f, -0.0293053f, 
		-0.0310706f, 0.954501f, 0.296586f, -0.0969676f, 0.943056f, 0.318186f, 
		-0.0310706f, 0.954501f, 0.296586f, -0.0969676f, 0.943056f, 0.318186f, 
		0.139353f, 0.962494f, 0.232778f, -0.0310706f, 0.954501f, 0.296586f, 
		0.799259f, -0.0454080f, -0.599269f, 0.799259f, -0.0454080f, -0.599269f, 
		-0.270699f, -0.937962f, 0.216679f, -0.515925f, -0.831969f, 0.204080f, 
		-0.759416f, -0.622642f, 0.188690f, -0.515217f, 0.249031f, -0.820082f, 
		-0.759416f, -0.622642f, 0.188690f, -0.515217f, 0.249031f, -0.820082f, 
		-0.0240160f, 0.597311f, -0.801650f, -0.338427f, -0.344835f, -0.875532f, 
		-0.753350f, -0.570112f, -0.327775f, 0.0953556f, -0.993294f, 0.0653749f, 
		0.0953556f, -0.993294f, 0.0653749f, -0.753350f, -0.570112f, -0.327775f, 
		-0.578413f, -0.286441f, 0.763800f, 0.0719161f, 0.954853f, -0.288242f, 
		0.0318936f, 0.993186f, 0.112088f, -0.0166650f, 0.976914f, 0.212981f, 
		0.0846742f, -0.995172f, 0.0496203f, 0.0846742f, -0.995172f, 0.0496203f, 
		0.0846742f, -0.995172f, 0.0496203f, 0.977879f, -0.207416f, 0.0270467f, 
		0.977879f, -0.207416f, 0.0270467f, -0.866485f, 0.290128f, -0.406237f, 
		-0.198914f, -0.583398f, 0.787452f, -0.190049f, 0.153733f, -0.969664f, 
		0.476875f, 0.0474389f, 0.877690f, -0.187759f, -0.962714f, -0.194750f, 
		0.0230246f, -0.965052f, -0.261046f, -0.0808963f, -0.963520f, -0.255116f, 
		-0.170854f, -0.981420f, 0.0873168f, 0.906514f, 0.104912f, -0.408934f, 
		0.771197f, -0.299215f, -0.561895f, 0.870662f, -0.155241f, -0.466742f, 
		0.881206f, 0.261132f, -0.394063f, 0.889896f, -0.0158900f, -0.455887f, 
		0.376221f, -0.925116f, -0.0511665f, 0.596256f, -0.801624f, 0.0433298f, 
		0.843191f, -0.534487f, 0.0578937f, 0.843191f, -0.534487f, 0.0578937f, 
		0.376221f, -0.925116f, -0.0511665f, 0.927628f, -0.367130f, 0.0687178f, 
		-0.136941f, 0.989732f, -0.0409659f, -0.302960f, 0.948570f, 0.0918146f, 
		-0.206029f, 0.976157f, -0.0683352f, -0.289708f, 0.946718f, -0.140694f, 
		-0.148412f, 0.974586f, -0.167800f, 0.230654f, 0.958452f, 0.167835f, 
		-0.0455119f, -0.945598f, 0.322139f, 0.356424f, 0.840948f, 0.407147f, 
		0.149645f, 0.966012f, 0.210775f, 0.149645f, 0.966012f, 0.210775f, 
		-0.0555587f, 0.939616f, 0.337691f, 0.0764195f, 0.980688f, 0.180032f, 
		0.160130f, 0.978876f, 0.127125f, 0.00269053f, 0.896962f, 0.442099f, 
		0.00269053f, 0.896962f, 0.442099f, 0.261117f, 0.893719f, -0.364807f, 
		0.100527f, 0.580334f, -0.808150f, -0.0297246f, 0.434844f, -0.900015f, 
		0.247370f, 0.954407f, -0.167079f, -0.748390f, 0.321536f, 0.580109f, 
		-0.562846f, 0.120112f, 0.817788f, -0.747019f, 0.525982f, 0.406578f, 
		-0.414042f, 0.0228148f, 0.909972f, 0.953370f, -0.232235f, -0.192751f, 
		0.953370f, -0.232235f, -0.192751f, 0.953370f, -0.232235f, -0.192751f, 
		0.0222806f, -0.969118f, -0.245587f, -0.0791292f, -0.965938f, -0.246379f, 
		-0.234433f, -0.953057f, -0.191633f, -0.00823375f, -0.587527f, -0.809163f, 
		-0.502445f, -0.459306f, 0.732521f, -0.502445f, -0.459306f, 0.732521f, 
		-0.308130f, -0.951267f, 0.0121084f, 0.499719f, 0.854492f, 0.141862f, 
		0.968976f, 0.246619f, 0.0162808f, 0.751345f, 0.647858f, 0.125544f, 
		0.842015f, 0.531902f, 0.0899449f, 0.842015f, 0.531902f, 0.0899449f, 
		0.751345f, 0.647858f, 0.125544f, 0.467066f, 0.290091f, 0.835282f, 
		0.467066f, 0.290091f, 0.835282f, 0.0423446f, -0.668592f, -0.742423f, 
		0.628557f, -0.632838f, -0.452142f, 0.628557f, -0.632838f, -0.452142f, 
		0.691583f, -0.538711f, -0.481147f, 0.555090f, -0.694701f, -0.457455f, 
		0.0722545f, 0.915790f, 0.395106f, -0.269509f, 0.818951f, 0.506640f, 
		0.306550f, 0.895386f, 0.322972f, -0.0838748f, -0.645644f, -0.759018f, 
		-0.0276656f, -0.544517f, -0.838293f, 0.0137540f, -0.315727f, -0.948750f, 
		0.00729746f, -0.0781589f, -0.996914f, -0.0305475f, -0.432527f, -0.901104f, 
		-0.306831f, 0.547756f, -0.778343f, -0.345835f, 0.306290f, -0.886896f, 
		0.261675f, 0.933214f, -0.246248f, -0.195145f, 0.0262170f, -0.980424f, 
		-0.365854f, -0.916913f, 0.159440f, -0.850964f, 0.416575f, -0.319882f, 
		-0.421099f, -0.885853f, -0.194780f, -0.303203f, 0.942240f, 0.142306f, 
		-0.180176f, 0.983310f, 0.0252688f, -0.452844f, 0.883989f, 0.116171f, 
		-0.310595f, 0.135435f, 0.940844f, -0.470799f, 0.848092f, -0.243083f, 
		0.530644f, 0.281425f, 0.799510f, -0.393918f, -0.428291f, -0.813262f, 
		-0.393918f, -0.428291f, -0.813262f, 0.353428f, -0.907853f, -0.225592f, 
		0.913271f, -0.299649f, -0.275948f, 0.353428f, -0.907853f, -0.225592f, 
		0.913271f, -0.299649f, -0.275948f, 0.217579f, -0.895183f, 0.388983f, 
		0.696519f, -0.507404f, 0.507348f, 0.356219f, -0.852104f, 0.383441f, 
		0.217579f, -0.895183f, 0.388983f, 0.531857f, 0.794456f, 0.293202f, 
		0.592634f, 0.779178f, 0.204123f, 0.628446f, 0.725052f, 0.281701f, 
		0.644149f, 0.688594f, 0.333033f, 0.531857f, 0.794456f, 0.293202f, 
		0.740133f, 0.621241f, 0.257418f, 0.480915f, 0.875757f, 0.0420832f, 
		0.909989f, 0.390314f, -0.139910f, 0.812117f, 0.553986f, -0.183209f, 
		0.327084f, 0.929643f, 0.169646f, 0.916445f, 0.353550f, -0.187434f, 
		0.311798f, 0.944604f, 0.102490f, 0.916445f, 0.353550f, -0.187434f, 
		0.311798f, 0.944604f, 0.102490f, 0.814545f, -0.200103f, 0.544495f, 
		0.814545f, -0.200103f, 0.544495f, -0.0473964f, -0.652519f, -0.756289f, 
		-0.0930529f, 0.971101f, 0.219783f, 0.174014f, 0.984319f, -0.0289119f, 
		0.0250476f, 0.994825f, 0.0984719f, 0.990897f, -0.121383f, -0.0582193f, 
		0.990897f, -0.121383f, -0.0582193f, 0.990897f, -0.121383f, -0.0582193f, 
		0.358174f, 0.835224f, 0.417268f, -0.464670f, 0.158900f, -0.871110f, 
		-0.129641f, -0.915694f, 0.380391f, -0.201122f, -0.841009f, 0.502249f, 
		-0.0568786f, -0.959046f, 0.277482f, 0.0524163f, -0.997739f, -0.0420700f, 
		0.117199f, -0.980912f, -0.155167f, 0.118499f, -0.948255f, -0.294568f, 
		0.811139f, 0.560966f, -0.165437f, 0.900611f, 0.281336f, -0.331285f, 
		0.843513f, 0.474080f, -0.252457f, 0.850387f, 0.436399f, -0.293936f, 
		0.827463f, 0.521035f, -0.209352f, 0.863697f, -0.493974f, -0.100085f, 
		-0.803467f, 0.435274f, -0.406173f, -0.237858f, 0.963709f, -0.121194f, 
		0.654880f, -0.359577f, 0.664708f, 0.443331f, -0.722517f, 0.530497f, 
		0.730770f, -0.150588f, 0.665807f, -0.202657f, 0.872330f, -0.444939f, 
		-0.00775109f, 0.996593f, 0.0821175f, -0.0164098f, 0.998361f, -0.0548243f, 
		-0.310076f, 0.818397f, -0.483817f, -0.00775109f, 0.996593f, 0.0821175f, 
		-0.137943f, 0.959594f, -0.245257f, 0.904461f, -0.131971f, 0.405628f, 
		0.904461f, -0.131971f, 0.405628f, 0.894870f, -0.0651479f, 0.441547f, 
		0.791718f, -0.415057f, 0.448230f, 0.887501f, 0.182382f, 0.423176f, 
		0.925863f, 0.0165665f, 0.377497f, 0.925863f, 0.0165665f, 0.377497f, 
		0.925863f, 0.0165665f, 0.377497f, -0.312720f, -0.939366f, -0.140702f, 
		-0.861552f, 0.400330f, -0.312192f, 0.851889f, -0.238189f, -0.466423f, 
		-0.345411f, 0.936451f, -0.0612414f, 0.851889f, -0.238189f, -0.466423f, 
		0.914954f, 0.0888578f, -0.393655f, 0.201959f, 0.153004f, -0.967369f, 
		-0.0315488f, 0.800614f, -0.598350f, 0.914954f, 0.0888578f, -0.393655f, 
		-0.257159f, 0.183177f, -0.948850f, -0.257159f, 0.183177f, -0.948850f, 
		0.965263f, -0.00645810f, -0.261199f, 0.965263f, -0.00645810f, -0.261199f, 
		0.965263f, -0.00645810f, -0.261199f, -0.846242f, -0.398807f, -0.353310f, 
		-0.933649f, 0.142424f, -0.328656f, -0.947106f, -0.0369011f, -0.318793f, 
		-0.673476f, -0.667812f, -0.316950f, -0.530014f, 0.720848f, 0.446613f, 
		-0.103470f, 0.866651f, -0.488068f, 0.248008f, -0.509539f, -0.823931f, 
		-0.00774245f, -0.983718f, 0.179553f, -0.152643f, -0.00326714f, -0.988276f, 
		-0.152643f, -0.00326714f, -0.988276f, 0.463111f, -0.877802f, -0.122443f, 
		0.896743f, -0.355315f, -0.263822f, 0.764033f, -0.597957f, -0.242281f, 
		0.896743f, -0.355315f, -0.263822f, 0.463111f, -0.877802f, -0.122443f, 
		0.295375f, -0.948085f, -0.117847f, -0.184909f, 0.943896f, -0.273623f, 
		-0.184909f, 0.943896f, -0.273623f, -0.184909f, 0.943896f, -0.273623f, 
		-0.184909f, 0.943896f, -0.273623f, 0.236825f, -0.816175f, -0.527041f, 
		0.257518f, -0.966272f, 0.00171390f, 0.165214f, -0.789518f, -0.591072f, 
		0.290035f, -0.734832f, -0.613108f, 0.226584f, -0.752066f, -0.618916f, 
		0.0480037f, 0.930699f, 0.362623f, 0.313666f, 0.913768f, 0.258149f, 
		0.218838f, 0.925137f, 0.310211f, -0.114699f, 0.908769f, 0.401226f, 
		0.119585f, 0.940582f, 0.317813f, 0.476402f, 0.879228f, 0.000238065f, 
		0.476402f, 0.879228f, 0.000238065f, 0.476402f, 0.879228f, 0.000238065f, 
		0.486224f, 0.822000f, -0.296484f, 0.444506f, 0.0614790f, -0.893664f, 
		0.486224f, 0.822000f, -0.296484f, 0.444506f, 0.0614790f, -0.893664f, 
		0.823172f, -0.449668f, -0.346680f, 0.249541f, -0.959966f, -0.127261f, 
		0.249541f, -0.959966f, -0.127261f, 0.823172f, -0.449668f, -0.346680f, 
		0.907449f, 0.397734f, -0.135443f, 0.907449f, 0.397734f, -0.135443f, 
		0.236870f, 0.956862f, 0.168247f, 0.236870f, 0.956862f, 0.168247f, 
		0.771179f, -0.506593f, -0.385547f, 0.771179f, -0.506593f, -0.385547f, 
		0.771179f, -0.506593f, -0.385547f, -0.0992435f, 0.845703f, 0.524345f, 
		-0.268083f, 0.767989f, 0.581657f, -0.264209f, 0.247926f, -0.932055f, 
		0.216975f, 0.884823f, 0.412324f, -0.794718f, 0.437008f, 0.421245f, 
		-0.250586f, -0.0357013f, 0.967436f, -0.188755f, 0.0698420f, 0.979537f, 
		-0.0869147f, 0.133570f, 0.987221f, 0.724980f, 0.439831f, 0.530049f, 
		0.730643f, 0.354489f, 0.583523f, 0.749120f, 0.279308f, 0.600672f, 
		-0.122035f, -0.990607f, -0.0616896f, -0.560444f, -0.686097f, 0.463868f, 
		-0.144394f, -0.944465f, -0.295187f, -0.195632f, -0.896311f, -0.397939f, 
		0.498743f, 0.802996f, -0.326270f, 0.494986f, 0.758073f, -0.424634f, 
		0.694486f, 0.707596f, -0.130371f, 0.276607f, 0.799020f, -0.533906f, 
		0.250438f, 0.610164f, -0.751652f, 0.342442f, 0.140066f, -0.929040f, 
		-0.558539f, -0.413130f, 0.719276f, -0.149701f, -0.382365f, -0.911804f, 
		0.427597f, 0.403769f, 0.808784f, 0.571641f, 0.715916f, 0.400864f, 
		0.502723f, 0.786250f, 0.359277f, 0.520517f, 0.694116f, 0.497257f, 
		0.600431f, 0.676957f, 0.425689f, 0.571641f, 0.715916f, 0.400864f, 
		-0.781896f, 0.500679f, 0.371427f, -0.908641f, 0.136212f, -0.394738f, 
		-0.574490f, 0.775467f, 0.261941f, -0.242770f, 0.962139f, 0.123897f, 
		-0.565160f, -0.311075f, -0.764086f, -0.302795f, -0.620643f, -0.723268f, 
		-0.152396f, -0.703516f, -0.694147f, -0.158528f, 0.955305f, -0.249522f, 
		-0.158528f, 0.955305f, -0.249522f, 0.0723896f, -0.960405f, -0.269040f, 
		0.0640917f, 0.974410f, -0.215449f, 0.651315f, 0.545943f, 0.527005f, 
		0.0640917f, 0.974410f, -0.215449f, 0.651315f, 0.545943f, 0.527005f, 
		0.831075f, 0.00944859f, 0.556080f, -0.262274f, -0.402661f, 0.876970f, 
		0.393521f, 0.332357f, 0.857135f, 0.145291f, 0.336914f, 0.930258f, 
		0.662271f, 0.109412f, 0.741233f, 0.883961f, 0.386780f, -0.262706f, 
		0.159059f, 0.985656f, 0.0564097f, 0.159059f, 0.985656f, 0.0564097f, 
		0.883961f, 0.386780f, -0.262706f, 0.626659f, -0.422313f, 0.654943f, 
		0.113744f, -0.710376f, 0.694571f, -0.0590532f, -0.684987f, 0.726158f, 
		-0.0969686f, -0.605177f, 0.790163f, -0.0202538f, -0.742793f, 0.669215f, 
		0.0324762f, -0.795138f, 0.605559f, 0.102400f, -0.852948f, 0.511853f, 
		-0.584097f, -0.808488f, -0.0719603f, -0.956468f, -0.288354f, 0.0449657f, 
		-0.676122f, -0.736628f, -0.0154726f, -0.431071f, -0.889469f, -0.151734f, 
		-0.888373f, -0.459098f, -0.00468164f, -0.825059f, -0.562885f, -0.0493881f, 
		0.0825987f, -0.970569f, -0.226215f, 0.545826f, -0.465930f, -0.696407f, 
		0.494908f, -0.633234f, -0.595046f, 0.545826f, -0.465930f, -0.696407f, 
		0.320895f, 0.945839f, 0.0491352f, -0.123369f, -0.984281f, -0.126377f, 
		0.504842f, -0.164825f, -0.847330f, 0.504842f, -0.164825f, -0.847330f, 
		0.504842f, -0.164825f, -0.847330f, -0.641096f, -0.766710f, 0.0339301f, 
		-0.425343f, -0.855391f, 0.295618f, -0.777813f, -0.621179f, 0.0956179f, 
		-0.405512f, -0.627932f, -0.664275f, -0.332352f, -0.505777f, -0.796072f, 
		-0.777813f, -0.621179f, 0.0956179f, -0.104258f, -0.304334f, -0.946843f, 
		-0.617162f, -0.774036f, 0.141350f, 0.927522f, 0.281262f, -0.246158f, 
		-0.186813f, 0.949301f, -0.252839f, -0.601355f, 0.667317f, -0.439387f, 
		-0.532321f, 0.768132f, -0.355820f, -0.118939f, 0.936578f, -0.329659f, 
		-0.400222f, 0.829690f, -0.389149f, -0.305901f, 0.899452f, -0.312106f, 
		-0.118939f, 0.936578f, -0.329659f, -0.0562635f, 0.966526f, -0.250322f, 
		-0.405850f, -0.898071f, 0.169569f, 0.217383f, 0.916250f, -0.336497f, 
		0.438090f, 0.825344f, -0.356208f, -0.0369287f, 0.267876f, -0.962745f, 
		0.704612f, 0.508498f, -0.494925f, 0.805885f, 0.226448f, -0.547056f, 
		-0.0143509f, -0.912917f, 0.407894f, 0.321550f, -0.762641f, 0.561235f, 
		0.104996f, -0.865303f, 0.490128f, -0.497523f, -0.246465f, 0.831701f, 
		0.0779343f, 0.466888f, 0.880876f, -0.437950f, -0.266987f, 0.858439f, 
		-0.437950f, -0.266987f, 0.858439f, -0.437950f, -0.266987f, 0.858439f, 
		0.951215f, 0.240431f, -0.193346f, 0.969216f, 0.141059f, -0.201800f, 
		0.969216f, 0.141059f, -0.201800f, 0.976340f, 0.0809930f, -0.200501f, 
		0.0709024f, -0.987976f, 0.137393f, -0.549918f, -0.504729f, 0.665462f, 
		-0.357682f, -0.684252f, -0.635502f, -0.963241f, 0.254899f, -0.0848110f, 
		-0.302111f, 0.940761f, -0.153939f, -0.490589f, -0.0664864f, 0.868851f, 
		-0.491902f, -0.834084f, 0.249673f, -0.464545f, -0.885540f, -0.00402593f, 
		-0.446793f, -0.886741f, -0.118601f, 0.921913f, 0.331659f, -0.200196f, 
		-0.560577f, -0.826786f, 0.0466749f, 0.878287f, 0.212738f, -0.428199f, 
		0.822763f, -0.427652f, -0.374398f, 0.900272f, -0.295656f, -0.319527f, 
		0.790594f, 0.395466f, -0.467512f, 0.822763f, -0.427652f, -0.374398f, 
		-0.946914f, -0.0874072f, -0.309376f, -0.949016f, -0.225677f, -0.220088f, 
		-0.950761f, -0.0197038f, 0.309296f, -0.982347f, -0.186599f, -0.0132357f, 
		-0.891690f, 0.167312f, -0.420589f, -0.902723f, -0.0111502f, -0.430078f, 
		-0.325059f, -0.539915f, -0.776420f, -0.962573f, -0.267241f, -0.0451221f, 
		0.0601327f, 0.989501f, 0.131421f, -0.482292f, -0.867039f, -0.125051f, 
		-0.871892f, -0.481699f, -0.0881512f, -0.770147f, -0.622764f, -0.137983f, 
		0.144424f, -0.920028f, 0.364266f, 0.144424f, -0.920028f, 0.364266f, 
		0.217207f, -0.871113f, 0.440435f, 0.378554f, -0.724266f, 0.576313f, 
		0.257692f, 0.928002f, -0.269086f, 0.401940f, 0.869080f, -0.288346f, 
		0.170793f, 0.961660f, -0.214570f, 0.401956f, -0.834855f, -0.376096f, 
		0.401956f, -0.834855f, -0.376096f, 0.0649138f, 0.994920f, 0.0769384f, 
		0.418871f, -0.479978f, -0.770823f, -0.707643f, -0.458836f, -0.537318f, 
		-0.370783f, -0.455527f, -0.809330f, -0.143517f, -0.441857f, -0.885531f, 
		-0.238196f, -0.524779f, -0.817233f, -0.930347f, -0.223112f, -0.290992f, 
		-0.467475f, -0.488443f, -0.736811f, -0.920468f, -0.240804f, -0.307819f, 
		-0.436158f, -0.879609f, 0.189881f, -0.920468f, -0.240804f, -0.307819f, 
		-0.505625f, -0.829865f, 0.235939f, -0.0991204f, -0.0504493f, -0.993796f, 
		0.251650f, 0.178111f, -0.951288f, 0.423152f, 0.142295f, -0.894815f, 
		-0.206821f, -0.232699f, -0.950303f, -0.0553469f, -0.617305f, -0.784775f, 
		-0.938572f, 0.146111f, -0.312623f, -0.938572f, 0.146111f, -0.312623f, 
		-0.997296f, 0.0229016f, -0.0698351f, -0.581423f, 0.659322f, 0.476698f, 
		-0.691107f, 0.548261f, 0.470936f, -0.722830f, 0.476772f, 0.500206f, 
		-0.754232f, 0.400349f, 0.520437f, -0.500641f, 0.732784f, 0.460853f, 
		-0.405539f, 0.810067f, 0.423473f, -0.814409f, 0.318455f, 0.485103f, 
		-0.410751f, 0.699082f, -0.585292f, -0.376472f, -0.567724f, -0.732091f, 
		-0.409011f, -0.733039f, -0.543475f, -0.329236f, -0.502157f, -0.799651f, 
		-0.639673f, -0.686813f, -0.345117f, -0.639673f, -0.686813f, -0.345117f, 
		0.437535f, -0.679392f, -0.589058f, 0.531960f, -0.549184f, -0.644528f, 
		-0.0883927f, 0.230777f, -0.968983f, 0.719269f, -0.270860f, -0.639755f, 
		-0.897888f, -0.384090f, 0.215111f, 0.0601327f, 0.989501f, 0.131421f, 
		-0.823202f, 0.288242f, -0.489137f, -0.781302f, 0.408917f, -0.471545f, 
		-0.711924f, 0.402453f, -0.575496f, -0.751484f, 0.295271f, -0.589989f, 
		-0.767390f, 0.359296f, -0.531054f, 0.653687f, 0.686438f, -0.318585f, 
		0.713152f, 0.685091f, -0.148543f, 0.701976f, 0.667056f, -0.249531f, 
		0.104776f, -0.908273f, -0.405047f, -0.0260959f, -0.928396f, -0.370675f, 
		0.0264074f, -0.913420f, -0.406161f, -0.157061f, -0.542422f, -0.825294f, 
		0.540207f, 0.0668537f, 0.838872f, 0.395934f, 0.137993f, 0.907851f, 
		0.106089f, 0.340722f, 0.934159f, -0.948435f, 0.306711f, -0.0799978f, 
		0.337915f, 0.390258f, -0.856453f, 0.337915f, 0.390258f, -0.856453f, 
		0.337915f, 0.390258f, -0.856453f, -0.870647f, 0.231480f, -0.434040f, 
		-0.0790827f, 0.913136f, -0.399911f, -0.446342f, -0.623783f, 0.641618f, 
		-0.446342f, -0.623783f, 0.641618f, -0.446342f, -0.623783f, 0.641618f, 
		-0.493675f, -0.0579924f, -0.867711f, -0.480622f, -0.711772f, 0.512234f, 
		0.106654f, 0.681628f, -0.723884f, 0.106654f, 0.681628f, -0.723884f, 
		0.225663f, -0.696709f, 0.680935f, -0.436252f, -0.878844f, 0.193176f, 
		-0.132473f, 0.344104f, -0.929539f, 0.450217f, 0.837231f, -0.310401f, 
		-0.0428656f, 0.143838f, -0.988672f, 0.215194f, -0.0935783f, -0.972077f, 
		0.509244f, -0.127651f, -0.851102f, 0.664866f, -0.0436242f, -0.745688f, 
		-0.0123546f, 0.300681f, 0.953645f, 0.527161f, 0.809593f, 0.258187f, 
		-0.0123546f, 0.300681f, 0.953645f, 0.527161f, 0.809593f, 0.258187f, 
		-0.683713f, -0.423316f, -0.594424f, -0.436160f, -0.537120f, -0.721988f, 
		0.143774f, -0.494133f, -0.857416f, 0.347503f, -0.389179f, -0.853101f, 
		-0.0777494f, -0.599506f, -0.796585f, 0.0840785f, -0.983606f, 0.159530f, 
		0.575447f, 0.448498f, 0.683893f, -0.109720f, -0.930598f, -0.349212f, 
		0.0515717f, -0.995921f, -0.0740363f, -0.261014f, -0.805927f, -0.531370f, 
		-0.889018f, -0.324329f, -0.323199f, -0.647238f, -0.713497f, -0.268337f, 
		-0.546846f, -0.796875f, -0.256808f, 0.217122f, -0.303285f, -0.927834f, 
		0.131185f, -0.991333f, -0.00701027f, 0.712801f, -0.412055f, -0.567561f, 
		0.110749f, -0.132889f, -0.984924f, 0.110749f, -0.132889f, -0.984924f, 
		0.675661f, 0.736963f, 0.0191646f, 0.675661f, 0.736963f, 0.0191646f, 
		0.580217f, -0.572629f, -0.579176f, 0.697523f, -0.326565f, -0.637822f, 
		0.641369f, -0.436702f, -0.630822f, 0.641369f, -0.436702f, -0.630822f, 
		0.697523f, -0.326565f, -0.637822f, -0.721927f, -0.540605f, -0.431935f, 
		-0.0560450f, -0.982207f, 0.179245f, -0.0560450f, -0.982207f, 0.179245f, 
		-0.721927f, -0.540605f, -0.431935f, -0.0974122f, 0.0706195f, -0.992736f, 
		0.473201f, 0.0443040f, -0.879840f, -0.216458f, 0.0569318f, -0.974631f, 
		-0.372803f, 0.347223f, 0.860496f, 0.298997f, -0.757661f, -0.580130f, 
		0.115298f, -0.723960f, -0.680139f, 0.196460f, -0.721092f, -0.664402f, 
		-0.957881f, -0.0361207f, 0.284885f, -0.723446f, -0.558230f, -0.406208f, 
		-0.805406f, -0.336155f, -0.488181f, -0.856688f, -0.0333791f, -0.514753f, 
		-0.740949f, -0.446281f, -0.501824f, -0.794720f, -0.280571f, -0.538237f, 
		-0.427710f, -0.0342290f, 0.903268f, -0.355549f, 0.00760274f, 0.934627f, 
		-0.400058f, -0.208114f, 0.892548f, -0.262863f, 0.327981f, 0.907376f, 
		-0.427710f, -0.0342290f, 0.903268f, -0.375858f, 0.161351f, 0.912522f, 
		0.136823f, 0.261867f, -0.955356f, -0.907563f, 0.00457178f, -0.419891f, 
		-0.824951f, -0.270253f, -0.496406f, -0.871231f, -0.0914872f, -0.482273f, 
		-0.542130f, 0.246050f, 0.803464f, -0.253699f, -0.634069f, 0.730475f, 
		-0.153964f, -0.732238f, 0.663418f, 0.123258f, -0.744817f, 0.655786f, 
		-0.191694f, -0.774037f, 0.603423f, -0.372493f, -0.799320f, 0.471525f, 
		-0.293772f, -0.745510f, 0.598258f, -0.322393f, -0.783079f, 0.531837f, 
		-0.442103f, 0.488525f, 0.752256f, -0.706401f, -0.360779f, -0.608963f, 
		0.747919f, 0.625386f, -0.222507f, 0.686253f, -0.0752599f, -0.723459f, 
		0.686253f, -0.0752599f, -0.723459f, 0.747919f, 0.625386f, -0.222507f, 
		-0.476481f, -0.241457f, 0.845378f, 0.317284f, 0.833438f, -0.452452f, 
		0.671135f, 0.438000f, -0.598109f, 0.708316f, 0.0842688f, -0.700847f, 
		-0.686810f, 0.558721f, -0.464890f, -0.818307f, 0.301186f, -0.489551f, 
		-0.225436f, 0.875574f, -0.427258f, -0.0420240f, 0.939585f, -0.339726f, 
		0.629197f, 0.585269f, -0.511440f, 0.571943f, 0.792993f, -0.209868f, 
		0.369713f, 0.923674f, 0.100692f, 0.255535f, 0.954740f, 0.152230f, 
		0.731269f, -0.408274f, 0.546405f, 0.514452f, 0.821065f, 0.247370f, 
		0.514452f, 0.821065f, 0.247370f, -0.0938318f, -0.680020f, -0.727165f, 
		0.00322824f, 0.941652f, -0.336571f, 0.675425f, 0.431908f, -0.597709f, 
		0.675425f, 0.431908f, -0.597709f, 0.00322824f, 0.941652f, -0.336571f, 
		-0.385532f, -0.872664f, 0.299703f, -0.217865f, -0.965162f, 0.144905f, 
		-0.308078f, -0.919947f, 0.242458f, -0.308078f, -0.919947f, 0.242458f, 
		-0.308078f, -0.919947f, 0.242458f, -0.638523f, -0.168108f, 0.751018f, 
		-0.632315f, -0.697254f, 0.337660f, -0.502886f, -0.833565f, 0.228637f, 
		-0.559257f, -0.0403870f, 0.828010f, -0.0307250f, 0.877658f, 0.478301f, 
		-0.418927f, 0.608547f, 0.673922f, -0.613986f, 0.381718f, 0.690878f, 
		0.0784051f, 0.945640f, 0.315622f, -0.731681f, 0.0615288f, -0.678864f, 
		0.347120f, 0.0873808f, -0.933741f, 0.347120f, 0.0873808f, -0.933741f, 
		0.983542f, 0.143845f, -0.109332f, -0.416368f, -0.908910f, 0.0228123f, 
		-0.234148f, 0.870887f, -0.432123f, -0.468977f, 0.310865f, 0.826695f, 
		-0.224478f, -0.539053f, -0.811808f, -0.934904f, 0.0632102f, -0.349227f, 
		-0.916716f, -0.0626962f, -0.394591f, -0.927728f, -0.176236f, -0.329032f, 
		-0.873849f, -0.345948f, -0.341624f, -0.838266f, 0.218919f, -0.499384f, 
		-0.621260f, 0.278528f, -0.732433f, -0.642028f, 0.138611f, 0.754047f, 
		-0.527236f, 0.340420f, 0.778548f, -0.719253f, 0.0252725f, 0.694288f, 
		-0.607625f, 0.254266f, 0.752423f, -0.547815f, 0.480103f, 0.685128f, 
		0.879175f, 0.240191f, -0.411533f, -0.494147f, -0.837916f, 0.231767f, 
		-0.479271f, 0.564091f, 0.672384f, 0.272991f, -0.856906f, -0.437251f, 
		-0.757626f, -0.0964339f, -0.645525f, 0.272991f, -0.856906f, -0.437251f, 
		-0.841263f, 0.425641f, -0.333326f, -0.269874f, 0.962891f, 0.00288763f, 
		-0.454118f, 0.129076f, 0.881542f, 0.0636070f, 0.0179819f, -0.997813f, 
		-0.127293f, 0.199256f, -0.971645f, 0.0636070f, 0.0179819f, -0.997813f, 
		-0.237380f, 0.351538f, -0.905578f, -0.127293f, 0.199256f, -0.971645f, 
		-0.237380f, 0.351538f, -0.905578f, 0.268915f, 0.961513f, 0.0563658f, 
		0.463316f, 0.871610f, -0.160109f, 0.363740f, 0.931487f, -0.00501804f, 
		0.246562f, 0.949127f, 0.195871f, 0.511104f, 0.810825f, -0.285193f, 
		0.171720f, -0.812944f, -0.556448f, 0.440252f, -0.773576f, -0.455806f, 
		-0.353686f, -0.920633f, 0.165353f, -0.0950741f, -0.823548f, -0.559223f, 
		0.237078f, 0.269424f, -0.933384f, 0.313112f, 0.0891378f, -0.945524f, 
		0.313112f, 0.0891378f, -0.945524f, 0.983542f, 0.143845f, -0.109332f, 
		-0.0165195f, 0.566494f, -0.823900f, -0.535640f, -0.389825f, 0.749084f, 
		-0.450205f, -0.677684f, 0.581430f, -0.487213f, -0.246771f, 0.837692f, 
		-0.492557f, -0.511662f, 0.703981f, -0.386518f, -0.770449f, 0.506964f, 
		-0.374931f, -0.855843f, 0.356313f, -0.662176f, -0.357034f, -0.658825f, 
		0.486317f, -0.0510130f, -0.872292f, -0.316315f, -0.664496f, -0.677045f, 
		-0.428112f, -0.545939f, -0.720188f, -0.545825f, -0.717400f, 0.432912f, 
		-0.545825f, -0.717400f, 0.432912f, 0.282503f, 0.564595f, -0.775515f, 
		0.850731f, 0.453176f, -0.266248f, 0.240030f, 0.719943f, -0.651205f, 
		-0.118761f, 0.762956f, -0.635448f, 0.780197f, 0.572254f, -0.252623f, 
		0.521769f, 0.744014f, -0.417372f, 0.604662f, 0.610779f, -0.511207f, 
		-0.146375f, 0.952981f, -0.265331f, -0.194279f, 0.967808f, -0.160012f, 
		-0.146375f, 0.952981f, -0.265331f, -0.135783f, 0.912307f, -0.386340f, 
		-0.385055f, -0.825047f, -0.413557f, -0.385055f, -0.825047f, -0.413557f, 
		0.508996f, -0.382457f, -0.771136f, 0.330745f, -0.421073f, -0.844574f, 
		0.365651f, -0.226397f, -0.902798f, 0.571440f, -0.195560f, -0.797002f, 
		0.448402f, -0.662400f, -0.600135f, 0.448402f, -0.662400f, -0.600135f, 
		-0.436154f, -0.465816f, -0.769925f, -0.586861f, -0.326827f, -0.740796f, 
		-0.706687f, -0.259606f, -0.658178f, -0.336757f, -0.517850f, -0.786400f, 
		-0.230225f, -0.609064f, -0.758972f, 0.325192f, 0.882837f, 0.338893f, 
		0.300503f, 0.778482f, 0.551057f, -0.0615196f, 0.157385f, 0.985619f, 
		-0.184973f, 0.0552609f, 0.981189f, -0.170414f, 0.945569f, -0.277232f, 
		0.249825f, 0.962777f, -0.103191f, -0.212812f, 0.934137f, 0.286530f, 
		0.117206f, 0.966235f, 0.229463f, -0.343661f, 0.936692f, -0.0671147f, 
		-0.336527f, 0.903826f, -0.264289f, -0.332681f, -0.0858413f, -0.939125f, 
		-0.385400f, 0.426448f, -0.818296f, -0.597363f, -0.194810f, 0.777951f, 
		0.737838f, 0.472320f, -0.482192f, 0.0379559f, 0.987396f, -0.153650f, 
		-0.905949f, -0.405877f, 0.120503f, -0.260726f, -0.957413f, -0.124027f, 
		-0.772500f, -0.631589f, 0.0658696f, 0.0379559f, 0.987396f, -0.153650f, 
		-0.498712f, -0.866408f, -0.0249813f, 0.643165f, 0.144376f, -0.751993f, 
		0.635099f, -0.0506877f, -0.770766f, 0.635099f, -0.0506877f, -0.770766f, 
		0.215829f, 0.702568f, -0.678097f, 0.550633f, 0.727152f, -0.409943f, 
		0.455394f, 0.595000f, -0.662262f, -0.245624f, -0.104156f, 0.963753f, 
		-0.245624f, -0.104156f, 0.963753f, -0.369819f, -0.878888f, 0.301313f, 
		-0.641204f, 0.525441f, 0.559257f, -0.804417f, 0.498825f, 0.322624f, 
		-0.656277f, 0.472709f, -0.588087f, -0.798405f, 0.495879f, -0.341546f, 
		-0.656277f, 0.472709f, -0.588087f, -0.234148f, 0.870887f, -0.432123f, 
		0.0368220f, -0.393243f, -0.918697f, -0.382454f, 0.291173f, 0.876896f, 
		0.677194f, 0.705788f, 0.208017f, -0.382454f, 0.291173f, 0.876896f, 
		-0.332198f, 0.941828f, -0.0510281f, -0.390566f, -0.911757f, 0.127110f, 
		0.623573f, -0.0821413f, -0.777438f, 0.320991f, -0.722172f, 0.612725f, 
		0.623573f, -0.0821413f, -0.777438f, -0.463386f, 0.476292f, 0.747274f, 
		-0.354798f, 0.594231f, 0.721809f, -0.237409f, 0.640827f, 0.730053f, 
		0.0468704f, -0.743106f, -0.667530f, 0.499599f, -0.653042f, -0.569154f, 
		-0.289364f, -0.543644f, -0.787858f, -0.399486f, -0.414931f, -0.817461f, 
		-0.765315f, -0.521855f, -0.376776f, 0.136943f, -0.489590f, -0.861132f, 
		0.463121f, -0.184461f, -0.866887f, -0.691669f, 0.452797f, -0.562645f, 
		0.337568f, -0.361820f, -0.868985f, 0.00397081f, 0.993434f, 0.114341f, 
		0.626265f, -0.432486f, -0.648650f, -0.794718f, 0.437008f, 0.421245f, 
		-0.405835f, -0.110563f, 0.907234f, 0.186153f, -0.914119f, -0.360186f, 
		0.179206f, -0.741126f, -0.647007f, 0.155186f, -0.848383f, -0.506126f, 
		-0.647512f, -0.744017f, 0.164828f, -0.595941f, -0.802861f, 0.0163616f, 
		-0.548927f, -0.833894f, -0.0574457f, -0.895697f, 0.146626f, 0.419794f, 
		-0.955346f, 0.237921f, 0.175237f, -0.941783f, 0.200394f, 0.269976f, 
		-0.940015f, -0.149348f, 0.306703f, 0.790651f, 0.611809f, 0.0236857f, 
		-0.337910f, 0.923077f, -0.183697f, -0.337910f, 0.923077f, -0.183697f, 
		-0.573115f, 0.707600f, -0.413330f, 0.816369f, 0.553173f, -0.165958f, 
		-0.518628f, 0.854786f, 0.0191398f, -0.571714f, 0.779869f, -0.254848f, 
		-0.193189f, 0.914423f, 0.355682f, -0.426802f, 0.706179f, 0.564935f, 
		-0.364333f, -0.883201f, -0.295325f, 0.173805f, -0.572261f, -0.801442f, 
		0.216217f, -0.935941f, 0.277964f, 0.173805f, -0.572261f, -0.801442f, 
		0.834638f, 0.531075f, -0.146077f, 0.712283f, -0.246401f, -0.657222f, 
		-0.335173f, -0.174250f, -0.925903f, -0.324395f, 0.878247f, -0.351355f, 
		0.637732f, -0.602692f, -0.479646f, -0.00767601f, -0.298346f, -0.954427f, 
		-0.0254490f, -0.746986f, -0.664353f, 0.449139f, 0.749619f, 0.486154f, 
		-0.305678f, 0.361409f, -0.880877f, 0.285906f, -0.585740f, 0.758397f, 
		-0.751459f, -0.489988f, -0.441839f, -0.461803f, -0.869353f, 0.175963f, 
		-0.695111f, 0.617554f, -0.368033f, -0.768810f, 0.558029f, -0.312305f, 
		-0.695111f, 0.617554f, -0.368033f, -0.0812236f, 0.654536f, -0.751655f, 
		-0.256768f, 0.671160f, -0.695424f, -0.507141f, 0.627081f, -0.591252f, 
		-0.618556f, 0.656667f, -0.431483f, -0.339265f, 0.232643f, -0.911470f, 
		-0.208248f, 0.918744f, -0.335473f, -0.339265f, 0.232643f, -0.911470f, 
		-0.611125f, 0.263418f, 0.746416f, 0.0673353f, 0.692251f, -0.718508f, 
		0.239775f, 0.571499f, -0.784791f, -0.195016f, -0.703842f, -0.683063f, 
		0.132557f, 0.635551f, -0.760594f, -0.935520f, 0.349349f, 0.0525187f, 
		0.319707f, -0.754788f, -0.572785f, -0.420982f, -0.831276f, -0.362978f, 
		-0.331762f, 0.185673f, -0.924910f, -0.331762f, 0.185673f, -0.924910f, 
		0.593178f, 0.358952f, -0.720620f, 0.694372f, -0.436228f, -0.572322f, 
		0.593178f, 0.358952f, -0.720620f, 0.593178f, 0.358952f, -0.720620f, 
		-0.756198f, 0.426094f, -0.496597f, -0.968046f, 0.149932f, -0.201015f, 
		-0.999852f, 0.0146900f, 0.00896631f, 0.240800f, -0.866080f, -0.438088f, 
		0.0659388f, -0.996162f, 0.0575616f, 0.136811f, -0.956522f, -0.257582f, 
		0.136581f, -0.746601f, -0.651100f, -0.0471490f, -0.851309f, -0.522542f, 
		0.461561f, -0.0615524f, -0.884971f, 0.461561f, -0.0615524f, -0.884971f, 
		-0.0623696f, -0.706231f, -0.705229f, -0.0606391f, -0.485702f, -0.872018f, 
		-0.0799370f, -0.337647f, -0.937873f, -0.0585741f, -0.385142f, -0.920996f, 
		0.573848f, -0.507640f, 0.642650f, 0.490764f, -0.387573f, 0.780345f, 
		0.0459306f, -0.105075f, 0.993403f, -0.170354f, -0.0297182f, 0.984935f, 
		0.814143f, -0.151386f, -0.560583f, 0.657963f, -0.0549675f, -0.751041f, 
		0.532510f, 0.0577417f, -0.844452f, -0.994918f, 0.0890841f, -0.0469185f, 
		-0.990883f, -0.0804622f, -0.108061f, -0.930710f, 0.363724f, -0.0385227f, 
		-0.486593f, 0.784650f, -0.384125f, -0.624694f, 0.750446f, -0.215844f, 
		-0.435822f, -0.290357f, -0.851911f, -0.435822f, -0.290357f, -0.851911f, 
		0.416317f, -0.0680831f, 0.906667f, -0.274335f, 0.365569f, 0.889438f, 
		-0.972556f, -0.175333f, 0.152946f, -0.763534f, -0.330694f, 0.554669f, 
		-0.992155f, -0.112814f, 0.0538594f, -0.640561f, 0.488191f, 0.592749f, 
		-0.445982f, 0.567458f, 0.692165f, 0.0600056f, 0.841952f, 0.536206f, 
		0.217999f, 0.858371f, 0.464408f, -0.216785f, -0.909652f, 0.354313f, 
		-0.231407f, -0.931575f, 0.280389f, -0.232056f, -0.848832f, 0.475011f, 
		-0.216785f, -0.909652f, 0.354313f, -0.200501f, 0.700284f, 0.685129f, 
		-0.377041f, 0.922740f, -0.0799397f, -0.674582f, -0.729931f, -0.110185f, 
		-0.304280f, -0.924526f, -0.229490f, -0.467430f, -0.861283f, -0.199250f, 
		-0.892223f, -0.448042f, 0.0565448f, -0.961599f, 0.271025f, 0.0432835f, 
		-0.813472f, -0.473725f, -0.337413f, -0.484666f, 0.175770f, -0.856857f, 
		0.666269f, 0.118282f, -0.736271f, -0.813472f, -0.473725f, -0.337413f, 
		-0.223051f, -0.584052f, -0.780469f, -0.0699708f, -0.635036f, -0.769307f, 
		-0.381983f, -0.308176f, -0.871273f, -0.504298f, -0.174720f, -0.845669f, 
		-0.504298f, -0.174720f, -0.845669f, -0.862811f, 0.377122f, -0.336655f, 
		-0.107818f, 0.985858f, -0.128292f, -0.713534f, -0.431571f, 0.551920f, 
		-0.980649f, 0.102227f, 0.166966f, -0.865378f, -0.299167f, 0.402020f, 
		-0.810946f, 0.581413f, 0.0657723f, -0.678273f, 0.730966f, 0.0750611f, 
		-0.285958f, 0.780483f, 0.555945f, -0.604998f, 0.564638f, 0.561392f, 
		-0.604998f, 0.564638f, 0.561392f, -0.410083f, 0.703632f, 0.580288f, 
		-0.0443442f, 0.897658f, 0.438456f, -0.138229f, 0.855894f, 0.498336f, 
		-0.360091f, 0.857510f, -0.367438f, -0.480559f, 0.484055f, 0.731269f, 
		-0.480559f, 0.484055f, 0.731269f, -0.335910f, -0.303395f, -0.891693f, 
		-0.754849f, -0.481984f, 0.444855f, -0.754849f, -0.481984f, 0.444855f, 
		0.984322f, -0.160121f, -0.0739744f, -0.991539f, 0.102886f, 0.0791508f, 
		-0.314653f, -0.668370f, 0.673999f, -0.314653f, -0.668370f, 0.673999f, 
		-0.750301f, 0.523267f, -0.404030f, -0.750301f, 0.523267f, -0.404030f, 
		-0.659165f, 0.107845f, 0.744226f, -0.396920f, 0.446718f, 0.801809f, 
		-0.509551f, 0.348919f, 0.786520f, -0.396920f, 0.446718f, 0.801809f, 
		-0.962978f, -0.197600f, -0.183379f, -0.301401f, 0.841638f, -0.448111f, 
		-0.996688f, -0.0270288f, 0.0766982f, -0.967357f, 0.240970f, 0.0784397f, 
		-0.904482f, 0.419561f, 0.0766847f, -0.271143f, -0.910735f, 0.311519f, 
		-0.271143f, -0.910735f, 0.311519f, -0.760175f, 0.520667f, -0.388639f, 
		-0.435017f, -0.322712f, 0.840605f, 0.396293f, -0.614392f, 0.682257f, 
		-0.132549f, -0.450448f, 0.882908f, 0.0425943f, -0.558517f, 0.828399f, 
		-0.132549f, -0.450448f, 0.882908f, 0.0888614f, 0.520063f, -0.849493f, 
		0.128036f, 0.401936f, -0.906672f, -0.0465573f, 0.682204f, -0.729679f, 
		0.00490094f, 0.591550f, -0.806253f, -0.0991120f, 0.795015f, -0.598439f, 
		-0.0378240f, 0.995028f, 0.0921343f, -0.553304f, 0.472555f, 0.685964f, 
		0.257518f, -0.966272f, 0.00171390f, -0.276318f, -0.365631f, -0.888798f, 
		-0.119131f, 0.197547f, 0.973028f, -0.119131f, 0.197547f, 0.973028f, 
		-0.395036f, -0.00111385f, -0.918665f, 0.470882f, 0.265673f, 0.841242f, 
		-0.948435f, 0.306711f, -0.0799978f, -0.395036f, -0.00111385f, -0.918665f, 
		-0.396589f, -0.193781f, -0.897310f, -0.0834309f, -0.767913f, -0.635097f, 
		-0.502412f, -0.845229f, -0.182126f, -0.162129f, -0.806428f, -0.568673f, 
		-0.288143f, -0.831193f, -0.475491f, -0.325187f, -0.841619f, -0.431198f, 
		-0.429637f, -0.381442f, -0.818483f, -0.450207f, -0.0421728f, 0.891928f, 
		-0.419766f, -0.262766f, 0.868764f, -0.681894f, 0.228550f, 0.694827f, 
		-0.824743f, 0.535195f, 0.182662f, -0.855327f, 0.514992f, -0.0565563f, 
		-0.335274f, -0.377236f, -0.863299f, -0.0370252f, -0.526245f, -0.849526f, 
		-0.138127f, -0.476535f, -0.868237f, -0.285095f, 0.920578f, 0.266940f, 
		-0.909654f, 0.291526f, 0.295875f, -0.658547f, 0.718322f, 0.224341f, 
		-0.848352f, 0.501272f, 0.170367f, -0.120172f, 0.891221f, 0.437360f, 
		-0.948578f, 0.308184f, 0.0722636f, 0.993199f, -0.0930671f, -0.0699627f, 
		0.643086f, 0.684049f, 0.344263f, 0.978977f, 0.0373541f, -0.200519f, 
		0.909253f, 0.103660f, -0.403130f, 0.180101f, -0.739118f, 0.649052f, 
		-0.337949f, -0.882292f, 0.327646f, -0.458223f, -0.868238f, 0.190250f, 
		-0.0735568f, -0.861159f, 0.502985f, -0.643104f, 0.306089f, 0.701945f, 
		-0.597776f, 0.378773f, 0.706537f, -0.643104f, 0.306089f, 0.701945f, 
		-0.693963f, 0.229015f, 0.682619f, -0.283765f, -0.934528f, 0.214788f, 
		-0.382269f, -0.679310f, -0.626425f, -0.766860f, 0.554831f, -0.322628f, 
		-0.766860f, 0.554831f, -0.322628f, -0.299476f, -0.284445f, -0.910717f, 
		-0.299476f, -0.284445f, -0.910717f, 0.460333f, -0.273141f, 0.844682f, 
		0.528096f, 0.575479f, 0.624451f, -0.262903f, 0.959786f, -0.0984471f, 
		-0.262903f, 0.959786f, -0.0984471f, -0.680045f, -0.726664f, 0.0974621f, 
		0.824094f, 0.276528f, -0.494370f, 0.766609f, 0.510125f, -0.389979f, 
		0.725560f, 0.600394f, -0.336289f, 0.643086f, 0.684049f, 0.344263f, 
		0.985397f, -0.0767370f, -0.152000f, 0.393359f, 0.367442f, -0.842767f, 
		-0.931507f, -0.363238f, 0.0187919f, -0.931680f, -0.335508f, 0.139310f, 
		-0.971259f, -0.229449f, 0.0633214f, -0.947194f, -0.233677f, 0.219590f, 
		-0.989961f, -0.0401495f, -0.135515f, -0.926286f, -0.349353f, -0.141234f, 
		-0.794143f, -0.567356f, -0.217819f, -0.344210f, -0.938142f, -0.0375421f, 
		-0.549996f, -0.810546f, -0.201296f, 0.582891f, -0.109873f, -0.805087f, 
		-0.216232f, 0.517934f, -0.827640f, -0.211884f, 0.435690f, -0.874802f, 
		-0.178289f, -0.609207f, -0.772709f, -0.809391f, 0.548840f, 0.208953f, 
		-0.809391f, 0.548840f, 0.208953f, 0.179211f, 0.185687f, -0.966128f, 
		-0.0563603f, -0.694071f, -0.717697f, -0.546560f, 0.483284f, 0.683893f, 
		-0.664677f, 0.468527f, 0.581968f, -0.526355f, 0.850029f, 0.0200420f, 
		-0.627525f, 0.776271f, 0.0601337f, -0.677752f, 0.689831f, 0.254531f, 
		-0.621884f, 0.719132f, 0.310016f, -0.621260f, 0.278528f, -0.732433f, 
		0.110312f, 0.923916f, -0.366348f, 0.288504f, -0.742301f, -0.604776f, 
		0.840637f, -0.148371f, -0.520880f, -0.985003f, -0.154600f, -0.0766069f, 
		-0.672840f, 0.708133f, -0.214090f, -0.743634f, 0.547496f, -0.383740f, 
		-0.706411f, 0.702062f, -0.0899587f, -0.671710f, 0.701116f, 0.239253f, 
		-0.706411f, 0.702062f, -0.0899587f, -0.495520f, 0.678343f, 0.542504f, 
		-0.956919f, 0.264356f, 0.120092f, -0.0536819f, -0.958699f, -0.279311f, 
		-0.878858f, 0.475659f, 0.0368412f, -0.799987f, 0.599145f, 0.0323427f, 
		-0.736627f, -0.623147f, -0.262808f, -0.577103f, -0.760518f, -0.297598f, 
		-0.952432f, -0.292899f, -0.0841692f, -0.568082f, 0.219054f, -0.793283f, 
		-0.906488f, -0.258436f, 0.333901f, -0.249328f, -0.941640f, 0.226164f, 
		-0.278909f, -0.856184f, 0.434924f, 0.273947f, -0.925520f, -0.261470f, 
		-0.298537f, -0.573717f, -0.762708f, -0.0702501f, -0.824088f, -0.562089f, 
		-0.407544f, -0.503847f, -0.761608f, -0.407544f, -0.503847f, -0.761608f, 
		-0.201436f, -0.303775f, -0.931206f, -0.953080f, 0.288564f, 0.0914880f, 
		-0.838160f, 0.538042f, 0.0894294f, -0.892842f, 0.442320f, 0.0847752f, 
		-0.794718f, 0.437008f, 0.421245f, -0.0513994f, 0.0955358f, 0.994098f, 
		-0.990637f, 0.122681f, 0.0598975f, -0.711484f, 0.700868f, -0.0507423f, 
		-0.529644f, 0.829790f, -0.175854f, -0.620623f, 0.265037f, -0.737959f, 
		-0.919869f, 0.392223f, 0.00121517f, 0.911564f, 0.406923f, -0.0588695f, 
		0.841480f, 0.100906f, -0.530782f, 0.905991f, 0.263372f, -0.331385f, 
		0.841194f, 0.241163f, -0.483976f, 0.601923f, 0.780984f, -0.166595f, 
		0.839041f, 0.509794f, -0.190051f, 0.285447f, -0.479933f, -0.829569f, 
		0.104490f, -0.494084f, -0.863112f, 0.184502f, -0.491053f, -0.851367f, 
		-0.941208f, -0.333171f, 0.0558982f, -0.981012f, -0.0627451f, 0.183516f, 
		-0.974568f, 0.0177009f, 0.223391f, -0.352972f, 0.904597f, -0.238987f, 
		-0.352972f, 0.904597f, -0.238987f, -0.352972f, 0.904597f, -0.238987f, 
		-0.352972f, 0.904597f, -0.238987f, -0.0993935f, -0.596085f, -0.796746f, 
		0.153166f, -0.633617f, -0.758333f, -0.00133784f, -0.640100f, -0.768291f, 
		-0.963684f, -0.246137f, 0.103582f, -0.637599f, 0.761264f, 0.118084f, 
		-0.637599f, 0.761264f, 0.118084f, -0.0220141f, -0.691097f, -0.722426f, 
		-0.607320f, -0.781498f, -0.142910f, -0.332341f, -0.0742911f, -0.940229f, 
		-0.317584f, 0.868917f, -0.379635f, -0.317584f, 0.868917f, -0.379635f, 
		-0.332341f, -0.0742911f, -0.940229f, -0.378614f, 0.596345f, 0.707830f, 
		-0.457128f, -0.0473121f, -0.888142f, -0.802011f, -0.545427f, -0.243492f, 
		-0.0712852f, -0.218547f, 0.973219f, -0.882503f, -0.402066f, -0.243991f, 
		-0.0449624f, 0.0244054f, -0.998691f, -0.922120f, -0.266942f, -0.280065f, 
		0.916698f, -0.242588f, 0.317516f, -0.982939f, 0.0172833f, -0.183120f, 
		-0.849257f, 0.502771f, -0.161194f, -0.944586f, 0.284044f, -0.164549f, 
		-0.683263f, 0.716873f, -0.138723f, -0.946479f, -0.184363f, 0.264930f, 
		-0.975512f, -0.122156f, 0.182903f, -0.826633f, -0.301161f, 0.475373f, 
		-0.997703f, 0.0292206f, -0.0611108f, -0.887756f, -0.278754f, 0.366313f, 
		-0.641128f, -0.414350f, -0.645964f, -0.552180f, -0.830228f, -0.0762875f, 
		-0.621610f, -0.743955f, -0.245220f, -0.619967f, -0.286304f, -0.730528f, 
		-0.819601f, -0.524732f, -0.230022f, -0.578009f, -0.793990f, 0.188376f, 
		-0.655746f, -0.710363f, 0.255699f, -0.823001f, -0.567795f, -0.0166481f, 
		-0.695801f, -0.714001f, -0.0778722f, -0.360189f, -0.501006f, 0.786928f, 
		-0.886747f, 0.344760f, 0.307931f, -0.906333f, 0.0228636f, 0.421945f, 
		-0.697582f, 0.695482f, 0.172289f, -0.793011f, 0.585828f, 0.167149f, 
		-0.295463f, 0.130781f, -0.946360f, -0.295463f, 0.130781f, -0.946360f, 
		-0.295463f, 0.130781f, -0.946360f, -0.274335f, 0.365569f, 0.889438f, 
		-0.948435f, 0.306711f, -0.0799978f, -0.295463f, 0.130781f, -0.946360f, 
		-0.949770f, -0.195656f, -0.244244f, -0.199778f, -0.562833f, -0.802065f, 
		-0.365613f, -0.255490f, -0.895015f, -0.365613f, -0.255490f, -0.895015f, 
		-0.365613f, -0.255490f, -0.895015f, -0.821374f, 0.498323f, -0.277521f, 
		-0.529405f, 0.438210f, 0.726431f, -0.529405f, 0.438210f, 0.726431f, 
		-0.255280f, -0.906293f, -0.336845f, 0.456027f, -0.653214f, 0.604443f, 
		0.493947f, -0.134821f, -0.858976f, -0.976053f, 0.215834f, -0.0271436f, 
		-0.976053f, 0.215834f, -0.0271436f, 0.877637f, 0.100203f, -0.468736f, 
		-0.363555f, -0.828139f, 0.426630f, -0.363555f, -0.828139f, 0.426630f, 
		-0.955277f, -0.215149f, 0.202873f, -0.968397f, 0.0735991f, 0.238308f, 
		-0.827756f, 0.463692f, 0.315927f, -0.720586f, 0.636773f, 0.274365f, 
		-0.623880f, 0.722222f, 0.298611f, 0.517499f, 0.654978f, 0.550635f, 
		0.517499f, 0.654978f, 0.550635f, 0.864990f, -0.279417f, 0.416795f, 
		-0.412599f, 0.156292f, -0.897404f, 0.139094f, -0.785469f, 0.603069f, 
		-0.167865f, -0.894960f, 0.413363f, -0.246131f, -0.897774f, 0.365270f, 
		-0.167865f, -0.894960f, 0.413363f, -0.908442f, -0.319752f, -0.269242f, 
		-0.988824f, -0.0114200f, 0.148651f, -0.445308f, 0.872683f, -0.200312f, 
		-0.445308f, 0.872683f, -0.200312f, -0.683854f, -0.728776f, -0.0350678f, 
		-0.706841f, 0.566746f, 0.423290f, -0.854149f, 0.448663f, -0.262929f, 
		-0.769816f, 0.586662f, -0.251417f, 0.968751f, -0.0985128f, 0.227634f, 
		-0.691709f, 0.665594f, -0.280220f, 0.361271f, 0.587127f, 0.724406f, 
		0.288504f, -0.742301f, -0.604776f, 0.666269f, 0.118282f, -0.736271f, 
		-0.760575f, 0.594786f, -0.260300f, -0.752987f, -0.422564f, 0.504431f, 
		-0.527448f, 0.845921f, -0.0788480f, -0.346340f, 0.938068f, 0.00883081f, 
		-0.0687161f, 0.436793f, -0.896934f, -0.961887f, -0.163921f, -0.218867f, 
		-0.262614f, 0.748397f, -0.609045f, -0.262614f, 0.748397f, -0.609045f, 
		-0.229663f, 0.617883f, -0.751981f, 0.323050f, -0.558632f, 0.763917f, 
		-0.270278f, 0.107312f, 0.956783f, -0.586900f, -0.643231f, -0.491734f, 
		-0.293268f, 0.950977f, -0.0981621f, -0.937722f, 0.105452f, -0.330994f, 
		-0.937722f, 0.105452f, -0.330994f, -0.217736f, 0.749598f, -0.625055f, 
		-0.327972f, 0.865509f, -0.378588f, -0.246381f, -0.0118055f, -0.969101f, 
		-0.805013f, -0.461144f, 0.373228f, -0.713694f, 0.0345497f, 0.699605f, 
		-0.805517f, -0.231287f, 0.545572f, 0.415512f, -0.125849f, 0.900840f, 
		0.445380f, 0.491922f, 0.748098f, 0.377382f, 0.389967f, 0.839946f, 
		0.323252f, -0.00748577f, 0.946283f, -0.848598f, -0.282117f, 0.447539f, 
		-0.293837f, -0.950505f, 0.100997f, -0.641074f, -0.657354f, 0.396119f, 
		-0.638442f, -0.502890f, 0.582660f, -0.631286f, -0.734445f, 0.249134f, 
		-0.966673f, -0.159816f, -0.200007f, -0.989378f, -0.00513757f, -0.145272f, 
		-0.970362f, 0.104844f, -0.217727f, -0.946613f, 0.167784f, -0.275267f, 
		-0.418430f, -0.496479f, -0.760543f, -0.184894f, -0.845848f, 0.500356f, 
		-0.0390101f, 0.944738f, -0.325496f, 0.0902284f, 0.843041f, -0.530227f, 
		0.0501356f, 0.680976f, -0.730587f, 0.942099f, 0.294069f, 0.161162f, 
		-0.222211f, 0.795988f, -0.563050f, 0.715774f, 0.0372201f, -0.697339f, 
		0.887606f, 0.0369104f, -0.459123f, 0.497615f, -0.0891378f, -0.862806f, 
		-0.358327f, -0.873579f, -0.329334f, -0.912011f, 0.283816f, 0.296117f, 
		-0.915073f, 0.321797f, 0.243080f, -0.912011f, 0.283816f, 0.296117f, 
		-0.928140f, 0.179363f, 0.326166f, -0.402360f, -0.240521f, -0.883321f, 
		0.382939f, 0.813840f, 0.437060f, -0.232352f, 0.252549f, -0.939272f, 
		-0.958516f, -0.175036f, -0.224964f, 0.0215105f, 0.997779f, 0.0630424f, 
		-0.871906f, -0.0564831f, 0.486405f, 0.462982f, 0.750181f, 0.472098f, 
		0.487594f, -0.381185f, -0.785462f, 0.865008f, -0.232585f, -0.444595f, 
		-0.901314f, 0.185201f, 0.391578f, -0.862187f, 0.290584f, 0.414963f, 
		-0.833185f, 0.447150f, 0.325361f, -0.779785f, 0.541854f, 0.313576f, 
		-0.868278f, 0.366648f, 0.334160f, 0.816414f, 0.0560786f, -0.574738f, 
		0.605515f, 0.462508f, -0.647640f, 0.802912f, -0.272989f, -0.529913f, 
		0.836463f, -0.162475f, -0.523385f, -0.852325f, -0.208867f, 0.479495f, 
		-0.869091f, -0.493973f, -0.0259249f, -0.709921f, -0.653359f, 0.262935f, 
		-0.886476f, -0.385267f, -0.256379f, -0.243268f, 0.862277f, -0.444184f, 
		-0.678011f, -0.461071f, -0.572464f, -0.677974f, -0.728658f, -0.0970004f, 
		-0.661152f, -0.311719f, -0.682428f, -0.643507f, -0.762492f, 0.0671092f, 
		0.378979f, 0.269788f, -0.885206f, 0.267640f, 0.364685f, -0.891837f, 
		0.102184f, 0.659341f, -0.744867f, 0.158198f, 0.474887f, -0.865711f, 
		0.550219f, -0.0170487f, -0.834846f, -0.822474f, 0.445130f, 0.354113f, 
		0.929062f, -0.0793207f, -0.361319f, 0.279308f, 0.556032f, -0.782825f, 
		-0.943271f, -0.234799f, 0.234754f, -0.705228f, -0.0915604f, -0.703043f, 
		-0.733300f, -0.147306f, -0.663756f, -0.761818f, -0.228015f, -0.606336f, 
		-0.815108f, -0.443238f, -0.373013f, 0.359833f, 0.731640f, 0.578985f, 
		0.285570f, -0.286169f, -0.914635f, 0.285570f, -0.286169f, -0.914635f, 
		0.159972f, -0.201665f, -0.966302f, -0.393842f, 0.218764f, -0.892766f, 
		-0.343008f, -0.0264975f, -0.938959f, -0.0576683f, -0.983130f, -0.173580f, 
		-0.418238f, 0.889777f, -0.182689f, -0.0576683f, -0.983130f, -0.173580f, 
		-0.939311f, 0.315794f, -0.134048f, -0.644956f, 0.737109f, -0.201749f, 
		-0.418238f, 0.889777f, -0.182689f, 0.895627f, 0.293112f, 0.334572f, 
		-0.260022f, 0.454745f, 0.851819f, -0.141274f, 0.584014f, 0.799356f, 
		0.400056f, 0.904008f, 0.150746f, 0.226252f, 0.825206f, 0.517537f, 
		-0.330330f, 0.931730f, 0.150871f, -0.369496f, 0.591536f, -0.716630f, 
		-0.369496f, 0.591536f, -0.716630f, 0.458853f, 0.464392f, -0.757492f, 
		0.647954f, 0.345062f, -0.679035f, 0.285590f, 0.547790f, -0.786362f, 
		0.520090f, 0.850339f, -0.0801921f, -0.626726f, -0.294898f, -0.721283f, 
		-0.153240f, -0.125484f, 0.980189f, -0.0249263f, -0.447308f, -0.894032f, 
		-0.146707f, -0.640605f, -0.753726f, 0.529869f, -0.145045f, -0.835584f, 
		0.612984f, -0.000584253f, -0.790095f, -0.194161f, -0.798407f, 0.569954f, 
		0.764661f, 0.473297f, -0.437360f, -0.194161f, -0.798407f, 0.569954f, 
		0.150977f, 0.987111f, -0.0530804f, 0.0399213f, 0.588239f, 0.807701f, 
		0.886332f, 0.310592f, 0.343436f, -0.211355f, 0.440677f, 0.872429f, 
		-0.141145f, -0.663283f, -0.734938f, -0.563561f, -0.725414f, -0.395188f, 
		-0.357718f, -0.708856f, -0.607915f, -0.455275f, -0.742478f, -0.491377f, 
		-0.0246031f, -0.543762f, -0.838879f, -0.808949f, 0.160619f, -0.565512f, 
		-0.703338f, 0.338953f, -0.624841f, -0.753729f, 0.267095f, -0.600460f, 
		-0.564248f, -0.397828f, 0.723434f, -0.411317f, -0.644744f, 0.644301f, 
		-0.218706f, -0.909220f, 0.354242f, -0.255960f, -0.794629f, 0.550499f, 
		-0.699770f, 0.441988f, 0.561221f, -0.778312f, 0.151636f, 0.609292f, 
		-0.739726f, 0.297703f, 0.603472f, -0.855060f, 0.215686f, -0.471542f, 
		-0.307691f, 0.685068f, -0.660308f, -0.562802f, 0.589319f, -0.579618f, 
		-0.462834f, 0.638024f, -0.615394f, -0.685844f, 0.382458f, -0.619148f, 
		-0.774828f, 0.335628f, -0.535719f, -0.353373f, 0.330085f, -0.875312f, 
		-0.826523f, -0.365284f, -0.428284f, -0.553290f, -0.242774f, 0.796826f, 
		-0.956150f, -0.289683f, 0.0431510f, -0.227038f, -0.240226f, 0.943793f, 
		0.442179f, -0.334333f, 0.832285f, 0.528016f, 0.592299f, 0.608590f, 
		-0.669581f, 0.0142496f, 0.742602f, -0.747905f, 0.0826851f, 0.658636f, 
		-0.713752f, 0.0451302f, 0.698943f, -0.722058f, -0.207715f, -0.659914f, 
		-0.820456f, -0.480241f, 0.310193f, -0.813294f, -0.343186f, 0.469868f, 
		-0.522439f, 0.225450f, 0.822332f, -0.634678f, 0.137105f, 0.760517f, 
		-0.474849f, -0.565431f, -0.674394f, 0.214161f, 0.288252f, 0.933299f, 
		-0.474849f, -0.565431f, -0.674394f, -0.474849f, -0.565431f, -0.674394f, 
		-0.341478f, -0.467167f, -0.815566f, -0.287687f, 0.671489f, -0.682890f, 
		-0.0755389f, -0.539795f, 0.838400f, 0.788125f, 0.0536176f, 0.613176f, 
		0.978400f, -0.128614f, -0.161842f, 0.698538f, -0.163041f, 0.696751f, 
		0.784534f, 0.205874f, 0.584912f, 0.148663f, 0.965339f, -0.214524f, 
		0.0946936f, 0.994938f, -0.0336450f, 0.155880f, 0.937277f, -0.311789f, 
		-0.336582f, -0.819839f, 0.463224f, -0.162755f, -0.699914f, 0.695436f, 
		-0.699351f, 0.468965f, -0.539426f, -0.821594f, 0.141879f, 0.552135f, 
		-0.699351f, 0.468965f, -0.539426f, 0.0508313f, -0.523806f, 0.850319f, 
		-0.696962f, 0.101094f, 0.709947f, -0.549973f, 0.341020f, 0.762388f, 
		-0.241780f, 0.954780f, 0.173025f, -0.838708f, 0.246826f, 0.485434f, 
		-0.714229f, 0.575018f, 0.399039f, -0.422189f, 0.789512f, 0.445451f, 
		-0.632747f, 0.614154f, -0.471641f, -0.0576683f, -0.983130f, -0.173580f, 
		-0.467018f, 0.806482f, -0.362604f, -0.622324f, 0.459148f, -0.633952f, 
		-0.307935f, 0.901578f, -0.303864f, -0.0576683f, -0.983130f, -0.173580f, 
		-0.132390f, -0.106183f, -0.985494f, 0.0885115f, -0.490940f, -0.866686f, 
		-0.0737865f, -0.221785f, -0.972300f, -0.132390f, -0.106183f, -0.985494f, 
		-0.591865f, -0.636444f, -0.494606f, 0.249727f, -0.465851f, -0.848893f, 
		0.000637852f, -0.414705f, -0.909956f, -0.232177f, -0.313179f, -0.920876f, 
		-0.0736695f, -0.402393f, -0.912498f, 0.416317f, -0.0680831f, 0.906667f, 
		-0.137509f, -0.323201f, -0.936286f, -0.135187f, 0.989156f, 0.0574071f, 
		-0.135187f, 0.989156f, 0.0574071f, -0.746067f, -0.646980f, -0.157483f, 
		-0.854312f, -0.510519f, 0.0975744f, -0.697526f, -0.637571f, -0.327048f, 
		-0.845184f, -0.534476f, 0.000191718f, -0.897232f, -0.413610f, 0.154601f, 
		-0.651017f, -0.202503f, -0.731553f, 0.266158f, 0.750977f, 0.604312f, 
		-0.540036f, -0.0546501f, -0.839866f, -0.345914f, 0.127223f, -0.929601f, 
		0.266158f, 0.750977f, 0.604312f, -0.292243f, -0.375449f, -0.879564f, 
		0.513248f, -0.447386f, 0.732408f, 0.513248f, -0.447386f, 0.732408f, 
		-0.494599f, 0.732895f, -0.467157f, -0.349523f, 0.804963f, -0.479446f, 
		-0.419854f, 0.770940f, -0.478931f, -0.419854f, 0.770940f, -0.478931f, 
		-0.259501f, -0.317518f, -0.912053f, 0.0437532f, -0.284192f, 0.957768f, 
		0.147413f, -0.300006f, 0.942479f, 0.0946690f, -0.297289f, 0.950083f, 
		-0.315498f, -0.164933f, -0.934483f, -0.778588f, -0.324667f, -0.537021f, 
		0.0501356f, 0.680976f, -0.730587f, 0.115717f, 0.483898f, -0.867440f, 
		-0.683508f, -0.409954f, -0.603949f, -0.621394f, -0.573429f, -0.533899f, 
		0.276624f, 0.266362f, -0.923326f, -0.375124f, -0.774909f, -0.508721f, 
		0.664830f, -0.329621f, 0.670336f, 0.383339f, -0.217837f, -0.897551f, 
		0.564953f, 0.590163f, 0.576660f, 0.383339f, -0.217837f, -0.897551f, 
		0.344638f, -0.609950f, 0.713572f, 0.344638f, -0.609950f, 0.713572f, 
		0.212840f, 0.161102f, -0.963714f, 0.212840f, 0.161102f, -0.963714f, 
		0.637412f, 0.681049f, -0.360387f, 0.637412f, 0.681049f, -0.360387f, 
		0.344596f, -0.275621f, -0.897378f, -0.918692f, -0.259558f, 0.297717f, 
		0.0917042f, 0.957170f, -0.274620f, 0.0304259f, 0.986289f, -0.162200f, 
		0.0983354f, 0.991794f, -0.0817013f, 0.0304259f, 0.986289f, -0.162200f, 
		-0.780901f, -0.0992636f, -0.616718f, 0.0179965f, 0.936188f, -0.351040f, 
		0.00322741f, 0.845635f, -0.533752f, -0.0703287f, 0.532350f, 0.843598f, 
		0.474497f, 0.284371f, -0.833058f, 0.854807f, -0.0329849f, -0.517897f, 
		0.644796f, -0.0907504f, 0.758948f, 0.908354f, -0.261656f, -0.326234f, 
		0.214666f, 0.345316f, -0.913606f, 0.908354f, -0.261656f, -0.326234f, 
		0.895202f, -0.350648f, -0.275064f, -0.311327f, -0.755946f, 0.575866f, 
		-0.167784f, -0.724052f, 0.669026f, 0.0233117f, -0.654813f, 0.755431f, 
		-0.109716f, -0.652416f, 0.749877f, -0.266721f, -0.696562f, 0.666079f, 
		-0.167784f, -0.724052f, 0.669026f, -0.449560f, 0.758654f, -0.471530f, 
		-0.449560f, 0.758654f, -0.471530f, -0.449560f, 0.758654f, -0.471530f, 
		-0.0457473f, 0.686106f, 0.726062f, 0.563401f, 0.685754f, 0.460783f, 
		0.563401f, 0.685754f, 0.460783f, 0.563401f, 0.685754f, 0.460783f, 
		-0.909184f, -0.283382f, -0.305089f, -0.257279f, 0.646173f, 0.718518f, 
		-0.257279f, 0.646173f, 0.718518f, 0.867153f, 0.101912f, -0.487503f, 
		0.520090f, 0.850339f, -0.0801921f, 0.0741832f, -0.665130f, 0.743033f, 
		0.698538f, -0.163041f, 0.696751f, 0.153388f, 0.986650f, -0.0547130f, 
		-0.895215f, 0.441204f, 0.0626827f, -0.331198f, 0.375977f, 0.865419f, 
		-0.331198f, 0.375977f, 0.865419f, -0.115092f, -0.975170f, -0.189199f, 
		-0.148694f, -0.774046f, 0.615421f, 0.599630f, 0.733007f, -0.321162f, 
		0.361271f, 0.587127f, 0.724406f, -0.310251f, 0.912759f, -0.265736f, 
		0.344997f, -0.451378f, 0.822943f, 0.344997f, -0.451378f, 0.822943f, 
		-0.186319f, 0.922812f, 0.337198f, -0.582783f, -0.276635f, -0.764093f, 
		-0.318345f, 0.370158f, -0.872720f, -0.530088f, -0.328115f, -0.781887f, 
		0.589119f, -0.529038f, -0.610785f, 0.214161f, 0.288252f, 0.933299f, 
		-0.718263f, 0.152913f, -0.678761f, 0.150977f, 0.987111f, -0.0530804f, 
		-0.881263f, 0.471950f, 0.0252562f, 0.316693f, 0.487332f, -0.813765f, 
		-0.521670f, -0.830123f, 0.196868f, 0.493891f, 0.241627f, -0.835277f, 
		-0.783540f, 0.372043f, -0.497643f, -0.208396f, 0.522452f, -0.826810f, 
		-0.441740f, -0.276469f, -0.853482f, -0.310914f, -0.0930357f, -0.945874f, 
		-0.407656f, -0.349013f, -0.843805f, -0.481470f, -0.412915f, -0.773103f, 
		-0.425764f, -0.509519f, -0.747740f, -0.200994f, -0.329435f, 0.922537f, 
		-0.375980f, 0.307658f, -0.874063f, -0.271568f, 0.304224f, -0.913071f, 
		-0.223794f, 0.432396f, -0.873470f, -0.365459f, 0.429605f, -0.825759f, 
		-0.303917f, 0.368475f, -0.878556f, -0.329172f, 0.211683f, 0.920237f, 
		-0.186811f, 0.541723f, 0.819535f, -0.288514f, 0.333916f, 0.897363f, 
		-0.443918f, 0.233741f, 0.865044f, -0.376655f, 0.374883f, 0.847109f, 
		-0.132949f, 0.127285f, 0.982916f, -0.0835689f, -0.884095f, 0.459775f, 
		-0.717168f, -0.670039f, -0.191616f, -0.475746f, -0.360286f, 0.802409f, 
		-0.475746f, -0.360286f, 0.802409f, -0.939892f, -0.339380f, -0.0377354f, 
		-0.312424f, 0.860132f, 0.403192f, -0.733569f, -0.146155f, 0.663713f, 
		-0.261420f, 0.916397f, 0.303112f, -0.261420f, 0.916397f, 0.303112f, 
		-0.159128f, 0.954936f, 0.250552f, -0.880903f, -0.252252f, 0.400473f, 
		-0.531041f, -0.204010f, 0.822421f, -0.755528f, -0.251603f, 0.604874f, 
		-0.865582f, -0.311557f, -0.392046f, -0.558520f, -0.122840f, -0.820345f, 
		-0.796566f, -0.266830f, -0.542480f, -0.301736f, 0.0748220f, -0.950451f, 
		0.442681f, -0.444756f, -0.778605f, 0.442681f, -0.444756f, -0.778605f, 
		-0.430922f, 0.770078f, 0.470410f, -0.535803f, 0.781493f, 0.319661f, 
		-0.468426f, 0.802964f, 0.368546f, -0.468426f, 0.802964f, 0.368546f, 
		0.0117549f, 0.934779f, 0.355035f, 0.148299f, -0.450241f, 0.880506f, 
		0.917261f, -0.396441f, 0.0382943f, 0.607320f, -0.583590f, 0.539059f, 
		-0.0342162f, 0.0861021f, -0.995699f, 0.853290f, -0.499436f, 0.149870f, 
		0.791497f, -0.521244f, 0.319121f, 0.255714f, -0.538938f, 0.802594f, 
		0.394909f, -0.552352f, 0.734135f, -0.820645f, -0.519184f, -0.238726f, 
		-0.820645f, -0.519184f, -0.238726f, -0.136091f, -0.269054f, 0.953462f, 
		-0.969246f, -0.0349682f, 0.243598f, -0.969246f, -0.0349682f, 0.243598f, 
		-0.501102f, 0.240902f, 0.831182f, -0.622965f, -0.780671f, -0.0496766f, 
		-0.484739f, -0.855369f, 0.182681f, 6.31319e-005f, 0.828710f, 0.559678f, 
		-0.264825f, -0.905902f, 0.330468f, 6.31319e-005f, 0.828710f, 0.559678f, 
		-0.0256090f, 0.609423f, -0.792432f, 0.185306f, 0.488963f, -0.852395f, 
		0.355038f, 0.461377f, -0.813068f, -0.184396f, 0.0133942f, 0.982761f, 
		-0.260910f, 0.0961882f, 0.960559f, -0.342333f, 0.126296f, 0.931052f, 
		0.734920f, 0.592063f, -0.330686f, 0.734920f, 0.592063f, -0.330686f, 
		-0.282326f, -0.953207f, 0.108113f, 0.0707206f, 0.666593f, -0.742059f, 
		0.184160f, 0.533889f, -0.825256f, 0.116814f, 0.609488f, -0.784142f, 
		-0.458305f, -0.330976f, -0.824870f, -0.340902f, 0.438491f, -0.831572f, 
		0.530444f, -0.436878f, 0.726475f, 0.106868f, -0.584024f, 0.804671f, 
		0.329398f, -0.567333f, 0.754738f, -0.821594f, 0.141879f, 0.552135f, 
		0.354637f, 0.584741f, 0.729596f, 0.354637f, 0.584741f, 0.729596f, 
		0.323624f, 0.484793f, 0.812554f, 0.224397f, 0.0627989f, 0.972472f, 
		0.354637f, 0.584741f, 0.729596f, -0.296822f, 0.101632f, -0.949509f, 
		0.177644f, 0.592734f, -0.785563f, 0.268622f, -0.461104f, -0.845710f, 
		0.268622f, -0.461104f, -0.845710f, -0.368065f, -0.650984f, -0.663888f, 
		-0.451251f, 0.653151f, 0.608084f, -0.451251f, 0.653151f, 0.608084f, 
		0.0762714f, 0.627649f, -0.774751f, 0.465843f, 0.769770f, 0.436398f, 
		0.284595f, 0.887350f, 0.362787f, 0.404668f, 0.835549f, 0.371620f, 
		0.596683f, 0.627737f, 0.499916f, 0.674420f, 0.475376f, 0.564957f, 
		-0.224093f, 0.421099f, -0.878896f, -0.0845029f, -0.665872f, 0.741265f, 
		-0.759276f, -0.226237f, -0.610178f, -0.964472f, 0.222018f, 0.143184f, 
		-0.895215f, 0.441204f, 0.0626827f, -0.759276f, -0.226237f, -0.610178f, 
		-0.976173f, 0.0813829f, 0.201155f, 0.207476f, 0.906893f, -0.366741f, 
		0.0745687f, 0.951638f, -0.298034f, 0.288504f, -0.742301f, -0.604776f, 
		0.0147012f, 0.980909f, -0.193909f, 0.178929f, 0.970152f, -0.163672f, 
		0.333484f, 0.917537f, 0.216596f, -0.124252f, 0.848219f, 0.514866f, 
		-0.0797401f, -0.444207f, 0.892369f, -0.336582f, -0.819839f, 0.463224f, 
		0.721411f, 0.0698702f, -0.688973f, 0.750750f, -0.429576f, 0.501835f, 
		-0.336582f, -0.819839f, 0.463224f, -0.369255f, 0.516586f, 0.772521f, 
		0.481649f, 0.876158f, -0.0189970f, -0.270542f, 0.669507f, 0.691785f, 
		-0.442244f, 0.119393f, 0.888913f, -0.270542f, 0.669507f, 0.691785f, 
		0.523663f, 0.321351f, 0.788993f, 0.335180f, 0.931567f, 0.140848f, 
		0.178668f, 0.969070f, -0.170239f, -0.154757f, 0.742828f, -0.651350f, 
		-0.0583111f, 0.823217f, -0.564724f, -0.842945f, -0.195269f, -0.501312f, 
		-0.792313f, -0.180375f, -0.582842f, -0.553680f, -0.0729963f, -0.829524f, 
		-0.118366f, 0.396850f, -0.910220f, 0.172651f, -0.447131f, -0.877648f, 
		0.342442f, 0.140066f, -0.929040f, 0.370993f, -0.0632357f, -0.926480f, 
		0.0980656f, -0.609472f, -0.786719f, 0.0741832f, -0.665130f, 0.743033f, 
		0.743909f, -0.233378f, 0.626206f, 0.816162f, 0.474129f, 0.330275f, 
		0.0437226f, 0.154911f, 0.986960f, -0.164476f, -0.444739f, 0.880429f, 
		0.0334057f, 0.128998f, -0.991082f, -0.530374f, -0.846435f, -0.0474489f, 
		-0.164476f, -0.444739f, 0.880429f, -0.772056f, -0.177883f, -0.610154f, 
		-0.525180f, 0.122188f, -0.842174f, -0.370166f, 0.215933f, -0.903521f, 
		-0.842837f, -0.280500f, -0.459288f, 0.348847f, 0.830558f, 0.434142f, 
		0.207772f, 0.921836f, 0.327184f, 0.0932737f, 0.991271f, 0.0931799f, 
		0.464798f, 0.779099f, 0.420676f, 0.308188f, 0.895121f, 0.322148f, 
		-0.431485f, -0.367066f, -0.824065f, 0.553078f, -0.477717f, -0.682562f, 
		-0.0474367f, 0.724900f, 0.687219f, 0.193097f, 0.973273f, -0.124313f, 
		0.0475908f, 0.910170f, -0.411493f, 0.348809f, 0.922102f, 0.167510f, 
		-0.492128f, 0.349573f, -0.797251f, -0.214798f, -0.975639f, -0.0446119f, 
		0.452350f, 0.444204f, -0.773345f, 0.130159f, 0.976794f, -0.170097f, 
		0.0616816f, 0.156008f, -0.985828f, -0.783540f, 0.372043f, -0.497643f, 
		0.0616816f, 0.156008f, -0.985828f, 0.109721f, -0.522918f, 0.845292f, 
		0.109721f, -0.522918f, 0.845292f, -0.193384f, -0.342521f, -0.919392f, 
		-0.937431f, -0.220183f, 0.269708f, -0.697450f, -0.154368f, 0.699810f, 
		-0.828708f, -0.155968f, 0.537510f, -0.481529f, -0.0709202f, 0.873556f, 
		0.0711257f, 0.495850f, 0.865491f, -0.0479944f, -0.396067f, 0.916967f, 
		-0.297688f, 0.642202f, -0.706370f, 0.196111f, 0.733751f, -0.650500f, 
		-0.109237f, 0.745404f, -0.657602f, -0.0103927f, 0.714346f, -0.699716f, 
		0.0923550f, 0.757885f, -0.645818f, 0.0502502f, 0.372315f, -0.926745f, 
		-0.134068f, 0.371880f, -0.918548f, -0.0629970f, 0.209798f, -0.975713f, 
		-0.0752735f, 0.735334f, -0.673512f, 0.00623012f, 0.837876f, -0.545825f, 
		0.0560117f, 0.722106f, -0.689512f, -0.153828f, 0.398896f, -0.904002f, 
		-0.257025f, -0.627298f, 0.735143f, -0.513461f, -0.640159f, 0.571449f, 
		-0.410520f, -0.671137f, 0.617292f, -0.337146f, -0.650848f, 0.680242f, 
		-0.140834f, -0.627388f, 0.765866f, 0.615973f, 0.635444f, -0.465605f, 
		0.380796f, -0.450773f, -0.807340f, 0.816162f, 0.474129f, 0.330275f, 
		-0.0924870f, -0.699770f, 0.708356f, -0.295908f, -0.328864f, -0.896820f, 
		0.702164f, 0.349386f, 0.620400f, 0.682353f, 0.261071f, 0.682815f, 
		0.646742f, 0.600712f, 0.469969f, 0.702164f, 0.349386f, 0.620400f, 
		0.682353f, 0.261071f, 0.682815f, 0.411553f, -0.437886f, 0.799300f, 
		0.499568f, -0.434281f, 0.749554f, 0.411553f, -0.437886f, 0.799300f, 
		0.323936f, -0.439570f, 0.837761f, 0.411553f, -0.437886f, 0.799300f, 
		0.594311f, -0.418144f, 0.686986f, 0.620713f, 0.565557f, 0.543011f, 
		0.609227f, 0.625619f, -0.487282f, 0.609227f, 0.625619f, -0.487282f, 
		-0.276819f, -0.874422f, 0.398443f, -0.276819f, -0.874422f, 0.398443f, 
		0.353662f, 0.514784f, 0.780974f, -0.0157936f, 0.231503f, -0.972706f, 
		0.0195074f, 0.597182f, 0.801869f, -0.150952f, -0.816036f, -0.557941f, 
		-0.224294f, -0.871084f, -0.436927f, -0.281882f, -0.879760f, -0.382838f, 
		-0.136347f, -0.263351f, -0.955016f, -0.134931f, 0.224119f, -0.965176f, 
		-0.239396f, 0.538707f, -0.807765f, -0.0712852f, -0.218547f, 0.973219f, 
		-0.148989f, 0.362517f, -0.919991f, -0.134931f, 0.224119f, -0.965176f, 
		-0.148989f, 0.362517f, -0.919991f, 0.468093f, 0.873247f, 0.135385f, 
		0.426929f, 0.541022f, -0.724587f, -0.207977f, 0.914308f, -0.347542f, 
		-0.140496f, 0.691180f, 0.708894f, -0.120528f, -0.351145f, 0.928531f, 
		-0.288525f, -0.362366f, 0.886253f, -0.525418f, -0.308322f, 0.793015f, 
		-0.0170062f, -0.127378f, -0.991708f, 0.0544048f, -0.0447828f, -0.997514f, 
		0.139146f, 0.277001f, -0.950741f, 0.128528f, 0.149293f, -0.980404f, 
		0.0591920f, 0.0713753f, -0.995692f, -0.0299392f, 0.818983f, 0.573036f, 
		0.524321f, 0.141035f, 0.839760f, -0.524686f, -0.847704f, 0.0781159f, 
		-0.941326f, -0.281539f, 0.186121f, -0.231382f, 0.559246f, -0.796057f, 
		0.565611f, 0.159189f, -0.809162f, -0.169418f, 0.694074f, 0.699685f, 
		0.0363553f, 0.984671f, -0.170593f, 0.631452f, 0.487646f, 0.602885f, 
		0.0363553f, 0.984671f, -0.170593f, 0.631452f, 0.487646f, 0.602885f, 
		0.821039f, -0.569142f, 0.0444083f, 0.756708f, -0.576979f, -0.307388f, 
		0.689602f, -0.543641f, -0.478438f, 0.214161f, 0.288252f, 0.933299f, 
		0.110232f, -0.740956f, 0.662445f, -0.459793f, -0.324697f, -0.826536f, 
		0.829530f, 0.322221f, -0.456129f, 0.985624f, -0.0163141f, 0.168163f, 
		0.754251f, 0.387340f, -0.530164f, 0.754251f, 0.387340f, -0.530164f, 
		0.949593f, -0.0893146f, 0.300494f, 0.996679f, 0.0599824f, 0.0550658f, 
		0.882337f, 0.303448f, -0.359724f, -0.304209f, 0.259522f, 0.916573f, 
		0.274793f, 0.961279f, 0.0207539f, -0.480925f, -0.260264f, -0.837242f, 
		-0.0865959f, 0.955676f, -0.281396f, 0.0274008f, 0.804096f, 0.593868f, 
		0.121715f, 0.0268203f, 0.992203f, 0.121715f, 0.0268203f, 0.992203f, 
		0.240029f, 0.00191566f, 0.970764f, -0.340902f, 0.438491f, -0.831572f, 
		0.750750f, -0.429576f, 0.501835f, -0.374338f, -0.545269f, -0.750035f, 
		0.998813f, -0.0478927f, 0.00889806f, 0.998813f, -0.0478927f, 0.00889806f, 
		0.998813f, -0.0478927f, 0.00889806f, 0.632699f, 0.267624f, 0.726684f, 
		0.632699f, 0.267624f, 0.726684f, 0.218832f, 0.959511f, 0.177344f, 
		0.719141f, 0.665854f, -0.198683f, 0.988584f, -0.0381949f, 0.145747f, 
		0.968220f, 0.226444f, 0.106179f, 0.800445f, 0.580083f, -0.150968f, 
		0.988584f, -0.0381949f, 0.145747f, 0.956817f, 0.290664f, 0.00405578f, 
		-0.722012f, -0.657112f, -0.216570f, -0.622965f, -0.780671f, -0.0496766f, 
		-0.823346f, -0.462793f, -0.328518f, 0.638386f, -0.764217f, -0.0918470f, 
		-0.0163303f, -0.686424f, -0.727018f, 0.592934f, 0.802150f, -0.0706014f, 
		-0.844297f, -0.247708f, 0.475188f, -0.805324f, -0.219475f, 0.550712f, 
		-0.882863f, -0.291837f, 0.367946f, -0.748663f, -0.229038f, 0.622130f, 
		-0.676152f, -0.210270f, 0.706120f, -0.117565f, -0.562116f, -0.818660f, 
		-0.145591f, -0.966199f, 0.212750f, -0.145591f, -0.966199f, 0.212750f, 
		0.643099f, -0.462551f, 0.610304f, -0.0445224f, 0.944086f, -0.326680f, 
		0.400807f, 0.0334213f, -0.915553f, 0.0423483f, -0.823697f, 0.565446f, 
		0.550219f, -0.0170487f, -0.834846f, 0.203862f, 0.127946f, -0.970603f, 
		-0.737091f, -0.667123f, 0.107903f, 0.0469211f, -0.832118f, 0.552610f, 
		-0.139350f, -0.838670f, 0.526512f, -0.737091f, -0.667123f, 0.107903f, 
		-0.479571f, -0.813963f, 0.327836f, -0.168381f, 0.547340f, 0.819797f, 
		-0.0651151f, 0.498862f, 0.864232f, -0.158227f, 0.392868f, 0.905880f, 
		-0.452971f, 0.0706278f, 0.888723f, -0.00171478f, 0.449572f, 0.893242f, 
		-0.232908f, 0.480723f, -0.845375f, 0.752318f, 0.417289f, -0.509792f, 
		0.752318f, 0.417289f, -0.509792f, 0.757730f, 0.651538f, -0.0366688f, 
		0.757730f, 0.651538f, -0.0366688f, 0.757730f, 0.651538f, -0.0366688f, 
		0.757730f, 0.651538f, -0.0366688f, 0.0993823f, -0.451113f, -0.886916f, 
		-0.154892f, -0.433296f, -0.887842f, -0.308329f, -0.423079f, -0.852020f, 
		-0.125258f, 0.950547f, 0.284201f, 0.0809590f, 0.950010f, 0.301539f, 
		0.161593f, 0.916387f, 0.366228f, -0.907025f, -0.329815f, -0.261777f, 
		0.804185f, 0.592403f, -0.0484346f, 0.804185f, 0.592403f, -0.0484346f, 
		0.397332f, -0.899102f, 0.183693f, 0.570819f, -0.807630f, 0.147984f, 
		0.954980f, -0.293748f, 0.0415321f, 0.570819f, -0.807630f, 0.147984f, 
		0.774758f, -0.618864f, 0.129449f, 0.665064f, -0.745590f, 0.0422536f, 
		0.665064f, -0.745590f, 0.0422536f, -0.0507311f, -0.286050f, 0.956871f, 
		0.623574f, 0.740762f, 0.249854f, 0.623574f, 0.740762f, 0.249854f, 
		-0.897181f, -0.359421f, -0.256676f, -0.124038f, 0.677766f, -0.724740f, 
		0.141337f, -0.423224f, -0.894933f, -0.645943f, -0.323819f, -0.691303f, 
		0.783029f, 0.364721f, -0.503830f, 0.705360f, 0.387192f, -0.593759f, 
		0.986153f, 0.125403f, -0.108523f, 0.843591f, 0.308420f, -0.439581f, 
		0.705360f, 0.387192f, -0.593759f, 0.951904f, 0.206434f, -0.226415f, 
		0.533060f, -0.581137f, 0.614920f, 0.629761f, -0.352868f, 0.692016f, 
		0.690167f, -0.226555f, 0.687272f, 0.765100f, -0.381448f, 0.518766f, 
		0.775950f, -0.252276f, 0.578151f, 0.986028f, -0.125078f, 0.110019f, 
		0.997903f, -0.0647051f, -0.00168709f, 0.967659f, -0.113342f, 0.225368f, 
		0.997903f, -0.0647051f, -0.00168709f, 0.311164f, -0.772106f, 0.554102f, 
		0.959774f, -0.234414f, 0.154545f, 0.311164f, -0.772106f, 0.554102f, 
		0.959774f, -0.234414f, 0.154545f, -0.0342162f, 0.0861021f, -0.995699f, 
		0.184881f, -0.705823f, 0.683836f, -0.815347f, 0.531828f, -0.228841f, 
		0.373644f, -0.687449f, 0.622739f, -0.821594f, 0.141879f, 0.552135f, 
		0.622034f, -0.468902f, 0.627060f, -0.798727f, -0.361235f, -0.481191f, 
		-0.265558f, 0.227870f, -0.936779f, 0.00349688f, -0.902746f, -0.430159f, 
		0.00349688f, -0.902746f, -0.430159f, 0.0941994f, -0.0438538f, 0.994587f, 
		0.962232f, -0.151913f, 0.225904f, 0.962232f, -0.151913f, 0.225904f, 
		0.962232f, -0.151913f, 0.225904f, -0.593470f, -0.748844f, 0.295002f, 
		0.186180f, 0.533298f, 0.825185f, -0.0747564f, 0.612678f, 0.786789f, 
		0.364913f, 0.425459f, 0.828144f, -0.213710f, 0.694858f, -0.686659f, 
		0.848506f, 0.528826f, 0.0195194f, 0.995803f, -0.0908012f, 0.0115021f, 
		0.990446f, 0.135356f, 0.0263656f, 0.230598f, -0.429585f, 0.873087f, 
		-0.846429f, -0.247193f, -0.471650f, 0.666134f, -0.335502f, 0.666111f, 
		0.788326f, -0.257722f, 0.558678f, 0.594108f, -0.400037f, 0.697858f, 
		0.865288f, -0.200438f, 0.459457f, 0.720355f, -0.326914f, 0.611732f, 
		0.807074f, 0.590424f, 0.00553238f, 0.807074f, 0.590424f, 0.00553238f, 
		0.807074f, 0.590424f, 0.00553238f, 0.807074f, 0.590424f, 0.00553238f, 
		0.749182f, 0.661696f, 0.0297440f, 0.695993f, -0.0370548f, 0.717091f, 
		0.749182f, 0.661696f, 0.0297440f, 0.749182f, 0.661696f, 0.0297440f, 
		0.668340f, -0.739842f, -0.0771708f, -0.0927985f, -0.936400f, -0.338442f, 
		0.592934f, 0.802150f, -0.0706014f, 0.548191f, 0.826353f, -0.128950f, 
		0.640592f, 0.358701f, 0.678952f, -0.111215f, 0.331971f, -0.936710f, 
		-0.194242f, -0.940591f, 0.278492f, -0.216299f, -0.878227f, 0.426535f, 
		-0.213268f, -0.914707f, -0.343262f, -0.100488f, -0.846205f, -0.523297f, 
		0.592934f, 0.802150f, -0.0706014f, 0.493956f, -0.869012f, -0.0287188f, 
		0.321397f, -0.946500f, -0.0289991f, 0.783305f, -0.621453f, -0.0151905f, 
		0.493956f, -0.869012f, -0.0287188f, 0.945929f, -0.324151f, 0.0119859f, 
		0.709260f, 0.284314f, 0.645070f, 0.700555f, 0.0829058f, 0.708767f, 
		0.651652f, -0.00857772f, 0.758469f, 0.700555f, 0.0829058f, 0.708767f, 
		0.380559f, -0.924687f, -0.0113735f, 0.974137f, -0.225744f, 0.00987340f, 
		0.376530f, 0.305563f, -0.874561f, 0.270890f, -0.621643f, 0.734968f, 
		0.270890f, -0.621643f, 0.734968f, 0.920880f, -0.220875f, 0.321238f, 
		0.0484594f, -0.985306f, 0.163782f, 0.877707f, -0.403804f, 0.258018f, 
		0.0484594f, -0.985306f, 0.163782f, 0.877707f, -0.403804f, 0.258018f, 
		0.0922295f, -0.113830f, 0.989210f, 0.741331f, 0.527518f, 0.414914f, 
		-0.911600f, -0.220509f, -0.346932f, -0.351961f, 0.318240f, -0.880254f, 
		-0.0316502f, -0.0158786f, -0.999373f, -0.0656284f, 0.0393188f, -0.997069f, 
		-0.132891f, 0.100724f, -0.985999f, -0.0656284f, 0.0393188f, -0.997069f, 
		-0.164735f, -0.284719f, -0.944350f, -0.0366638f, 0.999313f, -0.00534922f, 
		-0.253377f, 0.964279f, -0.0772415f, 0.213140f, 0.973632f, -0.0813133f, 
		-0.782096f, -0.618455f, 0.0764133f, 0.0848392f, -0.851740f, 0.517050f, 
		-0.809423f, 0.584136f, 0.0601649f, -0.859597f, -0.510869f, 0.0102696f, 
		-0.0207655f, -0.289218f, 0.957038f, 0.0252957f, -0.222465f, 0.974612f, 
		0.0813704f, -0.140624f, 0.986714f, 0.0195973f, 0.830933f, -0.556028f, 
		-0.209903f, -0.207906f, -0.955362f, 0.738599f, 0.606192f, -0.294964f, 
		0.814929f, 0.500921f, 0.291495f, 0.780558f, 0.623828f, -0.0395865f, 
		0.808319f, 0.554361f, 0.198253f, 0.828111f, 0.560470f, 0.0102807f, 
		0.738599f, 0.606192f, -0.294964f, -0.995037f, 0.0711079f, -0.0696042f, 
		-0.171572f, 0.270024f, -0.947444f, -0.989554f, -0.0764371f, 0.122229f, 
		-0.788025f, 0.580049f, -0.206302f, -0.851024f, -0.524906f, -0.0151990f, 
		0.493891f, 0.241627f, -0.835277f, 0.791875f, -0.406869f, 0.455403f, 
		-0.00228223f, -0.729448f, 0.684032f, -0.374338f, -0.545269f, -0.750035f, 
		-0.150841f, 0.938021f, -0.312030f, -0.150841f, 0.938021f, -0.312030f, 
		-0.150841f, 0.938021f, -0.312030f, -0.150841f, 0.938021f, -0.312030f, 
		-0.977506f, -0.148523f, -0.149743f, -0.618167f, 0.781488f, 0.0845355f, 
		-0.363353f, -0.931384f, -0.0223270f, -0.645450f, -0.495292f, 0.581447f, 
		0.502770f, 0.863899f, 0.0300058f, 0.502770f, 0.863899f, 0.0300058f, 
		-0.309842f, 0.201592f, -0.929171f, -0.309842f, 0.201592f, -0.929171f, 
		-0.713595f, 0.646334f, 0.270248f, -0.848629f, -0.527511f, 0.0395244f, 
		-0.0771390f, -0.203654f, -0.975999f, 0.481235f, -0.601396f, -0.637759f, 
		0.326938f, -0.478096f, -0.815191f, 0.113677f, -0.379956f, -0.917993f, 
		-0.665521f, 0.594387f, -0.451426f, -0.778248f, -0.625577f, 0.0546310f, 
		0.865177f, 0.120218f, 0.486844f, 0.740543f, 0.159910f, 0.652706f, 
		0.677670f, 0.165358f, 0.716533f, -0.884626f, -0.462693f, -0.0578995f, 
		-0.0856401f, -0.0815633f, -0.992982f, -0.666427f, -0.0715488f, -0.742129f, 
		-0.379612f, -0.00935128f, -0.925098f, -0.283838f, 0.00602318f, -0.958853f, 
		0.276319f, -0.487544f, 0.828220f, -0.912420f, -0.408768f, 0.0199608f, 
		-0.892821f, -0.411174f, 0.183865f, -0.907738f, -0.408826f, 0.0941922f, 
		-0.514227f, -0.857447f, 0.0188410f, -0.139701f, -0.661721f, -0.736620f, 
		-0.631597f, 0.748655f, -0.201498f, -0.940429f, 0.261906f, -0.216791f, 
		-0.949942f, 0.280678f, 0.137222f, -0.937944f, -0.0170950f, 0.346364f, 
		-0.0689430f, -0.974444f, 0.213791f, -0.654236f, -0.576118f, -0.489962f, 
		-0.0689430f, -0.974444f, 0.213791f, -0.654236f, -0.576118f, -0.489962f, 
		0.671726f, 0.156969f, 0.723978f, -0.946889f, -0.318026f, -0.0475419f, 
		-0.938812f, 0.0189261f, -0.343911f, -0.821335f, 0.296066f, -0.487599f, 
		-0.642311f, 0.715312f, -0.275255f, -0.765626f, 0.530335f, -0.364090f, 
		0.969689f, -0.185753f, 0.158745f, 0.393557f, 0.655249f, -0.644795f, 
		0.393557f, 0.655249f, -0.644795f, -0.743558f, 0.529846f, 0.407902f, 
		-0.785629f, -0.617714f, -0.0348932f, 0.104565f, -0.772458f, 0.626398f, 
		-0.138995f, 0.284273f, -0.948614f, 0.0689280f, 0.320021f, -0.944900f, 
		0.499088f, 0.332958f, -0.800031f, -0.138995f, 0.284273f, -0.948614f, 
		0.681097f, 0.370045f, -0.631802f, -0.508684f, -0.491730f, -0.706712f, 
		-0.524220f, -0.196958f, -0.828493f, -0.648934f, 0.517446f, -0.557795f, 
		-0.664582f, 0.270311f, -0.696608f, 0.409364f, -0.158839f, 0.898438f, 
		0.856553f, -0.515281f, 0.0283266f, 0.577469f, -0.217303f, 0.786962f, 
		-0.539931f, 0.792688f, -0.283054f, 0.941265f, -0.334553f, -0.0457720f, 
		0.104257f, -0.285476f, -0.952698f, 0.104257f, -0.285476f, -0.952698f, 
		-0.387193f, 0.805185f, -0.449175f, -0.619881f, 0.705401f, -0.343740f, 
		-0.468424f, 0.774623f, -0.424898f, -0.287606f, -0.236512f, -0.928087f, 
		-0.874409f, -0.485049f, 0.0116709f, 0.0166932f, -0.297766f, -0.954493f, 
		0.938924f, 0.0562129f, 0.339502f, 0.938924f, 0.0562129f, 0.339502f, 
		0.149338f, 0.788019f, 0.597264f, -0.875695f, 0.0935001f, -0.473726f, 
		0.198836f, 0.384124f, 0.901617f, 0.198836f, 0.384124f, 0.901617f, 
		0.519241f, 0.845778f, -0.122671f, 0.519241f, 0.845778f, -0.122671f, 
		0.517779f, 0.720572f, -0.461174f, 0.545012f, 0.805041f, -0.234247f, 
		-0.564744f, 0.752676f, 0.338441f, -0.308827f, 0.597745f, -0.739815f, 
		0.699128f, 0.445403f, -0.559317f, 0.699128f, 0.445403f, -0.559317f, 
		-0.308827f, 0.597745f, -0.739815f, 0.699128f, 0.445403f, -0.559317f, 
		-0.241426f, -0.187646f, 0.952104f, 0.224397f, 0.0627989f, 0.972472f, 
		-0.0402083f, -0.0431743f, 0.998258f, -0.0657635f, 0.402540f, -0.913037f, 
		0.334448f, 0.381753f, -0.861632f, 0.127708f, 0.380810f, -0.915792f, 
		0.631948f, 0.639395f, -0.437967f, 0.577745f, 0.816150f, -0.0104895f, 
		0.571030f, 0.458680f, -0.680836f, -0.198068f, 0.521551f, -0.829912f, 
		0.710810f, 0.298756f, -0.636784f, -0.198068f, 0.521551f, -0.829912f, 
		-0.0221944f, 0.487538f, -0.872819f, 0.531032f, 0.320702f, -0.784318f, 
		-0.911540f, -0.296150f, 0.285289f, 0.362431f, -0.428828f, 0.827496f, 
		-0.186858f, 0.435799f, -0.880434f, -0.176153f, 0.194057f, -0.965045f, 
		-0.292724f, 0.572235f, -0.766068f, -0.801532f, -0.597949f, 0.00195013f, 
		-0.296155f, 0.953302f, -0.0592254f, 0.893442f, -0.354981f, -0.275227f, 
		-0.901359f, 0.170276f, 0.398194f, -0.872931f, 0.461065f, -0.159406f, 
		0.0856760f, -0.896959f, 0.433732f, 0.454738f, 0.374765f, -0.807939f, 
		0.454738f, 0.374765f, -0.807939f, 0.543684f, 0.510304f, -0.666332f, 
		-0.500345f, 0.861892f, -0.0824435f, 0.614815f, 0.696171f, -0.370605f, 
		-0.516810f, 0.853590f, -0.0655041f, 0.599665f, 0.799653f, -0.0309403f, 
		-0.516810f, 0.853590f, -0.0655041f, 0.599665f, 0.799653f, -0.0309403f, 
		-0.876881f, -0.477047f, 0.0592091f, -0.195016f, -0.703842f, -0.683063f, 
		0.257795f, 0.557288f, -0.789286f, 0.520090f, 0.850339f, -0.0801921f, 
		0.0741832f, -0.665130f, 0.743033f, -0.545680f, 0.837655f, -0.0238082f, 
		0.573888f, 0.817169f, -0.0537348f, -0.262468f, -0.00350729f, 0.964934f, 
		-0.262468f, -0.00350729f, 0.964934f, -0.230236f, 0.693883f, 0.682289f, 
		0.576518f, 0.489717f, 0.654067f, -0.516277f, -0.360358f, 0.776917f, 
		0.196351f, -0.241826f, -0.950245f, 0.303051f, -0.165197f, -0.938547f, 
		0.269378f, -0.196918f, -0.942687f, -0.882761f, -0.259307f, -0.391781f, 
		0.243997f, -0.211579f, 0.946414f, 0.0333422f, -0.327415f, 0.944292f, 
		0.545561f, -0.111651f, 0.830600f, 0.123606f, -0.216176f, 0.968499f, 
		0.0333422f, -0.327415f, 0.944292f, 0.405036f, -0.123536f, 0.905916f, 
		-0.167703f, 0.206698f, -0.963925f, 0.825221f, -0.443207f, -0.350110f, 
		0.0228509f, -0.996915f, -0.0750926f, -0.180629f, 0.975139f, 0.128365f, 
		0.773265f, -0.385086f, -0.503755f, -0.0442327f, -0.386701f, 0.921144f, 
		0.452757f, 0.479408f, -0.751784f, 0.452757f, 0.479408f, -0.751784f, 
		-0.226524f, 0.697911f, 0.679416f, 0.564323f, 0.483211f, 0.669363f, 
		-0.233597f, -0.110240f, 0.966064f, -0.233597f, -0.110240f, 0.966064f, 
		-0.830940f, -0.554477f, 0.0457617f, 0.0423483f, -0.823697f, 0.565446f, 
		-0.252069f, -0.0665998f, -0.965415f, -0.252069f, -0.0665998f, -0.965415f, 
		0.846534f, -0.497589f, -0.189172f, -0.720447f, -0.361021f, -0.592132f, 
		-0.725633f, -0.178951f, -0.664405f, -0.687836f, 0.0937784f, -0.719783f, 
		-0.712997f, -0.465177f, -0.524639f, -0.720447f, -0.361021f, -0.592132f, 
		-0.721844f, -0.262666f, -0.640272f, 0.890267f, 0.344766f, -0.297592f, 
		0.922724f, -0.358329f, 0.142057f, 0.982876f, 0.0963266f, -0.157088f, 
		0.979389f, -0.183204f, 0.0850463f, 0.995787f, -0.0901381f, -0.0168100f, 
		0.947814f, 0.170506f, -0.269398f, 0.993581f, 0.0858687f, -0.0736409f, 
		0.532827f, 0.200280f, 0.822182f, 0.591641f, -0.790768f, -0.156990f, 
		0.00349688f, -0.902746f, -0.430159f, 0.776960f, -0.349758f, -0.523453f, 
		0.757298f, -0.573385f, -0.312616f, 0.376407f, -0.886778f, -0.268219f, 
		-0.276291f, 0.957492f, -0.0828961f, 0.654456f, 0.706821f, 0.268500f, 
		-0.276291f, 0.957492f, -0.0828961f, 0.654456f, 0.706821f, 0.268500f, 
		-0.120970f, 0.823584f, 0.554145f, 0.635310f, -0.329164f, -0.698593f, 
		0.561113f, 0.138326f, 0.816099f, 0.107065f, 0.981336f, 0.159737f, 
		0.188827f, 0.940489f, -0.282531f, 0.161354f, 0.982823f, -0.0895774f, 
		0.834854f, 0.542812f, 0.0915109f, -0.0813882f, 0.621231f, -0.779390f, 
		-0.555873f, -0.373067f, 0.742850f, -0.363353f, -0.931384f, -0.0223270f, 
		-0.555873f, -0.373067f, 0.742850f, 0.275062f, 0.730320f, -0.625279f, 
		0.417152f, 0.729444f, -0.542121f, 0.553263f, 0.634523f, -0.539704f, 
		-0.819847f, 0.524311f, 0.230107f, -0.112474f, -0.185575f, 0.976172f, 
		0.741016f, 0.569694f, 0.355449f, 0.647570f, 0.762001f, -0.00269410f, 
		0.710935f, 0.412454f, 0.569608f, 0.522357f, 0.623591f, 0.581616f, 
		0.522357f, 0.623591f, 0.581616f, 0.126601f, -0.560912f, -0.818138f, 
		0.491162f, -0.867923f, 0.0739622f, -0.496495f, -0.864897f, 0.0737993f, 
		-0.820090f, 0.269335f, -0.504887f, 0.482627f, -0.861575f, 0.157351f, 
		-0.532011f, -0.805517f, 0.260973f, 0.482627f, -0.861575f, 0.157351f, 
		-0.532011f, -0.805517f, 0.260973f, -0.811200f, -0.166475f, 0.560572f, 
		-0.416914f, 0.908740f, -0.0193568f, 0.630738f, 0.775930f, 0.0101238f, 
		-0.416914f, 0.908740f, -0.0193568f, 0.630738f, 0.775930f, 0.0101238f, 
		0.935686f, -0.275030f, -0.221019f, 0.528003f, -0.241542f, 0.814169f, 
		-0.823455f, -0.540433f, -0.172785f, -0.891509f, 0.145158f, -0.429116f, 
		-0.823243f, 0.353840f, -0.443923f, -0.738058f, -0.662702f, -0.126869f, 
		-0.827159f, -0.485243f, -0.283454f, -0.735123f, 0.471414f, -0.487200f, 
		-0.523396f, 0.717017f, -0.460373f, -0.418949f, 0.778511f, -0.467335f, 
		-0.938851f, 0.108802f, 0.326681f, -0.860436f, 0.338630f, 0.380762f, 
		-0.549583f, 0.735532f, 0.396170f, -0.427406f, 0.828558f, 0.361685f, 
		-0.429365f, 0.903014f, -0.0145337f, 0.640884f, 0.766801f, 0.0358405f, 
		-0.959026f, -0.149281f, 0.240799f, -0.938851f, 0.108802f, 0.326681f, 
		-0.718705f, -0.689618f, 0.0888304f, -0.811733f, -0.571241f, 0.121547f, 
		-0.821698f, 0.323112f, 0.469479f, -0.301099f, 0.695028f, -0.652898f, 
		0.555093f, 0.456737f, -0.695171f, -0.590592f, -0.351140f, -0.726569f, 
		-0.517961f, -0.0707470f, -0.852474f, -0.602572f, -0.102154f, -0.791499f, 
		-0.445236f, -0.0235708f, -0.895103f, -0.667919f, -0.165331f, -0.725637f, 
		-0.204563f, 0.0844154f, -0.975207f, 0.523166f, 0.607064f, 0.598139f, 
		0.781726f, 0.562995f, 0.268217f, 0.858940f, 0.483499f, 0.168674f, 
		0.708176f, 0.548327f, 0.444774f, 0.631975f, 0.581474f, 0.512343f, 
		0.227056f, -0.520305f, 0.823243f, -0.0736195f, -0.486769f, 0.870423f, 
		-0.724325f, -0.551018f, 0.414405f, -0.454717f, -0.346518f, 0.820462f, 
		0.227056f, -0.520305f, 0.823243f, -0.567190f, -0.445184f, 0.692897f, 
		0.313664f, 0.740614f, 0.594227f, 0.313664f, 0.740614f, 0.594227f, 
		0.990571f, 0.0911324f, 0.102292f, -0.825606f, 0.0621857f, 0.560810f, 
		-0.407149f, 0.910798f, -0.0683861f, -0.804053f, 0.593701f, -0.0319094f, 
		0.578060f, 0.482427f, 0.658112f, 0.578060f, 0.482427f, 0.658112f, 
		-0.298766f, 0.697343f, -0.651500f, 0.539730f, 0.449931f, -0.711515f, 
		0.640326f, -0.433424f, -0.634134f, -0.196670f, 0.491412f, -0.848431f, 
		0.328746f, -0.507589f, 0.796416f, 0.328746f, -0.507589f, 0.796416f, 
		0.954497f, 0.217913f, 0.203589f, 0.998774f, 0.0441229f, -0.0224610f, 
		0.992444f, 0.0957923f, 0.0766700f, 0.499455f, 0.397678f, -0.769673f, 
		0.725952f, 0.446954f, -0.522710f, 0.265780f, 0.286394f, -0.920510f, 
		0.725952f, 0.446954f, -0.522710f, -0.799267f, -0.541122f, 0.261456f, 
		0.0245976f, -0.184459f, -0.982532f, 0.0697190f, -0.524272f, 0.848692f, 
		0.390605f, -0.812303f, 0.433119f, -0.657150f, -0.625461f, 0.420658f, 
		0.390605f, -0.812303f, 0.433119f, -0.657150f, -0.625461f, 0.420658f, 
		-0.392847f, 0.879730f, 0.267856f, -0.284686f, 0.880985f, -0.377914f, 
		-0.794259f, -0.0264212f, -0.607005f, -0.371684f, -0.893006f, -0.253754f, 
		0.445720f, -0.0184188f, -0.894983f, -0.000536259f, 0.999505f, -0.0314721f, 
		-0.139908f, 0.544522f, 0.826996f, 0.986174f, -0.155765f, 0.0565554f, 
		0.962465f, -0.261568f, -0.0724109f, 0.975226f, -0.221166f, -0.00449247f, 
		-0.619004f, -0.335671f, -0.710041f, 0.526348f, 0.848330f, -0.0573883f, 
		0.489358f, 0.689160f, -0.534404f, 0.375709f, 0.922390f, 0.0896658f, 
		0.480355f, 0.872424f, 0.0901903f, 0.563632f, 0.819494f, 0.103674f, 
		0.473885f, -0.577579f, 0.664707f, 0.0794965f, 0.996826f, -0.00419296f, 
		0.0794965f, 0.996826f, -0.00419296f, 0.0794965f, 0.996826f, -0.00419296f, 
		0.754937f, 0.552977f, -0.352543f, 0.805968f, 0.452233f, -0.381969f, 
		0.812773f, 0.514271f, -0.273723f, 0.776305f, 0.403474f, -0.484314f, 
		0.853066f, 0.353323f, -0.383980f, -0.771746f, -0.371093f, 0.516427f, 
		0.113032f, -0.0848152f, 0.989965f, -0.611174f, 0.777610f, 0.147612f, 
		-0.611174f, 0.777610f, 0.147612f, 0.314860f, -0.850754f, 0.420810f, 
		0.0718276f, -0.868285f, 0.490838f, 0.444241f, -0.808728f, 0.385500f, 
		0.674586f, 0.732019f, 0.0953009f, 0.674586f, 0.732019f, 0.0953009f, 
		0.120214f, -0.689087f, -0.714638f, 0.0199716f, -0.803436f, -0.595056f, 
		-0.236045f, -0.948861f, -0.209634f, -0.318970f, -0.947497f, -0.0225352f, 
		-0.373398f, 0.846031f, 0.380532f, -0.373398f, 0.846031f, 0.380532f, 
		-0.223998f, 0.969668f, 0.0978196f, -0.317165f, 0.906714f, 0.277987f, 
		0.409189f, -0.911830f, -0.0336153f, -0.588548f, -0.807714f, -0.0347878f, 
		-0.857116f, -0.502453f, -0.113549f, -0.757699f, 0.508473f, -0.409081f, 
		-0.530213f, 0.510795f, 0.676730f, -0.753619f, -0.637940f, -0.158402f, 
		-0.702001f, -0.583373f, 0.408497f, -0.871533f, -0.209042f, 0.443545f, 
		-0.844097f, -0.391922f, 0.365920f, -0.399714f, 0.874576f, 0.274490f, 
		0.932501f, -0.360451f, -0.0227202f, 0.667679f, 0.639859f, 0.380508f, 
		0.391600f, 0.800791f, 0.453192f, 0.813765f, 0.475421f, 0.334307f, 
		0.590906f, 0.682960f, 0.429414f, 0.484822f, 0.727268f, 0.485828f, 
		0.309827f, -0.610824f, 0.728630f, -0.653728f, -0.478848f, 0.585956f, 
		0.309827f, -0.610824f, 0.728630f, -0.653728f, -0.478848f, 0.585956f, 
		0.381095f, -0.923381f, -0.0461988f, -0.697642f, -0.706065f, -0.121521f, 
		0.381095f, -0.923381f, -0.0461988f, -0.697642f, -0.706065f, -0.121521f, 
		-0.746713f, -0.658149f, -0.0962259f, 0.809947f, 0.522766f, 0.265897f, 
		0.855039f, 0.480279f, 0.195551f, 0.858518f, 0.422006f, 0.291303f, 
		0.841910f, 0.379296f, 0.383827f, 0.898826f, 0.325964f, 0.293017f, 
		0.253891f, -0.966712f, 0.0317406f, -0.757265f, -0.567809f, -0.322711f, 
		0.253891f, -0.966712f, 0.0317406f, -0.757265f, -0.567809f, -0.322711f, 
		0.822390f, 0.316671f, -0.472646f, 0.822390f, 0.316671f, -0.472646f, 
		0.0776535f, 0.505375f, -0.859398f, -0.892788f, -0.431074f, -0.130784f, 
		0.392852f, 0.871964f, 0.292140f, 0.203128f, 0.823515f, -0.529681f, 
		0.890556f, 0.380697f, -0.248956f, -0.724025f, -0.669797f, 0.164803f, 
		-0.622097f, -0.225435f, 0.749783f, -0.982429f, 0.0354245f, -0.183245f, 
		0.638975f, 0.0896329f, -0.763987f, -0.907915f, -0.0223346f, -0.418559f, 
		-0.866586f, 0.364112f, -0.341248f, -0.484927f, 0.855523f, -0.181457f, 
		-0.624502f, 0.746409f, -0.229937f, -0.907915f, -0.0223346f, -0.418559f, 
		0.468938f, 0.774896f, 0.423832f, 0.00313871f, 0.999994f, -0.00160526f, 
		0.848182f, -0.479211f, -0.225709f, 0.456596f, -0.604562f, 0.652706f, 
		0.257484f, -0.562120f, 0.785954f, 0.695113f, -0.558385f, 0.452796f, 
		0.175218f, 0.240987f, 0.954580f, 0.837258f, -0.449694f, 0.311085f, 
		0.383196f, -0.718502f, 0.580445f, -0.332953f, 0.176231f, 0.926329f, 
		-0.956494f, 0.256694f, -0.138667f, 0.244009f, 0.215707f, 0.945479f, 
		0.888441f, -0.457723f, -0.0340946f, -0.617846f, 0.614778f, -0.490219f, 
		-0.757486f, 0.394428f, -0.520232f, -0.604316f, 0.677246f, -0.419691f, 
		-0.865115f, 0.252531f, -0.433363f, -0.718270f, 0.475099f, -0.508300f, 
		-0.865115f, 0.252531f, -0.433363f, -0.718270f, 0.475099f, -0.508300f, 
		-0.574003f, 0.111540f, 0.811221f, 0.661206f, 0.172251f, -0.730161f, 
		0.0829485f, 0.536338f, -0.839917f, 0.134650f, 0.305990f, -0.942465f, 
		0.0236139f, 0.672307f, -0.739896f, 0.804063f, 0.497730f, -0.325189f, 
		0.193615f, -0.823990f, 0.532498f, 0.700881f, -0.620396f, 0.351958f, 
		0.562565f, -0.723397f, 0.400271f, 0.453238f, -0.716710f, 0.530002f, 
		0.192904f, -0.721259f, 0.665262f, 0.602060f, -0.315757f, -0.733363f, 
		0.602060f, -0.315757f, -0.733363f, -0.986659f, -0.158605f, 0.0367140f, 
		-0.700014f, 0.345877f, 0.624780f, 0.708412f, 0.696152f, -0.116293f, 
		0.708412f, 0.696152f, -0.116293f, -0.995569f, 0.0859205f, 0.0381982f, 
		-0.202996f, 0.852064f, -0.482473f, -0.681792f, 0.723796f, 0.106201f, 
		-0.875695f, 0.0935001f, -0.473726f, 0.189878f, 0.859846f, 0.473931f, 
		-0.0910658f, 0.953894f, 0.285995f, -0.348633f, 0.933008f, 0.0891721f, 
		-0.827128f, -0.534617f, 0.173332f, 0.756182f, -0.643428f, 0.119120f, 
		0.887880f, -0.450278f, 0.0944435f, 0.822799f, -0.558966f, 0.102761f, 
		0.683795f, -0.710136f, 0.167723f, 0.595807f, -0.766984f, 0.238221f, 
		0.820406f, -0.568953f, -0.0568011f, -0.875594f, 0.462503f, -0.139376f, 
		-0.268268f, -0.0412277f, 0.962462f, -0.354833f, 0.846754f, 0.396359f, 
		0.894968f, -0.427997f, 0.125901f, -0.0282794f, -0.628607f, -0.777209f, 
		0.0433990f, -0.862840f, -0.503610f, 0.0549258f, -0.780598f, -0.622616f, 
		0.591859f, -0.657095f, -0.466829f, 0.181925f, -0.861375f, -0.474274f, 
		0.706325f, -0.631471f, -0.319921f, 0.444598f, 0.543293f, -0.712155f, 
		0.723507f, -0.544548f, -0.424269f, 0.705339f, -0.463972f, -0.535936f, 
		-0.611965f, -0.520338f, 0.595606f, -0.986567f, -0.0480914f, -0.156118f, 
		-0.682133f, 0.561701f, 0.468174f, 0.307720f, -0.570516f, 0.761459f, 
		0.222014f, -0.672104f, 0.706389f, 0.386557f, -0.508907f, 0.769147f, 
		0.810798f, 0.486723f, -0.325127f, 0.813111f, 0.390540f, -0.431659f, 
		0.739598f, 0.617359f, -0.268073f, 0.885588f, 0.0104253f, -0.464355f, 
		0.888974f, 0.109130f, -0.444764f, 0.876914f, -0.136004f, -0.461004f, 
		-0.728683f, -0.472770f, -0.495489f, -0.823085f, -0.231206f, -0.518724f, 
		-0.728683f, -0.472770f, -0.495489f, -0.564409f, -0.682334f, -0.464610f, 
		-0.335151f, -0.856080f, -0.393446f, -0.564409f, -0.682334f, -0.464610f, 
		0.252589f, 0.498387f, 0.829343f, -0.986736f, 0.0362566f, -0.158235f, 
		-0.321801f, -0.386124f, 0.864495f, 0.813241f, 0.445807f, -0.374026f, 
		0.813241f, 0.445807f, -0.374026f, -0.690143f, -0.588508f, 0.421143f, 
		0.477659f, 0.529088f, 0.701362f, 0.477659f, 0.529088f, 0.701362f, 
		-0.803391f, -0.273642f, 0.528851f, -0.803391f, -0.273642f, 0.528851f, 
		0.489604f, 0.279647f, -0.825885f, -0.465642f, 0.861460f, -0.202642f, 
		-0.188711f, 0.970702f, -0.148746f, -0.737138f, 0.607952f, -0.294997f, 
		-0.663042f, 0.716865f, -0.215593f, -0.350537f, 0.919301f, -0.178913f, 
		-0.612450f, -0.693068f, 0.380213f, 0.602861f, 0.193436f, -0.774042f, 
		-0.343032f, 0.605903f, 0.717781f, 0.748062f, -0.156876f, 0.644821f, 
		-0.112285f, -0.799009f, 0.590743f, -0.249482f, 0.771753f, 0.584940f, 
		0.778552f, -0.451495f, 0.435900f, -0.249482f, 0.771753f, 0.584940f, 
		0.788270f, 0.0962153f, 0.607761f, 0.694456f, 0.520032f, -0.497291f, 
		0.694456f, 0.520032f, -0.497291f, 0.409161f, 0.567215f, 0.714741f, 
		0.409161f, 0.567215f, 0.714741f, -0.717911f, 0.0537267f, 0.694058f, 
		0.854500f, 0.387657f, 0.345764f, 0.748551f, 0.618866f, 0.238067f, 
		0.919781f, -0.0981333f, 0.379964f, 0.911320f, 0.179080f, 0.370712f, 
		0.441182f, 0.456011f, -0.772924f, 0.261670f, 0.368277f, -0.892133f, 
		0.580745f, 0.498417f, -0.643674f, 0.714224f, 0.446815f, -0.538739f, 
		0.355185f, 0.441088f, -0.824187f, 0.741943f, 0.557673f, -0.372185f, 
		0.741943f, 0.557673f, -0.372185f, -0.943249f, -0.222652f, 0.246390f, 
		-0.971094f, -0.105259f, 0.214234f, -0.982029f, 0.0982571f, 0.161133f, 
		0.704690f, -0.633589f, -0.319340f, -0.681081f, -0.327344f, -0.654961f, 
		-0.982926f, 0.00725986f, -0.183856f, -0.180378f, -0.544892f, 0.818875f, 
		-0.656851f, -0.372068f, 0.655829f, -0.656851f, -0.372068f, 0.655829f, 
		-0.656851f, -0.372068f, 0.655829f, 0.771528f, 0.635054f, -0.0380846f, 
		-0.827485f, -0.560347f, 0.0357818f, -0.391912f, 0.226367f, -0.891719f, 
		-0.422493f, -0.203041f, -0.883331f, -0.394506f, 0.468636f, -0.790409f, 
		-0.560840f, 0.529061f, -0.636830f, -0.867864f, 0.336229f, -0.365735f, 
		-0.394506f, 0.468636f, -0.790409f, 0.411498f, 0.301692f, -0.860030f, 
		0.676607f, -0.0217252f, -0.736023f, 0.829193f, -0.195078f, -0.523816f, 
		-0.377969f, 0.872471f, -0.309733f, -0.966845f, 0.255162f, -0.0101073f, 
		-0.169868f, -0.425842f, -0.888709f, -0.818139f, -0.573570f, -0.0408175f, 
		0.458330f, 0.494712f, -0.738372f, 0.458330f, 0.494712f, -0.738372f, 
		-0.843900f, -0.262166f, -0.468083f, -0.843900f, -0.262166f, -0.468083f, 
		0.697874f, 0.716085f, -0.0139683f, 0.959126f, -0.282812f, -0.00968170f, 
		-0.116770f, -0.795671f, 0.594367f, 0.821355f, -0.455302f, 0.343621f, 
		0.254498f, -0.484146f, -0.837158f, 0.423452f, -0.392626f, -0.816415f, 
		0.000501044f, -0.468310f, -0.883564f, -0.134880f, -0.855531f, -0.499874f, 
		0.0772951f, -0.781067f, -0.619645f, 0.216092f, -0.663832f, -0.715983f, 
		-0.297723f, 0.838937f, -0.455572f, -0.958464f, 0.265020f, -0.105407f, 
		-0.658481f, -0.313112f, 0.684371f, 0.443513f, -0.340027f, 0.829264f, 
		-0.651129f, 0.709640f, -0.269150f, 0.811853f, 0.582829f, -0.0347052f, 
		0.811853f, 0.582829f, -0.0347052f, -0.412472f, 0.860097f, 0.300165f, 
		0.0966683f, -0.297969f, -0.949668f, 0.758690f, 0.496243f, 0.422057f, 
		0.758690f, 0.496243f, 0.422057f, 0.414615f, 0.530707f, -0.739219f, 
		0.414615f, 0.530707f, -0.739219f, 0.783866f, -0.156349f, 0.600924f, 
		0.783866f, -0.156349f, 0.600924f, 0.639804f, -0.541851f, -0.545022f, 
		-0.377110f, 0.249641f, -0.891890f, 0.639804f, -0.541851f, -0.545022f, 
		0.381542f, -0.386064f, -0.839869f, -0.517567f, -0.139170f, 0.844249f, 
		-0.434140f, -0.102189f, 0.895031f, -0.434140f, -0.102189f, 0.895031f, 
		-0.280769f, 0.0290681f, 0.959335f, -0.412937f, 0.871442f, -0.264710f, 
		-0.412937f, 0.871442f, -0.264710f, -0.690727f, -0.664646f, 0.284854f, 
		-0.431617f, -0.781383f, 0.450719f, -0.919916f, -0.389371f, -0.0463002f, 
		-0.622092f, 0.255988f, -0.739914f, 0.860742f, 0.413379f, 0.297055f, 
		0.860742f, 0.413379f, 0.297055f, 0.972448f, -0.0519386f, -0.227260f, 
		0.960720f, 0.115183f, -0.252488f, 0.971393f, 0.0300935f, -0.235564f, 
		-0.977550f, -0.153413f, -0.144431f, -0.00621794f, -0.631296f, 0.775517f, 
		-0.637299f, -0.760395f, 0.125101f, -0.622482f, -0.677369f, -0.392031f, 
		-0.622482f, -0.677369f, -0.392031f, -0.622482f, -0.677369f, -0.392031f, 
		0.191650f, -0.0578995f, -0.979754f, -0.706152f, -0.316180f, -0.633545f, 
		-0.706152f, -0.316180f, -0.633545f, 0.712665f, 0.492453f, -0.499598f, 
		0.813877f, 0.565956f, -0.131519f, 0.824613f, 0.565690f, -0.00294345f, 
		0.595084f, 0.187029f, -0.781598f, -0.0245562f, 0.882670f, -0.469352f, 
		-0.104223f, -0.683959f, -0.722037f, -0.752861f, -0.653491f, 0.0784234f, 
		-0.752861f, -0.653491f, 0.0784234f, -0.629310f, -0.599295f, -0.494787f, 
		-0.471226f, -0.657388f, 0.588037f, -0.104348f, -0.683586f, 0.722372f, 
		0.333378f, -0.611837f, 0.717297f, 0.492303f, -0.503108f, 0.710296f, 
		-0.534499f, 0.828160f, -0.168710f, -0.351799f, 0.927383f, -0.127271f, 
		-0.251280f, 0.966852f, -0.0453457f, 0.0571776f, 0.374944f, -0.925282f, 
		0.0571776f, 0.374944f, -0.925282f, 0.717815f, 0.648854f, -0.252448f, 
		-0.609981f, -0.0328512f, -0.791735f, 0.172889f, -0.380768f, -0.908364f, 
		0.159570f, -0.100168f, -0.982092f, 0.424470f, 0.103442f, -0.899514f, 
		0.615107f, -0.0726842f, -0.785086f, 0.434043f, -0.309843f, -0.845934f, 
		0.776405f, 0.542691f, 0.320440f, 0.776405f, 0.542691f, 0.320440f, 
		0.635082f, -0.542423f, -0.549952f, 0.831394f, 0.555664f, 0.00462024f, 
		0.831394f, 0.555664f, 0.00462024f, -0.489707f, 0.0444345f, 0.870754f, 
		0.427082f, -0.225524f, 0.875637f, 0.457979f, 0.850420f, 0.258923f, 
		0.378895f, 0.881386f, 0.282129f, 0.352398f, 0.850827f, 0.389755f, 
		-0.526719f, -0.749287f, 0.401417f, -0.757647f, -0.529535f, -0.381529f, 
		-0.914519f, -0.198469f, -0.352513f, -0.700387f, -0.656312f, -0.280558f, 
		-0.757647f, -0.529535f, -0.381529f, -0.891979f, 0.235509f, -0.385887f, 
		-0.832924f, 0.505462f, 0.225269f, 0.777014f, -0.628052f, 0.0424293f, 
		-0.765054f, -0.627460f, 0.144866f, -0.765054f, -0.627460f, 0.144866f, 
		0.281933f, 0.266737f, 0.921610f, 0.121300f, 0.171885f, 0.977621f, 
		0.0779679f, 0.0778801f, 0.993909f, 0.170781f, 0.946553f, 0.273627f, 
		0.170781f, 0.946553f, 0.273627f, 0.562472f, -0.173498f, -0.808408f, 
		0.701238f, -0.220569f, -0.677949f, 0.772641f, -0.171815f, -0.611151f, 
		0.173860f, 0.699304f, 0.693359f, 0.656366f, 0.652829f, -0.378151f, 
		0.279186f, 0.879727f, -0.384885f, 0.410930f, 0.816847f, -0.404842f, 
		0.887663f, 0.295189f, -0.353438f, -0.603660f, 0.743281f, 0.288321f, 
		-0.635886f, -0.272551f, 0.722056f, 0.231910f, 0.508538f, 0.829220f, 
		0.231910f, 0.508538f, 0.829220f, -0.947807f, -0.182205f, 0.261653f, 
		0.231910f, 0.508538f, 0.829220f, -0.947807f, -0.182205f, 0.261653f, 
		0.145551f, 0.181864f, -0.972492f, 0.0950107f, 0.227334f, -0.969171f, 
		0.00569907f, 0.261200f, -0.965268f, -0.931798f, 0.336432f, -0.136256f, 
		-0.0931595f, 0.441475f, -0.892424f, -0.646991f, 0.760358f, -0.0570775f, 
		-0.759530f, 0.639679f, -0.118004f, -0.646991f, 0.760358f, -0.0570775f, 
		-0.767253f, -0.281855f, 0.576091f, -0.767253f, -0.281855f, 0.576091f, 
		0.0226692f, -0.860031f, 0.509738f, 0.826358f, 0.484095f, -0.287721f, 
		0.826358f, 0.484095f, -0.287721f, 0.323065f, 0.656667f, 0.681481f, 
		0.323065f, 0.656667f, 0.681481f, -0.665869f, 0.414353f, -0.620427f, 
		-0.562961f, 0.460959f, -0.685997f, -0.665869f, 0.414353f, -0.620427f, 
		-0.857753f, 0.258595f, -0.444285f, -0.562961f, 0.460959f, -0.685997f, 
		0.164441f, 0.657029f, 0.735712f, 0.573629f, 0.0210082f, 0.818846f, 
		0.510935f, 0.0533349f, 0.857963f, 0.573629f, 0.0210082f, 0.818846f, 
		0.616906f, 0.00631973f, 0.787012f, -0.583377f, -0.536971f, 0.609371f, 
		0.680136f, -0.539754f, 0.496065f, 0.367914f, -0.552846f, 0.747664f, 
		-0.562342f, 0.447884f, 0.695105f, -0.947234f, -0.0914903f, 0.307210f, 
		-0.569850f, -0.0674529f, 0.818976f, -0.477397f, -0.841351f, 0.253419f, 
		-0.791749f, -0.575843f, -0.203810f, -0.918063f, -0.395472f, 0.0275853f, 
		-0.682462f, -0.434277f, -0.587920f, -0.855289f, -0.0954688f, 0.509281f, 
		-0.779862f, -0.589595f, -0.210223f, -0.996962f, 0.0760168f, -0.0169529f, 
		-0.968778f, -0.235042f, 0.0788971f, -0.952397f, -0.218354f, 0.212748f, 
		0.273784f, -0.871775f, 0.406264f, -0.134680f, -0.838792f, 0.527531f, 
		0.133110f, -0.881059f, 0.453891f, 0.273784f, -0.871775f, 0.406264f, 
		0.322914f, -0.590981f, -0.739235f, -0.956846f, -0.286155f, 0.0506110f, 
		0.315433f, 0.597868f, -0.736923f, 0.222069f, 0.490580f, -0.842625f, 
		0.222069f, 0.490580f, -0.842625f, -0.965020f, -0.175574f, -0.194704f, 
		0.145751f, 0.455493f, -0.878227f, -0.965020f, -0.175574f, -0.194704f, 
		0.111170f, 0.116981f, -0.986892f, 0.273385f, 0.0913271f, -0.957559f, 
		0.182686f, 0.104138f, -0.977640f, 0.0561566f, 0.573736f, 0.817113f, 
		-0.584586f, 0.792899f, -0.171961f, -0.490108f, -0.844328f, 0.216573f, 
		-0.646040f, -0.741980f, 0.179159f, -0.696204f, -0.715064f, 0.0631163f, 
		-0.839489f, 0.259374f, 0.477476f, -0.839489f, 0.259374f, 0.477476f, 
		0.888859f, -0.272337f, -0.368459f, 0.888859f, -0.272337f, -0.368459f, 
		0.857082f, 0.465982f, 0.219706f, 0.857082f, 0.465982f, 0.219706f, 
		0.318809f, 0.645198f, -0.694320f, 0.318809f, 0.645198f, -0.694320f, 
		0.812671f, 0.509498f, -0.282801f, -0.349389f, 0.934919f, -0.0620732f, 
		-0.349389f, 0.934919f, -0.0620732f, -0.950604f, 0.273264f, 0.147239f, 
		-0.783769f, -0.618266f, 0.0587597f, -0.897602f, -0.440090f, 0.0251317f, 
		-0.985863f, -0.167468f, -0.00539534f, -0.937179f, -0.191825f, 0.291375f, 
		-0.937179f, -0.191825f, 0.291375f, 0.808801f, 0.573522f, 0.130053f, 
		0.808801f, 0.573522f, 0.130053f, 0.0332039f, 0.174251f, 0.984141f, 
		-0.384231f, 0.906186f, -0.176619f, -0.688586f, 0.719302f, -0.0919458f, 
		-0.629636f, 0.774088f, -0.0659330f, -0.538213f, 0.842725f, -0.0118774f, 
		-0.629636f, 0.774088f, -0.0659330f, -0.629636f, 0.774088f, -0.0659330f, 
		-0.807743f, 0.588127f, -0.0407211f, -0.660655f, 0.749789f, -0.0367662f, 
		-0.974513f, 0.223660f, -0.0173460f, -0.0342162f, 0.0861021f, -0.995699f, 
		0.298576f, -0.413435f, 0.860188f, 0.295330f, 0.863582f, 0.408664f, 
		0.0522225f, 0.911552f, 0.407855f, -0.304729f, 0.931442f, 0.198887f, 
		0.230448f, 0.819285f, -0.525038f, -0.524742f, 0.851257f, 0.00279424f, 
		0.969235f, -0.234338f, -0.0752958f, 0.969235f, -0.234338f, -0.0752958f, 
		0.972667f, -0.144427f, 0.181826f, 0.887949f, -0.0383444f, 0.458340f, 
		0.939203f, -0.289331f, -0.184892f, 0.960531f, -0.105484f, 0.257397f, 
		0.105134f, -0.651752f, -0.751110f, -0.0136716f, -0.650961f, -0.758988f, 
		-0.186982f, -0.669358f, -0.719025f, 0.329210f, -0.511548f, -0.793687f, 
		0.180300f, -0.548575f, -0.816430f, 0.863263f, -0.181927f, 0.470828f, 
		-0.107486f, 0.542183f, -0.833357f, 0.825114f, 0.500046f, 0.262947f, 
		0.0535271f, 0.0712939f, -0.996018f, 0.122726f, -0.790590f, 0.599922f, 
		0.303548f, -0.728468f, 0.614161f, 0.525542f, -0.615725f, 0.587102f, 
		-0.552440f, 0.531979f, -0.641724f, -0.547713f, 0.704194f, 0.451799f, 
		-0.540874f, 0.193621f, 0.818515f, -0.996018f, 0.00515407f, 0.0889990f, 
		-0.539891f, -0.447793f, 0.712740f, -0.690638f, 0.720331f, -0.0643557f, 
		-0.745196f, -0.237955f, -0.622945f, 0.499668f, -0.855446f, 0.136178f, 
		0.684750f, -0.726904f, -0.0522319f, 0.594457f, -0.794152f, 0.126267f, 
		0.784572f, -0.602515f, -0.146364f, 0.428769f, -0.870253f, 0.242520f, 
		0.0146222f, -0.124518f, -0.992110f, -0.953978f, -0.183025f, -0.237545f, 
		-0.953978f, -0.183025f, -0.237545f, 0.829504f, 0.552350f, -0.0826563f, 
		0.829504f, 0.552350f, -0.0826563f, -0.714285f, -0.618503f, 0.327492f, 
		-0.967919f, 0.155786f, -0.197137f, -0.983630f, 0.0819662f, -0.160479f, 
		-0.983630f, 0.0819662f, -0.160479f, -0.714285f, -0.618503f, 0.327492f, 
		-0.588038f, -0.697708f, 0.409163f, -0.967919f, 0.155786f, -0.197137f, 
		-0.956443f, -0.282765f, 0.0725348f, -0.983630f, 0.0819662f, -0.160479f, 
		-0.746116f, -0.588367f, -0.311665f, -0.944828f, 0.197320f, 0.261466f, 
		-0.404217f, 0.914370f, 0.0231392f, -0.404217f, 0.914370f, 0.0231392f, 
		-0.0710674f, -0.984098f, -0.162790f, -0.864853f, -0.501726f, -0.0173152f, 
		0.240440f, -0.695774f, 0.676822f, -0.600428f, 0.799472f, -0.0181973f, 
		-0.600428f, 0.799472f, -0.0181973f, 0.995309f, -0.0915962f, 0.0311501f, 
		0.484360f, -0.411082f, 0.772274f, -0.0150101f, 0.0638003f, 0.997850f, 
		0.267387f, 0.0680611f, -0.961183f, 0.267387f, 0.0680611f, -0.961183f, 
		-0.199495f, 0.791937f, -0.577094f, 0.176691f, 0.862432f, 0.474333f, 
		-0.537199f, -0.795290f, -0.280947f, -0.0914637f, 0.0775855f, 0.992781f, 
		0.213729f, 0.0899985f, 0.972739f, 0.316340f, 0.0806205f, 0.945214f, 
		0.192397f, -0.461636f, 0.865953f, 0.996322f, -0.0278502f, 0.0810391f, 
		0.595822f, 0.624817f, -0.504578f, -0.137656f, 0.981842f, -0.130529f, 
		0.156057f, 0.955766f, 0.249313f, 0.239294f, -0.846885f, 0.474894f, 
		0.0967768f, -0.868513f, 0.486127f, 0.172549f, -0.861287f, 0.477925f, 
		-0.530406f, -0.777614f, 0.337617f, -0.524947f, 0.847539f, -0.0781593f, 
		0.611680f, -0.471089f, -0.635549f, 0.757279f, -0.618643f, -0.209306f, 
		0.423452f, -0.392626f, -0.816415f, 0.652062f, -0.605566f, -0.456186f, 
		-0.575261f, -0.807716f, -0.129113f, -0.974924f, 0.147344f, -0.166772f, 
		-0.575261f, -0.807716f, -0.129113f, -0.720481f, -0.683947f, -0.114561f, 
		-0.985096f, -0.102855f, -0.137862f, 0.985393f, 0.139095f, 0.0982537f, 
		0.556988f, -0.541753f, 0.629499f, -0.727013f, -0.608552f, 0.317987f, 
		-0.629581f, -0.440367f, 0.640082f, -0.579063f, 0.794272f, 0.183895f, 
		0.220931f, -0.685863f, 0.693384f, 0.962943f, 0.110682f, 0.245949f, 
		-0.0712655f, -0.991405f, 0.109713f, 0.111268f, -0.950379f, 0.290515f, 
		-0.484669f, -0.804191f, 0.344054f, -0.0424640f, -0.960251f, 0.275890f, 
		0.155425f, -0.903357f, 0.399736f, 0.130589f, -0.181802f, 0.974625f, 
		0.963934f, -0.266118f, 0.00352132f, 0.960734f, -0.149652f, 0.233653f, 
		0.903521f, -0.248160f, 0.349381f, 0.737745f, -0.337173f, 0.584848f, 
		0.650891f, -0.315371f, 0.690566f, 0.802408f, -0.295780f, 0.518319f, 
		-0.862752f, -0.302701f, 0.405008f, -0.724036f, -0.385236f, 0.572158f, 
		-0.795827f, -0.330359f, 0.507466f, -0.768747f, -0.423134f, 0.479568f, 
		-0.997013f, -0.0436488f, 0.0637242f, -0.894337f, -0.300593f, 0.331369f, 
		-0.768747f, -0.423134f, 0.479568f, -0.997013f, -0.0436488f, 0.0637242f, 
		-0.944373f, 0.175497f, -0.278138f, -0.944373f, 0.175497f, -0.278138f, 
		-0.473848f, 0.742640f, 0.473237f, 0.952121f, -0.261906f, 0.157703f, 
		0.660612f, -0.403456f, -0.633099f, 0.832656f, -0.420585f, -0.360267f, 
		0.924853f, -0.210375f, 0.316843f, 0.372556f, 0.287995f, 0.882191f, 
		0.203776f, 0.149056f, 0.967604f, -0.972381f, -0.152215f, 0.176932f, 
		0.763304f, 0.643075f, -0.0618261f, 0.753251f, 0.640358f, -0.150182f, 
		0.696015f, 0.692701f, 0.189022f, 0.763304f, 0.643075f, -0.0618261f, 
		-0.546052f, -0.834979f, -0.0681049f, -0.986187f, -0.159392f, -0.0450426f, 
		0.887063f, -0.440749f, -0.137329f, 0.445645f, -0.269947f, 0.853539f, 
		-0.509623f, -0.781995f, 0.358843f, -0.0118534f, -0.287795f, 0.957619f, 
		-0.766053f, -0.599203f, 0.232634f, -0.0118534f, -0.287795f, 0.957619f, 
		-0.766053f, -0.599203f, 0.232634f, -0.317398f, 0.223607f, -0.921552f, 
		-0.814524f, 0.576874f, -0.0613759f, -0.224098f, 0.415329f, -0.881636f, 
		-0.292161f, 0.305971f, -0.906103f, 0.815397f, -0.534230f, 0.222992f, 
		0.906917f, -0.419172f, -0.0423830f, 0.938198f, -0.332340f, 0.0966193f, 
		0.777221f, -0.460227f, 0.429091f, 0.651296f, -0.568234f, 0.502915f, 
		-0.782118f, -0.374628f, -0.497941f, -0.438581f, -0.114813f, -0.891327f, 
		-0.258966f, 0.180444f, -0.948882f, 0.313188f, -0.217841f, 0.924369f, 
		-0.422909f, -0.297054f, -0.856100f, 0.313188f, -0.217841f, 0.924369f, 
		0.253980f, 0.0334589f, 0.966631f, -0.625215f, 0.773720f, -0.102296f, 
		-0.551723f, 0.576933f, 0.602287f, -0.551723f, 0.576933f, 0.602287f, 
		-0.639398f, 0.550952f, 0.536304f, -0.857733f, 0.337393f, 0.387892f, 
		-0.639398f, 0.550952f, 0.536304f, 0.256001f, 0.894510f, -0.366490f, 
		0.355138f, 0.887490f, -0.293665f, 0.186133f, 0.813197f, -0.551420f, 
		0.000906035f, 0.765990f, -0.642852f, 0.355138f, 0.887490f, -0.293665f, 
		-0.0725189f, 0.675154f, -0.734103f, -0.632854f, -0.381576f, -0.673718f, 
		-0.517231f, -0.563363f, -0.644277f, 0.196869f, -0.887997f, -0.415576f, 
		0.0185242f, -0.846812f, -0.531569f, -0.948625f, 0.253133f, -0.189826f, 
		-0.948625f, 0.253133f, -0.189826f, -0.948625f, 0.253133f, -0.189826f, 
		-0.221253f, -0.827190f, -0.516530f, 0.542843f, -0.837182f, -0.0666831f, 
		0.743150f, -0.661231f, -0.102472f, 0.934292f, -0.300781f, -0.191387f, 
		0.542843f, -0.837182f, -0.0666831f, -0.290886f, -0.778953f, -0.555534f, 
		-0.290886f, -0.778953f, -0.555534f, -0.226168f, 0.770879f, -0.595478f, 
		0.328134f, 0.287585f, -0.899791f, 0.155576f, 0.148513f, -0.976596f, 
		-0.979970f, -0.152279f, -0.128338f, 0.766180f, 0.641602f, 0.0362778f, 
		0.759678f, 0.637605f, 0.127865f, 0.691059f, 0.688721f, -0.219320f, 
		0.766180f, 0.641602f, 0.0362778f, -0.844060f, -0.534195f, -0.0468837f, 
		0.816664f, -0.384076f, -0.430750f, 0.807440f, -0.263908f, -0.527630f, 
		0.373859f, 0.353772f, -0.857365f, 0.514856f, 0.261692f, -0.816358f, 
		0.560302f, 0.141006f, -0.816198f, 0.792944f, -0.160639f, -0.587737f, 
		0.976097f, -0.130684f, 0.173653f, 0.751763f, 0.482139f, -0.449883f, 
		0.857561f, 0.323055f, -0.400280f, 0.857561f, 0.323055f, -0.400280f, 
		0.832910f, -0.455139f, -0.314815f, 0.968226f, -0.0226731f, -0.249047f, 
		-0.716578f, -0.623247f, 0.313177f, -0.716578f, -0.623247f, 0.313177f, 
		0.629029f, 0.616606f, 0.473413f, -0.0848139f, 0.478596f, 0.873929f, 
		0.410349f, -0.234426f, 0.881282f, -0.933716f, 0.0399295f, 0.355780f, 
		-0.483661f, 0.842817f, 0.236077f, -0.732261f, -0.645943f, 0.215759f, 
		0.782569f, -0.512314f, 0.353723f, 0.0206993f, 0.767517f, 0.640695f, 
		0.192706f, 0.471783f, 0.860398f, -0.863077f, 0.218023f, 0.455592f, 
		-0.434098f, 0.769405f, 0.468587f, 0.175218f, 0.240987f, 0.954580f, 
		-0.772043f, 0.455700f, 0.443043f, -0.306654f, 0.762498f, -0.569702f, 
		-0.306654f, 0.762498f, -0.569702f, -0.0291466f, -0.670097f, -0.741701f, 
		0.295026f, -0.735299f, -0.610160f, -0.374808f, -0.918092f, 0.128946f, 
		-0.322374f, 0.0498854f, -0.945297f, -0.00250421f, 0.208919f, -0.977930f, 
		0.0796864f, 0.250875f, -0.964734f, -0.199281f, 0.925060f, -0.323345f, 
		0.0583162f, 0.884172f, -0.463507f, -0.141631f, 0.819814f, -0.554838f, 
		0.0200855f, 0.813469f, -0.581261f, 0.347427f, 0.937463f, 0.0214059f, 
		0.433066f, 0.898839f, -0.0673992f, 0.162180f, 0.983911f, 0.0749413f, 
		-0.112756f, 0.973421f, 0.199342f, 0.214645f, 0.976667f, 0.00696241f, 
		-0.0658625f, -0.848514f, -0.525058f, -0.332711f, -0.687928f, -0.645026f, 
		-0.512833f, -0.521119f, -0.682230f, -0.908803f, 0.238025f, 0.342669f, 
		-0.331771f, 0.938383f, 0.0967772f, -0.418221f, -0.683185f, 0.598622f, 
		-0.565498f, -0.524865f, 0.636183f, -0.418221f, -0.683185f, 0.598622f, 
		-0.297087f, -0.806218f, 0.511616f, 0.943713f, -0.136825f, -0.301140f, 
		0.713689f, 0.124803f, -0.689255f, 0.800873f, 0.00731500f, -0.598790f, 
		0.965800f, -0.259188f, -0.00718050f, -0.733226f, -0.396233f, 0.552612f, 
		-0.405029f, -0.680812f, 0.610284f, -0.836971f, -0.186598f, 0.514453f, 
		0.0400738f, 0.0854402f, 0.995537f, -0.189317f, -0.736935f, 0.648911f, 
		0.451986f, 0.430311f, 0.781372f, 0.420116f, 0.326016f, 0.846886f, 
		0.517427f, 0.611063f, 0.599059f, -0.462106f, -0.875150f, 0.143426f, 
		0.922107f, -0.239645f, -0.303792f, 0.944386f, 0.0205877f, -0.328194f, 
		0.930997f, 0.160142f, -0.328023f, 0.362127f, -0.897525f, -0.251622f, 
		0.259430f, 0.0444498f, 0.964738f, 0.808583f, -0.567754f, -0.154430f, 
		0.522590f, -0.830196f, -0.194098f, -0.268629f, -0.761623f, -0.589719f, 
		0.929651f, 0.362309f, -0.0669402f, -0.268629f, -0.761623f, -0.589719f, 
		-0.268629f, -0.761623f, -0.589719f, -0.268629f, -0.761623f, -0.589719f, 
		-0.431445f, 0.761811f, -0.483218f, 0.632667f, -0.387273f, -0.670635f, 
		0.419351f, -0.677426f, -0.604350f, 0.678776f, -0.724213f, -0.121568f, 
		0.523483f, -0.723895f, -0.449380f, 0.788519f, -0.587497f, 0.181894f, 
		0.337496f, -0.0342460f, 0.940704f, -0.421949f, 0.643952f, 0.638189f, 
		0.613677f, -0.685109f, 0.392461f, 0.458621f, -0.796706f, 0.393606f, 
		0.110934f, -0.930048f, 0.350291f, -0.220132f, -0.939698f, 0.261744f, 
		-0.418404f, -0.0964366f, -0.903127f, 0.822091f, 0.305462f, 0.480478f, 
		0.707523f, 0.0541917f, 0.704609f, 0.794234f, 0.135301f, 0.592356f, 
		0.805640f, 0.534498f, 0.255451f, 0.865260f, 0.399997f, 0.302204f, 
		0.930132f, -0.366042f, 0.0294584f, 0.961525f, -0.266517f, -0.0666261f, 
		0.752877f, -0.636538f, -0.167317f, 0.974666f, -0.213363f, 0.0671008f, 
		0.873773f, -0.439895f, -0.207395f, 0.754443f, -0.209632f, 0.621989f, 
		0.927687f, 0.151858f, 0.341080f, 0.682197f, -0.297779f, 0.667784f, 
		-0.422109f, -0.391813f, -0.817500f, -0.416129f, -0.258636f, 0.871748f, 
		0.100750f, -0.769688f, -0.630420f, -0.546314f, -0.836594f, 0.0406353f, 
		0.154142f, 0.910869f, -0.382830f, -0.429805f, 0.865506f, -0.257231f, 
		-0.147520f, 0.932533f, -0.329575f, 0.515376f, -0.666323f, 0.538889f, 
		0.902066f, -0.357702f, 0.241509f, -0.301916f, 0.672703f, 0.675512f, 
		-0.726700f, -0.686201f, 0.0321698f, -0.412292f, -0.910603f, -0.0285896f, 
		-0.0601323f, 0.983278f, -0.171895f, 0.0753084f, 0.980554f, -0.181227f, 
		0.0110888f, 0.985657f, -0.168397f, -0.0133960f, 0.989803f, 0.141810f, 
		-0.624506f, -0.549991f, -0.554529f, -0.624506f, -0.549991f, -0.554529f, 
		-0.730995f, -0.682376f, 0.00304132f, 0.475712f, -0.726171f, 0.496360f, 
		0.628294f, -0.467789f, 0.621627f, 0.608738f, -0.592716f, 0.527376f, 
		0.707799f, -0.330330f, 0.624421f, 0.709472f, -0.190947f, 0.678372f, 
		-0.272065f, -0.760228f, 0.589944f, 0.0478484f, -0.907709f, 0.416863f, 
		-0.376018f, -0.695969f, 0.611750f, 0.186280f, 0.529997f, -0.827286f, 
		0.466882f, 0.231026f, -0.853609f, -0.0761159f, 0.831957f, -0.549594f, 
		-0.0761159f, 0.831957f, -0.549594f, -0.170203f, 0.898092f, -0.405539f, 
		0.409367f, -0.0140833f, 0.912261f, 0.486425f, -0.865829f, -0.117177f, 
		0.425660f, -0.212732f, 0.879522f, 0.312411f, 0.822330f, -0.475576f, 
		0.352354f, 0.858510f, -0.372569f, 0.442431f, 0.833745f, -0.330339f, 
		0.467582f, 0.883710f, -0.0205742f, 0.249830f, 0.817230f, -0.519346f, 
		0.312411f, 0.822330f, -0.475576f, -0.391487f, 0.908672f, 0.145096f, 
		0.368664f, 0.588876f, 0.719244f, -0.716215f, -0.573609f, 0.397503f, 
		-0.716215f, -0.573609f, 0.397503f, -0.670647f, -0.619165f, 0.408494f, 
		-0.763946f, -0.510894f, 0.394174f, -0.860422f, -0.484435f, -0.158102f, 
		-0.569925f, -0.812855f, 0.120219f, 0.378435f, -0.925350f, -0.0226544f, 
		0.962589f, -0.235750f, -0.133581f, -0.0383137f, -0.274041f, 0.960954f, 
		-0.801964f, 0.470985f, -0.367460f, -0.729742f, 0.524241f, -0.438916f, 
		-0.671535f, 0.504285f, -0.542897f, -0.729742f, 0.524241f, -0.438916f, 
		-0.0293643f, 0.909264f, 0.415183f, -0.0413475f, 0.849266f, 0.526343f, 
		0.0436575f, 0.976948f, 0.208968f, 0.327296f, 0.943791f, -0.0462260f, 
		-0.0465874f, 0.987336f, -0.151646f, 0.0666205f, 0.995295f, -0.0703552f, 
		-0.0465874f, 0.987336f, -0.151646f, 0.646387f, -0.253822f, -0.719554f, 
		0.472043f, -0.513871f, 0.716318f, -0.868052f, 0.495221f, 0.0352346f, 
		-0.573161f, 0.819440f, 0.00229586f, -0.815284f, 0.512449f, 0.269644f, 
		-0.592815f, 0.800725f, -0.0860788f, -0.400327f, 0.907345f, -0.128312f, 
		-0.377113f, 0.220178f, -0.899615f, -0.209383f, 0.977412f, 0.0287262f, 
		-0.109684f, 0.807468f, 0.579624f, -0.231068f, 0.952834f, -0.196762f, 
		-0.136195f, 0.668388f, 0.731238f, -0.382121f, -0.494603f, 0.780609f, 
		0.180171f, 0.886518f, -0.426175f, 0.868792f, -0.494645f, 0.0229604f, 
		0.468554f, -0.836444f, -0.284285f, 0.444598f, 0.543293f, -0.712155f, 
		0.650617f, -0.743292f, -0.155610f, 0.962842f, -0.252234f, 0.0965117f, 
		-0.0375412f, 0.520405f, -0.853094f, -0.781271f, 0.622949f, -0.0393777f, 
		-0.602914f, -0.396766f, -0.692150f, -0.784434f, 0.618670f, -0.0437039f, 
		0.0189644f, 0.410175f, -0.911810f, -0.359135f, -0.737167f, 0.572370f, 
		0.933691f, -0.0593274f, -0.353131f, 0.841727f, 0.0731712f, -0.534923f, 
		0.896524f, 0.0493229f, -0.440241f, 0.683297f, 0.275039f, -0.676357f, 
		0.933691f, -0.0593274f, -0.353131f, 0.961824f, -0.0821281f, -0.261053f, 
		-0.370226f, -0.655146f, -0.658571f, -0.605020f, -0.590021f, 0.534627f, 
		0.415429f, -0.463063f, 0.782938f, 0.309795f, -0.249124f, 0.917586f, 
		0.363691f, -0.312566f, 0.877514f, 0.306729f, -0.0260109f, 0.951441f, 
		-0.326575f, 0.511797f, 0.794615f, 0.652672f, -0.0946090f, -0.751710f, 
		0.158087f, 0.885516f, 0.436887f, 0.547954f, -0.627215f, 0.553487f, 
		-0.694743f, 0.529116f, -0.487204f, -0.694743f, 0.529116f, -0.487204f, 
		0.261692f, -0.570354f, -0.778597f, 0.261692f, -0.570354f, -0.778597f, 
		0.925141f, -0.135615f, 0.354573f, 0.680697f, 0.346142f, -0.645630f, 
		-0.358437f, -0.0689885f, 0.931001f, 0.293002f, 0.473314f, 0.830737f, 
		0.278621f, 0.721981f, 0.633335f, 0.126923f, 0.984965f, 0.117192f, 
		0.0406478f, 0.996525f, -0.0727073f, -0.576892f, -0.323202f, 0.750157f, 
		-0.218606f, -0.783866f, -0.581177f, -0.771742f, -0.146723f, 0.618778f, 
		-0.238613f, 0.851729f, 0.466500f, -0.238613f, 0.851729f, 0.466500f, 
		-0.108634f, -0.368678f, -0.923187f, -0.276978f, -0.345073f, 0.896776f, 
		-0.0383137f, -0.274041f, 0.960954f, -0.127081f, -0.546362f, -0.827852f, 
		-0.108634f, -0.368678f, -0.923187f, 0.929651f, 0.362309f, -0.0669402f, 
		0.523048f, 0.168140f, -0.835554f, 0.972024f, 0.0620425f, -0.226539f, 
		0.961242f, -0.0757326f, -0.265102f, 0.878183f, -0.301806f, -0.371091f, 
		0.961242f, -0.0757326f, -0.265102f, 0.972024f, 0.0620425f, -0.226539f, 
		-0.849654f, 0.526990f, 0.0192104f, -0.319153f, -0.946075f, 0.0555334f, 
		-0.388781f, -0.528153f, 0.754920f, 0.872471f, -0.418168f, -0.252843f, 
		-0.388781f, -0.528153f, 0.754920f, 0.737863f, 0.641608f, 0.209518f, 
		0.737891f, 0.642003f, -0.208204f, 0.773292f, 0.634031f, 0.00483712f, 
		0.377933f, 0.649880f, 0.659411f, -0.0768242f, 0.983649f, -0.162888f, 
		-0.290259f, -0.819147f, 0.494721f, 0.141054f, -0.292107f, 0.945927f, 
		-0.126929f, -0.671142f, 0.730382f, 0.0326341f, -0.507686f, 0.860924f, 
		0.106483f, -0.161572f, -0.981099f, -0.176691f, 0.969319f, -0.170883f, 
		-0.176691f, 0.969319f, -0.170883f, -0.669436f, -0.629532f, -0.394392f, 
		0.0684389f, -0.962546f, 0.262340f, -0.182692f, -0.910085f, 0.371979f, 
		0.215207f, -0.965847f, 0.144314f, 0.438507f, 0.742008f, -0.507086f, 
		0.473419f, 0.683295f, 0.555862f, 0.473419f, 0.683295f, 0.555862f, 
		-0.916335f, 0.0723061f, 0.393830f, -0.917941f, -0.0619293f, 0.391853f, 
		-0.918180f, 0.00569319f, 0.396122f, 0.903333f, 0.418007f, -0.0962236f, 
		-0.284699f, 0.794327f, 0.536648f, 0.903333f, 0.418007f, -0.0962236f, 
		0.903333f, 0.418007f, -0.0962236f, -0.237136f, -0.665313f, -0.707902f, 
		0.989954f, 0.0958567f, 0.103936f, -0.886589f, 0.398178f, -0.235402f, 
		-0.442264f, -0.700550f, -0.560029f, -0.442264f, -0.700550f, -0.560029f, 
		-0.886589f, 0.398178f, -0.235402f, -0.442264f, -0.700550f, -0.560029f, 
		-0.685714f, -0.693590f, -0.220749f, 0.616317f, 0.728660f, -0.298678f, 
		0.749681f, 0.585642f, -0.308223f, 0.538468f, 0.799794f, -0.265295f, 
		0.689664f, 0.658107f, -0.302092f, 0.887627f, 0.342676f, -0.307721f, 
		0.331697f, -0.393537f, 0.857383f, 0.961958f, -0.100311f, -0.254114f, 
		-0.399828f, 0.708523f, 0.581491f, 0.961958f, -0.100311f, -0.254114f, 
		-0.399828f, 0.708523f, 0.581491f, -0.492061f, -0.670960f, -0.554697f, 
		-0.492061f, -0.670960f, -0.554697f, 0.757723f, 0.146537f, -0.635911f, 
		0.144848f, 0.706697f, -0.692530f, -0.333606f, -0.877141f, 0.345443f, 
		-0.581102f, -0.724415f, 0.370870f, -0.692432f, -0.613887f, 0.379052f, 
		0.455053f, 0.694588f, 0.557202f, 0.455053f, 0.694588f, 0.557202f, 
		0.378594f, 0.611087f, 0.695155f, 0.208551f, -0.0346109f, 0.977399f, 
		0.243805f, 0.212345f, 0.946292f, -0.689129f, -0.721108f, 0.0714505f, 
		-0.317603f, -0.00768025f, 0.948193f, 0.00121161f, 0.170552f, 0.985348f, 
		-0.0916706f, 0.146560f, 0.984945f, 0.0847495f, 0.219958f, 0.971821f, 
		0.188206f, 0.239994f, 0.952356f, -0.328279f, 0.333704f, 0.883671f, 
		0.691336f, -0.688109f, 0.220363f, -0.355137f, -0.922975f, 0.148305f, 
		-0.296168f, 0.119402f, 0.947643f, 0.906812f, 0.318519f, -0.276112f, 
		0.915268f, 0.0219275f, -0.402248f, 0.822277f, 0.511350f, -0.249763f, 
		0.300653f, 0.867309f, 0.396715f, 0.793738f, -0.491771f, 0.357968f, 
		0.486485f, -0.871902f, 0.0558411f, 0.573568f, -0.786355f, -0.229488f, 
		-0.412459f, -0.893895f, 0.175583f, -0.768637f, 0.623091f, 0.144756f, 
		-0.768637f, 0.623091f, 0.144756f, -0.313506f, 0.562663f, -0.764934f, 
		-0.511958f, -0.475001f, -0.715732f, 0.713285f, -0.528961f, -0.459810f, 
		0.429951f, -0.609253f, 0.666298f, 0.356015f, 0.804462f, 0.475494f, 
		0.588390f, 0.694124f, 0.414717f, 0.468426f, 0.739957f, 0.482743f, 
		0.445190f, 0.683072f, -0.578981f, 0.445190f, 0.683072f, -0.578981f, 
		0.326890f, -0.944722f, 0.0253459f, 0.218130f, -0.964906f, -0.146206f, 
		0.267085f, -0.962598f, 0.0455090f, 0.555755f, -0.768299f, 0.317572f, 
		0.338440f, -0.865788f, 0.368604f, -0.522148f, -0.817590f, 0.242710f, 
		0.390493f, -0.919459f, 0.0459394f, -0.0196048f, -0.999326f, -0.0310266f, 
		-0.281874f, 0.947912f, 0.148354f, -0.0196048f, -0.999326f, -0.0310266f, 
		-0.281874f, 0.947912f, 0.148354f, -0.464906f, -0.885303f, 0.0100238f, 
		-0.413653f, -0.908295f, -0.0623834f, -0.367051f, -0.923739f, -0.109456f, 
		0.426436f, 0.695717f, -0.578040f, 0.426436f, 0.695717f, -0.578040f, 
		0.343317f, 0.612091f, -0.712375f, 0.159662f, -0.0349630f, -0.986552f, 
		0.196394f, 0.211974f, -0.957338f, -0.558128f, -0.179914f, 0.810015f, 
		-0.766071f, 0.627697f, 0.138318f, -0.558128f, -0.179914f, 0.810015f, 
		-0.766071f, 0.627697f, 0.138318f, -0.874967f, -0.227714f, 0.427292f, 
		-0.951131f, 0.0190684f, 0.308197f, -0.955717f, 0.120705f, 0.268394f, 
		0.0483984f, 0.997235f, -0.0563827f, 0.176723f, 0.982837f, -0.0529215f, 
		-0.276180f, 0.952083f, 0.131385f, -0.739584f, -0.604950f, 0.295044f, 
		-0.571437f, -0.786998f, 0.232583f, -0.856805f, -0.370013f, 0.359133f, 
		0.382097f, -0.920297f, 0.0839967f, 0.592015f, -0.754141f, 0.284235f, 
		0.468505f, -0.859478f, 0.204453f, 0.992832f, 0.0401545f, 0.112571f, 
		0.993419f, 0.101807f, 0.0524707f, 0.938770f, -0.196443f, 0.283056f, 
		0.174915f, -0.964088f, 0.199846f, 0.992832f, 0.0401545f, 0.112571f, 
		0.968049f, -0.0936654f, 0.232612f, 0.982213f, 0.186490f, -0.0219078f, 
		0.982252f, 0.0292953f, -0.185264f, 0.982252f, 0.0292953f, -0.185264f, 
		0.982252f, 0.0292953f, -0.185264f, -0.400292f, -0.836046f, 0.375225f, 
		-0.881055f, 0.310558f, 0.356786f, -0.297965f, 0.952447f, 0.0637348f, 
		0.717741f, 0.681876f, -0.141041f, 0.0775098f, 0.405043f, -0.911006f, 
		0.644689f, -0.626158f, -0.438523f, 0.503397f, -0.717000f, -0.482184f, 
		0.299838f, -0.848527f, -0.436003f, -0.508490f, -0.448054f, -0.735313f, 
		0.0210353f, 0.451903f, -0.891819f, 0.411303f, 0.189637f, 0.891554f, 
		0.0240729f, -0.991801f, -0.125503f, 0.287075f, 0.695917f, 0.658246f, 
		0.396201f, -0.285481f, 0.872654f, -0.293223f, 0.504161f, -0.812307f, 
		-0.993931f, 0.0506074f, 0.0976707f, 0.785808f, 0.556412f, -0.270020f, 
		-0.00725882f, 0.980621f, 0.195781f, -0.303164f, 0.952347f, 0.0335639f, 
		-0.178547f, 0.975799f, 0.126242f, -0.287936f, 0.919867f, -0.266343f, 
		0.330441f, -0.313616f, 0.890199f, -0.544443f, -0.789604f, 0.283032f, 
		-0.160603f, 0.175658f, -0.971263f, -0.245032f, 0.0462723f, -0.968410f, 
		-0.434965f, -0.0900911f, -0.895929f, 0.0155302f, 0.285943f, -0.958121f, 
		-0.0633143f, 0.214168f, -0.974743f, 0.286322f, 0.947164f, -0.144569f, 
		0.309580f, -0.946911f, -0.0867160f, 0.566994f, -0.808215f, 0.159081f, 
		0.622005f, -0.748430f, 0.230138f, -0.405179f, 0.595670f, 0.693547f, 
		0.811276f, -0.238250f, -0.533918f, -0.433079f, -0.882074f, -0.185438f, 
		0.811276f, -0.238250f, -0.533918f, 0.811276f, -0.238250f, -0.533918f, 
		-0.433079f, -0.882074f, -0.185438f, -0.462402f, -0.250029f, -0.850688f, 
		-0.462402f, -0.250029f, -0.850688f, -0.610219f, -0.689643f, 0.389905f, 
		-0.984433f, -0.149509f, -0.0924013f, -0.275473f, -0.855273f, -0.438888f, 
		0.574349f, 0.190815f, -0.796061f, 0.574349f, 0.190815f, -0.796061f, 
		0.648168f, 0.692911f, -0.315837f, 0.777638f, 0.418623f, -0.469078f, 
		0.860906f, 0.108852f, -0.496982f, 0.648168f, 0.692911f, -0.315837f, 
		0.860906f, 0.108852f, -0.496982f, 0.641665f, -0.592532f, 0.487004f, 
		0.123779f, -0.712370f, 0.690803f, -0.229960f, 0.182778f, -0.955882f, 
		-0.381208f, -0.164947f, -0.909655f, 0.123779f, -0.712370f, 0.690803f, 
		-0.362624f, -0.361437f, -0.858992f, 0.123779f, -0.712370f, 0.690803f, 
		-0.362624f, -0.361437f, -0.858992f, 0.957872f, -0.264643f, 0.111559f, 
		0.786299f, -0.518827f, 0.335488f, 0.957872f, -0.264643f, 0.111559f, 
		0.607425f, -0.619945f, 0.496693f, 0.607425f, -0.619945f, 0.496693f, 
		-0.820078f, -0.562341f, -0.106045f, -0.750099f, -0.599755f, 0.278651f, 
		-0.797843f, -0.544423f, -0.258939f, -0.968365f, 0.244176f, -0.0514523f, 
		0.299186f, -0.953515f, 0.0360193f, -0.459723f, -0.795651f, 0.394455f, 
		0.586160f, -0.424439f, 0.690121f, -0.263807f, 0.887051f, 0.378874f, 
		-0.266741f, -0.934018f, 0.237611f, 0.955909f, 0.0764602f, 0.283536f, 
		0.955909f, 0.0764602f, 0.283536f, 0.271758f, -0.883536f, 0.381460f, 
		-0.974530f, 0.0787718f, -0.209967f, -0.848224f, 0.293026f, -0.441194f, 
		-0.697660f, -0.548844f, -0.460479f, 0.667917f, 0.171216f, -0.724273f, 
		0.553619f, -0.593608f, -0.584067f, 0.200746f, -0.193927f, -0.960257f, 
		0.404306f, 0.729808f, 0.551287f, 0.968029f, 0.160141f, 0.193067f, 
		0.409893f, 0.874093f, 0.260670f, 0.968029f, 0.160141f, 0.193067f, 
		0.409893f, 0.874093f, 0.260670f, 0.321476f, 0.0420747f, 0.945982f, 
		0.778955f, 0.270165f, -0.565898f, 0.657457f, 0.409468f, -0.632524f, 
		0.474656f, 0.815482f, -0.331196f, 0.293615f, 0.885302f, -0.360596f, 
		0.737523f, 0.467304f, -0.487532f, 0.393289f, 0.763651f, -0.512017f, 
		0.215657f, -0.217533f, -0.951931f, 0.541643f, -0.181548f, 0.820770f, 
		-0.517969f, -0.0762795f, 0.851992f, -0.517969f, -0.0762795f, 0.851992f, 
		0.541643f, -0.181548f, 0.820770f, 0.134360f, -0.893472f, 0.428551f, 
		0.00867642f, 0.748506f, -0.663071f, 0.939773f, 0.323280f, -0.110978f, 
		0.380334f, 0.921701f, -0.0762429f, 0.939773f, 0.323280f, -0.110978f, 
		0.380334f, 0.921701f, -0.0762429f, -0.967006f, -0.152214f, 0.204279f, 
		0.390992f, 0.762629f, 0.515289f, 0.620707f, 0.783029f, 0.0398584f, 
		0.714170f, 0.655538f, -0.245420f, 0.540939f, 0.806986f, 0.236978f, 
		0.650283f, -0.535798f, 0.538566f, 0.650283f, -0.535798f, 0.538566f, 
		0.650283f, -0.535798f, 0.538566f, 0.650283f, -0.535798f, 0.538566f, 
		-0.524438f, 0.585727f, -0.617971f, -0.750764f, 0.581869f, -0.312699f, 
		-0.665400f, 0.607564f, -0.433715f, -0.372525f, 0.538949f, -0.755486f, 
		-0.789900f, 0.582484f, -0.191756f, -0.0677413f, -0.647319f, -0.759203f, 
		-0.644214f, -0.263672f, -0.717959f, 0.182721f, 0.863364f, 0.470336f, 
		0.781942f, -0.169450f, 0.599878f, 0.913090f, 0.173472f, -0.369018f, 
		0.913090f, 0.173472f, -0.369018f, 0.913090f, 0.173472f, -0.369018f, 
		0.207341f, -0.977278f, 0.0440167f, 0.500817f, 0.797945f, -0.335359f, 
		0.369513f, -0.897209f, 0.241819f, -0.0196048f, -0.999326f, -0.0310266f, 
		0.500817f, 0.797945f, -0.335359f, -0.284699f, 0.794327f, 0.536648f, 
		0.0423483f, -0.823697f, 0.565446f, -0.508684f, -0.491730f, -0.706712f, 
		0.652178f, 0.675350f, -0.344335f, 0.652178f, 0.675350f, -0.344335f, 
		0.748808f, 0.585526f, -0.310558f, 0.467947f, 0.791840f, -0.392448f, 
		-0.940801f, -0.315768f, 0.123223f, -0.694483f, -0.424737f, -0.580769f, 
		0.883606f, 0.367129f, -0.290615f, 0.816619f, 0.497519f, -0.292589f, 
		0.750024f, 0.581352f, -0.315425f, 0.703282f, 0.629263f, -0.330791f, 
		0.631193f, 0.681035f, -0.371195f, 0.810930f, -0.494828f, 0.312309f, 
		0.810930f, -0.494828f, 0.312309f, 0.658680f, -0.309792f, 0.685689f, 
		0.658680f, -0.309792f, 0.685689f, 0.744915f, -0.429791f, 0.510276f, 
		0.916127f, -0.351862f, -0.192104f, 0.930297f, -0.222588f, -0.291552f, 
		0.930297f, -0.222588f, -0.291552f, 0.660761f, -0.749042f, 0.0482862f, 
		0.502479f, -0.857665f, 0.109206f, -0.280223f, -0.000598317f, -0.959935f, 
		-0.0260146f, -0.218316f, -0.975531f, 0.224903f, -0.394654f, -0.890880f, 
		0.293717f, 0.698652f, -0.652392f, -0.259557f, -0.618837f, 0.741398f, 
		-0.0241749f, -0.457365f, 0.888950f, -0.470274f, -0.750279f, 0.464675f, 
		0.625174f, -0.457522f, 0.632322f, 0.534573f, -0.167761f, 0.828304f, 
		0.465080f, 0.0577740f, 0.883381f, -0.946065f, 0.128071f, 0.297589f, 
		-0.281874f, 0.947912f, 0.148354f, -0.946065f, 0.128071f, 0.297589f, 
		-0.281874f, 0.947912f, 0.148354f, -0.429640f, 0.624516f, 0.652219f, 
		-0.429640f, 0.624516f, 0.652219f, -0.993852f, 0.110116f, -0.0115250f, 
		0.419094f, -0.823021f, 0.383402f, -0.354007f, 0.929310f, -0.105179f, 
		-0.514463f, -0.751793f, -0.412475f, 0.927970f, 0.0769460f, 0.364625f, 
		0.419094f, -0.823021f, 0.383402f, 0.419094f, -0.823021f, 0.383402f, 
		0.397611f, 0.807245f, 0.436189f, -0.924071f, -0.0275620f, 0.381227f, 
		0.251616f, 0.777379f, -0.576516f, 0.719441f, -0.312769f, 0.620146f, 
		0.614720f, -0.544777f, 0.570383f, 0.573559f, -0.672686f, 0.467465f, 
		-0.520707f, -0.486700f, 0.701418f, -0.0432028f, 0.331117f, 0.942600f, 
		-0.928407f, 0.182693f, 0.323547f, 0.851664f, 0.0953348f, -0.515345f, 
		0.854409f, 0.283290f, -0.435581f, 0.754763f, 0.655940f, -0.00866901f, 
		0.631978f, 0.770312f, 0.0849906f, -0.926922f, 0.341466f, 0.155617f, 
		-0.707382f, 0.706297f, 0.0274699f, -0.707382f, 0.706297f, 0.0274699f, 
		-0.249620f, 0.511758f, -0.822066f, 0.412719f, -0.746692f, 0.521646f, 
		0.322668f, -0.792958f, 0.516820f, 0.517044f, -0.679052f, 0.521108f, 
		0.322668f, -0.792958f, 0.516820f, 0.412719f, -0.746692f, 0.521646f, 
		0.412719f, -0.746692f, 0.521646f, 0.412719f, -0.746692f, 0.521646f, 
		-0.901389f, -0.238539f, -0.361381f, 0.389309f, -0.919028f, -0.0618556f, 
		-0.946065f, 0.128071f, 0.297589f, -0.433079f, -0.882074f, -0.185438f, 
		-0.771742f, -0.146723f, 0.618778f, -0.901475f, -0.0624387f, 0.428304f, 
		-0.433079f, -0.882074f, -0.185438f, 0.793440f, 0.582330f, -0.177047f, 
		0.833053f, 0.495759f, -0.245450f, 0.772536f, 0.535986f, 0.340451f, 
		0.903753f, 0.427980f, -0.00804711f, 0.653448f, 0.719587f, -0.234947f, 
		0.893098f, 0.372168f, -0.252720f, 0.705327f, 0.699688f, 0.113797f, 
		0.775466f, 0.602668f, 0.188265f, 0.115012f, 0.166150f, -0.979370f, 
		0.750004f, 0.660254f, 0.0394750f, 0.694860f, 0.375376f, 0.613402f, 
		-0.575615f, -0.779627f, 0.246676f, -0.908085f, -0.0472951f, -0.416106f, 
		-0.905239f, 0.319156f, -0.280505f, -0.496934f, -0.847378f, 0.187100f, 
		-0.903831f, -0.384030f, -0.188709f, 0.555458f, 0.174626f, -0.813002f, 
		0.269562f, -0.882319f, -0.385810f, 0.208595f, -0.486199f, -0.848586f, 
		0.300664f, -0.775556f, -0.555080f, 0.916262f, -0.256775f, -0.307458f, 
		0.596748f, 0.794633f, 0.111584f, 0.255914f, 0.912398f, -0.319433f, 
		0.151604f, 0.857217f, -0.492132f, -0.659459f, -0.296709f, -0.690708f, 
		0.709404f, 0.636739f, 0.302173f, -0.424607f, -0.314152f, 0.849128f, 
		-0.424607f, -0.314152f, 0.849128f, 0.333637f, -0.490457f, 0.805070f, 
		0.369551f, -0.620485f, 0.691686f, 0.425969f, -0.692170f, 0.582624f, 
		0.182721f, 0.863364f, 0.470336f, -0.939771f, 0.298851f, -0.165889f, 
		0.458962f, -0.521526f, 0.719280f, 0.621995f, -0.216267f, 0.752563f, 
		0.495946f, -0.405828f, 0.767686f, -0.572386f, -0.590141f, -0.569305f, 
		-0.572386f, -0.590141f, -0.569305f, -0.462293f, 0.728462f, 0.505597f, 
		0.402461f, 0.894430f, 0.194987f, -0.462293f, 0.728462f, 0.505597f, 
		0.402461f, 0.894430f, 0.194987f, 0.575400f, 0.725682f, -0.377226f, 
		0.575400f, 0.725682f, -0.377226f, 0.575400f, 0.725682f, -0.377226f, 
		0.575400f, 0.725682f, -0.377226f, -0.493906f, 0.515505f, 0.700222f, 
		-0.493906f, 0.515505f, 0.700222f, 0.351681f, -0.797464f, 0.490277f, 
		-0.493906f, 0.515505f, 0.700222f, 0.510982f, -0.773887f, 0.374162f, 
		0.293647f, 0.820759f, -0.490027f, 0.788836f, -0.0589542f, -0.611769f, 
		0.0800118f, -0.783607f, 0.616082f, 0.510982f, -0.773887f, 0.374162f, 
		0.0794782f, -0.995500f, -0.0516042f, -0.150713f, -0.984216f, 0.0927616f, 
		-0.0890481f, -0.994299f, -0.0586545f, 0.417792f, -0.289761f, 0.861097f, 
		0.871619f, 0.489171f, -0.0315003f, 0.853306f, 0.521371f, 0.00640281f, 
		0.176385f, -0.589145f, 0.788541f, 0.108157f, -0.543907f, -0.832146f, 
		0.871619f, 0.489171f, -0.0315003f, 0.871619f, 0.489171f, -0.0315003f, 
		0.881694f, 0.463586f, -0.0877731f, -0.863039f, -0.501185f, -0.0630571f, 
		0.261415f, -0.382217f, -0.886325f, 0.0410898f, 0.279636f, 0.959226f, 
		-0.940532f, 0.326508f, -0.0937631f, -0.972565f, 0.222824f, 0.0668394f, 
		-0.892901f, 0.449471f, 0.0265263f, -0.487065f, 0.0808742f, 0.869613f, 
		-0.500233f, 0.865659f, -0.0200668f, -0.270058f, 0.961810f, -0.0446116f, 
		-0.604896f, -0.756079f, 0.249891f, 0.630947f, 0.125362f, 0.765630f, 
		0.630947f, 0.125362f, 0.765630f, -0.593516f, -0.752100f, 0.286503f, 
		-0.880751f, 0.155269f, -0.447402f, 0.857368f, 0.319792f, 0.403303f, 
		0.878994f, 0.141603f, 0.455323f, 0.881087f, 0.402906f, 0.247694f, 
		0.757104f, 0.636928f, 0.145316f, 0.733997f, 0.679127f, -0.00583571f, 
		0.619151f, 0.781042f, -0.0813950f, -0.753179f, 0.657755f, -0.00900123f, 
		-0.169505f, 0.740363f, -0.650485f, -0.865955f, 0.495259f, -0.0695686f, 
		-0.866239f, 0.481917f, -0.131856f, -0.00177076f, -0.360254f, 0.932852f, 
		-0.860657f, -0.507697f, -0.0389000f, 0.257188f, -0.745613f, 0.614749f, 
		0.200957f, -0.612525f, 0.764480f, 0.170729f, -0.544239f, 0.821374f, 
		0.280089f, 0.777575f, 0.562962f, 0.699048f, -0.713848f, -0.0418565f, 
		-0.783003f, 0.509799f, 0.356385f, 0.518968f, -0.854383f, -0.0264956f, 
		0.390232f, -0.917462f, 0.0773455f, 0.908897f, -0.404838f, -0.100060f, 
		0.699155f, 0.588909f, -0.405423f, 0.918403f, 0.376163f, -0.122626f, 
		0.489164f, 0.872060f, 0.0151278f, 0.302640f, 0.948420f, -0.0943879f, 
		0.833511f, 0.526259f, 0.168260f, 0.440450f, 0.868093f, -0.228952f, 
		-0.872218f, -0.286738f, 0.396255f, 0.643482f, -0.662704f, 0.383086f, 
		0.0145206f, -0.931820f, -0.362631f, 0.643482f, -0.662704f, 0.383086f, 
		-0.154400f, 0.784813f, 0.600191f, 0.562060f, 0.171406f, 0.809141f, 
		-0.665632f, 0.741371f, 0.0854633f, 0.262519f, -0.633273f, 0.728045f, 
		0.262519f, -0.633273f, 0.728045f, 0.262519f, -0.633273f, 0.728045f, 
		0.262519f, -0.633273f, 0.728045f, -0.561763f, -0.803669f, 0.196311f, 
		-0.378980f, -0.897341f, -0.226170f, 0.801330f, 0.130265f, -0.583867f, 
		0.636419f, -0.403104f, -0.657631f, 0.515629f, -0.246598f, -0.820559f, 
		0.863975f, 0.232602f, -0.446591f, 0.857163f, 0.0601095f, -0.511526f, 
		0.151152f, 0.985763f, 0.0736568f, 0.370237f, 0.926087f, -0.0727204f, 
		-0.449203f, 0.866617f, 0.217236f, -0.449203f, 0.866617f, 0.217236f, 
		-0.257429f, 0.947064f, 0.191835f, 0.188770f, -0.0472554f, -0.980884f, 
		0.0957629f, 0.556600f, -0.825243f, 0.222962f, 0.505738f, -0.833377f, 
		0.00231755f, 0.641068f, -0.767481f, 0.655843f, 0.165908f, -0.736441f, 
		0.406366f, 0.315295f, -0.857587f, 0.552583f, 0.268138f, -0.789148f, 
		-0.147177f, -0.972605f, -0.179942f, 0.731735f, 0.308128f, -0.607965f, 
		-0.852202f, -0.522221f, -0.0322115f, -0.903474f, 0.383848f, -0.190775f, 
		-0.165391f, -0.363087f, 0.916959f, 0.462466f, -0.708888f, 0.532544f, 
		0.174811f, -0.688430f, 0.703921f, 0.409109f, -0.803733f, 0.432022f, 
		0.571335f, -0.720400f, 0.393193f, 0.148198f, -0.821748f, 0.550244f, 
		0.351182f, -0.936304f, 0.00233161f, 0.963199f, -0.253887f, -0.0882580f, 
		0.261415f, -0.382217f, -0.886325f, 0.0762442f, 0.455654f, 0.886886f, 
		0.801225f, -0.498359f, -0.331174f, -0.434344f, -0.899376f, -0.0496793f, 
		-0.783003f, 0.509799f, 0.356385f, -0.135964f, 0.990636f, -0.0124157f, 
		0.292457f, 0.948627f, -0.120733f, -0.851381f, 0.158012f, 0.500183f, 
		-0.581388f, -0.667582f, 0.465105f, -0.949522f, -0.0723657f, 0.305239f, 
		-0.908391f, -0.288175f, 0.302956f, -0.679137f, 0.00100314f, 0.734011f, 
		-0.878307f, -0.0347543f, 0.476832f, -0.328181f, -0.784905f, 0.525567f, 
		0.974764f, 0.223145f, -0.00642346f, 0.911830f, 0.408860f, -0.0374069f, 
		0.816257f, -0.405897f, 0.411062f, 0.956433f, -0.178170f, 0.231280f, 
		0.911830f, 0.408860f, -0.0374069f, 0.357205f, 0.933296f, -0.0369245f, 
		0.426753f, 0.562535f, 0.708122f, 0.449721f, 0.392982f, 0.802070f, 
		0.376408f, 0.903161f, 0.206440f, 0.754662f, 0.596779f, -0.272653f, 
		0.754662f, 0.596779f, -0.272653f, -0.290107f, 0.952860f, 0.0888578f, 
		-0.128010f, -0.125074f, -0.983855f, -0.527668f, -0.661929f, 0.532369f, 
		0.914926f, -0.0669642f, -0.398028f, 0.914926f, -0.0669642f, -0.398028f, 
		0.914926f, -0.0669642f, -0.398028f, -0.481198f, 0.487325f, -0.728672f, 
		-0.0767383f, 0.983297f, -0.165039f, -0.426810f, 0.900786f, -0.0801138f, 
		-0.601332f, 0.798999f, -0.000902951f, -0.123895f, -0.403761f, -0.906437f, 
		-0.910381f, 0.252234f, -0.328001f, -0.00771010f, 0.883197f, -0.468940f, 
		-0.0513921f, 0.912573f, -0.405671f, -0.161209f, 0.930432f, -0.329101f, 
		-0.826668f, 0.388708f, 0.406850f, -0.840391f, 0.139973f, 0.523594f, 
		0.132165f, 0.885411f, -0.445623f, 0.725806f, -0.522115f, -0.447886f, 
		0.832967f, -0.307542f, -0.459982f, 0.860021f, -0.155035f, -0.486136f, 
		-0.854419f, -0.518006f, -0.0404576f, -0.882799f, 0.396791f, -0.251443f, 
		0.0612541f, 0.842717f, 0.534860f, -0.875815f, 0.474594f, -0.0877990f, 
		-0.875815f, 0.474594f, -0.0877990f, 0.522315f, -0.250685f, 0.815073f, 
		0.185827f, 0.965281f, -0.183580f, -0.00700150f, 0.998682f, -0.0508479f, 
		-0.262022f, 0.962279f, 0.0732345f, 0.213516f, 0.932773f, -0.290423f, 
		0.0923957f, 0.984318f, -0.150267f, -0.828977f, -0.528252f, 0.183702f, 
		-0.518079f, -0.850585f, 0.0899974f, -0.0986683f, -0.871925f, 0.479595f, 
		0.367991f, 0.113339f, 0.922896f, -0.410789f, -0.885085f, 0.218808f, 
		-0.410789f, -0.885085f, 0.218808f, 0.458943f, -0.872109f, 0.169699f, 
		0.122135f, -0.787640f, 0.603909f, 0.295932f, -0.810928f, 0.504797f, 
		0.450871f, -0.892308f, -0.0224086f, 0.509749f, 0.600437f, 0.616142f, 
		0.665717f, 0.709724f, -0.230461f, -0.120085f, -0.645616f, 0.754162f, 
		0.610761f, 0.0332077f, 0.791119f, -0.376589f, -0.917290f, 0.129458f, 
		0.904155f, 0.230340f, -0.359787f, 0.904155f, 0.230340f, -0.359787f, 
		0.756199f, 0.565092f, -0.329900f, 0.538790f, 0.802185f, -0.257303f, 
		0.538790f, 0.802185f, -0.257303f, 0.757547f, -0.0355965f, -0.651809f, 
		-0.838619f, -0.0237587f, -0.544201f, 0.389373f, 0.671612f, -0.630338f, 
		-0.838619f, -0.0237587f, -0.544201f, 0.354757f, 0.159277f, 0.921292f, 
		0.904224f, 0.238688f, -0.354128f, 0.947702f, 0.0768966f, -0.309754f, 
		0.968443f, 0.00276565f, -0.249219f, 0.860171f, -0.297646f, -0.414142f, 
		0.340917f, -0.921276f, -0.187152f, 0.446518f, 0.893833f, 0.0410485f, 
		0.676814f, 0.580611f, 0.452564f, 0.661118f, 0.435152f, 0.611200f, 
		0.287975f, 0.954465f, -0.0778923f, 0.739764f, 0.627004f, -0.244165f, 
		0.739764f, 0.627004f, -0.244165f, 0.739764f, 0.627004f, -0.244165f, 
		0.739764f, 0.627004f, -0.244165f, -0.824557f, -0.00512081f, 0.565755f, 
		-0.204942f, -0.671065f, 0.712510f, -0.824557f, -0.00512081f, 0.565755f, 
		-0.824557f, -0.00512081f, 0.565755f, 0.0547020f, 0.962949f, -0.264077f, 
		0.0547020f, 0.962949f, -0.264077f, -0.525345f, 0.660758f, 0.536108f, 
		-0.707731f, 0.261754f, 0.656203f, -0.416272f, 0.808181f, 0.416607f, 
		-0.811186f, 0.0139651f, 0.584622f, -0.748598f, -0.416284f, 0.516052f, 
		-0.550078f, -0.677930f, 0.487673f, -0.807588f, -0.354697f, 0.471161f, 
		-0.748598f, -0.416284f, 0.516052f, -0.292409f, -0.368811f, -0.882312f, 
		-0.0872842f, 0.161320f, -0.983035f, -0.373110f, 0.239790f, 0.896264f, 
		0.551384f, 0.158931f, 0.818973f, -0.772593f, 0.624020f, 0.117039f, 
		0.391063f, 0.917389f, -0.0739408f, 0.433200f, 0.885096f, 0.170126f, 
		0.362700f, 0.830087f, 0.423561f, 0.395977f, 0.916685f, 0.0537762f, 
		0.337597f, 0.918891f, -0.204125f, -0.0988109f, -0.719476f, -0.687452f, 
		-0.523553f, 0.523663f, -0.672063f, -0.563821f, 0.666394f, -0.487877f, 
		-0.585539f, 0.735023f, -0.341885f, 0.199765f, 0.937139f, -0.286120f, 
		0.764486f, -0.262660f, -0.588702f, -0.523598f, 0.754178f, 0.396309f, 
		-0.711389f, 0.494320f, 0.499573f, -0.627303f, 0.566817f, 0.534050f, 
		-0.279692f, 0.899757f, 0.334976f, -0.461892f, 0.799118f, 0.384793f, 
		-0.504016f, -0.468219f, -0.725767f, -0.504016f, -0.468219f, -0.725767f, 
		0.167125f, 0.815889f, 0.553529f, 0.0886525f, 0.952442f, 0.291538f, 
		0.0334419f, 0.997544f, 0.0615455f, -0.132584f, 0.980695f, -0.143730f, 
		0.757547f, -0.0355965f, -0.651809f, 0.00439651f, 0.0931463f, 0.995643f, 
		-0.932669f, 0.289811f, -0.214799f, -0.744297f, 0.637588f, -0.198755f, 
		-0.361817f, 0.893676f, -0.265390f, -0.545701f, 0.803123f, -0.239173f, 
		0.824600f, 0.553004f, -0.119254f, 0.866152f, 0.495777f, 0.0631265f, 
		0.773774f, 0.328949f, 0.541356f, 0.596792f, 0.295396f, 0.746043f, 
		0.783675f, 0.596372f, -0.173764f, 0.920321f, 0.371288f, -0.123103f, 
		0.931129f, 0.294818f, 0.214664f, 0.727933f, 0.669788f, -0.146619f, 
		0.998877f, -0.0466266f, -0.00846570f, 0.934980f, -0.353454f, 0.0297137f, 
		0.977346f, 0.197780f, -0.0753495f, -0.793922f, 0.585557f, 0.163737f, 
		-0.0220676f, -0.628425f, 0.777557f, 0.538608f, -0.837384f, -0.0932208f, 
		-0.238262f, -0.971031f, 0.0181603f, 0.128354f, -0.991524f, -0.0201146f, 
		0.128354f, -0.991524f, -0.0201146f, -0.0664799f, -0.997505f, 0.0237678f, 
		0.276529f, -0.936417f, -0.215996f, 0.0948491f, 0.347569f, 0.932845f, 
		0.234370f, 0.458129f, 0.857432f, 0.350286f, 0.480433f, 0.804042f, 
		0.368409f, 0.401701f, 0.838398f, 0.637764f, 0.205941f, 0.742190f, 
		0.483711f, 0.403288f, 0.776777f, 0.792998f, -0.552635f, 0.256415f, 
		-0.770032f, 0.542011f, -0.336563f, -0.0753504f, -0.647466f, -0.758360f, 
		-0.829996f, 0.555778f, -0.0470898f, 0.503483f, -0.861313f, 0.0681594f, 
		-0.00521947f, -0.0948568f, 0.995477f, 0.503483f, -0.861313f, 0.0681594f, 
		-0.0739513f, 0.611968f, 0.787418f, 0.590409f, 0.597616f, 0.542469f, 
		0.440833f, -0.344544f, 0.828828f, -0.786333f, -0.103596f, 0.609055f, 
		0.995133f, 0.0244064f, -0.0954720f, 0.949060f, 0.00421161f, -0.315068f, 
		0.0410898f, 0.279636f, 0.959226f, -0.659459f, -0.296709f, -0.690708f, 
		-0.783003f, 0.509799f, 0.356385f, 0.997539f, 0.0388767f, 0.0583509f, 
		-0.599562f, 0.774062f, -0.203357f, -0.849355f, 0.511778f, -0.129146f, 
		-0.772440f, 0.613387f, -0.164598f, -0.772440f, 0.613387f, -0.164598f, 
		-0.481387f, -0.875806f, 0.0350844f, -0.481387f, -0.875806f, 0.0350844f, 
		-0.679137f, 0.00100314f, 0.734011f, 0.0879656f, 0.990569f, 0.105046f, 
		0.998669f, 0.0384700f, 0.0343640f, -0.542908f, -0.761451f, 0.354180f, 
		0.152421f, -0.693168f, 0.704476f, -0.542908f, -0.761451f, 0.354180f, 
		-0.618066f, -0.742456f, 0.258367f, -0.542908f, -0.761451f, 0.354180f, 
		-0.339772f, -0.789663f, 0.510870f, -0.0669509f, -0.137048f, 0.988299f, 
		-0.173651f, 0.212080f, -0.961700f, -0.681671f, -0.356819f, -0.638753f, 
		-0.613526f, -0.232090f, -0.754798f, -0.0306369f, 0.275785f, -0.960731f, 
		0.768060f, -0.0228491f, -0.639970f, 0.553905f, -0.664676f, -0.501393f, 
		0.687342f, -0.375148f, -0.621953f, 0.623777f, -0.505617f, -0.596032f, 
		0.783815f, -0.143164f, -0.604266f, 0.798849f, 0.145022f, -0.583788f, 
		0.855765f, 0.502232f, -0.124215f, 0.737806f, 0.324719f, -0.591776f, 
		0.558694f, 0.295251f, -0.775040f, 0.825286f, 0.562103f, 0.0542586f, 
		0.921156f, 0.387086f, 0.0404536f, 0.920957f, 0.346264f, -0.178716f, 
		0.739310f, 0.667318f, 0.0900419f, -0.485815f, -0.872937f, -0.0443243f, 
		0.261415f, -0.382217f, -0.886325f, -0.485815f, -0.872937f, -0.0443243f, 
		-0.889277f, 0.457368f, -0.000918502f, 0.209203f, -0.950340f, -0.230409f, 
		0.515310f, -0.431373f, 0.740522f, -0.572756f, -0.696180f, -0.432765f, 
		0.275569f, -0.928465f, 0.249028f, -0.829334f, -0.0789297f, 0.553151f, 
		0.145550f, -0.891200f, 0.429626f, 0.991899f, -0.0411565f, 0.120173f, 
		0.210416f, -0.904813f, 0.370188f, -0.757489f, -0.538532f, 0.369044f, 
		-0.573776f, -0.797608f, 0.186020f, -0.339585f, 0.878740f, -0.335407f, 
		-0.559118f, 0.767636f, -0.313243f, -0.616888f, 0.728591f, -0.297663f, 
		0.291838f, -0.457894f, 0.839740f, 0.177208f, -0.319027f, 0.931031f, 
		0.0370111f, -0.258531f, 0.965294f, 0.416167f, -0.600481f, 0.682809f, 
		0.368744f, -0.509236f, 0.777629f, -0.802610f, 0.307385f, 0.511206f, 
		-0.641914f, 0.625583f, 0.443388f, -0.869235f, 0.197867f, 0.453078f, 
		-0.854643f, 0.0812346f, 0.512822f, -0.789805f, 0.384205f, 0.478115f, 
		0.0873197f, 0.499049f, -0.862163f, 0.549228f, 0.258096f, -0.794817f, 
		-0.0279691f, 0.546593f, -0.836931f, 0.553547f, -0.600321f, 0.577235f, 
		0.656152f, -0.665327f, 0.356097f, 0.595743f, -0.652134f, 0.468840f, 
		0.595743f, -0.652134f, 0.468840f, 0.791709f, 0.326542f, 0.516301f, 
		0.529752f, -0.829167f, -0.178453f, 0.681779f, -0.679455f, -0.271145f, 
		0.884007f, -0.286911f, -0.369072f, -0.179202f, 0.797962f, 0.575450f, 
		0.638685f, 0.379067f, 0.669619f, 0.462825f, 0.680142f, 0.568506f, 
		0.144729f, 0.673508f, 0.724873f, -0.0347418f, 0.622310f, 0.782000f, 
		0.0491140f, 0.680757f, 0.730861f, 0.189899f, 0.740884f, 0.644228f, 
		0.779282f, -0.379652f, -0.498582f, 0.0382183f, 0.503886f, -0.862924f, 
		-0.694972f, -0.715211f, -0.0740704f, -0.344864f, -0.938620f, 0.00778780f, 
		-0.555278f, -0.831398f, -0.0210375f, -0.00886866f, -0.455478f, -0.890203f, 
		-0.0801459f, 0.732767f, -0.675743f, -0.762226f, 0.363372f, -0.535699f, 
		-0.370253f, -0.922325f, 0.110588f, 0.108495f, -0.705708f, 0.700147f, 
		0.0468653f, -0.632657f, 0.773012f, 0.108495f, -0.705708f, 0.700147f, 
		0.0617443f, -0.544730f, 0.836335f, -0.0193341f, -0.224055f, 0.974385f, 
		-0.191622f, -0.412879f, 0.890400f, 0.0468653f, -0.632657f, 0.773012f, 
		-0.573298f, -0.183560f, 0.798520f, 0.327146f, 0.944762f, -0.0200198f, 
		0.740949f, 0.612107f, -0.276261f, 0.148355f, 0.359864f, -0.921135f, 
		-0.308480f, 0.948442f, 0.0727800f, 0.693012f, 0.0611415f, -0.718329f, 
		0.506470f, 0.179250f, -0.843420f, -0.0899030f, 0.246435f, -0.964980f, 
		-0.274569f, 0.188194f, -0.942971f, 0.366676f, 0.426758f, 0.826696f, 
		0.453771f, -0.164537f, 0.875797f, 0.152421f, -0.693168f, 0.704476f, 
		-0.558744f, -0.829324f, -0.00509140f, -0.461940f, -0.877343f, -0.129926f, 
		-0.179659f, -0.726685f, 0.663062f, -0.559915f, -0.797826f, 0.223537f, 
		-0.558744f, -0.829324f, -0.00509140f, -0.751737f, -0.382494f, -0.537206f, 
		-0.754841f, -0.654338f, 0.0453476f, -0.754841f, -0.654338f, 0.0453476f, 
		0.482952f, 0.868324f, -0.113011f, 0.912469f, 0.407063f, 0.0412399f, 
		0.791078f, 0.604109f, 0.0961620f, 0.314803f, 0.920532f, -0.231343f, 
		0.374408f, -0.764146f, -0.525262f, 0.374408f, -0.764146f, -0.525262f, 
		-0.250659f, 0.896897f, -0.364343f, -0.882086f, 0.400949f, -0.247314f, 
		-0.638470f, -0.644740f, 0.420317f, 0.612119f, -0.350746f, 0.708722f, 
		0.0424774f, 0.0787314f, 0.995990f, -0.115972f, 0.972649f, 0.201255f, 
		-0.258413f, 0.927956f, 0.268553f, 0.0424774f, 0.0787314f, 0.995990f, 
		-0.115972f, 0.972649f, 0.201255f, -0.874177f, 0.0780764f, 0.479290f, 
		0.00562689f, 0.970325f, 0.241738f, -0.0303775f, 0.385425f, 0.922239f, 
		0.760321f, -0.523707f, 0.384244f, 0.812870f, -0.420529f, 0.402987f, 
		0.760321f, -0.523707f, 0.384244f, 0.635426f, -0.640186f, 0.431735f, 
		-0.0171011f, 0.842278f, -0.538772f, -0.176398f, 0.845089f, -0.504687f, 
		-0.0840456f, 0.870515f, -0.484911f, 0.701986f, 0.577033f, -0.417430f, 
		0.886881f, 0.172726f, -0.428495f, 0.567587f, 0.736902f, -0.367178f, 
		0.115012f, 0.166150f, -0.979370f, 0.668164f, 0.222000f, 0.710121f, 
		-0.0280043f, 0.127307f, 0.991468f, -0.742761f, -0.142460f, -0.654226f, 
		-0.811744f, -0.326910f, 0.483943f, -0.811744f, -0.326910f, 0.483943f, 
		0.698554f, -0.136528f, 0.702412f, -0.212453f, 0.807419f, 0.550398f, 
		0.665582f, -0.0765321f, 0.742391f, 0.683542f, -0.267553f, 0.679106f, 
		0.698554f, -0.136528f, 0.702412f, 0.636851f, 0.00320477f, -0.770980f, 
		0.805715f, 0.128170f, -0.578269f, 0.385084f, 0.771368f, -0.506657f, 
		0.438826f, -0.0878748f, -0.894265f, -0.803315f, -0.595542f, -0.00394445f, 
		-0.803315f, -0.595542f, -0.00394445f, -0.0225631f, 0.903173f, -0.428684f, 
		0.306671f, -0.431221f, 0.848529f, 0.544790f, -0.442255f, 0.712470f, 
		0.363433f, -0.483727f, 0.796194f, -0.478927f, -0.584762f, 0.654738f, 
		-0.105430f, -0.524193f, 0.845048f, 0.460858f, -0.405653f, 0.789339f, 
		-0.415968f, -0.0635978f, 0.907153f, -0.165352f, 0.0170025f, 0.986088f, 
		-0.683654f, -0.0661394f, 0.726803f, -0.837179f, -0.0241893f, 0.546393f, 
		-0.735752f, -0.576945f, -0.354687f, 0.586562f, -0.738736f, 0.331985f, 
		0.552792f, -0.542615f, 0.632448f, -0.700208f, 0.689427f, -0.185468f, 
		-0.728345f, 0.177819f, 0.661736f, 0.968667f, -0.244833f, 0.0417163f, 
		0.889017f, -0.447891f, 0.0950939f, 0.504825f, -0.833637f, 0.224055f, 
		0.326668f, -0.911114f, 0.251314f, 0.332132f, 0.925622f, -0.181415f, 
		0.142850f, 0.956823f, -0.253146f, -0.188095f, 0.715941f, 0.672345f, 
		0.215040f, 0.949444f, -0.228722f, 0.850168f, 0.000652654f, 0.526511f, 
		0.850168f, 0.000652654f, 0.526511f, -0.934457f, 0.100637f, 0.341558f, 
		-0.922838f, 0.242887f, 0.298959f, -0.921580f, 0.331032f, 0.202753f, 
		0.778033f, -0.272092f, -0.566242f, -0.270195f, -0.241247f, -0.932092f, 
		-0.344108f, -0.456030f, -0.820747f, -0.603193f, 0.784913f, 0.141672f, 
		-0.319663f, 0.935558f, 0.150158f, 0.0568351f, -0.562795f, -0.824640f, 
		-0.143795f, -0.456764f, -0.877889f, -0.466872f, 0.878712f, 0.0994812f, 
		0.0279028f, -0.893018f, 0.449156f, 0.119244f, -0.918873f, 0.376102f, 
		-0.141034f, -0.757364f, 0.637581f, -0.0637946f, -0.820648f, 0.567862f, 
		-0.00782892f, -0.855871f, 0.517131f, 0.0353330f, 0.465667f, -0.884254f, 
		0.749188f, 0.599243f, -0.282181f, 0.749188f, 0.599243f, -0.282181f, 
		0.0353330f, 0.465667f, -0.884254f, 0.233256f, -0.972392f, 0.00670631f, 
		-0.00570552f, 0.427370f, -0.904059f, 0.772622f, -0.276905f, 0.571296f, 
		0.106704f, 0.400059f, 0.910257f, -0.694711f, 0.432525f, 0.574716f, 
		0.684443f, 0.706954f, -0.178193f, 0.336100f, 0.914425f, -0.225531f, 
		0.840442f, 0.528712f, -0.118836f, -0.560571f, -0.788446f, 0.253205f, 
		0.00213747f, -0.995669f, 0.0929457f, -0.343076f, -0.851066f, 0.397474f, 
		-0.712219f, -0.424913f, 0.558742f, 0.431713f, 0.890591f, -0.143077f, 
		0.268230f, 0.950863f, -0.154636f, 0.431713f, 0.890591f, -0.143077f, 
		0.650694f, 0.757303f, -0.0555814f, 0.304095f, -0.0943200f, 0.947961f, 
		-0.423073f, -0.891367f, -0.162708f, -0.268229f, -0.959778f, -0.0829424f, 
		-0.340140f, -0.938992f, -0.0509787f, -0.406051f, -0.913850f, 0.000178833f, 
		-0.340140f, -0.938992f, -0.0509787f, -0.729831f, 0.113084f, -0.674210f, 
		0.00956743f, 0.967206f, 0.253813f, 0.351310f, -0.507708f, 0.786647f, 
		0.0128874f, -0.832343f, -0.554112f, 0.377372f, -0.901049f, -0.213777f, 
		0.668285f, 0.718516f, -0.192691f, 0.668285f, 0.718516f, -0.192691f, 
		-0.244576f, 0.967895f, 0.0579823f, 0.816839f, 0.0378007f, -0.575626f, 
		0.761455f, 0.242270f, -0.601241f, 0.675763f, 0.0374552f, -0.736167f, 
		0.398509f, 0.0541940f, -0.915562f, 0.626949f, 0.508806f, -0.589958f, 
		0.910366f, -0.0998276f, -0.401582f, 0.910366f, -0.0998276f, -0.401582f, 
		0.910366f, -0.0998276f, -0.401582f, 0.910366f, -0.0998276f, -0.401582f, 
		-0.529785f, -0.761591f, 0.373239f, -0.522553f, -0.850078f, 0.0656120f, 
		-0.496170f, -0.700094f, 0.513501f, 0.00814712f, -0.652671f, 0.757597f, 
		0.329190f, -0.531418f, 0.780531f, 0.899579f, 0.414516f, 0.137602f, 
		0.728026f, 0.668593f, -0.151531f, 0.846899f, 0.531699f, -0.00758650f, 
		-0.789950f, -0.288746f, 0.540930f, -0.789950f, -0.288746f, 0.540930f, 
		0.296052f, 0.635466f, 0.713117f, 0.296052f, 0.635466f, 0.713117f, 
		-0.139697f, -0.989958f, 0.0216114f, -0.354040f, -0.917266f, 0.182424f, 
		-0.213966f, -0.967537f, 0.134501f, -0.397617f, 0.917316f, -0.0207713f, 
		-0.216181f, 0.972539f, -0.0862198f, -0.287503f, 0.954693f, -0.0768358f, 
		0.0365744f, -0.859658f, -0.509559f, 0.375812f, -0.740931f, -0.556585f, 
		0.469115f, -0.682466f, -0.560510f, 0.469115f, -0.682466f, -0.560510f, 
		0.375812f, -0.740931f, -0.556585f, -0.442196f, 0.753833f, 0.486003f, 
		-0.584172f, 0.811355f, -0.0211163f, -0.873586f, 0.482657f, 0.0623675f, 
		-0.577470f, 0.771189f, 0.267948f, -0.442196f, 0.753833f, 0.486003f, 
		-0.696360f, -0.706807f, -0.124526f, 0.0264555f, 0.781031f, -0.623931f, 
		0.596997f, 0.682398f, 0.421816f, -0.710538f, 0.567996f, 0.415350f, 
		-0.416798f, 0.218378f, -0.882378f, 0.275087f, -0.871895f, -0.405124f, 
		0.448598f, -0.270449f, 0.851831f, 0.448598f, -0.270449f, 0.851831f, 
		-0.394074f, 0.878570f, -0.269853f, -0.944141f, 0.329125f, -0.0165449f, 
		-0.408633f, -0.912401f, 0.0233013f, -0.679039f, 0.628295f, 0.379672f, 
		0.878582f, 0.321870f, -0.352836f, 0.701182f, 0.683585f, -0.202619f, 
		0.837315f, 0.459064f, -0.296923f, 0.878582f, 0.321870f, -0.352836f, 
		0.837315f, 0.459064f, -0.296923f, -0.564452f, -0.800189f, 0.202713f, 
		-0.564452f, -0.800189f, 0.202713f, 0.282988f, -0.671547f, 0.684794f, 
		0.242851f, -0.694510f, 0.677259f, 0.282988f, -0.671547f, 0.684794f, 
		0.282988f, -0.671547f, 0.684794f, 0.332765f, -0.631210f, 0.700601f, 
		0.282988f, -0.671547f, 0.684794f, 0.139765f, 0.986704f, -0.0829491f, 
		0.139765f, 0.986704f, -0.0829491f, 0.139765f, 0.986704f, -0.0829491f, 
		0.139765f, 0.986704f, -0.0829491f, 0.548048f, 0.502879f, 0.668398f, 
		0.548057f, 0.348464f, 0.760399f, 0.548057f, 0.348464f, 0.760399f, 
		0.497751f, 0.189272f, 0.846416f, -0.550651f, -0.790391f, 0.268450f, 
		0.962190f, 0.0507144f, 0.267616f, 0.962190f, 0.0507144f, 0.267616f, 
		-0.0123479f, 0.0263709f, 0.999576f, -0.0123479f, 0.0263709f, 0.999576f, 
		0.299019f, -0.631397f, 0.715490f, 0.299019f, -0.631397f, 0.715490f, 
		0.565643f, 0.557155f, 0.607970f, -0.143684f, 0.265151f, 0.953441f, 
		0.0328535f, 0.416972f, -0.908325f, 0.743764f, 0.662930f, -0.0856710f, 
		0.0328535f, 0.416972f, -0.908325f, 0.725103f, -0.478289f, -0.495444f, 
		-0.195320f, -0.604247f, -0.772487f, -0.664967f, 0.746871f, 0.00183490f, 
		-0.502234f, -0.761537f, 0.409662f, 0.137064f, 0.984573f, -0.108762f, 
		0.137064f, 0.984573f, -0.108762f, 0.137064f, 0.984573f, -0.108762f, 
		0.491027f, -0.316395f, 0.811657f, 0.491027f, -0.316395f, 0.811657f, 
		0.491027f, -0.316395f, 0.811657f, 0.491027f, -0.316395f, 0.811657f, 
		-0.491543f, -0.545581f, 0.678769f, 0.102943f, -0.0574257f, 0.993028f, 
		0.409634f, 0.215380f, 0.886460f, 0.229579f, 0.0558434f, 0.971687f, 
		-0.179202f, 0.797962f, 0.575450f, 0.305564f, 0.0793731f, -0.948858f, 
		0.220049f, -0.576588f, 0.786845f, 0.756897f, -0.489112f, 0.433448f, 
		0.892346f, -0.375686f, 0.250155f, 0.465569f, -0.573708f, 0.673873f, 
		0.0574703f, 0.781264f, 0.621550f, 0.574590f, 0.684712f, -0.448349f, 
		0.665718f, -0.683438f, -0.299554f, 0.665718f, -0.683438f, -0.299554f, 
		0.589426f, -0.770610f, -0.242359f, 0.426783f, -0.889121f, -0.165286f, 
		0.426783f, -0.889121f, -0.165286f, 0.589426f, -0.770610f, -0.242359f, 
		0.921903f, 0.383574f, -0.0544571f, -0.583754f, -0.805388f, 0.102865f, 
		0.448452f, -0.601713f, 0.660932f, -0.583754f, -0.805388f, 0.102865f, 
		0.748135f, 0.204571f, -0.631224f, 0.748135f, 0.204571f, -0.631224f, 
		-0.631369f, -0.319358f, 0.706671f, 0.236266f, 0.961860f, -0.137857f, 
		0.146530f, 0.986610f, -0.0716228f, 0.186843f, 0.976953f, -0.103209f, 
		0.138069f, -0.305849f, 0.942016f, 0.763745f, 0.478806f, -0.432942f, 
		-0.0210512f, -0.231148f, 0.972691f, 0.383554f, 0.855009f, 0.349063f, 
		0.818061f, 0.471186f, 0.329787f, -0.120407f, 0.687718f, 0.715923f, 
		-0.295263f, 0.520457f, 0.801214f, 0.774707f, -0.268769f, 0.572357f, 
		0.863242f, -0.0131576f, 0.504618f, -0.109509f, -0.992082f, 0.0614901f, 
		-0.485949f, -0.856189f, -0.175483f, -0.596728f, -0.742150f, -0.305172f, 
		0.0797323f, -0.991320f, 0.104533f, -0.810569f, 0.415806f, 0.412411f, 
		-0.810569f, 0.415806f, 0.412411f, -0.409353f, 0.171515f, -0.896110f, 
		-0.409353f, 0.171515f, -0.896110f, 0.513941f, 0.504678f, -0.693661f, 
		0.509572f, 0.349781f, -0.786123f, 0.509572f, 0.349781f, -0.786123f, 
		0.454936f, 0.188893f, -0.870260f, 0.620038f, -0.521084f, 0.586535f, 
		0.732340f, -0.412121f, 0.542066f, 0.526103f, -0.576630f, 0.625071f, 
		0.377303f, -0.194558f, 0.905422f, 0.526103f, -0.576630f, 0.625071f, 
		0.620038f, -0.521084f, 0.586535f, 0.575578f, -0.453130f, 0.680722f, 
		0.288205f, -0.0484160f, -0.956344f, 0.308717f, 0.943901f, -0.117237f, 
		0.894980f, 0.405838f, 0.185221f, 0.553446f, 0.829879f, 0.0706931f, 
		0.412027f, 0.910947f, 0.0202153f, 0.146245f, -0.0145984f, 0.989141f, 
		0.969877f, 0.142845f, 0.197319f, 0.412027f, 0.910947f, 0.0202153f, 
		0.686589f, -0.0497649f, 0.725341f, 0.751056f, 0.361563f, 0.552437f, 
		0.970146f, -0.218306f, 0.105634f, 0.583269f, -0.231919f, 0.778467f, 
		0.973621f, 0.148924f, -0.172868f, 0.569894f, 0.0976484f, 0.815895f, 
		-0.637432f, -0.759345f, 0.130676f, 0.452356f, -0.845158f, -0.284750f, 
		-0.0816071f, 0.433574f, -0.897415f, 0.718517f, 0.663544f, -0.208429f, 
		0.757703f, 0.174625f, 0.628802f, -0.482485f, -0.458503f, -0.746314f, 
		0.0148867f, 0.442908f, -0.896444f, 0.249497f, -0.315742f, -0.915455f, 
		0.408849f, -0.846758f, -0.340357f, 0.899629f, -0.0272850f, -0.435801f, 
		0.408849f, -0.846758f, -0.340357f, -0.386743f, -0.883387f, 0.264684f, 
		-0.519897f, 0.854024f, 0.0187042f, 0.621590f, 0.132755f, -0.772012f, 
		-0.355016f, 0.934803f, -0.0103502f, -0.355016f, 0.934803f, -0.0103502f, 
		-0.162885f, -0.0349628f, -0.986025f, -0.106312f, 0.0649296f, -0.992211f, 
		0.0174778f, 0.359615f, -0.932937f, -0.162885f, -0.0349628f, -0.986025f, 
		-0.217154f, -0.458590f, 0.861708f, 0.918253f, -0.158530f, -0.362877f, 
		0.918253f, -0.158530f, -0.362877f, 0.975697f, -0.0838407f, -0.202448f, 
		0.835262f, -0.0814412f, 0.543788f, 0.923916f, -0.126951f, 0.360919f, 
		0.789767f, 0.458491f, 0.407498f, -0.0783043f, -0.217115f, -0.973000f, 
		0.222638f, -0.855446f, -0.467594f, 0.486135f, -0.727481f, -0.484194f, 
		0.622616f, -0.603428f, -0.498221f, 0.292200f, -0.794298f, -0.532644f, 
		0.0960179f, -0.870151f, -0.483341f, -0.179764f, 0.960337f, 0.213160f, 
		0.631357f, 0.396129f, 0.666686f, -0.307534f, 0.927310f, 0.213353f, 
		0.0908393f, 0.948366f, 0.303893f, 0.808618f, -0.535933f, -0.242717f, 
		0.524859f, -0.851036f, 0.0161324f, 0.775814f, -0.609067f, -0.164772f, 
		0.863724f, -0.430398f, -0.262178f, 0.722261f, -0.677574f, -0.138682f, 
		-0.882048f, 0.201155f, 0.426061f, 0.0913503f, 0.994427f, -0.0526227f, 
		-0.449043f, 0.0805734f, -0.889870f, 0.626027f, 0.368264f, 0.687366f, 
		0.529084f, 0.837343f, -0.137571f, 0.746239f, 0.163918f, 0.645181f, 
		0.954287f, -0.0302414f, 0.297357f, 0.983801f, -0.119093f, 0.133990f, 
		0.405329f, 0.327437f, 0.853518f, -0.755587f, 0.518330f, 0.400529f, 
		0.0996679f, -0.747414f, 0.656839f, 0.948442f, -0.123552f, 0.291877f, 
		0.948442f, -0.123552f, 0.291877f, 0.930653f, -0.253796f, 0.263577f, 
		0.670905f, -0.727949f, 0.141337f, 0.539391f, 0.835095f, 0.108049f, 
		0.990648f, -0.0687446f, 0.117862f, 0.539391f, 0.835095f, 0.108049f, 
		0.821039f, -0.569142f, 0.0444083f, 0.722725f, -0.676853f, -0.139781f, 
		0.636120f, -0.694546f, -0.336089f, 0.792927f, -0.433549f, 0.428137f, 
		0.792927f, -0.433549f, 0.428137f, 0.792927f, -0.433549f, 0.428137f, 
		0.870663f, -0.352324f, 0.343239f, 0.986746f, -0.0649475f, 0.148708f, 
		0.333245f, -0.0575952f, 0.941080f, -0.606951f, 0.769425f, 0.198986f, 
		0.841774f, 0.430539f, -0.325659f, 0.885724f, 0.401007f, -0.233852f, 
		0.987903f, 0.144798f, 0.0555128f, 0.989169f, 0.123839f, -0.0787999f, 
		0.773025f, 0.460886f, -0.435909f, 0.108740f, 0.647042f, -0.754660f, 
		0.725037f, 0.174934f, -0.666122f, 0.325314f, 0.936353f, 0.131960f, 
		0.325314f, 0.936353f, 0.131960f, 0.367991f, 0.113339f, 0.922896f, 
		0.343934f, 0.385689f, 0.856127f, 0.383622f, 0.854132f, 0.351130f, 
		0.954955f, -0.188695f, -0.229032f, 0.519185f, 0.844907f, 0.128758f, 
		0.385082f, 0.914976f, 0.120541f, 0.519185f, 0.844907f, 0.128758f, 
		0.110971f, 0.988138f, 0.106157f, 0.954955f, -0.188695f, -0.229032f, 
		-0.175502f, -0.828447f, -0.531859f, -0.497281f, -0.621751f, -0.605093f, 
		-0.497281f, -0.621751f, -0.605093f, 0.328189f, 0.671718f, 0.664144f, 
		0.481697f, 0.414865f, -0.771916f, 0.481697f, 0.414865f, -0.771916f, 
		-0.262193f, 0.954000f, 0.145389f, -0.861341f, 0.292097f, 0.415656f, 
		0.419406f, 0.146552f, 0.895891f, 0.419406f, 0.146552f, 0.895891f, 
		-0.861341f, 0.292097f, 0.415656f, -0.598103f, -0.113715f, 0.793311f, 
		0.814255f, -0.555677f, -0.167965f, 0.814255f, -0.555677f, -0.167965f, 
		0.518903f, -0.438643f, 0.733711f, 0.518903f, -0.438643f, 0.733711f, 
		-0.279002f, 0.303294f, 0.911137f, 0.719113f, -0.429674f, 0.546129f, 
		0.191549f, -0.707217f, 0.680553f, 0.483020f, -0.571254f, 0.663596f, 
		0.132147f, -0.940285f, -0.313690f, 0.378877f, 0.494580f, -0.782204f, 
		0.378877f, 0.494580f, -0.782204f, 0.378877f, 0.494580f, -0.782204f, 
		0.378877f, 0.494580f, -0.782204f, 0.252031f, -0.646465f, 0.720114f, 
		-0.565656f, 0.616309f, -0.547902f, 0.133223f, 0.976628f, -0.168667f, 
		0.423170f, -0.340819f, 0.839506f, 0.675635f, -0.578120f, 0.457487f, 
		0.618389f, -0.521340f, 0.588047f, 0.134516f, 0.851870f, 0.506185f, 
		0.204709f, -0.953230f, -0.222368f, 0.0158089f, -0.986384f, -0.163695f, 
		-0.0518710f, -0.994097f, -0.0952884f, -0.877069f, 0.208155f, 0.432922f, 
		0.444663f, 0.0264644f, 0.895307f, 0.167343f, 0.985867f, -0.00787890f, 
		0.439097f, -0.425115f, 0.791499f, 0.346308f, -0.604609f, 0.717300f, 
		0.273848f, -0.738124f, 0.616588f, 0.305244f, -0.665479f, 0.681149f, 
		0.391844f, -0.484318f, 0.782237f, 0.357752f, -0.545361f, 0.758020f, 
		0.489807f, -0.340288f, 0.802679f, 0.991320f, -0.124208f, -0.0431003f, 
		0.449891f, -0.872330f, -0.191410f, -0.418335f, 0.908053f, 0.0208591f, 
		-0.418335f, 0.908053f, 0.0208591f, 0.0185595f, 0.941001f, -0.337894f, 
		0.0996785f, 0.943352f, -0.316468f, -0.158749f, 0.956936f, -0.243047f, 
		0.460752f, 0.818755f, -0.342561f, 0.342163f, 0.857804f, -0.383532f, 
		0.0484248f, -0.320983f, 0.945846f, 0.914565f, 0.393238f, -0.0945263f, 
		0.517249f, -0.105451f, 0.849314f, 0.161473f, -0.940135f, -0.300121f, 
		0.161473f, -0.940135f, -0.300121f, 0.221743f, -0.903403f, -0.367006f, 
		0.455428f, -0.784499f, -0.420887f, 0.269857f, -0.0189790f, -0.962713f, 
		0.0985769f, 0.911310f, -0.399746f, 0.0985769f, 0.911310f, -0.399746f, 
		0.806081f, 0.0494452f, -0.589737f, 0.806081f, 0.0494452f, -0.589737f, 
		0.0268059f, -0.852196f, -0.522535f, 0.0268059f, -0.852196f, -0.522535f, 
		-0.147686f, 0.877810f, -0.455674f, 0.187558f, -0.982206f, 0.00967491f, 
		0.103913f, -0.991461f, 0.0787834f, 0.0243663f, -0.990759f, 0.133427f, 
		0.310391f, 0.939932f, -0.142073f, 0.754243f, 0.168656f, 0.634565f, 
		0.842497f, 0.373305f, -0.388383f, 0.143869f, -0.488545f, 0.860596f, 
		0.805061f, 0.186404f, 0.563143f, 0.805061f, 0.186404f, 0.563143f, 
		0.418998f, 0.130377f, 0.898578f, 0.700604f, -0.197917f, -0.685553f, 
		0.700604f, -0.197917f, -0.685553f, 0.0676304f, 0.680089f, -0.730003f, 
		-0.142448f, -0.133022f, 0.980823f, -0.142448f, -0.133022f, 0.980823f, 
		-0.0851594f, -0.0388912f, 0.995608f, 0.0356654f, 0.247123f, 0.968328f, 
		0.193476f, 0.966814f, -0.166844f, 0.229701f, 0.970602f, -0.0718976f, 
		0.193476f, 0.966814f, -0.166844f, 0.164231f, 0.928632f, -0.332673f, 
		0.0171860f, 0.987286f, -0.158021f, -0.286081f, 0.932788f, -0.219236f, 
		0.447158f, 0.890924f, -0.0794025f, -0.0861469f, -0.995828f, -0.0300723f, 
		-0.0347618f, 0.931930f, 0.360970f, -0.246476f, 0.930509f, 0.270930f, 
		-0.436408f, 0.840739f, 0.320478f, 0.755172f, -0.196856f, 0.625270f, 
		0.0269992f, 0.973425f, 0.227409f, 0.180463f, 0.979785f, 0.0863350f, 
		0.0659944f, 0.996932f, 0.0420827f, 0.253105f, 0.966628f, -0.0396058f, 
		-0.277012f, 0.957776f, -0.0770003f, 0.254248f, -0.0456278f, 0.966062f, 
		0.232620f, 0.205804f, 0.950543f, 0.237830f, 0.401486f, 0.884447f, 
		0.159936f, -0.923635f, 0.348309f, -0.0169232f, 0.772912f, 0.634287f, 
		0.0754311f, 0.887915f, 0.453781f, 0.191645f, 0.980582f, 0.0416052f, 
		0.0394214f, 0.980402f, -0.193022f, 0.0333999f, -0.965446f, 0.258454f, 
		-0.238120f, -0.940502f, 0.242392f, 0.315757f, -0.930741f, 0.184441f, 
		-0.0753660f, -0.957178f, 0.279518f, 0.0582754f, -0.958380f, 0.279485f, 
		-0.00454447f, -0.954630f, 0.297761f, -0.00875719f, 0.995549f, 0.0938388f, 
		0.353777f, 0.335635f, 0.873035f, 0.329662f, -0.842093f, 0.426852f, 
		0.640149f, -0.604404f, 0.474241f, 0.542070f, -0.716586f, 0.438937f, 
		0.640149f, -0.604404f, 0.474241f, -0.564743f, -0.729454f, 0.385956f, 
		-0.355249f, -0.428773f, -0.830633f, -0.355249f, -0.428773f, -0.830633f, 
		0.409364f, -0.158839f, 0.898438f, -0.355249f, -0.428773f, -0.830633f, 
		0.385084f, 0.771368f, -0.506657f, -0.0272235f, -0.104607f, -0.994141f, 
		-0.0138221f, 0.917517f, -0.397455f, 0.0221016f, -0.210764f, 0.977287f, 
		-0.400251f, -0.853931f, 0.332568f, -0.534077f, 0.844967f, 0.0281494f, 
		0.282073f, 0.882821f, 0.375583f, 0.199718f, -0.901234f, 0.384565f, 
		-0.0649335f, -0.936059f, 0.345801f, -0.467646f, -0.849920f, 0.242782f, 
		-0.530424f, 0.0659538f, 0.845163f, 0.404354f, -0.749783f, 0.523759f, 
		0.0586274f, -0.331174f, -0.941746f, -0.628980f, -0.734199f, 0.255610f, 
		-0.398296f, 0.893768f, -0.206249f, -0.0907044f, 0.819364f, -0.566053f, 
		-0.418027f, 0.908265f, -0.0175603f, -0.319809f, 0.930977f, -0.176080f, 
		-0.258239f, 0.763194f, -0.592323f, -0.116382f, 0.700446f, -0.704153f, 
		-0.0565386f, -0.995695f, -0.0734514f, -0.417347f, -0.890146f, 0.182922f, 
		-0.522228f, -0.788813f, 0.324117f, 0.126013f, -0.980727f, -0.149314f, 
		0.126013f, -0.980727f, -0.149314f, -0.178495f, -0.981251f, 0.0727106f, 
		0.324233f, 0.187847f, 0.927139f, 0.324233f, 0.187847f, 0.927139f, 
		-0.0155096f, -0.298308f, -0.954344f, 0.923340f, 0.381679f, 0.0419997f, 
		-0.355898f, -0.920251f, 0.162708f, 0.139734f, 0.584700f, 0.799125f, 
		-0.0351437f, 0.451237f, 0.891712f, 0.139734f, 0.584700f, 0.799125f, 
		0.279018f, 0.706279f, 0.650630f, 0.814332f, 0.452977f, -0.362872f, 
		0.0583843f, 0.965892f, 0.252279f, 0.216241f, 0.914371f, 0.342294f, 
		-0.185536f, 0.953793f, 0.236337f, -0.0705677f, 0.286489f, -0.955481f, 
		-0.0705677f, 0.286489f, -0.955481f, 0.138706f, 0.468904f, 0.872290f, 
		0.177347f, 0.927891f, -0.327973f, 0.0499398f, 0.931551f, -0.360164f, 
		-0.154273f, 0.919385f, -0.361844f, -0.0458764f, 0.940949f, -0.335426f, 
		-0.257113f, 0.906644f, -0.334499f, 0.188187f, -0.807828f, -0.558569f, 
		0.301022f, -0.762566f, -0.572607f, 0.0780037f, -0.842830f, -0.532497f, 
		0.0780037f, -0.842830f, -0.532497f, 0.188187f, -0.807828f, -0.558569f, 
		0.725827f, -0.342762f, -0.596398f, 0.448119f, 0.889105f, -0.0931768f, 
		-0.143628f, -0.685044f, -0.714203f, -0.344977f, 0.869555f, 0.353362f, 
		0.923619f, 0.359026f, 0.134266f, 0.903764f, 0.258420f, -0.341217f, 
		0.884935f, 0.366707f, 0.287082f, 0.454516f, -0.820361f, -0.347020f, 
		0.345850f, 0.609108f, -0.713705f, -0.0216069f, 0.512023f, -0.858700f, 
		0.204016f, 0.564495f, -0.799826f, 0.140988f, -0.165391f, -0.976098f, 
		0.287111f, 0.00807382f, -0.957863f, -0.511265f, 0.632999f, 0.581310f, 
		0.780008f, 0.115510f, -0.615017f, 0.780008f, 0.115510f, -0.615017f, 
		-0.538610f, 0.375693f, -0.754158f, -0.227114f, -0.848548f, 0.477897f, 
		0.0882797f, -0.895215f, 0.436803f, 0.201571f, -0.885097f, 0.419490f, 
		0.182747f, -0.380492f, -0.906548f, 0.0450185f, 0.562794f, -0.825370f, 
		0.695065f, -0.0758845f, 0.714930f, 0.616595f, 0.0860063f, 0.782568f, 
		0.278964f, 0.481278f, 0.830994f, 0.141999f, 0.596824f, 0.789707f, 
		-0.530210f, 0.286572f, 0.797969f, -0.656858f, 0.748237f, 0.0931600f, 
		0.238203f, 0.923971f, 0.299228f, 0.839691f, 0.435615f, 0.324282f, 
		0.111922f, 0.799446f, 0.590221f, -0.154336f, -0.987986f, -0.00794948f, 
		-0.493176f, 0.470460f, 0.731741f, -0.00867195f, 0.995198f, 0.0974974f, 
		-0.345933f, 0.347641f, -0.871479f, 0.375628f, -0.662100f, 0.648481f, 
		-0.444227f, -0.382141f, -0.810327f, 0.375628f, -0.662100f, 0.648481f, 
		0.375628f, -0.662100f, 0.648481f, -0.444227f, -0.382141f, -0.810327f, 
		-0.0184526f, -0.963973f, 0.265359f, -0.142029f, -0.852398f, 0.503234f, 
		-0.0335980f, -0.929761f, 0.366627f, -0.444158f, -0.712156f, 0.543652f, 
		0.0772087f, 0.995316f, -0.0581790f, -0.399937f, 0.915995f, -0.0316706f, 
		-0.0216871f, 0.998125f, -0.0572461f, -0.110674f, 0.991260f, -0.0718022f, 
		0.190734f, 0.981019f, -0.0349516f, 0.0772087f, 0.995316f, -0.0581790f, 
		0.199648f, -0.978902f, -0.0435014f, 0.199648f, -0.978902f, -0.0435014f, 
		0.199648f, -0.978902f, -0.0435014f, 0.199648f, -0.978902f, -0.0435014f, 
		0.670905f, -0.727949f, 0.141337f, 0.325508f, -0.945463f, 0.0120501f, 
		0.298143f, 0.831008f, 0.469614f, 0.298143f, 0.831008f, 0.469614f, 
		0.813101f, 0.0690298f, 0.578015f, 0.813101f, 0.0690298f, 0.578015f, 
		0.608675f, -0.461191f, 0.645614f, -0.704703f, -0.268397f, -0.656777f, 
		0.0242793f, 0.342501f, -0.939204f, -0.436170f, 0.899862f, 0.00181040f, 
		-0.245242f, 0.969444f, -0.00592588f, 0.482557f, 0.871951f, 0.0827036f, 
		0.335411f, 0.937874f, 0.0888311f, -0.436170f, 0.899862f, 0.00181040f, 
		0.482557f, 0.871951f, 0.0827036f, 0.520925f, -0.700275f, 0.488111f, 
		-0.421101f, -0.733358f, 0.533723f, 0.520925f, -0.700275f, 0.488111f, 
		-0.421101f, -0.733358f, 0.533723f, -0.523512f, -0.492319f, -0.695383f, 
		0.290246f, 0.281077f, 0.914742f, -0.486054f, -0.559121f, 0.671666f, 
		0.545377f, -0.550287f, 0.632256f, -0.486054f, -0.559121f, 0.671666f, 
		0.0251583f, 0.367382f, 0.929730f, -0.508162f, 0.785854f, -0.352428f, 
		-0.0337161f, 0.989581f, -0.139973f, -0.0337161f, 0.989581f, -0.139973f, 
		-0.0337161f, 0.989581f, -0.139973f, 0.210925f, 0.0867498f, -0.973645f, 
		0.156975f, 0.983964f, 0.0846979f, -0.100305f, 0.934615f, 0.341223f, 
		-0.417176f, 0.908154f, -0.0349401f, -0.0379172f, 0.947555f, -0.317335f, 
		-0.275942f, 0.918925f, -0.281840f, 0.165209f, -0.195785f, -0.966630f, 
		0.245531f, -0.0643666f, 0.967249f, -0.116299f, -0.733147f, 0.670053f, 
		0.0541725f, -0.783371f, 0.619189f, 0.0541725f, -0.783371f, 0.619189f, 
		0.225248f, -0.730482f, 0.644716f, 0.222112f, 0.398228f, 0.889989f, 
		0.222112f, 0.398228f, 0.889989f, -0.0452568f, -0.885883f, 0.461696f, 
		0.191772f, -0.646683f, -0.738258f, 0.783537f, 0.621194f, -0.0137067f, 
		-0.692320f, 0.644962f, -0.323600f, -0.692320f, 0.644962f, -0.323600f, 
		-0.712803f, -0.592215f, 0.375757f, 0.619807f, -0.627249f, 0.471590f, 
		-0.351550f, 0.934446f, 0.0567745f, -0.351550f, 0.934446f, 0.0567745f, 
		0.502336f, 0.860102f, 0.0887884f, -0.513628f, -0.220311f, -0.829246f, 
		0.419265f, 0.883082f, 0.210674f, 0.474295f, 0.792068f, 0.384281f, 
		0.445591f, 0.695666f, 0.563469f, 0.0360889f, -0.866691f, 0.497539f, 
		-0.260120f, -0.866031f, 0.426999f, 0.266450f, -0.830947f, 0.488398f, 
		0.494602f, -0.679876f, 0.541422f, 0.0360889f, -0.866691f, 0.497539f, 
		-0.0373220f, -0.902266f, -0.429562f, -0.0373220f, -0.902266f, -0.429562f, 
		0.161151f, -0.850494f, -0.500689f, 0.427199f, -0.639546f, -0.639126f, 
		0.609947f, -0.591687f, -0.527135f, 0.541175f, 0.829503f, 0.138037f, 
		-0.278478f, 0.941671f, 0.188957f, -0.121149f, 0.970013f, 0.210709f, 
		0.340129f, 0.908690f, 0.242063f, 0.193033f, -0.604993f, -0.772478f, 
		0.109662f, 0.991343f, -0.0722011f, 0.109662f, 0.991343f, -0.0722011f, 
		0.109662f, 0.991343f, -0.0722011f, 0.226588f, 0.655937f, 0.720003f, 
		0.633598f, -0.327398f, 0.700974f, -0.505037f, -0.712332f, -0.487360f, 
		0.0268406f, -0.992738f, 0.117261f, 0.833641f, -0.289384f, -0.470425f, 
		0.772805f, 0.533116f, -0.344326f, -0.789888f, 0.521214f, 0.323129f, 
		-0.307314f, 0.158759f, -0.938272f, -0.789888f, 0.521214f, 0.323129f, 
		0.167343f, 0.985867f, -0.00787890f, -0.307314f, 0.158759f, -0.938272f, 
		0.515066f, -0.703884f, 0.489136f, -0.655675f, -0.694682f, 0.295815f, 
		0.515066f, -0.703884f, 0.489136f, 0.00463319f, 0.841834f, -0.539717f, 
		0.138407f, 0.864314f, -0.483533f, 0.0248774f, 0.762189f, -0.646876f, 
		-0.0403477f, 0.534840f, -0.843989f, 0.406328f, 0.880289f, -0.244928f, 
		0.490631f, -0.539120f, 0.684566f, -0.451908f, 0.887293f, 0.0921417f, 
		-0.451908f, 0.887293f, 0.0921417f, -0.324926f, -0.925753f, 0.193403f, 
		0.236331f, -0.196188f, 0.951661f, -0.600805f, -0.791909f, 0.109147f, 
		0.510781f, -0.776965f, 0.368005f, 0.510781f, -0.776965f, 0.368005f, 
		-0.600805f, -0.791909f, 0.109147f, -0.485420f, -0.620077f, 0.616337f, 
		-0.0474744f, -0.414999f, 0.908583f, -0.0474744f, -0.414999f, 0.908583f, 
		0.543850f, 0.835669f, -0.0767093f, -0.444468f, 0.821656f, -0.356832f, 
		0.895235f, 0.445114f, -0.0207042f, 0.294600f, -0.0744987f, -0.952712f, 
		0.194144f, 0.957058f, 0.215285f, 0.203898f, 0.930886f, 0.303112f, 
		0.203898f, 0.930886f, 0.303112f, 0.184103f, 0.908710f, 0.374636f, 
		0.244852f, 0.798844f, -0.549450f, 0.339689f, 0.928674f, -0.148918f, 
		-0.516710f, -0.570483f, 0.638405f, 0.299734f, -0.488040f, 0.819742f, 
		0.0991087f, -0.499580f, 0.860580f, -0.516710f, -0.570483f, 0.638405f, 
		-0.364158f, -0.549123f, 0.752232f, 0.788898f, 0.141845f, 0.597930f, 
		0.788898f, 0.141845f, 0.597930f, 0.701313f, 0.674550f, -0.230527f, 
		-0.617822f, 0.625122f, -0.476989f, 0.701313f, 0.674550f, -0.230527f, 
		-0.617822f, 0.625122f, -0.476989f, 0.433273f, 0.831063f, 0.348725f, 
		0.311172f, 0.112885f, 0.943626f, 0.180270f, 0.917603f, 0.354270f, 
		-0.496438f, 0.0751175f, -0.864816f, -0.519058f, 0.610224f, -0.598503f, 
		0.597149f, 0.670577f, -0.440159f, -0.519058f, 0.610224f, -0.598503f, 
		-0.497263f, -0.866809f, -0.0370363f, 0.508083f, -0.794120f, 0.333505f, 
		-0.295849f, -0.889354f, 0.348601f, -0.142177f, -0.924650f, 0.353282f, 
		-0.209543f, -0.910006f, 0.357743f, -0.488059f, -0.544716f, 0.681970f, 
		0.0208649f, 0.402811f, 0.915045f, 0.270757f, -0.960737f, -0.0606233f, 
		0.162029f, 0.618806f, 0.768652f, 0.162029f, 0.618806f, 0.768652f, 
		0.162029f, 0.618806f, 0.768652f, -0.576160f, 0.814002f, 0.0737587f, 
		-0.576160f, 0.814002f, 0.0737587f, 0.489298f, 0.686422f, -0.537971f, 
		0.489298f, 0.686422f, -0.537971f, -0.444585f, -0.509103f, -0.736992f, 
		-0.162720f, -0.942830f, -0.290850f, 0.276753f, 0.398557f, 0.874391f, 
		-0.460099f, -0.858742f, -0.225547f, -0.478031f, -0.862889f, -0.164038f, 
		-0.527428f, -0.809373f, 0.258333f, 0.536722f, -0.782938f, 0.314542f, 
		0.539979f, -0.836620f, 0.0921372f, -0.459274f, -0.746315f, 0.481748f, 
		0.484672f, -0.727152f, 0.486152f, -0.827822f, 0.278131f, 0.487190f, 
		0.365193f, 0.108445f, 0.924594f, 0.365193f, 0.108445f, 0.924594f, 
		0.242023f, 0.969568f, 0.0369267f, 0.280093f, 0.104926f, 0.954221f, 
		-0.0666799f, -0.980584f, 0.184415f, -0.633867f, -0.767216f, 0.0979412f, 
		-0.316369f, -0.936218f, 0.152991f, -0.0666799f, -0.980584f, 0.184415f, 
		-0.316369f, -0.936218f, 0.152991f, 0.137452f, -0.953117f, 0.269584f, 
		-0.0666799f, -0.980584f, 0.184415f, 0.282546f, 0.953574f, 0.104233f, 
		0.238591f, 0.308778f, -0.920723f, -0.219320f, -0.970220f, 0.102818f, 
		0.344693f, -0.937603f, 0.0456804f, -0.181875f, -0.925351f, -0.332637f, 
		0.132065f, -0.989774f, -0.0539034f, 0.344693f, -0.937603f, 0.0456804f, 
		0.306688f, 0.438080f, 0.845002f, 0.324336f, 0.550788f, 0.769050f, 
		-0.789888f, 0.521214f, 0.323129f, -0.789888f, 0.521214f, 0.323129f, 
		0.306688f, 0.438080f, 0.845002f, 0.304853f, 0.309327f, 0.900767f, 
		-0.442655f, 0.807269f, 0.390351f, 0.465521f, -0.0461934f, -0.883830f, 
		0.360558f, -0.0828682f, -0.929048f, 0.417250f, -0.0412271f, -0.907856f, 
		0.229300f, -0.511023f, -0.828418f, -0.112063f, -0.207522f, 0.971790f, 
		-0.801155f, -0.569760f, 0.183099f, 0.00403928f, -0.993766f, -0.111414f, 
		-0.179202f, 0.797962f, 0.575450f, 0.222424f, -0.952500f, -0.208016f, 
		0.222424f, -0.952500f, -0.208016f, 0.222424f, -0.952500f, -0.208016f, 
		-0.799328f, 0.474808f, -0.368283f, 0.602682f, 0.549628f, -0.578518f, 
		0.415355f, -0.168533f, -0.893911f, -0.242370f, 0.165443f, -0.955974f, 
		-0.242370f, 0.165443f, -0.955974f, -0.147989f, -0.968042f, -0.202467f, 
		-0.147989f, -0.968042f, -0.202467f, -0.147989f, -0.968042f, -0.202467f, 
		-0.147989f, -0.968042f, -0.202467f, -0.147989f, -0.968042f, -0.202467f, 
		0.691834f, -0.452980f, -0.562294f, -0.147989f, -0.968042f, -0.202467f, 
		-0.363587f, -0.822130f, -0.438071f, -0.274690f, -0.884684f, -0.376669f, 
		-0.200612f, -0.920958f, -0.334054f, -0.128621f, -0.944786f, -0.301391f, 
		0.137179f, -0.977360f, -0.161088f, -0.428890f, 0.895103f, -0.121834f, 
		0.297796f, -0.732375f, -0.612327f, 0.278261f, 0.00740867f, 0.960477f, 
		0.0869460f, 0.354476f, 0.931014f, 0.0683916f, -0.973024f, 0.220334f, 
		0.624667f, 0.675340f, -0.392055f, -0.813329f, 0.140339f, -0.564625f, 
		-0.745526f, 0.397480f, -0.534977f, 0.307965f, 0.951238f, -0.0174453f, 
		-0.0116155f, 0.983562f, 0.180197f, -0.410270f, 0.897181f, -0.163538f, 
		-0.147233f, 0.987733f, 0.0520205f, -0.0713765f, 0.991147f, 0.111951f, 
		-0.162799f, 0.977164f, 0.136553f, -0.0116155f, 0.983562f, 0.180197f, 
		-0.0577799f, 0.954143f, 0.293721f, -0.640047f, 0.767303f, -0.0398218f, 
		0.225307f, 0.799337f, 0.557043f, -0.640047f, 0.767303f, -0.0398218f, 
		0.442532f, -0.532501f, -0.721532f, 0.578194f, -0.519367f, -0.629245f, 
		0.155396f, -0.493366f, -0.855828f, -0.407950f, 0.875823f, 0.257897f, 
		-0.324926f, -0.925753f, 0.193403f, 0.440078f, 0.886613f, 0.142298f, 
		-0.0300080f, 0.439696f, -0.897645f, 0.345816f, -0.173128f, -0.922192f, 
		0.663239f, -0.748202f, -0.0175408f, -0.208535f, 0.247281f, -0.946237f, 
		0.314198f, -0.757041f, 0.572860f, 0.817460f, 0.239694f, -0.523742f, 
		-0.184016f, -0.0174705f, 0.982768f, 0.0577190f, -0.629612f, -0.774763f, 
		-0.381132f, 0.843553f, 0.378360f, -0.521617f, 0.815737f, 0.249977f, 
		-0.779893f, 0.619382f, 0.0901807f, -0.717984f, -0.114995f, -0.686495f, 
		-0.0475096f, 0.712299f, -0.700266f, 0.276721f, 0.761836f, 0.585689f, 
		-0.682883f, 0.718720f, 0.130813f, -0.101879f, 0.586144f, -0.803776f, 
		0.831403f, 0.267577f, 0.487003f, -0.193552f, -0.0529365f, -0.979661f, 
		-0.814303f, 0.368356f, -0.448579f, 0.612420f, 0.459338f, -0.643389f, 
		0.612420f, 0.459338f, -0.643389f, -0.814303f, 0.368356f, -0.448579f, 
		-0.871371f, -0.365204f, 0.327627f, -0.113567f, -0.934490f, 0.337387f, 
		-0.871371f, -0.365204f, 0.327627f, -0.113567f, -0.934490f, 0.337387f, 
		0.104347f, -0.975631f, 0.193017f, 0.419493f, -0.193987f, 0.886789f, 
		-0.0812383f, -0.978976f, 0.187099f, -0.289403f, -0.833307f, -0.471005f, 
		-0.289403f, -0.833307f, -0.471005f, -0.289403f, -0.833307f, -0.471005f, 
		-0.289403f, -0.833307f, -0.471005f, 0.532697f, 0.831185f, 0.159262f, 
		0.300445f, 0.728118f, 0.616099f, 0.0526999f, 0.353559f, 0.933926f, 
		0.818763f, -0.0222654f, 0.573700f, 0.154444f, 0.482042f, 0.862428f, 
		-0.407216f, -0.441966f, 0.799275f, -0.281593f, -0.913128f, 0.294791f, 
		-0.964678f, 0.137831f, -0.224495f, -0.0988120f, 0.866725f, 0.488901f, 
		-0.259233f, 0.954430f, 0.147859f, 0.190931f, -0.147537f, 0.970453f, 
		-0.964678f, 0.137831f, -0.224495f, -0.288069f, 0.957593f, -0.00562669f, 
		0.190728f, -0.279321f, 0.941065f, 0.377985f, -0.874552f, -0.303786f, 
		0.915582f, -0.390765f, 0.0949389f, 0.387235f, -0.633319f, -0.670042f, 
		0.388441f, -0.802825f, -0.452312f, 0.0584300f, -0.998142f, 0.0172964f, 
		0.0584300f, -0.998142f, 0.0172964f, -0.959689f, -0.279290f, 0.0315357f, 
		-0.284758f, -0.928062f, 0.240026f, 0.452011f, 0.882413f, 0.130513f, 
		0.211680f, 0.915043f, 0.343348f, -0.00892674f, 0.831301f, 0.555750f, 
		0.0753690f, -0.984556f, 0.158018f, -0.536139f, 0.826588f, -0.171195f, 
		-0.536139f, 0.826588f, -0.171195f, -0.679800f, 0.725859f, 0.104882f, 
		0.721797f, 0.0935109f, 0.685758f, 0.721797f, 0.0935109f, 0.685758f, 
		-0.269677f, 0.960705f, 0.0657246f, -0.971135f, 0.202999f, 0.125253f, 
		-0.269677f, 0.960705f, 0.0657246f, -0.269677f, 0.960705f, 0.0657246f, 
		-0.0612385f, -0.0484372f, 0.996947f, -0.438333f, 0.898810f, 0.00222473f, 
		-0.998611f, 0.0404927f, -0.0336982f, -0.438333f, 0.898810f, 0.00222473f, 
		-0.998611f, 0.0404927f, -0.0336982f, -0.703411f, -0.0823253f, -0.706000f, 
		-0.100142f, 0.596671f, -0.796213f, -0.100142f, 0.596671f, -0.796213f, 
		-0.393018f, -0.917271f, 0.0644227f, 0.355710f, -0.0995577f, 0.929278f, 
		0.477436f, -0.132210f, 0.868663f, 0.433831f, -0.0901115f, 0.896477f, 
		-0.374181f, -0.795035f, -0.477396f, -0.535512f, -0.729412f, -0.425658f, 
		-0.709273f, -0.597113f, -0.374684f, 0.879938f, 0.364022f, -0.305282f, 
		0.215421f, 0.854149f, -0.473312f, 0.316482f, 0.658206f, -0.683084f, 
		0.571773f, 0.176720f, -0.801153f, 0.220811f, 0.766651f, -0.602900f, 
		0.220811f, 0.766651f, -0.602900f, -0.0556282f, -0.952103f, -0.300675f, 
		0.924979f, 0.0175945f, 0.379611f, 0.610095f, 0.730519f, 0.306800f, 
		-0.962695f, -0.212962f, 0.166931f, -0.716521f, -0.680482f, 0.153430f, 
		-0.979912f, -0.0778374f, 0.183611f, -0.979912f, -0.0778374f, 0.183611f, 
		-0.979912f, -0.0778374f, 0.183611f, -0.992017f, -0.0123200f, -0.125500f, 
		0.368236f, -0.0606384f, 0.927753f, -0.992017f, -0.0123200f, -0.125500f, 
		-0.124703f, -0.929730f, 0.346485f, -0.376429f, 0.926374f, 0.0115194f, 
		-0.997383f, 0.0254096f, -0.0676812f, -0.997383f, 0.0254096f, -0.0676812f, 
		-0.376429f, 0.926374f, 0.0115194f, 0.000977999f, 0.660003f, -0.751263f, 
		0.409587f, 0.456431f, -0.789879f, 0.304314f, 0.949683f, -0.0741341f, 
		0.423277f, 0.765629f, 0.484406f, 0.637407f, 0.0534365f, -0.768672f, 
		0.637407f, 0.0534365f, -0.768672f, 0.742419f, -0.0394571f, 0.668773f, 
		0.637407f, 0.0534365f, -0.768672f, 0.566877f, -0.791498f, 0.228433f, 
		0.293305f, -0.934132f, 0.203396f, 0.792310f, -0.571760f, 0.212922f, 
		0.887472f, -0.423521f, 0.181726f, 0.211365f, 0.751301f, 0.625197f, 
		0.196154f, 0.656865f, 0.728047f, 0.127163f, 0.594669f, 0.793851f, 
		-0.402211f, -0.914756f, -0.0380462f, -0.997719f, 0.0296383f, -0.0606470f, 
		-0.402211f, -0.914756f, -0.0380462f, -0.997719f, 0.0296383f, -0.0606470f, 
		-0.402211f, -0.914756f, -0.0380462f, 0.523184f, -0.301453f, 0.797123f, 
		-0.994167f, 0.0181604f, -0.106309f, -0.452186f, 0.862189f, 0.228379f, 
		-0.452186f, 0.862189f, 0.228379f, -0.994167f, 0.0181604f, -0.106309f, 
		-0.452186f, 0.862189f, 0.228379f, -0.112562f, -0.804536f, 0.583139f, 
		-0.667975f, -0.541946f, 0.510003f, -0.762099f, -0.397753f, 0.510880f, 
		-0.824143f, -0.404734f, 0.396204f, -0.259664f, -0.126220f, 0.957415f, 
		-0.530746f, -0.350831f, 0.771509f, 0.113959f, -0.828360f, 0.548483f, 
		-0.789364f, -0.555286f, 0.261842f, -0.810898f, -0.574460f, -0.111535f, 
		-0.758911f, -0.446022f, -0.474467f, -0.658058f, -0.209090f, -0.723354f, 
		-0.412765f, -0.849770f, -0.327897f, -0.657616f, -0.714029f, -0.240215f, 
		0.608675f, -0.461191f, 0.645614f, -0.368673f, -0.108451f, -0.923211f, 
		-0.144744f, 0.415761f, -0.897882f, -0.114239f, -0.0609981f, -0.991579f, 
		0.902486f, -0.411805f, -0.126232f, 0.0472235f, -0.238810f, -0.969917f, 
		0.0472235f, -0.238810f, -0.969917f, -0.118706f, -0.226131f, -0.966837f, 
		0.117247f, -0.974385f, -0.191905f, -0.992676f, 0.0307142f, -0.116838f, 
		-0.992676f, 0.0307142f, -0.116838f, -0.409360f, -0.861314f, -0.300936f, 
		-0.976553f, -0.157073f, -0.147214f, -0.409360f, -0.861314f, -0.300936f, 
		-0.841877f, -0.486816f, -0.232923f, -0.976553f, -0.157073f, -0.147214f, 
		0.966977f, 0.0998636f, -0.234484f, 0.0240171f, -0.0619880f, 0.997788f, 
		0.340813f, 0.906774f, -0.248209f, 0.446315f, 0.0204992f, -0.894641f, 
		-0.00608898f, 0.425456f, 0.904959f, 0.0597549f, 0.581673f, 0.811225f, 
		-0.383203f, 0.914478f, 0.129942f, 0.164436f, -0.274487f, 0.947427f, 
		-0.493818f, 0.853912f, 0.164251f, 0.449869f, 0.817522f, -0.359549f, 
		0.884351f, 0.250318f, -0.394036f, 0.161832f, -0.985462f, 0.0517247f, 
		0.337786f, 0.764753f, 0.548683f, 0.337786f, 0.764753f, 0.548683f, 
		0.371553f, 0.490908f, -0.788009f, 0.0472030f, -0.275340f, 0.960187f, 
		0.531816f, 0.831588f, -0.160105f, 0.953881f, 0.281349f, -0.104659f, 
		0.634582f, 0.741344f, -0.218436f, 0.761587f, 0.211176f, -0.612691f, 
		0.795469f, 0.478126f, -0.372323f, 0.904041f, 0.269986f, 0.331387f, 
		0.988905f, 0.0759676f, -0.127652f, 0.823218f, 0.528326f, -0.207807f, 
		0.664935f, 0.696837f, -0.268850f, 0.310385f, 0.912573f, -0.266217f, 
		-0.136754f, -0.0207452f, 0.990388f, 0.972425f, 0.227030f, -0.0533634f, 
		-0.00884231f, 0.995886f, 0.0901790f, -0.913226f, 0.287487f, 0.288737f, 
		0.331678f, 0.231106f, 0.914647f, -0.176821f, -0.0449139f, -0.983218f, 
		0.942661f, 0.297231f, 0.151801f, 0.371214f, 0.0387747f, -0.927737f, 
		0.651667f, -0.242895f, -0.718562f, 0.501676f, -0.0698324f, -0.862232f, 
		0.712807f, -0.311845f, 0.628219f, 0.484407f, -0.217824f, -0.847291f, 
		0.726818f, 0.250742f, 0.639424f, 0.605002f, 0.375275f, 0.702240f, 
		0.0437934f, 0.761344f, 0.646867f, 0.363051f, 0.651752f, 0.665893f, 
		-0.534007f, 0.766321f, -0.357197f, -0.791943f, 0.528608f, -0.305614f, 
		-0.867630f, 0.429596f, -0.250332f, -0.944842f, 0.277411f, -0.174118f, 
		-0.638357f, 0.692696f, -0.335667f, -0.364251f, 0.849186f, -0.382367f, 
		-0.0566113f, -0.662049f, 0.747319f, -0.0566113f, -0.662049f, 0.747319f, 
		-0.527232f, 0.431969f, 0.731731f, 0.422050f, 0.409181f, 0.808978f, 
		-0.685423f, -0.691119f, 0.229235f, -0.303356f, -0.911738f, 0.276963f, 
		-0.584048f, -0.776902f, 0.235183f, -0.782655f, -0.572949f, 0.243271f, 
		-0.457930f, -0.842997f, 0.282235f, 0.389313f, 0.867894f, -0.308538f, 
		0.143255f, -0.722547f, 0.676316f, 0.231547f, -0.710449f, 0.664567f, 
		-0.000238900f, -0.719988f, 0.693986f, 0.231547f, -0.710449f, 0.664567f, 
		-0.304551f, -0.649874f, 0.696356f, -0.000238900f, -0.719988f, 0.693986f, 
		-0.119200f, -0.698386f, 0.705726f, -0.304551f, -0.649874f, 0.696356f, 
		0.143255f, -0.722547f, 0.676316f, -0.968545f, 0.0983316f, 0.228588f, 
		-0.968545f, 0.0983316f, 0.228588f, 0.177205f, 0.0839877f, 0.980584f, 
		0.177205f, 0.0839877f, 0.980584f, 0.177205f, 0.0839877f, 0.980584f, 
		-0.411394f, -0.633479f, 0.655331f, 0.428015f, 0.858255f, 0.283199f, 
		-0.500380f, 0.704948f, 0.502661f, 0.0838760f, 0.899776f, -0.428214f, 
		0.238976f, 0.963509f, -0.120587f, -0.514470f, 0.628341f, 0.583531f, 
		0.435857f, 0.536026f, 0.722983f, 0.435857f, 0.536026f, 0.722983f, 
		-0.514470f, 0.628341f, 0.583531f, 0.0395749f, 0.956440f, 0.289235f, 
		0.0395749f, 0.956440f, 0.289235f, 0.0395749f, 0.956440f, 0.289235f, 
		-0.337826f, -0.212541f, 0.916897f, 0.229161f, 0.429569f, 0.873473f, 
		-0.331580f, 0.542162f, -0.772085f, -0.0250330f, 0.751772f, -0.658947f, 
		0.285954f, 0.771688f, -0.568092f, -0.344863f, 0.654811f, -0.672526f, 
		0.598231f, 0.645739f, -0.474490f, 0.374924f, -0.842123f, -0.387635f, 
		0.400991f, -0.464511f, 0.789579f, -0.0656597f, 0.774800f, -0.628787f, 
		-0.139709f, 0.715977f, -0.684002f, 0.0607672f, 0.809665f, -0.583738f, 
		0.106109f, -0.966067f, -0.235491f, -0.00489018f, 0.727869f, -0.685699f, 
		-0.777244f, 0.507482f, -0.371958f, -0.821153f, -0.482674f, -0.304522f, 
		-0.951436f, -0.178750f, -0.250637f, -0.779893f, 0.619382f, 0.0901807f, 
		-0.900888f, 0.433909f, 0.0111155f, -0.711038f, -0.616018f, -0.339038f, 
		-0.821153f, -0.482674f, -0.304522f, -0.324926f, -0.925753f, 0.193403f, 
		-0.142309f, 0.915755f, 0.375687f, -0.312731f, 0.634312f, -0.706999f, 
		0.00957140f, 0.996383f, 0.0844295f, 0.00957140f, 0.996383f, 0.0844295f, 
		0.00957140f, 0.996383f, 0.0844295f, -0.227248f, -0.918346f, 0.324036f, 
		-0.152040f, -0.948116f, 0.279213f, 0.149766f, -0.983709f, 0.0994300f, 
		0.221487f, 0.278467f, 0.934559f, 0.221487f, 0.278467f, 0.934559f, 
		0.117613f, 0.895137f, -0.429996f, 0.261851f, 0.932591f, -0.248409f, 
		-0.0910288f, 0.845223f, -0.526603f, 0.165354f, 0.927416f, -0.335497f, 
		0.319230f, 0.939828f, -0.121717f, -0.929022f, 0.258770f, 0.264491f, 
		0.964883f, 0.155163f, -0.211957f, 0.175950f, 0.136267f, 0.974922f, 
		-0.434804f, 0.895961f, -0.0905549f, -0.939505f, 0.322132f, -0.116457f, 
		-0.0652081f, 0.991974f, 0.108326f, -0.0652081f, 0.991974f, 0.108326f, 
		-0.0652081f, 0.991974f, 0.108326f, -0.0652081f, 0.991974f, 0.108326f, 
		0.410859f, 0.836234f, 0.363189f, 0.0132561f, -0.995386f, -0.0950329f, 
		-0.451468f, -0.506472f, -0.734618f, -0.0549070f, 0.392900f, -0.917940f, 
		-0.00875719f, 0.995549f, 0.0938388f, -0.929022f, 0.258770f, 0.264491f, 
		-0.345933f, 0.347641f, -0.871479f, 0.863615f, 0.499600f, 0.0675998f, 
		0.966768f, 0.242445f, 0.0811175f, 0.646408f, 0.762096f, -0.0369717f, 
		0.415239f, -0.891666f, 0.180298f, 0.296548f, 0.136388f, -0.945229f, 
		0.331421f, 0.940831f, -0.0706858f, 0.930890f, 0.174199f, -0.321090f, 
		0.990040f, -0.105556f, 0.0931577f, 0.467917f, -0.145899f, -0.871647f, 
		0.993463f, -0.0914514f, -0.0683285f, 0.694419f, -0.117784f, -0.709865f, 
		0.932857f, 0.231025f, 0.276416f, -0.305792f, 0.408879f, -0.859831f, 
		-0.122113f, 0.587003f, -0.800322f, -0.375654f, 0.300729f, -0.876611f, 
		-0.803670f, 0.434522f, -0.406578f, -0.731078f, 0.480400f, -0.484501f, 
		-0.849136f, 0.413192f, -0.328999f, -0.803670f, 0.434522f, -0.406578f, 
		0.357415f, 0.877756f, 0.319060f, 0.357415f, 0.877756f, 0.319060f, 
		0.319711f, 0.835792f, -0.446359f, 0.244729f, 0.741473f, -0.624760f, 
		-0.596223f, 0.802095f, -0.0340964f, 0.0492751f, 0.653249f, -0.755538f, 
		-0.806413f, -0.474647f, 0.352716f, -0.494438f, -0.707241f, 0.505312f, 
		-0.917455f, -0.281711f, 0.280919f, -0.287159f, 0.315146f, 0.904556f, 
		-0.277473f, -0.755336f, 0.593697f, 0.116715f, -0.914734f, -0.386833f, 
		0.0125185f, -0.916220f, -0.400481f, 0.192575f, -0.920549f, -0.339859f, 
		-0.237337f, -0.404867f, -0.883037f, -0.418532f, -0.411920f, -0.809415f, 
		0.221014f, -0.476579f, -0.850897f, 0.973370f, -0.0351031f, -0.226536f, 
		-0.418532f, -0.411920f, -0.809415f, 0.402691f, -0.517157f, -0.755241f, 
		-0.733215f, -0.390733f, -0.556529f, -0.733215f, -0.390733f, -0.556529f, 
		-0.834474f, -0.387941f, 0.391350f, -0.834474f, -0.387941f, 0.391350f, 
		-0.486463f, 0.0915732f, -0.868889f, 0.859809f, 0.129950f, -0.493804f, 
		0.436225f, -0.0764031f, -0.896588f, -0.0824189f, 0.593286f, -0.800761f, 
		-0.270142f, 0.617991f, -0.738316f, -0.686071f, 0.406459f, -0.603405f, 
		-0.811630f, 0.279888f, -0.512757f, -0.0824189f, 0.593286f, -0.800761f, 
		-0.798854f, 0.219219f, -0.560157f, -0.0726037f, 0.391137f, -0.917464f, 
		-0.0568869f, 0.957630f, 0.282326f, -0.608631f, 0.791934f, 0.0490829f, 
		0.758581f, 0.330817f, 0.561351f, 0.160929f, 0.986912f, -0.0103077f, 
		-0.0681309f, 0.979196f, 0.191139f, -0.0681309f, 0.979196f, 0.191139f, 
		-0.184192f, 0.956191f, 0.227535f, 0.428595f, -0.523186f, 0.736602f, 
		0.569734f, -0.731020f, 0.375517f, 0.258219f, -0.364223f, -0.894799f, 
		0.258219f, -0.364223f, -0.894799f, 0.965136f, -0.257392f, 0.0475607f, 
		0.811248f, -0.545544f, 0.210375f, -0.718515f, -0.513552f, 0.469042f, 
		-0.718515f, -0.513552f, 0.469042f, -0.718515f, -0.513552f, 0.469042f, 
		-0.718515f, -0.513552f, 0.469042f, -0.253463f, 0.868770f, -0.425435f, 
		-0.705100f, -0.472584f, 0.528676f, -0.705100f, -0.472584f, 0.528676f, 
		0.343041f, 0.938107f, 0.0477356f, 0.775616f, 0.130849f, 0.617494f, 
		-0.0748657f, 0.527881f, -0.846012f, -0.912412f, 0.373244f, -0.167911f, 
		-0.912412f, 0.373244f, -0.167911f, -0.912412f, 0.373244f, -0.167911f, 
		-0.912412f, 0.373244f, -0.167911f, 0.161864f, 0.606528f, 0.778411f, 
		-0.298243f, -0.549888f, -0.780176f, 0.443297f, -0.410916f, -0.796640f, 
		-0.310372f, -0.882191f, 0.354131f, 0.205262f, 0.190922f, 0.959904f, 
		0.205262f, 0.190922f, 0.959904f, 0.205262f, 0.190922f, 0.959904f, 
		-0.812527f, 0.555751f, -0.175901f, -0.791223f, -0.339631f, -0.508544f, 
		0.880279f, 0.358767f, -0.310476f, 0.902486f, -0.411805f, -0.126232f, 
		-0.0876098f, 0.995427f, 0.0380644f, 0.964883f, 0.155163f, -0.211957f, 
		0.293570f, 0.598382f, -0.745490f, 0.254825f, 0.503747f, 0.825411f, 
		-0.891194f, 0.410363f, -0.193330f, -0.891194f, 0.410363f, -0.193330f, 
		0.744063f, -0.219407f, 0.631055f, 0.744063f, -0.219407f, 0.631055f, 
		-0.943274f, 0.229623f, 0.239806f, -0.0493659f, 0.338823f, -0.939554f, 
		0.964883f, 0.155163f, -0.211957f, -0.0493659f, 0.338823f, -0.939554f, 
		-0.0493659f, 0.338823f, -0.939554f, -0.0488049f, 0.842581f, 0.536354f, 
		-0.0488049f, 0.842581f, 0.536354f, -0.0488049f, 0.842581f, 0.536354f, 
		-0.0447389f, -0.996565f, -0.0696889f, -0.288260f, -0.269605f, -0.918814f, 
		-0.857894f, 0.0609536f, -0.510198f, -0.857894f, 0.0609536f, -0.510198f, 
		-0.903743f, 0.0243766f, -0.427380f, -0.997826f, 0.0488520f, 0.0442428f, 
		-0.301977f, -0.738867f, -0.602400f, -0.231409f, -0.793448f, -0.562930f, 
		-0.124522f, -0.884414f, -0.449785f, -0.127947f, -0.989983f, 0.0597000f, 
		-0.180084f, -0.0770410f, 0.980630f, 0.268355f, 0.264827f, -0.926203f, 
		0.923856f, 0.129635f, 0.360118f, -0.283979f, 0.0457665f, 0.957738f, 
		-0.279025f, -0.776361f, -0.565163f, -0.0726861f, -0.896165f, 0.437727f, 
		0.938703f, 0.128571f, 0.319854f, 0.823413f, 0.0726048f, 0.562778f, 
		0.366437f, 0.137115f, 0.920285f, 0.606755f, 0.0595279f, 0.792657f, 
		0.683094f, 0.574597f, -0.450800f, 0.689911f, 0.0969157f, -0.717377f, 
		0.655968f, -0.0622696f, -0.752215f, 0.305141f, 0.892983f, -0.330862f, 
		0.305141f, 0.892983f, -0.330862f, 0.995600f, 0.0753109f, 0.0557520f, 
		-0.356247f, 0.723445f, 0.591368f, -0.353158f, 0.854525f, 0.380877f, 
		-0.296782f, 0.623305f, 0.723471f, -0.979698f, 0.144713f, 0.138742f, 
		0.977815f, 0.129191f, 0.164885f, 0.00675794f, -0.0915500f, -0.995778f, 
		0.935000f, 0.240851f, -0.260318f, 0.947079f, -0.281644f, -0.154005f, 
		0.378167f, -0.235035f, -0.895404f, 0.963882f, 0.111585f, -0.241829f, 
		-0.245540f, -0.967474f, -0.0608625f, 0.168190f, -0.981373f, -0.0928403f, 
		0.168190f, -0.981373f, -0.0928403f, -0.938513f, -0.113340f, -0.326110f, 
		-0.356411f, -0.137923f, -0.924093f, -0.801933f, -0.142399f, -0.580194f, 
		-0.987581f, -0.0804328f, 0.134964f, -0.987581f, -0.0804328f, 0.134964f, 
		-0.987581f, -0.0804328f, 0.134964f, 0.775241f, 0.0829227f, 0.626199f, 
		0.0229264f, -0.694662f, -0.718971f, 0.985901f, 0.115815f, -0.120772f, 
		0.976868f, -0.131119f, 0.168928f, -0.239314f, 0.369220f, -0.898001f, 
		-0.647244f, 0.377228f, -0.662401f, -0.647244f, 0.377228f, -0.662401f, 
		-0.647244f, 0.377228f, -0.662401f, 0.909575f, 0.144505f, 0.389604f, 
		0.975496f, 0.219183f, 0.0191353f, 0.954964f, 0.276721f, -0.107097f, 
		-0.662459f, -0.362829f, -0.655365f, -0.664201f, -0.502583f, -0.553396f, 
		-0.478031f, -0.862889f, -0.164038f, -0.735532f, -0.252324f, -0.628749f, 
		-0.599866f, -0.442037f, -0.666906f, -0.0556282f, -0.952103f, -0.300675f, 
		0.301995f, 0.831187f, 0.466827f, 0.470346f, 0.719615f, 0.510812f, 
		0.473948f, -0.432435f, -0.767055f, 0.829257f, 0.408467f, 0.381428f, 
		0.892497f, 0.214459f, 0.396809f, -0.233315f, 0.745194f, 0.624701f, 
		0.630099f, -0.406500f, 0.661614f, 0.747645f, -0.270790f, 0.606383f, 
		0.565131f, -0.344667f, 0.749554f, 0.226665f, 0.0266915f, 0.973607f, 
		0.531286f, -0.530543f, 0.660499f, 0.609631f, -0.479645f, 0.631102f, 
		0.420817f, -0.690590f, 0.588216f, 0.531286f, -0.530543f, 0.660499f, 
		-0.0156672f, -0.472455f, 0.881216f, -0.00473645f, -0.608152f, 0.793806f, 
		0.00813842f, -0.557231f, 0.830318f, 0.547763f, -0.00926520f, -0.836582f, 
		0.365914f, -0.0200495f, -0.930433f, 0.668425f, -0.112419f, -0.735235f, 
		0.633855f, -0.00996650f, -0.773387f, 0.456603f, 0.0243820f, -0.889336f, 
		0.987810f, 0.125340f, -0.0923076f, -0.421521f, -0.0141350f, -0.906709f, 
		-0.254433f, 0.0367760f, -0.966391f, 0.379502f, 0.915988f, 0.130171f, 
		0.379502f, 0.915988f, 0.130171f, 0.991866f, 0.116262f, -0.0518228f, 
		-0.250940f, 0.307690f, 0.917800f, 0.247171f, -0.822265f, 0.512627f, 
		-0.205040f, 0.750639f, 0.628092f, 0.584312f, 0.791187f, -0.180564f, 
		0.910903f, 0.324067f, 0.255413f, 0.0611886f, 0.977048f, 0.204044f, 
		0.126044f, 0.141550f, 0.981874f, 0.0611886f, 0.977048f, 0.204044f, 
		0.126044f, 0.141550f, 0.981874f, 0.448628f, 0.636383f, -0.627494f, 
		-0.241963f, 0.547636f, 0.800967f, 0.972316f, 0.156087f, 0.173894f, 
		0.958125f, 0.143076f, -0.248044f, 0.841532f, 0.129923f, -0.524351f, 
		-0.248191f, 0.835151f, -0.490840f, 0.459567f, -0.660880f, 0.593325f, 
		-0.352135f, 0.878890f, 0.321796f, -0.162448f, 0.942514f, 0.292025f, 
		0.496182f, 0.846829f, -0.191530f, 0.378522f, 0.922572f, -0.0747124f, 
		-0.973033f, 0.158673f, -0.167420f, -0.0605808f, -0.0340500f, -0.997582f, 
		-0.0605808f, -0.0340500f, -0.997582f, -0.993610f, -0.0992867f, -0.0536785f, 
		0.309128f, 0.681839f, 0.662974f, 0.309128f, 0.681839f, 0.662974f, 
		-0.0100422f, 0.713005f, -0.701087f, 0.870776f, 0.484708f, 0.0825136f, 
		-0.798441f, 0.231545f, -0.555769f, -0.376162f, 0.178570f, -0.909184f, 
		-0.317380f, 0.851773f, -0.416836f, -0.390052f, 0.750804f, -0.533060f, 
		-0.523755f, 0.476877f, -0.705882f, -0.232512f, -0.926832f, -0.294822f, 
		-0.644346f, 0.764725f, 0.00378288f, 0.531315f, 0.772984f, -0.346700f, 
		0.531315f, 0.772984f, -0.346700f, -0.644346f, 0.764725f, 0.00378288f, 
		0.949984f, 0.0232110f, 0.311435f, 0.949984f, 0.0232110f, 0.311435f, 
		0.949984f, 0.0232110f, 0.311435f, 0.481876f, -0.637566f, -0.601087f, 
		0.557280f, -0.407674f, -0.723354f, 0.498176f, 0.866765f, 0.0232040f, 
		0.665132f, -0.127759f, -0.735715f, -0.0503407f, -0.962269f, -0.267402f, 
		-0.0503407f, -0.962269f, -0.267402f, -0.0777258f, 0.704650f, -0.705286f, 
		-0.930353f, 0.343334f, -0.128704f, 0.760377f, 0.124088f, 0.637518f, 
		0.0730620f, 0.971963f, 0.223494f, 0.183451f, -0.371146f, 0.910273f, 
		-0.423178f, -0.433199f, 0.795776f, -0.227685f, -0.359497f, 0.904943f, 
		0.639033f, -0.434660f, 0.634592f, 0.735935f, -0.492746f, 0.464328f, 
		0.505614f, 0.636100f, 0.582865f, 0.638748f, -0.272292f, 0.719623f, 
		0.653478f, -0.352469f, 0.669875f, 0.646562f, -0.418754f, 0.637654f, 
		0.653478f, -0.352469f, 0.669875f, 0.0559079f, -0.978470f, 0.198671f, 
		0.510420f, -0.833737f, -0.210605f, 0.958717f, -0.259288f, -0.116756f, 
		-0.958170f, 0.277306f, 0.0707943f, -0.103225f, 0.0525935f, -0.993267f, 
		0.988559f, 0.149233f, 0.0219376f, -0.978136f, -0.193553f, 0.0760716f, 
		0.342963f, -0.0145306f, -0.939236f, 0.432218f, 0.899312f, 0.0665235f, 
		0.990135f, -0.104043f, 0.0938469f, 0.563789f, 0.823912f, -0.0575392f, 
		0.289986f, 0.954017f, 0.0758881f, 0.368236f, -0.0606384f, 0.927753f, 
		-0.935930f, -0.322163f, 0.142292f, -0.998931f, -0.0421145f, 0.0190653f, 
		-0.998958f, 0.0397544f, -0.0223960f, 0.0502956f, 0.134913f, -0.989580f, 
		0.516975f, -0.236690f, 0.822626f, 0.949244f, 0.271940f, 0.158066f, 
		-0.514525f, -0.498721f, 0.697525f, 0.104743f, 0.744541f, 0.659308f, 
		0.431482f, 0.0606741f, 0.900079f, -0.137757f, 0.393842f, -0.908797f, 
		0.733522f, -0.578584f, 0.356632f, 0.570557f, -0.00516352f, -0.821242f, 
		-0.934433f, -0.116094f, -0.336685f, -0.768710f, 0.464515f, -0.439672f, 
		0.327242f, -0.261564f, -0.908018f, -0.856767f, -0.402545f, -0.322348f, 
		-0.880413f, 0.252757f, -0.401232f, 0.532614f, 0.249766f, -0.808665f, 
		0.473948f, -0.432435f, -0.767055f, 0.984511f, 0.134112f, 0.112929f, 
		0.759116f, 0.334773f, 0.558274f, 0.146410f, 0.905616f, 0.398025f, 
		-0.0799428f, 0.956007f, 0.282239f, -0.0799428f, 0.956007f, 0.282239f, 
		-0.0799428f, 0.956007f, 0.282239f, -0.220297f, -0.756939f, 0.615233f, 
		-0.000597419f, 0.848036f, -0.529939f, 0.372832f, -0.0467414f, 0.926721f, 
		-0.0171384f, -0.999416f, 0.0295528f, -0.901346f, -0.389291f, -0.189809f, 
		-0.258714f, -0.554561f, -0.790904f, -0.229755f, -0.936816f, -0.263795f, 
		-0.230347f, -0.873289f, -0.429309f, 0.527948f, 0.847462f, -0.0554863f, 
		-0.0976832f, 0.217589f, -0.971140f, 0.122059f, 0.881871f, -0.455417f, 
		-0.0254662f, 0.539647f, -0.841506f, 0.0307786f, 0.804863f, -0.592662f, 
		-0.148543f, 0.438073f, -0.886581f, 0.870776f, 0.484708f, 0.0825136f, 
		0.958717f, -0.259288f, -0.116756f, -0.148543f, 0.438073f, -0.886581f, 
		-0.416861f, 0.882579f, -0.217442f, -0.416861f, 0.882579f, -0.217442f, 
		0.812510f, 0.379485f, 0.442514f, 0.812510f, 0.379485f, 0.442514f, 
		0.143598f, 0.331468f, 0.932474f, 0.870776f, 0.484708f, 0.0825136f, 
		0.958717f, -0.259288f, -0.116756f, 0.143598f, 0.331468f, 0.932474f, 
		-0.964459f, 0.227998f, 0.133554f, 0.143598f, 0.331468f, 0.932474f, 
		0.143598f, 0.331468f, 0.932474f, -0.0876098f, 0.995427f, 0.0380644f, 
		-0.858038f, 0.475821f, -0.193303f, 0.114944f, 0.451326f, -0.884925f, 
		0.743297f, -0.547951f, 0.383744f, 0.743297f, -0.547951f, 0.383744f, 
		0.743297f, -0.547951f, 0.383744f, 0.408690f, 0.156677f, 0.899124f, 
		0.381134f, -0.521666f, -0.763283f, 0.733302f, 0.0513768f, 0.677959f, 
		-0.0998787f, 0.493562f, -0.863956f, -0.931744f, 0.335094f, -0.139877f, 
		-0.931744f, 0.335094f, -0.139877f, -0.0998787f, 0.493562f, -0.863956f, 
		0.404988f, -0.239930f, 0.882280f, 0.173827f, 0.975265f, -0.136537f, 
		-0.945739f, 0.324838f, 0.00758101f, 0.0612369f, 0.118551f, -0.991058f, 
		0.547579f, -0.629930f, -0.550768f, 0.392159f, -0.225241f, -0.891896f, 
		0.663239f, -0.748202f, -0.0175408f, -0.367279f, -0.793826f, 0.484712f, 
		-0.423759f, -0.642686f, 0.638266f, -0.00189073f, 0.357077f, 0.934073f, 
		-0.474937f, -0.850744f, -0.225099f, -0.300518f, -0.928581f, -0.217775f, 
		-0.214350f, -0.962985f, -0.163443f, -0.609712f, 0.177993f, -0.772379f, 
		-0.175518f, 0.938478f, -0.297409f, -0.285032f, 0.838674f, -0.464093f, 
		-0.609712f, 0.177993f, -0.772379f, -0.589489f, 0.328990f, -0.737746f, 
		-0.172992f, -0.925594f, 0.336673f, 0.0572625f, -0.924830f, 0.376046f, 
		0.300239f, -0.830212f, 0.469685f, 0.167448f, 0.972325f, -0.162927f, 
		-0.958170f, 0.277306f, 0.0707943f, 0.00927820f, 0.202444f, 0.979250f, 
		-0.471806f, -0.264402f, -0.841124f, -0.214960f, -0.914364f, -0.343120f, 
		-0.214960f, -0.914364f, -0.343120f, -0.471806f, -0.264402f, -0.841124f, 
		-0.357829f, -0.727084f, -0.585925f, -0.214960f, -0.914364f, -0.343120f, 
		0.937609f, -0.299783f, 0.176123f, 0.626884f, -0.723772f, 0.288394f, 
		0.275250f, -0.884315f, 0.377127f, 0.530513f, 0.0287349f, 0.847190f, 
		0.406053f, -0.837159f, 0.366449f, 0.545456f, -0.500924f, -0.671977f, 
		0.672095f, -0.491929f, -0.553439f, 0.607591f, -0.516656f, -0.603241f, 
		0.0268406f, -0.992738f, 0.117261f, 0.246651f, 0.415519f, 0.875504f, 
		0.780620f, -0.120010f, 0.613376f, 0.809985f, 0.459927f, -0.363857f, 
		-0.173808f, -0.103346f, -0.979342f, 0.556132f, 0.264191f, 0.787985f, 
		0.976370f, 0.201614f, -0.0778010f, 0.551387f, -0.739848f, 0.385485f, 
		-0.954137f, 0.261241f, -0.146206f, -0.0584929f, 0.447991f, -0.892123f, 
		-0.152591f, 0.924085f, 0.350403f, 0.674550f, 0.733813f, 0.0806197f, 
		-0.235292f, -0.956087f, 0.174747f, -0.915533f, 0.376006f, -0.142893f, 
		-0.915533f, 0.376006f, -0.142893f, -0.460190f, 0.854680f, -0.240305f, 
		-0.952693f, 0.258271f, -0.160222f, -0.758443f, 0.617353f, -0.208901f, 
		0.525417f, 0.170880f, -0.833509f, 0.643297f, 0.270506f, -0.716237f, 
		0.433803f, 0.0837832f, -0.897104f, -0.0733729f, 0.103306f, 0.991940f, 
		0.237456f, 0.850850f, 0.468688f, 0.322293f, -0.333024f, 0.886128f, 
		0.557463f, 0.372792f, 0.741796f, 0.342946f, -0.166995f, -0.924392f, 
		0.342946f, -0.166995f, -0.924392f, -0.967036f, -0.245567f, -0.0673719f, 
		-0.412668f, -0.892106f, 0.183987f, -0.456799f, -0.314273f, -0.832206f, 
		-0.0876098f, 0.995427f, 0.0380644f, -0.931878f, 0.353772f, -0.0803071f, 
		0.117386f, 0.294787f, 0.948326f, -0.195589f, -0.859741f, 0.471794f, 
		-0.0216712f, -0.144570f, 0.989257f, -0.0216712f, -0.144570f, 0.989257f, 
		0.561357f, 0.0720321f, 0.824433f, -0.504479f, -0.431266f, 0.748005f, 
		-0.926390f, -0.361609f, -0.105076f, -0.330064f, -0.933752f, 0.138440f, 
		0.943979f, 0.207374f, 0.256710f, 0.884390f, 0.210493f, 0.416590f, 
		0.921469f, 0.201697f, 0.331984f, 0.385891f, 0.716205f, -0.581497f, 
		-0.546102f, 0.834176f, -0.0769625f, 0.385891f, 0.716205f, -0.581497f, 
		0.427846f, -0.308218f, 0.849676f, 0.269327f, -0.666041f, -0.695595f, 
		-0.746889f, 0.386435f, -0.541133f, -0.163181f, -0.986586f, 0.00440841f, 
		0.903448f, 0.205332f, 0.376325f, 0.954978f, -0.208120f, 0.211431f, 
		0.915484f, -0.357712f, 0.184205f, 0.756311f, 0.523422f, 0.392458f, 
		-0.0516533f, 0.350495f, 0.935139f, -0.0567847f, 0.190320f, 0.980079f, 
		-0.974857f, 0.220008f, 0.0353486f, -0.0567847f, 0.190320f, 0.980079f, 
		0.983151f, 0.156610f, -0.0942711f, -0.410501f, 0.317313f, -0.854869f, 
		-0.816874f, 0.413150f, 0.402521f, -0.297441f, -0.623410f, -0.723110f, 
		-0.297441f, -0.623410f, -0.723110f, -0.584750f, 0.0307294f, -0.810631f, 
		-0.584750f, 0.0307294f, -0.810631f, -0.584750f, 0.0307294f, -0.810631f, 
		-0.584750f, 0.0307294f, -0.810631f, 0.540922f, -0.210721f, -0.814248f, 
		0.0388022f, 0.996040f, 0.0799901f, -0.493329f, 0.632677f, -0.596947f, 
		0.232454f, 0.970244f, -0.0677607f, -0.176933f, 0.970561f, 0.163418f, 
		0.874691f, 0.341392f, 0.344044f, 0.0915073f, 0.974344f, 0.205622f, 
		0.0915073f, 0.974344f, 0.205622f, 0.874691f, 0.341392f, 0.344044f, 
		0.291682f, 0.956171f, -0.0256725f, 0.291682f, 0.956171f, -0.0256725f, 
		-0.931878f, 0.353772f, -0.0803071f, 0.0402682f, 0.217783f, -0.975166f, 
		0.856036f, 0.365145f, -0.365886f, 0.450213f, 0.330493f, -0.829508f, 
		0.142539f, 0.280843f, -0.949110f, 0.0402682f, 0.217783f, -0.975166f, 
		0.142539f, 0.280843f, -0.949110f, 0.923979f, 0.148143f, 0.352587f, 
		0.392606f, 0.886524f, -0.244816f, 0.478797f, 0.118866f, -0.869842f, 
		-0.116125f, 0.993231f, 0.00256226f, -0.116125f, 0.993231f, 0.00256226f, 
		-0.116125f, 0.993231f, 0.00256226f, 0.135137f, 0.857508f, -0.496406f, 
		0.0278965f, 0.700455f, 0.713151f, -0.150534f, 0.916740f, 0.370037f, 
		-0.158159f, 0.960350f, -0.229593f, 0.914054f, 0.332114f, -0.232822f, 
		0.916444f, 0.214245f, 0.337978f, 0.962528f, 0.264953f, 0.0577804f, 
		0.953085f, 0.267233f, -0.142185f, 0.951284f, 0.307334f, -0.0245987f, 
		0.978869f, 0.179020f, 0.0988299f, 0.987523f, -0.0606470f, 0.145329f, 
		0.918669f, -0.317333f, 0.235260f, 0.967577f, -0.166513f, 0.189917f, 
		0.901520f, 0.432707f, 0.00518851f, 0.951611f, 0.305987f, 0.0284180f, 
		-0.593397f, -0.798827f, 0.0987716f, -0.593397f, -0.798827f, 0.0987716f, 
		0.203772f, -0.766911f, 0.608543f, -0.545701f, 0.458463f, 0.701443f, 
		-0.913191f, 0.379110f, -0.149522f, -0.136772f, 0.624124f, -0.769261f, 
		0.958835f, -0.224560f, -0.173803f, 0.958835f, -0.224560f, -0.173803f, 
		-0.788335f, 0.389989f, -0.475853f, -0.726598f, -0.576248f, -0.374156f, 
		-0.0337306f, 0.997800f, 0.0570757f, -0.0490094f, 0.283756f, 0.957643f, 
		0.856036f, 0.365145f, -0.365886f, 0.378548f, -0.807876f, 0.451706f, 
		0.378548f, -0.807876f, 0.451706f, 0.378548f, -0.807876f, 0.451706f, 
		0.378548f, -0.807876f, 0.451706f, -0.0227307f, 0.922536f, 0.385240f, 
		0.824292f, -0.487478f, 0.287938f, 0.824292f, -0.487478f, 0.287938f, 
		0.824292f, -0.487478f, 0.287938f, -0.0493611f, 0.195936f, 0.979374f, 
		-0.0765530f, 0.122291f, 0.989538f, -0.0555031f, 0.285702f, 0.956710f, 
		-0.0493611f, 0.195936f, 0.979374f, -0.599347f, -0.101568f, -0.794020f, 
		-0.172773f, -0.971051f, -0.164955f, 0.608675f, -0.461191f, 0.645614f, 
		-0.599347f, -0.101568f, -0.794020f, 0.739214f, 0.445148f, -0.505377f, 
		0.602831f, 0.762022f, -0.236466f, 0.662953f, 0.622681f, -0.415647f, 
		0.0359078f, 0.0928109f, -0.995036f, 0.0359078f, 0.0928109f, -0.995036f, 
		-0.0607452f, 0.537691f, 0.840951f, 0.612698f, -0.361028f, -0.703036f, 
		0.100300f, -0.986356f, -0.130544f, -0.935536f, 0.321574f, -0.146161f, 
		-0.935536f, 0.321574f, -0.146161f, -0.935536f, 0.321574f, -0.146161f, 
		-0.935536f, 0.321574f, -0.146161f, 0.472335f, -0.374463f, 0.797920f, 
		0.216380f, 0.976224f, -0.0128934f, -0.00636272f, 0.988721f, 0.149635f, 
		0.446757f, 0.873989f, -0.191183f, 0.00376551f, 0.750765f, 0.660559f, 
		0.349245f, -0.724079f, 0.594759f, 0.421980f, -0.577959f, 0.698495f, 
		0.349245f, -0.724079f, 0.594759f, 0.471101f, -0.276866f, 0.837502f, 
		0.471101f, -0.276866f, 0.837502f, 0.421980f, -0.577959f, 0.698495f, 
		-0.325202f, -0.890681f, -0.317695f, -0.978136f, -0.193553f, 0.0760716f, 
		0.570299f, -0.0563905f, -0.819500f, 0.229771f, 0.865919f, -0.444286f, 
		0.570299f, -0.0563905f, -0.819500f, 0.603451f, 0.131991f, 0.786400f, 
		0.0287074f, 0.970090f, 0.241043f, 0.276378f, 0.937131f, 0.213073f, 
		0.603451f, 0.131991f, 0.786400f, 0.142997f, 0.964543f, 0.221832f, 
		0.820932f, 0.365610f, 0.438634f, 0.738850f, 0.495397f, 0.456817f, 
		0.820932f, 0.365610f, 0.438634f, 0.316790f, 0.938715f, 0.135857f, 
		0.529625f, 0.823005f, 0.205330f, 0.595988f, 0.683057f, -0.422175f, 
		-0.575609f, 0.00786435f, -0.817687f, -0.451487f, 0.359428f, -0.816683f, 
		-0.192162f, 0.745646f, -0.638033f, -0.575609f, 0.00786435f, -0.817687f, 
		0.753937f, -0.500192f, -0.425895f, 0.743738f, -0.383476f, -0.547540f, 
		0.754246f, -0.610721f, -0.241108f, -0.380439f, -0.759174f, 0.528130f, 
		-0.0269987f, 0.981420f, -0.189961f, -0.960115f, 0.241838f, -0.140334f, 
		-0.960115f, 0.241838f, -0.140334f, -0.0593744f, 0.998096f, 0.0167034f, 
		0.349490f, 0.936907f, 0.00782265f, 0.200038f, 0.978932f, 0.0409580f, 
		0.751839f, -0.107751f, -0.650483f, 0.619859f, 0.193963f, -0.760364f, 
		0.748024f, -0.582302f, -0.318410f, 0.800304f, -0.332429f, -0.499004f, 
		0.198355f, -0.803481f, -0.561314f, -0.430475f, 0.164100f, -0.887560f, 
		-0.871894f, 0.286150f, 0.397389f, -0.430475f, 0.164100f, -0.887560f, 
		-0.871894f, 0.286150f, 0.397389f, -0.105495f, 0.860793f, 0.497901f, 
		0.663714f, 0.718682f, -0.207316f, 0.113715f, -0.941941f, 0.315938f, 
		-0.131629f, -0.553800f, 0.822180f, 0.229810f, 0.916877f, -0.326379f, 
		0.229810f, 0.916877f, -0.326379f, 0.376489f, -0.788529f, 0.486290f, 
		-0.632948f, -0.728894f, 0.260941f, 0.376489f, -0.788529f, 0.486290f, 
		-0.632948f, -0.728894f, 0.260941f, 0.959564f, -0.259507f, -0.109051f, 
		0.513656f, 0.784060f, 0.348435f, 0.425283f, -0.262589f, -0.866130f, 
		0.959564f, -0.259507f, -0.109051f, 0.959564f, -0.259507f, -0.109051f, 
		0.354024f, 0.785349f, 0.507832f, 0.155746f, -0.0894980f, 0.983734f, 
		0.354024f, 0.785349f, 0.507832f, 0.346589f, 0.0951041f, -0.933183f, 
		-0.296820f, -0.745266f, -0.597056f, -0.446344f, -0.612364f, -0.652524f, 
		-0.508934f, -0.544267f, -0.666903f, 0.254175f, -0.541413f, -0.801416f, 
		0.0974211f, 0.994250f, 0.0444519f, -0.112363f, 0.993630f, -0.00863896f, 
		-0.112363f, 0.993630f, -0.00863896f, -0.180926f, 0.983455f, -0.00902218f, 
		-0.180926f, 0.983455f, -0.00902218f, -0.112363f, 0.993630f, -0.00863896f, 
		-0.112363f, 0.993630f, -0.00863896f, 0.444316f, -0.733589f, -0.514227f, 
		0.570658f, 0.796706f, -0.199022f, -0.216616f, 0.943398f, -0.251153f, 
		-0.503532f, 0.817656f, -0.279094f, -0.731400f, 0.561106f, -0.387576f, 
		-0.818517f, 0.436202f, -0.373843f, -0.351503f, 0.865794f, -0.356156f, 
		-0.745924f, 0.567011f, -0.349422f, -0.0455661f, 0.823245f, 0.565854f, 
		0.473948f, -0.432435f, -0.767055f, 0.973373f, 0.227014f, 0.0317861f, 
		-0.00793764f, -0.760618f, 0.649151f, -0.325202f, -0.890681f, -0.317695f, 
		-0.978136f, -0.193553f, 0.0760716f, -0.200243f, 0.481600f, -0.853208f, 
		0.246651f, 0.415519f, 0.875504f, 0.878678f, 0.141486f, 0.455967f, 
		-0.201155f, -0.643923f, 0.738173f, 0.821712f, -0.542274f, 0.175295f, 
		0.806520f, -0.583998f, 0.0920361f, 0.772495f, -0.633351f, 0.0460199f, 
		0.806520f, -0.583998f, 0.0920361f, 0.372485f, -0.252115f, -0.893136f, 
		0.977876f, -0.0194079f, -0.208285f, 0.372485f, -0.252115f, -0.893136f, 
		0.372485f, -0.252115f, -0.893136f, 0.372485f, -0.252115f, -0.893136f, 
		-0.726598f, -0.576248f, -0.374156f, -0.0776803f, 0.630670f, -0.772153f, 
		0.630210f, -0.776423f, 0.00156956f, 0.592861f, 0.767272f, -0.244561f, 
		0.596530f, -0.299169f, -0.744748f, -0.321743f, -0.892677f, -0.315610f, 
		-0.207147f, -0.918294f, -0.337382f, -0.574144f, -0.757407f, -0.310955f, 
		-0.396221f, -0.855607f, -0.333085f, -0.471033f, -0.820439f, -0.324050f, 
		0.639205f, -0.167142f, -0.750653f, -0.133708f, 0.984698f, -0.111767f, 
		-0.133708f, 0.984698f, -0.111767f, 0.0177911f, 0.935962f, -0.351650f, 
		0.319513f, -0.327549f, 0.889170f, -0.547222f, 0.190941f, 0.814917f, 
		-0.347805f, 0.775731f, 0.526567f, -0.531194f, 0.425917f, 0.732412f, 
		0.330184f, 0.162430f, 0.929836f, -0.179599f, 0.912921f, 0.366497f, 
		-0.663942f, -0.353608f, 0.658895f, 0.549771f, -0.780712f, 0.297053f, 
		0.645785f, -0.0180853f, 0.763305f, 0.123915f, 0.944921f, -0.302936f, 
		0.926486f, -0.0563962f, -0.372080f, 0.648126f, 0.746573f, -0.150207f, 
		0.869107f, 0.494598f, -0.00508153f, 0.508922f, 0.841943f, -0.179251f, 
		0.815890f, -0.0650018f, -0.574541f, 0.678447f, 0.193371f, -0.708743f, 
		0.778916f, 1.46706e-005f, -0.627128f, -0.415647f, 0.0539487f, -0.907925f, 
		-0.893805f, 0.203259f, 0.399748f, 0.179366f, 0.980539f, -0.0798179f, 
		-0.584112f, -0.773171f, 0.247023f, 0.387528f, -0.733603f, 0.558255f, 
		-0.584112f, -0.773171f, 0.247023f, 0.617293f, 0.330747f, 0.713832f, 
		0.994399f, 0.0589866f, -0.0876953f, 0.485856f, 0.580162f, 0.653725f, 
		0.652627f, 0.135930f, 0.745387f, 0.647213f, 0.739531f, 0.184958f, 
		-0.352919f, -0.140052f, 0.925113f, -0.670267f, 0.158475f, 0.725002f, 
		-0.702281f, 0.369482f, 0.608510f, 0.286452f, -0.128032f, 0.949502f, 
		0.0927196f, -0.180394f, 0.979214f, 0.506118f, 0.263894f, 0.821100f, 
		-0.822012f, 0.369288f, 0.433500f, 0.467995f, -0.211213f, -0.858120f, 
		-0.529561f, 0.544113f, 0.650774f, -0.949875f, 0.279705f, -0.139650f, 
		-0.949875f, 0.279705f, -0.139650f, -0.529561f, 0.544113f, 0.650774f, 
		-0.246062f, 0.938891f, -0.240702f, 0.169516f, 0.985280f, 0.0220619f, 
		0.220621f, 0.716949f, -0.661294f, 0.112633f, 0.936977f, -0.330738f, 
		0.242362f, 0.619667f, -0.746507f, 0.535449f, 0.0495739f, 0.843112f, 
		0.535449f, 0.0495739f, 0.843112f, 0.211917f, -0.928074f, 0.306218f, 
		-0.0987387f, -0.954811f, 0.280332f, -0.278158f, -0.924002f, 0.262389f, 
		0.0435344f, 0.900268f, -0.433154f, 0.855340f, 0.359182f, 0.373338f, 
		0.0335873f, 0.997005f, 0.0696657f, 0.761048f, -0.612957f, -0.212343f, 
		0.462422f, -0.838720f, -0.287602f, 0.894991f, -0.414860f, -0.163959f, 
		0.894991f, -0.414860f, -0.163959f, 0.462422f, -0.838720f, -0.287602f, 
		0.650913f, -0.376908f, -0.658978f, -0.0778893f, -0.949746f, 0.303175f, 
		0.105708f, -0.985832f, -0.130236f, -0.846619f, 0.341499f, 0.408184f, 
		0.447512f, 0.150842f, 0.881464f, 0.447512f, 0.150842f, 0.881464f, 
		-0.846619f, 0.341499f, 0.408184f, 0.925737f, -0.366255f, -0.0941748f, 
		0.337811f, -0.915642f, -0.217909f, -0.878245f, 0.328205f, -0.347802f, 
		-0.206871f, 0.915168f, -0.345936f, -0.360537f, -0.622307f, -0.694800f, 
		-0.360537f, -0.622307f, -0.694800f, -0.105432f, 0.325011f, -0.939815f, 
		0.486480f, -0.287187f, 0.825143f, -0.525253f, -0.00309761f, -0.850940f, 
		-0.696469f, 0.196800f, -0.690073f, 0.633319f, -0.630974f, 0.448084f, 
		0.579527f, -0.403533f, 0.708032f, -0.301557f, -0.232559f, -0.924651f, 
		-0.0337306f, 0.997800f, 0.0570757f, -0.627166f, 0.559973f, -0.541381f, 
		0.374115f, 0.387064f, -0.842745f, 0.374115f, 0.387064f, -0.842745f, 
		0.665810f, -0.520187f, 0.534886f, 0.449685f, -0.874708f, 0.180748f, 
		0.840977f, -0.0763401f, -0.535658f, -0.966320f, 0.218922f, -0.135270f, 
		-0.369684f, 0.873110f, 0.317826f, -0.502201f, 0.721146f, 0.477223f, 
		0.186912f, 0.978508f, -0.0871008f, 0.436397f, 0.886824f, -0.151987f, 
		-0.118061f, 0.973690f, -0.194909f, -0.210033f, 0.977230f, -0.0301292f, 
		-0.210033f, 0.977230f, -0.0301292f, -0.210033f, 0.977230f, -0.0301292f, 
		-0.0548058f, -0.573763f, -0.817185f, -0.166089f, -0.966973f, 0.193334f, 
		-0.349574f, -0.930241f, 0.111574f, 0.512389f, -0.762243f, 0.395529f, 
		0.226023f, -0.929141f, 0.292594f, -0.166089f, -0.966973f, 0.193334f, 
		0.280189f, 0.958315f, -0.0559201f, 0.379851f, -0.831025f, -0.406339f, 
		-0.0950868f, 0.954263f, 0.283445f, 0.0685818f, 0.985456f, 0.155476f, 
		-0.00793885f, 0.969967f, 0.243107f, -0.156744f, 0.965167f, 0.209487f, 
		-0.0725274f, 0.980653f, 0.181821f, -0.176617f, 0.980342f, 0.0879511f, 
		0.349887f, -0.0867501f, -0.932767f, 0.189312f, -0.0807004f, -0.978595f, 
		0.496563f, -0.0409016f, -0.867036f, 0.607706f, 0.124434f, 0.784353f, 
		0.451663f, 0.370521f, 0.811613f, 0.184367f, 0.924493f, 0.333648f, 
		0.0573577f, 0.966859f, 0.248784f, 0.242722f, 0.858761f, 0.451237f, 
		0.997995f, -0.0169915f, -0.0609669f, 0.242722f, 0.858761f, 0.451237f, 
		-0.0983920f, 0.993304f, 0.0605542f, 0.451193f, 0.685182f, -0.571796f, 
		-0.0453389f, -0.302381f, -0.952108f, -0.892257f, 0.197739f, 0.405928f, 
		0.177353f, 0.981970f, -0.0654299f, 0.413183f, 0.0406415f, 0.909741f, 
		0.696815f, -0.644671f, -0.314401f, 0.926576f, 0.103538f, 0.361575f, 
		0.893702f, -0.156805f, 0.420368f, 0.799271f, -0.301070f, 0.520119f, 
		0.900571f, 0.259819f, 0.348520f, 0.912388f, -0.0174155f, 0.408957f, 
		0.685401f, 0.0663438f, -0.725137f, -0.226915f, -0.744499f, 0.627878f, 
		-0.0359629f, -0.792848f, -0.608357f, 0.692983f, 0.439762f, -0.571299f, 
		-0.531318f, 0.846388f, 0.0364466f, -0.573459f, 0.817824f, -0.0480528f, 
		-0.566308f, 0.795736f, -0.214709f, -0.545999f, 0.824240f, -0.150046f, 
		-0.552418f, 0.701798f, -0.449793f, -0.573459f, 0.817824f, -0.0480528f, 
		0.287470f, -0.825900f, 0.485026f, -0.0530581f, -0.292677f, 0.954738f, 
		-0.234245f, 0.960718f, 0.148828f, -0.234245f, 0.960718f, 0.148828f, 
		-0.234245f, 0.960718f, 0.148828f, -0.0755007f, 0.839477f, -0.538125f, 
		-0.0755007f, 0.839477f, -0.538125f, -0.255557f, 0.836614f, -0.484528f, 
		0.578693f, 0.792123f, -0.194051f, -0.0754749f, 0.285313f, 0.955458f, 
		-0.0754749f, 0.285313f, 0.955458f, -0.0754749f, 0.285313f, 0.955458f, 
		0.729723f, -0.405140f, -0.550787f, -0.0790658f, 0.899742f, 0.429200f, 
		-0.134769f, 0.943201f, 0.303658f, -0.336494f, 0.936255f, -0.100989f, 
		-0.432071f, -0.895665f, 0.105348f, -0.0790658f, 0.899742f, 0.429200f, 
		0.379150f, -0.897394f, 0.225674f, 0.290773f, -0.933066f, 0.211752f, 
		0.379150f, -0.897394f, 0.225674f, 0.290773f, -0.933066f, 0.211752f, 
		-0.140237f, -0.984902f, 0.101497f, 0.0701326f, -0.980697f, -0.182521f, 
		0.201558f, -0.967526f, -0.152537f, 0.137487f, -0.979833f, -0.145001f, 
		0.0587980f, -0.998202f, 0.0116555f, 0.135894f, -0.623616f, 0.769828f, 
		0.164891f, -0.978314f, 0.125347f, 0.248778f, -0.952678f, 0.174684f, 
		0.213123f, -0.889890f, 0.403329f, -0.251945f, -0.967038f, 0.0368934f, 
		-0.271065f, -0.958073f, -0.0928488f, -0.181154f, -0.935480f, 0.303415f, 
		-0.271065f, -0.958073f, -0.0928488f, -0.251945f, -0.967038f, 0.0368934f, 
		-0.0662224f, -0.981104f, 0.181793f, 0.520153f, -0.316778f, 0.793154f, 
		0.538837f, -0.372639f, -0.755509f, 0.0929923f, -0.993733f, 0.0620255f, 
		0.217784f, 0.901728f, 0.373440f, 0.635653f, 0.632115f, 0.443144f, 
		0.417277f, 0.790545f, 0.448239f, 0.364421f, -0.250211f, -0.896990f, 
		0.364421f, -0.250211f, -0.896990f, -0.00852845f, -0.00524741f, -0.999950f, 
		-0.800584f, 0.0478331f, 0.597308f, 0.169079f, -0.380490f, 0.909197f, 
		-0.289920f, -0.673448f, 0.680010f, 0.351870f, 0.703329f, 0.617670f, 
		-0.0719214f, 0.829581f, -0.553735f, 0.351870f, 0.703329f, 0.617670f, 
		0.651023f, -0.634327f, 0.416891f, 0.715496f, -0.540305f, 0.442873f, 
		0.651023f, -0.634327f, 0.416891f, 0.577916f, -0.696194f, 0.425825f, 
		-0.0149676f, 0.819905f, -0.572304f, -0.216623f, 0.938740f, 0.268035f, 
		-0.216623f, 0.938740f, 0.268035f, 0.721461f, 0.662399f, -0.201796f, 
		-0.248167f, 0.241967f, 0.938011f, 0.131660f, 0.991244f, -0.0100427f, 
		-0.154045f, 0.294262f, 0.943229f, -0.327508f, 0.145377f, 0.933598f, 
		0.185706f, -0.982533f, -0.0119371f, 0.305493f, -0.952155f, 0.00865609f, 
		0.444389f, -0.874481f, -0.194428f, 0.272718f, -0.959703f, -0.0677793f, 
		0.200884f, -0.969445f, -0.140793f, -0.0337306f, 0.997800f, 0.0570757f, 
		-0.0727608f, 0.245900f, 0.966560f, -0.0727608f, 0.245900f, 0.966560f, 
		-0.627166f, 0.559973f, -0.541381f, -0.999365f, 0.0353305f, -0.00470060f, 
		-0.261158f, -0.752292f, 0.604858f, 0.330834f, -0.915638f, 0.228379f, 
		0.330834f, -0.915638f, 0.228379f, -0.627166f, 0.559973f, -0.541381f, 
		-0.999365f, 0.0353305f, -0.00470060f, 0.206913f, 0.310533f, -0.927769f, 
		0.988546f, 0.150895f, 0.00273752f, 0.206913f, 0.310533f, -0.927769f, 
		0.206913f, 0.310533f, -0.927769f, -0.139033f, 0.722995f, 0.676718f, 
		-0.617105f, -0.554003f, 0.558804f, -0.216148f, -0.916841f, 0.335681f, 
		-0.370632f, -0.803268f, 0.466254f, -0.124982f, -0.840026f, 0.527954f, 
		0.159123f, -0.659728f, 0.734465f, -0.999365f, 0.0353305f, -0.00470060f, 
		0.638422f, 0.492142f, 0.591789f, 0.988546f, 0.150895f, 0.00273752f, 
		-0.174470f, 0.100853f, 0.979484f, 0.272305f, 0.942989f, -0.191367f, 
		0.0571323f, 0.966616f, -0.249777f, -0.0565622f, 0.970135f, -0.235878f, 
		-0.171230f, 0.942288f, -0.287703f, 0.438575f, 0.886699f, -0.146344f, 
		0.656466f, -0.257038f, -0.709214f, 0.379187f, 0.917295f, 0.121601f, 
		-0.0409337f, 0.238153f, 0.970365f, -0.0409337f, 0.238153f, 0.970365f, 
		0.832939f, 0.509998f, 0.214743f, 0.856702f, 0.227021f, 0.463167f, 
		0.641038f, 0.763881f, -0.0745382f, 0.512434f, 0.836989f, -0.191992f, 
		0.00933688f, -0.938174f, -0.346038f, 0.735447f, 0.554652f, 0.389203f, 
		-0.169453f, 0.312245f, -0.934767f, 0.478334f, 0.875819f, -0.0643180f, 
		0.916135f, 0.389788f, 0.0936064f, 0.820692f, 0.553331f, 0.142440f, 
		0.318106f, 0.930119f, -0.183539f, 0.731904f, -0.650603f, 0.202566f, 
		-0.177640f, -0.963295f, 0.201263f, 0.0362990f, -0.965860f, 0.256508f, 
		-0.0677863f, -0.964300f, 0.255988f, 0.209939f, -0.0119085f, -0.977642f, 
		-0.0406322f, -0.907648f, -0.417761f, 0.747380f, -0.254133f, 0.613873f, 
		0.0872610f, 0.991147f, 0.100067f, 0.638422f, 0.492142f, 0.591789f, 
		0.988546f, 0.150895f, 0.00273752f, 0.295087f, 0.403400f, -0.866136f, 
		0.744628f, 0.661005f, -0.0927417f, 0.666143f, 0.745408f, -0.0248850f, 
		0.615895f, 0.787518f, 0.0221125f, 0.252334f, -0.514928f, -0.819254f, 
		0.0150024f, -0.819921f, 0.572280f, -0.0463810f, 0.789201f, 0.612380f, 
		0.317290f, -0.261514f, 0.911558f, -0.233648f, 0.267650f, 0.934758f, 
		-0.0341654f, -0.974406f, 0.222184f, -0.455731f, -0.273689f, 0.846997f, 
		-0.748980f, 0.0220951f, 0.662224f, -0.664832f, 0.318678f, 0.675606f, 
		-0.532129f, 0.486651f, 0.692827f, -0.210236f, -0.367435f, 0.905976f, 
		0.00781301f, 0.000886663f, 0.999969f, 0.0781704f, 0.963815f, -0.254855f, 
		0.0781704f, 0.963815f, -0.254855f, 0.165713f, 0.647238f, -0.744057f, 
		-0.442790f, 0.894432f, -0.0626764f, -0.959111f, 0.282363f, 0.0194308f, 
		-0.959111f, 0.282363f, 0.0194308f, -0.442790f, 0.894432f, -0.0626764f, 
		-0.959111f, 0.282363f, 0.0194308f, -0.0794889f, -0.995023f, 0.0600946f, 
		0.373362f, -0.919703f, 0.121443f, 0.544597f, -0.820349f, 0.174474f, 
		-0.272030f, -0.961192f, 0.0459242f, 0.0175382f, 0.981952f, -0.188317f, 
		-0.478069f, 0.132811f, -0.868223f, -0.846631f, 0.360088f, 0.391857f, 
		-0.478069f, 0.132811f, -0.868223f, 0.181341f, 0.978899f, -0.0941887f, 
		0.709697f, -0.440172f, -0.550072f, 0.764828f, -0.465652f, -0.445203f, 
		0.0442433f, 0.293701f, -0.954873f, 0.0432281f, 0.970183f, -0.238486f, 
		0.412701f, -0.0779450f, -0.907525f, 0.291744f, 0.948397f, -0.124214f, 
		0.372362f, 0.928081f, -0.00335930f, -0.451159f, -0.878644f, 0.156334f, 
		-0.981054f, -0.192927f, 0.0176512f, -0.927184f, -0.367174f, 0.0742552f, 
		-0.727710f, -0.669800f, 0.147667f, 0.362348f, 0.928576f, 0.0803185f, 
		0.362348f, 0.928576f, 0.0803185f, -0.000288415f, 0.917600f, 0.397505f, 
		0.817859f, 0.483449f, -0.312064f, -0.581709f, 0.0142426f, 0.813272f, 
		-0.105765f, 0.621570f, 0.776186f, 0.784006f, 0.310952f, 0.537256f, 
		0.771867f, 0.228442f, -0.593325f, 0.144033f, 0.986183f, -0.0818433f, 
		-0.846966f, -0.0724550f, 0.526686f, -0.938517f, -0.131917f, -0.319036f, 
		-0.301146f, 0.227413f, 0.926064f, -0.301146f, 0.227413f, 0.926064f, 
		0.0878751f, 0.953931f, 0.286869f, 0.0162586f, 0.994374f, -0.104668f, 
		-0.0386570f, 0.978564f, -0.202281f, 0.788111f, 0.0322633f, 0.614687f, 
		0.574656f, -0.597609f, -0.559137f, 0.541743f, 0.731213f, 0.414539f, 
		0.958810f, -0.0400435f, 0.281211f, -0.298801f, 0.442340f, 0.845608f, 
		-0.298801f, 0.442340f, 0.845608f, -0.756845f, 0.584745f, -0.291992f, 
		-0.298801f, 0.442340f, 0.845608f, -0.298801f, 0.442340f, 0.845608f, 
		-0.588216f, 0.796372f, -0.140689f, -0.939509f, 0.268440f, -0.212749f, 
		-0.751248f, 0.635385f, -0.178639f, -0.588216f, 0.796372f, -0.140689f, 
		-0.939509f, 0.268440f, -0.212749f, 0.0623484f, 0.788768f, 0.611521f, 
		0.684468f, -0.379608f, -0.622415f, 0.684468f, -0.379608f, -0.622415f, 
		0.448119f, 0.889105f, -0.0931768f, 0.580626f, -0.130598f, 0.803628f, 
		0.580626f, -0.130598f, 0.803628f, -0.631352f, 0.0625508f, -0.772970f, 
		-0.956464f, -0.253595f, -0.144450f, -0.185590f, -0.981075f, 0.0552096f, 
		-0.956464f, -0.253595f, -0.144450f, -0.185590f, -0.981075f, 0.0552096f, 
		0.0872610f, 0.991147f, 0.100067f, -0.481848f, 0.204267f, 0.852113f, 
		0.638422f, 0.492142f, 0.591789f, 0.600396f, 0.00638659f, -0.799677f, 
		0.334422f, -0.905019f, -0.262872f, -0.453536f, 0.478017f, -0.752200f, 
		0.555540f, -0.786476f, -0.269873f, 0.625660f, 0.688756f, -0.366284f, 
		-0.836076f, -0.473431f, 0.277199f, -0.836076f, -0.473431f, 0.277199f, 
		-0.836076f, -0.473431f, 0.277199f, -0.836076f, -0.473431f, 0.277199f, 
		0.458160f, -0.713906f, 0.529554f, 0.0450455f, 0.298190f, 0.953443f, 
		-0.767911f, -0.125101f, 0.628222f, -0.139033f, 0.722995f, 0.676718f, 
		-0.644229f, -0.332032f, 0.689001f, -0.0991089f, -0.565564f, 0.818727f, 
		-0.319980f, -0.471778f, 0.821607f, 0.266466f, 0.140275f, -0.953582f, 
		-0.0526666f, -0.982416f, 0.179125f, 0.0255064f, -0.953226f, 0.301180f, 
		-0.0663016f, 0.866434f, 0.494869f, 0.104988f, -0.938907f, 0.327767f, 
		-0.145049f, -0.985897f, -0.0834780f, -0.0113748f, -0.972291f, 0.233497f, 
		0.0255064f, -0.953226f, 0.301180f, -0.172857f, 0.978596f, 0.111667f, 
		0.135029f, 0.968854f, -0.207581f, -0.292513f, 0.886806f, 0.357787f, 
		-0.285700f, 0.955374f, 0.0750700f, 0.570101f, 0.664403f, -0.483273f, 
		-0.320262f, 0.902271f, -0.288687f, -0.572036f, 0.817021f, 0.0724682f, 
		-0.412704f, 0.551626f, -0.724834f, -0.517237f, 0.316013f, -0.795363f, 
		-0.691584f, 0.645365f, 0.324369f, -0.569581f, 0.146984f, -0.808686f, 
		-0.517237f, 0.316013f, -0.795363f, 0.331514f, -0.942913f, -0.0318442f, 
		0.331514f, -0.942913f, -0.0318442f, 0.0766816f, -0.995488f, -0.0558975f, 
		0.830353f, -0.552551f, -0.0721234f, 0.807387f, -0.145280f, -0.571856f, 
		-0.761234f, -0.335245f, 0.555097f, 0.174801f, -0.638252f, -0.749719f, 
		0.156307f, -0.978780f, -0.132508f, 0.156307f, -0.978780f, -0.132508f, 
		0.146298f, -0.957673f, -0.247911f, -0.995997f, 0.0155365f, 0.0880241f, 
		-0.995997f, 0.0155365f, 0.0880241f, -0.995997f, 0.0155365f, 0.0880241f, 
		-0.271318f, 0.958177f, 0.0910090f, -0.271318f, 0.958177f, 0.0910090f, 
		-0.332427f, 0.923450f, 0.191658f, -0.779209f, 0.448780f, 0.437527f, 
		-0.493031f, 0.810728f, 0.315659f, -0.332427f, 0.923450f, 0.191658f, 
		0.474162f, 0.825030f, 0.307402f, -0.891234f, -0.334954f, -0.305790f, 
		-0.836609f, -0.181523f, 0.516851f, -0.891234f, -0.334954f, -0.305790f, 
		-0.304377f, -0.952507f, 0.00919433f, 0.0549275f, 0.570153f, 0.819700f, 
		-0.249150f, -0.707356f, 0.661492f, 0.958810f, -0.0400435f, 0.281211f, 
		-0.756845f, 0.584745f, -0.291992f, 0.419429f, 0.115856f, -0.900365f, 
		0.419429f, 0.115856f, -0.900365f, 0.191178f, -0.175349f, -0.965766f, 
		0.311209f, 0.949818f, 0.0315311f, 0.311209f, 0.949818f, 0.0315311f, 
		0.958810f, -0.0400435f, 0.281211f, 0.281838f, -0.0483371f, -0.958244f, 
		0.804180f, 0.202488f, -0.558832f, 0.502507f, -0.740685f, -0.445952f, 
		0.804180f, 0.202488f, -0.558832f, 0.804180f, 0.202488f, -0.558832f, 
		-0.0257831f, 0.908932f, 0.416147f, 0.112002f, 0.554356f, -0.824709f, 
		0.106158f, -0.292562f, -0.950336f, 0.106158f, -0.292562f, -0.950336f, 
		0.484499f, -0.328491f, 0.810774f, 0.495477f, 0.0276929f, 0.868179f, 
		-0.846744f, 0.357913f, 0.393603f, 0.179366f, 0.980539f, -0.0798179f, 
		0.495477f, 0.0276929f, 0.868179f, 0.0778980f, 0.949744f, -0.303182f, 
		0.833162f, 0.0551337f, -0.550274f, -0.198892f, 0.461845f, -0.864373f, 
		-0.453123f, -0.840366f, 0.297430f, -0.587946f, -0.727616f, 0.353404f, 
		-0.719636f, -0.591737f, 0.363279f, -0.453123f, -0.840366f, 0.297430f, 
		-0.507295f, -0.783792f, 0.358221f, -0.778881f, -0.520034f, 0.350584f, 
		-0.119930f, 0.686120f, 0.717534f, -0.0777723f, 0.654469f, 0.752078f, 
		0.00347549f, 0.603543f, 0.797323f, 0.794596f, 0.607137f, -0.00144635f, 
		0.456249f, 0.824187f, 0.335488f, 0.234849f, 0.915177f, 0.327562f, 
		0.0132662f, 0.264907f, 0.964183f, 0.729529f, 0.506884f, 0.459190f, 
		0.833295f, 0.224667f, 0.505119f, 0.500364f, -0.163904f, 0.850159f, 
		0.188421f, -0.932998f, -0.306615f, 0.188421f, -0.932998f, -0.306615f, 
		0.188421f, -0.932998f, -0.306615f, 0.188421f, -0.932998f, -0.306615f, 
		0.149311f, 0.985276f, 0.0832909f, -0.869065f, -0.0701476f, -0.489700f, 
		-0.923882f, -0.131943f, 0.359211f, 0.817887f, 0.471801f, -0.329340f, 
		0.155610f, 0.929265f, -0.335041f, 0.289764f, 0.955393f, -0.0571112f, 
		0.280123f, 0.260551f, -0.923929f, 0.517611f, -0.752131f, 0.407895f, 
		0.230582f, -0.199395f, -0.952404f, 0.428299f, -0.286125f, -0.857142f, 
		0.0838051f, 0.0227716f, -0.996222f, -0.373907f, -0.896283f, 0.238475f, 
		0.839575f, -0.305549f, -0.449170f, 0.250898f, 0.967951f, -0.0110290f, 
		0.250898f, 0.967951f, -0.0110290f, -0.321958f, -0.753638f, 0.573038f, 
		-0.0186269f, 0.283740f, 0.958720f, -0.978635f, -0.0533189f, -0.198570f, 
		-0.978635f, -0.0533189f, -0.198570f, -0.978635f, -0.0533189f, -0.198570f, 
		-0.690375f, 0.723087f, 0.0229653f, -0.777916f, 0.626380f, -0.0499441f, 
		-0.734000f, 0.679146f, -0.00205390f, -0.690375f, 0.723087f, 0.0229653f, 
		-0.631527f, 0.773017f, 0.0601570f, -0.549070f, 0.832081f, 0.0785054f, 
		0.0293658f, 0.931815f, -0.361743f, 0.300106f, 0.914521f, -0.271269f, 
		0.202702f, 0.926066f, -0.318297f, -0.135139f, 0.910026f, -0.391905f, 
		0.103187f, 0.941549f, -0.320683f, -0.907747f, 0.136069f, 0.396837f, 
		-0.907747f, 0.136069f, 0.396837f, -0.838338f, 0.365007f, 0.404918f, 
		-0.896597f, 0.0807582f, 0.435422f, -0.920215f, 0.00946804f, 0.391298f, 
		-0.882406f, -0.116517f, 0.455833f, -0.920215f, 0.00946804f, 0.391298f, 
		-0.920215f, 0.00946804f, 0.391298f, -0.190133f, -0.789798f, -0.583154f, 
		-0.881669f, -0.210277f, 0.422426f, 0.353605f, -0.934360f, 0.0439867f, 
		0.837969f, -0.464596f, 0.286283f, -0.701651f, 0.693363f, -0.164117f, 
		-0.647480f, 0.760578f, -0.0478638f, -0.647480f, 0.760578f, -0.0478638f, 
		-0.839646f, 0.452024f, -0.301113f, -0.701651f, 0.693363f, -0.164117f, 
		0.583953f, -0.722605f, -0.369920f, -0.623265f, -0.640326f, 0.448913f, 
		-0.754825f, 0.552972f, 0.352791f, 0.572271f, 0.603831f, 0.554882f, 
		0.572271f, 0.603831f, 0.554882f, 0.594325f, 0.466506f, 0.655095f, 
		0.605508f, 0.0983233f, 0.789742f, -0.754825f, 0.552972f, 0.352791f, 
		0.486759f, 0.0772291f, 0.870115f, 0.879231f, 0.195730f, -0.434329f, 
		0.139516f, 0.985778f, 0.0936814f, -0.378804f, 0.673544f, 0.634702f, 
		-0.756845f, 0.584745f, -0.291992f, 0.401898f, 0.433433f, -0.806606f, 
		0.327989f, 0.870392f, -0.367207f, 0.882711f, 0.196726f, 0.426755f, 
		0.843762f, -0.427216f, -0.324888f, -0.877597f, -0.334766f, 0.343156f, 
		-0.858570f, -0.178387f, -0.480662f, -0.877597f, -0.334766f, 0.343156f, 
		-0.924211f, -0.332343f, -0.188099f, -0.924211f, -0.332343f, -0.188099f, 
		-0.0770149f, -0.989008f, 0.126220f, -0.0770149f, -0.989008f, 0.126220f, 
		0.106426f, -0.609843f, 0.785344f, -0.0455513f, 0.262758f, 0.963786f, 
		-0.461638f, 0.858465f, 0.223445f, -0.258873f, 0.758109f, -0.598545f, 
		0.445729f, 0.812552f, 0.375612f, 0.0672036f, -0.968463f, -0.239923f, 
		0.0672036f, -0.968463f, -0.239923f, -0.0581168f, 0.966116f, -0.251478f, 
		-0.0589376f, 0.363247f, 0.929827f, 0.606625f, -0.670089f, 0.427769f, 
		0.606625f, -0.670089f, 0.427769f, 0.647264f, -0.724876f, -0.235803f, 
		0.533619f, 0.744306f, -0.401571f, -0.899493f, -0.362944f, -0.243279f, 
		0.00922639f, -0.974838f, -0.222723f, 0.00922639f, -0.974838f, -0.222723f, 
		-0.899493f, -0.362944f, -0.243279f, 0.125207f, 0.548219f, -0.826909f, 
		0.829319f, -0.0801428f, -0.552998f, 0.499395f, 0.717776f, -0.485182f, 
		0.761671f, -0.0301401f, -0.647262f, -0.568576f, 0.389706f, -0.724466f, 
		-0.282685f, 0.940460f, -0.188746f, -0.282685f, 0.940460f, -0.188746f, 
		-0.236388f, -0.796358f, -0.556718f, 0.638290f, -0.702338f, -0.315131f, 
		0.771865f, -0.414875f, -0.481771f, 0.785643f, -0.295838f, -0.543364f, 
		0.249693f, -0.961831f, -0.111959f, 0.655616f, 0.720433f, -0.226148f, 
		0.464018f, 0.219084f, 0.858306f, 0.866271f, 0.224573f, -0.446252f, 
		0.464018f, 0.219084f, 0.858306f, 0.866271f, 0.224573f, -0.446252f, 
		0.0389620f, 0.973727f, 0.224359f, 0.875024f, 0.327130f, -0.356817f, 
		-0.541064f, 0.0306640f, 0.840422f, -0.472540f, 0.164235f, 0.865871f, 
		0.0232651f, 0.431869f, 0.901636f, -0.278578f, 0.326668f, 0.903151f, 
		-0.985425f, 0.0408291f, -0.165141f, 0.494703f, 0.235796f, -0.836462f, 
		0.956683f, 0.256291f, 0.138107f, 0.494703f, 0.235796f, -0.836462f, 
		0.494703f, 0.235796f, -0.836462f, 0.0872610f, 0.991147f, 0.100067f, 
		-0.652857f, 0.424248f, 0.627528f, -0.985425f, 0.0408291f, -0.165141f, 
		0.290867f, 0.398408f, -0.869867f, 0.833641f, -0.289384f, -0.470425f, 
		0.924979f, 0.0175945f, 0.379611f, -0.355321f, -0.801143f, 0.481577f, 
		0.574664f, 0.152481f, 0.804059f, 0.574664f, 0.152481f, 0.804059f, 
		-0.863985f, -0.395505f, -0.311619f, -0.758826f, -0.436808f, 0.483096f, 
		-0.193114f, -0.981146f, -0.00772769f, -0.591147f, 0.251777f, -0.766260f, 
		-0.591147f, 0.251777f, -0.766260f, 0.442501f, 0.0258919f, -0.896394f, 
		0.442501f, 0.0258919f, -0.896394f, -0.409104f, -0.912423f, 0.0108828f, 
		-0.845138f, 0.497783f, 0.194819f, 0.582020f, -0.304948f, -0.753830f, 
		0.506316f, -0.580865f, -0.637370f, 0.550574f, -0.459296f, -0.697076f, 
		-0.502421f, -0.718087f, 0.481585f, -0.800001f, 0.501932f, -0.328729f, 
		-0.886866f, 0.135092f, 0.441835f, -0.587103f, 0.776351f, -0.229323f, 
		-0.248606f, 0.962550f, -0.108131f, 0.467373f, -0.681277f, 0.563404f, 
		0.564589f, -0.551252f, 0.614297f, -0.0378215f, 0.227791f, 0.972975f, 
		0.751468f, -0.272945f, 0.600664f, 0.159419f, -0.959162f, 0.233654f, 
		-0.579780f, -0.808648f, 0.0997176f, -0.957594f, -0.288093f, 0.00392043f, 
		-0.674606f, -0.736595f, 0.0483106f, -0.422836f, -0.889893f, 0.171170f, 
		-0.821530f, -0.562943f, 0.0904589f, -0.887056f, -0.459007f, 0.0494289f, 
		0.889269f, 0.233394f, -0.393355f, -0.399188f, -0.912256f, 0.0918600f, 
		-0.399188f, -0.912256f, 0.0918600f, -0.399188f, -0.912256f, 0.0918600f, 
		-0.579425f, 0.495181f, -0.647351f, -0.304005f, 0.786187f, -0.538044f, 
		-0.480756f, 0.577886f, -0.659485f, 0.129511f, 0.939691f, 0.316555f, 
		0.0340373f, 0.970169f, 0.240029f, -0.109261f, 0.993034f, 0.0441071f, 
		-0.0376531f, 0.990819f, 0.129843f, -0.231711f, 0.945644f, -0.228183f, 
		0.457204f, -0.131059f, 0.879652f, 0.451691f, -0.714747f, -0.533958f, 
		0.451691f, -0.714747f, -0.533958f, -0.0286630f, -0.951391f, 0.306648f, 
		-0.985425f, 0.0408291f, -0.165141f, 0.956812f, 0.195375f, 0.215267f, 
		-0.392734f, 0.106736f, 0.913437f, 0.421955f, -0.427417f, -0.799543f, 
		-0.979459f, -0.0989982f, -0.175668f, -0.987884f, -0.0176362f, -0.154191f, 
		-0.987884f, -0.0176362f, -0.154191f, -0.990724f, 0.0622656f, -0.120785f, 
		-0.154701f, -0.256982f, 0.953954f, -0.491412f, -0.269188f, 0.828282f, 
		-0.451209f, -0.745536f, 0.490496f, -0.627035f, -0.283038f, 0.725752f, 
		-0.580363f, -0.463063f, 0.669890f, -0.269854f, -0.891336f, 0.364279f, 
		0.891549f, 0.424225f, 0.158662f, -0.832783f, 0.0217419f, 0.553173f, 
		-0.132214f, 0.490007f, 0.861634f, -0.576681f, -0.276794f, 0.768650f, 
		-0.691320f, -0.101821f, 0.715338f, 0.567990f, -0.484545f, -0.665284f, 
		0.533967f, -0.560336f, -0.633169f, 0.661894f, -0.328387f, -0.673839f, 
		0.734922f, 0.677716f, 0.0243115f, 0.568788f, -0.341745f, 0.748125f, 
		-0.951913f, -0.0736277f, -0.297390f, -0.962764f, 0.224684f, -0.150339f, 
		-0.828569f, -0.226780f, -0.511903f, -0.903100f, 0.0683530f, -0.423956f, 
		0.509430f, 0.342045f, 0.789611f, 0.509430f, 0.342045f, 0.789611f, 
		0.509430f, 0.342045f, 0.789611f, 0.312205f, 0.919681f, -0.238150f, 
		-0.557381f, 0.511499f, -0.653984f, -0.923460f, -0.0399340f, 0.381610f, 
		-0.897675f, 0.109333f, -0.426880f, -0.604109f, 0.138713f, -0.784736f, 
		-0.604109f, 0.138713f, -0.784736f, -0.604109f, 0.138713f, -0.784736f, 
		-0.0881290f, 0.955374f, -0.281946f, 0.178825f, 0.927041f, 0.329571f, 
		-0.0853785f, -0.988470f, -0.125048f, 0.153720f, 0.987754f, -0.0266907f, 
		-0.930370f, 0.170917f, -0.324344f, -0.863511f, 0.143756f, 0.483408f, 
		-0.00751154f, 0.963180f, 0.268752f, 0.439265f, 0.332531f, 0.834547f, 
		0.623436f, 0.538082f, -0.567270f, 0.893637f, -0.229114f, 0.385901f, 
		-0.397726f, 0.695106f, 0.598867f, -0.700456f, 0.399020f, 0.591730f, 
		-0.0483159f, 0.665278f, 0.745031f, 0.0840558f, 0.330509f, 0.940053f, 
		-0.0609630f, 0.852394f, 0.519334f, -0.169129f, 0.810456f, 0.560853f, 
		-0.173475f, 0.869613f, 0.462255f, 0.331178f, 0.915421f, -0.228750f, 
		0.962707f, 0.235149f, 0.133789f, 0.158704f, 0.987317f, -0.00423651f, 
		-0.455826f, 0.346855f, 0.819704f, -0.455826f, 0.346855f, 0.819704f, 
		-0.455826f, 0.346855f, 0.819704f, -0.131761f, 0.579852f, 0.803996f, 
		-0.396391f, 0.190766f, 0.898044f, -0.260438f, 0.643800f, 0.719510f, 
		-0.213057f, 0.480452f, 0.850748f, -0.0301419f, 0.465078f, 0.884756f, 
		0.884464f, 0.214851f, -0.414201f, -0.416873f, 0.287616f, -0.862261f, 
		-0.416873f, 0.287616f, -0.862261f, -0.0753295f, -0.954690f, -0.287911f, 
		-0.612702f, 0.195005f, 0.765878f, 0.131660f, 0.991244f, -0.0100427f, 
		0.157480f, 0.978219f, 0.135231f, 0.947308f, 0.314729f, 0.0596126f, 
		0.589452f, 0.144632f, -0.794750f, 0.948752f, 0.277193f, 0.151767f, 
		0.948752f, 0.277193f, 0.151767f, 0.925947f, 0.364959f, 0.0970873f, 
		0.858854f, 0.511562f, -0.0259733f, -0.897806f, -0.110991f, 0.426175f, 
		0.0841573f, 0.976910f, 0.196378f, 0.0841573f, 0.976910f, 0.196378f, 
		0.956683f, 0.256291f, 0.138107f, -0.503658f, 0.0953683f, 0.858623f, 
		0.924813f, -0.000316752f, -0.380422f, -0.886477f, -0.195994f, -0.419220f, 
		-0.813120f, -0.469840f, 0.343637f, -0.710049f, -0.695797f, 0.108153f, 
		-0.465194f, -0.880477f, -0.0914052f, 0.470611f, 0.558948f, 0.682717f, 
		0.470611f, 0.558948f, 0.682717f, 0.840131f, -0.463838f, -0.281132f, 
		0.520271f, -0.848326f, -0.0982866f, 0.679796f, -0.731855f, -0.0475907f, 
		0.885137f, -0.446533f, -0.130925f, 0.646230f, -0.733994f, -0.208902f, 
		-0.647715f, -0.675254f, -0.352841f, -0.546788f, -0.809092f, -0.215391f, 
		-0.689608f, -0.297345f, -0.660323f, -0.546788f, -0.809092f, -0.215391f, 
		-0.581644f, -0.0758845f, -0.809896f, 0.122093f, 0.965383f, -0.230498f, 
		-0.0149838f, 0.889736f, -0.456229f, 0.0621413f, 0.944438f, -0.322763f, 
		-0.0794608f, 0.839715f, -0.537182f, -0.0593668f, 0.871279f, -0.487184f, 
		-0.780029f, -0.432937f, -0.451797f, -0.850411f, -0.394750f, 0.347814f, 
		-0.192800f, -0.981180f, 0.0107064f, 0.877203f, 0.0955807f, -0.470509f, 
		0.772699f, 0.615396f, -0.155642f, 0.852348f, 0.228979f, 0.470182f, 
		0.768037f, 0.614519f, 0.180240f, 0.862277f, 0.255540f, -0.437240f, 
		0.800867f, 0.415477f, 0.431266f, -0.984338f, 0.150078f, -0.0924906f, 
		-0.960948f, 0.173938f, -0.215230f, -0.978819f, 0.204516f, -0.00932346f, 
		-0.917666f, 0.114445f, -0.380514f, -0.967662f, 0.216573f, 0.129331f, 
		0.919192f, -0.195429f, -0.341897f, 0.928903f, -0.327488f, -0.172891f, 
		-0.411132f, -0.911574f, -0.00194636f, -0.852129f, 0.499734f, -0.155379f, 
		-0.165814f, 0.433363f, 0.885834f, -0.0889231f, 0.409176f, 0.908112f, 
		-0.0265567f, -0.434239f, 0.900406f, -0.119699f, -0.627453f, 0.769399f, 
		0.334711f, -0.885859f, -0.321281f, 0.0131824f, 0.611092f, 0.791450f, 
		-0.113413f, 0.526006f, 0.842885f, -0.916294f, 0.119769f, 0.382178f, 
		-0.912856f, -0.0154606f, -0.407990f, 0.125449f, -0.909536f, 0.396241f, 
		-0.00704839f, -0.929540f, 0.368655f, 0.0472352f, -0.914680f, 0.401408f, 
		0.136212f, 0.986728f, -0.0884038f, 0.967682f, 0.248135f, -0.0449510f, 
		0.530331f, 0.836410f, -0.138449f, 0.899151f, 0.397206f, -0.183725f, 
		0.629225f, 0.760656f, -0.159621f, 0.715792f, 0.687250f, -0.123810f, 
		0.894668f, 0.387059f, -0.223059f, 0.808950f, 0.552541f, -0.200745f, 
		0.699977f, 0.681505f, -0.213501f, -0.219757f, -0.759580f, -0.612165f, 
		0.933149f, 0.207656f, 0.293450f, -0.377273f, 0.907591f, -0.184238f, 
		-0.591885f, 0.634707f, -0.496808f, -0.630084f, 0.367923f, -0.683832f, 
		-0.630084f, 0.367923f, -0.683832f, -0.555257f, 0.261165f, -0.789609f, 
		-0.159541f, 0.979063f, -0.126420f, 0.622453f, 0.606222f, -0.495022f, 
		0.697974f, 0.380758f, -0.606511f, 0.691345f, 0.475194f, -0.544273f, 
		-0.501793f, 0.206922f, -0.839873f, 0.623436f, 0.538082f, -0.567270f, 
		0.775668f, 0.370000f, -0.511311f, -0.501793f, 0.206922f, -0.839873f, 
		0.872481f, 0.221365f, -0.435630f, -0.929587f, -0.0882506f, 0.357882f, 
		-0.936365f, -0.226229f, 0.268403f, -0.965558f, -0.0185953f, -0.259524f, 
		-0.980388f, -0.186500f, 0.0636905f, -0.868591f, 0.166089f, 0.466865f, 
		-0.879164f, -0.0123879f, 0.476358f, 0.927365f, 0.353927f, -0.121364f, 
		0.187416f, -0.340107f, 0.921522f, 0.917602f, 0.251317f, 0.307973f, 
		-0.592544f, 0.169772f, -0.787445f, 0.444241f, 0.00504379f, -0.895893f, 
		-0.523082f, -0.819125f, 0.235415f, 0.937234f, -0.00645865f, 0.348642f, 
		0.724318f, 0.637978f, 0.261434f, -0.563592f, 0.387287f, -0.729639f, 
		-0.338708f, 0.930619f, -0.138653f, 0.595717f, 0.472952f, -0.649182f, 
		-0.605466f, 0.108408f, -0.788454f, -0.605466f, 0.108408f, -0.788454f, 
		-0.605466f, 0.108408f, -0.788454f, 0.156510f, 0.987301f, 0.0272427f, 
		-0.914720f, 0.171723f, 0.365786f, -0.883461f, 0.146579f, -0.444985f, 
		-0.975945f, 0.200684f, -0.0851861f, -0.952406f, -0.000125099f, -0.304833f, 
		-0.975945f, 0.200684f, -0.0851861f, -0.948442f, 0.306983f, 0.0788636f, 
		0.196356f, -0.909893f, -0.365429f, 0.0860572f, -0.960445f, -0.264839f, 
		0.0214137f, -0.987585f, -0.155621f, 0.483786f, 0.833977f, 0.265394f, 
		0.614541f, 0.788855f, 0.00687855f, 0.684364f, 0.348524f, -0.640451f, 
		0.749565f, 0.491904f, -0.442925f, 0.806726f, -0.523340f, 0.274424f, 
		0.670692f, -0.658997f, 0.340433f, 0.832038f, -0.449678f, 0.324812f, 
		0.773182f, -0.590811f, 0.230504f, 0.854914f, -0.461279f, 0.237369f, 
		0.957020f, -0.277491f, 0.0843298f, -0.215769f, 0.632244f, 0.744118f, 
		0.751410f, 0.656560f, 0.0656661f, 0.930780f, 0.326354f, 0.164746f, 
		0.490112f, 0.871089f, -0.0315360f, 0.523845f, 0.102059f, 0.845677f, 
		0.219105f, 0.754462f, -0.618692f, -0.993464f, 0.114114f, -0.00276135f, 
		-0.989699f, 0.00764353f, -0.142962f, -0.996514f, 0.0653097f, -0.0519150f, 
		0.164624f, 0.986173f, 0.0189977f, -0.727699f, -0.0378176f, -0.684853f, 
		-0.727699f, -0.0378176f, -0.684853f, -0.517958f, 0.723002f, -0.457152f, 
		0.342045f, 0.938792f, -0.0409337f, -0.552525f, 0.811379f, -0.190734f, 
		-0.509485f, 0.798403f, -0.320900f, -0.974093f, -0.159454f, -0.160368f, 
		-0.974093f, -0.159454f, -0.160368f, -0.427762f, -0.894228f, -0.131818f, 
		-0.220572f, -0.962282f, 0.159252f, 0.802284f, -0.379295f, -0.460950f, 
		0.868837f, -0.202902f, -0.451613f, 0.317481f, -0.902247f, -0.291815f, 
		0.494104f, -0.786986f, -0.369478f, 0.471662f, -0.575809f, -0.667817f, 
		0.519620f, 0.720645f, 0.458983f, 0.715181f, 0.591837f, 0.371814f, 
		0.887997f, 0.402123f, 0.223067f, 0.824383f, 0.474458f, 0.308676f, 
		0.758818f, 0.570496f, 0.314213f, 0.779167f, -0.370415f, -0.505659f, 
		0.528730f, -0.649020f, 0.547008f, -0.116945f, -0.961091f, -0.250256f, 
		0.629755f, -0.463078f, -0.623673f, 0.979488f, -0.0857884f, -0.182330f, 
		0.998950f, 0.0451513f, 0.00773715f, 0.990440f, -0.0298522f, -0.134678f, 
		-0.538762f, 0.837192f, -0.0940516f, -0.187821f, 0.958750f, 0.213361f, 
		-0.658498f, 0.702839f, -0.269067f, -0.658498f, 0.702839f, -0.269067f, 
		-0.361829f, -0.312072f, -0.878459f, 0.112002f, 0.554356f, -0.824709f, 
		0.974011f, 0.100495f, -0.202985f, 0.139516f, 0.985778f, 0.0936814f, 
		-0.441512f, 0.430249f, 0.787371f, 0.434075f, 0.521182f, 0.734812f, 
		-0.441512f, 0.430249f, 0.787371f, -0.441512f, 0.430249f, 0.787371f, 
		0.906408f, 0.414462f, -0.0815228f, -0.155746f, 0.121913f, -0.980245f, 
		0.182069f, 0.870148f, -0.457923f, -0.983763f, -0.104759f, 0.145727f, 
		-0.831886f, -0.0642816f, -0.551210f, -0.987598f, -0.105200f, -0.116543f, 
		-0.789486f, -0.290476f, -0.540680f, -0.789486f, -0.290476f, -0.540680f, 
		0.641371f, 0.0280397f, 0.766718f, 0.641371f, 0.0280397f, 0.766718f, 
		0.641371f, 0.0280397f, 0.766718f, 0.982509f, -0.107478f, -0.152067f, 
		-0.982365f, 0.0453030f, -0.181403f, -0.960219f, -0.0445943f, -0.275664f, 
		-0.982365f, 0.0453030f, -0.181403f, -0.985798f, 0.128174f, -0.108511f, 
		0.624200f, 0.665379f, -0.409446f, 0.624200f, 0.665379f, -0.409446f, 
		0.544562f, 0.715358f, -0.437852f, 0.669583f, 0.614837f, -0.416695f, 
		0.249485f, -0.832732f, 0.494282f, 0.657539f, 0.309947f, 0.686714f, 
		0.657539f, 0.309947f, 0.686714f, -0.650444f, 0.398433f, 0.646664f, 
		-0.702078f, 0.0558767f, -0.709904f, -0.650444f, 0.398433f, 0.646664f, 
		-0.650444f, 0.398433f, 0.646664f, -0.980134f, -0.198167f, -0.00814490f, 
		-0.245109f, -0.499150f, -0.831126f, 0.0877333f, 0.858968f, 0.504457f, 
		0.0548815f, 0.828569f, 0.557191f, 0.0232412f, 0.806513f, 0.590760f, 
		0.888980f, 0.451485f, -0.0766517f, 0.677638f, 0.212476f, 0.704032f, 
		0.242235f, -0.556367f, -0.794844f, -0.139033f, 0.722995f, 0.676718f, 
		-0.321852f, -0.835148f, 0.446026f, 0.536093f, 0.621499f, 0.571264f, 
		-0.637281f, -0.768437f, -0.0581133f, -0.244116f, 0.572243f, 0.782909f, 
		0.609749f, -0.121035f, -0.783298f, -0.703452f, 0.141241f, -0.696568f, 
		-0.613615f, 0.116702f, 0.780933f, -0.703452f, 0.141241f, -0.696568f, 
		-0.703452f, 0.141241f, -0.696568f, -0.0881290f, 0.955374f, -0.281946f, 
		-0.407154f, -0.913084f, 0.0224311f, -0.949937f, 0.130497f, -0.283884f, 
		-0.986155f, 0.160464f, -0.0418222f, -0.982571f, 0.149446f, 0.110547f, 
		0.709804f, -0.697428f, -0.0988552f, 0.447224f, 0.379981f, -0.809695f, 
		-0.656099f, 0.111769f, -0.746352f, -0.831886f, -0.0642816f, -0.551210f, 
		-0.289756f, 0.101112f, -0.951744f, 0.175165f, -0.00771974f, -0.984509f, 
		-0.529555f, 0.148742f, -0.835133f, 0.331298f, 0.0404583f, -0.942658f, 
		-0.0556282f, -0.952103f, -0.300675f, -0.0455661f, 0.823245f, 0.565854f, 
		-0.00793764f, -0.760618f, 0.649151f, 0.995407f, 0.0716130f, 0.0635343f, 
		0.250213f, -0.317826f, -0.914538f, -0.112248f, 0.992364f, 0.0511296f, 
		0.109931f, 0.992667f, -0.0502803f, -0.240541f, 0.964321f, 0.110563f, 
		0.956864f, 0.0341468f, 0.288523f, 0.250102f, -0.0370598f, 0.967510f, 
		0.0134778f, 0.871694f, -0.489866f, -0.215273f, 0.829068f, -0.516047f, 
		0.280183f, 0.947606f, -0.153429f, 0.519659f, 0.836588f, 0.173419f, 
		0.492278f, 0.762000f, 0.420734f, 0.181539f, 0.981087f, -0.0671666f, 
		-0.722351f, 0.0367971f, -0.690547f, -0.760627f, 0.241490f, 0.602601f, 
		0.211647f, 0.965530f, 0.151519f, -0.638637f, 0.680483f, -0.359284f, 
		0.933149f, 0.207656f, 0.293450f, -0.638637f, 0.680483f, -0.359284f, 
		-0.0494137f, 0.474511f, 0.878862f, -0.279807f, 0.958171f, 0.0601337f, 
		-0.279807f, 0.958171f, 0.0601337f, -0.522487f, 0.233588f, -0.820027f, 
		0.301058f, 0.727485f, -0.616546f, -0.963911f, 0.263913f, -0.0350048f, 
		0.161944f, 0.958597f, -0.234236f, 0.613927f, -0.116082f, -0.780781f, 
		-0.708899f, 0.0827343f, -0.700441f, 0.161944f, 0.958597f, -0.234236f, 
		-0.615907f, 0.121795f, 0.778347f, -0.708899f, 0.0827343f, -0.700441f, 
		0.576023f, -0.284289f, -0.766406f, -0.384750f, -0.900301f, -0.203533f, 
		-0.833316f, 0.492326f, -0.251396f, -0.349413f, 0.283758f, -0.892968f, 
		-0.314655f, -0.810714f, 0.493695f, 0.259163f, -0.748595f, -0.610279f, 
		0.773299f, -0.224473f, -0.592975f, 0.348289f, -0.169041f, -0.922020f, 
		0.567048f, -0.190734f, -0.801297f, -0.259358f, -0.948487f, -0.181953f, 
		-0.00271651f, -0.954359f, -0.298650f, -0.164372f, -0.947314f, -0.274915f, 
		-0.0350084f, -0.949886f, -0.310629f, -0.710039f, -0.422265f, -0.563503f, 
		-0.710039f, -0.422265f, -0.563503f, -0.0350084f, -0.949886f, -0.310629f, 
		0.0443133f, 0.0156795f, 0.998895f, 0.0443133f, 0.0156795f, 0.998895f, 
		0.113028f, 0.0865657f, 0.989814f, 0.0443133f, 0.0156795f, 0.998895f, 
		0.0443133f, 0.0156795f, 0.998895f, 0.0796848f, -0.0839911f, 0.993275f, 
		0.804837f, 0.538104f, -0.250362f, 0.402038f, 0.912499f, -0.0755754f, 
		0.355763f, 0.934515f, -0.0106723f, 0.303694f, 0.951511f, 0.0489628f, 
		0.355763f, 0.934515f, -0.0106723f, 0.0912018f, -0.171455f, 0.980962f, 
		-0.482876f, -0.824673f, 0.294526f, 0.0912018f, -0.171455f, 0.980962f, 
		-0.482876f, -0.824673f, 0.294526f, 0.164528f, 0.986112f, -0.0226487f, 
		-0.697494f, -0.0388776f, 0.715535f, -0.697494f, -0.0388776f, 0.715535f, 
		0.255136f, 0.962418f, 0.0930379f, -0.155492f, 0.944726f, 0.288643f, 
		-0.227138f, 0.935056f, -0.272174f, 0.105407f, 0.966927f, -0.232255f, 
		-0.322064f, 0.903044f, 0.284230f, -0.339429f, 0.936525f, 0.0877942f, 
		-0.659176f, 0.524231f, -0.539138f, 0.583334f, -0.481585f, -0.654063f, 
		0.674137f, -0.342763f, -0.654258f, 0.811694f, -0.131130f, -0.569172f, 
		0.139516f, 0.985778f, 0.0936814f, 0.401504f, 0.431647f, -0.807759f, 
		0.592548f, 0.398660f, 0.699969f, -0.198699f, -0.970833f, -0.134168f, 
		0.0751666f, -0.553172f, 0.829669f, 0.553882f, -0.802460f, 0.221975f, 
		0.584981f, -0.207410f, 0.784078f, -0.570370f, 0.136977f, -0.809886f, 
		-0.207921f, 0.902041f, -0.378273f, -0.246695f, -0.614602f, -0.749270f, 
		-0.118078f, -0.528721f, -0.840542f, 0.390961f, -0.179298f, -0.902774f, 
		0.590517f, -0.170077f, -0.788900f, -0.0362402f, -0.998510f, 0.0408048f, 
		0.512711f, -0.237040f, 0.825191f, 0.735709f, 0.672898f, -0.0770731f, 
		0.591182f, 0.805586f, 0.0391804f, -0.274460f, 0.958058f, 0.0824428f, 
		-0.430323f, 0.902481f, 0.0187226f, 0.0447344f, 0.975281f, 0.216393f, 
		0.302020f, 0.753199f, 0.584359f, -0.354565f, -0.746217f, -0.563421f, 
		-0.127661f, 0.247529f, -0.960433f, 0.125951f, 0.880556f, 0.456899f, 
		-0.117575f, 0.000289714f, 0.993064f, 0.282333f, -0.0563158f, -0.957662f, 
		0.574484f, 0.715692f, -0.397181f, -0.697403f, -0.716141f, 0.0277581f, 
		-0.697403f, -0.716141f, 0.0277581f, 0.341946f, 0.936506f, 0.0776513f, 
		-0.764874f, -0.291578f, 0.574413f, -0.764874f, -0.291578f, 0.574413f, 
		-0.359235f, -0.810875f, 0.461986f, -0.359235f, -0.810875f, 0.461986f, 
		0.0459164f, -0.989738f, -0.135317f, -0.238013f, -0.913089f, 0.331088f, 
		-0.871117f, -0.325217f, 0.367953f, -0.632621f, -0.714249f, 0.299396f, 
		-0.532991f, -0.797601f, 0.282406f, 0.264971f, -0.306215f, 0.914343f, 
		-0.411133f, -0.911474f, -0.0136062f, -0.983225f, 0.161319f, 0.0851116f, 
		-0.936457f, 0.130769f, 0.325497f, -0.986322f, 0.150262f, -0.0677566f, 
		-0.784831f, -0.445189f, -0.431099f, -0.204854f, -0.969552f, -0.134181f, 
		-0.776353f, 0.449363f, 0.441983f, 0.131660f, 0.991244f, -0.0100427f, 
		-0.783581f, 0.256235f, 0.565990f, -0.776353f, 0.449363f, 0.441983f, 
		-0.762933f, 0.384498f, 0.519707f, -0.762933f, 0.384498f, 0.519707f, 
		-0.180665f, 0.980601f, 0.0760403f, 0.225831f, 0.972734f, 0.0528017f, 
		0.0496470f, 0.992328f, 0.113225f, -0.291547f, 0.954969f, 0.0550874f, 
		-0.416169f, 0.908674f, 0.0333824f, 0.288290f, 0.269598f, 0.918807f, 
		-0.206987f, -0.206148f, -0.956378f, -0.0331989f, 0.289646f, -0.956558f, 
		-0.0393742f, -0.323990f, -0.945241f, 0.921244f, -0.353912f, 0.161419f, 
		0.577538f, -0.426831f, -0.695892f, 0.380075f, -0.403912f, -0.832105f, 
		-0.135401f, -0.0144122f, -0.990686f, -0.591198f, -0.772626f, -0.231376f, 
		-0.634204f, -0.760036f, -0.141883f, -0.557443f, -0.769267f, -0.312225f, 
		-0.681880f, 0.650632f, 0.334240f, -0.612629f, 0.649171f, -0.450847f, 
		-0.719322f, 0.484264f, -0.498061f, -0.775269f, 0.395210f, -0.492713f, 
		-0.719322f, 0.484264f, -0.498061f, -0.775269f, 0.395210f, -0.492713f, 
		0.881477f, -0.0306590f, -0.471231f, 0.881477f, -0.0306590f, -0.471231f, 
		0.798356f, -0.0105700f, -0.602094f, 0.787958f, 0.185259f, -0.587198f, 
		0.836535f, 0.0513258f, -0.545505f, 0.861462f, 0.113458f, -0.494986f, 
		0.263884f, 0.171702f, 0.949149f, 0.263884f, 0.171702f, 0.949149f, 
		0.202334f, 0.762857f, 0.614092f, 0.188248f, 0.850351f, 0.491392f, 
		0.265017f, 0.470385f, 0.841727f, 0.202334f, 0.762857f, 0.614092f, 
		0.188248f, 0.850351f, 0.491392f, -0.872684f, -0.280302f, -0.399816f, 
		-0.830504f, -0.466682f, -0.304091f, -0.773888f, 0.119373f, -0.621970f, 
		-0.859992f, -0.103102f, -0.499784f, -0.859992f, -0.103102f, -0.499784f, 
		-0.862903f, -0.193248f, -0.466962f, 0.632707f, -0.237185f, -0.737174f, 
		-0.375319f, 0.898366f, 0.228199f, 0.632707f, -0.237185f, -0.737174f, 
		0.626584f, 0.743991f, 0.232099f, -0.694922f, 0.557596f, -0.454060f, 
		0.309181f, 0.880957f, -0.358219f, 0.299336f, -0.875708f, -0.378858f, 
		0.298248f, 0.549869f, 0.780187f, -0.776038f, -0.455158f, -0.436574f, 
		-0.0708092f, -0.965719f, -0.249745f, 0.735838f, 0.676760f, 0.0231939f, 
		0.882981f, 0.463987f, 0.0711429f, 0.482021f, 0.875215f, -0.0406728f, 
		0.241317f, 0.963294f, -0.117602f, 0.113690f, 0.954402f, 0.276028f, 
		0.933149f, 0.207656f, 0.293450f, 0.0572603f, 0.988213f, 0.141971f, 
		0.200496f, 0.919142f, 0.339087f, 0.113690f, 0.954402f, 0.276028f, 
		-0.624672f, 0.144016f, 0.767492f, -0.230808f, -0.959301f, 0.162696f, 
		0.458548f, 0.247304f, -0.853566f, 0.745726f, 0.192847f, 0.637733f, 
		0.745726f, 0.192847f, 0.637733f, 0.458548f, 0.247304f, -0.853566f, 
		-0.580146f, -0.792843f, -0.186629f, -0.371848f, -0.925215f, 0.0755406f, 
		-0.0370439f, -0.958490f, 0.282709f, 0.0372003f, -0.897228f, 0.439997f, 
		0.507511f, -0.365954f, -0.780071f, 0.558880f, -0.690651f, 0.458970f, 
		0.761320f, 0.125103f, 0.636193f, -0.722351f, 0.0367971f, -0.690547f, 
		0.691340f, -0.107600f, -0.714473f, -0.927160f, 0.127476f, 0.352312f, 
		-0.436510f, -0.896672f, 0.0737420f, 0.208683f, 0.971596f, -0.111588f, 
		0.784456f, -0.0353262f, -0.619178f, -0.741794f, 0.0176753f, -0.670395f, 
		0.172518f, 0.984876f, 0.0160381f, -0.862920f, 0.0940641f, -0.496509f, 
		-0.862920f, 0.0940641f, -0.496509f, 0.606335f, -0.284185f, 0.742695f, 
		0.0111732f, -0.0737390f, -0.997215f, -0.937934f, -0.253850f, -0.236307f, 
		-0.772820f, -0.565072f, -0.288865f, -0.633477f, -0.732591f, -0.249034f, 
		0.340498f, 0.832039f, 0.437919f, 0.743813f, 0.0819848f, 0.663341f, 
		0.701314f, 0.436127f, 0.563872f, -0.661578f, 0.557346f, 0.501677f, 
		-0.791697f, 0.299735f, 0.532329f, -0.202805f, 0.874262f, 0.441063f, 
		-0.0242029f, 0.938539f, 0.344323f, 0.654918f, 0.583704f, 0.479971f, 
		0.709420f, 0.243581f, -0.661356f, 0.780600f, 0.0219811f, 0.624644f, 
		0.613927f, -0.116082f, -0.780781f, 0.780600f, 0.0219811f, 0.624644f, 
		-0.611300f, 0.111605f, 0.783490f, 0.780600f, 0.0219811f, 0.624644f, 
		0.555807f, -0.427365f, 0.713048f, 0.345978f, 0.920342f, -0.182401f, 
		0.675720f, 0.463778f, 0.572986f, 0.711626f, 0.268592f, 0.649189f, 
		0.618075f, -0.111124f, -0.778226f, 0.435419f, 0.899378f, 0.0391154f, 
		0.711626f, 0.268592f, 0.649189f, -0.613615f, 0.116702f, 0.780933f, 
		-0.375703f, -0.901779f, 0.213638f, -0.820739f, 0.492049f, 0.290302f, 
		-0.313912f, 0.283913f, 0.906009f, 0.496639f, 0.754767f, 0.428575f, 
		-0.784444f, -0.275766f, -0.555519f, -0.840908f, 0.121018f, -0.527473f, 
		-0.767869f, 0.468565f, -0.436834f, -0.767869f, 0.468565f, -0.436834f, 
		-0.784444f, -0.275766f, -0.555519f, -0.731627f, -0.451443f, -0.510804f, 
		-0.152477f, -0.926333f, -0.344467f, -0.291351f, 0.229872f, 0.928587f, 
		-0.190257f, 0.917727f, 0.348683f, -0.291351f, 0.229872f, 0.928587f, 
		0.348857f, -0.756600f, 0.553042f, -0.401817f, -0.832346f, 0.381763f, 
		-0.283173f, 0.182852f, 0.941477f, -0.283173f, 0.182852f, 0.941477f, 
		0.632853f, -0.262624f, 0.728372f, -0.640181f, 0.0405245f, -0.767154f, 
		0.118257f, 0.976963f, -0.177649f, -0.737684f, -0.0428290f, 0.673787f, 
		-0.737684f, -0.0428290f, 0.673787f, -0.547982f, 0.128774f, 0.826519f, 
		-0.547982f, 0.128774f, 0.826519f, 0.778313f, 0.518815f, -0.353639f, 
		0.0268406f, -0.992738f, 0.117261f, 0.246651f, 0.415519f, 0.875504f, 
		-0.0239663f, -0.565275f, 0.824554f, -0.999813f, 0.0192836f, 0.00167320f, 
		0.338112f, -0.628597f, 0.700390f, -0.921286f, 0.0558082f, -0.384860f, 
		0.526139f, 0.850398f, -0.000601859f, 0.386380f, -0.0172700f, -0.922178f, 
		0.386380f, -0.0172700f, -0.922178f, -0.989413f, 0.134663f, -0.0541088f, 
		-0.160930f, 0.114026f, -0.980357f, 0.508498f, -0.677674f, -0.531213f, 
		-0.943559f, 0.0961848f, -0.316932f, -0.160930f, 0.114026f, -0.980357f, 
		-0.429215f, -0.789365f, -0.438950f, 0.508498f, -0.677674f, -0.531213f, 
		0.563316f, -0.305937f, -0.767514f, 0.384619f, 0.820420f, -0.423059f, 
		0.384619f, 0.820420f, -0.423059f, 0.751348f, -0.481870f, 0.450862f, 
		0.907031f, -0.107662f, 0.407068f, 0.834601f, -0.342786f, 0.431207f, 
		0.577538f, -0.426831f, -0.695892f, 0.577538f, -0.426831f, -0.695892f, 
		-0.186053f, -0.861242f, 0.472912f, 0.542212f, 0.815193f, 0.203632f, 
		0.656990f, 0.686357f, 0.311895f, 0.750631f, 0.408786f, 0.519083f, 
		0.626819f, 0.747597f, 0.219536f, 0.709917f, 0.631430f, 0.311952f, 
		-0.463529f, 0.140832f, 0.874819f, -0.966176f, 0.180092f, 0.184583f, 
		-0.346355f, -0.922130f, 0.172379f, -0.00654103f, 0.989695f, 0.143038f, 
		0.0638333f, 0.938288f, -0.339914f, 0.0741565f, 0.994838f, -0.0692649f, 
		0.335426f, 0.202607f, -0.920022f, 0.747168f, 0.0151770f, -0.664462f, 
		0.747168f, 0.0151770f, -0.664462f, -0.680352f, -0.291872f, 0.672259f, 
		-0.656993f, -0.219839f, 0.721132f, -0.627971f, -0.165492f, 0.760437f, 
		-0.656993f, -0.219839f, 0.721132f, 0.374951f, -0.657664f, -0.653368f, 
		-0.787748f, -0.615641f, 0.0209535f, 0.724644f, 0.105496f, -0.681001f, 
		-0.543271f, -0.741118f, -0.394463f, 0.127055f, 0.975292f, 0.180726f, 
		-0.766074f, -0.0387399f, -0.641583f, -0.766074f, -0.0387399f, -0.641583f, 
		0.528114f, 0.634202f, 0.564698f, -0.789703f, 0.606640f, -0.0914139f, 
		-0.129054f, 0.549242f, -0.825638f, 0.0416074f, 0.895979f, -0.442144f, 
		0.193069f, 0.952558f, -0.235281f, -0.0721619f, 0.693279f, -0.717047f, 
		-0.444896f, 0.287188f, 0.848287f, -0.406052f, -0.801298f, 0.439366f, 
		-0.715629f, 0.403789f, 0.569938f, -0.766974f, 0.475800f, 0.430540f, 
		-0.765359f, -0.445694f, 0.464309f, -0.196008f, -0.970292f, 0.141827f, 
		0.125269f, 0.970879f, -0.204210f, 0.125269f, 0.970879f, -0.204210f, 
		0.0841573f, 0.976910f, 0.196378f, 0.0841573f, 0.976910f, 0.196378f, 
		-0.874966f, 0.364867f, -0.318287f, 0.594495f, 0.156438f, -0.788735f, 
		-0.0585561f, 0.811125f, -0.581935f, -0.430826f, 0.784720f, -0.445649f, 
		0.211168f, 0.965553f, 0.152039f, 0.107608f, 0.794098f, -0.598188f, 
		0.621673f, -0.627976f, 0.468154f, 0.636602f, 0.130172f, 0.760127f, 
		-0.546025f, 0.286866f, -0.787124f, -0.546025f, 0.286866f, -0.787124f, 
		0.854142f, 0.470392f, 0.221747f, 0.428392f, 0.642364f, 0.635491f, 
		0.621465f, 0.623594f, 0.474248f, -0.995511f, 0.0792404f, -0.0517533f, 
		-0.986886f, 0.140997f, -0.0785848f, 0.265873f, 0.961659f, -0.0672530f, 
		0.471089f, 0.871134f, 0.138569f, 0.236464f, 0.949664f, -0.205481f, 
		0.363751f, 0.931432f, -0.0109827f, 0.525266f, 0.809975f, 0.260837f, 
		-0.465852f, 0.609290f, -0.641675f, -0.662068f, 0.379419f, -0.646303f, 
		0.0613552f, 0.947263f, -0.314528f, -0.0647301f, 0.880619f, -0.469382f, 
		-0.869990f, 0.359244f, -0.337729f, -0.869990f, 0.359244f, -0.337729f, 
		-0.869990f, 0.359244f, -0.337729f, -0.396910f, -0.913222f, -0.0921324f, 
		-0.687030f, 0.100731f, -0.719613f, -0.468436f, 0.0949030f, -0.878385f, 
		-0.812401f, 0.0511989f, -0.580847f, -0.709108f, -0.287000f, -0.644047f, 
		-0.687839f, -0.214187f, -0.693543f, -0.687839f, -0.214187f, -0.693543f, 
		-0.660173f, -0.159772f, -0.733924f, 0.197004f, 0.278108f, -0.940131f, 
		0.400242f, 0.0419490f, -0.915449f, -0.943559f, 0.0961848f, -0.316932f, 
		0.0889218f, 0.371668f, -0.924097f, 0.195524f, 0.411669f, -0.890112f, 
		0.307666f, 0.582158f, -0.752618f, 0.276490f, 0.324555f, -0.904554f, 
		-0.690691f, -0.167640f, -0.703451f, -0.654087f, -0.693749f, -0.301468f, 
		-0.520641f, -0.830457f, -0.198178f, -0.620041f, -0.0407622f, -0.783510f, 
		-0.986688f, 0.153280f, -0.0543261f, 0.788082f, 0.0903775f, 0.608900f, 
		0.788082f, 0.0903775f, 0.608900f, -0.790790f, 0.231472f, -0.566632f, 
		0.754098f, 0.194591f, -0.627273f, 0.779025f, -0.0271695f, 0.626404f, 
		0.754098f, 0.194591f, -0.627273f, 0.754098f, 0.194591f, -0.627273f, 
		0.656712f, 0.248795f, 0.711920f, 0.656712f, 0.248795f, 0.711920f, 
		0.656712f, 0.248795f, 0.711920f, 0.656712f, 0.248795f, 0.711920f, 
		0.695108f, 0.319826f, -0.643845f, 0.745750f, 0.219595f, -0.628996f, 
		0.721711f, 0.264716f, -0.639577f, 0.358887f, -0.925216f, -0.123187f, 
		-0.444772f, -0.880614f, -0.163391f, -0.370637f, -0.921510f, 0.115968f, 
		-0.474959f, 0.377488f, 0.794932f, -0.474959f, 0.377488f, 0.794932f, 
		0.00543139f, -0.999984f, 0.00165962f, 0.0207078f, -0.418608f, -0.907931f, 
		0.227916f, 0.0255466f, 0.973346f, 0.227916f, 0.0255466f, 0.973346f, 
		0.227916f, 0.0255466f, 0.973346f, 0.227916f, 0.0255466f, 0.973346f, 
		-0.427400f, 0.718975f, 0.548092f, 0.677751f, 0.212373f, 0.703954f, 
		0.605803f, 0.733938f, 0.307146f, 0.613934f, 0.0599805f, 0.787076f, 
		0.456427f, 0.866236f, 0.203246f, -0.948477f, 0.187138f, 0.255678f, 
		0.0100676f, 0.966695f, 0.255734f, -0.883409f, 0.466682f, -0.0423929f, 
		-0.622052f, 0.0760059f, 0.779278f, 0.371312f, 0.0650209f, 0.926229f, 
		-0.810734f, 0.338799f, 0.477416f, -0.340853f, 0.0842634f, -0.936333f, 
		-0.810734f, 0.338799f, 0.477416f, -0.810734f, 0.338799f, 0.477416f, 
		0.962425f, 0.175452f, 0.207256f, 0.929196f, 0.304364f, 0.209662f, 
		0.956791f, -0.0357217f, 0.288575f, 0.667720f, -0.251039f, -0.700806f, 
		0.779051f, 0.620340f, 0.0908742f, 0.712971f, 0.672847f, 0.197358f, 
		0.666139f, 0.686828f, 0.290734f, 0.411501f, 0.774550f, 0.480353f, 
		0.491637f, 0.793237f, 0.359259f, 0.194515f, 0.959792f, -0.202395f, 
		-0.695480f, 0.138358f, -0.705100f, -0.592047f, 0.479384f, -0.647821f, 
		-0.658814f, 0.254062f, -0.708108f, -0.915017f, -0.0286167f, 0.402399f, 
		-0.785950f, -0.326349f, 0.525147f, -0.785950f, -0.326349f, 0.525147f, 
		-0.708417f, -0.424905f, 0.563561f, 0.170703f, 0.985083f, -0.0217414f, 
		-0.840389f, 0.0943004f, 0.533718f, -0.840389f, 0.0943004f, 0.533718f, 
		-0.891931f, 0.431762f, 0.134312f, -0.891931f, 0.431762f, 0.134312f, 
		0.832855f, 0.549161f, -0.0691021f, 0.757650f, 0.638615f, -0.134676f, 
		0.624320f, 0.653336f, -0.428225f, 0.734562f, 0.640916f, -0.222815f, 
		0.801970f, 0.569664f, -0.179799f, 0.529916f, 0.773848f, -0.346914f, 
		-0.646966f, -0.197792f, -0.736419f, 0.659671f, -0.200835f, -0.724223f, 
		-0.879188f, -0.0364073f, 0.475082f, -0.801989f, -0.224042f, 0.553732f, 
		-0.678642f, 0.162797f, 0.716199f, -0.769942f, -0.113503f, 0.627939f, 
		-0.973085f, 0.137806f, 0.184705f, -0.918469f, 0.211416f, 0.334242f, 
		-0.0753145f, 0.977399f, 0.197531f, -0.0753145f, 0.977399f, 0.197531f, 
		-0.401407f, 0.373125f, 0.836451f, 0.779025f, -0.0271695f, 0.626404f, 
		0.854532f, 0.210212f, -0.474959f, 0.340815f, -0.0508229f, -0.938756f, 
		-0.855862f, 0.226507f, -0.464967f, -0.855862f, 0.226507f, -0.464967f, 
		-0.392895f, 0.282211f, 0.875209f, -0.855862f, 0.226507f, -0.464967f, 
		-0.0881290f, 0.955374f, -0.281946f, -0.756345f, 0.540943f, -0.367862f, 
		-0.569727f, -0.416826f, -0.708285f, 0.906553f, 0.421621f, 0.0199378f, 
		0.921244f, -0.353912f, 0.161419f, -0.235003f, 0.708929f, -0.664977f, 
		-0.640529f, 0.461605f, -0.613713f, -0.732922f, 0.228591f, -0.640758f, 
		0.103764f, 0.656005f, -0.747590f, 0.358549f, 0.332947f, -0.872117f, 
		0.354305f, 0.105190f, -0.929195f, -0.378303f, -0.919197f, -0.109380f, 
		-0.506198f, 0.380762f, -0.773812f, -0.506198f, 0.380762f, -0.773812f, 
		0.186548f, 0.980214f, 0.0661791f, -0.0589422f, 0.998207f, -0.0104207f, 
		-0.279807f, 0.958171f, 0.0601337f, 0.579244f, 0.387462f, 0.717182f, 
		0.579244f, 0.387462f, 0.717182f, 0.494556f, 0.438112f, -0.750648f, 
		0.604849f, -0.382838f, 0.698278f, 0.281515f, -0.740271f, 0.610531f, 
		0.130175f, -0.799069f, 0.586977f, 0.391901f, 0.917440f, -0.0686825f, 
		0.153886f, 0.987831f, -0.0225570f, 0.367123f, 0.0716830f, 0.927406f, 
		-0.760455f, 0.245989f, 0.600998f, -0.668135f, -0.730196f, 0.142859f, 
		-0.292185f, -0.925200f, 0.242144f, -0.456668f, -0.861846f, 0.220626f, 
		-0.894073f, -0.447775f, -0.0114524f, 0.620501f, -0.237853f, -0.747265f, 
		-0.744871f, -0.522907f, 0.414410f, 0.181380f, -0.492295f, 0.851321f, 
		0.507503f, -0.187230f, 0.841062f, -0.661413f, 0.451084f, 0.599212f, 
		0.382178f, -0.364576f, 0.849132f, 0.587437f, -0.764176f, -0.266368f, 
		0.261692f, -0.201364f, 0.943912f, -0.693071f, -0.691476f, 0.203746f, 
		0.261692f, -0.201364f, 0.943912f, 0.353205f, -0.935544f, -0.00203772f, 
		-0.644201f, -0.706525f, -0.292965f, 0.711257f, -0.641820f, -0.286672f, 
		0.594432f, -0.795463f, -0.117854f, 0.305726f, -0.907487f, 0.288097f, 
		0.477408f, 0.835826f, 0.271066f, 0.438707f, 0.890484f, 0.120723f, 
		0.582488f, 0.594059f, 0.554799f, -0.984280f, 0.155187f, 0.0843254f, 
		-0.580959f, 0.425521f, -0.693843f, -0.106705f, -0.959587f, -0.260398f, 
		-0.916909f, 0.320671f, 0.237589f, -0.916909f, 0.320671f, 0.237589f, 
		-0.916909f, 0.320671f, 0.237589f, 0.177730f, 0.981731f, -0.0679420f, 
		-0.372869f, 0.0630195f, -0.925742f, -0.936927f, 0.262977f, 0.230242f, 
		-0.447901f, -0.626184f, 0.638184f, -0.533192f, -0.470448f, 0.703125f, 
		-0.284985f, -0.838704f, 0.464069f, -0.160603f, -0.970565f, 0.179474f, 
		0.462493f, 0.711230f, -0.529388f, 0.648036f, -0.126369f, 0.751053f, 
		0.542468f, -0.237677f, 0.805753f, 0.609378f, -0.181381f, 0.771855f, 
		0.0846621f, 0.745429f, 0.661187f, 0.0846621f, 0.745429f, 0.661187f, 
		0.0607034f, 0.684240f, 0.726726f, -0.0589602f, 0.458079f, 0.886954f, 
		0.115303f, 0.986725f, -0.114367f, 0.339736f, -0.0517346f, -0.939097f, 
		-0.786427f, 0.188952f, -0.588072f, -0.786427f, 0.188952f, -0.588072f, 
		-0.819428f, -0.570963f, -0.0504007f, 0.356981f, -0.927311f, -0.112507f, 
		0.356981f, -0.927311f, -0.112507f, -0.971398f, 0.0535056f, 0.231350f, 
		-0.848760f, -0.504303f, -0.159011f, -0.598801f, 0.337286f, -0.726413f, 
		0.306369f, 0.183662f, -0.934027f, 0.350321f, -0.873120f, -0.339023f, 
		0.496919f, 0.715722f, -0.490728f, 0.404351f, 0.433598f, -0.805291f, 
		0.236070f, 0.922697f, 0.304797f, 0.236070f, 0.922697f, 0.304797f, 
		0.416592f, -0.366734f, 0.831840f, -0.978286f, 0.161306f, -0.130140f, 
		-0.655275f, -0.743573f, -0.133097f, -0.596111f, -0.802809f, 0.0122425f, 
		-0.545307f, -0.834075f, 0.0834241f, -0.921902f, 0.171959f, -0.347169f, 
		0.576323f, 0.0887520f, 0.812389f, -0.646189f, -0.586147f, -0.488744f, 
		-0.00793764f, -0.760618f, 0.649151f, -0.325202f, -0.890681f, -0.317695f, 
		0.207415f, 0.741099f, -0.638554f, 0.176582f, 0.983057f, -0.0491752f, 
		-0.930390f, 0.300614f, -0.209774f, -0.458210f, 0.375201f, 0.805772f, 
		-0.930390f, 0.300614f, -0.209774f, -0.476595f, -0.619590f, -0.623670f, 
		-0.564633f, -0.462940f, -0.683284f, -0.169458f, -0.969046f, -0.179536f, 
		-0.306294f, -0.834380f, -0.458251f, 0.558006f, 0.310780f, -0.769445f, 
		0.404808f, 0.909095f, -0.0983701f, 0.404808f, 0.909095f, -0.0983701f, 
		-0.393958f, -0.913327f, 0.103104f, -0.431696f, 0.0950286f, 0.896999f, 
		-0.656226f, 0.100683f, 0.747817f, -0.786681f, 0.0511449f, 0.615238f, 
		-0.126978f, -0.978355f, -0.163394f, -0.874966f, 0.364867f, -0.318287f, 
		-0.954171f, 0.299219f, -0.00497360f, 0.779025f, -0.0271695f, 0.626404f, 
		-0.694360f, 0.107507f, 0.711552f, -0.767278f, 0.178036f, 0.616107f, 
		-0.278578f, 0.0927316f, 0.955926f, -0.923288f, -0.0252520f, 0.383278f, 
		-0.728090f, -0.587674f, -0.352880f, 0.281148f, -0.236012f, -0.930190f, 
		0.126125f, 0.979867f, -0.154771f, -0.573157f, 0.116836f, 0.811074f, 
		-0.573157f, 0.116836f, 0.811074f, -0.176150f, -0.0746989f, -0.981525f, 
		-0.949410f, 0.306442f, -0.0686637f, -0.949410f, 0.306442f, -0.0686637f, 
		0.127019f, 0.235807f, 0.963463f, -0.949410f, 0.306442f, -0.0686637f, 
		-0.949410f, 0.306442f, -0.0686637f, -0.441563f, -0.775753f, 0.450810f, 
		0.607945f, -0.699219f, -0.376159f, 0.607945f, -0.699219f, -0.376159f, 
		0.652013f, -0.697196f, -0.297989f, 0.556215f, -0.662829f, -0.501281f, 
		0.607945f, -0.699219f, -0.376159f, 0.638608f, -0.393907f, -0.661073f, 
		-0.972135f, 0.0510537f, 0.228796f, 0.734922f, 0.677716f, 0.0243115f, 
		0.664567f, -0.0320298f, -0.746542f, 0.534455f, -0.771317f, -0.345583f, 
		0.552506f, -0.833001f, -0.0290838f, 0.494452f, -0.765091f, 0.412497f, 
		0.604229f, 0.270394f, 0.749530f, -0.274233f, 0.633476f, 0.723536f, 
		-0.514513f, -0.675185f, 0.528584f, -0.140849f, 0.0952399f, -0.985439f, 
		-0.954078f, 0.0220991f, -0.298743f, -0.744070f, 0.111962f, 0.658653f, 
		-0.744070f, 0.111962f, 0.658653f, 0.00128428f, 0.998917f, -0.0465198f, 
		0.00128428f, 0.998917f, -0.0465198f, -0.194808f, 0.526889f, 0.827308f, 
		0.770616f, 0.326110f, 0.547544f, 0.770616f, 0.326110f, 0.547544f, 
		0.431916f, -0.892250f, 0.131679f, -0.317787f, -0.0304280f, 0.947674f, 
		-0.754243f, -0.572791f, 0.320981f, -0.570689f, -0.762190f, 0.305581f, 
		-0.416622f, -0.871550f, 0.258509f, 0.655840f, -0.637310f, -0.404611f, 
		0.655840f, -0.637310f, -0.404611f, 0.134297f, 0.978319f, 0.157656f, 
		-0.605898f, 0.121379f, -0.786228f, -0.605898f, 0.121379f, -0.786228f, 
		-0.278283f, 0.0767256f, 0.957430f, -0.917394f, 0.0941559f, 0.386683f, 
		-0.846019f, 0.526528f, 0.0837898f, 0.875663f, 0.168673f, 0.452508f, 
		-0.298046f, -0.00891852f, 0.954510f, -0.933648f, 0.0892189f, 0.346901f, 
		-0.242478f, 0.968930f, 0.0487654f, -0.297525f, -0.947972f, 0.113256f, 
		0.197574f, 0.978089f, -0.0656282f, -0.940649f, 0.260592f, 0.217419f, 
		0.0679988f, 0.322754f, 0.944037f, -0.940649f, 0.260592f, 0.217419f, 
		-0.972175f, 0.124085f, 0.198691f, 0.894981f, 0.0519871f, -0.443065f, 
		0.894981f, 0.0519871f, -0.443065f, -0.721280f, 0.565033f, -0.400616f, 
		-0.731868f, 0.212369f, -0.647510f, -0.731868f, 0.212369f, -0.647510f, 
		0.494556f, 0.438112f, -0.750648f, -0.733076f, 0.304811f, -0.608021f, 
		-0.731868f, 0.212369f, -0.647510f, 0.685464f, 0.698787f, 0.204539f, 
		0.148807f, 0.986725f, -0.0650394f, -0.0979873f, -0.0299666f, -0.994736f, 
		-0.940161f, 0.278426f, -0.196409f, 0.711753f, 0.278684f, -0.644781f, 
		0.711753f, 0.278684f, -0.644781f, 0.711753f, 0.278684f, -0.644781f, 
		0.452196f, 0.862469f, 0.227301f, -0.334997f, -0.919454f, 0.205866f, 
		-0.736468f, 0.119211f, 0.665886f, -0.736468f, 0.119211f, 0.665886f, 
		-0.194808f, 0.526889f, 0.827308f, 0.770214f, 0.183995f, 0.610669f, 
		0.777333f, 0.621596f, -0.0968072f, 0.770214f, 0.183995f, 0.610669f, 
		0.770214f, 0.183995f, 0.610669f, -0.920435f, 0.133817f, 0.367277f, 
		-0.579149f, -0.133207f, 0.804265f, -0.833197f, 0.0503525f, 0.550679f, 
		-0.298316f, 0.921443f, -0.248900f, -0.923723f, 0.292571f, -0.247261f, 
		-0.669109f, 0.719110f, -0.187550f, -0.855915f, 0.501917f, -0.124456f, 
		-0.142487f, 0.892589f, -0.427764f, 0.224582f, 0.865189f, -0.448342f, 
		-0.967935f, 0.103077f, 0.229078f, 0.00128428f, 0.998917f, -0.0465198f, 
		0.00128428f, 0.998917f, -0.0465198f, -0.872572f, 0.130565f, -0.470714f, 
		0.494556f, 0.438112f, -0.750648f, -0.0262142f, 0.436105f, -0.899514f, 
		-0.0262142f, 0.436105f, -0.899514f, -0.0262142f, 0.436105f, -0.899514f, 
		0.375478f, 0.0583546f, 0.924993f, 0.892803f, -0.0983815f, -0.439573f, 
		-0.372869f, 0.0630195f, -0.925742f, 0.892803f, -0.0983815f, -0.439573f, 
		0.759170f, -0.183766f, 0.624412f, 0.243286f, 0.934489f, -0.259890f, 
		0.243286f, 0.934489f, -0.259890f, 0.732930f, -0.297091f, 0.612005f, 
		-0.384010f, -0.919146f, 0.0877874f, 0.393476f, -0.756187f, -0.522836f, 
		-0.778258f, -0.627823f, 0.0123635f, -0.481171f, 0.569687f, -0.666281f, 
		-0.670343f, 0.490139f, -0.557140f, 0.0322915f, 0.843607f, -0.535989f, 
		0.193791f, 0.859784f, -0.472458f, 0.386959f, -0.778872f, 0.493579f, 
		0.353814f, -0.740380f, 0.571536f, 0.322690f, -0.691034f, 0.646795f, 
		-0.233112f, -0.966574f, -0.106741f, 0.197574f, 0.978089f, -0.0656282f, 
		0.958833f, -0.0460039f, -0.280220f, -0.404292f, 0.0416755f, -0.913680f, 
		0.899268f, -0.0136103f, 0.437186f, 0.339736f, -0.0517346f, -0.939097f, 
		0.899268f, -0.0136103f, 0.437186f, -0.320613f, 0.184217f, 0.929124f, 
		0.899268f, -0.0136103f, 0.437186f, -0.330681f, -0.807306f, -0.488781f, 
		0.161512f, 0.985241f, -0.0566886f, 0.831983f, 0.0381530f, 0.553487f, 
		0.338657f, -0.0526461f, -0.939436f, 0.181539f, 0.981087f, -0.0671666f, 
		0.371312f, 0.0650209f, 0.926229f, 0.794485f, -0.0980965f, -0.599308f, 
		0.548114f, 0.438962f, -0.711958f, -0.173111f, -0.233051f, -0.956933f, 
		-0.896171f, -0.200306f, -0.395923f, 0.477186f, -0.0727654f, 0.875785f, 
		-0.970691f, 0.232623f, 0.0603785f, -0.188939f, -0.943870f, 0.270947f, 
		-0.306147f, -0.843442f, 0.441451f, 0.0503455f, 0.172462f, 0.983729f, 
		0.501750f, 0.864114f, 0.0394151f, 0.745193f, 0.646019f, 0.165370f, 
		0.903455f, 0.353411f, 0.242631f, -0.392895f, 0.282211f, 0.875209f, 
		-0.307454f, -0.0615172f, 0.949572f, -0.961576f, 0.113181f, 0.250124f, 
		-0.100599f, -0.994477f, 0.0299195f, -0.346146f, -0.916497f, -0.200539f, 
		-0.763683f, 0.122557f, -0.633852f, -0.763683f, 0.122557f, -0.633852f, 
		-0.970453f, 0.157181f, -0.183071f, 0.689188f, -0.639177f, 0.341281f, 
		-0.939090f, 0.138664f, -0.314456f, 0.436683f, -0.764352f, -0.474420f, 
		0.407405f, -0.729224f, -0.549776f, 0.378755f, -0.689399f, -0.617473f, 
		-0.727465f, -0.605297f, 0.323126f, -0.847988f, 0.528170f, -0.0441906f, 
		-0.950955f, 0.159497f, 0.265040f, 0.527705f, -0.256991f, -0.809620f, 
		-0.676433f, -0.226448f, -0.700828f, -0.457201f, -0.564937f, -0.686887f, 
		-0.445990f, -0.494971f, -0.745719f, -0.327825f, -0.722918f, -0.608211f, 
		-0.530134f, -0.129020f, -0.838040f, -0.769481f, 0.0740289f, -0.634365f, 
		-0.313618f, -0.794907f, -0.519391f, -0.388504f, 0.704471f, 0.593958f, 
		-0.356358f, 0.770836f, 0.528034f, -0.351129f, 0.809969f, 0.469743f, 
		0.482350f, 0.614116f, -0.624660f, 0.944641f, 0.0899971f, -0.315521f, 
		-0.806164f, 0.514916f, -0.291480f, -0.653231f, 0.479040f, -0.586353f, 
		-0.270708f, 0.310269f, -0.911290f, -0.400217f, 0.403057f, -0.823026f, 
		-0.545682f, 0.741054f, -0.391242f, 0.993295f, -0.105089f, 0.0481868f, 
		-0.223682f, -0.919838f, -0.322280f, 0.443151f, -0.715895f, 0.539547f, 
		0.353253f, -0.776993f, 0.521051f, 0.628559f, -0.554342f, 0.545544f, 
		0.443151f, -0.715895f, 0.539547f, -0.962273f, 0.203767f, 0.180307f, 
		0.967308f, 0.0482903f, 0.248964f, 0.967308f, 0.0482903f, 0.248964f, 
		0.993295f, -0.105089f, 0.0481868f, 0.673190f, 0.736725f, 0.0636481f, 
		-0.982457f, 0.156410f, -0.101559f, 0.585124f, 0.0530017f, -0.809210f, 
		0.468201f, 0.874208f, -0.128638f, 0.103382f, 0.757584f, -0.644499f, 
		0.280647f, 0.824484f, -0.491389f, 0.500440f, 0.719124f, 0.482100f, 
		-0.722149f, -0.623862f, 0.298827f, -0.561064f, -0.761370f, 0.324843f, 
		-0.946853f, -0.293026f, 0.132687f, -0.526014f, 0.216683f, 0.822410f, 
		0.569445f, -0.127023f, -0.812156f, 0.456252f, -0.110677f, -0.882941f, 
		0.501657f, -0.135536f, -0.854383f, 0.446163f, 0.482030f, -0.754046f, 
		0.0851259f, 0.638629f, -0.764792f, 0.203303f, 0.610933f, -0.765133f, 
		-0.169663f, 0.291742f, -0.941329f, -0.930551f, 0.318653f, -0.180375f, 
		-0.658206f, 0.463755f, -0.593039f, 0.349984f, 0.212646f, -0.912301f, 
		0.447718f, 0.114176f, -0.886855f, 0.187561f, 0.451906f, -0.872125f, 
		0.986512f, 0.0349015f, -0.159925f, 0.986512f, 0.0349015f, -0.159925f, 
		0.574256f, 0.0760336f, 0.815137f, -0.631352f, 0.0625508f, -0.772970f, 
		-0.715434f, -0.148427f, -0.682732f, -0.533610f, -0.249664f, -0.808040f, 
		-0.621630f, -0.0827383f, -0.778929f, -0.533610f, -0.249664f, -0.808040f, 
		-0.805176f, 0.123931f, -0.579941f, 0.513986f, 0.224484f, 0.827904f, 
		-0.717819f, -0.599361f, -0.354263f, 0.346648f, -0.434111f, -0.831494f, 
		0.907256f, 0.227428f, -0.353784f, -0.723481f, -0.152147f, -0.673370f, 
		-0.767936f, -0.0948778f, -0.633461f, -0.723481f, -0.152147f, -0.673370f, 
		-0.666377f, -0.197585f, -0.718959f, 0.990325f, 0.00196038f, 0.138753f, 
		0.990325f, 0.00196038f, 0.138753f, 0.990325f, 0.00196038f, 0.138753f, 
		-0.897724f, 0.0117668f, -0.440402f, -0.897724f, 0.0117668f, -0.440402f, 
		-0.196169f, -0.0786547f, -0.977410f, 0.140149f, -0.613431f, 0.777213f, 
		0.140149f, -0.613431f, 0.777213f, 0.0995131f, 0.987443f, -0.122692f, 
		-0.193763f, 0.673752f, 0.713102f, 0.777333f, 0.621596f, -0.0968072f, 
		0.798908f, 0.146889f, 0.583241f, -0.299024f, -0.0367244f, 0.953539f, 
		-0.967650f, 0.0142267f, 0.251894f, -0.110945f, 0.967217f, 0.228435f, 
		-0.777466f, 0.145828f, 0.611785f, 0.997751f, 0.0248467f, 0.0622573f, 
		-0.0979873f, -0.0299666f, -0.994736f, 0.997751f, 0.0248467f, 0.0622573f, 
		0.184589f, 0.146166f, 0.971886f, 0.997751f, 0.0248467f, 0.0622573f, 
		-0.187000f, 0.224479f, -0.956368f, 0.511328f, -0.779998f, 0.360759f, 
		-0.136309f, 0.990058f, -0.0347073f, -0.136309f, 0.990058f, -0.0347073f, 
		-0.791716f, 0.207933f, -0.574412f, -0.194808f, 0.526889f, 0.827308f, 
		-0.791716f, 0.207933f, -0.574412f, 0.777333f, 0.621596f, -0.0968072f, 
		-0.791716f, 0.207933f, -0.574412f, -0.101056f, -0.994394f, -0.0311276f, 
		-0.883423f, -0.0841815f, -0.460953f, -0.185230f, 0.0531386f, -0.981257f, 
		-0.350413f, -0.915055f, -0.199712f, 0.523427f, 0.495926f, 0.692880f, 
		-0.242478f, 0.968930f, 0.0487654f, 0.597123f, 0.801968f, 0.0170730f, 
		0.933740f, 0.224274f, 0.278982f, 0.968571f, -0.0432198f, 0.244955f, 
		0.964690f, 0.141000f, 0.222469f, -0.328659f, -0.0298247f, 0.943977f, 
		-0.965589f, 0.0862536f, 0.245352f, -0.0395092f, 0.985306f, 0.166168f, 
		-0.267140f, 0.216229f, -0.939085f, 0.847166f, 0.158344f, -0.507186f, 
		0.995465f, -0.0371279f, -0.0875824f, 0.995465f, -0.0371279f, -0.0875824f, 
		0.995465f, -0.0371279f, -0.0875824f, 0.0841004f, -0.995232f, -0.0493930f, 
		0.0602103f, -0.668580f, 0.741199f, 0.0946093f, -0.987922f, 0.122715f, 
		-0.0546363f, -0.417825f, 0.906883f, -0.992372f, 0.123023f, -0.00789833f, 
		-0.519538f, 0.829309f, 0.205735f, -0.707674f, 0.700801f, 0.0898603f, 
		-0.581353f, 0.262850f, 0.770025f, -0.918565f, 0.392363f, 0.0478594f, 
		0.574327f, -0.341629f, -0.743934f, 0.0634652f, 0.971113f, 0.230026f, 
		-0.916679f, 0.376384f, 0.134295f, 0.137268f, 0.880529f, 0.453681f, 
		0.137268f, 0.880529f, 0.453681f, -0.702019f, 0.616373f, 0.356727f, 
		0.692359f, -0.643634f, -0.326151f, 0.692359f, -0.643634f, -0.326151f, 
		0.778106f, -0.519138f, -0.353620f, 0.991356f, 0.109904f, 0.0716487f, 
		0.386390f, 0.922329f, 0.00336841f, 0.386390f, 0.922329f, 0.00336841f, 
		0.992437f, -0.115789f, 0.0407547f, -0.0190126f, 0.0150140f, -0.999707f, 
		0.331634f, 0.139999f, 0.932963f, 0.891991f, 0.186535f, -0.411773f, 
		-0.345081f, 0.263532f, -0.900817f, 0.891991f, 0.186535f, -0.411773f, 
		0.891991f, 0.186535f, -0.411773f, -0.696597f, 0.111056f, -0.708815f, 
		-0.438000f, 0.449134f, -0.778739f, -0.549373f, 0.351852f, -0.757885f, 
		-0.438000f, 0.449134f, -0.778739f, -0.749117f, 0.284286f, -0.598335f, 
		-0.185686f, -0.221795f, -0.957250f, 0.529964f, -0.490486f, -0.691782f, 
		0.631980f, 0.403528f, -0.661639f, 0.221281f, 0.255966f, 0.941019f, 
		0.208989f, 0.488754f, 0.847020f, 0.202362f, 0.613925f, 0.762985f, 
		0.703078f, -0.586312f, -0.402393f, 0.703078f, -0.586312f, -0.402393f, 
		0.217335f, 0.974043f, -0.0632873f, 0.993921f, -0.0942388f, -0.0569305f, 
		0.993921f, -0.0942388f, -0.0569305f, 0.127019f, 0.235807f, 0.963463f, 
		0.678674f, -0.678535f, 0.281055f, 0.689138f, -0.478339f, 0.544316f, 
		0.607677f, -0.324298f, 0.724955f, 0.720064f, -0.539433f, 0.436485f, 
		0.662639f, -0.384461f, 0.642728f, -0.631352f, 0.0625508f, -0.772970f, 
		0.699174f, -0.0600236f, 0.712427f, 0.697403f, 0.694046f, 0.178688f, 
		0.726867f, -0.286395f, -0.624214f, -0.0333234f, -0.999216f, 0.0213920f, 
		0.504197f, -0.323758f, -0.800604f, 0.784018f, -0.511953f, 0.351026f, 
		-0.178195f, 0.957454f, 0.226997f, 0.669737f, 0.742578f, 0.00549017f, 
		-0.939277f, 0.291683f, 0.180773f, 0.165014f, -0.569568f, -0.805210f, 
		0.165014f, -0.569568f, -0.805210f, -0.338299f, 0.587046f, 0.735480f, 
		-0.338299f, 0.587046f, 0.735480f, 0.865405f, 0.314693f, 0.389927f, 
		0.529136f, 0.152775f, -0.834671f, 0.865405f, 0.314693f, 0.389927f, 
		0.885649f, 0.226352f, 0.405452f, 0.865405f, 0.314693f, 0.389927f, 
		0.823488f, 0.370702f, 0.429473f, -0.939772f, 0.0250209f, 0.340886f, 
		-0.975051f, 0.0831958f, 0.205801f, -0.486175f, -0.0829842f, 0.869912f, 
		-0.746213f, -0.0222525f, 0.665335f, 0.362881f, 0.914257f, -0.180146f, 
		0.320070f, 0.937055f, 0.139583f, 0.330160f, 0.943811f, -0.0146737f, 
		0.320863f, 0.865715f, 0.384167f, 0.250239f, 0.751042f, 0.610997f, 
		0.214242f, 0.852959f, 0.475985f, 0.172905f, 0.954506f, 0.242945f, 
		0.271195f, 0.723240f, -0.635120f, 0.271195f, 0.723240f, -0.635120f, 
		-0.702019f, 0.616373f, 0.356727f, 0.515357f, -0.658167f, -0.548839f, 
		-0.942940f, -0.332868f, -0.00791322f, -0.989246f, -0.0620392f, -0.132451f, 
		-0.984860f, 0.0185351f, -0.172359f, 0.691486f, -0.188862f, 0.697265f, 
		0.691486f, -0.188862f, 0.697265f, -0.381819f, -0.846901f, 0.370098f, 
		-0.645713f, -0.687230f, 0.332821f, -0.627261f, 0.477988f, 0.614876f, 
		-0.791848f, 0.514214f, 0.329486f, -0.234991f, 0.310064f, 0.921216f, 
		-0.366516f, 0.401987f, 0.839090f, 0.880333f, 0.162466f, 0.445667f, 
		-0.728804f, -0.677092f, 0.101938f, -0.344187f, 0.0312878f, 0.938380f, 
		-0.967829f, 0.128694f, 0.216204f, -0.764442f, 0.509672f, 0.394794f, 
		-0.545090f, 0.443023f, 0.711764f, -0.400600f, 0.353889f, 0.845152f, 
		0.336504f, 0.907909f, -0.249933f, 0.329893f, 0.841516f, -0.427810f, 
		0.404475f, 0.880848f, -0.245982f, 0.433710f, 0.900496f, 0.0316731f, 
		0.385477f, 0.761914f, -0.520476f, 0.225562f, 0.828005f, -0.513352f, 
		-0.242478f, 0.968930f, 0.0487654f, -0.285895f, -0.958192f, 0.0114627f, 
		-0.0690629f, -0.750889f, -0.656808f, 0.0785632f, -0.957237f, -0.278433f, 
		0.0674307f, -0.873786f, -0.481613f, 0.694891f, -0.0810848f, 0.714529f, 
		0.586418f, 0.796545f, -0.147071f, -0.870004f, 0.474681f, 0.133307f, 
		-0.842403f, 0.536524f, -0.0499951f, -0.789399f, 0.527384f, -0.314190f, 
		-0.754236f, 0.535625f, -0.379783f, -0.710020f, 0.688149f, -0.149407f, 
		-0.721832f, 0.621464f, -0.304535f, 0.866389f, -0.0571588f, 0.496088f, 
		0.778404f, -0.529266f, 0.337586f, -0.328742f, -0.108390f, 0.938179f, 
		-0.296578f, 0.100862f, -0.949667f, -0.957286f, 0.0309074f, -0.287487f, 
		-0.0347699f, 0.992696f, -0.115527f, 0.0566217f, 0.249146f, 0.966809f, 
		0.941703f, 0.212126f, -0.261147f, 0.558015f, -0.110557f, -0.822433f, 
		-0.738700f, 0.336903f, -0.583797f, -0.738700f, 0.336903f, -0.583797f, 
		-0.561998f, -0.112287f, -0.819482f, -0.925265f, 0.115949f, -0.361166f, 
		-0.780464f, 0.0141077f, -0.625041f, -0.400867f, -0.166887f, -0.900808f, 
		0.561755f, 0.726475f, -0.395810f, 0.286310f, -0.0584842f, 0.956351f, 
		0.286310f, -0.0584842f, 0.956351f, 0.803551f, -0.532026f, 0.266935f, 
		0.766414f, -0.615648f, -0.183267f, 0.841430f, -0.540364f, -0.00124745f, 
		0.814646f, -0.573833f, 0.0840736f, -0.587216f, 0.760196f, 0.277992f, 
		-0.958804f, 0.148236f, 0.242322f, -0.385915f, 0.0645751f, 0.920272f, 
		-0.00850177f, 0.146455f, 0.989181f, -0.0988099f, 0.432461f, -0.896222f, 
		0.961583f, -0.139023f, -0.236710f, 0.669737f, 0.742578f, 0.00549017f, 
		0.0600158f, -0.987126f, -0.148258f, -0.697478f, 0.704159f, -0.132980f, 
		-0.849049f, 0.313992f, -0.424882f, -0.837679f, 0.188009f, -0.512784f, 
		-0.517956f, 0.846183f, -0.125284f, -0.247155f, 0.208957f, -0.946177f, 
		-0.957748f, 0.139001f, -0.251789f, 0.574975f, -0.729209f, -0.371024f, 
		-0.780215f, 0.512484f, -0.358642f, -0.433200f, 0.357262f, -0.827467f, 
		-0.573140f, 0.446610f, -0.687059f, -0.878737f, 0.444333f, 0.174327f, 
		-0.112133f, -0.987388f, 0.111761f, -0.112133f, -0.987388f, 0.111761f, 
		-0.878737f, 0.444333f, 0.174327f, -0.399009f, -0.880269f, 0.256745f, 
		-0.298161f, -0.941103f, 0.159455f, -0.250615f, -0.964226f, 0.0863771f, 
		-0.298161f, -0.941103f, 0.159455f, -0.328742f, -0.108390f, 0.938179f, 
		-0.966721f, 0.114022f, -0.229017f, -0.732356f, -0.680883f, -0.00735198f, 
		-0.860744f, 0.121895f, 0.494228f, -0.860744f, 0.121895f, 0.494228f, 
		-0.127049f, -0.989914f, -0.0626772f, -0.0753145f, 0.977399f, 0.197531f, 
		-0.0753145f, 0.977399f, 0.197531f, -0.186587f, 0.166813f, -0.968173f, 
		-0.898664f, 0.138677f, 0.416139f, -0.0332752f, -0.687975f, 0.724971f, 
		0.329159f, 0.509248f, 0.795186f, -0.783639f, 0.544493f, -0.299059f, 
		-0.783639f, 0.544493f, -0.299059f, 0.529136f, 0.152775f, -0.834671f, 
		0.861724f, 0.452369f, 0.229768f, 0.843448f, -0.376910f, -0.382798f, 
		-0.716602f, -0.542532f, -0.438339f, -0.859315f, -0.324331f, -0.395458f, 
		0.942242f, -0.0623991f, 0.329068f, -0.483736f, -0.757109f, -0.439074f, 
		-0.328742f, -0.108390f, 0.938179f, -0.343816f, 0.166388f, -0.924178f, 
		-0.973142f, 0.105085f, -0.204820f, 0.127378f, 0.984473f, 0.120779f, 
		-0.936067f, 0.342759f, -0.0793372f, 0.589387f, -0.599424f, 0.541585f, 
		0.989126f, 0.146101f, -0.0168456f, 0.917347f, 0.397636f, 0.0189776f, 
		0.951452f, 0.302375f, 0.0575246f, 0.0127206f, 0.904155f, 0.427016f, 
		0.0127206f, 0.904155f, 0.427016f, -0.0333893f, 0.854448f, 0.518463f, 
		0.0564892f, 0.946355f, 0.318151f, 0.789299f, 0.391077f, -0.473355f, 
		-0.167248f, 0.892434f, 0.419034f, -0.167248f, 0.892434f, 0.419034f, 
		-0.364949f, 0.0446999f, 0.929954f, -0.940998f, 0.258527f, 0.218372f, 
		0.759691f, -0.123683f, 0.638414f, 0.0995131f, 0.987443f, -0.122692f, 
		-0.338299f, 0.587046f, 0.735480f, -0.716106f, 0.0348983f, -0.697119f, 
		-0.338299f, 0.587046f, 0.735480f, 0.0721656f, 0.828162f, -0.555823f, 
		0.00536715f, 0.923223f, -0.384228f, 0.174816f, 0.563675f, -0.807285f, 
		0.109411f, 0.779375f, -0.616932f, 0.0538394f, 0.875305f, -0.480565f, 
		0.593335f, 0.792122f, 0.143167f, -0.873868f, 0.477115f, -0.0933640f, 
		-0.774025f, 0.526495f, 0.351694f, -0.838344f, 0.537720f, 0.0896485f, 
		-0.746328f, -0.575203f, 0.334867f, 0.288998f, 0.724877f, 0.625327f, 
		-0.479683f, -0.750169f, -0.455138f, -0.162971f, 0.199017f, -0.966350f, 
		-0.356571f, -0.874347f, -0.329204f, -0.866346f, 0.103815f, -0.488535f, 
		0.568892f, 0.0892034f, -0.817560f, -0.155485f, 0.490090f, -0.857692f, 
		0.762030f, 0.526071f, -0.377571f, 0.0148685f, 0.999311f, -0.0339948f, 
		0.0148685f, 0.999311f, -0.0339948f, 0.0148685f, 0.999311f, -0.0339948f, 
		-0.434870f, 0.155180f, 0.887022f, 0.931478f, 0.336063f, 0.139321f, 
		0.931478f, 0.336063f, 0.139321f, 0.457471f, 0.281175f, -0.843600f, 
		0.931478f, 0.336063f, 0.139321f, 0.931478f, 0.336063f, 0.139321f, 
		0.931478f, 0.336063f, 0.139321f, 0.282974f, 0.725701f, -0.627124f, 
		0.283985f, 0.492607f, -0.822612f, 0.199739f, 0.243914f, -0.949005f, 
		0.139642f, 0.0751838f, -0.987344f, 0.199739f, 0.243914f, -0.949005f, 
		0.282974f, 0.725701f, -0.627124f, 0.913514f, 0.406610f, 0.0126857f, 
		0.867951f, 0.0991386f, 0.486654f, 0.922065f, 0.262217f, 0.284672f, 
		0.865276f, 0.239546f, 0.440358f, 0.609990f, 0.780389f, 0.137500f, 
		0.847937f, 0.509083f, 0.147775f, -0.207417f, 0.504824f, 0.837932f, 
		0.965937f, 0.200924f, -0.163083f, 0.965937f, 0.200924f, -0.163083f, 
		0.133855f, 0.0697294f, -0.988545f, 0.965937f, 0.200924f, -0.163083f, 
		0.536601f, -0.425389f, 0.728768f, 0.510582f, -0.853744f, 0.102109f, 
		0.610973f, -0.775969f, 0.156792f, 0.751555f, -0.605554f, 0.261668f, 
		0.594357f, -0.740124f, 0.314575f, -0.665190f, 0.744545f, 0.0563507f, 
		0.274012f, 0.771257f, -0.574526f, 0.189228f, 0.981886f, 0.00957629f, 
		0.0770234f, -0.996669f, -0.0267880f, -0.0212903f, -0.412475f, -0.910720f, 
		-0.153156f, -0.211376f, -0.965331f, -0.251798f, -0.0705637f, -0.965204f, 
		-0.964077f, 0.235864f, -0.122165f, 0.200044f, -0.779468f, 0.593643f, 
		-0.171615f, -0.862040f, -0.476902f, 0.302897f, -0.155089f, -0.940319f, 
		0.387063f, -0.190544f, -0.902150f, 0.425809f, -0.247755f, -0.870232f, 
		0.129296f, -0.736649f, -0.663800f, -0.187854f, -0.883610f, -0.428888f, 
		0.335261f, -0.306956f, -0.890718f, -0.936468f, 0.0441655f, 0.347962f, 
		0.0566217f, 0.249146f, 0.966809f, -0.936468f, 0.0441655f, 0.347962f, 
		-0.267140f, 0.216229f, -0.939085f, -0.936468f, 0.0441655f, 0.347962f, 
		-0.936468f, 0.0441655f, 0.347962f, -0.873672f, 0.134949f, 0.467425f, 
		-0.317800f, -0.940094f, 0.123395f, 0.586336f, -0.434075f, -0.683951f, 
		-0.763361f, 0.600212f, -0.238800f, -0.434870f, 0.155180f, 0.887022f, 
		0.872740f, 0.358310f, 0.331571f, 0.598264f, -0.785405f, -0.158807f, 
		-0.398341f, -0.864967f, -0.305216f, -0.398341f, -0.864967f, -0.305216f, 
		0.329159f, 0.509248f, 0.795186f, 0.00407599f, 0.944485f, -0.328530f, 
		0.0398480f, 0.985701f, -0.163725f, 0.944642f, 0.177810f, -0.275745f, 
		-0.505336f, 0.465429f, -0.726644f, 0.133855f, 0.0697294f, -0.988545f, 
		0.314867f, 0.584639f, -0.747700f, 0.452787f, 0.435011f, -0.778299f, 
		0.378454f, 0.521673f, -0.764611f, 0.780967f, -0.529951f, 0.330519f, 
		0.780967f, -0.529951f, 0.330519f, -0.0513647f, 0.364193f, -0.929906f, 
		0.397295f, -0.655246f, -0.642502f, -0.0513647f, 0.364193f, -0.929906f, 
		-0.323310f, 0.00830695f, -0.946257f, -0.941025f, 0.103730f, -0.322043f, 
		-0.276699f, 0.130558f, -0.952046f, -0.944608f, 0.0630203f, -0.322092f, 
		0.783655f, 0.0576856f, -0.618513f, -0.281555f, 0.915554f, -0.287207f, 
		-0.281555f, 0.915554f, -0.287207f, 0.967093f, 0.254199f, -0.0106739f, 
		-0.281555f, 0.915554f, -0.287207f, 0.457471f, 0.281175f, -0.843600f, 
		-0.816527f, 0.256969f, -0.516962f, -0.473055f, 0.483369f, 0.736595f, 
		-0.816527f, 0.256969f, -0.516962f, 0.529136f, 0.152775f, -0.834671f, 
		-0.816527f, 0.256969f, -0.516962f, -0.0904282f, -0.985568f, 0.143104f, 
		0.659741f, -0.440200f, -0.609069f, 0.562579f, 0.123273f, 0.817502f, 
		0.856528f, 0.514005f, 0.0464579f, 0.0431391f, 0.996051f, -0.0776031f, 
		-0.260824f, 0.540961f, 0.799583f, 0.965611f, 0.259668f, -0.0129486f, 
		0.965611f, 0.259668f, -0.0129486f, -0.663159f, -0.633679f, 0.398336f, 
		-0.468644f, -0.785959f, 0.403287f, -0.365316f, -0.851978f, 0.375070f, 
		0.602449f, 0.306639f, -0.736904f, 0.505537f, 0.347227f, -0.789852f, 
		0.555296f, 0.317252f, -0.768764f, -0.862870f, 0.0106911f, -0.505313f, 
		0.935503f, 0.327892f, -0.131609f, 0.576323f, 0.0887520f, 0.812389f, 
		-0.596631f, -0.233325f, -0.767848f, -0.765250f, -0.144455f, -0.627315f, 
		-0.109112f, 0.991809f, -0.0664106f, -0.951982f, 0.00371664f, 0.306131f, 
		-0.223412f, 0.336195f, 0.914910f, -0.0382355f, 0.985065f, 0.167882f, 
		-0.770220f, 0.624746f, -0.128272f, 0.127378f, 0.984473f, 0.120779f, 
		0.0847265f, -0.996320f, -0.0129311f, 0.634806f, 0.759696f, -0.141009f, 
		0.382659f, -0.902501f, -0.197648f, 0.382659f, -0.902501f, -0.197648f, 
		0.382659f, -0.902501f, -0.197648f, 0.382659f, -0.902501f, -0.197648f, 
		-0.122632f, -0.990191f, 0.0669624f, 0.223210f, 0.113780f, -0.968107f, 
		0.282331f, -0.883138f, -0.374642f, 0.282331f, -0.883138f, -0.374642f, 
		0.223210f, 0.113780f, -0.968107f, -0.167248f, 0.892434f, 0.419034f, 
		0.663987f, 0.745886f, -0.0526865f, 0.223145f, -0.974016f, 0.0387134f, 
		-0.167248f, 0.892434f, 0.419034f, -0.438310f, 0.0463584f, 0.897628f, 
		0.223145f, -0.974016f, 0.0387134f, 0.667798f, -0.461240f, 0.584212f, 
		0.839932f, -0.506507f, 0.194845f, -0.912741f, 0.192197f, -0.360504f, 
		-0.847673f, 0.148969f, -0.509175f, -0.555948f, 0.154187f, -0.816791f, 
		0.655741f, 0.713283f, -0.247448f, 0.616070f, 0.713273f, -0.334213f, 
		0.531141f, 0.781803f, -0.326610f, 0.613457f, 0.738208f, -0.280569f, 
		0.594406f, 0.781831f, -0.188207f, -0.839876f, 0.270339f, -0.470665f, 
		-0.184682f, -0.968275f, -0.168334f, -0.115136f, -0.978255f, -0.172513f, 
		0.155258f, 0.399752f, 0.903379f, -0.145209f, 0.932063f, 0.331923f, 
		-0.145209f, 0.932063f, 0.331923f, 0.651326f, 0.263919f, -0.711422f, 
		0.345925f, 0.784805f, -0.514214f, 0.785992f, -0.173966f, -0.593256f, 
		0.775551f, 0.0129805f, -0.631152f, -0.0808251f, 0.761228f, -0.643428f, 
		0.111910f, 0.727680f, -0.676726f, -0.251177f, 0.785397f, -0.565741f, 
		-0.967624f, 0.0557009f, -0.246174f, 0.387534f, 0.915514f, 0.107945f, 
		0.935503f, 0.327892f, -0.131609f, -0.349392f, -0.0613815f, -0.934964f, 
		-0.297275f, -0.950988f, -0.0851406f, 0.727564f, 0.685259f, 0.0327364f, 
		0.658338f, -0.368266f, 0.656484f, -0.00108146f, 0.271542f, 0.962426f, 
		0.328194f, 0.717200f, 0.614746f, 0.395015f, -0.834099f, -0.385021f, 
		0.243703f, -0.910101f, -0.335150f, 0.122829f, -0.934056f, -0.335340f, 
		0.535989f, -0.698200f, -0.474587f, 0.455263f, -0.773272f, -0.441347f, 
		0.579408f, -0.806337f, 0.118778f, 0.579408f, -0.806337f, 0.118778f, 
		0.557700f, 0.825562f, -0.0861356f, 0.0878383f, 0.605215f, -0.791201f, 
		0.307463f, 0.327984f, 0.893249f, 0.531525f, -0.606692f, -0.591105f, 
		-0.122897f, -0.0801703f, 0.989176f, 0.0992188f, -0.00790834f, 0.995034f, 
		0.331613f, -0.0131069f, 0.943324f, -0.785679f, 0.392116f, -0.478490f, 
		-0.751825f, 0.517287f, -0.408868f, -0.789845f, 0.450484f, -0.416183f, 
		-0.863845f, -0.493496f, 0.101158f, -0.298457f, -0.722213f, -0.623965f, 
		0.412978f, 0.901154f, -0.131796f, -0.0129475f, 0.271343f, -0.962396f, 
		-0.0129475f, 0.271343f, -0.962396f, -0.112581f, 0.523763f, -0.844392f, 
		-0.106048f, 0.439242f, -0.892088f, 0.0424261f, 0.171219f, -0.984319f, 
		-0.259058f, 0.686673f, -0.679241f, -0.939296f, 0.191633f, 0.284603f, 
		-0.333265f, 0.0866940f, 0.938839f, 0.672710f, -0.739734f, 0.0159573f, 
		-0.787715f, 0.474183f, -0.393263f, -0.787715f, 0.474183f, -0.393263f, 
		-0.434870f, 0.155180f, 0.887022f, -0.787715f, 0.474183f, -0.393263f, 
		0.457471f, 0.281175f, -0.843600f, -0.787715f, 0.474183f, -0.393263f, 
		0.889199f, -0.403709f, 0.215276f, 0.781550f, -0.297491f, 0.548341f, 
		0.715088f, -0.305591f, -0.628699f, -0.467566f, 0.863724f, 0.188051f, 
		-0.274716f, 0.955688f, 0.105794f, -0.103556f, 0.994391f, 0.0215125f, 
		0.0618130f, 0.0707666f, -0.995576f, 0.205527f, 0.752721f, -0.625436f, 
		-0.702019f, 0.616373f, 0.356727f, 0.692430f, -0.683267f, -0.231703f, 
		0.704860f, -0.708963f, 0.0233435f, 0.625271f, -0.520362f, 0.581601f, 
		0.593731f, -0.310138f, 0.742495f, 0.809888f, -0.160704f, 0.564142f, 
		0.169648f, 0.753311f, -0.635407f, -0.0269097f, 0.981994f, 0.186984f, 
		-0.0269097f, 0.981994f, 0.186984f, 0.387534f, 0.915514f, 0.107945f, 
		0.935503f, 0.327892f, -0.131609f, -0.978084f, -0.180007f, -0.104637f, 
		-0.412238f, -0.780686f, -0.469669f, 0.576323f, 0.0887520f, 0.812389f, 
		-0.256768f, 0.138146f, -0.956549f, -0.926908f, 0.147758f, -0.344976f, 
		0.373093f, 0.760594f, 0.531318f, 0.443348f, 0.815939f, 0.371060f, 
		0.443348f, 0.815939f, 0.371060f, -0.703852f, 0.596193f, -0.386193f, 
		-0.355049f, 0.168732f, -0.919494f, -0.897036f, 0.253229f, -0.362217f, 
		-0.897036f, 0.253229f, -0.362217f, 0.356547f, 0.915755f, 0.185113f, 
		-0.436897f, -0.171239f, -0.883062f, -0.155485f, 0.490090f, -0.857692f, 
		0.577220f, -0.449660f, -0.681633f, 0.735709f, 0.672898f, -0.0770731f, 
		-0.0347699f, 0.992696f, -0.115527f, -0.954229f, -0.0121345f, 0.298829f, 
		-0.954229f, -0.0121345f, 0.298829f, -0.505336f, 0.465429f, -0.726644f, 
		-0.192365f, 0.794257f, 0.576325f, 0.751058f, 0.0349649f, 0.659310f, 
		0.910268f, 0.0353656f, 0.412507f, 0.541776f, -0.0918581f, 0.835488f, 
		0.206420f, -0.893637f, -0.398503f, 0.00568128f, 0.0978054f, -0.995189f, 
		0.757503f, 0.612324f, 0.226381f, 0.695623f, -0.0861036f, 0.713228f, 
		0.306275f, -0.909691f, -0.280461f, 0.306275f, -0.909691f, -0.280461f, 
		0.643580f, 0.765241f, 0.0145061f, 0.694385f, 0.710408f, 0.114673f, 
		0.806685f, 0.448547f, 0.384792f, 0.802628f, 0.353053f, 0.480772f, 
		0.802628f, 0.353053f, 0.480772f, 0.812219f, 0.583351f, -0.00140421f, 
		-0.0217576f, 0.943732f, 0.329994f, 0.0882537f, 0.678687f, 0.729106f, 
		0.117909f, 0.841382f, 0.527421f, 0.932530f, 0.294460f, -0.209001f, 
		0.918285f, -0.393216f, -0.0461965f, -0.157917f, 0.976220f, -0.148518f, 
		-0.157917f, 0.976220f, -0.148518f, -0.993189f, 0.115010f, 0.0186903f, 
		-0.312763f, 0.574052f, 0.756732f, -0.0877967f, 0.868946f, -0.487058f, 
		0.0136173f, 0.743736f, -0.668334f, -0.0242610f, 0.802817f, -0.595732f, 
		0.0136173f, 0.743736f, -0.668334f, 0.124567f, 0.644352f, -0.754515f, 
		0.105812f, 0.714160f, -0.691938f, -0.490398f, -0.400971f, -0.773778f, 
		-0.112813f, -0.971067f, -0.210479f, -0.758543f, 0.651597f, -0.00583810f, 
		0.153950f, 0.986469f, 0.0563788f, -0.336232f, 0.186855f, -0.923056f, 
		0.351112f, -0.452924f, -0.819500f, 0.326796f, -0.436299f, 0.838360f, 
		-0.430602f, 0.819964f, -0.377148f, -0.984722f, 0.121914f, -0.124333f, 
		-0.610373f, 0.673054f, -0.417664f, -0.984722f, 0.121914f, -0.124333f, 
		-0.941850f, 0.254233f, -0.219738f, 0.387534f, 0.915514f, 0.107945f, 
		-0.799681f, -0.600088f, 0.0201372f, -0.598279f, -0.801167f, 0.0139117f, 
		-0.598279f, -0.801167f, 0.0139117f, -0.690356f, -0.723440f, -0.00661320f, 
		-0.984949f, 0.0767140f, 0.154886f, -0.260824f, 0.540961f, 0.799583f, 
		-0.984949f, 0.0767140f, 0.154886f, -0.505336f, 0.465429f, -0.726644f, 
		0.133855f, 0.0697294f, -0.988545f, -0.984949f, 0.0767140f, 0.154886f, 
		0.711475f, -0.109129f, 0.694186f, 0.684606f, 0.422912f, -0.593683f, 
		-0.925589f, 0.292603f, 0.240141f, -0.421655f, -0.850683f, 0.313919f, 
		0.792806f, -0.343164f, -0.503684f, 0.857634f, -0.193288f, 0.476555f, 
		-0.864096f, -0.115093f, 0.489991f, -0.734136f, -0.0790382f, 0.674386f, 
		-0.600306f, -0.159457f, 0.783713f, 0.325304f, 0.932791f, -0.155174f, 
		-0.978769f, 0.145758f, 0.144102f, -0.978769f, 0.145758f, 0.144102f, 
		0.150278f, 0.982963f, -0.105830f, 0.855135f, 0.330055f, -0.399760f, 
		0.0675044f, 0.706616f, -0.704370f, 0.171710f, 0.827484f, -0.534589f, 
		0.281621f, 0.925187f, -0.254400f, 0.585495f, 0.0399182f, 0.809692f, 
		0.810097f, 0.0140485f, 0.586128f, 0.935852f, 0.0327272f, 0.350869f, 
		0.362440f, 0.0633211f, 0.929853f, -0.802602f, -0.434319f, -0.408898f, 
		-0.234214f, 0.201335f, -0.951109f, 0.538900f, 0.402372f, 0.740056f, 
		0.863049f, 0.445658f, 0.237772f, 0.860258f, 0.508427f, 0.0381774f, 
		0.352159f, 0.406757f, 0.842931f, -0.236722f, 0.146825f, -0.960419f, 
		-0.927001f, 0.143656f, -0.346457f, 0.195616f, 0.415640f, 0.888244f, 
		-0.133209f, 0.930405f, 0.341469f, 0.884154f, 0.466778f, -0.0197458f, 
		0.431122f, 0.850598f, -0.301027f, 0.249369f, 0.958049f, -0.141267f, 
		0.339208f, 0.912073f, -0.230350f, 0.716513f, -0.660748f, 0.223654f, 
		0.734625f, 0.583461f, 0.346266f, -0.563619f, 0.391798f, -0.727205f, 
		-0.555948f, 0.154187f, -0.816791f, -0.426276f, -0.902772f, -0.0573695f, 
		-0.600391f, 0.525164f, -0.603103f, 0.830206f, -0.385383f, 0.402787f, 
		0.546516f, -0.501059f, -0.671015f, -0.377228f, 0.673594f, -0.635586f, 
		0.126822f, 0.811339f, -0.570654f, 0.830206f, -0.385383f, 0.402787f, 
		0.434979f, 0.821228f, -0.369294f, 0.434979f, 0.821228f, -0.369294f, 
		-0.684928f, 0.594599f, 0.421101f, -0.320761f, 0.165694f, 0.932554f, 
		-0.538551f, -0.175720f, 0.824066f, -0.444618f, -0.733938f, 0.513469f, 
		-0.373905f, -0.863933f, 0.337365f, -0.323640f, -0.911149f, 0.255078f, 
		-0.373905f, -0.863933f, 0.337365f, -0.662499f, -0.748747f, 0.0217613f, 
		0.743622f, 0.152580f, 0.650958f, -0.694629f, -0.668185f, 0.266493f, 
		-0.909528f, 0.302555f, 0.284991f, -0.275259f, 0.0914988f, 0.957006f, 
		0.900086f, 0.143081f, -0.411549f, 0.538054f, -0.698297f, -0.472100f, 
		0.907633f, 0.374065f, 0.190465f, 0.315216f, -0.816233f, -0.484151f, 
		0.645493f, -0.579116f, -0.497960f, 0.523884f, -0.668755f, -0.527553f, 
		0.909125f, 0.00229032f, -0.416516f, 0.903705f, -0.112212f, -0.413190f, 
		-0.600306f, -0.159457f, 0.783713f, 0.466301f, -0.505866f, 0.725715f, 
		-0.373133f, -0.170408f, 0.911994f, 0.361525f, -0.398287f, 0.843011f, 
		0.0958553f, -0.114234f, 0.988819f, 0.751584f, 0.391237f, 0.531089f, 
		0.952800f, -0.0163541f, 0.303158f, 0.952800f, -0.0163541f, 0.303158f, 
		0.0267932f, 0.392339f, 0.919430f, -0.980620f, 0.187125f, -0.0580347f, 
		-0.294538f, -0.955409f, 0.0210045f, -0.231532f, 0.187796f, -0.954529f, 
		-0.937666f, 0.0256819f, -0.346587f, -0.632762f, 0.583121f, -0.509492f, 
		-0.484322f, 0.696672f, -0.529226f, -0.0766664f, 0.821210f, -0.565453f, 
		0.763896f, -0.560252f, 0.320282f, -0.642510f, -0.762777f, 0.0731516f, 
		0.813277f, -0.530505f, 0.239051f, -0.710326f, -0.701465f, 0.0581751f, 
		-0.551648f, -0.833451f, 0.0322977f, -0.207826f, 0.961356f, -0.180564f, 
		-0.651736f, 0.755252f, -0.0695295f, -0.0528754f, 0.986085f, -0.157612f, 
		-0.0528754f, 0.986085f, -0.157612f, -0.0460231f, -0.923815f, -0.380064f, 
		-0.205177f, -0.941592f, -0.267033f, -0.101168f, -0.948552f, -0.300024f, 
		-0.121475f, 0.752374f, -0.647438f, 0.813277f, -0.530505f, 0.239051f, 
		-0.902511f, -0.368515f, 0.222869f, 0.546516f, -0.501059f, -0.671015f, 
		-0.703994f, 0.623985f, -0.339167f, -0.788702f, 0.528378f, -0.314269f, 
		-0.199040f, 0.903641f, -0.379230f, 0.000352785f, 0.917023f, -0.398833f, 
		-0.398292f, -0.172098f, 0.900969f, 0.481586f, 0.773810f, -0.411452f, 
		-0.586351f, 0.219964f, 0.779620f, -0.639501f, 0.331684f, 0.693559f, 
		-0.737853f, 0.521246f, 0.428807f, 0.0214603f, -0.450083f, 0.892729f, 
		-0.107515f, -0.642933f, 0.758339f, 0.572549f, -0.147707f, 0.806455f, 
		0.653227f, -0.00311402f, 0.757155f, 0.197709f, -0.227184f, -0.953571f, 
		0.136254f, 0.984114f, 0.113820f, -0.391717f, 0.117769f, -0.912518f, 
		0.770848f, 0.493366f, -0.402969f, 0.920733f, -0.352561f, 0.167189f, 
		-0.859027f, -0.261468f, 0.440121f, -0.372527f, -0.853789f, 0.363687f, 
		-0.132121f, 0.142606f, 0.980922f, 0.381017f, 0.898408f, 0.218380f, 
		-0.388754f, -0.867786f, -0.309544f, -0.247933f, 0.330071f, -0.910814f, 
		-0.455057f, -0.403302f, 0.793896f, -0.100275f, -0.971914f, 0.212906f, 
		-0.00689215f, -0.517339f, 0.855753f, 0.148162f, 0.986910f, -0.0636849f, 
		-0.297707f, 0.186975f, 0.936168f, 0.403895f, -0.618167f, 0.674343f, 
		0.565102f, -0.531910f, 0.630660f, 0.941810f, -0.180564f, 0.283534f, 
		0.984552f, -0.165662f, 0.0566909f, 0.877089f, 0.294066f, -0.379789f, 
		-0.303808f, 0.457440f, -0.835733f, -0.182460f, 0.586518f, -0.789116f, 
		0.199278f, 0.826781f, -0.526044f, 0.391933f, 0.904421f, -0.168559f, 
		0.0777284f, 0.864298f, -0.496937f, -0.0163002f, 0.775880f, -0.630670f, 
		-0.178622f, 0.664196f, -0.725905f, -0.929144f, 0.274028f, 0.248195f, 
		-0.244177f, 0.0863251f, 0.965881f, 0.754529f, -0.462123f, -0.465971f, 
		0.865253f, -0.0462932f, 0.499193f, 0.732452f, -0.240089f, -0.637080f, 
		0.263830f, 0.846544f, -0.462338f, 0.266853f, 0.750399f, -0.604724f, 
		0.265600f, 0.790305f, -0.552155f, 0.984708f, 0.0132858f, -0.173704f, 
		0.492475f, 0.826637f, -0.272285f, 0.277528f, 0.949517f, -0.146271f, 
		-0.319955f, 0.947405f, 0.00719475f, -0.474860f, 0.879737f, 0.0238872f, 
		0.796366f, -0.509015f, 0.326656f, 0.949178f, -0.305330f, 0.0763898f, 
		-0.909448f, -0.113198f, 0.400114f, 0.495505f, 0.767568f, 0.406589f, 
		-0.615939f, 0.226181f, -0.754627f, -0.666135f, 0.337257f, -0.665223f, 
		-0.754542f, 0.524991f, -0.393764f, -0.0196475f, 0.417373f, -0.908523f, 
		-0.00144206f, 0.638357f, -0.769739f, 0.103448f, 0.0419442f, -0.993750f, 
		0.193195f, -0.145693f, -0.970283f, 0.153804f, 0.986926f, 0.0481763f, 
		-0.00195351f, 0.590745f, -0.806856f, 0.867322f, 0.311623f, -0.388127f, 
		-0.483875f, -0.254034f, -0.837456f, -0.653821f, 0.0939430f, -0.750795f, 
		-0.601696f, -0.0768128f, -0.795023f, 0.701904f, 0.410514f, 0.582073f, 
		-0.902511f, -0.368515f, 0.222869f, 0.260268f, -0.952745f, 0.156647f, 
		0.0622463f, -0.986437f, 0.151878f, -0.166924f, -0.977245f, 0.130878f, 
		0.546516f, -0.501059f, -0.671015f, 0.487804f, 0.734337f, -0.472013f, 
		0.982651f, 0.180539f, 0.0424677f, 0.487804f, 0.734337f, -0.472013f, 
		-0.493453f, -0.855381f, 0.157570f, -0.370965f, -0.911743f, 0.176381f, 
		-0.428398f, -0.889923f, 0.156560f, -0.102948f, -0.665557f, 0.739213f, 
		-0.542450f, -0.726576f, 0.421706f, -0.325826f, -0.710704f, 0.623488f, 
		-0.429318f, -0.743950f, 0.512078f, 0.0188782f, -0.546375f, 0.837328f, 
		0.567098f, -0.786825f, -0.243530f, 0.678567f, 0.696332f, -0.233814f, 
		0.962951f, -0.173643f, -0.206333f, -0.121621f, -0.981218f, -0.149733f, 
		0.994801f, 0.0537872f, 0.0864761f, 0.947359f, -0.287650f, -0.140599f, 
		0.971691f, -0.221711f, 0.0816078f, -0.937557f, -0.0414102f, 0.345358f, 
		-0.876108f, -0.327767f, 0.353558f, -0.735921f, -0.560271f, 0.380154f, 
		-0.222606f, 0.117667f, 0.967781f, 0.643827f, 0.578665f, -0.500633f, 
		0.804533f, 0.572818f, -0.156865f, 0.578070f, 0.659802f, -0.480100f, 
		0.615209f, 0.699267f, -0.364065f, 0.742855f, 0.658996f, -0.117857f, 
		0.680313f, 0.698935f, -0.220600f, 0.749634f, -0.488663f, -0.446382f, 
		0.0452729f, 0.953379f, -0.298359f, 0.887263f, 0.347881f, -0.302893f, 
		0.927744f, -0.359441f, -0.100471f, -0.0336787f, -0.364282f, -0.930680f, 
		0.788291f, 0.0716878f, 0.611112f, 0.856629f, -0.495561f, -0.143546f, 
		0.855279f, -0.514105f, -0.0647641f, 0.860056f, -0.509949f, 0.0159963f, 
		-0.0984914f, -0.407033f, 0.908088f, -0.222698f, -0.400936f, 0.888626f, 
		-0.0309438f, -0.228633f, 0.973021f, -0.322084f, -0.181414f, 0.929167f, 
		0.945637f, 0.314341f, 0.0834330f, 0.115096f, 0.860510f, -0.496262f, 
		-0.0834897f, 0.860613f, -0.502370f, 0.807156f, -0.221702f, 0.547126f, 
		0.603394f, 0.704715f, -0.373218f, 0.812615f, 0.518140f, -0.266809f, 
		-0.135191f, -0.399149f, -0.906864f, -0.259798f, -0.392946f, -0.882099f, 
		-0.0688563f, -0.220509f, -0.972952f, -0.360860f, -0.172119f, -0.916600f, 
		0.986891f, -0.126257f, 0.100526f, 0.966442f, -0.109757f, 0.232259f, 
		0.974536f, -0.134671f, 0.179288f, 0.855982f, -0.337899f, -0.391303f, 
		0.660797f, -0.206103f, -0.721713f, 0.547356f, -0.165379f, 0.820397f, 
		0.803460f, -0.556660f, -0.211142f, -0.208754f, -0.587450f, 0.781873f, 
		0.887805f, -0.235006f, 0.395696f, 0.963364f, -0.266254f, -0.0322122f, 
		0.891808f, -0.451567f, 0.0276887f, 0.782596f, -0.616133f, 0.0890127f, 
		0.550170f, 0.671095f, -0.496934f, 0.963364f, -0.266254f, -0.0322122f, 
		0.802938f, 0.556664f, -0.213108f, 0.952233f, 0.304286f, 0.0257323f, 
		-0.0374866f, -0.614175f, 0.788279f, -0.0887821f, -0.775614f, 0.624932f, 
		-0.147969f, -0.831969f, 0.534727f, -0.0887821f, -0.775614f, 0.624932f, 
		0.969741f, -0.237179f, 0.0578695f, -0.512873f, 0.279249f, -0.811777f, 
		0.792311f, 0.0114859f, -0.610010f, 0.0157224f, 0.958032f, -0.286229f, 
		-0.185261f, 0.0867957f, 0.978849f, 0.996317f, -0.0687784f, -0.0511995f, 
		0.411920f, -0.444734f, -0.795320f, 0.309118f, -0.396628f, -0.864368f, 
		0.409982f, -0.353407f, -0.840844f, 0.394317f, -0.262563f, -0.880667f, 
		0.454522f, -0.297988f, -0.839412f, -0.374481f, -0.879159f, -0.294691f, 
		-0.293861f, 0.153404f, -0.943458f, 0.980841f, 0.0614756f, -0.184854f, 
		0.892383f, 0.374906f, -0.251191f, 0.960294f, 0.168965f, -0.222004f, 
		-0.199283f, -0.904639f, 0.376715f, -0.0964226f, 0.321203f, 0.942089f, 
		-0.571811f, -0.0651741f, -0.817792f, -0.0697206f, -0.603047f, -0.794653f, 
		-0.115510f, -0.767950f, -0.630008f, -0.172171f, -0.825480f, -0.537531f, 
		-0.115510f, -0.767950f, -0.630008f, 0.795584f, 0.0235583f, -0.605384f, 
		0.0298687f, 0.956559f, 0.290003f, -0.224038f, 0.0926417f, -0.970167f, 
		-0.272195f, 0.943074f, 0.191107f, 0.738344f, 0.664494f, -0.115309f, 
		0.832649f, -0.397224f, -0.385886f, -0.917781f, -0.335380f, 0.212599f, 
		0.979262f, 0.197659f, 0.0444521f, 0.554485f, 0.727636f, -0.403847f, 
		0.983322f, 0.0179792f, 0.180982f, 0.850062f, 0.473509f, -0.230618f, 
		0.979262f, 0.197659f, 0.0444521f, 0.338991f, -0.431625f, 0.835934f, 
		0.340216f, -0.257684f, 0.904351f, 0.352133f, -0.352239f, 0.867139f, 
		0.836050f, -0.323267f, 0.443305f, 0.126193f, 0.984827f, -0.119126f, 
		-0.353635f, 0.118313f, 0.927871f, -0.615510f, -0.200589f, 0.762176f, 
		-0.622976f, -0.311075f, 0.717728f, -0.612552f, -0.511154f, 0.602911f, 
		-0.622976f, -0.311075f, 0.717728f, -0.217005f, -0.900953f, -0.375755f, 
		-0.132480f, 0.323631f, -0.936863f, 0.550170f, 0.671095f, -0.496934f, 
		0.999308f, -0.0309284f, 0.0206853f, -0.369588f, -0.870748f, 0.324349f, 
		-0.212549f, 0.330691f, 0.919493f, 0.252390f, 0.827113f, -0.502178f, 
		0.252390f, 0.827113f, -0.502178f, -0.133831f, 0.878066f, -0.459446f, 
		-0.509228f, 0.762561f, -0.398984f, 0.317135f, 0.883727f, 0.344169f, 
		-0.00285145f, 0.373866f, 0.927478f, 0.842154f, -0.538987f, 0.0164236f, 
		-0.513612f, 0.575382f, -0.636505f, -0.513612f, 0.575382f, -0.636505f, 
		0.392310f, -0.919667f, 0.0174983f, 0.208356f, -0.971560f, 0.112508f, 
		0.676276f, -0.736269f, -0.0236465f, 0.585281f, 0.729883f, 0.353153f, 
		0.552738f, 0.727894f, 0.405771f, 0.537807f, 0.695447f, 0.476567f, 
		0.898853f, 0.434136f, 0.0599024f, -0.581481f, -0.521315f, 0.624588f, 
		-0.595845f, -0.421940f, 0.683327f, -0.538173f, -0.683999f, 0.492459f, 
		0.876508f, -0.481212f, -0.0129875f, 0.935993f, -0.342437f, -0.0815689f, 
		0.961561f, -0.130927f, -0.241367f, 0.931554f, -0.306385f, -0.195795f, 
		0.316741f, -0.789317f, 0.525978f, -0.898659f, -0.206057f, 0.387236f, 
		0.198098f, -0.934412f, -0.296025f, -0.333483f, -0.936745f, -0.106294f, 
		0.340744f, -0.513255f, -0.787695f, -0.835654f, -0.479535f, -0.267822f, 
		-0.836838f, -0.342092f, -0.427405f, -0.673336f, 0.139424f, -0.726071f, 
		-0.564454f, 0.227928f, -0.793373f, -0.200983f, -0.599143f, 0.775005f, 
		0.856105f, -0.433261f, 0.281726f, 0.692100f, 0.719194f, -0.0612939f, 
		0.279535f, 0.852010f, 0.442649f, 0.494856f, 0.777783f, 0.387520f, 
		0.380366f, 0.851079f, 0.361920f, 0.741391f, 0.637200f, 0.210513f, 
		0.885583f, 0.435070f, 0.162658f, 0.885583f, 0.435070f, 0.162658f, 
		0.808377f, 0.553346f, 0.200833f, -0.365718f, -0.906916f, 0.209175f, 
		-0.581253f, -0.128200f, 0.803561f, 0.601125f, -0.725430f, -0.335263f, 
		0.652382f, 0.744654f, -0.141022f, 0.870568f, 0.491982f, -0.00811300f, 
		-0.112330f, -0.981438f, 0.155440f, 0.752500f, -0.281909f, -0.595207f, 
		0.294787f, 0.836982f, -0.461044f, 0.183152f, 0.871326f, 0.455243f, 
		0.902153f, -0.169218f, -0.396844f, 0.734221f, -0.170215f, 0.657226f, 
		0.865673f, -0.411902f, -0.284513f, -0.558646f, -0.401595f, 0.725697f, 
		-0.492440f, -0.652932f, 0.575485f, -0.541909f, 0.0638237f, 0.838010f, 
		-0.562356f, -0.0765890f, 0.823341f, 0.913812f, -0.0472234f, 0.403382f, 
		0.886990f, -0.136085f, 0.441282f, 0.892468f, -0.439805f, -0.100360f, 
		-0.151099f, -0.0624266f, -0.986546f, 0.0626905f, 0.968788f, -0.239831f, 
		-0.171232f, 0.196688f, 0.965398f, 0.0261440f, -0.995088f, -0.0954800f, 
		0.438560f, -0.855878f, -0.274113f, -0.180456f, -0.980635f, 0.0761003f, 
		0.586921f, -0.761051f, -0.276270f, -0.102669f, -0.879265f, 0.465137f, 
		-0.154899f, 0.166294f, 0.973834f, -0.550687f, 0.834085f, 0.0323258f, 
		0.436062f, 0.874400f, -0.212779f, 0.863179f, 0.241897f, -0.443179f, 
		0.0743013f, 0.966747f, 0.244705f, -0.209020f, 0.201856f, -0.956851f, 
		0.727159f, 0.0104791f, -0.686389f, 0.846287f, -0.0214092f, -0.532297f, 
		0.784658f, 0.00331126f, -0.619920f, 0.885578f, 0.428307f, 0.179738f, 
		-0.895826f, -0.431303f, -0.107111f, -0.749697f, -0.326242f, 0.575778f, 
		0.160808f, 0.481185f, 0.861744f, 0.0882537f, 0.678687f, 0.729106f, 
		-0.651294f, -0.411748f, 0.637401f, -0.592949f, -0.575014f, 0.563711f, 
		0.324324f, 0.263467f, 0.908515f, 0.266555f, -0.795871f, 0.543634f, 
		0.656072f, -0.702265f, -0.276393f, 0.864450f, -0.422804f, -0.271961f, 
		0.920660f, -0.305508f, -0.243002f, -0.124035f, -0.876323f, -0.465482f, 
		-0.192845f, 0.170797f, -0.966250f, -0.737043f, -0.647385f, 0.194062f, 
		-0.858369f, -0.510117f, -0.0546125f, -0.844198f, -0.534377f, 0.0420925f, 
		-0.679740f, -0.638510f, 0.360913f, -0.904171f, -0.413020f, -0.109038f, 
		-0.358764f, -0.881081f, 0.308196f, -0.255480f, 0.153326f, 0.954579f, 
		0.898836f, -0.438193f, 0.00899179f, 0.872722f, -0.486037f, -0.0460909f, 
		0.896694f, 0.0915199f, 0.433086f, 0.212419f, 0.837443f, -0.503555f, 
		-0.286834f, 0.724030f, -0.627301f, -0.682401f, 0.347089f, -0.643318f, 
		0.222018f, -0.00659490f, -0.975020f, -0.566240f, 0.474652f, -0.673853f, 
		0.915694f, 0.250039f, 0.314620f, 0.156993f, 0.924851f, -0.346417f, 
		0.897915f, 0.0776706f, -0.433263f, 0.785100f, 0.600985f, -0.149783f, 
		0.917348f, 0.374917f, -0.133832f, 0.865677f, 0.470994f, -0.169611f, 
		0.910878f, 0.0164859f, 0.412347f, 0.904592f, -0.0180943f, 0.425893f, 
		0.650309f, -0.0444141f, 0.758370f, -0.321704f, -0.0403141f, 0.945982f, 
		-0.321704f, -0.0403141f, 0.945982f, 0.739728f, -0.657276f, 0.144190f, 
		-0.530929f, -0.615578f, 0.582389f, -0.277994f, 0.130093f, -0.951733f, 
		0.131086f, 0.633680f, 0.762408f, -0.538266f, -0.00123769f, 0.842774f, 
		-0.696316f, -0.275481f, -0.662762f, 0.441551f, 0.703871f, -0.556416f, 
		0.221404f, 0.843600f, -0.489202f, 0.302727f, 0.798511f, -0.520324f, 
		0.538879f, 0.830709f, 0.139758f, 0.675518f, 0.701834f, 0.226063f, 
		0.619742f, 0.758338f, 0.202096f, 0.861114f, -0.217076f, 0.459740f, 
		0.862850f, 0.476988f, 0.167247f, 0.767145f, 0.586120f, 0.260676f, 
		0.628981f, 0.630975f, 0.454150f, 0.524692f, 0.634051f, 0.568046f, 
		0.707228f, 0.604894f, 0.365967f, -0.346341f, -0.00143467f, 0.938107f, 
		-0.107440f, 0.273925f, 0.955731f, 0.953353f, 0.181820f, -0.240955f, 
		0.933591f, -0.350971f, 0.0722941f, 0.965440f, -0.0428558f, -0.257079f, 
		0.666286f, -0.740464f, -0.0881805f, 0.936257f, 0.234195f, -0.261867f, 
		0.936257f, 0.234195f, -0.261867f, -0.932606f, -0.353815f, 0.0711446f, 
		0.134960f, -0.780874f, -0.609936f, 0.680381f, -0.732858f, 0.000705163f, 
		0.517087f, 0.801468f, -0.300449f, 0.943230f, -0.305494f, -0.130350f, 
		0.931794f, 0.311964f, -0.185575f, 0.927794f, 0.0362763f, -0.371326f, 
		-0.149407f, 0.790622f, 0.593796f, -0.368416f, 0.0167172f, 0.929511f, 
		0.0299584f, -0.924155f, 0.380842f, 0.929983f, -0.342205f, 0.134265f, 
		0.902758f, -0.194204f, -0.383815f, 0.796441f, -0.482874f, -0.364025f, 
		-0.165635f, -0.113855f, -0.979593f, -0.472991f, -0.0984708f, -0.875547f, 
		-0.382326f, -0.0876796f, -0.919858f, 0.900938f, -0.0678791f, 0.428606f, 
		0.855720f, -0.315150f, 0.410394f, -0.677404f, 0.691359f, -0.251290f, 
		0.517704f, 0.794676f, -0.316974f, -0.144735f, 0.275921f, -0.950221f, 
		-0.116721f, -0.470469f, 0.874663f, -0.160181f, -0.402886f, 0.901124f, 
		-0.237899f, -0.213231f, 0.947595f, -0.337470f, 0.0214232f, 0.941093f, 
		0.119183f, 0.647386f, -0.752786f, 0.119183f, 0.647386f, -0.752786f, 
		-0.264391f, -0.0311892f, 0.963911f, 0.440964f, 0.880975f, -0.171562f, 
		0.372118f, 0.895215f, -0.245190f, 0.452565f, 0.889590f, -0.0617556f, 
		-0.463476f, -0.245267f, -0.851489f, -0.463476f, -0.245267f, -0.851489f, 
		0.534052f, -0.309735f, -0.786671f, -0.106464f, 0.142064f, 0.984115f, 
		0.0155725f, -0.921251f, -0.388657f, -0.229386f, 0.0980055f, 0.968389f, 
		0.260346f, -0.943884f, 0.203230f, -0.351233f, -0.0570353f, 0.934549f, 
		0.936940f, -0.324095f, -0.130790f, 0.855281f, -0.459848f, -0.238819f, 
		0.578887f, -0.812682f, 0.0666081f, 0.743342f, -0.666352f, -0.0584650f, 
		0.798649f, -0.576884f, -0.171359f, -0.392896f, -0.422292f, -0.816885f, 
		-0.633712f, -0.118674f, -0.764412f, 0.282826f, -0.739327f, -0.611069f, 
		0.442026f, -0.748295f, -0.494638f, -0.633712f, -0.118674f, -0.764412f, 
		-0.683845f, -0.0160062f, -0.729452f, 0.442026f, -0.748295f, -0.494638f, 
		0.108969f, -0.154369f, -0.981986f, 0.0861907f, -0.0341070f, -0.995695f, 
		0.115583f, -0.291241f, -0.949642f, 0.236635f, -0.0908910f, -0.967338f, 
		0.569149f, 0.182217f, -0.801790f, 0.985437f, -0.150981f, 0.0782173f, 
		0.331852f, 0.660433f, -0.673575f, 0.562588f, -0.161172f, -0.810875f, 
		0.974954f, -0.0571294f, 0.214944f, -0.119239f, 0.760901f, -0.637818f, 
		0.998696f, 0.0395164f, 0.0323287f, 0.0407563f, -0.0328787f, -0.998628f, 
		0.998696f, 0.0395164f, 0.0323287f, -0.00543944f, -0.999977f, -0.00397568f, 
		-0.561336f, -0.367433f, -0.741549f, 0.156316f, 0.986456f, 0.0496916f, 
		-0.897125f, 0.441532f, -0.0147108f, -0.375599f, 0.378719f, -0.845871f, 
		-0.375599f, 0.378719f, -0.845871f, -0.681958f, 0.150899f, 0.715656f, 
		0.153804f, 0.986926f, 0.0481763f, -0.881240f, 0.472156f, 0.0220287f, 
		0.358684f, 0.484764f, 0.797715f, -0.213796f, 0.0957703f, 0.972172f, 
		-0.401160f, -0.784056f, 0.473632f, -0.374196f, 0.0282981f, -0.926918f, 
		0.149840f, 0.636469f, 0.756607f, 0.149840f, 0.636469f, 0.756607f, 
		0.975851f, -0.0522734f, 0.212089f, 0.111133f, 0.702600f, -0.702853f, 
		0.111133f, 0.702600f, -0.702853f, 0.887220f, 0.175126f, -0.426816f, 
		0.223375f, 0.803091f, 0.552403f, 0.760315f, -0.0177685f, 0.649312f, 
		-0.163454f, 0.188283f, -0.968417f, 0.0356795f, 0.377397f, -0.925364f, 
		0.814681f, 0.164055f, -0.556221f, 0.411425f, 0.906681f, -0.0930499f, 
		0.968175f, 0.0317860f, 0.248246f, 0.435242f, 0.736562f, 0.517726f, 
		0.366661f, 0.701738f, 0.610839f, 0.514985f, 0.712333f, 0.476835f, 
		0.500968f, 0.743498f, 0.442991f, 0.327812f, 0.789184f, 0.519354f, 
		0.972761f, 0.214303f, 0.0883747f, -0.267143f, -0.0604755f, -0.961757f, 
		0.563208f, 0.775298f, -0.285848f, 0.954563f, -0.295627f, 0.0375965f, 
		0.288169f, 0.0662555f, 0.955285f, 0.173472f, -0.0840943f, 0.981242f, 
		0.167987f, -0.314429f, 0.934299f, 0.266472f, -0.0488214f, 0.962605f, 
		0.352283f, 0.175803f, 0.919233f, 0.100906f, 0.643987f, -0.758352f, 
		-0.241915f, 0.126562f, 0.962008f, 0.157471f, -0.874818f, -0.458145f, 
		0.945814f, -0.119846f, -0.301783f, 0.227340f, 0.851902f, -0.471783f, 
		-0.300058f, -0.0702294f, 0.951332f, -0.300058f, -0.0702294f, 0.951332f, 
		-0.443787f, -0.450779f, -0.774501f, -0.443787f, -0.450779f, -0.774501f, 
		0.501255f, 0.825489f, -0.259447f, 0.997726f, -0.0662945f, 0.0121757f, 
		0.996698f, 0.0807238f, -0.00875362f, 0.555731f, -0.831088f, -0.0213582f, 
		0.224208f, 0.958675f, -0.175137f, 0.912530f, -0.405678f, 0.0520989f, 
		0.770928f, -0.636252f, 0.0292054f, 0.300605f, 0.870483f, -0.389739f, 
		0.991968f, -0.124674f, -0.0213609f, -0.00890550f, -0.312812f, -0.949773f, 
		0.963343f, -0.223811f, 0.147915f, 0.987214f, -0.157256f, -0.0260545f, 
		0.941550f, 0.320736f, -0.103013f, 0.962537f, 0.222288f, -0.155274f, 
		0.955654f, 0.265099f, -0.128250f, -0.222659f, 0.244621f, -0.943707f, 
		0.992421f, -0.0150842f, -0.121953f, -0.286255f, -0.930706f, 0.227694f, 
		0.653167f, -0.755890f, 0.0447510f, -0.518202f, -0.627773f, 0.580833f, 
		-0.430631f, 0.0626437f, 0.900351f, 0.963389f, -0.229324f, 0.138900f, 
		0.952023f, -0.286200f, 0.108356f, 0.942978f, -0.330325f, 0.0409596f, 
		0.337698f, 0.898872f, -0.279267f, 0.337088f, 0.923202f, -0.184581f, 
		0.370867f, 0.920623f, -0.122113f, 0.661693f, -0.722722f, -0.199586f, 
		-0.747261f, -0.640299f, 0.177815f, -0.150930f, -0.0482509f, -0.987366f, 
		0.944290f, -0.150849f, -0.292510f, 0.923747f, -0.172417f, 0.342001f, 
		0.447467f, -0.748153f, -0.489940f, 0.913636f, 0.216618f, 0.344013f, 
		0.961946f, 0.123399f, 0.243788f, 0.683371f, 0.380164f, 0.623281f, 
		0.882233f, -0.432256f, -0.186599f, -0.377354f, -0.503903f, -0.776972f, 
		-0.416793f, -0.275647f, -0.866200f, -0.407509f, -0.196800f, -0.891743f, 
		-0.417246f, -0.356203f, -0.836077f, -0.416793f, -0.275647f, -0.866200f, 
		-0.244414f, 0.163112f, -0.955854f, -0.317721f, -0.748384f, -0.582216f, 
		-0.317721f, -0.748384f, -0.582216f, -0.151276f, 0.0218036f, -0.988251f, 
		-0.417491f, -0.839760f, -0.347136f, -0.424875f, -0.674940f, 0.603272f, 
		0.977427f, 0.211272f, -0.000276388f, 0.730811f, -0.581963f, -0.356699f, 
		0.887603f, -0.341664f, -0.308913f, 0.920487f, -0.255713f, -0.295490f, 
		0.993407f, -0.00415765f, -0.114569f, 0.977427f, 0.211272f, -0.000276388f, 
		0.992001f, 0.100398f, -0.0765162f, 0.850802f, 0.353334f, -0.388962f, 
		0.944712f, 0.0399415f, 0.325461f, 0.970099f, -0.241729f, -0.0217949f, 
		0.980458f, -0.0684394f, 0.184439f, -0.294034f, 0.0859530f, 0.951922f, 
		-0.0615570f, 0.0403050f, 0.997289f, -0.161497f, 0.0623642f, 0.984901f, 
		-0.202514f, 0.124981f, 0.971271f, -0.0864023f, 0.0866522f, 0.992485f, 
		-0.980606f, -0.0340788f, -0.193004f, -0.543514f, 0.243571f, -0.803285f, 
		-0.980606f, -0.0340788f, -0.193004f, 0.350533f, 0.191759f, 0.916709f, 
		0.435648f, 0.171745f, 0.883580f, 0.705444f, 0.0536725f, 0.706730f, 
		-0.569226f, -0.371498f, -0.733465f, -0.878954f, -0.433179f, -0.199489f, 
		-0.833840f, -0.359587f, -0.418817f, -0.0621124f, -0.435075f, -0.898249f, 
		0.130270f, -0.493106f, -0.860161f, 0.828179f, -0.488524f, -0.274708f, 
		0.868821f, 0.189295f, 0.457512f, 0.909925f, -0.316719f, -0.267818f, 
		0.858335f, 0.458731f, -0.229840f, 0.564970f, 0.768591f, -0.300128f, 
		0.740842f, 0.631128f, -0.229848f, 0.355709f, -0.898780f, 0.256252f, 
		0.0940948f, -0.941659f, 0.323148f, 0.185226f, -0.946753f, 0.263343f, 
		-0.279233f, 0.113451f, -0.953498f, -0.102892f, 0.0460547f, -0.993626f, 
		-0.241021f, 0.129869f, -0.961792f, -0.201342f, 0.0682662f, -0.977139f, 
		-0.126986f, 0.0919386f, -0.987634f, 0.884026f, -0.235035f, -0.404050f, 
		-0.351426f, 0.118813f, 0.928646f, 0.417024f, 0.873282f, 0.251931f, 
		0.391384f, 0.916704f, 0.0804569f, 0.355201f, 0.769607f, 0.530600f, 
		0.390027f, 0.905253f, 0.168510f, 0.363219f, 0.930765f, -0.0418097f, 
		0.714925f, 0.340556f, 0.610659f, 0.389316f, 0.679124f, 0.622273f, 
		0.578619f, 0.521687f, 0.626931f, -0.977603f, -0.206965f, -0.0381866f, 
		0.0175540f, 0.533231f, -0.845787f, 0.158821f, 0.737843f, -0.656021f, 
		0.369248f, 0.896547f, -0.244662f, 0.314430f, 0.854003f, -0.414502f, 
		-0.185935f, 0.243753f, 0.951847f, 0.338056f, 0.780229f, 0.526271f, 
		0.568685f, -0.485002f, -0.664358f, -0.420199f, -0.0666675f, -0.904980f, 
		-0.233584f, 0.125241f, 0.964237f, -0.447864f, -0.740200f, -0.501518f, 
		0.927797f, -0.142328f, 0.344871f, 0.876618f, -0.0229794f, 0.480637f, 
		0.899822f, -0.104628f, 0.423526f, 0.894772f, -0.304284f, 0.326793f, 
		0.939185f, -0.239498f, 0.246113f, 0.599912f, -0.727942f, 0.331972f, 
		0.895229f, -0.248739f, 0.369721f, 0.237753f, -0.876442f, 0.418717f, 
		0.795076f, -0.606323f, -0.0150458f, 0.865255f, 0.456662f, 0.206869f, 
		0.815859f, -0.499782f, -0.290848f, 0.901119f, -0.382913f, -0.203377f, 
		0.676502f, -0.610486f, -0.411887f, -0.648343f, -0.759167f, -0.0575982f, 
		-0.726588f, -0.228033f, 0.648129f, -0.897125f, 0.441532f, -0.0147108f, 
		-0.970542f, 0.222600f, -0.0921765f, -0.726588f, -0.228033f, 0.648129f, 
		-0.985284f, 0.0821451f, -0.149891f, 0.381020f, 0.903616f, -0.195709f, 
		0.989189f, -0.0198200f, 0.145298f, 0.926129f, -0.0330233f, 0.375758f, 
		0.997203f, -0.0261047f, 0.0700342f, 0.992352f, -0.0951289f, -0.0786603f, 
		0.997203f, -0.0261047f, 0.0700342f, 0.974112f, 0.0144623f, 0.225605f, 
		0.973304f, 0.204540f, 0.104125f, 0.959892f, 0.279384f, -0.0235119f, 
		0.967519f, 0.111995f, 0.226636f, 0.656162f, -0.648627f, -0.385661f, 
		0.719843f, -0.648987f, -0.246256f, 0.0472063f, -0.992424f, -0.113426f, 
		-0.0768475f, -0.996262f, 0.0394587f, 0.119492f, -0.991835f, 0.0445475f, 
		0.773854f, -0.525287f, -0.353870f, 0.210118f, -0.578829f, -0.787913f, 
		0.994613f, -0.00399429f, 0.103579f, 0.249873f, 0.732187f, 0.633613f, 
		0.249873f, 0.732187f, 0.633613f, 0.786032f, 0.0551269f, 0.615723f, 
		-0.982409f, 0.156412f, -0.102023f, 0.147095f, -0.988890f, 0.0214503f, 
		0.778681f, -0.101258f, 0.619196f, 0.772056f, -0.0120813f, 0.635439f, 
		0.760953f, 0.0580568f, 0.646204f, 0.772056f, -0.0120813f, 0.635439f, 
		-0.135795f, 0.131411f, -0.981983f, -0.247985f, -0.858021f, -0.449782f, 
		0.357123f, -0.485847f, -0.797757f, 0.421427f, -0.906719f, -0.0161088f, 
		0.376555f, -0.655033f, -0.655086f, 0.452054f, -0.851988f, -0.264127f, 
		-0.968422f, -0.207323f, 0.138480f, 0.239631f, -0.889124f, 0.389918f, 
		0.819130f, -0.514067f, 0.254481f, -0.0713155f, -0.945196f, 0.318619f, 
		0.687797f, -0.650835f, 0.321479f, -0.292310f, 0.119866f, 0.948782f, 
		0.718612f, 0.238452f, 0.653251f, 0.450105f, 0.713436f, 0.537042f, 
		-0.121692f, 0.0782235f, 0.989481f, 0.909499f, 0.00180883f, -0.415702f, 
		0.933195f, -0.239801f, 0.267663f, -0.851888f, -0.164756f, 0.497133f, 
		0.978002f, -0.165163f, -0.127412f, 0.985791f, -0.0312877f, -0.165036f, 
		0.973698f, 0.148953f, -0.172410f, -0.994564f, -0.0351489f, 0.0980154f, 
		-0.995508f, -0.0902781f, -0.0285133f, -0.997909f, -0.0602527f, 0.0234105f, 
		0.917518f, 0.0796964f, 0.389628f, -0.161950f, 0.0846832f, -0.983159f, 
		-0.979901f, 0.150773f, 0.130622f, 0.145236f, -0.987783f, -0.0564877f, 
		0.931220f, -0.224656f, 0.286983f, 0.447467f, -0.748153f, -0.489940f, 
		-0.606915f, -0.793802f, -0.0391531f, 0.711600f, 0.656770f, -0.249557f, 
		0.423464f, 0.835212f, -0.350856f, 0.536867f, 0.786069f, -0.306381f, 
		0.947876f, -0.168090f, 0.270699f, -0.729445f, -0.124500f, -0.672615f, 
		-0.622199f, -0.114417f, -0.774453f, -0.921071f, -0.166696f, -0.351911f, 
		-0.00504349f, 0.289017f, 0.957311f, 0.0926086f, -0.995346f, 0.0266513f, 
		0.570538f, 0.821098f, -0.0168739f, -0.804154f, 0.219550f, -0.552390f, 
		-0.804154f, 0.219550f, -0.552390f, 0.129845f, -0.988849f, -0.0729301f, 
		-0.0952756f, 0.349310f, -0.932151f, 0.847479f, -0.232018f, 0.477437f, 
		-0.357240f, -0.0137179f, -0.933912f, 0.913804f, 0.403641f, -0.0451249f, 
		0.951062f, -0.304413f, 0.0530536f, 0.813591f, -0.580431f, 0.0341991f, 
		0.887624f, -0.458850f, 0.0397591f, -0.692920f, -0.718071f, 0.0650843f, 
		0.412755f, 0.879350f, 0.237437f, -0.0964144f, 0.127253f, 0.987173f, 
		-0.236379f, 0.166619f, -0.957269f, -0.236379f, 0.166619f, -0.957269f, 
		-0.859578f, -0.121052f, -0.496459f, 0.0295224f, -0.994184f, 0.103568f, 
		-0.853192f, 0.194309f, 0.484053f, 0.878122f, -0.260197f, -0.401496f, 
		0.723867f, -0.689853f, 0.0109686f, 0.471408f, 0.0504444f, 0.880472f, 
		0.723867f, -0.689853f, 0.0109686f, 0.723867f, -0.689853f, 0.0109686f, 
		0.723867f, -0.689853f, 0.0109686f, -0.999632f, -0.00959845f, -0.0253822f, 
		-0.981982f, -0.0691384f, -0.175871f, -0.996000f, -0.0366090f, -0.0815120f, 
		-0.730725f, -0.682663f, 0.00366334f, -0.730725f, -0.682663f, 0.00366334f, 
		-0.149269f, 0.301921f, -0.941574f, 0.652685f, 0.756581f, 0.0398574f, 
		0.499553f, 0.855050f, 0.139052f, 0.567462f, 0.816303f, 0.107874f, 
		0.370437f, 0.591734f, 0.715980f, 0.471191f, 0.715948f, 0.515167f, 
		0.370437f, 0.591734f, 0.715980f, 0.469364f, 0.624552f, 0.624206f, 
		0.469364f, 0.624552f, 0.624206f, -0.771937f, -0.0356479f, 0.634699f, 
		0.641828f, 0.419362f, 0.642022f, 0.551867f, 0.640706f, 0.533796f, 
		0.800746f, 0.0417423f, 0.597547f, 0.854101f, -0.142708f, 0.500146f, 
		-0.603289f, -0.184825f, 0.775810f, -0.603289f, -0.184825f, 0.775810f, 
		0.0901557f, -0.994107f, -0.0602008f, 0.576106f, 0.817134f, 0.0198546f, 
		0.131486f, -0.990659f, -0.0361361f, 0.431661f, 0.827032f, 0.360121f, 
		0.431661f, 0.827032f, 0.360121f, 0.805025f, 0.363310f, -0.468978f, 
		0.783050f, 0.458891f, -0.419825f, 0.882066f, 0.363242f, -0.300024f, 
		0.743455f, 0.576952f, -0.338232f, 0.883644f, -0.00206753f, -0.468156f, 
		0.933026f, -0.00240757f, -0.359801f, 0.865542f, 0.113181f, -0.487880f, 
		-0.792790f, 0.204912f, 0.574016f, -0.792790f, 0.204912f, 0.574016f, 
		0.133267f, -0.990216f, 0.0413833f, -0.745937f, 0.0976562f, -0.658818f, 
		-0.788349f, 0.122929f, -0.602822f, -0.693551f, 0.137221f, -0.707219f, 
		-0.745937f, 0.0976562f, -0.658818f, -0.616118f, 0.116786f, -0.778948f, 
		-0.833515f, 0.0968657f, -0.543940f, -0.155485f, 0.490090f, -0.857692f, 
		-0.162977f, 0.985799f, 0.0404913f, 0.512638f, -0.462205f, -0.723580f, 
		0.942554f, -0.281711f, -0.179529f, -0.576248f, -0.803521f, -0.149305f, 
		-0.576248f, -0.803521f, -0.149305f, -0.264106f, 0.115700f, -0.957529f, 
		0.0231176f, -0.990996f, -0.131878f, -0.863151f, 0.206090f, -0.460975f, 
		-0.0160181f, -0.994083f, 0.107438f, 0.539812f, 0.786237f, -0.300722f, 
		0.873071f, -0.297486f, 0.386328f, 0.873071f, -0.297486f, 0.386328f, 
		-0.669593f, -0.328772f, -0.665998f, 0.186168f, -0.716538f, -0.672246f, 
		0.956595f, -0.283886f, 0.0658448f, -0.782485f, 0.00392201f, -0.622657f, 
		0.0886233f, -0.963885f, 0.251140f, -0.149911f, 0.163878f, 0.975023f, 
		-0.803243f, 0.405959f, 0.435887f, 0.944824f, -0.308871f, 0.109118f, 
		0.772507f, 0.249953f, 0.583743f, 0.772507f, 0.249953f, 0.583743f, 
		0.535400f, 0.784231f, -0.313575f, 0.166891f, 0.0171722f, 0.985826f, 
		0.129787f, -0.148303f, 0.980388f, 0.153895f, -0.0609682f, 0.986204f, 
		0.0466302f, 0.339213f, 0.939553f, 0.133306f, -0.991053f, 0.00660852f, 
		0.427270f, 0.832806f, -0.351958f, 0.427270f, 0.832806f, -0.351958f, 
		0.361123f, -0.539817f, 0.760387f, 0.794720f, -0.588453f, -0.148804f, 
		0.794720f, -0.588453f, -0.148804f, 0.0510783f, -0.518718f, -0.853418f, 
		-0.0235091f, -0.990404f, -0.136188f, 0.549805f, 0.778806f, 0.301953f, 
		0.00708108f, 0.133151f, -0.991070f, -0.804380f, 0.0528782f, 0.591757f, 
		-0.730275f, 0.0627776f, 0.680263f, -0.764582f, 0.0248912f, 0.644046f, 
		-0.764582f, 0.0248912f, 0.644046f, -0.795669f, -0.00634774f, 0.605698f, 
		-0.679278f, -0.0235450f, 0.733503f, 0.0870865f, -0.964798f, -0.248157f, 
		-0.171085f, 0.173515f, -0.969857f, -0.811418f, 0.423984f, -0.402292f, 
		0.707871f, 0.683580f, 0.177869f, 0.981339f, -0.161146f, 0.104911f, 
		-0.724209f, -0.688846f, 0.0318048f, -0.724209f, -0.688846f, 0.0318048f, 
		-0.111739f, 0.303505f, 0.946255f, 0.131169f, -0.979731f, -0.151397f, 
		0.153767f, 0.663352f, 0.732338f, 0.0480468f, -0.981412f, 0.185802f, 
		0.290942f, 0.724064f, -0.625367f, 0.290942f, 0.724064f, -0.625367f, 
		0.129831f, -0.970619f, -0.202589f, -0.430131f, 0.182842f, -0.884057f, 
		0.484418f, 0.0876938f, 0.870430f, -0.600694f, -0.104410f, 0.792632f, 
		0.978370f, 0.0236687f, -0.205505f, -0.562011f, -0.807971f, 0.176994f, 
		-0.562011f, -0.807971f, 0.176994f, -0.225686f, 0.113998f, 0.967507f, 
		0.839672f, -0.185269f, 0.510515f, 0.419848f, -0.906995f, 0.0329706f, 
		0.419848f, -0.906995f, 0.0329706f, 0.332711f, -0.941273f, -0.0575214f, 
		0.0785632f, -0.957237f, -0.278433f, -0.00905059f, 0.261976f, 0.965032f, 
		0.380029f, -0.456131f, 0.804688f, -0.548469f, 0.146064f, 0.823315f, 
		-0.565820f, -0.691908f, 0.448455f, 0.0427780f, -0.975470f, -0.215935f, 
		0.312580f, 0.712786f, 0.627878f, 0.312580f, 0.712786f, 0.627878f, 
		0.493231f, 0.869894f, 0.00285446f, 0.451803f, 0.841472f, 0.296309f, 
		0.0346243f, 0.324436f, 0.945274f, 0.997586f, 0.00661281f, 0.0691248f, 
		0.562579f, 0.123273f, 0.817502f, -0.223912f, 0.264178f, 0.938122f, 
		0.690329f, 0.705765f, -0.159190f, 0.142586f, -0.982433f, 0.120395f, 
		0.131471f, 0.673054f, -0.727815f, -0.0770614f, -0.904080f, 0.420357f, 
		-0.476890f, -0.802159f, 0.359328f, -0.247921f, -0.852666f, 0.459887f, 
		0.177847f, 0.454759f, 0.872677f, 0.311903f, -0.683700f, 0.659750f, 
		-0.568610f, -0.646757f, 0.508319f, -0.619401f, -0.0385456f, -0.784128f, 
		0.474658f, 0.126697f, -0.871004f, 0.426768f, 0.0527676f, -0.902820f, 
		-0.442501f, -0.0751713f, -0.893612f, 0.376725f, 0.862358f, -0.338255f, 
		0.146122f, -0.973642f, 0.175125f, -0.415332f, 0.172697f, 0.893126f, 
		0.136854f, 0.597175f, -0.790350f, 0.193286f, 0.651553f, -0.733566f, 
		0.125677f, 0.494838f, -0.859849f, 0.193286f, 0.651553f, -0.733566f, 
		0.242580f, 0.780252f, -0.576508f, 0.201161f, 0.713437f, -0.671224f, 
		-0.142940f, -0.504322f, 0.851603f, -9.27636e-005f, -0.189824f, 0.981818f, 
		0.0207762f, -0.0178920f, 0.999624f, 0.0282640f, 0.150801f, 0.988160f, 
		-0.678246f, 0.157032f, 0.717860f, 0.338500f, 0.194007f, 0.920749f, 
		-0.560450f, 0.164337f, 0.811720f, -0.261670f, 0.0217205f, -0.964913f, 
		-0.0309645f, 0.151090f, -0.988035f, -0.589652f, -0.136758f, 0.795994f, 
		-0.379559f, -0.900702f, 0.211353f, 0.225034f, 0.319412f, 0.920508f, 
		-0.0513077f, -0.0161016f, 0.998553f, -0.238972f, -0.388126f, -0.890085f, 
		-0.0603730f, -0.975461f, -0.211732f, 0.112012f, 0.980603f, 0.160846f, 
		-0.832998f, -0.532644f, 0.149681f, -0.218622f, 0.260353f, -0.940437f, 
		-0.0941252f, -0.0203587f, 0.995352f, -0.467532f, -0.0250460f, -0.883622f, 
		0.453589f, 0.0806044f, -0.887558f, 0.0424291f, 0.206477f, 0.977531f, 
		0.473973f, 0.274113f, -0.836786f, -0.0710880f, 0.173844f, -0.982204f, 
		-0.416012f, 0.132764f, -0.899616f, 0.322104f, 0.242140f, -0.915214f, 
		0.115974f, 0.978092f, 0.172873f, -0.830045f, -0.532613f, 0.165375f, 
		-0.247474f, 0.138151f, -0.958995f, 0.454735f, -0.00973244f, 0.890574f, 
		-0.401273f, -0.159719f, 0.901926f, 0.185181f, 0.219866f, 0.957793f, 
		0.508155f, 0.838894f, 0.195028f, 0.531928f, 0.846223f, 0.0309535f, 
		0.526122f, 0.841847f, 0.120372f, -0.577381f, 0.191292f, -0.793750f, 
		0.00452042f, 0.185566f, -0.982621f, -0.692482f, 0.188766f, -0.696301f, 
		0.315445f, 0.222368f, -0.922522f, 0.0813393f, 0.343265f, -0.935710f, 
		0.120904f, 0.132711f, -0.983753f, 0.287626f, -0.767459f, 0.572955f, 
		-0.0389590f, -0.899736f, 0.434692f, -0.509578f, -0.663756f, 0.547502f, 
		-0.276488f, -0.848341f, 0.451522f, -0.570221f, -0.298170f, 0.765469f, 
		0.188838f, 0.512924f, 0.837407f, 0.229696f, 0.0449110f, 0.972226f, 
		0.410407f, -0.0177240f, 0.911730f, -0.270422f, 0.172786f, 0.947110f, 
		-0.464397f, 0.157411f, 0.871526f, 0.642759f, 0.746900f, -0.170298f, 
		0.223292f, 0.287501f, 0.931388f, -0.0843566f, 0.314125f, 0.945626f, 
		0.0482646f, 0.286663f, 0.956815f, -0.0323720f, 0.121949f, -0.992008f, 
		-0.0383595f, -0.0408972f, 0.998427f, -0.0547283f, 0.166041f, -0.984599f, 
		-0.0547283f, 0.166041f, -0.984599f, 0.238535f, -0.884001f, 0.402048f, 
		-0.163059f, -0.972427f, 0.166726f, -0.163059f, -0.972427f, 0.166726f, 
		-0.0439266f, -0.951874f, 0.303325f, -0.452410f, -0.0965315f, 0.886570f, 
		0.491903f, 0.0497697f, 0.869226f, 0.538307f, 0.818042f, -0.202565f, 
		0.0485942f, 0.178033f, 0.982824f, 0.441906f, 0.794576f, 0.416375f, 
		-0.0724150f, -0.979239f, 0.189335f, 0.495650f, 0.240855f, 0.834458f, 
		0.0472916f, 0.171531f, 0.984043f, -0.410970f, 0.117971f, 0.903984f, 
		0.377223f, 0.218675f, 0.899936f, 0.416154f, 0.808307f, -0.416480f, 
		0.507804f, 0.560936f, 0.653824f, 0.416154f, 0.808307f, -0.416480f, 
		0.0257149f, 0.255081f, -0.966578f, -0.139935f, 0.560911f, 0.815964f, 
		-0.139935f, 0.560911f, 0.815964f, 0.0257149f, 0.255081f, -0.966578f, 
		0.127149f, 0.165378f, 0.978000f, -0.0362157f, 0.155977f, 0.987097f, 
		0.0447176f, 0.166398f, 0.985044f, 0.0447176f, 0.166398f, 0.985044f, 
		0.852247f, -0.237903f, -0.465916f, 0.564152f, 0.535241f, 0.628689f, 
		0.564152f, 0.535241f, 0.628689f, -0.169704f, 0.306328f, -0.936677f, 
		0.129713f, 0.201640f, -0.970833f, 0.233690f, -0.949265f, -0.210440f, 
		0.129713f, 0.201640f, -0.970833f, 0.187575f, -0.960588f, -0.205151f, 
		-0.361131f, 0.542035f, 0.758803f, -0.361131f, 0.542035f, 0.758803f, 
		0.178061f, 0.494373f, -0.850817f, 0.510785f, 0.833107f, -0.212206f, 
		0.228805f, -0.934339f, 0.273236f, -0.276665f, 0.576572f, -0.768779f, 
		-0.276665f, 0.576572f, -0.768779f, 0.0592917f, -0.102166f, -0.992999f, 
		0.213965f, -0.302708f, -0.928755f, -0.246290f, -0.232263f, -0.940954f, 
		-0.0547535f, -0.509692f, -0.858613f, -0.0941989f, -0.337586f, -0.936570f, 
		-0.244346f, -0.396161f, -0.885072f, -0.0681073f, -0.470287f, -0.879881f, 
		-0.0949291f, -0.545894f, -0.832459f, -0.0949291f, -0.545894f, -0.832459f, 
		0.0899673f, -0.388701f, -0.916961f, -0.0681073f, -0.470287f, -0.879881f, 
		-0.217880f, 0.0234605f, 0.975694f, -0.346312f, 0.00875334f, -0.938079f, 
		0.0631112f, -0.119133f, 0.990870f, 0.843975f, -0.219800f, -0.489279f, 
		0.552858f, 0.776086f, 0.303377f, -0.0527209f, 0.111510f, -0.992364f, 
		-0.197793f, -0.387350f, 0.900465f, -0.0494789f, -0.975467f, 0.214512f, 
		0.0992135f, 0.981212f, -0.165471f, -0.834509f, -0.540180f, -0.108632f, 
		-0.176631f, 0.261591f, 0.948879f, 0.183901f, 0.243311f, 0.952355f, 
		-0.238884f, 0.557793f, -0.794859f, -0.238884f, 0.557793f, -0.794859f, 
		0.279147f, -0.922258f, 0.267428f, 0.559787f, 0.325491f, 0.762033f, 
		0.156075f, 0.303541f, 0.939948f, 0.344357f, 0.290502f, 0.892764f, 
		0.648020f, 0.133247f, 0.749877f, 0.648020f, 0.133247f, 0.749877f, 
		0.102442f, 0.978896f, -0.176830f, -0.832333f, -0.540182f, -0.124195f, 
		-0.208296f, 0.137988f, 0.968283f, 0.263664f, 0.191330f, 0.945449f, 
		-0.341082f, 0.164288f, 0.925566f, 0.442971f, 0.182401f, 0.877785f, 
		-0.0936992f, 0.188823f, 0.977531f, -0.00362254f, -0.999978f, 0.00549388f, 
		-0.243106f, -0.332637f, -0.911182f, -0.444212f, -0.511542f, -0.735527f, 
		-0.0875066f, -0.0881017f, -0.992260f, 0.553784f, 0.791200f, 0.259473f, 
		0.166827f, -0.948955f, -0.267682f, -0.176400f, 0.555751f, 0.812418f, 
		-0.176400f, 0.555751f, 0.812418f, -0.316293f, 0.538238f, 0.781190f, 
		-0.316293f, 0.538238f, 0.781190f, 0.144790f, 0.247931f, -0.957897f, 
		0.119679f, 0.0112877f, 0.992748f, 0.0736258f, 0.267484f, -0.960745f, 
		0.150143f, 0.231133f, 0.961267f, 0.173128f, 0.412697f, 0.894264f, 
		0.500522f, 0.766524f, 0.402392f, 0.426403f, 0.690014f, 0.584860f, 
		-0.0147856f, 0.160815f, 0.986874f, -0.0147856f, 0.160815f, 0.986874f, 
		0.486754f, 0.0508480f, 0.872058f, -0.371624f, 0.164942f, 0.913614f, 
		0.0731657f, -0.0549039f, -0.995807f, -0.0127592f, -0.127233f, 0.991791f, 
		-0.240923f, -0.0631395f, 0.968488f, -0.346312f, 0.00875334f, -0.938079f, 
		0.312558f, -0.899496f, -0.305310f, 0.321759f, 0.297499f, -0.898869f, 
		0.539158f, 0.330868f, -0.774490f, 0.135238f, 0.314367f, -0.939619f, 
		0.0935150f, 0.0354991f, -0.994985f, 0.228258f, -0.146949f, 0.962447f, 
		0.0242025f, -0.178463f, 0.983649f, 0.228258f, -0.146949f, 0.962447f, 
		0.353558f, -0.217102f, 0.909870f, -0.376994f, -0.440547f, 0.814736f, 
		-0.432720f, -0.647432f, 0.627364f, 0.0768684f, 0.0191787f, -0.996857f, 
		-0.346312f, 0.00875334f, -0.938079f, 0.0227493f, 0.0824878f, 0.996332f, 
		0.204113f, -0.962001f, 0.181360f, -0.391551f, 0.546675f, -0.740158f, 
		-0.391551f, 0.546675f, -0.740158f, 0.156328f, 0.192599f, 0.968745f, 
		0.248645f, -0.949477f, 0.191491f, 0.156328f, 0.192599f, 0.968745f, 
		0.0649778f, 0.0893547f, -0.993878f, -0.216354f, -0.522975f, -0.824432f, 
		-0.216354f, -0.522975f, -0.824432f, -0.287002f, -0.615146f, -0.734320f, 
		-0.0787959f, -0.360281f, -0.929510f, -0.823650f, -0.510171f, 0.247643f, 
		-0.00282869f, -0.843481f, 0.537151f, 0.0587527f, 0.176631f, 0.982522f, 
		0.0646617f, 0.251303f, 0.965746f, -0.169330f, 0.568515f, -0.805058f, 
		-0.169330f, 0.568515f, -0.805058f, 0.0646617f, 0.251303f, 0.965746f, 
		-0.216058f, -0.232648f, -0.948258f, 0.336518f, -0.250970f, 0.907618f, 
		-0.424585f, -0.549234f, 0.719771f, 0.422205f, 0.0497881f, -0.905132f, 
		0.941543f, 0.180649f, -0.284365f, -0.823476f, -0.506036f, 0.256545f, 
		-0.00283964f, -0.840333f, 0.542063f, 0.101397f, 0.211169f, 0.972176f, 
		0.632370f, 0.168997f, -0.756008f, 0.632370f, 0.168997f, -0.756008f, 
		0.121457f, 0.0962911f, 0.987915f, 0.0152522f, -0.995439f, 0.0941733f, 
		-0.835691f, -0.509057f, -0.206109f, -0.0273325f, -0.841194f, -0.540043f, 
		0.0168932f, 0.176803f, -0.984101f, 0.132616f, -0.234342f, -0.963066f, 
		0.132616f, -0.234342f, -0.963066f, -0.471646f, -0.719280f, -0.510085f, 
		0.0764130f, -0.0127345f, -0.996995f, 0.873041f, -0.231585f, 0.429148f, 
		0.531710f, 0.536631f, -0.655219f, 0.531710f, 0.536631f, -0.655219f, 
		-0.129911f, 0.307741f, 0.942560f, -0.129812f, -0.758900f, -0.638137f, 
		-0.129812f, -0.758900f, -0.638137f, -0.835918f, -0.505391f, -0.214059f, 
		-0.0274410f, -0.839411f, -0.542803f, 0.0639063f, 0.214907f, -0.974541f, 
		-0.0270965f, -0.994791f, -0.0982651f, 0.911236f, -0.387998f, 0.138225f, 
		0.848063f, -0.446683f, 0.285068f, 0.200044f, -0.779468f, 0.593643f, 
		0.463752f, -0.631356f, 0.621550f, 0.911236f, -0.387998f, 0.138225f, 
		0.239954f, -0.385159f, -0.891109f, -0.450969f, -0.633617f, -0.628615f, 
		0.0618544f, 0.00621984f, -0.998066f, 0.866841f, -0.216205f, 0.449268f, 
		0.535760f, 0.777536f, -0.329241f, -0.00405364f, 0.111312f, 0.993777f, 
		-0.119917f, -0.885169f, -0.449550f, 0.0267142f, -0.909661f, 0.414492f, 
		0.143432f, 0.254146f, -0.956471f, -0.0749347f, 0.993809f, -0.0820308f, 
		-0.0749347f, 0.993809f, -0.0820308f, 0.550381f, -0.472299f, -0.688487f, 
		-0.203868f, 0.978484f, -0.0317288f, 0.0145889f, 0.984244f, -0.176212f, 
		0.958315f, 0.212831f, 0.190620f, -0.676881f, 0.0235012f, -0.735718f, 
		0.912093f, -0.331448f, 0.241306f, -0.920080f, 0.104028f, 0.377665f, 
		0.440107f, -0.0227289f, 0.897658f, 0.946196f, 0.161212f, 0.280578f, 
		0.401180f, -0.856390f, -0.325041f, -0.510533f, 0.513575f, 0.689636f, 
		-0.266098f, 0.0641632f, -0.961808f, 0.105944f, -0.196345f, -0.974795f, 
		0.456530f, -0.310651f, -0.833712f, -0.437706f, 0.0608066f, -0.897060f, 
		0.00734497f, -0.910054f, -0.414425f, 0.00825890f, -0.996595f, -0.0820406f, 
		0.255688f, 0.257018f, -0.931968f, 0.760550f, 0.252655f, 0.598104f, 
		0.760550f, 0.252655f, 0.598104f, 0.0711905f, -0.633103f, 0.770787f, 
		0.0711905f, -0.633103f, 0.770787f, 0.911607f, -0.410368f, -0.0238776f, 
		0.911607f, -0.410368f, -0.0238776f, 0.911607f, -0.410368f, -0.0238776f, 
		0.0510783f, -0.518718f, -0.853418f, -0.205253f, 0.269745f, 0.940802f, 
		0.837888f, 0.0115835f, 0.545719f, 0.837888f, 0.0115835f, 0.545719f, 
		0.582414f, 0.757904f, -0.293898f, 0.837888f, 0.0115835f, 0.545719f, 
		0.0384291f, -0.629373f, -0.776153f, 0.0384291f, -0.629373f, -0.776153f, 
		0.259991f, 0.811464f, -0.523384f, 0.259991f, 0.811464f, -0.523384f, 
		0.196394f, 0.233804f, -0.952242f, 0.768768f, 0.318417f, -0.554622f, 
		0.581259f, 0.167846f, -0.796220f, 0.463480f, 0.162480f, -0.871084f, 
		0.725631f, 0.278506f, -0.629201f, 0.689357f, 0.247263f, -0.680918f, 
		0.338852f, -0.928792f, -0.150080f, -0.670998f, 0.566527f, 0.478340f, 
		0.954767f, 0.218969f, -0.201180f, -0.0422103f, 0.193851f, -0.980122f, 
		-0.457592f, 0.510406f, 0.728076f, 0.283374f, 0.359910f, -0.888912f, 
		0.0895266f, -0.201677f, 0.975352f, 0.0809460f, 0.115075f, 0.990053f, 
		0.0822822f, -0.135537f, 0.987350f, 0.739354f, 0.269717f, -0.616935f, 
		0.739354f, 0.269717f, -0.616935f, 0.389272f, -0.630938f, -0.671107f, 
		0.617542f, -0.747198f, -0.245636f, 0.277658f, -0.541024f, -0.793851f, 
		0.840545f, -0.389546f, 0.376482f, 0.818878f, -0.211795f, 0.533462f, 
		0.818878f, -0.211795f, 0.533462f, 0.766751f, 0.180465f, 0.616056f, 
		0.478397f, 0.0667920f, 0.875600f, 0.594328f, 0.0835072f, 0.799876f, 
		0.715362f, 0.145357f, 0.683468f, 0.674091f, 0.116922f, 0.729335f, 
		0.670001f, 0.742331f, 0.00652457f, 0.0483540f, -0.199031f, -0.978799f, 
		0.0394147f, 0.117966f, -0.992235f, 0.0400136f, -0.133169f, -0.990285f, 
		0.117174f, 0.320834f, 0.939860f, 0.655635f, 0.703948f, 0.273130f, 
		-0.721227f, 0.0437537f, -0.691316f, -0.899761f, 0.312783f, 0.304298f, 
		-0.0192546f, -0.995933f, 0.0880150f, 0.625654f, 0.394592f, -0.672945f, 
		0.369594f, -0.921357f, -0.120420f, 0.754225f, -0.287222f, -0.590464f, 
		0.754225f, -0.287222f, -0.590464f, 0.0680669f, 0.502144f, -0.862101f, 
		0.420914f, -0.884924f, 0.199352f, 0.866542f, 0.277055f, 0.415144f, 
		-0.674566f, 0.564501f, -0.475710f, -0.674566f, 0.564501f, -0.475710f, 
		0.866542f, 0.277055f, 0.415144f, 0.635576f, -0.341032f, -0.692633f, 
		0.315107f, -0.00675191f, -0.949032f, 0.172146f, 0.0838871f, -0.981493f, 
		0.172146f, 0.0838871f, -0.981493f, 0.0482568f, 0.232061f, -0.971503f, 
		0.340368f, 0.796493f, 0.499749f, 0.340368f, 0.796493f, 0.499749f, 
		0.668923f, 0.711967f, -0.213646f, 0.347350f, -0.928947f, 0.128087f, 
		-0.692637f, 0.566791f, -0.446096f, 0.0100147f, 0.196889f, -0.980375f, 
		0.964654f, 0.263299f, -0.0108092f, 0.964654f, 0.263299f, -0.0108092f, 
		0.783136f, 0.347585f, 0.515638f, 0.783136f, 0.347585f, 0.515638f, 
		-0.823222f, -0.501853f, 0.265422f, -0.0321485f, 0.945006f, -0.325470f, 
		0.0982119f, 0.201927f, 0.974464f, 0.182819f, 0.580250f, 0.793654f, 
		0.182819f, 0.580250f, 0.793654f, 0.325473f, 0.175288f, -0.929162f, 
		-0.823476f, -0.506036f, 0.256545f, -0.0329979f, 0.943319f, -0.330244f, 
		0.0824832f, 0.121360f, 0.989175f, -0.536515f, 0.538994f, -0.649336f, 
		0.474387f, 0.243215f, 0.846052f, 0.599142f, 0.517603f, -0.610832f, 
		0.986556f, -0.160547f, 0.0305407f, 0.165061f, 0.195056f, 0.966803f, 
		-0.836080f, -0.501686f, -0.221993f, -0.0158562f, 0.943993f, 0.329585f, 
		0.0607295f, 0.206054f, -0.976654f, 0.257267f, 0.243437f, -0.935175f, 
		0.610592f, 0.746587f, -0.264169f, -0.835918f, -0.505391f, -0.214059f, 
		-0.0160499f, 0.943504f, 0.330973f, 0.0392369f, 0.121905f, -0.991766f, 
		0.545223f, -0.727226f, -0.416982f, 0.848768f, 0.275568f, -0.451281f, 
		-0.661991f, 0.555999f, 0.502626f, -0.661991f, 0.555999f, 0.502626f, 
		0.848768f, 0.275568f, -0.451281f, -0.366300f, 0.0667451f, -0.928100f, 
		0.0616936f, 0.214430f, -0.974789f, 0.605797f, -0.529555f, -0.593786f, 
		-0.180667f, 0.112015f, -0.977145f, 0.626387f, 0.535832f, -0.566148f, 
		0.986506f, -0.160404f, 0.0328116f, 0.0295394f, 0.170503f, 0.984914f, 
		-0.493711f, 0.514867f, -0.700829f, 0.324388f, 0.357607f, 0.875722f, 
		0.282398f, 0.0453308f, 0.958226f, 0.650107f, 0.375135f, 0.660784f, 
		0.376667f, -0.921139f, 0.0981052f, 0.918628f, 0.368996f, -0.141293f, 
		0.453088f, -0.891073f, -0.0264559f, -0.798992f, 0.599917f, -0.0413663f, 
		0.918628f, 0.368996f, -0.141293f, 0.627737f, 0.514812f, 0.583879f, 
		0.984040f, -0.160851f, -0.0761008f, 0.119211f, 0.195385f, -0.973454f, 
		-0.515558f, 0.536844f, 0.667832f, 0.435564f, 0.245670f, -0.865985f, 
		0.653612f, 0.533476f, 0.536837f, 0.983849f, -0.160673f, -0.0788997f, 
		-0.0118869f, 0.171460f, -0.985119f, 0.964862f, 0.261936f, 0.0207708f, 
		0.964862f, 0.261936f, 0.0207708f, 0.781198f, -0.281896f, 0.557013f, 
		0.781198f, -0.281896f, 0.557013f, 0.109841f, 0.501815f, 0.857972f, 
		0.667432f, -0.336722f, 0.664194f, 0.356417f, -0.00799844f, 0.934293f, 
		0.214704f, 0.0818130f, 0.973246f, 0.214704f, 0.0818130f, 0.973246f, 
		0.0891546f, 0.229026f, 0.969329f, 0.704412f, -0.519405f, -0.483758f, 
		0.389231f, -0.510950f, -0.766439f, 0.617415f, -0.541451f, -0.570640f, 
		0.724746f, 0.686251f, 0.0616688f, 0.986600f, -0.160689f, 0.0282696f, 
		0.488480f, -0.514480f, 0.704768f, 0.263008f, 0.371757f, 0.890294f, 
		0.928129f, 0.360184f, 0.0940413f, 0.454246f, -0.890874f, 0.00191507f, 
		-0.795953f, 0.599813f, 0.0817461f, 0.928129f, 0.360184f, 0.0940413f, 
		0.724532f, 0.615185f, 0.310806f, 0.986556f, -0.160547f, 0.0305407f, 
		0.321339f, -0.448724f, 0.833899f, 0.382373f, 0.0632356f, 0.921842f, 
		0.348958f, 0.160852f, 0.923231f, 0.984224f, -0.161028f, -0.0733013f, 
		0.452541f, -0.513046f, -0.729376f, 0.220537f, 0.371802f, -0.901735f, 
		0.984040f, -0.160851f, -0.0761008f, 0.383557f, -0.100411f, -0.918042f, 
		0.339819f, 0.0670914f, -0.938095f, 0.307026f, 0.164662f, -0.937348f, 
		-0.672242f, -0.446187f, -0.590769f, 0.0433366f, -0.227879f, -0.972725f, 
		-0.966959f, -0.174070f, 0.186253f, 0.762904f, -0.633201f, -0.130513f, 
		0.930183f, -0.322272f, 0.175782f, 0.669113f, -0.687169f, -0.282996f, 
		0.669113f, -0.687169f, -0.282996f, 0.726442f, 0.661152f, -0.187509f, 
		0.308434f, 0.392365f, -0.866556f, 0.713402f, 0.674812f, -0.188911f, 
		0.355854f, -0.180062f, 0.917031f, 0.879668f, -0.326740f, 0.345580f, 
		-0.920603f, 0.272317f, 0.279881f, 0.276082f, -0.623083f, 0.731810f, 
		0.287591f, -0.279363f, 0.916104f, 0.239741f, 0.213565f, 0.947055f, 
		0.287099f, -0.522484f, 0.802860f, 0.791629f, 0.527217f, 0.308814f, 
		0.253242f, 0.153834f, 0.955094f, 0.834967f, -0.504774f, -0.219165f, 
		0.883012f, -0.437580f, -0.169746f, 0.834967f, -0.504774f, -0.219165f, 
		0.775205f, -0.556029f, -0.299814f, 0.326479f, -0.524367f, 0.786416f, 
		0.739434f, 0.626176f, 0.247267f, 0.403990f, 0.142592f, 0.903582f, 
		0.504392f, -0.407264f, -0.761397f, 0.229279f, 0.322245f, 0.918471f, 
		0.100758f, -0.601592f, -0.792424f, 0.128160f, 0.426582f, 0.895323f, 
		0.229279f, 0.322245f, 0.918471f, 0.273944f, -0.492551f, -0.826044f, 
		0.464320f, 0.280263f, 0.840155f, 0.526973f, 0.823290f, 0.210935f, 
		-0.821669f, 0.569913f, 0.00768461f, -0.0297579f, -0.184386f, -0.982403f, 
		0.385202f, 0.137289f, 0.912563f, 0.552858f, 0.776086f, 0.303377f, 
		0.568214f, 0.653598f, 0.499943f, 0.564152f, 0.535241f, 0.628689f, 
		-0.846809f, 0.482126f, 0.224653f, 0.505078f, 0.302276f, 0.808409f, 
		-0.825555f, 0.367608f, 0.428163f, -0.151361f, 0.321283f, -0.934808f, 
		-0.151361f, 0.321283f, -0.934808f, 0.348049f, 0.0938730f, -0.932765f, 
		0.787262f, 0.537226f, 0.302666f, -0.897644f, -0.152576f, 0.413468f, 
		0.385610f, -0.907212f, -0.168144f, 0.185973f, -0.971924f, -0.144148f, 
		-0.254742f, -0.950745f, -0.176610f, 0.385610f, -0.907212f, -0.168144f, 
		-0.195784f, -0.0736854f, -0.977875f, -0.579658f, 0.538219f, 0.611814f, 
		0.562574f, 0.503052f, -0.656087f, -0.172662f, -0.386287f, -0.906074f, 
		-0.0329718f, -0.983169f, -0.179696f, 0.263105f, 0.250748f, 0.931612f, 
		0.827632f, 0.497690f, 0.259481f, 0.439586f, 0.176446f, 0.880699f, 
		0.164667f, -0.0142378f, -0.986246f, 0.164667f, -0.0142378f, -0.986246f, 
		-0.151401f, -0.726878f, -0.669870f, -0.447939f, -0.803698f, -0.391690f, 
		-0.512973f, -0.845169f, -0.150158f, 0.551977f, -0.833650f, -0.0187003f, 
		0.543170f, -0.797004f, -0.264106f, 0.297511f, -0.746544f, -0.595113f, 
		0.716485f, 0.664042f, 0.213770f, 0.897132f, 0.439054f, 0.0488453f, 
		0.819655f, 0.553255f, 0.148576f, 0.583128f, 0.727970f, 0.360586f, 
		0.636176f, 0.729793f, 0.250364f, 0.932238f, 0.361786f, -0.00651286f, 
		0.843460f, 0.533207f, 0.0653132f, 0.514609f, 0.824071f, -0.236824f, 
		-0.821042f, 0.569898f, 0.0332495f, 0.0186562f, -0.184053f, 0.982739f, 
		0.287333f, 0.0928545f, -0.953319f, 0.0997192f, -0.533908f, -0.839642f, 
		0.101782f, -0.458952f, -0.882612f, 0.107590f, -0.350670f, -0.930298f, 
		0.101782f, -0.458952f, -0.882612f, 0.444660f, 0.148688f, 0.883272f, 
		0.318483f, 0.160010f, -0.934326f, 0.846733f, 0.496627f, -0.190803f, 
		0.218471f, -0.872123f, 0.437803f, -0.608478f, 0.539689f, -0.581800f, 
		0.594149f, 0.502871f, 0.627780f, 0.541833f, 0.654785f, -0.526947f, 
		0.535760f, 0.777536f, -0.329241f, 0.531710f, 0.536631f, -0.655219f, 
		-0.856937f, 0.482136f, -0.182219f, 0.842405f, 0.538835f, -0.00312722f, 
		0.464029f, 0.302029f, -0.832740f, -0.845845f, 0.367640f, -0.386505f, 
		-0.105410f, 0.321626f, 0.940981f, -0.105410f, 0.321626f, 0.940981f, 
		-0.734866f, 0.578621f, -0.353793f, -0.734866f, 0.578621f, -0.353793f, 
		0.594169f, 0.394905f, 0.700724f, 0.594169f, 0.394905f, 0.700724f, 
		0.289630f, 0.115177f, -0.950183f, 0.332837f, -0.0402920f, -0.942123f, 
		0.313131f, 0.0263502f, -0.949344f, 0.840948f, 0.497300f, -0.213304f, 
		0.502727f, 0.629189f, 0.592780f, 0.919455f, 0.384785f, -0.0808918f, 
		0.735873f, 0.624377f, -0.262002f, 0.574661f, 0.742690f, -0.343767f, 
		-0.406339f, 0.865351f, 0.293355f, 0.574661f, 0.742690f, -0.343767f, 
		0.0433366f, -0.227879f, -0.972725f, 0.958084f, 0.284701f, 0.0319281f, 
		0.913671f, 0.375577f, 0.155393f, 0.659462f, 0.596289f, 0.457765f, 
		0.257082f, -0.888892f, -0.379183f, 0.257082f, -0.888892f, -0.379183f, 
		0.958084f, 0.284701f, 0.0319281f, 0.907244f, 0.298333f, 0.296490f, 
		0.278409f, 0.0647606f, 0.958277f, -0.147283f, -0.0731413f, 0.986386f, 
		-0.715727f, 0.577877f, 0.392164f, -0.715727f, 0.577877f, 0.392164f, 
		0.559770f, 0.395906f, -0.727953f, 0.559770f, 0.395906f, -0.727953f, 
		-0.127510f, -0.386258f, 0.913535f, -0.0241626f, -0.983135f, 0.181278f, 
		0.0798076f, -0.794383f, -0.602152f, 0.364352f, 0.315331f, -0.876250f, 
		0.861276f, 0.475000f, -0.180495f, 0.387615f, 0.638601f, 0.664789f, 
		0.552157f, 0.604780f, 0.573902f, 0.833727f, 0.526313f, 0.167015f, 
		0.387615f, 0.638601f, 0.664789f, 0.387615f, 0.638601f, 0.664789f, 
		0.908337f, 0.344729f, 0.236827f, 0.343491f, 0.186020f, 0.920549f, 
		0.611969f, -0.396354f, -0.684396f, 0.611969f, -0.396354f, -0.684396f, 
		0.398149f, 0.701977f, -0.590513f, 0.398149f, 0.701977f, -0.590513f, 
		0.361491f, -0.325248f, 0.873807f, -0.216058f, -0.232648f, -0.948258f, 
		-0.787490f, 0.613513f, 0.0588312f, 0.0122988f, 0.281092f, -0.959602f, 
		-0.0527209f, 0.111510f, -0.992364f, 0.0325503f, 0.493324f, -0.869237f, 
		0.879201f, 0.378731f, 0.289082f, 0.415333f, 0.141526f, -0.898593f, 
		0.466551f, 0.0302098f, -0.883978f, 0.501483f, -0.170925f, -0.848115f, 
		0.879414f, 0.415100f, 0.233072f, 0.227211f, 0.0659978f, -0.971607f, 
		0.155355f, 0.0474038f, -0.986721f, 0.203676f, -0.136663f, -0.969453f, 
		0.321068f, 0.140021f, -0.936648f, 0.931925f, 0.275258f, -0.236113f, 
		0.866791f, 0.467547f, -0.173419f, -0.650940f, 0.230881f, 0.723168f, 
		0.626387f, 0.535832f, -0.566148f, 0.160588f, 0.205883f, 0.965310f, 
		0.712441f, -0.424433f, -0.558824f, 0.653191f, -0.256299f, -0.712498f, 
		0.472742f, 0.246106f, -0.846136f, 0.423207f, 0.438681f, -0.792752f, 
		0.866269f, 0.490453f, 0.0950460f, -0.827398f, 0.543593f, 0.141139f, 
		0.0790429f, 0.568603f, -0.818806f, -0.686143f, 0.230893f, -0.689853f, 
		0.653612f, 0.533476f, 0.536837f, 0.115119f, 0.205533f, -0.971856f, 
		0.398075f, 0.149434f, 0.905100f, 0.934112f, 0.282152f, 0.218689f, 
		0.644675f, -0.395425f, 0.654242f, 0.644675f, -0.395425f, 0.654242f, 
		0.426834f, 0.701742f, 0.570413f, 0.426834f, 0.701742f, 0.570413f, 
		-0.780588f, 0.602261f, 0.167224f, 0.770698f, 0.549578f, 0.322474f, 
		0.666894f, 0.523323f, -0.530457f, 0.262924f, 0.0332224f, 0.964244f, 
		0.938444f, 0.159504f, 0.306400f, 0.913511f, 0.338530f, -0.225598f, 
		-0.643000f, 0.233279f, 0.729474f, -0.395573f, 0.914698f, 0.0827633f, 
		0.291873f, 0.365769f, 0.883755f, -0.789446f, 0.613510f, -0.0195042f, 
		-0.00405364f, 0.111312f, 0.993777f, 0.0590812f, 0.281248f, 0.957815f, 
		0.0746697f, 0.493412f, 0.866584f, -0.694243f, -0.137021f, -0.706578f, 
		-0.927013f, 0.0648067f, 0.369387f, -0.186790f, 0.204037f, 0.960978f, 
		0.651709f, 0.552415f, -0.519725f, -0.151732f, 0.189918f, 0.970004f, 
		0.0224655f, 0.162895f, 0.986388f, 0.502727f, 0.629189f, 0.592780f, 
		0.575074f, -0.677322f, -0.458831f, -0.406339f, 0.865351f, 0.293355f, 
		-0.678575f, 0.233276f, -0.696504f, -0.399192f, 0.914702f, -0.0629749f, 
		0.249289f, 0.365649f, -0.896747f, 0.739124f, -0.424397f, 0.523051f, 
		0.687069f, -0.257008f, 0.679620f, 0.513289f, 0.245155f, 0.822455f, 
		0.461442f, 0.437521f, 0.771781f, -0.232649f, 0.204304f, -0.950860f, 
		-0.275777f, 0.205706f, -0.938953f, 0.677377f, 0.550417f, 0.488060f, 
		-0.120505f, 0.179516f, -0.976346f, -0.197900f, 0.190509f, -0.961531f, 
		-0.0241005f, 0.163560f, -0.986239f, 0.386465f, 0.274342f, -0.880558f, 
		0.927930f, 0.334213f, -0.165070f, -0.787937f, 0.602399f, -0.127558f, 
		0.754232f, 0.549180f, -0.359911f, 0.692317f, 0.523283f, 0.496863f, 
		0.611344f, 0.543673f, 0.575046f, -0.434516f, -0.707182f, -0.557754f, 
		0.905883f, 0.397995f, 0.144832f, 0.785915f, 0.469108f, 0.402835f, 
		-0.434516f, -0.707182f, -0.557754f, -0.833401f, 0.543594f, -0.0997467f, 
		0.119741f, 0.568598f, 0.813854f, 0.936454f, 0.350298f, -0.0185601f, 
		0.764888f, -0.541508f, 0.348879f, 0.764888f, -0.541508f, 0.348879f, 
		0.497972f, 0.606841f, 0.619490f, 0.497972f, 0.606841f, 0.619490f, 
		0.341231f, 0.125869f, -0.931514f, 0.942993f, 0.181310f, -0.279090f, 
		0.257051f, 0.0117554f, 0.966326f, 0.939328f, 0.146652f, 0.310091f, 
		-0.0212552f, -0.167666f, 0.985615f, -0.0276333f, -0.336917f, 0.941129f, 
		-0.0298126f, -0.0730105f, 0.996885f, -0.0740111f, -0.336292f, -0.938845f, 
		-0.0692552f, -0.167149f, -0.983496f, -0.0781996f, -0.0727847f, -0.994277f, 
		0.421782f, 0.122085f, 0.898440f, 0.958902f, 0.192359f, 0.208580f, 
		0.937859f, 0.232533f, -0.257582f, -0.211168f, 0.289858f, 0.933483f, 
		-0.468105f, 0.882487f, 0.0457669f, 0.102695f, 0.435813f, 0.894159f, 
		-0.0921222f, 0.408952f, 0.907894f, 0.746546f, -0.541451f, -0.386652f, 
		0.746546f, -0.541451f, -0.386652f, 0.467200f, 0.606480f, -0.643356f, 
		0.467200f, 0.606480f, -0.643356f, -0.257430f, 0.289856f, -0.921799f, 
		-0.469814f, 0.882482f, -0.0223818f, 0.0580417f, 0.435813f, -0.898164f, 
		-0.137247f, 0.408955f, -0.902175f, 0.640833f, -0.537933f, 0.547688f, 
		0.640833f, -0.537933f, 0.547688f, 0.691387f, 0.497355f, 0.524044f, 
		0.691387f, 0.497355f, 0.524044f, -0.0387292f, -0.650138f, 0.758828f, 
		-0.0387292f, -0.650138f, 0.758828f, -0.0764707f, -0.649869f, -0.756190f, 
		-0.0764707f, -0.649869f, -0.756190f, 0.249038f, -0.00594220f, 0.968475f, 
		0.945458f, 0.150178f, 0.289060f, 0.947707f, 0.319080f, -0.00627957f, 
		0.322929f, 0.159993f, -0.932802f, 0.922365f, 0.247862f, -0.296322f, 
		0.946985f, -0.222243f, 0.232009f, -0.906943f, 0.328558f, 0.263637f, 
		0.612709f, -0.537002f, -0.579841f, 0.612709f, -0.537002f, -0.579841f, 
		0.665049f, 0.497674f, -0.556803f, 0.665049f, 0.497674f, -0.556803f, 
		0.397956f, 0.250711f, -0.882483f, 0.959723f, 0.244092f, -0.139106f, 
		0.915853f, 0.396976f, 0.0601907f, -0.373667f, -0.904001f, -0.207737f, 
		0.842199f, -0.480077f, -0.245412f, 0.693575f, 0.704286f, -0.151440f, 
		0.687762f, 0.725936f, 0.000667417f, 0.697396f, 0.674046f, 0.243519f, 
		0.966906f, 0.254444f, 0.0187375f, 0.445439f, 0.119247f, 0.887335f, 
		0.967746f, 0.147729f, 0.204066f, 0.306320f, 0.0842580f, 0.948192f, 
		0.955185f, 0.00441323f, 0.295976f, 0.261426f, -0.0964768f, 0.960390f, 
		0.936309f, 0.196443f, 0.291093f, 0.320414f, -0.377462f, 0.868825f, 
		0.951581f, -0.0214049f, 0.306651f, 0.950545f, 0.271186f, 0.151401f, 
		-0.891607f, 0.0167094f, 0.452501f, 0.272485f, -0.494592f, 0.825306f, 
		0.913636f, 0.155722f, 0.375525f, 0.968580f, 0.151293f, 0.197390f, 
		0.958306f, 0.238418f, 0.157501f, 0.958306f, 0.238418f, 0.157501f, 
		0.347049f, 0.261968f, 0.900516f, 0.953521f, 0.0838406f, 0.289426f, 
		0.405295f, 0.227701f, -0.885374f, 0.975911f, 0.180175f, -0.123023f, 
		0.853381f, -0.480071f, 0.203154f, 0.700265f, 0.704279f, 0.116704f, 
		0.684403f, 0.674037f, -0.277970f, 0.686883f, 0.725928f, -0.0349296f, 
		-0.0254729f, -0.937143f, 0.348015f, 0.356206f, -0.896955f, 0.261896f, 
		0.944409f, 0.131193f, 0.301463f, -0.700081f, 0.714018f, -0.00813247f, 
		0.258065f, 0.662923f, -0.702806f, 0.258065f, 0.662923f, -0.702806f, 
		0.437351f, 0.195373f, 0.877812f, 0.962849f, 0.133495f, 0.234736f, 
		0.859801f, -0.508663f, -0.0447585f, 0.790365f, 0.533857f, 0.300534f, 
		0.666964f, 0.520419f, -0.533219f, -0.0435443f, -0.938173f, -0.343418f, 
		-0.497309f, 0.867024f, 0.0308782f, -0.497309f, 0.867024f, 0.0308782f, 
		0.643035f, 0.637363f, 0.424587f, 0.643035f, 0.637363f, 0.424587f, 
		0.259763f, -0.731144f, 0.630834f, 0.247632f, 0.245852f, 0.937142f, 
		0.287334f, -0.255494f, 0.923126f, 0.282131f, -0.591170f, 0.755593f, 
		0.282131f, -0.591170f, 0.755593f, 0.945341f, -0.0129684f, 0.325826f, 
		0.292260f, -0.233928f, 0.927287f, 0.926431f, 0.203508f, 0.316719f, 
		0.977762f, 0.194069f, -0.0794897f, 0.922839f, 0.0219251f, -0.384561f, 
		0.0640451f, -0.462040f, -0.884544f, 0.0640451f, -0.462040f, -0.884544f, 
		0.945507f, -0.0763407f, -0.316526f, 0.124742f, -0.397066f, -0.909274f, 
		0.402734f, -0.830133f, 0.385596f, 0.868978f, -0.462720f, 0.175408f, 
		0.868978f, -0.462720f, 0.175408f, 0.661581f, -0.670416f, 0.335937f, 
		0.118218f, -0.0163201f, -0.992854f, 0.961747f, 0.0209569f, -0.273137f, 
		0.118218f, -0.0163201f, -0.992854f, 0.248817f, 0.140078f, -0.958367f, 
		0.897025f, 0.333910f, -0.289570f, 0.860979f, -0.508637f, 0.00186271f, 
		0.774407f, 0.533869f, -0.339527f, 0.692515f, 0.520549f, 0.499451f, 
		0.0427775f, 0.650457f, 0.758337f, 0.948660f, -0.295403f, -0.113054f, 
		-0.0299451f, 0.492773f, -0.869643f, 0.0590887f, -0.834136f, -0.548385f, 
		0.802994f, -0.539597f, -0.253053f, -0.498203f, 0.867039f, -0.00608790f, 
		-0.498203f, 0.867039f, -0.00608790f, 0.621097f, 0.637344f, -0.456104f, 
		0.621097f, 0.637344f, -0.456104f, 0.188103f, 0.250668f, -0.949623f, 
		0.980454f, 0.0777957f, -0.180714f, -0.699979f, 0.713524f, 0.0302075f, 
		0.247745f, 0.806600f, -0.536673f, 0.247745f, 0.806600f, -0.536673f, 
		0.948150f, 0.209468f, 0.239027f, -0.698803f, 0.714021f, 0.0429946f, 
		0.292027f, 0.662902f, 0.689406f, 0.292027f, 0.662902f, 0.689406f, 
		-0.108988f, -0.355759f, -0.928201f, -0.0207444f, -0.986556f, -0.162103f, 
		0.985985f, 0.161977f, 0.0399613f, 0.908730f, 0.0606898f, -0.412948f, 
		0.0786954f, -0.546634f, -0.833665f, 0.0786954f, -0.546634f, -0.833665f, 
		-0.127294f, -0.0257471f, -0.991531f, -0.127294f, -0.0257471f, -0.991531f, 
		0.0443369f, 0.646791f, 0.761377f, 0.949328f, -0.291124f, -0.118421f, 
		-0.0865131f, 0.332555f, -0.939107f, -0.0865131f, 0.332555f, -0.939107f, 
		-0.0865131f, 0.332555f, -0.939107f, 0.381567f, 0.187969f, -0.905027f, 
		0.990516f, 0.0894494f, -0.104292f, -0.550768f, 0.834271f, -0.0254314f, 
		0.622004f, 0.748708f, -0.229230f, 0.868654f, -0.390773f, -0.304526f, 
		0.0776067f, -0.738622f, -0.669638f, 0.868654f, -0.390773f, -0.304526f, 
		-0.459186f, -0.244798f, -0.853945f, -0.671224f, -0.228431f, -0.705179f, 
		-0.315379f, -0.120896f, -0.941233f, 0.995258f, -0.0308467f, 0.0922502f, 
		-0.513572f, 0.857418f, 0.0328404f, -0.513572f, 0.857418f, 0.0328404f, 
		0.314618f, -0.155299f, 0.936428f, 0.898707f, 0.334209f, 0.283955f, 
		0.981600f, 0.138582f, -0.131365f, 0.967839f, 0.251381f, -0.00980655f, 
		0.943884f, 0.157466f, 0.290324f, 0.191978f, 0.166553f, -0.967163f, 
		0.882365f, 0.406452f, -0.237125f, -0.700599f, 0.713540f, 0.00470963f, 
		0.274169f, 0.806603f, 0.523663f, 0.274169f, 0.806603f, 0.523663f, 
		0.842563f, -0.509924f, 0.173396f, -0.514590f, 0.857406f, -0.00719979f, 
		-0.514590f, 0.857406f, -0.00719979f, -0.457233f, 0.887375f, 0.0591882f, 
		0.294091f, 0.790688f, 0.536957f, 0.294091f, 0.790688f, 0.536957f, 
		-0.548810f, 0.834276f, 0.0528322f, 0.632654f, 0.748704f, 0.197965f, 
		0.00496226f, 0.650448f, -0.759535f, 0.953115f, -0.295408f, 0.0656223f, 
		0.0134329f, 0.492773f, 0.870054f, 0.968359f, 0.214776f, 0.127093f, 
		-0.459646f, 0.887360f, -0.0362975f, 0.266983f, 0.790687f, -0.550940f, 
		0.266983f, 0.790687f, -0.550940f, 0.946401f, 0.218900f, -0.237503f, 
		-0.543591f, 0.839304f, -0.00883733f, -0.543591f, 0.839304f, -0.00883733f, 
		-0.0626108f, -0.355775f, 0.932472f, -0.0126428f, -0.986554f, 0.162948f, 
		0.00638747f, 0.646732f, -0.762691f, 0.954044f, -0.291154f, 0.0709184f, 
		-0.0396172f, 0.332579f, 0.942243f, -0.0396172f, 0.332579f, 0.942243f, 
		-0.0396172f, 0.332579f, 0.942243f, -0.0777453f, -0.0257124f, 0.996642f, 
		-0.0777453f, -0.0257124f, 0.996642f, 0.937331f, 0.0969911f, 0.334670f, 
		0.913532f, 0.134528f, 0.383876f, 0.300219f, -0.0274384f, 0.953476f, 
		0.915950f, -0.398852f, 0.0441816f, 0.844910f, 0.490042f, -0.214444f, 
		0.163816f, 0.0893960f, -0.982432f, 0.181366f, -0.145863f, -0.972538f, 
		0.955520f, -0.291016f, -0.0478621f, -0.449941f, 0.892719f, -0.0246194f, 
		-0.449941f, 0.892719f, -0.0246194f, 0.338688f, 0.940756f, -0.0164062f, 
		0.940056f, 0.127353f, -0.316349f, 0.910149f, -0.349537f, -0.222378f, 
		0.0899285f, 0.558312f, -0.824743f, 0.931670f, -0.258186f, 0.255599f, 
		0.931670f, -0.258186f, 0.255599f, 0.923096f, 0.0950799f, 0.372631f, 
		0.922677f, 0.101458f, -0.371986f, -0.542470f, 0.839308f, 0.0359090f, 
		-0.542470f, 0.839308f, 0.0359090f, 0.859179f, -0.379944f, -0.342716f, 
		0.0526727f, 0.520041f, -0.852516f, 0.895169f, 0.384611f, 0.225272f, 
		0.308462f, 0.0247177f, 0.950915f, 0.111162f, 0.104571f, -0.988285f, 
		0.922546f, 0.332432f, -0.195953f, 0.958688f, 0.284453f, 0.00202815f, 
		-0.448090f, 0.892752f, 0.0470094f, -0.448090f, 0.892752f, 0.0470094f, 
		0.339089f, 0.940754f, -0.000479226f, 0.903679f, 0.352805f, -0.242678f, 
		0.172973f, -0.0394915f, -0.984135f, 0.973839f, -0.212604f, -0.0802358f, 
		-0.216058f, -0.232648f, -0.948258f, 0.326844f, -0.0358126f, 0.944399f, 
		0.968749f, -0.225614f, 0.103067f, 0.949706f, 0.308919f, -0.0512672f, 
		0.155452f, 0.0240668f, -0.987550f, 0.985929f, 0.0478225f, -0.160178f, 
		0.920094f, -0.349573f, 0.176706f, 0.130918f, 0.558294f, 0.819248f, 
		0.295013f, 0.117731f, 0.948212f, 0.983679f, 0.0312057f, 0.177205f, 
		0.910997f, 0.323233f, 0.256134f, -0.00559879f, -0.996921f, 0.0782146f, 
		0.875184f, -0.379984f, 0.299440f, 0.0950868f, 0.520023f, 0.848843f, 
		0.942596f, -0.328271f, 0.0612408f, 0.942596f, -0.328271f, 0.0612408f, 
		0.882766f, -0.451881f, -0.128560f, 0.882766f, -0.451881f, -0.128560f, 
		0.964045f, 0.242569f, 0.108526f, 0.978123f, 0.207843f, -0.00872688f, 
		0.965340f, 0.243991f, -0.0926632f, 0.942441f, 0.265991f, -0.202615f, 
		0.963339f, 0.249677f, 0.0981812f, 0.967096f, -0.242610f, 0.0765886f, 
		0.967096f, -0.242610f, 0.0765886f, 0.967885f, 0.179232f, 0.176279f, 
		0.973084f, 0.216530f, 0.0788786f, 0.920340f, 0.301909f, -0.248647f, 
		0.969565f, 0.244828f, -0.00180209f, 0.963017f, 0.262091f, -0.0624967f, 
		-0.00902305f, -0.997813f, -0.0654883f, 0.985417f, 0.0829680f, 0.148558f, 
		0.940521f, -0.319739f, -0.114834f, 0.940521f, -0.319739f, -0.114834f, 
		0.989829f, 0.101668f, 0.0995129f, 0.961494f, 0.252104f, -0.109419f, 
		0.993710f, 0.102977f, -0.0440026f, 0.974274f, 0.208722f, 0.0850020f, 
		0.988199f, 0.153159f, 0.00222601f, 0.989829f, 0.101668f, 0.0995129f, 
		0.0289932f, 0.541739f, -0.840047f, 0.977511f, -0.154153f, -0.143904f, 
		-0.0241589f, 0.339267f, 0.940380f, 0.0707916f, 0.541711f, 0.837579f, 
		0.983457f, -0.154167f, 0.0951004f, -0.0709601f, 0.339288f, -0.938002f, 
		-0.935878f, 0.317389f, 0.152963f, 0.0412169f, 0.654106f, 0.755279f, 
		-0.0759308f, 0.557166f, -0.826922f, -0.0844941f, -0.806306f, 0.585432f, 
		-0.0745947f, -0.578513f, 0.812255f, -0.0925234f, -0.723808f, 0.683770f, 
		-0.0925234f, -0.723808f, 0.683770f, 0.802413f, -0.402914f, -0.440220f, 
		0.255092f, 0.783936f, -0.566014f, 0.255092f, 0.783936f, -0.566014f, 
		0.0303786f, 0.547206f, -0.836446f, 0.978330f, -0.153422f, -0.139037f, 
		-0.0195304f, 0.204975f, 0.978572f, 0.000256173f, -0.325019f, -0.945707f, 
		0.000256173f, -0.325019f, -0.945707f, -0.00214068f, -0.968226f, -0.250066f, 
		0.0719970f, 0.547183f, 0.833911f, 0.984031f, -0.153438f, 0.0902194f, 
		-0.0682408f, 0.204970f, -0.976386f, -0.114958f, -0.578514f, -0.807531f, 
		-0.126464f, -0.723812f, -0.678309f, -0.113547f, -0.806310f, -0.580492f, 
		-0.126464f, -0.723812f, -0.678309f, -0.936310f, 0.320717f, 0.143051f, 
		0.0427775f, 0.650457f, 0.758337f, -0.00394194f, 0.464156f, -0.885745f, 
		-0.0229516f, -0.00589372f, -0.999719f, -0.0229516f, -0.00589372f, -0.999719f, 
		0.941594f, -0.288134f, 0.174299f, 0.0530281f, 0.511150f, 0.857854f, 
		0.826266f, -0.334930f, -0.452886f, 0.178525f, 0.716984f, -0.673842f, 
		0.178525f, 0.716984f, -0.673842f, 0.931741f, -0.288177f, -0.220935f, 
		0.0102385f, 0.511161f, -0.859424f, 0.972592f, -0.232510f, 0.00210682f, 
		0.207588f, 0.582949f, 0.785543f, 0.971277f, -0.232534f, -0.0504930f, 
		0.168212f, 0.582948f, -0.794906f, -0.0609731f, -0.974189f, 0.217345f, 
		-0.0715839f, -0.974414f, -0.213059f, 0.823340f, -0.402941f, 0.399687f, 
		0.282973f, 0.783936f, 0.552603f, 0.282973f, 0.783936f, 0.552603f, 
		0.00353693f, 0.654147f, -0.756360f, -0.942332f, 0.317396f, -0.106166f, 
		-0.0346345f, 0.557181f, 0.829668f, 0.847804f, -0.334907f, 0.411175f, 
		0.211872f, 0.716986f, 0.664109f, 0.211872f, 0.716986f, 0.664109f, 
		0.0473628f, -0.325061f, 0.944506f, 0.0473628f, -0.325061f, 0.944506f, 
		0.0103172f, -0.968224f, 0.249872f, 0.00496226f, 0.650448f, -0.759535f, 
		-0.942270f, 0.320725f, -0.0962410f, 0.0401720f, 0.464186f, 0.884826f, 
		0.0268705f, -0.00589825f, 0.999622f, 0.0268705f, -0.00589825f, 0.999622f, 
		-0.841371f, 0.397713f, 0.365950f, 0.0138477f, 0.559319f, -0.828837f, 
		-0.895925f, 0.369958f, 0.245866f, 0.194099f, 0.552707f, -0.810457f, 
		0.222013f, 0.834806f, -0.503795f, 0.183195f, 0.747798f, -0.638152f, 
		-0.858553f, 0.397724f, -0.323578f, 0.0551387f, 0.559305f, 0.827126f, 
		0.951291f, -0.264973f, 0.157592f, 0.235608f, 0.838939f, 0.490582f, 
		0.235608f, 0.838939f, 0.490582f, -0.907056f, 0.369962f, -0.200940f, 
		0.234226f, 0.552698f, 0.799790f, 0.214754f, 0.747798f, 0.628235f, 
		0.246832f, 0.834810f, 0.492104f, 0.919493f, -0.313400f, 0.237305f, 
		0.327626f, 0.877795f, 0.349481f, 0.327626f, 0.877795f, 0.349481f, 
		0.942265f, -0.264966f, -0.204765f, 0.210873f, 0.838936f, -0.501716f, 
		0.210873f, 0.838936f, -0.501716f, 0.912988f, -0.290631f, -0.286332f, 
		0.331090f, 0.941274f, -0.0661989f, 0.906525f, -0.313457f, -0.282767f, 
		0.309814f, 0.877794f, -0.365367f, 0.309814f, 0.877794f, -0.365367f, 
		0.961646f, -0.246487f, -0.120335f, 0.331515f, 0.919023f, -0.213295f, 
		0.926142f, -0.290554f, 0.240500f, 0.333983f, 0.941271f, 0.0496299f, 
		0.966463f, -0.246420f, 0.0722894f, 0.341732f, 0.919020f, 0.196525f, 
		-0.812305f, 0.345569f, 0.469833f, 0.187186f, 0.717542f, -0.670891f, 
		0.187186f, 0.717542f, -0.670891f, -0.793201f, 0.413390f, 0.447147f, 
		0.346377f, 0.767483f, -0.539438f, -0.834695f, 0.345601f, -0.428771f, 
		0.220380f, 0.717533f, 0.660741f, 0.220380f, 0.717533f, 0.660741f, 
		0.0303786f, 0.547206f, -0.836446f, -0.976481f, 0.126786f, 0.174386f, 
		0.0176369f, 0.388288f, 0.921369f, 0.0719970f, 0.547183f, 0.833911f, 
		-0.983936f, 0.126856f, -0.125612f, -0.0282716f, 0.388305f, -0.921097f, 
		-0.972132f, 0.231572f, -0.0365260f, 0.151735f, 0.656095f, 0.739268f, 
		-0.814487f, 0.413411f, -0.407066f, 0.372819f, 0.767474f, 0.521526f, 
		-0.0710329f, -0.958239f, 0.277007f, 0.0558976f, -0.280482f, 0.958230f, 
		0.0317627f, 0.552650f, -0.832808f, -0.975409f, 0.130479f, 0.177631f, 
		0.111232f, 0.260363f, 0.959082f, -0.969108f, 0.231562f, 0.0849015f, 
		0.114720f, 0.656095f, -0.745908f, 0.0731992f, 0.552631f, 0.830205f, 
		-0.983040f, 0.130491f, -0.128855f, 0.0633228f, 0.260373f, -0.963429f, 
		0.00810003f, -0.280525f, -0.959812f, -0.0847412f, -0.958240f, -0.273119f, 
		0.0238013f, -0.108943f, 0.993763f, -0.969059f, 0.245826f, -0.0222157f, 
		0.190467f, 0.539793f, 0.819967f, 0.190467f, 0.539793f, 0.819967f, 
		-0.0257284f, -0.108936f, -0.993716f, -0.966758f, 0.245789f, 0.0704776f, 
		0.149148f, 0.539462f, -0.828695f, 0.149148f, 0.539462f, -0.828695f, 
		-0.00999787f, -0.994354f, 0.105638f, -0.0152477f, -0.994354f, -0.105013f, 
		0.0128532f, -0.984836f, -0.173011f, -0.00954700f, -0.999841f, 0.0150627f, 
		-0.952896f, 0.268326f, -0.141385f, 0.319935f, 0.905388f, 0.279132f, 
		0.319935f, 0.905388f, 0.279132f, 0.959667f, 0.0112052f, 0.280914f, 
		0.419659f, -0.904367f, 0.0775024f, 0.387364f, 0.341032f, -0.856532f, 
		-0.954915f, 0.247962f, 0.163256f, 0.328745f, 0.907941f, -0.259943f, 
		-0.0102232f, -0.999840f, -0.0147034f, 0.959753f, 0.0116666f, 0.280602f, 
		0.00277875f, 0.994469f, -0.104989f, 0.387328f, 0.339042f, -0.857337f, 
		-0.951709f, 0.278747f, -0.128649f, 0.343266f, 0.862895f, 0.370918f, 
		-0.903569f, 0.295869f, 0.309878f, 0.411483f, 0.904763f, -0.109934f, 
		-0.944684f, 0.268270f, 0.188691f, 0.305632f, 0.905387f, -0.294725f, 
		0.305632f, 0.905387f, -0.294725f, 0.0214480f, -0.984823f, 0.172232f, 
		0.959581f, 0.0107437f, 0.281227f, 0.557169f, -0.828813f, -0.0513033f, 
		0.0331379f, 0.479639f, -0.876840f, -0.944125f, 0.278719f, 0.175911f, 
		0.324332f, 0.862928f, -0.387510f, 0.231014f, -0.304418f, -0.924101f, 
		0.0748149f, -0.969245f, -0.234449f, -0.961863f, 0.247958f, -0.115484f, 
		0.341293f, 0.907936f, 0.243250f, 0.959667f, 0.0112052f, 0.280914f, 
		0.00289690f, 0.994421f, -0.105441f, 0.215777f, -0.132146f, -0.967459f, 
		-0.917875f, 0.295901f, -0.264477f, 0.416455f, 0.904761f, 0.0892939f, 
		0.944480f, 0.0112050f, -0.328378f, 0.415253f, -0.904375f, -0.0983438f, 
		0.429543f, 0.341060f, 0.836164f, 0.944575f, 0.0116369f, -0.328090f, 
		0.00799025f, 0.994471f, 0.104704f, 0.429543f, 0.339094f, 0.836964f, 
		0.944385f, 0.0107731f, -0.328666f, 0.559019f, -0.828823f, 0.0234561f, 
		0.0767622f, 0.479657f, 0.874092f, 0.276757f, -0.304409f, 0.911450f, 
		0.0863990f, -0.969241f, 0.230448f, 0.944480f, 0.0112050f, -0.328378f, 
		0.00812459f, 0.994425f, 0.105130f, 0.263699f, -0.132164f, 0.955508f, 
		0.511515f, -0.851187f, -0.117612f, 0.511515f, -0.851187f, -0.117612f, 
		0.555377f, 0.261834f, -0.789303f, 0.532258f, 0.492269f, -0.688747f, 
		0.413148f, 0.637483f, -0.650326f, 0.509812f, -0.829318f, -0.228744f, 
		-0.290230f, -0.904038f, 0.313819f, 0.509812f, -0.829318f, -0.228744f, 
		0.0843564f, 0.797240f, -0.597740f, 0.0577124f, 0.638391f, -0.767546f, 
		0.0729051f, 0.894957f, -0.440155f, 0.516720f, -0.851202f, 0.0919592f, 
		0.516720f, -0.851202f, 0.0919592f, 0.594007f, 0.261817f, 0.760663f, 
		0.445039f, 0.637468f, 0.628947f, 0.565912f, 0.492251f, 0.661386f, 
		0.0576418f, -0.990273f, 0.126638f, -0.305693f, -0.903929f, -0.299106f, 
		0.520551f, -0.829338f, 0.203041f, 0.520551f, -0.829338f, 0.203041f, 
		0.0958640f, 0.638393f, 0.763718f, 0.114019f, 0.797246f, 0.592788f, 
		0.0947312f, 0.894967f, 0.435958f, 0.0512628f, -0.990272f, -0.129361f, 
		0.0555789f, -0.995355f, -0.0786132f, 0.773334f, -0.0525878f, -0.631814f, 
		0.261614f, -0.964838f, -0.0254143f, 0.339098f, 0.132908f, 0.931315f, 
		0.356841f, 0.383778f, 0.851692f, 0.446414f, 0.541616f, 0.712297f, 
		0.261614f, -0.964838f, -0.0254143f, 0.803846f, -0.0525960f, 0.592508f, 
		0.265581f, -0.964050f, 0.00862524f, 0.292288f, 0.132963f, -0.947042f, 
		0.313984f, 0.383794f, -0.868399f, 0.265581f, -0.964050f, 0.00862524f, 
		0.410406f, 0.541576f, -0.733664f, 0.779278f, -0.0545818f, -0.624297f, 
		0.0437921f, 0.992254f, 0.116250f, 0.523428f, 0.227853f, 0.821039f, 
		0.809380f, -0.0545801f, 0.584743f, 0.0379484f, 0.992255f, -0.118280f, 
		0.481897f, 0.227813f, -0.846094f, 0.0550855f, -0.976374f, 0.208947f, 
		0.437907f, -0.238807f, 0.866723f, 0.779278f, -0.0545818f, -0.624297f, 
		0.381252f, -0.923382f, -0.0448571f, 0.161191f, 0.288875f, 0.943700f, 
		0.0594322f, -0.995346f, 0.0758508f, 0.394196f, -0.238859f, -0.887444f, 
		0.0446104f, -0.976371f, -0.211447f, 0.809380f, -0.0545801f, 0.584743f, 
		0.390127f, -0.920202f, 0.0320858f, 0.113833f, 0.288580f, -0.950665f, 
		0.785147f, -0.0565706f, -0.616720f, 0.0571584f, 0.989741f, 0.130938f, 
		0.266370f, -0.155144f, 0.951303f, 0.296692f, -0.924449f, -0.239516f, 
		0.709445f, 0.188909f, -0.678971f, 0.814838f, -0.0565591f, 0.576923f, 
		0.0505536f, 0.989745f, -0.133599f, 0.218658f, -0.155196f, -0.963381f, 
		0.430933f, -0.900666f, 0.0556576f, 0.882665f, -0.123334f, 0.453532f, 
		0.463657f, 0.730775f, 0.500989f, 0.136112f, 0.0305256f, 0.990223f, 
		0.733942f, 0.0756761f, -0.674983f, -0.290056f, -0.903702f, 0.314946f, 
		0.349732f, -0.885821f, -0.304974f, 0.433445f, -0.896606f, -0.0906797f, 
		0.858984f, -0.123367f, -0.496917f, 0.438152f, 0.730752f, -0.523473f, 
		0.0866155f, 0.0306633f, -0.995770f, 0.466978f, 0.535147f, -0.703953f, 
		0.512665f, 0.306997f, -0.801828f, 0.508057f, 0.434920f, -0.743454f, 
		0.422079f, 0.605667f, -0.674549f, 0.420348f, 0.754378f, -0.504203f, 
		0.709445f, 0.188909f, -0.678971f, 0.235277f, 0.911850f, -0.336414f, 
		0.235277f, 0.911850f, -0.336414f, 0.916821f, 0.0326302f, 0.397963f, 
		0.463657f, 0.730775f, 0.500989f, 0.136112f, 0.0305256f, 0.990223f, 
		0.0502217f, -0.966851f, -0.250354f, 0.308230f, -0.924462f, 0.224420f, 
		0.742388f, 0.188891f, 0.642791f, -0.290056f, -0.903702f, 0.314946f, 
		0.351121f, 0.804451f, -0.479137f, 0.351121f, 0.804451f, -0.479137f, 
		0.438152f, 0.730752f, -0.523473f, 0.895821f, 0.0328072f, -0.443202f, 
		0.0866155f, 0.0306633f, -0.995770f, 0.0626308f, -0.966851f, 0.247541f, 
		0.424047f, -0.905443f, -0.0189136f, 0.424047f, -0.905443f, -0.0189136f, 
		0.249135f, 0.678807f, 0.690762f, 0.249135f, 0.678807f, 0.690762f, 
		0.766658f, 0.0757492f, 0.637572f, -0.305575f, -0.903596f, -0.300231f, 
		0.364460f, -0.885841f, 0.287150f, 0.00594357f, 0.994741f, -0.102248f, 
		0.470080f, 0.356273f, -0.807523f, 0.0519370f, -0.998428f, 0.0210856f, 
		0.429248f, -0.903148f, -0.00839234f, 0.429248f, -0.903148f, -0.00839234f, 
		0.214226f, 0.678577f, -0.702596f, 0.214226f, 0.678577f, -0.702596f, 
		0.742388f, 0.188891f, 0.642791f, 0.251757f, 0.911842f, 0.324287f, 
		0.251757f, 0.911842f, 0.324287f, 0.551961f, 0.307033f, 0.775287f, 
		0.501459f, 0.535162f, 0.679809f, 0.455154f, 0.605674f, 0.652682f, 
		0.544452f, 0.434944f, 0.717214f, 0.444944f, 0.754378f, 0.482638f, 
		0.0508157f, -0.998428f, -0.0236473f, 0.374611f, 0.804403f, 0.461089f, 
		-0.305575f, -0.903596f, -0.300231f, 0.374611f, 0.804403f, 0.461089f, 
		0.00465752f, 0.994560f, -0.104061f, 0.670149f, -0.0296668f, -0.741633f, 
		0.566809f, -0.0947834f, -0.818379f, 0.100129f, -0.988639f, -0.112099f, 
		0.943523f, -0.0159571f, 0.330923f, 0.463657f, 0.730775f, 0.500989f, 
		0.421314f, 0.898853f, 0.120657f, 0.469941f, -0.880395f, -0.0637119f, 
		0.925997f, -0.118831f, 0.358342f, 0.126356f, -0.985447f, -0.113700f, 
		0.939644f, 0.0857870f, 0.331224f, 0.370941f, 0.871578f, 0.320552f, 
		0.370941f, 0.871578f, 0.320552f, 0.126356f, -0.985447f, -0.113700f, 
		0.0110022f, 0.994744f, 0.101798f, 0.509710f, 0.356323f, 0.783090f, 
		0.0462611f, -0.998726f, -0.0201587f, 0.438152f, 0.730752f, -0.523473f, 
		0.925864f, -0.0158562f, -0.377524f, 0.414995f, 0.898746f, -0.141542f, 
		0.475816f, -0.878818f, 0.0357519f, 0.906999f, -0.118865f, -0.404011f, 
		0.131849f, -0.985449f, 0.107269f, 0.921946f, 0.0860000f, -0.377649f, 
		0.354567f, 0.871547f, -0.338656f, 0.131849f, -0.985449f, 0.107269f, 
		0.354567f, 0.871547f, -0.338656f, 0.446028f, -0.894156f, -0.0392948f, 
		0.398689f, 0.896912f, 0.191304f, 0.00982486f, 0.994561f, 0.103689f, 
		0.706258f, -0.0296833f, 0.707332f, 0.606871f, -0.0947936f, 0.789128f, 
		0.105599f, -0.988637f, 0.106984f, 0.0550983f, -0.998264f, 0.0208235f, 
		0.447133f, -0.894341f, 0.0150132f, 0.388685f, 0.896910f, -0.210895f, 
		0.129627f, -0.991044f, -0.0320801f, 0.716878f, 0.206254f, -0.665992f, 
		0.271269f, 0.962468f, -0.00824331f, 0.440454f, -0.895713f, 0.0608130f, 
		0.445005f, 0.862930f, -0.239421f, 0.445005f, 0.862930f, -0.239421f, 
		0.523024f, 0.828320f, -0.200829f, 0.683497f, 0.387536f, -0.618585f, 
		-0.289880f, -0.903364f, 0.316073f, 0.662226f, 0.629883f, -0.405838f, 
		0.962478f, -0.0634152f, 0.263847f, 0.733942f, 0.0756761f, -0.674983f, 
		0.177746f, -0.973962f, -0.140727f, 0.962048f, 0.0624956f, 0.265627f, 
		0.131046f, -0.991046f, 0.0255849f, 0.749168f, 0.206241f, 0.629453f, 
		0.271371f, 0.962460f, -0.00528983f, 0.436763f, -0.895772f, -0.0826414f, 
		0.456475f, 0.862875f, 0.216973f, 0.456475f, 0.862875f, 0.216973f, 
		0.686966f, 0.270505f, 0.674466f, 0.617150f, 0.424239f, 0.662681f, 
		0.334213f, 0.906432f, 0.258232f, 0.458299f, 0.704018f, 0.542513f, 
		0.652535f, 0.270464f, -0.707847f, 0.583399f, 0.424195f, -0.692607f, 
		0.320975f, 0.906410f, -0.274583f, 0.430741f, 0.703984f, -0.564685f, 
		0.532609f, 0.828165f, 0.174557f, 0.713517f, 0.387427f, 0.583775f, 
		0.681744f, 0.629750f, 0.372342f, -0.305457f, -0.903261f, -0.301356f, 
		0.948143f, -0.0633600f, -0.311466f, 0.766658f, 0.0757492f, 0.637572f, 
		0.947609f, 0.0626921f, -0.313221f, 0.184514f, -0.973967f, 0.131691f, 
		0.0793960f, 0.991440f, 0.103648f, 0.845444f, 0.250923f, 0.471448f, 
		0.845444f, 0.250923f, 0.471448f, 0.0741204f, 0.991443f, -0.107453f, 
		0.820917f, 0.250900f, -0.512976f, 0.820917f, 0.250900f, -0.512976f, 
		0.107602f, -0.990017f, 0.0910359f, 0.888806f, -0.160588f, 0.429227f, 
		0.888806f, -0.160588f, 0.429227f, 0.125324f, 0.988564f, 0.0838789f, 
		0.748998f, -0.211241f, 0.627996f, 0.748998f, -0.211241f, 0.627996f, 
		0.866321f, -0.160543f, -0.472985f, 0.866321f, -0.160543f, -0.472985f, 
		0.102933f, -0.990017f, -0.0962907f, 0.120905f, 0.988577f, -0.0899810f, 
		0.716789f, -0.211245f, -0.664521f, 0.716789f, -0.211245f, -0.664521f, 
		0.625894f, 0.149736f, -0.765399f, 0.935906f, 0.241463f, 0.256468f, 
		0.195474f, 0.965102f, -0.174261f, 0.104374f, 0.994536f, 0.00186327f, 
		0.628569f, 0.265542f, -0.731019f, 0.957724f, 0.167298f, 0.234044f, 
		0.663235f, 0.149795f, 0.733267f, 0.921970f, 0.241457f, -0.302771f, 
		0.203927f, 0.965099f, 0.164308f, 0.970815f, -0.114484f, 0.210742f, 
		0.753405f, -0.0378775f, -0.656465f, 0.104783f, -0.994422f, -0.0120358f, 
		0.0658472f, 0.996638f, -0.0487454f, 0.969698f, -0.133303f, 0.204732f, 
		0.737977f, -0.110457f, -0.665724f, 0.104051f, 0.994547f, -0.00706583f, 
		0.664191f, 0.265598f, 0.698790f, 0.944867f, 0.167329f, -0.281472f, 
		0.959112f, -0.114456f, -0.258850f, 0.785168f, -0.0378881f, 0.618122f, 
		0.105230f, -0.994425f, 0.00679788f, 0.0680981f, 0.996645f, 0.0453932f, 
		0.958298f, -0.133259f, -0.252798f, 0.770221f, -0.110460f, 0.628138f
	};
	static GLfloat TexCoordData[] = {
		0.143231f, 0.339069f, 0.228184f, 0.301908f, 0.289960f, 0.779969f, 
		0.228470f, 0.367404f, 0.620199f, 0.404732f, 
		0.158497f, 0.391181f, 0.131009f, 0.282899f, 
		0.197280f, 0.249827f, 0.259953f, 0.778392f, 
		0.264890f, 0.346506f, 0.0943360f, 0.335171f, 
		0.601031f, 0.439520f, 0.115511f, 0.396281f, 
		0.111619f, 0.227565f, 0.106472f, 0.974322f, 
		0.208719f, 0.423814f, 0.696591f, 0.381784f, 
		0.242646f, 0.409515f, 0.0827680f, 0.976458f, 
		0.314817f, 0.719138f, 0.814350f, 0.386540f, 
		0.524059f, 0.174020f, 0.524059f, 0.174020f, 
		0.524059f, 0.174020f, 0.524059f, 0.174020f, 
		0.174937f, 0.431681f, 0.676070f, 0.404630f, 
		0.168777f, 0.199279f, 0.168061f, 0.816937f, 
		0.284469f, 0.250512f, 0.873445f, 0.430146f, 
		0.406106f, 0.794392f, 0.531200f, 0.178536f, 
		0.505219f, 0.166098f, 0.508227f, 0.171562f, 
		0.510136f, 0.163665f, 0.508938f, 0.166961f, 
		0.498915f, 0.165030f, 0.498915f, 0.165030f, 
		0.498915f, 0.165030f, 0.834121f, 0.381784f, 
		0.296660f, 0.715791f, 0.310073f, 0.306319f, 
		0.206351f, 0.770097f, 0.875283f, 0.435992f, 
		0.875283f, 0.435992f, 0.525354f, 0.180956f, 
		0.791053f, 0.456037f, 0.791053f, 0.456037f, 
		0.506863f, 0.162252f, 0.506863f, 0.162252f, 
		0.789524f, 0.452191f, 0.509082f, 0.166892f, 
		0.791515f, 0.453132f, 0.510079f, 0.163046f, 
		0.521185f, 0.166422f, 0.521185f, 0.166422f, 
		0.521185f, 0.166422f, 0.794463f, 0.441996f, 
		0.794463f, 0.441996f, 0.533579f, 0.173269f, 
		0.410900f, 0.797754f, 0.533579f, 0.173269f, 
		0.792109f, 0.428174f, 0.508613f, 0.168986f, 
		0.508613f, 0.168986f, 0.879609f, 0.454854f, 
		0.879110f, 0.453917f, 0.879110f, 0.453917f, 
		0.507749f, 0.170627f, 0.504235f, 0.170279f, 
		0.879596f, 0.457135f, 0.491396f, 0.163173f, 
		0.789999f, 0.466832f, 0.498255f, 0.161004f, 
		0.498255f, 0.161004f, 0.510334f, 0.163181f, 
		0.508254f, 0.171585f, 0.506403f, 0.170846f, 
		0.506403f, 0.170846f, 0.508360f, 0.162776f, 
		0.0946810f, 0.435534f, 0.498891f, 0.168872f, 
		0.498891f, 0.168872f, 0.880805f, 0.462466f, 
		0.136644f, 0.426626f, 0.255945f, 0.194875f, 
		0.508152f, 0.172016f, 0.878338f, 0.453194f, 
		0.508152f, 0.172016f, 0.878338f, 0.453194f, 
		0.508152f, 0.172016f, 0.490409f, 0.159175f, 
		0.490409f, 0.159175f, 0.490409f, 0.159175f, 
		0.490409f, 0.159175f, 0.789187f, 0.472902f, 
		0.0661110f, 0.395123f, 0.586966f, 0.486537f, 
		0.509132f, 0.166940f, 0.788169f, 0.451804f, 
		0.787795f, 0.453831f, 0.507143f, 0.166428f, 
		0.0490340f, 0.339616f, 0.788780f, 0.467497f, 
		0.495263f, 0.159511f, 0.492910f, 0.164019f, 
		0.492910f, 0.164019f, 0.492910f, 0.164019f, 
		0.492910f, 0.164019f, 0.492910f, 0.164019f, 
		0.489664f, 0.167990f, 0.882264f, 0.468795f, 
		0.508952f, 0.167215f, 0.507114f, 0.166682f, 
		0.878941f, 0.453206f, 0.878941f, 0.453206f, 
		0.0457320f, 0.444875f, 0.527255f, 0.166421f, 
		0.791035f, 0.436296f, 0.791035f, 0.436296f, 
		0.791035f, 0.436296f, 0.150653f, 0.471586f, 
		0.0938670f, 0.382174f, 0.883086f, 0.454588f, 
		0.883213f, 0.452603f, 0.882107f, 0.453344f, 
		0.491686f, 0.159328f, 0.789807f, 0.468655f, 
		0.789325f, 0.472891f, 0.786987f, 0.451738f, 
		0.791801f, 0.452832f, 0.787845f, 0.451951f, 
		0.879624f, 0.435138f, 0.879624f, 0.435138f, 
		0.879624f, 0.435138f, 0.879624f, 0.435138f, 
		0.879624f, 0.435138f, 0.787511f, 0.454185f, 
		0.787511f, 0.454185f, 0.787511f, 0.454185f, 
		0.787511f, 0.454185f, 0.787511f, 0.454185f, 
		0.0485580f, 0.382727f, 0.484512f, 0.167493f, 
		0.484512f, 0.167493f, 0.883524f, 0.475284f, 
		0.132400f, 0.380247f, 0.115830f, 0.487202f, 
		0.791887f, 0.452778f, 0.783739f, 0.451195f, 
		0.783363f, 0.453260f, 0.791447f, 0.454812f, 
		0.475401f, 0.161983f, 0.181252f, 0.461110f, 
		0.883050f, 0.455929f, 0.883050f, 0.455929f, 
		0.883050f, 0.455929f, 0.883050f, 0.455929f, 
		0.883050f, 0.455929f, 0.883050f, 0.455929f, 
		0.105924f, 0.163419f, 0.497759f, 0.158536f, 
		0.785808f, 0.465604f, 0.643065f, 0.471307f, 
		0.884183f, 0.461713f, 0.884183f, 0.461713f, 
		0.884183f, 0.461713f, 0.884183f, 0.461713f, 
		0.884183f, 0.461713f, 0.883121f, 0.454401f, 
		0.508809f, 0.162678f, 0.508809f, 0.162678f, 
		0.882468f, 0.454242f, 0.507463f, 0.167404f, 
		0.988224f, 0.540371f, 0.987145f, 0.539015f, 
		0.882909f, 0.454381f, 0.887036f, 0.452170f, 
		0.785854f, 0.459612f, 0.176490f, 0.417010f, 
		0.881790f, 0.428363f, 0.406155f, 0.802737f, 
		0.980544f, 0.516185f, 0.881790f, 0.428363f, 
		0.406155f, 0.802737f, 0.980544f, 0.516185f, 
		0.882738f, 0.452978f, 0.882738f, 0.452978f, 
		0.882738f, 0.452978f, 0.493702f, 0.156823f, 
		0.785548f, 0.469613f, 0.884067f, 0.479150f, 
		0.482195f, 0.167083f, 0.884067f, 0.479150f, 
		0.482195f, 0.167083f, 0.482195f, 0.167083f, 
		0.884067f, 0.479150f, 0.885183f, 0.467491f, 
		0.885183f, 0.467491f, 0.885183f, 0.467491f, 
		0.885183f, 0.467491f, 0.879145f, 0.454932f, 
		0.788725f, 0.453936f, 0.507782f, 0.164778f, 
		0.507782f, 0.164778f, 0.507711f, 0.164693f, 
		0.878592f, 0.453121f, 0.788725f, 0.453936f, 
		0.784705f, 0.452682f, 0.784705f, 0.452682f, 
		0.985184f, 0.515037f, 0.787664f, 0.429288f, 
		0.985184f, 0.515037f, 0.410721f, 0.803061f, 
		0.787664f, 0.429288f, 0.989542f, 0.540378f, 
		0.989542f, 0.540378f, 0.882751f, 0.452844f, 
		0.886148f, 0.453867f, 0.989625f, 0.538711f, 
		0.988203f, 0.539544f, 0.882262f, 0.454709f, 
		0.886162f, 0.452315f, 0.883251f, 0.453453f, 
		0.475481f, 0.157838f, 0.784541f, 0.488086f, 
		0.784541f, 0.488086f, 0.987826f, 0.540931f, 
		0.883331f, 0.454527f, 0.987196f, 0.539066f, 
		0.886706f, 0.451614f, 0.475292f, 0.165618f, 
		0.886011f, 0.485787f, 0.886011f, 0.485787f, 
		0.475292f, 0.165618f, 0.000000f, 0.455433f, 
		0.215487f, 0.151615f, 1.00563f, 0.534428f, 
		0.990785f, 0.540047f, 0.787490f, 0.452602f, 
		0.786594f, 0.452106f, 0.787405f, 0.453798f, 
		0.990984f, 0.537968f, 0.992781f, 0.537436f, 
		0.996220f, 0.538967f, 0.787549f, 0.453777f, 
		0.787549f, 0.453777f, 0.998407f, 0.535953f, 
		0.785482f, 0.453585f, 0.493512f, 0.163566f, 
		0.489725f, 0.167794f, 0.484126f, 0.162192f, 
		0.484126f, 0.162192f, 0.484126f, 0.162192f, 
		0.785317f, 0.468322f, 0.785317f, 0.468322f, 
		0.785317f, 0.468322f, 0.787827f, 0.451837f, 
		0.996142f, 0.538968f, 0.995739f, 0.537081f, 
		0.783830f, 0.451326f, 0.783108f, 0.474395f, 
		0.783108f, 0.474395f, 0.783108f, 0.474395f, 
		0.783108f, 0.474395f, 0.783108f, 0.474395f, 
		0.497098f, 0.164822f, 0.496380f, 0.160495f, 
		0.489728f, 0.163222f, 0.493662f, 0.168309f, 
		0.498948f, 0.169255f, 0.790951f, 0.456843f, 
		0.506189f, 0.162343f, 0.791739f, 0.452745f, 
		0.791739f, 0.452745f, 0.510267f, 0.163151f, 
		0.885110f, 0.454218f, 0.978229f, 0.522484f, 
		0.883739f, 0.434899f, 0.978229f, 0.522484f, 
		0.883739f, 0.434899f, 0.883739f, 0.434899f, 
		0.885601f, 0.469083f, 0.885601f, 0.469083f, 
		0.885601f, 0.469083f, 0.547266f, 0.596880f, 
		0.547266f, 0.596880f, 0.547266f, 0.596880f, 
		0.0650600f, 0.322394f, 0.102000f, 0.331608f, 
		0.493526f, 0.163797f, 0.493637f, 0.159764f, 
		0.485850f, 0.158163f, 0.785536f, 0.469970f, 
		0.785536f, 0.469970f, 0.785717f, 0.465161f, 
		0.0734290f, 0.508725f, 0.489715f, 0.163350f, 
		0.485458f, 0.158260f, 0.484709f, 0.167389f, 
		0.887351f, 0.454049f, 0.986988f, 0.539008f, 
		0.882719f, 0.452684f, 0.884494f, 0.454337f, 
		0.988236f, 0.543197f, 0.883479f, 0.456764f, 
		0.991921f, 0.537703f, 0.991921f, 0.537703f, 
		0.992796f, 0.541865f, 0.992796f, 0.541865f, 
		0.00164400f, 0.382115f, 0.498959f, 0.169058f, 
		0.880530f, 0.462391f, 0.491360f, 0.163876f, 
		0.484729f, 0.167434f, 0.883724f, 0.476512f, 
		0.783970f, 0.474731f, 0.781170f, 0.485164f, 
		0.785027f, 0.487080f, 0.778769f, 0.471065f, 
		0.493766f, 0.168344f, 0.881510f, 0.467650f, 
		0.499165f, 0.165190f, 0.879725f, 0.457162f, 
		0.784781f, 0.443862f, 0.784781f, 0.443862f, 
		0.993724f, 0.529612f, 0.490637f, 0.159371f, 
		0.490637f, 0.159371f, 0.483514f, 0.162366f, 
		0.784120f, 0.475468f, 0.784120f, 0.475468f, 
		0.887757f, 0.473527f, 0.887757f, 0.473527f, 
		0.885657f, 0.456359f, 0.504874f, 0.603684f, 
		0.504874f, 0.603684f, 0.504874f, 0.603684f, 
		0.504874f, 0.603684f, 0.504874f, 0.603684f, 
		0.468560f, 0.160901f, 0.468560f, 0.160901f, 
		0.468560f, 0.160901f, 0.996180f, 0.539163f, 
		0.996180f, 0.539163f, 0.996180f, 0.539163f, 
		0.783581f, 0.453412f, 0.783581f, 0.453412f, 
		0.992385f, 0.539595f, 0.992385f, 0.539595f, 
		0.992310f, 0.537784f, 0.786621f, 0.455714f, 
		0.995898f, 0.537080f, 0.786621f, 0.455714f, 
		0.787506f, 0.451774f, 0.996615f, 0.540935f, 
		0.464787f, 0.160399f, 0.784927f, 0.487468f, 
		0.783960f, 0.486993f, 0.783904f, 0.475098f, 
		0.781144f, 0.485394f, 0.984416f, 0.521067f, 
		0.984416f, 0.521067f, 0.984416f, 0.521067f, 
		0.996459f, 0.541478f, 0.996459f, 0.541478f, 
		0.996459f, 0.541478f, 0.783093f, 0.455734f, 
		0.783093f, 0.455734f, 0.504978f, 0.166339f, 
		0.505488f, 0.166020f, 0.509019f, 0.167247f, 
		0.509019f, 0.167247f, 0.224576f, 0.703462f, 
		0.883794f, 0.462001f, 0.785573f, 0.465032f, 
		0.502280f, 0.163941f, 0.887597f, 0.455655f, 
		0.506916f, 0.166922f, 0.790706f, 0.454716f, 
		0.506916f, 0.166922f, 0.882424f, 0.454954f, 
		0.789506f, 0.460063f, 0.504033f, 0.167123f, 
		0.883785f, 0.462059f, 0.189637f, 0.488768f, 
		0.489724f, 0.167772f, 0.483552f, 0.162860f, 
		0.483552f, 0.162860f, 0.882287f, 0.471583f, 
		0.885588f, 0.485425f, 0.885588f, 0.485425f, 
		0.475598f, 0.157625f, 0.475598f, 0.157625f, 
		0.464733f, 0.160752f, 0.475870f, 0.165936f, 
		0.475870f, 0.165936f, 0.504499f, 0.170435f, 
		0.879382f, 0.453079f, 0.879382f, 0.453079f, 
		0.508193f, 0.171458f, 0.880673f, 0.456830f, 
		0.465742f, 0.156413f, 0.780733f, 0.497232f, 
		0.780733f, 0.497232f, 0.164826f, 0.375750f, 
		0.157388f, 0.755143f, 0.347753f, 0.803571f, 
		0.997793f, 0.552085f, 0.781130f, 0.465994f, 
		0.884516f, 0.456530f, 0.885296f, 0.466550f, 
		0.885689f, 0.466434f, 0.884107f, 0.456739f, 
		0.136284f, 0.337556f, 0.135869f, 0.138710f, 
		0.783904f, 0.475098f, 0.784927f, 0.487468f, 
		0.781060f, 0.485567f, 0.788034f, 0.477638f, 
		0.466215f, 0.156341f, 0.780872f, 0.496967f, 
		0.887295f, 0.453684f, 0.887295f, 0.453684f, 
		0.987989f, 0.541162f, 0.887295f, 0.453684f, 
		0.987989f, 0.541162f, 0.987989f, 0.541162f, 
		0.889134f, 0.465390f, 0.889134f, 0.465390f, 
		0.889134f, 0.465390f, 0.989823f, 0.552817f, 
		0.465036f, 0.164179f, 0.474894f, 0.162167f, 
		0.883832f, 0.476422f, 0.890005f, 0.495874f, 
		0.888257f, 0.460846f, 0.780564f, 0.466586f, 
		0.780564f, 0.466586f, 0.883489f, 0.456822f, 
		0.784237f, 0.453723f, 0.989056f, 0.540717f, 
		0.989056f, 0.540717f, 0.995371f, 0.547555f, 
		0.993797f, 0.552122f, 0.892404f, 0.482569f, 
		0.889575f, 0.483461f, 0.891255f, 0.476234f, 
		0.890588f, 0.488766f, 0.898457f, 0.500462f, 
		0.885479f, 0.485480f, 0.890845f, 0.497148f, 
		0.464714f, 0.164443f, 0.890845f, 0.497148f, 
		0.890006f, 0.479480f, 0.890006f, 0.479480f, 
		0.780105f, 0.468462f, 0.780105f, 0.468462f, 
		0.780105f, 0.468462f, 0.996803f, 0.547464f, 
		0.782149f, 0.461625f, 0.744576f, 0.615166f, 
		0.744576f, 0.615166f, 0.744576f, 0.615166f, 
		0.212210f, 0.462610f, 0.744047f, 0.620461f, 
		0.743966f, 0.620689f, 0.743712f, 0.621218f, 
		0.786144f, 0.460590f, 0.785314f, 0.466402f, 
		0.789414f, 0.472565f, 0.779085f, 0.468520f, 
		0.789789f, 0.468827f, 0.989645f, 0.551280f, 
		0.989645f, 0.551280f, 0.348170f, 0.795575f, 
		0.888841f, 0.463695f, 0.888841f, 0.463695f, 
		0.884174f, 0.461998f, 0.885569f, 0.468223f, 
		0.885569f, 0.468223f, 0.886845f, 0.473736f, 
		0.886845f, 0.473736f, 0.884174f, 0.461998f, 
		0.887644f, 0.456046f, 0.988528f, 0.543556f, 
		0.887644f, 0.456046f, 0.988528f, 0.543556f, 
		0.778322f, 0.496947f, 0.778322f, 0.496947f, 
		0.779140f, 0.492707f, 0.888052f, 0.460874f, 
		0.888052f, 0.460874f, 0.989737f, 0.548353f, 
		0.888052f, 0.460874f, 0.989737f, 0.548353f, 
		0.989737f, 0.548353f, 0.886126f, 0.485166f, 
		0.886126f, 0.485166f, 0.898428f, 0.500533f, 
		0.894872f, 0.500277f, 0.887722f, 0.487928f, 
		0.779139f, 0.471512f, 0.787575f, 0.478540f, 
		0.787575f, 0.478540f, 0.779770f, 0.471801f, 
		0.784676f, 0.487068f, 0.0166590f, 0.240093f, 
		0.0166590f, 0.240093f, 0.00957700f, 0.542688f, 
		0.0166590f, 0.240093f, 0.992319f, 0.539824f, 
		0.992319f, 0.539824f, 0.992319f, 0.539824f, 
		0.992319f, 0.539824f, 0.992319f, 0.539824f, 
		0.750986f, 0.411378f, 0.112611f, 0.903180f, 
		0.889419f, 0.483508f, 0.885601f, 0.485419f, 
		0.889496f, 0.485407f, 0.890849f, 0.494249f, 
		0.779740f, 0.497439f, 0.779740f, 0.497439f, 
		0.779170f, 0.492907f, 0.779170f, 0.492907f, 
		0.779170f, 0.492907f, 0.174007f, 0.507370f, 
		0.0267040f, 0.311397f, 0.745335f, 0.621458f, 
		0.890066f, 0.465377f, 0.990817f, 0.552620f, 
		0.745969f, 0.620649f, 0.885958f, 0.470285f, 
		0.889665f, 0.482395f, 0.780809f, 0.465663f, 
		0.996244f, 0.551332f, 0.996244f, 0.551332f, 
		0.347564f, 0.802153f, 0.347564f, 0.802153f, 
		0.780809f, 0.465663f, 0.887521f, 0.455989f, 
		0.887521f, 0.455989f, 0.888993f, 0.465332f, 
		0.990036f, 0.552927f, 0.773097f, 0.471575f, 
		0.784638f, 0.469726f, 0.784638f, 0.469726f, 
		0.778825f, 0.471493f, 0.778825f, 0.471493f, 
		0.778825f, 0.471493f, 0.994455f, 0.547428f, 
		0.461654f, 0.159987f, 0.465139f, 0.156246f, 
		0.474626f, 0.161672f, 0.464128f, 0.164464f, 
		0.739671f, 0.621152f, 0.739717f, 0.621058f, 
		0.739671f, 0.621152f, 0.779101f, 0.466651f, 
		0.779101f, 0.466651f, 0.346715f, 0.803192f, 
		0.891628f, 0.470643f, 0.0483150f, 0.174751f, 
		0.743320f, 0.621616f, 0.347191f, 0.800602f, 
		0.993691f, 0.552125f, 0.992715f, 0.545100f, 
		0.741617f, 0.605317f, 0.746329f, 0.604345f, 
		0.746497f, 0.604460f, 0.746497f, 0.604460f, 
		0.746497f, 0.604460f, 0.461816f, 0.156724f, 
		0.461816f, 0.156724f, 0.779406f, 0.492699f, 
		0.465157f, 0.160147f, 0.465157f, 0.160147f, 
		0.779406f, 0.492699f, 0.778352f, 0.501395f, 
		0.461604f, 0.159765f, 0.460587f, 0.159771f, 
		0.458929f, 0.159578f, 0.784842f, 0.487522f, 
		0.787866f, 0.477537f, 0.781215f, 0.485649f, 
		0.782448f, 0.462046f, 0.780533f, 0.468665f, 
		0.346381f, 0.802932f, 0.993874f, 0.550951f, 
		0.104664f, 0.794599f, 0.316390f, 0.198262f, 
		0.785136f, 0.469557f, 0.773039f, 0.471879f, 
		0.773247f, 0.467563f, 0.779114f, 0.468560f, 
		0.0319600f, 0.534036f, 0.739104f, 0.620282f, 
		0.777591f, 0.465431f, 0.744161f, 0.604360f, 
		0.744161f, 0.604360f, 0.744161f, 0.604360f, 
		0.892229f, 0.465298f, 0.892229f, 0.465298f, 
		0.747567f, 0.621444f, 0.892229f, 0.465298f, 
		0.740924f, 0.611669f, 0.776553f, 0.457940f, 
		0.346390f, 0.797094f, 0.891567f, 0.466246f, 
		0.746754f, 0.621596f, 0.112872f, 0.290250f, 
		0.475754f, 0.166011f, 0.885491f, 0.485508f, 
		0.464524f, 0.160636f, 0.897862f, 0.497669f, 
		0.890089f, 0.496552f, 0.892947f, 0.499973f, 
		0.890996f, 0.467661f, 0.346412f, 0.796796f, 
		0.346412f, 0.796796f, 0.887892f, 0.461651f, 
		0.989716f, 0.548751f, 0.777873f, 0.502313f, 
		0.460833f, 0.156737f, 0.458737f, 0.156814f, 
		0.777089f, 0.504433f, 0.777089f, 0.504433f, 
		0.778649f, 0.469202f, 0.346345f, 0.803048f, 
		0.778649f, 0.469202f, 0.739634f, 0.621323f, 
		0.778649f, 0.469202f, 0.888110f, 0.473778f, 
		0.891399f, 0.492061f, 0.888110f, 0.473778f, 
		0.891323f, 0.491571f, 0.460945f, 0.159987f, 
		0.892949f, 0.503069f, 0.458477f, 0.162632f, 
		0.893381f, 0.502968f, 0.745542f, 0.609869f, 
		0.745542f, 0.609869f, 0.745542f, 0.609869f, 
		0.778378f, 0.490850f, 0.754130f, 0.584849f, 
		0.891179f, 0.426978f, 0.754130f, 0.584849f, 
		0.754130f, 0.584849f, 0.754130f, 0.584849f, 
		0.346573f, 0.799602f, 0.346573f, 0.799602f, 
		0.997425f, 0.552311f, 0.993179f, 0.547862f, 
		0.993179f, 0.547862f, 0.889165f, 0.484105f, 
		0.890278f, 0.494516f, 0.889716f, 0.493146f, 
		0.889872f, 0.495529f, 0.748517f, 0.614423f, 
		0.893570f, 0.457770f, 0.0805280f, 0.278382f, 
		0.779929f, 0.496962f, 0.779929f, 0.496962f, 
		0.779287f, 0.492956f, 0.779287f, 0.492956f, 
		0.210616f, 0.426400f, 0.746203f, 0.604163f, 
		0.746203f, 0.604163f, 0.741605f, 0.605236f, 
		0.745481f, 0.606088f, 0.745481f, 0.606088f, 
		0.750575f, 0.605559f, 0.461704f, 0.156536f, 
		0.778218f, 0.501489f, 0.776976f, 0.504646f, 
		0.458526f, 0.156741f, 0.0954660f, 0.900645f, 
		0.846017f, 0.441459f, 0.749408f, 0.608706f, 
		0.749408f, 0.608706f, 0.893923f, 0.453216f, 
		0.893923f, 0.453216f, 0.0457320f, 0.444875f, 
		0.0744340f, 0.825707f, 0.284738f, 0.151338f, 
		0.686306f, 0.475061f, 0.422973f, 0.0184440f, 
		0.422973f, 0.0184440f, 0.000000f, 0.244409f, 
		0.0121010f, 0.533066f, 0.794843f, 0.969012f, 
		0.794843f, 0.969012f, 0.0121010f, 0.533066f, 
		0.370913f, 0.00277900f, 0.00873000f, 0.187489f, 
		0.00873000f, 0.187489f, 0.00873000f, 0.187489f, 
		0.464998f, 0.156418f, 0.776991f, 0.504677f, 
		0.458499f, 0.156845f, 0.780252f, 0.498192f, 
		0.780252f, 0.498192f, 0.889856f, 0.483267f, 
		0.897379f, 0.472541f, 0.893745f, 0.482673f, 
		0.745807f, 0.606199f, 0.897660f, 0.451584f, 
		0.897660f, 0.451584f, 0.893354f, 0.449138f, 
		0.750587f, 0.605640f, 0.893354f, 0.449138f, 
		0.166092f, 0.339780f, 0.742378f, 0.603257f, 
		0.772947f, 0.448513f, 0.742118f, 0.603371f, 
		0.742118f, 0.603371f, 0.776752f, 0.448531f, 
		0.775612f, 0.500766f, 0.439465f, 0.968539f, 
		0.491336f, 0.544120f, 0.491336f, 0.544120f, 
		0.491336f, 0.544120f, 0.491336f, 0.544120f, 
		0.491336f, 0.544120f, 0.459601f, 0.0458630f, 
		0.459601f, 0.0458630f, 0.812621f, 0.929554f, 
		0.782822f, 0.472673f, 0.778671f, 0.468602f, 
		0.779076f, 0.468599f, 0.779076f, 0.468599f, 
		0.773304f, 0.467602f, 0.458798f, 0.162774f, 
		0.464696f, 0.159903f, 0.461064f, 0.159822f, 
		0.458602f, 0.159630f, 0.458798f, 0.162774f, 
		0.740533f, 0.613306f, 0.740533f, 0.613306f, 
		0.777114f, 0.458462f, 0.777114f, 0.458462f, 
		0.0254520f, 0.388613f, 0.590277f, 0.535758f, 
		0.780290f, 0.498151f, 0.771643f, 0.498993f, 
		0.773106f, 0.497269f, 0.775327f, 0.494290f, 
		0.780786f, 0.466492f, 0.785128f, 0.469363f, 
		0.773143f, 0.467250f, 0.778571f, 0.471195f, 
		0.0867650f, 0.898083f, 0.858257f, 0.440048f, 
		0.889058f, 0.465456f, 0.891379f, 0.469494f, 
		0.893169f, 0.482560f, 0.897075f, 0.469459f, 
		0.892841f, 0.465070f, 0.893135f, 0.453823f, 
		0.893135f, 0.453823f, 0.749522f, 0.610502f, 
		0.894784f, 0.484248f, 0.894784f, 0.484248f, 
		0.894784f, 0.484248f, 0.893327f, 0.459618f, 
		0.746226f, 0.621376f, 0.890090f, 0.466548f, 
		0.348107f, 0.795821f, 0.891129f, 0.466136f, 
		0.458757f, 0.159846f, 0.897990f, 0.503391f, 
		0.461101f, 0.163511f, 0.898321f, 0.503284f, 
		0.897777f, 0.451617f, 0.897777f, 0.451617f, 
		0.745698f, 0.606139f, 0.750172f, 0.607555f, 
		0.893184f, 0.450852f, 0.902840f, 0.449613f, 
		0.778161f, 0.501684f, 0.461511f, 0.156720f, 
		0.458606f, 0.156884f, 0.777033f, 0.504627f, 
		0.740797f, 0.614734f, 0.740045f, 0.621260f, 
		0.778955f, 0.466864f, 0.778955f, 0.466864f, 
		0.347415f, 0.802902f, 0.347415f, 0.802902f, 
		0.347415f, 0.802902f, 0.772970f, 0.463297f, 
		0.772970f, 0.463297f, 0.893777f, 0.431213f, 
		0.758856f, 0.589296f, 0.893777f, 0.431213f, 
		0.893777f, 0.431213f, 0.772623f, 0.448449f, 
		0.742056f, 0.603275f, 0.745895f, 0.604114f, 
		0.772693f, 0.450477f, 0.145765f, 0.299303f, 
		0.00566900f, 0.333124f, 0.000000f, 0.439063f, 
		0.549288f, 0.553368f, 0.215602f, 0.496448f, 
		0.776276f, 0.431685f, 0.747642f, 0.586528f, 
		0.747642f, 0.586528f, 0.776276f, 0.431685f, 
		0.744795f, 0.616608f, 0.744837f, 0.620089f, 
		0.744837f, 0.620089f, 0.740987f, 0.614631f, 
		0.0485580f, 0.382727f, 0.891234f, 0.511590f, 
		0.449757f, 0.162967f, 0.449757f, 0.162967f, 
		0.891234f, 0.511590f, 0.892489f, 0.471315f, 
		0.892489f, 0.471315f, 0.897694f, 0.482636f, 
		0.887363f, 0.475045f, 0.892489f, 0.471315f, 
		0.149502f, 0.531123f, 0.00133200f, 0.289707f, 
		0.00596200f, 0.486361f, 0.892232f, 0.500915f, 
		0.895975f, 0.503141f, 0.453593f, 0.156925f, 
		0.453593f, 0.156925f, 0.777799f, 0.509399f, 
		0.0464700f, 0.270036f, 0.773747f, 0.498467f, 
		0.779241f, 0.493601f, 0.775678f, 0.494276f, 
		0.878963f, 0.434323f, 0.316390f, 0.636433f, 
		0.897888f, 0.449660f, 0.893681f, 0.451070f, 
		0.749670f, 0.607213f, 0.749670f, 0.607213f, 
		0.743332f, 0.604173f, 0.750503f, 0.605955f, 
		0.750503f, 0.605955f, 0.745266f, 0.605747f, 
		0.745266f, 0.605747f, 0.892799f, 0.464986f, 
		0.896943f, 0.459327f, 0.745263f, 0.615181f, 
		0.774658f, 0.465628f, 0.186464f, 0.366700f, 
		0.896225f, 0.451714f, 0.896637f, 0.451129f, 
		0.896225f, 0.451714f, 0.897627f, 0.452213f, 
		0.897627f, 0.452213f, 0.745647f, 0.607096f, 
		0.745647f, 0.607096f, 0.896892f, 0.459043f, 
		0.896892f, 0.459043f, 0.896892f, 0.459043f, 
		0.896892f, 0.459043f, 0.896892f, 0.459043f, 
		0.896919f, 0.465354f, 0.772872f, 0.471376f, 
		0.772872f, 0.471376f, 0.772872f, 0.471376f, 
		0.772872f, 0.471376f, 0.386061f, 0.0180360f, 
		0.386061f, 0.0180360f, 0.386061f, 0.0180360f, 
		0.386061f, 0.0180360f, 0.386061f, 0.0180360f, 
		0.386061f, 0.0180360f, 0.386061f, 0.0180360f, 
		0.386061f, 0.0180360f, 0.749429f, 0.608982f, 
		0.741864f, 0.607104f, 0.741864f, 0.607104f, 
		0.894738f, 0.449907f, 0.894738f, 0.449907f, 
		0.901470f, 0.449746f, 0.901470f, 0.449746f, 
		0.772799f, 0.471750f, 0.778437f, 0.471178f, 
		0.778707f, 0.468478f, 0.767271f, 0.470412f, 
		0.898381f, 0.501759f, 0.898381f, 0.501759f, 
		0.898381f, 0.501759f, 0.898381f, 0.501759f, 
		0.925567f, 0.368271f, 0.898381f, 0.501759f, 
		0.739054f, 0.620733f, 0.773233f, 0.458450f, 
		0.745117f, 0.614743f, 0.745117f, 0.614743f, 
		0.879816f, 0.948706f, 0.880970f, 0.946084f, 
		0.897044f, 0.466596f, 0.897044f, 0.466596f, 
		0.897044f, 0.466596f, 0.897044f, 0.466596f, 
		0.897044f, 0.466596f, 0.907038f, 0.499397f, 
		0.898454f, 0.497907f, 0.772929f, 0.470319f, 
		0.772929f, 0.470319f, 0.772929f, 0.470319f, 
		0.897570f, 0.469796f, 0.772012f, 0.502292f, 
		0.766739f, 0.503419f, 0.771780f, 0.504826f, 
		0.771780f, 0.504826f, 0.771780f, 0.504826f, 
		0.771780f, 0.504826f, 0.771780f, 0.504826f, 
		0.896064f, 0.449363f, 0.896064f, 0.449363f, 
		0.899126f, 0.449648f, 0.899126f, 0.449648f, 
		0.894418f, 0.450198f, 0.896291f, 0.421667f, 
		0.896291f, 0.421667f, 0.896291f, 0.421667f, 
		0.462687f, 0.796634f, 0.757991f, 0.578671f, 
		0.757991f, 0.578671f, 0.772807f, 0.453035f, 
		0.898510f, 0.497639f, 0.907266f, 0.499309f, 
		0.905014f, 0.501546f, 0.890405f, 0.497276f, 
		0.764880f, 0.502987f, 0.771708f, 0.502186f, 
		0.771956f, 0.504974f, 0.771708f, 0.502186f, 
		0.771545f, 0.501914f, 0.771545f, 0.501914f, 
		0.771545f, 0.501914f, 0.926104f, 0.380661f, 
		0.767575f, 0.494285f, 0.771831f, 0.498983f, 
		0.772132f, 0.498065f, 0.772132f, 0.498065f, 
		0.772244f, 0.461937f, 0.426627f, 0.0376620f, 
		0.426627f, 0.0376620f, 0.426627f, 0.0376620f, 
		0.426627f, 0.0376620f, 0.443436f, 0.951267f, 
		0.443436f, 0.951267f, 0.430697f, 0.0405440f, 
		0.426627f, 0.0376620f, 0.771597f, 0.448623f, 
		0.776955f, 0.448394f, 0.772352f, 0.448755f, 
		0.772735f, 0.459844f, 0.772735f, 0.459844f, 
		0.772735f, 0.459844f, 0.898093f, 0.450007f, 
		0.898093f, 0.450007f, 0.896660f, 0.450079f, 
		0.898093f, 0.450007f, 0.777101f, 0.452502f, 
		0.745741f, 0.604829f, 0.775016f, 0.449691f, 
		0.745741f, 0.604829f, 0.775016f, 0.449691f, 
		0.745741f, 0.604829f, 0.428786f, 0.961852f, 
		0.428786f, 0.961852f, 0.489676f, 0.527129f, 
		0.968116f, 0.792318f, 0.890774f, 0.497333f, 
		0.898678f, 0.500538f, 0.890578f, 0.497256f, 
		0.905103f, 0.501499f, 0.897042f, 0.459421f, 
		0.897042f, 0.459421f, 0.897042f, 0.459421f, 
		0.896962f, 0.467891f, 0.896962f, 0.467891f, 
		0.891979f, 0.500172f, 0.898472f, 0.500693f, 
		0.898665f, 0.503601f, 0.218424f, 0.369434f, 
		0.218424f, 0.369434f, 0.897397f, 0.431847f, 
		0.303219f, 0.630702f, 0.160061f, 0.105044f, 
		0.767116f, 0.470176f, 0.773797f, 0.467898f, 
		0.767509f, 0.470397f, 0.778636f, 0.468585f, 
		0.772580f, 0.458174f, 0.772580f, 0.458174f, 
		0.778589f, 0.468023f, 0.778589f, 0.468023f, 
		0.778589f, 0.468023f, 0.767234f, 0.468067f, 
		0.773103f, 0.471841f, 0.772681f, 0.463957f, 
		0.163764f, 0.876063f, 0.401625f, 0.0297640f, 
		0.401625f, 0.0297640f, 0.401625f, 0.0297640f, 
		0.903359f, 0.470897f, 0.891588f, 0.467798f, 
		0.896859f, 0.465022f, 0.897508f, 0.471452f, 
		0.899124f, 0.502525f, 0.892366f, 0.501418f, 
		0.899468f, 0.497788f, 0.899468f, 0.497788f, 
		0.899124f, 0.502525f, 0.899124f, 0.502525f, 
		0.898562f, 0.503724f, 0.898562f, 0.503724f, 
		0.776959f, 0.448329f, 0.767576f, 0.449074f, 
		0.767703f, 0.451225f, 0.777011f, 0.450486f, 
		0.902662f, 0.483352f, 0.902431f, 0.483324f, 
		0.893605f, 0.482508f, 0.443436f, 0.932811f, 
		0.522014f, 0.527158f, 0.898152f, 0.452018f, 
		0.898152f, 0.452018f, 0.897900f, 0.451848f, 
		0.898152f, 0.452018f, 0.766353f, 0.505048f, 
		0.771751f, 0.502700f, 0.766353f, 0.505048f, 
		0.771900f, 0.499020f, 0.771751f, 0.502700f, 
		0.771936f, 0.504908f, 0.897866f, 0.449602f, 
		0.897866f, 0.449602f, 0.897866f, 0.449602f, 
		0.897866f, 0.449602f, 0.897866f, 0.449602f, 
		0.897574f, 0.456495f, 0.896875f, 0.464965f, 
		0.902281f, 0.453895f, 0.893345f, 0.456473f, 
		0.896875f, 0.464965f, 0.222477f, 0.366565f, 
		0.222477f, 0.366565f, 0.897798f, 0.482956f, 
		0.898579f, 0.482007f, 0.897286f, 0.479446f, 
		0.775399f, 0.494337f, 0.763122f, 0.498219f, 
		0.771704f, 0.501955f, 0.764416f, 0.495103f, 
		0.775024f, 0.494742f, 0.772846f, 0.463303f, 
		0.775886f, 0.450537f, 0.745325f, 0.608740f, 
		0.774839f, 0.454735f, 0.772642f, 0.456698f, 
		0.745325f, 0.608740f, 0.467600f, 0.797872f, 
		0.753931f, 0.576662f, 0.772523f, 0.421539f, 
		0.772523f, 0.421539f, 0.217266f, 0.359998f, 
		0.217266f, 0.359998f, 0.221961f, 0.359075f, 
		0.221961f, 0.359075f, 0.902675f, 0.449941f, 
		0.893298f, 0.449264f, 0.902754f, 0.449960f, 
		0.902754f, 0.449960f, 0.176169f, 0.306602f, 
		0.776900f, 0.450404f, 0.768840f, 0.450870f, 
		0.0734290f, 0.508725f, 0.204051f, 0.380977f, 
		0.0650600f, 0.322394f, 0.463496f, 0.0623380f, 
		0.873789f, 0.964410f, 0.866556f, 0.942684f, 
		0.522624f, 0.927623f, 0.244795f, 0.461961f, 
		0.215867f, 0.402643f, 0.771251f, 0.429506f, 
		0.771251f, 0.429506f, 0.771251f, 0.429506f, 
		0.769238f, 0.501564f, 0.462991f, 0.625314f, 
		0.968116f, 0.419919f, 0.455941f, 0.926883f, 
		0.455941f, 0.926883f, 0.968116f, 0.419919f, 
		0.495275f, 0.684321f, 0.495275f, 0.684321f, 
		0.495275f, 0.684321f, 0.899517f, 0.429339f, 
		0.899517f, 0.429339f, 0.899517f, 0.429339f, 
		0.899517f, 0.429339f, 0.899517f, 0.429339f, 
		0.904401f, 0.367777f, 0.896421f, 0.524883f, 
		0.196986f, 0.360372f, 0.123467f, 0.253394f, 
		0.123467f, 0.253394f, 0.123467f, 0.253394f, 
		0.123467f, 0.253394f, 0.123467f, 0.253394f, 
		0.222933f, 0.377287f, 0.222933f, 0.377287f, 
		0.901602f, 0.470734f, 0.458024f, 0.559602f, 
		0.987524f, 0.751634f, 0.458024f, 0.559602f, 
		0.190724f, 0.911151f, 0.190724f, 0.911151f, 
		0.190724f, 0.911151f, 0.813082f, 0.625885f, 
		0.813082f, 0.625885f, 0.768950f, 0.452818f, 
		0.812070f, 0.614974f, 0.768750f, 0.449059f, 
		0.768486f, 0.459733f, 0.429643f, 0.922305f, 
		0.975807f, 0.802502f, 0.173634f, 0.873112f, 
		0.173634f, 0.873112f, 0.210001f, 0.374401f, 
		0.210001f, 0.374401f, 0.120582f, 0.560358f, 
		0.812313f, 0.619362f, 0.769089f, 0.464644f, 
		0.810061f, 0.627616f, 0.768605f, 0.453344f, 
		0.534845f, 0.697272f, 0.643259f, 0.531426f, 
		0.812423f, 0.616825f, 0.812423f, 0.616825f, 
		0.767690f, 0.451063f, 0.811906f, 0.615124f, 
		0.811906f, 0.615124f, 0.772301f, 0.450306f, 
		0.772301f, 0.450306f, 0.0122850f, 0.431681f, 
		0.0122850f, 0.431681f, 0.793797f, 0.886493f, 
		0.555529f, 0.572890f, 0.500326f, 0.0903270f, 
		0.772585f, 0.468745f, 0.772585f, 0.468745f, 
		0.760417f, 0.473268f, 0.768532f, 0.470487f, 
		0.768532f, 0.470487f, 0.768532f, 0.470487f, 
		0.168703f, 0.876113f, 0.168703f, 0.876113f, 
		0.168703f, 0.876113f, 0.395589f, 0.0376070f, 
		0.901547f, 0.464612f, 0.806208f, 0.632135f, 
		0.901547f, 0.464612f, 0.383377f, 0.795747f, 
		0.450151f, 0.0629120f, 0.450151f, 0.0629120f, 
		0.450151f, 0.0629120f, 0.450151f, 0.0629120f, 
		0.450151f, 0.0629120f, 0.450151f, 0.0629120f, 
		0.226287f, 0.373616f, 0.226287f, 0.373616f, 
		0.901496f, 0.459836f, 0.901496f, 0.459836f, 
		0.805937f, 0.627438f, 0.903333f, 0.467130f, 
		0.382279f, 0.799534f, 0.903798f, 0.465374f, 
		0.367919f, 0.876992f, 0.367919f, 0.876992f, 
		0.191768f, 0.745687f, 0.382483f, 0.796161f, 
		0.902383f, 0.464295f, 0.902383f, 0.464295f, 
		0.382483f, 0.796161f, 0.806005f, 0.631405f, 
		0.902383f, 0.464295f, 0.0416000f, 0.950074f, 
		0.369808f, 0.895001f, 0.180739f, 0.730189f, 
		0.902306f, 0.453901f, 0.804515f, 0.621449f, 
		0.901386f, 0.464811f, 0.806263f, 0.632334f, 
		0.806263f, 0.632334f, 0.898009f, 0.451618f, 
		0.898009f, 0.451618f, 0.803983f, 0.619233f, 
		0.803983f, 0.619233f, 0.803520f, 0.617465f, 
		0.803520f, 0.617465f, 0.901928f, 0.451639f, 
		0.901592f, 0.451274f, 0.392926f, 0.162202f, 
		0.392926f, 0.162202f, 0.392926f, 0.162202f, 
		0.883300f, 0.568420f, 0.392926f, 0.162202f, 
		0.883300f, 0.568420f, 0.767557f, 0.494282f, 
		0.771205f, 0.498923f, 0.766910f, 0.495272f, 
		0.766739f, 0.494238f, 0.812319f, 0.617045f, 
		0.772133f, 0.448470f, 0.772193f, 0.450649f, 
		0.811897f, 0.614852f, 0.764766f, 0.495764f, 
		0.764290f, 0.494767f, 0.763981f, 0.495029f, 
		0.763076f, 0.499785f, 0.809425f, 0.620524f, 
		0.809425f, 0.620524f, 0.809425f, 0.620524f, 
		0.812637f, 0.626322f, 0.812637f, 0.626322f, 
		0.809965f, 0.631872f, 0.0923910f, 0.243412f, 
		0.226667f, 0.362933f, 0.226667f, 0.362933f, 
		0.382511f, 0.804054f, 0.382511f, 0.804054f, 
		0.814261f, 0.631856f, 0.767400f, 0.468556f, 
		0.767128f, 0.500317f, 0.812987f, 0.624124f, 
		0.768196f, 0.458363f, 0.897822f, 0.482959f, 
		0.907025f, 0.485242f, 0.903505f, 0.471049f, 
		0.394493f, 0.156953f, 0.903849f, 0.503736f, 
		0.925296f, 0.371292f, 0.925296f, 0.371292f, 
		0.925296f, 0.371292f, 0.925296f, 0.371292f, 
		0.216827f, 0.392321f, 0.925671f, 0.374303f, 
		0.904904f, 0.501799f, 0.925671f, 0.374303f, 
		0.903583f, 0.503959f, 0.768436f, 0.460383f, 
		0.810215f, 0.631769f, 0.810215f, 0.631769f, 
		0.381355f, 0.799950f, 0.767452f, 0.467675f, 
		0.382047f, 0.803126f, 0.381243f, 0.804641f, 
		0.925684f, 0.374524f, 0.771506f, 0.504748f, 
		0.771506f, 0.504748f, 0.771587f, 0.504969f, 
		0.925684f, 0.374524f, 0.226394f, 0.357141f, 
		0.226394f, 0.357141f, 0.809827f, 0.626446f, 
		0.809827f, 0.626446f, 0.808163f, 0.615990f, 
		0.807703f, 0.616117f, 0.901396f, 0.459697f, 
		0.806210f, 0.627226f, 0.898179f, 0.450349f, 
		0.804056f, 0.618728f, 0.902599f, 0.451586f, 
		0.803539f, 0.617149f, 0.814143f, 0.631673f, 
		0.809483f, 0.626650f, 0.383456f, 0.795820f, 
		0.381357f, 0.799571f, 0.897409f, 0.471811f, 
		0.909195f, 0.473997f, 0.902839f, 0.483555f, 
		0.382257f, 0.799603f, 0.809984f, 0.630569f, 
		0.772211f, 0.448548f, 0.812313f, 0.616944f, 
		0.811946f, 0.615040f, 0.767906f, 0.449314f, 
		0.766717f, 0.468084f, 0.772485f, 0.471866f, 
		0.759813f, 0.469308f, 0.766974f, 0.468209f, 
		0.814045f, 0.631619f, 0.814045f, 0.631619f, 
		0.768311f, 0.465609f, 0.768311f, 0.465609f, 
		0.382436f, 0.803522f, 0.382418f, 0.803904f, 
		0.224020f, 0.346386f, 0.224020f, 0.346386f, 
		0.224020f, 0.346386f, 0.224020f, 0.346386f, 
		0.901568f, 0.459724f, 0.805910f, 0.626996f, 
		0.901568f, 0.459724f, 0.805910f, 0.626996f, 
		0.897816f, 0.471849f, 0.909254f, 0.473842f, 
		0.903265f, 0.467276f, 0.760838f, 0.473516f, 
		0.772999f, 0.467667f, 0.767146f, 0.468176f, 
		0.759847f, 0.469235f, 0.759847f, 0.469235f, 
		0.219180f, 0.344824f, 0.219180f, 0.344824f, 
		0.759576f, 0.468881f, 0.766838f, 0.470224f, 
		0.772829f, 0.468068f, 0.768273f, 0.466044f, 
		0.383013f, 0.803768f, 0.766393f, 0.505573f, 
		0.926126f, 0.377685f, 0.926126f, 0.377685f, 
		0.768045f, 0.505366f, 0.766426f, 0.505576f, 
		0.925540f, 0.377315f, 0.797246f, 0.893468f, 
		0.797246f, 0.893468f, 0.478637f, 0.0828120f, 
		0.478637f, 0.0828120f, 0.275362f, 0.907371f, 
		0.205572f, 0.359844f, 0.205572f, 0.359844f, 
		0.926357f, 0.377336f, 0.926357f, 0.377336f, 
		0.925958f, 0.371258f, 0.925958f, 0.371258f, 
		0.927999f, 0.374077f, 0.927999f, 0.374077f, 
		0.808724f, 0.618092f, 0.808053f, 0.618323f, 
		0.808425f, 0.616772f, 0.807698f, 0.617002f, 
		0.767015f, 0.467672f, 0.381916f, 0.805020f, 
		0.381916f, 0.805020f, 0.218917f, 0.383778f, 
		0.218917f, 0.383778f, 0.804036f, 0.619279f, 
		0.897971f, 0.451585f, 0.897971f, 0.451585f, 
		0.803442f, 0.617369f, 0.902389f, 0.449822f, 
		0.0673450f, 0.777156f, 0.904130f, 0.494100f, 
		0.925376f, 0.371341f, 0.925376f, 0.371341f, 
		0.904989f, 0.501549f, 0.904989f, 0.501549f, 
		0.925313f, 0.371758f, 0.903506f, 0.503924f, 
		0.973998f, 0.404576f, 0.457342f, 0.918451f, 
		0.391294f, 0.0262020f, 0.0248990f, 0.940635f, 
		0.391294f, 0.0262020f, 0.378911f, 0.796452f, 
		0.381339f, 0.803082f, 0.381811f, 0.799470f, 
		0.382151f, 0.799610f, 0.903533f, 0.465374f, 
		0.903533f, 0.465374f, 0.365755f, 0.799715f, 
		0.457437f, 0.993386f, 0.972590f, 0.486970f, 
		0.0663400f, 0.962953f, 0.450022f, 0.0759820f, 
		0.450022f, 0.0759820f, 0.230180f, 0.361874f, 
		0.230180f, 0.361874f, 0.901538f, 0.464916f, 
		0.910166f, 0.469746f, 0.903328f, 0.470878f, 
		0.906473f, 0.465516f, 0.774345f, 0.534060f, 
		0.897061f, 0.383950f, 0.924285f, 0.376847f, 
		0.924285f, 0.376847f, 0.924285f, 0.376847f, 
		0.924285f, 0.376847f, 0.924285f, 0.376847f, 
		0.766402f, 0.505618f, 0.924285f, 0.376847f, 
		0.212210f, 0.529236f, 0.869523f, 0.366529f, 
		0.893322f, 0.559761f, 0.869523f, 0.366529f, 
		0.893322f, 0.559761f, 0.893322f, 0.559761f, 
		0.903323f, 0.504020f, 0.928458f, 0.373512f, 
		0.928458f, 0.373512f, 0.906801f, 0.499629f, 
		0.812413f, 0.619126f, 0.812413f, 0.619126f, 
		0.768059f, 0.453191f, 0.768059f, 0.453191f, 
		0.0354610f, 0.930563f, 0.394757f, 0.0388310f, 
		0.394757f, 0.0388310f, 0.975475f, 0.425030f, 
		0.809995f, 0.631795f, 0.381452f, 0.799066f, 
		0.382077f, 0.800751f, 0.0946810f, 0.435534f, 
		0.812891f, 0.625780f, 0.768479f, 0.459860f, 
		0.808442f, 0.618137f, 0.808442f, 0.618137f, 
		0.807892f, 0.616237f, 0.807892f, 0.616237f, 
		0.927671f, 0.370578f, 0.928178f, 0.378021f, 
		0.925410f, 0.374352f, 0.157521f, 0.797805f, 
		0.143592f, 0.796960f, 0.398724f, 0.834757f, 
		0.398724f, 0.834757f, 0.143592f, 0.796960f, 
		0.229602f, 0.368649f, 0.229602f, 0.368649f, 
		0.229943f, 0.356288f, 0.229943f, 0.356288f, 
		0.903458f, 0.444159f, 0.800914f, 0.611756f, 
		0.800914f, 0.611756f, 0.800914f, 0.611756f, 
		0.903458f, 0.444159f, 0.903458f, 0.444159f, 
		0.928185f, 0.377807f, 0.765140f, 0.503062f, 
		0.928185f, 0.377807f, 0.765140f, 0.503062f, 
		0.0805280f, 0.278382f, 0.0631960f, 0.236005f, 
		0.381365f, 0.803587f, 0.379838f, 0.803149f, 
		0.381365f, 0.803587f, 0.381014f, 0.803883f, 
		0.381014f, 0.803883f, 0.543233f, 0.141614f, 
		0.601124f, 0.567969f, 0.543233f, 0.141614f, 
		0.904431f, 0.465836f, 0.380434f, 0.796478f, 
		0.902379f, 0.451977f, 0.803792f, 0.619243f, 
		0.902409f, 0.451638f, 0.804156f, 0.619585f, 
		0.767677f, 0.494864f, 0.762462f, 0.498503f, 
		0.763046f, 0.499654f, 0.757361f, 0.486395f, 
		0.808938f, 0.602621f, 0.766275f, 0.436860f, 
		0.766275f, 0.436860f, 0.766275f, 0.436860f, 
		0.808938f, 0.602621f, 0.381105f, 0.799331f, 
		0.379505f, 0.804362f, 0.932823f, 0.629732f, 
		0.925551f, 0.624473f, 0.232369f, 0.365794f, 
		0.232369f, 0.365794f, 0.232369f, 0.365794f, 
		0.232369f, 0.365794f, 0.905535f, 0.501371f, 
		0.927861f, 0.370656f, 0.905535f, 0.501371f, 
		0.200623f, 0.338545f, 0.806729f, 0.618603f, 
		0.807855f, 0.618116f, 0.808682f, 0.618110f, 
		0.807827f, 0.616661f, 0.807827f, 0.616661f, 
		0.158210f, 0.263145f, 0.929305f, 0.629460f, 
		0.379875f, 0.799422f, 0.900805f, 0.498002f, 
		0.901168f, 0.500408f, 0.894033f, 0.666397f, 
		0.912942f, 0.486314f, 0.912942f, 0.486314f, 
		0.930436f, 0.373123f, 0.904271f, 0.500772f, 
		0.904271f, 0.500772f, 0.912833f, 0.486796f, 
		0.898867f, 0.500522f, 0.809589f, 0.626067f, 
		0.809589f, 0.626067f, 0.809589f, 0.626067f, 
		0.199926f, 0.315032f, 0.0966520f, 0.732281f, 
		0.771038f, 0.498658f, 0.762134f, 0.484376f, 
		0.757075f, 0.486503f, 0.762758f, 0.499819f, 
		0.904066f, 0.429832f, 0.793882f, 0.597429f, 
		0.764975f, 0.490320f, 0.391926f, 0.151501f, 
		0.391926f, 0.151501f, 0.391926f, 0.151501f, 
		0.786936f, 0.571060f, 0.391926f, 0.151501f, 
		0.786936f, 0.571060f, 0.898480f, 0.371661f, 
		0.898480f, 0.371661f, 0.898480f, 0.371661f, 
		0.898480f, 0.371661f, 0.760867f, 0.485122f, 
		0.768810f, 0.497984f, 0.764415f, 0.494266f, 
		0.930386f, 0.373501f, 0.763842f, 0.494128f, 
		0.750538f, 0.495145f, 0.894294f, 0.666156f, 
		0.771175f, 0.499075f, 0.380970f, 0.797298f, 
		0.904092f, 0.467174f, 0.929636f, 0.628983f, 
		0.910975f, 0.467178f, 0.904092f, 0.467174f, 
		0.379915f, 0.799663f, 0.758704f, 0.464562f, 
		0.758704f, 0.464562f, 0.929561f, 0.624667f, 
		0.929561f, 0.624667f, 0.381245f, 0.803164f, 
		0.808478f, 0.620362f, 0.808478f, 0.620362f, 
		0.808478f, 0.620362f, 0.808478f, 0.620362f, 
		0.808478f, 0.620362f, 0.909650f, 0.474524f, 
		0.913895f, 0.483177f, 0.906064f, 0.483967f, 
		0.906096f, 0.484566f, 0.228879f, 0.345853f, 
		0.228879f, 0.345853f, 0.928218f, 0.373986f, 
		0.252420f, 0.498448f, 0.389579f, 0.167493f, 
		0.892256f, 0.571766f, 0.892256f, 0.571766f, 
		0.230667f, 0.376134f, 0.230667f, 0.376134f, 
		0.229746f, 0.381363f, 0.229746f, 0.381363f, 
		0.800997f, 0.589437f, 0.765575f, 0.423676f, 
		0.800997f, 0.589437f, 0.467855f, 0.804743f, 
		0.765575f, 0.423676f, 0.930570f, 0.378694f, 
		0.899735f, 0.667504f, 0.762721f, 0.500550f, 
		0.930570f, 0.378694f, 0.762721f, 0.500550f, 
		0.234317f, 0.360446f, 0.234317f, 0.360446f, 
		0.234317f, 0.360446f, 0.906612f, 0.464415f, 
		0.932169f, 0.629410f, 0.932169f, 0.629410f, 
		0.906612f, 0.464415f, 0.378980f, 0.796723f, 
		0.924247f, 0.629256f, 0.379366f, 0.804436f, 
		0.924247f, 0.629256f, 0.763910f, 0.465765f, 
		0.379366f, 0.804436f, 0.929321f, 0.624456f, 
		0.0938670f, 0.382174f, 0.165248f, 0.920722f, 
		0.165248f, 0.920722f, 0.165248f, 0.920722f, 
		0.359510f, 0.0251480f, 0.165248f, 0.920722f, 
		0.359510f, 0.0251480f, 0.930699f, 0.378756f, 
		0.889820f, 0.666738f, 0.899500f, 0.666740f, 
		0.929826f, 0.369317f, 0.670651f, 0.375943f, 
		0.240705f, 0.0854900f, 0.929986f, 0.369648f, 
		0.890558f, 0.667401f, 0.890558f, 0.667401f, 
		0.907543f, 0.499353f, 0.932845f, 0.630135f, 
		0.932845f, 0.630135f, 0.906502f, 0.465062f, 
		0.906502f, 0.465062f, 0.906502f, 0.465062f, 
		0.378780f, 0.796070f, 0.758043f, 0.484330f, 
		0.758043f, 0.484330f, 0.761431f, 0.496847f, 
		0.753555f, 0.475865f, 0.753555f, 0.475865f, 
		0.150718f, 0.680175f, 0.209062f, 0.337577f, 
		0.209062f, 0.337577f, 0.905687f, 0.423498f, 
		0.905687f, 0.423498f, 0.463974f, 0.806030f, 
		0.796443f, 0.591094f, 0.931647f, 0.625151f, 
		0.764263f, 0.471273f, 0.764263f, 0.471273f, 
		0.764147f, 0.471544f, 0.764147f, 0.471544f, 
		0.758622f, 0.474295f, 0.758622f, 0.474295f, 
		0.763548f, 0.495924f, 0.763000f, 0.489306f, 
		0.763103f, 0.490555f, 0.228593f, 0.392969f, 
		0.930049f, 0.617960f, 0.908056f, 0.499000f, 
		0.898535f, 0.497526f, 0.898467f, 0.500086f, 
		0.912417f, 0.487969f, 0.232132f, 0.347066f, 
		0.232132f, 0.347066f, 0.168262f, 0.851861f, 
		0.870500f, 0.999971f, 0.400951f, 0.785749f, 
		0.168262f, 0.851861f, 0.924379f, 0.628099f, 
		0.924379f, 0.628099f, 0.763700f, 0.464748f, 
		0.379137f, 0.804809f, 0.763700f, 0.464748f, 
		0.930829f, 0.378825f, 0.899722f, 0.667448f, 
		0.761818f, 0.500116f, 0.762176f, 0.495924f, 
		0.932723f, 0.618950f, 0.932723f, 0.618950f, 
		0.907162f, 0.485019f, 0.916940f, 0.474721f, 
		0.903325f, 0.471656f, 0.229520f, 0.387814f, 
		0.229520f, 0.387814f, 0.898535f, 0.497523f, 
		0.890216f, 0.667300f, 0.890216f, 0.667300f, 
		0.929926f, 0.369394f, 0.907820f, 0.499095f, 
		0.242314f, 0.420399f, 0.246809f, 0.618672f, 
		0.764459f, 0.468639f, 0.764459f, 0.468639f, 
		0.766428f, 0.468601f, 0.757993f, 0.485144f, 
		0.757993f, 0.485144f, 0.234706f, 0.354574f, 
		0.763901f, 0.494468f, 0.760760f, 0.475363f, 
		0.753568f, 0.477650f, 0.762489f, 0.500291f, 
		0.0668530f, 0.827374f, 0.0668530f, 0.827374f, 
		0.483275f, 0.729374f, 0.483275f, 0.729374f, 
		0.483275f, 0.729374f, 0.483275f, 0.729374f, 
		0.930606f, 0.377404f, 0.898318f, 0.667148f, 
		0.0911480f, 0.598072f, 0.907973f, 0.460728f, 
		0.933279f, 0.625840f, 0.933279f, 0.625840f, 
		0.907973f, 0.460728f, 0.753118f, 0.476331f, 
		0.759508f, 0.469366f, 0.756781f, 0.485902f, 
		0.800450f, 0.597276f, 0.800450f, 0.597276f, 
		0.800450f, 0.597276f, 0.234917f, 0.367089f, 
		0.234917f, 0.367089f, 0.172715f, 0.730522f, 
		0.172715f, 0.730522f, 0.0420180f, 0.940364f, 
		0.0420180f, 0.940364f, 0.909608f, 0.453425f, 
		0.935120f, 0.618569f, 0.934765f, 0.618974f, 
		0.909516f, 0.453937f, 0.935124f, 0.617060f, 
		0.927207f, 0.614830f, 0.927207f, 0.614830f, 
		0.930489f, 0.616634f, 0.935124f, 0.617060f, 
		0.935124f, 0.617060f, 0.766534f, 0.468081f, 
		0.760296f, 0.473266f, 0.760296f, 0.473266f, 
		0.758357f, 0.465825f, 0.761114f, 0.477623f, 
		0.761214f, 0.482843f, 0.906462f, 0.465365f, 
		0.915615f, 0.469419f, 0.910382f, 0.469051f, 
		0.912423f, 0.462538f, 0.903961f, 0.467347f, 
		0.926609f, 0.619476f, 0.760764f, 0.455631f, 
		0.926609f, 0.619476f, 0.230690f, 0.332907f, 
		0.230690f, 0.332907f, 0.230690f, 0.332907f, 
		0.893112f, 0.666404f, 0.930218f, 0.372697f, 
		0.225798f, 0.328102f, 0.225798f, 0.328102f, 
		0.225798f, 0.328102f, 0.225798f, 0.328102f, 
		0.931018f, 0.616406f, 0.913910f, 0.454507f, 
		0.909432f, 0.453401f, 0.935112f, 0.618563f, 
		0.177135f, 0.0756410f, 0.892125f, 0.661757f, 
		0.915173f, 0.485056f, 0.115830f, 0.487202f, 
		0.931373f, 0.615077f, 0.931373f, 0.615077f, 
		0.926624f, 0.616094f, 0.931189f, 0.615098f, 
		0.931189f, 0.615098f, 0.914958f, 0.475382f, 
		0.910769f, 0.476668f, 0.933822f, 0.606935f, 
		0.933822f, 0.606935f, 0.933822f, 0.606935f, 
		0.933822f, 0.606935f, 0.933822f, 0.606935f, 
		0.933822f, 0.606935f, 0.757809f, 0.462175f, 
		0.763777f, 0.465187f, 0.756491f, 0.455989f, 
		0.759156f, 0.469243f, 0.235760f, 0.347882f, 
		0.902210f, 0.562012f, 0.867272f, 0.371766f, 
		0.867272f, 0.371766f, 0.867272f, 0.371766f, 
		0.902210f, 0.562012f, 0.760027f, 0.471618f, 
		0.760027f, 0.471618f, 0.760027f, 0.471618f, 
		0.766908f, 0.470545f, 0.762053f, 0.484163f, 
		0.759689f, 0.483640f, 0.761669f, 0.483692f, 
		0.766811f, 0.469067f, 0.761032f, 0.474160f, 
		0.761032f, 0.474160f, 0.756553f, 0.455976f, 
		0.760360f, 0.452604f, 0.930832f, 0.615204f, 
		0.755997f, 0.453787f, 0.930832f, 0.615204f, 
		0.930832f, 0.615204f, 0.235858f, 0.370663f, 
		0.235858f, 0.370663f, 0.235858f, 0.370663f, 
		0.235858f, 0.370663f, 0.236389f, 0.363303f, 
		0.236389f, 0.363303f, 0.236389f, 0.363303f, 
		0.926674f, 0.616198f, 0.931333f, 0.614824f, 
		0.934508f, 0.616707f, 0.930151f, 0.616667f, 
		0.181593f, 0.963111f, 0.0555570f, 0.960780f, 
		0.185817f, 0.947570f, 0.414247f, 0.568241f, 
		0.930741f, 0.616793f, 0.913947f, 0.455049f, 
		0.909645f, 0.451734f, 0.934351f, 0.616541f, 
		0.935169f, 0.617318f, 0.916878f, 0.474849f, 
		0.908337f, 0.498478f, 0.917165f, 0.486444f, 
		0.908751f, 0.476320f, 0.909719f, 0.469530f, 
		0.909719f, 0.469530f, 0.909719f, 0.469530f, 
		0.909719f, 0.469530f, 0.909719f, 0.469530f, 
		0.909719f, 0.469530f, 0.935610f, 0.617221f, 
		0.935610f, 0.617221f, 0.909552f, 0.452034f, 
		0.214348f, 0.319242f, 0.237392f, 0.360262f, 
		0.762061f, 0.484100f, 0.750949f, 0.487992f, 
		0.753129f, 0.476676f, 0.191229f, 0.971509f, 
		0.327898f, 0.00680100f, 0.396912f, 0.566180f, 
		0.00876800f, 0.124340f, 0.239026f, 0.397963f, 
		0.135568f, 0.797293f, 0.135568f, 0.797293f, 
		0.891166f, 0.584122f, 0.845162f, 0.369347f, 
		0.377224f, 0.164831f, 0.164692f, 0.730856f, 
		0.0424350f, 0.930655f, 0.0424350f, 0.930655f, 
		0.0424350f, 0.930655f, 0.755712f, 0.451696f, 
		0.755712f, 0.451696f, 0.926964f, 0.614205f, 
		0.931129f, 0.614743f, 0.756165f, 0.453825f, 
		0.0550160f, 0.876691f, 0.0550160f, 0.876691f, 
		0.400951f, 0.160312f, 0.0550160f, 0.876691f, 
		0.0923910f, 0.243412f, 0.912704f, 0.461336f, 
		0.918072f, 0.457874f, 0.911081f, 0.467892f, 
		0.908781f, 0.456779f, 0.927092f, 0.614359f, 
		0.927092f, 0.614359f, 0.756087f, 0.451709f, 
		0.927127f, 0.614352f, 0.759930f, 0.450985f, 
		0.927127f, 0.614352f, 0.218232f, 0.322995f, 
		0.218232f, 0.322995f, 0.193754f, 0.272741f, 
		0.879892f, 0.994357f, 0.529669f, 0.931322f, 
		0.881555f, 0.896678f, 0.759683f, 0.469621f, 
		0.759683f, 0.469621f, 0.759683f, 0.469621f, 
		0.759683f, 0.469621f, 0.759683f, 0.469621f, 
		0.911175f, 0.472298f, 0.236056f, 0.335881f, 
		0.236056f, 0.335881f, 0.236056f, 0.335881f, 
		0.362177f, 0.780873f, 0.160965f, 0.826994f, 
		0.438217f, 0.0917560f, 0.911101f, 0.467749f, 
		0.911101f, 0.467749f, 0.911101f, 0.467749f, 
		0.911101f, 0.467749f, 0.911101f, 0.467749f, 
		0.760861f, 0.455117f, 0.760861f, 0.455117f, 
		0.755493f, 0.451788f, 0.755493f, 0.451788f, 
		0.757411f, 0.460870f, 0.757411f, 0.460870f, 
		0.0812680f, 0.865966f, 0.519412f, 0.738042f, 
		0.913834f, 0.454851f, 0.930809f, 0.616831f, 
		0.930809f, 0.616831f, 0.934608f, 0.618361f, 
		0.934608f, 0.618361f, 0.910800f, 0.453827f, 
		0.238452f, 0.376128f, 0.238452f, 0.376128f, 
		0.512631f, 0.779338f, 0.390511f, 0.146033f, 
		0.777790f, 0.572670f, 0.858449f, 0.388144f, 
		0.102000f, 0.331608f, 0.912487f, 0.485912f, 
		0.912487f, 0.485912f, 0.912487f, 0.485912f, 
		0.910006f, 0.451743f, 0.909649f, 0.451697f, 
		0.919225f, 0.454178f, 0.669533f, 0.775887f, 
		0.0247400f, 0.853870f, 0.432388f, 0.115974f, 
		0.994664f, 0.387217f, 0.0346400f, 0.962704f, 
		0.994664f, 0.387217f, 0.758100f, 0.462714f, 
		0.758100f, 0.462714f, 0.758100f, 0.462714f, 
		0.758135f, 0.489510f, 0.939727f, 0.594564f, 
		0.939727f, 0.594564f, 0.939727f, 0.594564f, 
		0.911279f, 0.429378f, 0.939727f, 0.594564f, 
		0.910922f, 0.468633f, 0.910922f, 0.468633f, 
		0.649979f, 0.611421f, 0.645709f, 0.616309f, 
		0.916289f, 0.463281f, 0.645756f, 0.605800f, 
		0.754502f, 0.454025f, 0.754502f, 0.454025f, 
		0.754502f, 0.454025f, 0.754502f, 0.454025f, 
		0.754502f, 0.454025f, 0.919887f, 0.491115f, 
		0.908563f, 0.485368f, 0.907805f, 0.485299f, 
		0.916926f, 0.490878f, 0.919040f, 0.484916f, 
		0.919040f, 0.484916f, 0.910422f, 0.477957f, 
		0.910422f, 0.477957f, 0.917165f, 0.492944f, 
		0.912036f, 0.489184f, 0.238855f, 0.382125f, 
		0.238855f, 0.382125f, 0.238855f, 0.382125f, 
		0.238855f, 0.382125f, 0.377263f, 0.759377f, 
		0.377263f, 0.759377f, 0.191823f, 0.867912f, 
		0.377263f, 0.759377f, 0.127545f, 0.797626f, 
		0.702566f, 0.759057f, 0.000000f, 0.898670f, 
		0.758342f, 0.464279f, 0.758342f, 0.464279f, 
		0.758342f, 0.464279f, 0.239921f, 0.352567f, 
		0.243345f, 0.0642450f, 0.662156f, 0.370753f, 
		0.756902f, 0.486210f, 0.753538f, 0.463665f, 
		0.650322f, 0.611731f, 0.753235f, 0.475944f, 
		0.650322f, 0.611731f, 0.654128f, 0.616620f, 
		0.753958f, 0.471272f, 0.999290f, 0.471276f, 
		0.0662850f, 0.932240f, 0.429166f, 0.0824560f, 
		0.757873f, 0.438257f, 0.930449f, 0.601608f, 
		0.930449f, 0.601608f, 0.757873f, 0.438257f, 
		0.912249f, 0.462552f, 0.912249f, 0.462552f, 
		0.912249f, 0.462552f, 0.239244f, 0.339112f, 
		0.239244f, 0.339112f, 0.239244f, 0.339112f, 
		0.239244f, 0.339112f, 0.239244f, 0.339112f, 
		0.696031f, 0.535900f, 0.240409f, 0.386548f, 
		0.240409f, 0.386548f, 0.239550f, 0.365019f, 
		0.237675f, 0.367272f, 0.861496f, 0.377258f, 
		0.757313f, 0.478836f, 0.840049f, 0.997060f, 
		0.840049f, 0.997060f, 0.180809f, 0.885856f, 
		0.381709f, 0.745203f, 0.207395f, 0.560070f, 
		0.463857f, 0.0971230f, 0.463857f, 0.0971230f, 
		0.255539f, 0.931506f, 0.918101f, 0.457989f, 
		0.644613f, 0.600523f, 0.915436f, 0.468596f, 
		0.646327f, 0.611130f, 0.909328f, 0.473302f, 
		0.646200f, 0.613395f, 0.644204f, 0.618573f, 
		0.913633f, 0.485182f, 0.760098f, 0.473901f, 
		0.760098f, 0.473901f, 0.753887f, 0.472333f, 
		0.650122f, 0.615102f, 0.756840f, 0.486225f, 
		0.654150f, 0.613204f, 0.913260f, 0.434064f, 
		0.943791f, 0.600570f, 0.913260f, 0.434064f, 
		0.913260f, 0.434064f, 0.652750f, 0.598298f, 
		0.754400f, 0.469672f, 0.649966f, 0.605289f, 
		0.752064f, 0.457443f, 0.182564f, 0.976565f, 
		0.0537740f, 0.973111f, 0.323186f, 0.0181960f, 
		0.920372f, 0.490808f, 0.913012f, 0.485979f, 
		0.913012f, 0.485979f, 0.646283f, 0.611329f, 
		0.649682f, 0.605359f, 0.654120f, 0.610765f, 
		0.913056f, 0.457144f, 0.275330f, 0.457719f, 
		0.919419f, 0.476526f, 0.919419f, 0.476526f, 
		0.919419f, 0.476526f, 0.919419f, 0.476526f, 
		0.918542f, 0.489854f, 0.918542f, 0.489854f, 
		0.412344f, 0.621056f, 0.412344f, 0.621056f, 
		0.412344f, 0.621056f, 0.412344f, 0.621056f, 
		0.412344f, 0.621056f, 0.683692f, 0.816467f, 
		0.423487f, 0.0723540f, 0.838253f, 0.936954f, 
		0.371515f, 0.155955f, 0.371515f, 0.155955f, 
		0.371515f, 0.155955f, 0.792499f, 0.470124f, 
		0.340283f, 0.718673f, 0.340283f, 0.718673f, 
		0.792499f, 0.470124f, 0.101641f, 0.832852f, 
		0.101641f, 0.832852f, 0.646116f, 0.613364f, 
		0.650023f, 0.613742f, 0.649510f, 0.616798f, 
		0.649510f, 0.616798f, 0.654194f, 0.616699f, 
		0.654194f, 0.616699f, 0.654175f, 0.613138f, 
		0.650023f, 0.613742f, 0.756555f, 0.485727f, 
		0.154508f, 0.856643f, 0.154508f, 0.856643f, 
		0.869002f, 0.990360f, 0.869002f, 0.990360f, 
		0.0292830f, 0.831387f, 0.0292830f, 0.831387f, 
		0.367228f, 0.863373f, 0.466924f, 0.765688f, 
		0.914182f, 0.453156f, 0.914187f, 0.453016f, 
		0.648967f, 0.599693f, 0.653638f, 0.604534f, 
		0.650153f, 0.610841f, 0.503367f, 0.780380f, 
		0.858168f, 0.382754f, 0.858168f, 0.382754f, 
		0.858168f, 0.382754f, 0.120582f, 0.560358f, 
		0.242119f, 0.341507f, 0.242030f, 0.341732f, 
		0.914534f, 0.453079f, 0.918088f, 0.453677f, 
		0.910891f, 0.451863f, 0.916242f, 0.463261f, 
		0.645960f, 0.605769f, 0.643480f, 0.596335f, 
		0.643480f, 0.596335f, 0.913726f, 0.456911f, 
		0.913726f, 0.456911f, 0.760043f, 0.450821f, 
		0.750824f, 0.453213f, 0.751332f, 0.455315f, 
		0.760468f, 0.452911f, 0.243448f, 0.347731f, 
		0.246671f, 0.346312f, 0.243448f, 0.347731f, 
		0.243448f, 0.347731f, 0.243448f, 0.347731f, 
		0.914661f, 0.451642f, 0.914661f, 0.451642f, 
		0.914661f, 0.451642f, 0.914661f, 0.451642f, 
		0.914661f, 0.451642f, 0.756902f, 0.486907f, 
		0.746201f, 0.485335f, 0.750660f, 0.479325f, 
		0.762143f, 0.499716f, 0.893431f, 0.651163f, 
		0.746246f, 0.490979f, 0.890440f, 0.654557f, 
		0.644186f, 0.598203f, 0.914357f, 0.453187f, 
		0.918784f, 0.455896f, 0.643600f, 0.596330f, 
		0.653703f, 0.604456f, 0.651922f, 0.594005f, 
		0.751070f, 0.453131f, 0.753578f, 0.463618f, 
		0.146484f, 0.856976f, 0.867504f, 0.980748f, 
		0.722411f, 0.815935f, 0.914403f, 0.455539f, 
		0.914403f, 0.455539f, 0.914385f, 0.454902f, 
		0.913532f, 0.455328f, 0.303473f, 0.865752f, 
		0.303473f, 0.865752f, 0.303473f, 0.865752f, 
		0.303473f, 0.865752f, 0.370352f, 0.160216f, 
		0.370352f, 0.160216f, 0.370352f, 0.160216f, 
		0.235653f, 0.316512f, 0.235653f, 0.316512f, 
		0.235653f, 0.316512f, 0.235653f, 0.316512f, 
		0.444196f, 0.739131f, 0.444196f, 0.739131f, 
		0.444196f, 0.739131f, 0.373330f, 0.897463f, 
		0.457437f, 0.918451f, 0.457437f, 0.918451f, 
		0.112872f, 0.290250f, 0.242548f, 0.362427f, 
		0.746653f, 0.478901f, 0.746653f, 0.478901f, 
		0.746653f, 0.478901f, 0.650112f, 0.616892f, 
		0.650112f, 0.616892f, 0.751125f, 0.487178f, 
		0.645876f, 0.609425f, 0.645876f, 0.609425f, 
		0.916044f, 0.466899f, 0.916044f, 0.466899f, 
		0.244208f, 0.353446f, 0.244208f, 0.353446f, 
		0.244208f, 0.353446f, 0.750791f, 0.453246f, 
		0.759853f, 0.450882f, 0.755863f, 0.451907f, 
		0.840531f, 0.369564f, 0.372593f, 0.164613f, 
		0.263304f, 0.708514f, 0.368063f, 0.164449f, 
		0.649896f, 0.615098f, 0.299226f, 0.797582f, 
		0.747315f, 0.476274f, 0.747315f, 0.476274f, 
		0.654292f, 0.619548f, 0.652346f, 0.595904f, 
		0.751331f, 0.455097f, 0.755917f, 0.453847f, 
		0.652116f, 0.593969f, 0.645379f, 0.617062f, 
		0.645379f, 0.617062f, 0.298914f, 0.802881f, 
		0.298914f, 0.802881f, 0.918951f, 0.482861f, 
		0.918951f, 0.482861f, 0.918951f, 0.482861f, 
		0.753820f, 0.467830f, 0.654156f, 0.608521f, 
		0.753820f, 0.467830f, 0.753820f, 0.467830f, 
		0.654156f, 0.608521f, 0.654156f, 0.608521f, 
		0.919176f, 0.483161f, 0.883174f, 0.652229f, 
		0.883174f, 0.652229f, 0.889695f, 0.654619f, 
		0.919176f, 0.483161f, 0.919176f, 0.483161f, 
		0.887943f, 0.651149f, 0.884791f, 0.654827f, 
		0.896824f, 0.655320f, 0.244409f, 0.367413f, 
		0.244409f, 0.367413f, 0.244409f, 0.367413f, 
		0.244409f, 0.367413f, 0.244409f, 0.367413f, 
		0.242115f, 0.364945f, 0.241404f, 0.364269f, 
		0.0265520f, 0.0982060f, 0.390764f, 0.593081f, 
		0.898601f, 0.584585f, 0.843216f, 0.373742f, 
		0.843216f, 0.373742f, 0.843216f, 0.373742f, 
		0.843216f, 0.373742f, 0.843216f, 0.373742f, 
		0.270432f, 0.706725f, 0.270432f, 0.706725f, 
		0.0993610f, 0.213409f, 0.914946f, 0.425004f, 
		0.914946f, 0.425004f, 0.280199f, 0.798207f, 
		0.914946f, 0.425004f, 0.942921f, 0.590190f, 
		0.126709f, 0.942128f, 0.00684100f, 0.581122f, 
		0.00684100f, 0.581122f, 0.287729f, 0.880685f, 
		0.287729f, 0.880685f, 0.0126180f, 0.790408f, 
		0.717488f, 0.321502f, 0.292634f, 0.0968850f, 
		0.650082f, 0.605190f, 0.650082f, 0.605190f, 
		0.648057f, 0.595452f, 0.648057f, 0.595452f, 
		0.232449f, 0.310258f, 0.232449f, 0.310258f, 
		0.232449f, 0.310258f, 0.646291f, 0.611340f, 
		0.915492f, 0.468820f, 0.136644f, 0.426626f, 
		0.128488f, 0.218713f, 0.128488f, 0.218713f, 
		0.128488f, 0.218713f, 0.381455f, 0.618702f, 
		0.0443700f, 0.0883740f, 0.648328f, 0.597362f, 
		0.648328f, 0.597362f, 0.648328f, 0.597362f, 
		0.647940f, 0.595538f, 0.647940f, 0.595538f, 
		0.650052f, 0.610247f, 0.650052f, 0.610247f, 
		0.650052f, 0.610247f, 0.650052f, 0.610247f, 
		0.650052f, 0.610247f, 0.650052f, 0.610247f, 
		0.230056f, 0.304386f, 0.654106f, 0.610888f, 
		0.754142f, 0.470001f, 0.754142f, 0.470001f, 
		0.654106f, 0.610888f, 0.754142f, 0.470001f, 
		0.372814f, 0.151712f, 0.593916f, 0.566597f, 
		0.372814f, 0.151712f, 0.372814f, 0.151712f, 
		0.915914f, 0.477770f, 0.915914f, 0.477770f, 
		0.915914f, 0.477770f, 0.816528f, 0.934877f, 
		0.669606f, 0.845028f, 0.816528f, 0.934877f, 
		0.246117f, 0.344331f, 0.244743f, 0.360831f, 
		0.244743f, 0.360831f, 0.243759f, 0.361445f, 
		0.244494f, 0.361333f, 0.244951f, 0.361264f, 
		0.244951f, 0.361264f, 0.440679f, 0.162926f, 
		0.0572910f, 0.828394f, 0.0572910f, 0.828394f, 
		0.0721470f, 0.208858f, 0.247956f, 0.369697f, 
		0.247956f, 0.369697f, 0.247956f, 0.369697f, 
		0.247956f, 0.369697f, 0.242647f, 0.321793f, 
		0.472300f, 0.118881f, 0.0268180f, 0.805496f, 
		0.650386f, 0.610872f, 0.916306f, 0.463304f, 
		0.916306f, 0.463304f, 0.645720f, 0.605874f, 
		0.645720f, 0.605874f, 0.916306f, 0.463304f, 
		0.916306f, 0.463304f, 0.645720f, 0.605874f, 
		0.260902f, 0.534029f, 0.229715f, 0.286610f, 
		0.229715f, 0.286610f, 0.229715f, 0.286610f, 
		0.752820f, 0.476013f, 0.654227f, 0.616662f, 
		0.753307f, 0.425896f, 0.938275f, 0.589246f, 
		0.278041f, 0.802298f, 0.938275f, 0.589246f, 
		0.653620f, 0.603989f, 0.753283f, 0.463377f, 
		0.843653f, 0.378033f, 0.843653f, 0.378033f, 
		0.843653f, 0.378033f, 0.843653f, 0.378033f, 
		0.843653f, 0.378033f, 0.439214f, 0.712384f, 
		0.439214f, 0.712384f, 0.439214f, 0.712384f, 
		0.752718f, 0.438101f, 0.752718f, 0.438101f, 
		0.752718f, 0.438101f, 0.476926f, 0.120473f, 
		0.869856f, 0.868132f, 0.869856f, 0.868132f, 
		0.799122f, 0.809413f, 0.799122f, 0.809413f, 
		0.646111f, 0.616572f, 0.644992f, 0.617321f, 
		0.917401f, 0.474870f, 0.646219f, 0.616327f, 
		0.917401f, 0.474870f, 0.621000f, 0.636865f, 
		0.296189f, 0.802509f, 0.922111f, 0.479248f, 
		0.268291f, 0.421139f, 0.123467f, 0.253394f, 
		0.0747340f, 0.600400f, 0.115738f, 0.871022f, 
		0.0747340f, 0.600400f, 0.115738f, 0.871022f, 
		0.250507f, 0.373968f, 0.250507f, 0.373968f, 
		0.250507f, 0.373968f, 0.250507f, 0.373968f, 
		0.250507f, 0.373968f, 0.250507f, 0.373968f, 
		0.742752f, 0.476785f, 0.742752f, 0.476785f, 
		0.750400f, 0.479289f, 0.750400f, 0.479289f, 
		0.247370f, 0.360789f, 0.247370f, 0.360789f, 
		0.250562f, 0.360958f, 0.250562f, 0.360958f, 
		0.249775f, 0.360916f, 0.338718f, 0.749903f, 
		0.0810950f, 0.935363f, 0.442294f, 0.0986180f, 
		0.442294f, 0.0986180f, 0.861634f, 0.950008f, 
		0.654486f, 0.618922f, 0.654486f, 0.618922f, 
		0.750441f, 0.478313f, 0.750441f, 0.478313f, 
		0.914169f, 0.455027f, 0.644141f, 0.598307f, 
		0.643644f, 0.596578f, 0.917213f, 0.455531f, 
		0.741730f, 0.482663f, 0.750361f, 0.488123f, 
		0.923250f, 0.485086f, 0.893374f, 0.650811f, 
		0.893374f, 0.650811f, 0.889370f, 0.654321f, 
		0.889370f, 0.654321f, 0.513722f, 0.791878f, 
		0.375150f, 0.147502f, 0.586486f, 0.566227f, 
		0.586486f, 0.566227f, 0.252951f, 0.379647f, 
		0.251557f, 0.377659f, 0.252951f, 0.379647f, 
		0.887729f, 0.656948f, 0.250230f, 0.354520f, 
		0.250230f, 0.354520f, 0.250230f, 0.354520f, 
		0.649824f, 0.605331f, 0.506290f, 0.792714f, 
		0.506290f, 0.792714f, 0.843640f, 0.382345f, 
		0.579038f, 0.566231f, 0.843640f, 0.382345f, 
		0.620429f, 0.631462f, 0.745183f, 0.476203f, 
		0.297400f, 0.797454f, 0.750091f, 0.476065f, 
		0.618865f, 0.635464f, 0.745183f, 0.476203f, 
		0.649948f, 0.615180f, 0.649948f, 0.615180f, 
		0.649948f, 0.615180f, 0.649948f, 0.615180f, 
		0.150653f, 0.471586f, 0.618302f, 0.375321f, 
		0.618302f, 0.375321f, 0.618302f, 0.375321f, 
		0.618302f, 0.375321f, 0.205547f, 0.0414370f, 
		0.205547f, 0.0414370f, 0.205547f, 0.0414370f, 
		0.252178f, 0.341889f, 0.252178f, 0.341889f, 
		0.741796f, 0.486621f, 0.887255f, 0.650558f, 
		0.896483f, 0.655042f, 0.750088f, 0.494815f, 
		0.132400f, 0.380247f, 0.919502f, 0.475313f, 
		0.619075f, 0.635722f, 0.619075f, 0.635722f, 
		0.644250f, 0.618126f, 0.644250f, 0.618126f, 
		0.919502f, 0.475313f, 0.919502f, 0.475313f, 
		0.919502f, 0.475313f, 0.919185f, 0.483094f, 
		0.919185f, 0.483094f, 0.919185f, 0.483094f, 
		0.0455130f, 0.974964f, 0.165544f, 0.950619f, 
		0.336814f, 0.0280680f, 0.336814f, 0.0280680f, 
		0.755428f, 0.451798f, 0.652453f, 0.596062f, 
		0.652052f, 0.594014f, 0.755866f, 0.453852f, 
		0.922963f, 0.473895f, 0.924299f, 0.483092f, 
		0.924299f, 0.483092f, 0.922963f, 0.473895f, 
		0.922357f, 0.479385f, 0.896459f, 0.654771f, 
		0.749757f, 0.494776f, 0.749757f, 0.494776f, 
		0.896459f, 0.654771f, 0.920372f, 0.490808f, 
		0.884732f, 0.654696f, 0.884732f, 0.654696f, 
		0.920372f, 0.490808f, 0.648155f, 0.616800f, 
		0.646420f, 0.617784f, 0.299176f, 0.800246f, 
		0.299176f, 0.800246f, 0.750834f, 0.488027f, 
		0.250616f, 0.338422f, 0.250616f, 0.338422f, 
		0.250545f, 0.338360f, 0.510379f, 0.121546f, 
		0.0306970f, 0.758209f, 0.0306970f, 0.758209f, 
		0.0306970f, 0.758209f, 0.510379f, 0.121546f, 
		0.510379f, 0.121546f, 0.889956f, 0.654401f, 
		0.889956f, 0.654401f, 0.889956f, 0.654401f, 
		0.889956f, 0.654401f, 0.889956f, 0.654401f, 
		0.376774f, 0.636762f, 0.0626400f, 0.0716050f, 
		0.251875f, 0.346826f, 0.251875f, 0.346826f, 
		0.251875f, 0.346826f, 0.251693f, 0.346994f, 
		0.463385f, 0.0752420f, 0.830794f, 0.889084f, 
		0.890539f, 0.655668f, 0.644315f, 0.598256f, 
		0.914105f, 0.454827f, 0.914105f, 0.454827f, 
		0.643752f, 0.596288f, 0.918840f, 0.453872f, 
		0.918840f, 0.453872f, 0.920517f, 0.481499f, 
		0.920517f, 0.481499f, 0.920517f, 0.481499f, 
		0.920517f, 0.481499f, 0.920517f, 0.481499f, 
		0.926724f, 0.485389f, 0.884732f, 0.654696f, 
		0.924084f, 0.477481f, 0.923160f, 0.484637f, 
		0.618962f, 0.635178f, 0.618962f, 0.635178f, 
		0.297352f, 0.797777f, 0.297352f, 0.797777f, 
		0.921719f, 0.474862f, 0.619444f, 0.632305f, 
		0.924028f, 0.476611f, 0.619444f, 0.632305f, 
		0.619444f, 0.632305f, 0.924028f, 0.476611f, 
		0.924028f, 0.476611f, 0.650187f, 0.617125f, 
		0.298962f, 0.803578f, 0.750151f, 0.476368f, 
		0.650187f, 0.617125f, 0.896886f, 0.656057f, 
		0.750845f, 0.494480f, 0.643764f, 0.618821f, 
		0.299329f, 0.797597f, 0.921904f, 0.475902f, 
		0.921904f, 0.475902f, 0.920897f, 0.476420f, 
		0.920897f, 0.476420f, 0.920897f, 0.476420f, 
		0.322768f, 0.717322f, 0.0820230f, 0.826654f, 
		0.866705f, 0.519568f, 0.866705f, 0.519568f, 
		0.750561f, 0.479086f, 0.654199f, 0.619508f, 
		0.254023f, 0.362144f, 0.254023f, 0.362144f, 
		0.254023f, 0.362144f, 0.254023f, 0.362144f, 
		0.837054f, 0.977837f, 0.702668f, 0.855967f, 
		0.255277f, 0.343366f, 0.259161f, 0.348410f, 
		0.254399f, 0.341850f, 0.255277f, 0.343366f, 
		0.255277f, 0.343366f, 0.778805f, 0.999420f, 
		0.778805f, 0.999420f, 0.323954f, 0.732602f, 
		0.323954f, 0.732602f, 0.919431f, 0.432802f, 
		0.919431f, 0.432802f, 0.919431f, 0.432802f, 
		0.919431f, 0.432802f, 0.919431f, 0.432802f, 
		0.919431f, 0.432802f, 0.259745f, 0.388864f, 
		0.289132f, 0.492665f, 0.894718f, 0.655151f, 
		0.652399f, 0.596065f, 0.755309f, 0.451861f, 
		0.652033f, 0.594213f, 0.751145f, 0.453416f, 
		0.652033f, 0.594213f, 0.751145f, 0.453416f, 
		0.751145f, 0.453416f, 0.127545f, 0.922709f, 
		0.127545f, 0.922709f, 0.0256140f, 0.580506f, 
		0.0256140f, 0.580506f, 0.127545f, 0.922709f, 
		0.127545f, 0.922709f, 0.0216530f, 0.750210f, 
		0.759603f, 0.276036f, 0.0993610f, 0.213409f, 
		0.918465f, 0.456292f, 0.644009f, 0.598716f, 
		0.643909f, 0.598136f, 0.644708f, 0.596743f, 
		0.918594f, 0.455663f, 0.249209f, 0.343049f, 
		0.249204f, 0.343145f, 0.746292f, 0.477940f, 
		0.745716f, 0.479364f, 0.746738f, 0.476570f, 
		0.745304f, 0.484451f, 0.127127f, 0.932419f, 
		0.127127f, 0.932419f, 0.0162280f, 0.580814f, 
		0.0162280f, 0.580814f, 0.884990f, 0.654628f, 
		0.884990f, 0.654628f, 0.919978f, 0.490478f, 
		0.925437f, 0.481983f, 0.889975f, 0.647025f, 
		0.925441f, 0.481922f, 0.887462f, 0.650613f, 
		0.649756f, 0.616752f, 0.748531f, 0.475970f, 
		0.619774f, 0.630616f, 0.649756f, 0.616752f, 
		0.748531f, 0.475970f, 0.838552f, 0.987449f, 
		0.838552f, 0.987449f, 0.288467f, 0.825242f, 
		0.288467f, 0.825242f, 0.249440f, 0.312597f, 
		0.249440f, 0.312597f, 0.249440f, 0.312597f, 
		0.748431f, 0.486384f, 0.748431f, 0.486384f, 
		0.748431f, 0.486384f, 0.645465f, 0.598575f, 
		0.645465f, 0.598575f, 0.645465f, 0.598575f, 
		0.648504f, 0.599618f, 0.745656f, 0.488878f, 
		0.746285f, 0.478743f, 0.745650f, 0.490332f, 
		0.922526f, 0.479487f, 0.922526f, 0.479487f, 
		0.922526f, 0.479487f, 0.922526f, 0.479487f, 
		0.922526f, 0.479487f, 0.149502f, 0.531123f, 
		0.165500f, 0.225225f, 0.249658f, 0.344401f, 
		0.249495f, 0.344727f, 0.249742f, 0.344232f, 
		0.745435f, 0.490095f, 0.885759f, 0.648302f, 
		0.885336f, 0.648185f, 0.745862f, 0.485358f, 
		0.256958f, 0.363792f, 0.258045f, 0.364555f, 
		0.772833f, 0.936561f, 0.772833f, 0.936561f, 
		0.0698530f, 0.635897f, 0.0698530f, 0.635897f, 
		0.0631040f, 0.779255f, 0.0631040f, 0.779255f, 
		0.922375f, 0.478936f, 0.621106f, 0.632976f, 
		0.621106f, 0.632976f, 0.620865f, 0.636493f, 
		0.923864f, 0.473181f, 0.923864f, 0.473181f, 
		0.923864f, 0.473181f, 0.274027f, 0.797308f, 
		0.921117f, 0.425319f, 0.634669f, 0.567845f, 
		0.889228f, 0.653461f, 0.385748f, 0.887165f, 
		0.464078f, 0.923247f, 0.251417f, 0.912815f, 
		0.385748f, 0.887165f, 0.633380f, 0.878117f, 
		0.749238f, 0.426288f, 0.749238f, 0.426288f, 
		0.273993f, 0.803578f, 0.640939f, 0.565996f, 
		0.648423f, 0.597573f, 0.648423f, 0.597573f, 
		0.647379f, 0.597742f, 0.648005f, 0.596928f, 
		0.646955f, 0.596015f, 0.646955f, 0.596015f, 
		0.647601f, 0.595793f, 0.250661f, 0.306421f, 
		0.250661f, 0.306421f, 0.250661f, 0.306421f, 
		0.250661f, 0.306421f, 0.250661f, 0.306421f, 
		0.619464f, 0.630535f, 0.296092f, 0.802386f, 
		0.747212f, 0.476202f, 0.255778f, 0.328853f, 
		0.255778f, 0.328853f, 0.255778f, 0.328853f, 
		0.000000f, 0.630876f, 0.000000f, 0.630876f, 
		0.268617f, 0.829091f, 0.268617f, 0.829091f, 
		0.0346250f, 0.877647f, 0.0346250f, 0.877647f, 
		0.0346250f, 0.877647f, 0.664218f, 0.0747680f, 
		0.664218f, 0.0747680f, 0.664218f, 0.0747680f, 
		0.664218f, 0.0747680f, 0.664218f, 0.0747680f, 
		0.485442f, 0.135948f, 0.252498f, 0.965200f, 
		0.880608f, 0.856078f, 0.793681f, 0.799236f, 
		0.722411f, 0.186887f, 0.722411f, 0.186887f, 
		0.722411f, 0.186887f, 0.882567f, 0.652031f, 
		0.882567f, 0.652031f, 0.923613f, 0.483920f, 
		0.923613f, 0.483920f, 0.112611f, 0.979986f, 
		0.155700f, 0.0486280f, 0.819857f, 0.970800f, 
		0.155700f, 0.0486280f, 0.177405f, 0.610783f, 
		0.199797f, 0.597416f, 0.649100f, 0.582185f, 
		0.747603f, 0.441494f, 0.747603f, 0.441494f, 
		0.649100f, 0.582185f, 0.721480f, 0.0904460f, 
		0.0334710f, 0.730189f, 0.532709f, 0.123184f, 
		0.532709f, 0.123184f, 0.532709f, 0.123184f, 
		0.253670f, 0.302010f, 0.498814f, 0.141239f, 
		0.498814f, 0.141239f, 0.513090f, 0.957757f, 
		0.498814f, 0.141239f, 0.504552f, 0.0782410f, 
		0.823044f, 0.839668f, 0.664218f, 0.0747680f, 
		0.664218f, 0.0747680f, 0.664218f, 0.0747680f, 
		0.664218f, 0.0747680f, 0.664218f, 0.0747680f, 
		0.922643f, 0.485497f, 0.922643f, 0.485497f, 
		0.882730f, 0.652102f, 0.882730f, 0.652102f, 
		0.922643f, 0.485497f, 0.922643f, 0.485497f, 
		0.249950f, 0.342670f, 0.249950f, 0.342670f, 
		0.249909f, 0.343233f, 0.249837f, 0.343379f, 
		0.747278f, 0.491739f, 0.895162f, 0.652992f, 
		0.459722f, 0.759057f, 0.720864f, 0.0645630f, 
		0.621093f, 0.632248f, 0.922449f, 0.478880f, 
		0.921713f, 0.475040f, 0.619517f, 0.630546f, 
		0.886664f, 0.650076f, 0.886664f, 0.650076f, 
		0.886664f, 0.650076f, 0.924991f, 0.487552f, 
		0.651672f, 0.166332f, 0.899784f, 0.517564f, 
		0.722023f, 0.0467390f, 0.722023f, 0.0467390f, 
		0.722023f, 0.0467390f, 0.924479f, 0.476659f, 
		0.923017f, 0.484443f, 0.924290f, 0.473056f, 
		0.136284f, 0.337556f, 0.647825f, 0.349123f, 
		0.241729f, 0.0442430f, 0.647825f, 0.349123f, 
		0.647825f, 0.349123f, 0.00973400f, 0.542688f, 
		0.0142500f, 0.850200f, 0.390185f, 0.855373f, 
		0.390185f, 0.855373f, 0.390185f, 0.855373f, 
		0.809069f, 0.887007f, 0.249965f, 0.344190f, 
		0.249970f, 0.344236f, 0.249951f, 0.344143f, 
		0.800872f, 0.224100f, 0.0477960f, 0.703433f, 
		0.529738f, 0.973809f, 0.895927f, 0.841750f, 
		0.810067f, 0.768517f, 0.517885f, 0.157336f, 
		0.271602f, 0.390258f, 0.746444f, 0.478660f, 
		0.746444f, 0.478660f, 0.746444f, 0.478660f, 
		0.746444f, 0.478660f, 0.746444f, 0.478660f, 
		0.259254f, 0.293666f, 0.621044f, 0.636741f, 
		0.621044f, 0.636741f, 0.742747f, 0.476700f, 
		0.746193f, 0.478438f, 0.619074f, 0.635266f, 
		0.267142f, 0.356778f, 0.267142f, 0.356778f, 
		0.267142f, 0.356778f, 0.923612f, 0.435256f, 
		0.634378f, 0.577783f, 0.923612f, 0.435256f, 
		0.634378f, 0.577783f, 0.923612f, 0.435256f, 
		0.669485f, 0.864139f, 0.504196f, 0.774091f, 
		0.504196f, 0.774091f, 0.504196f, 0.774091f, 
		0.504196f, 0.774091f, 0.121011f, 0.601116f, 
		0.114634f, 0.823333f, 0.114634f, 0.823333f, 
		0.121011f, 0.601116f, 0.924536f, 0.487905f, 
		0.924536f, 0.487905f, 0.886930f, 0.650555f, 
		0.886930f, 0.650555f, 0.925392f, 0.481628f, 
		0.924491f, 0.488059f, 0.924457f, 0.486923f, 
		0.924484f, 0.476946f, 0.734735f, 0.936975f, 
		0.0807680f, 0.691740f, 0.0807680f, 0.691740f, 
		0.734735f, 0.936975f, 0.305434f, 0.549145f, 
		0.921049f, 0.510822f, 0.745446f, 0.485153f, 
		0.393597f, 0.669214f, 0.393597f, 0.669214f, 
		0.393597f, 0.669214f, 0.501601f, 0.772039f, 
		0.501601f, 0.772039f, 0.572160f, 0.147465f, 
		0.572160f, 0.147465f, 0.572160f, 0.147465f, 
		0.572160f, 0.147465f, 0.572160f, 0.147465f, 
		0.572160f, 0.147465f, 0.128527f, 0.179120f, 
		0.128527f, 0.179120f, 0.128527f, 0.179120f, 
		0.128527f, 0.179120f, 0.0187730f, 0.630260f, 
		0.0187730f, 0.630260f, 0.658997f, 0.599840f, 
		0.265379f, 0.331339f, 0.742944f, 0.476422f, 
		0.621026f, 0.636785f, 0.621015f, 0.632203f, 
		0.744309f, 0.474733f, 0.744104f, 0.474623f, 
		0.744104f, 0.474623f, 0.741688f, 0.481883f, 
		0.746046f, 0.485037f, 0.746934f, 0.476308f, 
		0.746934f, 0.476308f, 0.528573f, 0.0782410f, 
		0.819169f, 0.810853f, 0.819169f, 0.810853f, 
		0.528573f, 0.0782410f, 0.675569f, 0.0335140f, 
		0.675569f, 0.0335140f, 0.630439f, 0.797262f, 
		0.924976f, 0.487570f, 0.925202f, 0.482887f, 
		0.925202f, 0.482887f, 0.925202f, 0.482887f, 
		0.696777f, 0.0299370f, 0.696777f, 0.0299370f, 
		0.696777f, 0.0299370f, 0.696777f, 0.0299370f, 
		0.641256f, 0.569471f, 0.744766f, 0.428780f, 
		0.641256f, 0.569471f, 0.641256f, 0.569471f, 
		0.102362f, 0.174268f, 0.102362f, 0.174268f, 
		0.128488f, 0.218713f, 0.451349f, 0.120643f, 
		0.451349f, 0.120643f, 0.451349f, 0.120643f, 
		0.451349f, 0.120643f, 0.873531f, 0.965466f, 
		0.272284f, 0.369661f, 0.720527f, 0.0354920f, 
		0.720527f, 0.0354920f, 0.720527f, 0.0354920f, 
		0.290370f, 0.767346f, 0.290370f, 0.767346f, 
		0.636660f, 0.571276f, 0.926290f, 0.428749f, 
		0.926290f, 0.428749f, 0.636660f, 0.571276f, 
		0.636660f, 0.571276f, 0.624302f, 0.640743f, 
		0.624302f, 0.640743f, 0.624302f, 0.640743f, 
		0.624302f, 0.640743f, 0.927747f, 0.469722f, 
		0.927747f, 0.469722f, 0.775810f, 0.980197f, 
		0.775810f, 0.980197f, 0.775810f, 0.980197f, 
		0.640691f, 0.577619f, 0.640691f, 0.577619f, 
		0.640691f, 0.577619f, 0.742529f, 0.476751f, 
		0.741697f, 0.486596f, 0.745874f, 0.490688f, 
		0.746510f, 0.478764f, 0.268150f, 0.316194f, 
		0.268150f, 0.316194f, 0.268150f, 0.316194f, 
		0.721387f, 0.257698f, 0.742858f, 0.482699f, 
		0.744885f, 0.475015f, 0.742884f, 0.477007f, 
		0.742884f, 0.477007f, 0.889805f, 0.646872f, 
		0.741659f, 0.482138f, 0.746004f, 0.485333f, 
		0.884908f, 0.647788f, 0.174007f, 0.507370f, 
		0.288094f, 0.415254f, 0.572160f, 0.147465f, 
		0.572160f, 0.147465f, 0.572160f, 0.147465f, 
		0.572160f, 0.147465f, 0.572160f, 0.147465f, 
		0.459651f, 0.829290f, 0.655061f, 0.0409790f, 
		0.655061f, 0.0409790f, 0.655061f, 0.0409790f, 
		0.655061f, 0.0409790f, 0.651672f, 0.166332f, 
		0.651672f, 0.166332f, 0.651672f, 0.166332f, 
		0.651672f, 0.166332f, 0.651672f, 0.166332f, 
		0.278498f, 0.265705f, 0.278498f, 0.265705f, 
		0.278498f, 0.265705f, 0.278498f, 0.265705f, 
		0.0632000f, 0.745235f, 0.0632000f, 0.745235f, 
		0.726569f, 0.616591f, 0.507229f, 0.154519f, 
		0.507229f, 0.154519f, 0.145765f, 0.299303f, 
		0.696777f, 0.0299370f, 0.696777f, 0.0299370f, 
		0.696777f, 0.0299370f, 0.696777f, 0.0299370f, 
		0.522276f, 0.182625f, 0.275482f, 0.996725f, 
		0.619768f, 0.630808f, 0.805903f, 0.742337f, 
		0.805903f, 0.742337f, 0.524232f, 0.183509f, 
		0.125747f, 0.140314f, 0.272232f, 0.344047f, 
		0.927319f, 0.484908f, 0.893295f, 0.650565f, 
		0.890692f, 0.650635f, 0.927147f, 0.485025f, 
		0.927330f, 0.484905f, 0.884711f, 0.647737f, 
		0.206669f, 0.234784f, 0.00938600f, 0.630568f, 
		0.00938600f, 0.630568f, 0.703767f, 0.0177710f, 
		0.0887530f, 0.0612740f, 0.371638f, 0.675987f, 
		0.117253f, 0.953035f, 0.0893640f, 0.0450530f, 
		0.101938f, 0.137807f, 0.675569f, 0.0335140f, 
		0.675569f, 0.0335140f, 0.675569f, 0.0335140f, 
		0.675569f, 0.0335140f, 0.501505f, 0.828770f, 
		0.231773f, 0.731486f, 0.501505f, 0.828770f, 
		0.300023f, 0.446990f, 0.163614f, 0.610189f, 
		0.163614f, 0.610189f, 0.101843f, 0.780097f, 
		0.101843f, 0.780097f, 0.655951f, 0.247013f, 
		0.0971000f, 0.102109f, 0.742727f, 0.487498f, 
		0.743481f, 0.477528f, 0.742362f, 0.484038f, 
		0.630439f, 0.797262f, 0.669096f, 0.804212f, 
		0.669096f, 0.804212f, 0.503408f, 0.832602f, 
		0.234392f, 0.730189f, 0.234392f, 0.730189f, 
		0.820685f, 0.773645f, 0.560271f, 0.0641260f, 
		0.560271f, 0.0641260f, 0.560271f, 0.0641260f, 
		0.560271f, 0.0641260f, 0.820685f, 0.773645f, 
		0.820685f, 0.773645f, 0.560271f, 0.0641260f, 
		0.560271f, 0.0641260f, 0.820685f, 0.773645f, 
		0.820685f, 0.773645f, 0.117003f, 0.634822f, 
		0.181252f, 0.461110f, 0.162109f, 0.181607f, 
		0.682104f, 0.0104860f, 0.682104f, 0.0104860f, 
		0.107845f, 0.0589150f, 0.779797f, 0.533370f, 
		0.742784f, 0.483267f, 0.888491f, 0.647084f, 
		0.741778f, 0.486697f, 0.889499f, 0.646849f, 
		0.889499f, 0.646849f, 0.0152980f, 0.709146f, 
		0.725407f, 1.00000f, 0.271041f, 0.755352f, 
		0.271041f, 0.755352f, 0.0980727f, 0.173267f, 
		0.0980727f, 0.173267f, 0.0334710f, 0.730189f, 
		0.0334710f, 0.730189f, 0.532709f, 0.123184f, 
		0.532709f, 0.123184f, 0.118323f, 0.102004f, 
		0.118323f, 0.102004f, 0.118323f, 0.102004f, 
		0.276344f, 0.311341f, 0.158210f, 0.263145f, 
		0.930605f, 0.469345f, 0.930605f, 0.469345f, 
		0.930605f, 0.469345f, 0.623279f, 0.647189f, 
		0.930070f, 0.465181f, 0.628010f, 0.644912f, 
		0.628010f, 0.644912f, 0.327640f, 0.798563f, 
		0.248472f, 0.249156f, 0.704918f, 0.0179557f, 
		0.704918f, 0.0179557f, 0.0876269f, 0.0614107f, 
		0.0876269f, 0.0614107f, 0.285352f, 0.387948f, 
		0.765374f, 0.888691f, 0.819169f, 0.810853f, 
		0.528573f, 0.0782410f, 0.801311f, 0.837783f, 
		0.0934009f, 0.101967f, 0.777307f, 0.989809f, 
		0.777307f, 0.989809f, 0.459651f, 0.829290f, 
		0.655061f, 0.0409790f, 0.655061f, 0.0409790f, 
		0.655061f, 0.0409790f, 0.655061f, 0.0409790f, 
		0.655061f, 0.0409790f, 0.501505f, 0.828770f, 
		0.231773f, 0.731486f, 0.501505f, 0.828770f, 
		0.501505f, 0.828770f, 0.0953636f, 0.136810f, 
		0.0306970f, 0.758209f, 0.0306970f, 0.758209f, 
		0.510379f, 0.121546f, 0.270566f, 0.565905f, 
		0.299854f, 0.258676f, 0.299854f, 0.258676f, 
		0.299854f, 0.258676f, 0.299854f, 0.258676f, 
		0.000000f, 0.555260f, 0.000000f, 0.555260f, 
		0.408765f, 0.847466f, 0.408765f, 0.847466f, 
		0.408765f, 0.847466f, 0.669096f, 0.804212f, 
		0.503408f, 0.832602f, 0.234392f, 0.730189f, 
		0.655951f, 0.247013f, 0.155263f, 0.140935f, 
		0.155263f, 0.140935f, 0.155263f, 0.140935f, 
		0.135568f, 0.797293f, 0.135568f, 0.797293f, 
		0.0340700f, 0.708530f, 0.722411f, 0.980777f, 
		0.722411f, 0.980777f, 0.0340700f, 0.708530f, 
		0.0340700f, 0.708530f, 0.663257f, 0.0169530f, 
		0.834346f, 0.656712f, 0.834346f, 0.656712f, 
		0.663257f, 0.0169530f, 0.663257f, 0.0169530f, 
		0.663257f, 0.0169530f, 0.616226f, 0.644187f, 
		0.879486f, 0.642774f, 0.931177f, 0.478909f, 
		0.931177f, 0.478909f, 0.931177f, 0.478909f, 
		0.186992f, 0.645708f, 0.630876f, 0.759057f, 
		0.504196f, 0.896709f, 0.407902f, 0.875969f, 
		0.990414f, 0.559182f, 0.407902f, 0.875969f, 
		0.990414f, 0.559182f, 0.286908f, 0.304674f, 
		0.176490f, 0.417010f, 0.738790f, 0.466325f, 
		0.738790f, 0.466325f, 0.331528f, 0.800112f, 
		0.629313f, 0.641374f, 0.121436f, 0.971017f, 
		0.384867f, 0.716062f, 0.813994f, 0.932410f, 
		0.932673f, 0.474097f, 0.932673f, 0.474097f, 
		0.618661f, 0.648301f, 0.189637f, 0.488768f, 
		0.738137f, 0.472537f, 0.738137f, 0.472537f, 
		0.738137f, 0.472537f, 0.738137f, 0.472537f, 
		0.738137f, 0.472537f, 0.145562f, 0.100166f, 
		0.145562f, 0.100166f, 0.145562f, 0.100166f, 
		0.128527f, 0.179120f, 0.128527f, 0.179120f, 
		0.128527f, 0.179120f, 0.128527f, 0.179120f, 
		0.682104f, 0.0104860f, 0.682104f, 0.0104860f, 
		0.107845f, 0.0589150f, 0.661364f, 0.000000f, 
		0.133201f, 0.0541900f, 0.133201f, 0.0541900f, 
		0.133201f, 0.0541900f, 0.133201f, 0.0541900f, 
		0.133201f, 0.0541900f, 0.823044f, 0.839668f, 
		0.504552f, 0.0782410f, 0.125747f, 0.140314f, 
		0.716242f, 0.331177f, 0.164826f, 0.375750f, 
		0.127514f, 0.690197f, 0.727284f, 0.889110f, 
		0.118323f, 0.102004f, 0.118323f, 0.102004f, 
		0.118323f, 0.102004f, 0.298222f, 0.301114f, 
		0.736687f, 0.482457f, 0.573396f, 0.644176f, 
		0.883861f, 0.641177f, 0.883861f, 0.641177f, 
		0.426196f, 0.115687f, 0.340851f, 0.977850f, 
		0.437110f, 0.121934f, 0.860696f, 0.974799f, 
		0.286090f, 0.337153f, 0.306667f, 0.527019f, 
		0.614426f, 0.346274f, 0.480714f, 0.825913f, 
		0.480714f, 0.825913f, 0.480714f, 0.825913f, 
		0.00351400f, 0.887943f, 0.796692f, 0.809428f, 
		0.796692f, 0.809428f, 0.796692f, 0.809428f, 
		0.814647f, 0.899237f, 0.415057f, 0.929531f, 
		0.814647f, 0.899237f, 0.630348f, 0.321504f, 
		0.984097f, 0.380447f, 0.984097f, 0.380447f, 
		0.663257f, 0.0169530f, 0.834346f, 0.656712f, 
		0.834346f, 0.656712f, 0.663257f, 0.0169530f, 
		0.663257f, 0.0169530f, 0.663257f, 0.0169530f, 
		0.639233f, 0.0145300f, 0.639233f, 0.0145300f, 
		0.639233f, 0.0145300f, 0.819089f, 0.675998f, 
		0.819089f, 0.675998f, 0.819089f, 0.675998f, 
		0.603639f, 0.658064f, 0.501826f, 0.175132f, 
		0.501826f, 0.175132f, 0.501826f, 0.175132f, 
		0.324495f, 0.254038f, 0.474808f, 0.147195f, 
		0.474808f, 0.147195f, 0.474808f, 0.147195f, 
		0.474808f, 0.147195f, 0.860082f, 0.840158f, 
		0.474808f, 0.147195f, 0.261478f, 0.538198f, 
		0.961802f, 0.509300f, 0.735080f, 0.476489f, 
		0.735080f, 0.476489f, 0.735080f, 0.476489f, 
		0.735080f, 0.476489f, 0.578850f, 0.645839f, 
		0.154508f, 0.856643f, 0.154508f, 0.856643f, 
		0.869002f, 0.990360f, 0.869002f, 0.990360f, 
		0.869002f, 0.990360f, 0.292178f, 0.361848f, 
		0.462142f, 0.859632f, 0.214424f, 0.766338f, 
		0.620106f, 0.0282350f, 0.811820f, 0.696278f, 
		0.620106f, 0.0282350f, 0.811820f, 0.696278f, 
		0.294919f, 0.384413f, 0.692788f, 0.287015f, 
		0.692788f, 0.287015f, 0.692788f, 0.287015f, 
		0.298590f, 0.410342f, 0.589424f, 0.636683f, 
		0.934840f, 0.463506f, 0.934840f, 0.463506f, 
		0.734635f, 0.466219f, 0.734635f, 0.466219f, 
		0.330132f, 0.804009f, 0.209950f, 0.187662f, 
		0.0246840f, 0.708838f, 0.0246840f, 0.708838f, 
		0.723909f, 0.990389f, 0.723909f, 0.990389f, 
		0.127439f, 0.770753f, 0.164813f, 0.637877f, 
		0.00973100f, 0.622492f, 0.0140400f, 0.909514f, 
		0.163212f, 0.0187920f, 0.399121f, 0.758643f, 
		0.461974f, 0.960464f, 0.651830f, 0.324911f, 
		0.813260f, 0.665032f, 0.813260f, 0.665032f, 
		0.813260f, 0.665032f, 0.645275f, 0.00609900f, 
		0.645275f, 0.00609900f, 0.121032f, 0.0183040f, 
		0.121032f, 0.0183040f, 0.0902410f, 0.630231f, 
		0.422703f, 0.837277f, 0.975251f, 0.594793f, 
		0.498818f, 0.871678f, 0.422703f, 0.837277f, 
		0.422703f, 0.837277f, 0.498818f, 0.871678f, 
		0.498818f, 0.871678f, 0.0941760f, 0.745137f, 
		0.0941760f, 0.745137f, 0.0941760f, 0.745137f, 
		0.756106f, 0.618166f, 0.756106f, 0.618166f, 
		0.756106f, 0.618166f, 0.669533f, 0.766007f, 
		0.535631f, 0.892209f, 0.253428f, 0.748118f, 
		0.253428f, 0.748118f, 0.127545f, 0.797626f, 
		0.702566f, 0.759057f, 0.000000f, 0.898670f, 
		0.651830f, 0.324911f, 0.630876f, 0.759057f, 
		0.504196f, 0.896709f, 0.968367f, 0.559738f, 
		0.968367f, 0.559738f, 0.490882f, 0.829281f, 
		0.490882f, 0.829281f, 0.937150f, 0.473431f, 
		0.937150f, 0.473431f, 0.937150f, 0.473431f, 
		0.870368f, 0.637917f, 0.144598f, 0.0272980f, 
		0.830001f, 0.938101f, 0.390616f, 0.735592f, 
		0.250809f, 0.749416f, 0.250809f, 0.749416f, 
		0.503996f, 0.859111f, 0.250809f, 0.749416f, 
		0.199797f, 0.597416f, 0.313890f, 0.297601f, 
		0.319953f, 0.477581f, 0.404285f, 0.109199f, 
		0.404285f, 0.109199f, 0.320619f, 0.995575f, 
		0.587126f, 0.630268f, 0.937285f, 0.466377f, 
		0.937285f, 0.466377f, 0.937285f, 0.466377f, 
		0.820030f, 0.920580f, 0.820030f, 0.920580f, 
		0.820030f, 0.920580f, 0.754642f, 0.574850f, 
		0.197626f, 0.141753f, 0.197626f, 0.141753f, 
		0.197626f, 0.141753f, 0.197626f, 0.141753f, 
		0.197626f, 0.141753f, 0.166092f, 0.339780f, 
		0.182140f, 0.0946670f, 0.182140f, 0.0946670f, 
		0.182140f, 0.0946670f, 0.182140f, 0.0946670f, 
		0.182140f, 0.0946670f, 0.661364f, 0.000000f, 
		0.133201f, 0.0541900f, 0.133201f, 0.0541900f, 
		0.133201f, 0.0541900f, 0.133201f, 0.0541900f, 
		0.133201f, 0.0541900f, 0.165500f, 0.225225f, 
		0.532134f, 0.183887f, 0.532134f, 0.183887f, 
		0.733246f, 0.583322f, 0.714428f, 0.399231f, 
		0.639233f, 0.0145300f, 0.639233f, 0.0145300f, 
		0.639233f, 0.0145300f, 0.819089f, 0.675998f, 
		0.819089f, 0.675998f, 0.584559f, 0.236768f, 
		0.584559f, 0.236768f, 0.584559f, 0.236768f, 
		0.584559f, 0.236768f, 0.584559f, 0.236768f, 
		0.584559f, 0.236768f, 0.584559f, 0.236768f, 
		0.462142f, 0.859632f, 0.214424f, 0.766338f, 
		0.811820f, 0.696278f, 0.620106f, 0.0282350f, 
		0.620106f, 0.0282350f, 0.811820f, 0.696278f, 
		0.230463f, 0.536575f, 0.645181f, 0.313593f, 
		0.495341f, 0.888082f, 0.645181f, 0.313593f, 
		0.393945f, 0.923999f, 0.495341f, 0.888082f, 
		0.495341f, 0.888082f, 0.645181f, 0.313593f, 
		0.645181f, 0.313593f, 0.0268180f, 0.805496f, 
		0.472300f, 0.118881f, 0.155263f, 0.140935f, 
		0.939090f, 0.471753f, 0.579917f, 0.634134f, 
		0.873818f, 0.636328f, 0.172715f, 0.730522f, 
		0.172715f, 0.730522f, 0.172715f, 0.730522f, 
		0.0420180f, 0.940364f, 0.0420180f, 0.940364f, 
		0.505507f, 0.874534f, 0.505507f, 0.874534f, 
		0.505507f, 0.874534f, 0.145562f, 0.100166f, 
		0.145562f, 0.100166f, 0.145562f, 0.100166f, 
		0.156986f, 0.0152070f, 0.368067f, 0.744606f, 
		0.156986f, 0.0152070f, 0.165247f, 0.0458950f, 
		0.165247f, 0.0458950f, 0.165247f, 0.0458950f, 
		0.296551f, 0.335082f, 0.275492f, 0.907371f, 
		0.895926f, 0.888444f, 0.405033f, 0.918451f, 
		0.640122f, 0.307100f, 0.640122f, 0.307100f, 
		0.146484f, 0.856976f, 0.867504f, 0.980748f, 
		0.722411f, 0.815935f, 0.722411f, 0.815935f, 
		0.722411f, 0.815935f, 0.311732f, 0.437819f, 
		0.250809f, 0.749416f, 0.503996f, 0.859111f, 
		0.250809f, 0.749416f, 0.345769f, 0.252145f, 
		0.669533f, 0.766007f, 0.535631f, 0.892209f, 
		0.253428f, 0.748118f, 0.757660f, 0.839324f, 
		0.757660f, 0.839324f, 0.757660f, 0.839324f, 
		0.757660f, 0.839324f, 0.757660f, 0.839324f, 
		0.658778f, 0.645680f, 0.162109f, 0.181607f, 
		0.585438f, 0.635341f, 0.939784f, 0.467048f, 
		0.939784f, 0.467048f, 0.730666f, 0.471135f, 
		0.585438f, 0.635341f, 0.792376f, 0.775917f, 
		0.792376f, 0.775917f, 0.792376f, 0.775917f, 
		0.792376f, 0.775917f, 0.792376f, 0.775917f, 
		0.792376f, 0.775917f, 0.207395f, 0.560070f, 
		0.176169f, 0.306602f, 0.814133f, 0.925620f, 
		0.858280f, 0.928382f, 0.901389f, 0.852961f, 
		0.415408f, 0.951352f, 0.813260f, 0.665032f, 
		0.813260f, 0.665032f, 0.645275f, 0.00609900f, 
		0.645275f, 0.00609900f, 0.121032f, 0.0183040f, 
		0.121032f, 0.0183040f, 0.316390f, 0.670269f, 
		0.316390f, 0.670269f, 0.860801f, 0.576878f, 
		0.860801f, 0.576878f, 0.583177f, 0.315396f, 
		0.583177f, 0.315396f, 0.583177f, 0.315396f, 
		0.796692f, 0.809428f, 0.473500f, 0.973136f, 
		0.473500f, 0.973136f, 0.473500f, 0.973136f, 
		0.243177f, 0.941342f, 0.495858f, 0.802499f, 
		0.495858f, 0.802499f, 0.00970400f, 0.858171f, 
		0.212210f, 0.462610f, 0.0632000f, 0.745235f, 
		0.726569f, 0.616591f, 0.507229f, 0.154519f, 
		0.507229f, 0.154519f, 0.463385f, 0.0752420f, 
		0.830794f, 0.889084f, 0.830794f, 0.889084f, 
		0.463385f, 0.0752420f, 0.164692f, 0.730856f, 
		0.0424350f, 0.930655f, 0.0424350f, 0.930655f, 
		0.0424350f, 0.930655f, 0.0424350f, 0.930655f, 
		0.436116f, 0.144825f, 0.436116f, 0.144825f, 
		0.212210f, 0.529236f, 0.338669f, 0.662146f, 
		0.811569f, 0.544624f, 0.338669f, 0.662146f, 
		0.796169f, 0.675772f, 0.796169f, 0.675772f, 
		0.796169f, 0.675772f, 0.796169f, 0.675772f, 
		0.840809f, 0.850106f, 0.840809f, 0.850106f, 
		0.549285f, 0.927623f, 0.549285f, 0.927623f, 
		1.00000f, 0.336577f, 0.307060f, 0.380148f, 
		0.583177f, 0.315396f, 0.583177f, 0.315396f, 
		0.583177f, 0.315396f, 0.583177f, 0.315396f, 
		0.215602f, 0.496448f, 0.226309f, 0.787441f, 
		0.786752f, 0.702616f, 0.786752f, 0.702616f, 
		0.786752f, 0.702616f, 0.786752f, 0.702616f, 
		0.786752f, 0.702616f, 0.792376f, 0.775917f, 
		0.792376f, 0.775917f, 0.792376f, 0.775917f, 
		0.792376f, 0.775917f, 0.792376f, 0.775917f, 
		0.792376f, 0.775917f, 0.801311f, 0.837783f, 
		0.0631040f, 0.779255f, 0.0631040f, 0.779255f, 
		0.0631040f, 0.779255f, 0.0631040f, 0.779255f, 
		0.0631040f, 0.779255f, 0.392563f, 0.775581f, 
		0.461093f, 0.987911f, 0.000562000f, 0.856530f, 
		0.579999f, 0.347814f, 0.307284f, 0.357034f, 
		0.330470f, 0.157236f, 0.330470f, 0.157236f, 
		0.331666f, 0.163010f, 0.331666f, 0.163010f, 
		0.348678f, 0.158287f, 0.118684f, 0.731599f, 
		0.205582f, 0.627373f, 0.205582f, 0.627373f, 
		0.780433f, 0.641846f, 0.780433f, 0.641846f, 
		0.173376f, 0.685068f, 0.723624f, 0.843027f, 
		0.162690f, 0.00387300f, 0.375123f, 0.763683f, 
		0.567313f, 0.348006f, 0.162690f, 0.00387300f, 
		0.505507f, 0.874534f, 0.838552f, 0.987449f, 
		0.838552f, 0.987449f, 0.262316f, 0.187907f, 
		0.262316f, 0.187907f, 0.262316f, 0.187907f, 
		0.311528f, 0.403660f, 0.733246f, 0.583322f, 
		0.733246f, 0.583322f, 0.532134f, 0.183887f, 
		0.532134f, 0.183887f, 0.532134f, 0.183887f, 
		0.733246f, 0.583322f, 0.783835f, 0.660734f, 
		0.152463f, 0.0180660f, 0.262694f, 0.770519f, 
		0.262694f, 0.770519f, 0.262694f, 0.770519f, 
		0.262694f, 0.770519f, 0.262694f, 0.770519f, 
		0.220637f, 0.0872760f, 0.220637f, 0.0872760f, 
		0.220637f, 0.0872760f, 0.220637f, 0.0872760f, 
		0.220637f, 0.0872760f, 0.165247f, 0.0458950f, 
		0.165247f, 0.0458950f, 0.300826f, 0.205237f, 
		0.643398f, 0.395172f, 0.544278f, 0.869417f, 
		0.544278f, 0.869417f, 0.265313f, 0.769222f, 
		0.269417f, 0.747269f, 0.332307f, 0.163027f, 
		0.278365f, 0.746125f, 0.330255f, 0.157224f, 
		0.318564f, 0.952489f, 0.425298f, 0.151991f, 
		0.425298f, 0.151991f, 0.318564f, 0.952489f, 
		0.193754f, 0.272741f, 0.331880f, 0.293892f, 
		0.372713f, 0.158221f, 0.372713f, 0.158221f, 
		0.372713f, 0.158221f, 0.255551f, 0.707058f, 
		0.372713f, 0.158221f, 0.372713f, 0.158221f, 
		0.372713f, 0.158221f, 0.796169f, 0.675772f, 
		0.796169f, 0.675772f, 0.310332f, 0.332638f, 
		0.284051f, 0.604629f, 0.181939f, 0.544649f, 
		0.761561f, 0.196682f, 0.0126910f, 0.670989f, 
		0.182140f, 0.0946670f, 0.316390f, 0.933896f, 
		0.915150f, 0.934894f, 0.532549f, 0.936117f, 
		0.330745f, 0.153577f, 0.349274f, 0.152005f, 
		0.342503f, 0.154213f, 0.754438f, 0.806933f, 
		0.206087f, 0.714602f, 0.754438f, 0.806933f, 
		0.349869f, 0.163489f, 0.348916f, 0.156404f, 
		0.330503f, 0.155375f, 0.331666f, 0.163010f, 
		0.349345f, 0.150554f, 0.348916f, 0.156404f, 
		0.143592f, 0.796960f, 0.143592f, 0.796960f, 
		0.154103f, 0.797598f, 0.398724f, 0.834757f, 
		0.398724f, 0.834757f, 0.143592f, 0.796960f, 
		0.576439f, 0.390546f, 0.576439f, 0.390546f, 
		0.576439f, 0.390546f, 0.576439f, 0.390546f, 
		0.576439f, 0.390546f, 0.242723f, 0.137745f, 
		0.587712f, 0.607864f, 0.579028f, 0.606552f, 
		0.331547f, 0.149537f, 0.921382f, 0.568867f, 
		0.00685400f, 0.632223f, 0.00340200f, 0.855336f, 
		0.454606f, 0.777478f, 0.454606f, 0.777478f, 
		0.440679f, 0.162926f, 0.0572910f, 0.828394f, 
		0.0572910f, 0.828394f, 0.0572910f, 0.828394f, 
		0.0572910f, 0.828394f, 0.837054f, 0.977837f, 
		0.837054f, 0.977837f, 0.837054f, 0.977837f, 
		0.837054f, 0.977837f, 0.702668f, 0.855967f, 
		0.705239f, 0.632930f, 0.256631f, 0.712501f, 
		0.367076f, 0.160084f, 0.349869f, 0.163489f, 
		0.330255f, 0.157224f, 0.331666f, 0.163010f, 
		0.348678f, 0.158287f, 0.226309f, 0.787441f, 
		0.226309f, 0.787441f, 0.226309f, 0.787441f, 
		0.786752f, 0.702616f, 0.786752f, 0.702616f, 
		0.786752f, 0.702616f, 0.643398f, 0.395172f, 
		0.349869f, 0.163489f, 0.330255f, 0.157224f, 
		0.582070f, 0.588547f, 0.582070f, 0.588547f, 
		0.330745f, 0.153577f, 0.579028f, 0.606552f, 
		0.331201f, 0.149517f, 0.582070f, 0.588547f, 
		0.330745f, 0.153577f, 0.186464f, 0.366700f, 
		0.669533f, 0.775887f, 0.0247400f, 0.853870f, 
		0.432388f, 0.115974f, 0.262694f, 0.770519f, 
		0.262694f, 0.770519f, 0.262694f, 0.770519f, 
		0.330471f, 0.157237f, 0.330471f, 0.157237f, 
		0.330471f, 0.157237f, 0.330471f, 0.157237f, 
		0.331666f, 0.163010f, 0.348678f, 0.158287f, 
		0.331465f, 0.153616f, 0.331465f, 0.153616f, 
		0.331465f, 0.153616f, 0.346653f, 0.153487f, 
		0.335089f, 0.153812f, 0.349309f, 0.151281f, 
		0.346653f, 0.153487f, 0.349345f, 0.150554f, 
		0.349309f, 0.151281f, 0.582070f, 0.588547f, 
		0.330745f, 0.153577f, 0.579028f, 0.606552f, 
		0.331201f, 0.149517f, 0.405033f, 0.960762f, 
		0.671274f, 0.261780f, 0.983478f, 0.327027f, 
		0.671274f, 0.261780f, 0.671274f, 0.261780f, 
		0.521059f, 0.917200f, 0.162531f, 0.856309f, 
		0.870500f, 0.999971f, 0.400951f, 0.785749f, 
		0.177472f, 0.844712f, 0.210616f, 0.426400f, 
		0.332826f, 0.153690f, 0.349345f, 0.150554f, 
		0.349148f, 0.154573f, 0.321922f, 0.206832f, 
		0.544278f, 0.869417f, 0.544278f, 0.869417f, 
		0.544278f, 0.869417f, 0.265313f, 0.769222f, 
		0.349869f, 0.163489f, 0.349148f, 0.154573f, 
		0.330493f, 0.155456f, 0.197626f, 0.141753f, 
		0.576439f, 0.390546f, 0.374543f, 0.151784f, 
		0.374543f, 0.151784f, 0.593916f, 0.566599f, 
		0.374543f, 0.151784f, 0.374543f, 0.151784f, 
		0.349869f, 0.163489f, 0.330255f, 0.157224f, 
		0.331666f, 0.163010f, 0.348678f, 0.158287f, 
		0.349869f, 0.163489f, 0.330255f, 0.157224f, 
		0.331666f, 0.163010f, 0.348678f, 0.158287f, 
		0.367919f, 0.876992f, 0.367919f, 0.876992f, 
		0.191768f, 0.745687f, 0.783835f, 0.660734f, 
		0.152463f, 0.0180660f, 0.809069f, 0.887007f, 
		0.180739f, 0.730189f, 0.0416000f, 0.950074f, 
		0.369808f, 0.895001f, 0.369808f, 0.895001f, 
		0.180739f, 0.730189f, 0.582070f, 0.588547f, 
		0.582070f, 0.588547f, 0.330745f, 0.153577f, 
		0.579028f, 0.606552f, 0.331201f, 0.149517f, 
		0.726639f, 0.805221f, 0.726639f, 0.805221f, 
		0.211181f, 0.682332f, 0.211181f, 0.682332f, 
		0.582070f, 0.588547f, 0.330745f, 0.153577f, 
		0.203434f, 0.0430230f, 0.587700f, 0.607949f, 
		0.579028f, 0.606552f, 0.331462f, 0.149532f, 
		0.582070f, 0.588547f, 0.330745f, 0.153577f, 
		0.579028f, 0.606552f, 0.331201f, 0.149517f, 
		0.683692f, 0.816467f, 0.683692f, 0.816467f, 
		0.423487f, 0.0723540f, 0.838253f, 0.936954f, 
		0.506574f, 0.227216f, 0.506574f, 0.227216f, 
		0.649849f, 0.674954f, 0.649849f, 0.674954f, 
		0.317141f, 0.376734f, 0.0550160f, 0.876691f, 
		0.0550160f, 0.876691f, 0.0550160f, 0.876691f, 
		0.400951f, 0.160312f, 0.0550160f, 0.876691f, 
		0.587319f, 0.0162680f, 0.587316f, 0.0163192f, 
		0.765066f, 0.582159f, 0.765066f, 0.582159f, 
		0.765066f, 0.582159f, 0.326133f, 0.555252f, 
		0.320479f, 0.355926f, 0.392338f, 0.162198f, 
		0.392338f, 0.162198f, 0.883209f, 0.569008f, 
		0.392338f, 0.162198f, 0.883209f, 0.569008f, 
		0.883209f, 0.569008f, 0.781241f, 0.341860f, 
		0.334060f, 0.463543f, 0.653832f, 0.321061f, 
		0.608816f, 0.0163010f, 0.608730f, 0.0178311f, 
		0.860031f, 0.840158f, 0.932285f, 0.936995f, 
		0.543103f, 0.949170f, 0.543103f, 0.949170f, 
		0.802055f, 0.376073f, 0.278241f, 0.745460f, 
		0.819948f, 0.379219f, 0.269514f, 0.747910f, 
		0.769410f, 0.207021f, 0.587355f, 0.0110840f, 
		0.766801f, 0.671207f, 0.337683f, 0.730189f, 
		0.766801f, 0.671207f, 0.337683f, 0.730189f, 
		0.546184f, 0.243318f, 0.735400f, 0.522290f, 
		0.563639f, 0.0158620f, 0.563564f, 0.0172860f, 
		0.466639f, 0.195514f, 0.466639f, 0.195514f, 
		0.466639f, 0.195514f, 0.466639f, 0.195514f, 
		0.630314f, 0.0163340f, 0.630314f, 0.0163340f, 
		0.393643f, 0.156916f, 0.393643f, 0.156916f, 
		0.393643f, 0.156916f, 0.711145f, 0.461842f, 
		0.325557f, 0.426959f, 0.543475f, 0.315278f, 
		0.543475f, 0.315278f, 0.729820f, 0.451830f, 
		0.199926f, 0.315032f, 0.636268f, 0.459026f, 
		0.636268f, 0.459026f, 0.636268f, 0.459026f, 
		0.346939f, 0.209896f, 0.363977f, 0.252311f, 
		0.608783f, 0.0111820f, 0.890711f, 0.421105f, 
		0.728578f, 0.511402f, 0.548968f, 0.375953f, 
		0.579100f, 0.606126f, 0.579100f, 0.606126f, 
		0.587665f, 0.608210f, 0.570528f, 0.605309f, 
		0.203434f, 0.0430230f, 0.665515f, 0.138294f, 
		0.904801f, 0.271515f, 0.0686030f, 0.671049f, 
		0.0686030f, 0.671049f, 0.0686030f, 0.671049f, 
		0.112934f, 0.662263f, 0.504315f, 0.837827f, 
		0.211932f, 0.831911f, 0.539959f, 0.0154550f, 
		0.539959f, 0.0154550f, 0.209950f, 0.187662f, 
		0.891166f, 0.584122f, 0.891166f, 0.584122f, 
		0.377224f, 0.164831f, 0.845162f, 0.369347f, 
		0.377224f, 0.164831f, 0.148646f, 0.827757f, 
		0.148646f, 0.827757f, 0.994292f, 0.309736f, 
		0.994292f, 0.309736f, 0.972760f, 0.0649110f, 
		0.538622f, 0.922264f, 0.220637f, 0.0872760f, 
		0.0563620f, 0.669798f, 0.127880f, 0.659346f, 
		0.638997f, 0.685924f, 0.486540f, 0.217016f, 
		0.630309f, 0.0113410f, 0.630309f, 0.0113410f, 
		0.630309f, 0.0113410f, 0.326141f, 0.330281f, 
		0.586480f, 0.0348934f, 0.322002f, 0.397723f, 
		0.104731f, 0.664493f, 0.0917500f, 0.668462f, 
		0.0784280f, 0.670712f, 0.0784280f, 0.670712f, 
		0.790096f, 0.125632f, 0.0569610f, 0.604341f, 
		0.766801f, 0.671207f, 0.337683f, 0.730189f, 
		0.337683f, 0.730189f, 0.766801f, 0.671207f, 
		0.560928f, 0.0108428f, 0.840531f, 0.369564f, 
		0.372593f, 0.164613f, 0.263342f, 0.708685f, 
		0.263342f, 0.708685f, 0.368063f, 0.164449f, 
		0.816528f, 0.934877f, 0.669606f, 0.845028f, 
		0.669606f, 0.845028f, 0.816528f, 0.934877f, 
		0.816528f, 0.934877f, 0.816528f, 0.934877f, 
		0.756913f, 0.651091f, 0.756913f, 0.651091f, 
		0.183484f, 0.00692800f, 0.269436f, 0.747395f, 
		0.332181f, 0.163024f, 0.278365f, 0.746125f, 
		0.278365f, 0.746125f, 0.330255f, 0.157224f, 
		0.494201f, 0.226904f, 0.0941760f, 0.745137f, 
		0.756106f, 0.618166f, 0.756106f, 0.618166f, 
		0.756106f, 0.618166f, 0.629785f, 0.0258789f, 
		0.0418299f, 0.666605f, 0.138508f, 0.658624f, 
		0.554236f, 0.510247f, 0.896243f, 0.545536f, 
		0.206669f, 0.234784f, 0.275001f, 0.728102f, 
		0.348678f, 0.158287f, 0.348678f, 0.158287f, 
		0.278365f, 0.746125f, 0.330255f, 0.157224f, 
		0.275001f, 0.728102f, 0.348678f, 0.158287f, 
		0.278365f, 0.746125f, 0.330255f, 0.157224f, 
		0.545448f, 0.105036f, 0.250369f, 0.960183f, 
		0.444326f, 0.895699f, 0.974984f, 0.517792f, 
		0.517656f, 0.793957f, 0.275001f, 0.728102f, 
		0.348678f, 0.158287f, 0.543475f, 0.315278f, 
		0.729820f, 0.451830f, 0.265998f, 0.808254f, 
		0.209271f, 0.754330f, 0.265998f, 0.808254f, 
		0.254740f, 0.0756020f, 0.254740f, 0.0756020f, 
		0.254740f, 0.0756020f, 0.851512f, 0.116756f, 
		0.392402f, 0.151521f, 0.392402f, 0.151521f, 
		0.392402f, 0.151521f, 0.786885f, 0.570779f, 
		0.786885f, 0.570779f, 0.392402f, 0.151521f, 
		0.840049f, 0.997060f, 0.381709f, 0.745203f, 
		0.180809f, 0.885856f, 0.0442320f, 0.667212f, 
		0.137262f, 0.658652f, 0.196998f, 0.360400f, 
		0.535373f, 0.831252f, 0.211906f, 0.791178f, 
		0.268617f, 0.806956f, 0.206319f, 0.757374f, 
		0.546184f, 0.243318f, 0.735400f, 0.522290f, 
		0.541237f, 0.0269960f, 0.0118080f, 0.838577f, 
		0.157778f, 0.827324f, 0.473820f, 0.776657f, 
		0.549288f, 0.927623f, 0.570617f, 0.604862f, 
		0.802487f, 0.384385f, 0.802487f, 0.384385f, 
		0.579028f, 0.606552f, 0.579028f, 0.606552f, 
		0.819940f, 0.383421f, 0.524059f, 0.174020f, 
		0.524059f, 0.174020f, 0.524059f, 0.174020f, 
		0.524059f, 0.174020f, 0.524059f, 0.174020f, 
		0.524059f, 0.174020f, 0.0926130f, 0.761909f, 
		0.0926130f, 0.761909f, 0.377263f, 0.759377f, 
		0.377263f, 0.759377f, 0.377263f, 0.759377f, 
		0.377263f, 0.759377f, 0.191823f, 0.867912f, 
		0.275001f, 0.728102f, 0.348678f, 0.158287f, 
		0.278365f, 0.746125f, 0.330255f, 0.157224f, 
		0.0591098f, 0.670079f, 0.124525f, 0.660001f, 
		0.245145f, 0.726710f, 0.751512f, 0.764903f, 
		0.751512f, 0.764903f, 0.751512f, 0.764903f, 
		0.245145f, 0.726710f, 0.350079f, 0.505075f, 
		0.229613f, 0.825176f, 0.754547f, 0.682402f, 
		0.326516f, 0.726001f, 0.754547f, 0.682402f, 
		0.754547f, 0.682402f, 0.326516f, 0.726001f, 
		0.726272f, 0.656487f, 0.204111f, 0.380901f, 
		0.756913f, 0.651091f, 0.756913f, 0.651091f, 
		0.183484f, 0.00692800f, 0.504315f, 0.837827f, 
		0.211932f, 0.831911f, 0.270998f, 0.107609f, 
		0.590127f, 0.590066f, 0.574079f, 0.587409f, 
		1.01000f, 0.396486f, 0.590127f, 0.590066f, 
		0.574079f, 0.587409f, 0.587665f, 0.608210f, 
		0.570528f, 0.605309f, 0.396930f, 0.357049f, 
		0.275001f, 0.728102f, 0.348678f, 0.158287f, 
		0.278365f, 0.746125f, 0.330255f, 0.157224f, 
		0.0977170f, 0.763469f, 0.0977170f, 0.763469f, 
		0.655348f, 0.0178810f, 0.655348f, 0.0178810f, 
		0.655348f, 0.0178810f, 0.655289f, 0.0182987f, 
		0.715741f, 0.0270048f, 0.655368f, 0.0126020f, 
		0.655368f, 0.0126020f, 0.655368f, 0.0126020f, 
		0.507192f, 0.00808700f, 0.507192f, 0.00808700f, 
		0.507192f, 0.00808700f, 0.507192f, 0.00808700f, 
		0.275001f, 0.728102f, 0.348678f, 0.158287f, 
		0.506695f, 0.0134200f, 0.506695f, 0.0134200f, 
		0.506695f, 0.0134200f, 0.506695f, 0.0134200f, 
		0.557893f, 0.615618f, 0.265998f, 0.808254f, 
		0.209271f, 0.754330f, 0.265998f, 0.808254f, 
		0.722993f, 0.369177f, 0.534782f, 0.400641f, 
		0.722993f, 0.369177f, 0.534782f, 0.400641f, 
		0.722993f, 0.369177f, 0.0881000f, 0.760127f, 
		0.0881000f, 0.760127f, 0.0881000f, 0.760127f, 
		0.0881000f, 0.760127f, 0.0881000f, 0.760127f, 
		0.375732f, 0.147526f, 0.375732f, 0.147526f, 
		0.513722f, 0.791878f, 0.843670f, 0.386652f, 
		0.586474f, 0.566279f, 0.586474f, 0.566279f, 
		0.873445f, 0.430146f, 0.406106f, 0.794392f, 
		0.531200f, 0.178536f, 0.424303f, 0.486378f, 
		0.595416f, 0.00598415f, 0.863011f, 0.665608f, 
		0.535373f, 0.831252f, 0.211906f, 0.791178f, 
		0.268617f, 0.806956f, 0.206319f, 0.757374f, 
		0.765066f, 0.582159f, 0.765066f, 0.582159f, 
		0.163614f, 0.610189f, 0.101843f, 0.780097f, 
		0.0950398f, 0.724158f, 0.0950398f, 0.724158f, 
		0.0950398f, 0.724158f, 0.389579f, 0.167493f, 
		0.389579f, 0.167493f, 0.892256f, 0.571766f, 
		0.892256f, 0.571766f, 0.420996f, 0.110571f, 
		0.329337f, 0.374346f, 0.200623f, 0.338545f, 
		0.590127f, 0.590066f, 0.574079f, 0.587409f, 
		0.587665f, 0.608210f, 0.570528f, 0.605309f, 
		0.560990f, 0.00588790f, 0.630303f, 0.00634900f, 
		0.990089f, 0.222783f, 0.369664f, 0.214558f, 
		0.102993f, 0.665013f, 0.0784280f, 0.670712f, 
		0.0802599f, 0.670474f, 0.104191f, 0.723636f, 
		0.104191f, 0.723636f, 0.104191f, 0.723636f, 
		0.229613f, 0.825176f, 0.754547f, 0.682402f, 
		0.326516f, 0.726001f, 0.754547f, 0.682402f, 
		0.754547f, 0.682402f, 0.326516f, 0.726001f, 
		0.242723f, 0.137745f, 0.250431f, 0.489125f, 
		0.785050f, 0.988124f, 0.967006f, 0.568113f, 
		0.745987f, 0.641846f, 0.367599f, 0.714894f, 
		0.367599f, 0.714894f, 0.220148f, 0.00170000f, 
		0.220148f, 0.00170000f, 0.334433f, 0.283099f, 
		0.215867f, 0.402643f, 0.0747340f, 0.600400f, 
		0.115738f, 0.871022f, 0.115738f, 0.871022f, 
		0.115738f, 0.871022f, 0.0747340f, 0.600400f, 
		0.744291f, 0.670897f, 0.339598f, 0.710970f, 
		0.292829f, 0.141675f, 0.292829f, 0.141675f, 
		0.292829f, 0.141675f, 0.292829f, 0.141675f, 
		0.127545f, 0.922709f, 0.0256140f, 0.580506f, 
		0.127545f, 0.922709f, 0.127545f, 0.922709f, 
		0.590127f, 0.590066f, 0.574079f, 0.587409f, 
		0.630123f, 0.0540821f, 1.01718f, 0.559086f, 
		0.775810f, 0.980197f, 0.653726f, 0.0260840f, 
		0.475013f, 0.00569200f, 0.475013f, 0.00569200f, 
		0.475013f, 0.00569200f, 0.475013f, 0.00569200f, 
		0.111968f, 0.723262f, 0.0847803f, 0.722605f, 
		0.0834080f, 0.722261f, 0.0847803f, 0.722605f, 
		0.0847803f, 0.722605f, 0.0847803f, 0.722605f, 
		0.579091f, 0.606179f, 0.579091f, 0.606179f, 
		0.587665f, 0.608210f, 0.570528f, 0.605309f, 
		0.590127f, 0.590066f, 0.574079f, 0.587409f, 
		0.587665f, 0.608210f, 0.570528f, 0.605309f, 
		0.558884f, -0.0164455f, 0.745987f, 0.641846f, 
		0.367599f, 0.714894f, 0.367599f, 0.714894f, 
		0.220148f, 0.00170000f, 0.220148f, 0.00170000f, 
		0.590127f, 0.590066f, 0.574079f, 0.587409f, 
		0.587665f, 0.608210f, 0.570528f, 0.605309f, 
		0.754438f, 0.806933f, 0.206087f, 0.714602f, 
		0.754438f, 0.806933f, 0.636268f, 0.459026f, 
		0.875283f, 0.435992f, 0.875283f, 0.435992f, 
		0.525354f, 0.180956f, 0.506369f, 0.0219920f, 
		0.217266f, 0.359998f, 0.217266f, 0.359998f, 
		0.238543f, 0.0380720f, 0.680705f, 0.0140360f, 
		0.680705f, 0.0140360f, 0.680705f, 0.0140360f, 
		0.286830f, 0.657092f, 0.286830f, 0.657092f, 
		0.0820310f, 0.757969f, 0.291226f, 0.658506f, 
		0.103839f, 0.765148f, 0.103839f, 0.765148f, 
		0.214348f, 0.319242f, 0.533579f, 0.173269f, 
		0.410900f, 0.797754f, 0.533579f, 0.173269f, 
		0.792109f, 0.428174f, 0.218424f, 0.369434f, 
		0.218424f, 0.369434f, 0.244795f, 0.461961f, 
		0.127302f, 0.722547f, 0.801827f, 0.377888f, 
		0.801827f, 0.377888f, 0.801827f, 0.377888f, 
		0.810126f, 0.379687f, 0.810126f, 0.379687f, 
		0.819948f, 0.379219f, 0.819948f, 0.379219f, 
		0.772833f, 0.936561f, 0.772833f, 0.936561f, 
		0.751512f, 0.764903f, 0.751512f, 0.764903f, 
		0.751512f, 0.764903f, 0.245145f, 0.726710f, 
		0.114634f, 0.823333f, 0.121011f, 0.601116f, 
		0.121011f, 0.601116f, 0.121011f, 0.601116f, 
		0.114634f, 0.823333f, 0.508238f, 0.171758f, 
		0.510430f, 0.162941f, 0.509107f, 0.167074f, 
		0.472907f, 0.681784f, 0.744291f, 0.670897f, 
		0.339598f, 0.710970f, 0.505888f, 0.166221f, 
		0.655666f, 0.00749600f, 0.794305f, 0.769526f, 
		0.0743730f, 0.719476f, 0.0743730f, 0.719476f, 
		0.0743730f, 0.719476f, 0.0743730f, 0.719476f, 
		0.537392f, 0.0524890f, 0.521185f, 0.166422f, 
		0.521185f, 0.166422f, 0.521185f, 0.166422f, 
		0.794463f, 0.441997f, 0.794463f, 0.441997f, 
		0.137001f, 0.722135f, 0.210001f, 0.374401f, 
		0.210001f, 0.374401f, 0.507985f, 0.00293900f, 
		0.303473f, 0.865752f, 0.303473f, 0.865752f, 
		0.303473f, 0.865752f, 0.303473f, 0.865752f, 
		0.331022f, 0.747588f, 0.331022f, 0.747588f, 
		0.331022f, 0.747588f, 0.331022f, 0.747588f, 
		0.331022f, 0.747588f, 0.331022f, 0.747588f, 
		0.219180f, 0.344824f, 0.219180f, 0.344824f, 
		0.591691f, 0.759302f, 0.229715f, 0.286610f, 
		0.229715f, 0.286610f, 0.229715f, 0.286610f, 
		0.381190f, 0.711727f, 0.381190f, 0.711727f, 
		0.381190f, 0.711727f, 0.265097f, 0.000000f, 
		0.265097f, 0.000000f, 0.265097f, 0.000000f, 
		0.680382f, 0.0194290f, 0.281703f, 0.658291f, 
		0.281703f, 0.658291f, 0.680150f, 0.0199072f, 
		0.227614f, 0.443030f, 0.227614f, 0.443030f, 
		0.252420f, 0.498448f, 0.205572f, 0.359844f, 
		0.205572f, 0.359844f, 0.191823f, 0.827823f, 
		0.569785f, 0.800309f, 0.304329f, 0.154267f, 
		0.208843f, 0.730189f, 0.208019f, 0.760078f, 
		0.250825f, 0.833637f, 0.205891f, 0.791177f, 
		0.765374f, 0.888691f, 0.819413f, 0.375275f, 
		0.266769f, 0.729708f, 0.819948f, 0.379219f, 
		0.819948f, 0.379219f, 0.269514f, 0.747910f, 
		0.473399f, 0.0130581f, 0.777307f, 0.989809f, 
		0.777307f, 0.989809f, 0.254740f, 0.0756020f, 
		0.127127f, 0.932419f, 0.127127f, 0.932419f, 
		0.0162280f, 0.580814f, 0.0162280f, 0.580814f, 
		0.238543f, 0.0380720f, 0.193144f, 0.794359f, 
		0.584620f, 0.764659f, 0.205891f, 0.733233f, 
		0.209268f, 0.757374f, 0.331969f, 0.555284f, 
		0.381190f, 0.711727f, 0.381190f, 0.711727f, 
		0.265097f, 0.000000f, 0.265097f, 0.000000f, 
		0.757660f, 0.839324f, 0.757660f, 0.839324f, 
		0.757660f, 0.839324f, 0.757660f, 0.839324f, 
		0.757660f, 0.839324f, 0.561315f, 0.807279f, 
		0.400951f, 0.817721f, 0.499171f, 0.165086f, 
		0.499171f, 0.165086f, 0.499171f, 0.165086f, 
		0.143689f, 0.722324f, 0.899858f, 0.0632478f, 
		0.209062f, 0.337577f, 0.209062f, 0.337577f, 
		0.214440f, 0.850560f, 0.205890f, 0.747988f, 
		0.326088f, 0.701860f, 0.326088f, 0.701860f, 
		0.583490f, 0.0792631f, 0.898601f, 0.584585f, 
		0.843202f, 0.373742f, 0.843202f, 0.373742f, 
		0.843202f, 0.373742f, 0.843202f, 0.373742f, 
		0.270510f, 0.707024f, 0.778805f, 0.999420f, 
		0.778805f, 0.999420f, 0.322816f, 0.730189f, 
		0.791322f, 0.455914f, 0.507267f, 0.162201f, 
		0.350872f, 0.288531f, 0.609071f, 0.0800560f, 
		0.208843f, 0.730189f, 0.208019f, 0.760078f, 
		0.250825f, 0.833637f, 0.205891f, 0.791177f, 
		0.400951f, 0.710494f, 0.312798f, 0.000662000f, 
		0.126709f, 0.942128f, 0.00684100f, 0.581122f, 
		0.287729f, 0.880685f, 0.287729f, 0.880685f, 
		0.287729f, 0.880685f, 0.787998f, 0.451740f, 
		0.787998f, 0.451740f, 0.509107f, 0.167074f, 
		0.791924f, 0.452751f, 0.510430f, 0.162941f, 
		0.221961f, 0.359075f, 0.221961f, 0.359075f, 
		0.973793f, 0.715948f, 0.732930f, 0.662344f, 
		0.349641f, 0.696299f, 0.476595f, 0.000000f, 
		0.336089f, 0.418705f, 0.193144f, 0.794359f, 
		0.584620f, 0.764659f, 0.205891f, 0.733233f, 
		0.209268f, 0.757374f, 0.118684f, 0.731599f, 
		0.205582f, 0.627373f, 0.205582f, 0.627373f, 
		0.780433f, 0.641846f, 0.780433f, 0.641846f, 
		0.286357f, 0.0642500f, 0.534782f, 0.400641f, 
		0.534782f, 0.400641f, 0.722993f, 0.369177f, 
		0.722993f, 0.369177f, 0.681028f, 0.00864400f, 
		0.291957f, 0.655893f, 0.225798f, 0.328102f, 
		0.225798f, 0.328102f, 0.225798f, 0.328102f, 
		1.08033f, 0.381804f, 0.191823f, 0.827823f, 
		0.569785f, 0.800309f, 0.506190f, 0.166365f, 
		0.506190f, 0.166365f, 0.506190f, 0.166365f, 
		0.218232f, 0.322995f, 0.218232f, 0.322995f, 
		0.396267f, -0.00923202f, 0.225633f, 0.445935f, 
		0.642587f, 0.840462f, 0.677746f, 0.0248580f, 
		0.335447f, 0.390295f, 0.214440f, 0.850560f, 
		0.205890f, 0.747988f, 0.326088f, 0.701860f, 
		0.326088f, 0.701860f, 0.326088f, 0.701860f, 
		0.509107f, 0.167074f, 0.879050f, 0.455096f, 
		0.878439f, 0.453108f, 0.878439f, 0.453108f, 
		0.508238f, 0.171758f, 0.745249f, -0.0389483f, 
		0.224020f, 0.346386f, 0.224020f, 0.346386f, 
		0.224020f, 0.346386f, 0.224020f, 0.346386f, 
		0.0592910f, 0.714975f, 0.0592910f, 0.714975f, 
		0.0592910f, 0.714975f, 0.868815f, 0.366484f, 
		0.893259f, 0.560469f, 0.893259f, 0.560469f, 
		1.02482f, 0.202733f, 0.510430f, 0.162941f, 
		0.508238f, 0.171758f, 0.506250f, 0.170987f, 
		0.506250f, 0.170987f, 0.508301f, 0.162419f, 
		0.561315f, 0.807279f, 0.400951f, 0.817721f, 
		0.137001f, 0.722135f, 0.732930f, 0.662344f, 
		0.349641f, 0.696299f, 0.222477f, 0.366565f, 
		0.222477f, 0.366565f, 0.0722310f, 0.754841f, 
		0.0722310f, 0.754841f, 0.0722310f, 0.754841f, 
		0.473265f, 0.0203620f, 0.582070f, 0.588547f, 
		0.802040f, 0.384410f, 0.579028f, 0.606552f, 
		0.579028f, 0.606552f, 0.819940f, 0.383421f, 
		0.0698530f, 0.635897f, 0.0698530f, 0.635897f, 
		0.879739f, 0.458551f, 0.502795f, 0.170139f, 
		0.218670f, 0.392422f, 0.218670f, 0.392422f, 
		0.218670f, 0.392422f, 0.754275f, 0.991283f, 
		0.220983f, 0.489365f, 0.271660f, 0.0342000f, 
		0.271660f, 0.0342000f, 0.271660f, 0.0342000f, 
		0.260902f, 0.534029f, 0.508152f, 0.172016f, 
		0.878338f, 0.453194f, 0.878338f, 0.453194f, 
		0.508152f, 0.172016f, 0.696858f, 0.847127f, 
		0.207301f, 0.367260f, 0.208022f, 0.784285f, 
		0.445523f, 0.840737f, 0.191824f, 0.773378f, 
		0.629685f, 0.759057f, 0.629685f, 0.759057f, 
		0.771112f, 0.522385f, 0.771112f, 0.522385f, 
		0.771112f, 0.522385f, 0.819413f, 0.375275f, 
		0.266769f, 0.729708f, 0.268382f, 0.740407f, 
		0.819948f, 0.379219f, 0.269514f, 0.747910f, 
		0.579000f, 0.566378f, 0.840971f, 0.382459f, 
		0.248472f, 0.249156f, 0.561212f, 0.759057f, 
		0.443658f, 0.839164f, 0.209272f, 0.781581f, 
		0.443658f, 0.839164f, 0.802074f, 0.376072f, 
		0.278237f, 0.745441f, 0.819948f, 0.379219f, 
		0.819948f, 0.379219f, 0.269514f, 0.747910f, 
		0.105228f, 0.553109f, 0.803405f, 0.599472f, 
		0.803405f, 0.599472f, 0.250181f, 0.592007f, 
		0.250181f, 0.592007f, 0.206875f, 0.231864f, 
		0.270998f, 0.107609f, 0.230056f, 0.304386f, 
		0.422424f, 0.763370f, 0.491336f, 0.163724f, 
		0.226854f, 0.507434f, 0.339494f, 0.153129f, 
		0.632748f, 0.0808540f, 0.506290f, 0.792714f, 
		0.844453f, 0.381023f, 0.844453f, 0.381023f, 
		0.844453f, 0.381023f, 0.844453f, 0.381023f, 
		0.844453f, 0.381023f, 0.844453f, 0.381023f, 
		0.527255f, 0.166421f, 0.791035f, 0.436296f, 
		0.791035f, 0.436296f, 0.791035f, 0.436296f, 
		0.303726f, 0.0826290f, 0.630059f, 0.524065f, 
		0.208022f, 0.784285f, 0.208022f, 0.784285f, 
		0.445523f, 0.840737f, 0.191824f, 0.773378f, 
		0.629685f, 0.759057f, 0.629685f, 0.759057f, 
		0.768643f, 0.450359f, 0.768643f, 0.450359f, 
		0.768643f, 0.450359f, 0.222933f, 0.377287f, 
		0.222933f, 0.377287f, 0.582070f, 0.588547f, 
		0.579028f, 0.606552f, 0.819940f, 0.383421f, 
		0.734735f, 0.936975f, 0.0807680f, 0.691740f, 
		0.0807680f, 0.691740f, 0.734735f, 0.936975f, 
		0.561212f, 0.759057f, 0.443658f, 0.839164f, 
		0.209272f, 0.781581f, 0.443658f, 0.839164f, 
		0.365479f, 0.682674f, 0.494354f, 0.159848f, 
		0.789812f, 0.468604f, 0.494577f, 0.159887f, 
		0.582070f, 0.588547f, 0.802040f, 0.384410f, 
		0.802040f, 0.384410f, 0.191823f, 0.730189f, 
		0.597061f, 0.782763f, 0.338086f, 0.680404f, 
		0.547910f, 0.827478f, 0.218917f, 0.383778f, 
		0.218917f, 0.383778f, 0.819413f, 0.375275f, 
		0.266769f, 0.729708f, 0.266769f, 0.729708f, 
		0.819948f, 0.379219f, 0.269514f, 0.747910f, 
		0.812130f, 0.375610f, 0.266769f, 0.729708f, 
		0.802047f, 0.380072f, 0.388178f, 0.995039f, 
		0.655225f, 0.231662f, 0.879624f, 0.435138f, 
		0.879624f, 0.435138f, 0.879624f, 0.435138f, 
		0.879624f, 0.435138f, 0.879624f, 0.435138f, 
		0.301749f, 0.0343640f, 0.295761f, 0.0343314f, 
		0.295761f, 0.0343314f, 0.295761f, 0.0343314f, 
		0.301749f, 0.0343640f, 0.295761f, 0.0343314f, 
		0.509107f, 0.167074f, 0.787998f, 0.451740f, 
		0.787563f, 0.453878f, 0.507022f, 0.166471f, 
		0.507022f, 0.166471f, 0.286357f, 0.0642500f, 
		0.748027f, 0.653932f, 0.365479f, 0.682674f, 
		0.348673f, 0.447755f, 0.230690f, 0.332907f, 
		0.230690f, 0.332907f, 0.230690f, 0.332907f, 
		1.08850f, 0.566968f, 0.0187730f, 0.630260f, 
		0.283053f, 0.667170f, 0.585542f, 0.523679f, 
		0.585542f, 0.523679f, 0.282509f, 0.697404f, 
		0.282509f, 0.697404f, 0.111602f, 0.766908f, 
		0.111602f, 0.766908f, 0.111602f, 0.766908f, 
		0.111602f, 0.766908f, 0.111602f, 0.766908f, 
		0.337227f, 0.358068f, 0.191823f, 0.730189f, 
		0.597061f, 0.782763f, 0.338086f, 0.680404f, 
		0.547910f, 0.827478f, 0.582070f, 0.588547f, 
		0.801390f, 0.376104f, 0.801390f, 0.376104f, 
		0.801930f, 0.382145f, 0.579028f, 0.606552f, 
		0.579028f, 0.606552f, 0.816879f, 0.382031f, 
		0.819948f, 0.379219f, 0.819948f, 0.379219f, 
		0.656619f, 0.0542030f, 0.490758f, 0.159152f, 
		0.490758f, 0.159152f, 0.789452f, 0.472424f, 
		0.232449f, 0.310258f, 0.232449f, 0.310258f, 
		0.232449f, 0.310258f, 0.819413f, 0.375275f, 
		0.266769f, 0.729708f, 0.226394f, 0.357141f, 
		0.226394f, 0.357141f, 0.879050f, 0.455096f, 
		0.509107f, 0.167074f, 0.507022f, 0.166471f, 
		0.878439f, 0.453108f, 0.270566f, 0.565905f, 
		0.566615f, -0.0883766f, 0.768643f, 0.450359f, 
		0.768643f, 0.450359f, 0.768643f, 0.450359f, 
		0.229943f, 0.356288f, 0.229943f, 0.356288f, 
		0.405591f, 0.801750f, 0.0407500f, 0.710714f, 
		0.284051f, 0.604629f, 0.262316f, 0.187907f, 
		0.262316f, 0.187907f, 0.262316f, 0.187907f, 
		0.361141f, 0.159040f, 0.884018f, 0.851718f, 
		0.127302f, 0.722547f, 0.288467f, 0.825242f, 
		0.288467f, 0.825242f, 0.288467f, 0.825242f, 
		0.582070f, 0.588547f, 0.802040f, 0.384410f, 
		0.579028f, 0.606552f, 0.579028f, 0.606552f, 
		0.819940f, 0.383421f, 0.228879f, 0.345853f, 
		0.228879f, 0.345853f, 0.503350f, 0.0506050f, 
		0.436652f, 0.0116500f, 0.436652f, 0.0116500f, 
		0.232132f, 0.347066f, 0.232132f, 0.347066f, 
		0.235653f, 0.316512f, 0.235653f, 0.316512f, 
		0.235653f, 0.316512f, 0.235653f, 0.316512f, 
		0.235653f, 0.316512f, 0.230180f, 0.361874f, 
		0.230180f, 0.361874f, 0.164813f, 0.637877f, 
		0.164813f, 0.637877f, 0.164813f, 0.637877f, 
		0.127439f, 0.770753f, 0.164813f, 0.637877f, 
		0.573999f, 0.458707f, 0.573999f, 0.458707f, 
		0.573999f, 0.458707f, 0.570621f, 0.604837f, 
		0.802512f, 0.384384f, 0.802512f, 0.384384f, 
		0.579028f, 0.606552f, 0.819940f, 0.383421f, 
		0.802201f, 0.380065f, 0.819948f, 0.379219f, 
		0.580204f, 0.890854f, 0.307674f, 0.0572360f, 
		0.307674f, 0.0572360f, 0.307674f, 0.0572360f, 
		0.307674f, 0.0572360f, 0.584620f, 0.801607f, 
		0.584620f, 0.801607f, 0.584620f, 0.801607f, 
		0.355581f, 0.659010f, 0.355581f, 0.659010f, 
		0.550308f, 0.811591f, 0.550308f, 0.811591f, 
		0.582070f, 0.588547f, 0.802040f, 0.384410f, 
		0.226667f, 0.362933f, 0.226667f, 0.362933f, 
		0.243841f, 0.0478457f, 0.390511f, 0.146033f, 
		0.512631f, 0.779338f, 0.777730f, 0.571991f, 
		0.859128f, 0.388086f, 0.694092f, 0.690977f, 
		0.694092f, 0.690977f, 0.694092f, 0.690977f, 
		0.694092f, 0.690977f, 0.117003f, 0.634822f, 
		0.117003f, 0.634822f, 0.117003f, 0.634822f, 
		0.117003f, 0.634822f, 0.117003f, 0.634822f, 
		0.573999f, 0.458707f, 0.549288f, 0.979298f, 
		0.992435f, 0.283323f, 0.992435f, 0.283323f, 
		0.860082f, 0.929841f, 0.983328f, 0.0357830f, 
		0.771112f, 0.522385f, 0.288060f, 0.696361f, 
		0.0340700f, 0.708530f, 0.722411f, 0.980777f, 
		0.722411f, 0.980777f, 0.0340700f, 0.708530f, 
		0.0340700f, 0.708530f, 0.358736f, 0.589873f, 
		0.358736f, 0.589873f, 0.800808f, 0.621800f, 
		0.800808f, 0.621800f, 0.800808f, 0.621800f, 
		0.800808f, 0.621800f, 0.277097f, 0.698268f, 
		0.277097f, 0.698268f, 0.253773f, 0.481651f, 
		0.253773f, 0.481651f, 0.801390f, 0.376104f, 
		0.801894f, 0.379148f, 0.815781f, 0.379418f, 
		0.386238f, 0.220430f, 0.789325f, 0.472891f, 
		0.491686f, 0.159328f, 0.491686f, 0.159328f, 
		0.789807f, 0.468655f, 0.783717f, 0.451156f, 
		0.791924f, 0.452751f, 0.787998f, 0.451740f, 
		0.584620f, 0.801607f, 0.584620f, 0.801607f, 
		0.584620f, 0.801607f, 0.355581f, 0.659010f, 
		0.355581f, 0.659010f, 0.550308f, 0.811591f, 
		0.550308f, 0.811591f, 0.703996f, 0.530081f, 
		0.250181f, 0.592007f, 0.803405f, 0.599472f, 
		0.803405f, 0.599472f, 0.250181f, 0.592007f, 
		0.250181f, 0.592007f, 0.250181f, 0.592007f, 
		0.211181f, 0.682332f, 0.726639f, 0.805221f, 
		0.726639f, 0.805221f, 0.211181f, 0.682332f, 
		0.211181f, 0.682332f, 0.211181f, 0.682332f, 
		0.491435f, 0.168174f, 0.881818f, 0.469911f, 
		0.405591f, 0.801750f, 0.226287f, 0.373616f, 
		0.226287f, 0.373616f, 0.483522f, 0.162631f, 
		0.438230f, 0.00595900f, 0.535310f, 0.0793670f, 
		0.303726f, 0.0826290f, 0.881790f, 0.428363f, 
		0.406155f, 0.802737f, 0.980544f, 0.516185f, 
		0.881790f, 0.428363f, 0.406155f, 0.802737f, 
		0.980544f, 0.516185f, 0.883123f, 0.454713f, 
		0.882719f, 0.452684f, 0.882719f, 0.452684f, 
		0.327584f, 0.0993180f, 0.327584f, 0.0993180f, 
		0.758557f, 0.361529f, 0.758557f, 0.361529f, 
		0.758557f, 0.361529f, 0.787563f, 0.453878f, 
		0.787563f, 0.453878f, 0.787563f, 0.453878f, 
		0.787563f, 0.453878f, 0.0562760f, 0.750243f, 
		0.0562760f, 0.750243f, 0.0562760f, 0.750243f, 
		0.0562760f, 0.750243f, 0.0562760f, 0.750243f, 
		0.250489f, 0.483867f, 0.250489f, 0.483867f, 
		0.604847f, 0.836067f, 0.485544f, 0.158101f, 
		0.788034f, 0.477638f, 0.435625f, 0.0173470f, 
		0.435625f, 0.0173470f, 0.435813f, 0.0183573f, 
		0.435813f, 0.0183573f, 0.127514f, 0.690197f, 
		0.727284f, 0.889110f, 0.727284f, 0.889110f, 
		0.127514f, 0.690197f, 0.985184f, 0.515037f, 
		0.787664f, 0.429288f, 0.985184f, 0.515037f, 
		0.410721f, 0.803061f, 0.787664f, 0.429288f, 
		0.0828880f, 0.784326f, 0.0828880f, 0.784326f, 
		0.0828880f, 0.784326f, 0.387249f, 0.168848f, 
		0.482185f, 0.162507f, 0.482185f, 0.162507f, 
		0.482185f, 0.162507f, 0.232369f, 0.365794f, 
		0.232369f, 0.365794f, 0.232369f, 0.365794f, 
		0.232369f, 0.365794f, 0.791924f, 0.452751f, 
		0.783717f, 0.451156f, 0.783717f, 0.451156f, 
		0.783346f, 0.453315f, 0.791486f, 0.454880f, 
		1.03908f, 0.745587f, 0.111968f, 0.723262f, 
		0.318426f, 0.0647560f, 0.318426f, 0.0647560f, 
		0.318426f, 0.0647560f, 0.318426f, 0.0647560f, 
		0.721577f, 0.171660f, 0.455745f, 0.896328f, 
		0.292829f, 0.141675f, 0.292829f, 0.141675f, 
		0.292829f, 0.141675f, 0.292829f, 0.141675f, 
		1.02778f, 0.200669f, 0.269951f, 0.660853f, 
		0.269951f, 0.660853f, 0.269951f, 0.660853f, 
		0.269951f, 0.660853f, 0.269951f, 0.660853f, 
		0.000000f, 0.630876f, 0.000000f, 0.630876f, 
		0.268617f, 0.829091f, 0.268617f, 0.829091f, 
		0.268617f, 0.829091f, 0.237522f, 0.335397f, 
		0.236056f, 0.335881f, 0.237522f, 0.335397f, 
		0.909436f, 0.0520551f, 0.104971f, 0.455843f, 
		0.883123f, 0.454713f, 0.883123f, 0.454713f, 
		0.882738f, 0.452978f, 0.882738f, 0.452978f, 
		0.882738f, 0.452978f, 0.235760f, 0.347882f, 
		0.00938600f, 0.630568f, 0.00938600f, 0.630568f, 
		0.581421f, 0.125198f, 0.381461f, -0.0801984f, 
		0.786409f, 0.459856f, 0.786409f, 0.459856f, 
		0.786409f, 0.459856f, 0.0386024f, 0.710082f, 
		0.642401f, 0.811479f, 0.681662f, 0.0535690f, 
		0.604933f, 0.128182f, 0.239244f, 0.339112f, 
		0.239244f, 0.339112f, 0.239244f, 0.339112f, 
		0.239244f, 0.339112f, 0.239244f, 0.339112f, 
		0.437364f, 0.0234430f, 0.437364f, 0.0234430f, 
		0.437364f, 0.0234430f, 0.0850568f, 0.722674f, 
		0.0889470f, 0.723650f, 0.0850568f, 0.722674f, 
		0.0834080f, 0.722261f, 0.0834080f, 0.722261f, 
		0.0893840f, 0.785578f, 0.229602f, 0.368649f, 
		0.229602f, 0.368649f, 0.338744f, 0.604716f, 
		0.338744f, 0.604716f, 0.338744f, 0.604716f, 
		0.338744f, 0.604716f, 0.838120f, 0.656322f, 
		0.838120f, 0.656322f, 0.756701f, 0.953120f, 
		0.0747710f, 0.783301f, 0.484757f, 0.167546f, 
		0.883649f, 0.476589f, 0.883649f, 0.476589f, 
		0.484757f, 0.167546f, 0.630059f, 0.524065f, 
		0.883746f, 0.458830f, 0.883746f, 0.458830f, 
		0.883123f, 0.454713f, 0.883123f, 0.454713f, 
		0.987702f, 0.541099f, 0.986988f, 0.539008f, 
		0.882946f, 0.453825f, 0.887135f, 0.452599f, 
		0.0592910f, 0.714975f, 0.0592910f, 0.714975f, 
		0.0592910f, 0.714975f, 0.785573f, 0.465032f, 
		0.498149f, 0.158534f, 0.785573f, 0.465032f, 
		0.785573f, 0.465032f, 0.104191f, 0.723636f, 
		0.234706f, 0.354574f, 0.978229f, 0.522484f, 
		0.883739f, 0.434899f, 0.978229f, 0.522484f, 
		0.883739f, 0.434899f, 0.883739f, 0.434899f, 
		1.09441f, 0.378575f, 0.0743730f, 0.719476f, 
		0.0743730f, 0.719476f, 0.0743730f, 0.719476f, 
		0.0743730f, 0.719476f, 0.0774362f, 0.308117f, 
		0.348682f, 0.591594f, 0.290370f, 0.767346f, 
		0.290370f, 0.767346f, 0.290370f, 0.767346f, 
		0.290370f, 0.767346f, 0.290370f, 0.767346f, 
		0.278328f, 0.737536f, 0.278328f, 0.737536f, 
		0.278328f, 0.737536f, 0.284181f, 0.736994f, 
		0.367134f, 0.485070f, 0.116525f, 0.149250f, 
		0.0152980f, 0.709146f, 0.725407f, 1.00000f, 
		0.725407f, 1.00000f, 0.271041f, 0.755352f, 
		0.271041f, 0.755352f, 0.271041f, 0.755352f, 
		0.750960f, -0.0526874f, 0.468909f, 0.0484710f, 
		0.234317f, 0.360447f, 0.234317f, 0.360447f, 
		0.234317f, 0.360447f, 0.242314f, 0.420399f, 
		0.335681f, 0.863081f, 0.0981520f, 0.723983f, 
		0.177834f, 0.491168f, 0.243464f, 0.321374f, 
		0.987702f, 0.541099f, 0.883123f, 0.454713f, 
		0.986988f, 0.539008f, 0.886963f, 0.451423f, 
		0.173376f, 0.685068f, 0.723624f, 0.843027f, 
		0.110462f, 0.580298f, 0.229520f, 0.387814f, 
		0.229520f, 0.387814f, 0.229520f, 0.387814f, 
		0.229520f, 0.387814f, 0.879050f, 0.455096f, 
		0.791486f, 0.454880f, 0.507803f, 0.164242f, 
		0.787563f, 0.453878f, 0.507803f, 0.164242f, 
		0.507022f, 0.166471f, 0.878439f, 0.453108f, 
		0.878439f, 0.453108f, 0.791486f, 0.454880f, 
		0.506250f, 0.170987f, 0.783346f, 0.453315f, 
		0.0931700f, 0.724263f, 0.989076f, 0.540687f, 
		0.989076f, 0.540687f, 0.882719f, 0.452684f, 
		0.887269f, 0.453514f, 0.988419f, 0.538577f, 
		0.986988f, 0.539008f, 0.883123f, 0.454713f, 
		0.883123f, 0.454713f, 0.886963f, 0.451423f, 
		0.882719f, 0.452684f, 0.399590f, 0.676722f, 
		0.399590f, 0.676722f, 0.399590f, 0.676722f, 
		0.229746f, 0.381363f, 0.229746f, 0.381363f, 
		0.278498f, 0.265705f, 0.278498f, 0.265705f, 
		0.278498f, 0.265705f, 0.278498f, 0.265705f, 
		0.345477f, 0.327156f, 0.493817f, 0.156665f, 
		0.785259f, 0.469364f, 0.659163f, 0.0815670f, 
		0.785317f, 0.468322f, 0.785317f, 0.468322f, 
		0.785317f, 0.468322f, 0.457128f, 0.817040f, 
		0.214424f, 0.730216f, 0.457128f, 0.817040f, 
		0.474680f, 0.161629f, 0.474680f, 0.161629f, 
		0.474680f, 0.161629f, 0.996310f, 0.539064f, 
		0.783346f, 0.453315f, 0.995862f, 0.536905f, 
		0.787563f, 0.453878f, 0.787563f, 0.453878f, 
		0.996310f, 0.539064f, 0.992232f, 0.539742f, 
		0.787998f, 0.451740f, 0.787563f, 0.453878f, 
		0.991707f, 0.537586f, 0.992360f, 0.537479f, 
		0.626586f, 0.130087f, 0.884353f, 0.480432f, 
		0.480913f, 0.166915f, 0.884353f, 0.480432f, 
		0.480913f, 0.166915f, 0.480913f, 0.166915f, 
		0.259254f, 0.293666f, 0.0246840f, 0.708838f, 
		0.0246840f, 0.708838f, 0.723909f, 0.990389f, 
		0.723909f, 0.990389f, 0.787998f, 0.451740f, 
		0.996310f, 0.539064f, 0.995862f, 0.536905f, 
		0.783717f, 0.451156f, 0.784781f, 0.443862f, 
		0.784781f, 0.443862f, 0.993724f, 0.529612f, 
		0.210402f, 0.730189f, 0.459651f, 0.817295f, 
		0.459651f, 0.817295f, 0.630439f, 0.789976f, 
		0.630439f, 0.789976f, 0.559792f, 0.126747f, 
		0.758557f, 0.361529f, 0.758557f, 0.361529f, 
		0.758557f, 0.361529f, 0.758557f, 0.361529f, 
		0.758557f, 0.361529f, 0.231754f, 0.794417f, 
		0.327584f, 0.0993180f, 0.327584f, 0.0993180f, 
		0.154153f, 0.696971f, 0.269951f, 0.660853f, 
		0.269951f, 0.660853f, 0.269951f, 0.660853f, 
		0.242119f, 0.341507f, 0.242030f, 0.341732f, 
		0.127068f, 0.768932f, 0.342133f, 0.0717010f, 
		0.342133f, 0.0717010f, 0.225511f, 0.468262f, 
		0.399865f, 0.0119170f, 0.272492f, 0.738244f, 
		0.272492f, 0.738244f, 0.280548f, 0.519953f, 
		0.253670f, 0.302010f, 0.457128f, 0.817040f, 
		0.457128f, 0.817040f, 0.457128f, 0.817040f, 
		0.214424f, 0.730216f, 0.457128f, 0.817040f, 
		0.250661f, 0.306421f, 0.250661f, 0.306421f, 
		0.250661f, 0.306421f, 0.250661f, 0.306421f, 
		0.250661f, 0.306421f, 0.885637f, 0.469141f, 
		0.885637f, 0.469141f, 0.791144f, 0.457042f, 
		0.506139f, 0.161964f, 0.791924f, 0.452751f, 
		0.510430f, 0.162941f, 0.407485f, 0.179831f, 
		0.407485f, 0.179831f, 0.407485f, 0.179831f, 
		0.210402f, 0.730189f, 0.459651f, 0.817295f, 
		0.459651f, 0.817295f, 0.630439f, 0.789976f, 
		0.630439f, 0.789976f, 0.224724f, 0.473986f, 
		0.224724f, 0.473986f, 0.398842f, 0.0176130f, 
		0.398842f, 0.0176130f, 0.984416f, 0.521067f, 
		0.984416f, 0.521067f, 0.984416f, 0.521067f, 
		0.885601f, 0.469083f, 0.885601f, 0.469083f, 
		0.885601f, 0.469083f, 0.885479f, 0.485480f, 
		0.885479f, 0.485480f, 0.475865f, 0.166254f, 
		0.249440f, 0.312597f, 0.249440f, 0.312597f, 
		0.249440f, 0.312597f, 0.499171f, 0.165086f, 
		0.499171f, 0.165086f, 0.494354f, 0.159848f, 
		0.494354f, 0.159848f, 0.489624f, 0.163355f, 
		0.489624f, 0.163355f, 0.493667f, 0.168414f, 
		0.493446f, 0.164178f, 0.489729f, 0.167991f, 
		0.483522f, 0.162631f, 0.300826f, 0.205237f, 
		0.475714f, 0.157353f, 0.784927f, 0.487468f, 
		0.896034f, 0.529235f, 0.900049f, 0.367676f, 
		0.275344f, 0.521799f, 0.275344f, 0.521799f, 
		0.275344f, 0.521799f, 0.567107f, 0.831671f, 
		0.567107f, 0.831671f, 0.234917f, 0.367089f, 
		0.234917f, 0.367089f, 0.230667f, 0.376134f, 
		0.230667f, 0.376134f, 1.10281f, 0.568363f, 
		0.549045f, 0.375944f, 0.781060f, 0.485567f, 
		0.783904f, 0.475098f, 0.783904f, 0.475098f, 
		0.783904f, 0.475098f, 0.936870f, 0.900192f, 
		0.0959100f, 0.787276f, 0.384982f, 0.103786f, 
		0.902209f, 0.562024f, 0.867260f, 0.371766f, 
		0.867260f, 0.371766f, 0.867260f, 0.371766f, 
		0.902209f, 0.562024f, 0.0366620f, 0.745568f, 
		0.246671f, 0.346312f, 0.244080f, 0.346127f, 
		0.244080f, 0.346127f, 0.887269f, 0.453514f, 
		0.986988f, 0.539008f, 0.882719f, 0.452684f, 
		0.884831f, 0.454219f, 0.988232f, 0.543240f, 
		0.883489f, 0.456822f, 0.725807f, 0.297180f, 
		0.533787f, 0.473766f, 0.499931f, 0.0779740f, 
		0.579183f, 0.238278f, 0.567869f, -0.103352f, 
		0.810520f, 0.524906f, 0.262160f, 0.518147f, 
		0.991707f, 0.537586f, 0.991707f, 0.537586f, 
		0.991707f, 0.537586f, 0.992620f, 0.541925f, 
		0.992620f, 0.541925f, 0.239921f, 0.352566f, 
		0.971451f, 0.970685f, 0.287173f, 0.981924f, 
		0.533580f, 0.977854f, 0.533580f, 0.977854f, 
		0.533580f, 0.977854f, 0.618387f, 0.241066f, 
		0.852172f, 0.949498f, 0.494354f, 0.159848f, 
		0.494354f, 0.159848f, 0.485544f, 0.158101f, 
		0.493817f, 0.156665f, 0.785259f, 0.469364f, 
		0.503367f, 0.780380f, 0.858220f, 0.382757f, 
		0.858220f, 0.382757f, 0.669749f, 0.446434f, 
		0.886727f, 0.473778f, 0.886727f, 0.473778f, 
		0.237392f, 0.360262f, 0.604277f, 1.01020f, 
		0.207879f, -0.0151912f, 0.493446f, 0.164178f, 
		0.498948f, 0.169255f, 0.500258f, 0.160890f, 
		0.718505f, 0.334456f, 0.992232f, 0.539742f, 
		0.992232f, 0.539742f, 0.991707f, 0.537586f, 
		0.991707f, 0.537586f, 0.347006f, 0.408252f, 
		0.0635490f, 0.782185f, 0.493667f, 0.168414f, 
		0.881336f, 0.467679f, 0.499171f, 0.165086f, 
		0.879539f, 0.457179f, 0.239026f, 0.397963f, 
		0.996310f, 0.539064f, 0.996310f, 0.539064f, 
		0.783346f, 0.453315f, 0.783346f, 0.453315f, 
		0.996310f, 0.539064f, 0.783346f, 0.453315f, 
		0.358900f, 0.435920f, 0.223411f, 0.479631f, 
		0.223411f, 0.479631f, 0.397819f, 0.0233100f, 
		0.756066f, 0.0151735f, 0.397993f, 0.0234633f, 
		0.873761f, 0.653048f, 0.498948f, 0.169255f, 
		0.880447f, 0.462398f, 0.493446f, 0.164178f, 
		0.885080f, 0.467334f, 0.417152f, 0.338084f, 
		0.783904f, 0.475098f, 0.781060f, 0.485567f, 
		0.784927f, 0.487468f, 0.778672f, 0.471181f, 
		0.493446f, 0.164178f, 0.490758f, 0.159152f, 
		0.498149f, 0.158534f, 0.785573f, 0.465032f, 
		0.283481f, 0.774339f, 0.283481f, 0.774339f, 
		0.283481f, 0.774339f, 0.283481f, 0.774339f, 
		0.283481f, 0.774339f, 0.382522f, 0.252887f, 
		0.861696f, 0.377250f, 0.249017f, 0.342902f, 
		0.249017f, 0.342902f, 0.489624f, 0.163355f, 
		0.485544f, 0.158101f, 0.484757f, 0.167546f, 
		0.787158f, 0.456019f, 0.995862f, 0.536905f, 
		0.787158f, 0.456019f, 0.787998f, 0.451740f, 
		0.996663f, 0.541233f, 0.783717f, 0.451156f, 
		0.00180500f, 0.790491f, 0.158221f, 0.870380f, 
		0.996663f, 0.541233f, 0.782927f, 0.455483f, 
		0.996663f, 0.541233f, 0.782927f, 0.455483f, 
		0.409862f, 0.242346f, 0.585542f, 0.523679f, 
		0.489624f, 0.163355f, 0.489624f, 0.163355f, 
		0.484757f, 0.167546f, 0.886008f, 0.470344f, 
		0.883649f, 0.476589f, 0.249047f, 0.344008f, 
		0.248365f, 0.344098f, 0.249047f, 0.344008f, 
		0.249343f, 0.343969f, 0.249047f, 0.344008f, 
		0.490758f, 0.159152f, 0.490758f, 0.159152f, 
		0.483522f, 0.162631f, 0.783904f, 0.475098f, 
		0.783904f, 0.475098f, 0.693728f, 0.713512f, 
		0.693728f, 0.713512f, 0.497908f, 0.283730f, 
		0.376884f, 0.526904f, 0.299854f, 0.258676f, 
		0.299854f, 0.258676f, 0.299854f, 0.258676f, 
		0.236389f, 0.363303f, 0.236389f, 0.363303f, 
		0.236389f, 0.363303f, 0.504881f, 0.165999f, 
		0.504881f, 0.165999f, 0.509107f, 0.167074f, 
		0.509107f, 0.167074f, 0.884162f, 0.462074f, 
		0.887597f, 0.455655f, 0.507776f, 0.164553f, 
		0.789971f, 0.454493f, 0.507776f, 0.164553f, 
		0.879050f, 0.455096f, 0.504167f, 0.170400f, 
		0.786271f, 0.460560f, 0.504881f, 0.165999f, 
		0.881519f, 0.462305f, 0.376134f, 0.453227f, 
		0.400986f, 0.759057f, 0.759520f, 0.0195293f, 
		0.759520f, 0.0195293f, 0.401463f, 0.0265230f, 
		0.401463f, 0.0265230f, 0.218893f, 0.481989f, 
		0.467034f, 0.545257f, 0.314888f, 0.640858f, 
		0.314888f, 0.640858f, 0.314888f, 0.640858f, 
		0.504196f, 0.831252f, 0.604624f, 0.576334f, 
		0.728848f, 0.693673f, 0.800872f, 0.0703990f, 
		0.728848f, 0.693673f, 0.785573f, 0.465032f, 
		0.785573f, 0.465032f, 0.499171f, 0.165086f, 
		0.499171f, 0.165086f, 0.788231f, 0.461681f, 
		0.787158f, 0.456019f, 0.499171f, 0.165086f, 
		0.665523f, 0.138274f, 0.136915f, 0.769440f, 
		0.504167f, 0.170400f, 0.878439f, 0.453108f, 
		0.878439f, 0.453108f, 0.508238f, 0.171758f, 
		0.879539f, 0.457179f, 0.398325f, 0.649537f, 
		0.398325f, 0.649537f, 0.398325f, 0.649537f, 
		0.550267f, 0.759057f, 0.550267f, 0.759057f, 
		0.550267f, 0.759057f, 0.550267f, 0.759057f, 
		0.447215f, 0.162720f, 0.891329f, 0.514131f, 
		0.891329f, 0.514131f, 0.447215f, 0.162720f, 
		0.437205f, 0.132977f, 0.769440f, 0.206988f, 
		0.816617f, 0.436336f, 0.339494f, 0.153129f, 
		0.545444f, 0.105080f, 0.813076f, 0.449911f, 
		0.887269f, 0.453514f, 0.987702f, 0.541099f, 
		0.887269f, 0.453514f, 0.987702f, 0.541099f, 
		0.780564f, 0.466586f, 0.780564f, 0.466586f, 
		0.780564f, 0.466586f, 0.347828f, 0.803752f, 
		0.998008f, 0.552335f, 0.533787f, 0.473766f, 
		0.725807f, 0.297180f, 0.243889f, 0.355709f, 
		0.244114f, 0.354111f, 0.244114f, 0.354111f, 
		0.250616f, 0.338422f, 0.250616f, 0.338422f, 
		0.250545f, 0.338360f, 0.250545f, 0.338360f, 
		0.250545f, 0.338360f, 0.642216f, 0.782497f, 
		0.685577f, 0.0822800f, 0.883489f, 0.456822f, 
		0.885080f, 0.467334f, 0.885080f, 0.467334f, 
		0.883489f, 0.456822f, 0.489729f, 0.167991f, 
		0.483522f, 0.162631f, 0.882186f, 0.471617f, 
		0.885479f, 0.485480f, 0.888257f, 0.460846f, 
		0.993414f, 0.547704f, 0.780564f, 0.466586f, 
		0.883489f, 0.456822f, 0.783346f, 0.453315f, 
		0.992232f, 0.539742f, 0.991188f, 0.540055f, 
		0.993414f, 0.547704f, 0.781924f, 0.461391f, 
		0.235859f, 0.370663f, 0.235859f, 0.370663f, 
		0.235859f, 0.370663f, 0.235859f, 0.370663f, 
		0.909888f, 0.000000f, 0.909888f, 0.000000f, 
		0.964947f, 0.000000f, 0.964947f, 0.000000f, 
		0.398738f, 0.638927f, 0.549193f, 0.759946f, 
		0.549193f, 0.759946f, 0.744281f, 0.620669f, 
		0.744226f, 0.620992f, 0.744226f, 0.620992f, 
		0.744281f, 0.620669f, 0.989645f, 0.551280f, 
		0.989645f, 0.551280f, 0.348170f, 0.795575f, 
		0.888841f, 0.463695f, 0.888841f, 0.463695f, 
		0.536558f, 0.128241f, 0.810520f, 0.524906f, 
		0.262160f, 0.518147f, 0.321922f, 0.206832f, 
		0.847035f, 0.304434f, 0.314888f, 0.640858f, 
		0.314888f, 0.640858f, 0.314888f, 0.640858f, 
		0.314888f, 0.640858f, 0.504196f, 0.831252f, 
		0.504196f, 0.831252f, 0.292075f, 0.813350f, 
		1.05215f, 0.751455f, 0.763337f, 0.579213f, 
		0.252178f, 0.341889f, 0.252178f, 0.341889f, 
		0.420997f, 0.110573f, 0.103293f, 0.789078f, 
		0.103293f, 0.789078f, 0.103293f, 0.789078f, 
		0.400986f, 0.759057f, 0.889146f, 0.465409f, 
		0.348170f, 0.795575f, 0.889146f, 0.465409f, 
		0.889146f, 0.465409f, 0.989831f, 0.552994f, 
		0.996909f, 0.547328f, 0.996909f, 0.547328f, 
		0.781892f, 0.461579f, 0.781892f, 0.461579f, 
		0.996909f, 0.547328f, 0.781892f, 0.461579f, 
		0.275304f, 0.345144f, 0.249664f, 0.344388f, 
		0.249495f, 0.344727f, 0.249742f, 0.344232f, 
		0.441679f, 1.01740f, 0.813076f, 0.449911f, 
		0.158233f, 0.457256f, 0.786271f, 0.460560f, 
		0.494354f, 0.159848f, 0.785259f, 0.469364f, 
		0.789789f, 0.468827f, 0.382178f, 0.110060f, 
		0.420477f, 0.190202f, 0.992232f, 0.539742f, 
		0.992232f, 0.539742f, 0.992232f, 0.539742f, 
		0.992232f, 0.539742f, 0.992232f, 0.539742f, 
		0.884162f, 0.462074f, 0.881336f, 0.467679f, 
		0.886008f, 0.470344f, 0.884162f, 0.462074f, 
		0.884162f, 0.462074f, 0.343529f, 0.383679f, 
		0.803759f, 0.360177f, 0.803759f, 0.360177f, 
		0.803759f, 0.360177f, 0.803759f, 0.360177f, 
		0.803759f, 0.360177f, 0.803759f, 0.360177f, 
		0.378080f, -0.0949554f, 0.298538f, 0.581446f, 
		0.745568f, 0.606813f, 0.745568f, 0.606813f, 
		-0.0166494f, 0.441898f, 0.490758f, 0.159152f, 
		0.785573f, 0.465032f, 0.789452f, 0.472424f, 
		0.789452f, 0.472424f, 0.778958f, 0.468432f, 
		0.888028f, 0.459047f, 0.989148f, 0.546632f, 
		0.746412f, 0.622023f, 0.746412f, 0.622023f, 
		0.890944f, 0.465344f, 0.890944f, 0.465344f, 
		0.346373f, 0.796737f, 0.791886f, 1.01565f, 
		0.0152110f, 0.740203f, 0.464650f, 0.160443f, 
		0.780809f, 0.465663f, 0.996244f, 0.551332f, 
		0.996244f, 0.551332f, 0.347564f, 0.802153f, 
		0.347564f, 0.802153f, 0.780809f, 0.465663f, 
		0.754130f, 0.584849f, 0.891179f, 0.426978f, 
		0.754130f, 0.584849f, 0.754130f, 0.584849f, 
		0.754130f, 0.584849f, 0.240409f, 0.386548f, 
		0.240409f, 0.386548f, 0.240409f, 0.386548f, 
		0.240409f, 0.386548f, 0.784927f, 0.487468f, 
		0.783904f, 0.475098f, 0.781060f, 0.485567f, 
		0.989044f, 0.222126f, 0.464553f, 0.0765810f, 
		0.475714f, 0.157353f, 0.464650f, 0.160443f, 
		0.475865f, 0.166254f, 0.288120f, 0.811805f, 
		0.288120f, 0.811805f, 0.288120f, 0.811805f, 
		0.288120f, 0.811805f, 0.879282f, 0.0842934f, 
		0.778958f, 0.468432f, 0.778958f, 0.468432f, 
		0.778958f, 0.468432f, 0.778958f, 0.468432f, 
		0.500430f, 0.678306f, 0.338086f, 0.584623f, 
		0.921179f, 0.643455f, 0.741533f, 0.605345f, 
		0.741533f, 0.605345f, 0.746173f, 0.604069f, 
		0.746173f, 0.604069f, 0.746173f, 0.604069f, 
		0.249950f, 0.342670f, 0.249950f, 0.342670f, 
		0.249902f, 0.343254f, 0.249837f, 0.343379f, 
		0.882186f, 0.471617f, 0.885080f, 0.467334f, 
		0.885080f, 0.467334f, 0.886727f, 0.473778f, 
		0.886727f, 0.473778f, 0.304326f, 0.154262f, 
		0.454525f, 0.154344f, 0.0629059f, 0.100279f, 
		0.893375f, 0.482632f, 0.889619f, 0.483408f, 
		0.891068f, 0.490155f, 0.788034f, 0.477638f, 
		0.778672f, 0.471181f, 0.778672f, 0.471181f, 
		0.788034f, 0.477638f, 0.778672f, 0.471181f, 
		0.784927f, 0.487468f, -0.0124898f, 0.267134f, 
		0.239550f, 0.365019f, 0.237675f, 0.367272f, 
		0.464182f, 0.164528f, 0.474680f, 0.161629f, 
		0.474680f, 0.161629f, 0.883649f, 0.476589f, 
		0.890344f, 0.497164f, 0.740101f, 0.621595f, 
		0.779081f, 0.466752f, 0.779081f, 0.466752f, 
		0.346345f, 0.803048f, 0.275330f, 0.457719f, 
		0.992620f, 0.541925f, 0.992620f, 0.541925f, 
		0.992620f, 0.541925f, 0.474680f, 0.161629f, 
		0.781060f, 0.485567f, 0.238855f, 0.382125f, 
		0.238855f, 0.382125f, 0.238855f, 0.382125f, 
		0.238855f, 0.382125f, 0.783904f, 0.475098f, 
		0.784927f, 0.487468f, 0.781060f, 0.485567f, 
		0.788034f, 0.477638f, 0.992620f, 0.541925f, 
		0.996909f, 0.547328f, 0.996909f, 0.547328f, 
		0.993838f, 0.552161f, 0.886008f, 0.470344f, 
		0.889619f, 0.483408f, 0.887597f, 0.455655f, 
		0.988232f, 0.543240f, 0.889146f, 0.465409f, 
		0.989831f, 0.552994f, 0.898452f, 0.500659f, 
		0.885479f, 0.485480f, 0.464182f, 0.164528f, 
		0.890344f, 0.497164f, 0.552876f, 0.531818f, 
		1.05083f, 0.387101f, 0.159755f, 0.463865f, 
		0.159755f, 0.463865f, 0.159755f, 0.463865f, 
		0.0480280f, 0.780674f, 0.0480280f, 0.780674f, 
		0.0480280f, 0.780674f, 0.0480280f, 0.780674f, 
		0.0480280f, 0.780674f, 0.403650f, 0.227208f, 
		0.284113f, 0.809934f, 0.284113f, 0.809934f, 
		0.284166f, 0.810259f, 0.284166f, 0.810259f, 
		0.267333f, 0.592565f, 0.465024f, 0.156124f, 
		0.465024f, 0.156124f, 0.465024f, 0.156124f, 
		0.780454f, 0.498157f, 0.780454f, 0.498157f, 
		0.605312f, 0.787846f, 0.605476f, 0.778465f, 
		0.772846f, 0.471959f, 0.785259f, 0.469364f, 
		0.778672f, 0.471181f, 0.778672f, 0.471181f, 
		0.738891f, 0.620890f, 0.738891f, 0.620890f, 
		0.777957f, 0.466047f, 0.738891f, 0.620890f, 
		0.777957f, 0.466047f, 0.777957f, 0.466047f, 
		0.355858f, 0.633364f, 0.355858f, 0.633364f, 
		0.355858f, 0.633364f, 0.584649f, 0.848280f, 
		0.355858f, 0.633364f, 0.355858f, 0.633364f, 
		0.516440f, 0.790178f, 0.516440f, 0.790178f, 
		0.745542f, 0.609869f, 0.745542f, 0.609869f, 
		0.745542f, 0.609869f, 0.667118f, 0.718550f, 
		0.324495f, 0.254038f, 0.891369f, 0.467474f, 
		0.891369f, 0.467474f, 0.891438f, 0.468234f, 
		0.891369f, 0.467474f, 0.891438f, 0.468234f, 
		0.139107f, 0.769506f, 0.803759f, 0.360177f, 
		0.803759f, 0.360177f, 0.803759f, 0.360177f, 
		0.803759f, 0.360177f, 0.803759f, 0.360177f, 
		0.803759f, 0.360177f, 0.330802f, 0.824649f, 
		0.896263f, 0.545539f, 0.732297f, -0.0128673f, 
		0.251875f, 0.346826f, 0.251875f, 0.346826f, 
		0.251875f, 0.346826f, 0.251698f, 0.346990f, 
		0.284803f, 0.974010f, 0.238452f, 0.376128f, 
		0.238452f, 0.376128f, 0.226852f, 0.507394f, 
		0.993790f, 0.551653f, 0.743658f, 0.621628f, 
		0.743658f, 0.621628f, 0.347138f, 0.799582f, 
		0.346502f, 0.799491f, 0.993790f, 0.551653f, 
		0.777117f, 0.459723f, 0.740402f, 0.614567f, 
		0.740402f, 0.614567f, 0.777117f, 0.459723f, 
		0.577447f, 0.171138f, 0.340816f, 0.452699f, 
		0.346390f, 0.797094f, 0.891567f, 0.466246f, 
		0.746754f, 0.621596f, 0.885479f, 0.485480f, 
		0.885479f, 0.485480f, 0.898452f, 0.500659f, 
		0.891973f, 0.500172f, 0.891973f, 0.500172f, 
		0.890344f, 0.497164f, -0.00944847f, 0.604497f, 
		0.900211f, 0.371643f, 0.900211f, 0.371643f, 
		0.900211f, 0.371643f, 0.900211f, 0.371643f, 
		0.746173f, 0.604069f, 0.741533f, 0.605345f, 
		0.741533f, 0.605345f, 0.745657f, 0.606250f, 
		0.750831f, 0.605557f, 0.750831f, 0.605557f, 
		0.355858f, 0.633364f, 0.355858f, 0.633364f, 
		0.584649f, 0.848280f, 0.355858f, 0.633364f, 
		0.355858f, 0.633364f, 0.516440f, 0.790178f, 
		0.516440f, 0.790178f, 0.747810f, 0.621741f, 
		0.747810f, 0.621741f, 0.892556f, 0.465062f, 
		0.249966f, 0.344192f, 0.249971f, 0.344237f, 
		0.249952f, 0.344144f, 0.656691f, 0.135224f, 
		0.778649f, 0.469202f, 0.346345f, 0.803048f, 
		0.778649f, 0.469202f, 0.739634f, 0.621323f, 
		0.778649f, 0.469202f, 0.206872f, 0.231861f, 
		0.361141f, 0.159040f, 0.777109f, 0.452697f, 
		0.777109f, 0.452697f, 0.741110f, 0.607540f, 
		0.255276f, 0.343365f, 0.259161f, 0.348410f, 
		0.254399f, 0.341850f, 0.255276f, 0.343365f, 
		0.255276f, 0.343365f, 0.461594f, 0.160050f, 
		0.461594f, 0.160050f, 0.461594f, 0.160050f, 
		0.461594f, 0.160050f, 0.461594f, 0.160050f, 
		0.0881000f, 0.760127f, 0.0881000f, 0.760127f, 
		0.0881000f, 0.760127f, 0.267134f, 0.316650f, 
		0.265607f, 0.317203f, 0.265210f, 0.317268f, 
		0.267134f, 0.316650f, 0.298538f, 0.581446f, 
		0.778969f, 0.500399f, 0.460763f, 0.158048f, 
		0.460763f, 0.158048f, 0.778969f, 0.500399f, 
		0.460763f, 0.158048f, 0.785259f, 0.469364f, 
		0.785259f, 0.469364f, 0.772846f, 0.471959f, 
		0.773061f, 0.467401f, 0.778958f, 0.468432f, 
		0.257370f, 0.589423f, 0.501768f, 0.838695f, 
		0.748096f, 0.615969f, 0.893195f, 0.459290f, 
		0.893195f, 0.459290f, 0.368476f, 0.282729f, 
		0.0820310f, 0.757969f, 0.955819f, 0.407690f, 
		0.598935f, 0.175229f, 0.781892f, 0.461579f, 
		0.781892f, 0.461579f, 0.778958f, 0.468432f, 
		0.778958f, 0.468432f, 0.346345f, 0.803048f, 
		0.346345f, 0.803048f, 0.993838f, 0.552161f, 
		0.993838f, 0.552161f, 0.0366620f, 0.745568f, 
		0.780454f, 0.498157f, 0.780454f, 0.498157f, 
		0.779557f, 0.493269f, 0.0926130f, 0.761909f, 
		0.0926130f, 0.761909f, 0.0926130f, 0.761909f, 
		0.0926130f, 0.761909f, 0.289132f, 0.492665f, 
		0.695266f, 0.146367f, 0.889619f, 0.483408f, 
		0.885479f, 0.485480f, 0.885479f, 0.485480f, 
		0.891011f, 0.489887f, 0.891483f, 0.492086f, 
		0.891483f, 0.492086f, 0.715749f, 0.0269883f, 
		0.749623f, 0.609832f, 0.893184f, 0.453154f, 
		0.893777f, 0.431212f, 0.758856f, 0.589296f, 
		0.893777f, 0.431212f, 0.893777f, 0.431212f, 
		0.742017f, 0.603162f, 0.772397f, 0.448424f, 
		0.776961f, 0.448393f, 0.742000f, 0.603236f, 
		0.242115f, 0.364945f, 0.241847f, 0.364690f, 
		0.890944f, 0.465344f, 0.891369f, 0.467474f, 
		0.891369f, 0.467474f, 0.346373f, 0.796737f, 
		0.888257f, 0.460846f, 0.989634f, 0.548431f, 
		0.890944f, 0.465344f, 0.149006f, 0.884257f, 
		0.776276f, 0.431685f, 0.747642f, 0.586528f, 
		0.747642f, 0.586528f, 0.776276f, 0.431685f, 
		0.0722310f, 0.754841f, 0.0722310f, 0.754841f, 
		0.0722310f, 0.754841f, 0.462122f, 0.163447f, 
		0.462122f, 0.163447f, 0.891498f, 0.499294f, 
		0.891498f, 0.499294f, 0.462122f, 0.163447f, 
		0.0476468f, 0.756911f, 0.851528f, 0.116739f, 
		0.461174f, 0.163539f, 0.891973f, 0.500172f, 
		0.159219f, 0.470238f, 0.159219f, 0.470238f, 
		0.159219f, 0.470238f, 0.742537f, 0.0801077f, 
		0.742537f, 0.0801077f, 0.745657f, 0.606250f, 
		0.745657f, 0.606250f, 0.897789f, 0.451755f, 
		0.893191f, 0.450988f, 0.750239f, 0.607351f, 
		0.893174f, 0.450672f, 0.947384f, 0.909932f, 
		0.244951f, 0.361264f, 0.243313f, 0.361806f, 
		0.244073f, 0.361117f, 0.244951f, 0.361264f, 
		0.244951f, 0.361264f, 0.243313f, 0.361806f, 
		0.346502f, 0.799491f, 0.346502f, 0.799491f, 
		0.998008f, 0.552335f, 0.993414f, 0.547704f, 
		0.558883f, -0.0164311f, 0.250231f, 0.354519f, 
		0.262765f, 0.330040f, 0.862980f, 0.665594f, 
		0.283041f, 0.667154f, 0.740533f, 0.613306f, 
		0.740533f, 0.613306f, 0.777114f, 0.458462f, 
		0.777114f, 0.458462f, 0.0562760f, 0.750243f, 
		0.0562760f, 0.750243f, 0.0562760f, 0.750243f, 
		0.0562760f, 0.750243f, 0.461594f, 0.160050f, 
		0.458436f, 0.159734f, 0.458436f, 0.159734f, 
		0.458436f, 0.159734f, 0.458436f, 0.159734f, 
		0.0977170f, 0.763469f, 0.0977170f, 0.763469f, 
		0.726704f, 0.717877f, 0.726704f, 0.717877f, 
		0.743339f, 0.719945f, 0.533042f, 0.325581f, 
		0.533042f, 0.325581f, 0.833152f, 0.0656330f, 
		0.111777f, 0.791244f, 0.111777f, 0.791244f, 
		0.111777f, 0.791244f, 0.111777f, 0.791244f, 
		0.111777f, 0.791244f, 0.780454f, 0.498157f, 
		0.780454f, 0.498157f, 0.779557f, 0.493269f, 
		0.779557f, 0.493269f, 0.777808f, 0.489634f, 
		1.05863f, 0.563128f, 0.748496f, 0.0800870f, 
		0.159644f, 0.472813f, 0.422402f, 0.763364f, 
		0.893135f, 0.453823f, 0.893135f, 0.453823f, 
		0.749522f, 0.610502f, 0.498500f, 0.135651f, 
		0.200165f, -0.0283399f, 0.346939f, 0.209896f, 
		0.138190f, 0.335793f, 0.886727f, 0.473778f, 
		0.886727f, 0.473778f, 0.891483f, 0.492086f, 
		0.891483f, 0.492086f, 0.891628f, 0.470324f, 
		0.891483f, 0.492086f, 0.319624f, 0.447724f, 
		0.557627f, 0.174126f, 0.557627f, 0.174126f, 
		0.319624f, 0.447724f, 0.952933f, 0.244050f, 
		0.618315f, 1.08064f, 0.276344f, 0.311341f, 
		0.562486f, -0.0598635f, 0.784927f, 0.487468f, 
		0.788034f, 0.477638f, 0.781060f, 0.485567f, 
		0.897789f, 0.451755f, 0.745657f, 0.606250f, 
		0.745657f, 0.606250f, 0.750135f, 0.607667f, 
		0.893191f, 0.450988f, 0.893191f, 0.450988f, 
		0.461594f, 0.160050f, 0.465024f, 0.156124f, 
		0.474680f, 0.161629f, 0.464182f, 0.164528f, 
		0.244409f, 0.367413f, 0.244409f, 0.367413f, 
		0.244409f, 0.367413f, 0.244409f, 0.367413f, 
		0.244409f, 0.367413f, 0.461594f, 0.160050f, 
		0.892951f, 0.503115f, 0.892951f, 0.503115f, 
		0.458231f, 0.162829f, 0.892951f, 0.503115f, 
		0.889619f, 0.483408f, 0.897409f, 0.471811f, 
		0.893375f, 0.482632f, 0.893375f, 0.482632f, 
		0.893375f, 0.482632f, 0.287948f, 0.843011f, 
		0.287948f, 0.843011f, 0.287948f, 0.843011f, 
		0.772397f, 0.448424f, 0.772397f, 0.448424f, 
		0.742017f, 0.603162f, 0.746173f, 0.604069f, 
		0.772472f, 0.450612f, 0.461718f, 0.156406f, 
		0.778406f, 0.501464f, 0.461718f, 0.156406f, 
		0.461718f, 0.156406f, 0.778406f, 0.501464f, 
		0.396271f, -0.00921462f, 0.456469f, 0.770952f, 
		0.214380f, 0.764311f, 0.943072f, 0.610812f, 
		0.949847f, 0.602540f, 0.127068f, 0.768932f, 
		0.778406f, 0.501464f, 0.461718f, 0.156406f, 
		0.777102f, 0.504682f, 0.458499f, 0.156634f, 
		0.464026f, 0.171756f, 0.565174f, 0.816655f, 
		0.475865f, 0.166254f, 0.885479f, 0.485480f, 
		0.885479f, 0.485480f, 0.464650f, 0.160443f, 
		0.898535f, 0.497523f, 0.890344f, 0.497164f, 
		0.891973f, 0.500172f, 0.780564f, 0.466586f, 
		0.785259f, 0.469364f, 0.785259f, 0.469364f, 
		0.773061f, 0.467401f, 0.773061f, 0.467401f, 
		0.778672f, 0.471181f, 0.889146f, 0.465409f, 
		0.891628f, 0.470324f, 0.892556f, 0.465062f, 
		0.897123f, 0.468060f, 0.210359f, 0.764284f, 
		0.326455f, 0.682310f, 0.628273f, 0.828548f, 
		0.628273f, 0.828548f, 0.437205f, 0.132977f, 
		0.747810f, 0.621741f, 0.745235f, 0.615099f, 
		0.889146f, 0.465409f, 0.347903f, 0.796610f, 
		0.783904f, 0.475098f, 0.778958f, 0.468432f, 
		0.778958f, 0.468432f, 0.773061f, 0.467401f, 
		0.898229f, 0.504531f, 0.898229f, 0.504531f, 
		0.924753f, 0.368252f, 0.103839f, 0.765148f, 
		0.103839f, 0.765148f, 0.794294f, 0.769515f, 
		0.500819f, 0.131658f, 0.891369f, 0.467474f, 
		0.893375f, 0.482632f, 0.897409f, 0.471811f, 
		0.461718f, 0.156406f, 0.778406f, 0.501464f, 
		0.777102f, 0.504682f, 0.458499f, 0.156634f, 
		0.425891f, 0.0759792f, 0.777300f, 0.506022f, 
		0.457159f, 0.156531f, 0.457159f, 0.156531f, 
		0.777300f, 0.506022f, 0.381942f, 0.462452f, 
		0.247370f, 0.360789f, 0.250562f, 0.360958f, 
		0.250562f, 0.360958f, 0.249664f, 0.360910f, 
		0.456469f, 0.770952f, 0.214380f, 0.764311f, 
		0.461718f, 0.156406f, 0.464650f, 0.160443f, 
		0.779557f, 0.493269f, 0.779557f, 0.493269f, 
		0.778406f, 0.501464f, 0.778406f, 0.501464f, 
		0.889619f, 0.483408f, 0.891483f, 0.492086f, 
		0.891483f, 0.492086f, 0.890344f, 0.497164f, 
		0.853793f, 0.516702f, 0.298097f, 0.514647f, 
		0.104972f, 0.455844f, 0.894786f, 0.484430f, 
		0.894786f, 0.484430f, 0.894786f, 0.484430f, 
		0.286908f, 0.304674f, 0.957354f, 0.0617430f, 
		0.973017f, 0.0624570f, 0.896291f, 0.421667f, 
		0.896291f, 0.421667f, 0.896291f, 0.421667f, 
		0.462687f, 0.796634f, 0.757991f, 0.578671f, 
		0.757991f, 0.578671f, 0.620424f, 0.179320f, 
		0.620424f, 0.179320f, 0.620424f, 0.179320f, 
		0.620424f, 0.179320f, 0.326596f, 0.0756450f, 
		0.941737f, 0.603898f, 0.327461f, 0.0776844f, 
		0.943002f, 0.601760f, 0.210359f, 0.764284f, 
		0.326455f, 0.682310f, 0.628273f, 0.828548f, 
		0.628273f, 0.828548f, 0.740402f, 0.614567f, 
		0.740402f, 0.614567f, 0.779081f, 0.466752f, 
		0.347828f, 0.803752f, 0.772846f, 0.463303f, 
		0.772846f, 0.463303f, 0.772846f, 0.463303f, 
		0.347621f, 0.368734f, 0.0304220f, 0.778804f, 
		0.744226f, 0.620992f, 0.893195f, 0.459290f, 
		0.893195f, 0.459290f, 0.891369f, 0.467474f, 
		0.744226f, 0.620992f, 0.891369f, 0.467474f, 
		0.247956f, 0.369697f, 0.247956f, 0.369697f, 
		0.247956f, 0.369697f, 0.247956f, 0.369697f, 
		0.251557f, 0.377659f, 0.252603f, 0.379151f, 
		0.243842f, 0.0478478f, 0.780454f, 0.498157f, 
		0.779557f, 0.493269f, 0.779557f, 0.493269f, 
		0.341672f, 0.607131f, 0.568435f, 0.785016f, 
		0.568435f, 0.785016f, 0.369247f, 0.421605f, 
		0.742017f, 0.603162f, 0.750831f, 0.605557f, 
		0.745657f, 0.606250f, 0.387249f, 0.168848f, 
		0.284369f, 0.842210f, 0.247798f, 0.624394f, 
		0.291715f, 0.871507f, 0.371958f, 0.0898240f, 
		0.760484f, 0.287946f, 0.760484f, 0.287946f, 
		0.760484f, 0.287946f, 0.503576f, 0.487908f, 
		0.552876f, 0.531818f, 0.464650f, 0.160443f, 
		0.458800f, 0.162966f, 0.460984f, 0.159989f, 
		0.458436f, 0.159734f, 0.458800f, 0.162966f, 
		0