<resource resdir="__system" schema="dc">
	<meta name="creationDate">2008-07-24T09:00:00</meta>
	<meta name="subject">astronomical-software</meta>
	<meta name="description">Table-related metadata for
		the tables within this data center.</meta>

	<table id="tablemeta" onDisk="True" system="True"
			dupePolicy="overwrite">
		<meta name="description">A table mapping table names and schemas to
			the resource descriptors they come from and whether they are open
			to ADQL queries.

			This is used wherever DaCHS needs to go from a database name to the
			resource description, e.g., when generating tableinfo.

			The table is maintained through gavo imp; to force things out
			of here, there's gavo drop (for RDs; use -f if the RD is gone or
			meoved away) or gavo purge (for single tables).
			</meta>

		<primary>tableName, sourceRD</primary>

		<column name="tableName" description="Fully qualified table name"
			type="text" verbLevel="1"/>
		<column name="sourceRD" type="text"
			description="Id of the resource descriptor containing the 
				table's definition"
			tablehead="RD" verbLevel="15"/>
		<column name="tableDesc" type="text"
			description="Description of the table content" 
			tablehead="Table desc." verbLevel="1"/>
		<column name="resDesc" type="text"
			description="Description of the resource this table is part of"
			tablehead="Res desc." verbLevel="15"/>
		<column name="adql" type="boolean" required="True"
			description="True if this table may be accessed using ADQL"
			verbLevel="30"/>
		<column name="nrows" type="bigint"
			description="Estimated number of rows in the table.">
			<values nullLiteral="-1"/>
		</column>
	</table>

	<table id="metastore" onDisk="True" system="True" primary="key"
			dupePolicy="overwrite">
		<meta name="description">A table for storing all kinds of key-value
			pairs.  Key starting with an underscore are for use by user RDs.

			Only one pair per key is supported, newer keys overwrite older ones.

			Currently, this is only used for schemaversion, the version of
			the DaCHS system tables as used by gavo upgrade to figure out
			what to change.  gavo upgrade manages this.

			From your code, you can use base.getDBMeta(key) and
			base.setDBMeta(connection, key, value) to put persistent, string-valued
			metadata in here; if you use this, would you tell us your
			use case?
		</meta>

		<column name="quoted/key" type="text" description="A key; everything that
			starts with an underscore is user defined."/>
		<column name="quoted/value" type="text" description="A value; no serialization
			 format is defined here, but you are encouraged to use python literals
			 for non-strings."/>
	</table>

	<rowmaker id="fromColumnList">
		<!-- turns a rawrec with column, colInd, tableName keys into a
		columnmeta row -->
		<apply name="makerow">
			<code>
				column = vars["column"]
				for key in ["description", "unit", "ucd", "tablehead",
						"utype", "verbLevel", "type"]:
					result[key] = getattr(column, key)
				result["displayHint"] = column.getDisplayHintAsString()
				result["fieldName"] = column.name
				result["sourceRD"] = column.parent.rd.sourceId
			</code>
		</apply>
		<map dest="colInd"/>
		<map dest="tableName"/>
	</rowmaker>

	<data id="import">
		<make table="tablemeta"/>
		<make table="metastore">
			<script lang="python" type="postCreation">
				from gavo.user import upgrade
				from gavo import base
				base.setDBMeta(table.connection, 
					"schemaversion", upgrade.CURRENT_SCHEMAVERSION)
			</script>
		</make>
	</data>

	<fixedQueryCore id="queryList"
		query="SELECT tableName, tableName as tableinfo, tableDesc, resDesc 
			FROM dc.tablemeta WHERE adql ORDER BY tableName">
		<outputTable namePath="tablemeta">
			<outputField original="tableName"/>
			<outputField name="tableinfo" original="tableName"/>
			<outputField original="tableDesc"/>
			<outputField original="resDesc"/>
		</outputTable>
	</fixedQueryCore>

	<service id="show" allowed="tableinfo" core="queryList">
		<meta name="shortName">Table infos</meta>
		<meta name="description">Information on tables within the 
			\getConfig{web}{sitename}</meta>
		<meta name="title">\getConfig{web}{sitename} Table Infos</meta>
	</service>

	<service id="list" core="queryList">
		<meta name="shortName">ADQL tables</meta>
		<meta name="description">An overview over the tables available for ADQL 
			querying within the \getConfig{web}{sitename}</meta>
		<meta name="title">\getConfig{web}{sitename} Public Tables</meta>
		<outputTable namePath="tablemeta">
			<outputField original="tableName"/>
			<outputField name="tableinfo" type="text" tablehead="Info">
				<formatter>
					return T.a(href=base.makeSitePath("/__system__/dc_tables/"
						"show/tableinfo/"+urllib.parse.quote(data)))["Table Info"]
				</formatter>
			</outputField>
			<outputField original="tableDesc"/>
			<outputField original="resDesc"/>
		</outputTable>
	</service>
</resource>

