/* Copyright (C) 2011-2024 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* This test demonstrates a failure to resolve opaque structure types in
   binaries compiled by the Intel C compiler.  This is GDB PR symtab/13277.

   The test was derived from opaque-pointer.c, which contains the single line:

   struct opaque_struct_t *p_struct;

   and opaque_struct.c, which looks like:

   struct opaque_struct_t
   {
     int wrapped_value;
   };

   struct opaque_struct_t opaque_internal = { 0 };

   What follows is a simplified version of the debug info generated by ICC
   version 12.0.4.191. */

	.file "opaque-pointer.c"
	.data
	.comm p_struct,8,8
	.global p_struct

	.section .debug_info
debug_info_seg1:
	.4byte debug_info_seg1_end - 1f	/* Length of compilation unit info. */
1:
	.2byte 0x0002			/* DWARF version number. */
	.4byte .debug_abbrev_seg1	/* Points to abbrev section for this unit. */
	.byte 0x04			/* Target address size. */

	.byte 0x01			/* DIE 1: DW_TAG_compile_unit. */
	.byte 0x01			/* DW_AT_language = DW_LANG_C89. */
	.ascii "Intel(R) C Intel(R) 64 Compiler XE "	/* DW_AT_producer. */
	.ascii "for applications running on Intel(R) 64, "
	.ascii "Version 12.0.4.191 Build 20110427\n "
	.asciz "Fixes SameLinkageName MemberPointers"

	.byte 0x02			/* DIE 2: DW_TAG_variable. */
	.byte 0x01			/* DW_AT_accessibility. */
	.asciz "p_struct"		/* DW_AT_name. */
	.4byte 3f - debug_info_seg1	/* DW_AT_type. */
	.byte 0x05			/* DW_AT_location: 5 bytes ... */
	.byte 0x03			/* DW_OP_addr ... */
	.4byte p_struct			/* followed by the address of p_struct. */
	.byte 0x01			/* DW_AT_external. */

3:
	.byte 0x03			/* DIE 3: DW_TAG_pointer_type. */
	.4byte 4f - debug_info_seg1	/* DW_AT_type. */

4:
	.byte 0x04			/* DIE 4: DW_TAG_structure_type. */
	.byte 0x01			/* DW_AT_accessibility. */
	.byte 0x00			/* DW_AT_byte_size. */
	.asciz "opaque_struct_t"	/* DW_AT_name. */

	.byte 0x00			/* End DIE 1. */
debug_info_seg1_end:

	.section .debug_abbrev
.debug_abbrev_seg1:
	.byte 0x01	/* Abbrev 1. */
	.byte 0x11	/* DW_TAG_compile_unit. */
	.byte 0x01	/* DW_CHILDREN_yes. */
	.byte 0x13	/* DW_AT_language. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x25	/* DW_AT_producer. */
	.byte 0x08	/* DW_AT_string. */
	.2byte 0x0000	/* End abbrev. */

	.byte 0x02	/* Abbrev 2. */
	.byte 0x34	/* DW_TAG_variable. */
	.byte 0x00	/* DW_CHILDREN_no. */
	.byte 0x32	/* DW_AT_accessibility. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x03	/* DW_AT_name. */
	.byte 0x08	/* DW_FORM_string. */
	.byte 0x49	/* DW_AT_type. */
	.byte 0x13	/* DW_FORM_ref4. */
	.byte 0x02	/* DW_AT_location. */
	.byte 0x0a	/* DW_FORM_block1. */
	.byte 0x3f	/* DW_AT_external. */
	.byte 0x0c	/* DW_FORM_flag. */
	.2byte 0x0000	/* End abbrev. */

	.byte 0x03	/* Abbrev 3. */
	.byte 0x0f	/* DW_TAG_pointer_type. */
	.byte 0x00	/* DW_CHILDREN_no. */
	.byte 0x49	/* DW_AT_type. */
	.byte 0x13	/* DW_FORM_ref4. */
	.2byte 0x0000	/* End abbrev. */

	.byte 0x04	/* Abbrev 4. */
	.byte 0x13	/* DW_TAG_structure_type. */
	.byte 0x00	/* DW_CHILDREN_no. */
	.byte 0x32	/* DW_AT_accessibility. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x0b	/* DW_AT_byte_size. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x03	/* DW_AT_name. */
	.byte 0x08	/* DW_FORM_string. */
	.2byte 0x0000	/* End abbrev. */
	.byte 0x00	/* End abbrev table. */


	.file "opaque-struct.c"
	.section .debug_info
debug_info_seg2:
	.4byte debug_info_seg2_end - 1f	/* Length of compilation unit info. */
1:
	.2byte 0x0002			/* DWARF version number. */
	.4byte .debug_abbrev_seg2	/* Points to abbrev section for this unit. */
	.byte 0x04			/* Target address size. */

	.byte 0x01			/* DIE 1: DW_TAG_compile_unit. */
	.byte 0x01			/* DW_AT_language = DW_LANG_C89. */
	.ascii "Intel(R) C Intel(R) 64 Compiler XE "	/* DW_AT_producer. */
	.ascii "for applications running on Intel(R) 64, "
	.ascii "Version 12.0.4.191 Build 20110427\n "
	.asciz "Fixes SameLinkageName MemberPointers"

	.byte 0x02			/* DIE 2: DW_TAG_structure_type. */
	.byte 0x01			/* DW_AT_accessibility. */
	.byte 0x04			/* DW_AT_byte_size. */
	.asciz "opaque_struct_t"	/* DW_AT_name. */


	.byte 0x03			/* DIE 3: DW_TAG_member. */
	.byte 0x02			/* DW_AT_data_member_location: 2 bytes ... */
	.byte 0x23			/* DW_OP_plus_uconst ... */
	.byte 0x00			/* followed by zero. */
	.asciz "wrapped_value"		/* DW_AT_name. */
	.4byte 4f - debug_info_seg2	/* DW_AT_type. */
	.byte 0x00

4:
	.byte 0x04			/* DIE 4: DW_TAG_base_type. */
	.byte 0x04			/* DW_AT_byte_size. */
	.byte 0x05			/* DW_AT_encoding. */
	.asciz "int"			/* DW_AT_name. */

	.byte 0x00			/* End DIE 1. */
debug_info_seg2_end:

	.section .debug_abbrev
.debug_abbrev_seg2:
	.byte 0x01	/* Abbrev 1. */
	.byte 0x11	/* DW_TAG_compile_unit. */
	.byte 0x01	/* DW_CHILDREN_yes. */
	.byte 0x13	/* DW_AT_language. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x25	/* DW_AT_producer. */
	.byte 0x08	/* DW_FORM_string. */
	.2byte 0x0000	/* End abbrev. */

	.byte 0x02	/* Abbrev 2. */
	.byte 0x13	/* DW_TAG_structure_type. */
	.byte 0x01	/* DW_CHILDREN_yes. */
	.byte 0x32	/* DW_AT_accessibility. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x0b	/* DW_AT_byte_size. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x03	/* DW_AT_name. */
	.byte 0x08	/* DW_FORM_string. */
	.2byte 0x0000	/* End abbrev. */

	.byte 0x03	/* Abbrev 3. */
	.byte 0x0d	/* DW_TAG_member. */
	.byte 0x00	/* DW_CHILDREN_no. */
	.byte 0x38	/* DW_AT_data_member_location. */
	.byte 0x0a	/* DW_FORM_block1. */
	.byte 0x03	/* DW_AT_name. */
	.byte 0x08	/* DW_FORM_string. */
	.byte 0x49	/* DW_AT_type. */
	.byte 0x13	/* DW_FORM_ref4. */
	.2byte 0x0000	/* End abbrev. */

	.byte 0x04	/* Abbrev 4. */
	.byte 0x24	/* DW_TAG_base_type. */
	.byte 0x00	/* DW_CHILDREN_no. */
	.byte 0x0b	/* DW_AT_byte_size. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x3e	/* DW_AT_encoding. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x03	/* DW_AT_name. */
	.byte 0x08	/* DW_FORM_string. */
	.2byte 0x0000	/* End abbrev. */
	.byte 0x00	/* End abbrev table. */


	.file "opaque-pointer2.c"

	.section .debug_info
debug_info_seg3:
	.4byte debug_info_seg3_end - 1f	/* Length of compilation unit info. */
1:
	.2byte 0x0002			/* DWARF version number. */
	.4byte .debug_abbrev_seg3	/* Points to abbrev section for this unit. */
	.byte 0x04			/* Target address size. */

	.byte 0x01			/* DIE 1: DW_TAG_compile_unit. */
	.byte 0x01			/* DW_AT_language = DW_LANG_C89. */
	.ascii "Intel(R) C Intel(R) 64 Compiler XE "	/* DW_AT_producer. */
	.ascii "for applications running on Intel(R) 64, "
	.ascii "Version 12.0.4.191 Build 20110427\n "
	.asciz "Fixes SameLinkageName MemberPointers"

	.byte 0x04			/* DIE 4: DW_TAG_structure_type. */
	.byte 0x01			/* DW_AT_accessibility. */
	.byte 0x00			/* DW_AT_byte_size. */
	.asciz "opaque_struct_t"	/* DW_AT_name. */

	.byte 0x00			/* End DIE 1. */
debug_info_seg3_end:

	.section .debug_abbrev
.debug_abbrev_seg3:
	.byte 0x01	/* Abbrev 1. */
	.byte 0x11	/* DW_TAG_compile_unit. */
	.byte 0x01	/* DW_CHILDREN_yes. */
	.byte 0x13	/* DW_AT_language. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x25	/* DW_AT_producer. */
	.byte 0x08	/* DW_AT_string. */
	.2byte 0x0000	/* End abbrev. */

	.byte 0x04	/* Abbrev 4. */
	.byte 0x13	/* DW_TAG_structure_type. */
	.byte 0x00	/* DW_CHILDREN_no. */
	.byte 0x32	/* DW_AT_accessibility. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x0b	/* DW_AT_byte_size. */
	.byte 0x0b	/* DW_FORM_data1. */
	.byte 0x03	/* DW_AT_name. */
	.byte 0x08	/* DW_FORM_string. */
	.2byte 0x0000	/* End abbrev. */
	.byte 0x00	/* End abbrev table. */
#ifdef __arm__
	.section	.note.GNU-stack,"",%progbits
#else
	.section	.note.GNU-stack,"",@progbits
#endif
