//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armedgeorder

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagementClient contains the methods for the EdgeOrderManagementClient group.
// Don't use this type directly, use NewManagementClient() instead.
type ManagementClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewManagementClient creates a new instance of ManagementClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewManagementClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagementClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ManagementClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CancelOrderItem - Cancel order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// orderItemName - The name of the order item
// resourceGroupName - The name of the resource group. The name is case insensitive.
// cancellationReason - Reason for cancellation.
// options - ManagementClientCancelOrderItemOptions contains the optional parameters for the ManagementClient.CancelOrderItem
// method.
func (client *ManagementClient) CancelOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason CancellationReason, options *ManagementClientCancelOrderItemOptions) (ManagementClientCancelOrderItemResponse, error) {
	req, err := client.cancelOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, cancellationReason, options)
	if err != nil {
		return ManagementClientCancelOrderItemResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagementClientCancelOrderItemResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ManagementClientCancelOrderItemResponse{}, runtime.NewResponseError(resp)
	}
	return ManagementClientCancelOrderItemResponse{}, nil
}

// cancelOrderItemCreateRequest creates the CancelOrderItem request.
func (client *ManagementClient) cancelOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason CancellationReason, options *ManagementClientCancelOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}/cancel"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, cancellationReason)
}

// BeginCreateAddress - Creates a new address with the specified parameters. Existing address can be updated with this API
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
// 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - The name of the resource group. The name is case insensitive.
// addressResource - Address details from request body.
// options - ManagementClientBeginCreateAddressOptions contains the optional parameters for the ManagementClient.BeginCreateAddress
// method.
func (client *ManagementClient) BeginCreateAddress(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource, options *ManagementClientBeginCreateAddressOptions) (*runtime.Poller[ManagementClientCreateAddressResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createAddress(ctx, addressName, resourceGroupName, addressResource, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagementClientCreateAddressResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagementClientCreateAddressResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateAddress - Creates a new address with the specified parameters. Existing address can be updated with this API
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
func (client *ManagementClient) createAddress(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource, options *ManagementClientBeginCreateAddressOptions) (*http.Response, error) {
	req, err := client.createAddressCreateRequest(ctx, addressName, resourceGroupName, addressResource, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createAddressCreateRequest creates the CreateAddress request.
func (client *ManagementClient) createAddressCreateRequest(ctx context.Context, addressName string, resourceGroupName string, addressResource AddressResource, options *ManagementClientBeginCreateAddressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, addressResource)
}

// BeginCreateOrderItem - Creates an order item. Existing order item cannot be updated with this api and should instead be
// updated with the Update order item API.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// orderItemName - The name of the order item
// resourceGroupName - The name of the resource group. The name is case insensitive.
// orderItemResource - Order item details from request body.
// options - ManagementClientBeginCreateOrderItemOptions contains the optional parameters for the ManagementClient.BeginCreateOrderItem
// method.
func (client *ManagementClient) BeginCreateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource, options *ManagementClientBeginCreateOrderItemOptions) (*runtime.Poller[ManagementClientCreateOrderItemResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrderItem(ctx, orderItemName, resourceGroupName, orderItemResource, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagementClientCreateOrderItemResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagementClientCreateOrderItemResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrderItem - Creates an order item. Existing order item cannot be updated with this api and should instead be updated
// with the Update order item API.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
func (client *ManagementClient) createOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource, options *ManagementClientBeginCreateOrderItemOptions) (*http.Response, error) {
	req, err := client.createOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, orderItemResource, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrderItemCreateRequest creates the CreateOrderItem request.
func (client *ManagementClient) createOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource OrderItemResource, options *ManagementClientBeginCreateOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, orderItemResource)
}

// BeginDeleteAddressByName - Deletes an address.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
// 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - ManagementClientBeginDeleteAddressByNameOptions contains the optional parameters for the ManagementClient.BeginDeleteAddressByName
// method.
func (client *ManagementClient) BeginDeleteAddressByName(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientBeginDeleteAddressByNameOptions) (*runtime.Poller[ManagementClientDeleteAddressByNameResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteAddressByName(ctx, addressName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagementClientDeleteAddressByNameResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagementClientDeleteAddressByNameResponse](options.ResumeToken, client.pl, nil)
	}
}

// DeleteAddressByName - Deletes an address.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
func (client *ManagementClient) deleteAddressByName(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientBeginDeleteAddressByNameOptions) (*http.Response, error) {
	req, err := client.deleteAddressByNameCreateRequest(ctx, addressName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteAddressByNameCreateRequest creates the DeleteAddressByName request.
func (client *ManagementClient) deleteAddressByNameCreateRequest(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientBeginDeleteAddressByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginDeleteOrderItemByName - Deletes an order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// orderItemName - The name of the order item
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - ManagementClientBeginDeleteOrderItemByNameOptions contains the optional parameters for the ManagementClient.BeginDeleteOrderItemByName
// method.
func (client *ManagementClient) BeginDeleteOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientBeginDeleteOrderItemByNameOptions) (*runtime.Poller[ManagementClientDeleteOrderItemByNameResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOrderItemByName(ctx, orderItemName, resourceGroupName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagementClientDeleteOrderItemByNameResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagementClientDeleteOrderItemByNameResponse](options.ResumeToken, client.pl, nil)
	}
}

// DeleteOrderItemByName - Deletes an order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
func (client *ManagementClient) deleteOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientBeginDeleteOrderItemByNameOptions) (*http.Response, error) {
	req, err := client.deleteOrderItemByNameCreateRequest(ctx, orderItemName, resourceGroupName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteOrderItemByNameCreateRequest creates the DeleteOrderItemByName request.
func (client *ManagementClient) deleteOrderItemByNameCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientBeginDeleteOrderItemByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GetAddressByName - Gets information about the specified address.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
// 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - ManagementClientGetAddressByNameOptions contains the optional parameters for the ManagementClient.GetAddressByName
// method.
func (client *ManagementClient) GetAddressByName(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientGetAddressByNameOptions) (ManagementClientGetAddressByNameResponse, error) {
	req, err := client.getAddressByNameCreateRequest(ctx, addressName, resourceGroupName, options)
	if err != nil {
		return ManagementClientGetAddressByNameResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagementClientGetAddressByNameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagementClientGetAddressByNameResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAddressByNameHandleResponse(resp)
}

// getAddressByNameCreateRequest creates the GetAddressByName request.
func (client *ManagementClient) getAddressByNameCreateRequest(ctx context.Context, addressName string, resourceGroupName string, options *ManagementClientGetAddressByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAddressByNameHandleResponse handles the GetAddressByName response.
func (client *ManagementClient) getAddressByNameHandleResponse(resp *http.Response) (ManagementClientGetAddressByNameResponse, error) {
	result := ManagementClientGetAddressByNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResource); err != nil {
		return ManagementClientGetAddressByNameResponse{}, err
	}
	return result, nil
}

// GetOrderByName - Gets an order.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// orderName - The name of the order
// resourceGroupName - The name of the resource group. The name is case insensitive.
// location - The name of Azure region.
// options - ManagementClientGetOrderByNameOptions contains the optional parameters for the ManagementClient.GetOrderByName
// method.
func (client *ManagementClient) GetOrderByName(ctx context.Context, orderName string, resourceGroupName string, location string, options *ManagementClientGetOrderByNameOptions) (ManagementClientGetOrderByNameResponse, error) {
	req, err := client.getOrderByNameCreateRequest(ctx, orderName, resourceGroupName, location, options)
	if err != nil {
		return ManagementClientGetOrderByNameResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagementClientGetOrderByNameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagementClientGetOrderByNameResponse{}, runtime.NewResponseError(resp)
	}
	return client.getOrderByNameHandleResponse(resp)
}

// getOrderByNameCreateRequest creates the GetOrderByName request.
func (client *ManagementClient) getOrderByNameCreateRequest(ctx context.Context, orderName string, resourceGroupName string, location string, options *ManagementClientGetOrderByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/locations/{location}/orders/{orderName}"
	if orderName == "" {
		return nil, errors.New("parameter orderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderName}", url.PathEscape(orderName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOrderByNameHandleResponse handles the GetOrderByName response.
func (client *ManagementClient) getOrderByNameHandleResponse(resp *http.Response) (ManagementClientGetOrderByNameResponse, error) {
	result := ManagementClientGetOrderByNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderResource); err != nil {
		return ManagementClientGetOrderByNameResponse{}, err
	}
	return result, nil
}

// GetOrderItemByName - Gets an order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// orderItemName - The name of the order item
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - ManagementClientGetOrderItemByNameOptions contains the optional parameters for the ManagementClient.GetOrderItemByName
// method.
func (client *ManagementClient) GetOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientGetOrderItemByNameOptions) (ManagementClientGetOrderItemByNameResponse, error) {
	req, err := client.getOrderItemByNameCreateRequest(ctx, orderItemName, resourceGroupName, options)
	if err != nil {
		return ManagementClientGetOrderItemByNameResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagementClientGetOrderItemByNameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagementClientGetOrderItemByNameResponse{}, runtime.NewResponseError(resp)
	}
	return client.getOrderItemByNameHandleResponse(resp)
}

// getOrderItemByNameCreateRequest creates the GetOrderItemByName request.
func (client *ManagementClient) getOrderItemByNameCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, options *ManagementClientGetOrderItemByNameOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getOrderItemByNameHandleResponse handles the GetOrderItemByName response.
func (client *ManagementClient) getOrderItemByNameHandleResponse(resp *http.Response) (ManagementClientGetOrderItemByNameResponse, error) {
	result := ManagementClientGetOrderItemByNameResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderItemResource); err != nil {
		return ManagementClientGetOrderItemByNameResponse{}, err
	}
	return result, nil
}

// NewListAddressesAtResourceGroupLevelPager - Lists all the addresses available under the given resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - ManagementClientListAddressesAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.ListAddressesAtResourceGroupLevel
// method.
func (client *ManagementClient) NewListAddressesAtResourceGroupLevelPager(resourceGroupName string, options *ManagementClientListAddressesAtResourceGroupLevelOptions) *runtime.Pager[ManagementClientListAddressesAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListAddressesAtResourceGroupLevelResponse]{
		More: func(page ManagementClientListAddressesAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListAddressesAtResourceGroupLevelResponse) (ManagementClientListAddressesAtResourceGroupLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAddressesAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListAddressesAtResourceGroupLevelResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListAddressesAtResourceGroupLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListAddressesAtResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAddressesAtResourceGroupLevelHandleResponse(resp)
		},
	})
}

// listAddressesAtResourceGroupLevelCreateRequest creates the ListAddressesAtResourceGroupLevel request.
func (client *ManagementClient) listAddressesAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementClientListAddressesAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAddressesAtResourceGroupLevelHandleResponse handles the ListAddressesAtResourceGroupLevel response.
func (client *ManagementClient) listAddressesAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementClientListAddressesAtResourceGroupLevelResponse, error) {
	result := ManagementClientListAddressesAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResourceList); err != nil {
		return ManagementClientListAddressesAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListAddressesAtSubscriptionLevelPager - Lists all the addresses available under the subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// options - ManagementClientListAddressesAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.ListAddressesAtSubscriptionLevel
// method.
func (client *ManagementClient) NewListAddressesAtSubscriptionLevelPager(options *ManagementClientListAddressesAtSubscriptionLevelOptions) *runtime.Pager[ManagementClientListAddressesAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListAddressesAtSubscriptionLevelResponse]{
		More: func(page ManagementClientListAddressesAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListAddressesAtSubscriptionLevelResponse) (ManagementClientListAddressesAtSubscriptionLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAddressesAtSubscriptionLevelCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListAddressesAtSubscriptionLevelResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListAddressesAtSubscriptionLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListAddressesAtSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAddressesAtSubscriptionLevelHandleResponse(resp)
		},
	})
}

// listAddressesAtSubscriptionLevelCreateRequest creates the ListAddressesAtSubscriptionLevel request.
func (client *ManagementClient) listAddressesAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementClientListAddressesAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/addresses"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAddressesAtSubscriptionLevelHandleResponse handles the ListAddressesAtSubscriptionLevel response.
func (client *ManagementClient) listAddressesAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementClientListAddressesAtSubscriptionLevelResponse, error) {
	result := ManagementClientListAddressesAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressResourceList); err != nil {
		return ManagementClientListAddressesAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListConfigurationsPager - This method provides the list of configurations for the given product family, product line
// and product under subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// configurationsRequest - Filters for showing the configurations.
// options - ManagementClientListConfigurationsOptions contains the optional parameters for the ManagementClient.ListConfigurations
// method.
func (client *ManagementClient) NewListConfigurationsPager(configurationsRequest ConfigurationsRequest, options *ManagementClientListConfigurationsOptions) *runtime.Pager[ManagementClientListConfigurationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListConfigurationsResponse]{
		More: func(page ManagementClientListConfigurationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListConfigurationsResponse) (ManagementClientListConfigurationsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listConfigurationsCreateRequest(ctx, configurationsRequest, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListConfigurationsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListConfigurationsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListConfigurationsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listConfigurationsHandleResponse(resp)
		},
	})
}

// listConfigurationsCreateRequest creates the ListConfigurations request.
func (client *ManagementClient) listConfigurationsCreateRequest(ctx context.Context, configurationsRequest ConfigurationsRequest, options *ManagementClientListConfigurationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/listConfigurations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, configurationsRequest)
}

// listConfigurationsHandleResponse handles the ListConfigurations response.
func (client *ManagementClient) listConfigurationsHandleResponse(resp *http.Response) (ManagementClientListConfigurationsResponse, error) {
	result := ManagementClientListConfigurationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Configurations); err != nil {
		return ManagementClientListConfigurationsResponse{}, err
	}
	return result, nil
}

// NewListOperationsPager - This method gets all the operations that are exposed for customer.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// options - ManagementClientListOperationsOptions contains the optional parameters for the ManagementClient.ListOperations
// method.
func (client *ManagementClient) NewListOperationsPager(options *ManagementClientListOperationsOptions) *runtime.Pager[ManagementClientListOperationsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOperationsResponse]{
		More: func(page ManagementClientListOperationsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOperationsResponse) (ManagementClientListOperationsResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listOperationsCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListOperationsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListOperationsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListOperationsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listOperationsHandleResponse(resp)
		},
	})
}

// listOperationsCreateRequest creates the ListOperations request.
func (client *ManagementClient) listOperationsCreateRequest(ctx context.Context, options *ManagementClientListOperationsOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.EdgeOrder/operations"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOperationsHandleResponse handles the ListOperations response.
func (client *ManagementClient) listOperationsHandleResponse(resp *http.Response) (ManagementClientListOperationsResponse, error) {
	result := ManagementClientListOperationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OperationListResult); err != nil {
		return ManagementClientListOperationsResponse{}, err
	}
	return result, nil
}

// NewListOrderAtResourceGroupLevelPager - Lists order at resource group level.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - ManagementClientListOrderAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.ListOrderAtResourceGroupLevel
// method.
func (client *ManagementClient) NewListOrderAtResourceGroupLevelPager(resourceGroupName string, options *ManagementClientListOrderAtResourceGroupLevelOptions) *runtime.Pager[ManagementClientListOrderAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderAtResourceGroupLevelResponse]{
		More: func(page ManagementClientListOrderAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderAtResourceGroupLevelResponse) (ManagementClientListOrderAtResourceGroupLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listOrderAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListOrderAtResourceGroupLevelResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListOrderAtResourceGroupLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListOrderAtResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listOrderAtResourceGroupLevelHandleResponse(resp)
		},
	})
}

// listOrderAtResourceGroupLevelCreateRequest creates the ListOrderAtResourceGroupLevel request.
func (client *ManagementClient) listOrderAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementClientListOrderAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orders"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderAtResourceGroupLevelHandleResponse handles the ListOrderAtResourceGroupLevel response.
func (client *ManagementClient) listOrderAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementClientListOrderAtResourceGroupLevelResponse, error) {
	result := ManagementClientListOrderAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderResourceList); err != nil {
		return ManagementClientListOrderAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListOrderAtSubscriptionLevelPager - Lists order at subscription level.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// options - ManagementClientListOrderAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.ListOrderAtSubscriptionLevel
// method.
func (client *ManagementClient) NewListOrderAtSubscriptionLevelPager(options *ManagementClientListOrderAtSubscriptionLevelOptions) *runtime.Pager[ManagementClientListOrderAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderAtSubscriptionLevelResponse]{
		More: func(page ManagementClientListOrderAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderAtSubscriptionLevelResponse) (ManagementClientListOrderAtSubscriptionLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listOrderAtSubscriptionLevelCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListOrderAtSubscriptionLevelResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListOrderAtSubscriptionLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListOrderAtSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listOrderAtSubscriptionLevelHandleResponse(resp)
		},
	})
}

// listOrderAtSubscriptionLevelCreateRequest creates the ListOrderAtSubscriptionLevel request.
func (client *ManagementClient) listOrderAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementClientListOrderAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/orders"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderAtSubscriptionLevelHandleResponse handles the ListOrderAtSubscriptionLevel response.
func (client *ManagementClient) listOrderAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementClientListOrderAtSubscriptionLevelResponse, error) {
	result := ManagementClientListOrderAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderResourceList); err != nil {
		return ManagementClientListOrderAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListOrderItemsAtResourceGroupLevelPager - Lists order item at resource group level.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// options - ManagementClientListOrderItemsAtResourceGroupLevelOptions contains the optional parameters for the ManagementClient.ListOrderItemsAtResourceGroupLevel
// method.
func (client *ManagementClient) NewListOrderItemsAtResourceGroupLevelPager(resourceGroupName string, options *ManagementClientListOrderItemsAtResourceGroupLevelOptions) *runtime.Pager[ManagementClientListOrderItemsAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderItemsAtResourceGroupLevelResponse]{
		More: func(page ManagementClientListOrderItemsAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderItemsAtResourceGroupLevelResponse) (ManagementClientListOrderItemsAtResourceGroupLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listOrderItemsAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListOrderItemsAtResourceGroupLevelResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListOrderItemsAtResourceGroupLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListOrderItemsAtResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listOrderItemsAtResourceGroupLevelHandleResponse(resp)
		},
	})
}

// listOrderItemsAtResourceGroupLevelCreateRequest creates the ListOrderItemsAtResourceGroupLevel request.
func (client *ManagementClient) listOrderItemsAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementClientListOrderItemsAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderItemsAtResourceGroupLevelHandleResponse handles the ListOrderItemsAtResourceGroupLevel response.
func (client *ManagementClient) listOrderItemsAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementClientListOrderItemsAtResourceGroupLevelResponse, error) {
	result := ManagementClientListOrderItemsAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderItemResourceList); err != nil {
		return ManagementClientListOrderItemsAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListOrderItemsAtSubscriptionLevelPager - Lists order item at subscription level.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// options - ManagementClientListOrderItemsAtSubscriptionLevelOptions contains the optional parameters for the ManagementClient.ListOrderItemsAtSubscriptionLevel
// method.
func (client *ManagementClient) NewListOrderItemsAtSubscriptionLevelPager(options *ManagementClientListOrderItemsAtSubscriptionLevelOptions) *runtime.Pager[ManagementClientListOrderItemsAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListOrderItemsAtSubscriptionLevelResponse]{
		More: func(page ManagementClientListOrderItemsAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListOrderItemsAtSubscriptionLevelResponse) (ManagementClientListOrderItemsAtSubscriptionLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listOrderItemsAtSubscriptionLevelCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListOrderItemsAtSubscriptionLevelResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListOrderItemsAtSubscriptionLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListOrderItemsAtSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listOrderItemsAtSubscriptionLevelHandleResponse(resp)
		},
	})
}

// listOrderItemsAtSubscriptionLevelCreateRequest creates the ListOrderItemsAtSubscriptionLevel request.
func (client *ManagementClient) listOrderItemsAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementClientListOrderItemsAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/orderItems"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listOrderItemsAtSubscriptionLevelHandleResponse handles the ListOrderItemsAtSubscriptionLevel response.
func (client *ManagementClient) listOrderItemsAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementClientListOrderItemsAtSubscriptionLevelResponse, error) {
	result := ManagementClientListOrderItemsAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.OrderItemResourceList); err != nil {
		return ManagementClientListOrderItemsAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListProductFamiliesPager - This method provides the list of product families for the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// productFamiliesRequest - Filters for showing the product families.
// options - ManagementClientListProductFamiliesOptions contains the optional parameters for the ManagementClient.ListProductFamilies
// method.
func (client *ManagementClient) NewListProductFamiliesPager(productFamiliesRequest ProductFamiliesRequest, options *ManagementClientListProductFamiliesOptions) *runtime.Pager[ManagementClientListProductFamiliesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListProductFamiliesResponse]{
		More: func(page ManagementClientListProductFamiliesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListProductFamiliesResponse) (ManagementClientListProductFamiliesResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProductFamiliesCreateRequest(ctx, productFamiliesRequest, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListProductFamiliesResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListProductFamiliesResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListProductFamiliesResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProductFamiliesHandleResponse(resp)
		},
	})
}

// listProductFamiliesCreateRequest creates the ListProductFamilies request.
func (client *ManagementClient) listProductFamiliesCreateRequest(ctx context.Context, productFamiliesRequest ProductFamiliesRequest, options *ManagementClientListProductFamiliesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/listProductFamilies"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.Expand != nil {
		reqQP.Set("$expand", *options.Expand)
	}
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, productFamiliesRequest)
}

// listProductFamiliesHandleResponse handles the ListProductFamilies response.
func (client *ManagementClient) listProductFamiliesHandleResponse(resp *http.Response) (ManagementClientListProductFamiliesResponse, error) {
	result := ManagementClientListProductFamiliesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProductFamilies); err != nil {
		return ManagementClientListProductFamiliesResponse{}, err
	}
	return result, nil
}

// NewListProductFamiliesMetadataPager - This method provides the list of product families metadata for the given subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// options - ManagementClientListProductFamiliesMetadataOptions contains the optional parameters for the ManagementClient.ListProductFamiliesMetadata
// method.
func (client *ManagementClient) NewListProductFamiliesMetadataPager(options *ManagementClientListProductFamiliesMetadataOptions) *runtime.Pager[ManagementClientListProductFamiliesMetadataResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementClientListProductFamiliesMetadataResponse]{
		More: func(page ManagementClientListProductFamiliesMetadataResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementClientListProductFamiliesMetadataResponse) (ManagementClientListProductFamiliesMetadataResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listProductFamiliesMetadataCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementClientListProductFamiliesMetadataResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagementClientListProductFamiliesMetadataResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementClientListProductFamiliesMetadataResponse{}, runtime.NewResponseError(resp)
			}
			return client.listProductFamiliesMetadataHandleResponse(resp)
		},
	})
}

// listProductFamiliesMetadataCreateRequest creates the ListProductFamiliesMetadata request.
func (client *ManagementClient) listProductFamiliesMetadataCreateRequest(ctx context.Context, options *ManagementClientListProductFamiliesMetadataOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.EdgeOrder/productFamiliesMetadata"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listProductFamiliesMetadataHandleResponse handles the ListProductFamiliesMetadata response.
func (client *ManagementClient) listProductFamiliesMetadataHandleResponse(resp *http.Response) (ManagementClientListProductFamiliesMetadataResponse, error) {
	result := ManagementClientListProductFamiliesMetadataResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ProductFamiliesMetadata); err != nil {
		return ManagementClientListProductFamiliesMetadataResponse{}, err
	}
	return result, nil
}

// BeginReturnOrderItem - Return order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// orderItemName - The name of the order item
// resourceGroupName - The name of the resource group. The name is case insensitive.
// returnOrderItemDetails - Return order item CurrentStatus.
// options - ManagementClientBeginReturnOrderItemOptions contains the optional parameters for the ManagementClient.BeginReturnOrderItem
// method.
func (client *ManagementClient) BeginReturnOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails, options *ManagementClientBeginReturnOrderItemOptions) (*runtime.Poller[ManagementClientReturnOrderItemResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.returnOrderItem(ctx, orderItemName, resourceGroupName, returnOrderItemDetails, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagementClientReturnOrderItemResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagementClientReturnOrderItemResponse](options.ResumeToken, client.pl, nil)
	}
}

// ReturnOrderItem - Return order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
func (client *ManagementClient) returnOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails, options *ManagementClientBeginReturnOrderItemOptions) (*http.Response, error) {
	req, err := client.returnOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, returnOrderItemDetails, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// returnOrderItemCreateRequest creates the ReturnOrderItem request.
func (client *ManagementClient) returnOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails ReturnOrderItemDetails, options *ManagementClientBeginReturnOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}/return"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, returnOrderItemDetails)
}

// BeginUpdateAddress - Updates the properties of an existing address.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// addressName - The name of the address Resource within the specified resource group. address names must be between 3 and
// 24 characters in length and use any alphanumeric and underscore only
// resourceGroupName - The name of the resource group. The name is case insensitive.
// addressUpdateParameter - Address update parameters from request body.
// options - ManagementClientBeginUpdateAddressOptions contains the optional parameters for the ManagementClient.BeginUpdateAddress
// method.
func (client *ManagementClient) BeginUpdateAddress(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, options *ManagementClientBeginUpdateAddressOptions) (*runtime.Poller[ManagementClientUpdateAddressResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateAddress(ctx, addressName, resourceGroupName, addressUpdateParameter, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagementClientUpdateAddressResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagementClientUpdateAddressResponse](options.ResumeToken, client.pl, nil)
	}
}

// UpdateAddress - Updates the properties of an existing address.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
func (client *ManagementClient) updateAddress(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, options *ManagementClientBeginUpdateAddressOptions) (*http.Response, error) {
	req, err := client.updateAddressCreateRequest(ctx, addressName, resourceGroupName, addressUpdateParameter, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateAddressCreateRequest creates the UpdateAddress request.
func (client *ManagementClient) updateAddressCreateRequest(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter AddressUpdateParameter, options *ManagementClientBeginUpdateAddressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}"
	if addressName == "" {
		return nil, errors.New("parameter addressName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressName}", url.PathEscape(addressName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, addressUpdateParameter)
}

// BeginUpdateOrderItem - Updates the properties of an existing order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
// orderItemName - The name of the order item
// resourceGroupName - The name of the resource group. The name is case insensitive.
// orderItemUpdateParameter - order item update parameters from request body.
// options - ManagementClientBeginUpdateOrderItemOptions contains the optional parameters for the ManagementClient.BeginUpdateOrderItem
// method.
func (client *ManagementClient) BeginUpdateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, options *ManagementClientBeginUpdateOrderItemOptions) (*runtime.Poller[ManagementClientUpdateOrderItemResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.updateOrderItem(ctx, orderItemName, resourceGroupName, orderItemUpdateParameter, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[ManagementClientUpdateOrderItemResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[ManagementClientUpdateOrderItemResponse](options.ResumeToken, client.pl, nil)
	}
}

// UpdateOrderItem - Updates the properties of an existing order item.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-12-01
func (client *ManagementClient) updateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, options *ManagementClientBeginUpdateOrderItemOptions) (*http.Response, error) {
	req, err := client.updateOrderItemCreateRequest(ctx, orderItemName, resourceGroupName, orderItemUpdateParameter, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// updateOrderItemCreateRequest creates the UpdateOrderItem request.
func (client *ManagementClient) updateOrderItemCreateRequest(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter OrderItemUpdateParameter, options *ManagementClientBeginUpdateOrderItemOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}"
	if orderItemName == "" {
		return nil, errors.New("parameter orderItemName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{orderItemName}", url.PathEscape(orderItemName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	if options != nil && options.IfMatch != nil {
		req.Raw().Header["If-Match"] = []string{*options.IfMatch}
	}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, orderItemUpdateParameter)
}
