// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes the enrollment status of an organization's member accounts in Cost
// Optimization Hub.
type AccountEnrollmentStatus struct {

	// The Amazon Web Services account ID.
	AccountId *string

	// The time when the account enrollment status was created.
	CreatedTimestamp *time.Time

	// The time when the account enrollment status was last updated.
	LastUpdatedTimestamp *time.Time

	// The account enrollment status.
	Status EnrollmentStatus

	noSmithyDocumentSerde
}

// Describes the Amazon Elastic Block Store performance configuration of the
// current and recommended resource configuration for a recommendation.
type BlockStoragePerformanceConfiguration struct {

	// The number of I/O operations per second.
	Iops *float64

	// The throughput that the volume supports.
	Throughput *float64

	noSmithyDocumentSerde
}

// Describes the performance configuration for compute services such as Amazon
// EC2, Lambda, and ECS.
type ComputeConfiguration struct {

	// The architecture of the resource.
	Architecture *string

	// The memory size of the resource.
	MemorySizeInMB *int32

	// The platform of the resource. The platform is the specific combination of
	// operating system, license model, and software on an instance.
	Platform *string

	// The number of vCPU cores in the resource.
	VCpu *float64

	noSmithyDocumentSerde
}

// The Compute Savings Plans recommendation details.
type ComputeSavingsPlans struct {

	// Configuration details of the Compute Savings Plans to purchase.
	Configuration *ComputeSavingsPlansConfiguration

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation

	noSmithyDocumentSerde
}

// The Compute Savings Plans configuration used for recommendations.
type ComputeSavingsPlansConfiguration struct {

	// The account scope that you want your recommendations for. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER . If the value is LINKED , recommendations are
	// calculated for individual member accounts only.
	AccountScope *string

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Savings Plans recommendation term in years.
	Term *string

	noSmithyDocumentSerde
}

// Describes the Amazon Elastic Block Store volume configuration of the current
// and recommended resource configuration for a recommendation.
type EbsVolume struct {

	// The Amazon Elastic Block Store volume configuration used for recommendations.
	Configuration *EbsVolumeConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The Amazon Elastic Block Store volume configuration used for recommendations.
type EbsVolumeConfiguration struct {

	// The Amazon Elastic Block Store attachment state.
	AttachmentState *string

	// The Amazon Elastic Block Store performance configuration.
	Performance *BlockStoragePerformanceConfiguration

	// The disk storage of the Amazon Elastic Block Store volume.
	Storage *StorageConfiguration

	noSmithyDocumentSerde
}

// The EC2 Auto Scaling group recommendation details.
type Ec2AutoScalingGroup struct {

	// The EC2 Auto Scaling group configuration used for recommendations.
	Configuration *Ec2AutoScalingGroupConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The EC2 auto scaling group configuration used for recommendations.
type Ec2AutoScalingGroupConfiguration struct {

	// Details about the instance.
	Instance *InstanceConfiguration

	noSmithyDocumentSerde
}

// Describes the EC2 instance configuration of the current and recommended
// resource configuration for a recommendation.
type Ec2Instance struct {

	// The EC2 instance configuration used for recommendations.
	Configuration *Ec2InstanceConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The EC2 instance configuration used for recommendations.
type Ec2InstanceConfiguration struct {

	// Details about the instance.
	Instance *InstanceConfiguration

	noSmithyDocumentSerde
}

// The EC2 instance Savings Plans recommendation details.
type Ec2InstanceSavingsPlans struct {

	// The EC2 instance Savings Plans configuration used for recommendations.
	Configuration *Ec2InstanceSavingsPlansConfiguration

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation

	noSmithyDocumentSerde
}

// The EC2 instance Savings Plans configuration used for recommendations.
type Ec2InstanceSavingsPlansConfiguration struct {

	// The account scope that you want your recommendations for.
	AccountScope *string

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string

	// The instance family of the recommended Savings Plan.
	InstanceFamily *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	SavingsPlansRegion *string

	// The Savings Plans recommendation term in years.
	Term *string

	noSmithyDocumentSerde
}

// The EC2 reserved instances recommendation details.
type Ec2ReservedInstances struct {

	// The EC2 reserved instances configuration used for recommendations.
	Configuration *Ec2ReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The EC2 reserved instances configuration used for recommendations.
type Ec2ReservedInstancesConfiguration struct {

	// The account scope that you want your recommendations for.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// Indicates whether the recommendation is for standard or convertible
	// reservations.
	OfferingClass *string

	// The payment option for the commitment.
	PaymentOption *string

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service that you want your recommendations for.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// Determines whether the recommended reservation is dedicated or shared.
	Tenancy *string

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// The ECS service recommendation details.
type EcsService struct {

	// The ECS service configuration used for recommendations.
	Configuration *EcsServiceConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The ECS service configuration used for recommendations.
type EcsServiceConfiguration struct {

	// Details about the compute configuration.
	Compute *ComputeConfiguration

	noSmithyDocumentSerde
}

// The ElastiCache reserved instances recommendation details.
type ElastiCacheReservedInstances struct {

	// The ElastiCache reserved instances configuration used for recommendations.
	Configuration *ElastiCacheReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The ElastiCache reserved instances configuration used for recommendations.
type ElastiCacheReservedInstancesConfiguration struct {

	// The account scope that you want your recommendations for.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service that you want your recommendations for.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Estimated discount details of the current and recommended resource
// configuration for a recommendation.
type EstimatedDiscounts struct {

	// Estimated other discounts include all discounts that are not itemized. Itemized
	// discounts include reservedInstanceDiscount and savingsPlansDiscount .
	OtherDiscount *float64

	// Estimated reserved instance discounts.
	ReservedInstancesDiscount *float64

	// Estimated Savings Plans discounts.
	SavingsPlansDiscount *float64

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of recommendations.
// Filters recommendations by different dimensions.
type Filter struct {

	// The account that the recommendation is for.
	AccountIds []string

	// The type of action you can take by adopting the recommendation.
	ActionTypes []ActionType

	// The effort required to implement the recommendation.
	ImplementationEfforts []ImplementationEffort

	// The IDs for the recommendations.
	RecommendationIds []string

	// The Amazon Web Services Region of the resource.
	Regions []string

	// The Amazon Resource Name (ARN) of the recommendation.
	ResourceArns []string

	// The resource ID of the recommendation.
	ResourceIds []string

	// The resource type of the recommendation.
	ResourceTypes []ResourceType

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool

	// A list of tags assigned to the recommendation.
	Tags []Tag

	noSmithyDocumentSerde
}

// The Instance configuration used for recommendations.
type InstanceConfiguration struct {

	// Details about the type.
	Type *string

	noSmithyDocumentSerde
}

// The Lambda function recommendation details.
type LambdaFunction struct {

	// The Lambda function configuration used for recommendations.
	Configuration *LambdaFunctionConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The Lambda function configuration used for recommendations.
type LambdaFunctionConfiguration struct {

	// Details about the compute configuration.
	Compute *ComputeConfiguration

	noSmithyDocumentSerde
}

// The OpenSearch reserved instances recommendation details.
type OpenSearchReservedInstances struct {

	// The OpenSearch reserved instances configuration used for recommendations.
	Configuration *OpenSearchReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The OpenSearch reserved instances configuration used for recommendations.
type OpenSearchReservedInstancesConfiguration struct {

	// The account scope that you want your recommendations for.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service that you want your recommendations for.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Defines how rows will be sorted in the response.
type OrderBy struct {

	// Sorts by dimension values.
	Dimension *string

	// The order that's used to sort the data.
	Order Order

	noSmithyDocumentSerde
}

// The RDS reserved instances recommendation details.
type RdsReservedInstances struct {

	// The RDS reserved instances configuration used for recommendations.
	Configuration *RdsReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The RDS reserved instances configuration used for recommendations.
type RdsReservedInstancesConfiguration struct {

	// The account scope that you want your recommendations for.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string

	// Determines whether the recommendation is for a reservation in a single
	// Availability Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// The license model that the recommended reservation supports.
	LicenseModel *string

	// How much purchasing this instance costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service that you want your recommendations for.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Describes a recommendation.
type Recommendation struct {

	// The account that the recommendation is for.
	AccountId *string

	// The type of tasks that can be carried out by this action.
	ActionType *string

	// The currency code used for the recommendation.
	CurrencyCode *string

	// Describes the current resource.
	CurrentResourceSummary *string

	// The current resource type.
	CurrentResourceType *string

	// The estimated monthly cost for the recommendation.
	EstimatedMonthlyCost *float64

	// The estimated monthly savings amount for the recommendation.
	EstimatedMonthlySavings *float64

	// The estimated savings percentage relative to the total cost over the cost
	// calculation lookback period.
	EstimatedSavingsPercentage *float64

	// The effort required to implement the recommendation.
	ImplementationEffort *string

	// The time when the recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The ID for the recommendation.
	RecommendationId *string

	// The lookback period that's used to generate the recommendation.
	RecommendationLookbackPeriodInDays *int32

	// Describes the recommended resource.
	RecommendedResourceSummary *string

	// The recommended resource type.
	RecommendedResourceType *string

	// The Amazon Web Services Region of the resource.
	Region *string

	// The Amazon Resource Name (ARN) for the recommendation.
	ResourceArn *string

	// The resource ID for the recommendation.
	ResourceId *string

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool

	// The source of the recommendation.
	Source Source

	// A list of tags assigned to the recommendation.
	Tags []Tag

	noSmithyDocumentSerde
}

// The summary of rightsizing recommendations, including de-duped savings from all
// types of recommendations.
type RecommendationSummary struct {

	// The estimated total savings resulting from modifications, on a monthly basis.
	EstimatedMonthlySavings *float64

	// The grouping of recommendations.
	Group *string

	// The total number of instance recommendations.
	RecommendationCount *int32

	noSmithyDocumentSerde
}

// The Redshift reserved instances recommendation details.
type RedshiftReservedInstances struct {

	// The Redshift reserved instances configuration used for recommendations.
	Configuration *RedshiftReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The Redshift reserved instances configuration used for recommendations.
type RedshiftReservedInstancesConfiguration struct {

	// The account scope that you want your recommendations for.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service that you want your recommendations for.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Cost impact of the purchase recommendation.
type ReservedInstancesCostCalculation struct {

	// Pricing details of the purchase recommendation.
	Pricing *ReservedInstancesPricing

	noSmithyDocumentSerde
}

// Pricing details for your recommended reserved instance.
type ReservedInstancesPricing struct {

	// The estimated cost of your recurring monthly fees for the recommended reserved
	// instance across the month.
	EstimatedMonthlyAmortizedReservationCost *float64

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// reserved instance, over the length of the lookback period.
	EstimatedOnDemandCost *float64

	// The cost of paying for the recommended reserved instance monthly.
	MonthlyReservationEligibleCost *float64

	// The savings percentage relative to the total On-Demand costs that are
	// associated with this instance.
	SavingsPercentage *float64

	noSmithyDocumentSerde
}

// Cost impact of the resource recommendation.
type ResourceCostCalculation struct {

	// Pricing details of the resource recommendation.
	Pricing *ResourcePricing

	// Usage details of the resource recommendation.
	Usages []Usage

	noSmithyDocumentSerde
}

// Contains detailed information about the specified resource.
//
// The following types satisfy this interface:
//
//	ResourceDetailsMemberComputeSavingsPlans
//	ResourceDetailsMemberEbsVolume
//	ResourceDetailsMemberEc2AutoScalingGroup
//	ResourceDetailsMemberEc2Instance
//	ResourceDetailsMemberEc2InstanceSavingsPlans
//	ResourceDetailsMemberEc2ReservedInstances
//	ResourceDetailsMemberEcsService
//	ResourceDetailsMemberElastiCacheReservedInstances
//	ResourceDetailsMemberLambdaFunction
//	ResourceDetailsMemberOpenSearchReservedInstances
//	ResourceDetailsMemberRdsReservedInstances
//	ResourceDetailsMemberRedshiftReservedInstances
//	ResourceDetailsMemberSageMakerSavingsPlans
type ResourceDetails interface {
	isResourceDetails()
}

// The Compute Savings Plans recommendation details.
type ResourceDetailsMemberComputeSavingsPlans struct {
	Value ComputeSavingsPlans

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberComputeSavingsPlans) isResourceDetails() {}

// The Amazon Elastic Block Store volume recommendation details.
type ResourceDetailsMemberEbsVolume struct {
	Value EbsVolume

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEbsVolume) isResourceDetails() {}

// The EC2 Auto Scaling group recommendation details.
type ResourceDetailsMemberEc2AutoScalingGroup struct {
	Value Ec2AutoScalingGroup

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2AutoScalingGroup) isResourceDetails() {}

// The EC2 instance recommendation details.
type ResourceDetailsMemberEc2Instance struct {
	Value Ec2Instance

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2Instance) isResourceDetails() {}

// The EC2 instance Savings Plans recommendation details.
type ResourceDetailsMemberEc2InstanceSavingsPlans struct {
	Value Ec2InstanceSavingsPlans

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2InstanceSavingsPlans) isResourceDetails() {}

// The EC2 reserved instances recommendation details.
type ResourceDetailsMemberEc2ReservedInstances struct {
	Value Ec2ReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2ReservedInstances) isResourceDetails() {}

// The ECS service recommendation details.
type ResourceDetailsMemberEcsService struct {
	Value EcsService

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEcsService) isResourceDetails() {}

// The ElastiCache reserved instances recommendation details.
type ResourceDetailsMemberElastiCacheReservedInstances struct {
	Value ElastiCacheReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberElastiCacheReservedInstances) isResourceDetails() {}

// The Lambda function recommendation details.
type ResourceDetailsMemberLambdaFunction struct {
	Value LambdaFunction

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberLambdaFunction) isResourceDetails() {}

// The OpenSearch reserved instances recommendation details.
type ResourceDetailsMemberOpenSearchReservedInstances struct {
	Value OpenSearchReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberOpenSearchReservedInstances) isResourceDetails() {}

// The RDS reserved instances recommendation details.
type ResourceDetailsMemberRdsReservedInstances struct {
	Value RdsReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberRdsReservedInstances) isResourceDetails() {}

// The Redshift reserved instances recommendation details.
type ResourceDetailsMemberRedshiftReservedInstances struct {
	Value RedshiftReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberRedshiftReservedInstances) isResourceDetails() {}

// The SageMaker Savings Plans recommendation details.
type ResourceDetailsMemberSageMakerSavingsPlans struct {
	Value SageMakerSavingsPlans

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberSageMakerSavingsPlans) isResourceDetails() {}

// Contains pricing information about the specified resource.
type ResourcePricing struct {

	// The savings estimate incorporating all discounts with Amazon Web Services, such
	// as Reserved Instances and Savings Plans.
	EstimatedCostAfterDiscounts *float64

	// The savings estimate using Amazon Web Services public pricing without
	// incorporating any discounts.
	EstimatedCostBeforeDiscounts *float64

	// The estimated discounts for a recommendation.
	EstimatedDiscounts *EstimatedDiscounts

	// The estimated net unused amortized commitment for the recommendation.
	EstimatedNetUnusedAmortizedCommitments *float64

	noSmithyDocumentSerde
}

// The SageMaker Savings Plans recommendation details.
type SageMakerSavingsPlans struct {

	// The SageMaker Savings Plans configuration used for recommendations.
	Configuration *SageMakerSavingsPlansConfiguration

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation

	noSmithyDocumentSerde
}

// The SageMaker Savings Plans configuration used for recommendations.
type SageMakerSavingsPlansConfiguration struct {

	// The account scope that you want your recommendations for.
	AccountScope *string

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Savings Plans recommendation term in years.
	Term *string

	noSmithyDocumentSerde
}

// Cost impact of the purchase recommendation.
type SavingsPlansCostCalculation struct {

	// Pricing details of the purchase recommendation.
	Pricing *SavingsPlansPricing

	noSmithyDocumentSerde
}

// Pricing information about a Savings Plan.
type SavingsPlansPricing struct {

	// Estimated monthly commitment for the Savings Plan.
	EstimatedMonthlyCommitment *float64

	// Estimated On-Demand cost you will pay after buying the Savings Plan.
	EstimatedOnDemandCost *float64

	// The cost of paying for the recommended Savings Plan monthly.
	MonthlySavingsPlansEligibleCost *float64

	// Estimated savings as a percentage of your overall costs after buying the
	// Savings Plan.
	SavingsPercentage *float64

	noSmithyDocumentSerde
}

// The storage configuration used for recommendations.
type StorageConfiguration struct {

	// The storage volume.
	SizeInGb *float64

	// The storage type.
	Type *string

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value.
type Tag struct {

	// The key that's associated with the tag.
	Key *string

	// The value that's associated with the tag.
	Value *string

	noSmithyDocumentSerde
}

// Details about the usage.
type Usage struct {

	// The operation value.
	Operation *string

	// The product code.
	ProductCode *string

	// The usage unit.
	Unit *string

	// The usage amount.
	UsageAmount *float64

	// The usage type.
	UsageType *string

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionDetail struct {

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	FieldName *string

	// A message with the reason for the validation exception error.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isResourceDetails() {}
