/* Copyright (C) 2003-2025 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "pthread_rwlock_common.c"

/* See pthread_rwlock_common.c.  */
int
___pthread_rwlock_rdlock (pthread_rwlock_t *rwlock)
{
  LIBC_PROBE (rdlock_entry, 1, rwlock);

  int result = __pthread_rwlock_rdlock_full64 (rwlock, CLOCK_REALTIME, NULL);
  LIBC_PROBE (rdlock_acquire_read, 1, rwlock);
  return result;
}
versioned_symbol (libc, ___pthread_rwlock_rdlock, pthread_rwlock_rdlock,
		  GLIBC_2_34);
strong_alias (___pthread_rwlock_rdlock, __pthread_rwlock_rdlock)
libc_hidden_ver (___pthread_rwlock_rdlock, __pthread_rwlock_rdlock)

#if OTHER_SHLIB_COMPAT (libpthread, GLIBC_2_1, GLIBC_2_34)
compat_symbol (libpthread, ___pthread_rwlock_rdlock, pthread_rwlock_rdlock,
	       GLIBC_2_1);
#endif
#if OTHER_SHLIB_COMPAT (libpthread, GLIBC_2_2, GLIBC_2_34)
compat_symbol (libpthread, ___pthread_rwlock_rdlock, __pthread_rwlock_rdlock,
	       GLIBC_2_2);
#endif
