// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticache

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/elasticache/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This API creates a copy of an entire ServerlessCache at a specific moment in
// time. Available for Redis only.
func (c *Client) CreateServerlessCacheSnapshot(ctx context.Context, params *CreateServerlessCacheSnapshotInput, optFns ...func(*Options)) (*CreateServerlessCacheSnapshotOutput, error) {
	if params == nil {
		params = &CreateServerlessCacheSnapshotInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateServerlessCacheSnapshot", params, optFns, c.addOperationCreateServerlessCacheSnapshotMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateServerlessCacheSnapshotOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateServerlessCacheSnapshotInput struct {

	// The name of an existing serverless cache. The snapshot is created from this
	// cache. Available for Redis only.
	//
	// This member is required.
	ServerlessCacheName *string

	// The name for the snapshot being created. Must be unique for the customer
	// account. Available for Redis only. Must be between 1 and 255 characters.
	//
	// This member is required.
	ServerlessCacheSnapshotName *string

	// The ID of the KMS key used to encrypt the snapshot. Available for Redis only.
	// Default: NULL
	KmsKeyId *string

	// A list of tags to be added to the snapshot resource. A tag is a key-value pair.
	// Available for Redis only.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateServerlessCacheSnapshotOutput struct {

	// The state of a serverless cache snapshot at a specific point in time, to the
	// millisecond. Available for Redis only.
	ServerlessCacheSnapshot *types.ServerlessCacheSnapshot

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateServerlessCacheSnapshotMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateServerlessCacheSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateServerlessCacheSnapshot{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateServerlessCacheSnapshot"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateServerlessCacheSnapshotValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateServerlessCacheSnapshot(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateServerlessCacheSnapshot(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateServerlessCacheSnapshot",
	}
}
