// Code generated by smithy-go-codegen DO NOT EDIT.

package s3

import (
	"context"
	smithy "github.com/aws/smithy-go"
	smithyauth "github.com/aws/smithy-go/auth"
	smithyendpoints "github.com/aws/smithy-go/endpoints"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"github.com/google/go-cmp/cmp"
	"net/http"
	"net/url"
	"strings"
	"testing"
)

// region is not a valid DNS-suffix
func TestEndpointCase0(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("a b"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region: region was not a valid DNS name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid access point ARN: Not S3
func TestEndpointCase1(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:not-s3:us-west-2:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The ARN was not for the S3 service, found: not-s3", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid access point ARN: invalid resource
func TestEndpointCase2(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint:more-data"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid access point ARN: invalid no ap name
func TestEndpointCase3(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid access point ARN: AccountId is invalid
func TestEndpointCase4(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3:us-west-2:123456_789012:accesspoint:apname"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123456_789012`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Invalid access point ARN: access point name is invalid
func TestEndpointCase5(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:ap_name"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `ap_name`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Access points (disable access points explicitly false)
func TestEndpointCase6(t *testing.T) {
	var params = EndpointParameters{
		Region:              ptr.String("us-east-1"),
		UseFIPS:             ptr.Bool(false),
		UseDualStack:        ptr.Bool(false),
		Accelerate:          ptr.Bool(false),
		DisableAccessPoints: ptr.Bool(false),
		Bucket:              ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Access points: partition does not support FIPS
func TestEndpointCase7(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-north-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3:cn-north-1:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Bucket region is invalid
func TestEndpointCase8(t *testing.T) {
	var params = EndpointParameters{
		Region:              ptr.String("us-east-1"),
		UseFIPS:             ptr.Bool(false),
		UseDualStack:        ptr.Bool(false),
		Accelerate:          ptr.Bool(false),
		DisableAccessPoints: ptr.Bool(false),
		Bucket:              ptr.String("arn:aws:s3:us-west -2:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region in ARN: `us-west -2` (invalid DNS name)", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Access points when Access points explicitly disabled (used for CreateBucket)
func TestEndpointCase9(t *testing.T) {
	var params = EndpointParameters{
		Region:              ptr.String("us-east-1"),
		UseFIPS:             ptr.Bool(false),
		UseDualStack:        ptr.Bool(false),
		Accelerate:          ptr.Bool(false),
		DisableAccessPoints: ptr.Bool(true),
		Bucket:              ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Access points are not supported for this operation", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// missing arn type
func TestEndpointCase10(t *testing.T) {
	var params = EndpointParameters{
		Region:              ptr.String("us-east-1"),
		UseFIPS:             ptr.Bool(false),
		UseDualStack:        ptr.Bool(false),
		Accelerate:          ptr.Bool(false),
		DisableAccessPoints: ptr.Bool(true),
		Bucket:              ptr.String("arn:aws:s3:us-west-2:123456789012:"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: `arn:aws:s3:us-west-2:123456789012:` was not a valid ARN", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::Host + access point + Dualstack is an error
func TestEndpointCase11(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://beta.example.com"),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Access point ARN with FIPS & Dualstack
func TestEndpointCase12(t *testing.T) {
	var params = EndpointParameters{
		Region:              ptr.String("us-east-1"),
		UseFIPS:             ptr.Bool(true),
		UseDualStack:        ptr.Bool(true),
		Accelerate:          ptr.Bool(false),
		DisableAccessPoints: ptr.Bool(false),
		Bucket:              ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Access point ARN with Dualstack
func TestEndpointCase13(t *testing.T) {
	var params = EndpointParameters{
		Region:              ptr.String("us-east-1"),
		UseFIPS:             ptr.Bool(false),
		UseDualStack:        ptr.Bool(true),
		Accelerate:          ptr.Bool(false),
		DisableAccessPoints: ptr.Bool(false),
		Bucket:              ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint.dualstack.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla MRAP
func TestEndpointCase14(t *testing.T) {
	var params = EndpointParameters{
		Bucket:                         ptr.String("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap"),
		Region:                         ptr.String("us-east-1"),
		DisableMultiRegionAccessPoints: ptr.Bool(false),
		UseFIPS:                        ptr.Bool(false),
		UseDualStack:                   ptr.Bool(false),
		Accelerate:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mfzwi23gnjvgw.mrap.accesspoint.s3-global.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4a",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4ASigningRegions(&sp, []string{"*"})

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// MRAP does not support FIPS
func TestEndpointCase15(t *testing.T) {
	var params = EndpointParameters{
		Bucket:                         ptr.String("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap"),
		Region:                         ptr.String("us-east-1"),
		DisableMultiRegionAccessPoints: ptr.Bool(false),
		UseFIPS:                        ptr.Bool(true),
		UseDualStack:                   ptr.Bool(false),
		Accelerate:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 MRAP does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// MRAP does not support DualStack
func TestEndpointCase16(t *testing.T) {
	var params = EndpointParameters{
		Bucket:                         ptr.String("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap"),
		Region:                         ptr.String("us-east-1"),
		DisableMultiRegionAccessPoints: ptr.Bool(false),
		UseFIPS:                        ptr.Bool(false),
		UseDualStack:                   ptr.Bool(true),
		Accelerate:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 MRAP does not support dual-stack", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// MRAP does not support S3 Accelerate
func TestEndpointCase17(t *testing.T) {
	var params = EndpointParameters{
		Bucket:                         ptr.String("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap"),
		Region:                         ptr.String("us-east-1"),
		DisableMultiRegionAccessPoints: ptr.Bool(false),
		UseFIPS:                        ptr.Bool(false),
		UseDualStack:                   ptr.Bool(false),
		Accelerate:                     ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 MRAP does not support S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// MRAP explicitly disabled
func TestEndpointCase18(t *testing.T) {
	var params = EndpointParameters{
		Bucket:                         ptr.String("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap"),
		Region:                         ptr.String("us-east-1"),
		DisableMultiRegionAccessPoints: ptr.Bool(true),
		UseFIPS:                        ptr.Bool(false),
		UseDualStack:                   ptr.Bool(false),
		Accelerate:                     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: Multi-Region Access Point ARNs are disabled.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Dual-stack endpoint with path-style forced
func TestEndpointCase19(t *testing.T) {
	var params = EndpointParameters{
		Bucket:         ptr.String("bucketname"),
		Region:         ptr.String("us-west-2"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
		Accelerate:     ptr.Bool(false),
		UseDualStack:   ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-west-2.amazonaws.com/bucketname")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Dual-stack endpoint + SDK::Host is error
func TestEndpointCase20(t *testing.T) {
	var params = EndpointParameters{
		Bucket:         ptr.String("bucketname"),
		Region:         ptr.String("us-west-2"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
		Accelerate:     ptr.Bool(false),
		UseDualStack:   ptr.Bool(true),
		Endpoint:       ptr.String("https://abc.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + ARN bucket
func TestEndpointCase21(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with ARN buckets", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// implicit path style bucket + dualstack
func TestEndpointCase22(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("99_ab"),
		Region:       ptr.String("us-west-2"),
		UseDualStack: ptr.Bool(true),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-west-2.amazonaws.com/99_ab")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// implicit path style bucket + dualstack
func TestEndpointCase23(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("99_ab"),
		Region:       ptr.String("us-west-2"),
		UseDualStack: ptr.Bool(true),
		UseFIPS:      ptr.Bool(false),
		Endpoint:     ptr.String("http://abc.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// don't allow URL injections in the bucket
func TestEndpointCase24(t *testing.T) {
	var params = EndpointParameters{
		Bucket:       ptr.String("example.com#"),
		Region:       ptr.String("us-west-2"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com/example.com%23")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// URI encode bucket names in the path
func TestEndpointCase25(t *testing.T) {
	var params = EndpointParameters{
		Bucket:       ptr.String("bucket name"),
		Region:       ptr.String("us-west-2"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com/bucket%20name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// scheme is respected
func TestEndpointCase26(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("99_ab"),
		Endpoint:     ptr.String("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:       ptr.String("af-south-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// scheme is respected (virtual addressing)
func TestEndpointCase27(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("bucketname"),
		Endpoint:     ptr.String("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/foo"),
		Region:       ptr.String("af-south-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://bucketname.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/foo")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + implicit private link
func TestEndpointCase28(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("99_ab"),
		Endpoint:     ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:       ptr.String("af-south-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/99_ab")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// invalid Endpoint override
func TestEndpointCase29(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("bucketname"),
		Endpoint:     ptr.String("abcde://nota#url"),
		Region:       ptr.String("af-south-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Custom endpoint `abcde://nota#url` was not a valid URI", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// using an IPv4 address forces path style
func TestEndpointCase30(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("bucketname"),
		Endpoint:     ptr.String("https://123.123.0.1"),
		Region:       ptr.String("af-south-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://123.123.0.1/bucketname")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla access point arn with region mismatch and UseArnRegion=false
func TestEndpointCase31(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:us-east-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		UseArnRegion:   ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// vanilla access point arn with region mismatch and UseArnRegion unset
func TestEndpointCase32(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-east-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla access point arn with region mismatch and UseArnRegion=true
func TestEndpointCase33(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		UseArnRegion:   ptr.Bool(true),
		Region:         ptr.String("us-east-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// subdomains are not allowed in virtual buckets
func TestEndpointCase34(t *testing.T) {
	var params = EndpointParameters{
		Bucket: ptr.String("bucket.name"),
		Region: ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-east-1.amazonaws.com/bucket.name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// bucket names with 3 characters are allowed in virtual buckets
func TestEndpointCase35(t *testing.T) {
	var params = EndpointParameters{
		Bucket: ptr.String("aaa"),
		Region: ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://aaa.s3.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// bucket names with fewer than 3 characters are not allowed in virtual host
func TestEndpointCase36(t *testing.T) {
	var params = EndpointParameters{
		Bucket: ptr.String("aa"),
		Region: ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-east-1.amazonaws.com/aa")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// bucket names with uppercase characters are not allowed in virtual host
func TestEndpointCase37(t *testing.T) {
	var params = EndpointParameters{
		Bucket: ptr.String("BucketName"),
		Region: ptr.String("us-east-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-east-1.amazonaws.com/BucketName")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// subdomains are allowed in virtual buckets on http endpoints
func TestEndpointCase38(t *testing.T) {
	var params = EndpointParameters{
		Bucket:   ptr.String("bucket.name"),
		Region:   ptr.String("us-east-1"),
		Endpoint: ptr.String("http://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://bucket.name.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// no region set
func TestEndpointCase39(t *testing.T) {
	var params = EndpointParameters{
		Bucket: ptr.String("bucket-name"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A region must be set when sending requests to S3.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// UseGlobalEndpoints=true, region=us-east-1 uses the global endpoint
func TestEndpointCase40(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=us-west-2 uses the regional endpoint
func TestEndpointCase41(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-west-2"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=cn-north-1 uses the regional endpoint
func TestEndpointCase42(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("cn-north-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=us-east-1, fips=true uses the regional endpoint
// with fips
func TestEndpointCase43(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=us-east-1, dualstack=true uses the regional
// endpoint with dualstack
func TestEndpointCase44(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(true),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=us-east-1, dualstack and fips uses the regional
// endpoint with fips/dualstack
func TestEndpointCase45(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=us-east-1 with custom endpoint, uses custom
func TestEndpointCase46(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Endpoint:          ptr.String("https://example.com"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=us-west-2 with custom endpoint, uses custom
func TestEndpointCase47(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-west-2"),
		Endpoint:          ptr.String("https://example.com"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// UseGlobalEndpoints=true, region=us-east-1 with accelerate on non bucket case
// uses the global endpoint and ignores accelerate
func TestEndpointCase48(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global region uses the global endpoint
func TestEndpointCase49(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global region with fips uses the regional endpoint
func TestEndpointCase50(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global region with dualstack uses the regional endpoint
func TestEndpointCase51(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global region with fips and dualstack uses the regional endpoint
func TestEndpointCase52(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global region with accelerate on non-bucket case, uses global endpoint and
// ignores accelerate
func TestEndpointCase53(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global region with custom endpoint, uses custom
func TestEndpointCase54(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("aws-global"),
		Endpoint:          ptr.String("https://example.com"),
		UseGlobalEndpoint: ptr.Bool(false),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, aws-global region uses the global endpoint
func TestEndpointCase55(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket-name"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, aws-global region with Prefix, and Key uses the global
// endpoint. Prefix and Key parameters should not be used in endpoint evaluation.
func TestEndpointCase56(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket-name"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Prefix:       ptr.String("prefix"),
		Key:          ptr.String("key"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, aws-global region with fips uses the regional fips endpoint
func TestEndpointCase57(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket-name"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, aws-global region with dualstack uses the regional dualstack
// endpoint
func TestEndpointCase58(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket-name"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, aws-global region with fips/dualstack uses the regional
// fips/dualstack endpoint
func TestEndpointCase59(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket-name"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-fips.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, aws-global region with accelerate uses the global accelerate
// endpoint
func TestEndpointCase60(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket-name"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-accelerate.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, aws-global region with custom endpoint
func TestEndpointCase61(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Endpoint:     ptr.String("https://example.com"),
		Bucket:       ptr.String("bucket-name"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, UseGlobalEndpoint and us-east-1 region uses the global
// endpoint
func TestEndpointCase62(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		Bucket:            ptr.String("bucket-name"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, UseGlobalEndpoint and us-west-2 region uses the regional
// endpoint
func TestEndpointCase63(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-west-2"),
		UseGlobalEndpoint: ptr.Bool(true),
		Bucket:            ptr.String("bucket-name"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, UseGlobalEndpoint and us-east-1 region and fips uses the
// regional fips endpoint
func TestEndpointCase64(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		Bucket:            ptr.String("bucket-name"),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, UseGlobalEndpoint and us-east-1 region and dualstack uses
// the regional dualstack endpoint
func TestEndpointCase65(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		Bucket:            ptr.String("bucket-name"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(true),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, UseGlobalEndpoint and us-east-1 region and accelerate uses
// the global accelerate endpoint
func TestEndpointCase66(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		Bucket:            ptr.String("bucket-name"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-accelerate.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing, UseGlobalEndpoint and us-east-1 region with custom endpoint
func TestEndpointCase67(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Endpoint:          ptr.String("https://example.com"),
		UseGlobalEndpoint: ptr.Bool(true),
		Bucket:            ptr.String("bucket-name"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, aws-global region uses the global endpoint
func TestEndpointCase68(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("aws-global"),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
		UseDualStack:   ptr.Bool(false),
		Accelerate:     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, aws-global region with fips is invalid
func TestEndpointCase69(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("aws-global"),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
		UseDualStack:   ptr.Bool(false),
		Accelerate:     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-east-1.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, aws-global region with dualstack uses regional dualstack
// endpoint
func TestEndpointCase70(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("aws-global"),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
		UseDualStack:   ptr.Bool(true),
		Accelerate:     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-east-1.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, aws-global region custom endpoint uses the custom endpoint
func TestEndpointCase71(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("aws-global"),
		Endpoint:       ptr.String("https://example.com"),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
		UseDualStack:   ptr.Bool(false),
		Accelerate:     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, UseGlobalEndpoint us-east-1 region uses the global endpoint
func TestEndpointCase72(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket-name"),
		UseGlobalEndpoint: ptr.Bool(true),
		ForcePathStyle:    ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, UseGlobalEndpoint us-west-2 region uses the regional endpoint
func TestEndpointCase73(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-west-2"),
		Bucket:            ptr.String("bucket-name"),
		UseGlobalEndpoint: ptr.Bool(true),
		ForcePathStyle:    ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, UseGlobalEndpoint us-east-1 region, dualstack uses the regional
// dualstack endpoint
func TestEndpointCase74(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket-name"),
		UseGlobalEndpoint: ptr.Bool(true),
		ForcePathStyle:    ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(true),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-east-1.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ForcePathStyle, UseGlobalEndpoint us-east-1 region custom endpoint uses the
// custom endpoint
func TestEndpointCase75(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket-name"),
		Endpoint:          ptr.String("https://example.com"),
		UseGlobalEndpoint: ptr.Bool(true),
		ForcePathStyle:    ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// ARN with aws-global region and  UseArnRegion uses the regional endpoint
func TestEndpointCase76(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseArnRegion: ptr.Bool(true),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// cross partition MRAP ARN is an error
func TestEndpointCase77(t *testing.T) {
	var params = EndpointParameters{
		Bucket: ptr.String("arn:aws-cn:s3::123456789012:accesspoint:mfzwi23gnjvgw.mrap"),
		Region: ptr.String("us-west-1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Client was configured for partition `aws` but bucket referred to partition `aws-cn`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Endpoint override, accesspoint with HTTP, port
func TestEndpointCase78(t *testing.T) {
	var params = EndpointParameters{
		Endpoint: ptr.String("http://beta.example.com:1234"),
		Region:   ptr.String("us-west-2"),
		Bucket:   ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://myendpoint-123456789012.beta.example.com:1234")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Endpoint override, accesspoint with http, path, query, and port
func TestEndpointCase79(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Bucket:       ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		Endpoint:     ptr.String("http://beta.example.com:1234/path"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://myendpoint-123456789012.beta.example.com:1234/path")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// non-bucket endpoint override with FIPS = error
func TestEndpointCase80(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Endpoint:     ptr.String("http://beta.example.com:1234/path"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// FIPS + dualstack + custom endpoint
func TestEndpointCase81(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Endpoint:     ptr.String("http://beta.example.com:1234/path"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// dualstack + custom endpoint
func TestEndpointCase82(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Endpoint:     ptr.String("http://beta.example.com:1234/path"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// custom endpoint without FIPS/dualstack
func TestEndpointCase83(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Endpoint:     ptr.String("http://beta.example.com:1234/path"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://beta.example.com:1234/path")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// s3 object lambda with access points disabled
func TestEndpointCase84(t *testing.T) {
	var params = EndpointParameters{
		Region:              ptr.String("us-west-2"),
		Bucket:              ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:myendpoint"),
		DisableAccessPoints: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Access points are not supported for this operation", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// non bucket + FIPS
func TestEndpointCase85(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// standard non bucket endpoint
func TestEndpointCase86(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// non bucket endpoint with FIPS + Dualstack
func TestEndpointCase87(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// non bucket endpoint with dualstack
func TestEndpointCase88(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// use global endpoint + IP address endpoint override
func TestEndpointCase89(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Endpoint:          ptr.String("http://127.0.0.1"),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://127.0.0.1/bucket")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// non-dns endpoint + global endpoint
func TestEndpointCase90(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// endpoint override + use global endpoint
func TestEndpointCase91(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
		Endpoint:          ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://foo.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// FIPS + dualstack + non-bucket endpoint
func TestEndpointCase92(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("bucket!"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// FIPS + dualstack + non-DNS endpoint
func TestEndpointCase93(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("us-east-1"),
		Bucket:         ptr.String("bucket!"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
		UseDualStack:   ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// endpoint override + FIPS + dualstack (BUG)
func TestEndpointCase94(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("us-east-1"),
		Bucket:         ptr.String("bucket!"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
		UseDualStack:   ptr.Bool(false),
		Endpoint:       ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// endpoint override + non-dns bucket + FIPS (BUG)
func TestEndpointCase95(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("bucket!"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Endpoint:     ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// FIPS + bucket endpoint + force path style
func TestEndpointCase96(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		ForcePathStyle:    ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// bucket + FIPS + force path style
func TestEndpointCase97(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket"),
		ForcePathStyle:    ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// FIPS + dualstack + use global endpoint
func TestEndpointCase98(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket"),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket.s3-fips.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// URI encoded bucket + use global endpoint
func TestEndpointCase99(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
		Endpoint:          ptr.String("https://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// FIPS + path based endpoint
func TestEndpointCase100(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate + dualstack + global endpoint
func TestEndpointCase101(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(true),
		Accelerate:        ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket.s3-accelerate.dualstack.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// dualstack + global endpoint + non URI safe bucket
func TestEndpointCase102(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		Accelerate:        ptr.Bool(false),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// FIPS + uri encoded bucket
func TestEndpointCase103(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		ForcePathStyle:    ptr.Bool(true),
		Accelerate:        ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// endpoint override + non-uri safe endpoint + force path style
func TestEndpointCase104(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		ForcePathStyle:    ptr.Bool(true),
		Accelerate:        ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		UseFIPS:           ptr.Bool(true),
		Endpoint:          ptr.String("http://foo.com"),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// FIPS + Dualstack + global endpoint + non-dns bucket
func TestEndpointCase105(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		Bucket:            ptr.String("bucket!"),
		Accelerate:        ptr.Bool(false),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// endpoint override + FIPS + dualstack
func TestEndpointCase106(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseDualStack:      ptr.Bool(true),
		UseFIPS:           ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
		Endpoint:          ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// non-bucket endpoint override + dualstack + global endpoint
func TestEndpointCase107(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
		Endpoint:          ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Endpoint override + UseGlobalEndpoint + us-east-1
func TestEndpointCase108(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
		Endpoint:          ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// non-FIPS partition with FIPS set + custom endpoint
func TestEndpointCase109(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("cn-north-1"),
		UseFIPS:           ptr.Bool(true),
		UseDualStack:      ptr.Bool(false),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// aws-global signs as us-east-1
func TestEndpointCase110(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket!"),
		UseFIPS:      ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global signs as us-east-1
func TestEndpointCase111(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Endpoint:     ptr.String("https://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket.foo.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global + dualstack + path-only bucket
func TestEndpointCase112(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket!"),
		UseDualStack: ptr.Bool(true),
		UseFIPS:      ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global + path-only bucket
func TestEndpointCase113(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("aws-global"),
		Bucket: ptr.String("bucket!"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global + fips + custom endpoint
func TestEndpointCase114(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket!"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
		Endpoint:     ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// aws-global, endpoint override & path only-bucket
func TestEndpointCase115(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket!"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Endpoint:     ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://foo.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global + dualstack + custom endpoint
func TestEndpointCase116(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseDualStack: ptr.Bool(true),
		UseFIPS:      ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Endpoint:     ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// accelerate, dualstack + aws-global
func TestEndpointCase117(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		Bucket:       ptr.String("bucket"),
		UseDualStack: ptr.Bool(true),
		UseFIPS:      ptr.Bool(false),
		Accelerate:   ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket.s3-accelerate.dualstack.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// FIPS + aws-global + path only bucket. This is not supported by S3 but we allow
// garbage in garbage out
func TestEndpointCase118(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("aws-global"),
		Bucket:         ptr.String("bucket!"),
		ForcePathStyle: ptr.Bool(true),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
		Accelerate:     ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.dualstack.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// aws-global + FIPS + endpoint override.
func TestEndpointCase119(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("aws-global"),
		UseFIPS:  ptr.Bool(true),
		Endpoint: ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// force path style, FIPS, aws-global & endpoint override
func TestEndpointCase120(t *testing.T) {
	var params = EndpointParameters{
		Region:         ptr.String("aws-global"),
		Bucket:         ptr.String("bucket!"),
		ForcePathStyle: ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
		Endpoint:       ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// ip address causes path style to be forced
func TestEndpointCase121(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("aws-global"),
		Bucket:   ptr.String("bucket"),
		Endpoint: ptr.String("http://192.168.1.1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://192.168.1.1/bucket")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// endpoint override with aws-global region
func TestEndpointCase122(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(true),
		Endpoint:     ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// FIPS + path-only (TODO: consider making this an error)
func TestEndpointCase123(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("aws-global"),
		Bucket:  ptr.String("bucket!"),
		UseFIPS: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-east-1.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// empty arn type
func TestEndpointCase124(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:not-s3:us-west-2:123456789012::myendpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: No ARN type specified", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style can't be used with accelerate
func TestEndpointCase125(t *testing.T) {
	var params = EndpointParameters{
		Region:     ptr.String("us-east-2"),
		Bucket:     ptr.String("bucket!"),
		Accelerate: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid region
func TestEndpointCase126(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("us-east-2!"),
		Bucket:   ptr.String("bucket.subdomain"),
		Endpoint: ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region: region was not a valid DNS name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid region
func TestEndpointCase127(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("us-east-2!"),
		Bucket:   ptr.String("bucket"),
		Endpoint: ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region: region was not a valid DNS name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// empty arn type
func TestEndpointCase128(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:s3::123456789012:accesspoint:my_endpoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Access Point Name", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// empty arn type
func TestEndpointCase129(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-2"),
		Bucket:       ptr.String("arn:aws:s3:cn-north-1:123456789012:accesspoint:my-endpoint"),
		UseArnRegion: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Client was configured for partition `aws` but ARN (`arn:aws:s3:cn-north-1:123456789012:accesspoint:my-endpoint`) has `aws-cn`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid arn region
func TestEndpointCase130(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-2"),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-east_2:123456789012:accesspoint:my-endpoint"),
		UseArnRegion: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region in ARN: `us-east_2` (invalid DNS name)", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid ARN outpost
func TestEndpointCase131(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-2"),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op_01234567890123456/accesspoint/reports"),
		UseArnRegion: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `op_01234567890123456`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid ARN
func TestEndpointCase132(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: expected an access point name", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid ARN
func TestEndpointCase133(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected a 4-component resource", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid outpost type
func TestEndpointCase134(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/not-accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Expected an outpost type `accesspoint`, found not-accesspoint", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid outpost type
func TestEndpointCase135(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:s3-outposts:us-east_1:123456789012:outpost/op-01234567890123456/not-accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region in ARN: `us-east_1` (invalid DNS name)", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid outpost type
func TestEndpointCase136(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:s3-outposts:us-east-1:12345_789012:outpost/op-01234567890123456/not-accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `12345_789012`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// invalid outpost type
func TestEndpointCase137(t *testing.T) {
	var params = EndpointParameters{
		Region: ptr.String("us-east-2"),
		Bucket: ptr.String("arn:aws:s3-outposts:us-east-1:12345789012:outpost"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The Outpost Id was not set", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// use global endpoint virtual addressing
func TestEndpointCase138(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-2"),
		Bucket:            ptr.String("bucket"),
		Endpoint:          ptr.String("http://example.com"),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://bucket.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// global endpoint + ip address
func TestEndpointCase139(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-2"),
		Bucket:            ptr.String("bucket"),
		Endpoint:          ptr.String("http://192.168.0.1"),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://192.168.0.1/bucket")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// invalid outpost type
func TestEndpointCase140(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-2"),
		Bucket:            ptr.String("bucket!"),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-east-2.amazonaws.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// invalid outpost type
func TestEndpointCase141(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-2"),
		Bucket:            ptr.String("bucket"),
		Accelerate:        ptr.Bool(true),
		UseGlobalEndpoint: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket.s3-accelerate.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// use global endpoint + custom endpoint
func TestEndpointCase142(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-2"),
		Bucket:            ptr.String("bucket!"),
		UseGlobalEndpoint: ptr.Bool(true),
		Endpoint:          ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://foo.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// use global endpoint, not us-east-1, force path style
func TestEndpointCase143(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-2"),
		Bucket:            ptr.String("bucket!"),
		UseGlobalEndpoint: ptr.Bool(true),
		ForcePathStyle:    ptr.Bool(true),
		Endpoint:          ptr.String("http://foo.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://foo.com/bucket%21")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-2")

						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla virtual addressing@us-west-2
func TestEndpointCase144(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + dualstack@us-west-2
func TestEndpointCase145(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.dualstack.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate + dualstack@us-west-2
func TestEndpointCase146(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-accelerate.dualstack.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate (dualstack=false)@us-west-2
func TestEndpointCase147(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-accelerate.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + fips@us-west-2
func TestEndpointCase148(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-fips.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + dualstack + fips@us-west-2
func TestEndpointCase149(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-fips.dualstack.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate + fips = error@us-west-2
func TestEndpointCase150(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Accelerate cannot be used with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// vanilla virtual addressing@cn-north-1
func TestEndpointCase151(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + dualstack@cn-north-1
func TestEndpointCase152(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.dualstack.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate (dualstack=false)@cn-north-1
func TestEndpointCase153(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Accelerate cannot be used in this region", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// virtual addressing + fips@cn-north-1
func TestEndpointCase154(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// vanilla virtual addressing@af-south-1
func TestEndpointCase155(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + dualstack@af-south-1
func TestEndpointCase156(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3.dualstack.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate + dualstack@af-south-1
func TestEndpointCase157(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-accelerate.dualstack.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate (dualstack=false)@af-south-1
func TestEndpointCase158(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-accelerate.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + fips@af-south-1
func TestEndpointCase159(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-fips.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + dualstack + fips@af-south-1
func TestEndpointCase160(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.s3-fips.dualstack.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// accelerate + fips = error@af-south-1
func TestEndpointCase161(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Accelerate cannot be used with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// vanilla path style@us-west-2
func TestEndpointCase162(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// fips@us-gov-west-2, bucket is not S3-dns-compatible (subdomains)
func TestEndpointCase163(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("bucket.with.dots"),
		Region:       ptr.String("us-gov-west-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.us-gov-west-1.amazonaws.com/bucket.with.dots")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-west-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + accelerate = error@us-west-2
func TestEndpointCase164(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + dualstack@us-west-2
func TestEndpointCase165(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.us-west-2.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + arn is error@us-west-2
func TestEndpointCase166(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with ARN buckets", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + invalid DNS name@us-west-2
func TestEndpointCase167(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("99a_b"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com/99a_b")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// no path style + invalid DNS name@us-west-2
func TestEndpointCase168(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("99a_b"),
		Region:       ptr.String("us-west-2"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.us-west-2.amazonaws.com/99a_b")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla path style@cn-north-1
func TestEndpointCase169(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.cn-north-1.amazonaws.com.cn/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + fips@cn-north-1
func TestEndpointCase170(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + accelerate = error@cn-north-1
func TestEndpointCase171(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + dualstack@cn-north-1
func TestEndpointCase172(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.cn-north-1.amazonaws.com.cn/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + arn is error@cn-north-1
func TestEndpointCase173(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with ARN buckets", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + invalid DNS name@cn-north-1
func TestEndpointCase174(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("99a_b"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.cn-north-1.amazonaws.com.cn/99a_b")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// no path style + invalid DNS name@cn-north-1
func TestEndpointCase175(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("99a_b"),
		Region:       ptr.String("cn-north-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.cn-north-1.amazonaws.com.cn/99a_b")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla path style@af-south-1
func TestEndpointCase176(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.af-south-1.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + fips@af-south-1
func TestEndpointCase177(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-fips.af-south-1.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + accelerate = error@af-south-1
func TestEndpointCase178(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + dualstack@af-south-1
func TestEndpointCase179(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.dualstack.af-south-1.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + arn is error@af-south-1
func TestEndpointCase180(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:PARTITION:s3-outposts:REGION:123456789012:outpost:op-01234567890123456:bucket:mybucket"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Path-style addressing cannot be used with ARN buckets", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// path style + invalid DNS name@af-south-1
func TestEndpointCase181(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("99a_b"),
		ForcePathStyle: ptr.Bool(true),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.af-south-1.amazonaws.com/99a_b")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// no path style + invalid DNS name@af-south-1
func TestEndpointCase182(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("99a_b"),
		Region:       ptr.String("af-south-1"),
		UseDualStack: ptr.Bool(false),
		UseFIPS:      ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3.af-south-1.amazonaws.com/99a_b")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + private link@us-west-2
func TestEndpointCase183(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + private link@us-west-2
func TestEndpointCase184(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// SDK::Host + FIPS@us-west-2
func TestEndpointCase185(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::Host + DualStack@us-west-2
func TestEndpointCase186(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::HOST + accelerate@us-west-2
func TestEndpointCase187(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("http://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::Host + access point ARN@us-west-2
func TestEndpointCase188(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://beta.example.com"),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + private link@cn-north-1
func TestEndpointCase189(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + private link@cn-north-1
func TestEndpointCase190(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// FIPS@cn-north-1
func TestEndpointCase191(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::Host + DualStack@cn-north-1
func TestEndpointCase192(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::HOST + accelerate@cn-north-1
func TestEndpointCase193(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::Host + access point ARN@cn-north-1
func TestEndpointCase194(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://beta.example.com"),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// virtual addressing + private link@af-south-1
func TestEndpointCase195(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://bucket-name.control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// path style + private link@af-south-1
func TestEndpointCase196(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(true),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com/bucket-name")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// SDK::Host + FIPS@af-south-1
func TestEndpointCase197(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::Host + DualStack@af-south-1
func TestEndpointCase198(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Cannot set dual-stack in combination with a custom endpoint.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::HOST + accelerate@af-south-1
func TestEndpointCase199(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("bucket-name"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://control.vpce-1a2b3c4d-5e6f.s3.us-west-2.vpce.amazonaws.com"),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "A custom endpoint cannot be combined with S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// SDK::Host + access point ARN@af-south-1
func TestEndpointCase200(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Endpoint:       ptr.String("https://beta.example.com"),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.beta.example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla access point arn@us-west-2
func TestEndpointCase201(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// access point arn + FIPS@us-west-2
func TestEndpointCase202(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint-fips.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// access point arn + accelerate = error@us-west-2
func TestEndpointCase203(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Access Points do not support S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// access point arn + FIPS + DualStack@us-west-2
func TestEndpointCase204(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:us-west-2:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// vanilla access point arn@cn-north-1
func TestEndpointCase205(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint.cn-north-1.amazonaws.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "cn-north-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// access point arn + FIPS@cn-north-1
func TestEndpointCase206(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// access point arn + accelerate = error@cn-north-1
func TestEndpointCase207(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Access Points do not support S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// access point arn + FIPS + DualStack@cn-north-1
func TestEndpointCase208(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws-cn:s3:cn-north-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("cn-north-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// vanilla access point arn@af-south-1
func TestEndpointCase209(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// access point arn + FIPS@af-south-1
func TestEndpointCase210(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint-fips.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// access point arn + accelerate = error@af-south-1
func TestEndpointCase211(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(true),
		Bucket:         ptr.String("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Access Points do not support S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// access point arn + FIPS + DualStack@af-south-1
func TestEndpointCase212(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3:af-south-1:123456789012:accesspoint:myendpoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("af-south-1"),
		UseDualStack:   ptr.Bool(true),
		UseFIPS:        ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myendpoint-123456789012.s3-accesspoint-fips.dualstack.af-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "af-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 outposts vanilla test
func TestEndpointCase213(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://reports-123456789012.op-01234567890123456.s3-outposts.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 outposts custom endpoint
func TestEndpointCase214(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports"),
		Endpoint:     ptr.String("https://example.amazonaws.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://reports-123456789012.op-01234567890123456.example.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// outposts arn with region mismatch and UseArnRegion=false
func TestEndpointCase215(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		ForcePathStyle: ptr.Bool(false),
		UseArnRegion:   ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// outposts arn with region mismatch, custom region and UseArnRegion=false
func TestEndpointCase216(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		Endpoint:       ptr.String("https://example.com"),
		ForcePathStyle: ptr.Bool(false),
		UseArnRegion:   ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// outposts arn with region mismatch and UseArnRegion=true
func TestEndpointCase217(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		ForcePathStyle: ptr.Bool(false),
		UseArnRegion:   ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// outposts arn with region mismatch and UseArnRegion unset
func TestEndpointCase218(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		ForcePathStyle: ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://myaccesspoint-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// outposts arn with partition mismatch and UseArnRegion=true
func TestEndpointCase219(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint"),
		ForcePathStyle: ptr.Bool(false),
		UseArnRegion:   ptr.Bool(true),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Client was configured for partition `aws` but ARN (`arn:aws:s3-outposts:cn-north-1:123456789012:outpost:op-01234567890123456:accesspoint:myaccesspoint`) has `aws-cn`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// ARN with UseGlobalEndpoint and use-east-1 region uses the regional endpoint
func TestEndpointCase220(t *testing.T) {
	var params = EndpointParameters{
		Region:            ptr.String("us-east-1"),
		UseGlobalEndpoint: ptr.Bool(true),
		UseFIPS:           ptr.Bool(false),
		UseDualStack:      ptr.Bool(false),
		Accelerate:        ptr.Bool(false),
		Bucket:            ptr.String("arn:aws:s3-outposts:us-east-1:123456789012:outpost/op-01234567890123456/accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://reports-123456789012.op-01234567890123456.s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 outposts does not support dualstack
func TestEndpointCase221(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Outposts does not support Dual-stack", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// S3 outposts does not support fips
func TestEndpointCase222(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Outposts does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// S3 outposts does not support accelerate
func TestEndpointCase223(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost/op-01234567890123456/accesspoint/reports"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Outposts does not support S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// validates against subresource
func TestEndpointCase224(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-outposts:us-west-2:123456789012:outpost:op-01234567890123456:accesspoint:mybucket:object:foo"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Arn: Outpost Access Point ARN contains sub resources", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda @us-east-1
func TestEndpointCase225(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda @us-west-2
func TestEndpointCase226(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda, colon resource deliminator @us-west-2
func TestEndpointCase227(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda @us-east-1, client region us-west-2, useArnRegion=true
func TestEndpointCase228(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda @us-east-1, client region s3-external-1, useArnRegion=true
func TestEndpointCase229(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("s3-external-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda @us-east-1, client region s3-external-1, useArnRegion=false
func TestEndpointCase230(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("s3-external-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `s3-external-1` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda @us-east-1, client region aws-global, useArnRegion=true
func TestEndpointCase231(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda @us-east-1, client region aws-global, useArnRegion=false
func TestEndpointCase232(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `aws-global` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda @cn-north-1, client region us-west-2 (cross partition),
// useArnRegion=true
func TestEndpointCase233(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("aws-global"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Client was configured for partition `aws` but ARN (`arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner`) has `aws-cn`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with dualstack
func TestEndpointCase234(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(true),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Object Lambda does not support Dual-stack", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda @us-gov-east-1
func TestEndpointCase235(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-east-1"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws-us-gov:s3-object-lambda:us-gov-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda @us-gov-east-1, with fips
func TestEndpointCase236(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-gov-east-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws-us-gov:s3-object-lambda:us-gov-east-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.s3-object-lambda-fips.us-gov-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-gov-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda @cn-north-1, with fips
func TestEndpointCase237(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("cn-north-1"),
		UseFIPS:      ptr.Bool(true),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws-cn:s3-object-lambda:cn-north-1:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with accelerate
func TestEndpointCase238(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(true),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Object Lambda does not support S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - bad service and someresource
func TestEndpointCase239(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:sqs:us-west-2:123456789012:someresource"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Unrecognized format: arn:aws:sqs:us-west-2:123456789012:someresource (type: someresource)", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - invalid resource
func TestEndpointCase240(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:bucket_name:mybucket"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `bucket_name`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - missing region
func TestEndpointCase241(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda::123456789012:accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: bucket ARN is missing a region", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - missing account-id
func TestEndpointCase242(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2::accesspoint/mybanner"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Missing account id", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - account id contains invalid characters
func TestEndpointCase243(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123.45678.9012:accesspoint:mybucket"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `123.45678.9012`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - missing access point name
func TestEndpointCase244(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - access point name contains invalid character: *
func TestEndpointCase245(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:*"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `*`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - access point name contains invalid character: .
func TestEndpointCase246(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:my.bucket"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `my.bucket`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with invalid arn - access point name contains sub resources
func TestEndpointCase247(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(true),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint:mybucket:object:foo"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// object lambda with custom endpoint
func TestEndpointCase248(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		UseArnRegion: ptr.Bool(false),
		Bucket:       ptr.String("arn:aws:s3-object-lambda:us-west-2:123456789012:accesspoint/mybanner"),
		Endpoint:     ptr.String("https://my-endpoint.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybanner-123456789012.my-endpoint.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// object lambda arn with region mismatch and UseArnRegion=false
func TestEndpointCase249(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:     ptr.Bool(false),
		Bucket:         ptr.String("arn:aws:s3-object-lambda:us-east-1:123456789012:accesspoint/mybanner"),
		ForcePathStyle: ptr.Bool(false),
		UseArnRegion:   ptr.Bool(false),
		Region:         ptr.String("us-west-2"),
		UseDualStack:   ptr.Bool(false),
		UseFIPS:        ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid configuration: region from ARN `us-east-1` does not match client region `us-west-2` and UseArnRegion is `false`", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// WriteGetObjectResponse @ us-west-2
func TestEndpointCase250(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Region:                  ptr.String("us-west-2"),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-object-lambda.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// WriteGetObjectResponse with custom endpoint
func TestEndpointCase251(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Endpoint:                ptr.String("https://my-endpoint.com"),
		Region:                  ptr.String("us-west-2"),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://my-endpoint.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// WriteGetObjectResponse @ us-east-1
func TestEndpointCase252(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Region:                  ptr.String("us-east-1"),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-object-lambda.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// WriteGetObjectResponse with fips
func TestEndpointCase253(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Region:                  ptr.String("us-east-1"),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-object-lambda-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// WriteGetObjectResponse with dualstack
func TestEndpointCase254(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Region:                  ptr.String("us-east-1"),
		UseDualStack:            ptr.Bool(true),
		UseFIPS:                 ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Object Lambda does not support Dual-stack", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// WriteGetObjectResponse with accelerate
func TestEndpointCase255(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(true),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Region:                  ptr.String("us-east-1"),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3 Object Lambda does not support S3 Accelerate", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// WriteGetObjectResponse with fips in CN
func TestEndpointCase256(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		Region:                  ptr.String("cn-north-1"),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Partition does not support FIPS", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// WriteGetObjectResponse with invalid partition
func TestEndpointCase257(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Region:                  ptr.String("not a valid DNS name"),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid region: region was not a valid DNS name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// WriteGetObjectResponse with an unknown partition
func TestEndpointCase258(t *testing.T) {
	var params = EndpointParameters{
		Accelerate:              ptr.Bool(false),
		UseObjectLambdaEndpoint: ptr.Bool(true),
		Region:                  ptr.String("us-east.special"),
		UseDualStack:            ptr.Bool(false),
		UseFIPS:                 ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3-object-lambda.us-east.special.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-object-lambda")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-object-lambda")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east.special")
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Outposts bucketAlias Real Outpost Prod us-west-1
func TestEndpointCase259(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-1"),
		Bucket:       ptr.String("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.us-west-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Outposts bucketAlias Real Outpost Prod ap-east-1
func TestEndpointCase260(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("ap-east-1"),
		Bucket:       ptr.String("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.op-0b1d075431d83bebd.s3-outposts.ap-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "ap-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Outposts bucketAlias Ec2 Outpost Prod us-east-1
func TestEndpointCase261(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Outposts bucketAlias Ec2 Outpost Prod me-south-1
func TestEndpointCase262(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("me-south-1"),
		Bucket:       ptr.String("test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://test-accessp-e0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3.ec2.s3-outposts.me-south-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "me-south-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Outposts bucketAlias Real Outpost Beta
func TestEndpointCase263(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3"),
		Endpoint:     ptr.String("https://example.amazonaws.com"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3.op-0b1d075431d83bebd.example.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Outposts bucketAlias Ec2 Outpost Beta
func TestEndpointCase264(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("161743052723-e00000136899934034jeahy1t8gpzpbwjj8kb7beta0--op-s3"),
		Endpoint:     ptr.String("https://example.amazonaws.com"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://161743052723-e00000136899934034jeahy1t8gpzpbwjj8kb7beta0--op-s3.ec2.example.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3-outposts")
						smithyhttp.SetSigV4ASigningName(&sp, "s3-outposts")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Outposts bucketAlias - No endpoint set for beta
func TestEndpointCase265(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("test-accessp-o0b1d075431d83bebde8xz5w8ijx1qzlbp3i3kbeta0--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Expected a endpoint to be specified but no endpoint was found", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// S3 Outposts bucketAlias Invalid hardware type
func TestEndpointCase266(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("test-accessp-h0000075431d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Unrecognized hardware type: \"Expected hardware type o or e but got h\"", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// S3 Outposts bucketAlias Special character in Outpost Arn
func TestEndpointCase267(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("test-accessp-o00000754%1d83bebde8xz5w8ijx1qzlbp3i3kuse10--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// S3 Outposts bucketAlias - No endpoint set for beta
func TestEndpointCase268(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-east-1"),
		Bucket:       ptr.String("test-accessp-e0b1d075431d83bebde8xz5w8ijx1qzlbp3i3ebeta0--op-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Expected a endpoint to be specified but no endpoint was found", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// S3 Snow with bucket
func TestEndpointCase269(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("http://10.0.1.12:433"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://10.0.1.12:433/bucketName")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Snow without bucket
func TestEndpointCase270(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Endpoint:     ptr.String("https://10.0.1.12:433"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://10.0.1.12:433")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Snow no port
func TestEndpointCase271(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("http://10.0.1.12"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("http://10.0.1.12/bucketName")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// S3 Snow dns endpoint
func TestEndpointCase272(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("snow"),
		Bucket:       ptr.String("bucketName"),
		Endpoint:     ptr.String("https://amazonaws.com"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://amazonaws.com/bucketName")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3")
						smithyhttp.SetSigV4ASigningName(&sp, "s3")

						smithyhttp.SetSigV4SigningRegion(&sp, "snow")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane with short AZ
func TestEndpointCase273(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--use1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--use1-az1--x-s3.s3express-use1-az1.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "sigv4-s3express",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane with short AZ fips
func TestEndpointCase274(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--use1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--use1-az1--x-s3.s3express-fips-use1-az1.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "sigv4-s3express",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane with long AZ
func TestEndpointCase275(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("ap-northeast-1"),
		Bucket:                      ptr.String("mybucket--apne1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--apne1-az1--x-s3.s3express-apne1-az1.ap-northeast-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "sigv4-s3express",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "ap-northeast-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane with long AZ fips
func TestEndpointCase276(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("ap-northeast-1"),
		Bucket:                      ptr.String("mybucket--apne1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--apne1-az1--x-s3.s3express-fips-apne1-az1.ap-northeast-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "sigv4-s3express",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "ap-northeast-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Control plane with short AZ bucket
func TestEndpointCase277(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--use1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		DisableS3ExpressSessionAuth: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Control plane with short AZ bucket and fips
func TestEndpointCase278(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--use1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		DisableS3ExpressSessionAuth: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control-fips.us-east-1.amazonaws.com/mybucket--use1-az1--x-s3")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Control plane without bucket
func TestEndpointCase279(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		DisableS3ExpressSessionAuth: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Control plane without bucket and fips
func TestEndpointCase280(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		UseFIPS:                     ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		DisableS3ExpressSessionAuth: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://s3express-control-fips.us-east-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-east-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane sigv4 auth with short AZ
func TestEndpointCase281(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-west-2"),
		Bucket:                      ptr.String("mybucket--usw2-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--usw2-az1--x-s3.s3express-usw2-az1.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane sigv4 auth with short AZ fips
func TestEndpointCase282(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-west-2"),
		Bucket:                      ptr.String("mybucket--usw2-az1--x-s3"),
		UseFIPS:                     ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--usw2-az1--x-s3.s3express-fips-usw2-az1.us-west-2.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane sigv4 auth with long AZ
func TestEndpointCase283(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("ap-northeast-1"),
		Bucket:                      ptr.String("mybucket--apne1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--apne1-az1--x-s3.s3express-apne1-az1.ap-northeast-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "ap-northeast-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data Plane sigv4 auth with long AZ fips
func TestEndpointCase284(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("ap-northeast-1"),
		Bucket:                      ptr.String("mybucket--apne1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(true),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--apne1-az1--x-s3.s3express-fips-apne1-az1.ap-northeast-1.amazonaws.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "ap-northeast-1")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Control Plane host override
func TestEndpointCase285(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-west-2"),
		Bucket:                      ptr.String("mybucket--usw2-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
		Endpoint:                    ptr.String("https://custom.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--usw2-az1--x-s3.custom.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Control Plane host override no bucket
func TestEndpointCase286(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-west-2"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
		Endpoint:                    ptr.String("https://custom.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://custom.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data plane host override non virtual session auth
func TestEndpointCase287(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Bucket:       ptr.String("mybucket--usw2-az1--x-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Endpoint:     ptr.String("https://10.0.0.1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://10.0.0.1/mybucket--usw2-az1--x-s3")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "sigv4-s3express",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Control Plane host override ip
func TestEndpointCase288(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-west-2"),
		Bucket:                      ptr.String("mybucket--usw2-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(true),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
		Endpoint:                    ptr.String("https://10.0.0.1"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://10.0.0.1/mybucket--usw2-az1--x-s3")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "aws.auth#sigv4",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// Data plane host override
func TestEndpointCase289(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Bucket:       ptr.String("mybucket--usw2-az1--x-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Endpoint:     ptr.String("https://custom.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://mybucket--usw2-az1--x-s3.custom.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:     *uri,
		Headers: http.Header{},
		Properties: func() smithy.Properties {
			var out smithy.Properties
			smithyauth.SetAuthOptions(&out, []*smithyauth.Option{
				{
					SchemeID: "sigv4-s3express",
					SignerProperties: func() smithy.Properties {
						var sp smithy.Properties
						smithyhttp.SetSigV4SigningName(&sp, "s3express")
						smithyhttp.SetSigV4ASigningName(&sp, "s3express")

						smithyhttp.SetSigV4SigningRegion(&sp, "us-west-2")

						smithyhttp.SetDisableDoubleEncoding(&sp, true)
						return sp
					}(),
				},
			})
			out.Set("backend", "S3Express")
			return out
		}(),
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// bad format error
func TestEndpointCase290(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--usaz1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Unrecognized S3Express bucket name format.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// bad format error no session auth
func TestEndpointCase291(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--usaz1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Unrecognized S3Express bucket name format.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// dual-stack error
func TestEndpointCase292(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--use1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(true),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3Express does not support Dual-stack.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// accelerate error
func TestEndpointCase293(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("mybucket--use1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(true),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3Express does not support S3 Accelerate.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Data plane bucket format error
func TestEndpointCase294(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-east-1"),
		Bucket:                      ptr.String("my.bucket--use1-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		UseS3ExpressControlEndpoint: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3Express bucket name is not a valid virtual hostable name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// host override data plane bucket error session auth
func TestEndpointCase295(t *testing.T) {
	var params = EndpointParameters{
		Region:       ptr.String("us-west-2"),
		Bucket:       ptr.String("my.bucket--usw2-az1--x-s3"),
		UseFIPS:      ptr.Bool(false),
		UseDualStack: ptr.Bool(false),
		Accelerate:   ptr.Bool(false),
		Endpoint:     ptr.String("https://custom.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3Express bucket name is not a valid virtual hostable name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// host override data plane bucket error
func TestEndpointCase296(t *testing.T) {
	var params = EndpointParameters{
		Region:                      ptr.String("us-west-2"),
		Bucket:                      ptr.String("my.bucket--usw2-az1--x-s3"),
		UseFIPS:                     ptr.Bool(false),
		UseDualStack:                ptr.Bool(false),
		Accelerate:                  ptr.Bool(false),
		Endpoint:                    ptr.String("https://custom.com"),
		DisableS3ExpressSessionAuth: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "S3Express bucket name is not a valid virtual hostable name.", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}
