//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork

// AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual network.
type AddressSpace struct {
	// A list of address blocks reserved for this virtual network in CIDR notation.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`
}

// ApplicationGatewayBackendAddress - Backend address of an application gateway.
type ApplicationGatewayBackendAddress struct {
	// Fully qualified domain name (FQDN).
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address
	IPAddress *string `json:"ipAddress,omitempty"`
}

// ApplicationGatewayBackendAddressPool - Backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPool struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the backend address pool that is unique within an Application Gateway.
	Name *string `json:"name,omitempty"`

	// Properties of Backend Address Pool of an application gateway.
	Properties *ApplicationGatewayBackendAddressPoolPropertiesFormat `json:"properties,omitempty"`

	// Type of the resource.
	Type *string `json:"type,omitempty"`
}

// ApplicationGatewayBackendAddressPoolPropertiesFormat - Properties of Backend Address Pool of an application gateway.
type ApplicationGatewayBackendAddressPoolPropertiesFormat struct {
	// Backend addresses
	BackendAddresses []*ApplicationGatewayBackendAddress `json:"backendAddresses,omitempty"`

	// Collection of references to IPs defined in network interfaces.
	BackendIPConfigurations []*InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty"`

	// Provisioning state of the backend address pool resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ApplicationSecurityGroup - An application security group in a resource group.
type ApplicationSecurityGroup struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the application security group.
	Properties *ApplicationSecurityGroupPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ApplicationSecurityGroupPropertiesFormat - Application security group properties.
type ApplicationSecurityGroupPropertiesFormat struct {
	// READ-ONLY; The provisioning state of the application security group resource. Possible values are: 'Succeeded', 'Updating',
	// 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the application security group resource. It uniquely identifies a resource, even
	// if the user changes its name or migrate the resource across subscriptions or resource
	// groups.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// Availability of the metric.
type Availability struct {
	// Duration of the availability blob.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// The retention of the availability.
	Retention *string `json:"retention,omitempty"`

	// The time grain of the availability.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// AzureAsyncOperationResult - The response body contains the status of the specified asynchronous operation, indicating whether
// it has succeeded, is in progress, or has failed. Note that this status is distinct from the HTTP
// status code returned for the Get Operation Status operation itself. If the asynchronous operation succeeded, the response
// body includes the HTTP status code for the successful request. If the
// asynchronous operation failed, the response body includes the HTTP status code for the failed request and error information
// regarding the failure.
type AzureAsyncOperationResult struct {
	Error *Error `json:"error,omitempty"`

	// Status of the Azure async operation. Possible values are: 'InProgress', 'Succeeded', and 'Failed'.
	Status *NetworkOperationStatus `json:"status,omitempty"`
}

// BackendAddressPool - Pool of backend IP addresses.
type BackendAddressPool struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer backend address pool.
	Properties *BackendAddressPoolPropertiesFormat `json:"properties,omitempty"`
}

// BackendAddressPoolPropertiesFormat - Properties of the backend address pool.
type BackendAddressPoolPropertiesFormat struct {
	// Get provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// READ-ONLY; Gets collection of references to IP addresses defined in network interfaces.
	BackendIPConfigurations []*InterfaceIPConfiguration `json:"backendIPConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; Gets load balancing rules that use this backend address pool.
	LoadBalancingRules []*SubResource `json:"loadBalancingRules,omitempty" azure:"ro"`

	// READ-ONLY; Gets outbound rules that use this backend address pool.
	OutboundRule *SubResource `json:"outboundRule,omitempty" azure:"ro"`

	// READ-ONLY; Gets outbound rules that use this backend address pool.
	OutboundRules []*SubResource `json:"outboundRules,omitempty" azure:"ro"`
}

// BgpPeerStatus - BGP peer status details
type BgpPeerStatus struct {
	// READ-ONLY; The autonomous system number of the remote BGP peer
	Asn *int32 `json:"asn,omitempty" azure:"ro"`

	// READ-ONLY; For how long the peering has been up
	ConnectedDuration *string `json:"connectedDuration,omitempty" azure:"ro"`

	// READ-ONLY; The virtual network gateway's local address
	LocalAddress *string `json:"localAddress,omitempty" azure:"ro"`

	// READ-ONLY; The number of BGP messages received
	MessagesReceived *int64 `json:"messagesReceived,omitempty" azure:"ro"`

	// READ-ONLY; The number of BGP messages sent
	MessagesSent *int64 `json:"messagesSent,omitempty" azure:"ro"`

	// READ-ONLY; The remote BGP peer
	Neighbor *string `json:"neighbor,omitempty" azure:"ro"`

	// READ-ONLY; The number of routes learned from this peer
	RoutesReceived *int64 `json:"routesReceived,omitempty" azure:"ro"`

	// READ-ONLY; The BGP peer state
	State *BgpPeerState `json:"state,omitempty" azure:"ro"`
}

// BgpPeerStatusListResult - Response for list BGP peer status API service call
type BgpPeerStatusListResult struct {
	// List of BGP peers
	Value []*BgpPeerStatus `json:"value,omitempty"`
}

// BgpSettings - BGP settings details
type BgpSettings struct {
	// The BGP speaker's ASN.
	Asn *int64 `json:"asn,omitempty"`

	// The BGP peering address and BGP identifier of this BGP speaker.
	BgpPeeringAddress *string `json:"bgpPeeringAddress,omitempty"`

	// The weight added to routes learned from this BGP speaker.
	PeerWeight *int32 `json:"peerWeight,omitempty"`
}

type Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// ConnectionResetSharedKey - The virtual network connection reset shared key
type ConnectionResetSharedKey struct {
	// REQUIRED; The virtual network connection reset shared key length, should between 1 and 128.
	KeyLength *int32 `json:"keyLength,omitempty"`
}

// ConnectionSharedKey - Response for GetConnectionSharedKey API service call
type ConnectionSharedKey struct {
	// REQUIRED; The virtual network connection shared key value.
	Value *string `json:"value,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// DdosSettings - Contains the DDoS protection settings of the public IP.
type DdosSettings struct {
	// The DDoS custom policy associated with the public IP.
	DdosCustomPolicy *SubResource `json:"ddosCustomPolicy,omitempty"`

	// The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.
	ProtectionCoverage *DdosSettingsProtectionCoverage `json:"protectionCoverage,omitempty"`
}

// DefaultSecurityRulesClientGetOptions contains the optional parameters for the DefaultSecurityRulesClient.Get method.
type DefaultSecurityRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// DefaultSecurityRulesClientListOptions contains the optional parameters for the DefaultSecurityRulesClient.NewListPager
// method.
type DefaultSecurityRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// Delegation - Details the service to which the subnet is delegated.
type Delegation struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a subnet. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the subnet.
	Properties *ServiceDelegationPropertiesFormat `json:"properties,omitempty"`
}

// DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for
// a subnet overrides VNET DHCP options.
type DhcpOptions struct {
	// The list of DNS servers IP addresses.
	DNSServers []*string `json:"dnsServers,omitempty"`
}

// Dimension of the metric.
type Dimension struct {
	// The display name of the dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// The internal name of the dimension.
	InternalName *string `json:"internalName,omitempty"`

	// The name of the dimension.
	Name *string `json:"name,omitempty"`
}

// EffectiveNetworkSecurityGroup - Effective network security group.
type EffectiveNetworkSecurityGroup struct {
	// Associated resources.
	Association *EffectiveNetworkSecurityGroupAssociation `json:"association,omitempty"`

	// A collection of effective security rules.
	EffectiveSecurityRules []*EffectiveNetworkSecurityRule `json:"effectiveSecurityRules,omitempty"`

	// The ID of network security group that is applied.
	NetworkSecurityGroup *SubResource `json:"networkSecurityGroup,omitempty"`

	// Mapping of tags to list of IP Addresses included within the tag.
	TagMap *string `json:"tagMap,omitempty"`
}

// EffectiveNetworkSecurityGroupAssociation - The effective network security group association.
type EffectiveNetworkSecurityGroupAssociation struct {
	// The ID of the network interface if assigned.
	NetworkInterface *SubResource `json:"networkInterface,omitempty"`

	// The ID of the subnet if assigned.
	Subnet *SubResource `json:"subnet,omitempty"`
}

// EffectiveNetworkSecurityGroupListResult - Response for list effective network security groups API service call.
type EffectiveNetworkSecurityGroupListResult struct {
	// A list of effective network security groups.
	Value []*EffectiveNetworkSecurityGroup `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// EffectiveNetworkSecurityRule - Effective network security rules.
type EffectiveNetworkSecurityRule struct {
	// Whether network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
	Access *SecurityRuleAccess `json:"access,omitempty"`

	// The destination address prefix.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`

	// The destination address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer,
	// Internet), System Tags, and the asterisk (*).
	DestinationAddressPrefixes []*string `json:"destinationAddressPrefixes,omitempty"`

	// The destination port or range.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`

	// The destination port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator
	// (e.g. 100-400), or an asterisk (*)
	DestinationPortRanges []*string `json:"destinationPortRanges,omitempty"`

	// The direction of the rule. Possible values are: 'Inbound and Outbound'.
	Direction *SecurityRuleDirection `json:"direction,omitempty"`

	// Expanded destination address prefix.
	ExpandedDestinationAddressPrefix []*string `json:"expandedDestinationAddressPrefix,omitempty"`

	// The expanded source address prefix.
	ExpandedSourceAddressPrefix []*string `json:"expandedSourceAddressPrefix,omitempty"`

	// The name of the security rule specified by the user (if created by the user).
	Name *string `json:"name,omitempty"`

	// The priority of the rule.
	Priority *int32 `json:"priority,omitempty"`

	// The network protocol this rule applies to. Possible values are: 'Tcp', 'Udp', and 'All'.
	Protocol *EffectiveSecurityRuleProtocol `json:"protocol,omitempty"`

	// The source address prefix.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`

	// The source address prefixes. Expected values include CIDR IP ranges, Default Tags (VirtualNetwork, AzureLoadBalancer, Internet),
	// System Tags, and the asterisk (*).
	SourceAddressPrefixes []*string `json:"sourceAddressPrefixes,omitempty"`

	// The source port or range.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`

	// The source port ranges. Expected values include a single integer between 0 and 65535, a range using '-' as separator (e.g.
	// 100-400), or an asterisk (*)
	SourcePortRanges []*string `json:"sourcePortRanges,omitempty"`
}

// EffectiveRoute - Effective Route
type EffectiveRoute struct {
	// The address prefixes of the effective routes in CIDR notation.
	AddressPrefix []*string `json:"addressPrefix,omitempty"`

	// The name of the user defined route. This is optional.
	Name *string `json:"name,omitempty"`

	// The IP address of the next hop of the effective route.
	NextHopIPAddress []*string `json:"nextHopIpAddress,omitempty"`

	// The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet',
	// 'VirtualAppliance', and 'None'.
	NextHopType *RouteNextHopType `json:"nextHopType,omitempty"`

	// Who created the route. Possible values are: 'Unknown', 'User', 'VirtualNetworkGateway', and 'Default'.
	Source *EffectiveRouteSource `json:"source,omitempty"`

	// The value of effective route. Possible values are: 'Active' and 'Invalid'.
	State *EffectiveRouteState `json:"state,omitempty"`
}

// EffectiveRouteListResult - Response for list effective route API service call.
type EffectiveRouteListResult struct {
	// A list of effective routes.
	Value []*EffectiveRoute `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// EndpointService - Identifies the service being brought into the virtual network.
type EndpointService struct {
	// A unique identifier of the service being referenced by the interface endpoint.
	ID *string `json:"id,omitempty"`
}

type Error struct {
	Code       *string         `json:"code,omitempty"`
	Details    []*ErrorDetails `json:"details,omitempty"`
	InnerError *string         `json:"innerError,omitempty"`
	Message    *string         `json:"message,omitempty"`
	Target     *string         `json:"target,omitempty"`
}

type ErrorDetails struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
	Target  *string `json:"target,omitempty"`
}

// FrontendIPConfiguration - Frontend IP address of the load balancer.
type FrontendIPConfiguration struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the load balancer probe.
	Properties *FrontendIPConfigurationPropertiesFormat `json:"properties,omitempty"`

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`
}

// FrontendIPConfigurationPropertiesFormat - Properties of Frontend IP Configuration of the load balancer.
type FrontendIPConfigurationPropertiesFormat struct {
	// The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The Private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The reference of the Public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`

	// The reference of the Public IP Prefix resource.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`

	// The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; Read only. Inbound pools URIs that use this frontend IP.
	InboundNatPools []*SubResource `json:"inboundNatPools,omitempty" azure:"ro"`

	// READ-ONLY; Read only. Inbound rules URIs that use this frontend IP.
	InboundNatRules []*SubResource `json:"inboundNatRules,omitempty" azure:"ro"`

	// READ-ONLY; Gets load balancing rules URIs that use this frontend IP.
	LoadBalancingRules []*SubResource `json:"loadBalancingRules,omitempty" azure:"ro"`

	// READ-ONLY; Read only. Outbound rules URIs that use this frontend IP.
	OutboundRules []*SubResource `json:"outboundRules,omitempty" azure:"ro"`
}

// GatewayRoute - Gateway routing details
type GatewayRoute struct {
	// READ-ONLY; The route's AS path sequence
	AsPath *string `json:"asPath,omitempty" azure:"ro"`

	// READ-ONLY; The gateway's local address
	LocalAddress *string `json:"localAddress,omitempty" azure:"ro"`

	// READ-ONLY; The route's network prefix
	Network *string `json:"network,omitempty" azure:"ro"`

	// READ-ONLY; The route's next hop
	NextHop *string `json:"nextHop,omitempty" azure:"ro"`

	// READ-ONLY; The source this route was learned from
	Origin *string `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; The peer this route was learned from
	SourcePeer *string `json:"sourcePeer,omitempty" azure:"ro"`

	// READ-ONLY; The route's weight
	Weight *int32 `json:"weight,omitempty" azure:"ro"`
}

// GatewayRouteListResult - List of virtual network gateway routes
type GatewayRouteListResult struct {
	// List of gateway routes
	Value []*GatewayRoute `json:"value,omitempty"`
}

// IPAddressAvailabilityResult - Response for CheckIPAddressAvailability API service call
type IPAddressAvailabilityResult struct {
	// Private IP address availability.
	Available *bool `json:"available,omitempty"`

	// Contains other available private IP addresses if the asked for address is taken.
	AvailableIPAddresses []*string `json:"availableIPAddresses,omitempty"`
}

// IPConfiguration - IP configuration
type IPConfiguration struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the IP configuration
	Properties *IPConfigurationPropertiesFormat `json:"properties,omitempty"`
}

// IPConfigurationProfile - IP configuration profile child resource.
type IPConfigurationProfile struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the IP configuration profile.
	Properties *IPConfigurationProfilePropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IPConfigurationProfilePropertiesFormat - IP configuration profile properties.
type IPConfigurationProfilePropertiesFormat struct {
	// The reference of the subnet resource to create a container network interface ip configuration.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// IPConfigurationPropertiesFormat - Properties of IP configuration.
type IPConfigurationPropertiesFormat struct {
	// The private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// The private IP allocation method. Possible values are 'Static' and 'Dynamic'.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The reference of the public IP resource.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`

	// The reference of the subnet resource.
	Subnet *Subnet `json:"subnet,omitempty"`
}

// IPSecPolicy - An IPSec Policy configuration for a virtual network gateway connection
type IPSecPolicy struct {
	// REQUIRED; The DH Groups used in IKE Phase 1 for initial SA.
	DhGroup *DhGroup `json:"dhGroup,omitempty"`

	// REQUIRED; The IPSec encryption algorithm (IKE phase 1).
	IPSecEncryption *IPSecEncryption `json:"ipsecEncryption,omitempty"`

	// REQUIRED; The IPSec integrity algorithm (IKE phase 1).
	IPSecIntegrity *IPSecIntegrity `json:"ipsecIntegrity,omitempty"`

	// REQUIRED; The IKE encryption algorithm (IKE phase 2).
	IkeEncryption *IkeEncryption `json:"ikeEncryption,omitempty"`

	// REQUIRED; The IKE integrity algorithm (IKE phase 2).
	IkeIntegrity *IkeIntegrity `json:"ikeIntegrity,omitempty"`

	// REQUIRED; The Pfs Groups used in IKE Phase 2 for new child SA.
	PfsGroup *PfsGroup `json:"pfsGroup,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for a site to site VPN
	// tunnel.
	SaDataSizeKilobytes *int32 `json:"saDataSizeKilobytes,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for a site to site
	// VPN tunnel.
	SaLifeTimeSeconds *int32 `json:"saLifeTimeSeconds,omitempty"`
}

// IPTag - Contains the IpTag associated with the object
type IPTag struct {
	// Gets or sets the ipTag type: Example FirstPartyUsage.
	IPTagType *string `json:"ipTagType,omitempty"`

	// Gets or sets value of the IpTag associated with the public IP. Example SQL, Storage etc
	Tag *string `json:"tag,omitempty"`
}

// InboundNatPool - Inbound NAT pool of the load balancer.
type InboundNatPool struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer inbound nat pool.
	Properties *InboundNatPoolPropertiesFormat `json:"properties,omitempty"`
}

// InboundNatPoolPropertiesFormat - Properties of Inbound NAT pool.
type InboundNatPoolPropertiesFormat struct {
	// REQUIRED; The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`

	// REQUIRED; The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated
	// with a load balancer. Acceptable values range between 1 and 65535.
	FrontendPortRangeEnd *int32 `json:"frontendPortRangeEnd,omitempty"`

	// REQUIRED; The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated
	// with a load balancer. Acceptable values range between 1 and 65534.
	FrontendPortRangeStart *int32 `json:"frontendPortRangeStart,omitempty"`

	// REQUIRED; The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
	Protocol *TransportProtocol `json:"protocol,omitempty"`

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// InboundNatRule - Inbound NAT rule of the load balancer.
type InboundNatRule struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer inbound nat rule.
	Properties *InboundNatRulePropertiesFormat `json:"properties,omitempty"`
}

// InboundNatRuleListResult - Response for ListInboundNatRule API service call.
type InboundNatRuleListResult struct {
	// A list of inbound nat rules in a load balancer.
	Value []*InboundNatRule `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InboundNatRulePropertiesFormat - Properties of the inbound NAT rule.
type InboundNatRulePropertiesFormat struct {
	// The port used for the internal endpoint. Acceptable values range from 1 to 65535.
	BackendPort *int32 `json:"backendPort,omitempty"`

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values
	// range from 1 to 65534.
	FrontendPort *int32 `json:"frontendPort,omitempty"`

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
	Protocol *TransportProtocol `json:"protocol,omitempty"`

	// Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// READ-ONLY; A reference to a private IP address defined on a network interface of a VM. Traffic sent to the frontend port
	// of each of the frontend IP configurations is forwarded to the backend IP.
	BackendIPConfiguration *InterfaceIPConfiguration `json:"backendIPConfiguration,omitempty" azure:"ro"`
}

// InboundNatRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the InboundNatRulesClient.BeginCreateOrUpdate
// method.
type InboundNatRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InboundNatRulesClientBeginDeleteOptions contains the optional parameters for the InboundNatRulesClient.BeginDelete method.
type InboundNatRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InboundNatRulesClientGetOptions contains the optional parameters for the InboundNatRulesClient.Get method.
type InboundNatRulesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InboundNatRulesClientListOptions contains the optional parameters for the InboundNatRulesClient.NewListPager method.
type InboundNatRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// Interface - A network interface in a resource group.
type Interface struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the network interface.
	Properties *InterfacePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InterfaceDNSSettings - DNS settings of a network interface.
type InterfaceDNSSettings struct {
	// If the VM that uses this NIC is part of an Availability Set, then this list will have the union of all DNS servers from
	// all NICs that are part of the Availability Set. This property is what is
	// configured on each of those VMs.
	AppliedDNSServers []*string `json:"appliedDnsServers,omitempty"`

	// List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure provided DNS resolution. 'AzureProvidedDNS'
	// value cannot be combined with other IPs, it must be the only value in dnsServers
	// collection.
	DNSServers []*string `json:"dnsServers,omitempty"`

	// Relative DNS name for this NIC used for internal communications between VMs in the same virtual network.
	InternalDNSNameLabel *string `json:"internalDnsNameLabel,omitempty"`

	// Even if internalDnsNameLabel is not specified, a DNS entry is created for the primary NIC of the VM. This DNS name can
	// be constructed by concatenating the VM name with the value of
	// internalDomainNameSuffix.
	InternalDomainNameSuffix *string `json:"internalDomainNameSuffix,omitempty"`

	// Fully qualified DNS name supporting internal communications between VMs in the same virtual network.
	InternalFqdn *string `json:"internalFqdn,omitempty"`
}

// InterfaceEndpoint - Interface endpoint resource.
type InterfaceEndpoint struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the interface endpoint.
	Properties *InterfaceEndpointProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InterfaceEndpointProperties - Properties of the interface endpoint.
type InterfaceEndpointProperties struct {
	// A reference to the service being brought into the virtual network.
	EndpointService *EndpointService `json:"endpointService,omitempty"`

	// A first-party service's FQDN that is mapped to the private IP allocated via this interface endpoint.
	Fqdn *string `json:"fqdn,omitempty"`

	// The ID of the subnet from which the private IP will be allocated.
	Subnet *Subnet `json:"subnet,omitempty"`

	// READ-ONLY; Gets an array of references to the network interfaces created for this interface endpoint.
	NetworkInterfaces []*Interface `json:"networkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; A read-only property that identifies who created this interface endpoint.
	Owner *string `json:"owner,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the interface endpoint. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// InterfaceIPConfiguration - IPConfiguration in a network interface.
type InterfaceIPConfiguration struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Network interface IP configuration properties.
	Properties *InterfaceIPConfigurationPropertiesFormat `json:"properties,omitempty"`
}

// InterfaceIPConfigurationListResult - Response for list ip configurations API service call.
type InterfaceIPConfigurationListResult struct {
	// A list of ip configurations.
	Value []*InterfaceIPConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceIPConfigurationPropertiesFormat - Properties of IP configuration.
type InterfaceIPConfigurationPropertiesFormat struct {
	// The reference of ApplicationGatewayBackendAddressPool resource.
	ApplicationGatewayBackendAddressPools []*ApplicationGatewayBackendAddressPool `json:"applicationGatewayBackendAddressPools,omitempty"`

	// Application security groups in which the IP configuration is included.
	ApplicationSecurityGroups []*ApplicationSecurityGroup `json:"applicationSecurityGroups,omitempty"`

	// The reference of LoadBalancerBackendAddressPool resource.
	LoadBalancerBackendAddressPools []*BackendAddressPool `json:"loadBalancerBackendAddressPools,omitempty"`

	// A list of references of LoadBalancerInboundNatRules.
	LoadBalancerInboundNatRules []*InboundNatRule `json:"loadBalancerInboundNatRules,omitempty"`

	// Gets whether this is a primary customer address on the network interface.
	Primary *bool `json:"primary,omitempty"`

	// Private IP address of the IP configuration.
	PrivateIPAddress *string `json:"privateIPAddress,omitempty"`

	// Available from Api-Version 2016-03-30 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default
	// is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
	PrivateIPAddressVersion *IPVersion `json:"privateIPAddressVersion,omitempty"`

	// Defines how a private IP address is assigned. Possible values are: 'Static' and 'Dynamic'.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The provisioning state of the network interface IP configuration. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Public IP address bound to the IP configuration.
	PublicIPAddress *PublicIPAddress `json:"publicIPAddress,omitempty"`

	// Subnet bound to the IP configuration.
	Subnet *Subnet `json:"subnet,omitempty"`

	// The reference to Virtual Network Taps.
	VirtualNetworkTaps []*VirtualNetworkTap `json:"virtualNetworkTaps,omitempty"`
}

// InterfaceIPConfigurationsClientGetOptions contains the optional parameters for the InterfaceIPConfigurationsClient.Get
// method.
type InterfaceIPConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InterfaceIPConfigurationsClientListOptions contains the optional parameters for the InterfaceIPConfigurationsClient.NewListPager
// method.
type InterfaceIPConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// InterfaceListResult - Response for the ListNetworkInterface API service call.
type InterfaceListResult struct {
	// A list of network interfaces in a resource group.
	Value []*Interface `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceLoadBalancerListResult - Response for list ip configurations API service call.
type InterfaceLoadBalancerListResult struct {
	// A list of load balancers.
	Value []*LoadBalancer `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceLoadBalancersClientListOptions contains the optional parameters for the InterfaceLoadBalancersClient.NewListPager
// method.
type InterfaceLoadBalancersClientListOptions struct {
	// placeholder for future optional parameters
}

// InterfacePropertiesFormat - NetworkInterface properties.
type InterfacePropertiesFormat struct {
	// The DNS settings in network interface.
	DNSSettings *InterfaceDNSSettings `json:"dnsSettings,omitempty"`

	// If the network interface is accelerated networking enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`

	// Indicates whether IP forwarding is enabled on this network interface.
	EnableIPForwarding *bool `json:"enableIPForwarding,omitempty"`

	// A list of IPConfigurations of the network interface.
	IPConfigurations []*InterfaceIPConfiguration `json:"ipConfigurations,omitempty"`

	// The MAC address of the network interface.
	MacAddress *string `json:"macAddress,omitempty"`

	// The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`

	// Gets whether this is a primary network interface on a virtual machine.
	Primary *bool `json:"primary,omitempty"`

	// The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The resource GUID property of the network interface resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// A list of TapConfigurations of the network interface.
	TapConfigurations []*InterfaceTapConfiguration `json:"tapConfigurations,omitempty"`

	// READ-ONLY; A list of references to linked BareMetal resources
	HostedWorkloads []*string `json:"hostedWorkloads,omitempty" azure:"ro"`

	// READ-ONLY; A reference to the interface endpoint to which the network interface is linked.
	InterfaceEndpoint *InterfaceEndpoint `json:"interfaceEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; The reference of a virtual machine.
	VirtualMachine *SubResource `json:"virtualMachine,omitempty" azure:"ro"`
}

// InterfaceTapConfiguration - Tap configuration in a Network Interface
type InterfaceTapConfiguration struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the Virtual Network Tap configuration
	Properties *InterfaceTapConfigurationPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; Sub Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InterfaceTapConfigurationListResult - Response for list tap configurations API service call.
type InterfaceTapConfigurationListResult struct {
	// A list of tap configurations.
	Value []*InterfaceTapConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// InterfaceTapConfigurationPropertiesFormat - Properties of Virtual Network Tap configuration.
type InterfaceTapConfigurationPropertiesFormat struct {
	// The reference of the Virtual Network Tap resource.
	VirtualNetworkTap *VirtualNetworkTap `json:"virtualNetworkTap,omitempty"`

	// READ-ONLY; The provisioning state of the network interface tap configuration. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// InterfaceTapConfigurationsClientBeginCreateOrUpdateOptions contains the optional parameters for the InterfaceTapConfigurationsClient.BeginCreateOrUpdate
// method.
type InterfaceTapConfigurationsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfaceTapConfigurationsClientBeginDeleteOptions contains the optional parameters for the InterfaceTapConfigurationsClient.BeginDelete
// method.
type InterfaceTapConfigurationsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfaceTapConfigurationsClientGetOptions contains the optional parameters for the InterfaceTapConfigurationsClient.Get
// method.
type InterfaceTapConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InterfaceTapConfigurationsClientListOptions contains the optional parameters for the InterfaceTapConfigurationsClient.NewListPager
// method.
type InterfaceTapConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientBeginCreateOrUpdateOptions contains the optional parameters for the InterfacesClient.BeginCreateOrUpdate
// method.
type InterfacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientBeginDeleteOptions contains the optional parameters for the InterfacesClient.BeginDelete method.
type InterfacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientBeginGetEffectiveRouteTableOptions contains the optional parameters for the InterfacesClient.BeginGetEffectiveRouteTable
// method.
type InterfacesClientBeginGetEffectiveRouteTableOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientBeginListEffectiveNetworkSecurityGroupsOptions contains the optional parameters for the InterfacesClient.BeginListEffectiveNetworkSecurityGroups
// method.
type InterfacesClientBeginListEffectiveNetworkSecurityGroupsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientBeginUpdateTagsOptions contains the optional parameters for the InterfacesClient.BeginUpdateTags method.
type InterfacesClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// InterfacesClientGetOptions contains the optional parameters for the InterfacesClient.Get method.
type InterfacesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// InterfacesClientListAllOptions contains the optional parameters for the InterfacesClient.NewListAllPager method.
type InterfacesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// InterfacesClientListOptions contains the optional parameters for the InterfacesClient.NewListPager method.
type InterfacesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancer resource
type LoadBalancer struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of load balancer.
	Properties *LoadBalancerPropertiesFormat `json:"properties,omitempty"`

	// The load balancer SKU.
	SKU *LoadBalancerSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LoadBalancerBackendAddressPoolListResult - Response for ListBackendAddressPool API service call.
type LoadBalancerBackendAddressPoolListResult struct {
	// A list of backend address pools in a load balancer.
	Value []*BackendAddressPool `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerBackendAddressPoolsClientGetOptions contains the optional parameters for the LoadBalancerBackendAddressPoolsClient.Get
// method.
type LoadBalancerBackendAddressPoolsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerBackendAddressPoolsClientListOptions contains the optional parameters for the LoadBalancerBackendAddressPoolsClient.NewListPager
// method.
type LoadBalancerBackendAddressPoolsClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerFrontendIPConfigurationListResult - Response for ListFrontendIPConfiguration API service call.
type LoadBalancerFrontendIPConfigurationListResult struct {
	// A list of frontend IP configurations in a load balancer.
	Value []*FrontendIPConfiguration `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerFrontendIPConfigurationsClientGetOptions contains the optional parameters for the LoadBalancerFrontendIPConfigurationsClient.Get
// method.
type LoadBalancerFrontendIPConfigurationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerFrontendIPConfigurationsClientListOptions contains the optional parameters for the LoadBalancerFrontendIPConfigurationsClient.NewListPager
// method.
type LoadBalancerFrontendIPConfigurationsClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerListResult - Response for ListLoadBalancers API service call.
type LoadBalancerListResult struct {
	// A list of load balancers in a resource group.
	Value []*LoadBalancer `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerLoadBalancingRuleListResult - Response for ListLoadBalancingRule API service call.
type LoadBalancerLoadBalancingRuleListResult struct {
	// A list of load balancing rules in a load balancer.
	Value []*LoadBalancingRule `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerLoadBalancingRulesClientGetOptions contains the optional parameters for the LoadBalancerLoadBalancingRulesClient.Get
// method.
type LoadBalancerLoadBalancingRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerLoadBalancingRulesClientListOptions contains the optional parameters for the LoadBalancerLoadBalancingRulesClient.NewListPager
// method.
type LoadBalancerLoadBalancingRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerNetworkInterfacesClientListOptions contains the optional parameters for the LoadBalancerNetworkInterfacesClient.NewListPager
// method.
type LoadBalancerNetworkInterfacesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerOutboundRuleListResult - Response for ListOutboundRule API service call.
type LoadBalancerOutboundRuleListResult struct {
	// A list of outbound rules in a load balancer.
	Value []*OutboundRule `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerOutboundRulesClientGetOptions contains the optional parameters for the LoadBalancerOutboundRulesClient.Get
// method.
type LoadBalancerOutboundRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerOutboundRulesClientListOptions contains the optional parameters for the LoadBalancerOutboundRulesClient.NewListPager
// method.
type LoadBalancerOutboundRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerProbeListResult - Response for ListProbe API service call.
type LoadBalancerProbeListResult struct {
	// A list of probes in a load balancer.
	Value []*Probe `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LoadBalancerProbesClientGetOptions contains the optional parameters for the LoadBalancerProbesClient.Get method.
type LoadBalancerProbesClientGetOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerProbesClientListOptions contains the optional parameters for the LoadBalancerProbesClient.NewListPager method.
type LoadBalancerProbesClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancerPropertiesFormat - Properties of the load balancer.
type LoadBalancerPropertiesFormat struct {
	// Collection of backend address pools used by a load balancer
	BackendAddressPools []*BackendAddressPool `json:"backendAddressPools,omitempty"`

	// Object representing the frontend IPs to be used for the load balancer
	FrontendIPConfigurations []*FrontendIPConfiguration `json:"frontendIPConfigurations,omitempty"`

	// Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound
	// NAT rules are created automatically for each NIC associated with the Load
	// Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive
	// with defining inbound Nat rules. Inbound NAT pools are referenced from virtual
	// machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They
	// have to reference individual inbound NAT rules.
	InboundNatPools []*InboundNatPool `json:"inboundNatPools,omitempty"`

	// Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive
	// with defining an inbound NAT pool. Inbound NAT pools are referenced from
	// virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool.
	// They have to reference individual inbound NAT rules.
	InboundNatRules []*InboundNatRule `json:"inboundNatRules,omitempty"`

	// Object collection representing the load balancing rules Gets the provisioning
	LoadBalancingRules []*LoadBalancingRule `json:"loadBalancingRules,omitempty"`

	// The outbound rules.
	OutboundRules []*OutboundRule `json:"outboundRules,omitempty"`

	// Collection of probe objects used in the load balancer
	Probes []*Probe `json:"probes,omitempty"`

	// Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The resource GUID property of the load balancer resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
}

// LoadBalancerSKU - SKU of a load balancer
type LoadBalancerSKU struct {
	// Name of a load balancer SKU.
	Name *LoadBalancerSKUName `json:"name,omitempty"`
}

// LoadBalancersClientBeginCreateOrUpdateOptions contains the optional parameters for the LoadBalancersClient.BeginCreateOrUpdate
// method.
type LoadBalancersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancersClientBeginDeleteOptions contains the optional parameters for the LoadBalancersClient.BeginDelete method.
type LoadBalancersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancersClientBeginUpdateTagsOptions contains the optional parameters for the LoadBalancersClient.BeginUpdateTags
// method.
type LoadBalancersClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LoadBalancersClientGetOptions contains the optional parameters for the LoadBalancersClient.Get method.
type LoadBalancersClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// LoadBalancersClientListAllOptions contains the optional parameters for the LoadBalancersClient.NewListAllPager method.
type LoadBalancersClientListAllOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancersClientListOptions contains the optional parameters for the LoadBalancersClient.NewListPager method.
type LoadBalancersClientListOptions struct {
	// placeholder for future optional parameters
}

// LoadBalancingRule - A load balancing rule for a load balancer.
type LoadBalancingRule struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer load balancing rule.
	Properties *LoadBalancingRulePropertiesFormat `json:"properties,omitempty"`
}

// LoadBalancingRulePropertiesFormat - Properties of the load balancer.
type LoadBalancingRulePropertiesFormat struct {
	// REQUIRED; The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable
	// values are between 0 and 65534. Note that value 0 enables "Any Port"
	FrontendPort *int32 `json:"frontendPort,omitempty"`

	// REQUIRED; The transport protocol for the endpoint. Possible values are 'Udp' or 'Tcp' or 'All'.
	Protocol *TransportProtocol `json:"protocol,omitempty"`

	// A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables
	// "Any Port"
	BackendPort *int32 `json:"backendPort,omitempty"`

	// Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing
	// rule.
	DisableOutboundSnat *bool `json:"disableOutboundSnat,omitempty"`

	// Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability
	// Group. This setting is required when using the SQL AlwaysOn Availability Groups
	// in SQL server. This setting can't be changed after you create the endpoint.
	EnableFloatingIP *bool `json:"enableFloatingIP,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// A reference to frontend IP addresses.
	FrontendIPConfiguration *SubResource `json:"frontendIPConfiguration,omitempty"`

	// The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes.
	// This element is only used when the protocol is set to TCP.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// The load distribution policy for this rule. Possible values are 'Default', 'SourceIP', and 'SourceIPProtocol'.
	LoadDistribution *LoadDistribution `json:"loadDistribution,omitempty"`

	// The reference of the load balancer probe used by the load balancing rule.
	Probe *SubResource `json:"probe,omitempty"`

	// Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// LocalNetworkGateway - A common class for general resource information
type LocalNetworkGateway struct {
	// REQUIRED; Properties of the local network gateway.
	Properties *LocalNetworkGatewayPropertiesFormat `json:"properties,omitempty"`

	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LocalNetworkGatewayListResult - Response for ListLocalNetworkGateways API service call.
type LocalNetworkGatewayListResult struct {
	// A list of local network gateways that exists in a resource group.
	Value []*LocalNetworkGateway `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// LocalNetworkGatewayPropertiesFormat - LocalNetworkGateway properties
type LocalNetworkGatewayPropertiesFormat struct {
	// Local network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`

	// IP address of local network gateway.
	GatewayIPAddress *string `json:"gatewayIpAddress,omitempty"`

	// Local network site address space.
	LocalNetworkAddressSpace *AddressSpace `json:"localNetworkAddressSpace,omitempty"`

	// The resource GUID property of the LocalNetworkGateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// READ-ONLY; The provisioning state of the LocalNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and
	// 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// LocalNetworkGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the LocalNetworkGatewaysClient.BeginCreateOrUpdate
// method.
type LocalNetworkGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LocalNetworkGatewaysClientBeginDeleteOptions contains the optional parameters for the LocalNetworkGatewaysClient.BeginDelete
// method.
type LocalNetworkGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LocalNetworkGatewaysClientBeginUpdateTagsOptions contains the optional parameters for the LocalNetworkGatewaysClient.BeginUpdateTags
// method.
type LocalNetworkGatewaysClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// LocalNetworkGatewaysClientGetOptions contains the optional parameters for the LocalNetworkGatewaysClient.Get method.
type LocalNetworkGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// LocalNetworkGatewaysClientListOptions contains the optional parameters for the LocalNetworkGatewaysClient.NewListPager
// method.
type LocalNetworkGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// LogSpecification - Description of logging specification.
type LogSpecification struct {
	// Duration of the blob.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// The display name of the specification.
	DisplayName *string `json:"displayName,omitempty"`

	// The name of the specification.
	Name *string `json:"name,omitempty"`
}

// ManagedServiceIdentity - Identity for the resource.
type ManagedServiceIdentity struct {
	// The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created
	// identity and a set of user assigned identities. The type 'None' will remove any
	// identities from the virtual machine.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*Components1Jq1T4ISchemasManagedserviceidentityPropertiesUserassignedidentitiesAdditionalproperties `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MetricSpecification - Description of metrics specification.
type MetricSpecification struct {
	// The aggregation type.
	AggregationType *string `json:"aggregationType,omitempty"`

	// List of availability.
	Availabilities []*Availability `json:"availabilities,omitempty"`

	// List of dimensions.
	Dimensions []*Dimension `json:"dimensions,omitempty"`

	// The description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// The display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`

	// Whether regional MDM account enabled.
	EnableRegionalMdmAccount *bool `json:"enableRegionalMdmAccount,omitempty"`

	// Whether gaps would be filled with zeros.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// Whether the metric is internal.
	IsInternal *bool `json:"isInternal,omitempty"`

	// Pattern for the filter of the metric.
	MetricFilterPattern *string `json:"metricFilterPattern,omitempty"`

	// The name of the metric.
	Name *string `json:"name,omitempty"`

	// The resource Id dimension name override.
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// The source MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`

	// The source MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// Units the metric to be displayed in.
	Unit *string `json:"unit,omitempty"`
}

// Operation - Network REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Origin of the operation.
	Origin *string `json:"origin,omitempty"`

	// Operation properties format.
	Properties *OperationPropertiesFormat `json:"properties,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Type of the operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Network.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Network operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Network operations supported by the Network resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationPropertiesFormat - Description of operation properties format.
type OperationPropertiesFormat struct {
	// Specification of the service.
	ServiceSpecification *OperationPropertiesFormatServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationPropertiesFormatServiceSpecification - Specification of the service.
type OperationPropertiesFormatServiceSpecification struct {
	// Operation log specification.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Operation service specification.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OutboundRule - Outbound rule of the load balancer.
type OutboundRule struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer outbound rule.
	Properties *OutboundRulePropertiesFormat `json:"properties,omitempty"`
}

// OutboundRulePropertiesFormat - Outbound rule of the load balancer.
type OutboundRulePropertiesFormat struct {
	// REQUIRED; A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.
	BackendAddressPool *SubResource `json:"backendAddressPool,omitempty"`

	// REQUIRED; The Frontend IP addresses of the load balancer.
	FrontendIPConfigurations []*SubResource `json:"frontendIPConfigurations,omitempty"`

	// REQUIRED; Protocol - TCP, UDP or All
	Protocol *OutboundRulePropertiesFormatProtocol `json:"protocol,omitempty"`

	// The number of outbound ports to be used for NAT.
	AllocatedOutboundPorts *int32 `json:"allocatedOutboundPorts,omitempty"`

	// Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used
	// when the protocol is set to TCP.
	EnableTCPReset *bool `json:"enableTcpReset,omitempty"`

	// The timeout for the TCP idle connection
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// Gets the provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// Probe - A load balancer probe.
type Probe struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Gets name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of load balancer probe.
	Properties *ProbePropertiesFormat `json:"properties,omitempty"`
}

// ProbePropertiesFormat - Load balancer probe resource.
type ProbePropertiesFormat struct {
	// REQUIRED; The port for communicating the probe. Possible values range from 1 to 65535, inclusive.
	Port *int32 `json:"port,omitempty"`

	// REQUIRED; The protocol of the end point. Possible values are: 'Http', 'Tcp', or 'Https'. If 'Tcp' is specified, a received
	// ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a
	// 200 OK response from the specifies URI is required for the probe to be successful.
	Protocol *ProbeProtocol `json:"protocol,omitempty"`

	// The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly
	// less than half the allocated timeout period (in seconds) which allows two full
	// probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`

	// The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint.
	// This values allows endpoints to be taken out of rotation faster or slower than
	// the typical times used in Azure.
	NumberOfProbes *int32 `json:"numberOfProbes,omitempty"`

	// Gets the provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is
	// not allowed. There is no default value.
	RequestPath *string `json:"requestPath,omitempty"`

	// READ-ONLY; The load balancer rules that use this probe.
	LoadBalancingRules []*SubResource `json:"loadBalancingRules,omitempty" azure:"ro"`
}

// PublicIPAddress - Public IP address resource.
type PublicIPAddress struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Public IP address properties.
	Properties *PublicIPAddressPropertiesFormat `json:"properties,omitempty"`

	// The public IP address SKU.
	SKU *PublicIPAddressSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// A list of availability zones denoting the IP allocated for the resource needs to come from.
	Zones []*string `json:"zones,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PublicIPAddressDNSSettings - Contains FQDN of the DNS record associated with the public IP address
type PublicIPAddressDNSSettings struct {
	// Gets or sets the Domain name label.The concatenation of the domain name label and the regionalized DNS zone make up the
	// fully qualified domain name associated with the public IP address. If a domain
	// name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`

	// Gets the FQDN, Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation
	// of the domainNameLabel and the regionalized DNS zone.
	Fqdn *string `json:"fqdn,omitempty"`

	// Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If
	// the reverseFqdn is specified, then a PTR DNS record is created pointing from the
	// IP address in the in-addr.arpa domain to the reverse FQDN.
	ReverseFqdn *string `json:"reverseFqdn,omitempty"`
}

// PublicIPAddressListResult - Response for ListPublicIpAddresses API service call.
type PublicIPAddressListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of public IP addresses that exists in a resource group.
	Value []*PublicIPAddress `json:"value,omitempty"`
}

// PublicIPAddressPropertiesFormat - Public IP address properties.
type PublicIPAddressPropertiesFormat struct {
	// The FQDN of the DNS record associated with the public IP address.
	DNSSettings *PublicIPAddressDNSSettings `json:"dnsSettings,omitempty"`

	// The DDoS protection custom policy associated with the public IP address.
	DdosSettings *DdosSettings `json:"ddosSettings,omitempty"`

	// The IP address associated with the public IP address resource.
	IPAddress *string `json:"ipAddress,omitempty"`

	// The list of tags associated with the public IP address.
	IPTags []*IPTag `json:"ipTags,omitempty"`

	// The idle timeout of the public IP address.
	IdleTimeoutInMinutes *int32 `json:"idleTimeoutInMinutes,omitempty"`

	// The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The public IP address version. Possible values are: 'IPv4' and 'IPv6'.
	PublicIPAddressVersion *IPVersion `json:"publicIPAddressVersion,omitempty"`

	// The public IP allocation method. Possible values are: 'Static' and 'Dynamic'.
	PublicIPAllocationMethod *IPAllocationMethod `json:"publicIPAllocationMethod,omitempty"`

	// The Public IP Prefix this Public IP Address should be allocated from.
	PublicIPPrefix *SubResource `json:"publicIPPrefix,omitempty"`

	// The resource GUID property of the public IP resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// READ-ONLY; The IP configuration associated with the public IP address.
	IPConfiguration *IPConfiguration `json:"ipConfiguration,omitempty" azure:"ro"`
}

// PublicIPAddressSKU - SKU of a public IP address
type PublicIPAddressSKU struct {
	// Name of a public IP address SKU.
	Name *PublicIPAddressSKUName `json:"name,omitempty"`
}

// PublicIPAddressesClientBeginCreateOrUpdateOptions contains the optional parameters for the PublicIPAddressesClient.BeginCreateOrUpdate
// method.
type PublicIPAddressesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PublicIPAddressesClientBeginDeleteOptions contains the optional parameters for the PublicIPAddressesClient.BeginDelete
// method.
type PublicIPAddressesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PublicIPAddressesClientBeginUpdateTagsOptions contains the optional parameters for the PublicIPAddressesClient.BeginUpdateTags
// method.
type PublicIPAddressesClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PublicIPAddressesClientGetOptions contains the optional parameters for the PublicIPAddressesClient.Get method.
type PublicIPAddressesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// PublicIPAddressesClientListAllOptions contains the optional parameters for the PublicIPAddressesClient.NewListAllPager
// method.
type PublicIPAddressesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// PublicIPAddressesClientListOptions contains the optional parameters for the PublicIPAddressesClient.NewListPager method.
type PublicIPAddressesClientListOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common resource representation.
type Resource struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceNavigationLink resource.
type ResourceNavigationLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Resource navigation link properties format.
	Properties *ResourceNavigationLinkFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// ResourceNavigationLinkFormat - Properties of ResourceNavigationLink.
type ResourceNavigationLinkFormat struct {
	// Link to the external resource
	Link *string `json:"link,omitempty"`

	// Resource type of the linked resource.
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`

	// READ-ONLY; Provisioning state of the ResourceNavigationLink resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// Route resource
type Route struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the route.
	Properties *RoutePropertiesFormat `json:"properties,omitempty"`
}

// RouteListResult - Response for the ListRoute API service call
type RouteListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a list of routes in a resource group.
	Value []*Route `json:"value,omitempty"`
}

// RoutePropertiesFormat - Route resource
type RoutePropertiesFormat struct {
	// REQUIRED; The type of Azure hop the packet should be sent to. Possible values are: 'VirtualNetworkGateway', 'VnetLocal',
	// 'Internet', 'VirtualAppliance', and 'None'
	NextHopType *RouteNextHopType `json:"nextHopType,omitempty"`

	// The destination CIDR to which the route applies.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
	NextHopIPAddress *string `json:"nextHopIpAddress,omitempty"`

	// The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// RouteTable - Route table resource.
type RouteTable struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the route table.
	Properties *RouteTablePropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RouteTableListResult - Response for the ListRouteTable API service call.
type RouteTableListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a list of route tables in a resource group.
	Value []*RouteTable `json:"value,omitempty"`
}

// RouteTablePropertiesFormat - Route Table resource
type RouteTablePropertiesFormat struct {
	// Gets or sets whether to disable the routes learned by BGP on that route table. True means disable.
	DisableBgpRoutePropagation *bool `json:"disableBgpRoutePropagation,omitempty"`

	// The provisioning state of the resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Collection of routes contained within a route table.
	Routes []*Route `json:"routes,omitempty"`

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet `json:"subnets,omitempty" azure:"ro"`
}

// RouteTablesClientBeginCreateOrUpdateOptions contains the optional parameters for the RouteTablesClient.BeginCreateOrUpdate
// method.
type RouteTablesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteTablesClientBeginDeleteOptions contains the optional parameters for the RouteTablesClient.BeginDelete method.
type RouteTablesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteTablesClientBeginUpdateTagsOptions contains the optional parameters for the RouteTablesClient.BeginUpdateTags method.
type RouteTablesClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RouteTablesClientGetOptions contains the optional parameters for the RouteTablesClient.Get method.
type RouteTablesClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// RouteTablesClientListAllOptions contains the optional parameters for the RouteTablesClient.NewListAllPager method.
type RouteTablesClientListAllOptions struct {
	// placeholder for future optional parameters
}

// RouteTablesClientListOptions contains the optional parameters for the RouteTablesClient.NewListPager method.
type RouteTablesClientListOptions struct {
	// placeholder for future optional parameters
}

// RoutesClientBeginCreateOrUpdateOptions contains the optional parameters for the RoutesClient.BeginCreateOrUpdate method.
type RoutesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutesClientBeginDeleteOptions contains the optional parameters for the RoutesClient.BeginDelete method.
type RoutesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// RoutesClientGetOptions contains the optional parameters for the RoutesClient.Get method.
type RoutesClientGetOptions struct {
	// placeholder for future optional parameters
}

// RoutesClientListOptions contains the optional parameters for the RoutesClient.NewListPager method.
type RoutesClientListOptions struct {
	// placeholder for future optional parameters
}

// SecurityGroup - NetworkSecurityGroup resource.
type SecurityGroup struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the network security group
	Properties *SecurityGroupPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecurityGroupListResult - Response for ListNetworkSecurityGroups API service call.
type SecurityGroupListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// A list of NetworkSecurityGroup resources.
	Value []*SecurityGroup `json:"value,omitempty"`
}

// SecurityGroupPropertiesFormat - Network Security Group resource.
type SecurityGroupPropertiesFormat struct {
	// The default security rules of network security group.
	DefaultSecurityRules []*SecurityRule `json:"defaultSecurityRules,omitempty"`

	// The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The resource GUID property of the network security group resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// A collection of security rules of the network security group.
	SecurityRules []*SecurityRule `json:"securityRules,omitempty"`

	// READ-ONLY; A collection of references to network interfaces.
	NetworkInterfaces []*Interface `json:"networkInterfaces,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet `json:"subnets,omitempty" azure:"ro"`
}

// SecurityGroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the SecurityGroupsClient.BeginCreateOrUpdate
// method.
type SecurityGroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityGroupsClientBeginDeleteOptions contains the optional parameters for the SecurityGroupsClient.BeginDelete method.
type SecurityGroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityGroupsClientBeginUpdateTagsOptions contains the optional parameters for the SecurityGroupsClient.BeginUpdateTags
// method.
type SecurityGroupsClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityGroupsClientGetOptions contains the optional parameters for the SecurityGroupsClient.Get method.
type SecurityGroupsClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// SecurityGroupsClientListAllOptions contains the optional parameters for the SecurityGroupsClient.NewListAllPager method.
type SecurityGroupsClientListAllOptions struct {
	// placeholder for future optional parameters
}

// SecurityGroupsClientListOptions contains the optional parameters for the SecurityGroupsClient.NewListPager method.
type SecurityGroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// SecurityRule - Network security rule.
type SecurityRule struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the security rule
	Properties *SecurityRulePropertiesFormat `json:"properties,omitempty"`
}

// SecurityRuleListResult - Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a
// network security group.
type SecurityRuleListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The security rules in a network security group.
	Value []*SecurityRule `json:"value,omitempty"`
}

// SecurityRulePropertiesFormat - Security rule resource.
type SecurityRulePropertiesFormat struct {
	// REQUIRED; The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.
	Access *SecurityRuleAccess `json:"access,omitempty"`

	// REQUIRED; The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.
	// Possible values are: 'Inbound' and 'Outbound'.
	Direction *SecurityRuleDirection `json:"direction,omitempty"`

	// REQUIRED; Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.
	Protocol *SecurityRuleProtocol `json:"protocol,omitempty"`

	// A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`

	// The destination address prefix. CIDR or destination IP range. Asterisks '*' can also be used to match all source IPs. Default
	// tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also
	// be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`

	// The destination address prefixes. CIDR or destination IP ranges.
	DestinationAddressPrefixes []*string `json:"destinationAddressPrefixes,omitempty"`

	// The application security group specified as destination.
	DestinationApplicationSecurityGroups []*ApplicationSecurityGroup `json:"destinationApplicationSecurityGroups,omitempty"`

	// The destination port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`

	// The destination port ranges.
	DestinationPortRanges []*string `json:"destinationPortRanges,omitempty"`

	// The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the
	// collection. The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`

	// The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The CIDR or source IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
	// 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress
	// rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`

	// The CIDR or source IP ranges.
	SourceAddressPrefixes []*string `json:"sourceAddressPrefixes,omitempty"`

	// The application security group specified as source.
	SourceApplicationSecurityGroups []*ApplicationSecurityGroup `json:"sourceApplicationSecurityGroups,omitempty"`

	// The source port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`

	// The source port ranges.
	SourcePortRanges []*string `json:"sourcePortRanges,omitempty"`
}

// SecurityRulesClientBeginCreateOrUpdateOptions contains the optional parameters for the SecurityRulesClient.BeginCreateOrUpdate
// method.
type SecurityRulesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityRulesClientBeginDeleteOptions contains the optional parameters for the SecurityRulesClient.BeginDelete method.
type SecurityRulesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SecurityRulesClientGetOptions contains the optional parameters for the SecurityRulesClient.Get method.
type SecurityRulesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecurityRulesClientListOptions contains the optional parameters for the SecurityRulesClient.NewListPager method.
type SecurityRulesClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceAssociationLink resource.
type ServiceAssociationLink struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Resource navigation link properties format.
	Properties *ServiceAssociationLinkPropertiesFormat `json:"properties,omitempty"`

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty" azure:"ro"`
}

// ServiceAssociationLinkPropertiesFormat - Properties of ServiceAssociationLink.
type ServiceAssociationLinkPropertiesFormat struct {
	// Link to the external resource.
	Link *string `json:"link,omitempty"`

	// Resource type of the linked resource.
	LinkedResourceType *string `json:"linkedResourceType,omitempty"`

	// READ-ONLY; Provisioning state of the ServiceAssociationLink resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceDelegationPropertiesFormat - Properties of a service delegation.
type ServiceDelegationPropertiesFormat struct {
	// Describes the actions permitted to the service upon delegation
	Actions []*string `json:"actions,omitempty"`

	// The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers)
	ServiceName *string `json:"serviceName,omitempty"`

	// READ-ONLY; The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceEndpointPolicy - Service End point policy resource.
type ServiceEndpointPolicy struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the service end point policy
	Properties *ServiceEndpointPolicyPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServiceEndpointPolicyDefinition - Service Endpoint policy definitions.
type ServiceEndpointPolicyDefinition struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the service endpoint policy definition
	Properties *ServiceEndpointPolicyDefinitionPropertiesFormat `json:"properties,omitempty"`
}

// ServiceEndpointPolicyDefinitionPropertiesFormat - Service Endpoint policy definition resource.
type ServiceEndpointPolicyDefinitionPropertiesFormat struct {
	// A description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`

	// service endpoint name.
	Service *string `json:"service,omitempty"`

	// A list of service resources.
	ServiceResources []*string `json:"serviceResources,omitempty"`

	// READ-ONLY; The provisioning state of the service end point policy definition. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ServiceEndpointPolicyPropertiesFormat - Service Endpoint Policy resource.
type ServiceEndpointPolicyPropertiesFormat struct {
	// A collection of service endpoint policy definitions of the service endpoint policy.
	ServiceEndpointPolicyDefinitions []*ServiceEndpointPolicyDefinition `json:"serviceEndpointPolicyDefinitions,omitempty"`

	// READ-ONLY; The provisioning state of the service endpoint policy. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resource GUID property of the service endpoint policy resource.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`

	// READ-ONLY; A collection of references to subnets.
	Subnets []*Subnet `json:"subnets,omitempty" azure:"ro"`
}

// ServiceEndpointPropertiesFormat - The service endpoint properties.
type ServiceEndpointPropertiesFormat struct {
	// A list of locations.
	Locations []*string `json:"locations,omitempty"`

	// The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The type of the endpoint service.
	Service *string `json:"service,omitempty"`
}

// SubResource - Reference to another subresource.
type SubResource struct {
	// Resource ID.
	ID *string `json:"id,omitempty"`
}

// Subnet in a virtual network resource.
type Subnet struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the subnet.
	Properties *SubnetPropertiesFormat `json:"properties,omitempty"`
}

// SubnetListResult - Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual network
type SubnetListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The subnets in a virtual network.
	Value []*Subnet `json:"value,omitempty"`
}

// SubnetPropertiesFormat - Properties of the subnet.
type SubnetPropertiesFormat struct {
	// The address prefix for the subnet.
	AddressPrefix *string `json:"addressPrefix,omitempty"`

	// List of address prefixes for the subnet.
	AddressPrefixes []*string `json:"addressPrefixes,omitempty"`

	// Gets an array of references to the delegations on the subnet.
	Delegations []*Delegation `json:"delegations,omitempty"`

	// The reference of the NetworkSecurityGroup resource.
	NetworkSecurityGroup *SecurityGroup `json:"networkSecurityGroup,omitempty"`

	// The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// Gets an array of references to the external resources using subnet.
	ResourceNavigationLinks []*ResourceNavigationLink `json:"resourceNavigationLinks,omitempty"`

	// The reference of the RouteTable resource.
	RouteTable *RouteTable `json:"routeTable,omitempty"`

	// Gets an array of references to services injecting into this subnet.
	ServiceAssociationLinks []*ServiceAssociationLink `json:"serviceAssociationLinks,omitempty"`

	// An array of service endpoint policies.
	ServiceEndpointPolicies []*ServiceEndpointPolicy `json:"serviceEndpointPolicies,omitempty"`

	// An array of service endpoints.
	ServiceEndpoints []*ServiceEndpointPropertiesFormat `json:"serviceEndpoints,omitempty"`

	// READ-ONLY; Array of IP configuration profiles which reference this subnet.
	IPConfigurationProfiles []*IPConfigurationProfile `json:"ipConfigurationProfiles,omitempty" azure:"ro"`

	// READ-ONLY; Gets an array of references to the network interface IP configurations using subnet.
	IPConfigurations []*IPConfiguration `json:"ipConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; An array of references to interface endpoints
	InterfaceEndpoints []*InterfaceEndpoint `json:"interfaceEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; A read-only string identifying the intention of use for this subnet based on delegations and other user-defined
	// properties.
	Purpose *string `json:"purpose,omitempty" azure:"ro"`
}

// SubnetsClientBeginCreateOrUpdateOptions contains the optional parameters for the SubnetsClient.BeginCreateOrUpdate method.
type SubnetsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubnetsClientBeginDeleteOptions contains the optional parameters for the SubnetsClient.BeginDelete method.
type SubnetsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SubnetsClientGetOptions contains the optional parameters for the SubnetsClient.Get method.
type SubnetsClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// SubnetsClientListOptions contains the optional parameters for the SubnetsClient.NewListPager method.
type SubnetsClientListOptions struct {
	// placeholder for future optional parameters
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// TunnelConnectionHealth - VirtualNetworkGatewayConnection properties
type TunnelConnectionHealth struct {
	// READ-ONLY; Virtual network Gateway connection status
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The Egress Bytes Transferred in this connection
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The Ingress Bytes Transferred in this connection
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The time at which connection was established in Utc format.
	LastConnectionEstablishedUTCTime *string `json:"lastConnectionEstablishedUtcTime,omitempty" azure:"ro"`

	// READ-ONLY; Tunnel name.
	Tunnel *string `json:"tunnel,omitempty" azure:"ro"`
}

// VPNClientConfiguration - VpnClientConfiguration for P2S client.
type VPNClientConfiguration struct {
	// The radius server address property of the VirtualNetworkGateway resource for vpn client connection.
	RadiusServerAddress *string `json:"radiusServerAddress,omitempty"`

	// The radius secret property of the VirtualNetworkGateway resource for vpn client connection.
	RadiusServerSecret *string `json:"radiusServerSecret,omitempty"`

	// The reference of the address space resource which represents Address space for P2S VpnClient.
	VPNClientAddressPool *AddressSpace `json:"vpnClientAddressPool,omitempty"`

	// VpnClientIpsecPolicies for virtual network gateway P2S client.
	VPNClientIPSecPolicies []*IPSecPolicy `json:"vpnClientIpsecPolicies,omitempty"`

	// VpnClientProtocols for Virtual network gateway.
	VPNClientProtocols []*VPNClientProtocol `json:"vpnClientProtocols,omitempty"`

	// VpnClientRevokedCertificate for Virtual network gateway.
	VPNClientRevokedCertificates []*VPNClientRevokedCertificate `json:"vpnClientRevokedCertificates,omitempty"`

	// VpnClientRootCertificate for virtual network gateway.
	VPNClientRootCertificates []*VPNClientRootCertificate `json:"vpnClientRootCertificates,omitempty"`
}

// VPNClientIPsecParameters - An IPSec parameters for a virtual network gateway P2S connection.
type VPNClientIPsecParameters struct {
	// REQUIRED; The DH Groups used in IKE Phase 1 for initial SA.
	DhGroup *DhGroup `json:"dhGroup,omitempty"`

	// REQUIRED; The IPSec encryption algorithm (IKE phase 1).
	IPSecEncryption *IPSecEncryption `json:"ipsecEncryption,omitempty"`

	// REQUIRED; The IPSec integrity algorithm (IKE phase 1).
	IPSecIntegrity *IPSecIntegrity `json:"ipsecIntegrity,omitempty"`

	// REQUIRED; The IKE encryption algorithm (IKE phase 2).
	IkeEncryption *IkeEncryption `json:"ikeEncryption,omitempty"`

	// REQUIRED; The IKE integrity algorithm (IKE phase 2).
	IkeIntegrity *IkeIntegrity `json:"ikeIntegrity,omitempty"`

	// REQUIRED; The Pfs Groups used in IKE Phase 2 for new child SA.
	PfsGroup *PfsGroup `json:"pfsGroup,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client..
	SaDataSizeKilobytes *int32 `json:"saDataSizeKilobytes,omitempty"`

	// REQUIRED; The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client.
	SaLifeTimeSeconds *int32 `json:"saLifeTimeSeconds,omitempty"`
}

// VPNClientParameters - Vpn Client Parameters for package generation
type VPNClientParameters struct {
	// VPN client Authentication Method. Possible values are: 'EAPTLS' and 'EAPMSCHAPv2'.
	AuthenticationMethod *AuthenticationMethod `json:"authenticationMethod,omitempty"`

	// A list of client root certificates public certificate data encoded as Base-64 strings. Optional parameter for external
	// radius based authentication with EAPTLS.
	ClientRootCertificates []*string `json:"clientRootCertificates,omitempty"`

	// VPN client Processor Architecture. Possible values are: 'AMD64' and 'X86'.
	ProcessorArchitecture *ProcessorArchitecture `json:"processorArchitecture,omitempty"`

	// The public certificate data for the radius server authentication certificate as a Base-64 encoded string. Required only
	// if external radius authentication has been configured with EAPTLS
	// authentication.
	RadiusServerAuthCertificate *string `json:"radiusServerAuthCertificate,omitempty"`
}

// VPNClientRevokedCertificate - VPN client revoked certificate of virtual network gateway.
type VPNClientRevokedCertificate struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the vpn client revoked certificate.
	Properties *VPNClientRevokedCertificatePropertiesFormat `json:"properties,omitempty"`
}

// VPNClientRevokedCertificatePropertiesFormat - Properties of the revoked VPN client certificate of virtual network gateway.
type VPNClientRevokedCertificatePropertiesFormat struct {
	// The revoked VPN client certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`

	// READ-ONLY; The provisioning state of the VPN client revoked certificate resource. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNClientRootCertificate - VPN client root certificate of virtual network gateway
type VPNClientRootCertificate struct {
	// REQUIRED; Properties of the vpn client root certificate.
	Properties *VPNClientRootCertificatePropertiesFormat `json:"properties,omitempty"`

	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`
}

// VPNClientRootCertificatePropertiesFormat - Properties of SSL certificates of application gateway
type VPNClientRootCertificatePropertiesFormat struct {
	// REQUIRED; The certificate public data.
	PublicCertData *string `json:"publicCertData,omitempty"`

	// READ-ONLY; The provisioning state of the VPN client root certificate resource. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VPNDeviceScriptParameters - Vpn device configuration script generation parameters
type VPNDeviceScriptParameters struct {
	// The device family for the vpn device.
	DeviceFamily *string `json:"deviceFamily,omitempty"`

	// The firmware version for the vpn device.
	FirmwareVersion *string `json:"firmwareVersion,omitempty"`

	// The vendor for the vpn device.
	Vendor *string `json:"vendor,omitempty"`
}

// VirtualNetwork - Virtual Network resource.
type VirtualNetwork struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the virtual network.
	Properties *VirtualNetworkPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkConnectionGatewayReference - A reference to VirtualNetworkGateway or LocalNetworkGateway resource.
type VirtualNetworkConnectionGatewayReference struct {
	// REQUIRED; The ID of VirtualNetworkGateway or LocalNetworkGateway resource.
	ID *string `json:"id,omitempty"`
}

// VirtualNetworkGateway - A common class for general resource information
type VirtualNetworkGateway struct {
	// REQUIRED; Properties of the virtual network gateway.
	Properties *VirtualNetworkGatewayPropertiesFormat `json:"properties,omitempty"`

	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnection - A common class for general resource information
type VirtualNetworkGatewayConnection struct {
	// REQUIRED; Properties of the virtual network gateway connection.
	Properties *VirtualNetworkGatewayConnectionPropertiesFormat `json:"properties,omitempty"`

	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionListEntity - A common class for general resource information
type VirtualNetworkGatewayConnectionListEntity struct {
	// REQUIRED; Properties of the virtual network gateway connection.
	Properties *VirtualNetworkGatewayConnectionListEntityPropertiesFormat `json:"properties,omitempty"`

	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionListEntityPropertiesFormat - VirtualNetworkGatewayConnection properties
type VirtualNetworkGatewayConnectionListEntityPropertiesFormat struct {
	// REQUIRED; Gateway connection type. Possible values are: 'Ipsec','Vnet2Vnet','ExpressRoute', and 'VPNClient.
	ConnectionType *VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`

	// REQUIRED; The reference to virtual network gateway resource.
	VirtualNetworkGateway1 *VirtualNetworkConnectionGatewayReference `json:"virtualNetworkGateway1,omitempty"`

	// The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// Connection protocol used for this connection
	ConnectionProtocol *VirtualNetworkGatewayConnectionProtocol `json:"connectionProtocol,omitempty"`

	// EnableBgp flag
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// Bypass ExpressRoute Gateway for data forwarding
	ExpressRouteGatewayBypass *bool `json:"expressRouteGatewayBypass,omitempty"`

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy `json:"ipsecPolicies,omitempty"`

	// The reference to local network gateway resource.
	LocalNetworkGateway2 *VirtualNetworkConnectionGatewayReference `json:"localNetworkGateway2,omitempty"`

	// The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`

	// The resource GUID property of the VirtualNetworkGatewayConnection resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// The routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`

	// The IPSec shared key.
	SharedKey *string `json:"sharedKey,omitempty"`

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`

	// The reference to virtual network gateway resource.
	VirtualNetworkGateway2 *VirtualNetworkConnectionGatewayReference `json:"virtualNetworkGateway2,omitempty"`

	// READ-ONLY; Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The egress bytes transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the VirtualNetworkGatewayConnection resource. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Collection of all tunnels' connection health status.
	TunnelConnectionStatus []*TunnelConnectionHealth `json:"tunnelConnectionStatus,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionListResult - Response for the ListVirtualNetworkGatewayConnections API service call
type VirtualNetworkGatewayConnectionListResult struct {
	// Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value []*VirtualNetworkGatewayConnection `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionPropertiesFormat - VirtualNetworkGatewayConnection properties
type VirtualNetworkGatewayConnectionPropertiesFormat struct {
	// REQUIRED; Gateway connection type. Possible values are: 'Ipsec','Vnet2Vnet','ExpressRoute', and 'VPNClient.
	ConnectionType *VirtualNetworkGatewayConnectionType `json:"connectionType,omitempty"`

	// REQUIRED; The reference to virtual network gateway resource.
	VirtualNetworkGateway1 *VirtualNetworkGateway `json:"virtualNetworkGateway1,omitempty"`

	// The authorizationKey.
	AuthorizationKey *string `json:"authorizationKey,omitempty"`

	// Connection protocol used for this connection
	ConnectionProtocol *VirtualNetworkGatewayConnectionProtocol `json:"connectionProtocol,omitempty"`

	// EnableBgp flag
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// Bypass ExpressRoute Gateway for data forwarding
	ExpressRouteGatewayBypass *bool `json:"expressRouteGatewayBypass,omitempty"`

	// The IPSec Policies to be considered by this connection.
	IPSecPolicies []*IPSecPolicy `json:"ipsecPolicies,omitempty"`

	// The reference to local network gateway resource.
	LocalNetworkGateway2 *LocalNetworkGateway `json:"localNetworkGateway2,omitempty"`

	// The reference to peerings resource.
	Peer *SubResource `json:"peer,omitempty"`

	// The resource GUID property of the VirtualNetworkGatewayConnection resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// The routing weight.
	RoutingWeight *int32 `json:"routingWeight,omitempty"`

	// The IPSec shared key.
	SharedKey *string `json:"sharedKey,omitempty"`

	// Enable policy-based traffic selectors.
	UsePolicyBasedTrafficSelectors *bool `json:"usePolicyBasedTrafficSelectors,omitempty"`

	// The reference to virtual network gateway resource.
	VirtualNetworkGateway2 *VirtualNetworkGateway `json:"virtualNetworkGateway2,omitempty"`

	// READ-ONLY; Virtual network Gateway connection status. Possible values are 'Unknown', 'Connecting', 'Connected' and 'NotConnected'.
	ConnectionStatus *VirtualNetworkGatewayConnectionStatus `json:"connectionStatus,omitempty" azure:"ro"`

	// READ-ONLY; The egress bytes transferred in this connection.
	EgressBytesTransferred *int64 `json:"egressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The ingress bytes transferred in this connection.
	IngressBytesTransferred *int64 `json:"ingressBytesTransferred,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the VirtualNetworkGatewayConnection resource. Possible values are: 'Updating', 'Deleting',
	// and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Collection of all tunnels' connection health status.
	TunnelConnectionStatus []*TunnelConnectionHealth `json:"tunnelConnectionStatus,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayConnectionsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginCreateOrUpdate
// method.
type VirtualNetworkGatewayConnectionsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginDelete
// method.
type VirtualNetworkGatewayConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginResetSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginResetSharedKey
// method.
type VirtualNetworkGatewayConnectionsClientBeginResetSharedKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginSetSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginSetSharedKey
// method.
type VirtualNetworkGatewayConnectionsClientBeginSetSharedKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientBeginUpdateTagsOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.BeginUpdateTags
// method.
type VirtualNetworkGatewayConnectionsClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewayConnectionsClientGetOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.Get
// method.
type VirtualNetworkGatewayConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayConnectionsClientGetSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.GetSharedKey
// method.
type VirtualNetworkGatewayConnectionsClientGetSharedKeyOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayConnectionsClientListOptions contains the optional parameters for the VirtualNetworkGatewayConnectionsClient.NewListPager
// method.
type VirtualNetworkGatewayConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewayIPConfiguration - IP configuration for virtual network gateway
type VirtualNetworkGatewayIPConfiguration struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the virtual network gateway ip configuration.
	Properties *VirtualNetworkGatewayIPConfigurationPropertiesFormat `json:"properties,omitempty"`
}

// VirtualNetworkGatewayIPConfigurationPropertiesFormat - Properties of VirtualNetworkGatewayIPConfiguration
type VirtualNetworkGatewayIPConfigurationPropertiesFormat struct {
	// The private IP allocation method. Possible values are: 'Static' and 'Dynamic'.
	PrivateIPAllocationMethod *IPAllocationMethod `json:"privateIPAllocationMethod,omitempty"`

	// The reference of the public IP resource.
	PublicIPAddress *SubResource `json:"publicIPAddress,omitempty"`

	// The reference of the subnet resource.
	Subnet *SubResource `json:"subnet,omitempty"`

	// READ-ONLY; The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayListConnectionsResult - Response for the VirtualNetworkGatewayListConnections API service call
type VirtualNetworkGatewayListConnectionsResult struct {
	// Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource group.
	Value []*VirtualNetworkGatewayConnectionListEntity `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayListResult - Response for the ListVirtualNetworkGateways API service call.
type VirtualNetworkGatewayListResult struct {
	// Gets a list of VirtualNetworkGateway resources that exists in a resource group.
	Value []*VirtualNetworkGateway `json:"value,omitempty"`

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// VirtualNetworkGatewayPropertiesFormat - VirtualNetworkGateway properties
type VirtualNetworkGatewayPropertiesFormat struct {
	// ActiveActive flag
	Active *bool `json:"activeActive,omitempty"`

	// Virtual network gateway's BGP speaker settings.
	BgpSettings *BgpSettings `json:"bgpSettings,omitempty"`

	// Whether BGP is enabled for this virtual network gateway or not.
	EnableBgp *bool `json:"enableBgp,omitempty"`

	// The reference of the LocalNetworkGateway resource which represents local network site having default routes. Assign Null
	// value in case of removing existing default site setting.
	GatewayDefaultSite *SubResource `json:"gatewayDefaultSite,omitempty"`

	// The type of this virtual network gateway. Possible values are: 'Vpn' and 'ExpressRoute'.
	GatewayType *VirtualNetworkGatewayType `json:"gatewayType,omitempty"`

	// IP configurations for virtual network gateway.
	IPConfigurations []*VirtualNetworkGatewayIPConfiguration `json:"ipConfigurations,omitempty"`

	// The resource GUID property of the VirtualNetworkGateway resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// The reference of the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
	SKU *VirtualNetworkGatewaySKU `json:"sku,omitempty"`

	// The reference of the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
	VPNClientConfiguration *VPNClientConfiguration `json:"vpnClientConfiguration,omitempty"`

	// The type of this virtual network gateway. Possible values are: 'PolicyBased' and 'RouteBased'.
	VPNType *VPNType `json:"vpnType,omitempty"`

	// READ-ONLY; The provisioning state of the VirtualNetworkGateway resource. Possible values are: 'Updating', 'Deleting', and
	// 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// VirtualNetworkGatewaySKU - VirtualNetworkGatewaySku details
type VirtualNetworkGatewaySKU struct {
	// The capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// Gateway SKU name.
	Name *VirtualNetworkGatewaySKUName `json:"name,omitempty"`

	// Gateway SKU tier.
	Tier *VirtualNetworkGatewaySKUTier `json:"tier,omitempty"`
}

// VirtualNetworkGatewaysClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginCreateOrUpdate
// method.
type VirtualNetworkGatewaysClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginDelete
// method.
type VirtualNetworkGatewaysClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGenerateVPNProfileOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGenerateVPNProfile
// method.
type VirtualNetworkGatewaysClientBeginGenerateVPNProfileOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGeneratevpnclientpackageOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGeneratevpnclientpackage
// method.
type VirtualNetworkGatewaysClientBeginGeneratevpnclientpackageOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetAdvertisedRoutesOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetAdvertisedRoutes
// method.
type VirtualNetworkGatewaysClientBeginGetAdvertisedRoutesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetBgpPeerStatus
// method.
type VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions struct {
	// The IP address of the peer to retrieve the status of.
	Peer *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetLearnedRoutesOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetLearnedRoutes
// method.
type VirtualNetworkGatewaysClientBeginGetLearnedRoutesOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetVPNProfilePackageURLOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetVPNProfilePackageURL
// method.
type VirtualNetworkGatewaysClientBeginGetVPNProfilePackageURLOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginGetVpnclientIPSecParametersOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginGetVpnclientIPSecParameters
// method.
type VirtualNetworkGatewaysClientBeginGetVpnclientIPSecParametersOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginResetOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginReset
// method.
type VirtualNetworkGatewaysClientBeginResetOptions struct {
	// Virtual network gateway vip address supplied to the begin reset of the active-active feature enabled gateway.
	GatewayVip *string
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginResetVPNClientSharedKeyOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginResetVPNClientSharedKey
// method.
type VirtualNetworkGatewaysClientBeginResetVPNClientSharedKeyOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginSetVpnclientIPSecParametersOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginSetVpnclientIPSecParameters
// method.
type VirtualNetworkGatewaysClientBeginSetVpnclientIPSecParametersOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientBeginUpdateTagsOptions contains the optional parameters for the VirtualNetworkGatewaysClient.BeginUpdateTags
// method.
type VirtualNetworkGatewaysClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkGatewaysClientGetOptions contains the optional parameters for the VirtualNetworkGatewaysClient.Get method.
type VirtualNetworkGatewaysClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientListConnectionsOptions contains the optional parameters for the VirtualNetworkGatewaysClient.NewListConnectionsPager
// method.
type VirtualNetworkGatewaysClientListConnectionsOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientListOptions contains the optional parameters for the VirtualNetworkGatewaysClient.NewListPager
// method.
type VirtualNetworkGatewaysClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientSupportedVPNDevicesOptions contains the optional parameters for the VirtualNetworkGatewaysClient.SupportedVPNDevices
// method.
type VirtualNetworkGatewaysClientSupportedVPNDevicesOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkGatewaysClientVPNDeviceConfigurationScriptOptions contains the optional parameters for the VirtualNetworkGatewaysClient.VPNDeviceConfigurationScript
// method.
type VirtualNetworkGatewaysClientVPNDeviceConfigurationScriptOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkListResult - Response for the ListVirtualNetworks API service call.
type VirtualNetworkListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// Gets a list of VirtualNetwork resources in a resource group.
	Value []*VirtualNetwork `json:"value,omitempty"`
}

// VirtualNetworkListUsageResult - Response for the virtual networks GetUsage API service call.
type VirtualNetworkListUsageResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// READ-ONLY; VirtualNetwork usage stats.
	Value []*VirtualNetworkUsage `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworkPeering - Peerings in a virtual network resource.
type VirtualNetworkPeering struct {
	// A unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// The name of the resource that is unique within a resource group. This name can be used to access the resource.
	Name *string `json:"name,omitempty"`

	// Properties of the virtual network peering.
	Properties *VirtualNetworkPeeringPropertiesFormat `json:"properties,omitempty"`
}

// VirtualNetworkPeeringListResult - Response for ListSubnets API service call. Retrieves all subnets that belong to a virtual
// network.
type VirtualNetworkPeeringListResult struct {
	// The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty"`

	// The peerings in a virtual network.
	Value []*VirtualNetworkPeering `json:"value,omitempty"`
}

// VirtualNetworkPeeringPropertiesFormat - Properties of the virtual network peering.
type VirtualNetworkPeeringPropertiesFormat struct {
	// Whether the forwarded traffic from the VMs in the remote virtual network will be allowed/disallowed.
	AllowForwardedTraffic *bool `json:"allowForwardedTraffic,omitempty"`

	// If gateway links can be used in remote virtual networking to link to this virtual network.
	AllowGatewayTransit *bool `json:"allowGatewayTransit,omitempty"`

	// Whether the VMs in the linked virtual network space would be able to access all the VMs in local Virtual network space.
	AllowVirtualNetworkAccess *bool `json:"allowVirtualNetworkAccess,omitempty"`

	// The status of the virtual network peering. Possible values are 'Initiated', 'Connected', and 'Disconnected'.
	PeeringState *VirtualNetworkPeeringState `json:"peeringState,omitempty"`

	// The provisioning state of the resource.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The reference of the remote virtual network address space.
	RemoteAddressSpace *AddressSpace `json:"remoteAddressSpace,omitempty"`

	// The reference of the remote virtual network. The remote virtual network can be in the same or different region (preview).
	// See here to register for the preview and learn more
	// (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
	RemoteVirtualNetwork *SubResource `json:"remoteVirtualNetwork,omitempty"`

	// If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering
	// is also true, virtual network will use gateways of remote virtual network
	// for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a
	// gateway.
	UseRemoteGateways *bool `json:"useRemoteGateways,omitempty"`
}

// VirtualNetworkPeeringsClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworkPeeringsClient.BeginCreateOrUpdate
// method.
type VirtualNetworkPeeringsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkPeeringsClientBeginDeleteOptions contains the optional parameters for the VirtualNetworkPeeringsClient.BeginDelete
// method.
type VirtualNetworkPeeringsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworkPeeringsClientGetOptions contains the optional parameters for the VirtualNetworkPeeringsClient.Get method.
type VirtualNetworkPeeringsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkPeeringsClientListOptions contains the optional parameters for the VirtualNetworkPeeringsClient.NewListPager
// method.
type VirtualNetworkPeeringsClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkPropertiesFormat - Properties of the virtual network.
type VirtualNetworkPropertiesFormat struct {
	// The AddressSpace that contains an array of IP address ranges that can be used by subnets.
	AddressSpace *AddressSpace `json:"addressSpace,omitempty"`

	// The DDoS protection plan associated with the virtual network.
	DdosProtectionPlan *SubResource `json:"ddosProtectionPlan,omitempty"`

	// The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
	DhcpOptions *DhcpOptions `json:"dhcpOptions,omitempty"`

	// Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection
	// plan associated with the resource.
	EnableDdosProtection *bool `json:"enableDdosProtection,omitempty"`

	// Indicates if VM protection is enabled for all the subnets in the virtual network.
	EnableVMProtection *bool `json:"enableVmProtection,omitempty"`

	// The provisioning state of the PublicIP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty"`

	// The resourceGuid property of the Virtual Network resource.
	ResourceGUID *string `json:"resourceGuid,omitempty"`

	// A list of subnets in a Virtual Network.
	Subnets []*Subnet `json:"subnets,omitempty"`

	// A list of peerings in a Virtual Network.
	VirtualNetworkPeerings []*VirtualNetworkPeering `json:"virtualNetworkPeerings,omitempty"`
}

// VirtualNetworkTap - Virtual Network Tap resource
type VirtualNetworkTap struct {
	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string `json:"etag,omitempty"`

	// Resource ID.
	ID *string `json:"id,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Virtual Network Tap Properties.
	Properties *VirtualNetworkTapPropertiesFormat `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VirtualNetworkTapPropertiesFormat - Virtual Network Tap properties.
type VirtualNetworkTapPropertiesFormat struct {
	// The reference to the private IP address on the internal Load Balancer that will receive the tap
	DestinationLoadBalancerFrontEndIPConfiguration *FrontendIPConfiguration `json:"destinationLoadBalancerFrontEndIPConfiguration,omitempty"`

	// The reference to the private IP Address of the collector nic that will receive the tap
	DestinationNetworkInterfaceIPConfiguration *InterfaceIPConfiguration `json:"destinationNetworkInterfaceIPConfiguration,omitempty"`

	// The VXLAN destination port that will receive the tapped traffic.
	DestinationPort *int32 `json:"destinationPort,omitempty"`

	// READ-ONLY; Specifies the list of resource IDs for the network interface IP configuration that needs to be tapped.
	NetworkInterfaceTapConfigurations []*InterfaceTapConfiguration `json:"networkInterfaceTapConfigurations,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the virtual network tap. Possible values are: 'Updating', 'Deleting', and 'Failed'.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The resourceGuid property of the virtual network tap.
	ResourceGUID *string `json:"resourceGuid,omitempty" azure:"ro"`
}

// VirtualNetworkUsage - Usage details for subnet.
type VirtualNetworkUsage struct {
	// READ-ONLY; Indicates number of IPs used from the Subnet.
	CurrentValue *float64 `json:"currentValue,omitempty" azure:"ro"`

	// READ-ONLY; Subnet identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Indicates the size of the subnet.
	Limit *float64 `json:"limit,omitempty" azure:"ro"`

	// READ-ONLY; The name containing common and localized value for usage.
	Name *VirtualNetworkUsageName `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Usage units. Returns 'Count'
	Unit *string `json:"unit,omitempty" azure:"ro"`
}

// VirtualNetworkUsageName - Usage strings container.
type VirtualNetworkUsageName struct {
	// READ-ONLY; Localized subnet size and usage string.
	LocalizedValue *string `json:"localizedValue,omitempty" azure:"ro"`

	// READ-ONLY; Subnet size and usage string.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// VirtualNetworksClientBeginCreateOrUpdateOptions contains the optional parameters for the VirtualNetworksClient.BeginCreateOrUpdate
// method.
type VirtualNetworksClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginDeleteOptions contains the optional parameters for the VirtualNetworksClient.BeginDelete method.
type VirtualNetworksClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientBeginUpdateTagsOptions contains the optional parameters for the VirtualNetworksClient.BeginUpdateTags
// method.
type VirtualNetworksClientBeginUpdateTagsOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VirtualNetworksClientCheckIPAddressAvailabilityOptions contains the optional parameters for the VirtualNetworksClient.CheckIPAddressAvailability
// method.
type VirtualNetworksClientCheckIPAddressAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientGetOptions contains the optional parameters for the VirtualNetworksClient.Get method.
type VirtualNetworksClientGetOptions struct {
	// Expands referenced resources.
	Expand *string
}

// VirtualNetworksClientListAllOptions contains the optional parameters for the VirtualNetworksClient.NewListAllPager method.
type VirtualNetworksClientListAllOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListOptions contains the optional parameters for the VirtualNetworksClient.NewListPager method.
type VirtualNetworksClientListOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworksClientListUsageOptions contains the optional parameters for the VirtualNetworksClient.NewListUsagePager
// method.
type VirtualNetworksClientListUsageOptions struct {
	// placeholder for future optional parameters
}
