//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armavs_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/avs/armavs"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/ScriptExecutions_List.json
func ExampleScriptExecutionsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewScriptExecutionsClient().NewListPager("group1", "cloud1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ScriptExecutionsList = armavs.ScriptExecutionsList{
		// 	Value: []*armavs.ScriptExecution{
		// 		{
		// 			Name: to.Ptr("addSsoServer"),
		// 			Type: to.Ptr("Microsoft.AVS/privateClouds/scriptExecutions"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptExecutions/addSsoServer"),
		// 			Properties: &armavs.ScriptExecutionProperties{
		// 				FailureReason: to.Ptr("vCenter failed to connect to the external server"),
		// 				FinishedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-21T18:32:28.000Z"); return t}()),
		// 				Parameters: []armavs.ScriptExecutionParameterClassification{
		// 					&armavs.ScriptStringExecutionParameter{
		// 						Name: to.Ptr("DomainName"),
		// 						Type: to.Ptr(armavs.ScriptExecutionParameterTypeValue),
		// 						Value: to.Ptr("placeholderDomain.local"),
		// 					},
		// 					&armavs.ScriptStringExecutionParameter{
		// 						Name: to.Ptr("BaseUserDN"),
		// 						Type: to.Ptr(armavs.ScriptExecutionParameterTypeValue),
		// 						Value: to.Ptr("DC=placeholder, DC=placeholder"),
		// 				}},
		// 				ProvisioningState: to.Ptr(armavs.ScriptExecutionProvisioningStateSucceeded),
		// 				Retention: to.Ptr("P0Y0M60DT0H60M60S"),
		// 				ScriptCmdletID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS:1.0.0/scriptCmdlets/New-SsoExternalIdentitySource"),
		// 				StartedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-21T17:32:28.000Z"); return t}()),
		// 				SubmittedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-21T17:31:28.000Z"); return t}()),
		// 				Timeout: to.Ptr("P0Y0M0DT0H60M60S"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/ScriptExecutions_Get.json
func ExampleScriptExecutionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScriptExecutionsClient().Get(ctx, "group1", "cloud1", "addSsoServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScriptExecution = armavs.ScriptExecution{
	// 	Name: to.Ptr("addSsoServer"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/scriptExecutions"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptExecutions/addSsoServer"),
	// 	Properties: &armavs.ScriptExecutionProperties{
	// 		FailureReason: to.Ptr("vCenter failed to connect to the external server"),
	// 		FinishedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-21T18:32:28.000Z"); return t}()),
	// 		Parameters: []armavs.ScriptExecutionParameterClassification{
	// 			&armavs.ScriptStringExecutionParameter{
	// 				Name: to.Ptr("DomainName"),
	// 				Type: to.Ptr(armavs.ScriptExecutionParameterTypeValue),
	// 				Value: to.Ptr("placeholderDomain.local"),
	// 			},
	// 			&armavs.ScriptStringExecutionParameter{
	// 				Name: to.Ptr("BaseUserDN"),
	// 				Type: to.Ptr(armavs.ScriptExecutionParameterTypeValue),
	// 				Value: to.Ptr("DC=placeholder, DC=placeholder"),
	// 		}},
	// 		ProvisioningState: to.Ptr(armavs.ScriptExecutionProvisioningStateSucceeded),
	// 		Retention: to.Ptr("P0Y0M60DT0H60M60S"),
	// 		ScriptCmdletID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource"),
	// 		StartedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-21T17:32:28.000Z"); return t}()),
	// 		SubmittedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-03-21T17:31:28.000Z"); return t}()),
	// 		Timeout: to.Ptr("P0Y0M0DT0H60M60S"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/ScriptExecutions_CreateOrUpdate.json
func ExampleScriptExecutionsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewScriptExecutionsClient().BeginCreateOrUpdate(ctx, "group1", "cloud1", "addSsoServer", armavs.ScriptExecution{
		Properties: &armavs.ScriptExecutionProperties{
			HiddenParameters: []armavs.ScriptExecutionParameterClassification{
				&armavs.ScriptSecureStringExecutionParameter{
					Name:        to.Ptr("Password"),
					Type:        to.Ptr(armavs.ScriptExecutionParameterTypeSecureValue),
					SecureValue: to.Ptr("PlaceholderPassword"),
				}},
			Parameters: []armavs.ScriptExecutionParameterClassification{
				&armavs.ScriptStringExecutionParameter{
					Name:  to.Ptr("DomainName"),
					Type:  to.Ptr(armavs.ScriptExecutionParameterTypeValue),
					Value: to.Ptr("placeholderDomain.local"),
				},
				&armavs.ScriptStringExecutionParameter{
					Name:  to.Ptr("BaseUserDN"),
					Type:  to.Ptr(armavs.ScriptExecutionParameterTypeValue),
					Value: to.Ptr("DC=placeholder, DC=placeholder"),
				}},
			Retention:      to.Ptr("P0Y0M60DT0H60M60S"),
			ScriptCmdletID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource"),
			Timeout:        to.Ptr("P0Y0M0DT0H60M60S"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScriptExecution = armavs.ScriptExecution{
	// 	Name: to.Ptr("addSsoServer"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/scriptExecutions"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptExecutions/addSsoServer"),
	// 	Properties: &armavs.ScriptExecutionProperties{
	// 		FailureReason: to.Ptr("vCenter failed to connect to the external server"),
	// 		Output: []*string{
	// 			to.Ptr("IdentitySource: placeholder.dc"),
	// 			to.Ptr("BaseDN='dc=placeholder, dc=local")},
	// 			Parameters: []armavs.ScriptExecutionParameterClassification{
	// 				&armavs.ScriptStringExecutionParameter{
	// 					Name: to.Ptr("DomainName"),
	// 					Type: to.Ptr(armavs.ScriptExecutionParameterTypeValue),
	// 					Value: to.Ptr("placeholderDomain.local"),
	// 				},
	// 				&armavs.ScriptStringExecutionParameter{
	// 					Name: to.Ptr("BaseUserDN"),
	// 					Type: to.Ptr(armavs.ScriptExecutionParameterTypeValue),
	// 					Value: to.Ptr("DC=placeholder, DC=placeholder"),
	// 			}},
	// 			ProvisioningState: to.Ptr(armavs.ScriptExecutionProvisioningStateSucceeded),
	// 			Retention: to.Ptr("P0Y0M60DT0H60M60S"),
	// 			ScriptCmdletID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptPackages/AVS.PowerCommands@1.0.0/scriptCmdlets/New-SsoExternalIdentitySource"),
	// 			Timeout: to.Ptr("P0Y0M0DT0H60M60S"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/ScriptExecutions_Delete.json
func ExampleScriptExecutionsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewScriptExecutionsClient().BeginDelete(ctx, "group1", "cloud1", "addSsoServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/ScriptExecutions_GetExecutionLogs.json
func ExampleScriptExecutionsClient_GetExecutionLogs() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScriptExecutionsClient().GetExecutionLogs(ctx, "group1", "cloud1", "addSsoServer", &armavs.ScriptExecutionsClientGetExecutionLogsOptions{ScriptOutputStreamType: []*armavs.ScriptOutputStreamType{
		to.Ptr(armavs.ScriptOutputStreamTypeInformation),
		to.Ptr(armavs.ScriptOutputStreamType("Warnings")),
		to.Ptr(armavs.ScriptOutputStreamType("Errors")),
		to.Ptr(armavs.ScriptOutputStreamTypeOutput)},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScriptExecution = armavs.ScriptExecution{
	// 	Name: to.Ptr("addSsoServer"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/scriptExecutions/addSsoServer"),
	// 	Properties: &armavs.ScriptExecutionProperties{
	// 		Errors: []*string{
	// 			to.Ptr("Most recent error output"),
	// 			to.Ptr("Second most error recent output")},
	// 			Information: []*string{
	// 				to.Ptr("Most recent information output"),
	// 				to.Ptr("Second most recent information output")},
	// 				Output: []*string{
	// 					to.Ptr("Most recent output"),
	// 					to.Ptr("Second most recent output")},
	// 					Timeout: to.Ptr("P0Y0M0D0H060M0S"),
	// 					Warnings: []*string{
	// 						to.Ptr("Most recent warning output"),
	// 						to.Ptr("Second most recent warning output")},
	// 					},
	// 				}
}
