//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armoperationalinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/LinkedStorageAccountsCreate.json
func ExampleLinkedStorageAccountsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLinkedStorageAccountsClient().CreateOrUpdate(ctx, "mms-eus", "testLinkStorageAccountsWS", armoperationalinsights.DataSourceTypeCustomLogs, armoperationalinsights.LinkedStorageAccountsResource{
		Properties: &armoperationalinsights.LinkedStorageAccountsProperties{
			StorageAccountIDs: []*string{
				to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
				to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB")},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LinkedStorageAccountsResource = armoperationalinsights.LinkedStorageAccountsResource{
	// 	Name: to.Ptr("CustomLogs"),
	// 	Type: to.Ptr("Microsoft.OperationalInsights/workspaces/linkedStorageAccounts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourcegroups/mms-eus/providers/microsoft.operationalinsights/workspaces/testLinkStorageAccountsWS/linkedStorageAccounts/CustomLogs"),
	// 	Properties: &armoperationalinsights.LinkedStorageAccountsProperties{
	// 		DataSourceType: to.Ptr(armoperationalinsights.DataSourceTypeCustomLogs),
	// 		StorageAccountIDs: []*string{
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB")},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/LinkedStorageAccountsDelete.json
func ExampleLinkedStorageAccountsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewLinkedStorageAccountsClient().Delete(ctx, "mms-eus", "testLinkStorageAccountsWS", armoperationalinsights.DataSourceTypeCustomLogs, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/LinkedStorageAccountsGet.json
func ExampleLinkedStorageAccountsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLinkedStorageAccountsClient().Get(ctx, "mms-eus", "testLinkStorageAccountsWS", armoperationalinsights.DataSourceTypeCustomLogs, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LinkedStorageAccountsResource = armoperationalinsights.LinkedStorageAccountsResource{
	// 	Name: to.Ptr("CustomLogs"),
	// 	Type: to.Ptr("Microsoft.OperationalInsights/workspaces/linkedStorageAccounts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/mms-eus/providers/microsoft.operationalinsights/workspaces/testLinkStorageAccountsWS/linkedStorageAccounts/CustomLogs"),
	// 	Properties: &armoperationalinsights.LinkedStorageAccountsProperties{
	// 		DataSourceType: to.Ptr(armoperationalinsights.DataSourceTypeCustomLogs),
	// 		StorageAccountIDs: []*string{
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
	// 			to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB")},
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c767823fdfd9d5e96bad245e3ea4d14d94a716bb/specification/operationalinsights/resource-manager/Microsoft.OperationalInsights/stable/2020-08-01/examples/LinkedStorageAccountsListByWorkspace.json
func ExampleLinkedStorageAccountsClient_NewListByWorkspacePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armoperationalinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLinkedStorageAccountsClient().NewListByWorkspacePager("mms-eus", "testLinkStorageAccountsWS", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LinkedStorageAccountsListResult = armoperationalinsights.LinkedStorageAccountsListResult{
		// 	Value: []*armoperationalinsights.LinkedStorageAccountsResource{
		// 		{
		// 			Name: to.Ptr("CustomLogs"),
		// 			Type: to.Ptr("Microsoft.OperationalInsights/workspaces/linkedStorageAccounts"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/mms-eus/providers/microsoft.operationalinsights/workspaces/testLinkStorageAccountsWS/linkedStorageAccounts/CustomLogs"),
		// 			Properties: &armoperationalinsights.LinkedStorageAccountsProperties{
		// 				DataSourceType: to.Ptr(armoperationalinsights.DataSourceTypeCustomLogs),
		// 				StorageAccountIDs: []*string{
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
		// 					to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageB")},
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("AzureWatson"),
		// 				Type: to.Ptr("Microsoft.OperationalInsights/workspaces/linkedStorageAccounts"),
		// 				ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/mms-eus/providers/microsoft.operationalinsights/workspaces/testLinkStorageAccountsWS/linkedStorageAccounts/AzureWatson"),
		// 				Properties: &armoperationalinsights.LinkedStorageAccountsProperties{
		// 					DataSourceType: to.Ptr(armoperationalinsights.DataSourceTypeAzureWatson),
		// 					StorageAccountIDs: []*string{
		// 						to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
		// 						to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageC")},
		// 					},
		// 				},
		// 				{
		// 					Name: to.Ptr("Query"),
		// 					Type: to.Ptr("Microsoft.OperationalInsights/workspaces/linkedStorageAccounts"),
		// 					ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/mms-eus/providers/microsoft.operationalinsights/workspaces/testLinkStorageAccountsWS/linkedStorageAccounts/Query"),
		// 					Properties: &armoperationalinsights.LinkedStorageAccountsProperties{
		// 						DataSourceType: to.Ptr(armoperationalinsights.DataSourceTypeQuery),
		// 						StorageAccountIDs: []*string{
		// 							to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
		// 							to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageC")},
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("Alerts"),
		// 						Type: to.Ptr("Microsoft.OperationalInsights/workspaces/linkedStorageAccounts"),
		// 						ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000005/resourcegroups/mms-eus/providers/microsoft.operationalinsights/workspaces/testLinkStorageAccountsWS/linkedStorageAccounts/Alerts"),
		// 						Properties: &armoperationalinsights.LinkedStorageAccountsProperties{
		// 							DataSourceType: to.Ptr(armoperationalinsights.DataSourceTypeAlerts),
		// 							StorageAccountIDs: []*string{
		// 								to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageA"),
		// 								to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/mms-eus/providers/Microsoft.Storage/storageAccounts/testStorageC")},
		// 							},
		// 					}},
		// 				}
	}
}
