//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsynapse

import "encoding/json"

// AzureADOnlyAuthenticationsClientCreateResponse contains the response from method AzureADOnlyAuthenticationsClient.BeginCreate.
type AzureADOnlyAuthenticationsClientCreateResponse struct {
	// Azure Active Directory Only Authentication Info
	AzureADOnlyAuthentication
}

// AzureADOnlyAuthenticationsClientGetResponse contains the response from method AzureADOnlyAuthenticationsClient.Get.
type AzureADOnlyAuthenticationsClientGetResponse struct {
	// Azure Active Directory Only Authentication Info
	AzureADOnlyAuthentication
}

// AzureADOnlyAuthenticationsClientListResponse contains the response from method AzureADOnlyAuthenticationsClient.NewListPager.
type AzureADOnlyAuthenticationsClientListResponse struct {
	// A list of active directory only authentications.
	AzureADOnlyAuthenticationListResult
}

// BigDataPoolsClientCreateOrUpdateResponse contains the response from method BigDataPoolsClient.BeginCreateOrUpdate.
type BigDataPoolsClientCreateOrUpdateResponse struct {
	// A Big Data pool
	BigDataPoolResourceInfo
}

// BigDataPoolsClientDeleteResponse contains the response from method BigDataPoolsClient.BeginDelete.
type BigDataPoolsClientDeleteResponse struct {
	// A Big Data pool
	BigDataPoolResourceInfo
}

// BigDataPoolsClientGetResponse contains the response from method BigDataPoolsClient.Get.
type BigDataPoolsClientGetResponse struct {
	// A Big Data pool
	BigDataPoolResourceInfo
}

// BigDataPoolsClientListByWorkspaceResponse contains the response from method BigDataPoolsClient.NewListByWorkspacePager.
type BigDataPoolsClientListByWorkspaceResponse struct {
	// Collection of Big Data pool information
	BigDataPoolResourceInfoListResult
}

// BigDataPoolsClientUpdateResponse contains the response from method BigDataPoolsClient.Update.
type BigDataPoolsClientUpdateResponse struct {
	// A Big Data pool
	BigDataPoolResourceInfo
}

// DataMaskingPoliciesClientCreateOrUpdateResponse contains the response from method DataMaskingPoliciesClient.CreateOrUpdate.
type DataMaskingPoliciesClientCreateOrUpdateResponse struct {
	DataMaskingPolicy
}

// DataMaskingPoliciesClientGetResponse contains the response from method DataMaskingPoliciesClient.Get.
type DataMaskingPoliciesClientGetResponse struct {
	DataMaskingPolicy
}

// DataMaskingRulesClientCreateOrUpdateResponse contains the response from method DataMaskingRulesClient.CreateOrUpdate.
type DataMaskingRulesClientCreateOrUpdateResponse struct {
	// Represents a Sql pool data masking rule.
	DataMaskingRule
}

// DataMaskingRulesClientGetResponse contains the response from method DataMaskingRulesClient.Get.
type DataMaskingRulesClientGetResponse struct {
	// Represents a Sql pool data masking rule.
	DataMaskingRule
}

// DataMaskingRulesClientListBySQLPoolResponse contains the response from method DataMaskingRulesClient.NewListBySQLPoolPager.
type DataMaskingRulesClientListBySQLPoolResponse struct {
	// The response to a list data masking rules request.
	DataMaskingRuleListResult
}

// ExtendedSQLPoolBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method ExtendedSQLPoolBlobAuditingPoliciesClient.CreateOrUpdate.
type ExtendedSQLPoolBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// An extended Sql pool blob auditing policy.
	ExtendedSQLPoolBlobAuditingPolicy
}

// ExtendedSQLPoolBlobAuditingPoliciesClientGetResponse contains the response from method ExtendedSQLPoolBlobAuditingPoliciesClient.Get.
type ExtendedSQLPoolBlobAuditingPoliciesClientGetResponse struct {
	// An extended Sql pool blob auditing policy.
	ExtendedSQLPoolBlobAuditingPolicy
}

// ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse contains the response from method ExtendedSQLPoolBlobAuditingPoliciesClient.NewListBySQLPoolPager.
type ExtendedSQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse struct {
	// A list of sql pool extended auditing settings.
	ExtendedSQLPoolBlobAuditingPolicyListResult
}

// GetClientIntegrationRuntimeEnableInteractivequeryResponse contains the response from method GetClient.IntegrationRuntimeEnableInteractivequery.
type GetClientIntegrationRuntimeEnableInteractivequeryResponse struct {
	// Integration Runtime Operation Status Properties
	IntegrationRuntimeEnableinteractivequery
}

// GetClientIntegrationRuntimeStartResponse contains the response from method GetClient.IntegrationRuntimeStart.
type GetClientIntegrationRuntimeStartResponse struct {
	// Integration Runtime Operation Status Properties
	IntegrationRuntimeOperationStatus
}

// GetClientIntegrationRuntimeStopResponse contains the response from method GetClient.IntegrationRuntimeStop.
type GetClientIntegrationRuntimeStopResponse struct {
	// Integration Runtime Operation Status Properties
	IntegrationRuntimeStopOperationStatus
}

// IPFirewallRulesClientCreateOrUpdateResponse contains the response from method IPFirewallRulesClient.BeginCreateOrUpdate.
type IPFirewallRulesClientCreateOrUpdateResponse struct {
	// IP firewall rule
	IPFirewallRuleInfo
}

// IPFirewallRulesClientDeleteResponse contains the response from method IPFirewallRulesClient.BeginDelete.
type IPFirewallRulesClientDeleteResponse struct {
	// IP firewall rule
	IPFirewallRuleInfo
}

// IPFirewallRulesClientGetResponse contains the response from method IPFirewallRulesClient.Get.
type IPFirewallRulesClientGetResponse struct {
	// IP firewall rule
	IPFirewallRuleInfo
}

// IPFirewallRulesClientListByWorkspaceResponse contains the response from method IPFirewallRulesClient.NewListByWorkspacePager.
type IPFirewallRulesClientListByWorkspaceResponse struct {
	// List of IP firewall rules
	IPFirewallRuleInfoListResult
}

// IPFirewallRulesClientReplaceAllResponse contains the response from method IPFirewallRulesClient.BeginReplaceAll.
type IPFirewallRulesClientReplaceAllResponse struct {
	// An existing operation for replacing the firewall rules
	ReplaceAllFirewallRulesOperationResponse
}

// IntegrationRuntimeAuthKeysClientListResponse contains the response from method IntegrationRuntimeAuthKeysClient.List.
type IntegrationRuntimeAuthKeysClientListResponse struct {
	// The integration runtime authentication keys.
	IntegrationRuntimeAuthKeys
}

// IntegrationRuntimeAuthKeysClientRegenerateResponse contains the response from method IntegrationRuntimeAuthKeysClient.Regenerate.
type IntegrationRuntimeAuthKeysClientRegenerateResponse struct {
	// The integration runtime authentication keys.
	IntegrationRuntimeAuthKeys
}

// IntegrationRuntimeConnectionInfosClientGetResponse contains the response from method IntegrationRuntimeConnectionInfosClient.Get.
type IntegrationRuntimeConnectionInfosClientGetResponse struct {
	// Connection information for encrypting the on-premises data source credentials.
	IntegrationRuntimeConnectionInfo
}

// IntegrationRuntimeCredentialsClientSyncResponse contains the response from method IntegrationRuntimeCredentialsClient.Sync.
type IntegrationRuntimeCredentialsClientSyncResponse struct {
	// placeholder for future response values
}

// IntegrationRuntimeMonitoringDataClientListResponse contains the response from method IntegrationRuntimeMonitoringDataClient.List.
type IntegrationRuntimeMonitoringDataClientListResponse struct {
	// Get monitoring data response.
	IntegrationRuntimeMonitoringData
}

// IntegrationRuntimeNodeIPAddressClientGetResponse contains the response from method IntegrationRuntimeNodeIPAddressClient.Get.
type IntegrationRuntimeNodeIPAddressClientGetResponse struct {
	// The IP address of self-hosted integration runtime node.
	IntegrationRuntimeNodeIPAddress
}

// IntegrationRuntimeNodesClientDeleteResponse contains the response from method IntegrationRuntimeNodesClient.Delete.
type IntegrationRuntimeNodesClientDeleteResponse struct {
	// placeholder for future response values
}

// IntegrationRuntimeNodesClientGetResponse contains the response from method IntegrationRuntimeNodesClient.Get.
type IntegrationRuntimeNodesClientGetResponse struct {
	// Properties of Self-hosted integration runtime node.
	SelfHostedIntegrationRuntimeNode
}

// IntegrationRuntimeNodesClientUpdateResponse contains the response from method IntegrationRuntimeNodesClient.Update.
type IntegrationRuntimeNodesClientUpdateResponse struct {
	// Properties of Self-hosted integration runtime node.
	SelfHostedIntegrationRuntimeNode
}

// IntegrationRuntimeObjectMetadataClientListResponse contains the response from method IntegrationRuntimeObjectMetadataClient.List.
type IntegrationRuntimeObjectMetadataClientListResponse struct {
	// A list of SSIS object metadata.
	SsisObjectMetadataListResponse
}

// IntegrationRuntimeObjectMetadataClientRefreshResponse contains the response from method IntegrationRuntimeObjectMetadataClient.BeginRefresh.
type IntegrationRuntimeObjectMetadataClientRefreshResponse struct {
	// The status of the operation.
	SsisObjectMetadataStatusResponse
}

// IntegrationRuntimeStatusClientGetResponse contains the response from method IntegrationRuntimeStatusClient.Get.
type IntegrationRuntimeStatusClientGetResponse struct {
	// Integration runtime status response.
	IntegrationRuntimeStatusResponse
}

// IntegrationRuntimesClientCreateResponse contains the response from method IntegrationRuntimesClient.BeginCreate.
type IntegrationRuntimesClientCreateResponse struct {
	// Integration runtime resource type.
	IntegrationRuntimeResource
}

// IntegrationRuntimesClientDeleteResponse contains the response from method IntegrationRuntimesClient.BeginDelete.
type IntegrationRuntimesClientDeleteResponse struct {
	// placeholder for future response values
}

// IntegrationRuntimesClientDisableInteractiveQueryResponse contains the response from method IntegrationRuntimesClient.BeginDisableInteractiveQuery.
type IntegrationRuntimesClientDisableInteractiveQueryResponse struct {
	// placeholder for future response values
}

// IntegrationRuntimesClientEnableInteractiveQueryResponse contains the response from method IntegrationRuntimesClient.BeginEnableInteractiveQuery.
type IntegrationRuntimesClientEnableInteractiveQueryResponse struct {
	// placeholder for future response values
}

// IntegrationRuntimesClientGetResponse contains the response from method IntegrationRuntimesClient.Get.
type IntegrationRuntimesClientGetResponse struct {
	// Integration runtime resource type.
	IntegrationRuntimeResource
}

// IntegrationRuntimesClientListByWorkspaceResponse contains the response from method IntegrationRuntimesClient.NewListByWorkspacePager.
type IntegrationRuntimesClientListByWorkspaceResponse struct {
	// A list of integration runtime resources.
	IntegrationRuntimeListResponse
}

// IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsResponse contains the response from method IntegrationRuntimesClient.ListOutboundNetworkDependenciesEndpoints.
type IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsResponse struct {
	// Azure-SSIS integration runtime outbound network dependency endpoints.
	IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse
}

// IntegrationRuntimesClientStartResponse contains the response from method IntegrationRuntimesClient.BeginStart.
type IntegrationRuntimesClientStartResponse struct {
	// Integration runtime status response.
	IntegrationRuntimeStatusResponse
}

// IntegrationRuntimesClientStopResponse contains the response from method IntegrationRuntimesClient.BeginStop.
type IntegrationRuntimesClientStopResponse struct {
	// placeholder for future response values
}

// IntegrationRuntimesClientUpdateResponse contains the response from method IntegrationRuntimesClient.Update.
type IntegrationRuntimesClientUpdateResponse struct {
	// Integration runtime resource type.
	IntegrationRuntimeResource
}

// IntegrationRuntimesClientUpgradeResponse contains the response from method IntegrationRuntimesClient.Upgrade.
type IntegrationRuntimesClientUpgradeResponse struct {
	// placeholder for future response values
}

// KeysClientCreateOrUpdateResponse contains the response from method KeysClient.CreateOrUpdate.
type KeysClientCreateOrUpdateResponse struct {
	// A workspace key
	Key
}

// KeysClientDeleteResponse contains the response from method KeysClient.Delete.
type KeysClientDeleteResponse struct {
	// A workspace key
	Key
}

// KeysClientGetResponse contains the response from method KeysClient.Get.
type KeysClientGetResponse struct {
	// A workspace key
	Key
}

// KeysClientListByWorkspaceResponse contains the response from method KeysClient.NewListByWorkspacePager.
type KeysClientListByWorkspaceResponse struct {
	// List of keys
	KeyInfoListResult
}

// KustoOperationsClientListResponse contains the response from method KustoOperationsClient.NewListPager.
type KustoOperationsClientListResponse struct {
	// Result of the request to list REST API operations. It contains a list of operations and a URL nextLink to get the next
	// set of results.
	OperationListResult
}

// KustoPoolAttachedDatabaseConfigurationsClientCreateOrUpdateResponse contains the response from method KustoPoolAttachedDatabaseConfigurationsClient.BeginCreateOrUpdate.
type KustoPoolAttachedDatabaseConfigurationsClientCreateOrUpdateResponse struct {
	// Class representing an attached database configuration.
	AttachedDatabaseConfiguration
}

// KustoPoolAttachedDatabaseConfigurationsClientDeleteResponse contains the response from method KustoPoolAttachedDatabaseConfigurationsClient.BeginDelete.
type KustoPoolAttachedDatabaseConfigurationsClientDeleteResponse struct {
	// placeholder for future response values
}

// KustoPoolAttachedDatabaseConfigurationsClientGetResponse contains the response from method KustoPoolAttachedDatabaseConfigurationsClient.Get.
type KustoPoolAttachedDatabaseConfigurationsClientGetResponse struct {
	// Class representing an attached database configuration.
	AttachedDatabaseConfiguration
}

// KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolResponse contains the response from method KustoPoolAttachedDatabaseConfigurationsClient.NewListByKustoPoolPager.
type KustoPoolAttachedDatabaseConfigurationsClientListByKustoPoolResponse struct {
	// The list attached database configurations operation response.
	AttachedDatabaseConfigurationListResult
}

// KustoPoolChildResourceClientCheckNameAvailabilityResponse contains the response from method KustoPoolChildResourceClient.CheckNameAvailability.
type KustoPoolChildResourceClientCheckNameAvailabilityResponse struct {
	// The result returned from a check name availability request.
	CheckNameResult
}

// KustoPoolDataConnectionsClientCheckNameAvailabilityResponse contains the response from method KustoPoolDataConnectionsClient.CheckNameAvailability.
type KustoPoolDataConnectionsClientCheckNameAvailabilityResponse struct {
	// The result returned from a check name availability request.
	CheckNameResult
}

// KustoPoolDataConnectionsClientCreateOrUpdateResponse contains the response from method KustoPoolDataConnectionsClient.BeginCreateOrUpdate.
type KustoPoolDataConnectionsClientCreateOrUpdateResponse struct {
	// Class representing a data connection.
	DataConnectionClassification
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolDataConnectionsClientCreateOrUpdateResponse.
func (k KustoPoolDataConnectionsClientCreateOrUpdateResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(k.DataConnectionClassification)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolDataConnectionsClientCreateOrUpdateResponse.
func (k *KustoPoolDataConnectionsClientCreateOrUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDataConnectionClassification(data)
	if err != nil {
		return err
	}
	k.DataConnectionClassification = res
	return nil
}

// KustoPoolDataConnectionsClientDataConnectionValidationResponse contains the response from method KustoPoolDataConnectionsClient.BeginDataConnectionValidation.
type KustoPoolDataConnectionsClientDataConnectionValidationResponse struct {
	// The list Kusto data connection validation result.
	DataConnectionValidationListResult
}

// KustoPoolDataConnectionsClientDeleteResponse contains the response from method KustoPoolDataConnectionsClient.BeginDelete.
type KustoPoolDataConnectionsClientDeleteResponse struct {
	// placeholder for future response values
}

// KustoPoolDataConnectionsClientGetResponse contains the response from method KustoPoolDataConnectionsClient.Get.
type KustoPoolDataConnectionsClientGetResponse struct {
	// Class representing a data connection.
	DataConnectionClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolDataConnectionsClientGetResponse.
func (k *KustoPoolDataConnectionsClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDataConnectionClassification(data)
	if err != nil {
		return err
	}
	k.DataConnectionClassification = res
	return nil
}

// KustoPoolDataConnectionsClientListByDatabaseResponse contains the response from method KustoPoolDataConnectionsClient.NewListByDatabasePager.
type KustoPoolDataConnectionsClientListByDatabaseResponse struct {
	// The list Kusto data connections operation response.
	DataConnectionListResult
}

// KustoPoolDataConnectionsClientUpdateResponse contains the response from method KustoPoolDataConnectionsClient.BeginUpdate.
type KustoPoolDataConnectionsClientUpdateResponse struct {
	// Class representing a data connection.
	DataConnectionClassification
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolDataConnectionsClientUpdateResponse.
func (k KustoPoolDataConnectionsClientUpdateResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(k.DataConnectionClassification)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolDataConnectionsClientUpdateResponse.
func (k *KustoPoolDataConnectionsClientUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDataConnectionClassification(data)
	if err != nil {
		return err
	}
	k.DataConnectionClassification = res
	return nil
}

// KustoPoolDatabasePrincipalAssignmentsClientCheckNameAvailabilityResponse contains the response from method KustoPoolDatabasePrincipalAssignmentsClient.CheckNameAvailability.
type KustoPoolDatabasePrincipalAssignmentsClientCheckNameAvailabilityResponse struct {
	// The result returned from a check name availability request.
	CheckNameResult
}

// KustoPoolDatabasePrincipalAssignmentsClientCreateOrUpdateResponse contains the response from method KustoPoolDatabasePrincipalAssignmentsClient.BeginCreateOrUpdate.
type KustoPoolDatabasePrincipalAssignmentsClientCreateOrUpdateResponse struct {
	// Class representing a database principal assignment.
	DatabasePrincipalAssignment
}

// KustoPoolDatabasePrincipalAssignmentsClientDeleteResponse contains the response from method KustoPoolDatabasePrincipalAssignmentsClient.BeginDelete.
type KustoPoolDatabasePrincipalAssignmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// KustoPoolDatabasePrincipalAssignmentsClientGetResponse contains the response from method KustoPoolDatabasePrincipalAssignmentsClient.Get.
type KustoPoolDatabasePrincipalAssignmentsClientGetResponse struct {
	// Class representing a database principal assignment.
	DatabasePrincipalAssignment
}

// KustoPoolDatabasePrincipalAssignmentsClientListResponse contains the response from method KustoPoolDatabasePrincipalAssignmentsClient.NewListPager.
type KustoPoolDatabasePrincipalAssignmentsClientListResponse struct {
	// The list Kusto database principal assignments operation response.
	DatabasePrincipalAssignmentListResult
}

// KustoPoolDatabasesClientCreateOrUpdateResponse contains the response from method KustoPoolDatabasesClient.BeginCreateOrUpdate.
type KustoPoolDatabasesClientCreateOrUpdateResponse struct {
	// Class representing a Kusto database.
	DatabaseClassification
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolDatabasesClientCreateOrUpdateResponse.
func (k KustoPoolDatabasesClientCreateOrUpdateResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(k.DatabaseClassification)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolDatabasesClientCreateOrUpdateResponse.
func (k *KustoPoolDatabasesClientCreateOrUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDatabaseClassification(data)
	if err != nil {
		return err
	}
	k.DatabaseClassification = res
	return nil
}

// KustoPoolDatabasesClientDeleteResponse contains the response from method KustoPoolDatabasesClient.BeginDelete.
type KustoPoolDatabasesClientDeleteResponse struct {
	// placeholder for future response values
}

// KustoPoolDatabasesClientGetResponse contains the response from method KustoPoolDatabasesClient.Get.
type KustoPoolDatabasesClientGetResponse struct {
	// Class representing a Kusto database.
	DatabaseClassification
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolDatabasesClientGetResponse.
func (k *KustoPoolDatabasesClientGetResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDatabaseClassification(data)
	if err != nil {
		return err
	}
	k.DatabaseClassification = res
	return nil
}

// KustoPoolDatabasesClientListByKustoPoolResponse contains the response from method KustoPoolDatabasesClient.NewListByKustoPoolPager.
type KustoPoolDatabasesClientListByKustoPoolResponse struct {
	// The list Kusto databases operation response.
	DatabaseListResult
}

// KustoPoolDatabasesClientUpdateResponse contains the response from method KustoPoolDatabasesClient.BeginUpdate.
type KustoPoolDatabasesClientUpdateResponse struct {
	// Class representing a Kusto database.
	DatabaseClassification
}

// MarshalJSON implements the json.Marshaller interface for type KustoPoolDatabasesClientUpdateResponse.
func (k KustoPoolDatabasesClientUpdateResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(k.DatabaseClassification)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustoPoolDatabasesClientUpdateResponse.
func (k *KustoPoolDatabasesClientUpdateResponse) UnmarshalJSON(data []byte) error {
	res, err := unmarshalDatabaseClassification(data)
	if err != nil {
		return err
	}
	k.DatabaseClassification = res
	return nil
}

// KustoPoolPrincipalAssignmentsClientCheckNameAvailabilityResponse contains the response from method KustoPoolPrincipalAssignmentsClient.CheckNameAvailability.
type KustoPoolPrincipalAssignmentsClientCheckNameAvailabilityResponse struct {
	// The result returned from a check name availability request.
	CheckNameResult
}

// KustoPoolPrincipalAssignmentsClientCreateOrUpdateResponse contains the response from method KustoPoolPrincipalAssignmentsClient.BeginCreateOrUpdate.
type KustoPoolPrincipalAssignmentsClientCreateOrUpdateResponse struct {
	// Class representing a cluster principal assignment.
	ClusterPrincipalAssignment
}

// KustoPoolPrincipalAssignmentsClientDeleteResponse contains the response from method KustoPoolPrincipalAssignmentsClient.BeginDelete.
type KustoPoolPrincipalAssignmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// KustoPoolPrincipalAssignmentsClientGetResponse contains the response from method KustoPoolPrincipalAssignmentsClient.Get.
type KustoPoolPrincipalAssignmentsClientGetResponse struct {
	// Class representing a cluster principal assignment.
	ClusterPrincipalAssignment
}

// KustoPoolPrincipalAssignmentsClientListResponse contains the response from method KustoPoolPrincipalAssignmentsClient.NewListPager.
type KustoPoolPrincipalAssignmentsClientListResponse struct {
	// The list Kusto cluster principal assignments operation response.
	ClusterPrincipalAssignmentListResult
}

// KustoPoolPrivateLinkResourcesClientListResponse contains the response from method KustoPoolPrivateLinkResourcesClient.NewListPager.
type KustoPoolPrivateLinkResourcesClientListResponse struct {
	// The list Kusto Private Link Resources operation response.
	PrivateLinkResources
}

// KustoPoolsClientAddLanguageExtensionsResponse contains the response from method KustoPoolsClient.BeginAddLanguageExtensions.
type KustoPoolsClientAddLanguageExtensionsResponse struct {
	// placeholder for future response values
}

// KustoPoolsClientCheckNameAvailabilityResponse contains the response from method KustoPoolsClient.CheckNameAvailability.
type KustoPoolsClientCheckNameAvailabilityResponse struct {
	// The result returned from a check name availability request.
	CheckNameResult
}

// KustoPoolsClientCreateOrUpdateResponse contains the response from method KustoPoolsClient.BeginCreateOrUpdate.
type KustoPoolsClientCreateOrUpdateResponse struct {
	// Class representing a Kusto kusto pool.
	KustoPool
}

// KustoPoolsClientDeleteResponse contains the response from method KustoPoolsClient.BeginDelete.
type KustoPoolsClientDeleteResponse struct {
	// placeholder for future response values
}

// KustoPoolsClientDetachFollowerDatabasesResponse contains the response from method KustoPoolsClient.BeginDetachFollowerDatabases.
type KustoPoolsClientDetachFollowerDatabasesResponse struct {
	// placeholder for future response values
}

// KustoPoolsClientGetResponse contains the response from method KustoPoolsClient.Get.
type KustoPoolsClientGetResponse struct {
	// Class representing a Kusto kusto pool.
	KustoPool
}

// KustoPoolsClientListByWorkspaceResponse contains the response from method KustoPoolsClient.ListByWorkspace.
type KustoPoolsClientListByWorkspaceResponse struct {
	// The list Kusto pools operation response.
	KustoPoolListResult
}

// KustoPoolsClientListFollowerDatabasesResponse contains the response from method KustoPoolsClient.NewListFollowerDatabasesPager.
type KustoPoolsClientListFollowerDatabasesResponse struct {
	// The list Kusto database principals operation response.
	FollowerDatabaseListResult
}

// KustoPoolsClientListLanguageExtensionsResponse contains the response from method KustoPoolsClient.NewListLanguageExtensionsPager.
type KustoPoolsClientListLanguageExtensionsResponse struct {
	// The list of language extension objects.
	LanguageExtensionsList
}

// KustoPoolsClientListSKUsByResourceResponse contains the response from method KustoPoolsClient.NewListSKUsByResourcePager.
type KustoPoolsClientListSKUsByResourceResponse struct {
	// List of available SKUs for a Kusto Pool.
	ListResourceSKUsResult
}

// KustoPoolsClientListSKUsResponse contains the response from method KustoPoolsClient.NewListSKUsPager.
type KustoPoolsClientListSKUsResponse struct {
	// The list of the SKU descriptions
	SKUDescriptionList
}

// KustoPoolsClientRemoveLanguageExtensionsResponse contains the response from method KustoPoolsClient.BeginRemoveLanguageExtensions.
type KustoPoolsClientRemoveLanguageExtensionsResponse struct {
	// placeholder for future response values
}

// KustoPoolsClientStartResponse contains the response from method KustoPoolsClient.BeginStart.
type KustoPoolsClientStartResponse struct {
	// placeholder for future response values
}

// KustoPoolsClientStopResponse contains the response from method KustoPoolsClient.BeginStop.
type KustoPoolsClientStopResponse struct {
	// placeholder for future response values
}

// KustoPoolsClientUpdateResponse contains the response from method KustoPoolsClient.BeginUpdate.
type KustoPoolsClientUpdateResponse struct {
	// Class representing a Kusto kusto pool.
	KustoPool
}

// LibrariesClientListByWorkspaceResponse contains the response from method LibrariesClient.NewListByWorkspacePager.
type LibrariesClientListByWorkspaceResponse struct {
	// A list of Library resources.
	LibraryListResponse
}

// LibraryClientGetResponse contains the response from method LibraryClient.Get.
type LibraryClientGetResponse struct {
	// Library response details
	LibraryResource
}

// OperationsClientCheckNameAvailabilityResponse contains the response from method OperationsClient.CheckNameAvailability.
type OperationsClientCheckNameAvailabilityResponse struct {
	// A response saying whether the workspace name is available
	CheckNameAvailabilityResponse
}

// OperationsClientGetAzureAsyncHeaderResultResponse contains the response from method OperationsClient.GetAzureAsyncHeaderResult.
type OperationsClientGetAzureAsyncHeaderResultResponse struct {
	// An operation
	OperationResource
}

// OperationsClientGetLocationHeaderResultResponse contains the response from method OperationsClient.GetLocationHeaderResult.
type OperationsClientGetLocationHeaderResultResponse struct {
	// placeholder for future response values
}

// OperationsClientListResponse contains the response from method OperationsClient.List.
type OperationsClientListResponse struct {
	// Array of AvailableRpOperation
	AvailableRpOperationArray []*AvailableRpOperation
}

// PrivateEndpointConnectionsClientCreateResponse contains the response from method PrivateEndpointConnectionsClient.BeginCreate.
type PrivateEndpointConnectionsClientCreateResponse struct {
	// A private endpoint connection
	PrivateEndpointConnection
}

// PrivateEndpointConnectionsClientDeleteResponse contains the response from method PrivateEndpointConnectionsClient.BeginDelete.
type PrivateEndpointConnectionsClientDeleteResponse struct {
	// An operation
	OperationResource
}

// PrivateEndpointConnectionsClientGetResponse contains the response from method PrivateEndpointConnectionsClient.Get.
type PrivateEndpointConnectionsClientGetResponse struct {
	// A private endpoint connection
	PrivateEndpointConnection
}

// PrivateEndpointConnectionsClientListResponse contains the response from method PrivateEndpointConnectionsClient.NewListPager.
type PrivateEndpointConnectionsClientListResponse struct {
	// A list of private endpoint connections
	PrivateEndpointConnectionList
}

// PrivateEndpointConnectionsPrivateLinkHubClientGetResponse contains the response from method PrivateEndpointConnectionsPrivateLinkHubClient.Get.
type PrivateEndpointConnectionsPrivateLinkHubClientGetResponse struct {
	PrivateEndpointConnectionForPrivateLinkHub
}

// PrivateEndpointConnectionsPrivateLinkHubClientListResponse contains the response from method PrivateEndpointConnectionsPrivateLinkHubClient.NewListPager.
type PrivateEndpointConnectionsPrivateLinkHubClientListResponse struct {
	PrivateEndpointConnectionForPrivateLinkHubResourceCollectionResponse
}

// PrivateLinkHubPrivateLinkResourcesClientGetResponse contains the response from method PrivateLinkHubPrivateLinkResourcesClient.Get.
type PrivateLinkHubPrivateLinkResourcesClientGetResponse struct {
	// A private link resource
	PrivateLinkResource
}

// PrivateLinkHubPrivateLinkResourcesClientListResponse contains the response from method PrivateLinkHubPrivateLinkResourcesClient.NewListPager.
type PrivateLinkHubPrivateLinkResourcesClientListResponse struct {
	// A list of private link resources
	PrivateLinkResourceListResult
}

// PrivateLinkHubsClientCreateOrUpdateResponse contains the response from method PrivateLinkHubsClient.CreateOrUpdate.
type PrivateLinkHubsClientCreateOrUpdateResponse struct {
	// A privateLinkHub
	PrivateLinkHub
}

// PrivateLinkHubsClientDeleteResponse contains the response from method PrivateLinkHubsClient.BeginDelete.
type PrivateLinkHubsClientDeleteResponse struct {
	// placeholder for future response values
}

// PrivateLinkHubsClientGetResponse contains the response from method PrivateLinkHubsClient.Get.
type PrivateLinkHubsClientGetResponse struct {
	// A privateLinkHub
	PrivateLinkHub
}

// PrivateLinkHubsClientListByResourceGroupResponse contains the response from method PrivateLinkHubsClient.NewListByResourceGroupPager.
type PrivateLinkHubsClientListByResourceGroupResponse struct {
	// List of privateLinkHubs
	PrivateLinkHubInfoListResult
}

// PrivateLinkHubsClientListResponse contains the response from method PrivateLinkHubsClient.NewListPager.
type PrivateLinkHubsClientListResponse struct {
	// List of privateLinkHubs
	PrivateLinkHubInfoListResult
}

// PrivateLinkHubsClientUpdateResponse contains the response from method PrivateLinkHubsClient.Update.
type PrivateLinkHubsClientUpdateResponse struct {
	// A privateLinkHub
	PrivateLinkHub
}

// PrivateLinkResourcesClientGetResponse contains the response from method PrivateLinkResourcesClient.Get.
type PrivateLinkResourcesClientGetResponse struct {
	// A private link resource
	PrivateLinkResource
}

// PrivateLinkResourcesClientListResponse contains the response from method PrivateLinkResourcesClient.NewListPager.
type PrivateLinkResourcesClientListResponse struct {
	// A list of private link resources
	PrivateLinkResourceListResult
}

// RestorableDroppedSQLPoolsClientGetResponse contains the response from method RestorableDroppedSQLPoolsClient.Get.
type RestorableDroppedSQLPoolsClientGetResponse struct {
	// A restorable dropped Sql pool
	RestorableDroppedSQLPool
}

// RestorableDroppedSQLPoolsClientListByWorkspaceResponse contains the response from method RestorableDroppedSQLPoolsClient.NewListByWorkspacePager.
type RestorableDroppedSQLPoolsClientListByWorkspaceResponse struct {
	// The response to a list restorable dropped Sql pools request
	RestorableDroppedSQLPoolListResult
}

// SQLPoolBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method SQLPoolBlobAuditingPoliciesClient.CreateOrUpdate.
type SQLPoolBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// A Sql pool blob auditing policy.
	SQLPoolBlobAuditingPolicy
}

// SQLPoolBlobAuditingPoliciesClientGetResponse contains the response from method SQLPoolBlobAuditingPoliciesClient.Get.
type SQLPoolBlobAuditingPoliciesClientGetResponse struct {
	// A Sql pool blob auditing policy.
	SQLPoolBlobAuditingPolicy
}

// SQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse contains the response from method SQLPoolBlobAuditingPoliciesClient.NewListBySQLPoolPager.
type SQLPoolBlobAuditingPoliciesClientListBySQLPoolResponse struct {
	// A list of Sql pool auditing settings.
	SQLPoolBlobAuditingPolicyListResult
}

// SQLPoolColumnsClientGetResponse contains the response from method SQLPoolColumnsClient.Get.
type SQLPoolColumnsClientGetResponse struct {
	// A Sql pool column resource.
	SQLPoolColumn
}

// SQLPoolConnectionPoliciesClientGetResponse contains the response from method SQLPoolConnectionPoliciesClient.Get.
type SQLPoolConnectionPoliciesClientGetResponse struct {
	// A Sql pool connection policy.
	SQLPoolConnectionPolicy
}

// SQLPoolDataWarehouseUserActivitiesClientGetResponse contains the response from method SQLPoolDataWarehouseUserActivitiesClient.Get.
type SQLPoolDataWarehouseUserActivitiesClientGetResponse struct {
	// User activities of a data warehouse
	DataWarehouseUserActivities
}

// SQLPoolGeoBackupPoliciesClientCreateOrUpdateResponse contains the response from method SQLPoolGeoBackupPoliciesClient.CreateOrUpdate.
type SQLPoolGeoBackupPoliciesClientCreateOrUpdateResponse struct {
	// A database geo backup policy.
	GeoBackupPolicy
}

// SQLPoolGeoBackupPoliciesClientGetResponse contains the response from method SQLPoolGeoBackupPoliciesClient.Get.
type SQLPoolGeoBackupPoliciesClientGetResponse struct {
	// A database geo backup policy.
	GeoBackupPolicy
}

// SQLPoolGeoBackupPoliciesClientListResponse contains the response from method SQLPoolGeoBackupPoliciesClient.NewListPager.
type SQLPoolGeoBackupPoliciesClientListResponse struct {
	// The response to a list geo backup policies request.
	GeoBackupPolicyListResult
}

// SQLPoolMaintenanceWindowOptionsClientGetResponse contains the response from method SQLPoolMaintenanceWindowOptionsClient.Get.
type SQLPoolMaintenanceWindowOptionsClientGetResponse struct {
	// Maintenance window options.
	MaintenanceWindowOptions
}

// SQLPoolMaintenanceWindowsClientCreateOrUpdateResponse contains the response from method SQLPoolMaintenanceWindowsClient.CreateOrUpdate.
type SQLPoolMaintenanceWindowsClientCreateOrUpdateResponse struct {
	// placeholder for future response values
}

// SQLPoolMaintenanceWindowsClientGetResponse contains the response from method SQLPoolMaintenanceWindowsClient.Get.
type SQLPoolMaintenanceWindowsClientGetResponse struct {
	// Maintenance windows.
	MaintenanceWindows
}

// SQLPoolMetadataSyncConfigsClientCreateResponse contains the response from method SQLPoolMetadataSyncConfigsClient.Create.
type SQLPoolMetadataSyncConfigsClientCreateResponse struct {
	// Configuration for metadata sync
	MetadataSyncConfig
}

// SQLPoolMetadataSyncConfigsClientGetResponse contains the response from method SQLPoolMetadataSyncConfigsClient.Get.
type SQLPoolMetadataSyncConfigsClientGetResponse struct {
	// Configuration for metadata sync
	MetadataSyncConfig
}

// SQLPoolOperationResultsClientGetLocationHeaderResultResponse contains the response from method SQLPoolOperationResultsClient.BeginGetLocationHeaderResult.
type SQLPoolOperationResultsClientGetLocationHeaderResultResponse struct {
	// A SQL Analytics pool
	SQLPool
}

// SQLPoolOperationsClientListResponse contains the response from method SQLPoolOperationsClient.NewListPager.
type SQLPoolOperationsClientListResponse struct {
	// The response to a list Sql pool operations request
	SQLPoolBlobAuditingPolicySQLPoolOperationListResult
}

// SQLPoolRecommendedSensitivityLabelsClientUpdateResponse contains the response from method SQLPoolRecommendedSensitivityLabelsClient.Update.
type SQLPoolRecommendedSensitivityLabelsClientUpdateResponse struct {
	// placeholder for future response values
}

// SQLPoolReplicationLinksClientGetByNameResponse contains the response from method SQLPoolReplicationLinksClient.GetByName.
type SQLPoolReplicationLinksClientGetByNameResponse struct {
	// Represents a Sql pool replication link.
	ReplicationLink
}

// SQLPoolReplicationLinksClientListResponse contains the response from method SQLPoolReplicationLinksClient.NewListPager.
type SQLPoolReplicationLinksClientListResponse struct {
	// Represents the response to a List Sql pool replication link request.
	ReplicationLinkListResult
}

// SQLPoolRestorePointsClientCreateResponse contains the response from method SQLPoolRestorePointsClient.BeginCreate.
type SQLPoolRestorePointsClientCreateResponse struct {
	// Database restore points.
	RestorePoint
}

// SQLPoolRestorePointsClientDeleteResponse contains the response from method SQLPoolRestorePointsClient.Delete.
type SQLPoolRestorePointsClientDeleteResponse struct {
	// placeholder for future response values
}

// SQLPoolRestorePointsClientGetResponse contains the response from method SQLPoolRestorePointsClient.Get.
type SQLPoolRestorePointsClientGetResponse struct {
	// Database restore points.
	RestorePoint
}

// SQLPoolRestorePointsClientListResponse contains the response from method SQLPoolRestorePointsClient.NewListPager.
type SQLPoolRestorePointsClientListResponse struct {
	// A list of long term retention backups.
	RestorePointListResult
}

// SQLPoolSchemasClientGetResponse contains the response from method SQLPoolSchemasClient.Get.
type SQLPoolSchemasClientGetResponse struct {
	// A Sql pool schema resource.
	SQLPoolSchema
}

// SQLPoolSchemasClientListResponse contains the response from method SQLPoolSchemasClient.NewListPager.
type SQLPoolSchemasClientListResponse struct {
	// A list of Sql pool schemas.
	SQLPoolSchemaListResult
}

// SQLPoolSecurityAlertPoliciesClientCreateOrUpdateResponse contains the response from method SQLPoolSecurityAlertPoliciesClient.CreateOrUpdate.
type SQLPoolSecurityAlertPoliciesClientCreateOrUpdateResponse struct {
	// A Sql pool security alert policy.
	SQLPoolSecurityAlertPolicy
}

// SQLPoolSecurityAlertPoliciesClientGetResponse contains the response from method SQLPoolSecurityAlertPoliciesClient.Get.
type SQLPoolSecurityAlertPoliciesClientGetResponse struct {
	// A Sql pool security alert policy.
	SQLPoolSecurityAlertPolicy
}

// SQLPoolSecurityAlertPoliciesClientListResponse contains the response from method SQLPoolSecurityAlertPoliciesClient.NewListPager.
type SQLPoolSecurityAlertPoliciesClientListResponse struct {
	// A list of SQL pool security alert policies.
	ListSQLPoolSecurityAlertPolicies
}

// SQLPoolSensitivityLabelsClientCreateOrUpdateResponse contains the response from method SQLPoolSensitivityLabelsClient.CreateOrUpdate.
type SQLPoolSensitivityLabelsClientCreateOrUpdateResponse struct {
	// A sensitivity label.
	SensitivityLabel
}

// SQLPoolSensitivityLabelsClientDeleteResponse contains the response from method SQLPoolSensitivityLabelsClient.Delete.
type SQLPoolSensitivityLabelsClientDeleteResponse struct {
	// placeholder for future response values
}

// SQLPoolSensitivityLabelsClientDisableRecommendationResponse contains the response from method SQLPoolSensitivityLabelsClient.DisableRecommendation.
type SQLPoolSensitivityLabelsClientDisableRecommendationResponse struct {
	// placeholder for future response values
}

// SQLPoolSensitivityLabelsClientEnableRecommendationResponse contains the response from method SQLPoolSensitivityLabelsClient.EnableRecommendation.
type SQLPoolSensitivityLabelsClientEnableRecommendationResponse struct {
	// placeholder for future response values
}

// SQLPoolSensitivityLabelsClientGetResponse contains the response from method SQLPoolSensitivityLabelsClient.Get.
type SQLPoolSensitivityLabelsClientGetResponse struct {
	// A sensitivity label.
	SensitivityLabel
}

// SQLPoolSensitivityLabelsClientListCurrentResponse contains the response from method SQLPoolSensitivityLabelsClient.NewListCurrentPager.
type SQLPoolSensitivityLabelsClientListCurrentResponse struct {
	// A list of sensitivity labels.
	SensitivityLabelListResult
}

// SQLPoolSensitivityLabelsClientListRecommendedResponse contains the response from method SQLPoolSensitivityLabelsClient.NewListRecommendedPager.
type SQLPoolSensitivityLabelsClientListRecommendedResponse struct {
	// A list of sensitivity labels.
	SensitivityLabelListResult
}

// SQLPoolSensitivityLabelsClientUpdateResponse contains the response from method SQLPoolSensitivityLabelsClient.Update.
type SQLPoolSensitivityLabelsClientUpdateResponse struct {
	// placeholder for future response values
}

// SQLPoolTableColumnsClientListByTableNameResponse contains the response from method SQLPoolTableColumnsClient.NewListByTableNamePager.
type SQLPoolTableColumnsClientListByTableNameResponse struct {
	// A list of Sql pool columns.
	SQLPoolColumnListResult
}

// SQLPoolTablesClientGetResponse contains the response from method SQLPoolTablesClient.Get.
type SQLPoolTablesClientGetResponse struct {
	// A Sql pool table resource.
	SQLPoolTable
}

// SQLPoolTablesClientListBySchemaResponse contains the response from method SQLPoolTablesClient.NewListBySchemaPager.
type SQLPoolTablesClientListBySchemaResponse struct {
	// A list of Sql pool tables.
	SQLPoolTableListResult
}

// SQLPoolTransparentDataEncryptionsClientCreateOrUpdateResponse contains the response from method SQLPoolTransparentDataEncryptionsClient.CreateOrUpdate.
type SQLPoolTransparentDataEncryptionsClientCreateOrUpdateResponse struct {
	// Represents a Sql pool transparent data encryption configuration.
	TransparentDataEncryption
}

// SQLPoolTransparentDataEncryptionsClientGetResponse contains the response from method SQLPoolTransparentDataEncryptionsClient.Get.
type SQLPoolTransparentDataEncryptionsClientGetResponse struct {
	// Represents a Sql pool transparent data encryption configuration.
	TransparentDataEncryption
}

// SQLPoolTransparentDataEncryptionsClientListResponse contains the response from method SQLPoolTransparentDataEncryptionsClient.NewListPager.
type SQLPoolTransparentDataEncryptionsClientListResponse struct {
	// A list of transparent data encryption configurations.
	TransparentDataEncryptionListResult
}

// SQLPoolUsagesClientListResponse contains the response from method SQLPoolUsagesClient.NewListPager.
type SQLPoolUsagesClientListResponse struct {
	// The response to a list Sql pool usages request.
	SQLPoolUsageListResult
}

// SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse contains the response from method SQLPoolVulnerabilityAssessmentRuleBaselinesClient.CreateOrUpdate.
type SQLPoolVulnerabilityAssessmentRuleBaselinesClientCreateOrUpdateResponse struct {
	// A Sql pool vulnerability assessment rule baseline.
	SQLPoolVulnerabilityAssessmentRuleBaseline
}

// SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse contains the response from method SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Delete.
type SQLPoolVulnerabilityAssessmentRuleBaselinesClientDeleteResponse struct {
	// placeholder for future response values
}

// SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse contains the response from method SQLPoolVulnerabilityAssessmentRuleBaselinesClient.Get.
type SQLPoolVulnerabilityAssessmentRuleBaselinesClientGetResponse struct {
	// A Sql pool vulnerability assessment rule baseline.
	SQLPoolVulnerabilityAssessmentRuleBaseline
}

// SQLPoolVulnerabilityAssessmentScansClientExportResponse contains the response from method SQLPoolVulnerabilityAssessmentScansClient.Export.
type SQLPoolVulnerabilityAssessmentScansClientExportResponse struct {
	// A Sql pool Vulnerability Assessment scan export resource.
	SQLPoolVulnerabilityAssessmentScansExport
}

// SQLPoolVulnerabilityAssessmentScansClientGetResponse contains the response from method SQLPoolVulnerabilityAssessmentScansClient.Get.
type SQLPoolVulnerabilityAssessmentScansClientGetResponse struct {
	// A vulnerability assessment scan record.
	VulnerabilityAssessmentScanRecord
}

// SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse contains the response from method SQLPoolVulnerabilityAssessmentScansClient.BeginInitiateScan.
type SQLPoolVulnerabilityAssessmentScansClientInitiateScanResponse struct {
	// placeholder for future response values
}

// SQLPoolVulnerabilityAssessmentScansClientListResponse contains the response from method SQLPoolVulnerabilityAssessmentScansClient.NewListPager.
type SQLPoolVulnerabilityAssessmentScansClientListResponse struct {
	// A list of vulnerability assessment scan records.
	VulnerabilityAssessmentScanRecordListResult
}

// SQLPoolVulnerabilityAssessmentsClientCreateOrUpdateResponse contains the response from method SQLPoolVulnerabilityAssessmentsClient.CreateOrUpdate.
type SQLPoolVulnerabilityAssessmentsClientCreateOrUpdateResponse struct {
	// A Sql pool vulnerability assessment.
	SQLPoolVulnerabilityAssessment
}

// SQLPoolVulnerabilityAssessmentsClientDeleteResponse contains the response from method SQLPoolVulnerabilityAssessmentsClient.Delete.
type SQLPoolVulnerabilityAssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// SQLPoolVulnerabilityAssessmentsClientGetResponse contains the response from method SQLPoolVulnerabilityAssessmentsClient.Get.
type SQLPoolVulnerabilityAssessmentsClientGetResponse struct {
	// A Sql pool vulnerability assessment.
	SQLPoolVulnerabilityAssessment
}

// SQLPoolVulnerabilityAssessmentsClientListResponse contains the response from method SQLPoolVulnerabilityAssessmentsClient.NewListPager.
type SQLPoolVulnerabilityAssessmentsClientListResponse struct {
	// A list of the Sql pool's vulnerability assessments.
	SQLPoolVulnerabilityAssessmentListResult
}

// SQLPoolWorkloadClassifierClientCreateOrUpdateResponse contains the response from method SQLPoolWorkloadClassifierClient.BeginCreateOrUpdate.
type SQLPoolWorkloadClassifierClientCreateOrUpdateResponse struct {
	// Workload classifier operations for a data warehouse
	WorkloadClassifier
}

// SQLPoolWorkloadClassifierClientDeleteResponse contains the response from method SQLPoolWorkloadClassifierClient.BeginDelete.
type SQLPoolWorkloadClassifierClientDeleteResponse struct {
	// placeholder for future response values
}

// SQLPoolWorkloadClassifierClientGetResponse contains the response from method SQLPoolWorkloadClassifierClient.Get.
type SQLPoolWorkloadClassifierClientGetResponse struct {
	// Workload classifier operations for a data warehouse
	WorkloadClassifier
}

// SQLPoolWorkloadClassifierClientListResponse contains the response from method SQLPoolWorkloadClassifierClient.NewListPager.
type SQLPoolWorkloadClassifierClientListResponse struct {
	// A list of workload classifiers for a workload group.
	WorkloadClassifierListResult
}

// SQLPoolWorkloadGroupClientCreateOrUpdateResponse contains the response from method SQLPoolWorkloadGroupClient.BeginCreateOrUpdate.
type SQLPoolWorkloadGroupClientCreateOrUpdateResponse struct {
	// Workload group operations for a sql pool
	WorkloadGroup
}

// SQLPoolWorkloadGroupClientDeleteResponse contains the response from method SQLPoolWorkloadGroupClient.BeginDelete.
type SQLPoolWorkloadGroupClientDeleteResponse struct {
	// placeholder for future response values
}

// SQLPoolWorkloadGroupClientGetResponse contains the response from method SQLPoolWorkloadGroupClient.Get.
type SQLPoolWorkloadGroupClientGetResponse struct {
	// Workload group operations for a sql pool
	WorkloadGroup
}

// SQLPoolWorkloadGroupClientListResponse contains the response from method SQLPoolWorkloadGroupClient.NewListPager.
type SQLPoolWorkloadGroupClientListResponse struct {
	// A list of workload groups.
	WorkloadGroupListResult
}

// SQLPoolsClientCreateResponse contains the response from method SQLPoolsClient.BeginCreate.
type SQLPoolsClientCreateResponse struct {
	// A SQL Analytics pool
	SQLPool
}

// SQLPoolsClientDeleteResponse contains the response from method SQLPoolsClient.BeginDelete.
type SQLPoolsClientDeleteResponse struct {
	// A SQL Analytics pool
	SQLPool
}

// SQLPoolsClientGetResponse contains the response from method SQLPoolsClient.Get.
type SQLPoolsClientGetResponse struct {
	// A SQL Analytics pool
	SQLPool
}

// SQLPoolsClientListByWorkspaceResponse contains the response from method SQLPoolsClient.NewListByWorkspacePager.
type SQLPoolsClientListByWorkspaceResponse struct {
	// List of SQL pools
	SQLPoolInfoListResult
}

// SQLPoolsClientPauseResponse contains the response from method SQLPoolsClient.BeginPause.
type SQLPoolsClientPauseResponse struct {
	// A SQL Analytics pool
	SQLPool
}

// SQLPoolsClientRenameResponse contains the response from method SQLPoolsClient.Rename.
type SQLPoolsClientRenameResponse struct {
	// placeholder for future response values
}

// SQLPoolsClientResumeResponse contains the response from method SQLPoolsClient.BeginResume.
type SQLPoolsClientResumeResponse struct {
	// A SQL Analytics pool
	SQLPool
}

// SQLPoolsClientUpdateResponse contains the response from method SQLPoolsClient.BeginUpdate.
type SQLPoolsClientUpdateResponse struct {
	// A SQL Analytics pool
	SQLPool
}

// SparkConfigurationClientGetResponse contains the response from method SparkConfigurationClient.Get.
type SparkConfigurationClientGetResponse struct {
	// SparkConfiguration response details
	SparkConfigurationResource
}

// SparkConfigurationsClientListByWorkspaceResponse contains the response from method SparkConfigurationsClient.NewListByWorkspacePager.
type SparkConfigurationsClientListByWorkspaceResponse struct {
	// A list of SparkConfiguration resources.
	SparkConfigurationListResponse
}

// WorkspaceAADAdminsClientCreateOrUpdateResponse contains the response from method WorkspaceAADAdminsClient.BeginCreateOrUpdate.
type WorkspaceAADAdminsClientCreateOrUpdateResponse struct {
	// Workspace active directory administrator
	WorkspaceAADAdminInfo
}

// WorkspaceAADAdminsClientDeleteResponse contains the response from method WorkspaceAADAdminsClient.BeginDelete.
type WorkspaceAADAdminsClientDeleteResponse struct {
	// placeholder for future response values
}

// WorkspaceAADAdminsClientGetResponse contains the response from method WorkspaceAADAdminsClient.Get.
type WorkspaceAADAdminsClientGetResponse struct {
	// Workspace active directory administrator
	WorkspaceAADAdminInfo
}

// WorkspaceManagedIdentitySQLControlSettingsClientCreateOrUpdateResponse contains the response from method WorkspaceManagedIdentitySQLControlSettingsClient.BeginCreateOrUpdate.
type WorkspaceManagedIdentitySQLControlSettingsClientCreateOrUpdateResponse struct {
	// Sql Control Settings for workspace managed identity
	ManagedIdentitySQLControlSettingsModel
}

// WorkspaceManagedIdentitySQLControlSettingsClientGetResponse contains the response from method WorkspaceManagedIdentitySQLControlSettingsClient.Get.
type WorkspaceManagedIdentitySQLControlSettingsClientGetResponse struct {
	// Sql Control Settings for workspace managed identity
	ManagedIdentitySQLControlSettingsModel
}

// WorkspaceManagedSQLServerBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method WorkspaceManagedSQLServerBlobAuditingPoliciesClient.BeginCreateOrUpdate.
type WorkspaceManagedSQLServerBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// A server blob auditing policy.
	ServerBlobAuditingPolicy
}

// WorkspaceManagedSQLServerBlobAuditingPoliciesClientGetResponse contains the response from method WorkspaceManagedSQLServerBlobAuditingPoliciesClient.Get.
type WorkspaceManagedSQLServerBlobAuditingPoliciesClientGetResponse struct {
	// A server blob auditing policy.
	ServerBlobAuditingPolicy
}

// WorkspaceManagedSQLServerBlobAuditingPoliciesClientListByWorkspaceResponse contains the response from method WorkspaceManagedSQLServerBlobAuditingPoliciesClient.NewListByWorkspacePager.
type WorkspaceManagedSQLServerBlobAuditingPoliciesClientListByWorkspaceResponse struct {
	// A list of server auditing settings.
	ServerBlobAuditingPolicyListResult
}

// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse contains the response from method WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.Get.
type WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientGetResponse struct {
	// Dedicated Sql Minimal Tls Settings Info
	DedicatedSQLminimalTLSSettings
}

// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse contains the response from method WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.NewListPager.
type WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientListResponse struct {
	// A list of the server's dedicated sql minimal tls settings.
	DedicatedSQLminimalTLSSettingsListResult
}

// WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientUpdateResponse contains the response from method WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClient.BeginUpdate.
type WorkspaceManagedSQLServerDedicatedSQLMinimalTLSSettingsClientUpdateResponse struct {
	// Dedicated Sql Minimal Tls Settings Info
	DedicatedSQLminimalTLSSettings
}

// WorkspaceManagedSQLServerEncryptionProtectorClientCreateOrUpdateResponse contains the response from method WorkspaceManagedSQLServerEncryptionProtectorClient.BeginCreateOrUpdate.
type WorkspaceManagedSQLServerEncryptionProtectorClientCreateOrUpdateResponse struct {
	// The server encryption protector.
	EncryptionProtector
}

// WorkspaceManagedSQLServerEncryptionProtectorClientGetResponse contains the response from method WorkspaceManagedSQLServerEncryptionProtectorClient.Get.
type WorkspaceManagedSQLServerEncryptionProtectorClientGetResponse struct {
	// The server encryption protector.
	EncryptionProtector
}

// WorkspaceManagedSQLServerEncryptionProtectorClientListResponse contains the response from method WorkspaceManagedSQLServerEncryptionProtectorClient.NewListPager.
type WorkspaceManagedSQLServerEncryptionProtectorClientListResponse struct {
	// A list of server encryption protectors.
	EncryptionProtectorListResult
}

// WorkspaceManagedSQLServerEncryptionProtectorClientRevalidateResponse contains the response from method WorkspaceManagedSQLServerEncryptionProtectorClient.BeginRevalidate.
type WorkspaceManagedSQLServerEncryptionProtectorClientRevalidateResponse struct {
	// placeholder for future response values
}

// WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientCreateOrUpdateResponse contains the response from method WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient.BeginCreateOrUpdate.
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientCreateOrUpdateResponse struct {
	// An extended server blob auditing policy.
	ExtendedServerBlobAuditingPolicy
}

// WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientGetResponse contains the response from method WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient.Get.
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientGetResponse struct {
	// An extended server blob auditing policy.
	ExtendedServerBlobAuditingPolicy
}

// WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientListByWorkspaceResponse contains the response from method WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClient.NewListByWorkspacePager.
type WorkspaceManagedSQLServerExtendedBlobAuditingPoliciesClientListByWorkspaceResponse struct {
	// A list of server extended auditing settings.
	ExtendedServerBlobAuditingPolicyListResult
}

// WorkspaceManagedSQLServerRecoverableSQLPoolsClientGetResponse contains the response from method WorkspaceManagedSQLServerRecoverableSQLPoolsClient.Get.
type WorkspaceManagedSQLServerRecoverableSQLPoolsClientGetResponse struct {
	// A recoverable sql pool
	RecoverableSQLPool
}

// WorkspaceManagedSQLServerRecoverableSQLPoolsClientListResponse contains the response from method WorkspaceManagedSQLServerRecoverableSQLPoolsClient.NewListPager.
type WorkspaceManagedSQLServerRecoverableSQLPoolsClientListResponse struct {
	// The response to a list recoverable sql pools request
	RecoverableSQLPoolListResult
}

// WorkspaceManagedSQLServerSecurityAlertPolicyClientCreateOrUpdateResponse contains the response from method WorkspaceManagedSQLServerSecurityAlertPolicyClient.BeginCreateOrUpdate.
type WorkspaceManagedSQLServerSecurityAlertPolicyClientCreateOrUpdateResponse struct {
	// Workspace managed Sql server security alert policy.
	ServerSecurityAlertPolicy
}

// WorkspaceManagedSQLServerSecurityAlertPolicyClientGetResponse contains the response from method WorkspaceManagedSQLServerSecurityAlertPolicyClient.Get.
type WorkspaceManagedSQLServerSecurityAlertPolicyClientGetResponse struct {
	// Workspace managed Sql server security alert policy.
	ServerSecurityAlertPolicy
}

// WorkspaceManagedSQLServerSecurityAlertPolicyClientListResponse contains the response from method WorkspaceManagedSQLServerSecurityAlertPolicyClient.NewListPager.
type WorkspaceManagedSQLServerSecurityAlertPolicyClientListResponse struct {
	// A list of the workspace managed sql server's security alert policies.
	ServerSecurityAlertPolicyListResult
}

// WorkspaceManagedSQLServerUsagesClientListResponse contains the response from method WorkspaceManagedSQLServerUsagesClient.NewListPager.
type WorkspaceManagedSQLServerUsagesClientListResponse struct {
	// Represents the response to a list server metrics request.
	ServerUsageListResult
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse contains the response from method WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.CreateOrUpdate.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientCreateOrUpdateResponse struct {
	// A server vulnerability assessment.
	ServerVulnerabilityAssessment
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteResponse contains the response from method WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Delete.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse contains the response from method WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.Get.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientGetResponse struct {
	// A server vulnerability assessment.
	ServerVulnerabilityAssessment
}

// WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse contains the response from method WorkspaceManagedSQLServerVulnerabilityAssessmentsClient.NewListPager.
type WorkspaceManagedSQLServerVulnerabilityAssessmentsClientListResponse struct {
	// A list of the server's vulnerability assessments.
	ServerVulnerabilityAssessmentListResult
}

// WorkspaceSQLAADAdminsClientCreateOrUpdateResponse contains the response from method WorkspaceSQLAADAdminsClient.BeginCreateOrUpdate.
type WorkspaceSQLAADAdminsClientCreateOrUpdateResponse struct {
	// Workspace active directory administrator
	WorkspaceAADAdminInfo
}

// WorkspaceSQLAADAdminsClientDeleteResponse contains the response from method WorkspaceSQLAADAdminsClient.BeginDelete.
type WorkspaceSQLAADAdminsClientDeleteResponse struct {
	// placeholder for future response values
}

// WorkspaceSQLAADAdminsClientGetResponse contains the response from method WorkspaceSQLAADAdminsClient.Get.
type WorkspaceSQLAADAdminsClientGetResponse struct {
	// Workspace active directory administrator
	WorkspaceAADAdminInfo
}

// WorkspacesClientCreateOrUpdateResponse contains the response from method WorkspacesClient.BeginCreateOrUpdate.
type WorkspacesClientCreateOrUpdateResponse struct {
	// A workspace
	Workspace
}

// WorkspacesClientDeleteResponse contains the response from method WorkspacesClient.BeginDelete.
type WorkspacesClientDeleteResponse struct {
	// A workspace
	Workspace
}

// WorkspacesClientGetResponse contains the response from method WorkspacesClient.Get.
type WorkspacesClientGetResponse struct {
	// A workspace
	Workspace
}

// WorkspacesClientListByResourceGroupResponse contains the response from method WorkspacesClient.NewListByResourceGroupPager.
type WorkspacesClientListByResourceGroupResponse struct {
	// List of workspaces
	WorkspaceInfoListResult
}

// WorkspacesClientListResponse contains the response from method WorkspacesClient.NewListPager.
type WorkspacesClientListResponse struct {
	// List of workspaces
	WorkspaceInfoListResult
}

// WorkspacesClientUpdateResponse contains the response from method WorkspacesClient.BeginUpdate.
type WorkspacesClientUpdateResponse struct {
	// A workspace
	Workspace
}
