// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/devtools/testing/v1/test_environment_discovery.proto

package testing

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Whether the device is physical or virtual.
type DeviceForm int32

const (
	// Do not use.  For proto versioning only.
	DeviceForm_DEVICE_FORM_UNSPECIFIED DeviceForm = 0
	// Android virtual device using Compute Engine native virtualization. Firebase
	// Test Lab only.
	DeviceForm_VIRTUAL DeviceForm = 1
	// Actual hardware.
	DeviceForm_PHYSICAL DeviceForm = 2
	// Android virtual device using emulator in nested virtualization. Equivalent
	// to Android Studio.
	DeviceForm_EMULATOR DeviceForm = 3
)

// Enum value maps for DeviceForm.
var (
	DeviceForm_name = map[int32]string{
		0: "DEVICE_FORM_UNSPECIFIED",
		1: "VIRTUAL",
		2: "PHYSICAL",
		3: "EMULATOR",
	}
	DeviceForm_value = map[string]int32{
		"DEVICE_FORM_UNSPECIFIED": 0,
		"VIRTUAL":                 1,
		"PHYSICAL":                2,
		"EMULATOR":                3,
	}
)

func (x DeviceForm) Enum() *DeviceForm {
	p := new(DeviceForm)
	*p = x
	return p
}

func (x DeviceForm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeviceForm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes[0].Descriptor()
}

func (DeviceForm) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes[0]
}

func (x DeviceForm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeviceForm.Descriptor instead.
func (DeviceForm) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{0}
}

// The form factor of a device.
type DeviceFormFactor int32

const (
	// Do not use. For proto versioning only.
	DeviceFormFactor_DEVICE_FORM_FACTOR_UNSPECIFIED DeviceFormFactor = 0
	// This device has the shape of a phone.
	DeviceFormFactor_PHONE DeviceFormFactor = 1
	// This device has the shape of a tablet.
	DeviceFormFactor_TABLET DeviceFormFactor = 2
	// This device has the shape of a watch or other wearable.
	DeviceFormFactor_WEARABLE DeviceFormFactor = 3
)

// Enum value maps for DeviceFormFactor.
var (
	DeviceFormFactor_name = map[int32]string{
		0: "DEVICE_FORM_FACTOR_UNSPECIFIED",
		1: "PHONE",
		2: "TABLET",
		3: "WEARABLE",
	}
	DeviceFormFactor_value = map[string]int32{
		"DEVICE_FORM_FACTOR_UNSPECIFIED": 0,
		"PHONE":                          1,
		"TABLET":                         2,
		"WEARABLE":                       3,
	}
)

func (x DeviceFormFactor) Enum() *DeviceFormFactor {
	p := new(DeviceFormFactor)
	*p = x
	return p
}

func (x DeviceFormFactor) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeviceFormFactor) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes[1].Descriptor()
}

func (DeviceFormFactor) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes[1]
}

func (x DeviceFormFactor) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeviceFormFactor.Descriptor instead.
func (DeviceFormFactor) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{1}
}

// Types of environments the Test API supports.
type GetTestEnvironmentCatalogRequest_EnvironmentType int32

const (
	// Do not use.  For proto versioning only.
	GetTestEnvironmentCatalogRequest_ENVIRONMENT_TYPE_UNSPECIFIED GetTestEnvironmentCatalogRequest_EnvironmentType = 0
	// A device running a version of the Android OS.
	GetTestEnvironmentCatalogRequest_ANDROID GetTestEnvironmentCatalogRequest_EnvironmentType = 1
	// A device running a version of iOS.
	GetTestEnvironmentCatalogRequest_IOS GetTestEnvironmentCatalogRequest_EnvironmentType = 3
	// A network configuration to use when running a test.
	GetTestEnvironmentCatalogRequest_NETWORK_CONFIGURATION GetTestEnvironmentCatalogRequest_EnvironmentType = 4
	// The software environment provided by TestExecutionService.
	GetTestEnvironmentCatalogRequest_PROVIDED_SOFTWARE GetTestEnvironmentCatalogRequest_EnvironmentType = 5
	// The IP blocks used by devices in the test environment.
	GetTestEnvironmentCatalogRequest_DEVICE_IP_BLOCKS GetTestEnvironmentCatalogRequest_EnvironmentType = 6
)

// Enum value maps for GetTestEnvironmentCatalogRequest_EnvironmentType.
var (
	GetTestEnvironmentCatalogRequest_EnvironmentType_name = map[int32]string{
		0: "ENVIRONMENT_TYPE_UNSPECIFIED",
		1: "ANDROID",
		3: "IOS",
		4: "NETWORK_CONFIGURATION",
		5: "PROVIDED_SOFTWARE",
		6: "DEVICE_IP_BLOCKS",
	}
	GetTestEnvironmentCatalogRequest_EnvironmentType_value = map[string]int32{
		"ENVIRONMENT_TYPE_UNSPECIFIED": 0,
		"ANDROID":                      1,
		"IOS":                          3,
		"NETWORK_CONFIGURATION":        4,
		"PROVIDED_SOFTWARE":            5,
		"DEVICE_IP_BLOCKS":             6,
	}
)

func (x GetTestEnvironmentCatalogRequest_EnvironmentType) Enum() *GetTestEnvironmentCatalogRequest_EnvironmentType {
	p := new(GetTestEnvironmentCatalogRequest_EnvironmentType)
	*p = x
	return p
}

func (x GetTestEnvironmentCatalogRequest_EnvironmentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetTestEnvironmentCatalogRequest_EnvironmentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes[2].Descriptor()
}

func (GetTestEnvironmentCatalogRequest_EnvironmentType) Type() protoreflect.EnumType {
	return &file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes[2]
}

func (x GetTestEnvironmentCatalogRequest_EnvironmentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetTestEnvironmentCatalogRequest_EnvironmentType.Descriptor instead.
func (GetTestEnvironmentCatalogRequest_EnvironmentType) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{1, 0}
}

// A single device IP block
type DeviceIpBlock struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An IP address block in CIDR notation eg: 34.68.194.64/29
	Block string `protobuf:"bytes,1,opt,name=block,proto3" json:"block,omitempty"`
	// Whether this block is used by physical or virtual devices
	Form DeviceForm `protobuf:"varint,2,opt,name=form,proto3,enum=google.devtools.testing.v1.DeviceForm" json:"form,omitempty"`
	// The date this block was added to Firebase Test Lab
	AddedDate *date.Date `protobuf:"bytes,3,opt,name=added_date,json=addedDate,proto3" json:"added_date,omitempty"`
}

func (x *DeviceIpBlock) Reset() {
	*x = DeviceIpBlock{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceIpBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceIpBlock) ProtoMessage() {}

func (x *DeviceIpBlock) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceIpBlock.ProtoReflect.Descriptor instead.
func (*DeviceIpBlock) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{0}
}

func (x *DeviceIpBlock) GetBlock() string {
	if x != nil {
		return x.Block
	}
	return ""
}

func (x *DeviceIpBlock) GetForm() DeviceForm {
	if x != nil {
		return x.Form
	}
	return DeviceForm_DEVICE_FORM_UNSPECIFIED
}

func (x *DeviceIpBlock) GetAddedDate() *date.Date {
	if x != nil {
		return x.AddedDate
	}
	return nil
}

// Request to list the currently supported values for an environment type.
type GetTestEnvironmentCatalogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of environment that should be listed.
	EnvironmentType GetTestEnvironmentCatalogRequest_EnvironmentType `protobuf:"varint,1,opt,name=environment_type,json=environmentType,proto3,enum=google.devtools.testing.v1.GetTestEnvironmentCatalogRequest_EnvironmentType" json:"environment_type,omitempty"`
	// For authorization, the cloud project requesting the TestEnvironmentCatalog.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
}

func (x *GetTestEnvironmentCatalogRequest) Reset() {
	*x = GetTestEnvironmentCatalogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTestEnvironmentCatalogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTestEnvironmentCatalogRequest) ProtoMessage() {}

func (x *GetTestEnvironmentCatalogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTestEnvironmentCatalogRequest.ProtoReflect.Descriptor instead.
func (*GetTestEnvironmentCatalogRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{1}
}

func (x *GetTestEnvironmentCatalogRequest) GetEnvironmentType() GetTestEnvironmentCatalogRequest_EnvironmentType {
	if x != nil {
		return x.EnvironmentType
	}
	return GetTestEnvironmentCatalogRequest_ENVIRONMENT_TYPE_UNSPECIFIED
}

func (x *GetTestEnvironmentCatalogRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

// A description of a test environment.
type TestEnvironmentCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only.
	//
	// Types that are assignable to EnvironmentCatalog:
	//	*TestEnvironmentCatalog_AndroidDeviceCatalog
	//	*TestEnvironmentCatalog_IosDeviceCatalog
	//	*TestEnvironmentCatalog_NetworkConfigurationCatalog
	//	*TestEnvironmentCatalog_SoftwareCatalog
	//	*TestEnvironmentCatalog_DeviceIpBlockCatalog
	EnvironmentCatalog isTestEnvironmentCatalog_EnvironmentCatalog `protobuf_oneof:"environment_catalog"`
}

func (x *TestEnvironmentCatalog) Reset() {
	*x = TestEnvironmentCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestEnvironmentCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestEnvironmentCatalog) ProtoMessage() {}

func (x *TestEnvironmentCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestEnvironmentCatalog.ProtoReflect.Descriptor instead.
func (*TestEnvironmentCatalog) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{2}
}

func (m *TestEnvironmentCatalog) GetEnvironmentCatalog() isTestEnvironmentCatalog_EnvironmentCatalog {
	if m != nil {
		return m.EnvironmentCatalog
	}
	return nil
}

func (x *TestEnvironmentCatalog) GetAndroidDeviceCatalog() *AndroidDeviceCatalog {
	if x, ok := x.GetEnvironmentCatalog().(*TestEnvironmentCatalog_AndroidDeviceCatalog); ok {
		return x.AndroidDeviceCatalog
	}
	return nil
}

func (x *TestEnvironmentCatalog) GetIosDeviceCatalog() *IosDeviceCatalog {
	if x, ok := x.GetEnvironmentCatalog().(*TestEnvironmentCatalog_IosDeviceCatalog); ok {
		return x.IosDeviceCatalog
	}
	return nil
}

func (x *TestEnvironmentCatalog) GetNetworkConfigurationCatalog() *NetworkConfigurationCatalog {
	if x, ok := x.GetEnvironmentCatalog().(*TestEnvironmentCatalog_NetworkConfigurationCatalog); ok {
		return x.NetworkConfigurationCatalog
	}
	return nil
}

func (x *TestEnvironmentCatalog) GetSoftwareCatalog() *ProvidedSoftwareCatalog {
	if x, ok := x.GetEnvironmentCatalog().(*TestEnvironmentCatalog_SoftwareCatalog); ok {
		return x.SoftwareCatalog
	}
	return nil
}

func (x *TestEnvironmentCatalog) GetDeviceIpBlockCatalog() *DeviceIpBlockCatalog {
	if x, ok := x.GetEnvironmentCatalog().(*TestEnvironmentCatalog_DeviceIpBlockCatalog); ok {
		return x.DeviceIpBlockCatalog
	}
	return nil
}

type isTestEnvironmentCatalog_EnvironmentCatalog interface {
	isTestEnvironmentCatalog_EnvironmentCatalog()
}

type TestEnvironmentCatalog_AndroidDeviceCatalog struct {
	// Supported Android devices.
	AndroidDeviceCatalog *AndroidDeviceCatalog `protobuf:"bytes,1,opt,name=android_device_catalog,json=androidDeviceCatalog,proto3,oneof"`
}

type TestEnvironmentCatalog_IosDeviceCatalog struct {
	// Supported iOS devices.
	IosDeviceCatalog *IosDeviceCatalog `protobuf:"bytes,3,opt,name=ios_device_catalog,json=iosDeviceCatalog,proto3,oneof"`
}

type TestEnvironmentCatalog_NetworkConfigurationCatalog struct {
	// Supported network configurations.
	NetworkConfigurationCatalog *NetworkConfigurationCatalog `protobuf:"bytes,4,opt,name=network_configuration_catalog,json=networkConfigurationCatalog,proto3,oneof"`
}

type TestEnvironmentCatalog_SoftwareCatalog struct {
	// The software test environment provided by TestExecutionService.
	SoftwareCatalog *ProvidedSoftwareCatalog `protobuf:"bytes,5,opt,name=software_catalog,json=softwareCatalog,proto3,oneof"`
}

type TestEnvironmentCatalog_DeviceIpBlockCatalog struct {
	// The IP blocks used by devices in the test environment.
	DeviceIpBlockCatalog *DeviceIpBlockCatalog `protobuf:"bytes,6,opt,name=device_ip_block_catalog,json=deviceIpBlockCatalog,proto3,oneof"`
}

func (*TestEnvironmentCatalog_AndroidDeviceCatalog) isTestEnvironmentCatalog_EnvironmentCatalog() {}

func (*TestEnvironmentCatalog_IosDeviceCatalog) isTestEnvironmentCatalog_EnvironmentCatalog() {}

func (*TestEnvironmentCatalog_NetworkConfigurationCatalog) isTestEnvironmentCatalog_EnvironmentCatalog() {
}

func (*TestEnvironmentCatalog_SoftwareCatalog) isTestEnvironmentCatalog_EnvironmentCatalog() {}

func (*TestEnvironmentCatalog_DeviceIpBlockCatalog) isTestEnvironmentCatalog_EnvironmentCatalog() {}

// List of IP blocks used by the Firebase Test Lab
type DeviceIpBlockCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The device IP blocks used by Firebase Test Lab
	IpBlocks []*DeviceIpBlock `protobuf:"bytes,1,rep,name=ip_blocks,json=ipBlocks,proto3" json:"ip_blocks,omitempty"`
}

func (x *DeviceIpBlockCatalog) Reset() {
	*x = DeviceIpBlockCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeviceIpBlockCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceIpBlockCatalog) ProtoMessage() {}

func (x *DeviceIpBlockCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceIpBlockCatalog.ProtoReflect.Descriptor instead.
func (*DeviceIpBlockCatalog) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{3}
}

func (x *DeviceIpBlockCatalog) GetIpBlocks() []*DeviceIpBlock {
	if x != nil {
		return x.IpBlocks
	}
	return nil
}

// The currently supported Android devices.
type AndroidDeviceCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of supported Android device models.
	Models []*AndroidModel `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// The set of supported Android OS versions.
	Versions []*AndroidVersion `protobuf:"bytes,2,rep,name=versions,proto3" json:"versions,omitempty"`
	// The set of supported runtime configurations.
	RuntimeConfiguration *AndroidRuntimeConfiguration `protobuf:"bytes,3,opt,name=runtime_configuration,json=runtimeConfiguration,proto3" json:"runtime_configuration,omitempty"`
}

func (x *AndroidDeviceCatalog) Reset() {
	*x = AndroidDeviceCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidDeviceCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidDeviceCatalog) ProtoMessage() {}

func (x *AndroidDeviceCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidDeviceCatalog.ProtoReflect.Descriptor instead.
func (*AndroidDeviceCatalog) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{4}
}

func (x *AndroidDeviceCatalog) GetModels() []*AndroidModel {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *AndroidDeviceCatalog) GetVersions() []*AndroidVersion {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *AndroidDeviceCatalog) GetRuntimeConfiguration() *AndroidRuntimeConfiguration {
	if x != nil {
		return x.RuntimeConfiguration
	}
	return nil
}

// Android configuration that can be selected at the time a test is run.
type AndroidRuntimeConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of available locales.
	Locales []*Locale `protobuf:"bytes,1,rep,name=locales,proto3" json:"locales,omitempty"`
	// The set of available orientations.
	Orientations []*Orientation `protobuf:"bytes,2,rep,name=orientations,proto3" json:"orientations,omitempty"`
}

func (x *AndroidRuntimeConfiguration) Reset() {
	*x = AndroidRuntimeConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidRuntimeConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidRuntimeConfiguration) ProtoMessage() {}

func (x *AndroidRuntimeConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidRuntimeConfiguration.ProtoReflect.Descriptor instead.
func (*AndroidRuntimeConfiguration) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{5}
}

func (x *AndroidRuntimeConfiguration) GetLocales() []*Locale {
	if x != nil {
		return x.Locales
	}
	return nil
}

func (x *AndroidRuntimeConfiguration) GetOrientations() []*Orientation {
	if x != nil {
		return x.Orientations
	}
	return nil
}

// A description of an Android device tests may be run on.
type AndroidModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique opaque id for this model.
	// Use this for invoking the TestExecutionService.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The human-readable marketing name for this device model.
	// Examples: "Nexus 5", "Galaxy S5".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The manufacturer of this device.
	Manufacturer string `protobuf:"bytes,3,opt,name=manufacturer,proto3" json:"manufacturer,omitempty"`
	// The company that this device is branded with.
	// Example: "Google", "Samsung".
	Brand string `protobuf:"bytes,9,opt,name=brand,proto3" json:"brand,omitempty"`
	// The name of the industrial design.
	// This corresponds to android.os.Build.DEVICE.
	Codename string `protobuf:"bytes,10,opt,name=codename,proto3" json:"codename,omitempty"`
	// Whether this device is virtual or physical.
	Form DeviceForm `protobuf:"varint,4,opt,name=form,proto3,enum=google.devtools.testing.v1.DeviceForm" json:"form,omitempty"`
	// Whether this device is a phone, tablet, wearable, etc.
	FormFactor DeviceFormFactor `protobuf:"varint,16,opt,name=form_factor,json=formFactor,proto3,enum=google.devtools.testing.v1.DeviceFormFactor" json:"form_factor,omitempty"`
	// Screen size in the horizontal (X) dimension measured in pixels.
	ScreenX int32 `protobuf:"varint,5,opt,name=screen_x,json=screenX,proto3" json:"screen_x,omitempty"`
	// Screen size in the vertical (Y) dimension measured in pixels.
	ScreenY int32 `protobuf:"varint,6,opt,name=screen_y,json=screenY,proto3" json:"screen_y,omitempty"`
	// Screen density in DPI.
	// This corresponds to ro.sf.lcd_density
	ScreenDensity int32 `protobuf:"varint,12,opt,name=screen_density,json=screenDensity,proto3" json:"screen_density,omitempty"`
	// True if and only if tests with this model are recorded by stitching
	// together screenshots. See use_low_spec_video_recording in device config.
	LowFpsVideoRecording bool `protobuf:"varint,17,opt,name=low_fps_video_recording,json=lowFpsVideoRecording,proto3" json:"low_fps_video_recording,omitempty"`
	// The set of Android versions this device supports.
	SupportedVersionIds []string `protobuf:"bytes,7,rep,name=supported_version_ids,json=supportedVersionIds,proto3" json:"supported_version_ids,omitempty"`
	// The list of supported ABIs for this device.
	// This corresponds to either android.os.Build.SUPPORTED_ABIS (for API level
	// 21 and above) or android.os.Build.CPU_ABI/CPU_ABI2.
	// The most preferred ABI is the first element in the list.
	//
	// Elements are optionally prefixed by "version_id:" (where version_id is
	// the id of an AndroidVersion), denoting an ABI that is supported only on
	// a particular version.
	SupportedAbis []string `protobuf:"bytes,11,rep,name=supported_abis,json=supportedAbis,proto3" json:"supported_abis,omitempty"`
	// Tags for this dimension.
	// Examples: "default", "preview", "deprecated".
	Tags []string `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// URL of a thumbnail image (photo) of the device.
	// e.g. https://lh3.googleusercontent.com/90WcauuJiCYABEl8U0lcZeuS5STUbf2yW...
	ThumbnailUrl string `protobuf:"bytes,19,opt,name=thumbnail_url,json=thumbnailUrl,proto3" json:"thumbnail_url,omitempty"`
}

func (x *AndroidModel) Reset() {
	*x = AndroidModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidModel) ProtoMessage() {}

func (x *AndroidModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidModel.ProtoReflect.Descriptor instead.
func (*AndroidModel) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{6}
}

func (x *AndroidModel) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AndroidModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AndroidModel) GetManufacturer() string {
	if x != nil {
		return x.Manufacturer
	}
	return ""
}

func (x *AndroidModel) GetBrand() string {
	if x != nil {
		return x.Brand
	}
	return ""
}

func (x *AndroidModel) GetCodename() string {
	if x != nil {
		return x.Codename
	}
	return ""
}

func (x *AndroidModel) GetForm() DeviceForm {
	if x != nil {
		return x.Form
	}
	return DeviceForm_DEVICE_FORM_UNSPECIFIED
}

func (x *AndroidModel) GetFormFactor() DeviceFormFactor {
	if x != nil {
		return x.FormFactor
	}
	return DeviceFormFactor_DEVICE_FORM_FACTOR_UNSPECIFIED
}

func (x *AndroidModel) GetScreenX() int32 {
	if x != nil {
		return x.ScreenX
	}
	return 0
}

func (x *AndroidModel) GetScreenY() int32 {
	if x != nil {
		return x.ScreenY
	}
	return 0
}

func (x *AndroidModel) GetScreenDensity() int32 {
	if x != nil {
		return x.ScreenDensity
	}
	return 0
}

func (x *AndroidModel) GetLowFpsVideoRecording() bool {
	if x != nil {
		return x.LowFpsVideoRecording
	}
	return false
}

func (x *AndroidModel) GetSupportedVersionIds() []string {
	if x != nil {
		return x.SupportedVersionIds
	}
	return nil
}

func (x *AndroidModel) GetSupportedAbis() []string {
	if x != nil {
		return x.SupportedAbis
	}
	return nil
}

func (x *AndroidModel) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AndroidModel) GetThumbnailUrl() string {
	if x != nil {
		return x.ThumbnailUrl
	}
	return ""
}

// A version of the Android OS.
type AndroidVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An opaque id for this Android version.
	// Use this id to invoke the TestExecutionService.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A string representing this version of the Android OS.
	// Examples: "4.3", "4.4".
	VersionString string `protobuf:"bytes,2,opt,name=version_string,json=versionString,proto3" json:"version_string,omitempty"`
	// The API level for this Android version.
	// Examples: 18, 19.
	ApiLevel int32 `protobuf:"varint,3,opt,name=api_level,json=apiLevel,proto3" json:"api_level,omitempty"`
	// The code name for this Android version.
	// Examples: "JellyBean", "KitKat".
	CodeName string `protobuf:"bytes,4,opt,name=code_name,json=codeName,proto3" json:"code_name,omitempty"`
	// The date this Android version became available in the market.
	ReleaseDate *date.Date `protobuf:"bytes,5,opt,name=release_date,json=releaseDate,proto3" json:"release_date,omitempty"`
	// Market share for this version.
	Distribution *Distribution `protobuf:"bytes,6,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// Tags for this dimension.
	// Examples: "default", "preview", "deprecated".
	Tags []string `protobuf:"bytes,7,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *AndroidVersion) Reset() {
	*x = AndroidVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidVersion) ProtoMessage() {}

func (x *AndroidVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidVersion.ProtoReflect.Descriptor instead.
func (*AndroidVersion) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{7}
}

func (x *AndroidVersion) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AndroidVersion) GetVersionString() string {
	if x != nil {
		return x.VersionString
	}
	return ""
}

func (x *AndroidVersion) GetApiLevel() int32 {
	if x != nil {
		return x.ApiLevel
	}
	return 0
}

func (x *AndroidVersion) GetCodeName() string {
	if x != nil {
		return x.CodeName
	}
	return ""
}

func (x *AndroidVersion) GetReleaseDate() *date.Date {
	if x != nil {
		return x.ReleaseDate
	}
	return nil
}

func (x *AndroidVersion) GetDistribution() *Distribution {
	if x != nil {
		return x.Distribution
	}
	return nil
}

func (x *AndroidVersion) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// Data about the relative number of devices running a
// given configuration of the Android platform.
type Distribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time this distribution was measured.
	MeasurementTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=measurement_time,json=measurementTime,proto3" json:"measurement_time,omitempty"`
	// Output only. The estimated fraction (0-1) of the total market with this
	// configuration.
	MarketShare float64 `protobuf:"fixed64,2,opt,name=market_share,json=marketShare,proto3" json:"market_share,omitempty"`
}

func (x *Distribution) Reset() {
	*x = Distribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Distribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Distribution) ProtoMessage() {}

func (x *Distribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Distribution.ProtoReflect.Descriptor instead.
func (*Distribution) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{8}
}

func (x *Distribution) GetMeasurementTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MeasurementTime
	}
	return nil
}

func (x *Distribution) GetMarketShare() float64 {
	if x != nil {
		return x.MarketShare
	}
	return 0
}

// The currently supported iOS devices.
type IosDeviceCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of supported iOS device models.
	Models []*IosModel `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// The set of supported iOS software versions.
	Versions []*IosVersion `protobuf:"bytes,2,rep,name=versions,proto3" json:"versions,omitempty"`
	// The set of supported Xcode versions.
	XcodeVersions []*XcodeVersion `protobuf:"bytes,4,rep,name=xcode_versions,json=xcodeVersions,proto3" json:"xcode_versions,omitempty"`
	// The set of supported runtime configurations.
	RuntimeConfiguration *IosRuntimeConfiguration `protobuf:"bytes,3,opt,name=runtime_configuration,json=runtimeConfiguration,proto3" json:"runtime_configuration,omitempty"`
}

func (x *IosDeviceCatalog) Reset() {
	*x = IosDeviceCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosDeviceCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosDeviceCatalog) ProtoMessage() {}

func (x *IosDeviceCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosDeviceCatalog.ProtoReflect.Descriptor instead.
func (*IosDeviceCatalog) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{9}
}

func (x *IosDeviceCatalog) GetModels() []*IosModel {
	if x != nil {
		return x.Models
	}
	return nil
}

func (x *IosDeviceCatalog) GetVersions() []*IosVersion {
	if x != nil {
		return x.Versions
	}
	return nil
}

func (x *IosDeviceCatalog) GetXcodeVersions() []*XcodeVersion {
	if x != nil {
		return x.XcodeVersions
	}
	return nil
}

func (x *IosDeviceCatalog) GetRuntimeConfiguration() *IosRuntimeConfiguration {
	if x != nil {
		return x.RuntimeConfiguration
	}
	return nil
}

// iOS configuration that can be selected at the time a test is run.
type IosRuntimeConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The set of available locales.
	Locales []*Locale `protobuf:"bytes,1,rep,name=locales,proto3" json:"locales,omitempty"`
	// The set of available orientations.
	Orientations []*Orientation `protobuf:"bytes,2,rep,name=orientations,proto3" json:"orientations,omitempty"`
}

func (x *IosRuntimeConfiguration) Reset() {
	*x = IosRuntimeConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosRuntimeConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosRuntimeConfiguration) ProtoMessage() {}

func (x *IosRuntimeConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosRuntimeConfiguration.ProtoReflect.Descriptor instead.
func (*IosRuntimeConfiguration) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{10}
}

func (x *IosRuntimeConfiguration) GetLocales() []*Locale {
	if x != nil {
		return x.Locales
	}
	return nil
}

func (x *IosRuntimeConfiguration) GetOrientations() []*Orientation {
	if x != nil {
		return x.Orientations
	}
	return nil
}

// A description of an iOS device tests may be run on.
type IosModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique opaque id for this model.
	// Use this for invoking the TestExecutionService.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The human-readable name for this device model.
	// Examples: "iPhone 4s", "iPad Mini 2".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The set of iOS major software versions this device supports.
	SupportedVersionIds []string `protobuf:"bytes,3,rep,name=supported_version_ids,json=supportedVersionIds,proto3" json:"supported_version_ids,omitempty"`
	// Tags for this dimension.
	// Examples: "default", "preview", "deprecated".
	Tags []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// Device capabilities.
	// Copied from
	// https://developer.apple.com/library/archive/documentation/DeviceInformation/Reference/iOSDeviceCompatibility/DeviceCompatibilityMatrix/DeviceCompatibilityMatrix.html
	DeviceCapabilities []string `protobuf:"bytes,5,rep,name=device_capabilities,json=deviceCapabilities,proto3" json:"device_capabilities,omitempty"`
	// Screen size in the horizontal (X) dimension measured in pixels.
	ScreenX int32 `protobuf:"varint,7,opt,name=screen_x,json=screenX,proto3" json:"screen_x,omitempty"`
	// Screen size in the vertical (Y) dimension measured in pixels.
	ScreenY int32 `protobuf:"varint,8,opt,name=screen_y,json=screenY,proto3" json:"screen_y,omitempty"`
	// Screen density in DPI.
	ScreenDensity int32 `protobuf:"varint,9,opt,name=screen_density,json=screenDensity,proto3" json:"screen_density,omitempty"`
	// Whether this device is a phone, tablet, wearable, etc.
	FormFactor DeviceFormFactor `protobuf:"varint,6,opt,name=form_factor,json=formFactor,proto3,enum=google.devtools.testing.v1.DeviceFormFactor" json:"form_factor,omitempty"`
}

func (x *IosModel) Reset() {
	*x = IosModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosModel) ProtoMessage() {}

func (x *IosModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosModel.ProtoReflect.Descriptor instead.
func (*IosModel) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{11}
}

func (x *IosModel) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *IosModel) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IosModel) GetSupportedVersionIds() []string {
	if x != nil {
		return x.SupportedVersionIds
	}
	return nil
}

func (x *IosModel) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *IosModel) GetDeviceCapabilities() []string {
	if x != nil {
		return x.DeviceCapabilities
	}
	return nil
}

func (x *IosModel) GetScreenX() int32 {
	if x != nil {
		return x.ScreenX
	}
	return 0
}

func (x *IosModel) GetScreenY() int32 {
	if x != nil {
		return x.ScreenY
	}
	return 0
}

func (x *IosModel) GetScreenDensity() int32 {
	if x != nil {
		return x.ScreenDensity
	}
	return 0
}

func (x *IosModel) GetFormFactor() DeviceFormFactor {
	if x != nil {
		return x.FormFactor
	}
	return DeviceFormFactor_DEVICE_FORM_FACTOR_UNSPECIFIED
}

// An iOS version.
type IosVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An opaque id for this iOS version.
	// Use this id to invoke the TestExecutionService.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// An integer representing the major iOS version.
	// Examples: "8", "9".
	MajorVersion int32 `protobuf:"varint,2,opt,name=major_version,json=majorVersion,proto3" json:"major_version,omitempty"`
	// An integer representing the minor iOS version.
	// Examples: "1", "2".
	MinorVersion int32 `protobuf:"varint,4,opt,name=minor_version,json=minorVersion,proto3" json:"minor_version,omitempty"`
	// Tags for this dimension.
	// Examples: "default", "preview", "deprecated".
	Tags []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	// The available Xcode versions for this version.
	SupportedXcodeVersionIds []string `protobuf:"bytes,5,rep,name=supported_xcode_version_ids,json=supportedXcodeVersionIds,proto3" json:"supported_xcode_version_ids,omitempty"`
}

func (x *IosVersion) Reset() {
	*x = IosVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosVersion) ProtoMessage() {}

func (x *IosVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosVersion.ProtoReflect.Descriptor instead.
func (*IosVersion) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{12}
}

func (x *IosVersion) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *IosVersion) GetMajorVersion() int32 {
	if x != nil {
		return x.MajorVersion
	}
	return 0
}

func (x *IosVersion) GetMinorVersion() int32 {
	if x != nil {
		return x.MinorVersion
	}
	return 0
}

func (x *IosVersion) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *IosVersion) GetSupportedXcodeVersionIds() []string {
	if x != nil {
		return x.SupportedXcodeVersionIds
	}
	return nil
}

// A location/region designation for language.
type Locale struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id for this locale.
	// Example: "en_US".
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A human-friendly name for this language/locale.
	// Example: "English".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// A human-friendly string representing the region for this
	// locale. Example: "United States". Not present for every locale.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Tags for this dimension.
	// Example: "default".
	Tags []string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *Locale) Reset() {
	*x = Locale{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Locale) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Locale) ProtoMessage() {}

func (x *Locale) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Locale.ProtoReflect.Descriptor instead.
func (*Locale) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{13}
}

func (x *Locale) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Locale) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Locale) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

func (x *Locale) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// Screen orientation of the device.
type Orientation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id for this orientation.
	// Example: "portrait".
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A human-friendly name for this orientation.
	// Example: "portrait".
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Tags for this dimension.
	// Example: "default".
	Tags []string `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *Orientation) Reset() {
	*x = Orientation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Orientation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Orientation) ProtoMessage() {}

func (x *Orientation) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Orientation.ProtoReflect.Descriptor instead.
func (*Orientation) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{14}
}

func (x *Orientation) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Orientation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Orientation) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// An Xcode version that an iOS version is compatible with.
type XcodeVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id for this version.
	// Example: "9.2".
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Tags for this Xcode version.
	// Example: "default".
	Tags []string `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
}

func (x *XcodeVersion) Reset() {
	*x = XcodeVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *XcodeVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*XcodeVersion) ProtoMessage() {}

func (x *XcodeVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use XcodeVersion.ProtoReflect.Descriptor instead.
func (*XcodeVersion) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{15}
}

func (x *XcodeVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *XcodeVersion) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

type NetworkConfigurationCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Configurations []*NetworkConfiguration `protobuf:"bytes,1,rep,name=configurations,proto3" json:"configurations,omitempty"`
}

func (x *NetworkConfigurationCatalog) Reset() {
	*x = NetworkConfigurationCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfigurationCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfigurationCatalog) ProtoMessage() {}

func (x *NetworkConfigurationCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfigurationCatalog.ProtoReflect.Descriptor instead.
func (*NetworkConfigurationCatalog) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{16}
}

func (x *NetworkConfigurationCatalog) GetConfigurations() []*NetworkConfiguration {
	if x != nil {
		return x.Configurations
	}
	return nil
}

type NetworkConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique opaque id for this network traffic configuration.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The emulation rule applying to the upload traffic.
	UpRule *TrafficRule `protobuf:"bytes,2,opt,name=up_rule,json=upRule,proto3" json:"up_rule,omitempty"`
	// The emulation rule applying to the download traffic.
	DownRule *TrafficRule `protobuf:"bytes,3,opt,name=down_rule,json=downRule,proto3" json:"down_rule,omitempty"`
}

func (x *NetworkConfiguration) Reset() {
	*x = NetworkConfiguration{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfiguration) ProtoMessage() {}

func (x *NetworkConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfiguration.ProtoReflect.Descriptor instead.
func (*NetworkConfiguration) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{17}
}

func (x *NetworkConfiguration) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *NetworkConfiguration) GetUpRule() *TrafficRule {
	if x != nil {
		return x.UpRule
	}
	return nil
}

func (x *NetworkConfiguration) GetDownRule() *TrafficRule {
	if x != nil {
		return x.DownRule
	}
	return nil
}

// Network emulation parameters.
type TrafficRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Packet delay, must be >= 0.
	Delay *durationpb.Duration `protobuf:"bytes,1,opt,name=delay,proto3" json:"delay,omitempty"`
	// Packet loss ratio (0.0 - 1.0).
	PacketLossRatio float32 `protobuf:"fixed32,2,opt,name=packet_loss_ratio,json=packetLossRatio,proto3" json:"packet_loss_ratio,omitempty"`
	// Packet duplication ratio (0.0 - 1.0).
	PacketDuplicationRatio float32 `protobuf:"fixed32,3,opt,name=packet_duplication_ratio,json=packetDuplicationRatio,proto3" json:"packet_duplication_ratio,omitempty"`
	// Bandwidth in kbits/second.
	Bandwidth float32 `protobuf:"fixed32,4,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	// Burst size in kbits.
	Burst float32 `protobuf:"fixed32,5,opt,name=burst,proto3" json:"burst,omitempty"`
}

func (x *TrafficRule) Reset() {
	*x = TrafficRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrafficRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrafficRule) ProtoMessage() {}

func (x *TrafficRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrafficRule.ProtoReflect.Descriptor instead.
func (*TrafficRule) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{18}
}

func (x *TrafficRule) GetDelay() *durationpb.Duration {
	if x != nil {
		return x.Delay
	}
	return nil
}

func (x *TrafficRule) GetPacketLossRatio() float32 {
	if x != nil {
		return x.PacketLossRatio
	}
	return 0
}

func (x *TrafficRule) GetPacketDuplicationRatio() float32 {
	if x != nil {
		return x.PacketDuplicationRatio
	}
	return 0
}

func (x *TrafficRule) GetBandwidth() float32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *TrafficRule) GetBurst() float32 {
	if x != nil {
		return x.Burst
	}
	return 0
}

// The currently provided software environment on the devices under test.
type ProvidedSoftwareCatalog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A string representing the current version of Android Test Orchestrator
	// that is used in the environment. The package is available at
	// https://maven.google.com/web/index.html#com.android.support.test:orchestrator.
	OrchestratorVersion string `protobuf:"bytes,1,opt,name=orchestrator_version,json=orchestratorVersion,proto3" json:"orchestrator_version,omitempty"`
	// A string representing the current version of AndroidX Test Orchestrator
	// that is used in the environment. The package is available at
	// https://maven.google.com/web/index.html#androidx.test:orchestrator.
	AndroidxOrchestratorVersion string `protobuf:"bytes,2,opt,name=androidx_orchestrator_version,json=androidxOrchestratorVersion,proto3" json:"androidx_orchestrator_version,omitempty"`
}

func (x *ProvidedSoftwareCatalog) Reset() {
	*x = ProvidedSoftwareCatalog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvidedSoftwareCatalog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvidedSoftwareCatalog) ProtoMessage() {}

func (x *ProvidedSoftwareCatalog) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvidedSoftwareCatalog.ProtoReflect.Descriptor instead.
func (*ProvidedSoftwareCatalog) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP(), []int{19}
}

func (x *ProvidedSoftwareCatalog) GetOrchestratorVersion() string {
	if x != nil {
		return x.OrchestratorVersion
	}
	return ""
}

func (x *ProvidedSoftwareCatalog) GetAndroidxOrchestratorVersion() string {
	if x != nil {
		return x.AndroidxOrchestratorVersion
	}
	return ""
}

var File_google_devtools_testing_v1_test_environment_discovery_proto protoreflect.FileDescriptor

var file_google_devtools_testing_v1_test_environment_discovery_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x01, 0x0a, 0x0d, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x14, 0x0a, 0x05,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x12, 0x3a, 0x0a, 0x04, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x52, 0x04, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x30,
	0x0a, 0x0a, 0x61, 0x64, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x09, 0x61, 0x64, 0x64, 0x65, 0x64, 0x44, 0x61, 0x74, 0x65,
	0x22, 0xce, 0x02, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x77, 0x0a, 0x10, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x54, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x22, 0x91, 0x01,
	0x0a, 0x0f, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x20, 0x0a, 0x1c, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x4e, 0x44, 0x52, 0x4f, 0x49, 0x44, 0x10, 0x01,
	0x12, 0x07, 0x0a, 0x03, 0x49, 0x4f, 0x53, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x45, 0x54,
	0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x55, 0x52, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x04, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44, 0x45, 0x44,
	0x5f, 0x53, 0x4f, 0x46, 0x54, 0x57, 0x41, 0x52, 0x45, 0x10, 0x05, 0x12, 0x14, 0x0a, 0x10, 0x44,
	0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x49, 0x50, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x53, 0x10,
	0x06, 0x22, 0xc3, 0x04, 0x0a, 0x16, 0x54, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x68, 0x0a, 0x16,
	0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69,
	0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x48, 0x00,
	0x52, 0x14, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x5c, 0x0a, 0x12, 0x69, 0x6f, 0x73, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6f, 0x73, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x48, 0x00, 0x52, 0x10, 0x69, 0x6f, 0x73, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x12, 0x7d, 0x0a, 0x1d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x48, 0x00, 0x52, 0x1b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x12, 0x60, 0x0a, 0x10, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x64, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x69, 0x0a, 0x17, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x70, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x48, 0x00, 0x52, 0x14, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x70, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x42, 0x15, 0x0a, 0x13, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x22, 0x5e, 0x0a, 0x14, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x49, 0x70, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12,
	0x46, 0x0a, 0x09, 0x69, 0x70, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x70, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x08, 0x69,
	0x70, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x22, 0x8e, 0x02, 0x0a, 0x14, 0x41, 0x6e, 0x64, 0x72,
	0x6f, 0x69, 0x64, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x12, 0x40, 0x0a, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x73, 0x12, 0x46, 0x0a, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6c, 0x0a, 0x15, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x14, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0x0a, 0x1b, 0x41, 0x6e, 0x64,
	0x72, 0x6f, 0x69, 0x64, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x07, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x52, 0x07, 0x6c,
	0x6f, 0x63, 0x61, 0x6c, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0c, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xbb, 0x04, 0x0a, 0x0c, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0c, 0x6d, 0x61, 0x6e, 0x75,
	0x66, 0x61, 0x63, 0x74, 0x75, 0x72, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74, 0x75, 0x72, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05,
	0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x62, 0x72, 0x61,
	0x6e, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x64, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x64, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x04, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x46, 0x6f, 0x72, 0x6d, 0x52, 0x04, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x4d, 0x0a, 0x0b, 0x66, 0x6f,
	0x72, 0x6d, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0a, 0x66,
	0x6f, 0x72, 0x6d, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x63, 0x72,
	0x65, 0x65, 0x6e, 0x5f, 0x78, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x73, 0x63, 0x72,
	0x65, 0x65, 0x6e, 0x58, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x79,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x59, 0x12,
	0x25, 0x0a, 0x0e, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x64, 0x65, 0x6e, 0x73, 0x69, 0x74,
	0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x44,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x79, 0x12, 0x35, 0x0a, 0x17, 0x6c, 0x6f, 0x77, 0x5f, 0x66, 0x70,
	0x73, 0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x6c, 0x6f, 0x77, 0x46, 0x70, 0x73, 0x56,
	0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x32, 0x0a,
	0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x62, 0x69, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x41, 0x62, 0x69, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x55, 0x72,
	0x6c, 0x22, 0x99, 0x02, 0x0a, 0x0e, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x1b, 0x0a, 0x09, 0x61,
	0x70, 0x69, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x61, 0x70, 0x69, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x64, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x64,
	0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0b,
	0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x44, 0x61, 0x74, 0x65, 0x12, 0x4c, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x69, 0x73,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x22, 0x78, 0x0a,
	0x0c, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a,
	0x10, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x72, 0x6b,
	0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x65, 0x22, 0xcf, 0x02, 0x0a, 0x10, 0x49, 0x6f, 0x73, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x3c, 0x0a, 0x06,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x06, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x42, 0x0a, 0x08, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f,
	0x0a, 0x0e, 0x78, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x58, 0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x78, 0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x68, 0x0a, 0x15, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6f, 0x73, 0x52,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x14, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x17, 0x49, 0x6f,
	0x73, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x07, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x52, 0x07, 0x6c, 0x6f, 0x63, 0x61,
	0x6c, 0x65, 0x73, 0x12, 0x4b, 0x0a, 0x0c, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0c, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xd3, 0x02, 0x0a, 0x08, 0x49, 0x6f, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x13, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x2f, 0x0a, 0x13, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x63,
	0x72, 0x65, 0x65, 0x6e, 0x5f, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x73, 0x63,
	0x72, 0x65, 0x65, 0x6e, 0x58, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f,
	0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x59,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x5f, 0x64, 0x65, 0x6e, 0x73, 0x69,
	0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e,
	0x44, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x79, 0x12, 0x4d, 0x0a, 0x0b, 0x66, 0x6f, 0x72, 0x6d, 0x5f,
	0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x46, 0x6f, 0x72, 0x6d, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0a, 0x66, 0x6f, 0x72, 0x6d,
	0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xb9, 0x01, 0x0a, 0x0a, 0x49, 0x6f, 0x73, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61,
	0x6a, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69,
	0x6e, 0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x5f, 0x78, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x18, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x58, 0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x73, 0x22, 0x58, 0x0a, 0x06, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x22, 0x45, 0x0a, 0x0b,
	0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x61, 0x67, 0x73, 0x22, 0x3c, 0x0a, 0x0c, 0x58, 0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x22, 0x77, 0x0a, 0x1b, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x12, 0x58, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xae, 0x01, 0x0a, 0x14, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x07, 0x75, 0x70, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x06, 0x75,
	0x70, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x44, 0x0a, 0x09, 0x64, 0x6f, 0x77, 0x6e, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x08, 0x64, 0x6f, 0x77, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x22, 0xd8, 0x01, 0x0a, 0x0b,
	0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x2f, 0x0a, 0x05, 0x64,
	0x65, 0x6c, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x2a, 0x0a, 0x11,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x5f, 0x6c, 0x6f, 0x73, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x4c,
	0x6f, 0x73, 0x73, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x38, 0x0a, 0x18, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x5f, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x16, 0x70, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x74,
	0x69, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x12, 0x14, 0x0a, 0x05, 0x62, 0x75, 0x72, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x05, 0x62, 0x75, 0x72, 0x73, 0x74, 0x22, 0x90, 0x01, 0x0a, 0x17, 0x50, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x64, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x12, 0x31, 0x0a, 0x14, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x1d, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x78, 0x5f, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1b, 0x61, 0x6e,
	0x64, 0x72, 0x6f, 0x69, 0x64, 0x78, 0x4f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a, 0x52, 0x0a, 0x0a, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45, 0x56, 0x49, 0x43,
	0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x56, 0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x48, 0x59, 0x53, 0x49, 0x43, 0x41, 0x4c, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x45, 0x4d, 0x55, 0x4c, 0x41, 0x54, 0x4f, 0x52, 0x10, 0x03, 0x2a, 0x5b, 0x0a,
	0x10, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x61, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x22, 0x0a, 0x1e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d,
	0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x48, 0x4f, 0x4e, 0x45, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x54, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08,
	0x57, 0x45, 0x41, 0x52, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x32, 0xee, 0x02, 0x0a, 0x1f, 0x54,
	0x65, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc4,
	0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73,
	0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x22, 0x35,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x73, 0x74,
	0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2f, 0x7b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x7d, 0x1a, 0x83, 0x01, 0xca, 0x41, 0x16, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x67, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0x84, 0x01, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42, 0x1d,
	0x54, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescOnce sync.Once
	file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescData = file_google_devtools_testing_v1_test_environment_discovery_proto_rawDesc
)

func file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescGZIP() []byte {
	file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescOnce.Do(func() {
		file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescData)
	})
	return file_google_devtools_testing_v1_test_environment_discovery_proto_rawDescData
}

var file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_devtools_testing_v1_test_environment_discovery_proto_goTypes = []interface{}{
	(DeviceForm)(0),       // 0: google.devtools.testing.v1.DeviceForm
	(DeviceFormFactor)(0), // 1: google.devtools.testing.v1.DeviceFormFactor
	(GetTestEnvironmentCatalogRequest_EnvironmentType)(0), // 2: google.devtools.testing.v1.GetTestEnvironmentCatalogRequest.EnvironmentType
	(*DeviceIpBlock)(nil),                    // 3: google.devtools.testing.v1.DeviceIpBlock
	(*GetTestEnvironmentCatalogRequest)(nil), // 4: google.devtools.testing.v1.GetTestEnvironmentCatalogRequest
	(*TestEnvironmentCatalog)(nil),           // 5: google.devtools.testing.v1.TestEnvironmentCatalog
	(*DeviceIpBlockCatalog)(nil),             // 6: google.devtools.testing.v1.DeviceIpBlockCatalog
	(*AndroidDeviceCatalog)(nil),             // 7: google.devtools.testing.v1.AndroidDeviceCatalog
	(*AndroidRuntimeConfiguration)(nil),      // 8: google.devtools.testing.v1.AndroidRuntimeConfiguration
	(*AndroidModel)(nil),                     // 9: google.devtools.testing.v1.AndroidModel
	(*AndroidVersion)(nil),                   // 10: google.devtools.testing.v1.AndroidVersion
	(*Distribution)(nil),                     // 11: google.devtools.testing.v1.Distribution
	(*IosDeviceCatalog)(nil),                 // 12: google.devtools.testing.v1.IosDeviceCatalog
	(*IosRuntimeConfiguration)(nil),          // 13: google.devtools.testing.v1.IosRuntimeConfiguration
	(*IosModel)(nil),                         // 14: google.devtools.testing.v1.IosModel
	(*IosVersion)(nil),                       // 15: google.devtools.testing.v1.IosVersion
	(*Locale)(nil),                           // 16: google.devtools.testing.v1.Locale
	(*Orientation)(nil),                      // 17: google.devtools.testing.v1.Orientation
	(*XcodeVersion)(nil),                     // 18: google.devtools.testing.v1.XcodeVersion
	(*NetworkConfigurationCatalog)(nil),      // 19: google.devtools.testing.v1.NetworkConfigurationCatalog
	(*NetworkConfiguration)(nil),             // 20: google.devtools.testing.v1.NetworkConfiguration
	(*TrafficRule)(nil),                      // 21: google.devtools.testing.v1.TrafficRule
	(*ProvidedSoftwareCatalog)(nil),          // 22: google.devtools.testing.v1.ProvidedSoftwareCatalog
	(*date.Date)(nil),                        // 23: google.type.Date
	(*timestamppb.Timestamp)(nil),            // 24: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),              // 25: google.protobuf.Duration
}
var file_google_devtools_testing_v1_test_environment_discovery_proto_depIdxs = []int32{
	0,  // 0: google.devtools.testing.v1.DeviceIpBlock.form:type_name -> google.devtools.testing.v1.DeviceForm
	23, // 1: google.devtools.testing.v1.DeviceIpBlock.added_date:type_name -> google.type.Date
	2,  // 2: google.devtools.testing.v1.GetTestEnvironmentCatalogRequest.environment_type:type_name -> google.devtools.testing.v1.GetTestEnvironmentCatalogRequest.EnvironmentType
	7,  // 3: google.devtools.testing.v1.TestEnvironmentCatalog.android_device_catalog:type_name -> google.devtools.testing.v1.AndroidDeviceCatalog
	12, // 4: google.devtools.testing.v1.TestEnvironmentCatalog.ios_device_catalog:type_name -> google.devtools.testing.v1.IosDeviceCatalog
	19, // 5: google.devtools.testing.v1.TestEnvironmentCatalog.network_configuration_catalog:type_name -> google.devtools.testing.v1.NetworkConfigurationCatalog
	22, // 6: google.devtools.testing.v1.TestEnvironmentCatalog.software_catalog:type_name -> google.devtools.testing.v1.ProvidedSoftwareCatalog
	6,  // 7: google.devtools.testing.v1.TestEnvironmentCatalog.device_ip_block_catalog:type_name -> google.devtools.testing.v1.DeviceIpBlockCatalog
	3,  // 8: google.devtools.testing.v1.DeviceIpBlockCatalog.ip_blocks:type_name -> google.devtools.testing.v1.DeviceIpBlock
	9,  // 9: google.devtools.testing.v1.AndroidDeviceCatalog.models:type_name -> google.devtools.testing.v1.AndroidModel
	10, // 10: google.devtools.testing.v1.AndroidDeviceCatalog.versions:type_name -> google.devtools.testing.v1.AndroidVersion
	8,  // 11: google.devtools.testing.v1.AndroidDeviceCatalog.runtime_configuration:type_name -> google.devtools.testing.v1.AndroidRuntimeConfiguration
	16, // 12: google.devtools.testing.v1.AndroidRuntimeConfiguration.locales:type_name -> google.devtools.testing.v1.Locale
	17, // 13: google.devtools.testing.v1.AndroidRuntimeConfiguration.orientations:type_name -> google.devtools.testing.v1.Orientation
	0,  // 14: google.devtools.testing.v1.AndroidModel.form:type_name -> google.devtools.testing.v1.DeviceForm
	1,  // 15: google.devtools.testing.v1.AndroidModel.form_factor:type_name -> google.devtools.testing.v1.DeviceFormFactor
	23, // 16: google.devtools.testing.v1.AndroidVersion.release_date:type_name -> google.type.Date
	11, // 17: google.devtools.testing.v1.AndroidVersion.distribution:type_name -> google.devtools.testing.v1.Distribution
	24, // 18: google.devtools.testing.v1.Distribution.measurement_time:type_name -> google.protobuf.Timestamp
	14, // 19: google.devtools.testing.v1.IosDeviceCatalog.models:type_name -> google.devtools.testing.v1.IosModel
	15, // 20: google.devtools.testing.v1.IosDeviceCatalog.versions:type_name -> google.devtools.testing.v1.IosVersion
	18, // 21: google.devtools.testing.v1.IosDeviceCatalog.xcode_versions:type_name -> google.devtools.testing.v1.XcodeVersion
	13, // 22: google.devtools.testing.v1.IosDeviceCatalog.runtime_configuration:type_name -> google.devtools.testing.v1.IosRuntimeConfiguration
	16, // 23: google.devtools.testing.v1.IosRuntimeConfiguration.locales:type_name -> google.devtools.testing.v1.Locale
	17, // 24: google.devtools.testing.v1.IosRuntimeConfiguration.orientations:type_name -> google.devtools.testing.v1.Orientation
	1,  // 25: google.devtools.testing.v1.IosModel.form_factor:type_name -> google.devtools.testing.v1.DeviceFormFactor
	20, // 26: google.devtools.testing.v1.NetworkConfigurationCatalog.configurations:type_name -> google.devtools.testing.v1.NetworkConfiguration
	21, // 27: google.devtools.testing.v1.NetworkConfiguration.up_rule:type_name -> google.devtools.testing.v1.TrafficRule
	21, // 28: google.devtools.testing.v1.NetworkConfiguration.down_rule:type_name -> google.devtools.testing.v1.TrafficRule
	25, // 29: google.devtools.testing.v1.TrafficRule.delay:type_name -> google.protobuf.Duration
	4,  // 30: google.devtools.testing.v1.TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog:input_type -> google.devtools.testing.v1.GetTestEnvironmentCatalogRequest
	5,  // 31: google.devtools.testing.v1.TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog:output_type -> google.devtools.testing.v1.TestEnvironmentCatalog
	31, // [31:32] is the sub-list for method output_type
	30, // [30:31] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_devtools_testing_v1_test_environment_discovery_proto_init() }
func file_google_devtools_testing_v1_test_environment_discovery_proto_init() {
	if File_google_devtools_testing_v1_test_environment_discovery_proto != nil {
		return
	}
	file_google_devtools_testing_v1_test_execution_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceIpBlock); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTestEnvironmentCatalogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestEnvironmentCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeviceIpBlockCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidDeviceCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidRuntimeConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Distribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosDeviceCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosRuntimeConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Locale); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Orientation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*XcodeVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfigurationCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfiguration); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrafficRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvidedSoftwareCatalog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*TestEnvironmentCatalog_AndroidDeviceCatalog)(nil),
		(*TestEnvironmentCatalog_IosDeviceCatalog)(nil),
		(*TestEnvironmentCatalog_NetworkConfigurationCatalog)(nil),
		(*TestEnvironmentCatalog_SoftwareCatalog)(nil),
		(*TestEnvironmentCatalog_DeviceIpBlockCatalog)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_testing_v1_test_environment_discovery_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_testing_v1_test_environment_discovery_proto_goTypes,
		DependencyIndexes: file_google_devtools_testing_v1_test_environment_discovery_proto_depIdxs,
		EnumInfos:         file_google_devtools_testing_v1_test_environment_discovery_proto_enumTypes,
		MessageInfos:      file_google_devtools_testing_v1_test_environment_discovery_proto_msgTypes,
	}.Build()
	File_google_devtools_testing_v1_test_environment_discovery_proto = out.File
	file_google_devtools_testing_v1_test_environment_discovery_proto_rawDesc = nil
	file_google_devtools_testing_v1_test_environment_discovery_proto_goTypes = nil
	file_google_devtools_testing_v1_test_environment_discovery_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TestEnvironmentDiscoveryServiceClient is the client API for TestEnvironmentDiscoveryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TestEnvironmentDiscoveryServiceClient interface {
	// Gets the catalog of supported test environments.
	//
	// May return any of the following canonical error codes:
	//
	// - INVALID_ARGUMENT - if the request is malformed
	// - NOT_FOUND - if the environment type does not exist
	// - INTERNAL - if an internal error occurred
	GetTestEnvironmentCatalog(ctx context.Context, in *GetTestEnvironmentCatalogRequest, opts ...grpc.CallOption) (*TestEnvironmentCatalog, error)
}

type testEnvironmentDiscoveryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTestEnvironmentDiscoveryServiceClient(cc grpc.ClientConnInterface) TestEnvironmentDiscoveryServiceClient {
	return &testEnvironmentDiscoveryServiceClient{cc}
}

func (c *testEnvironmentDiscoveryServiceClient) GetTestEnvironmentCatalog(ctx context.Context, in *GetTestEnvironmentCatalogRequest, opts ...grpc.CallOption) (*TestEnvironmentCatalog, error) {
	out := new(TestEnvironmentCatalog)
	err := c.cc.Invoke(ctx, "/google.devtools.testing.v1.TestEnvironmentDiscoveryService/GetTestEnvironmentCatalog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TestEnvironmentDiscoveryServiceServer is the server API for TestEnvironmentDiscoveryService service.
type TestEnvironmentDiscoveryServiceServer interface {
	// Gets the catalog of supported test environments.
	//
	// May return any of the following canonical error codes:
	//
	// - INVALID_ARGUMENT - if the request is malformed
	// - NOT_FOUND - if the environment type does not exist
	// - INTERNAL - if an internal error occurred
	GetTestEnvironmentCatalog(context.Context, *GetTestEnvironmentCatalogRequest) (*TestEnvironmentCatalog, error)
}

// UnimplementedTestEnvironmentDiscoveryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTestEnvironmentDiscoveryServiceServer struct {
}

func (*UnimplementedTestEnvironmentDiscoveryServiceServer) GetTestEnvironmentCatalog(context.Context, *GetTestEnvironmentCatalogRequest) (*TestEnvironmentCatalog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTestEnvironmentCatalog not implemented")
}

func RegisterTestEnvironmentDiscoveryServiceServer(s *grpc.Server, srv TestEnvironmentDiscoveryServiceServer) {
	s.RegisterService(&_TestEnvironmentDiscoveryService_serviceDesc, srv)
}

func _TestEnvironmentDiscoveryService_GetTestEnvironmentCatalog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTestEnvironmentCatalogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TestEnvironmentDiscoveryServiceServer).GetTestEnvironmentCatalog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.testing.v1.TestEnvironmentDiscoveryService/GetTestEnvironmentCatalog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TestEnvironmentDiscoveryServiceServer).GetTestEnvironmentCatalog(ctx, req.(*GetTestEnvironmentCatalogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TestEnvironmentDiscoveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.testing.v1.TestEnvironmentDiscoveryService",
	HandlerType: (*TestEnvironmentDiscoveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTestEnvironmentCatalog",
			Handler:    _TestEnvironmentDiscoveryService_GetTestEnvironmentCatalog_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/testing/v1/test_environment_discovery.proto",
}
