// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package org.jetbrains.intellij.build

import groovy.transform.CompileStatic

import static org.jetbrains.intellij.build.LibraryLicense.jetbrainsLibrary

/**
 * Defines information about licenses of libraries located in 'community', 'contrib' and 'android' repositories.
 *
 * @author nik
 */
@CompileStatic
class CommunityLibraryLicenses {
  public static final List<LibraryLicense> LICENSES_LIST = [
    new LibraryLicense(name: "Aether", version: "1.1.0", license: "Eclipse Public License 1.0", url: "http://www.eclipse.org/aether/",
                       libraryName: 'org.eclipse.aether:aether-api',
                       additionalLibraryNames: ['org.eclipse.aether:aether-impl', 'org.eclipse.aether:aether-connector-basic', 'org.eclipse.aether:aether-transport-file', 'org.eclipse.aether:aether-transport-http'],
                       licenseUrl: "http://www.eclipse.org/legal/epl-v10.html"),
    new LibraryLicense(name: "aether-api", version: "1.13.1", libraryName: "aether-api-1.13.1.jar", license: "Apache 2.0",
                       url: "http://maven.apache.org/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "aether-api-0.9.0.M2.jar", version: "0.9.0.M2", libraryName: "aether-api-0.9.0.M2.jar",
                       license: "Eclipse Public License v1.0", url: "http://www.eclipse.org/aether/",
                       licenseUrl: "http://www.eclipse.org/org/documents/epl-v10.html"),
    new LibraryLicense(name: "Android Aia Manifest Proto", libraryName: "aia-manifest-proto-1.0-jarjar.jar", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Analytics", attachedTo: "intellij.android", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Analytics Protos", libraryName: "analytics-protos", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Analytics Shared", libraryName: "com.android.tools.analytics-library:shared:26.1.2",
                       license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Analytics Tracker", libraryName: "com.android.tools.analytics-library:tracker:26.1.2",
                       license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Annotations", libraryName: "com.android.tools:annotations:26.1.2", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Archive Patcher", libraryName: "archive-patcher", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Baksmali", libraryName: "baksmali", license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Builder", attachedTo: "intellij.android", license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Builder Model", libraryName: "builder-model", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Builder Test Api", libraryName: "builder-test-api", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Common Library", libraryName: "com.android.tools:common:26.1.2", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Ddm Library", libraryName: "com.android.tools.ddms:ddmlib:26.1.2", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android DEX library", libraryName: "dexlib2", license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Gradle model", attachedTo: "intellij.android", version: "0.4-SNAPSHOT", license: "Apache 2.0",
                       url: "https://android.googlesource.com/platform/tools/build/+/master/gradle-model/"),
    new LibraryLicense(name: "Android Layout Library", libraryName: "layoutlib", license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "Android libwebp library", libraryName: "libwebp.jar", license: "Apache 2.0",
                       url: "https://github.com/webmproject/libwebp"),
    new LibraryLicense(name: "Android Lint Api", libraryName: "com.android.tools.lint:lint-api:26.1.2", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Lint Checks", libraryName: "com.android.tools.lint:lint-checks:26.1.2", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Manifest Merger", libraryName: "com.android.tools.build:manifest-merger:26.1.2",
                       license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Profiler", libraryName: "studio-profiler-grpc-1.0-jarjar", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Repository", libraryName: "com.android.tools:repository:26.1.2", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Sdk Common", libraryName: "com.android.tools:sdk-common:26.1.2", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android SDK Tools", attachedTo: "intellij.android", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android SDK Tools JPS", libraryName: "android-sdk-tools-jps", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Android Sherpa library", libraryName: "sherpa-solver", license: "Apache 2.0",
                       url: "http://source.android.com/"),
    new LibraryLicense(name: "Ant", version: "1.9", license: "Apache 2.0", url: "http://ant.apache.org/",
                       licenseUrl: "http://ant.apache.org/license.html"),
    new LibraryLicense(name: "ANTLR 4 Runtime", libraryName: "antlr-runtime-4.1.jar", version: "4.1", license: "BSD",
                       url: "http://www.antlr.org", licenseUrl: "http://www.antlr.org/license.html"),

    new LibraryLicense(name: "Apache Axis", libraryName: "axis-1.4", version: "1.4", license: "Apache 2.0",
                       url: "http://ws.apache.org/axis/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.html"),
    new LibraryLicense(name: "Apache Axis wstx-asl", libraryName: "wstx-asl", version: "1.4", license: "Apache 2.0",
                           url: "http://ws.apache.org/axis/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.html"),

    new LibraryLicense(name: "Apache Commons BeanUtils", libraryName: "commons-beanutils.jar", version: "1.6", license: "Apache 2.0",
                       url: "http://commons.apache.org/beanutils/"),
    new LibraryLicense(name: "Apache Commons Codec", libraryName: "commons-codec", version: "1.8", license: "Apache 2.0",
                       url: "http://commons.apache.org/codec/", licenseUrl: "http://www.apache.org/licenses/"),
    new LibraryLicense(name: "Apache Commons Collections", libraryName: "commons-collections", version: "3.2.2", license: "Apache 2.0",
                       url: "https://commons.apache.org/proper/commons-collections/"),
    new LibraryLicense(name: "Apache Commons Compress", libraryName: "commons-compress", version: "1.10", license: "Apache 2.0",
                       url: "http://commons.apache.org/proper/commons-compress/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Apache Commons Discovery", libraryName: "commons-discovery", version: "0.4", license: "Apache 2.0",
                       url: "http://jakarta.apache.org/commons/discovery/", licenseUrl: "http://www.apache.org/licenses/"),
    new LibraryLicense(name: "Apache Commons HTTPClient", libraryName: "http-client-3.1", version: "3.1&nbsp; (with patch by JetBrains)",
                       license: "Apache 2.0", url: "http://hc.apache.org/httpclient-3.x"),
    new LibraryLicense(name: "Apache Commons Imaging (JetBrains's fork)", libraryName: "commons-imaging", version: "1.0-RC",
                       license: "Apache 2.0", url: "https://github.com/JetBrains/intellij-deps-commons-imaging"),
    new LibraryLicense(name: "Apache Commons IO", libraryName: "commons-io", version: "2.6", license: "Apache 2.0",
                       url: "http://commons.apache.org/io/"),
    new LibraryLicense(name: "Apache Commons Lang", libraryName: "commons-lang", version: "2.6", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt", url: "http://commons.apache.org/proper/commons-lang/"),
    new LibraryLicense(name: "Apache Commons Lang 3", libraryName: "commons-lang3-3.2.1.jar", version: "3.2.1", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt", url: "http://commons.apache.org/proper/commons-lang/"),
    new LibraryLicense(name: "Apache Commons Logging", libraryName: "commons-logging", version: "1.1.1", license: "Apache 2.0",
                       url: "http://commons.apache.org/logging/"),
    new LibraryLicense(name: "Apache Commons Net", libraryName: "commons-net", version: "3.3", license: "Apache 2.0",
                       url: "http://commons.apache.org/net/"),
    new LibraryLicense(name: "Apache Lucene", libraryName: "lucene-core-2.4.1.jar", version: "2.4.1", license: "Apache 2.0",
                       url: "http://lucene.apache.org/java"),
    new LibraryLicense(name: "ASM Bytecode Manipulation Framework", libraryName: "ASM", version: "7.0 (with patches by JetBrains)",
                       license: "BSD", url: "http://asm.objectweb.org/", licenseUrl: "http://asm.objectweb.org/license.html",
                       additionalLibraryNames: ["asm-capture"]),
    new LibraryLicense(name: "ASM Tools", libraryName: "asm-tools", license: "BSD", url: "http://asm.objectweb.org/",
                       licenseUrl: "http://asm.objectweb.org/license.html"),
    new LibraryLicense(name: "Automaton", libraryName: "automaton", version: "1.12-1", license: "BSD",
                       url: "http://www.brics.dk/automaton/", licenseUrl: "http://www.opensource.org/licenses/bsd-license.php"),
    new LibraryLicense(name: "batik", libraryName: "batik", version: "1.9.1", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt", url: "https://xmlgraphics.apache.org/batik/"),
    new LibraryLicense(name: "bouncy-castle", version: "1.59", license: "MIT License", url: "http://bouncycastle.org",
                       licenseUrl: "http://bouncycastle.org/licence.html"),
    new LibraryLicense(name: "bouncy-castle-provider", version: "1.59", license: "MIT License", url: "http://bouncycastle.org",
                       licenseUrl: "http://bouncycastle.org/licence.html"),
    new LibraryLicense(name: "CGLib", libraryName: "CGLIB", version: "2.2.2", license: "Apache", url: "http://cglib.sourceforge.net/",
                       licenseUrl: "http://www.apache.org/foundation/licence-FAQ.html"),
    new LibraryLicense(name: "classworlds", libraryName: "Maven", version: "1.1", license: "codehaus",
                       url: "https://github.com/codehaus/classworlds",
                       licenseUrl: "https://github.com/codehaus/classworlds/blob/master/classworlds/LICENSE.txt"),
    new LibraryLicense(name: "completion-ranking-java", attachedTo: "intellij.statsCollector.completionRanker", version: "0.0.3",
                       license: "Apache 2.0"),
    new LibraryLicense(name: "coverage.py", attachedTo: "intellij.python.helpers", version: "3.7.1", license: "Apache 2.0",
                       url: "http://coverage.readthedocs.org/"),
    new LibraryLicense(name: "Cucumber-Core", libraryName: "cucumber-core", version: "1.2.4", license: "MIT License",
                       url: "https://github.com/cucumber/cucumber-jvm/", licenseUrl: "http://www.opensource.org/licenses/mit-license.html"),
    new LibraryLicense(name: "Cucumber-Core", libraryName: "cucumber-core", version: "3.0.2", license: "MIT License",
                       url: "https://github.com/cucumber/cucumber-jvm/", licenseUrl: "http://www.opensource.org/licenses/mit-license.html"),
    new LibraryLicense(name: "Cucumber-Expressions", libraryName: "cucumber-expressions", version: "6.1.2", license: "MIT License",
                       url: "https://github.com/cucumber/cucumber/", licenseUrl: "http://www.opensource.org/licenses/mit-license.html"),
    new LibraryLicense(name: "Cucumber-Groovy", libraryName: "cucumber-groovy", version: "1.2.4", license: "MIT License",
                       url: "https://github.com/cucumber/cucumber-jvm/", licenseUrl: "http://www.opensource.org/licenses/mit-license.html"),
    new LibraryLicense(name: "Cucumber-Java", libraryName: "cucumber-java", version: "1.2.4", license: "MIT License",
                       url: "https://github.com/cucumber/cucumber-jvm/", licenseUrl: "http://www.opensource.org/licenses/mit-license.html"),
    new LibraryLicense(name: "Dart Analysis Server", attachedTo: "intellij.dart", license: "Eclipse Public License v1.0",
                       licenseUrl: "http://www.eclipse.org/legal/epl-v10.html", url: "https://github.com/dart-lang/eclipse3"),
    new LibraryLicense(name: "Dart VM Service drivers", attachedTo: "intellij.dart", license: "BSD",
                       licenseUrl: "https://github.com/dart-lang/vm_service_drivers/blob/master/LICENSE",
                       url: "https://github.com/dart-lang/vm_service_drivers"),
    new LibraryLicense(name: "data-binding", libraryName: "data-binding.jar", license: "Apache 2.0", url: "http://source.android.com/"),
    new LibraryLicense(name: "delight-nashorn-sandbox", libraryName: "delight-nashorn-sandbox", version: "0.1.15", license: "Apache 2.0",
                       url: "https://github.com/javadelight/delight-nashorn-sandbox",
                       licenseUrl: "https://github.com/javadelight/delight-nashorn-sandbox/blob/master/LICENSE.TXT"),
    new LibraryLicense(name: "docutils", attachedTo: "intellij.python.helpers", version: "0.8", license: "BSD",
                       url: "http://docutils.sourceforge.net/"),
    new LibraryLicense(name: "DTDParser", version: "1.13", license: "LGPL", url: "http://sourceforge.net/projects/dtdparser/",
                       licenseUrl: "http://www.opensource.org/licenses/lgpl-2.1"),
    new LibraryLicense(name: "Eclipse JDT Core", attachedTo: "intellij.platform.jps.build", version: "4.2.1", license: "CPL 1.0",
                       url: "http://www.eclipse.org/jdt/core/index.php"),
    new LibraryLicense(name: "EdDSA-Java", libraryName: "trilead-ssh2", version: "0.2.0", license: "CC0 1.0 Universal",
                       licenseUrl: "https://github.com/str4d/ed25519-java/blob/master/LICENSE.txt",
                       url: "https://github.com/str4d/ed25519-java"),
    new LibraryLicense(name: "EditorConfig Java Core", libraryName: "editorconfig-core-java.jar", version: "1.0", license: "Apache 2.0",
                       url: "https://github.com/editorconfig/editorconfig-core-java/",
                       licenseUrl: "https://github.com/editorconfig/editorconfig-core-java/blob/master/LICENSE"),
    new LibraryLicense(name: "epydoc", attachedTo: "intellij.python.helpers", version: "3.0.1", license: "MIT",
                       url: "http://epydoc.sourceforge.net/"),
    new LibraryLicense(name: "error-prone-annotations", libraryName: "error-prone-annotations", version: "2.3.1", license: "Apache 2.0",
                       url: "https://github.com/google/error-prone",
                       licenseUrl: "https://github.com/google/error-prone/blob/master/COPYING"),
    new LibraryLicense(name: "FiraCode", attachedTo: "intellij.platform.resources", version: "1.205", license: "OFL",
                       url: "https://github.com/tonsky/FiraCode/blob/master/LICENSE"),
    new LibraryLicense(name: "FreeMarker", attachedTo: "intellij.java.coverage", version: "2.3.15", license: "BSD",
                       url: "http://freemarker.sourceforge.net/"),
    new LibraryLicense(name: "FreeMarker", libraryName: "freemarker-2.3.20", version: "2.3.20", license: "BSD",
                       url: "http://freemarker.sourceforge.net/"),
    new LibraryLicense(name: "FST", libraryName: "de.ruedigermoeller:fst", version: "2.56", license: "Apache 2.0",
                       url: "https://github.com/RuedigerMoeller/fast-serialization",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt"),
    new LibraryLicense(name: "fxg-utils", libraryName: "fxg-utils", version: "4.9.1", license: "Apache 2.0", url: "http://flex.apache.org",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Gant", version: "1.9.8", libraryName: "gant-groovy", license: "Apache 2.0",
                       url: "https://github.com/codehaus/gant", licenseUrl: "https://github.com/codehaus/gant/blob/master/LICENCE.txt"),
    new LibraryLicense(name: "Gherkin keywords", attachedTo: "intellij.gherkin", version: "2.12.2", license: "MIT",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt", url: "https://github.com/cucumber/gherkin"),
    new LibraryLicense(name: "Gradle", version: "4.10", license: "Apache 2.0", url: "http://gradle.org/",
                       licenseUrl: "http://gradle.org/license"),
    new LibraryLicense(name: "Groovy", version: "2.4.6", license: "Apache 2.0", url: "http://groovy-lang.org/"),
    new LibraryLicense(name: "Gson", version: "2.8.4", libraryName: "gson", license: "Apache 2.0",
                       url: "http://code.google.com/p/google-gson/"),
    new LibraryLicense(name: "Guava", version: "23.6", license: "Apache 2.0", url: "http://code.google.com/p/guava-libraries/",
                       licenseUrl: "http://ant.apache.org/license.html"),
    new LibraryLicense(name: "hamcrest", version: "1.3", license: "BSD", url: "http://hamcrest.org/",
                       licenseUrl: "http://opensource.org/licenses/BSD-3-Clause"),
    new LibraryLicense(name: "HttpComponents HttpClient", libraryName: "http-client", version: "4.5.5", license: "Apache 2.0",
                       url: "http://hc.apache.org/httpcomponents-client-ga/index.html"),
    new LibraryLicense(name: "HttpComponents HttpClient Fluent API", libraryName: "fluent-hc", version: "4.5.2",
                       license: "Apache 2.0", url: "http://hc.apache.org/httpcomponents-client-ga/index.html"),
    new LibraryLicense(name: "ImageIO", libraryName: "imageio-tiff", version: "3.2.1", license: "BSD",
                       url: "https://github.com/haraldk/TwelveMonkeys", licenseUrl: "https://github.com/haraldk/TwelveMonkeys#license"),
    new LibraryLicense(name: "imgscalr", libraryName: "imgscalr", version: "4.2", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt", url: "https://github.com/thebuzzmedia/imgscalr"),
    new LibraryLicense(name: "Inconsolata", attachedTo: "intellij.platform.resources", version: "001.010", license: "OFL",
                       url: "https://github.com/google/fonts/blob/master/ofl/inconsolata/OFL.txt"),
    new LibraryLicense(name: "ini4j (JetBrains's fork)", libraryName: "ini4j", version: "0.5.5-1", license: "Apache 2.0",
                       url: "https://github.com/JetBrains/intellij-deps-ini4j"),
    new LibraryLicense(name: "ISO RELAX", libraryName: "isorelax", license: "MIT License",
                       url: "http://sourceforge.net/projects/iso-relax/",
                       licenseUrl: "http://www.opensource.org/licenses/mit-license.html"),
    new LibraryLicense(name: "Jackson", libraryName: "jackson", version: "2.9.5", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0", url: "https://github.com/FasterXML/jackson"),
    new LibraryLicense(name: "Jakarta ORO", libraryName: "OroMatcher", version: "2.0.8", license: "Apache",
                       url: "http://jakarta.apache.org/oro/", licenseUrl: "http://svn.apache.org/repos/asf/jakarta/oro/trunk/LICENSE"),
    new LibraryLicense(name: "Java-WebSocket", libraryName: "java_websocket.jar", version: "1.4.0 Trunk", license: "MIT",
                       url: "https://github.com/TooTallNate/Java-WebSocket",
                       licenseUrl: "https://github.com/TooTallNate/Java-WebSocket/blob/master/LICENSE"),
    new LibraryLicense(name: "Java Compatibility", version: "1.0.1", license: "GPL 2.0 + Classpath", url: "https://github.com/JetBrains/intellij-deps-java-compatibility",
                       licenseUrl: "https://raw.githubusercontent.com/JetBrains/intellij-deps-java-compatibility/master/LICENSE"),
    new LibraryLicense(name: "JavaBeans Activation Framework", libraryName: "javax-activation", version: "1.1", license: "CDDL 1.0",
                          url: "http://java.sun.com/products/archive/javabeans/jaf11.html",
                          licenseUrl: "https://opensource.org/licenses/CDDL-1.0"),
    new LibraryLicense(name: "JavaCVS", attachedTo: "intellij.vcs.cvs.javacvs",
                       version: "no version number available (with patches by JetBrains)", license: "Sun Public License",
                       url: "https://versioncontrol.netbeans.org/javacvs/library/",
                       licenseUrl: "https://netbeans.org/about/legal/license.html"),
    new LibraryLicense(name: "JavaHelp", version: "2.0_02", license: "CDDL 1.1", licenseUrl: "https://javaee.github.io/javahelp/LICENSE",
                       url: "https://javaee.github.io/javahelp/"),
    new LibraryLicense(name: "Javassist", libraryName: "javassist", version: "3.21.0-GA", license: "Apache 2.0",
                       url: "https://github.com/jboss-javassist/javassist", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt"),
    new LibraryLicense(name: "javawriter", attachedTo: "intellij.android", license: "Apache 2.0", url: "https://github.com/square/javawriter"),
    new LibraryLicense(name: "javax inject", libraryName: "javax-inject", version: "1", license: "Apache 2.0",
                       licenseUrl: "http://apache.org/licenses/LICENSE-2.0", url: "http://code.google.com/p/atinject/"),
    new LibraryLicense(name: "JAXB", libraryName: "JAXB", version: "2.2.4-1", license: "CDDL 1.1", url: "http://jaxb.java.net/",
                       licenseUrl: "http://glassfish.java.net/public/CDDL+GPL_1_1.html"),
    new LibraryLicense(name: "Jaxen", version: "", license: "modified Apache", url: "https://github.com/jaxen-xpath/jaxen",
                       licenseUrl: "https://github.com/jaxen-xpath/jaxen/blob/master/LICENSE.txt"),
    new LibraryLicense(name: "JBcrypt", libraryName: "trilead-ssh2", version: "1.0.0", license: "ISC License",
                       licenseUrl: "https://github.com/jeremyh/jBCrypt/blob/master/LICENSE", url: "https://github.com/jeremyh/jBCrypt"),
    new LibraryLicense(name: "JCIP Annotations", libraryName: "jcip", license: "Creative Commons Attribution License",
                       url: "http://www.jcip.net", licenseUrl: "http://creativecommons.org/licenses/by/2.5"),
    new LibraryLicense(name: "JDOM", version: "1.1 (with patches by JetBrains)", license: "modified Apache", url: "http://www.jdom.org/",
                       licenseUrl: "http://www.jdom.org/docs/faq.html#a0030"),
    new LibraryLicense(name: "JediTerm", libraryName: "jediterm-pty", version: "2.14", license: "LGPL 3",
                       url: "https://github.com/JetBrains/jediterm",
                       licenseUrl: "https://github.com/JetBrains/jediterm/blob/master/LICENSE-LGPLv3.txt"),
    new LibraryLicense(name: "JetBrains Annotations", libraryName: "jetbrains-annotations", version: "16.0.1", license: "Apache 2.0",
                       url: "https://github.com/JetBrains/java-annotations"),
    new LibraryLicense(name: "JetBrains Annotations for Java 5", libraryName: "jetbrains-annotations-java5", version: "16.0.1",
                       license: "Apache 2.0", url: "https://github.com/JetBrains/java-annotations"),
    new LibraryLicense(name: "jetCheck", libraryName: "jetCheck", version: "0.2.1", license: "Apache 2.0",
                       url: "https://github.com/JetBrains/jetCheck"),
    new LibraryLicense(name: "JGit", libraryName: "jgit", version: "4.0", license: "Eclipse Distribution License 1.0",
                       licenseUrl: "http://www.eclipse.org/org/documents/edl-v10.php", url: "https://eclipse.org/jgit/"),
    new LibraryLicense(name: "JGoodies Common", libraryName: "jgoodies-common", version: "1.4.0", license: "BSD",
                       url: "http://www.jgoodies.com/freeware/libraries/looks/",
                       licenseUrl: "https://opensource.org/licenses/bsd-license.html"),
    new LibraryLicense(name: "JGoodies Forms", libraryName: "jgoodies-forms", version: "1.1-preview 2006-05-04 11:55:37", license: "BSD",
                       url: "http://www.jgoodies.com/freeware/libraries/forms/",
                       licenseUrl: "https://opensource.org/licenses/bsd-license.html"),
    new LibraryLicense(name: "jgraphx", libraryName: "jgraphx", version: "3.4.1.3", license: "BSD",
                       url: "https://github.com/jgraph/jgraphx"),
    new LibraryLicense(name: "JNA", libraryName: "jna", version: "4.5.0", license: "LGPL 2.1",
                       url: "https://github.com/java-native-access/jna", licenseUrl: "http://www.opensource.org/licenses/lgpl-2.1.php"),

    new LibraryLicense(name: "JSch", libraryName: "JSch", version: "0.1.53", license: "BSD", url: "http://www.jcraft.com/jsch/",
                       licenseUrl: "http://www.jcraft.com/jsch/LICENSE.txt"),
    new LibraryLicense(name: "jsch-agent-proxy", libraryName: "jsch-agent-proxy", version: "0.0.9", license: "BSD",
                       url: "https://github.com/ymnk/jsch-agent-proxy",
                       licenseUrl: "https://github.com/ymnk/jsch-agent-proxy/blob/master/LICENSE.txt"),
    new LibraryLicense(name: "jsch-extension", libraryName: "jsch-extension", version: "0.1.11", license: "MIT",
                       url: "https://github.com/lucastheisen/jsch-extension",
                       licenseUrl: "https://github.com/lucastheisen/jsch-extension/blob/master/LICENSE"),
    new LibraryLicense(name: "jsch-nio", libraryName: "jsch-nio", version: "1.0.10", license: "MIT",
                       url: "https://github.com/lucastheisen/jsch-nio",
                       licenseUrl: "https://github.com/lucastheisen/jsch-nio/blob/master/LICENSE"),

    new LibraryLicense(name: "JSON", libraryName: "json.jar", license: "JSON License", licenseUrl: "http://www.json.org/license.html",
                       url: "http://www.json.org/"),

    new LibraryLicense(name: "json-path", libraryName: "json-path-0.8.0.jar", version: "0.8.0", license: "Apache 2.0",
                       url: "http://code.google.com/p/json-path/", licenseUrl: "http://apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "json-smart", libraryName: "json-smart-1.1.1.jar", version: "1.1.1", license: "Apache 2.0",
                       url: "http://code.google.com/p/json-smart/", licenseUrl: "http://apache.org/licenses/LICENSE-2.0"),

    new LibraryLicense(name: "JSON Schema (schema.json)", attachedTo: "intellij.json", version: "draft-04",
                       license: "Simplified BSD License", licenseUrl: "https://opensource.org/licenses/BSD-2-Clause",
                       url: "http://json-schema.org/draft-04/schema#"),
    new LibraryLicense(name: "JSON Schema (schema06.json)", attachedTo: "intellij.json", version: "draft-06",
                       license: "Simplified BSD License", licenseUrl: "https://opensource.org/licenses/BSD-2-Clause",
                       url: "http://json-schema.org/draft-06/schema#"),
    new LibraryLicense(name: "JSON Schema (schema07.json)", attachedTo: "intellij.json", version: "draft-07",
                           license: "Simplified BSD License", licenseUrl: "https://opensource.org/licenses/BSD-2-Clause",
                           url: "http://json-schema.org/draft-07/schema#"),

    new LibraryLicense(name: "jsoup", libraryName: "jsoup", version: "1.10.3", license: "MIT", url: "http://jsoup.org",
                       licenseUrl: "http://jsoup.org/license"),
    new LibraryLicense(name: "jsr305", libraryName: "jsr305", version: "snapshot", license: "BSD", url: "http://code.google.com/p/jsr-305/",
                       licenseUrl: "http://code.google.com/p/jsr-305/source/browse/trunk/ri/LICENSE"),
    new LibraryLicense(name: "Jsr305", version: "1.3.9", license: "New BSD", url: "http://code.google.com/p/jsr-305/",
                       licenseUrl: "http://opensource.org/licenses/BSD-3-Clause"),
    new LibraryLicense(name: "JUnit", libraryName: "JUnit3", version: "3.8.1", license: "CPL 1.0", url: "http://junit.org/"),
    new LibraryLicense(name: "JUnit", libraryName: "JUnit4", version: "4.11", license: "CPL 1.0", url: "http://junit.org/"),
    new LibraryLicense(name: "jzlib", libraryName: "jzlib", version: "1.1.1", license: "BSD", url: "http://www.jcraft.com/jzlib/",
                       licenseUrl: "http://www.jcraft.com/jzlib/LICENSE.txt"),
    new LibraryLicense(name: "Kryo", libraryName: "Kryo", version: "2.24", license: "New BSD License",
                       url: "https://github.com/EsotericSoftware/kryo",
                       licenseUrl: "https://github.com/EsotericSoftware/kryo/blob/master/LICENSE.md"),
    new LibraryLicense(name: "kXML2", libraryName: "kxml2", version: "2.3.0", license: "BSD", url: "http://sourceforge.net/projects/kxml/"),
    new LibraryLicense(name: "Log4j", libraryName: "Log4J", version: "1.2.17", license: "Apache 2.0",
                       url: "http://logging.apache.org/log4j/1.2/index.html", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "lz4-java", libraryName: "lz4-java", version: "1.3", license: "Apache 2.0",
                       url: "https://github.com/lz4/lz4-java", licenseUrl: "https://github.com/lz4/lz4-java/blob/master/LICENSE.txt"),
    new LibraryLicense(name: "markdown4j", libraryName: "markdown4j", version: "2.2", license: "New BSD",
                       url: "https://code.google.com/p/markdown4j/", licenseUrl: "http://opensource.org/licenses/BSD-3-Clause"),
    new LibraryLicense(name: "markdownj", attachedTo: "intellij.tasks.core", version: "", license: "BSD",
                       url: "https://github.com/myabc/markdownj", licenseUrl: "http://www.opensource.org/licenses/bsd-license.php"),
    new LibraryLicense(name: "markdownj", libraryName: "markdownj", version: "0.4.2", license: "New BSD",
                       url: "https://github.com/myabc/markdownj", licenseUrl: "http://opensource.org/licenses/BSD-3-Clause"),
    new LibraryLicense(name: "MathJax", attachedTo: "intellij.python", version: "2.6.1", license: "Apache-2.0",
                       url: "git://github.com/mathjax/MathJax", licenseUrl: "https://github.com/mathjax/MathJax/blob/master/LICENSE"),
    new LibraryLicense(name: "Maven", version: "2.2.1", license: "Apache 2.0", url: "http://maven.apache.org/",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "maven-2.2.1-uber", version: "2.2.1", libraryName: "maven-2.2.1-uber.jar", license: "Apache 2.0",
                       url: "http://maven.apache.org/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "maven-artifact", version: "3.0.5", libraryName: "maven-artifact-3.0.5.jar", license: "Apache 2.0",
                       url: "http://maven.apache.org/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "maven-core", version: "3.0.5", libraryName: "maven-core-3.0.5.jar", license: "Apache 2.0",
                       url: "http://maven.apache.org/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Maven Aether Provider", version: "3.3.9", license: "Apache 2.0",
                           url: "http://maven.apache.org/ref/3.3.9/maven-aether-provider",
                           libraryName: 'org.apache.maven:maven-aether-provider',
                           additionalLibraryNames: ['org.apache.maven:maven-model-builder', 'org.apache.maven:maven-artifact', 'org.apache.maven:maven-repository-metadata', 'org.apache.maven:maven-builder-support'],
                           licenseUrl: "http://apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Maven Model", version: "3.0.5", libraryName: "maven-model", license: "Apache 2.0",
                           url: "http://maven.apache.org/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Maven3", attachedTo: "intellij.maven",
                       additionalLibraryNames: ["maven-dependency-tree-1.2.jar", "archetype-catalog-2.2.jar", "archetype-common-2.2.jar"],
                       version: "3.0.5", license: "Apache 2.0", url: "http://maven.apache.org/",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "mercurial_prompthooks", attachedTo: "intellij.vcs.hg", version: "",
                       license: "GPLv2 (used as hg extension called from hg executable)",
                       url: "https://github.com/willemv/mercurial_prompthooks",
                       licenseUrl: "https://github.com/willemv/mercurial_prompthooks/blob/master/LICENSE.txt"),
    new LibraryLicense(name: "Microba", libraryName: "microba", version: "0.4.2", license: "BSD", url: "http://microba.sourceforge.net/",
                       licenseUrl: "http://microba.sourceforge.net/license.txt"),
    new LibraryLicense(name: "MigLayout", libraryName: "miglayout-swing", version: "5.1.0", license: "BSD",
                       url: "http://www.miglayout.com/", licenseUrl: "http://www.miglayout.com/mavensite/license.html"),
    new LibraryLicense(name: "minlog", libraryName: "Kryo", version: "1.2", license: "BSD",
                       url: "https://github.com/EsotericSoftware/minlog", licenseUrl: "http://opensource.org/licenses/BSD-3-Clause"),
    new LibraryLicense(name: "NanoXML", version: "2.2.3", license: "zlib/libpng",
                       url: "http://mvnrepository.com/artifact/be.cyberelf.nanoxml/nanoxml/2.2.3",
                       licenseUrl: "http://www.opensource.org/licenses/zlib-license.html"),
    new LibraryLicense(name: "nekohtml", libraryName: "nekohtml", version: "1.9.14", license: "Apache 2.0",
                       url: "http://nekohtml.sourceforge.net/", licenseUrl: "http://apache.org/licenses/LICENSE-2.0.txt"),
    new LibraryLicense(name: "netty-codec-http", libraryName: "netty-codec-http", version: "4.1.24", license: "Apache 2.0",
                       url: "http://netty.io", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "netty-handler", libraryName: "netty-handler", version: "4.1.24", license: "Apache 2.0",
                       url: "http://netty.io", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Objenesis", libraryName: "Objenesis", version: "2.5.1", license: "Apache 2.0", url: "http://objenesis.org/",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt"),
    new LibraryLicense(name: "PicoContainer", libraryName: "picocontainer", version: "1.2", license: "BSD",
                       url: "https://github.com/codehaus/picocontainer", licenseUrl: "https://opensource.org/licenses/bsd-license.php"),
    new LibraryLicense(name: "plexus-archiver", libraryName: "plexus-archiver", version: "2.4.4", license: "Apache 2.0",
                       url: "https://github.com/codehaus-plexus/plexus-archiver", licenseUrl: "http://apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "plexus-classworlds", attachedTo: "intellij.maven.server.m30.impl", version: "2.4", license: "Apache 2.0",
                       url: "https://github.com/codehaus-plexus/plexus-classworlds", licenseUrl: "http://apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "plexus-component-annotations", version: "1.5.5", libraryName: "plexus-component-annotations-1.5.5.jar",
                       license: "Apache 2.0", url: "http://maven.apache.org/", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Plexus Component Annotations", libraryName: "org.codehaus.plexus:plexus-component-annotations",
                       version: "1.6", license: "Apache 2.0",
                       url: "https://codehaus-plexus.github.io/plexus-containers/plexus-component-annotations/"),
    new LibraryLicense(name: "Plexus Interpolation", libraryName: "org.codehaus.plexus:plexus-interpolation", version: "1.21",
                       license: "Apache 2.0", url: "https://codehaus-plexus.github.io/plexus-interpolation/"),
    new LibraryLicense(name: "Plexus Utils", libraryName: "plexus-utils", version: "3.0.22", license: "Apache 2.0",
                       url: "http://plexus.codehaus.org/plexus-utils"),

    new LibraryLicense(name: "pockets", attachedTo: "intellij.python.helpers", version: "0.3.2", license: "BSD",
                       url: "http://pockets.readthedocs.org/"),
    new LibraryLicense(name: "protobuf", version: "2.5.0", license: "New BSD", url: "http://code.google.com/p/protobuf/",
                       licenseUrl: "https://github.com/google/protobuf/blob/master/LICENSE"),
    new LibraryLicense(name: "Proxy Vole", libraryName: "proxy-vole", version: "1.0.5", license: "Apache 2.0",
                       url: "https://github.com/MarkusBernhardt/proxy-vole",
                       licenseUrl: "https://github.com/MarkusBernhardt/proxy-vole/blob/master/LICENSE.md"),
    new LibraryLicense(name: "pty4j", libraryName: "pty4j", version: "0.8.6", license: "Eclipse Public License v1.0",
                       url: "https://github.com/JetBrains/pty4j"),
    new LibraryLicense(name: "PureJavaComm", libraryName: "pty4j", version: "0.0.11.1", license: "BSD",
                       url: "https://github.com/nyholku/purejavacomm"),
    new LibraryLicense(name: "pycodestyle.py", attachedTo: "intellij.python.helpers", version: "2.3.1", license: "MIT",
                       url: "http://pycodestyle.readthedocs.io/"),
    new LibraryLicense(name: "Relax NG Object Model", libraryName: "rngom-20051226-patched.jar", license: "MIT",
                       url: "http://java.net/projects/rngom/", licenseUrl: "http://www.opensource.org/licenses/mit-license.php"),
    new LibraryLicense(name: "RMI Stubs", attachedTo: "intellij.xslt.debugger.engine", license: "Apache 2.0",
                       url: "https://confluence.jetbrains.com/display/CONTEST/XSLT-Debugger",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "Roboto", attachedTo: "intellij.platform.resources", version: "1.100141", license: "Apache 2.0",
                       url: "https://github.com/google/roboto/blob/master/LICENSE"),
    new LibraryLicense(name: "sa-jdwp", version: "1.12", license: "GPL 2.0 + Classpath", url: "https://github.com/JetBrains/jdk-sa-jdwp",
                       licenseUrl: "https://raw.githubusercontent.com/JetBrains/jdk-sa-jdwp/master/LICENSE.txt"),
    new LibraryLicense(name: "Saxon-6.5.5", version: "6.5.5", license: "Mozilla Public License", url: "http://saxon.sourceforge.net/",
                       licenseUrl: "http://www.mozilla.org/MPL/"),
    new LibraryLicense(name: "Saxon-9HE", version: "9", license: "Mozilla Public License", url: "http://saxon.sourceforge.net/",
                       licenseUrl: "http://www.mozilla.org/MPL/"),
    new LibraryLicense(name: "SceneBuilderKit", version: "8.2.0", license: "BSD", url: "http://gluonhq.com/open-source/scene-builder/",
                       licenseUrl: "http://www.oracle.com/technetwork/licenses/bsd-license-1835287.html"),
    new LibraryLicense(name: "six.py", attachedTo: "intellij.python.helpers", version: "1.9.0", license: "MIT",
                       url: "http://pythonhosted.org/six/"),
    new LibraryLicense(name: "Slf4j", version: "1.7.25", license: "MIT License", url: "http://slf4j.org/",
                       licenseUrl: "http://slf4j.org/license.html"),
    new LibraryLicense(name: "SnakeYAML", libraryName: "snakeyaml", version: "1.21", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0", url: "https://bitbucket.org/asomov/snakeyaml"),
    new LibraryLicense(name: "SnuggleTeX", version: "1.3 (with patches by JetBrains)", license: "BSD",
                       url: "http://snuggletex.sourceforge.net/", licenseUrl: "http://snuggletex.sourceforge.net/maven/license.html"),
    new LibraryLicense(name: "Sonatype Nexus Indexer Artifact", libraryName: "nexus-indexer-artifact-1.0.1.jar", version: "1.0.1",
                       license: "Eclipse Public License v1.0", url: "http://nexus.sonatype.org/",
                       licenseUrl: "http://www.eclipse.org/org/documents/epl-v10.html"),
    new LibraryLicense(name: "Sonatype Nexus: Indexer", libraryName: "nexus-indexer-1.2.3.jar", version: "1.2.3",
                       license: "Eclipse Public License v1.0", url: "http://nexus.sonatype.org/",
                       licenseUrl: "http://www.eclipse.org/org/documents/epl-v10.html"),
    new LibraryLicense(name: "Sonatype Nexus: Indexer", libraryName: "nexus-indexer-3.0.4.jar", version: "3.0.4",
                       license: "Eclipse Public License v1.0", url: "http://nexus.sonatype.org/",
                       licenseUrl: "http://www.eclipse.org/org/documents/epl-v10.html"),
    new LibraryLicense(name: "SourceCodePro", attachedTo: "intellij.platform.resources", version: "2.010", license: "OFL",
                       url: "https://github.com/adobe-fonts/source-code-pro",
                       licenseUrl: "https://github.com/adobe-fonts/source-code-pro/blob/master/LICENSE.md"),
    new LibraryLicense(name: "Spantable", libraryName: "spantable.jar", version: "patched", license: "LGPL 2.1",
                       licenseUrl: "http://www.gnu.org/licenses/lgpl.html",
                       url: "https://android.googlesource.com/platform/prebuilts/tools/+/master/common/spantable/"),
    new LibraryLicense(name: "sphinxcontrib-napoleon", attachedTo: "intellij.python.helpers", version: "0.3.11", license: "BSD",
                       url: "http://sphinxcontrib-napoleon.readthedocs.org/"),
    new LibraryLicense(name: "StreamEx", version: "0.6.2", libraryName: "StreamEx", license: "Apache 2.0",
                       url: "https://github.com/amaembo/streamex", licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0"),
    new LibraryLicense(name: "swingx", libraryName: "swingx", version: "1.6.2-2", license: "LGPL 2.1",
                       url: "http://java.net/downloads/swingx/", licenseUrl: "http://www.opensource.org/licenses/lgpl-2.1.php"),
    new LibraryLicense(name: "TestNG", version: "6.9 snapshot", license: "Apache 2.0", url: "http://testng.org/doc/",
                       licenseUrl: "https://github.com/cbeust/testng/blob/master/LICENSE.txt"),
    new LibraryLicense(name: "Thrift", libraryName: "libthrift", version: "0.11.0", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt", url: "https://thrift.apache.org/"),
    new LibraryLicense(name: "Trilead SSH", libraryName: "trilead-ssh2", version: "build-217-jenkins-11", license: "BSD style",
                       licenseUrl: "https://github.com/jenkinsci/trilead-ssh2/blob/master/LICENSE.txt",
                       url: "https://github.com/jenkinsci/trilead-ssh2"),
    new LibraryLicense(name: "Trilead SSH build213", libraryName: "trilead-ssh2-build213", version: "build213",
                       license: "BSD style (see LICENSE.txt in trilead-ssh2-build213.jar)", url: "http://www.trilead.com/SSH_Library/"),
    new LibraryLicense(name: "Trove4j", version: "1.1 (with patches by JetBrains)", license: "LGPL", url: "http://trove4j.sourceforge.net/",
                       licenseUrl: "http://trove4j.sourceforge.net/html/license.html"),
    new LibraryLicense(name: "Velocity", version: "1.7", license: "Apache 2.0", url: "http://velocity.apache.org/",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt"),
    new LibraryLicense(name: "weberknecht", libraryName: "weberknecht-0.1.5.jar", version: "0.1.5", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0", url: "https://github.com/pelotoncycle/weberknecht"),
    new LibraryLicense(name: "winp", version: "1.26", license: "MIT", url: "https://github.com/kohsuke/winp",
                       licenseUrl: "http://opensource.org/licenses/mit-license.php"),
    new LibraryLicense(name: "Xalan", libraryName: "Xalan-2.7.2", version: "2.7.2", license: "Apache 2.0",
                       url: "http://xalan.apache.org/xalan-j/", licenseUrl: "http://xalan.apache.org/xalan-j/#license"),
    new LibraryLicense(name: "Xerces", version: "2.11", license: "Apache 2.0", url: "http://xerces.apache.org/xerces2-j/",
                       licenseUrl: "http://xerces.apache.org/xerces2-j/"),
    new LibraryLicense(name: "Xerial SQLite JDBC", libraryName: "sqlite", version: "3.20.1", license: "Apache 2.0",
                       url: "https://github.com/xerial/sqlite-jdbc"),

    new LibraryLicense(name: "xml-apis-ext", libraryName: "xml-apis-ext", version: "1.3", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt",
                       url: "http://xerces.apache.org/xml-commons/components/external"),
    new LibraryLicense(name: "xml-resolver", libraryName: "xml-resolver", version: "1.2.0", license: "Apache 2.0",
                       url: "http://xml.apache.org/commons/components/resolver/",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt"),

    new LibraryLicense(name: "XML Commons (xml-apis.jar, resolver.jar)", version: "",
                           license: "Apache 2.0, W3C Software License , public domain", url: "http://xml.apache.org/commons/",
                           licenseUrl: "http://xml.apache.org/commons/licenses.html"),
    new LibraryLicense(name: "XMLBeans", libraryName: "XmlBeans", version: "2.3.0", license: "Apache 2.0",
                       url: "http://xmlbeans.apache.org/",
                       licenseUrl: "http://svn.jetbrains.org/idea/Trunk/bundled/WebServices/resources/lib/xmlbeans-2.3.0/xmlbeans.LICENSE"),
    new LibraryLicense(name: "xmlgraphics-commons", libraryName: "xmlgraphics-commons", version: "1.5", license: "Apache 2.0",
                       licenseUrl: "http://www.apache.org/licenses/LICENSE-2.0.txt", url: "https://xmlgraphics.apache.org/commons/"),
    new LibraryLicense(name: "XmlRPC", libraryName: "XmlRPC", version: "2.0", license: "Apache 2.0",
                           url: "http://ws.apache.org/xmlrpc/xmlrpc2/", licenseUrl: "http://ws.apache.org/xmlrpc/xmlrpc2/license.html"),
    new LibraryLicense(name: "XStream", libraryName: "XStream", version: "1.4.2", license: "BSD License",
                       url: "https://github.com/codehaus/xstream",
                       licenseUrl: "https://github.com/codehaus/xstream/blob/master/LICENSE.txt"),
    new LibraryLicense(name: "XStream", version: "1.4.3", license: "BSD", url: "https://github.com/codehaus/xstream",
                       licenseUrl: "https://github.com/codehaus/xstream/blob/master/LICENSE.txt"),
    new LibraryLicense(name: "XZ for Java", libraryName: "xz", version: "1.5", license: "Public Domain",
                       url: "http://tukaani.org/xz/java.html"),
    new LibraryLicense(name: "YourKit Java Profiler", libraryName: "yjp-controller-api-redist.jar", version: "8.0.x",
                       license: "link (commercial license)", url: "http://yourkit.com/",
                       licenseUrl: "http://www.yourkit.com/purchase/license.html"),

    jetbrainsLibrary("CoverageReport"),
    jetbrainsLibrary("intellij-coverage"),
    jetbrainsLibrary("intellij-markdown"),
    jetbrainsLibrary("intellij-test-discovery"),
    jetbrainsLibrary("JPS"),
    jetbrainsLibrary("KotlinJavaRuntime"),
    jetbrainsLibrary("KotlinScriptRuntime"),
    jetbrainsLibrary("KotlinTest"),
    jetbrainsLibrary("kotlinx-coroutines-core"),
    jetbrainsLibrary("kotlinx-coroutines-jdk8"),
    jetbrainsLibrary("Maven Embedder"),
    jetbrainsLibrary("optimizedFileManager.jar"),
    jetbrainsLibrary("precompiled_jshell-frontend"),
    jetbrainsLibrary("tcServiceMessages"),
  ] as List<LibraryLicense>
}