/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2020 Ian McInerney <ian.s.mcinerney at ieee dot org>
 * Copyright (C) 2020 KiCad Developers, see AUTHORS.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <wx/log.h>

/**
 * A logger class that filters out all log messages that are not generated by wxLogTrace
 * and ignores them, while passing the trace messages onwards.
 */
class WX_LOG_TRACE_ONLY : public wxLogInterposerTemp
{
public:
    WX_LOG_TRACE_ONLY() : wxLogInterposerTemp()
    {
    }

protected:
    void DoLogRecord( wxLogLevel aLevel, const wxString& aMsg,
                      const wxLogRecordInfo& aInfo ) override
    {
        // Only forward the message if it is a trace message
        if( aLevel == wxLOG_Trace )
            wxLogInterposerTemp::DoLogRecord( aLevel, aMsg, aInfo );
    }
};
