#| -*-Scheme-*-

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
    2017, 2018, 2019 Massachusetts Institute of Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

|#

;;;; UCD property: gc (general-category)

;;; Generated from Unicode 9.0.0

(declare (usual-integrations))

(define (ucd-gc-value char)
  (let ((sv (char->integer char)))
    (vector-ref ucd-gc-table-5 (bytevector-u8-ref ucd-gc-table-4 (fix:or (fix:lsh (bytevector-u16be-ref ucd-gc-table-3 (fix:lsh (fix:or (fix:lsh (bytevector-u8-ref ucd-gc-table-2 (fix:or (fix:lsh (bytevector-u8-ref ucd-gc-table-1 (fix:or (fix:lsh (bytevector-u8-ref ucd-gc-table-0 (fix:lsh sv -16)) 4) (fix:and 15 (fix:lsh sv -12)))) 4) (fix:and 15 (fix:lsh sv -8)))) 4) (fix:and 15 (fix:lsh sv -4))) 1)) 4) (fix:and 15 sv))))))

(define-deferred ucd-gc-table-0
  (vector->bytevector '#(0 1 2 3 3 3 3 3 3 3 3 3 3 3 4 5 5)))

(define-deferred ucd-gc-table-1
  (vector->bytevector '#(0 1 2 3 4 5 5 5 5 6 7 5 5 8 9 10 11 12 13 14 15 16 17 5 18 16 16 19 16 20 21 22 5 5 5 5 5 5 5 5 5 5 23 24 25 16 16 26 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 27 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 28)))

(define-deferred ucd-gc-table-2
  (vector->bytevector
   '#(0  1  2  3  4  5  6  7  8  9  10 11 12 13 14 15 16 17 18 19 20 17 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 33 41 42 43 44 45 46 47 48 39 17 17 17 17 17 17 17 17 17 17 17 17  17 17 17  17 17 17 17 17 17  17 17 17 17 49 17 17 17 17 17 17 17  17 17 17 17  17  17  17  17  17  17  17  17 17 17  17 17 17 17 17 17  17 17 17 17 17 17 50 51  17  17 17 52 17 53  54 55  56  57  58  17 17 17  17  17  17  17 17 17 17 17 59 60 60 60 60 60 60 60  60 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61  61  61 61 61 61 61 61 61 61 17 62 63 17 64 65 66 67 68 69 70 71 72 17  73 74 75 76 77 78 79 80 79 81 82 83  84 85 86 87 88 89  79  90 79 91 79 79 79 17 17 17 92 93 94 79 79 79 79 79 79 79 79 79 79 17 17 17 17 95 79 79 79
      79 79 79 79 79 79 79 79 79 79 79 79 17 17 96 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 79 17 17 97 98 79 79 79 99 17 17 17 17 17 17 17 100 17 17 101 79 79 79 79 79 102 79 79 79 79 79 79 79 79 79 79 79 103 79 79 79 104 105 106 107 108 109 110 111 39 39 112 79 79 79 79 79 113 79 79 79 79 79 79 79 114 115 79 79 79 79 116 79 117 118 119 120 39 39 121 122 123 124 79 79 79 79 79 79 17 17 17 17 17 17 125 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 126 127 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 128 79 79 79 79 79 79 79 79 79 17 17 129 79 79 79 79 79 130 131 79 79 79 79 79 79 79 79 79 79 79 79 79 79 61 61 61 61 61 61 61 61 61 61 61 61 61 61 61 132)))

(define-deferred ucd-gc-table-3
  (vector->bytevector-u16be
   '#(0   0   1   2   3   4   5   6   0   0   7   8   9   10  11  12  13  13  13  14  15  13  13  16  17  18  19  20  21  22  13  23  13  13  13  24  25  11  11  11  11  26  11  27  28  29  30  31  32  32  32  32  32  32  32  33  34  35  36  11  37  38  13  39  9   9   9   11  11  11  13  13  40  13  13  13  41  13  13  13  13  13  13  42  9   43  44  11  45  46  32  47  48  49  50  51  52  53  49  49  54  32  55  56  49  49  49  49  49  57  58  59  60  61  49  32  62  49  49  49  49  49  63  64  65  49  66  67  49  68  69  70  49  71  72  72  72  72  49  73  72  74  75  32  76  49  49  77  78  79  80  81  82  83  84  85  86  87  88  89  90  83  84  91  92  93  94  95  96  97  84  98  99  100 88  101 102 83  84  103 104 105 88  106 107 108 109 110 111 112 94  113 114 115 84  116 117 118 88  119 120 115 84  121 122 123 88  124 125 115 49  126 127 128 88  129 130 131 49  132 133 134 94  135 136 49  49  137 138 139 72  72  140 141 142 143 144 145 72  72  146 147 148 149 150 49  151
      152 153 154 32  155 156 157 72  72  49  49  158 159 160 161 162 163 164 165 9   9   166 49  49  167 49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  168 169 49  49  168 49  49  170 171 172 49  49  49  171 49  49  49  173 174 175 49  176 9   9   9   9   9   177 178 49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  179 49  180 181 49  49  49  49  182 183 184 185 49  186 49  187 184 188 49  49  49  189 190 191 192 193 194 192 49  49  195 49  49  196 197 49  198 49  49  49  49  199 49  200 201 202 203 49  204 205 49  49  206 49  207 208 209 209 49  210 49  49  49  211 212 213 192 192 214 215 72  72  72  72  216 49  49  217 218 160 219 220 221 49  222 65  49  49  223 224 49  49  225 226 227 65  49  228 229 72  72  72  230 231 232 233 11  11  234 27  27  27  235 236 11  237 27  27  32  32  32  238 13  13  13  13  13  13  13  13  13  239 13  13  13  13  13  13  240 241 240 240 241 242 240 243 244 244 244 245 246 247
      248 249 250 251 252 253 254 255 256 257 258 259 260 261 72  262 263 264 265 266 267 268 269 270 271 271 272 273 274 209 275 276 209 277 278 278 278 278 278 278 278 278 278 278 278 278 278 278 278 278 279 209 280 209 209 209 209 281 209 282 278 283 209 284 285 286 209 209 287 72  288 72  270 270 270 289 209 209 209 209 290 270 209 209 209 209 209 209 209 209 209 209 209 291 292 209 209 293 209 209 209 209 209 209 294 209 209 209 209 209 209 209 209 209 209 209 209 209 209 209 295 296 270 297 209 209 298 278 299 278 209 209 209 209 209 209 209 209 209 209 209 209 209 209 209 209 278 278 278 278 278 278 278 278 300 301 278 278 278 302 278 303 209 209 209 278 304 209 209 305 209 306 209 307 308 309 310 72  9   9   311 11  11  312 313 314 13  13  13  13  13  13  315 316 11  11  317 49  49  49  318 319 49  320 321 321 321 321 32  32  322 323 324 325 326 72  72  72  209 327 209 209 209 209 209 328 209 209 209 209 209 209 209 209 209 209 209 209 209 329 72  330 331 332 333 334 136
      49  49  49  49  335 178 49  49  49  49  336 337 49  204 136 49  49  49  49  200 338 49  50  209 209 328 49  209 286 339 209 340 341 209 209 339 209 209 341 209 209 209 286 49  49  49  49  49  49  49  49  49  49  49  199 209 209 209 209 49  49  49  49  49  49  49  49  49  49  49  49  49  199 72  72  49  342 49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  151 209 209 209 287 49  49  228 343 49  344 72  13  13  345 346 13  347 49  49  49  49  348 349 31  350 351 352 13  13  13  353 354 355 356 357 72  72  72  358 359 49  360 361 49  49  49  362 363 49  49  364 365 192 32  366 65  49  367 49  368 369 49  151 76  49  49  370 371 372 373 374 49  49  375 376 377 378 49  379 49  49  49  380 381 382 383 384 385 386 321 11  11  387 388 11  11  11  11  11  49  49  389 192 49  49  49  49  49  49  49  49  49  49  390 49  391 49  49  206 392 392 392 392 392 392 392 392 392 392 392 392 392 392 392 392 393 393 393 393 393 393 393 393 393 393 393 393
      393 393 393 393 49  49  49  49  49  49  204 49  49  49  49  49  49  207 72  72  394 395 396 397 398 49  49  49  49  49  49  399 400 401 49  49  49  49  49  402 72  49  49  49  49  403 49  49  196 72  72  404 32  405 32  406 407 408 409 410 49  49  49  49  49  49  49  411 412 2   3   4   5   413 414 415 49  416 49  200 417 418 419 420 421 49  172 422 204 204 72  72  49  49  49  49  49  49  49  50  423 270 270 424 271 271 271 425 426 330 427 72  72  209 209 428 72  72  72  72  72  72  72  72  49  151 49  49  49  100 429 430 49  49  431 49  432 49  49  433 49  434 49  49  435 436 72  72  9   9   437 11  11  49  49  49  49  204 192 9   9   438 11  439 49  49  196 49  49  49  440 72  72  72  72  72  72  72  72  72  49  49  49  320 49  199 196 72  72  72  72  72  72  72  72  72  441 49  49  442 49  443 49  444 49  200 445 72  72  72  49  446 49  447 49  448 72  72  72  72  49  49  49  449 270 450 270 270 451 452 49  453 454 455 49  456 49  457 72  72  458 49  459 460 49  49  49
      461 49  462 49  463 49  464 465 72  72  72  72  72  49  49  49  49  466 72  72  72  9   9   9   467 11  11  11  468 72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  270 469 72  72  72  72  72  72  72  72  470 49  49  471 472 450 473 474 221 49  49  475 476 49  466 192 477 49  478 479 480 49  49  481 221 49  49  482 483 484 485 486 49  97  487 488 72  72  72  72  489 490 491 49  49  492 493 192 494 83  84  98  495 496 497 498 72  72  72  72  72  72  72  72  49  49  49  499 500 501 72  72  49  49  49  502 503 192 72  72  72  72  72  72  72  72  72  72  49  49  504 505 506 507 72  72  49  49  49  508 509 192 510 72  49  49  511 512 192 72  72  72  49  513 514 515 72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  9   9   11  11  148 516 72  72  72  72  72  72  72  72  72  72  72  72  49  49  49  466 84  49  504 517 518 148 175 519 49  520 521 522 72  72  72  72  49  49  49  49  49  49  49  49  49  207
      72  72  72  72  72  72  271 271 271 271 271 271 523 524 49  49  49  49  49  49  49  49  49  49  49  49  390 72  72  72  72  72  72  72  72  72  72  72  49  49  200 72  72  72  72  72  72  72  72  72  72  72  72  72  49  49  49  49  320 72  72  72  72  72  72  72  72  72  72  72  49  49  49  466 49  200 372 72  72  72  72  72  72  49  204 525 49  49  49  526 527 528 529 530 49  72  72  72  72  72  72  72  49  49  49  49  205 531 532 533 474 534 72  72  72  72  535 72  49  49  49  49  49  49  49  49  49  49  49  49  49  49  151 72  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  536 537 72  72  72  72  72  72  72  72  72  72  72  72  72  72  72  49  49  49  49  49  49  50  151 466 538 539 72  72  72  72  72  209 209 209 209 209 209 209 209 209 209 209 209 209 209 209 329 209 209 540 209 209 209 541 542 543 209 544 209 209 209 545 72  209 209 209 209 546 72  72  72  72  72  72  72  72  72  72  72  209 209 209 209 209 287 270 547 72  72  72  72  72  72  72  72  9
      548 11  549 550 551 240 9   552 553 554 555 556 9   548 11  557 558 11  559 560 561 562 9   563 11  9   548 11  549 550 11  240 9   552 562 9   563 11  9   548 11  564 9   565 566 567 568 11  569 9   570 571 572 573 11  574 9   575 11  576 577 577 577 32  32  32  578 32  32  579 580 581 582 46  72  72  72  72  72  583 584 585 72  72  72  72  72  72  72  72  72  72  72  72  72  49  49  49  49  49  49  49  49  49  49  49  49  586 587 72  72  9   9   552 11  588 372 72  72  72  72  72  72  72  72  72  72  589 49  590 591 592 593 594 595 596 206 597 206 72  72  72  598 209 209 330 209 209 209 209 209 209 328 286 599 599 599 209 329 175 209 286 209 209 209 330 209 209 209 600 72  72  72  601 209 602 209 209 330 545 309 72  72  72  72  72  72  72  72  72  72  209 209 209 209 209 209 209 209 209 209 209 209 209 209 209 603 209 209 209 209 209 209 209 209 209 209 209 209 209 602 600 287 209 209 209 209 209 209 209 328 209 209 209 209 209 604 72  72  330 209 209 209 605 176 209 209
      605 209 606 72  72  72  72  72  72  286 605 607 330 286 72  72  209 309 72  72  427 72  72  72  49  49  49  49  49  49  49  49  49  49  49  49  49  320 72  72  49  49  49  205 49  49  49  49  49  49  49  49  49  49  49  49  49  204 49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  49  537 72  72  72  72  72  49  204 72  72  72  72  72  72  72  72  72  72  72  72  72  72  608 72  609 609 609 609 609 609 72  72  72  72  72  72  72  72  32  32  32  32  32  32  32  32  32  32  32  32  32  32  32  72  393 393 393 393 393 393 393 393 393 393 393 393 393 393 393 610)))

(define-deferred ucd-gc-table-4
  (vector->bytevector
   '#(0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  2  2  2  3  2  2  2  4  5  2  6  2  7  2  2  8  8  8  8  8  8  8  8  8  8  2  2  6  6  6  2  2  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  4  2  5  10 11 10 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 4  6  5  6  0  1  2  3  3  3  3  13 2  10 13 14 15 6  16 13 10 13 6  17 17 10 12 2  2  10 17 14 18 17 17 17 2  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  6  9  9  9  9  9  9  9  12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 6  12 12 12 12 12 12 12 12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  9  12 9  12 9  12 12 12 9  9  12 9  12 9  9  12 9  9  9  12 12 9  9  9  9  12 9  9  12 9  9  9  12 12 12 9  9  12 9  9  12 9  12 9  12 9  9  12 9  12 12 9  12 9  9  12 9  9  9  12 9  12 9  9  12
      12 14 9  12 12 12 14 14 14 14 9  19 12 9  19 12 9  19 12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 12 9  12 12 9  19 12 9  12 9  9  9  12 9  12 9  12 9  12 9  12 9  12 12 12 12 12 12 12 9  9  12 9  9  12 12 9  12 9  9  9  9  12 9  12 9  12 9  12 9  12 12 12 12 12 14 12 12 12 12 12 12 12 12 12 12 12 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 10 10 10 10 20 20 20 20 20 20 20 20 20 20 20 20 10 10 10 10 10 10 10 10 10 10 10 10 10 10 20 20 20 20 20 10 10 10 10 10 10 10 20 10 20 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 9  12 9  12 20 10 9  12 22 22 20 12 12 12 2  9  22 22 22 22 10 10 9  2  9  9  9  22 9  22 9  9  12 9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  22 9  9  9  9  9  9  9  9  9  12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 9  12 12 9  9  9  12 12 12 9  12 9  12 9  12 9  12 12 12 12 12 9  12 6  9  12 9  9  12 12 9  9  9  9  12 13 21 21 21 21 21 23 23 9  12 9  12 9  12 9  9  12 9
      12 9  12 9  12 9  12 9  12 9  12 12 22 9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  22 22 20 2  2  2  2  2  2  22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 2  7  22 22 13 13 3  22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 7  21 2  21 21 2  21 21 2  21 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 14 14 14 2  2  22 22 22 22 22 22 22 22 22 22 22 16 16 16 16 16 16 6  6  6  2  2  3  2  2  13 13 21 21 21 21 21 21 21 21 21 21 21 2  16 22 2  2  20 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 8  8  8  8  8  8  8  8  8  8  2  2  2  2  14 14 21 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 2  14 21 21 21 21 21 21 21 16 13 21 21 21 21 21 21 20 20 21 21 13 21 21 21 21 14 14 8  8  8  8  8  8  8  8  8  8  14 14 14 13 13 14 2  2  2  2  2  2  2  2  2  2  2  2  2  2  22 16 14 21 14 14 14 14 14 14 14 14 14 14 14 14
      14 14 21 21 21 21 21 21 21 21 21 21 21 22 22 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 8  8  8  8  8  8  8  8  8  8  14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 20 20 13 2  2  2  20 22 22 22 22 22 14 14 14 14 14 14 21 21 21 21 20 21 21 21 21 21 21 21 21 21 20 21 21 21 20 21 21 21 21 21 22 22 2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  22 14 14 14 14 14 14 14 14 14 21 21 21 22 22 2  22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 22 14 14 14 14 14 14 14 14 22 22 22 22 22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 16 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 21 14 24 24 24 21 21 21 21 21 21 21 21 24 24 24 24 21 24 24 14 21 21 21 21 21 21 21 14 14 14 14 14 14 14 14 14 14 21 21 2  2  8  8  8  8  8  8  8  8  8  8  2  20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 24 22 14 14 14
      14 14 14 14 14 22 22 14 14 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 22 14 22 22 22 14 14 14 14 22 22 21 14 24 24 24 21 21 21 21 22 22 24 24 22 22 24 24 21 14 22 22 22 22 22 22 22 22 24 22 22 22 22 14 14 22 14 14 14 21 21 22 22 8  8  8  8  8  8  8  8  8  8  14 14 3  3  17 17 17 17 17 17 13 3  22 22 22 22 22 21 21 24 22 14 14 14 14 14 14 22 22 22 22 14 14 22 14 14 22 14 14 22 14 14 22 22 21 22 24 24 24 21 21 22 22 22 22 21 21 22 22 21 21 21 22 22 22 21 22 22 22 22 22 22 22 14 14 14 14 22 14 22 22 22 22 22 22 22 8  8  8  8  8  8  8  8  8  8  21 21 14 14 14 21 22 22 22 22 22 22 22 22 22 22 22 21 21 24 22 14 14 14 14 14 14 14 14 14 22 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 14 14 14 14 14 22 22 21 14 24 24 24 21 21 21 21 21 22 21 21 24 22 24 24 21 22 22 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 2  3  22 22 22 22 22 22 22 14 22 22 22 22 22 22 22 21 24 24 22 14 14 14 14 14 14 14 14 22 22 14 14 22
      14 14 22 14 14 14 14 14 22 22 21 14 24 21 24 21 21 21 21 22 22 24 24 22 22 24 24 21 22 22 22 22 22 22 22 22 21 24 22 22 22 22 14 14 22 14 13 14 17 17 17 17 17 17 22 22 22 22 22 22 22 22 22 22 21 14 22 14 14 14 14 14 14 22 22 22 14 14 14 22 14 14 14 14 22 22 22 14 14 22 14 22 14 14 22 22 22 14 14 22 22 22 14 14 14 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 24 24 21 24 24 22 22 22 24 24 24 22 24 24 24 21 22 22 14 22 22 22 22 22 22 24 22 22 22 22 22 22 22 22 17 17 17 13 13 13 13 13 13 3  13 22 22 22 22 22 21 24 24 24 22 14 14 14 14 14 14 14 14 22 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 14 21 21 21 24 24 24 24 22 21 21 21 22 21 21 21 21 22 22 22 22 22 22 22 21 21 22 14 14 14 22 22 22 22 22 22 22 22 22 22 22 22 22 17 17 17 17 17 17 17 13 14 21 24 24 22 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 22 14 14 14 14 14 22 22 21 14 24 21 24 24 24 24 24 22 21 24 24 22 24 24 21 21 22 22 22 22 22 22 22 24 24 22 22 22 22 22
      22 22 14 22 22 14 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 24 24 22 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 14 24 24 24 21 21 21 21 22 24 24 24 22 24 24 24 21 14 13 22 22 22 22 14 14 14 24 17 17 17 17 17 17 17 14 17 17 17 17 17 17 17 17 17 13 14 14 14 14 14 14 22 22 24 24 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 22 14 22 22 14 14 14 14 14 14 14 22 22 22 21 22 22 22 22 24 24 24 21 21 21 22 21 22 24 24 24 24 24 24 24 24 22 22 24 24 2  22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 14 14 21 21 21 21 21 21 21 22 22 22 22 3  14 14 14 14 14 14 20 21 21 21 21 21 21 21 21 2  8  8  8  8  8  8  8  8  8  8  2  2  22 22 22 22 22 14 14 22 14 22 22 14 14 22 14 22 22 14 22 22 22 22 22 22 14 14 14 14 22 14 14 14 14 14 14 14 22 14 14 14 22 14 22 14 22 22 14 14 22 14 14 14 14 21 14 14 21 21 21 21 21 21 22 21 21 14 22 22 14 14 14 14 14 22
      20 22 21 21 21 21 21 21 22 22 8  8  8  8  8  8  8  8  8  8  22 22 14 14 14 14 14 13 13 13 2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  13 2  13 13 13 21 21 13 13 13 13 13 13 8  8  8  8  8  8  8  8  8  8  17 17 17 17 17 17 17 17 17 17 13 21 13 21 13 21 4  5  4  5  24 24 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 24 21 21 21 21 21 2  21 21 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 22 13 13 13 13 13 13 13 13 21 13 13 13 13 13 13 22 13 13 2  2  2  2  2  13 13 13 13 2  2  22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 24 24 21 21 21 21 24 21 21 21 21 21 21 24 21 21 24 24 21 21 14 8  8  8  8  8  8  8  8  8  8  2  2  2  2  2  2  14 14 14 14 14 14 24 24 21 21 14 14 14 14 21 21 21 14 24 24 24 14 14 24 24 24 24 24 24 24 14 14 14 21 21 21 21 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 24 21 21 24 24 24 24 24 24 21 14 24
      8  8  8  8  8  8  8  8  8  8  24 24 24 21 13 13 9  9  9  9  9  9  22 9  22 22 22 22 22 9  22 22 14 14 14 14 14 14 14 14 14 14 14 2  20 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 22 22 14 14 14 14 14 14 14 22 14 22 14 14 14 14 22 22 14 22 14 14 14 14 22 22 14 14 14 14 14 14 14 22 14 22 14 14 14 14 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 21 21 21 2  2  2  2  2  2  2  2  2  17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 9  9  9  9  9  9  22 22 12 12 12 12 12 12 22 22 7  14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 2  2  14 1  14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 4  5  22 22 22 14 14 14 14 14 14 14 14 14 14 14 2  2  2  25 25 25 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 21 21 21 22 22 22 22 22
      22 22 22 22 22 22 14 14 21 21 21 2  2  22 22 22 22 22 22 22 22 22 14 14 21 21 22 22 22 22 22 22 22 22 22 22 22 22 14 22 21 21 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 21 21 24 21 21 21 21 21 21 21 24 24 24 24 24 24 24 24 21 24 24 21 21 21 21 21 21 21 21 21 21 21 2  2  2  20 2  2  2  3  14 21 22 22 8  8  8  8  8  8  8  8  8  8  22 22 22 22 22 22 17 17 17 17 17 17 17 17 17 17 22 22 22 22 22 22 2  2  2  2  2  2  7  2  2  2  2  21 21 21 16 22 14 14 14 20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 22 14 14 14 14 14 21 21 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 14 22 22 22 22 22 14 14 14 14 14 14 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 21 21 21 24 24 24 24 21 21 24 24 24 22 22 22 22 24 24 21 24 24 24 24 24 24 21 21 21 22 22 22 22 13 22 22 22 2  2  8  8  8  8  8  8  8  8  8  8  14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 14 14 14 14 14 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14
      14 14 14 14 14 14 14 14 22 22 22 22 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 22 8  8  8  8  8  8  8  8  8  8  17 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 14 14 14 14 14 14 14 21 21 24 24 21 22 22 2  2  14 14 14 14 14 24 21 24 21 21 21 21 21 21 21 22 21 24 21 24 24 21 21 21 21 21 21 21 21 24 24 24 24 24 24 21 21 21 21 21 21 21 21 21 21 22 22 21 2  2  2  2  2  2  2  20 2  2  2  2  2  2  22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 23 22 21 21 21 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 21 21 21 21 21 24 21 24 24 24 24 24 21 24 24 14 14 14 14 14 14 14 22 22 22 22 2  13 13 13 13 13 13 13 13 13 13 21 21 21 21 21 21 21 21 21 13 13 13 13 13 13 13 13 13 22 22 22 21 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 24 21 21 21 21 24 24 21 21 24 21 21 21 14 14 14 14 14 14 14 14 21 24 21 21 24 24 24 21 24 21 21 21 24 24 22 22 22 22 22 22 22 22 2  2  2  2  14 14 14 14 24 24 24 24 24 24 24 24 21 21 21 21 21 21 21 21 24 24 21 21 22 22 22 2  2  2
      2  2  8  8  8  8  8  8  8  8  8  8  22 22 22 14 14 14 14 14 14 14 14 14 14 14 20 20 20 20 20 20 2  2  12 12 12 12 12 12 12 12 12 22 22 22 22 22 22 22 2  2  2  2  2  2  2  2  22 22 22 22 22 22 22 22 21 21 21 2  21 21 21 21 21 21 21 21 21 21 21 21 21 24 21 21 21 21 21 21 21 14 14 14 14 21 14 14 14 14 24 24 21 14 14 22 21 21 22 22 22 22 22 22 12 12 12 12 12 12 12 12 12 12 12 12 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 12 12 12 12 12 12 12 12 12 12 12 12 12 20 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 20 20 20 20 20 21 21 21 21 21 21 22 22 22 22 22 21 21 21 21 21 9  12 9  12 9  12 12 12 12 12 12 12 12 12 9  12 12 12 12 12 12 12 12 12 9  9  9  9  9  9  9  9  12 12 12 12 12 12 22 22 9  9  9  9  9  9  22 22 12 12 12 12 12 12 12 12 22 9  22 9  22 9  22 9  12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 22 12 12 12 12 12 12 12 12 19 19 19 19 19 19 19 19 12 12 12 12 12 22 12 12 9  9  9  9  19 10 12 10 10 10 12 12 12 22 12 12 9  9  9  9  19 10 10 10 12 12 12 12 22 22 12 12
      9  9  9  9  22 10 10 10 12 12 12 12 12 12 12 12 9  9  9  9  9  10 10 10 22 22 12 12 12 22 12 12 9  9  9  9  19 10 10 22 1  1  1  1  1  1  1  1  1  1  1  16 16 16 16 16 7  7  7  7  7  7  2  2  15 18 4  15 15 18 4  15 2  2  2  2  2  2  2  2  26 27 16 16 16 16 16 1  2  2  2  2  2  2  2  2  2  15 18 2  2  2  2  11 11 2  2  2  6  4  5  2  2  2  2  2  2  2  2  2  2  2  6  2  11 2  2  2  2  2  2  2  2  2  2  1  16 16 16 16 16 22 16 16 16 16 16 16 16 16 16 16 17 20 22 22 17 17 17 17 17 17 6  6  6  4  5  20 17 17 17 17 17 17 17 17 17 17 6  6  6  4  5  22 20 20 20 20 20 20 20 20 20 20 20 20 20 22 22 22 3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  3  22 21 21 21 21 21 21 21 21 21 21 21 21 21 23 23 23 23 21 23 23 23 21 21 21 21 21 21 21 21 21 21 21 21 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 9  13 13 13 13 9  13 13 12 9  9  9  12 12 9  9  9  12 13 9  13 13 6  9  9  9  9  9  13 13 13 13 13 13 9  13 9  13 9  13 9  9  9  9  13 12 9  9
      9  9  12 14 14 14 14 12 13 13 12 12 9  9  6  6  6  6  6  9  12 12 12 12 13 6  13 13 12 13 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 9  12 25 25 25 25 17 13 13 22 22 22 22 6  6  6  6  6  13 13 13 13 13 6  6  13 13 13 13 6  13 13 6  13 13 6  13 13 13 13 13 13 13 6  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6  6  13 13 6  13 6  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  13 13 13 13 13 13 13 13 4  5  4  5  13 13 13 13 6  6  13 13 13 13 13 13 13 4  5  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6  13 13 13 13 13 13 13 13 13 13 13 13 13 13 6  6  6  6  6  6  6  6  6  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6  6  6  6  6  6  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 22
      22 22 22 22 17 17 17 17 17 17 17 17 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 13 13 17 17 17 17 17 17 13 13 13 13 13 13 13 6  13 13 13 13 13 13 13 13 13 6  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6  6  6  6  6  6  6  6  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 6  13 13 13 13 13 13 13 13 4  5  4  5  4  5  4  5  4  5  4  5  4  5  17 17 17 17 17 17 17 17 17 17 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 6  6  6  6  6  4  5  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  4  5  4  5  4  5  4  5  4  5  6  6  6  4  5  4  5  4  5  4  5  4  5  4  5  4  5  4  5  4  5  4  5  4  5  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  4  5  4  5  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  6  4  5  6  6  6  6  6  6  6  13 13 6  6  6  6  6  6  13 13 13 13 13 13 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 22 13 13 13 13 13 13 13 13 22 22 22 22
      22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 9  12 9  9  9  12 12 9  12 9  12 9  12 9  9  9  9  12 9  12 12 9  12 12 12 12 12 12 20 20 9  9  9  12 9  12 12 13 13 13 13 13 13 9  12 9  12 21 21 21 9  12 22 22 22 22 22 2  2  2  2  17 2  2  12 12 12 12 12 12 22 12 22 22 22 22 22 12 22 22 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 20 2  22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 14 14 14 14 14 14 14 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 22 2  2  15 18 15 18 2  2  2  15 18 2  15 18 2  2  2  2  2  2  2  2  2  7  2  2  7  2  15 18 2  2  15 18 4  5  4  5  4  5  4  5  2  2  2  2  2  20 2  2  2  2  2  2  2  2  2  2  7  7  2  2  2  2  7  2  4  2  2  22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 22 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22
      13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 1  2  2  2  13 20 14 25 4  5  4  5  4  5  4  5  4  5  13 13 4  5  4  5  4  5  4  5  7  4  5  5  13 25 25 25 25 25 25 25 25 25 21 21 21 21 24 24 7  20 20 20 20 20 13 13 25 25 25 20 14 2  13 13 14 14 14 14 14 14 14 22 22 21 21 10 10 20 20 14 14 14 14 14 14 14 14 14 14 14 14 2  20 20 20 14 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 13 13 17 17 17 17 13 13 13 13 13 13 13 13 13 13 17 17 17 17 17 17 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 13 13 17 17 17 17 17 17 17 17 13 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 14 14 14 14 14 20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 20 2  2  2  8  8  8  8  8  8  8  8  8  8  14 14 22 22 22 22 9  12 9  12 9  12 9  12 9  12 9  12 9  12 14 21 23 23 23 2  21 21 21 21 21 21 21 21 21 21 2  20 9  12 9  12 9  12 9  12 9  12 9  12 20 20 21 21 14 14 14 14 14 14 25 25 25 25 25 25 25 25 25 25 21 21 2  2  2  2  2  2  22 22 22 22 22 22 22 22 10 10 10 10 10 10 10 20 20 20
      20 20 20 20 20 20 10 10 9  12 9  12 9  12 9  12 9  12 9  12 9  12 12 12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 20 12 12 12 12 12 12 12 12 9  12 9  12 9  9  12 9  12 9  12 9  12 9  12 20 10 10 9  12 9  12 14 9  12 9  12 12 12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  12 9  9  9  9  9  22 9  9  9  9  9  12 9  12 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 20 20 12 14 14 14 14 14 14 14 21 14 14 14 21 14 14 14 14 21 14 14 14 14 14 14 14 24 24 21 21 24 13 13 13 13 22 22 22 22 17 17 17 17 17 17 13 13 3  13 22 22 22 22 22 22 14 14 14 14 2  2  2  2  22 22 22 22 22 22 22 22 24 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 21 21 22 22 22 22 22 22 22 22 2  2  21 21 14 14 14 14 14 14 2  2  2  14 2  14 22 22 14 14 14 14 14 14 21 21 21 21 21 21 21 21 2  2  14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 24 24 22 22 22 22 22 22 22 22 22 22 22 2  14 14 14 21 24 24 21 21 21 21 24 24 21 24 24 24 24 2  2  2
      2  2  2  2  2  2  2  2  2  2  22 20 8  8  8  8  8  8  8  8  8  8  22 22 22 22 2  2  14 14 14 14 14 21 20 14 14 14 14 14 14 14 14 14 8  8  8  8  8  8  8  8  8  8  14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 24 24 21 21 24 24 21 21 22 22 22 22 22 22 22 22 22 14 14 14 21 14 14 14 14 14 14 14 14 21 24 22 22 8  8  8  8  8  8  8  8  8  8  22 22 2  2  2  2  20 14 14 14 14 14 14 13 13 13 14 24 21 24 14 14 21 14 21 21 21 14 14 21 21 14 14 14 14 14 21 21 14 21 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 20 2  2  14 14 14 14 14 14 14 14 14 14 14 24 21 21 24 24 2  2  14 20 20 24 21 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 22 22 22 22 22 22 22 12 12 12 12 12 12 12 12 12 12 12 10 20 20 20 20 12 12 12 12 12 12 22 22 22 22 22 22 22 22 22 22 14 14 14 24 24 21 24 24 21 24 24 2  24 21 22 22 14 14 14 14 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 22 22 22 22 14 14 14
      14 14 28 28 28 28 28 28 28 28 28 28 28 28 28 28 28 28 29 29 29 29 29 29 29 29 29 29 29 29 29 29 29 29 12 12 12 12 12 12 12 22 22 22 22 22 22 22 22 22 22 22 22 12 12 12 12 12 22 22 22 22 22 14 21 14 14 14 14 14 14 14 14 14 14 6  14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 22 14 22 14 14 22 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 5  4  22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 3  13 22 22 2  2  2  2  2  2  2  4  5  2  22 22 22 22 22 22 2  7  7  11 11 4  5  4  5  4  5  4  5  4  5  4  5  4  5  4  5  2  2  4  5  2  2  2  2  11 11 11 2  2  2  22 2  2  2  2  7  4  5  4  5  4  5  2  2  2  6  7  6  6  6  22 2  3  2  2  22 22 22 22 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 16 22 2  2  2  3  2  2  2
      4  5  2  6  2  7  2  2  12 12 12 12 12 12 12 12 12 12 12 4  6  5  6  4  5  2  4  5  2  2  14 14 14 14 14 14 14 14 14 14 20 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 20 20 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 14 14 14 14 14 14 22 22 14 14 14 22 22 22 3  3  6  10 13 3  3  22 13 6  6  6  6  13 13 22 22 22 22 22 22 22 22 22 22 16 16 16 13 13 22 22 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 14 2  2  2  22 22 22 22 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 13 13 13 13 13 13 13 13 13 25 25 25 25 25 17 17 17 17 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 17 17 13 13 13 22 13 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 21 22 22 21 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 22 17 17 17 17 22 22 22 22 22 22 22 22 22 22 22 22 14 25 14 14 14 14 14 14 14 14 25 22 22 22 22 22 14 14
      14 14 14 14 21 21 21 21 21 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 2  14 14 14 14 22 22 22 22 14 14 14 14 14 14 14 14 2  25 25 25 25 25 22 22 22 22 22 22 22 22 22 22 9  9  9  9  9  9  9  9  12 12 12 12 12 12 12 12 9  9  9  9  22 22 22 22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 22 22 22 14 14 14 14 22 22 22 22 22 22 22 22 22 22 22 2  14 14 14 14 14 14 22 22 14 22 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 22 22 14 22 22 14 14 14 14 14 14 14 22 2  17 17 17 17 17 17 17 17 14 14 14 14 14 14 14 13 13 17 17 17 17 17 17 17 22 22 22 22 22 22 22 17 17 17 17 17 17 17 17 17 14 14 14 22 14 14 22 22 22 22 22 17 17 17 17 17 14 14 14 14 14 14 17 17 17 17 17 17 22 22 22 2  14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 2  14 14 14 14 14 14 14 14 22 22 22 22 17 17 14 14 22 22 17 17 17 17 17 17 17 17 17 17 17 17 17 17 14 21 21 21 22 21 21 22 22 22 22 22 21 21 21 21 14 14 14 14 22 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 21 21 21 22
      22 22 22 21 17 17 17 17 17 17 17 17 22 22 22 22 22 22 22 22 2  2  2  2  2  2  2  2  2  22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 17 17 2  14 14 14 14 14 14 14 14 14 14 14 14 14 17 17 17 14 14 14 14 14 14 14 14 13 14 14 14 14 14 14 14 14 14 14 14 14 21 21 22 22 22 22 17 17 17 17 17 2  2  2  2  2  2  2  22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 22 22 22 2  2  2  2  2  2  2  14 14 14 14 14 14 22 22 17 17 17 17 17 17 17 17 14 14 14 22 22 22 22 22 17 17 17 17 17 17 17 17 14 14 22 22 22 22 22 22 22 2  2  2  2  22 22 22 22 22 22 22 22 22 22 22 22 17 17 17 17 17 17 17 14 14 14 14 14 14 14 14 14 22 22 22 22 22 22 22 9  9  9  22 22 22 22 22 22 22 22 22 22 22 22 22 12 12 12 22 22 22 22 22 22 22 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 24 21 24 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 2  2  2  2  2  2  2  22 22 17 17 17 17 17 17 8  8  8  8  8  8  8  8  8  8  22 22 22 22 22 22
      22 22 22 22 22 22 22 22 22 21 24 24 24 21 21 21 21 24 24 21 21 2  2  16 2  2  2  2  22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 21 21 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 21 21 21 21 24 21 21 21 21 21 21 21 21 22 8  8  8  8  8  8  8  8  8  8  2  2  2  2  22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 21 2  2  14 22 22 22 22 22 22 22 22 22 14 14 14 24 24 24 21 21 21 21 21 21 21 21 21 24 24 14 14 14 14 2  2  2  2  2  21 21 21 2  22 22 8  8  8  8  8  8  8  8  8  8  14 2  14 2  2  2  22 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 24 24 24 21 21 21 24 24 21 24 21 21 2  2  2  2  2  2  21 22 14 14 14 14 14 14 14 22 14 22 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 2  22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 21 24 24 24 21 21 21 21 21 21 21 21 22 22 22 22 22 21 21 24 24 22 14 14 14 14 14 14 14 14 22 22 14
      21 24 24 24 24 22 22 24 24 22 22 24 24 24 22 22 14 22 22 22 22 22 22 24 22 22 22 22 22 14 14 14 14 14 24 24 22 22 21 21 21 21 21 21 21 22 22 22 21 21 21 21 21 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 24 24 24 21 21 21 21 21 21 21 21 24 24 21 21 21 24 21 14 14 14 14 2  2  2  2  2  8  8  8  8  8  8  8  8  8  8  22 2  22 2  22 22 24 24 24 21 21 21 21 21 21 24 21 24 24 24 24 21 21 24 21 21 14 14 2  14 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 24 24 24 21 21 21 21 22 22 24 24 24 24 21 21 24 21 21 2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  2  14 14 14 14 21 21 22 22 24 24 24 21 21 21 21 21 21 21 21 24 24 21 24 21 21 2  2  2  14 22 22 22 22 22 22 22 22 22 22 22 2  2  2  2  2  2  2  2  2  2  2  2  2  22 22 22 14 14 14 14 14 14 14 14 14 14 14 21 24 21 24 24 21 21 21 21 21 21 24 21 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 22 22 22 21 21 21 24 24 21 21 21 21 24 21 21 21 21 21 22 22 22 22 8  8  8  8  8  8  8  8  8  8
      17 17 2  2  2  13 17 17 17 22 22 22 22 22 22 22 22 22 22 22 22 14 21 21 21 21 21 21 21 22 21 21 21 21 21 21 24 21 14 2  2  2  2  2  22 22 22 22 22 22 22 22 22 22 2  2  14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 22 24 21 21 21 21 21 21 21 24 21 21 24 21 21 22 22 22 22 22 22 22 22 22 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 22 2  2  2  2  2  22 22 22 22 22 22 22 22 22 22 22 21 21 21 21 21 2  22 22 22 22 22 22 22 22 22 22 21 21 21 21 21 21 21 2  2  2  2  2  13 13 13 13 20 20 20 20 2  13 22 22 22 22 22 22 22 22 22 22 8  8  8  8  8  8  8  8  8  8  22 17 17 17 17 17 17 17 22 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 22 22 22 22 22 14 14 14 14 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 24 22 21 21 21 20 20 20 20 20 20 20 20 20 20 20 20 20 20 22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 22
      22 22 22 22 22 22 22 22 22 22 22 22 14 14 22 22 22 22 22 22 22 22 22 22 22 22 22 22 14 14 14 14 14 14 14 14 14 14 22 22 13 21 21 2  16 16 16 16 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 24 24 21 21 21 13 13 13 24 24 24 24 24 24 16 16 16 16 16 16 16 16 21 21 21 21 21 21 21 21 13 13 21 21 21 21 21 21 21 13 13 13 13 13 13 13 13 13 13 13 13 13 13 21 21 21 21 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 13 13 21 21 21 13 22 22 22 22 22 22 22 22 22 22 17 17 22 22 22 22 22 22 22 22 22 22 22 22 22 22 9  9  9  9  9  9  9  9  9  9  12 12 12 12 12 12 12 12 12 12 9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  12 12 12 12 12 12 12 22 12 12 12 12 12 12 12 12 12 12 9  9  12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 9  22 9  9  22 22 9  22 22 9  9  22 22 9  9  9  9  22 9  9  9  9  9  9  9  9  12 12 12 12 22 12 22 12 12 12 12 12 12 12 22 12 12 12 12 12 12 12 12 12
      12 12 12 12 12 12 9  9  22 9  9  9  9  22 22 9  9  9  9  9  9  9  9  22 9  9  9  9  9  9  9  22 12 12 12 12 12 12 12 12 12 12 9  9  22 9  9  9  9  22 9  9  9  9  9  22 9  22 22 22 9  9  9  9  9  9  9  22 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 9  9  9  9  9  9  9  9  9  9  12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 22 22 9  9  9  9  9  9  9  9  9  6  12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 6  12 12 12 12 12 12 9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  6  12 12 12 12 12 12 12 12 12 6  12 12 12 12 12 12 9  9  9  9  9  9  9  9  9  6  12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 6  12 12 12 12 12 12 9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  9  6  12 12 12 12 12 12 12 12 12 6  12 12 12 12 12 12 9  9  9  9  9  9  9  9  9  6  12 12 12 12 12 12 12 12 12 6  12 12 12 12 12 12 9  12 22 22 8  8  8  8  8  8  8  8  8  8
      8  8  8  8  8  8  8  8  21 21 21 21 21 21 21 13 13 13 13 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 13 13 13 13 13 13 13 13 21 13 13 13 13 13 13 13 13 13 13 13 13 13 13 21 13 13 2  2  2  2  2  22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 21 21 21 21 21 21 21 21 21 21 21 21 22 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 21 22 22 21 21 21 21 21 21 21 22 21 21 22 21 21 21 21 21 22 22 22 22 22 14 14 14 14 14 22 22 17 17 17 17 17 17 17 17 17 21 21 21 21 21 21 21 22 22 22 22 22 22 22 22 22 12 12 12 12 21 21 21 21 21 21 21 22 22 22 22 22 14 14 14 14 22 14 14 14 14 14 14 14 14 14 14 14 22 14 14 22 14 22 22 14 22 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 22 14 22 14 22 22 22 22 22 22 14 22 22 22 22 14 22 14 22 14 22 14 14 14 22 14 14 22 14 22 22 14 22 14 22 14 22 14 22 14 22 14 14 22 14 22 22 14 14 14 14 22 14 14 14 14 14 14 14 22 14 14 14 14 22 14 14 14 14 22 14 22 14 14 14 14 14 14 14 14 14 14 22 14 14 14 14 14 22 14 14 14 22 14 14 14 14 14 22 14 14 14 14 14 6  6
      22 22 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 10 13 13 13 13 13 22 22 22 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 22 22 22 22 22 22 22 22 13 13 13 13 13 13 13 13 13 13 13 13 13 13 22 22 13 22 22 13 13 13 13 13 13 13 13 13 13 13 13 22 22 16 22 22 22 22 22 22 22 22 22 22 22 22 22 22 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 29 29 29 29 29 29 29 29 29 29 29 29 29 29 22 22)))

(define-deferred ucd-gc-table-5
  #(other:control separator:space punctuation:other symbol:currency punctuation:open punctuation:close symbol:math punctuation:dash number:decimal-digit letter:uppercase symbol:modifier punctuation:connector letter:lowercase symbol:other letter:other punctuation:initial-quote other:format number:other punctuation:final-quote letter:titlecase letter:modifier mark:nonspacing other:not-assigned mark:enclosing mark:spacing-combining number:letter separator:line separator:paragraph other:surrogate other:private-use))
