/**
 * Navit, a modular navigation system.
 * Copyright (C) 2005-2008 Navit Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#ifndef NAVIT_PROJECTION_H
#define NAVIT_PROJECTION_H

enum projection {
	projection_none,	/*!< No projection or unknown projection */
	projection_mg,		/*!< Mercator projection */
	projection_garmin,	/*!< Garmin projection */
	projection_screen,	/*!< Screen projection */
	projection_utm		/*!< UTM projection */
};

enum map_datum {
	map_datum_none, map_datum_wgs84, map_datum_dhdn
};

struct coord;
enum projection projection_from_name(const char *name, struct coord *offset);
char * projection_to_name(enum projection proj);

#endif

